﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeartifact/model/CreateRepositoryRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeArtifact::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String CreateRepositoryRequest::SerializePayload() const {
  JsonValue payload;

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_upstreamsHasBeenSet) {
    Aws::Utils::Array<JsonValue> upstreamsJsonList(m_upstreams.size());
    for (unsigned upstreamsIndex = 0; upstreamsIndex < upstreamsJsonList.GetLength(); ++upstreamsIndex) {
      upstreamsJsonList[upstreamsIndex].AsObject(m_upstreams[upstreamsIndex].Jsonize());
    }
    payload.WithArray("upstreams", std::move(upstreamsJsonList));
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

void CreateRepositoryRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_domainHasBeenSet) {
    ss << m_domain;
    uri.AddQueryStringParameter("domain", ss.str());
    ss.str("");
  }

  if (m_domainOwnerHasBeenSet) {
    ss << m_domainOwner;
    uri.AddQueryStringParameter("domain-owner", ss.str());
    ss.str("");
  }

  if (m_repositoryHasBeenSet) {
    ss << m_repository;
    uri.AddQueryStringParameter("repository", ss.str());
    ss.str("");
  }
}
