﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/GuardrailEvent.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BedrockAgentRuntime {
namespace Model {

GuardrailEvent::GuardrailEvent(JsonView jsonValue) { *this = jsonValue; }

GuardrailEvent& GuardrailEvent::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("action")) {
    m_action = GuadrailActionMapper::GetGuadrailActionForName(jsonValue.GetString("action"));
    m_actionHasBeenSet = true;
  }
  return *this;
}

JsonValue GuardrailEvent::Jsonize() const {
  JsonValue payload;

  if (m_actionHasBeenSet) {
    payload.WithString("action", GuadrailActionMapper::GetNameForGuadrailAction(m_action));
  }

  return payload;
}

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
