/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal.matchers;

import org.easymock.IArgumentMatcher;

public class Equals
implements IArgumentMatcher {
    private final Object expected;

    public Equals(Object expected) {
        this.expected = expected;
    }

    public boolean matches(Object actual) {
        if (this.expected == null) {
            return actual == null;
        }
        return this.expected.equals(actual);
    }

    public void appendTo(StringBuffer buffer) {
        this.appendQuoting(buffer);
        buffer.append(this.expected);
        this.appendQuoting(buffer);
    }

    private void appendQuoting(StringBuffer buffer) {
        if (this.expected instanceof String) {
            buffer.append("\"");
        } else if (this.expected instanceof Character) {
            buffer.append("'");
        }
    }

    protected final Object getExpected() {
        return this.expected;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Equals other = (Equals)o;
        return this.expected == null && other.expected == null || this.expected != null && this.expected.equals(other.expected);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not supported");
    }
}

