/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_th extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "เวลามาตรฐานกรีนิช",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "เวลามาตรฐานอาเกร",
               "",
               "เวลาฤดูร้อนอาเกร",
               "",
               "เวลาอาเกร",
               "",
            };
        final String[] Apia = new String[] {
               "เวลามาตรฐานอาปีอา",
               "",
               "เวลาออมแสงอาปีอา",
               "",
               "เวลาอาปีอา",
               "",
            };
        final String[] Cook = new String[] {
               "เวลามาตรฐานหมู่เกาะคุก",
               "",
               "เวลาครึ่งฤดูร้อนหมู่เกาะคุก",
               "",
               "เวลาหมู่เกาะคุก",
               "",
            };
        final String[] Cuba = new String[] {
               "เวลามาตรฐานคิวบา",
               "CST",
               "เวลาออมแสงของคิวบา",
               "CDT",
               "เวลาคิวบา",
               "CT",
            };
        final String[] Fiji = new String[] {
               "เวลามาตรฐานฟิจิ",
               "",
               "เวลาฤดูร้อนฟิจิ",
               "",
               "เวลาฟิจิ",
               "",
            };
        final String[] Gulf = new String[] {
               "เวลากัลฟ์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "เวลามาตรฐานฮอฟด์",
               "",
               "เวลาฤดูร้อนฮอฟด์",
               "",
               "เวลาฮอฟด์",
               "",
            };
        final String[] Iran = new String[] {
               "เวลามาตรฐานอิหร่าน",
               "",
               "เวลาออมแสงอิหร่าน",
               "",
               "เวลาอิหร่าน",
               "",
            };
        final String[] Niue = new String[] {
               "เวลานีอูเอ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "เวลามาตรฐานออมสค์",
               "",
               "เวลาฤดูร้อนออมสค์",
               "",
               "เวลาออมสค์",
               "",
            };
        final String[] Peru = new String[] {
               "เวลามาตรฐานเปรู",
               "",
               "เวลาฤดูร้อนเปรู",
               "",
               "เวลาเปรู",
               "",
            };
        final String[] Truk = new String[] {
               "เวลาชุก",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "เวลาเกาะเวก",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "เวลามาตรฐานชิลี",
               "",
               "เวลาฤดูร้อนชิลี",
               "",
               "เวลาชิลี",
               "",
            };
        final String[] China = new String[] {
               "เวลามาตรฐานจีน",
               "CST",
               "เวลาออมแสงจีน",
               "CDT",
               "เวลาจีน",
               "CT",
            };
        final String[] Cocos = new String[] {
               "เวลาหมู่เกาะโคโคส",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "เวลาเดวิส",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "เวลาอินเดีย",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "เวลามาตรฐานญี่ปุ่น",
               "JST",
               "เวลาออมแสงญี่ปุ่น",
               "JDT",
               "เวลาญี่ปุ่น",
               "JT",
            };
        final String[] Korea = new String[] {
               "เวลามาตรฐานเกาหลี",
               "KST",
               "เวลาออมแสงเกาหลี",
               "KST",
               "เวลาเกาหลี",
               "KST",
            };
        final String[] Nauru = new String[] {
               "เวลานาอูรู",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "เวลาเนปาล",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "เวลาปาเลา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "เวลามาตรฐานซามัว",
               "SST",
               "เวลาฤดูร้อนซามัว",
               "SST",
               "เวลาซามัว",
               "SST",
            };
        final String[] Syowa = new String[] {
               "เวลาไซโยวา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "เวลามาตรฐานตองกา",
               "",
               "เวลาฤดูร้อนตองกา",
               "",
               "เวลาตองกา",
               "",
            };
        final String[] Yukon = new String[] {
               "เวลายูคอน",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "เวลามาตรฐานอะแลสกา",
               "AKST",
               "เวลาออมแสงของอะแลสกา",
               "AKDT",
               "เวลาอะแลสกา",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "เวลามาตรฐานแอมะซอน",
               "",
               "เวลาฤดูร้อนแอมะซอน",
               "",
               "เวลาแอมะซอน",
               "",
            };
        final String[] Azores = new String[] {
               "เวลามาตรฐานอะโซร์ส",
               "",
               "เวลาฤดูร้อนอะโซร์ส",
               "",
               "เวลาอะโซร์ส",
               "",
            };
        final String[] Bhutan = new String[] {
               "เวลาภูฏาน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "เวลาบรูไนดารุสซาลาม",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "เวลามาตรฐานเกาะอีสเตอร์",
               "",
               "เวลาฤดูร้อนเกาะอีสเตอร์",
               "",
               "เวลาเกาะอีสเตอร์",
               "",
            };
        final String[] Guyana = new String[] {
               "เวลากายอานา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "เวลามาตรฐานฮาวาย-อะลูเชียน",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "เวลามาตรฐานอิสราเอล",
               "IST",
               "เวลาออมแสงอิสราเอล",
               "IDT",
               "เวลาอิสราเอล",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "เวลาคอสไร",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "เวลามอว์สัน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "เวลามาตรฐานมอสโก",
               "MSK",
               "เวลาฤดูร้อนมอสโก",
               "MSK",
               "เวลามอสโก",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "เวลาโปนาเป",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "เวลามาตรฐานซามารา",
               "",
               "เวลาฤดูร้อนซามารา",
               "",
               "เวลาซามารา",
               "",
            };
        final String[] Tahiti = new String[] {
               "เวลาตาฮีตี",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "เวลามาตรฐานไทเป",
               "CST",
               "เวลาออมแสงไทเป",
               "CDT",
               "เวลาไทเป",
               "CT",
            };
        final String[] Turkey = new String[] {
               "เวลามาตรฐานตุรกี",
               "",
               "เวลาฤดูร้อนตุรกี",
               "",
               "เวลาตุรกี",
               "",
            };
        final String[] Tuvalu = new String[] {
               "เวลาตูวาลู",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "เวลาวอสตอค",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "เวลาวาลลิสและฟุตูนา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "เวลามาตรฐานอาหรับ",
               "",
               "เวลาออมแสงอาหรับ",
               "",
               "เวลาอาหรับ",
               "",
            };
        final String[] Armenia = new String[] {
               "เวลามาตรฐานอาร์เมเนีย",
               "",
               "เวลาฤดูร้อนอาร์เมเนีย",
               "",
               "เวลาอาร์เมเนีย",
               "",
            };
        final String[] Bolivia = new String[] {
               "เวลาโบลิเวีย",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "เวลามาตรฐานแชทัม",
               "",
               "เวลาออมแสงแชทัม",
               "",
               "เวลาแชทัม",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "เวลาสากลเชิงพิกัด",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "เวลาเอกวาดอร์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "เวลาแกมเบียร์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "เวลามาตรฐานจอร์เจีย",
               "",
               "เวลาฤดูร้อนจอร์เจีย",
               "",
               "เวลาจอร์เจีย",
               "",
            };
        final String[] Irkutsk = new String[] {
               "เวลามาตรฐานอีร์คุตสค์",
               "",
               "เวลาฤดูร้อนอีร์คุตสค์",
               "",
               "เวลาอีร์คุตสค์",
               "",
            };
        final String[] Magadan = new String[] {
               "เวลามาตรฐานมากาดาน",
               "",
               "เวลาฤดูร้อนมากาดาน",
               "",
               "เวลามากาดาน",
               "",
            };
        final String[] Myanmar = new String[] {
               "เวลาพม่า",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "เวลามาตรฐานเกาะนอร์ฟอล์ก",
               "",
               "เวลาออมแสงเกาะนอร์ฟอล์ก",
               "",
               "เวลาเกาะนอร์ฟอล์ก",
               "",
            };
        final String[] Noronha = new String[] {
               "เวลามาตรฐานหมู่เกาะเฟอร์นันโด",
               "",
               "เวลาฤดูร้อนของหมู่เกาะเฟอร์นันโด",
               "",
               "เวลาหมู่เกาะเฟอร์นันโด",
               "",
            };
        final String[] Reunion = new String[] {
               "เวลาเรอูนียง",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "เวลาโรธีรา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "เวลาหมู่เกาะโซโลมอน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "เวลาโตเกเลา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "เวลามาตรฐานอุรุกวัย",
               "",
               "เวลาฤดูร้อนอุรุกวัย",
               "",
               "เวลาอุรุกวัย",
               "",
            };
        final String[] Vanuatu = new String[] {
               "เวลามาตรฐานวานูอาตู",
               "",
               "เวลาฤดูร้อนวานูอาตู",
               "",
               "เวลาวานูอาตู",
               "",
            };
        final String[] Yakutsk = new String[] {
               "เวลามาตรฐานยาคุตสค์",
               "",
               "เวลาฤดูร้อนยาคุตสค์",
               "",
               "เวลายาคุตสค์",
               "",
            };
        final String[] Atlantic = new String[] {
               "เวลามาตรฐานแอตแลนติก",
               "AST",
               "เวลาออมแสงของแอตแลนติก",
               "AST",
               "เวลาแอตแลนติก",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "เวลามาตรฐานบราซิเลีย",
               "",
               "เวลาฤดูร้อนบราซิเลีย",
               "",
               "เวลาบราซิเลีย",
               "",
            };
        final String[] Chamorro = new String[] {
               "เวลาชามอร์โร",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "เวลามาตรฐานโคลอมเบีย",
               "",
               "เวลาฤดูร้อนโคลอมเบีย",
               "",
               "เวลาโคลอมเบีย",
               "",
            };
        final String[] Falkland = new String[] {
               "เวลามาตรฐานหมู่เกาะฟอล์กแลนด์",
               "",
               "เวลาฤดูร้อนหมู่เกาะฟอล์กแลนด์",
               "",
               "เวลาหมู่เกาะฟอล์กแลนด์",
               "",
            };
        final String[] Malaysia = new String[] {
               "เวลามาเลเซีย",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "เวลามัลดีฟส์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "เวลามาตรฐานอูลานบาตอร์",
               "",
               "เวลาฤดูร้อนอูลานบาตอร์",
               "",
               "เวลาอูลานบาตอร์",
               "",
            };
        final String[] Pakistan = new String[] {
               "เวลามาตรฐานปากีสถาน",
               "PKT",
               "เวลาฤดูร้อนปากีสถาน",
               "PKST",
               "เวลาปากีสถาน",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "เวลามาตรฐานปารากวัย",
               "",
               "เวลาฤดูร้อนปารากวัย",
               "",
               "เวลาปารากวัย",
               "",
            };
        final String[] Pitcairn = new String[] {
               "เวลาพิตแคร์น",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "เวลาซูรินาเม",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "เวลามาตรฐานอาร์เจนตินา",
               "",
               "เวลาฤดูร้อนอาร์เจนตินา",
               "",
               "เวลาอาร์เจนตินา",
               "",
            };
        final String[] Christmas = new String[] {
               "เวลาเกาะคริสต์มาส",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "เวลากาลาปาโกส",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "เวลามาตรฐานฮ่องกง",
               "HKT",
               "เวลาฤดูร้อนฮ่องกง",
               "HKST",
               "เวลาฮ่องกง",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "เวลาอินโดจีน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "เวลาเปโตรปัฟลอฟสค์-คัมชัตสกี",
               "",
               "เวลาฤดูร้อนเปโตรปัฟลอฟสค์-คัมชัตสกี",
               "",
               "เวลาคัมชัตคา",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "เวลาคีร์กีซสถาน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "เวลามาตรฐานลอร์ดโฮว์",
               "",
               "เวลาออมแสงลอร์ดโฮว์",
               "",
               "เวลาลอร์ดโฮว์",
               "",
            };
        final String[] Marquesas = new String[] {
               "เวลามาร์เคซัส",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "เวลามาตรฐานมอริเชียส",
               "",
               "เวลาฤดูร้อนของมอริเชียส",
               "",
               "เวลามอริเชียส",
               "",
            };
        final String[] Singapore = new String[] {
               "เวลาสิงคโปร์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "เวลาเวเนซุเอลา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "เวลามาตรฐานอาเซอร์ไบจาน",
               "",
               "เวลาฤดูร้อนอาเซอร์ไบจาน",
               "",
               "เวลาอาเซอร์ไบจาน",
               "",
            };
        final String[] Bangladesh = new String[] {
               "เวลามาตรฐานบังกลาเทศ",
               "",
               "เวลาฤดูร้อนบังกลาเทศ",
               "",
               "เวลาบังกลาเทศ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "เวลามาตรฐานเคปเวิร์ด",
               "",
               "เวลาฤดูร้อนเคปเวิร์ด",
               "",
               "เวลาเคปเวิร์ด",
               "",
            };
        final String[] East_Timor = new String[] {
               "เวลาติมอร์ตะวันออก",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "เวลาคาซัคสถาน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "เวลาเซเชลส์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "เวลาทาจิกิสถาน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "เวลามาตรฐานอุซเบกิสถาน",
               "",
               "เวลาฤดูร้อนอุซเบกิสถาน",
               "",
               "เวลาอุซเบกิสถาน",
               "",
            };
        final String[] Afghanistan = new String[] {
               "เวลาอัฟกานิสถาน",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "เวลามาตรฐานครัสโนยาสค์",
               "",
               "เวลาฤดูร้อนครัสโนยาสค์",
               "",
               "เวลาครัสโนยาสค์",
               "",
            };
        final String[] New_Zealand = new String[] {
               "เวลามาตรฐานนิวซีแลนด์",
               "NZST",
               "เวลาออมแสงนิวซีแลนด์",
               "NZDT",
               "เวลานิวซีแลนด์",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "เวลามาตรฐานฟิลิปปินส์",
               "PST",
               "เวลาฤดูร้อนฟิลิปปินส์",
               "PDT",
               "เวลาฟิลิปปินส์",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "เวลามาตรฐานวลาดีวอสตอค",
               "",
               "เวลาฤดูร้อนวลาดีวอสตอค",
               "",
               "เวลาวลาดีวอสตอค",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "เวลามหาสมุทรอินเดีย",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "เวลาหมู่เกาะไลน์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "เวลามาตรฐานนิวฟันด์แลนด์",
               "NST",
               "เวลาออมแสงนิวฟันด์แลนด์",
               "NDT",
               "เวลานิวฟันด์แลนด์",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "เวลามาตรฐานเติร์กเมนิสถาน",
               "",
               "เวลาฤดูร้อนเติร์กเมนิสถาน",
               "",
               "เวลาเติร์กเมนิสถาน",
               "",
            };
        final String[] French_Guiana = new String[] {
               "เวลาเฟรนช์เกียนา",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "เวลามาตรฐานนิวแคลิโดเนีย",
               "",
               "เวลาฤดูร้อนนิวแคลิโดเนีย",
               "",
               "เวลานิวแคลิโดเนีย",
               "",
            };
        final String[] South_Georgia = new String[] {
               "เวลาเซาท์จอร์เจีย",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "เวลามาตรฐานเยคาเตรินบูร์ก",
               "",
               "เวลาฤดูร้อนเยคาเตรินบูร์ก",
               "",
               "เวลาเยคาเตรินบูร์ก",
               "",
            };
        final String[] Africa_Central = new String[] {
               "เวลาแอฟริกากลาง",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "เวลาแอฟริกาตะวันออก",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "เวลาแอฟริกาตะวันตก",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "เวลาดูมองต์ดูร์วิลล์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "เวลามาตรฐานยุโรปกลาง",
               "CET",
               "เวลาฤดูร้อนยุโรปกลาง",
               "CEST",
               "เวลายุโรปกลาง",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "เวลามาตรฐานยุโรปตะวันออก",
               "EET",
               "เวลาฤดูร้อนยุโรปตะวันออก",
               "EEST",
               "เวลายุโรปตะวันออก",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "เวลามาตรฐานยุโรปตะวันตก",
               "WET",
               "เวลาฤดูร้อนยุโรปตะวันตก",
               "WEST",
               "เวลายุโรปตะวันตก",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "เวลามาตรฐานแปซิฟิกเม็กซิโก",
               "MST",
               "เวลาออมแสงแปซิฟิกเม็กซิโก",
               "MDT",
               "เวลาแปซิฟิกเม็กซิโก",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "เวลาแอฟริกาใต้",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "เวลามาตรฐานตอนกลางในอเมริกาเหนือ",
               "CST",
               "เวลาออมแสงตอนกลางในอเมริกาเหนือ",
               "CDT",
               "เวลาตอนกลางในอเมริกาเหนือ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "เวลามาตรฐานทางตะวันออกในอเมริกาเหนือ",
               "EST",
               "เวลาออมแสงทางตะวันออกในอเมริกาเหนือ",
               "EST",
               "เวลาทางตะวันออกในอเมริกาเหนือ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "เวลามาตรฐานแปซิฟิกในอเมริกาเหนือ",
               "PST",
               "เวลาออมแสงแปซิฟิกในอเมริกาเหนือ",
               "PDT",
               "เวลาแปซิฟิกในอเมริกาเหนือ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "เวลาเฟรนช์เซาเทิร์นและแอนตาร์กติก",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "เวลาหมู่เกาะกิลเบิร์ต",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "เวลามาตรฐานฮาวาย-อะลูเชียน",
               "HST",
               "เวลาออมแสงฮาวาย-อะลูเชียน",
               "HDT",
               "เวลาฮาวาย-อะลูเชียน",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "เวลาหมู่เกาะฟินิกซ์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "เวลามาตรฐานแซงปีแยร์และมีเกอลง",
               "",
               "เวลาออมแสงของแซงปีแยร์และมีเกอลง",
               "",
               "เวลาแซงปีแยร์และมีเกอลง",
               "",
            };
        final String[] America_Mountain = new String[] {
               "เวลามาตรฐานแถบภูเขาในอเมริกาเหนือ",
               "MST",
               "เวลาออมแสงแถบภูเขาในอเมริกาเหนือ",
               "MST",
               "เวลาแถบภูเขาในอเมริกาเหนือ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "เวลาหมู่เกาะมาร์แชลล์",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "เวลาปาปัวนิวกินี",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "เวลามาตรฐานทางตอนกลางของออสเตรเลีย",
               "ACST",
               "เวลาออมแสงทางตอนกลางของออสเตรเลีย",
               "ACDT",
               "เวลาออสเตรเลียกลาง",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "เวลามาตรฐานทางตะวันออกของออสเตรเลีย",
               "AEST",
               "เวลาออมแสงทางตะวันออกของออสเตรเลีย",
               "AEDT",
               "เวลาออสเตรเลียตะวันออก",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "เวลามาตรฐานทางตะวันตกของออสเตรเลีย",
               "AWST",
               "เวลาออมแสงทางตะวันตกของออสเตรเลีย",
               "AWDT",
               "เวลาออสเตรเลียตะวันตก",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "เวลาอินโดนีเซียตอนกลาง",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "เวลาอินโดนีเซียฝั่งตะวันออก",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "เวลาอินโดนีเซียฝั่งตะวันตก",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "เวลามาตรฐานทางตะวันตกตอนกลางของออสเตรเลีย",
               "",
               "เวลาออมแสงทางตะวันตกตอนกลางของออสเตรเลีย",
               "",
               "เวลาทางตะวันตกตอนกลางของออสเตรเลีย",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลามาตรฐานไอร์แลนด์",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "เวลาสากลเชิงพิกัด",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลามาตรฐานไอร์แลนด์",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "เวลามาตรฐานกรีนิช",
                    "GMT",
                    "เวลาฤดูร้อนอังกฤษ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "เอเดน" },
            { "timezone.excity.Asia/Baku", "บากู" },
            { "timezone.excity.Asia/Dili", "ดิลี" },
            { "timezone.excity.Asia/Gaza", "กาซา" },
            { "timezone.excity.Asia/Hovd", "ฮอฟด์" },
            { "timezone.excity.Asia/Omsk", "โอมสก์" },
            { "timezone.excity.Asia/Oral", "ออรัล" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "อัมมาน" },
            { "timezone.excity.Asia/Aqtau", "อัคตาอู" },
            { "timezone.excity.Asia/Chita", "ชิตา" },
            { "timezone.excity.Asia/Dhaka", "ดากา" },
            { "timezone.excity.Asia/Dubai", "ดูไบ" },
            { "timezone.excity.Asia/Kabul", "คาบูล" },
            { "timezone.excity.Asia/Macau", "มาเก๊า" },
            { "timezone.excity.Asia/Qatar", "กาตาร์" },
            { "timezone.excity.Asia/Seoul", "โซล" },
            { "timezone.excity.Asia/Tokyo", "โตเกียว" },
            { "timezone.excity.Asia/Tomsk", "ตอมสค์" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "จูบา" },
            { "timezone.excity.Africa/Lome", "โลเม" },
            { "timezone.excity.Asia/Almaty", "อัลมาตี" },
            { "timezone.excity.Asia/Anadyr", "อานาดีร์" },
            { "timezone.excity.Asia/Aqtobe", "อัคโทบี" },
            { "timezone.excity.Asia/Atyrau", "อทีราว" },
            { "timezone.excity.Asia/Beirut", "เบรุต" },
            { "timezone.excity.Asia/Brunei", "บรูไน" },
            { "timezone.excity.Asia/Hebron", "เฮบรอน" },
            { "timezone.excity.Asia/Kuwait", "คูเวต" },
            { "timezone.excity.Asia/Manila", "มะนิลา" },
            { "timezone.excity.Asia/Muscat", "มัสกัต" },
            { "timezone.excity.Asia/Riyadh", "ริยาร์ด" },
            { "timezone.excity.Asia/Saigon", "นครโฮจิมินห์" },
            { "timezone.excity.Asia/Taipei", "ไทเป" },
            { "timezone.excity.Asia/Tehran", "เตหะราน" },
            { "timezone.excity.Asia/Urumqi", "อุรุมชี" },
            { "timezone.excity.Etc/Unknown", "ไม่ทราบชื่อเมือง" },
            { "timezone.excity.Europe/Kiev", "เคียฟ" },
            { "timezone.excity.Europe/Oslo", "ออสโล" },
            { "timezone.excity.Europe/Riga", "ริกา" },
            { "timezone.excity.Europe/Rome", "โรม" },
            { "timezone.excity.Indian/Mahe", "มาเอ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "อักกรา" },
            { "timezone.excity.Africa/Cairo", "ไคโร" },
            { "timezone.excity.Africa/Ceuta", "เซวตา" },
            { "timezone.excity.Africa/Dakar", "ดาการ์" },
            { "timezone.excity.Africa/Lagos", "ลากอส" },
            { "timezone.excity.Africa/Tunis", "ตูนิส" },
            { "timezone.excity.America/Adak", "เอดัก" },
            { "timezone.excity.America/Lima", "ลิมา" },
            { "timezone.excity.America/Nome", "นอม" },
            { "timezone.excity.Asia/Baghdad", "แบกแดด" },
            { "timezone.excity.Asia/Bahrain", "บาห์เรน" },
            { "timezone.excity.Asia/Bangkok", "กรุงเทพ" },
            { "timezone.excity.Asia/Barnaul", "บาร์เนาว์" },
            { "timezone.excity.Asia/Bishkek", "บิชเคก" },
            { "timezone.excity.Asia/Colombo", "โคลัมโบ" },
            { "timezone.excity.Asia/Irkutsk", "อีร์คุตสค์" },
            { "timezone.excity.Asia/Jakarta", "จาการ์ตา" },
            { "timezone.excity.Asia/Karachi", "การาจี" },
            { "timezone.excity.Asia/Kuching", "กูชิง" },
            { "timezone.excity.Asia/Magadan", "มากาดาน" },
            { "timezone.excity.Asia/Nicosia", "นิโคเซีย" },
            { "timezone.excity.Asia/Rangoon", "ย่างกุ้ง" },
            { "timezone.excity.Asia/Tbilisi", "ทบิลิซิ" },
            { "timezone.excity.Asia/Thimphu", "ทิมพู" },
            { "timezone.excity.Asia/Yakutsk", "ยาคุตสค์" },
            { "timezone.excity.Asia/Yerevan", "เยเรวาน" },
            { "timezone.excity.Europe/Kirov", "คิรอฟ" },
            { "timezone.excity.Europe/Malta", "มอลตา" },
            { "timezone.excity.Europe/Minsk", "มินสก์" },
            { "timezone.excity.Europe/Paris", "ปารีส" },
            { "timezone.excity.Europe/Sofia", "โซเฟีย" },
            { "timezone.excity.Europe/Vaduz", "วาดุซ" },
            { "timezone.excity.Indian/Cocos", "โคโคส" },
            { "timezone.excity.Pacific/Apia", "อาปีอา" },
            { "timezone.excity.Pacific/Fiji", "ฟิจิ" },
            { "timezone.excity.Pacific/Guam", "กวม" },
            { "timezone.excity.Pacific/Niue", "นีอูเอ" },
            { "timezone.excity.Pacific/Truk", "ทรัก" },
            { "timezone.excity.Pacific/Wake", "เวก" },
            { "timezone.excity.Africa/Asmera", "แอสมารา" },
            { "timezone.excity.Africa/Bamako", "บามาโก" },
            { "timezone.excity.Africa/Bangui", "บังกี" },
            { "timezone.excity.Africa/Banjul", "บันจูล" },
            { "timezone.excity.Africa/Bissau", "บิสเซา" },
            { "timezone.excity.Africa/Douala", "ดูอาลา" },
            { "timezone.excity.Africa/Harare", "ฮาราเร" },
            { "timezone.excity.Africa/Kigali", "คิกาลี" },
            { "timezone.excity.Africa/Luanda", "ลูอันดา" },
            { "timezone.excity.Africa/Lusaka", "ลูซากา" },
            { "timezone.excity.Africa/Malabo", "มาลาโบ" },
            { "timezone.excity.Africa/Maputo", "มาปูโต" },
            { "timezone.excity.Africa/Maseru", "มาเซรู" },
            { "timezone.excity.Africa/Niamey", "นีอาเมย์" },
            { "timezone.excity.America/Aruba", "อารูบา" },
            { "timezone.excity.America/Bahia", "บาเยีย" },
            { "timezone.excity.America/Belem", "เบเลง" },
            { "timezone.excity.America/Boise", "บอยซี" },
            { "timezone.excity.America/Jujuy", "จูจิว" },
            { "timezone.excity.America/Sitka", "ซิตกา" },
            { "timezone.excity.America/Thule", "ทูเล" },
            { "timezone.excity.Asia/Ashgabat", "อาชกาบัต" },
            { "timezone.excity.Asia/Calcutta", "โกลกาตา" },
            { "timezone.excity.Asia/Damascus", "ดามัสกัส" },
            { "timezone.excity.Asia/Dushanbe", "ดูชานเบ" },
            { "timezone.excity.Asia/Jayapura", "จายาปุระ" },
            { "timezone.excity.Asia/Katmandu", "กาตมันดุ" },
            { "timezone.excity.Asia/Khandyga", "ฮันดืยกา" },
            { "timezone.excity.Asia/Makassar", "มากัสซาร์" },
            { "timezone.excity.Asia/Qostanay", "คอสตาเนย์" },
            { "timezone.excity.Asia/Sakhalin", "ซาคาลิน" },
            { "timezone.excity.Asia/Shanghai", "เซี่ยงไฮ้" },
            { "timezone.excity.Asia/Tashkent", "ทาชเคนต์" },
            { "timezone.excity.Asia/Ust-Nera", "อุสต์เนรา" },
            { "timezone.excity.Europe/Athens", "เอเธนส์" },
            { "timezone.excity.Europe/Berlin", "เบอร์ลิน" },
            { "timezone.excity.Europe/Dublin", "ดับบลิน" },
            { "timezone.excity.Europe/Jersey", "เจอร์ซีย์" },
            { "timezone.excity.Europe/Lisbon", "ลิสบอน" },
            { "timezone.excity.Europe/London", "ลอนดอน" },
            { "timezone.excity.Europe/Madrid", "มาดริด" },
            { "timezone.excity.Europe/Monaco", "โมนาโก" },
            { "timezone.excity.Europe/Moscow", "มอสโก" },
            { "timezone.excity.Europe/Prague", "ปราก" },
            { "timezone.excity.Europe/Samara", "ซามารา" },
            { "timezone.excity.Europe/Skopje", "สโกเปีย" },
            { "timezone.excity.Europe/Tirane", "ติรานา" },
            { "timezone.excity.Europe/Vienna", "เวียนนา" },
            { "timezone.excity.Europe/Warsaw", "วอร์ซอ" },
            { "timezone.excity.Europe/Zagreb", "ซาเกร็บ" },
            { "timezone.excity.Europe/Zurich", "ซูริค" },
            { "timezone.excity.Indian/Chagos", "ชากัส" },
            { "timezone.excity.Indian/Comoro", "โคโมโร" },
            { "timezone.excity.Pacific/Efate", "เอฟาเต" },
            { "timezone.excity.Pacific/Nauru", "นาอูรู" },
            { "timezone.excity.Pacific/Palau", "ปาเลา" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "อาบีจาน" },
            { "timezone.excity.Africa/Algiers", "แอลเจียร์" },
            { "timezone.excity.Africa/Conakry", "โกนากรี" },
            { "timezone.excity.Africa/Kampala", "คัมพาลา" },
            { "timezone.excity.Africa/Mbabane", "อัมบาบาเน" },
            { "timezone.excity.Africa/Nairobi", "ไนโรเบีย" },
            { "timezone.excity.Africa/Tripoli", "ตรีโปลี" },
            { "timezone.excity.America/Belize", "เบลีซ" },
            { "timezone.excity.America/Bogota", "โบโกตา" },
            { "timezone.excity.America/Cancun", "แคนคุน" },
            { "timezone.excity.America/Cayman", "เคย์แมน" },
            { "timezone.excity.America/Cuiaba", "กุยาบา" },
            { "timezone.excity.America/Dawson", "ดอว์สัน" },
            { "timezone.excity.America/Denver", "เดนเวอร์" },
            { "timezone.excity.America/Guyana", "กายอานา" },
            { "timezone.excity.America/Havana", "ฮาวานา" },
            { "timezone.excity.America/Inuvik", "อินูวิก" },
            { "timezone.excity.America/Juneau", "จูโน" },
            { "timezone.excity.America/La_Paz", "ลาปาซ" },
            { "timezone.excity.America/Maceio", "มาเซโอ" },
            { "timezone.excity.America/Manaus", "มาเนาส์" },
            { "timezone.excity.America/Merida", "เมรีดา" },
            { "timezone.excity.America/Nassau", "แนสซอ" },
            { "timezone.excity.America/Panama", "ปานามา" },
            { "timezone.excity.America/Recife", "เรซีเฟ" },
            { "timezone.excity.America/Regina", "ริไจนา" },
            { "timezone.excity.Asia/Famagusta", "แฟมากุสตา" },
            { "timezone.excity.Asia/Hong_Kong", "ฮ่องกง" },
            { "timezone.excity.Asia/Jerusalem", "เยรูซาเลม" },
            { "timezone.excity.Asia/Kamchatka", "คามชัตกา" },
            { "timezone.excity.Asia/Pontianak", "พอนเทียนัก" },
            { "timezone.excity.Asia/Pyongyang", "เปียงยาง" },
            { "timezone.excity.Asia/Qyzylorda", "ไคซีลอร์ดา" },
            { "timezone.excity.Asia/Samarkand", "ซามาร์กานด์" },
            { "timezone.excity.Asia/Singapore", "สิงคโปร์" },
            { "timezone.excity.Asia/Vientiane", "เวียงจันทน์" },
            { "timezone.excity.Europe/Andorra", "อันดอร์รา" },
            { "timezone.excity.Europe/Saratov", "ซาราทอฟ" },
            { "timezone.excity.Europe/Tallinn", "ทาลลินน์" },
            { "timezone.excity.Europe/Vatican", "วาติกัน" },
            { "timezone.excity.Europe/Vilnius", "วิลนีอุส" },
            { "timezone.excity.Indian/Mayotte", "มาโยเต" },
            { "timezone.excity.Indian/Reunion", "เรอูนียง" },
            { "timezone.excity.Pacific/Easter", "อีสเตอร์" },
            { "timezone.excity.Pacific/Kosrae", "คอสไร" },
            { "timezone.excity.Pacific/Majuro", "มาจูโร" },
            { "timezone.excity.Pacific/Midway", "มิดเวย์" },
            { "timezone.excity.Pacific/Noumea", "นูเมอา" },
            { "timezone.excity.Pacific/Ponape", "โปนาเป" },
            { "timezone.excity.Pacific/Saipan", "ไซปัน" },
            { "timezone.excity.Pacific/Tahiti", "ตาฮีตี" },
            { "timezone.excity.Pacific/Tarawa", "ตาระวา" },
            { "timezone.excity.Pacific/Wallis", "วาลลิส" },
            { "timezone.excity.Africa/Blantyre", "แบลนไทร์" },
            { "timezone.excity.Africa/Djibouti", "จิบูตี" },
            { "timezone.excity.Africa/El_Aaiun", "เอลไอย์อุง" },
            { "timezone.excity.Africa/Freetown", "ฟรีทาวน์" },
            { "timezone.excity.Africa/Gaborone", "กาโบโรเน" },
            { "timezone.excity.Africa/Khartoum", "คาร์ทูม" },
            { "timezone.excity.Africa/Kinshasa", "กินชาซา" },
            { "timezone.excity.Africa/Monrovia", "มันโรเวีย" },
            { "timezone.excity.Africa/Ndjamena", "เอ็นจาเมนา" },
            { "timezone.excity.Africa/Sao_Tome", "เซาตูเม" },
            { "timezone.excity.Africa/Windhoek", "วินด์ฮุก" },
            { "timezone.excity.America/Antigua", "แอนติกา" },
            { "timezone.excity.America/Caracas", "คาราคัส" },
            { "timezone.excity.America/Cayenne", "กาแยน" },
            { "timezone.excity.America/Chicago", "ชิคาโก" },
            { "timezone.excity.America/Cordoba", "คอร์โดบา" },
            { "timezone.excity.America/Creston", "เครสตัน" },
            { "timezone.excity.America/Curacao", "คูราเซา" },
            { "timezone.excity.America/Detroit", "ดีทรอยต์" },
            { "timezone.excity.America/Godthab", "กอดแธบ" },
            { "timezone.excity.America/Grenada", "เกรนาดา" },
            { "timezone.excity.America/Halifax", "แฮลิแฟกซ์" },
            { "timezone.excity.America/Iqaluit", "อีกวาลิต" },
            { "timezone.excity.America/Jamaica", "จาเมกา" },
            { "timezone.excity.America/Managua", "มานากัว" },
            { "timezone.excity.America/Marigot", "มาริโกต์" },
            { "timezone.excity.America/Mendoza", "เมนดูซา" },
            { "timezone.excity.America/Moncton", "มองตัน" },
            { "timezone.excity.America/Noronha", "โนรอนฮา" },
            { "timezone.excity.America/Ojinaga", "โอจินากา" },
            { "timezone.excity.America/Phoenix", "ฟินิกซ์" },
            { "timezone.excity.America/Tijuana", "ทิฮัวนา" },
            { "timezone.excity.America/Toronto", "โทรอนโต" },
            { "timezone.excity.America/Tortola", "ตอร์โตลา" },
            { "timezone.excity.America/Yakutat", "ยากูทัต" },
            { "timezone.excity.Asia/Phnom_Penh", "พนมเปญ" },
            { "timezone.excity.Atlantic/Azores", "อะโซร์ส" },
            { "timezone.excity.Atlantic/Canary", "คะเนรี" },
            { "timezone.excity.Atlantic/Faeroe", "แฟโร" },
            { "timezone.excity.Australia/Eucla", "ยูคลา" },
            { "timezone.excity.Australia/Perth", "เพิร์ท" },
            { "timezone.excity.Europe/Belgrade", "เบลเกรด" },
            { "timezone.excity.Europe/Brussels", "บรัสเซลส์" },
            { "timezone.excity.Europe/Budapest", "บูดาเปส" },
            { "timezone.excity.Europe/Busingen", "บุสซิงเง็น" },
            { "timezone.excity.Europe/Chisinau", "คีชีเนา" },
            { "timezone.excity.Europe/Guernsey", "เกิร์นซีย์" },
            { "timezone.excity.Europe/Helsinki", "เฮลซิงกิ" },
            { "timezone.excity.Europe/Istanbul", "อิสตันบูล" },
            { "timezone.excity.Europe/Sarajevo", "ซาราเยโว" },
            { "timezone.excity.Indian/Maldives", "มัลดีฟส์" },
            { "timezone.excity.Pacific/Chatham", "แชทัม" },
            { "timezone.excity.Pacific/Fakaofo", "ฟาเคาโฟ" },
            { "timezone.excity.Pacific/Gambier", "แกมเบียร์" },
            { "timezone.excity.Pacific/Norfolk", "นอร์ฟอล์ก" },
            { "timezone.excity.Africa/Bujumbura", "บูจุมบูรา" },
            { "timezone.excity.Africa/Mogadishu", "โมกาดิชู" },
            { "timezone.excity.America/Anguilla", "แองกิลลา" },
            { "timezone.excity.America/Asuncion", "อะซุนซิออง" },
            { "timezone.excity.America/Barbados", "บาร์เบโดส" },
            { "timezone.excity.America/Dominica", "โดมินิกา" },
            { "timezone.excity.America/Edmonton", "เอดมันตัน" },
            { "timezone.excity.America/Eirunepe", "เอรูเนเป" },
            { "timezone.excity.America/Mazatlan", "มาซาทลาน" },
            { "timezone.excity.America/Miquelon", "มีเกอลง" },
            { "timezone.excity.America/New_York", "นิวยอร์ก" },
            { "timezone.excity.America/Resolute", "เรโซลูท" },
            { "timezone.excity.America/Santarem", "ซันตาเรม" },
            { "timezone.excity.America/Santiago", "ซันติอาโก" },
            { "timezone.excity.America/St_Johns", "เซนต์จอนส์" },
            { "timezone.excity.America/St_Kitts", "เซนต์คิตส์" },
            { "timezone.excity.America/St_Lucia", "เซนต์ลูเซีย" },
            { "timezone.excity.America/Winnipeg", "วินนิเพก" },
            { "timezone.excity.Antarctica/Casey", "เคซีย์" },
            { "timezone.excity.Antarctica/Davis", "เดวิส" },
            { "timezone.excity.Antarctica/Syowa", "ไซโยวา" },
            { "timezone.excity.Antarctica/Troll", "โทรล" },
            { "timezone.excity.Asia/Krasnoyarsk", "ครัสโนยาร์สก์" },
            { "timezone.excity.Asia/Novosibirsk", "โนโวซิบิร์สก์" },
            { "timezone.excity.Asia/Ulaanbaatar", "อูลานบาตอร์" },
            { "timezone.excity.Asia/Vladivostok", "วลาดิโวสต็อก" },
            { "timezone.excity.Atlantic/Bermuda", "เบอร์มิวดา" },
            { "timezone.excity.Atlantic/Madeira", "มาเดรา" },
            { "timezone.excity.Atlantic/Stanley", "สแตนลีย์" },
            { "timezone.excity.Australia/Darwin", "ดาร์วิน" },
            { "timezone.excity.Australia/Hobart", "โฮบาร์ต" },
            { "timezone.excity.Australia/Sydney", "ซิดนีย์" },
            { "timezone.excity.Europe/Amsterdam", "อัมสเตอดัม" },
            { "timezone.excity.Europe/Astrakhan", "แอสตราคาน" },
            { "timezone.excity.Europe/Bucharest", "บูคาเรส" },
            { "timezone.excity.Europe/Gibraltar", "ยิบรอลตาร์" },
            { "timezone.excity.Europe/Ljubljana", "ลูบลิยานา" },
            { "timezone.excity.Europe/Mariehamn", "มารีฮามน์" },
            { "timezone.excity.Europe/Podgorica", "พอดกอรีตซา" },
            { "timezone.excity.Europe/Stockholm", "สตอกโฮล์ม" },
            { "timezone.excity.Europe/Ulyanovsk", "อะลิยานอฟ" },
            { "timezone.excity.Europe/Volgograd", "วอลโกกราด" },
            { "timezone.excity.Indian/Christmas", "คริสต์มาส" },
            { "timezone.excity.Indian/Kerguelen", "แกร์เกอลอง" },
            { "timezone.excity.Indian/Mauritius", "มอริเชียส" },
            { "timezone.excity.Pacific/Auckland", "โอคแลนด์" },
            { "timezone.excity.Pacific/Funafuti", "ฟูนะฟูตี" },
            { "timezone.excity.Pacific/Honolulu", "โฮโนลูลู" },
            { "timezone.excity.Pacific/Pitcairn", "พิตแคร์น" },
            { "timezone.excity.Africa/Casablanca", "คาสซาบลางก้า" },
            { "timezone.excity.Africa/Libreville", "ลีเบรอวิล" },
            { "timezone.excity.Africa/Lubumbashi", "ลูบัมบาชิ" },
            { "timezone.excity.Africa/Nouakchott", "นูแอกชอต" },
            { "timezone.excity.Africa/Porto-Novo", "ปอร์โต-โนโว" },
            { "timezone.excity.America/Anchorage", "แองเคอเรจ" },
            { "timezone.excity.America/Araguaina", "อารากัวนา" },
            { "timezone.excity.America/Boa_Vista", "บัววีชตา" },
            { "timezone.excity.America/Catamarca", "กาตามาร์กา" },
            { "timezone.excity.America/Chihuahua", "ชีวาวา" },
            { "timezone.excity.America/Coyhaique", "โกไยเก" },
            { "timezone.excity.America/Fortaleza", "ฟอร์ตาเลซา" },
            { "timezone.excity.America/Glace_Bay", "เกลซเบย์" },
            { "timezone.excity.America/Goose_Bay", "กูสเบย์" },
            { "timezone.excity.America/Guatemala", "กัวเตมาลา" },
            { "timezone.excity.America/Guayaquil", "กัวยากิล" },
            { "timezone.excity.America/Matamoros", "มาตาโมรอส" },
            { "timezone.excity.America/Menominee", "เมโนมินี" },
            { "timezone.excity.America/Monterrey", "มอนเตร์เรย์" },
            { "timezone.excity.America/Sao_Paulo", "เซาเปาลู" },
            { "timezone.excity.America/St_Thomas", "เซนต์โธมัส" },
            { "timezone.excity.America/Vancouver", "แวนคูเวอร์" },
            { "timezone.excity.Antarctica/Mawson", "มอว์สัน" },
            { "timezone.excity.Antarctica/Palmer", "พาล์เมอร์" },
            { "timezone.excity.Antarctica/Vostok", "วอสตอค" },
            { "timezone.excity.Asia/Kuala_Lumpur", "กัวลาลัมเปอร์" },
            { "timezone.excity.Asia/Novokuznetsk", "โนโวคุซเนตสค์" },
            { "timezone.excity.Europe/Bratislava", "บราติสลาวา" },
            { "timezone.excity.Europe/Copenhagen", "โคเปนเฮเกน" },
            { "timezone.excity.Europe/Luxembourg", "ลักเซมเบิร์ก" },
            { "timezone.excity.Europe/San_Marino", "ซานมารีโน" },
            { "timezone.excity.Europe/Simferopol", "ซิมเฟอโรโปล" },
            { "timezone.excity.Pacific/Enderbury", "แคนทอน" },
            { "timezone.excity.Pacific/Galapagos", "กาลาปาโกส" },
            { "timezone.excity.Pacific/Kwajalein", "ควาจาเลน" },
            { "timezone.excity.Pacific/Marquesas", "มาร์เคซัส" },
            { "timezone.excity.Pacific/Pago_Pago", "ปาโก ปาโก" },
            { "timezone.excity.Pacific/Rarotonga", "ราโรตองกา" },
            { "timezone.excity.Pacific/Tongatapu", "ตองกาตาปู" },
            { "timezone.excity.Africa/Addis_Ababa", "แอดดิสอาบาบา" },
            { "timezone.excity.Africa/Brazzaville", "บราซซาวิล" },
            { "timezone.excity.Africa/Ouagadougou", "วากาดูกู" },
            { "timezone.excity.America/Costa_Rica", "คอสตาริกา" },
            { "timezone.excity.America/Grand_Turk", "แกรนด์เติร์ก" },
            { "timezone.excity.America/Guadeloupe", "กวาเดอลูป" },
            { "timezone.excity.America/Hermosillo", "เอร์โมซีโย" },
            { "timezone.excity.America/Kralendijk", "คราเลนดิจค์" },
            { "timezone.excity.America/Louisville", "ลูส์วิลล์" },
            { "timezone.excity.America/Martinique", "มาร์ตินีก" },
            { "timezone.excity.America/Metlakatla", "เมทลากาตละ" },
            { "timezone.excity.America/Montevideo", "มอนเตวิเดโอ" },
            { "timezone.excity.America/Montserrat", "มอนเซอร์รัต" },
            { "timezone.excity.America/Paramaribo", "ปารามาริโบ" },
            { "timezone.excity.America/Rio_Branco", "รีโอบรังโก" },
            { "timezone.excity.America/St_Vincent", "เซนต์วินเซนต์" },
            { "timezone.excity.America/Whitehorse", "ไวต์ฮอร์ส" },
            { "timezone.excity.Antarctica/McMurdo", "แมคมัวโด" },
            { "timezone.excity.Antarctica/Rothera", "โรธีรา" },
            { "timezone.excity.Asia/Srednekolymsk", "ซเรดเนคโคลิมสก์" },
            { "timezone.excity.Asia/Yekaterinburg", "ยีคาเตอรินเบิร์ก" },
            { "timezone.excity.Atlantic/Reykjavik", "เรคยาวิก" },
            { "timezone.excity.Atlantic/St_Helena", "เซนต์เฮเลนา" },
            { "timezone.excity.Australia/Adelaide", "แอดิเลด" },
            { "timezone.excity.Australia/Brisbane", "บริสเบน" },
            { "timezone.excity.Australia/Lindeman", "ลินดีแมน" },
            { "timezone.excity.Europe/Isle_of_Man", "เกาะแมน" },
            { "timezone.excity.Europe/Kaliningrad", "คาลินิงกราด" },
            { "timezone.excity.Pacific/Kiritimati", "คิริทิมาตี" },
            { "timezone.excity.Africa/Johannesburg", "โจฮันเนสเบอร์ก" },
            { "timezone.excity.America/El_Salvador", "เอลซัลวาดอร์" },
            { "timezone.excity.America/Fort_Nelson", "ฟอร์ตเนลสัน" },
            { "timezone.excity.America/Los_Angeles", "ลอสแองเจลิส" },
            { "timezone.excity.America/Mexico_City", "เม็กซิโกซิตี" },
            { "timezone.excity.America/Porto_Velho", "ปอร์ตูเวลโย" },
            { "timezone.excity.America/Puerto_Rico", "เปอโตริโก" },
            { "timezone.excity.America/Tegucigalpa", "เตกูซิกัลปา" },
            { "timezone.excity.Arctic/Longyearbyen", "ลองเยียร์เบียน" },
            { "timezone.excity.Atlantic/Cape_Verde", "เคปเวิร์ด" },
            { "timezone.excity.Australia/Lord_Howe", "ลอร์ดโฮว์" },
            { "timezone.excity.Australia/Melbourne", "เมลเบิร์น" },
            { "timezone.excity.Indian/Antananarivo", "อันตานานาริโว" },
            { "timezone.excity.Pacific/Guadalcanal", "กัวดัลคานัล" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ดาร์เอสซาลาม" },
            { "timezone.excity.America/Blanc-Sablon", "บลังค์-ซาบลอน" },
            { "timezone.excity.America/Buenos_Aires", "บัวโนสไอเรส" },
            { "timezone.excity.America/Campo_Grande", "กัมปูกรันดี" },
            { "timezone.excity.America/Danmarkshavn", "ดานมาร์กสฮาวน์" },
            { "timezone.excity.America/Dawson_Creek", "ดอว์สัน ครีก" },
            { "timezone.excity.America/Indiana/Knox", "นอกซ์, อินดีแอนา" },
            { "timezone.excity.America/Indianapolis", "อินเดียแนโพลิส" },
            { "timezone.excity.America/Punta_Arenas", "ปุนตาอาเรนัส" },
            { "timezone.excity.America/Rankin_Inlet", "แรงกินอินเล็ต" },
            { "timezone.excity.America/Scoresbysund", "สกอเรสไบซันด์" },
            { "timezone.excity.Antarctica/Macquarie", "แมคควอรี" },
            { "timezone.excity.Pacific/Bougainville", "บูเกนวิลล์" },
            { "timezone.excity.Pacific/Port_Moresby", "พอร์ตมอร์สบี" },
            { "timezone.excity.America/Cambridge_Bay", "อ่าวแคมบริดจ์" },
            { "timezone.excity.America/Ciudad_Juarez", "ซิวดัดฮัวเรซ" },
            { "timezone.excity.America/Coral_Harbour", "คอรัลฮาร์เบอร์" },
            { "timezone.excity.America/Indiana/Vevay", "วีเวย์, อินดีแอนา" },
            { "timezone.excity.America/Lower_Princes", "โลเวอร์พรินซ์ ควอเตอร์" },
            { "timezone.excity.America/Port_of_Spain", "พอร์ทออฟสเปน" },
            { "timezone.excity.America/Santo_Domingo", "ซานโต โดมิงโก" },
            { "timezone.excity.America/St_Barthelemy", "เซนต์บาร์เธเลมี" },
            { "timezone.excity.America/Swift_Current", "สวิฟต์เคอร์เรนต์" },
            { "timezone.excity.Australia/Broken_Hill", "โบรกเคนฮิลล์" },
            { "timezone.excity.America/Bahia_Banderas", "บาเอียบันเดรัส" },
            { "timezone.excity.America/Port-au-Prince", "ปอร์โตแปรงซ์" },
            { "timezone.excity.Atlantic/South_Georgia", "เซาท์ จอร์เจีย" },
            { "timezone.excity.America/Argentina/Salta", "ซัลตา" },
            { "timezone.excity.America/Indiana/Marengo", "มาเรงโก, อินดีแอนา" },
            { "timezone.excity.America/Indiana/Winamac", "วินาแมค, อินดีแอนา" },
            { "timezone.excity.America/Argentina/Tucuman", "ทูคูแมน" },
            { "timezone.excity.America/Argentina/Ushuaia", "อูชูเอีย" },
            { "timezone.excity.America/Indiana/Tell_City", "เทลล์ซิตี, อินดีแอนา" },
            { "timezone.excity.America/Indiana/Vincennes", "วินเซนเนส, อินดีแอนา" },
            { "timezone.excity.Antarctica/DumontDUrville", "ดูมองต์ดูร์วิลล์" },
            { "timezone.excity.America/Argentina/La_Rioja", "ลาริโอจา" },
            { "timezone.excity.America/Argentina/San_Juan", "ซานฮวน" },
            { "timezone.excity.America/Argentina/San_Luis", "ซันลูอิส" },
            { "timezone.excity.America/Indiana/Petersburg", "ปีเตอร์สเบิร์ก, อินดีแอนา" },
            { "timezone.excity.America/Kentucky/Monticello", "มอนติเซลโล, เคนตักกี" },
            { "timezone.excity.America/North_Dakota/Beulah", "โบลาห์, นอร์ทดาโคตา" },
            { "timezone.excity.America/North_Dakota/Center", "เซนเตอร์, นอร์ทดาโคตา" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ริโอกาลเลกอส" },
            { "timezone.excity.America/North_Dakota/New_Salem", "นิวเซเลม, นอร์ทดาโคตา" },
        };
        return data;
    }
}
