/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv_Telu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ఆరబిక్";
        final String metaValue_kn = "కన్నడ";
        final String metaValue_or = "ఒడియా";
        final String metaValue_ta = "తమిళము";
        final String metaValue_te = "తెలుగు";
        final Object[][] data = new Object[][] {
            { "001", "ప్రపంచం" },
            { "419", "లాటిన్ ఆమెరిక" },
            { "AD", "ఆండొర" },
            { "AE", "యునైటెడ్ ఆరబ్ ఎమిరేబ్స్" },
            { "AF", "ఆప్గనిస్తాన్" },
            { "AG", "ఆంటిగ్వా మరియు బార్బుడా" },
            { "AI", "ఆంగ్విల్లా" },
            { "AL", "ఆల్లేనియా" },
            { "AM", "ఆర్మేనియా" },
            { "AO", "ఆంగోలా" },
            { "AQ", "ఆంటార్కటికా" },
            { "AR", "ఆర్జెంటినా" },
            { "AS", "ఆమెరికన్ సమూవా" },
            { "AT", "ఆస్ట్రీయా" },
            { "AU", "ఆస్ట్రేలియా" },
            { "AW", "ఆరుబా" },
            { "AX", "ఆలాండ్ దీపులు" },
            { "AZ", "ఆజర్బైజాన్" },
            { "BA", "బోస్నియా మరియు బెర్జిగోవినా" },
            { "BB", "బార్బడోస్" },
            { "BD", "బంగ్లాదేస్" },
            { "BE", "బెల్జియం" },
            { "BF", "బుర్కినా పాసో" },
            { "BG", "బుల్గేరియ" },
            { "BH", "బహరిన్" },
            { "BI", "బురుండి" },
            { "BJ", "బెనిన్" },
            { "BL", "సెంట్ బర్తెలిమి" },
            { "BM", "బర్ముడా" },
            { "BN", "బ్రునేఇ" },
            { "BO", "బొలివియా" },
            { "BQ", "కరీబియన్ నెదర్లాండ్స" },
            { "BR", "బ్రాజిల్" },
            { "BS", "బహామాస్" },
            { "BT", "బుటాన్" },
            { "BW", "బోట్స్వానా" },
            { "BY", "బెలారస్" },
            { "BZ", "బెలిజ్" },
            { "CA", "కెనడా" },
            { "CC", "కోకోస్ (కీలింగ్) దీవులు" },
            { "CD", "కాంగో కిన్సాసా" },
            { "CF", "సెంట్రల్ ఆప్రికన్ రిపబ్లిక్" },
            { "CG", "కాంగో- బ్రాజావిల్లి" },
            { "CH", "స్విజర్లాండ్" },
            { "CI", "కోట్ డి ఐవోర్" },
            { "CK", "కుక్ దీపులు" },
            { "CL", "చిలి" },
            { "CM", "కామెరూన్" },
            { "CN", "చినా" },
            { "CO", "కొలంబియా" },
            { "CR", "కోస్టా రికా" },
            { "CU", "క్యూబా" },
            { "CV", "కేప్ వడ్" },
            { "CW", "క్వురసో" },
            { "CX", "క్రిస్ట మాస్ దీపుపు" },
            { "CY", "సైప్రస్" },
            { "CZ", "చెకియా" },
            { "DE", "జర్మనీ" },
            { "DG", "డియాగో గార్సియా" },
            { "DJ", "జిబుతి" },
            { "DK", "డెన్మార్క" },
            { "DM", "డొమినికా" },
            { "DO", "డొమినికాన్ రిపబ్లిక్" },
            { "DZ", "ఆల్జిరియా" },
            { "EA", "స్యూటా & మెలిల్లా" },
            { "EC", "ఈక్వడార్" },
            { "EE", "ఎస్టోనియా" },
            { "EG", "ఈజిప్ట్" },
            { "EH", "పడమటి సహారా" },
            { "ER", "ఇరిట్రియా" },
            { "ES", "స్పెన్" },
            { "ET", "ఇతియోపియా" },
            { "FI", "పిన్లాండ్" },
            { "FJ", "పిజీ" },
            { "FK", "ఫాక్‌ల్యాండ్ దీవులు" },
            { "FM", "మైక్రోనేసియా" },
            { "FO", "పెరొ దీప" },
            { "FR", "ప్రాన్స్" },
            { "GA", "గాబన్" },
            { "GB", "యునైటెడ్ కింగ్‌డమ్" },
            { "GD", "గ్రెనడా" },
            { "GE", "జార్జియా" },
            { "GF", "ప్రెంచ్ గుయానా" },
            { "GG", "గర్నసీ" },
            { "GH", "గనా" },
            { "GI", "జిబ్రాల్టర్" },
            { "GL", "గ్రీన్లండ్" },
            { "GM", "గంబియా" },
            { "GN", "గినియా" },
            { "GP", "గ్వడెలుప్" },
            { "GQ", "ఈక్వటోరియల్ గినియా" },
            { "GR", "గ్రీస్" },
            { "GS", "దకిన జర్జిఆ అదే దకిన సండవిచ్ దిప" },
            { "GT", "గ్వటెమాలా" },
            { "GU", "గ్వమ్" },
            { "GW", "గినియా-బిస్సావ్" },
            { "GY", "గుయానా" },
            { "HK", "హాంకాంగ్ ఎస్ఎఆర్ చినా" },
            { "HN", "హండురాస్" },
            { "HR", "క్రొయేసియా" },
            { "HT", "హైటి" },
            { "HU", "హంగేరీ" },
            { "IC", "కేనరీ దీపులు" },
            { "ID", "ఇండోనేసియా" },
            { "IE", "ఐర్లాండ్" },
            { "IL", "ఇజ్రాయెల్" },
            { "IM", "ఐల్ ఆప్ మాన్" },
            { "IN", "బారతదెసాం" },
            { "IO", "బ్రిటిస్ హీందూ మహాసముద్ర ప్రాంతం" },
            { "IQ", "ఇరాక్" },
            { "IR", "ఇరాన్" },
            { "IS", "ఐస్లాండ్" },
            { "IT", "ఇటలి" },
            { "JE", "జెర్సీ" },
            { "JM", "జమైకా" },
            { "JO", "జోర్డాన్" },
            { "JP", "జపాన్" },
            { "KE", "కెన్యా" },
            { "KG", "కిర్గజిస్తాన్" },
            { "KH", "కంబోడియా" },
            { "KI", "కీరిబాటి" },
            { "KM", "కొమొరోస్" },
            { "KN", "సెయింట్ కిట్స్ మరియు నెవిస్" },
            { "KP", "ఉత్తర కొరియా" },
            { "KR", "దకిణ కొరియా" },
            { "KW", "కువైట్" },
            { "KY", "కేమాన్ దీపులు" },
            { "KZ", "కజకిస్తాన్" },
            { "LA", "లావోస్" },
            { "LB", "లెబనాన్" },
            { "LC", "సెయింట్ లూసియా" },
            { "LI", "లిక్టెన్‌స్టెయిన్" },
            { "LK", "స్రీ లంక" },
            { "LR", "లైబీరియా" },
            { "LS", "లెసోతో" },
            { "LT", "లీతువేనియ" },
            { "LU", "లక్సెంబర్గ్" },
            { "LV", "లాత్వియా" },
            { "LY", "లిబియా" },
            { "MA", "మొరాకో" },
            { "MC", "మొనాకో" },
            { "MD", "మోల్డొవా" },
            { "ME", "మాంటెనెగ్రో" },
            { "MF", "సెయింట్ మార్టిన్" },
            { "MG", "మడగాస్కర్" },
            { "MH", "మార్సాల్ దీపులు" },
            { "MK", "ఉత్తర మాసిడోనియా" },
            { "ML", "మాలి" },
            { "MM", "మయన్మార్ (బర్మా)" },
            { "MN", "మంగోలియా" },
            { "MO", "మకావ్ ఎస్ఏఆర్ చైనా" },
            { "MP", "ఉత్తర మరియానా దీవులు" },
            { "MQ", "మార్ర్టనీక్" },
            { "MR", "మౌరిటేనియా" },
            { "MS", "మాంట్సెరాట్" },
            { "MT", "మాల్డా" },
            { "MU", "మారిసస్" },
            { "MV", "మాలదిపి" },
            { "MW", "మలావీ" },
            { "MX", "మెక్సికో" },
            { "MY", "మలేసియా" },
            { "MZ", "మొజాంబిక్" },
            { "NA", "నమీబియా" },
            { "NC", "క్రొత్త కెలెడోనియా" },
            { "NE", "నఇజర్" },
            { "NF", "నార్పోక్ దీవ" },
            { "NG", "నౌజీరియా" },
            { "NI", "నికరాగువా" },
            { "NL", "నెదర్లాండ్స్" },
            { "NO", "నార్వే" },
            { "NP", "నేపాల్" },
            { "NR", "నౌరు" },
            { "NU", "నియూ" },
            { "NZ", "న్యూజిలాండ్" },
            { "OM", "ఓమన్" },
            { "PA", "పనామా" },
            { "PE", "పెరూ" },
            { "PF", "ప్రెంచ్ పోలినిసియా" },
            { "PG", "పాపువా న్యూ గనియా" },
            { "PH", "పిలిప్పైన్స్" },
            { "PK", "పాకిస్తాన్" },
            { "PL", "పోలాండ్" },
            { "PM", "సెయింట్ పియెర్ మరియు మికెలాన్" },
            { "PN", "పిట్‌కెయిర్న్ దీవులు" },
            { "PR", "ప్యూర్టో రికో" },
            { "PS", "పాలస్తీనియన్ ప్రాంతాలు" },
            { "PT", "పోర్చుగల్" },
            { "PW", "పాలావ్" },
            { "PY", "పరాగ్వే" },
            { "QA", "కతార" },
            { "RE", "రీయూనియన్" },
            { "RO", "రోమేనియా" },
            { "RS", "సెర్బియా" },
            { "RU", "రస్యా" },
            { "RW", "రువాండా" },
            { "SA", "సౌదీ అరేబియా" },
            { "SB", "సోలమన్ దీవులు" },
            { "SC", "సీషెల్స్" },
            { "SD", "సూడాన్" },
            { "SE", "స్వీడన్" },
            { "SG", "సింగపూర్" },
            { "SH", "సెయింట్ హెలెనా" },
            { "SI", "స్లోవేనియా" },
            { "SJ", "స్వాల్‌బార్డ్ మరియు జాన్ మాయెన్" },
            { "SK", "స్లొవేకియా" },
            { "SL", "సియెర్రా లియాన్" },
            { "SM", "సస్ మారిసో" },
            { "SN", "సెనెగల్" },
            { "SO", "సోమలియా" },
            { "SR", "సూరినామ్" },
            { "SS", "దక్షిణ సూడాన్" },
            { "ST", "సావో టోమ్ మరియు ప్రిన్సిపి" },
            { "SV", "ఎల్ సాల్వడోర్" },
            { "SX", "సింట్ మార్టెన్" },
            { "SY", "సిరియా" },
            { "SZ", "ఈస్వాటిని" },
            { "TC", "టర్క్స్ మరియు కైకోస్ దీవులు" },
            { "TD", "చాద్" },
            { "TF", "ప్రెంచ్ దకినియ టెరిటొరి" },
            { "TG", "టోగో" },
            { "TH", "తయిలాండ్" },
            { "TJ", "తాజాకిస్తాన" },
            { "TK", "టోకెలావ్" },
            { "TL", "టిమోర్-లెస్టె" },
            { "TM", "తుర్క్‍మెనిస్తన్" },
            { "TN", "ట్యునీషియా" },
            { "TO", "టోంగా" },
            { "TR", "టర్కీ" },
            { "TT", "ట్రినిడాడ్ మరియు టొబాగో" },
            { "TV", "టువాలు" },
            { "TW", "తైవాన్" },
            { "TZ", "టాంజానియా" },
            { "UA", "ఉక్రెయిన్" },
            { "UG", "ఉగాండా" },
            { "UM", "సంయుక్త రాజ్య అమెరికా బయట ఉన్న దీవులు" },
            { "US", "యునైటెడ్ స్టేట్స్" },
            { "UY", "ఉరుగ్వే" },
            { "UZ", "ఉజ్బెకిస్తాన్" },
            { "VA", "బాటికాన్ సిటి" },
            { "VC", "సెయింట్ విన్సెంట్ మరియు గ్రెనడీన్స్" },
            { "VE", "వెనిజులా" },
            { "VG", "బ్రిటిష్ వర్జిన్ దీవులు" },
            { "VI", "యు.ఎస్. వర్జిన్ దీవులు" },
            { "VN", "వియత్నాం" },
            { "VU", "వనాటు" },
            { "WF", "వాల్లిస్ మరియు ఫుటునా" },
            { "WS", "సమోవా" },
            { "XK", "కొసోవో" },
            { "YE", "యెమెన్" },
            { "YT", "మాయొట్" },
            { "ZA", "దకిణ అప్రికా" },
            { "ZM", "జంబియా" },
            { "ZW", "జింబాబ్వే" },
            { "af", "ఆప్రికాన్స్" },
            { "am", "ఆమ్హెరి" },
            { "ar", metaValue_ar },
            { "as", "ఆసమీజ్" },
            { "az", "అజరబైజాని" },
            { "be", "బెలారుసియన్" },
            { "bg", "బుల్గారియన్" },
            { "bn", "బంగ్లా" },
            { "bo", "తిబ్బతన్" },
            { "bs", "బొస్ నిఆన్" },
            { "ca", "కాటాలాన్" },
            { "cs", "చెక్" },
            { "da", "డెనిస్" },
            { "de", "జర్మన్" },
            { "el", "గ్రిక్" },
            { "en", "ఇంగ్లిస్" },
            { "es", "స్పెనిస్" },
            { "et", "ఎస్టొ నియన్" },
            { "eu", "బాస్క్" },
            { "fa", "పర్సియన్" },
            { "fi", "పినిస్" },
            { "fr", "ప్రెంచ్" },
            { "gl", "గాలసియన్" },
            { "gu", "గుజరాటి" },
            { "he", "హిబ్రూ" },
            { "hi", "హిందీ" },
            { "hr", "క్రొయేసియన్" },
            { "hu", "హంగేరియన్" },
            { "hy", "అర్మేనియన్" },
            { "id", "ఇండోనేసియన్" },
            { "is", "అఇస్లెండిక్" },
            { "it", "ఇటాలియన్" },
            { "ja", "జపనిస్" },
            { "ka", "జర్జియన్" },
            { "kk", "కజక్" },
            { "km", "కమెర్" },
            { "kn", metaValue_kn },
            { "ko", "కొరియన్" },
            { "ks", "కాస్మిరి" },
            { "ky", "కిర్గజ్" },
            { "lo", "లావో" },
            { "lt", "లితువేనియన్" },
            { "lv", "లాట్వియన్" },
            { "mk", "మాసిడోనియన్" },
            { "ml", "మలయాలం" },
            { "mn", "మగోంలియన్" },
            { "mr", "మరాటి" },
            { "ms", "మలయ్" },
            { "my", "బర్మీస్" },
            { "nb", "సార్వేజియన్ బొకమల్" },
            { "ne", "సేపాలి" },
            { "nl", "డచ్" },
            { "or", metaValue_or },
            { "pa", "పంజాబి" },
            { "pl", "పోలిస్" },
            { "pt", "పోర్తుగీస్" },
            { "ro", "రోమేనియన్" },
            { "ru", "రస్వన్" },
            { "sa", "సంస్కృతం" },
            { "sd", "సిందీ" },
            { "si", "సింహళం" },
            { "sk", "స్లోవక్" },
            { "sl", "స్లోవేనియన్" },
            { "sq", "అల్బేనియన్" },
            { "sr", "సెర్బియన్" },
            { "sv", "స్విడిస్" },
            { "sw", "స్వాహిలి" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "తాఇ" },
            { "tr", "టర్కిస్" },
            { "uk", "యుక్రెయనియన్" },
            { "ur", "ఉర్దూ" },
            { "uz", "ఉజ్బెక్" },
            { "vi", "వియత్నామీస్" },
            { "zh", "చైనీస్" },
            { "zu", "జాలూ" },
            { "brx", "బొడొ" },
            { "chr", "చెరొకీ" },
            { "doi", "డోగ్రి" },
            { "fil", "పిలిపినో" },
            { "kok", "కొంకణి" },
            { "kxv", "కువి" },
            { "mai", "మైతలి" },
            { "mni", "మణిపురి" },
            { "sat", "సంతాలి" },
            { "Arab", metaValue_ar },
            { "Beng", "బాంగ్లా" },
            { "Brah", "బ్రాహ్మి" },
            { "Cher", "చిరోకి" },
            { "Cyrl", "సిరిలిక్" },
            { "Deva", "దేవనాగరి" },
            { "Gujr", "గుజరాతి" },
            { "Guru", "గురుముకి" },
            { "Hans", "సరళీకృతం" },
            { "Hant", "సాంప్రదాయక" },
            { "Knda", metaValue_kn },
            { "Latn", "లాటిన్" },
            { "Mlym", "మలయాళం" },
            { "Orya", metaValue_or },
            { "Saur", "సౌరాస్ట్ర" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Zxxx", "లిపి లేని" },
            { "Zzzz", "తెలియని లిపి" },
            { "de_AT", "అస్ట్రీయన్ జర్మన్" },
            { "de_CH", "స్విస్ హఇ జర్మన్" },
            { "en_AU", "అస్ట్రె లియన్ ఇంగ్లిస్" },
            { "en_CA", "కనెడయన్ ఇంగ్లిస్" },
            { "en_GB", "బ్రిటిస్ ఇంగ్లిస్" },
            { "en_US", "అమెరికాన్ ఇంగ్లిస్" },
            { "es_ES", "యురోపియన్ స్పెనిస్" },
            { "es_MX", "మెక్సికాన్ స్పాస్పెనిస్" },
            { "fa_AF", "డారి" },
            { "fr_CA", "కానడియెన్ ప్రేంచ్" },
            { "fr_CH", "స్విస్ ప్రెంచ్" },
            { "nl_BE", "ప్లెమిస్" },
            { "pt_BR", "బ్రెజిలియన్ పోర్తుగీస్" },
            { "pt_PT", "యురోపియన్ పోర్తుగిస్" },
            { "ro_MD", "మెల్డావియన్" },
            { "sw_CD", "కాగోం స్వాహిలి" },
            { "ar_001", "అదునిక ప్రామాణిక్ అరబిక్" },
            { "es_419", "లాటిన్ అమెరికన్ స్పెనిస్" },
            { "key.ca", "క్యాలెండర్" },
            { "key.cf", "కరెన్సీ ఫార్మాట్" },
            { "key.co", "క్రమబద్ధీకరణ క్రమం" },
            { "key.cu", "కరెన్సీ" },
            { "key.hc", "గంటల పద్ధతి (౧౨ వర్సెస్౨౪)" },
            { "key.lb", "లైన్ బ్రేక్ సైలి" },
            { "key.ms", "కొలమాన పద్ధతి" },
            { "key.nu", "సంక్యాలు" },
            { "zh_Hans", "సరళీకృత చైనీస్" },
            { "zh_Hant", "సాంప్రదాయక చైనీస్" },
            { "type.hc.h11", "౧౨ గంటల పద్ధతి (0–౧౧)" },
            { "type.hc.h12", "౧౨ గంటల పద్ధతి (౧–౧౨)" },
            { "type.hc.h23", "౨౪ గంటల పద్ధతి (0–౨౩)" },
            { "type.hc.h24", "౨౪ గంటల పద్ధతి (౧–౨౪)" },
            { "type.nu.arab", "అరబిక్-ఇండిక్ అంకెలు" },
            { "type.nu.beng", "బెంగాలీ అంకెలు" },
            { "type.nu.deva", "దేవనాగరి అంకెలు" },
            { "type.nu.gujr", "గుజరాతీ అంకెలు" },
            { "type.nu.guru", "గుర్ముకి అంకెలు" },
            { "type.nu.knda", "కన్నడ అంకెలు" },
            { "type.nu.latn", "పస్చిమ అంకెలు" },
            { "type.nu.mlym", "మలయాళం అంకెలు" },
            { "type.nu.orya", "ఒరియా అంకెలు" },
            { "type.nu.taml", "సాంప్రదాయ తమిళ సంక్యలు" },
            { "type.nu.telu", "తెలుగు అంకెలు" },
            { "type.co.ducet", "డిపాల్ట్ యూనీకోడ్ క్రమబద్ధీకరణ క్రమం" },
            { "type.nu.roman", "రోమన్ సంఖ్యలు" },
            { "type.ca.indian", "భారతీయ జాతీయ క్యాలెండర్" },
            { "type.co.search", "సాధారణ-ప్రయోజన సోధన" },
            { "type.ms.metric", "మెట్రిక్ పద్ధతి" },
            { "type.nu.arabext", "పొడిగించబడిన అరబిక్-ఇండిక్ అంకెలు" },
            { "type.nu.tamldec", "తమిళ అంకెలు" },
            { "type.cf.standard", "ప్రామాణిక కరెన్సీ ఫార్మాట్" },
            { "type.co.standard", "ప్రామాణిక క్రమబద్ధీకరణ క్రమం" },
            { "type.ms.uksystem", "ఇంపీరియల్ కొలమాన పద్ధతి" },
            { "type.ms.ussystem", "యు.ఎస్. కొలమాన పద్ధతి" },
            { "type.nu.romanlow", "రోమన్ చిన్నబడి సంఖ్యలు" },
            { "type.ca.gregorian", "గ్రేగోరియన్ క్యాలెండర్" },
            { "type.co.phonebook", "పోన్‌బుక్ క్రమబద్ధీకరణ క్రమం" },
        };
        return data;
    }
}
