"use strict";


//#region rolldown:runtime
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function() {
	return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};

//#endregion

//#region node_modules/@volar/source-map/lib/binarySearch.js
var require_binarySearch$1 = __commonJS({ "node_modules/@volar/source-map/lib/binarySearch.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.binarySearch = binarySearch$2;
	function binarySearch$2(values, searchValue) {
		let low = 0;
		let high = values.length - 1;
		let match$1;
		while (low <= high) {
			const mid = Math.floor((low + high) / 2);
			const midValue = values[mid];
			if (midValue < searchValue) low = mid + 1;
			else if (midValue > searchValue) high = mid - 1;
			else {
				low = mid;
				high = mid;
				match$1 = mid;
				break;
			}
		}
		const finalLow = Math.max(Math.min(low, high, values.length - 1), 0);
		const finalHigh = Math.min(Math.max(low, high, 0), values.length - 1);
		return {
			low: finalLow,
			high: finalHigh,
			match: match$1
		};
	}
} });

//#endregion
//#region node_modules/@volar/source-map/lib/translateOffset.js
var require_translateOffset = __commonJS({ "node_modules/@volar/source-map/lib/translateOffset.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.translateOffset = translateOffset;
	let warned = false;
	function translateOffset(start, fromOffsets, toOffsets$1, fromLengths, toLengths = fromLengths) {
		const isSorted = fromOffsets.every((value, index$1) => index$1 === 0 || fromOffsets[index$1 - 1] <= value);
		if (!isSorted) {
			for (let i = 0; i < fromOffsets.length; i++) {
				const fromOffset = fromOffsets[i];
				const fromLength = fromLengths[i];
				if (start >= fromOffset && start <= fromOffset + fromLength) {
					const toLength = toLengths[i];
					const toOffset = toOffsets$1[i];
					let rangeOffset = Math.min(start - fromOffset, toLength);
					return toOffset + rangeOffset;
				}
			}
			if (!warned) {
				warned = true;
				console.warn("fromOffsets should be sorted in ascending order");
			}
		}
		let low = 0;
		let high = fromOffsets.length - 1;
		while (low <= high) {
			const mid = Math.floor((low + high) / 2);
			const fromOffset = fromOffsets[mid];
			const fromLength = fromLengths[mid];
			if (start >= fromOffset && start <= fromOffset + fromLength) {
				const toLength = toLengths[mid];
				const toOffset = toOffsets$1[mid];
				let rangeOffset = Math.min(start - fromOffset, toLength);
				return toOffset + rangeOffset;
			} else if (start < fromOffset) high = mid - 1;
			else low = mid + 1;
		}
	}
} });

//#endregion
//#region node_modules/@volar/source-map/lib/sourceMap.js
var require_sourceMap = __commonJS({ "node_modules/@volar/source-map/lib/sourceMap.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.SourceMap = void 0;
	const binarySearch_1$1 = require_binarySearch$1();
	const translateOffset_1 = require_translateOffset();
	var SourceMap = class {
		constructor(mappings) {
			this.mappings = mappings;
		}
		toSourceRange(generatedStart, generatedEnd, fallbackToAnyMatch, filter$1) {
			return this.findMatchingStartEnd(generatedStart, generatedEnd, fallbackToAnyMatch, "generatedOffsets", filter$1);
		}
		toGeneratedRange(sourceStart, sourceEnd, fallbackToAnyMatch, filter$1) {
			return this.findMatchingStartEnd(sourceStart, sourceEnd, fallbackToAnyMatch, "sourceOffsets", filter$1);
		}
		toSourceLocation(generatedOffset, filter$1) {
			return this.findMatchingOffsets(generatedOffset, "generatedOffsets", filter$1);
		}
		toGeneratedLocation(sourceOffset, filter$1) {
			return this.findMatchingOffsets(sourceOffset, "sourceOffsets", filter$1);
		}
		*findMatchingOffsets(offset, fromRange, filter$1) {
			const memo = this.getMemoBasedOnRange(fromRange);
			if (memo.offsets.length === 0) return;
			const { low: start, high: end } = (0, binarySearch_1$1.binarySearch)(memo.offsets, offset);
			const skip = /* @__PURE__ */ new Set();
			const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
			for (let i = start; i <= end; i++) for (const mapping of memo.mappings[i]) {
				if (skip.has(mapping)) continue;
				skip.add(mapping);
				if (filter$1 && !filter$1(mapping.data)) continue;
				const mapped = (0, translateOffset_1.translateOffset)(offset, mapping[fromRange], mapping[toRange], getLengths(mapping, fromRange), getLengths(mapping, toRange));
				if (mapped !== void 0) yield [mapped, mapping];
			}
		}
		*findMatchingStartEnd(start, end, fallbackToAnyMatch, fromRange, filter$1) {
			const toRange = fromRange == "sourceOffsets" ? "generatedOffsets" : "sourceOffsets";
			const mappedStarts = [];
			let hadMatch = false;
			for (const [mappedStart, mapping] of this.findMatchingOffsets(start, fromRange)) {
				if (filter$1 && !filter$1(mapping.data)) continue;
				mappedStarts.push([mappedStart, mapping]);
				const mappedEnd = (0, translateOffset_1.translateOffset)(end, mapping[fromRange], mapping[toRange], getLengths(mapping, fromRange), getLengths(mapping, toRange));
				if (mappedEnd !== void 0) {
					hadMatch = true;
					yield [
						mappedStart,
						mappedEnd,
						mapping,
						mapping
					];
				}
			}
			if (!hadMatch && fallbackToAnyMatch) for (const [mappedStart, mappingStart] of mappedStarts) for (const [mappedEnd, mappingEnd] of this.findMatchingOffsets(end, fromRange)) {
				if (filter$1 && !filter$1(mappingEnd.data) || mappedEnd < mappedStart) continue;
				yield [
					mappedStart,
					mappedEnd,
					mappingStart,
					mappingEnd
				];
				break;
			}
		}
		getMemoBasedOnRange(fromRange) {
			return fromRange === "sourceOffsets" ? this.sourceCodeOffsetsMemo ??= this.createMemo("sourceOffsets") : this.generatedCodeOffsetsMemo ??= this.createMemo("generatedOffsets");
		}
		createMemo(key) {
			const offsetsSet = /* @__PURE__ */ new Set();
			for (const mapping of this.mappings) for (let i = 0; i < mapping[key].length; i++) {
				offsetsSet.add(mapping[key][i]);
				offsetsSet.add(mapping[key][i] + getLengths(mapping, key)[i]);
			}
			const offsets = [...offsetsSet].sort((a, b) => a - b);
			const mappings = offsets.map(() => /* @__PURE__ */ new Set());
			for (const mapping of this.mappings) for (let i = 0; i < mapping[key].length; i++) {
				const startIndex = (0, binarySearch_1$1.binarySearch)(offsets, mapping[key][i]).match;
				const endIndex = (0, binarySearch_1$1.binarySearch)(offsets, mapping[key][i] + getLengths(mapping, key)[i]).match;
				for (let i$1 = startIndex; i$1 <= endIndex; i$1++) mappings[i$1].add(mapping);
			}
			return {
				offsets,
				mappings
			};
		}
	};
	exports.SourceMap = SourceMap;
	function getLengths(mapping, key) {
		return key == "sourceOffsets" ? mapping.lengths : mapping.generatedLengths ?? mapping.lengths;
	}
} });

//#endregion
//#region node_modules/@volar/source-map/index.js
var require_source_map$1 = __commonJS({ "node_modules/@volar/source-map/index.js"(exports) {
	var __createBinding$6 = void 0 && (void 0).__createBinding || (Object.create ? function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		var desc = Object.getOwnPropertyDescriptor(m, k);
		if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) desc = {
			enumerable: true,
			get: function() {
				return m[k];
			}
		};
		Object.defineProperty(o, k2, desc);
	} : function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		o[k2] = m[k];
	});
	var __exportStar$5 = void 0 && (void 0).__exportStar || function(m, exports$1) {
		for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p)) __createBinding$6(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	__exportStar$5(require_sourceMap(), exports);
	__exportStar$5(require_translateOffset(), exports);
} });

//#endregion
//#region node_modules/@volar/language-core/lib/editor.js
var require_editor = __commonJS({ "node_modules/@volar/language-core/lib/editor.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.isHoverEnabled = isHoverEnabled;
	exports.isInlayHintsEnabled = isInlayHintsEnabled;
	exports.isCodeLensEnabled = isCodeLensEnabled;
	exports.isMonikerEnabled = isMonikerEnabled;
	exports.isInlineValueEnabled = isInlineValueEnabled;
	exports.isSemanticTokensEnabled = isSemanticTokensEnabled;
	exports.isCallHierarchyEnabled = isCallHierarchyEnabled;
	exports.isTypeHierarchyEnabled = isTypeHierarchyEnabled;
	exports.isRenameEnabled = isRenameEnabled;
	exports.isDefinitionEnabled = isDefinitionEnabled;
	exports.isTypeDefinitionEnabled = isTypeDefinitionEnabled;
	exports.isReferencesEnabled = isReferencesEnabled;
	exports.isImplementationEnabled = isImplementationEnabled;
	exports.isHighlightEnabled = isHighlightEnabled;
	exports.isSymbolsEnabled = isSymbolsEnabled;
	exports.isFoldingRangesEnabled = isFoldingRangesEnabled;
	exports.isSelectionRangesEnabled = isSelectionRangesEnabled;
	exports.isLinkedEditingEnabled = isLinkedEditingEnabled;
	exports.isColorEnabled = isColorEnabled;
	exports.isDocumentLinkEnabled = isDocumentLinkEnabled;
	exports.isDiagnosticsEnabled = isDiagnosticsEnabled;
	exports.isCodeActionsEnabled = isCodeActionsEnabled;
	exports.isFormattingEnabled = isFormattingEnabled;
	exports.isCompletionEnabled = isCompletionEnabled;
	exports.isAutoInsertEnabled = isAutoInsertEnabled;
	exports.isSignatureHelpEnabled = isSignatureHelpEnabled;
	exports.shouldReportDiagnostics = shouldReportDiagnostics;
	exports.resolveRenameNewName = resolveRenameNewName;
	exports.resolveRenameEditText = resolveRenameEditText;
	exports.findOverlapCodeRange = findOverlapCodeRange;
	function isHoverEnabled(info) {
		return !!info.semantic;
	}
	function isInlayHintsEnabled(info) {
		return !!info.semantic;
	}
	function isCodeLensEnabled(info) {
		return !!info.semantic;
	}
	function isMonikerEnabled(info) {
		return !!info.semantic;
	}
	function isInlineValueEnabled(info) {
		return !!info.semantic;
	}
	function isSemanticTokensEnabled(info) {
		return typeof info.semantic === "object" ? info.semantic.shouldHighlight?.() ?? true : !!info.semantic;
	}
	function isCallHierarchyEnabled(info) {
		return !!info.navigation;
	}
	function isTypeHierarchyEnabled(info) {
		return !!info.navigation;
	}
	function isRenameEnabled(info) {
		return typeof info.navigation === "object" ? info.navigation.shouldRename?.() ?? true : !!info.navigation;
	}
	function isDefinitionEnabled(info) {
		return !!info.navigation;
	}
	function isTypeDefinitionEnabled(info) {
		return !!info.navigation;
	}
	function isReferencesEnabled(info) {
		return !!info.navigation;
	}
	function isImplementationEnabled(info) {
		return !!info.navigation;
	}
	function isHighlightEnabled(info) {
		return !!info.navigation;
	}
	function isSymbolsEnabled(info) {
		return !!info.structure;
	}
	function isFoldingRangesEnabled(info) {
		return !!info.structure;
	}
	function isSelectionRangesEnabled(info) {
		return !!info.structure;
	}
	function isLinkedEditingEnabled(info) {
		return !!info.structure;
	}
	function isColorEnabled(info) {
		return !!info.structure;
	}
	function isDocumentLinkEnabled(info) {
		return !!info.structure;
	}
	function isDiagnosticsEnabled(info) {
		return !!info.verification;
	}
	function isCodeActionsEnabled(info) {
		return !!info.verification;
	}
	function isFormattingEnabled(info) {
		return !!info.format;
	}
	function isCompletionEnabled(info) {
		return !!info.completion;
	}
	function isAutoInsertEnabled(info) {
		return !!info.completion;
	}
	function isSignatureHelpEnabled(info) {
		return !!info.completion;
	}
	function shouldReportDiagnostics(info, source, code$1) {
		return typeof info.verification === "object" ? info.verification.shouldReport?.(source, code$1) ?? true : !!info.verification;
	}
	function resolveRenameNewName(newName, info) {
		return typeof info.navigation === "object" ? info.navigation.resolveRenameNewName?.(newName) ?? newName : newName;
	}
	function resolveRenameEditText(text$1, info) {
		return typeof info.navigation === "object" ? info.navigation.resolveRenameEditText?.(text$1) ?? text$1 : text$1;
	}
	function findOverlapCodeRange(start, end, map, filter$1) {
		let mappedStart;
		let mappedEnd;
		for (const [mapped, mapping] of map.toGeneratedLocation(start)) if (filter$1(mapping.data)) {
			mappedStart = mapped;
			break;
		}
		for (const [mapped, mapping] of map.toGeneratedLocation(end)) if (filter$1(mapping.data)) {
			mappedEnd = mapped;
			break;
		}
		if (mappedStart === void 0 || mappedEnd === void 0) {
			for (const mapping of map.mappings) if (filter$1(mapping.data)) {
				const mappingStart = mapping.sourceOffsets[0];
				const mappingEnd = mapping.sourceOffsets[mapping.sourceOffsets.length - 1] + mapping.lengths[mapping.lengths.length - 1];
				const overlap = getOverlapRange(start, end, mappingStart, mappingEnd);
				if (overlap) {
					const curMappedStart = overlap.start - mappingStart + mapping.generatedOffsets[0];
					const lastGeneratedLength = (mapping.generatedLengths ?? mapping.lengths)[mapping.generatedOffsets.length - 1];
					const curMappedEndOffset = Math.min(overlap.end - mapping.sourceOffsets[mapping.sourceOffsets.length - 1], lastGeneratedLength);
					const curMappedEnd = mapping.generatedOffsets[mapping.generatedOffsets.length - 1] + curMappedEndOffset;
					mappedStart = mappedStart === void 0 ? curMappedStart : Math.min(mappedStart, curMappedStart);
					mappedEnd = mappedEnd === void 0 ? curMappedEnd : Math.max(mappedEnd, curMappedEnd);
				}
			}
		}
		if (mappedStart !== void 0 && mappedEnd !== void 0) return {
			start: mappedStart,
			end: mappedEnd
		};
	}
	function getOverlapRange(range1Start, range1End, range2Start, range2End) {
		const start = Math.max(range1Start, range2Start);
		const end = Math.min(range1End, range2End);
		if (start > end) return void 0;
		return {
			start,
			end
		};
	}
} });

//#endregion
//#region node_modules/@volar/language-core/lib/linkedCodeMap.js
var require_linkedCodeMap = __commonJS({ "node_modules/@volar/language-core/lib/linkedCodeMap.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.LinkedCodeMap = void 0;
	const source_map_1$1 = require_source_map$1();
	var LinkedCodeMap = class extends source_map_1$1.SourceMap {
		*getLinkedOffsets(start) {
			for (const mapped of this.toGeneratedLocation(start)) yield mapped[0];
			for (const mapped of this.toSourceLocation(start)) yield mapped[0];
		}
	};
	exports.LinkedCodeMap = LinkedCodeMap;
} });

//#endregion
//#region node_modules/@volar/language-core/lib/types.js
var require_types$2 = __commonJS({ "node_modules/@volar/language-core/lib/types.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
} });

//#endregion
//#region node_modules/@volar/language-core/lib/utils.js
var require_utils$3 = __commonJS({ "node_modules/@volar/language-core/lib/utils.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.FileMap = void 0;
	var FileMap = class extends Map {
		constructor(caseSensitive) {
			super();
			this.caseSensitive = caseSensitive;
			this.originalFileNames = /* @__PURE__ */ new Map();
		}
		keys() {
			return this.originalFileNames.values();
		}
		get(key) {
			return super.get(this.normalizeId(key));
		}
		has(key) {
			return super.has(this.normalizeId(key));
		}
		set(key, value) {
			this.originalFileNames.set(this.normalizeId(key), key);
			return super.set(this.normalizeId(key), value);
		}
		delete(key) {
			this.originalFileNames.delete(this.normalizeId(key));
			return super.delete(this.normalizeId(key));
		}
		clear() {
			this.originalFileNames.clear();
			return super.clear();
		}
		normalizeId(id) {
			return this.caseSensitive ? id : id.toLowerCase();
		}
	};
	exports.FileMap = FileMap;
} });

//#endregion
//#region node_modules/@volar/language-core/index.js
var require_language_core$1 = __commonJS({ "node_modules/@volar/language-core/index.js"(exports) {
	var __createBinding$5 = void 0 && (void 0).__createBinding || (Object.create ? function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		var desc = Object.getOwnPropertyDescriptor(m, k);
		if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) desc = {
			enumerable: true,
			get: function() {
				return m[k];
			}
		};
		Object.defineProperty(o, k2, desc);
	} : function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		o[k2] = m[k];
	});
	var __exportStar$4 = void 0 && (void 0).__exportStar || function(m, exports$1) {
		for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p)) __createBinding$5(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.defaultMapperFactory = exports.SourceMap = void 0;
	exports.createLanguage = createLanguage;
	exports.forEachEmbeddedCode = forEachEmbeddedCode;
	var source_map_1 = require_source_map$1();
	Object.defineProperty(exports, "SourceMap", {
		enumerable: true,
		get: function() {
			return source_map_1.SourceMap;
		}
	});
	__exportStar$4(require_editor(), exports);
	__exportStar$4(require_linkedCodeMap(), exports);
	__exportStar$4(require_types$2(), exports);
	__exportStar$4(require_utils$3(), exports);
	const source_map_2 = require_source_map$1();
	const linkedCodeMap_1 = require_linkedCodeMap();
	const defaultMapperFactory = (mappings) => new source_map_2.SourceMap(mappings);
	exports.defaultMapperFactory = defaultMapperFactory;
	function createLanguage(plugins, scriptRegistry, sync, onAssociationDirty) {
		const virtualCodeToSourceScriptMap = /* @__PURE__ */ new WeakMap();
		const virtualCodeToSourceMap = /* @__PURE__ */ new WeakMap();
		const virtualCodeToLinkedCodeMap = /* @__PURE__ */ new WeakMap();
		const language = {
			mapperFactory: exports.defaultMapperFactory,
			plugins,
			scripts: {
				fromVirtualCode(virtualCode) {
					return virtualCodeToSourceScriptMap.get(virtualCode);
				},
				get(id, includeFsFiles = true, shouldRegister = false) {
					sync(id, includeFsFiles, shouldRegister);
					const result = scriptRegistry.get(id);
					if (result?.isAssociationDirty) this.set(id, result.snapshot, result.languageId);
					return scriptRegistry.get(id);
				},
				set(id, snapshot, languageId, _plugins = plugins) {
					if (!languageId) for (const plugin$13 of plugins) {
						languageId = plugin$13.getLanguageId?.(id);
						if (languageId) break;
					}
					if (!languageId) {
						console.warn(`languageId not found for ${id}`);
						return;
					}
					let associatedOnly = false;
					for (const plugin$13 of plugins) if (plugin$13.isAssociatedFileOnly?.(id, languageId)) {
						associatedOnly = true;
						break;
					}
					if (scriptRegistry.has(id)) {
						const sourceScript = scriptRegistry.get(id);
						if (sourceScript.languageId !== languageId || sourceScript.associatedOnly !== associatedOnly) {
							this.delete(id);
							triggerTargetsDirty(sourceScript);
							return this.set(id, snapshot, languageId);
						} else if (associatedOnly) {
							if (sourceScript.snapshot !== snapshot) {
								sourceScript.snapshot = snapshot;
								triggerTargetsDirty(sourceScript);
							}
						} else if (sourceScript.isAssociationDirty || sourceScript.snapshot !== snapshot) {
							if (sourceScript.snapshot !== snapshot) {
								sourceScript.snapshot = snapshot;
								triggerTargetsDirty(sourceScript);
							}
							const codegenCtx = prepareCreateVirtualCode(sourceScript);
							if (sourceScript.generated) {
								const { updateVirtualCode, createVirtualCode } = sourceScript.generated.languagePlugin;
								const newVirtualCode = updateVirtualCode ? updateVirtualCode(id, sourceScript.generated.root, snapshot, codegenCtx) : createVirtualCode?.(id, languageId, snapshot, codegenCtx);
								if (newVirtualCode) {
									sourceScript.generated.root = newVirtualCode;
									sourceScript.generated.embeddedCodes.clear();
									for (const code$1 of forEachEmbeddedCode(sourceScript.generated.root)) {
										virtualCodeToSourceScriptMap.set(code$1, sourceScript);
										sourceScript.generated.embeddedCodes.set(code$1.id, code$1);
									}
									return sourceScript;
								} else {
									this.delete(id);
									return;
								}
							}
						} else return sourceScript;
					} else {
						const sourceScript = {
							id,
							languageId,
							snapshot,
							associatedIds: /* @__PURE__ */ new Set(),
							targetIds: /* @__PURE__ */ new Set(),
							associatedOnly
						};
						scriptRegistry.set(id, sourceScript);
						if (associatedOnly) return sourceScript;
						for (const languagePlugin of _plugins) {
							const virtualCode = languagePlugin.createVirtualCode?.(id, languageId, snapshot, prepareCreateVirtualCode(sourceScript));
							if (virtualCode) {
								sourceScript.generated = {
									root: virtualCode,
									languagePlugin,
									embeddedCodes: /* @__PURE__ */ new Map()
								};
								for (const code$1 of forEachEmbeddedCode(virtualCode)) {
									virtualCodeToSourceScriptMap.set(code$1, sourceScript);
									sourceScript.generated.embeddedCodes.set(code$1.id, code$1);
								}
								break;
							}
						}
						return sourceScript;
					}
				},
				delete(id) {
					const sourceScript = scriptRegistry.get(id);
					if (sourceScript) {
						sourceScript.generated?.languagePlugin.disposeVirtualCode?.(id, sourceScript.generated.root);
						scriptRegistry.delete(id);
						triggerTargetsDirty(sourceScript);
					}
				}
			},
			maps: {
				get(virtualCode, sourceScript) {
					let mapCache = virtualCodeToSourceMap.get(virtualCode.snapshot);
					if (!mapCache) virtualCodeToSourceMap.set(virtualCode.snapshot, mapCache = /* @__PURE__ */ new WeakMap());
					if (!mapCache.has(sourceScript.snapshot)) {
						const mappings = virtualCode.associatedScriptMappings?.get(sourceScript.id) ?? virtualCode.mappings;
						mapCache.set(sourceScript.snapshot, language.mapperFactory(mappings));
					}
					return mapCache.get(sourceScript.snapshot);
				},
				*forEach(virtualCode) {
					const sourceScript = virtualCodeToSourceScriptMap.get(virtualCode);
					yield [sourceScript, this.get(virtualCode, sourceScript)];
					if (virtualCode.associatedScriptMappings) for (const [relatedScriptId] of virtualCode.associatedScriptMappings) {
						const relatedSourceScript = scriptRegistry.get(relatedScriptId);
						if (relatedSourceScript) yield [relatedSourceScript, this.get(virtualCode, relatedSourceScript)];
					}
				}
			},
			linkedCodeMaps: { get(virtualCode) {
				const sourceScript = virtualCodeToSourceScriptMap.get(virtualCode);
				let mapCache = virtualCodeToLinkedCodeMap.get(virtualCode.snapshot);
				if (mapCache?.[0] !== sourceScript.snapshot) virtualCodeToLinkedCodeMap.set(virtualCode.snapshot, mapCache = [sourceScript.snapshot, virtualCode.linkedCodeMappings ? new linkedCodeMap_1.LinkedCodeMap(virtualCode.linkedCodeMappings) : void 0]);
				return mapCache[1];
			} }
		};
		return language;
		function triggerTargetsDirty(sourceScript) {
			sourceScript.targetIds.forEach((id) => {
				const sourceScript$1 = scriptRegistry.get(id);
				if (sourceScript$1) {
					sourceScript$1.isAssociationDirty = true;
					onAssociationDirty?.(sourceScript$1.id);
				}
			});
		}
		function prepareCreateVirtualCode(sourceScript) {
			for (const id of sourceScript.associatedIds) scriptRegistry.get(id)?.targetIds.delete(sourceScript.id);
			sourceScript.associatedIds.clear();
			sourceScript.isAssociationDirty = false;
			return { getAssociatedScript(id) {
				sync(id, true, true);
				const relatedSourceScript = scriptRegistry.get(id);
				if (relatedSourceScript) {
					relatedSourceScript.targetIds.add(sourceScript.id);
					sourceScript.associatedIds.add(relatedSourceScript.id);
				}
				return relatedSourceScript;
			} };
		}
	}
	function* forEachEmbeddedCode(virtualCode) {
		yield virtualCode;
		if (virtualCode.embeddedCodes) for (const embeddedCode of virtualCode.embeddedCodes) yield* forEachEmbeddedCode(embeddedCode);
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/node/dedupe.js
var require_dedupe = __commonJS({ "node_modules/@volar/typescript/lib/node/dedupe.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.dedupeDocumentSpans = dedupeDocumentSpans;
	function dedupeDocumentSpans(items) {
		return dedupe(items, (item) => [
			item.fileName,
			item.textSpan.start,
			item.textSpan.length
		].join(":"));
	}
	function dedupe(items, getKey) {
		const map = /* @__PURE__ */ new Map();
		for (const item of items.reverse()) map.set(getKey(item), item);
		return [...map.values()];
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/node/utils.js
var require_utils$2 = __commonJS({ "node_modules/@volar/typescript/lib/node/utils.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.getServiceScript = getServiceScript;
	function getServiceScript(language, fileName) {
		const sourceScript = language.scripts.get(fileName);
		if (sourceScript?.targetIds.size) for (const targetId of sourceScript.targetIds) {
			const targetScript = language.scripts.get(targetId);
			if (targetScript?.generated) {
				const serviceScript = targetScript.generated.languagePlugin.typescript?.getServiceScript(targetScript.generated.root);
				if (serviceScript) return [
					serviceScript,
					targetScript,
					sourceScript
				];
			}
		}
		if (sourceScript?.associatedOnly) return [
			void 0,
			sourceScript,
			sourceScript
		];
		if (sourceScript?.generated) {
			const serviceScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(sourceScript.generated.root);
			if (serviceScript) return [
				serviceScript,
				sourceScript,
				sourceScript
			];
		}
		return [
			void 0,
			void 0,
			void 0
		];
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/node/transform.js
var require_transform = __commonJS({ "node_modules/@volar/typescript/lib/node/transform.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.transformCallHierarchyItem = transformCallHierarchyItem;
	exports.transformDiagnostic = transformDiagnostic;
	exports.fillSourceFileText = fillSourceFileText;
	exports.transformFileTextChanges = transformFileTextChanges;
	exports.transformDocumentSpan = transformDocumentSpan;
	exports.transformSpan = transformSpan;
	exports.transformTextChange = transformTextChange;
	exports.transformTextSpan = transformTextSpan;
	exports.toSourceOffset = toSourceOffset;
	exports.toSourceRanges = toSourceRanges;
	exports.toSourceOffsets = toSourceOffsets;
	exports.toGeneratedRange = toGeneratedRange;
	exports.toGeneratedRanges = toGeneratedRanges;
	exports.toGeneratedOffset = toGeneratedOffset;
	exports.toGeneratedOffsets = toGeneratedOffsets;
	exports.getMappingOffset = getMappingOffset;
	const language_core_1$13 = require_language_core$1();
	const utils_1$35 = require_utils$2();
	const transformedDiagnostics = /* @__PURE__ */ new WeakMap();
	const transformedSourceFile = /* @__PURE__ */ new WeakSet();
	/**
	* This file contains a number of facilities for transforming `ts.Diagnostic`s returned
	* from the  base TypeScript LanguageService, which reference locations in generated
	* TS code (e.g. the TypeScript codegen'd from the script portion of a .vue file) into locations
	* in the script portion of the .vue file.
	*/
	function transformCallHierarchyItem(language, item, fallbackToAnyMatch, filter$1) {
		const span = transformSpan(language, item.file, item.span, fallbackToAnyMatch, filter$1);
		const selectionSpan = transformSpan(language, item.file, item.selectionSpan, fallbackToAnyMatch, filter$1);
		return {
			...item,
			file: span?.fileName ?? item.file,
			span: span?.textSpan ?? {
				start: 0,
				length: 0
			},
			selectionSpan: selectionSpan?.textSpan ?? {
				start: 0,
				length: 0
			}
		};
	}
	function transformDiagnostic(language, diagnostic, program, isTsc) {
		if (!transformedDiagnostics.has(diagnostic)) {
			transformedDiagnostics.set(diagnostic, void 0);
			const { relatedInformation } = diagnostic;
			if (relatedInformation) diagnostic.relatedInformation = relatedInformation.map((d) => transformDiagnostic(language, d, program, isTsc)).filter((d) => !!d);
			if (diagnostic.file !== void 0 && diagnostic.start !== void 0 && diagnostic.length !== void 0) {
				const [serviceScript] = (0, utils_1$35.getServiceScript)(language, diagnostic.file.fileName);
				if (serviceScript) {
					const [sourceSpanFileName, sourceSpan] = transformTextSpan(void 0, language, serviceScript, {
						start: diagnostic.start,
						length: diagnostic.length
					}, true, (data) => (0, language_core_1$13.shouldReportDiagnostics)(data, String(diagnostic.source), String(diagnostic.code))) ?? [];
					const actualDiagnosticFile = sourceSpanFileName ? diagnostic.file.fileName === sourceSpanFileName ? diagnostic.file : program?.getSourceFile(sourceSpanFileName) : void 0;
					if (sourceSpan && actualDiagnosticFile) {
						if (isTsc) fillSourceFileText(language, diagnostic.file);
						transformedDiagnostics.set(diagnostic, {
							...diagnostic,
							file: actualDiagnosticFile,
							start: sourceSpan.start,
							length: sourceSpan.length
						});
					}
				} else transformedDiagnostics.set(diagnostic, diagnostic);
			} else transformedDiagnostics.set(diagnostic, diagnostic);
		}
		return transformedDiagnostics.get(diagnostic);
	}
	function fillSourceFileText(language, sourceFile) {
		if (transformedSourceFile.has(sourceFile)) return;
		transformedSourceFile.add(sourceFile);
		const [serviceScript] = (0, utils_1$35.getServiceScript)(language, sourceFile.fileName);
		if (serviceScript && !serviceScript.preventLeadingOffset) {
			const sourceScript = language.scripts.fromVirtualCode(serviceScript.code);
			sourceFile.text = sourceScript.snapshot.getText(0, sourceScript.snapshot.getLength()) + sourceFile.text.substring(sourceScript.snapshot.getLength());
		}
	}
	function transformFileTextChanges(language, changes, fallbackToAnyMatch, filter$1) {
		const changesPerFile = {};
		const newFiles = /* @__PURE__ */ new Set();
		for (const fileChanges of changes) {
			const [_, source] = (0, utils_1$35.getServiceScript)(language, fileChanges.fileName);
			if (source) fileChanges.textChanges.forEach((c) => {
				const { fileName, textSpan } = transformSpan(language, fileChanges.fileName, c.span, fallbackToAnyMatch, filter$1) ?? {};
				if (fileName && textSpan) (changesPerFile[fileName] ?? (changesPerFile[fileName] = [])).push({
					...c,
					span: textSpan
				});
			});
			else {
				const list = changesPerFile[fileChanges.fileName] ?? (changesPerFile[fileChanges.fileName] = []);
				fileChanges.textChanges.forEach((c) => {
					list.push(c);
				});
				if (fileChanges.isNewFile) newFiles.add(fileChanges.fileName);
			}
		}
		const result = [];
		for (const fileName in changesPerFile) result.push({
			fileName,
			isNewFile: newFiles.has(fileName),
			textChanges: changesPerFile[fileName]
		});
		return result;
	}
	function transformDocumentSpan(language, documentSpan, fallbackToAnyMatch, filter$1, shouldFallback) {
		let textSpan = transformSpan(language, documentSpan.fileName, documentSpan.textSpan, fallbackToAnyMatch, filter$1);
		if (!textSpan && shouldFallback) textSpan = {
			fileName: documentSpan.fileName,
			textSpan: {
				start: 0,
				length: 0
			}
		};
		if (!textSpan) return;
		const contextSpan = transformSpan(language, documentSpan.fileName, documentSpan.contextSpan, fallbackToAnyMatch, filter$1);
		const originalTextSpan = transformSpan(language, documentSpan.originalFileName, documentSpan.originalTextSpan, fallbackToAnyMatch, filter$1);
		const originalContextSpan = transformSpan(language, documentSpan.originalFileName, documentSpan.originalContextSpan, fallbackToAnyMatch, filter$1);
		return {
			...documentSpan,
			fileName: textSpan.fileName,
			textSpan: textSpan.textSpan,
			contextSpan: contextSpan?.textSpan,
			originalFileName: originalTextSpan?.fileName,
			originalTextSpan: originalTextSpan?.textSpan,
			originalContextSpan: originalContextSpan?.textSpan
		};
	}
	function transformSpan(language, fileName, textSpan, fallbackToAnyMatch, filter$1) {
		if (!fileName || !textSpan) return;
		const [serviceScript] = (0, utils_1$35.getServiceScript)(language, fileName);
		if (serviceScript) {
			const [sourceSpanFileName, sourceSpan] = transformTextSpan(void 0, language, serviceScript, textSpan, fallbackToAnyMatch, filter$1) ?? [];
			if (sourceSpan && sourceSpanFileName) return {
				fileName: sourceSpanFileName,
				textSpan: sourceSpan
			};
		} else return {
			fileName,
			textSpan
		};
	}
	function transformTextChange(sourceScript, language, serviceScript, textChange, fallbackToAnyMatch, filter$1) {
		const [sourceSpanFileName, sourceSpan] = transformTextSpan(sourceScript, language, serviceScript, textChange.span, fallbackToAnyMatch, filter$1) ?? [];
		if (sourceSpan && sourceSpanFileName) return [sourceSpanFileName, {
			newText: textChange.newText,
			span: sourceSpan
		}];
		return void 0;
	}
	function transformTextSpan(sourceScript, language, serviceScript, textSpan, fallbackToAnyMatch, filter$1) {
		const start = textSpan.start;
		const end = textSpan.start + textSpan.length;
		for (const [fileName, sourceStart, sourceEnd] of toSourceRanges(sourceScript, language, serviceScript, start, end, fallbackToAnyMatch, filter$1)) return [fileName, {
			start: sourceStart,
			length: sourceEnd - sourceStart
		}];
	}
	function toSourceOffset(sourceScript, language, serviceScript, position, filter$1) {
		for (const source of toSourceOffsets(sourceScript, language, serviceScript, position, filter$1)) return source;
	}
	function* toSourceRanges(sourceScript, language, serviceScript, start, end, fallbackToAnyMatch, filter$1) {
		if (sourceScript) {
			const map = language.maps.get(serviceScript.code, sourceScript);
			for (const [sourceStart, sourceEnd] of map.toSourceRange(start - getMappingOffset(language, serviceScript), end - getMappingOffset(language, serviceScript), fallbackToAnyMatch, filter$1)) yield [
				sourceScript.id,
				sourceStart,
				sourceEnd
			];
		} else for (const [sourceScript$1, map] of language.maps.forEach(serviceScript.code)) for (const [sourceStart, sourceEnd] of map.toSourceRange(start - getMappingOffset(language, serviceScript), end - getMappingOffset(language, serviceScript), fallbackToAnyMatch, filter$1)) yield [
			sourceScript$1.id,
			sourceStart,
			sourceEnd
		];
	}
	function* toSourceOffsets(sourceScript, language, serviceScript, position, filter$1) {
		if (sourceScript) {
			const map = language.maps.get(serviceScript.code, sourceScript);
			for (const [sourceOffset, mapping] of map.toSourceLocation(position - getMappingOffset(language, serviceScript))) if (filter$1(mapping.data)) yield [sourceScript.id, sourceOffset];
		} else for (const [sourceScript$1, map] of language.maps.forEach(serviceScript.code)) for (const [sourceOffset, mapping] of map.toSourceLocation(position - getMappingOffset(language, serviceScript))) if (filter$1(mapping.data)) yield [sourceScript$1.id, sourceOffset];
	}
	function toGeneratedRange(language, serviceScript, sourceScript, start, end, filter$1) {
		for (const result of toGeneratedRanges(language, serviceScript, sourceScript, start, end, filter$1)) return result;
	}
	function* toGeneratedRanges(language, serviceScript, sourceScript, start, end, filter$1) {
		const map = language.maps.get(serviceScript.code, sourceScript);
		for (const [generateStart, generateEnd] of map.toGeneratedRange(start, end, true, filter$1)) yield [generateStart + getMappingOffset(language, serviceScript), generateEnd + getMappingOffset(language, serviceScript)];
	}
	function toGeneratedOffset(language, serviceScript, sourceScript, position, filter$1) {
		for (const [generateOffset] of toGeneratedOffsets(language, serviceScript, sourceScript, position, filter$1)) return generateOffset;
	}
	function* toGeneratedOffsets(language, serviceScript, sourceScript, position, filter$1) {
		const map = language.maps.get(serviceScript.code, sourceScript);
		for (const [generateOffset, mapping] of map.toGeneratedLocation(position)) if (filter$1(mapping.data)) yield [generateOffset + getMappingOffset(language, serviceScript), mapping];
	}
	function getMappingOffset(language, serviceScript) {
		if (serviceScript.preventLeadingOffset) return 0;
		const sourceScript = language.scripts.fromVirtualCode(serviceScript.code);
		return sourceScript.snapshot.getLength();
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/node/proxyLanguageService.js
var require_proxyLanguageService = __commonJS({ "node_modules/@volar/typescript/lib/node/proxyLanguageService.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createProxyLanguageService = createProxyLanguageService;
	const language_core_1$12 = require_language_core$1();
	const dedupe_1 = require_dedupe();
	const transform_1 = require_transform();
	const utils_1$34 = require_utils$2();
	const windowsPathReg$2 = /\\/g;
	/**
	* Creates and returns a Proxy around the base TypeScript LanguageService.
	*
	* This is used by the Volar TypeScript Plugin (which can be created by `createLanguageServicePlugin`
	* and `createAsyncLanguageServicePlugin`) as an adapter layer between the TypeScript Language Service
	* plugin API (see https://github.com/microsoft/TypeScript/wiki/Writing-a-Language-Service-Plugin)
	* and a Volar `Language`.
	*
	* Once the `initialize` method is called, the proxy will begin intercepting requests and
	* enhancing the default behavior of the LanguageService with enhancements based on
	* the Volar `Language` that has been passed to `initialize`.
	*/
	function createProxyLanguageService(languageService) {
		const proxyCache = /* @__PURE__ */ new Map();
		let getProxyMethod;
		return {
			initialize(language) {
				getProxyMethod = (target$1, p) => {
					switch (p) {
						case "getNavigationTree": return getNavigationTree(language, target$1[p]);
						case "getOutliningSpans": return getOutliningSpans(language, target$1[p]);
						case "getFormattingEditsForDocument": return getFormattingEditsForDocument(language, target$1[p]);
						case "getFormattingEditsForRange": return getFormattingEditsForRange(language, target$1[p]);
						case "getFormattingEditsAfterKeystroke": return getFormattingEditsAfterKeystroke(language, target$1[p]);
						case "getEditsForFileRename": return getEditsForFileRename(language, target$1[p]);
						case "getLinkedEditingRangeAtPosition": return getLinkedEditingRangeAtPosition(language, target$1[p]);
						case "prepareCallHierarchy": return prepareCallHierarchy(language, target$1[p]);
						case "provideCallHierarchyIncomingCalls": return provideCallHierarchyIncomingCalls(language, target$1[p]);
						case "provideCallHierarchyOutgoingCalls": return provideCallHierarchyOutgoingCalls(language, target$1[p]);
						case "organizeImports": return organizeImports(language, target$1[p]);
						case "getQuickInfoAtPosition": return getQuickInfoAtPosition(language, target$1[p]);
						case "getSignatureHelpItems": return getSignatureHelpItems(language, target$1[p]);
						case "getDocumentHighlights": return getDocumentHighlights(language, target$1[p]);
						case "getApplicableRefactors": return getApplicableRefactors(language, target$1[p]);
						case "getEditsForRefactor": return getEditsForRefactor(language, target$1[p]);
						case "getCombinedCodeFix": return getCombinedCodeFix(language, target$1[p]);
						case "getRenameInfo": return getRenameInfo(language, target$1[p]);
						case "getCodeFixesAtPosition": return getCodeFixesAtPosition$1(language, target$1[p]);
						case "getEncodedSemanticClassifications": return getEncodedSemanticClassifications$1(language, target$1[p]);
						case "getSyntacticDiagnostics": return getSyntacticDiagnostics(language, languageService, target$1[p]);
						case "getSemanticDiagnostics": return getSemanticDiagnostics(language, languageService, target$1[p]);
						case "getSuggestionDiagnostics": return getSuggestionDiagnostics(language, languageService, target$1[p]);
						case "getDefinitionAndBoundSpan": return getDefinitionAndBoundSpan$1(language, target$1[p]);
						case "findReferences": return findReferences(language, target$1[p]);
						case "getDefinitionAtPosition": return getDefinitionAtPosition(language, target$1[p]);
						case "getTypeDefinitionAtPosition": return getTypeDefinitionAtPosition(language, target$1[p]);
						case "getImplementationAtPosition": return getImplementationAtPosition(language, target$1[p]);
						case "findRenameLocations": return findRenameLocations(language, target$1[p]);
						case "getReferencesAtPosition": return getReferencesAtPosition(language, target$1[p]);
						case "getCompletionsAtPosition": return getCompletionsAtPosition$1(language, target$1[p]);
						case "getCompletionEntryDetails": return getCompletionEntryDetails$1(language, target$1[p]);
						case "provideInlayHints": return provideInlayHints(language, target$1[p]);
						case "getFileReferences": return getFileReferences(language, target$1[p]);
						case "getNavigateToItems": return getNavigateToItems(language, target$1[p]);
					}
				};
			},
			proxy: new Proxy(languageService, {
				get(target$1, p, receiver) {
					if (getProxyMethod) {
						if (!proxyCache.has(p)) proxyCache.set(p, getProxyMethod(target$1, p));
						const proxyMethod = proxyCache.get(p);
						if (proxyMethod) return proxyMethod;
					}
					return Reflect.get(target$1, p, receiver);
				},
				set(target$1, p, value, receiver) {
					return Reflect.set(target$1, p, value, receiver);
				}
			})
		};
	}
	function getNavigationTree(language, getNavigationTree$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (serviceScript || targetScript?.associatedOnly) {
				const tree = getNavigationTree$1(targetScript.id);
				tree.childItems = void 0;
				return tree;
			} else return getNavigationTree$1(fileName);
		};
	}
	function getOutliningSpans(language, getOutliningSpans$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (serviceScript || targetScript?.associatedOnly) return [];
			else return getOutliningSpans$1(fileName);
		};
	}
	function getFormattingEditsForDocument(language, getFormattingEditsForDocument$1) {
		return (filePath, options) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const map = language.maps.get(serviceScript.code, targetScript);
				if (!map.mappings.some((mapping) => (0, language_core_1$12.isFormattingEnabled)(mapping.data))) return [];
				const edits = getFormattingEditsForDocument$1(targetScript.id, options);
				return edits.map((edit) => (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, false, language_core_1$12.isFormattingEnabled)?.[1]).filter((edit) => !!edit);
			} else return getFormattingEditsForDocument$1(fileName, options);
		};
	}
	function getFormattingEditsForRange(language, getFormattingEditsForRange$1) {
		return (filePath, start, end, options) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const generatedRange = (0, transform_1.toGeneratedRange)(language, serviceScript, sourceScript, start, end, language_core_1$12.isFormattingEnabled);
				if (generatedRange !== void 0) {
					const edits = getFormattingEditsForRange$1(targetScript.id, generatedRange[0], generatedRange[1], options);
					return edits.map((edit) => (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, false, language_core_1$12.isFormattingEnabled)?.[1]).filter((edit) => !!edit);
				}
				return [];
			} else return getFormattingEditsForRange$1(fileName, start, end, options);
		};
	}
	function getFormattingEditsAfterKeystroke(language, getFormattingEditsAfterKeystroke$1) {
		return (filePath, position, key, options) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isFormattingEnabled);
				if (generatePosition !== void 0) {
					const edits = getFormattingEditsAfterKeystroke$1(targetScript.id, generatePosition, key, options);
					return edits.map((edit) => (0, transform_1.transformTextChange)(sourceScript, language, serviceScript, edit, false, language_core_1$12.isFormattingEnabled)?.[1]).filter((edit) => !!edit);
				}
				return [];
			} else return getFormattingEditsAfterKeystroke$1(fileName, position, key, options);
		};
	}
	function getEditsForFileRename(language, getEditsForFileRename$1) {
		return (oldFilePath, newFilePath, formatOptions, preferences) => {
			const edits = getEditsForFileRename$1(oldFilePath, newFilePath, formatOptions, preferences);
			return (0, transform_1.transformFileTextChanges)(language, edits, false, language_core_1$12.isRenameEnabled);
		};
	}
	function getLinkedEditingRangeAtPosition(language, getLinkedEditingRangeAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isLinkedEditingEnabled);
				if (generatePosition !== void 0) {
					const info = getLinkedEditingRangeAtPosition$1(targetScript.id, generatePosition);
					if (info) return {
						ranges: info.ranges.map((span) => (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, span, false, language_core_1$12.isLinkedEditingEnabled)?.[1]).filter((span) => !!span),
						wordPattern: info.wordPattern
					};
				}
			} else return getLinkedEditingRangeAtPosition$1(fileName, position);
		};
	}
	function prepareCallHierarchy(language, prepareCallHierarchy$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isCallHierarchyEnabled);
				if (generatePosition !== void 0) {
					const item = prepareCallHierarchy$1(targetScript.id, generatePosition);
					if (Array.isArray(item)) return item.map((item$1) => (0, transform_1.transformCallHierarchyItem)(language, item$1, true, language_core_1$12.isCallHierarchyEnabled));
					else if (item) return (0, transform_1.transformCallHierarchyItem)(language, item, true, language_core_1$12.isCallHierarchyEnabled);
				}
			} else return prepareCallHierarchy$1(fileName, position);
		};
	}
	function provideCallHierarchyIncomingCalls(language, provideCallHierarchyIncomingCalls$1) {
		return (filePath, position) => {
			let calls = [];
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isCallHierarchyEnabled);
				if (generatePosition !== void 0) calls = provideCallHierarchyIncomingCalls$1(targetScript.id, generatePosition);
			} else calls = provideCallHierarchyIncomingCalls$1(fileName, position);
			return calls.map((call) => {
				const from = (0, transform_1.transformCallHierarchyItem)(language, call.from, true, language_core_1$12.isCallHierarchyEnabled);
				const fromSpans = call.fromSpans.map((span) => (0, transform_1.transformSpan)(language, call.from.file, span, true, language_core_1$12.isCallHierarchyEnabled)?.textSpan).filter((span) => !!span);
				return {
					from,
					fromSpans
				};
			});
		};
	}
	function provideCallHierarchyOutgoingCalls(language, provideCallHierarchyOutgoingCalls$1) {
		return (filePath, position) => {
			let calls = [];
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isCallHierarchyEnabled);
				if (generatePosition !== void 0) calls = provideCallHierarchyOutgoingCalls$1(targetScript.id, generatePosition);
			} else calls = provideCallHierarchyOutgoingCalls$1(fileName, position);
			return calls.map((call) => {
				const to = (0, transform_1.transformCallHierarchyItem)(language, call.to, true, language_core_1$12.isCallHierarchyEnabled);
				const fromSpans = call.fromSpans.map((span) => serviceScript ? (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, span, true, language_core_1$12.isCallHierarchyEnabled)?.[1] : span).filter((span) => !!span);
				return {
					to,
					fromSpans
				};
			});
		};
	}
	function organizeImports(language, organizeImports$1) {
		return (args, formatOptions, preferences) => {
			const unresolved = organizeImports$1(args, formatOptions, preferences);
			return (0, transform_1.transformFileTextChanges)(language, unresolved, false, language_core_1$12.isCodeActionsEnabled);
		};
	}
	function getQuickInfoAtPosition(language, getQuickInfoAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				const infos = [];
				for (const [generatePosition] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1$12.isHoverEnabled)) {
					const info = getQuickInfoAtPosition$1(targetScript.id, generatePosition);
					if (info) {
						const textSpan = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, info.textSpan, true, language_core_1$12.isHoverEnabled)?.[1];
						if (textSpan) infos.push({
							...info,
							textSpan
						});
					}
				}
				if (infos.length === 1) return infos[0];
				else if (infos.length >= 2) {
					const combine = { ...infos[0] };
					combine.displayParts = combine.displayParts?.slice();
					combine.documentation = combine.documentation?.slice();
					combine.tags = combine.tags?.slice();
					const displayPartsStrs = new Set([displayPartsToString(infos[0].displayParts)]);
					const documentationStrs = new Set([displayPartsToString(infos[0].documentation)]);
					const tagsStrs = /* @__PURE__ */ new Set();
					for (const tag of infos[0].tags ?? []) tagsStrs.add(tag.name + "__volar__" + displayPartsToString(tag.text));
					for (let i = 1; i < infos.length; i++) {
						const { displayParts, documentation, tags } = infos[i];
						if (displayParts?.length && !displayPartsStrs.has(displayPartsToString(displayParts))) {
							displayPartsStrs.add(displayPartsToString(displayParts));
							combine.displayParts ??= [];
							combine.displayParts.push({
								...displayParts[0],
								text: "\n\n" + displayParts[0].text
							});
							combine.displayParts.push(...displayParts.slice(1));
						}
						if (documentation?.length && !documentationStrs.has(displayPartsToString(documentation))) {
							documentationStrs.add(displayPartsToString(documentation));
							combine.documentation ??= [];
							combine.documentation.push({
								...documentation[0],
								text: "\n\n" + documentation[0].text
							});
							combine.documentation.push(...documentation.slice(1));
						}
						for (const tag of tags ?? []) if (!tagsStrs.has(tag.name + "__volar__" + displayPartsToString(tag.text))) {
							tagsStrs.add(tag.name + "__volar__" + displayPartsToString(tag.text));
							combine.tags ??= [];
							combine.tags.push(tag);
						}
					}
					return combine;
				}
			} else return getQuickInfoAtPosition$1(fileName, position);
		};
	}
	function getSignatureHelpItems(language, getSignatureHelpItems$1) {
		return (filePath, position, options) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isSignatureHelpEnabled);
				if (generatePosition !== void 0) {
					const result = getSignatureHelpItems$1(targetScript.id, generatePosition, options);
					if (result) {
						const applicableSpan = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, result.applicableSpan, true, language_core_1$12.isSignatureHelpEnabled)?.[1];
						if (applicableSpan) return {
							...result,
							applicableSpan
						};
					}
				}
			} else return getSignatureHelpItems$1(fileName, position, options);
		};
	}
	function getDocumentHighlights(language, getDocumentHighlights$1) {
		return (filePath, position, filesToSearch) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isHighlightEnabled, (fileName$1, position$1) => getDocumentHighlights$1(fileName$1, position$1, filesToSearch), function* (result) {
				for (const ref of result) for (const reference of ref.highlightSpans) yield [reference.fileName ?? ref.fileName, reference.textSpan.start];
			});
			const resolved = unresolved.flat().map((highlights) => {
				return {
					...highlights,
					highlightSpans: highlights.highlightSpans.map((span) => {
						const { textSpan } = (0, transform_1.transformSpan)(language, span.fileName ?? highlights.fileName, span.textSpan, false, language_core_1$12.isHighlightEnabled) ?? {};
						if (textSpan) return {
							...span,
							contextSpan: (0, transform_1.transformSpan)(language, span.fileName ?? highlights.fileName, span.contextSpan, false, language_core_1$12.isHighlightEnabled)?.textSpan,
							textSpan
						};
					}).filter((span) => !!span)
				};
			});
			return resolved;
		};
	}
	function getApplicableRefactors(language, getApplicableRefactors$1) {
		return (filePath, positionOrRange, preferences, triggerReason, kind, includeInteractiveActions) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				if (typeof positionOrRange === "number") {
					const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, positionOrRange, language_core_1$12.isCodeActionsEnabled);
					if (generatePosition !== void 0) return getApplicableRefactors$1(targetScript.id, generatePosition, preferences, triggerReason, kind, includeInteractiveActions);
				} else for (const [generatedStart, generatedEnd] of (0, transform_1.toGeneratedRanges)(language, serviceScript, sourceScript, positionOrRange.pos, positionOrRange.end, language_core_1$12.isCodeActionsEnabled)) return getApplicableRefactors$1(targetScript.id, {
					pos: generatedStart,
					end: generatedEnd
				}, preferences, triggerReason, kind, includeInteractiveActions);
				return [];
			} else return getApplicableRefactors$1(fileName, positionOrRange, preferences, triggerReason, kind, includeInteractiveActions);
		};
	}
	function getEditsForRefactor(language, getEditsForRefactor$1) {
		return (filePath, formatOptions, positionOrRange, refactorName, actionName, preferences, interactiveRefactorArguments) => {
			let edits;
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) if (typeof positionOrRange === "number") {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, positionOrRange, language_core_1$12.isCodeActionsEnabled);
				if (generatePosition !== void 0) edits = getEditsForRefactor$1(targetScript.id, formatOptions, generatePosition, refactorName, actionName, preferences, interactiveRefactorArguments);
			} else for (const [generatedStart, generatedEnd] of (0, transform_1.toGeneratedRanges)(language, serviceScript, sourceScript, positionOrRange.pos, positionOrRange.end, language_core_1$12.isCodeActionsEnabled)) edits = getEditsForRefactor$1(targetScript.id, formatOptions, {
				pos: generatedStart,
				end: generatedEnd
			}, refactorName, actionName, preferences, interactiveRefactorArguments);
			else edits = getEditsForRefactor$1(fileName, formatOptions, positionOrRange, refactorName, actionName, preferences, interactiveRefactorArguments);
			if (edits) {
				edits.edits = (0, transform_1.transformFileTextChanges)(language, edits.edits, false, language_core_1$12.isCodeActionsEnabled);
				return edits;
			}
		};
	}
	function getCombinedCodeFix(language, getCombinedCodeFix$1) {
		return (...args) => {
			const codeActions = getCombinedCodeFix$1(...args);
			codeActions.changes = (0, transform_1.transformFileTextChanges)(language, codeActions.changes, false, language_core_1$12.isCodeActionsEnabled);
			return codeActions;
		};
	}
	function getRenameInfo(language, getRenameInfo$1) {
		return (filePath, position, options) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return {
				canRename: false,
				localizedErrorMessage: "Cannot rename"
			};
			if (serviceScript) {
				let failed;
				for (const [generateOffset] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1$12.isRenameEnabled)) {
					const info = getRenameInfo$1(targetScript.id, generateOffset, options);
					if (info.canRename) {
						const span = (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, info.triggerSpan, false, language_core_1$12.isRenameEnabled)?.[1];
						if (span) {
							info.triggerSpan = span;
							return info;
						}
					} else failed = info;
				}
				if (failed) return failed;
				return {
					canRename: false,
					localizedErrorMessage: "Failed to get rename locations"
				};
			} else return getRenameInfo$1(fileName, position, options);
		};
	}
	function getCodeFixesAtPosition$1(language, getCodeFixesAtPosition$2) {
		return (filePath, start, end, errorCodes, formatOptions, preferences) => {
			let fixes = [];
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const generateRange = (0, transform_1.toGeneratedRange)(language, serviceScript, sourceScript, start, end, language_core_1$12.isCodeActionsEnabled);
				if (generateRange !== void 0) fixes = getCodeFixesAtPosition$2(targetScript.id, generateRange[0], generateRange[1], errorCodes, formatOptions, preferences);
			} else fixes = getCodeFixesAtPosition$2(fileName, start, end, errorCodes, formatOptions, preferences);
			fixes = fixes.map((fix) => {
				fix.changes = (0, transform_1.transformFileTextChanges)(language, fix.changes, false, language_core_1$12.isCodeActionsEnabled);
				return fix;
			});
			return fixes;
		};
	}
	function getEncodedSemanticClassifications$1(language, getEncodedSemanticClassifications$2) {
		return (filePath, span, format) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return {
				spans: [],
				endOfLineState: 0
			};
			if (serviceScript) {
				const map = language.maps.get(serviceScript.code, targetScript);
				const mapped = (0, language_core_1$12.findOverlapCodeRange)(span.start, span.start + span.length, map, language_core_1$12.isSemanticTokensEnabled);
				if (!mapped) return {
					spans: [],
					endOfLineState: 0
				};
				const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript);
				const start = mapped.start + mappingOffset;
				const end = mapped.end + mappingOffset;
				const result = getEncodedSemanticClassifications$2(targetScript.id, {
					start,
					length: end - start
				}, format);
				const spans = [];
				for (let i = 0; i < result.spans.length; i += 3) for (const [_, sourceStart, sourceEnd] of (0, transform_1.toSourceRanges)(sourceScript, language, serviceScript, result.spans[i], result.spans[i] + result.spans[i + 1], false, language_core_1$12.isSemanticTokensEnabled)) {
					spans.push(sourceStart, sourceEnd - sourceStart, result.spans[i + 2]);
					break;
				}
				result.spans = spans;
				return result;
			} else return getEncodedSemanticClassifications$2(fileName, span, format);
		};
	}
	function getSyntacticDiagnostics(language, languageService, getSyntacticDiagnostics$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			return getSyntacticDiagnostics$1(targetScript?.id ?? fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || language.scripts.get(d.file.fileName) === sourceScript);
		};
	}
	function getSemanticDiagnostics(language, languageService, getSemanticDiagnostics$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			return getSemanticDiagnostics$1(targetScript?.id ?? fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || !d.file || language.scripts.get(d.file.fileName) === sourceScript);
		};
	}
	function getSuggestionDiagnostics(language, languageService, getSuggestionDiagnostics$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			return getSuggestionDiagnostics$1(targetScript?.id ?? fileName).map((d) => (0, transform_1.transformDiagnostic)(language, d, languageService.getProgram(), false)).filter((d) => !!d).filter((d) => !serviceScript || !d.file || language.scripts.get(d.file.fileName) === sourceScript);
		};
	}
	function getDefinitionAndBoundSpan$1(language, getDefinitionAndBoundSpan$2) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isDefinitionEnabled, (fileName$1, position$1) => getDefinitionAndBoundSpan$2(fileName$1, position$1), function* (result) {
				for (const ref of result.definitions ?? []) yield [ref.fileName, ref.textSpan.start];
			});
			const textSpan = unresolved.map((s) => (0, transform_1.transformSpan)(language, fileName, s.textSpan, true, language_core_1$12.isDefinitionEnabled)?.textSpan).filter((s) => !!s)[0];
			if (!textSpan) return;
			const definitions = unresolved.map((s) => s.definitions?.map((s$1) => (0, transform_1.transformDocumentSpan)(language, s$1, true, language_core_1$12.isDefinitionEnabled, s$1.fileName !== fileName)).filter((s$1) => !!s$1) ?? []).flat();
			return {
				textSpan,
				definitions: (0, dedupe_1.dedupeDocumentSpans)(definitions)
			};
		};
	}
	function findReferences(language, findReferences$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isReferencesEnabled, (fileName$1, position$1) => findReferences$1(fileName$1, position$1), function* (result) {
				for (const ref of result) for (const reference of ref.references) yield [reference.fileName, reference.textSpan.start];
			});
			const resolved = unresolved.flat().map((symbol) => {
				const definition = (0, transform_1.transformDocumentSpan)(language, symbol.definition, true, language_core_1$12.isDefinitionEnabled, true);
				return {
					definition,
					references: symbol.references.map((r) => (0, transform_1.transformDocumentSpan)(language, r, true, language_core_1$12.isReferencesEnabled)).filter((r) => !!r)
				};
			});
			return resolved;
		};
	}
	function getDefinitionAtPosition(language, getDefinitionAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isDefinitionEnabled, (fileName$1, position$1) => getDefinitionAtPosition$1(fileName$1, position$1), function* (result) {
				for (const ref of result) yield [ref.fileName, ref.textSpan.start];
			});
			const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isDefinitionEnabled, s.fileName !== fileName)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function getTypeDefinitionAtPosition(language, getTypeDefinitionAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isTypeDefinitionEnabled, (fileName$1, position$1) => getTypeDefinitionAtPosition$1(fileName$1, position$1), function* (result) {
				for (const ref of result) yield [ref.fileName, ref.textSpan.start];
			});
			const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isTypeDefinitionEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function getImplementationAtPosition(language, getImplementationAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isImplementationEnabled, (fileName$1, position$1) => getImplementationAtPosition$1(fileName$1, position$1), function* (result) {
				for (const ref of result) yield [ref.fileName, ref.textSpan.start];
			});
			const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isImplementationEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function findRenameLocations(language, findRenameLocations$1) {
		return (filePath, position, findInStrings, findInComments, preferences) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isRenameEnabled, (fileName$1, position$1) => findRenameLocations$1(fileName$1, position$1, findInStrings, findInComments, preferences), function* (result) {
				for (const ref of result) yield [ref.fileName, ref.textSpan.start];
			});
			const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, false, language_core_1$12.isRenameEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function getReferencesAtPosition(language, getReferencesAtPosition$1) {
		return (filePath, position) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = linkedCodeFeatureWorker(language, fileName, position, language_core_1$12.isReferencesEnabled, (fileName$1, position$1) => getReferencesAtPosition$1(fileName$1, position$1), function* (result) {
				for (const ref of result) yield [ref.fileName, ref.textSpan.start];
			});
			const resolved = unresolved.flat().map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isReferencesEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function getCompletionsAtPosition$1(language, getCompletionsAtPosition$2) {
		return (filePath, position, options, formattingSettings) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				let mainResult;
				const additionalResults = [];
				for (const [generatedOffset, mapping] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, language_core_1$12.isCompletionEnabled)) {
					const isAdditional = typeof mapping.data.completion === "object" && mapping.data.completion.isAdditional;
					if (!isAdditional && mainResult?.entries.length) continue;
					const result = getCompletionsAtPosition$2(targetScript.id, generatedOffset, options, formattingSettings);
					if (!result) continue;
					if (typeof mapping.data.completion === "object" && mapping.data.completion.onlyImport) result.entries = result.entries.filter((entry) => !!entry.sourceDisplay);
					for (const entry of result.entries) entry.replacementSpan = entry.replacementSpan && (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, entry.replacementSpan, false, language_core_1$12.isCompletionEnabled)?.[1];
					result.optionalReplacementSpan = result.optionalReplacementSpan && (0, transform_1.transformTextSpan)(sourceScript, language, serviceScript, result.optionalReplacementSpan, false, language_core_1$12.isCompletionEnabled)?.[1];
					if (isAdditional) additionalResults.push(result);
					else mainResult = result;
				}
				const results = additionalResults;
				if (mainResult) results.unshift(mainResult);
				if (results.length) return {
					...results[0],
					entries: results.map((additionalResult) => additionalResult.entries).flat()
				};
			} else return getCompletionsAtPosition$2(fileName, position, options, formattingSettings);
		};
	}
	function getCompletionEntryDetails$1(language, getCompletionEntryDetails$2) {
		return (filePath, position, entryName, formatOptions, source, preferences, data) => {
			let details;
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return void 0;
			if (serviceScript) {
				const generatePosition = (0, transform_1.toGeneratedOffset)(language, serviceScript, sourceScript, position, language_core_1$12.isCompletionEnabled);
				if (generatePosition !== void 0) details = getCompletionEntryDetails$2(targetScript.id, generatePosition, entryName, formatOptions, source, preferences, data);
			} else return getCompletionEntryDetails$2(fileName, position, entryName, formatOptions, source, preferences, data);
			if (details?.codeActions) for (const codeAction of details.codeActions) codeAction.changes = (0, transform_1.transformFileTextChanges)(language, codeAction.changes, false, language_core_1$12.isCompletionEnabled);
			return details;
		};
	}
	function provideInlayHints(language, provideInlayHints$1) {
		return (filePath, span, preferences) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
			if (targetScript?.associatedOnly) return [];
			if (serviceScript) {
				const map = language.maps.get(serviceScript.code, sourceScript);
				const mapped = (0, language_core_1$12.findOverlapCodeRange)(span.start, span.start + span.length, map, language_core_1$12.isSemanticTokensEnabled);
				if (!mapped) return [];
				const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript);
				const start = mapped.start + mappingOffset;
				const end = mapped.end + mappingOffset;
				const result = provideInlayHints$1(targetScript.id, {
					start,
					length: end - start
				}, preferences);
				const hints = [];
				for (const hint of result) {
					const sourcePosition = (0, transform_1.toSourceOffset)(sourceScript, language, serviceScript, hint.position, language_core_1$12.isInlayHintsEnabled);
					if (sourcePosition !== void 0) hints.push({
						...hint,
						position: sourcePosition[1]
					});
				}
				return hints;
			} else return provideInlayHints$1(fileName, span, preferences);
		};
	}
	function getFileReferences(language, getFileReferences$1) {
		return (filePath) => {
			const fileName = filePath.replace(windowsPathReg$2, "/");
			const unresolved = getFileReferences$1(fileName);
			const resolved = unresolved.map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isReferencesEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function getNavigateToItems(language, getNavigateToItems$1) {
		return (...args) => {
			const unresolved = getNavigateToItems$1(...args);
			const resolved = unresolved.map((s) => (0, transform_1.transformDocumentSpan)(language, s, true, language_core_1$12.isReferencesEnabled)).filter((s) => !!s);
			return (0, dedupe_1.dedupeDocumentSpans)(resolved);
		};
	}
	function linkedCodeFeatureWorker(language, fileName, position, filter$1, worker, getLinkedCodes) {
		const results = [];
		const processedFilePositions = /* @__PURE__ */ new Set();
		const [serviceScript, targetScript, sourceScript] = (0, utils_1$34.getServiceScript)(language, fileName);
		if (serviceScript) for (const [generatedOffset] of (0, transform_1.toGeneratedOffsets)(language, serviceScript, sourceScript, position, filter$1)) process$1(targetScript.id, generatedOffset);
		else process$1(fileName, position);
		return results;
		function process$1(fileName$1, position$1) {
			if (processedFilePositions.has(fileName$1 + ":" + position$1)) return;
			processedFilePositions.add(fileName$1 + ":" + position$1);
			const result = worker(fileName$1, position$1);
			if (!result) return;
			results.push(result);
			for (const ref of getLinkedCodes(result)) {
				processedFilePositions.add(ref[0] + ":" + ref[1]);
				const [serviceScript$1] = (0, utils_1$34.getServiceScript)(language, ref[0]);
				if (!serviceScript$1) continue;
				const linkedCodeMap = language.linkedCodeMaps.get(serviceScript$1.code);
				if (!linkedCodeMap) continue;
				const mappingOffset = (0, transform_1.getMappingOffset)(language, serviceScript$1);
				for (const linkedCodeOffset of linkedCodeMap.getLinkedOffsets(ref[1] - mappingOffset)) process$1(ref[0], linkedCodeOffset + mappingOffset);
			}
		}
	}
	function displayPartsToString(displayParts) {
		if (displayParts) return displayParts.map((displayPart) => displayPart.text).join("");
		return "";
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/common.js
var require_common$1 = __commonJS({ "node_modules/@volar/typescript/lib/common.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.resolveFileLanguageId = resolveFileLanguageId;
	function resolveFileLanguageId(path$5) {
		const ext$1 = path$5.split(".").pop();
		switch (ext$1) {
			case "js": return "javascript";
			case "cjs": return "javascript";
			case "mjs": return "javascript";
			case "ts": return "typescript";
			case "cts": return "typescript";
			case "mts": return "typescript";
			case "jsx": return "javascriptreact";
			case "tsx": return "typescriptreact";
			case "json": return "json";
		}
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/resolveModuleName.js
var require_resolveModuleName = __commonJS({ "node_modules/@volar/typescript/lib/resolveModuleName.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createResolveModuleName = createResolveModuleName;
	function createResolveModuleName(ts, getFileSize, host, languagePlugins, getSourceScript) {
		const toSourceFileInfo = /* @__PURE__ */ new Map();
		const moduleResolutionHost = {
			readFile: host.readFile.bind(host),
			directoryExists: host.directoryExists?.bind(host),
			realpath: host.realpath?.bind(host),
			getCurrentDirectory: host.getCurrentDirectory?.bind(host),
			getDirectories: host.getDirectories?.bind(host),
			useCaseSensitiveFileNames: typeof host.useCaseSensitiveFileNames === "function" ? host.useCaseSensitiveFileNames.bind(host) : host.useCaseSensitiveFileNames,
			fileExists(fileName) {
				for (const { typescript: typescript$1 } of languagePlugins) {
					if (!typescript$1) continue;
					for (const { extension } of typescript$1.extraFileExtensions) if (fileName.endsWith(`.d.${extension}.ts`)) {
						const sourceFileName = fileName.slice(0, -`.d.${extension}.ts`.length) + `.${extension}`;
						if (fileExists(sourceFileName)) {
							const sourceScript = getSourceScript(sourceFileName);
							if (sourceScript?.generated) {
								const serviceScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(sourceScript.generated.root);
								if (serviceScript) {
									const dtsPath = sourceFileName + ".d.ts";
									if ((serviceScript.extension === ".js" || serviceScript.extension === ".jsx") && fileExists(dtsPath)) toSourceFileInfo.set(fileName, {
										sourceFileName: dtsPath,
										extension: ".ts"
									});
									else toSourceFileInfo.set(fileName, {
										sourceFileName,
										extension: serviceScript.extension
									});
									return true;
								}
							}
						}
					}
					if (typescript$1.resolveHiddenExtensions && fileName.endsWith(`.d.ts`)) for (const { extension } of typescript$1.extraFileExtensions) {
						const sourceFileName = fileName.slice(0, -`.d.ts`.length) + `.${extension}`;
						if (fileExists(sourceFileName)) {
							const sourceScript = getSourceScript(sourceFileName);
							if (sourceScript?.generated) {
								const serviceScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(sourceScript.generated.root);
								if (serviceScript) {
									toSourceFileInfo.set(fileName, {
										sourceFileName,
										extension: serviceScript.extension
									});
									return true;
								}
							}
						}
					}
				}
				return host.fileExists(fileName);
			}
		};
		return (moduleName, containingFile, compilerOptions, cache, redirectedReference, resolutionMode) => {
			const result = ts.resolveModuleName(moduleName, containingFile, compilerOptions, moduleResolutionHost, cache, redirectedReference, resolutionMode);
			if (result.resolvedModule) {
				const sourceFileInfo = toSourceFileInfo.get(result.resolvedModule.resolvedFileName);
				if (sourceFileInfo) {
					result.resolvedModule.resolvedFileName = sourceFileInfo.sourceFileName;
					result.resolvedModule.extension = sourceFileInfo.extension;
				}
			}
			toSourceFileInfo.clear();
			return result;
		};
		function fileExists(fileName) {
			if (host.fileExists(fileName)) {
				const fileSize = getFileSize?.(fileName) ?? host.readFile(fileName)?.length ?? 0;
				return fileSize < 4 * 1024 * 1024;
			}
			return false;
		}
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/node/decorateLanguageServiceHost.js
var require_decorateLanguageServiceHost = __commonJS({ "node_modules/@volar/typescript/lib/node/decorateLanguageServiceHost.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.decorateLanguageServiceHost = decorateLanguageServiceHost;
	exports.searchExternalFiles = searchExternalFiles;
	const resolveModuleName_1 = require_resolveModuleName();
	function decorateLanguageServiceHost(ts, language, languageServiceHost) {
		const pluginExtensions = language.plugins.map((plugin$13) => plugin$13.typescript?.extraFileExtensions.map((ext$1) => "." + ext$1.extension) ?? []).flat();
		const scripts = /* @__PURE__ */ new Map();
		const crashFileNames = /* @__PURE__ */ new Set();
		const readDirectory = languageServiceHost.readDirectory?.bind(languageServiceHost);
		const resolveModuleNameLiterals = languageServiceHost.resolveModuleNameLiterals?.bind(languageServiceHost);
		const resolveModuleNames = languageServiceHost.resolveModuleNames?.bind(languageServiceHost);
		const getScriptSnapshot = languageServiceHost.getScriptSnapshot.bind(languageServiceHost);
		const getScriptKind = languageServiceHost.getScriptKind?.bind(languageServiceHost);
		if (readDirectory) languageServiceHost.readDirectory = (path$5, extensions, exclude, include, depth) => {
			if (extensions) {
				for (const ext$1 of pluginExtensions) if (!extensions.includes(ext$1)) extensions = [...extensions, ext$1];
			}
			return readDirectory(path$5, extensions, exclude, include, depth);
		};
		if (pluginExtensions.length) {
			const resolveModuleName = (0, resolveModuleName_1.createResolveModuleName)(ts, ts.sys.getFileSize, languageServiceHost, language.plugins, (fileName) => language.scripts.get(fileName));
			const getCanonicalFileName = languageServiceHost.useCaseSensitiveFileNames?.() ? (fileName) => fileName : (fileName) => fileName.toLowerCase();
			const moduleResolutionCache = ts.createModuleResolutionCache(languageServiceHost.getCurrentDirectory(), getCanonicalFileName, languageServiceHost.getCompilationSettings());
			if (resolveModuleNameLiterals) languageServiceHost.resolveModuleNameLiterals = (moduleLiterals, containingFile, redirectedReference, options, containingSourceFile, ...rest) => {
				if (moduleLiterals.every((name) => !pluginExtensions.some((ext$1) => name.text.endsWith(ext$1)))) return resolveModuleNameLiterals(moduleLiterals, containingFile, redirectedReference, options, containingSourceFile, ...rest);
				return moduleLiterals.map((moduleLiteral) => {
					const mode = ts.getModeForUsageLocation(containingSourceFile, moduleLiteral, options);
					return resolveModuleName(moduleLiteral.text, containingFile, options, moduleResolutionCache, redirectedReference, mode);
				});
			};
			if (resolveModuleNames) languageServiceHost.resolveModuleNames = (moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile) => {
				if (moduleNames.every((name) => !pluginExtensions.some((ext$1) => name.endsWith(ext$1)))) return resolveModuleNames(moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile);
				return moduleNames.map((moduleName) => {
					return resolveModuleName(moduleName, containingFile, options, moduleResolutionCache, redirectedReference).resolvedModule;
				});
			};
		}
		languageServiceHost.getScriptSnapshot = (fileName) => {
			const virtualScript = updateVirtualScript(fileName, true);
			if (virtualScript) return virtualScript.snapshot;
			return getScriptSnapshot(fileName);
		};
		if (getScriptKind) languageServiceHost.getScriptKind = (fileName) => {
			const virtualScript = updateVirtualScript(fileName, false);
			if (virtualScript) return virtualScript.scriptKind;
			return getScriptKind(fileName);
		};
		function updateVirtualScript(fileName, shouldRegister) {
			if (crashFileNames.has(fileName)) return;
			let version;
			try {
				version = languageServiceHost.getScriptVersion(fileName);
			} catch {
				crashFileNames.add(fileName);
			}
			if (version === void 0) return;
			let script = scripts.get(fileName);
			if (!script || script[0] !== version) {
				script = [version];
				const sourceScript = language.scripts.get(fileName, void 0, shouldRegister);
				if (sourceScript?.generated) {
					const serviceScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(sourceScript.generated.root);
					if (serviceScript) if (serviceScript.preventLeadingOffset) script[1] = {
						extension: serviceScript.extension,
						scriptKind: serviceScript.scriptKind,
						snapshot: serviceScript.code.snapshot
					};
					else {
						const sourceContents = sourceScript.snapshot.getText(0, sourceScript.snapshot.getLength());
						const virtualContents = sourceContents.split("\n").map((line) => " ".repeat(line.length)).join("\n") + serviceScript.code.snapshot.getText(0, serviceScript.code.snapshot.getLength());
						script[1] = {
							extension: serviceScript.extension,
							scriptKind: serviceScript.scriptKind,
							snapshot: ts.ScriptSnapshot.fromString(virtualContents)
						};
					}
					if (sourceScript.generated.languagePlugin.typescript?.getExtraServiceScripts) console.warn("getExtraServiceScripts() is not available in TS plugin.");
				}
				scripts.set(fileName, script);
			}
			return script[1];
		}
	}
	function searchExternalFiles(ts, project, exts) {
		if (project.projectKind !== ts.server.ProjectKind.Configured) return [];
		const configFile = project.getProjectName();
		const config$1 = ts.readJsonConfigFile(configFile, project.readFile.bind(project));
		const parseHost = {
			useCaseSensitiveFileNames: project.useCaseSensitiveFileNames(),
			fileExists: project.fileExists.bind(project),
			readFile: project.readFile.bind(project),
			readDirectory: (...args) => {
				args[1] = exts;
				return project.readDirectory(...args);
			}
		};
		const parsed = ts.parseJsonSourceFileConfigFileContent(config$1, parseHost, project.getCurrentDirectory());
		return parsed.fileNames;
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/quickstart/languageServicePluginCommon.js
var require_languageServicePluginCommon = __commonJS({ "node_modules/@volar/typescript/lib/quickstart/languageServicePluginCommon.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.makeGetExternalFiles = exports.decoratedLanguageServiceHosts = exports.decoratedLanguageServices = exports.projectExternalFileExtensions = exports.externalFiles = void 0;
	exports.makeGetScriptInfoWithLargeFileFailsafe = makeGetScriptInfoWithLargeFileFailsafe;
	exports.createLanguageCommon = createLanguageCommon;
	exports.isHasAlreadyDecoratedLanguageService = isHasAlreadyDecoratedLanguageService;
	const language_core_1$11 = require_language_core$1();
	const common_1$1 = require_common$1();
	const decorateLanguageServiceHost_1 = require_decorateLanguageServiceHost();
	exports.externalFiles = /* @__PURE__ */ new WeakMap();
	exports.projectExternalFileExtensions = /* @__PURE__ */ new WeakMap();
	exports.decoratedLanguageServices = /* @__PURE__ */ new WeakSet();
	exports.decoratedLanguageServiceHosts = /* @__PURE__ */ new WeakSet();
	/**
	* Wrap `getScriptInfo` to handle large files that may crash the language service.
	*
	* Introduced to fix issues with converting `relatedInformation` (in Diagnostics)
	* when working with large files.
	*
	* https://github.com/volarjs/volar.js/commit/e242709a91e9d2919dc4fa59278dd266fd11e7a3
	*/
	function makeGetScriptInfoWithLargeFileFailsafe(info) {
		return (fileName) => {
			try {
				return info.project.getScriptInfo(fileName);
			} catch {}
		};
	}
	function createLanguageCommon(createPluginResult, ts, info, initializeProxiedLanguageService) {
		const getScriptSnapshot = info.languageServiceHost.getScriptSnapshot.bind(info.languageServiceHost);
		const getScriptInfo = makeGetScriptInfoWithLargeFileFailsafe(info);
		const language = (0, language_core_1$11.createLanguage)([...createPluginResult.languagePlugins, { getLanguageId: common_1$1.resolveFileLanguageId }], new language_core_1$11.FileMap(ts.sys.useCaseSensitiveFileNames), (fileName, _, shouldRegister) => {
			let snapshot;
			if (shouldRegister) snapshot = getScriptSnapshot(fileName);
			else {
				snapshot = getScriptInfo(fileName)?.getSnapshot();
				if (!snapshot) {
					info.project.getScriptVersion(fileName);
					snapshot = getScriptInfo(fileName)?.getSnapshot();
				}
			}
			if (snapshot) language.scripts.set(fileName, snapshot);
			else language.scripts.delete(fileName);
		}, (targetFileName) => {
			info.session.change({
				file: targetFileName,
				line: 1,
				offset: 1,
				endLine: 1,
				endOffset: 1,
				insertString: ""
			});
		});
		initializeProxiedLanguageService(language);
		(0, decorateLanguageServiceHost_1.decorateLanguageServiceHost)(ts, language, info.languageServiceHost);
		createPluginResult.setup?.(language);
	}
	const makeGetExternalFiles = (ts) => (project, updateLevel = 0) => {
		if (updateLevel >= 1 || !exports.externalFiles.has(project)) {
			const oldFiles = exports.externalFiles.get(project);
			const extensions = exports.projectExternalFileExtensions.get(project);
			const newFiles = extensions?.length ? (0, decorateLanguageServiceHost_1.searchExternalFiles)(ts, project, extensions) : [];
			exports.externalFiles.set(project, newFiles);
			if (oldFiles && !arrayItemsEqual(oldFiles, newFiles)) project.refreshDiagnostics();
		}
		return exports.externalFiles.get(project);
	};
	exports.makeGetExternalFiles = makeGetExternalFiles;
	function arrayItemsEqual(a, b) {
		if (a.length !== b.length) return false;
		const set$1 = new Set(a);
		for (const file of b) if (!set$1.has(file)) return false;
		return true;
	}
	function isHasAlreadyDecoratedLanguageService(info) {
		if (exports.decoratedLanguageServices.has(info.languageService) || exports.decoratedLanguageServiceHosts.has(info.languageServiceHost)) return true;
		else {
			exports.decoratedLanguageServices.add(info.languageService);
			exports.decoratedLanguageServiceHosts.add(info.languageServiceHost);
			return false;
		}
	}
} });

//#endregion
//#region node_modules/@volar/typescript/lib/quickstart/createLanguageServicePlugin.js
var require_createLanguageServicePlugin = __commonJS({ "node_modules/@volar/typescript/lib/quickstart/createLanguageServicePlugin.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createLanguageServicePlugin = createLanguageServicePlugin;
	const proxyLanguageService_1 = require_proxyLanguageService();
	const languageServicePluginCommon_1 = require_languageServicePluginCommon();
	/**
	* Creates and returns a TS Service Plugin using Volar primitives.
	*
	* See https://github.com/microsoft/TypeScript/wiki/Writing-a-Language-Service-Plugin for
	* more information.
	*/
	function createLanguageServicePlugin(createPluginCallback) {
		return (modules$1) => {
			const { typescript: ts } = modules$1;
			const pluginModule = {
				create(info) {
					if (!(0, languageServicePluginCommon_1.isHasAlreadyDecoratedLanguageService)(info)) {
						const createPluginResult = createPluginCallback(ts, info);
						const extensions = createPluginResult.languagePlugins.map((plugin$13) => plugin$13.typescript?.extraFileExtensions.map((ext$1) => "." + ext$1.extension) ?? []).flat();
						languageServicePluginCommon_1.projectExternalFileExtensions.set(info.project, extensions);
						const { proxy, initialize } = (0, proxyLanguageService_1.createProxyLanguageService)(info.languageService);
						info.languageService = proxy;
						(0, languageServicePluginCommon_1.createLanguageCommon)(createPluginResult, ts, info, initialize);
					}
					return info.languageService;
				},
				getExternalFiles: (0, languageServicePluginCommon_1.makeGetExternalFiles)(ts)
			};
			return pluginModule;
		};
	}
} });

//#endregion
//#region node_modules/@vue/shared/dist/shared.cjs.prod.js
var require_shared_cjs_prod = __commonJS({ "node_modules/@vue/shared/dist/shared.cjs.prod.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	/*! #__NO_SIDE_EFFECTS__ */
	/* @__NO_SIDE_EFFECTS__ */
	function makeMap$1(str$1) {
		const map = /* @__PURE__ */ Object.create(null);
		for (const key of str$1.split(",")) map[key] = 1;
		return (val) => val in map;
	}
	const EMPTY_OBJ = {};
	const EMPTY_ARR = [];
	const NOOP = () => {};
	const NO = () => false;
	const isOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && (key.charCodeAt(2) > 122 || key.charCodeAt(2) < 97);
	const isModelListener = (key) => key.startsWith("onUpdate:");
	const extend$1 = Object.assign;
	const remove$1 = (arr, el) => {
		const i = arr.indexOf(el);
		if (i > -1) arr.splice(i, 1);
	};
	const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
	const hasOwn$1 = (val, key) => hasOwnProperty$2.call(val, key);
	const isArray$1 = Array.isArray;
	const isMap = (val) => toTypeString(val) === "[object Map]";
	const isSet = (val) => toTypeString(val) === "[object Set]";
	const isDate = (val) => toTypeString(val) === "[object Date]";
	const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
	const isFunction$1 = (val) => typeof val === "function";
	const isString = (val) => typeof val === "string";
	const isSymbol = (val) => typeof val === "symbol";
	const isObject$1 = (val) => val !== null && typeof val === "object";
	const isPromise$1 = (val) => {
		return (isObject$1(val) || isFunction$1(val)) && isFunction$1(val.then) && isFunction$1(val.catch);
	};
	const objectToString = Object.prototype.toString;
	const toTypeString = (value) => objectToString.call(value);
	const toRawType = (value) => {
		return toTypeString(value).slice(8, -1);
	};
	const isPlainObject$1 = (val) => toTypeString(val) === "[object Object]";
	const isIntegerKey = (key) => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
	const isReservedProp = /* @__PURE__ */ makeMap$1(",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted");
	const isBuiltInDirective = /* @__PURE__ */ makeMap$1("bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo");
	const cacheStringFunction = (fn) => {
		const cache = /* @__PURE__ */ Object.create(null);
		return (str$1) => {
			const hit = cache[str$1];
			return hit || (cache[str$1] = fn(str$1));
		};
	};
	const camelizeRE$1 = /-(\w)/g;
	const camelize$1 = cacheStringFunction((str$1) => {
		return str$1.replace(camelizeRE$1, (_, c) => c ? c.toUpperCase() : "");
	});
	const hyphenateRE$1 = /\B([A-Z])/g;
	const hyphenate$1 = cacheStringFunction((str$1) => str$1.replace(hyphenateRE$1, "-$1").toLowerCase());
	const capitalize$1 = cacheStringFunction((str$1) => {
		return str$1.charAt(0).toUpperCase() + str$1.slice(1);
	});
	const toHandlerKey = cacheStringFunction((str$1) => {
		const s = str$1 ? `on${capitalize$1(str$1)}` : ``;
		return s;
	});
	const hasChanged$1 = (value, oldValue) => !Object.is(value, oldValue);
	const invokeArrayFns = (fns, ...arg) => {
		for (let i = 0; i < fns.length; i++) fns[i](...arg);
	};
	const def$1 = (obj, key, value, writable = false) => {
		Object.defineProperty(obj, key, {
			configurable: true,
			enumerable: false,
			writable,
			value
		});
	};
	const looseToNumber = (val) => {
		const n = parseFloat(val);
		return isNaN(n) ? val : n;
	};
	const toNumber$1 = (val) => {
		const n = isString(val) ? Number(val) : NaN;
		return isNaN(n) ? val : n;
	};
	let _globalThis;
	const getGlobalThis = () => {
		return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
	};
	const identRE = /^[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*$/;
	function genPropsAccessExp(name) {
		return identRE.test(name) ? `__props.${name}` : `__props[${JSON.stringify(name)}]`;
	}
	function genCacheKey(source, options) {
		return source + JSON.stringify(options, (_, val) => typeof val === "function" ? val.toString() : val);
	}
	const PatchFlags = {
		"TEXT": 1,
		"1": "TEXT",
		"CLASS": 2,
		"2": "CLASS",
		"STYLE": 4,
		"4": "STYLE",
		"PROPS": 8,
		"8": "PROPS",
		"FULL_PROPS": 16,
		"16": "FULL_PROPS",
		"NEED_HYDRATION": 32,
		"32": "NEED_HYDRATION",
		"STABLE_FRAGMENT": 64,
		"64": "STABLE_FRAGMENT",
		"KEYED_FRAGMENT": 128,
		"128": "KEYED_FRAGMENT",
		"UNKEYED_FRAGMENT": 256,
		"256": "UNKEYED_FRAGMENT",
		"NEED_PATCH": 512,
		"512": "NEED_PATCH",
		"DYNAMIC_SLOTS": 1024,
		"1024": "DYNAMIC_SLOTS",
		"DEV_ROOT_FRAGMENT": 2048,
		"2048": "DEV_ROOT_FRAGMENT",
		"CACHED": -1,
		"-1": "CACHED",
		"BAIL": -2,
		"-2": "BAIL"
	};
	const PatchFlagNames = {
		[1]: `TEXT`,
		[2]: `CLASS`,
		[4]: `STYLE`,
		[8]: `PROPS`,
		[16]: `FULL_PROPS`,
		[32]: `NEED_HYDRATION`,
		[64]: `STABLE_FRAGMENT`,
		[128]: `KEYED_FRAGMENT`,
		[256]: `UNKEYED_FRAGMENT`,
		[512]: `NEED_PATCH`,
		[1024]: `DYNAMIC_SLOTS`,
		[2048]: `DEV_ROOT_FRAGMENT`,
		[-1]: `CACHED`,
		[-2]: `BAIL`
	};
	const ShapeFlags = {
		"ELEMENT": 1,
		"1": "ELEMENT",
		"FUNCTIONAL_COMPONENT": 2,
		"2": "FUNCTIONAL_COMPONENT",
		"STATEFUL_COMPONENT": 4,
		"4": "STATEFUL_COMPONENT",
		"TEXT_CHILDREN": 8,
		"8": "TEXT_CHILDREN",
		"ARRAY_CHILDREN": 16,
		"16": "ARRAY_CHILDREN",
		"SLOTS_CHILDREN": 32,
		"32": "SLOTS_CHILDREN",
		"TELEPORT": 64,
		"64": "TELEPORT",
		"SUSPENSE": 128,
		"128": "SUSPENSE",
		"COMPONENT_SHOULD_KEEP_ALIVE": 256,
		"256": "COMPONENT_SHOULD_KEEP_ALIVE",
		"COMPONENT_KEPT_ALIVE": 512,
		"512": "COMPONENT_KEPT_ALIVE",
		"COMPONENT": 6,
		"6": "COMPONENT"
	};
	const SlotFlags = {
		"STABLE": 1,
		"1": "STABLE",
		"DYNAMIC": 2,
		"2": "DYNAMIC",
		"FORWARDED": 3,
		"3": "FORWARDED"
	};
	const slotFlagsText = {
		[1]: "STABLE",
		[2]: "DYNAMIC",
		[3]: "FORWARDED"
	};
	const GLOBALS_ALLOWED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error,Symbol";
	const isGloballyAllowed = /* @__PURE__ */ makeMap$1(GLOBALS_ALLOWED);
	const isGloballyWhitelisted = isGloballyAllowed;
	const range$2 = 2;
	function generateCodeFrame$1(source, start = 0, end = source.length) {
		start = Math.max(0, Math.min(start, source.length));
		end = Math.max(0, Math.min(end, source.length));
		if (start > end) return "";
		let lines = source.split(/(\r?\n)/);
		const newlineSequences = lines.filter((_, idx) => idx % 2 === 1);
		lines = lines.filter((_, idx) => idx % 2 === 0);
		let count$1 = 0;
		const res = [];
		for (let i = 0; i < lines.length; i++) {
			count$1 += lines[i].length + (newlineSequences[i] && newlineSequences[i].length || 0);
			if (count$1 >= start) {
				for (let j = i - range$2; j <= i + range$2 || end > count$1; j++) {
					if (j < 0 || j >= lines.length) continue;
					const line = j + 1;
					res.push(`${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`);
					const lineLength = lines[j].length;
					const newLineSeqLength = newlineSequences[j] && newlineSequences[j].length || 0;
					if (j === i) {
						const pad = start - (count$1 - (lineLength + newLineSeqLength));
						const length = Math.max(1, end > count$1 ? lineLength - pad : end - start);
						res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
					} else if (j > i) {
						if (end > count$1) {
							const length = Math.max(Math.min(end - count$1, lineLength), 1);
							res.push(`   |  ` + "^".repeat(length));
						}
						count$1 += lineLength + newLineSeqLength;
					}
				}
				break;
			}
		}
		return res.join("\n");
	}
	function normalizeStyle(value) {
		if (isArray$1(value)) {
			const res = {};
			for (let i = 0; i < value.length; i++) {
				const item = value[i];
				const normalized = isString(item) ? parseStringStyle(item) : normalizeStyle(item);
				if (normalized) for (const key in normalized) res[key] = normalized[key];
			}
			return res;
		} else if (isString(value) || isObject$1(value)) return value;
	}
	const listDelimiterRE = /;(?![^(]*\))/g;
	const propertyDelimiterRE = /:([^]+)/;
	const styleCommentRE = /\/\*[^]*?\*\//g;
	function parseStringStyle(cssText) {
		const ret = {};
		cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
			if (item) {
				const tmp = item.split(propertyDelimiterRE);
				tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
			}
		});
		return ret;
	}
	function stringifyStyle(styles) {
		if (!styles) return "";
		if (isString(styles)) return styles;
		let ret = "";
		for (const key in styles) {
			const value = styles[key];
			if (isString(value) || typeof value === "number") {
				const normalizedKey = key.startsWith(`--`) ? key : hyphenate$1(key);
				ret += `${normalizedKey}:${value};`;
			}
		}
		return ret;
	}
	function normalizeClass(value) {
		let res = "";
		if (isString(value)) res = value;
		else if (isArray$1(value)) for (let i = 0; i < value.length; i++) {
			const normalized = normalizeClass(value[i]);
			if (normalized) res += normalized + " ";
		}
		else if (isObject$1(value)) {
			for (const name in value) if (value[name]) res += name + " ";
		}
		return res.trim();
	}
	function normalizeProps$1(props) {
		if (!props) return null;
		let { class: klass$1, style: style$1 } = props;
		if (klass$1 && !isString(klass$1)) props.class = normalizeClass(klass$1);
		if (style$1) props.style = normalizeStyle(style$1);
		return props;
	}
	const HTML_TAGS = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
	const SVG_TAGS = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
	const MATH_TAGS = "annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics";
	const VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
	const isHTMLTag$1 = /* @__PURE__ */ makeMap$1(HTML_TAGS);
	const isSVGTag = /* @__PURE__ */ makeMap$1(SVG_TAGS);
	const isMathMLTag = /* @__PURE__ */ makeMap$1(MATH_TAGS);
	const isVoidTag = /* @__PURE__ */ makeMap$1(VOID_TAGS);
	const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
	const isSpecialBooleanAttr = /* @__PURE__ */ makeMap$1(specialBooleanAttrs);
	const isBooleanAttr$1 = /* @__PURE__ */ makeMap$1(specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected`);
	function includeBooleanAttr(value) {
		return !!value || value === "";
	}
	const unsafeAttrCharRE = /[>/="'\u0009\u000a\u000c\u0020]/;
	const attrValidationCache = {};
	function isSSRSafeAttrName(name) {
		if (attrValidationCache.hasOwnProperty(name)) return attrValidationCache[name];
		const isUnsafe = unsafeAttrCharRE.test(name);
		if (isUnsafe) console.error(`unsafe attribute name: ${name}`);
		return attrValidationCache[name] = !isUnsafe;
	}
	const propsToAttrMap$1 = {
		acceptCharset: "accept-charset",
		className: "class",
		htmlFor: "for",
		httpEquiv: "http-equiv"
	};
	const isKnownHtmlAttr = /* @__PURE__ */ makeMap$1(`accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap`);
	const isKnownSvgAttr = /* @__PURE__ */ makeMap$1(`xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`);
	const isKnownMathMLAttr = /* @__PURE__ */ makeMap$1(`accent,accentunder,actiontype,align,alignmentscope,altimg,altimg-height,altimg-valign,altimg-width,alttext,bevelled,close,columnsalign,columnlines,columnspan,denomalign,depth,dir,display,displaystyle,encoding,equalcolumns,equalrows,fence,fontstyle,fontweight,form,frame,framespacing,groupalign,height,href,id,indentalign,indentalignfirst,indentalignlast,indentshift,indentshiftfirst,indentshiftlast,indextype,justify,largetop,largeop,lquote,lspace,mathbackground,mathcolor,mathsize,mathvariant,maxsize,minlabelspacing,mode,other,overflow,position,rowalign,rowlines,rowspan,rquote,rspace,scriptlevel,scriptminsize,scriptsizemultiplier,selection,separator,separators,shift,side,src,stackalign,stretchy,subscriptshift,superscriptshift,symmetric,voffset,width,widths,xlink:href,xlink:show,xlink:type,xmlns`);
	function isRenderableAttrValue(value) {
		if (value == null) return false;
		const type = typeof value;
		return type === "string" || type === "number" || type === "boolean";
	}
	const escapeRE = /["'&<>]/;
	function escapeHtml(string) {
		const str$1 = "" + string;
		const match$1 = escapeRE.exec(str$1);
		if (!match$1) return str$1;
		let html$1 = "";
		let escaped;
		let index$1;
		let lastIndex = 0;
		for (index$1 = match$1.index; index$1 < str$1.length; index$1++) {
			switch (str$1.charCodeAt(index$1)) {
				case 34:
					escaped = "&quot;";
					break;
				case 38:
					escaped = "&amp;";
					break;
				case 39:
					escaped = "&#39;";
					break;
				case 60:
					escaped = "&lt;";
					break;
				case 62:
					escaped = "&gt;";
					break;
				default: continue;
			}
			if (lastIndex !== index$1) html$1 += str$1.slice(lastIndex, index$1);
			lastIndex = index$1 + 1;
			html$1 += escaped;
		}
		return lastIndex !== index$1 ? html$1 + str$1.slice(lastIndex, index$1) : html$1;
	}
	const commentStripRE = /^-?>|<!--|-->|--!>|<!-$/g;
	function escapeHtmlComment(src) {
		return src.replace(commentStripRE, "");
	}
	const cssVarNameEscapeSymbolsRE = /[ !"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g;
	function getEscapedCssVarName(key, doubleEscape) {
		return key.replace(cssVarNameEscapeSymbolsRE, (s) => doubleEscape ? s === "\"" ? "\\\\\\\"" : `\\\\${s}` : `\\${s}`);
	}
	function looseCompareArrays(a, b) {
		if (a.length !== b.length) return false;
		let equal = true;
		for (let i = 0; equal && i < a.length; i++) equal = looseEqual$1(a[i], b[i]);
		return equal;
	}
	function looseEqual$1(a, b) {
		if (a === b) return true;
		let aValidType = isDate(a);
		let bValidType = isDate(b);
		if (aValidType || bValidType) return aValidType && bValidType ? a.getTime() === b.getTime() : false;
		aValidType = isSymbol(a);
		bValidType = isSymbol(b);
		if (aValidType || bValidType) return a === b;
		aValidType = isArray$1(a);
		bValidType = isArray$1(b);
		if (aValidType || bValidType) return aValidType && bValidType ? looseCompareArrays(a, b) : false;
		aValidType = isObject$1(a);
		bValidType = isObject$1(b);
		if (aValidType || bValidType) {
			if (!aValidType || !bValidType) return false;
			const aKeysCount = Object.keys(a).length;
			const bKeysCount = Object.keys(b).length;
			if (aKeysCount !== bKeysCount) return false;
			for (const key in a) {
				const aHasKey = a.hasOwnProperty(key);
				const bHasKey = b.hasOwnProperty(key);
				if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual$1(a[key], b[key])) return false;
			}
		}
		return String(a) === String(b);
	}
	function looseIndexOf$1(arr, val) {
		return arr.findIndex((item) => looseEqual$1(item, val));
	}
	const isRef$1 = (val) => {
		return !!(val && val["__v_isRef"] === true);
	};
	const toDisplayString = (val) => {
		return isString(val) ? val : val == null ? "" : isArray$1(val) || isObject$1(val) && (val.toString === objectToString || !isFunction$1(val.toString)) ? isRef$1(val) ? toDisplayString(val.value) : JSON.stringify(val, replacer$1, 2) : String(val);
	};
	const replacer$1 = (_key, val) => {
		if (isRef$1(val)) return replacer$1(_key, val.value);
		else if (isMap(val)) return { [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2], i) => {
			entries[stringifySymbol(key, i) + " =>"] = val2;
			return entries;
		}, {}) };
		else if (isSet(val)) return { [`Set(${val.size})`]: [...val.values()].map((v) => stringifySymbol(v)) };
		else if (isSymbol(val)) return stringifySymbol(val);
		else if (isObject$1(val) && !isArray$1(val) && !isPlainObject$1(val)) return String(val);
		return val;
	};
	const stringifySymbol = (v, i = "") => {
		var _a$1;
		return isSymbol(v) ? `Symbol(${(_a$1 = v.description) != null ? _a$1 : i})` : v;
	};
	exports.EMPTY_ARR = EMPTY_ARR;
	exports.EMPTY_OBJ = EMPTY_OBJ;
	exports.NO = NO;
	exports.NOOP = NOOP;
	exports.PatchFlagNames = PatchFlagNames;
	exports.PatchFlags = PatchFlags;
	exports.ShapeFlags = ShapeFlags;
	exports.SlotFlags = SlotFlags;
	exports.camelize = camelize$1;
	exports.capitalize = capitalize$1;
	exports.cssVarNameEscapeSymbolsRE = cssVarNameEscapeSymbolsRE;
	exports.def = def$1;
	exports.escapeHtml = escapeHtml;
	exports.escapeHtmlComment = escapeHtmlComment;
	exports.extend = extend$1;
	exports.genCacheKey = genCacheKey;
	exports.genPropsAccessExp = genPropsAccessExp;
	exports.generateCodeFrame = generateCodeFrame$1;
	exports.getEscapedCssVarName = getEscapedCssVarName;
	exports.getGlobalThis = getGlobalThis;
	exports.hasChanged = hasChanged$1;
	exports.hasOwn = hasOwn$1;
	exports.hyphenate = hyphenate$1;
	exports.includeBooleanAttr = includeBooleanAttr;
	exports.invokeArrayFns = invokeArrayFns;
	exports.isArray = isArray$1;
	exports.isBooleanAttr = isBooleanAttr$1;
	exports.isBuiltInDirective = isBuiltInDirective;
	exports.isDate = isDate;
	exports.isFunction = isFunction$1;
	exports.isGloballyAllowed = isGloballyAllowed;
	exports.isGloballyWhitelisted = isGloballyWhitelisted;
	exports.isHTMLTag = isHTMLTag$1;
	exports.isIntegerKey = isIntegerKey;
	exports.isKnownHtmlAttr = isKnownHtmlAttr;
	exports.isKnownMathMLAttr = isKnownMathMLAttr;
	exports.isKnownSvgAttr = isKnownSvgAttr;
	exports.isMap = isMap;
	exports.isMathMLTag = isMathMLTag;
	exports.isModelListener = isModelListener;
	exports.isObject = isObject$1;
	exports.isOn = isOn;
	exports.isPlainObject = isPlainObject$1;
	exports.isPromise = isPromise$1;
	exports.isRegExp = isRegExp;
	exports.isRenderableAttrValue = isRenderableAttrValue;
	exports.isReservedProp = isReservedProp;
	exports.isSSRSafeAttrName = isSSRSafeAttrName;
	exports.isSVGTag = isSVGTag;
	exports.isSet = isSet;
	exports.isSpecialBooleanAttr = isSpecialBooleanAttr;
	exports.isString = isString;
	exports.isSymbol = isSymbol;
	exports.isVoidTag = isVoidTag;
	exports.looseEqual = looseEqual$1;
	exports.looseIndexOf = looseIndexOf$1;
	exports.looseToNumber = looseToNumber;
	exports.makeMap = makeMap$1;
	exports.normalizeClass = normalizeClass;
	exports.normalizeProps = normalizeProps$1;
	exports.normalizeStyle = normalizeStyle;
	exports.objectToString = objectToString;
	exports.parseStringStyle = parseStringStyle;
	exports.propsToAttrMap = propsToAttrMap$1;
	exports.remove = remove$1;
	exports.slotFlagsText = slotFlagsText;
	exports.stringifyStyle = stringifyStyle;
	exports.toDisplayString = toDisplayString;
	exports.toHandlerKey = toHandlerKey;
	exports.toNumber = toNumber$1;
	exports.toRawType = toRawType;
	exports.toTypeString = toTypeString;
} });

//#endregion
//#region node_modules/@vue/shared/index.js
var require_shared$2 = __commonJS({ "node_modules/@vue/shared/index.js"(exports, module) {
	module.exports = require_shared_cjs_prod();
} });

//#endregion
//#region node_modules/@vue/language-core/lib/utils/shared.js
var require_shared$1 = __commonJS({ "node_modules/@vue/language-core/lib/utils/shared.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.hyphenateTag = void 0;
	exports.hyphenateAttr = hyphenateAttr;
	exports.getSlotsPropertyName = getSlotsPropertyName;
	exports.getStartEnd = getStartEnd;
	exports.getNodeText = getNodeText;
	const shared_1$27 = require_shared$2();
	var shared_2$4 = require_shared$2();
	Object.defineProperty(exports, "hyphenateTag", {
		enumerable: true,
		get: function() {
			return shared_2$4.hyphenate;
		}
	});
	function hyphenateAttr(str$1) {
		let hyphencase = (0, shared_1$27.hyphenate)(str$1);
		if (str$1.length && str$1[0] !== str$1[0].toLowerCase()) hyphencase = "-" + hyphencase;
		return hyphencase;
	}
	function getSlotsPropertyName(vueVersion) {
		return vueVersion < 3 ? "$scopedSlots" : "$slots";
	}
	function getStartEnd(ts, node, ast) {
		return {
			start: ts.getTokenPosOfNode(node, ast),
			end: node.end
		};
	}
	function getNodeText(ts, node, ast) {
		const { start, end } = getStartEnd(ts, node, ast);
		return ast.text.slice(start, end);
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/globalTypes.js
var require_globalTypes = __commonJS({ "node_modules/@vue/language-core/lib/codegen/globalTypes.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.getGlobalTypesFileName = getGlobalTypesFileName;
	exports.generateGlobalTypes = generateGlobalTypes;
	const shared_1$26 = require_shared$1();
	function getGlobalTypesFileName({ lib, target: target$1, checkUnknownProps, checkUnknownEvents, checkUnknownComponents }) {
		return [
			lib,
			target$1,
			checkUnknownProps,
			checkUnknownEvents,
			checkUnknownComponents
		].map((v) => typeof v === "boolean" ? Number(v) : v).join("_") + ".d.ts";
	}
	function generateGlobalTypes({ lib, target: target$1, checkUnknownProps, checkUnknownEvents, checkUnknownComponents }) {
		const fnPropsType = `(T extends { $props: infer Props } ? Props : {})${checkUnknownProps ? "" : " & Record<string, unknown>"}`;
		let text$1 = ``;
		if (target$1 < 3.5) text$1 += `
; declare module '${lib}' {
	export interface GlobalComponents { }
	export interface GlobalDirectives { }
}`;
		text$1 += `
; declare global {
	const __VLS_directiveBindingRestFields: { instance: null, oldValue: null, modifiers: any, dir: any };
	const __VLS_unref: typeof import('${lib}').unref;
	const __VLS_placeholder: any;

	type __VLS_NativeElements = __VLS_SpreadMerge<SVGElementTagNameMap, HTMLElementTagNameMap>;
	type __VLS_IntrinsicElements = ${target$1 >= 3.3 ? `import('${lib}/jsx-runtime').JSX.IntrinsicElements;` : `globalThis.JSX.IntrinsicElements;`}
	type __VLS_Element = ${target$1 >= 3.3 ? `import('${lib}/jsx-runtime').JSX.Element;` : `globalThis.JSX.Element;`}
	type __VLS_GlobalComponents = ${target$1 >= 3.5 ? `import('${lib}').GlobalComponents;` : `import('${lib}').GlobalComponents & Pick<typeof import('${lib}'), 'Transition' | 'TransitionGroup' | 'KeepAlive' | 'Suspense' | 'Teleport'>;`}
	type __VLS_GlobalDirectives = import('${lib}').GlobalDirectives;
	type __VLS_IsAny<T> = 0 extends 1 & T ? true : false;
	type __VLS_PickNotAny<A, B> = __VLS_IsAny<A> extends true ? B : A;
	type __VLS_SpreadMerge<A, B> = Omit<A, keyof B> & B;
	type __VLS_WithComponent<N0 extends string, LocalComponents, Self, N1 extends string, N2 extends string, N3 extends string> =
		N1 extends keyof LocalComponents ? N1 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : { [K in N0]: LocalComponents[N1] } :
		N2 extends keyof LocalComponents ? N2 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : { [K in N0]: LocalComponents[N2] } :
		N3 extends keyof LocalComponents ? N3 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : { [K in N0]: LocalComponents[N3] } :
		Self extends object ? { [K in N0]: Self } :
		N1 extends keyof __VLS_GlobalComponents ? N1 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : { [K in N0]: __VLS_GlobalComponents[N1] } :
		N2 extends keyof __VLS_GlobalComponents ? N2 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : { [K in N0]: __VLS_GlobalComponents[N2] } :
		N3 extends keyof __VLS_GlobalComponents ? N3 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : { [K in N0]: __VLS_GlobalComponents[N3] } :
		${checkUnknownComponents ? "{}" : "{ [K in N0]: unknown }"};
	type __VLS_FunctionalComponentCtx<T, K> = __VLS_PickNotAny<'__ctx' extends keyof __VLS_PickNotAny<K, {}>
		? K extends { __ctx?: infer Ctx } ? NonNullable<Ctx> : never : any
		, T extends (props: any, ctx: infer Ctx) => any ? Ctx : any
	>;
	type __VLS_FunctionalComponentProps<T, K> = '__ctx' extends keyof __VLS_PickNotAny<K, {}>
		? K extends { __ctx?: { props?: infer P } } ? NonNullable<P> : never
		: T extends (props: infer P, ...args: any) => any ? P
		: {};
	type __VLS_FunctionalComponent<T> = (props: ${fnPropsType}, ctx?: any) => __VLS_Element & {
		__ctx?: {
			attrs?: any,
			slots?: T extends { ${(0, shared_1$26.getSlotsPropertyName)(target$1)}: infer Slots } ? Slots : Record<string, any>,
			emit?: T extends { $emit: infer Emit } ? Emit : {},
			props?: ${fnPropsType},
			expose?: (exposed: T) => void,
		}
	};
	type __VLS_NormalizeSlotReturns<S, R = NonNullable<S> extends (...args: any) => infer K ? K : any> = R extends any[] ? {
		[K in keyof R]: R[K] extends infer V
			? V extends Element ? V
			: V extends new (...args: any) => infer R ? ReturnType<__VLS_FunctionalComponent<R>>
			: V extends (...args: any) => infer R ? R
			: any
			: never
	} : R;
	type __VLS_IsFunction<T, K> = K extends keyof T
		? __VLS_IsAny<T[K]> extends false
		? unknown extends T[K]
		? false
		: true
		: false
		: false;
	type __VLS_NormalizeComponentEvent<Props, Emits, onEvent extends keyof Props, Event extends keyof Emits, CamelizedEvent extends keyof Emits> = (
		__VLS_IsFunction<Props, onEvent> extends true
			? Props
			: __VLS_IsFunction<Emits, Event> extends true
				? { [K in onEvent]?: Emits[Event] }
				: __VLS_IsFunction<Emits, CamelizedEvent> extends true
					? { [K in onEvent]?: Emits[CamelizedEvent] }
					: Props
	)${checkUnknownEvents ? "" : " & Record<string, unknown>"};
	// fix https://github.com/vuejs/language-tools/issues/926
	type __VLS_UnionToIntersection<U> = (U extends unknown ? (arg: U) => unknown : never) extends ((arg: infer P) => unknown) ? P : never;
	type __VLS_OverloadUnionInner<T, U = unknown> = U & T extends (...args: infer A) => infer R
		? U extends T
		? never
		: __VLS_OverloadUnionInner<T, Pick<T, keyof T> & U & ((...args: A) => R)> | ((...args: A) => R)
		: never;
	type __VLS_OverloadUnion<T> = Exclude<
		__VLS_OverloadUnionInner<(() => never) & T>,
		T extends () => never ? never : () => never
	>;
	type __VLS_ConstructorOverloads<T> = __VLS_OverloadUnion<T> extends infer F
		? F extends (event: infer E, ...args: infer A) => any
		? { [K in E & string]: (...args: A) => void; }
		: never
		: never;
	type __VLS_NormalizeEmits<T> = __VLS_PrettifyGlobal<
		__VLS_UnionToIntersection<
			__VLS_ConstructorOverloads<T> & {
				[K in keyof T]: T[K] extends any[] ? { (...args: T[K]): void } : never
			}
		>
	>;
	type __VLS_ResolveEmits<
		Comp,
		Emits,
		TypeEmits = ${target$1 >= 3.6 ? `Comp extends { __typeEmits?: infer T } ? unknown extends T ? {} : import('${lib}').ShortEmitsToObject<T> : {}` : `{}`},
		NormalizedEmits = __VLS_NormalizeEmits<Emits> extends infer E ? string extends keyof E ? {} : E : never,
	> = __VLS_SpreadMerge<NormalizedEmits, TypeEmits>;
	type __VLS_ResolveDirectives<T> = {
		[K in Exclude<keyof T, keyof __VLS_GlobalDirectives> & string as \`v\${Capitalize<K>}\`]: T[K];
	};
	type __VLS_PrettifyGlobal<T> = { [K in keyof T as K]: T[K]; } & {};
	type __VLS_UseTemplateRef<T> = Readonly<import('${lib}').ShallowRef<T | null>>;

	function __VLS_getVForSourceType<T extends number | string | any[] | Iterable<any>>(source: T): [
		item: T extends number ? number
			: T extends string ? string
			: T extends any[] ? T[number]
			: T extends Iterable<infer T1> ? T1
			: any,
		index: number,
	][];
	function __VLS_getVForSourceType<T>(source: T): [
		item: T[keyof T],
		key: keyof T,
		index: number,
	][];
	function __VLS_getSlotParameters<S, D extends S>(slot: S, decl?: D):
		__VLS_PickNotAny<NonNullable<D>, (...args: any) => any> extends (...args: infer P) => any ? P : any[];
	function __VLS_asFunctionalDirective<T>(dir: T): T extends import('${lib}').ObjectDirective
		? NonNullable<T['created' | 'beforeMount' | 'mounted' | 'beforeUpdate' | 'updated' | 'beforeUnmount' | 'unmounted']>
		: T extends (...args: any) => any
			? T
			: (arg1: unknown, arg2: unknown, arg3: unknown, arg4: unknown) => void;
	function __VLS_makeOptional<T>(t: T): { [K in keyof T]?: T[K] };
	function __VLS_asFunctionalComponent<T, K = T extends new (...args: any) => any ? InstanceType<T> : unknown>(t: T, instance?: K):
		T extends new (...args: any) => any ? __VLS_FunctionalComponent<K>
		: T extends () => any ? (props: {}, ctx?: any) => ReturnType<T>${target$1 === 2.7 ? `: T extends import('${lib}').AsyncComponent ? (props: {}, ctx?: any) => any` : ``}
		: T extends (...args: any) => any ? T
		: __VLS_FunctionalComponent<{}>;
	function __VLS_functionalComponentArgsRest<T extends (...args: any) => any>(t: T): 2 extends Parameters<T>['length'] ? [any] : [];
	function __VLS_asFunctionalElement<T>(tag: T, endTag?: T): (attrs: T${checkUnknownComponents ? "" : " & Record<string, unknown>"}) => void;
	function __VLS_asFunctionalSlot<S>(slot: S): S extends () => infer R ? (props: {}) => R : NonNullable<S>;
	function __VLS_tryAsConstant<const T>(t: T): T;
}
`;
		return text$1;
	}
} });

//#endregion
//#region node_modules/entities/lib/generated/decode-data-html.js
var require_decode_data_html = __commonJS({ "node_modules/entities/lib/generated/decode-data-html.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = new Uint16Array("ᵁ<Õıʊҝջאٵ۞ޢߖࠏ੊ઑඡ๭༉༦჊ረዡᐕᒝᓃᓟᔥ\0\0\0\0\0\0ᕫᛍᦍᰒᷝ὾⁠↰⊍⏀⏻⑂⠤⤒ⴈ⹈⿎〖㊺㘹㞬㣾㨨㩱㫠㬮ࠀEMabcfglmnoprstu\\bfms¦³¹ÈÏlig耻Æ䃆P耻&䀦cute耻Á䃁reve;䄂Āiyx}rc耻Â䃂;䐐r;쀀𝔄rave耻À䃀pha;䎑acr;䄀d;橓Āgp¡on;䄄f;쀀𝔸plyFunction;恡ing耻Å䃅Ācs¾Ãr;쀀𝒜ign;扔ilde耻Ã䃃ml耻Ä䃄ЀaceforsuåûþėĜĢħĪĀcrêòkslash;或Ŷöø;櫧ed;挆y;䐑ƀcrtąċĔause;戵noullis;愬a;䎒r;쀀𝔅pf;쀀𝔹eve;䋘còēmpeq;扎܀HOacdefhilorsuōőŖƀƞƢƵƷƺǜȕɳɸɾcy;䐧PY耻©䂩ƀcpyŝŢźute;䄆Ā;iŧŨ拒talDifferentialD;慅leys;愭ȀaeioƉƎƔƘron;䄌dil耻Ç䃇rc;䄈nint;戰ot;䄊ĀdnƧƭilla;䂸terDot;䂷òſi;䎧rcleȀDMPTǇǋǑǖot;抙inus;抖lus;投imes;抗oĀcsǢǸkwiseContourIntegral;戲eCurlyĀDQȃȏoubleQuote;思uote;怙ȀlnpuȞȨɇɕonĀ;eȥȦ户;橴ƀgitȯȶȺruent;扡nt;戯ourIntegral;戮ĀfrɌɎ;愂oduct;成nterClockwiseContourIntegral;戳oss;樯cr;쀀𝒞pĀ;Cʄʅ拓ap;才րDJSZacefiosʠʬʰʴʸˋ˗ˡ˦̳ҍĀ;oŹʥtrahd;椑cy;䐂cy;䐅cy;䐏ƀgrsʿ˄ˇger;怡r;憡hv;櫤Āayː˕ron;䄎;䐔lĀ;t˝˞戇a;䎔r;쀀𝔇Āaf˫̧Ācm˰̢riticalȀADGT̖̜̀̆cute;䂴oŴ̋̍;䋙bleAcute;䋝rave;䁠ilde;䋜ond;拄ferentialD;慆Ѱ̽\0\0\0͔͂\0Ѕf;쀀𝔻ƀ;DE͈͉͍䂨ot;惜qual;扐blèCDLRUVͣͲ΂ϏϢϸontourIntegraìȹoɴ͹\0\0ͻ»͉nArrow;懓Āeo·ΤftƀARTΐΖΡrrow;懐ightArrow;懔eåˊngĀLRΫτeftĀARγιrrow;柸ightArrow;柺ightArrow;柹ightĀATϘϞrrow;懒ee;抨pɁϩ\0\0ϯrrow;懑ownArrow;懕erticalBar;戥ǹABLRTaВЪаўѿͼrrowƀ;BUНОТ憓ar;椓pArrow;懵reve;䌑eft˒к\0ц\0ѐightVector;楐eeVector;楞ectorĀ;Bљњ憽ar;楖ightǔѧ\0ѱeeVector;楟ectorĀ;BѺѻ懁ar;楗eeĀ;A҆҇护rrow;憧ĀctҒҗr;쀀𝒟rok;䄐ࠀNTacdfglmopqstuxҽӀӄӋӞӢӧӮӵԡԯԶՒ՝ՠեG;䅊H耻Ð䃐cute耻É䃉ƀaiyӒӗӜron;䄚rc耻Ê䃊;䐭ot;䄖r;쀀𝔈rave耻È䃈ement;戈ĀapӺӾcr;䄒tyɓԆ\0\0ԒmallSquare;旻erySmallSquare;斫ĀgpԦԪon;䄘f;쀀𝔼silon;䎕uĀaiԼՉlĀ;TՂՃ橵ilde;扂librium;懌Āci՗՚r;愰m;橳a;䎗ml耻Ë䃋Āipժկsts;戃onentialE;慇ʀcfiosօֈ֍ֲ׌y;䐤r;쀀𝔉lledɓ֗\0\0֣mallSquare;旼erySmallSquare;斪Ͱֺ\0ֿ\0\0ׄf;쀀𝔽All;戀riertrf;愱cò׋؀JTabcdfgorstר׬ׯ׺؀ؒؖ؛؝أ٬ٲcy;䐃耻>䀾mmaĀ;d׷׸䎓;䏜reve;䄞ƀeiy؇،ؐdil;䄢rc;䄜;䐓ot;䄠r;쀀𝔊;拙pf;쀀𝔾eater̀EFGLSTصلَٖٛ٦qualĀ;Lؾؿ扥ess;招ullEqual;执reater;檢ess;扷lantEqual;橾ilde;扳cr;쀀𝒢;扫ЀAacfiosuڅڋږڛڞڪھۊRDcy;䐪Āctڐڔek;䋇;䁞irc;䄤r;愌lbertSpace;愋ǰگ\0ڲf;愍izontalLine;攀Āctۃۅòکrok;䄦mpńېۘownHumðįqual;扏܀EJOacdfgmnostuۺ۾܃܇܎ܚܞܡܨ݄ݸދޏޕcy;䐕lig;䄲cy;䐁cute耻Í䃍Āiyܓܘrc耻Î䃎;䐘ot;䄰r;愑rave耻Ì䃌ƀ;apܠܯܿĀcgܴܷr;䄪inaryI;慈lieóϝǴ݉\0ݢĀ;eݍݎ戬Āgrݓݘral;戫section;拂isibleĀCTݬݲomma;恣imes;恢ƀgptݿރވon;䄮f;쀀𝕀a;䎙cr;愐ilde;䄨ǫޚ\0ޞcy;䐆l耻Ï䃏ʀcfosuެ޷޼߂ߐĀiyޱ޵rc;䄴;䐙r;쀀𝔍pf;쀀𝕁ǣ߇\0ߌr;쀀𝒥rcy;䐈kcy;䐄΀HJacfosߤߨ߽߬߱ࠂࠈcy;䐥cy;䐌ppa;䎚Āey߶߻dil;䄶;䐚r;쀀𝔎pf;쀀𝕂cr;쀀𝒦րJTaceflmostࠥࠩࠬࡐࡣ঳সে্਷ੇcy;䐉耻<䀼ʀcmnpr࠷࠼ࡁࡄࡍute;䄹bda;䎛g;柪lacetrf;愒r;憞ƀaeyࡗ࡜ࡡron;䄽dil;䄻;䐛Āfsࡨ॰tԀACDFRTUVarࡾࢩࢱࣦ࣠ࣼयज़ΐ४Ānrࢃ࢏gleBracket;柨rowƀ;BR࢙࢚࢞憐ar;懤ightArrow;懆eiling;挈oǵࢷ\0ࣃbleBracket;柦nǔࣈ\0࣒eeVector;楡ectorĀ;Bࣛࣜ懃ar;楙loor;挊ightĀAV࣯ࣵrrow;憔ector;楎Āerँगeƀ;AVउऊऐ抣rrow;憤ector;楚iangleƀ;BEतथऩ抲ar;槏qual;抴pƀDTVषूौownVector;楑eeVector;楠ectorĀ;Bॖॗ憿ar;楘ectorĀ;B॥०憼ar;楒ightáΜs̀EFGLSTॾঋকঝঢভqualGreater;拚ullEqual;扦reater;扶ess;檡lantEqual;橽ilde;扲r;쀀𝔏Ā;eঽা拘ftarrow;懚idot;䄿ƀnpw৔ਖਛgȀLRlr৞৷ਂਐeftĀAR০৬rrow;柵ightArrow;柷ightArrow;柶eftĀarγਊightáοightáϊf;쀀𝕃erĀLRਢਬeftArrow;憙ightArrow;憘ƀchtਾੀੂòࡌ;憰rok;䅁;扪Ѐacefiosuਗ਼੝੠੷੼અઋ઎p;椅y;䐜Ādl੥੯iumSpace;恟lintrf;愳r;쀀𝔐nusPlus;戓pf;쀀𝕄cò੶;䎜ҀJacefostuણધભીଔଙඑ඗ඞcy;䐊cute;䅃ƀaey઴હાron;䅇dil;䅅;䐝ƀgswે૰଎ativeƀMTV૓૟૨ediumSpace;怋hiĀcn૦૘ë૙eryThiî૙tedĀGL૸ଆreaterGreateòٳessLesóੈLine;䀊r;쀀𝔑ȀBnptଢନଷ଺reak;恠BreakingSpace;䂠f;愕ڀ;CDEGHLNPRSTV୕ୖ୪୼஡௫ఄ౞಄ದ೘ൡඅ櫬Āou୛୤ngruent;扢pCap;扭oubleVerticalBar;戦ƀlqxஃஊ஛ement;戉ualĀ;Tஒஓ扠ilde;쀀≂̸ists;戄reater΀;EFGLSTஶஷ஽௉௓௘௥扯qual;扱ullEqual;쀀≧̸reater;쀀≫̸ess;批lantEqual;쀀⩾̸ilde;扵umpń௲௽ownHump;쀀≎̸qual;쀀≏̸eĀfsఊధtTriangleƀ;BEచఛడ拪ar;쀀⧏̸qual;括s̀;EGLSTవశ఼ౄోౘ扮qual;扰reater;扸ess;쀀≪̸lantEqual;쀀⩽̸ilde;扴estedĀGL౨౹reaterGreater;쀀⪢̸essLess;쀀⪡̸recedesƀ;ESಒಓಛ技qual;쀀⪯̸lantEqual;拠ĀeiಫಹverseElement;戌ghtTriangleƀ;BEೋೌ೒拫ar;쀀⧐̸qual;拭ĀquೝഌuareSuĀbp೨೹setĀ;E೰ೳ쀀⊏̸qual;拢ersetĀ;Eഃആ쀀⊐̸qual;拣ƀbcpഓതൎsetĀ;Eഛഞ쀀⊂⃒qual;抈ceedsȀ;ESTലള഻െ抁qual;쀀⪰̸lantEqual;拡ilde;쀀≿̸ersetĀ;E൘൛쀀⊃⃒qual;抉ildeȀ;EFT൮൯൵ൿ扁qual;扄ullEqual;扇ilde;扉erticalBar;戤cr;쀀𝒩ilde耻Ñ䃑;䎝܀Eacdfgmoprstuvලෂ෉෕ෛ෠෧෼ขภยา฿ไlig;䅒cute耻Ó䃓Āiy෎ීrc耻Ô䃔;䐞blac;䅐r;쀀𝔒rave耻Ò䃒ƀaei෮ෲ෶cr;䅌ga;䎩cron;䎟pf;쀀𝕆enCurlyĀDQฎบoubleQuote;怜uote;怘;橔Āclวฬr;쀀𝒪ash耻Ø䃘iŬื฼de耻Õ䃕es;樷ml耻Ö䃖erĀBP๋๠Āar๐๓r;怾acĀek๚๜;揞et;掴arenthesis;揜Ҁacfhilors๿ງຊຏຒດຝະ໼rtialD;戂y;䐟r;쀀𝔓i;䎦;䎠usMinus;䂱Āipຢອncareplanåڝf;愙Ȁ;eio຺ູ໠໤檻cedesȀ;EST່້໏໚扺qual;檯lantEqual;扼ilde;找me;怳Ādp໩໮uct;戏ortionĀ;aȥ໹l;戝Āci༁༆r;쀀𝒫;䎨ȀUfos༑༖༛༟OT耻\"䀢r;쀀𝔔pf;愚cr;쀀𝒬؀BEacefhiorsu༾གྷཇའཱིྦྷྪྭ႖ႩႴႾarr;椐G耻®䂮ƀcnrཎནབute;䅔g;柫rĀ;tཛྷཝ憠l;椖ƀaeyཧཬཱron;䅘dil;䅖;䐠Ā;vླྀཹ愜erseĀEUྂྙĀlq྇ྎement;戋uilibrium;懋pEquilibrium;楯r»ཹo;䎡ghtЀACDFTUVa࿁࿫࿳ဢဨၛႇϘĀnr࿆࿒gleBracket;柩rowƀ;BL࿜࿝࿡憒ar;懥eftArrow;懄eiling;按oǵ࿹\0စbleBracket;柧nǔည\0နeeVector;楝ectorĀ;Bဝသ懂ar;楕loor;挋Āerိ၃eƀ;AVဵံြ抢rrow;憦ector;楛iangleƀ;BEၐၑၕ抳ar;槐qual;抵pƀDTVၣၮၸownVector;楏eeVector;楜ectorĀ;Bႂႃ憾ar;楔ectorĀ;B႑႒懀ar;楓Āpuႛ႞f;愝ndImplies;楰ightarrow;懛ĀchႹႼr;愛;憱leDelayed;槴ڀHOacfhimoqstuფჱჷჽᄙᄞᅑᅖᅡᅧᆵᆻᆿĀCcჩხHcy;䐩y;䐨FTcy;䐬cute;䅚ʀ;aeiyᄈᄉᄎᄓᄗ檼ron;䅠dil;䅞rc;䅜;䐡r;쀀𝔖ortȀDLRUᄪᄴᄾᅉownArrow»ОeftArrow»࢚ightArrow»࿝pArrow;憑gma;䎣allCircle;战pf;쀀𝕊ɲᅭ\0\0ᅰt;戚areȀ;ISUᅻᅼᆉᆯ斡ntersection;抓uĀbpᆏᆞsetĀ;Eᆗᆘ抏qual;抑ersetĀ;Eᆨᆩ抐qual;抒nion;抔cr;쀀𝒮ar;拆ȀbcmpᇈᇛሉላĀ;sᇍᇎ拐etĀ;Eᇍᇕqual;抆ĀchᇠህeedsȀ;ESTᇭᇮᇴᇿ扻qual;檰lantEqual;扽ilde;承Tháྌ;我ƀ;esሒሓሣ拑rsetĀ;Eሜም抃qual;抇et»ሓրHRSacfhiorsሾቄ቉ቕ቞ቱቶኟዂወዑORN耻Þ䃞ADE;愢ĀHc቎ቒcy;䐋y;䐦Ābuቚቜ;䀉;䎤ƀaeyብቪቯron;䅤dil;䅢;䐢r;쀀𝔗Āeiቻ኉ǲኀ\0ኇefore;戴a;䎘Ācn኎ኘkSpace;쀀  Space;怉ldeȀ;EFTካኬኲኼ戼qual;扃ullEqual;扅ilde;扈pf;쀀𝕋ipleDot;惛Āctዖዛr;쀀𝒯rok;䅦ૡዷጎጚጦ\0ጬጱ\0\0\0\0\0ጸጽ፷ᎅ\0᏿ᐄᐊᐐĀcrዻጁute耻Ú䃚rĀ;oጇገ憟cir;楉rǣጓ\0጖y;䐎ve;䅬Āiyጞጣrc耻Û䃛;䐣blac;䅰r;쀀𝔘rave耻Ù䃙acr;䅪Ādiፁ፩erĀBPፈ፝Āarፍፐr;䁟acĀekፗፙ;揟et;掵arenthesis;揝onĀ;P፰፱拃lus;抎Āgp፻፿on;䅲f;쀀𝕌ЀADETadps᎕ᎮᎸᏄϨᏒᏗᏳrrowƀ;BDᅐᎠᎤar;椒ownArrow;懅ownArrow;憕quilibrium;楮eeĀ;AᏋᏌ报rrow;憥ownáϳerĀLRᏞᏨeftArrow;憖ightArrow;憗iĀ;lᏹᏺ䏒on;䎥ing;䅮cr;쀀𝒰ilde;䅨ml耻Ü䃜ҀDbcdefosvᐧᐬᐰᐳᐾᒅᒊᒐᒖash;披ar;櫫y;䐒ashĀ;lᐻᐼ抩;櫦Āerᑃᑅ;拁ƀbtyᑌᑐᑺar;怖Ā;iᑏᑕcalȀBLSTᑡᑥᑪᑴar;戣ine;䁼eparator;杘ilde;所ThinSpace;怊r;쀀𝔙pf;쀀𝕍cr;쀀𝒱dash;抪ʀcefosᒧᒬᒱᒶᒼirc;䅴dge;拀r;쀀𝔚pf;쀀𝕎cr;쀀𝒲Ȁfiosᓋᓐᓒᓘr;쀀𝔛;䎞pf;쀀𝕏cr;쀀𝒳ҀAIUacfosuᓱᓵᓹᓽᔄᔏᔔᔚᔠcy;䐯cy;䐇cy;䐮cute耻Ý䃝Āiyᔉᔍrc;䅶;䐫r;쀀𝔜pf;쀀𝕐cr;쀀𝒴ml;䅸ЀHacdefosᔵᔹᔿᕋᕏᕝᕠᕤcy;䐖cute;䅹Āayᕄᕉron;䅽;䐗ot;䅻ǲᕔ\0ᕛoWidtè૙a;䎖r;愨pf;愤cr;쀀𝒵௡ᖃᖊᖐ\0ᖰᖶᖿ\0\0\0\0ᗆᗛᗫᙟ᙭\0ᚕ᚛ᚲᚹ\0ᚾcute耻á䃡reve;䄃̀;Ediuyᖜᖝᖡᖣᖨᖭ戾;쀀∾̳;房rc耻â䃢te肻´̆;䐰lig耻æ䃦Ā;r²ᖺ;쀀𝔞rave耻à䃠ĀepᗊᗖĀfpᗏᗔsym;愵èᗓha;䎱ĀapᗟcĀclᗤᗧr;䄁g;樿ɤᗰ\0\0ᘊʀ;adsvᗺᗻᗿᘁᘇ戧nd;橕;橜lope;橘;橚΀;elmrszᘘᘙᘛᘞᘿᙏᙙ戠;榤e»ᘙsdĀ;aᘥᘦ戡ѡᘰᘲᘴᘶᘸᘺᘼᘾ;榨;榩;榪;榫;榬;榭;榮;榯tĀ;vᙅᙆ戟bĀ;dᙌᙍ抾;榝Āptᙔᙗh;戢»¹arr;捼Āgpᙣᙧon;䄅f;쀀𝕒΀;Eaeiop዁ᙻᙽᚂᚄᚇᚊ;橰cir;橯;扊d;手s;䀧roxĀ;e዁ᚒñᚃing耻å䃥ƀctyᚡᚦᚨr;쀀𝒶;䀪mpĀ;e዁ᚯñʈilde耻ã䃣ml耻ä䃤Āciᛂᛈoninôɲnt;樑ࠀNabcdefiklnoprsu᛭ᛱᜰ᜼ᝃᝈ᝸᝽០៦ᠹᡐᜍ᤽᥈ᥰot;櫭Ācrᛶ᜞kȀcepsᜀᜅᜍᜓong;扌psilon;䏶rime;怵imĀ;e᜚᜛戽q;拍Ŷᜢᜦee;抽edĀ;gᜬᜭ挅e»ᜭrkĀ;t፜᜷brk;掶Āoyᜁᝁ;䐱quo;怞ʀcmprtᝓ᝛ᝡᝤᝨausĀ;eĊĉptyv;榰séᜌnoõēƀahwᝯ᝱ᝳ;䎲;愶een;扬r;쀀𝔟g΀costuvwឍឝឳេ៕៛៞ƀaiuបពរðݠrc;旯p»፱ƀdptឤឨឭot;樀lus;樁imes;樂ɱឹ\0\0ើcup;樆ar;昅riangleĀdu៍្own;施p;斳plus;樄eåᑄåᒭarow;植ƀako៭ᠦᠵĀcn៲ᠣkƀlst៺֫᠂ozenge;槫riangleȀ;dlr᠒᠓᠘᠝斴own;斾eft;旂ight;斸k;搣Ʊᠫ\0ᠳƲᠯ\0ᠱ;斒;斑4;斓ck;斈ĀeoᠾᡍĀ;qᡃᡆ쀀=⃥uiv;쀀≡⃥t;挐Ȁptwxᡙᡞᡧᡬf;쀀𝕓Ā;tᏋᡣom»Ꮜtie;拈؀DHUVbdhmptuvᢅᢖᢪᢻᣗᣛᣬ᣿ᤅᤊᤐᤡȀLRlrᢎᢐᢒᢔ;敗;敔;敖;敓ʀ;DUduᢡᢢᢤᢦᢨ敐;敦;敩;敤;敧ȀLRlrᢳᢵᢷᢹ;敝;敚;敜;教΀;HLRhlrᣊᣋᣍᣏᣑᣓᣕ救;敬;散;敠;敫;敢;敟ox;槉ȀLRlrᣤᣦᣨᣪ;敕;敒;攐;攌ʀ;DUduڽ᣷᣹᣻᣽;敥;敨;攬;攴inus;抟lus;択imes;抠ȀLRlrᤙᤛᤝ᤟;敛;敘;攘;攔΀;HLRhlrᤰᤱᤳᤵᤷ᤻᤹攂;敪;敡;敞;攼;攤;攜Āevģ᥂bar耻¦䂦Ȁceioᥑᥖᥚᥠr;쀀𝒷mi;恏mĀ;e᜚᜜lƀ;bhᥨᥩᥫ䁜;槅sub;柈Ŭᥴ᥾lĀ;e᥹᥺怢t»᥺pƀ;Eeįᦅᦇ;檮Ā;qۜۛೡᦧ\0᧨ᨑᨕᨲ\0ᨷᩐ\0\0᪴\0\0᫁\0\0ᬡᬮ᭍᭒\0᯽\0ᰌƀcpr᦭ᦲ᧝ute;䄇̀;abcdsᦿᧀᧄ᧊᧕᧙戩nd;橄rcup;橉Āau᧏᧒p;橋p;橇ot;橀;쀀∩︀Āeo᧢᧥t;恁îړȀaeiu᧰᧻ᨁᨅǰ᧵\0᧸s;橍on;䄍dil耻ç䃧rc;䄉psĀ;sᨌᨍ橌m;橐ot;䄋ƀdmnᨛᨠᨦil肻¸ƭptyv;榲t脀¢;eᨭᨮ䂢räƲr;쀀𝔠ƀceiᨽᩀᩍy;䑇ckĀ;mᩇᩈ朓ark»ᩈ;䏇r΀;Ecefms᩟᩠ᩢᩫ᪤᪪᪮旋;槃ƀ;elᩩᩪᩭ䋆q;扗eɡᩴ\0\0᪈rrowĀlr᩼᪁eft;憺ight;憻ʀRSacd᪒᪔᪖᪚᪟»ཇ;擈st;抛irc;抚ash;抝nint;樐id;櫯cir;槂ubsĀ;u᪻᪼晣it»᪼ˬ᫇᫔᫺\0ᬊonĀ;eᫍᫎ䀺Ā;qÇÆɭ᫙\0\0᫢aĀ;t᫞᫟䀬;䁀ƀ;fl᫨᫩᫫戁îᅠeĀmx᫱᫶ent»᫩eóɍǧ᫾\0ᬇĀ;dኻᬂot;橭nôɆƀfryᬐᬔᬗ;쀀𝕔oäɔ脀©;sŕᬝr;愗Āaoᬥᬩrr;憵ss;朗Ācuᬲᬷr;쀀𝒸Ābpᬼ᭄Ā;eᭁᭂ櫏;櫑Ā;eᭉᭊ櫐;櫒dot;拯΀delprvw᭠᭬᭷ᮂᮬᯔ᯹arrĀlr᭨᭪;椸;椵ɰ᭲\0\0᭵r;拞c;拟arrĀ;p᭿ᮀ憶;椽̀;bcdosᮏᮐᮖᮡᮥᮨ截rcap;橈Āauᮛᮞp;橆p;橊ot;抍r;橅;쀀∪︀Ȁalrv᮵ᮿᯞᯣrrĀ;mᮼᮽ憷;椼yƀevwᯇᯔᯘqɰᯎ\0\0ᯒreã᭳uã᭵ee;拎edge;拏en耻¤䂤earrowĀlrᯮ᯳eft»ᮀight»ᮽeäᯝĀciᰁᰇoninôǷnt;戱lcty;挭ঀAHabcdefhijlorstuwz᰸᰻᰿ᱝᱩᱵᲊᲞᲬᲷ᳻᳿ᴍᵻᶑᶫᶻ᷆᷍rò΁ar;楥Ȁglrs᱈ᱍ᱒᱔ger;怠eth;愸òᄳhĀ;vᱚᱛ怐»ऊūᱡᱧarow;椏aã̕Āayᱮᱳron;䄏;䐴ƀ;ao̲ᱼᲄĀgrʿᲁr;懊tseq;橷ƀglmᲑᲔᲘ耻°䂰ta;䎴ptyv;榱ĀirᲣᲨsht;楿;쀀𝔡arĀlrᲳᲵ»ࣜ»သʀaegsv᳂͸᳖᳜᳠mƀ;oș᳊᳔ndĀ;ș᳑uit;晦amma;䏝in;拲ƀ;io᳧᳨᳸䃷de脀÷;o᳧ᳰntimes;拇nø᳷cy;䑒cɯᴆ\0\0ᴊrn;挞op;挍ʀlptuwᴘᴝᴢᵉᵕlar;䀤f;쀀𝕕ʀ;emps̋ᴭᴷᴽᵂqĀ;d͒ᴳot;扑inus;戸lus;戔quare;抡blebarwedgåúnƀadhᄮᵝᵧownarrowóᲃarpoonĀlrᵲᵶefôᲴighôᲶŢᵿᶅkaro÷གɯᶊ\0\0ᶎrn;挟op;挌ƀcotᶘᶣᶦĀryᶝᶡ;쀀𝒹;䑕l;槶rok;䄑Ādrᶰᶴot;拱iĀ;fᶺ᠖斿Āah᷀᷃ròЩaòྦangle;榦Āci᷒ᷕy;䑟grarr;柿ऀDacdefglmnopqrstuxḁḉḙḸոḼṉṡṾấắẽỡἪἷὄ὎὚ĀDoḆᴴoôᲉĀcsḎḔute耻é䃩ter;橮ȀaioyḢḧḱḶron;䄛rĀ;cḭḮ扖耻ê䃪lon;払;䑍ot;䄗ĀDrṁṅot;扒;쀀𝔢ƀ;rsṐṑṗ檚ave耻è䃨Ā;dṜṝ檖ot;檘Ȁ;ilsṪṫṲṴ檙nters;揧;愓Ā;dṹṺ檕ot;檗ƀapsẅẉẗcr;䄓tyƀ;svẒẓẕ戅et»ẓpĀ1;ẝẤĳạả;怄;怅怃ĀgsẪẬ;䅋p;怂ĀgpẴẸon;䄙f;쀀𝕖ƀalsỄỎỒrĀ;sỊị拕l;槣us;橱iƀ;lvỚớở䎵on»ớ;䏵ȀcsuvỪỳἋἣĀioữḱrc»Ḯɩỹ\0\0ỻíՈantĀglἂἆtr»ṝess»Ṻƀaeiἒ἖Ἒls;䀽st;扟vĀ;DȵἠD;橸parsl;槥ĀDaἯἳot;打rr;楱ƀcdiἾὁỸr;愯oô͒ĀahὉὋ;䎷耻ð䃰Āmrὓὗl耻ë䃫o;悬ƀcipὡὤὧl;䀡sôծĀeoὬὴctatioîՙnentialåչৡᾒ\0ᾞ\0ᾡᾧ\0\0ῆῌ\0ΐ\0ῦῪ \0 ⁚llingdotseñṄy;䑄male;晀ƀilrᾭᾳ῁lig;耀ﬃɩᾹ\0\0᾽g;耀ﬀig;耀ﬄ;쀀𝔣lig;耀ﬁlig;쀀fjƀaltῙ῜ῡt;晭ig;耀ﬂns;斱of;䆒ǰ΅\0ῳf;쀀𝕗ĀakֿῷĀ;vῼ´拔;櫙artint;樍Āao‌⁕Ācs‑⁒α‚‰‸⁅⁈\0⁐β•‥‧‪‬\0‮耻½䂽;慓耻¼䂼;慕;慙;慛Ƴ‴\0‶;慔;慖ʴ‾⁁\0\0⁃耻¾䂾;慗;慜5;慘ƶ⁌\0⁎;慚;慝8;慞l;恄wn;挢cr;쀀𝒻ࢀEabcdefgijlnorstv₂₉₟₥₰₴⃰⃵⃺⃿℃ℒℸ̗ℾ⅒↞Ā;lٍ₇;檌ƀcmpₐₕ₝ute;䇵maĀ;dₜ᳚䎳;檆reve;䄟Āiy₪₮rc;䄝;䐳ot;䄡Ȁ;lqsؾق₽⃉ƀ;qsؾٌ⃄lanô٥Ȁ;cdl٥⃒⃥⃕c;檩otĀ;o⃜⃝檀Ā;l⃢⃣檂;檄Ā;e⃪⃭쀀⋛︀s;檔r;쀀𝔤Ā;gٳ؛mel;愷cy;䑓Ȁ;Eajٚℌℎℐ;檒;檥;檤ȀEaesℛℝ℩ℴ;扩pĀ;p℣ℤ檊rox»ℤĀ;q℮ℯ檈Ā;q℮ℛim;拧pf;쀀𝕘Āci⅃ⅆr;愊mƀ;el٫ⅎ⅐;檎;檐茀>;cdlqr׮ⅠⅪⅮⅳⅹĀciⅥⅧ;檧r;橺ot;拗Par;榕uest;橼ʀadelsↄⅪ←ٖ↛ǰ↉\0↎proø₞r;楸qĀlqؿ↖lesó₈ií٫Āen↣↭rtneqq;쀀≩︀Å↪ԀAabcefkosy⇄⇇⇱⇵⇺∘∝∯≨≽ròΠȀilmr⇐⇔⇗⇛rsðᒄf»․ilôکĀdr⇠⇤cy;䑊ƀ;cwࣴ⇫⇯ir;楈;憭ar;意irc;䄥ƀalr∁∎∓rtsĀ;u∉∊晥it»∊lip;怦con;抹r;쀀𝔥sĀew∣∩arow;椥arow;椦ʀamopr∺∾≃≞≣rr;懿tht;戻kĀlr≉≓eftarrow;憩ightarrow;憪f;쀀𝕙bar;怕ƀclt≯≴≸r;쀀𝒽asè⇴rok;䄧Ābp⊂⊇ull;恃hen»ᱛૡ⊣\0⊪\0⊸⋅⋎\0⋕⋳\0\0⋸⌢⍧⍢⍿\0⎆⎪⎴cute耻í䃭ƀ;iyݱ⊰⊵rc耻î䃮;䐸Ācx⊼⊿y;䐵cl耻¡䂡ĀfrΟ⋉;쀀𝔦rave耻ì䃬Ȁ;inoܾ⋝⋩⋮Āin⋢⋦nt;樌t;戭fin;槜ta;愩lig;䄳ƀaop⋾⌚⌝ƀcgt⌅⌈⌗r;䄫ƀelpܟ⌏⌓inåގarôܠh;䄱f;抷ed;䆵ʀ;cfotӴ⌬⌱⌽⍁are;愅inĀ;t⌸⌹戞ie;槝doô⌙ʀ;celpݗ⍌⍐⍛⍡al;抺Āgr⍕⍙eróᕣã⍍arhk;樗rod;樼Ȁcgpt⍯⍲⍶⍻y;䑑on;䄯f;쀀𝕚a;䎹uest耻¿䂿Āci⎊⎏r;쀀𝒾nʀ;EdsvӴ⎛⎝⎡ӳ;拹ot;拵Ā;v⎦⎧拴;拳Ā;iݷ⎮lde;䄩ǫ⎸\0⎼cy;䑖l耻ï䃯̀cfmosu⏌⏗⏜⏡⏧⏵Āiy⏑⏕rc;䄵;䐹r;쀀𝔧ath;䈷pf;쀀𝕛ǣ⏬\0⏱r;쀀𝒿rcy;䑘kcy;䑔Ѐacfghjos␋␖␢␧␭␱␵␻ppaĀ;v␓␔䎺;䏰Āey␛␠dil;䄷;䐺r;쀀𝔨reen;䄸cy;䑅cy;䑜pf;쀀𝕜cr;쀀𝓀஀ABEHabcdefghjlmnoprstuv⑰⒁⒆⒍⒑┎┽╚▀♎♞♥♹♽⚚⚲⛘❝❨➋⟀⠁⠒ƀart⑷⑺⑼rò৆òΕail;椛arr;椎Ā;gঔ⒋;檋ar;楢ॣ⒥\0⒪\0⒱\0\0\0\0\0⒵Ⓔ\0ⓆⓈⓍ\0⓹ute;䄺mptyv;榴raîࡌbda;䎻gƀ;dlࢎⓁⓃ;榑åࢎ;檅uo耻«䂫rЀ;bfhlpst࢙ⓞⓦⓩ⓫⓮⓱⓵Ā;f࢝ⓣs;椟s;椝ë≒p;憫l;椹im;楳l;憢ƀ;ae⓿─┄檫il;椙Ā;s┉┊檭;쀀⪭︀ƀabr┕┙┝rr;椌rk;杲Āak┢┬cĀek┨┪;䁻;䁛Āes┱┳;榋lĀdu┹┻;榏;榍Ȁaeuy╆╋╖╘ron;䄾Ādi═╔il;䄼ìࢰâ┩;䐻Ȁcqrs╣╦╭╽a;椶uoĀ;rนᝆĀdu╲╷har;楧shar;楋h;憲ʀ;fgqs▋▌উ◳◿扤tʀahlrt▘▤▷◂◨rrowĀ;t࢙□aé⓶arpoonĀdu▯▴own»њp»०eftarrows;懇ightƀahs◍◖◞rrowĀ;sࣴࢧarpoonó྘quigarro÷⇰hreetimes;拋ƀ;qs▋ও◺lanôবʀ;cdgsব☊☍☝☨c;檨otĀ;o☔☕橿Ā;r☚☛檁;檃Ā;e☢☥쀀⋚︀s;檓ʀadegs☳☹☽♉♋pproøⓆot;拖qĀgq♃♅ôউgtò⒌ôছiíলƀilr♕࣡♚sht;楼;쀀𝔩Ā;Eজ♣;檑š♩♶rĀdu▲♮Ā;l॥♳;楪lk;斄cy;䑙ʀ;achtੈ⚈⚋⚑⚖rò◁orneòᴈard;楫ri;旺Āio⚟⚤dot;䅀ustĀ;a⚬⚭掰che»⚭ȀEaes⚻⚽⛉⛔;扨pĀ;p⛃⛄檉rox»⛄Ā;q⛎⛏檇Ā;q⛎⚻im;拦Ѐabnoptwz⛩⛴⛷✚✯❁❇❐Ānr⛮⛱g;柬r;懽rëࣁgƀlmr⛿✍✔eftĀar০✇ightá৲apsto;柼ightá৽parrowĀlr✥✩efô⓭ight;憬ƀafl✶✹✽r;榅;쀀𝕝us;樭imes;樴š❋❏st;戗áፎƀ;ef❗❘᠀旊nge»❘arĀ;l❤❥䀨t;榓ʀachmt❳❶❼➅➇ròࢨorneòᶌarĀ;d྘➃;業;怎ri;抿̀achiqt➘➝ੀ➢➮➻quo;怹r;쀀𝓁mƀ;egল➪➬;檍;檏Ābu┪➳oĀ;rฟ➹;怚rok;䅂萀<;cdhilqrࠫ⟒☹⟜⟠⟥⟪⟰Āci⟗⟙;檦r;橹reå◲mes;拉arr;楶uest;橻ĀPi⟵⟹ar;榖ƀ;ef⠀भ᠛旃rĀdu⠇⠍shar;楊har;楦Āen⠗⠡rtneqq;쀀≨︀Å⠞܀Dacdefhilnopsu⡀⡅⢂⢎⢓⢠⢥⢨⣚⣢⣤ઃ⣳⤂Dot;戺Ȁclpr⡎⡒⡣⡽r耻¯䂯Āet⡗⡙;時Ā;e⡞⡟朠se»⡟Ā;sျ⡨toȀ;dluျ⡳⡷⡻owîҌefôएðᏑker;斮Āoy⢇⢌mma;権;䐼ash;怔asuredangle»ᘦr;쀀𝔪o;愧ƀcdn⢯⢴⣉ro耻µ䂵Ȁ;acdᑤ⢽⣀⣄sôᚧir;櫰ot肻·Ƶusƀ;bd⣒ᤃ⣓戒Ā;uᴼ⣘;横ţ⣞⣡p;櫛ò−ðઁĀdp⣩⣮els;抧f;쀀𝕞Āct⣸⣽r;쀀𝓂pos»ᖝƀ;lm⤉⤊⤍䎼timap;抸ఀGLRVabcdefghijlmoprstuvw⥂⥓⥾⦉⦘⧚⧩⨕⨚⩘⩝⪃⪕⪤⪨⬄⬇⭄⭿⮮ⰴⱧⱼ⳩Āgt⥇⥋;쀀⋙̸Ā;v⥐௏쀀≫⃒ƀelt⥚⥲⥶ftĀar⥡⥧rrow;懍ightarrow;懎;쀀⋘̸Ā;v⥻ే쀀≪⃒ightarrow;懏ĀDd⦎⦓ash;抯ash;抮ʀbcnpt⦣⦧⦬⦱⧌la»˞ute;䅄g;쀀∠⃒ʀ;Eiop඄⦼⧀⧅⧈;쀀⩰̸d;쀀≋̸s;䅉roø඄urĀ;a⧓⧔普lĀ;s⧓ସǳ⧟\0⧣p肻\xA0ଷmpĀ;e௹ఀʀaeouy⧴⧾⨃⨐⨓ǰ⧹\0⧻;橃on;䅈dil;䅆ngĀ;dൾ⨊ot;쀀⩭̸p;橂;䐽ash;怓΀;Aadqsxஒ⨩⨭⨻⩁⩅⩐rr;懗rĀhr⨳⨶k;椤Ā;oᏲᏰot;쀀≐̸uiöୣĀei⩊⩎ar;椨í஘istĀ;s஠டr;쀀𝔫ȀEest௅⩦⩹⩼ƀ;qs஼⩭௡ƀ;qs஼௅⩴lanô௢ií௪Ā;rஶ⪁»ஷƀAap⪊⪍⪑rò⥱rr;憮ar;櫲ƀ;svྍ⪜ྌĀ;d⪡⪢拼;拺cy;䑚΀AEadest⪷⪺⪾⫂⫅⫶⫹rò⥦;쀀≦̸rr;憚r;急Ȁ;fqs఻⫎⫣⫯tĀar⫔⫙rro÷⫁ightarro÷⪐ƀ;qs఻⪺⫪lanôౕĀ;sౕ⫴»శiíౝĀ;rవ⫾iĀ;eచథiäඐĀpt⬌⬑f;쀀𝕟膀¬;in⬙⬚⬶䂬nȀ;Edvஉ⬤⬨⬮;쀀⋹̸ot;쀀⋵̸ǡஉ⬳⬵;拷;拶iĀ;vಸ⬼ǡಸ⭁⭃;拾;拽ƀaor⭋⭣⭩rȀ;ast୻⭕⭚⭟lleì୻l;쀀⫽⃥;쀀∂̸lint;樔ƀ;ceಒ⭰⭳uåಥĀ;cಘ⭸Ā;eಒ⭽ñಘȀAait⮈⮋⮝⮧rò⦈rrƀ;cw⮔⮕⮙憛;쀀⤳̸;쀀↝̸ghtarrow»⮕riĀ;eೋೖ΀chimpqu⮽⯍⯙⬄୸⯤⯯Ȁ;cerല⯆ഷ⯉uå൅;쀀𝓃ortɭ⬅\0\0⯖ará⭖mĀ;e൮⯟Ā;q൴൳suĀbp⯫⯭å೸åഋƀbcp⯶ⰑⰙȀ;Ees⯿ⰀഢⰄ抄;쀀⫅̸etĀ;eഛⰋqĀ;qണⰀcĀ;eലⰗñസȀ;EesⰢⰣൟⰧ抅;쀀⫆̸etĀ;e൘ⰮqĀ;qൠⰣȀgilrⰽⰿⱅⱇìௗlde耻ñ䃱çృiangleĀlrⱒⱜeftĀ;eచⱚñదightĀ;eೋⱥñ೗Ā;mⱬⱭ䎽ƀ;esⱴⱵⱹ䀣ro;愖p;怇ҀDHadgilrsⲏⲔⲙⲞⲣⲰⲶⳓⳣash;抭arr;椄p;쀀≍⃒ash;抬ĀetⲨⲬ;쀀≥⃒;쀀>⃒nfin;槞ƀAetⲽⳁⳅrr;椂;쀀≤⃒Ā;rⳊⳍ쀀<⃒ie;쀀⊴⃒ĀAtⳘⳜrr;椃rie;쀀⊵⃒im;쀀∼⃒ƀAan⳰⳴ⴂrr;懖rĀhr⳺⳽k;椣Ā;oᏧᏥear;椧ቓ᪕\0\0\0\0\0\0\0\0\0\0\0\0\0ⴭ\0ⴸⵈⵠⵥ⵲ⶄᬇ\0\0ⶍⶫ\0ⷈⷎ\0ⷜ⸙⸫⸾⹃Ācsⴱ᪗ute耻ó䃳ĀiyⴼⵅrĀ;c᪞ⵂ耻ô䃴;䐾ʀabios᪠ⵒⵗǈⵚlac;䅑v;樸old;榼lig;䅓Ācr⵩⵭ir;榿;쀀𝔬ͯ⵹\0\0⵼\0ⶂn;䋛ave耻ò䃲;槁Ābmⶈ෴ar;榵Ȁacitⶕ⶘ⶥⶨrò᪀Āir⶝ⶠr;榾oss;榻nå๒;槀ƀaeiⶱⶵⶹcr;䅍ga;䏉ƀcdnⷀⷅǍron;䎿;榶pf;쀀𝕠ƀaelⷔ⷗ǒr;榷rp;榹΀;adiosvⷪⷫⷮ⸈⸍⸐⸖戨rò᪆Ȁ;efmⷷⷸ⸂⸅橝rĀ;oⷾⷿ愴f»ⷿ耻ª䂪耻º䂺gof;抶r;橖lope;橗;橛ƀclo⸟⸡⸧ò⸁ash耻ø䃸l;折iŬⸯ⸴de耻õ䃵esĀ;aǛ⸺s;樶ml耻ö䃶bar;挽ૡ⹞\0⹽\0⺀⺝\0⺢⺹\0\0⻋ຜ\0⼓\0\0⼫⾼\0⿈rȀ;astЃ⹧⹲຅脀¶;l⹭⹮䂶leìЃɩ⹸\0\0⹻m;櫳;櫽y;䐿rʀcimpt⺋⺏⺓ᡥ⺗nt;䀥od;䀮il;怰enk;怱r;쀀𝔭ƀimo⺨⺰⺴Ā;v⺭⺮䏆;䏕maô੶ne;明ƀ;tv⺿⻀⻈䏀chfork»´;䏖Āau⻏⻟nĀck⻕⻝kĀ;h⇴⻛;愎ö⇴sҀ;abcdemst⻳⻴ᤈ⻹⻽⼄⼆⼊⼎䀫cir;樣ir;樢Āouᵀ⼂;樥;橲n肻±ຝim;樦wo;樧ƀipu⼙⼠⼥ntint;樕f;쀀𝕡nd耻£䂣Ԁ;Eaceinosu່⼿⽁⽄⽇⾁⾉⾒⽾⾶;檳p;檷uå໙Ā;c໎⽌̀;acens່⽙⽟⽦⽨⽾pproø⽃urlyeñ໙ñ໎ƀaes⽯⽶⽺pprox;檹qq;檵im;拨iíໟmeĀ;s⾈ຮ怲ƀEas⽸⾐⽺ð⽵ƀdfp໬⾙⾯ƀals⾠⾥⾪lar;挮ine;挒urf;挓Ā;t໻⾴ï໻rel;抰Āci⿀⿅r;쀀𝓅;䏈ncsp;怈̀fiopsu⿚⋢⿟⿥⿫⿱r;쀀𝔮pf;쀀𝕢rime;恗cr;쀀𝓆ƀaeo⿸〉〓tĀei⿾々rnionóڰnt;樖stĀ;e【】䀿ñἙô༔઀ABHabcdefhilmnoprstux぀けさすムㄎㄫㅇㅢㅲㆎ㈆㈕㈤㈩㉘㉮㉲㊐㊰㊷ƀartぇおがròႳòϝail;検aròᱥar;楤΀cdenqrtとふへみわゔヌĀeuねぱ;쀀∽̱te;䅕iãᅮmptyv;榳gȀ;del࿑らるろ;榒;榥å࿑uo耻»䂻rր;abcfhlpstw࿜ガクシスゼゾダッデナp;極Ā;f࿠ゴs;椠;椳s;椞ë≝ð✮l;楅im;楴l;憣;憝Āaiパフil;椚oĀ;nホボ戶aló༞ƀabrョリヮrò៥rk;杳ĀakンヽcĀekヹ・;䁽;䁝Āes㄂㄄;榌lĀduㄊㄌ;榎;榐Ȁaeuyㄗㄜㄧㄩron;䅙Ādiㄡㄥil;䅗ì࿲âヺ;䑀Ȁclqsㄴㄷㄽㅄa;椷dhar;楩uoĀ;rȎȍh;憳ƀacgㅎㅟངlȀ;ipsླྀㅘㅛႜnåႻarôྩt;断ƀilrㅩဣㅮsht;楽;쀀𝔯ĀaoㅷㆆrĀduㅽㅿ»ѻĀ;l႑ㆄ;楬Ā;vㆋㆌ䏁;䏱ƀgns㆕ㇹㇼht̀ahlrstㆤㆰ㇂㇘㇤㇮rrowĀ;t࿜ㆭaéトarpoonĀduㆻㆿowîㅾp»႒eftĀah㇊㇐rrowó࿪arpoonóՑightarrows;應quigarro÷ニhreetimes;拌g;䋚ingdotseñἲƀahm㈍㈐㈓rò࿪aòՑ;怏oustĀ;a㈞㈟掱che»㈟mid;櫮Ȁabpt㈲㈽㉀㉒Ānr㈷㈺g;柭r;懾rëဃƀafl㉇㉊㉎r;榆;쀀𝕣us;樮imes;樵Āap㉝㉧rĀ;g㉣㉤䀩t;榔olint;樒arò㇣Ȁachq㉻㊀Ⴜ㊅quo;怺r;쀀𝓇Ābu・㊊oĀ;rȔȓƀhir㊗㊛㊠reåㇸmes;拊iȀ;efl㊪ၙᠡ㊫方tri;槎luhar;楨;愞ൡ㋕㋛㋟㌬㌸㍱\0㍺㎤\0\0㏬㏰\0㐨㑈㑚㒭㒱㓊㓱\0㘖\0\0㘳cute;䅛quï➺Ԁ;Eaceinpsyᇭ㋳㋵㋿㌂㌋㌏㌟㌦㌩;檴ǰ㋺\0㋼;檸on;䅡uåᇾĀ;dᇳ㌇il;䅟rc;䅝ƀEas㌖㌘㌛;檶p;檺im;择olint;樓iíሄ;䑁otƀ;be㌴ᵇ㌵担;橦΀Aacmstx㍆㍊㍗㍛㍞㍣㍭rr;懘rĀhr㍐㍒ë∨Ā;oਸ਼਴t耻§䂧i;䀻war;椩mĀin㍩ðnuóñt;朶rĀ;o㍶⁕쀀𝔰Ȁacoy㎂㎆㎑㎠rp;景Āhy㎋㎏cy;䑉;䑈rtɭ㎙\0\0㎜iäᑤaraì⹯耻­䂭Āgm㎨㎴maƀ;fv㎱㎲㎲䏃;䏂Ѐ;deglnprካ㏅㏉㏎㏖㏞㏡㏦ot;橪Ā;q኱ኰĀ;E㏓㏔檞;檠Ā;E㏛㏜檝;檟e;扆lus;樤arr;楲aròᄽȀaeit㏸㐈㐏㐗Āls㏽㐄lsetmé㍪hp;樳parsl;槤Ādlᑣ㐔e;挣Ā;e㐜㐝檪Ā;s㐢㐣檬;쀀⪬︀ƀflp㐮㐳㑂tcy;䑌Ā;b㐸㐹䀯Ā;a㐾㐿槄r;挿f;쀀𝕤aĀdr㑍ЂesĀ;u㑔㑕晠it»㑕ƀcsu㑠㑹㒟Āau㑥㑯pĀ;sᆈ㑫;쀀⊓︀pĀ;sᆴ㑵;쀀⊔︀uĀbp㑿㒏ƀ;esᆗᆜ㒆etĀ;eᆗ㒍ñᆝƀ;esᆨᆭ㒖etĀ;eᆨ㒝ñᆮƀ;afᅻ㒦ְrť㒫ֱ»ᅼaròᅈȀcemt㒹㒾㓂㓅r;쀀𝓈tmîñiì㐕aræᆾĀar㓎㓕rĀ;f㓔ឿ昆Āan㓚㓭ightĀep㓣㓪psiloîỠhé⺯s»⡒ʀbcmnp㓻㕞ሉ㖋㖎Ҁ;Edemnprs㔎㔏㔑㔕㔞㔣㔬㔱㔶抂;櫅ot;檽Ā;dᇚ㔚ot;櫃ult;櫁ĀEe㔨㔪;櫋;把lus;檿arr;楹ƀeiu㔽㕒㕕tƀ;en㔎㕅㕋qĀ;qᇚ㔏eqĀ;q㔫㔨m;櫇Ābp㕚㕜;櫕;櫓c̀;acensᇭ㕬㕲㕹㕻㌦pproø㋺urlyeñᇾñᇳƀaes㖂㖈㌛pproø㌚qñ㌗g;晪ڀ123;Edehlmnps㖩㖬㖯ሜ㖲㖴㗀㗉㗕㗚㗟㗨㗭耻¹䂹耻²䂲耻³䂳;櫆Āos㖹㖼t;檾ub;櫘Ā;dሢ㗅ot;櫄sĀou㗏㗒l;柉b;櫗arr;楻ult;櫂ĀEe㗤㗦;櫌;抋lus;櫀ƀeiu㗴㘉㘌tƀ;enሜ㗼㘂qĀ;qሢ㖲eqĀ;q㗧㗤m;櫈Ābp㘑㘓;櫔;櫖ƀAan㘜㘠㘭rr;懙rĀhr㘦㘨ë∮Ā;oਫ਩war;椪lig耻ß䃟௡㙑㙝㙠ዎ㙳㙹\0㙾㛂\0\0\0\0\0㛛㜃\0㜉㝬\0\0\0㞇ɲ㙖\0\0㙛get;挖;䏄rë๟ƀaey㙦㙫㙰ron;䅥dil;䅣;䑂lrec;挕r;쀀𝔱Ȁeiko㚆㚝㚵㚼ǲ㚋\0㚑eĀ4fኄኁaƀ;sv㚘㚙㚛䎸ym;䏑Ācn㚢㚲kĀas㚨㚮pproø዁im»ኬsðኞĀas㚺㚮ð዁rn耻þ䃾Ǭ̟㛆⋧es膀×;bd㛏㛐㛘䃗Ā;aᤏ㛕r;樱;樰ƀeps㛡㛣㜀á⩍Ȁ;bcf҆㛬㛰㛴ot;挶ir;櫱Ā;o㛹㛼쀀𝕥rk;櫚á㍢rime;怴ƀaip㜏㜒㝤dåቈ΀adempst㜡㝍㝀㝑㝗㝜㝟ngleʀ;dlqr㜰㜱㜶㝀㝂斵own»ᶻeftĀ;e⠀㜾ñम;扜ightĀ;e㊪㝋ñၚot;旬inus;樺lus;樹b;槍ime;樻ezium;揢ƀcht㝲㝽㞁Āry㝷㝻;쀀𝓉;䑆cy;䑛rok;䅧Āio㞋㞎xô᝷headĀlr㞗㞠eftarro÷ࡏightarrow»ཝऀAHabcdfghlmoprstuw㟐㟓㟗㟤㟰㟼㠎㠜㠣㠴㡑㡝㡫㢩㣌㣒㣪㣶ròϭar;楣Ācr㟜㟢ute耻ú䃺òᅐrǣ㟪\0㟭y;䑞ve;䅭Āiy㟵㟺rc耻û䃻;䑃ƀabh㠃㠆㠋ròᎭlac;䅱aòᏃĀir㠓㠘sht;楾;쀀𝔲rave耻ù䃹š㠧㠱rĀlr㠬㠮»ॗ»ႃlk;斀Āct㠹㡍ɯ㠿\0\0㡊rnĀ;e㡅㡆挜r»㡆op;挏ri;旸Āal㡖㡚cr;䅫肻¨͉Āgp㡢㡦on;䅳f;쀀𝕦̀adhlsuᅋ㡸㡽፲㢑㢠ownáᎳarpoonĀlr㢈㢌efô㠭ighô㠯iƀ;hl㢙㢚㢜䏅»ᏺon»㢚parrows;懈ƀcit㢰㣄㣈ɯ㢶\0\0㣁rnĀ;e㢼㢽挝r»㢽op;挎ng;䅯ri;旹cr;쀀𝓊ƀdir㣙㣝㣢ot;拰lde;䅩iĀ;f㜰㣨»᠓Āam㣯㣲rò㢨l耻ü䃼angle;榧ހABDacdeflnoprsz㤜㤟㤩㤭㦵㦸㦽㧟㧤㧨㧳㧹㧽㨁㨠ròϷarĀ;v㤦㤧櫨;櫩asèϡĀnr㤲㤷grt;榜΀eknprst㓣㥆㥋㥒㥝㥤㦖appá␕othinçẖƀhir㓫⻈㥙opô⾵Ā;hᎷ㥢ïㆍĀiu㥩㥭gmá㎳Ābp㥲㦄setneqĀ;q㥽㦀쀀⊊︀;쀀⫋︀setneqĀ;q㦏㦒쀀⊋︀;쀀⫌︀Āhr㦛㦟etá㚜iangleĀlr㦪㦯eft»थight»ၑy;䐲ash»ံƀelr㧄㧒㧗ƀ;beⷪ㧋㧏ar;抻q;扚lip;拮Ābt㧜ᑨaòᑩr;쀀𝔳tré㦮suĀbp㧯㧱»ജ»൙pf;쀀𝕧roð໻tré㦴Ācu㨆㨋r;쀀𝓋Ābp㨐㨘nĀEe㦀㨖»㥾nĀEe㦒㨞»㦐igzag;榚΀cefoprs㨶㨻㩖㩛㩔㩡㩪irc;䅵Ādi㩀㩑Ābg㩅㩉ar;機eĀ;qᗺ㩏;扙erp;愘r;쀀𝔴pf;쀀𝕨Ā;eᑹ㩦atèᑹcr;쀀𝓌ૣណ㪇\0㪋\0㪐㪛\0\0㪝㪨㪫㪯\0\0㫃㫎\0㫘ៜ៟tré៑r;쀀𝔵ĀAa㪔㪗ròσrò৶;䎾ĀAa㪡㪤ròθrò৫að✓is;拻ƀdptឤ㪵㪾Āfl㪺ឩ;쀀𝕩imåឲĀAa㫇㫊ròώròਁĀcq㫒ីr;쀀𝓍Āpt៖㫜ré។Ѐacefiosu㫰㫽㬈㬌㬑㬕㬛㬡cĀuy㫶㫻te耻ý䃽;䑏Āiy㬂㬆rc;䅷;䑋n耻¥䂥r;쀀𝔶cy;䑗pf;쀀𝕪cr;쀀𝓎Ācm㬦㬩y;䑎l耻ÿ䃿Ԁacdefhiosw㭂㭈㭔㭘㭤㭩㭭㭴㭺㮀cute;䅺Āay㭍㭒ron;䅾;䐷ot;䅼Āet㭝㭡træᕟa;䎶r;쀀𝔷cy;䐶grarr;懝pf;쀀𝕫cr;쀀𝓏Ājn㮅㮇;怍j;怌".split("").map(function(c) {
		return c.charCodeAt(0);
	}));
} });

//#endregion
//#region node_modules/entities/lib/generated/decode-data-xml.js
var require_decode_data_xml = __commonJS({ "node_modules/entities/lib/generated/decode-data-xml.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = new Uint16Array("Ȁaglq	\x1Bɭ\0\0p;䀦os;䀧t;䀾t;䀼uot;䀢".split("").map(function(c) {
		return c.charCodeAt(0);
	}));
} });

//#endregion
//#region node_modules/entities/lib/decode_codepoint.js
var require_decode_codepoint = __commonJS({ "node_modules/entities/lib/decode_codepoint.js"(exports) {
	var _a;
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.replaceCodePoint = exports.fromCodePoint = void 0;
	var decodeMap = new Map([
		[0, 65533],
		[128, 8364],
		[130, 8218],
		[131, 402],
		[132, 8222],
		[133, 8230],
		[134, 8224],
		[135, 8225],
		[136, 710],
		[137, 8240],
		[138, 352],
		[139, 8249],
		[140, 338],
		[142, 381],
		[145, 8216],
		[146, 8217],
		[147, 8220],
		[148, 8221],
		[149, 8226],
		[150, 8211],
		[151, 8212],
		[152, 732],
		[153, 8482],
		[154, 353],
		[155, 8250],
		[156, 339],
		[158, 382],
		[159, 376]
	]);
	/**
	* Polyfill for `String.fromCodePoint`. It is used to create a string from a Unicode code point.
	*/
	exports.fromCodePoint = (_a = String.fromCodePoint) !== null && _a !== void 0 ? _a : function(codePoint) {
		var output = "";
		if (codePoint > 65535) {
			codePoint -= 65536;
			output += String.fromCharCode(codePoint >>> 10 & 1023 | 55296);
			codePoint = 56320 | codePoint & 1023;
		}
		output += String.fromCharCode(codePoint);
		return output;
	};
	/**
	* Replace the given code point with a replacement character if it is a
	* surrogate or is outside the valid range. Otherwise return the code
	* point unchanged.
	*/
	function replaceCodePoint(codePoint) {
		var _a$1;
		if (codePoint >= 55296 && codePoint <= 57343 || codePoint > 1114111) return 65533;
		return (_a$1 = decodeMap.get(codePoint)) !== null && _a$1 !== void 0 ? _a$1 : codePoint;
	}
	exports.replaceCodePoint = replaceCodePoint;
	/**
	* Replace the code point if relevant, then convert it to a string.
	*
	* @deprecated Use `fromCodePoint(replaceCodePoint(codePoint))` instead.
	* @param codePoint The code point to decode.
	* @returns The decoded code point.
	*/
	function decodeCodePoint(codePoint) {
		return (0, exports.fromCodePoint)(replaceCodePoint(codePoint));
	}
	exports.default = decodeCodePoint;
} });

//#endregion
//#region node_modules/entities/lib/decode.js
var require_decode = __commonJS({ "node_modules/entities/lib/decode.js"(exports) {
	var __createBinding$4 = void 0 && (void 0).__createBinding || (Object.create ? function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		var desc = Object.getOwnPropertyDescriptor(m, k);
		if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) desc = {
			enumerable: true,
			get: function() {
				return m[k];
			}
		};
		Object.defineProperty(o, k2, desc);
	} : function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		o[k2] = m[k];
	});
	var __setModuleDefault = void 0 && (void 0).__setModuleDefault || (Object.create ? function(o, v) {
		Object.defineProperty(o, "default", {
			enumerable: true,
			value: v
		});
	} : function(o, v) {
		o["default"] = v;
	});
	var __importStar = void 0 && (void 0).__importStar || function(mod) {
		if (mod && mod.__esModule) return mod;
		var result = {};
		if (mod != null) {
			for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding$4(result, mod, k);
		}
		__setModuleDefault(result, mod);
		return result;
	};
	var __importDefault = void 0 && (void 0).__importDefault || function(mod) {
		return mod && mod.__esModule ? mod : { "default": mod };
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.decodeXML = exports.decodeHTMLStrict = exports.decodeHTMLAttribute = exports.decodeHTML = exports.determineBranch = exports.EntityDecoder = exports.DecodingMode = exports.BinTrieFlags = exports.fromCodePoint = exports.replaceCodePoint = exports.decodeCodePoint = exports.xmlDecodeTree = exports.htmlDecodeTree = void 0;
	var decode_data_html_js_1 = __importDefault(require_decode_data_html());
	exports.htmlDecodeTree = decode_data_html_js_1.default;
	var decode_data_xml_js_1 = __importDefault(require_decode_data_xml());
	exports.xmlDecodeTree = decode_data_xml_js_1.default;
	var decode_codepoint_js_1 = __importStar(require_decode_codepoint());
	exports.decodeCodePoint = decode_codepoint_js_1.default;
	var decode_codepoint_js_2 = require_decode_codepoint();
	Object.defineProperty(exports, "replaceCodePoint", {
		enumerable: true,
		get: function() {
			return decode_codepoint_js_2.replaceCodePoint;
		}
	});
	Object.defineProperty(exports, "fromCodePoint", {
		enumerable: true,
		get: function() {
			return decode_codepoint_js_2.fromCodePoint;
		}
	});
	var CharCodes;
	(function(CharCodes$1) {
		CharCodes$1[CharCodes$1["NUM"] = 35] = "NUM";
		CharCodes$1[CharCodes$1["SEMI"] = 59] = "SEMI";
		CharCodes$1[CharCodes$1["EQUALS"] = 61] = "EQUALS";
		CharCodes$1[CharCodes$1["ZERO"] = 48] = "ZERO";
		CharCodes$1[CharCodes$1["NINE"] = 57] = "NINE";
		CharCodes$1[CharCodes$1["LOWER_A"] = 97] = "LOWER_A";
		CharCodes$1[CharCodes$1["LOWER_F"] = 102] = "LOWER_F";
		CharCodes$1[CharCodes$1["LOWER_X"] = 120] = "LOWER_X";
		CharCodes$1[CharCodes$1["LOWER_Z"] = 122] = "LOWER_Z";
		CharCodes$1[CharCodes$1["UPPER_A"] = 65] = "UPPER_A";
		CharCodes$1[CharCodes$1["UPPER_F"] = 70] = "UPPER_F";
		CharCodes$1[CharCodes$1["UPPER_Z"] = 90] = "UPPER_Z";
	})(CharCodes || (CharCodes = {}));
	/** Bit that needs to be set to convert an upper case ASCII character to lower case */
	var TO_LOWER_BIT = 32;
	var BinTrieFlags;
	(function(BinTrieFlags$1) {
		BinTrieFlags$1[BinTrieFlags$1["VALUE_LENGTH"] = 49152] = "VALUE_LENGTH";
		BinTrieFlags$1[BinTrieFlags$1["BRANCH_LENGTH"] = 16256] = "BRANCH_LENGTH";
		BinTrieFlags$1[BinTrieFlags$1["JUMP_TABLE"] = 127] = "JUMP_TABLE";
	})(BinTrieFlags = exports.BinTrieFlags || (exports.BinTrieFlags = {}));
	function isNumber$1(code$1) {
		return code$1 >= CharCodes.ZERO && code$1 <= CharCodes.NINE;
	}
	function isHexadecimalCharacter(code$1) {
		return code$1 >= CharCodes.UPPER_A && code$1 <= CharCodes.UPPER_F || code$1 >= CharCodes.LOWER_A && code$1 <= CharCodes.LOWER_F;
	}
	function isAsciiAlphaNumeric(code$1) {
		return code$1 >= CharCodes.UPPER_A && code$1 <= CharCodes.UPPER_Z || code$1 >= CharCodes.LOWER_A && code$1 <= CharCodes.LOWER_Z || isNumber$1(code$1);
	}
	/**
	* Checks if the given character is a valid end character for an entity in an attribute.
	*
	* Attribute values that aren't terminated properly aren't parsed, and shouldn't lead to a parser error.
	* See the example in https://html.spec.whatwg.org/multipage/parsing.html#named-character-reference-state
	*/
	function isEntityInAttributeInvalidEnd(code$1) {
		return code$1 === CharCodes.EQUALS || isAsciiAlphaNumeric(code$1);
	}
	var EntityDecoderState;
	(function(EntityDecoderState$1) {
		EntityDecoderState$1[EntityDecoderState$1["EntityStart"] = 0] = "EntityStart";
		EntityDecoderState$1[EntityDecoderState$1["NumericStart"] = 1] = "NumericStart";
		EntityDecoderState$1[EntityDecoderState$1["NumericDecimal"] = 2] = "NumericDecimal";
		EntityDecoderState$1[EntityDecoderState$1["NumericHex"] = 3] = "NumericHex";
		EntityDecoderState$1[EntityDecoderState$1["NamedEntity"] = 4] = "NamedEntity";
	})(EntityDecoderState || (EntityDecoderState = {}));
	var DecodingMode;
	(function(DecodingMode$1) {
		/** Entities in text nodes that can end with any character. */
		DecodingMode$1[DecodingMode$1["Legacy"] = 0] = "Legacy";
		/** Only allow entities terminated with a semicolon. */
		DecodingMode$1[DecodingMode$1["Strict"] = 1] = "Strict";
		/** Entities in attributes have limitations on ending characters. */
		DecodingMode$1[DecodingMode$1["Attribute"] = 2] = "Attribute";
	})(DecodingMode = exports.DecodingMode || (exports.DecodingMode = {}));
	/**
	* Token decoder with support of writing partial entities.
	*/
	var EntityDecoder = function() {
		function EntityDecoder$1(decodeTree, emitCodePoint, errors) {
			this.decodeTree = decodeTree;
			this.emitCodePoint = emitCodePoint;
			this.errors = errors;
			/** The current state of the decoder. */
			this.state = EntityDecoderState.EntityStart;
			/** Characters that were consumed while parsing an entity. */
			this.consumed = 1;
			/**
			* The result of the entity.
			*
			* Either the result index of a numeric entity, or the codepoint of a
			* numeric entity.
			*/
			this.result = 0;
			/** The current index in the decode tree. */
			this.treeIndex = 0;
			/** The number of characters that were consumed in excess. */
			this.excess = 1;
			/** The mode in which the decoder is operating. */
			this.decodeMode = DecodingMode.Strict;
		}
		/** Resets the instance to make it reusable. */
		EntityDecoder$1.prototype.startEntity = function(decodeMode) {
			this.decodeMode = decodeMode;
			this.state = EntityDecoderState.EntityStart;
			this.result = 0;
			this.treeIndex = 0;
			this.excess = 1;
			this.consumed = 1;
		};
		/**
		* Write an entity to the decoder. This can be called multiple times with partial entities.
		* If the entity is incomplete, the decoder will return -1.
		*
		* Mirrors the implementation of `getDecoder`, but with the ability to stop decoding if the
		* entity is incomplete, and resume when the next string is written.
		*
		* @param string The string containing the entity (or a continuation of the entity).
		* @param offset The offset at which the entity begins. Should be 0 if this is not the first call.
		* @returns The number of characters that were consumed, or -1 if the entity is incomplete.
		*/
		EntityDecoder$1.prototype.write = function(str$1, offset) {
			switch (this.state) {
				case EntityDecoderState.EntityStart: {
					if (str$1.charCodeAt(offset) === CharCodes.NUM) {
						this.state = EntityDecoderState.NumericStart;
						this.consumed += 1;
						return this.stateNumericStart(str$1, offset + 1);
					}
					this.state = EntityDecoderState.NamedEntity;
					return this.stateNamedEntity(str$1, offset);
				}
				case EntityDecoderState.NumericStart: return this.stateNumericStart(str$1, offset);
				case EntityDecoderState.NumericDecimal: return this.stateNumericDecimal(str$1, offset);
				case EntityDecoderState.NumericHex: return this.stateNumericHex(str$1, offset);
				case EntityDecoderState.NamedEntity: return this.stateNamedEntity(str$1, offset);
			}
		};
		/**
		* Switches between the numeric decimal and hexadecimal states.
		*
		* Equivalent to the `Numeric character reference state` in the HTML spec.
		*
		* @param str The string containing the entity (or a continuation of the entity).
		* @param offset The current offset.
		* @returns The number of characters that were consumed, or -1 if the entity is incomplete.
		*/
		EntityDecoder$1.prototype.stateNumericStart = function(str$1, offset) {
			if (offset >= str$1.length) return -1;
			if ((str$1.charCodeAt(offset) | TO_LOWER_BIT) === CharCodes.LOWER_X) {
				this.state = EntityDecoderState.NumericHex;
				this.consumed += 1;
				return this.stateNumericHex(str$1, offset + 1);
			}
			this.state = EntityDecoderState.NumericDecimal;
			return this.stateNumericDecimal(str$1, offset);
		};
		EntityDecoder$1.prototype.addToNumericResult = function(str$1, start, end, base) {
			if (start !== end) {
				var digitCount = end - start;
				this.result = this.result * Math.pow(base, digitCount) + parseInt(str$1.substr(start, digitCount), base);
				this.consumed += digitCount;
			}
		};
		/**
		* Parses a hexadecimal numeric entity.
		*
		* Equivalent to the `Hexademical character reference state` in the HTML spec.
		*
		* @param str The string containing the entity (or a continuation of the entity).
		* @param offset The current offset.
		* @returns The number of characters that were consumed, or -1 if the entity is incomplete.
		*/
		EntityDecoder$1.prototype.stateNumericHex = function(str$1, offset) {
			var startIdx = offset;
			while (offset < str$1.length) {
				var char = str$1.charCodeAt(offset);
				if (isNumber$1(char) || isHexadecimalCharacter(char)) offset += 1;
				else {
					this.addToNumericResult(str$1, startIdx, offset, 16);
					return this.emitNumericEntity(char, 3);
				}
			}
			this.addToNumericResult(str$1, startIdx, offset, 16);
			return -1;
		};
		/**
		* Parses a decimal numeric entity.
		*
		* Equivalent to the `Decimal character reference state` in the HTML spec.
		*
		* @param str The string containing the entity (or a continuation of the entity).
		* @param offset The current offset.
		* @returns The number of characters that were consumed, or -1 if the entity is incomplete.
		*/
		EntityDecoder$1.prototype.stateNumericDecimal = function(str$1, offset) {
			var startIdx = offset;
			while (offset < str$1.length) {
				var char = str$1.charCodeAt(offset);
				if (isNumber$1(char)) offset += 1;
				else {
					this.addToNumericResult(str$1, startIdx, offset, 10);
					return this.emitNumericEntity(char, 2);
				}
			}
			this.addToNumericResult(str$1, startIdx, offset, 10);
			return -1;
		};
		/**
		* Validate and emit a numeric entity.
		*
		* Implements the logic from the `Hexademical character reference start
		* state` and `Numeric character reference end state` in the HTML spec.
		*
		* @param lastCp The last code point of the entity. Used to see if the
		*               entity was terminated with a semicolon.
		* @param expectedLength The minimum number of characters that should be
		*                       consumed. Used to validate that at least one digit
		*                       was consumed.
		* @returns The number of characters that were consumed.
		*/
		EntityDecoder$1.prototype.emitNumericEntity = function(lastCp, expectedLength) {
			var _a$1;
			if (this.consumed <= expectedLength) {
				(_a$1 = this.errors) === null || _a$1 === void 0 || _a$1.absenceOfDigitsInNumericCharacterReference(this.consumed);
				return 0;
			}
			if (lastCp === CharCodes.SEMI) this.consumed += 1;
			else if (this.decodeMode === DecodingMode.Strict) return 0;
			this.emitCodePoint((0, decode_codepoint_js_1.replaceCodePoint)(this.result), this.consumed);
			if (this.errors) {
				if (lastCp !== CharCodes.SEMI) this.errors.missingSemicolonAfterCharacterReference();
				this.errors.validateNumericCharacterReference(this.result);
			}
			return this.consumed;
		};
		/**
		* Parses a named entity.
		*
		* Equivalent to the `Named character reference state` in the HTML spec.
		*
		* @param str The string containing the entity (or a continuation of the entity).
		* @param offset The current offset.
		* @returns The number of characters that were consumed, or -1 if the entity is incomplete.
		*/
		EntityDecoder$1.prototype.stateNamedEntity = function(str$1, offset) {
			var decodeTree = this.decodeTree;
			var current = decodeTree[this.treeIndex];
			var valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
			for (; offset < str$1.length; offset++, this.excess++) {
				var char = str$1.charCodeAt(offset);
				this.treeIndex = determineBranch(decodeTree, current, this.treeIndex + Math.max(1, valueLength), char);
				if (this.treeIndex < 0) return this.result === 0 || this.decodeMode === DecodingMode.Attribute && (valueLength === 0 || isEntityInAttributeInvalidEnd(char)) ? 0 : this.emitNotTerminatedNamedEntity();
				current = decodeTree[this.treeIndex];
				valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
				if (valueLength !== 0) {
					if (char === CharCodes.SEMI) return this.emitNamedEntityData(this.treeIndex, valueLength, this.consumed + this.excess);
					if (this.decodeMode !== DecodingMode.Strict) {
						this.result = this.treeIndex;
						this.consumed += this.excess;
						this.excess = 0;
					}
				}
			}
			return -1;
		};
		/**
		* Emit a named entity that was not terminated with a semicolon.
		*
		* @returns The number of characters consumed.
		*/
		EntityDecoder$1.prototype.emitNotTerminatedNamedEntity = function() {
			var _a$1;
			var _b = this, result = _b.result, decodeTree = _b.decodeTree;
			var valueLength = (decodeTree[result] & BinTrieFlags.VALUE_LENGTH) >> 14;
			this.emitNamedEntityData(result, valueLength, this.consumed);
			(_a$1 = this.errors) === null || _a$1 === void 0 || _a$1.missingSemicolonAfterCharacterReference();
			return this.consumed;
		};
		/**
		* Emit a named entity.
		*
		* @param result The index of the entity in the decode tree.
		* @param valueLength The number of bytes in the entity.
		* @param consumed The number of characters consumed.
		*
		* @returns The number of characters consumed.
		*/
		EntityDecoder$1.prototype.emitNamedEntityData = function(result, valueLength, consumed) {
			var decodeTree = this.decodeTree;
			this.emitCodePoint(valueLength === 1 ? decodeTree[result] & ~BinTrieFlags.VALUE_LENGTH : decodeTree[result + 1], consumed);
			if (valueLength === 3) this.emitCodePoint(decodeTree[result + 2], consumed);
			return consumed;
		};
		/**
		* Signal to the parser that the end of the input was reached.
		*
		* Remaining data will be emitted and relevant errors will be produced.
		*
		* @returns The number of characters consumed.
		*/
		EntityDecoder$1.prototype.end = function() {
			var _a$1;
			switch (this.state) {
				case EntityDecoderState.NamedEntity: return this.result !== 0 && (this.decodeMode !== DecodingMode.Attribute || this.result === this.treeIndex) ? this.emitNotTerminatedNamedEntity() : 0;
				case EntityDecoderState.NumericDecimal: return this.emitNumericEntity(0, 2);
				case EntityDecoderState.NumericHex: return this.emitNumericEntity(0, 3);
				case EntityDecoderState.NumericStart: {
					(_a$1 = this.errors) === null || _a$1 === void 0 || _a$1.absenceOfDigitsInNumericCharacterReference(this.consumed);
					return 0;
				}
				case EntityDecoderState.EntityStart: return 0;
			}
		};
		return EntityDecoder$1;
	}();
	exports.EntityDecoder = EntityDecoder;
	/**
	* Creates a function that decodes entities in a string.
	*
	* @param decodeTree The decode tree.
	* @returns A function that decodes entities in a string.
	*/
	function getDecoder(decodeTree) {
		var ret = "";
		var decoder = new EntityDecoder(decodeTree, function(str$1) {
			return ret += (0, decode_codepoint_js_1.fromCodePoint)(str$1);
		});
		return function decodeWithTrie(str$1, decodeMode) {
			var lastIndex = 0;
			var offset = 0;
			while ((offset = str$1.indexOf("&", offset)) >= 0) {
				ret += str$1.slice(lastIndex, offset);
				decoder.startEntity(decodeMode);
				var len$1 = decoder.write(str$1, offset + 1);
				if (len$1 < 0) {
					lastIndex = offset + decoder.end();
					break;
				}
				lastIndex = offset + len$1;
				offset = len$1 === 0 ? lastIndex + 1 : lastIndex;
			}
			var result = ret + str$1.slice(lastIndex);
			ret = "";
			return result;
		};
	}
	/**
	* Determines the branch of the current node that is taken given the current
	* character. This function is used to traverse the trie.
	*
	* @param decodeTree The trie.
	* @param current The current node.
	* @param nodeIdx The index right after the current node and its value.
	* @param char The current character.
	* @returns The index of the next node, or -1 if no branch is taken.
	*/
	function determineBranch(decodeTree, current, nodeIdx, char) {
		var branchCount = (current & BinTrieFlags.BRANCH_LENGTH) >> 7;
		var jumpOffset = current & BinTrieFlags.JUMP_TABLE;
		if (branchCount === 0) return jumpOffset !== 0 && char === jumpOffset ? nodeIdx : -1;
		if (jumpOffset) {
			var value = char - jumpOffset;
			return value < 0 || value >= branchCount ? -1 : decodeTree[nodeIdx + value] - 1;
		}
		var lo = nodeIdx;
		var hi = lo + branchCount - 1;
		while (lo <= hi) {
			var mid = lo + hi >>> 1;
			var midVal = decodeTree[mid];
			if (midVal < char) lo = mid + 1;
			else if (midVal > char) hi = mid - 1;
			else return decodeTree[mid + branchCount];
		}
		return -1;
	}
	exports.determineBranch = determineBranch;
	var htmlDecoder = getDecoder(decode_data_html_js_1.default);
	var xmlDecoder = getDecoder(decode_data_xml_js_1.default);
	/**
	* Decodes an HTML string.
	*
	* @param str The string to decode.
	* @param mode The decoding mode.
	* @returns The decoded string.
	*/
	function decodeHTML(str$1, mode) {
		if (mode === void 0) mode = DecodingMode.Legacy;
		return htmlDecoder(str$1, mode);
	}
	exports.decodeHTML = decodeHTML;
	/**
	* Decodes an HTML string in an attribute.
	*
	* @param str The string to decode.
	* @returns The decoded string.
	*/
	function decodeHTMLAttribute(str$1) {
		return htmlDecoder(str$1, DecodingMode.Attribute);
	}
	exports.decodeHTMLAttribute = decodeHTMLAttribute;
	/**
	* Decodes an HTML string, requiring all entities to be terminated by a semicolon.
	*
	* @param str The string to decode.
	* @returns The decoded string.
	*/
	function decodeHTMLStrict(str$1) {
		return htmlDecoder(str$1, DecodingMode.Strict);
	}
	exports.decodeHTMLStrict = decodeHTMLStrict;
	/**
	* Decodes an XML string, requiring all entities to be terminated by a semicolon.
	*
	* @param str The string to decode.
	* @returns The decoded string.
	*/
	function decodeXML(str$1) {
		return xmlDecoder(str$1, DecodingMode.Strict);
	}
	exports.decodeXML = decodeXML;
} });

//#endregion
//#region node_modules/@babel/parser/lib/index.js
var require_lib = __commonJS({ "node_modules/@babel/parser/lib/index.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	function _objectWithoutPropertiesLoose(r, e) {
		if (null == r) return {};
		var t = {};
		for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
			if (-1 !== e.indexOf(n)) continue;
			t[n] = r[n];
		}
		return t;
	}
	var Position = class {
		constructor(line, col, index$1) {
			this.line = void 0;
			this.column = void 0;
			this.index = void 0;
			this.line = line;
			this.column = col;
			this.index = index$1;
		}
	};
	var SourceLocation = class {
		constructor(start, end) {
			this.start = void 0;
			this.end = void 0;
			this.filename = void 0;
			this.identifierName = void 0;
			this.start = start;
			this.end = end;
		}
	};
	function createPositionWithColumnOffset(position, columnOffset) {
		const { line, column, index: index$1 } = position;
		return new Position(line, column + columnOffset, index$1 + columnOffset);
	}
	const code = "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED";
	var ModuleErrors = {
		ImportMetaOutsideModule: {
			message: `import.meta may appear only with 'sourceType: "module"'`,
			code
		},
		ImportOutsideModule: {
			message: `'import' and 'export' may appear only with 'sourceType: "module"'`,
			code
		}
	};
	const NodeDescriptions = {
		ArrayPattern: "array destructuring pattern",
		AssignmentExpression: "assignment expression",
		AssignmentPattern: "assignment expression",
		ArrowFunctionExpression: "arrow function expression",
		ConditionalExpression: "conditional expression",
		CatchClause: "catch clause",
		ForOfStatement: "for-of statement",
		ForInStatement: "for-in statement",
		ForStatement: "for-loop",
		FormalParameters: "function parameter list",
		Identifier: "identifier",
		ImportSpecifier: "import specifier",
		ImportDefaultSpecifier: "import default specifier",
		ImportNamespaceSpecifier: "import namespace specifier",
		ObjectPattern: "object destructuring pattern",
		ParenthesizedExpression: "parenthesized expression",
		RestElement: "rest element",
		UpdateExpression: {
			true: "prefix operation",
			false: "postfix operation"
		},
		VariableDeclarator: "variable declaration",
		YieldExpression: "yield expression"
	};
	const toNodeDescription = (node) => node.type === "UpdateExpression" ? NodeDescriptions.UpdateExpression[`${node.prefix}`] : NodeDescriptions[node.type];
	var StandardErrors = {
		AccessorIsGenerator: ({ kind }) => `A ${kind}ter cannot be a generator.`,
		ArgumentsInClass: "'arguments' is only allowed in functions and class methods.",
		AsyncFunctionInSingleStatementContext: "Async functions can only be declared at the top level or inside a block.",
		AwaitBindingIdentifier: "Can not use 'await' as identifier inside an async function.",
		AwaitBindingIdentifierInStaticBlock: "Can not use 'await' as identifier inside a static block.",
		AwaitExpressionFormalParameter: "'await' is not allowed in async function parameters.",
		AwaitUsingNotInAsyncContext: "'await using' is only allowed within async functions and at the top levels of modules.",
		AwaitNotInAsyncContext: "'await' is only allowed within async functions and at the top levels of modules.",
		BadGetterArity: "A 'get' accessor must not have any formal parameters.",
		BadSetterArity: "A 'set' accessor must have exactly one formal parameter.",
		BadSetterRestParameter: "A 'set' accessor function argument must not be a rest parameter.",
		ConstructorClassField: "Classes may not have a field named 'constructor'.",
		ConstructorClassPrivateField: "Classes may not have a private field named '#constructor'.",
		ConstructorIsAccessor: "Class constructor may not be an accessor.",
		ConstructorIsAsync: "Constructor can't be an async function.",
		ConstructorIsGenerator: "Constructor can't be a generator.",
		DeclarationMissingInitializer: ({ kind }) => `Missing initializer in ${kind} declaration.`,
		DecoratorArgumentsOutsideParentheses: "Decorator arguments must be moved inside parentheses: use '@(decorator(args))' instead of '@(decorator)(args)'.",
		DecoratorBeforeExport: "Decorators must be placed *before* the 'export' keyword. Remove the 'decoratorsBeforeExport: true' option to use the 'export @decorator class {}' syntax.",
		DecoratorsBeforeAfterExport: "Decorators can be placed *either* before or after the 'export' keyword, but not in both locations at the same time.",
		DecoratorConstructor: "Decorators can't be used with a constructor. Did you mean '@dec class { ... }'?",
		DecoratorExportClass: "Decorators must be placed *after* the 'export' keyword. Remove the 'decoratorsBeforeExport: false' option to use the '@decorator export class {}' syntax.",
		DecoratorSemicolon: "Decorators must not be followed by a semicolon.",
		DecoratorStaticBlock: "Decorators can't be used with a static block.",
		DeferImportRequiresNamespace: "Only `import defer * as x from \"./module\"` is valid.",
		DeletePrivateField: "Deleting a private field is not allowed.",
		DestructureNamedImport: "ES2015 named imports do not destructure. Use another statement for destructuring after the import.",
		DuplicateConstructor: "Duplicate constructor in the same class.",
		DuplicateDefaultExport: "Only one default export allowed per module.",
		DuplicateExport: ({ exportName }) => `\`${exportName}\` has already been exported. Exported identifiers must be unique.`,
		DuplicateProto: "Redefinition of __proto__ property.",
		DuplicateRegExpFlags: "Duplicate regular expression flag.",
		ElementAfterRest: "Rest element must be last element.",
		EscapedCharNotAnIdentifier: "Invalid Unicode escape.",
		ExportBindingIsString: ({ localName, exportName }) => `A string literal cannot be used as an exported binding without \`from\`.\n- Did you mean \`export { '${localName}' as '${exportName}' } from 'some-module'\`?`,
		ExportDefaultFromAsIdentifier: "'from' is not allowed as an identifier after 'export default'.",
		ForInOfLoopInitializer: ({ type }) => `'${type === "ForInStatement" ? "for-in" : "for-of"}' loop variable declaration may not have an initializer.`,
		ForInUsing: "For-in loop may not start with 'using' declaration.",
		ForOfAsync: "The left-hand side of a for-of loop may not be 'async'.",
		ForOfLet: "The left-hand side of a for-of loop may not start with 'let'.",
		GeneratorInSingleStatementContext: "Generators can only be declared at the top level or inside a block.",
		IllegalBreakContinue: ({ type }) => `Unsyntactic ${type === "BreakStatement" ? "break" : "continue"}.`,
		IllegalLanguageModeDirective: "Illegal 'use strict' directive in function with non-simple parameter list.",
		IllegalReturn: "'return' outside of function.",
		ImportAttributesUseAssert: "The `assert` keyword in import attributes is deprecated and it has been replaced by the `with` keyword. You can enable the `deprecatedImportAssert` parser plugin to suppress this error.",
		ImportBindingIsString: ({ importName }) => `A string literal cannot be used as an imported binding.\n- Did you mean \`import { "${importName}" as foo }\`?`,
		ImportCallArity: `\`import()\` requires exactly one or two arguments.`,
		ImportCallNotNewExpression: "Cannot use new with import(...).",
		ImportCallSpreadArgument: "`...` is not allowed in `import()`.",
		ImportJSONBindingNotDefault: "A JSON module can only be imported with `default`.",
		ImportReflectionHasAssertion: "`import module x` cannot have assertions.",
		ImportReflectionNotBinding: "Only `import module x from \"./module\"` is valid.",
		IncompatibleRegExpUVFlags: "The 'u' and 'v' regular expression flags cannot be enabled at the same time.",
		InvalidBigIntLiteral: "Invalid BigIntLiteral.",
		InvalidCodePoint: "Code point out of bounds.",
		InvalidCoverDiscardElement: "'void' must be followed by an expression when not used in a binding position.",
		InvalidCoverInitializedName: "Invalid shorthand property initializer.",
		InvalidDecimal: "Invalid decimal.",
		InvalidDigit: ({ radix }) => `Expected number in radix ${radix}.`,
		InvalidEscapeSequence: "Bad character escape sequence.",
		InvalidEscapeSequenceTemplate: "Invalid escape sequence in template.",
		InvalidEscapedReservedWord: ({ reservedWord }) => `Escape sequence in keyword ${reservedWord}.`,
		InvalidIdentifier: ({ identifierName }) => `Invalid identifier ${identifierName}.`,
		InvalidLhs: ({ ancestor }) => `Invalid left-hand side in ${toNodeDescription(ancestor)}.`,
		InvalidLhsBinding: ({ ancestor }) => `Binding invalid left-hand side in ${toNodeDescription(ancestor)}.`,
		InvalidLhsOptionalChaining: ({ ancestor }) => `Invalid optional chaining in the left-hand side of ${toNodeDescription(ancestor)}.`,
		InvalidNumber: "Invalid number.",
		InvalidOrMissingExponent: "Floating-point numbers require a valid exponent after the 'e'.",
		InvalidOrUnexpectedToken: ({ unexpected }) => `Unexpected character '${unexpected}'.`,
		InvalidParenthesizedAssignment: "Invalid parenthesized assignment pattern.",
		InvalidPrivateFieldResolution: ({ identifierName }) => `Private name #${identifierName} is not defined.`,
		InvalidPropertyBindingPattern: "Binding member expression.",
		InvalidRecordProperty: "Only properties and spread elements are allowed in record definitions.",
		InvalidRestAssignmentPattern: "Invalid rest operator's argument.",
		LabelRedeclaration: ({ labelName }) => `Label '${labelName}' is already declared.`,
		LetInLexicalBinding: "'let' is disallowed as a lexically bound name.",
		LineTerminatorBeforeArrow: "No line break is allowed before '=>'.",
		MalformedRegExpFlags: "Invalid regular expression flag.",
		MissingClassName: "A class name is required.",
		MissingEqInAssignment: "Only '=' operator can be used for specifying default value.",
		MissingSemicolon: "Missing semicolon.",
		MissingPlugin: ({ missingPlugin }) => `This experimental syntax requires enabling the parser plugin: ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
		MissingOneOfPlugins: ({ missingPlugin }) => `This experimental syntax requires enabling one of the following parser plugin(s): ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
		MissingUnicodeEscape: "Expecting Unicode escape sequence \\uXXXX.",
		MixingCoalesceWithLogical: "Nullish coalescing operator(??) requires parens when mixing with logical operators.",
		ModuleAttributeDifferentFromType: "The only accepted module attribute is `type`.",
		ModuleAttributeInvalidValue: "Only string literals are allowed as module attribute values.",
		ModuleAttributesWithDuplicateKeys: ({ key }) => `Duplicate key "${key}" is not allowed in module attributes.`,
		ModuleExportNameHasLoneSurrogate: ({ surrogateCharCode }) => `An export name cannot include a lone surrogate, found '\\u${surrogateCharCode.toString(16)}'.`,
		ModuleExportUndefined: ({ localName }) => `Export '${localName}' is not defined.`,
		MultipleDefaultsInSwitch: "Multiple default clauses.",
		NewlineAfterThrow: "Illegal newline after throw.",
		NoCatchOrFinally: "Missing catch or finally clause.",
		NumberIdentifier: "Identifier directly after number.",
		NumericSeparatorInEscapeSequence: "Numeric separators are not allowed inside unicode escape sequences or hex escape sequences.",
		ObsoleteAwaitStar: "'await*' has been removed from the async functions proposal. Use Promise.all() instead.",
		OptionalChainingNoNew: "Constructors in/after an Optional Chain are not allowed.",
		OptionalChainingNoTemplate: "Tagged Template Literals are not allowed in optionalChain.",
		OverrideOnConstructor: "'override' modifier cannot appear on a constructor declaration.",
		ParamDupe: "Argument name clash.",
		PatternHasAccessor: "Object pattern can't contain getter or setter.",
		PatternHasMethod: "Object pattern can't contain methods.",
		PrivateInExpectedIn: ({ identifierName }) => `Private names are only allowed in property accesses (\`obj.#${identifierName}\`) or in \`in\` expressions (\`#${identifierName} in obj\`).`,
		PrivateNameRedeclaration: ({ identifierName }) => `Duplicate private name #${identifierName}.`,
		RecordExpressionBarIncorrectEndSyntaxType: "Record expressions ending with '|}' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
		RecordExpressionBarIncorrectStartSyntaxType: "Record expressions starting with '{|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
		RecordExpressionHashIncorrectStartSyntaxType: "Record expressions starting with '#{' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
		RecordNoProto: "'__proto__' is not allowed in Record expressions.",
		RestTrailingComma: "Unexpected trailing comma after rest element.",
		SloppyFunction: "In non-strict mode code, functions can only be declared at top level or inside a block.",
		SloppyFunctionAnnexB: "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement.",
		SourcePhaseImportRequiresDefault: "Only `import source x from \"./module\"` is valid.",
		StaticPrototype: "Classes may not have static property named prototype.",
		SuperNotAllowed: "`super()` is only valid inside a class constructor of a subclass. Maybe a typo in the method name ('constructor') or not extending another class?",
		SuperPrivateField: "Private fields can't be accessed on super.",
		TrailingDecorator: "Decorators must be attached to a class element.",
		TupleExpressionBarIncorrectEndSyntaxType: "Tuple expressions ending with '|]' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
		TupleExpressionBarIncorrectStartSyntaxType: "Tuple expressions starting with '[|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
		TupleExpressionHashIncorrectStartSyntaxType: "Tuple expressions starting with '#[' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
		UnexpectedArgumentPlaceholder: "Unexpected argument placeholder.",
		UnexpectedAwaitAfterPipelineBody: "Unexpected \"await\" after pipeline body; await must have parentheses in minimal proposal.",
		UnexpectedDigitAfterHash: "Unexpected digit after hash token.",
		UnexpectedImportExport: "'import' and 'export' may only appear at the top level.",
		UnexpectedKeyword: ({ keyword }) => `Unexpected keyword '${keyword}'.`,
		UnexpectedLeadingDecorator: "Leading decorators must be attached to a class declaration.",
		UnexpectedLexicalDeclaration: "Lexical declaration cannot appear in a single-statement context.",
		UnexpectedNewTarget: "`new.target` can only be used in functions or class properties.",
		UnexpectedNumericSeparator: "A numeric separator is only allowed between two digits.",
		UnexpectedPrivateField: "Unexpected private name.",
		UnexpectedReservedWord: ({ reservedWord }) => `Unexpected reserved word '${reservedWord}'.`,
		UnexpectedSuper: "'super' is only allowed in object methods and classes.",
		UnexpectedToken: ({ expected, unexpected }) => `Unexpected token${unexpected ? ` '${unexpected}'.` : ""}${expected ? `, expected "${expected}"` : ""}`,
		UnexpectedTokenUnaryExponentiation: "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.",
		UnexpectedUsingDeclaration: "Using declaration cannot appear in the top level when source type is `script` or in the bare case statement.",
		UnexpectedVoidPattern: "Unexpected void binding.",
		UnsupportedBind: "Binding should be performed on object property.",
		UnsupportedDecoratorExport: "A decorated export must export a class declaration.",
		UnsupportedDefaultExport: "Only expressions, functions or classes are allowed as the `default` export.",
		UnsupportedImport: "`import` can only be used in `import()` or `import.meta`.",
		UnsupportedMetaProperty: ({ target: target$1, onlyValidPropertyName }) => `The only valid meta property for ${target$1} is ${target$1}.${onlyValidPropertyName}.`,
		UnsupportedParameterDecorator: "Decorators cannot be used to decorate parameters.",
		UnsupportedPropertyDecorator: "Decorators cannot be used to decorate object literal properties.",
		UnsupportedSuper: "'super' can only be used with function calls (i.e. super()) or in property accesses (i.e. super.prop or super[prop]).",
		UnterminatedComment: "Unterminated comment.",
		UnterminatedRegExp: "Unterminated regular expression.",
		UnterminatedString: "Unterminated string constant.",
		UnterminatedTemplate: "Unterminated template.",
		UsingDeclarationExport: "Using declaration cannot be exported.",
		UsingDeclarationHasBindingPattern: "Using declaration cannot have destructuring patterns.",
		VarRedeclaration: ({ identifierName }) => `Identifier '${identifierName}' has already been declared.`,
		VoidPatternCatchClauseParam: "A void binding can not be the catch clause parameter. Use `try { ... } catch { ... }` if you want to discard the caught error.",
		VoidPatternInitializer: "A void binding may not have an initializer.",
		YieldBindingIdentifier: "Can not use 'yield' as identifier inside a generator.",
		YieldInParameter: "Yield expression is not allowed in formal parameters.",
		YieldNotInGeneratorFunction: "'yield' is only allowed within generator functions.",
		ZeroDigitNumericSeparator: "Numeric separator can not be used after leading 0."
	};
	var StrictModeErrors = {
		StrictDelete: "Deleting local variable in strict mode.",
		StrictEvalArguments: ({ referenceName }) => `Assigning to '${referenceName}' in strict mode.`,
		StrictEvalArgumentsBinding: ({ bindingName }) => `Binding '${bindingName}' in strict mode.`,
		StrictFunction: "In strict mode code, functions can only be declared at top level or inside a block.",
		StrictNumericEscape: "The only valid numeric escape in strict mode is '\\0'.",
		StrictOctalLiteral: "Legacy octal literals are not allowed in strict mode.",
		StrictWith: "'with' in strict mode."
	};
	var ParseExpressionErrors = {
		ParseExpressionEmptyInput: "Unexpected parseExpression() input: The input is empty or contains only comments.",
		ParseExpressionExpectsEOF: ({ unexpected }) => `Unexpected parseExpression() input: The input should contain exactly one expression, but the first expression is followed by the unexpected character \`${String.fromCodePoint(unexpected)}\`.`
	};
	const UnparenthesizedPipeBodyDescriptions = new Set([
		"ArrowFunctionExpression",
		"AssignmentExpression",
		"ConditionalExpression",
		"YieldExpression"
	]);
	var PipelineOperatorErrors = Object.assign({
		PipeBodyIsTighter: "Unexpected yield after pipeline body; any yield expression acting as Hack-style pipe body must be parenthesized due to its loose operator precedence.",
		PipeTopicRequiresHackPipes: "Topic reference is used, but the pipelineOperator plugin was not passed a \"proposal\": \"hack\" or \"smart\" option.",
		PipeTopicUnbound: "Topic reference is unbound; it must be inside a pipe body.",
		PipeTopicUnconfiguredToken: ({ token }) => `Invalid topic token ${token}. In order to use ${token} as a topic reference, the pipelineOperator plugin must be configured with { "proposal": "hack", "topicToken": "${token}" }.`,
		PipeTopicUnused: "Hack-style pipe body does not contain a topic reference; Hack-style pipes must use topic at least once.",
		PipeUnparenthesizedBody: ({ type }) => `Hack-style pipe body cannot be an unparenthesized ${toNodeDescription({ type })}; please wrap it in parentheses.`
	}, {
		PipelineBodyNoArrow: "Unexpected arrow \"=>\" after pipeline body; arrow function in pipeline body must be parenthesized.",
		PipelineBodySequenceExpression: "Pipeline body may not be a comma-separated sequence expression.",
		PipelineHeadSequenceExpression: "Pipeline head should not be a comma-separated sequence expression.",
		PipelineTopicUnused: "Pipeline is in topic style but does not use topic reference.",
		PrimaryTopicNotAllowed: "Topic reference was used in a lexical context without topic binding.",
		PrimaryTopicRequiresSmartPipeline: "Topic reference is used, but the pipelineOperator plugin was not passed a \"proposal\": \"hack\" or \"smart\" option."
	});
	const _excluded = ["message"];
	function defineHidden(obj, key, value) {
		Object.defineProperty(obj, key, {
			enumerable: false,
			configurable: true,
			value
		});
	}
	function toParseErrorConstructor({ toMessage, code: code$1, reasonCode, syntaxPlugin }) {
		const hasMissingPlugin = reasonCode === "MissingPlugin" || reasonCode === "MissingOneOfPlugins";
		{
			const oldReasonCodes = {
				AccessorCannotDeclareThisParameter: "AccesorCannotDeclareThisParameter",
				AccessorCannotHaveTypeParameters: "AccesorCannotHaveTypeParameters",
				ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference: "ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference",
				SetAccessorCannotHaveOptionalParameter: "SetAccesorCannotHaveOptionalParameter",
				SetAccessorCannotHaveRestParameter: "SetAccesorCannotHaveRestParameter",
				SetAccessorCannotHaveReturnType: "SetAccesorCannotHaveReturnType"
			};
			if (oldReasonCodes[reasonCode]) reasonCode = oldReasonCodes[reasonCode];
		}
		return function constructor(loc, details) {
			const error = new SyntaxError();
			error.code = code$1;
			error.reasonCode = reasonCode;
			error.loc = loc;
			error.pos = loc.index;
			error.syntaxPlugin = syntaxPlugin;
			if (hasMissingPlugin) error.missingPlugin = details.missingPlugin;
			defineHidden(error, "clone", function clone(overrides = {}) {
				var _overrides$loc;
				const { line, column, index: index$1 } = (_overrides$loc = overrides.loc) != null ? _overrides$loc : loc;
				return constructor(new Position(line, column, index$1), Object.assign({}, details, overrides.details));
			});
			defineHidden(error, "details", details);
			Object.defineProperty(error, "message", {
				configurable: true,
				get() {
					const message = `${toMessage(details)} (${loc.line}:${loc.column})`;
					this.message = message;
					return message;
				},
				set(value) {
					Object.defineProperty(this, "message", {
						value,
						writable: true
					});
				}
			});
			return error;
		};
	}
	function ParseErrorEnum(argument, syntaxPlugin) {
		if (Array.isArray(argument)) return (parseErrorTemplates) => ParseErrorEnum(parseErrorTemplates, argument[0]);
		const ParseErrorConstructors = {};
		for (const reasonCode of Object.keys(argument)) {
			const template = argument[reasonCode];
			const _ref = typeof template === "string" ? { message: () => template } : typeof template === "function" ? { message: template } : template, { message } = _ref, rest = _objectWithoutPropertiesLoose(_ref, _excluded);
			const toMessage = typeof message === "string" ? () => message : message;
			ParseErrorConstructors[reasonCode] = toParseErrorConstructor(Object.assign({
				code: "BABEL_PARSER_SYNTAX_ERROR",
				reasonCode,
				toMessage
			}, syntaxPlugin ? { syntaxPlugin } : {}, rest));
		}
		return ParseErrorConstructors;
	}
	const Errors = Object.assign({}, ParseErrorEnum(ModuleErrors), ParseErrorEnum(StandardErrors), ParseErrorEnum(StrictModeErrors), ParseErrorEnum(ParseExpressionErrors), ParseErrorEnum`pipelineOperator`(PipelineOperatorErrors));
	function createDefaultOptions() {
		return {
			sourceType: "script",
			sourceFilename: void 0,
			startIndex: 0,
			startColumn: 0,
			startLine: 1,
			allowAwaitOutsideFunction: false,
			allowReturnOutsideFunction: false,
			allowNewTargetOutsideFunction: false,
			allowImportExportEverywhere: false,
			allowSuperOutsideMethod: false,
			allowUndeclaredExports: false,
			allowYieldOutsideFunction: false,
			plugins: [],
			strictMode: null,
			ranges: false,
			tokens: false,
			createImportExpressions: false,
			createParenthesizedExpressions: false,
			errorRecovery: false,
			attachComment: true,
			annexB: true
		};
	}
	function getOptions(opts) {
		const options = createDefaultOptions();
		if (opts == null) return options;
		if (opts.annexB != null && opts.annexB !== false) throw new Error("The `annexB` option can only be set to `false`.");
		for (const key of Object.keys(options)) if (opts[key] != null) options[key] = opts[key];
		if (options.startLine === 1) {
			if (opts.startIndex == null && options.startColumn > 0) options.startIndex = options.startColumn;
			else if (opts.startColumn == null && options.startIndex > 0) options.startColumn = options.startIndex;
		} else if (opts.startColumn == null || opts.startIndex == null) {
			if (opts.startIndex != null) throw new Error("With a `startLine > 1` you must also specify `startIndex` and `startColumn`.");
		}
		if (options.sourceType === "commonjs") {
			if (opts.allowAwaitOutsideFunction != null) throw new Error("The `allowAwaitOutsideFunction` option cannot be used with `sourceType: 'commonjs'`.");
			if (opts.allowReturnOutsideFunction != null) throw new Error("`sourceType: 'commonjs'` implies `allowReturnOutsideFunction: true`, please remove the `allowReturnOutsideFunction` option or use `sourceType: 'script'`.");
			if (opts.allowNewTargetOutsideFunction != null) throw new Error("`sourceType: 'commonjs'` implies `allowNewTargetOutsideFunction: true`, please remove the `allowNewTargetOutsideFunction` option or use `sourceType: 'script'`.");
		}
		return options;
	}
	const { defineProperty } = Object;
	const toUnenumerable = (object, key) => {
		if (object) defineProperty(object, key, {
			enumerable: false,
			value: object[key]
		});
	};
	function toESTreeLocation(node) {
		toUnenumerable(node.loc.start, "index");
		toUnenumerable(node.loc.end, "index");
		return node;
	}
	var estree = (superClass) => class ESTreeParserMixin extends superClass {
		parse() {
			const file = toESTreeLocation(super.parse());
			if (this.optionFlags & 256) file.tokens = file.tokens.map(toESTreeLocation);
			return file;
		}
		parseRegExpLiteral({ pattern, flags }) {
			let regex = null;
			try {
				regex = new RegExp(pattern, flags);
			} catch (_) {}
			const node = this.estreeParseLiteral(regex);
			node.regex = {
				pattern,
				flags
			};
			return node;
		}
		parseBigIntLiteral(value) {
			let bigInt;
			try {
				bigInt = BigInt(value);
			} catch (_unused) {
				bigInt = null;
			}
			const node = this.estreeParseLiteral(bigInt);
			node.bigint = String(node.value || value);
			return node;
		}
		parseDecimalLiteral(value) {
			const decimal = null;
			const node = this.estreeParseLiteral(decimal);
			node.decimal = String(node.value || value);
			return node;
		}
		estreeParseLiteral(value) {
			return this.parseLiteral(value, "Literal");
		}
		parseStringLiteral(value) {
			return this.estreeParseLiteral(value);
		}
		parseNumericLiteral(value) {
			return this.estreeParseLiteral(value);
		}
		parseNullLiteral() {
			return this.estreeParseLiteral(null);
		}
		parseBooleanLiteral(value) {
			return this.estreeParseLiteral(value);
		}
		estreeParseChainExpression(node, endLoc) {
			const chain = this.startNodeAtNode(node);
			chain.expression = node;
			return this.finishNodeAt(chain, "ChainExpression", endLoc);
		}
		directiveToStmt(directive) {
			const expression = directive.value;
			delete directive.value;
			this.castNodeTo(expression, "Literal");
			expression.raw = expression.extra.raw;
			expression.value = expression.extra.expressionValue;
			const stmt = this.castNodeTo(directive, "ExpressionStatement");
			stmt.expression = expression;
			stmt.directive = expression.extra.rawValue;
			delete expression.extra;
			return stmt;
		}
		fillOptionalPropertiesForTSESLint(node) {}
		cloneEstreeStringLiteral(node) {
			const { start, end, loc, range: range$3, raw: raw$1, value } = node;
			const cloned = Object.create(node.constructor.prototype);
			cloned.type = "Literal";
			cloned.start = start;
			cloned.end = end;
			cloned.loc = loc;
			cloned.range = range$3;
			cloned.raw = raw$1;
			cloned.value = value;
			return cloned;
		}
		initFunction(node, isAsync) {
			super.initFunction(node, isAsync);
			node.expression = false;
		}
		checkDeclaration(node) {
			if (node != null && this.isObjectProperty(node)) this.checkDeclaration(node.value);
			else super.checkDeclaration(node);
		}
		getObjectOrClassMethodParams(method) {
			return method.value.params;
		}
		isValidDirective(stmt) {
			var _stmt$expression$extr;
			return stmt.type === "ExpressionStatement" && stmt.expression.type === "Literal" && typeof stmt.expression.value === "string" && !((_stmt$expression$extr = stmt.expression.extra) != null && _stmt$expression$extr.parenthesized);
		}
		parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
			super.parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse);
			const directiveStatements = node.directives.map((d) => this.directiveToStmt(d));
			node.body = directiveStatements.concat(node.body);
			delete node.directives;
		}
		parsePrivateName() {
			const node = super.parsePrivateName();
			if (!this.getPluginOption("estree", "classFeatures")) return node;
			return this.convertPrivateNameToPrivateIdentifier(node);
		}
		convertPrivateNameToPrivateIdentifier(node) {
			const name = super.getPrivateNameSV(node);
			node = node;
			delete node.id;
			node.name = name;
			return this.castNodeTo(node, "PrivateIdentifier");
		}
		isPrivateName(node) {
			if (!this.getPluginOption("estree", "classFeatures")) return super.isPrivateName(node);
			return node.type === "PrivateIdentifier";
		}
		getPrivateNameSV(node) {
			if (!this.getPluginOption("estree", "classFeatures")) return super.getPrivateNameSV(node);
			return node.name;
		}
		parseLiteral(value, type) {
			const node = super.parseLiteral(value, type);
			node.raw = node.extra.raw;
			delete node.extra;
			return node;
		}
		parseFunctionBody(node, allowExpression, isMethod = false) {
			super.parseFunctionBody(node, allowExpression, isMethod);
			node.expression = node.body.type !== "BlockStatement";
		}
		parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope = false) {
			let funcNode = this.startNode();
			funcNode.kind = node.kind;
			funcNode = super.parseMethod(funcNode, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope);
			delete funcNode.kind;
			const { typeParameters } = node;
			if (typeParameters) {
				delete node.typeParameters;
				funcNode.typeParameters = typeParameters;
				this.resetStartLocationFromNode(funcNode, typeParameters);
			}
			const valueNode = this.castNodeTo(funcNode, "FunctionExpression");
			node.value = valueNode;
			if (type === "ClassPrivateMethod") node.computed = false;
			if (type === "ObjectMethod") {
				if (node.kind === "method") node.kind = "init";
				node.shorthand = false;
				return this.finishNode(node, "Property");
			} else return this.finishNode(node, "MethodDefinition");
		}
		nameIsConstructor(key) {
			if (key.type === "Literal") return key.value === "constructor";
			return super.nameIsConstructor(key);
		}
		parseClassProperty(...args) {
			const propertyNode = super.parseClassProperty(...args);
			if (!this.getPluginOption("estree", "classFeatures")) return propertyNode;
			this.castNodeTo(propertyNode, "PropertyDefinition");
			return propertyNode;
		}
		parseClassPrivateProperty(...args) {
			const propertyNode = super.parseClassPrivateProperty(...args);
			if (!this.getPluginOption("estree", "classFeatures")) return propertyNode;
			this.castNodeTo(propertyNode, "PropertyDefinition");
			propertyNode.computed = false;
			return propertyNode;
		}
		parseClassAccessorProperty(node) {
			const accessorPropertyNode = super.parseClassAccessorProperty(node);
			if (!this.getPluginOption("estree", "classFeatures")) return accessorPropertyNode;
			if (accessorPropertyNode.abstract && this.hasPlugin("typescript")) {
				delete accessorPropertyNode.abstract;
				this.castNodeTo(accessorPropertyNode, "TSAbstractAccessorProperty");
			} else this.castNodeTo(accessorPropertyNode, "AccessorProperty");
			return accessorPropertyNode;
		}
		parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
			const node = super.parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors);
			if (node) {
				node.kind = "init";
				this.castNodeTo(node, "Property");
			}
			return node;
		}
		finishObjectProperty(node) {
			node.kind = "init";
			return this.finishNode(node, "Property");
		}
		isValidLVal(type, isUnparenthesizedInAssign, binding) {
			return type === "Property" ? "value" : super.isValidLVal(type, isUnparenthesizedInAssign, binding);
		}
		isAssignable(node, isBinding) {
			if (node != null && this.isObjectProperty(node)) return this.isAssignable(node.value, isBinding);
			return super.isAssignable(node, isBinding);
		}
		toAssignable(node, isLHS = false) {
			if (node != null && this.isObjectProperty(node)) {
				const { key, value } = node;
				if (this.isPrivateName(key)) this.classScope.usePrivateName(this.getPrivateNameSV(key), key.loc.start);
				this.toAssignable(value, isLHS);
			} else super.toAssignable(node, isLHS);
		}
		toAssignableObjectExpressionProp(prop, isLast, isLHS) {
			if (prop.type === "Property" && (prop.kind === "get" || prop.kind === "set")) this.raise(Errors.PatternHasAccessor, prop.key);
			else if (prop.type === "Property" && prop.method) this.raise(Errors.PatternHasMethod, prop.key);
			else super.toAssignableObjectExpressionProp(prop, isLast, isLHS);
		}
		finishCallExpression(unfinished, optional) {
			const node = super.finishCallExpression(unfinished, optional);
			if (node.callee.type === "Import") {
				var _ref, _ref2;
				this.castNodeTo(node, "ImportExpression");
				node.source = node.arguments[0];
				node.options = (_ref = node.arguments[1]) != null ? _ref : null;
				node.attributes = (_ref2 = node.arguments[1]) != null ? _ref2 : null;
				delete node.arguments;
				delete node.callee;
			} else if (node.type === "OptionalCallExpression") this.castNodeTo(node, "CallExpression");
			else node.optional = false;
			return node;
		}
		toReferencedArguments(node) {
			if (node.type === "ImportExpression") return;
			super.toReferencedArguments(node);
		}
		parseExport(unfinished, decorators) {
			const exportStartLoc = this.state.lastTokStartLoc;
			const node = super.parseExport(unfinished, decorators);
			switch (node.type) {
				case "ExportAllDeclaration":
					node.exported = null;
					break;
				case "ExportNamedDeclaration": if (node.specifiers.length === 1 && node.specifiers[0].type === "ExportNamespaceSpecifier") {
					this.castNodeTo(node, "ExportAllDeclaration");
					node.exported = node.specifiers[0].exported;
					delete node.specifiers;
				}
				case "ExportDefaultDeclaration":
					{
						var _declaration$decorato;
						const { declaration } = node;
						if ((declaration == null ? void 0 : declaration.type) === "ClassDeclaration" && ((_declaration$decorato = declaration.decorators) == null ? void 0 : _declaration$decorato.length) > 0 && declaration.start === node.start) this.resetStartLocation(node, exportStartLoc);
					}
					break;
			}
			return node;
		}
		stopParseSubscript(base, state) {
			const node = super.stopParseSubscript(base, state);
			if (state.optionalChainMember) return this.estreeParseChainExpression(node, base.loc.end);
			return node;
		}
		parseMember(base, startLoc, state, computed$1, optional) {
			const node = super.parseMember(base, startLoc, state, computed$1, optional);
			if (node.type === "OptionalMemberExpression") this.castNodeTo(node, "MemberExpression");
			else node.optional = false;
			return node;
		}
		isOptionalMemberExpression(node) {
			if (node.type === "ChainExpression") return node.expression.type === "MemberExpression";
			return super.isOptionalMemberExpression(node);
		}
		hasPropertyAsPrivateName(node) {
			if (node.type === "ChainExpression") node = node.expression;
			return super.hasPropertyAsPrivateName(node);
		}
		isObjectProperty(node) {
			return node.type === "Property" && node.kind === "init" && !node.method;
		}
		isObjectMethod(node) {
			return node.type === "Property" && (node.method || node.kind === "get" || node.kind === "set");
		}
		castNodeTo(node, type) {
			const result = super.castNodeTo(node, type);
			this.fillOptionalPropertiesForTSESLint(result);
			return result;
		}
		cloneIdentifier(node) {
			const cloned = super.cloneIdentifier(node);
			this.fillOptionalPropertiesForTSESLint(cloned);
			return cloned;
		}
		cloneStringLiteral(node) {
			if (node.type === "Literal") return this.cloneEstreeStringLiteral(node);
			return super.cloneStringLiteral(node);
		}
		finishNodeAt(node, type, endLoc) {
			return toESTreeLocation(super.finishNodeAt(node, type, endLoc));
		}
		finishNode(node, type) {
			const result = super.finishNode(node, type);
			this.fillOptionalPropertiesForTSESLint(result);
			return result;
		}
		resetStartLocation(node, startLoc) {
			super.resetStartLocation(node, startLoc);
			toESTreeLocation(node);
		}
		resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
			super.resetEndLocation(node, endLoc);
			toESTreeLocation(node);
		}
	};
	var TokContext = class {
		constructor(token, preserveSpace) {
			this.token = void 0;
			this.preserveSpace = void 0;
			this.token = token;
			this.preserveSpace = !!preserveSpace;
		}
	};
	const types$1 = {
		brace: new TokContext("{"),
		j_oTag: new TokContext("<tag"),
		j_cTag: new TokContext("</tag"),
		j_expr: new TokContext("<tag>...</tag>", true)
	};
	types$1.template = new TokContext("`", true);
	const beforeExpr = true;
	const startsExpr = true;
	const isLoop = true;
	const isAssign = true;
	const prefix = true;
	const postfix = true;
	var ExportedTokenType = class {
		constructor(label, conf = {}) {
			this.label = void 0;
			this.keyword = void 0;
			this.beforeExpr = void 0;
			this.startsExpr = void 0;
			this.rightAssociative = void 0;
			this.isLoop = void 0;
			this.isAssign = void 0;
			this.prefix = void 0;
			this.postfix = void 0;
			this.binop = void 0;
			this.label = label;
			this.keyword = conf.keyword;
			this.beforeExpr = !!conf.beforeExpr;
			this.startsExpr = !!conf.startsExpr;
			this.rightAssociative = !!conf.rightAssociative;
			this.isLoop = !!conf.isLoop;
			this.isAssign = !!conf.isAssign;
			this.prefix = !!conf.prefix;
			this.postfix = !!conf.postfix;
			this.binop = conf.binop != null ? conf.binop : null;
			this.updateContext = null;
		}
	};
	const keywords$1 = /* @__PURE__ */ new Map();
	function createKeyword(name, options = {}) {
		options.keyword = name;
		const token = createToken(name, options);
		keywords$1.set(name, token);
		return token;
	}
	function createBinop(name, binop) {
		return createToken(name, {
			beforeExpr,
			binop
		});
	}
	let tokenTypeCounter = -1;
	const tokenTypes = [];
	const tokenLabels = [];
	const tokenBinops = [];
	const tokenBeforeExprs = [];
	const tokenStartsExprs = [];
	const tokenPrefixes = [];
	function createToken(name, options = {}) {
		var _options$binop, _options$beforeExpr, _options$startsExpr, _options$prefix;
		++tokenTypeCounter;
		tokenLabels.push(name);
		tokenBinops.push((_options$binop = options.binop) != null ? _options$binop : -1);
		tokenBeforeExprs.push((_options$beforeExpr = options.beforeExpr) != null ? _options$beforeExpr : false);
		tokenStartsExprs.push((_options$startsExpr = options.startsExpr) != null ? _options$startsExpr : false);
		tokenPrefixes.push((_options$prefix = options.prefix) != null ? _options$prefix : false);
		tokenTypes.push(new ExportedTokenType(name, options));
		return tokenTypeCounter;
	}
	function createKeywordLike(name, options = {}) {
		var _options$binop2, _options$beforeExpr2, _options$startsExpr2, _options$prefix2;
		++tokenTypeCounter;
		keywords$1.set(name, tokenTypeCounter);
		tokenLabels.push(name);
		tokenBinops.push((_options$binop2 = options.binop) != null ? _options$binop2 : -1);
		tokenBeforeExprs.push((_options$beforeExpr2 = options.beforeExpr) != null ? _options$beforeExpr2 : false);
		tokenStartsExprs.push((_options$startsExpr2 = options.startsExpr) != null ? _options$startsExpr2 : false);
		tokenPrefixes.push((_options$prefix2 = options.prefix) != null ? _options$prefix2 : false);
		tokenTypes.push(new ExportedTokenType("name", options));
		return tokenTypeCounter;
	}
	const tt = {
		bracketL: createToken("[", {
			beforeExpr,
			startsExpr
		}),
		bracketHashL: createToken("#[", {
			beforeExpr,
			startsExpr
		}),
		bracketBarL: createToken("[|", {
			beforeExpr,
			startsExpr
		}),
		bracketR: createToken("]"),
		bracketBarR: createToken("|]"),
		braceL: createToken("{", {
			beforeExpr,
			startsExpr
		}),
		braceBarL: createToken("{|", {
			beforeExpr,
			startsExpr
		}),
		braceHashL: createToken("#{", {
			beforeExpr,
			startsExpr
		}),
		braceR: createToken("}"),
		braceBarR: createToken("|}"),
		parenL: createToken("(", {
			beforeExpr,
			startsExpr
		}),
		parenR: createToken(")"),
		comma: createToken(",", { beforeExpr }),
		semi: createToken(";", { beforeExpr }),
		colon: createToken(":", { beforeExpr }),
		doubleColon: createToken("::", { beforeExpr }),
		dot: createToken("."),
		question: createToken("?", { beforeExpr }),
		questionDot: createToken("?."),
		arrow: createToken("=>", { beforeExpr }),
		template: createToken("template"),
		ellipsis: createToken("...", { beforeExpr }),
		backQuote: createToken("`", { startsExpr }),
		dollarBraceL: createToken("${", {
			beforeExpr,
			startsExpr
		}),
		templateTail: createToken("...`", { startsExpr }),
		templateNonTail: createToken("...${", {
			beforeExpr,
			startsExpr
		}),
		at: createToken("@"),
		hash: createToken("#", { startsExpr }),
		interpreterDirective: createToken("#!..."),
		eq: createToken("=", {
			beforeExpr,
			isAssign
		}),
		assign: createToken("_=", {
			beforeExpr,
			isAssign
		}),
		slashAssign: createToken("_=", {
			beforeExpr,
			isAssign
		}),
		xorAssign: createToken("_=", {
			beforeExpr,
			isAssign
		}),
		moduloAssign: createToken("_=", {
			beforeExpr,
			isAssign
		}),
		incDec: createToken("++/--", {
			prefix,
			postfix,
			startsExpr
		}),
		bang: createToken("!", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		tilde: createToken("~", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		doubleCaret: createToken("^^", { startsExpr }),
		doubleAt: createToken("@@", { startsExpr }),
		pipeline: createBinop("|>", 0),
		nullishCoalescing: createBinop("??", 1),
		logicalOR: createBinop("||", 1),
		logicalAND: createBinop("&&", 2),
		bitwiseOR: createBinop("|", 3),
		bitwiseXOR: createBinop("^", 4),
		bitwiseAND: createBinop("&", 5),
		equality: createBinop("==/!=/===/!==", 6),
		lt: createBinop("</>/<=/>=", 7),
		gt: createBinop("</>/<=/>=", 7),
		relational: createBinop("</>/<=/>=", 7),
		bitShift: createBinop("<</>>/>>>", 8),
		bitShiftL: createBinop("<</>>/>>>", 8),
		bitShiftR: createBinop("<</>>/>>>", 8),
		plusMin: createToken("+/-", {
			beforeExpr,
			binop: 9,
			prefix,
			startsExpr
		}),
		modulo: createToken("%", {
			binop: 10,
			startsExpr
		}),
		star: createToken("*", { binop: 10 }),
		slash: createBinop("/", 10),
		exponent: createToken("**", {
			beforeExpr,
			binop: 11,
			rightAssociative: true
		}),
		_in: createKeyword("in", {
			beforeExpr,
			binop: 7
		}),
		_instanceof: createKeyword("instanceof", {
			beforeExpr,
			binop: 7
		}),
		_break: createKeyword("break"),
		_case: createKeyword("case", { beforeExpr }),
		_catch: createKeyword("catch"),
		_continue: createKeyword("continue"),
		_debugger: createKeyword("debugger"),
		_default: createKeyword("default", { beforeExpr }),
		_else: createKeyword("else", { beforeExpr }),
		_finally: createKeyword("finally"),
		_function: createKeyword("function", { startsExpr }),
		_if: createKeyword("if"),
		_return: createKeyword("return", { beforeExpr }),
		_switch: createKeyword("switch"),
		_throw: createKeyword("throw", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		_try: createKeyword("try"),
		_var: createKeyword("var"),
		_const: createKeyword("const"),
		_with: createKeyword("with"),
		_new: createKeyword("new", {
			beforeExpr,
			startsExpr
		}),
		_this: createKeyword("this", { startsExpr }),
		_super: createKeyword("super", { startsExpr }),
		_class: createKeyword("class", { startsExpr }),
		_extends: createKeyword("extends", { beforeExpr }),
		_export: createKeyword("export"),
		_import: createKeyword("import", { startsExpr }),
		_null: createKeyword("null", { startsExpr }),
		_true: createKeyword("true", { startsExpr }),
		_false: createKeyword("false", { startsExpr }),
		_typeof: createKeyword("typeof", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		_void: createKeyword("void", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		_delete: createKeyword("delete", {
			beforeExpr,
			prefix,
			startsExpr
		}),
		_do: createKeyword("do", {
			isLoop,
			beforeExpr
		}),
		_for: createKeyword("for", { isLoop }),
		_while: createKeyword("while", { isLoop }),
		_as: createKeywordLike("as", { startsExpr }),
		_assert: createKeywordLike("assert", { startsExpr }),
		_async: createKeywordLike("async", { startsExpr }),
		_await: createKeywordLike("await", { startsExpr }),
		_defer: createKeywordLike("defer", { startsExpr }),
		_from: createKeywordLike("from", { startsExpr }),
		_get: createKeywordLike("get", { startsExpr }),
		_let: createKeywordLike("let", { startsExpr }),
		_meta: createKeywordLike("meta", { startsExpr }),
		_of: createKeywordLike("of", { startsExpr }),
		_sent: createKeywordLike("sent", { startsExpr }),
		_set: createKeywordLike("set", { startsExpr }),
		_source: createKeywordLike("source", { startsExpr }),
		_static: createKeywordLike("static", { startsExpr }),
		_using: createKeywordLike("using", { startsExpr }),
		_yield: createKeywordLike("yield", { startsExpr }),
		_asserts: createKeywordLike("asserts", { startsExpr }),
		_checks: createKeywordLike("checks", { startsExpr }),
		_exports: createKeywordLike("exports", { startsExpr }),
		_global: createKeywordLike("global", { startsExpr }),
		_implements: createKeywordLike("implements", { startsExpr }),
		_intrinsic: createKeywordLike("intrinsic", { startsExpr }),
		_infer: createKeywordLike("infer", { startsExpr }),
		_is: createKeywordLike("is", { startsExpr }),
		_mixins: createKeywordLike("mixins", { startsExpr }),
		_proto: createKeywordLike("proto", { startsExpr }),
		_require: createKeywordLike("require", { startsExpr }),
		_satisfies: createKeywordLike("satisfies", { startsExpr }),
		_keyof: createKeywordLike("keyof", { startsExpr }),
		_readonly: createKeywordLike("readonly", { startsExpr }),
		_unique: createKeywordLike("unique", { startsExpr }),
		_abstract: createKeywordLike("abstract", { startsExpr }),
		_declare: createKeywordLike("declare", { startsExpr }),
		_enum: createKeywordLike("enum", { startsExpr }),
		_module: createKeywordLike("module", { startsExpr }),
		_namespace: createKeywordLike("namespace", { startsExpr }),
		_interface: createKeywordLike("interface", { startsExpr }),
		_type: createKeywordLike("type", { startsExpr }),
		_opaque: createKeywordLike("opaque", { startsExpr }),
		name: createToken("name", { startsExpr }),
		placeholder: createToken("%%", { startsExpr }),
		string: createToken("string", { startsExpr }),
		num: createToken("num", { startsExpr }),
		bigint: createToken("bigint", { startsExpr }),
		decimal: createToken("decimal", { startsExpr }),
		regexp: createToken("regexp", { startsExpr }),
		privateName: createToken("#name", { startsExpr }),
		eof: createToken("eof"),
		jsxName: createToken("jsxName"),
		jsxText: createToken("jsxText", { beforeExpr }),
		jsxTagStart: createToken("jsxTagStart", { startsExpr }),
		jsxTagEnd: createToken("jsxTagEnd")
	};
	function tokenIsIdentifier(token) {
		return token >= 93 && token <= 133;
	}
	function tokenKeywordOrIdentifierIsKeyword(token) {
		return token <= 92;
	}
	function tokenIsKeywordOrIdentifier(token) {
		return token >= 58 && token <= 133;
	}
	function tokenIsLiteralPropertyName(token) {
		return token >= 58 && token <= 137;
	}
	function tokenComesBeforeExpression(token) {
		return tokenBeforeExprs[token];
	}
	function tokenCanStartExpression(token) {
		return tokenStartsExprs[token];
	}
	function tokenIsAssignment(token) {
		return token >= 29 && token <= 33;
	}
	function tokenIsFlowInterfaceOrTypeOrOpaque(token) {
		return token >= 129 && token <= 131;
	}
	function tokenIsLoop(token) {
		return token >= 90 && token <= 92;
	}
	function tokenIsKeyword(token) {
		return token >= 58 && token <= 92;
	}
	function tokenIsOperator(token) {
		return token >= 39 && token <= 59;
	}
	function tokenIsPostfix(token) {
		return token === 34;
	}
	function tokenIsPrefix(token) {
		return tokenPrefixes[token];
	}
	function tokenIsTSTypeOperator(token) {
		return token >= 121 && token <= 123;
	}
	function tokenIsTSDeclarationStart(token) {
		return token >= 124 && token <= 130;
	}
	function tokenLabelName(token) {
		return tokenLabels[token];
	}
	function tokenOperatorPrecedence(token) {
		return tokenBinops[token];
	}
	function tokenIsRightAssociative(token) {
		return token === 57;
	}
	function tokenIsTemplate(token) {
		return token >= 24 && token <= 25;
	}
	function getExportedToken(token) {
		return tokenTypes[token];
	}
	{
		tokenTypes[8].updateContext = (context) => {
			context.pop();
		};
		tokenTypes[5].updateContext = tokenTypes[7].updateContext = tokenTypes[23].updateContext = (context) => {
			context.push(types$1.brace);
		};
		tokenTypes[22].updateContext = (context) => {
			if (context[context.length - 1] === types$1.template) context.pop();
			else context.push(types$1.template);
		};
		tokenTypes[143].updateContext = (context) => {
			context.push(types$1.j_expr, types$1.j_oTag);
		};
	}
	let nonASCIIidentifierStartChars = "ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲊᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟍꟐꟑꟓꟕ-Ƛꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ";
	let nonASCIIidentifierChars = "·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࢗ-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･";
	const nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
	const nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
	nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
	const astralIdentifierStartCodes = [
		0,
		11,
		2,
		25,
		2,
		18,
		2,
		1,
		2,
		14,
		3,
		13,
		35,
		122,
		70,
		52,
		268,
		28,
		4,
		48,
		48,
		31,
		14,
		29,
		6,
		37,
		11,
		29,
		3,
		35,
		5,
		7,
		2,
		4,
		43,
		157,
		19,
		35,
		5,
		35,
		5,
		39,
		9,
		51,
		13,
		10,
		2,
		14,
		2,
		6,
		2,
		1,
		2,
		10,
		2,
		14,
		2,
		6,
		2,
		1,
		4,
		51,
		13,
		310,
		10,
		21,
		11,
		7,
		25,
		5,
		2,
		41,
		2,
		8,
		70,
		5,
		3,
		0,
		2,
		43,
		2,
		1,
		4,
		0,
		3,
		22,
		11,
		22,
		10,
		30,
		66,
		18,
		2,
		1,
		11,
		21,
		11,
		25,
		71,
		55,
		7,
		1,
		65,
		0,
		16,
		3,
		2,
		2,
		2,
		28,
		43,
		28,
		4,
		28,
		36,
		7,
		2,
		27,
		28,
		53,
		11,
		21,
		11,
		18,
		14,
		17,
		111,
		72,
		56,
		50,
		14,
		50,
		14,
		35,
		39,
		27,
		10,
		22,
		251,
		41,
		7,
		1,
		17,
		2,
		60,
		28,
		11,
		0,
		9,
		21,
		43,
		17,
		47,
		20,
		28,
		22,
		13,
		52,
		58,
		1,
		3,
		0,
		14,
		44,
		33,
		24,
		27,
		35,
		30,
		0,
		3,
		0,
		9,
		34,
		4,
		0,
		13,
		47,
		15,
		3,
		22,
		0,
		2,
		0,
		36,
		17,
		2,
		24,
		20,
		1,
		64,
		6,
		2,
		0,
		2,
		3,
		2,
		14,
		2,
		9,
		8,
		46,
		39,
		7,
		3,
		1,
		3,
		21,
		2,
		6,
		2,
		1,
		2,
		4,
		4,
		0,
		19,
		0,
		13,
		4,
		31,
		9,
		2,
		0,
		3,
		0,
		2,
		37,
		2,
		0,
		26,
		0,
		2,
		0,
		45,
		52,
		19,
		3,
		21,
		2,
		31,
		47,
		21,
		1,
		2,
		0,
		185,
		46,
		42,
		3,
		37,
		47,
		21,
		0,
		60,
		42,
		14,
		0,
		72,
		26,
		38,
		6,
		186,
		43,
		117,
		63,
		32,
		7,
		3,
		0,
		3,
		7,
		2,
		1,
		2,
		23,
		16,
		0,
		2,
		0,
		95,
		7,
		3,
		38,
		17,
		0,
		2,
		0,
		29,
		0,
		11,
		39,
		8,
		0,
		22,
		0,
		12,
		45,
		20,
		0,
		19,
		72,
		200,
		32,
		32,
		8,
		2,
		36,
		18,
		0,
		50,
		29,
		113,
		6,
		2,
		1,
		2,
		37,
		22,
		0,
		26,
		5,
		2,
		1,
		2,
		31,
		15,
		0,
		328,
		18,
		16,
		0,
		2,
		12,
		2,
		33,
		125,
		0,
		80,
		921,
		103,
		110,
		18,
		195,
		2637,
		96,
		16,
		1071,
		18,
		5,
		26,
		3994,
		6,
		582,
		6842,
		29,
		1763,
		568,
		8,
		30,
		18,
		78,
		18,
		29,
		19,
		47,
		17,
		3,
		32,
		20,
		6,
		18,
		433,
		44,
		212,
		63,
		129,
		74,
		6,
		0,
		67,
		12,
		65,
		1,
		2,
		0,
		29,
		6135,
		9,
		1237,
		42,
		9,
		8936,
		3,
		2,
		6,
		2,
		1,
		2,
		290,
		16,
		0,
		30,
		2,
		3,
		0,
		15,
		3,
		9,
		395,
		2309,
		106,
		6,
		12,
		4,
		8,
		8,
		9,
		5991,
		84,
		2,
		70,
		2,
		1,
		3,
		0,
		3,
		1,
		3,
		3,
		2,
		11,
		2,
		0,
		2,
		6,
		2,
		64,
		2,
		3,
		3,
		7,
		2,
		6,
		2,
		27,
		2,
		3,
		2,
		4,
		2,
		0,
		4,
		6,
		2,
		339,
		3,
		24,
		2,
		24,
		2,
		30,
		2,
		24,
		2,
		30,
		2,
		24,
		2,
		30,
		2,
		24,
		2,
		30,
		2,
		24,
		2,
		7,
		1845,
		30,
		7,
		5,
		262,
		61,
		147,
		44,
		11,
		6,
		17,
		0,
		322,
		29,
		19,
		43,
		485,
		27,
		229,
		29,
		3,
		0,
		496,
		6,
		2,
		3,
		2,
		1,
		2,
		14,
		2,
		196,
		60,
		67,
		8,
		0,
		1205,
		3,
		2,
		26,
		2,
		1,
		2,
		0,
		3,
		0,
		2,
		9,
		2,
		3,
		2,
		0,
		2,
		0,
		7,
		0,
		5,
		0,
		2,
		0,
		2,
		0,
		2,
		2,
		2,
		1,
		2,
		0,
		3,
		0,
		2,
		0,
		2,
		0,
		2,
		0,
		2,
		0,
		2,
		1,
		2,
		0,
		3,
		3,
		2,
		6,
		2,
		3,
		2,
		3,
		2,
		0,
		2,
		9,
		2,
		16,
		6,
		2,
		2,
		4,
		2,
		16,
		4421,
		42719,
		33,
		4153,
		7,
		221,
		3,
		5761,
		15,
		7472,
		16,
		621,
		2467,
		541,
		1507,
		4938,
		6,
		4191
	];
	const astralIdentifierCodes = [
		509,
		0,
		227,
		0,
		150,
		4,
		294,
		9,
		1368,
		2,
		2,
		1,
		6,
		3,
		41,
		2,
		5,
		0,
		166,
		1,
		574,
		3,
		9,
		9,
		7,
		9,
		32,
		4,
		318,
		1,
		80,
		3,
		71,
		10,
		50,
		3,
		123,
		2,
		54,
		14,
		32,
		10,
		3,
		1,
		11,
		3,
		46,
		10,
		8,
		0,
		46,
		9,
		7,
		2,
		37,
		13,
		2,
		9,
		6,
		1,
		45,
		0,
		13,
		2,
		49,
		13,
		9,
		3,
		2,
		11,
		83,
		11,
		7,
		0,
		3,
		0,
		158,
		11,
		6,
		9,
		7,
		3,
		56,
		1,
		2,
		6,
		3,
		1,
		3,
		2,
		10,
		0,
		11,
		1,
		3,
		6,
		4,
		4,
		68,
		8,
		2,
		0,
		3,
		0,
		2,
		3,
		2,
		4,
		2,
		0,
		15,
		1,
		83,
		17,
		10,
		9,
		5,
		0,
		82,
		19,
		13,
		9,
		214,
		6,
		3,
		8,
		28,
		1,
		83,
		16,
		16,
		9,
		82,
		12,
		9,
		9,
		7,
		19,
		58,
		14,
		5,
		9,
		243,
		14,
		166,
		9,
		71,
		5,
		2,
		1,
		3,
		3,
		2,
		0,
		2,
		1,
		13,
		9,
		120,
		6,
		3,
		6,
		4,
		0,
		29,
		9,
		41,
		6,
		2,
		3,
		9,
		0,
		10,
		10,
		47,
		15,
		343,
		9,
		54,
		7,
		2,
		7,
		17,
		9,
		57,
		21,
		2,
		13,
		123,
		5,
		4,
		0,
		2,
		1,
		2,
		6,
		2,
		0,
		9,
		9,
		49,
		4,
		2,
		1,
		2,
		4,
		9,
		9,
		330,
		3,
		10,
		1,
		2,
		0,
		49,
		6,
		4,
		4,
		14,
		10,
		5350,
		0,
		7,
		14,
		11465,
		27,
		2343,
		9,
		87,
		9,
		39,
		4,
		60,
		6,
		26,
		9,
		535,
		9,
		470,
		0,
		2,
		54,
		8,
		3,
		82,
		0,
		12,
		1,
		19628,
		1,
		4178,
		9,
		519,
		45,
		3,
		22,
		543,
		4,
		4,
		5,
		9,
		7,
		3,
		6,
		31,
		3,
		149,
		2,
		1418,
		49,
		513,
		54,
		5,
		49,
		9,
		0,
		15,
		0,
		23,
		4,
		2,
		14,
		1361,
		6,
		2,
		16,
		3,
		6,
		2,
		1,
		2,
		4,
		101,
		0,
		161,
		6,
		10,
		9,
		357,
		0,
		62,
		13,
		499,
		13,
		245,
		1,
		2,
		9,
		726,
		6,
		110,
		6,
		6,
		9,
		4759,
		9,
		787719,
		239
	];
	function isInAstralSet(code$1, set$1) {
		let pos = 65536;
		for (let i = 0, length = set$1.length; i < length; i += 2) {
			pos += set$1[i];
			if (pos > code$1) return false;
			pos += set$1[i + 1];
			if (pos >= code$1) return true;
		}
		return false;
	}
	function isIdentifierStart(code$1) {
		if (code$1 < 65) return code$1 === 36;
		if (code$1 <= 90) return true;
		if (code$1 < 97) return code$1 === 95;
		if (code$1 <= 122) return true;
		if (code$1 <= 65535) return code$1 >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code$1));
		return isInAstralSet(code$1, astralIdentifierStartCodes);
	}
	function isIdentifierChar(code$1) {
		if (code$1 < 48) return code$1 === 36;
		if (code$1 < 58) return true;
		if (code$1 < 65) return false;
		if (code$1 <= 90) return true;
		if (code$1 < 97) return code$1 === 95;
		if (code$1 <= 122) return true;
		if (code$1 <= 65535) return code$1 >= 170 && nonASCIIidentifier.test(String.fromCharCode(code$1));
		return isInAstralSet(code$1, astralIdentifierStartCodes) || isInAstralSet(code$1, astralIdentifierCodes);
	}
	const reservedWords = {
		keyword: [
			"break",
			"case",
			"catch",
			"continue",
			"debugger",
			"default",
			"do",
			"else",
			"finally",
			"for",
			"function",
			"if",
			"return",
			"switch",
			"throw",
			"try",
			"var",
			"const",
			"while",
			"with",
			"new",
			"this",
			"super",
			"class",
			"extends",
			"export",
			"import",
			"null",
			"true",
			"false",
			"in",
			"instanceof",
			"typeof",
			"void",
			"delete"
		],
		strict: [
			"implements",
			"interface",
			"let",
			"package",
			"private",
			"protected",
			"public",
			"static",
			"yield"
		],
		strictBind: ["eval", "arguments"]
	};
	const keywords = new Set(reservedWords.keyword);
	const reservedWordsStrictSet = new Set(reservedWords.strict);
	const reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
	function isReservedWord(word, inModule) {
		return inModule && word === "await" || word === "enum";
	}
	function isStrictReservedWord(word, inModule) {
		return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
	}
	function isStrictBindOnlyReservedWord(word) {
		return reservedWordsStrictBindSet.has(word);
	}
	function isStrictBindReservedWord(word, inModule) {
		return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
	}
	function isKeyword(word) {
		return keywords.has(word);
	}
	function isIteratorStart(current, next$1, next2) {
		return current === 64 && next$1 === 64 && isIdentifierStart(next2);
	}
	const reservedWordLikeSet = new Set([
		"break",
		"case",
		"catch",
		"continue",
		"debugger",
		"default",
		"do",
		"else",
		"finally",
		"for",
		"function",
		"if",
		"return",
		"switch",
		"throw",
		"try",
		"var",
		"const",
		"while",
		"with",
		"new",
		"this",
		"super",
		"class",
		"extends",
		"export",
		"import",
		"null",
		"true",
		"false",
		"in",
		"instanceof",
		"typeof",
		"void",
		"delete",
		"implements",
		"interface",
		"let",
		"package",
		"private",
		"protected",
		"public",
		"static",
		"yield",
		"eval",
		"arguments",
		"enum",
		"await"
	]);
	function canBeReservedWord(word) {
		return reservedWordLikeSet.has(word);
	}
	var Scope = class {
		constructor(flags) {
			this.flags = 0;
			this.names = /* @__PURE__ */ new Map();
			this.firstLexicalName = "";
			this.flags = flags;
		}
	};
	var ScopeHandler = class {
		constructor(parser$1, inModule) {
			this.parser = void 0;
			this.scopeStack = [];
			this.inModule = void 0;
			this.undefinedExports = /* @__PURE__ */ new Map();
			this.parser = parser$1;
			this.inModule = inModule;
		}
		get inTopLevel() {
			return (this.currentScope().flags & 1) > 0;
		}
		get inFunction() {
			return (this.currentVarScopeFlags() & 2) > 0;
		}
		get allowSuper() {
			return (this.currentThisScopeFlags() & 16) > 0;
		}
		get allowDirectSuper() {
			return (this.currentThisScopeFlags() & 32) > 0;
		}
		get allowNewTarget() {
			return (this.currentThisScopeFlags() & 512) > 0;
		}
		get inClass() {
			return (this.currentThisScopeFlags() & 64) > 0;
		}
		get inClassAndNotInNonArrowFunction() {
			const flags = this.currentThisScopeFlags();
			return (flags & 64) > 0 && (flags & 2) === 0;
		}
		get inStaticBlock() {
			for (let i = this.scopeStack.length - 1;; i--) {
				const { flags } = this.scopeStack[i];
				if (flags & 128) return true;
				if (flags & 1731) return false;
			}
		}
		get inNonArrowFunction() {
			return (this.currentThisScopeFlags() & 2) > 0;
		}
		get inBareCaseStatement() {
			return (this.currentScope().flags & 256) > 0;
		}
		get treatFunctionsAsVar() {
			return this.treatFunctionsAsVarInScope(this.currentScope());
		}
		createScope(flags) {
			return new Scope(flags);
		}
		enter(flags) {
			this.scopeStack.push(this.createScope(flags));
		}
		exit() {
			const scope = this.scopeStack.pop();
			return scope.flags;
		}
		treatFunctionsAsVarInScope(scope) {
			return !!(scope.flags & 130 || !this.parser.inModule && scope.flags & 1);
		}
		declareName(name, bindingType, loc) {
			let scope = this.currentScope();
			if (bindingType & 8 || bindingType & 16) {
				this.checkRedeclarationInScope(scope, name, bindingType, loc);
				let type = scope.names.get(name) || 0;
				if (bindingType & 16) type = type | 4;
				else {
					if (!scope.firstLexicalName) scope.firstLexicalName = name;
					type = type | 2;
				}
				scope.names.set(name, type);
				if (bindingType & 8) this.maybeExportDefined(scope, name);
			} else if (bindingType & 4) for (let i = this.scopeStack.length - 1; i >= 0; --i) {
				scope = this.scopeStack[i];
				this.checkRedeclarationInScope(scope, name, bindingType, loc);
				scope.names.set(name, (scope.names.get(name) || 0) | 1);
				this.maybeExportDefined(scope, name);
				if (scope.flags & 1667) break;
			}
			if (this.parser.inModule && scope.flags & 1) this.undefinedExports.delete(name);
		}
		maybeExportDefined(scope, name) {
			if (this.parser.inModule && scope.flags & 1) this.undefinedExports.delete(name);
		}
		checkRedeclarationInScope(scope, name, bindingType, loc) {
			if (this.isRedeclaredInScope(scope, name, bindingType)) this.parser.raise(Errors.VarRedeclaration, loc, { identifierName: name });
		}
		isRedeclaredInScope(scope, name, bindingType) {
			if (!(bindingType & 1)) return false;
			if (bindingType & 8) return scope.names.has(name);
			const type = scope.names.get(name);
			if (bindingType & 16) return (type & 2) > 0 || !this.treatFunctionsAsVarInScope(scope) && (type & 1) > 0;
			return (type & 2) > 0 && !(scope.flags & 8 && scope.firstLexicalName === name) || !this.treatFunctionsAsVarInScope(scope) && (type & 4) > 0;
		}
		checkLocalExport(id) {
			const { name } = id;
			const topLevelScope = this.scopeStack[0];
			if (!topLevelScope.names.has(name)) this.undefinedExports.set(name, id.loc.start);
		}
		currentScope() {
			return this.scopeStack[this.scopeStack.length - 1];
		}
		currentVarScopeFlags() {
			for (let i = this.scopeStack.length - 1;; i--) {
				const { flags } = this.scopeStack[i];
				if (flags & 1667) return flags;
			}
		}
		currentThisScopeFlags() {
			for (let i = this.scopeStack.length - 1;; i--) {
				const { flags } = this.scopeStack[i];
				if (flags & 1731 && !(flags & 4)) return flags;
			}
		}
	};
	var FlowScope = class extends Scope {
		constructor(...args) {
			super(...args);
			this.declareFunctions = /* @__PURE__ */ new Set();
		}
	};
	var FlowScopeHandler = class extends ScopeHandler {
		createScope(flags) {
			return new FlowScope(flags);
		}
		declareName(name, bindingType, loc) {
			const scope = this.currentScope();
			if (bindingType & 2048) {
				this.checkRedeclarationInScope(scope, name, bindingType, loc);
				this.maybeExportDefined(scope, name);
				scope.declareFunctions.add(name);
				return;
			}
			super.declareName(name, bindingType, loc);
		}
		isRedeclaredInScope(scope, name, bindingType) {
			if (super.isRedeclaredInScope(scope, name, bindingType)) return true;
			if (bindingType & 2048 && !scope.declareFunctions.has(name)) {
				const type = scope.names.get(name);
				return (type & 4) > 0 || (type & 2) > 0;
			}
			return false;
		}
		checkLocalExport(id) {
			if (!this.scopeStack[0].declareFunctions.has(id.name)) super.checkLocalExport(id);
		}
	};
	const reservedTypes = new Set([
		"_",
		"any",
		"bool",
		"boolean",
		"empty",
		"extends",
		"false",
		"interface",
		"mixed",
		"null",
		"number",
		"static",
		"string",
		"true",
		"typeof",
		"void"
	]);
	const FlowErrors = ParseErrorEnum`flow`({
		AmbiguousConditionalArrow: "Ambiguous expression: wrap the arrow functions in parentheses to disambiguate.",
		AmbiguousDeclareModuleKind: "Found both `declare module.exports` and `declare export` in the same module. Modules can only have 1 since they are either an ES module or they are a CommonJS module.",
		AssignReservedType: ({ reservedType }) => `Cannot overwrite reserved type ${reservedType}.`,
		DeclareClassElement: "The `declare` modifier can only appear on class fields.",
		DeclareClassFieldInitializer: "Initializers are not allowed in fields with the `declare` modifier.",
		DuplicateDeclareModuleExports: "Duplicate `declare module.exports` statement.",
		EnumBooleanMemberNotInitialized: ({ memberName, enumName }) => `Boolean enum members need to be initialized. Use either \`${memberName} = true,\` or \`${memberName} = false,\` in enum \`${enumName}\`.`,
		EnumDuplicateMemberName: ({ memberName, enumName }) => `Enum member names need to be unique, but the name \`${memberName}\` has already been used before in enum \`${enumName}\`.`,
		EnumInconsistentMemberValues: ({ enumName }) => `Enum \`${enumName}\` has inconsistent member initializers. Either use no initializers, or consistently use literals (either booleans, numbers, or strings) for all member initializers.`,
		EnumInvalidExplicitType: ({ invalidEnumType, enumName }) => `Enum type \`${invalidEnumType}\` is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
		EnumInvalidExplicitTypeUnknownSupplied: ({ enumName }) => `Supplied enum type is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
		EnumInvalidMemberInitializerPrimaryType: ({ enumName, memberName, explicitType }) => `Enum \`${enumName}\` has type \`${explicitType}\`, so the initializer of \`${memberName}\` needs to be a ${explicitType} literal.`,
		EnumInvalidMemberInitializerSymbolType: ({ enumName, memberName }) => `Symbol enum members cannot be initialized. Use \`${memberName},\` in enum \`${enumName}\`.`,
		EnumInvalidMemberInitializerUnknownType: ({ enumName, memberName }) => `The enum member initializer for \`${memberName}\` needs to be a literal (either a boolean, number, or string) in enum \`${enumName}\`.`,
		EnumInvalidMemberName: ({ enumName, memberName, suggestion }) => `Enum member names cannot start with lowercase 'a' through 'z'. Instead of using \`${memberName}\`, consider using \`${suggestion}\`, in enum \`${enumName}\`.`,
		EnumNumberMemberNotInitialized: ({ enumName, memberName }) => `Number enum members need to be initialized, e.g. \`${memberName} = 1\` in enum \`${enumName}\`.`,
		EnumStringMemberInconsistentlyInitialized: ({ enumName }) => `String enum members need to consistently either all use initializers, or use no initializers, in enum \`${enumName}\`.`,
		GetterMayNotHaveThisParam: "A getter cannot have a `this` parameter.",
		ImportReflectionHasImportType: "An `import module` declaration can not use `type` or `typeof` keyword.",
		ImportTypeShorthandOnlyInPureImport: "The `type` and `typeof` keywords on named imports can only be used on regular `import` statements. It cannot be used with `import type` or `import typeof` statements.",
		InexactInsideExact: "Explicit inexact syntax cannot appear inside an explicit exact object type.",
		InexactInsideNonObject: "Explicit inexact syntax cannot appear in class or interface definitions.",
		InexactVariance: "Explicit inexact syntax cannot have variance.",
		InvalidNonTypeImportInDeclareModule: "Imports within a `declare module` body must always be `import type` or `import typeof`.",
		MissingTypeParamDefault: "Type parameter declaration needs a default, since a preceding type parameter declaration has a default.",
		NestedDeclareModule: "`declare module` cannot be used inside another `declare module`.",
		NestedFlowComment: "Cannot have a flow comment inside another flow comment.",
		PatternIsOptional: Object.assign({ message: "A binding pattern parameter cannot be optional in an implementation signature." }, { reasonCode: "OptionalBindingPattern" }),
		SetterMayNotHaveThisParam: "A setter cannot have a `this` parameter.",
		SpreadVariance: "Spread properties cannot have variance.",
		ThisParamAnnotationRequired: "A type annotation is required for the `this` parameter.",
		ThisParamBannedInConstructor: "Constructors cannot have a `this` parameter; constructors don't bind `this` like other functions.",
		ThisParamMayNotBeOptional: "The `this` parameter cannot be optional.",
		ThisParamMustBeFirst: "The `this` parameter must be the first function parameter.",
		ThisParamNoDefault: "The `this` parameter may not have a default value.",
		TypeBeforeInitializer: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
		TypeCastInPattern: "The type cast expression is expected to be wrapped with parenthesis.",
		UnexpectedExplicitInexactInObject: "Explicit inexact syntax must appear at the end of an inexact object.",
		UnexpectedReservedType: ({ reservedType }) => `Unexpected reserved type ${reservedType}.`,
		UnexpectedReservedUnderscore: "`_` is only allowed as a type argument to call or new.",
		UnexpectedSpaceBetweenModuloChecks: "Spaces between `%` and `checks` are not allowed here.",
		UnexpectedSpreadType: "Spread operator cannot appear in class or interface definitions.",
		UnexpectedSubtractionOperand: "Unexpected token, expected \"number\" or \"bigint\".",
		UnexpectedTokenAfterTypeParameter: "Expected an arrow function after this type parameter declaration.",
		UnexpectedTypeParameterBeforeAsyncArrowFunction: "Type parameters must come after the async keyword, e.g. instead of `<T> async () => {}`, use `async <T>() => {}`.",
		UnsupportedDeclareExportKind: ({ unsupportedExportKind, suggestion }) => `\`declare export ${unsupportedExportKind}\` is not supported. Use \`${suggestion}\` instead.`,
		UnsupportedStatementInDeclareModule: "Only declares and type imports are allowed inside declare module.",
		UnterminatedFlowComment: "Unterminated flow-comment."
	});
	function isEsModuleType(bodyElement) {
		return bodyElement.type === "DeclareExportAllDeclaration" || bodyElement.type === "DeclareExportDeclaration" && (!bodyElement.declaration || bodyElement.declaration.type !== "TypeAlias" && bodyElement.declaration.type !== "InterfaceDeclaration");
	}
	function hasTypeImportKind(node) {
		return node.importKind === "type" || node.importKind === "typeof";
	}
	const exportSuggestions = {
		const: "declare export var",
		let: "declare export var",
		type: "export type",
		interface: "export interface"
	};
	function partition(list, test) {
		const list1 = [];
		const list2 = [];
		for (let i = 0; i < list.length; i++) (test(list[i], i, list) ? list1 : list2).push(list[i]);
		return [list1, list2];
	}
	const FLOW_PRAGMA_REGEX = /\*?\s*@((?:no)?flow)\b/;
	var flow = (superClass) => class FlowParserMixin extends superClass {
		constructor(...args) {
			super(...args);
			this.flowPragma = void 0;
		}
		getScopeHandler() {
			return FlowScopeHandler;
		}
		shouldParseTypes() {
			return this.getPluginOption("flow", "all") || this.flowPragma === "flow";
		}
		finishToken(type, val) {
			if (type !== 134 && type !== 13 && type !== 28) {
				if (this.flowPragma === void 0) this.flowPragma = null;
			}
			super.finishToken(type, val);
		}
		addComment(comment$1) {
			if (this.flowPragma === void 0) {
				const matches = FLOW_PRAGMA_REGEX.exec(comment$1.value);
				if (!matches);
				else if (matches[1] === "flow") this.flowPragma = "flow";
				else if (matches[1] === "noflow") this.flowPragma = "noflow";
				else throw new Error("Unexpected flow pragma");
			}
			super.addComment(comment$1);
		}
		flowParseTypeInitialiser(tok) {
			const oldInType = this.state.inType;
			this.state.inType = true;
			this.expect(tok || 14);
			const type = this.flowParseType();
			this.state.inType = oldInType;
			return type;
		}
		flowParsePredicate() {
			const node = this.startNode();
			const moduloLoc = this.state.startLoc;
			this.next();
			this.expectContextual(110);
			if (this.state.lastTokStartLoc.index > moduloLoc.index + 1) this.raise(FlowErrors.UnexpectedSpaceBetweenModuloChecks, moduloLoc);
			if (this.eat(10)) {
				node.value = super.parseExpression();
				this.expect(11);
				return this.finishNode(node, "DeclaredPredicate");
			} else return this.finishNode(node, "InferredPredicate");
		}
		flowParseTypeAndPredicateInitialiser() {
			const oldInType = this.state.inType;
			this.state.inType = true;
			this.expect(14);
			let type = null;
			let predicate = null;
			if (this.match(54)) {
				this.state.inType = oldInType;
				predicate = this.flowParsePredicate();
			} else {
				type = this.flowParseType();
				this.state.inType = oldInType;
				if (this.match(54)) predicate = this.flowParsePredicate();
			}
			return [type, predicate];
		}
		flowParseDeclareClass(node) {
			this.next();
			this.flowParseInterfaceish(node, true);
			return this.finishNode(node, "DeclareClass");
		}
		flowParseDeclareFunction(node) {
			this.next();
			const id = node.id = this.parseIdentifier();
			const typeNode = this.startNode();
			const typeContainer = this.startNode();
			if (this.match(47)) typeNode.typeParameters = this.flowParseTypeParameterDeclaration();
			else typeNode.typeParameters = null;
			this.expect(10);
			const tmp = this.flowParseFunctionTypeParams();
			typeNode.params = tmp.params;
			typeNode.rest = tmp.rest;
			typeNode.this = tmp._this;
			this.expect(11);
			[typeNode.returnType, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
			typeContainer.typeAnnotation = this.finishNode(typeNode, "FunctionTypeAnnotation");
			id.typeAnnotation = this.finishNode(typeContainer, "TypeAnnotation");
			this.resetEndLocation(id);
			this.semicolon();
			this.scope.declareName(node.id.name, 2048, node.id.loc.start);
			return this.finishNode(node, "DeclareFunction");
		}
		flowParseDeclare(node, insideModule) {
			if (this.match(80)) return this.flowParseDeclareClass(node);
			else if (this.match(68)) return this.flowParseDeclareFunction(node);
			else if (this.match(74)) return this.flowParseDeclareVariable(node);
			else if (this.eatContextual(127)) if (this.match(16)) return this.flowParseDeclareModuleExports(node);
			else {
				if (insideModule) this.raise(FlowErrors.NestedDeclareModule, this.state.lastTokStartLoc);
				return this.flowParseDeclareModule(node);
			}
			else if (this.isContextual(130)) return this.flowParseDeclareTypeAlias(node);
			else if (this.isContextual(131)) return this.flowParseDeclareOpaqueType(node);
			else if (this.isContextual(129)) return this.flowParseDeclareInterface(node);
			else if (this.match(82)) return this.flowParseDeclareExportDeclaration(node, insideModule);
			else this.unexpected();
		}
		flowParseDeclareVariable(node) {
			this.next();
			node.id = this.flowParseTypeAnnotatableIdentifier(true);
			this.scope.declareName(node.id.name, 5, node.id.loc.start);
			this.semicolon();
			return this.finishNode(node, "DeclareVariable");
		}
		flowParseDeclareModule(node) {
			this.scope.enter(0);
			if (this.match(134)) node.id = super.parseExprAtom();
			else node.id = this.parseIdentifier();
			const bodyNode = node.body = this.startNode();
			const body = bodyNode.body = [];
			this.expect(5);
			while (!this.match(8)) {
				let bodyNode$1 = this.startNode();
				if (this.match(83)) {
					this.next();
					if (!this.isContextual(130) && !this.match(87)) this.raise(FlowErrors.InvalidNonTypeImportInDeclareModule, this.state.lastTokStartLoc);
					super.parseImport(bodyNode$1);
				} else {
					this.expectContextual(125, FlowErrors.UnsupportedStatementInDeclareModule);
					bodyNode$1 = this.flowParseDeclare(bodyNode$1, true);
				}
				body.push(bodyNode$1);
			}
			this.scope.exit();
			this.expect(8);
			this.finishNode(bodyNode, "BlockStatement");
			let kind = null;
			let hasModuleExport = false;
			body.forEach((bodyElement) => {
				if (isEsModuleType(bodyElement)) {
					if (kind === "CommonJS") this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
					kind = "ES";
				} else if (bodyElement.type === "DeclareModuleExports") {
					if (hasModuleExport) this.raise(FlowErrors.DuplicateDeclareModuleExports, bodyElement);
					if (kind === "ES") this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
					kind = "CommonJS";
					hasModuleExport = true;
				}
			});
			node.kind = kind || "CommonJS";
			return this.finishNode(node, "DeclareModule");
		}
		flowParseDeclareExportDeclaration(node, insideModule) {
			this.expect(82);
			if (this.eat(65)) {
				if (this.match(68) || this.match(80)) node.declaration = this.flowParseDeclare(this.startNode());
				else {
					node.declaration = this.flowParseType();
					this.semicolon();
				}
				node.default = true;
				return this.finishNode(node, "DeclareExportDeclaration");
			} else {
				if (this.match(75) || this.isLet() || (this.isContextual(130) || this.isContextual(129)) && !insideModule) {
					const label = this.state.value;
					throw this.raise(FlowErrors.UnsupportedDeclareExportKind, this.state.startLoc, {
						unsupportedExportKind: label,
						suggestion: exportSuggestions[label]
					});
				}
				if (this.match(74) || this.match(68) || this.match(80) || this.isContextual(131)) {
					node.declaration = this.flowParseDeclare(this.startNode());
					node.default = false;
					return this.finishNode(node, "DeclareExportDeclaration");
				} else if (this.match(55) || this.match(5) || this.isContextual(129) || this.isContextual(130) || this.isContextual(131)) {
					node = this.parseExport(node, null);
					if (node.type === "ExportNamedDeclaration") {
						node.default = false;
						delete node.exportKind;
						return this.castNodeTo(node, "DeclareExportDeclaration");
					} else return this.castNodeTo(node, "DeclareExportAllDeclaration");
				}
			}
			this.unexpected();
		}
		flowParseDeclareModuleExports(node) {
			this.next();
			this.expectContextual(111);
			node.typeAnnotation = this.flowParseTypeAnnotation();
			this.semicolon();
			return this.finishNode(node, "DeclareModuleExports");
		}
		flowParseDeclareTypeAlias(node) {
			this.next();
			const finished = this.flowParseTypeAlias(node);
			this.castNodeTo(finished, "DeclareTypeAlias");
			return finished;
		}
		flowParseDeclareOpaqueType(node) {
			this.next();
			const finished = this.flowParseOpaqueType(node, true);
			this.castNodeTo(finished, "DeclareOpaqueType");
			return finished;
		}
		flowParseDeclareInterface(node) {
			this.next();
			this.flowParseInterfaceish(node, false);
			return this.finishNode(node, "DeclareInterface");
		}
		flowParseInterfaceish(node, isClass) {
			node.id = this.flowParseRestrictedIdentifier(!isClass, true);
			this.scope.declareName(node.id.name, isClass ? 17 : 8201, node.id.loc.start);
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
			else node.typeParameters = null;
			node.extends = [];
			if (this.eat(81)) do
				node.extends.push(this.flowParseInterfaceExtends());
			while (!isClass && this.eat(12));
			if (isClass) {
				node.implements = [];
				node.mixins = [];
				if (this.eatContextual(117)) do
					node.mixins.push(this.flowParseInterfaceExtends());
				while (this.eat(12));
				if (this.eatContextual(113)) do
					node.implements.push(this.flowParseInterfaceExtends());
				while (this.eat(12));
			}
			node.body = this.flowParseObjectType({
				allowStatic: isClass,
				allowExact: false,
				allowSpread: false,
				allowProto: isClass,
				allowInexact: false
			});
		}
		flowParseInterfaceExtends() {
			const node = this.startNode();
			node.id = this.flowParseQualifiedTypeIdentifier();
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterInstantiation();
			else node.typeParameters = null;
			return this.finishNode(node, "InterfaceExtends");
		}
		flowParseInterface(node) {
			this.flowParseInterfaceish(node, false);
			return this.finishNode(node, "InterfaceDeclaration");
		}
		checkNotUnderscore(word) {
			if (word === "_") this.raise(FlowErrors.UnexpectedReservedUnderscore, this.state.startLoc);
		}
		checkReservedType(word, startLoc, declaration) {
			if (!reservedTypes.has(word)) return;
			this.raise(declaration ? FlowErrors.AssignReservedType : FlowErrors.UnexpectedReservedType, startLoc, { reservedType: word });
		}
		flowParseRestrictedIdentifier(liberal, declaration) {
			this.checkReservedType(this.state.value, this.state.startLoc, declaration);
			return this.parseIdentifier(liberal);
		}
		flowParseTypeAlias(node) {
			node.id = this.flowParseRestrictedIdentifier(false, true);
			this.scope.declareName(node.id.name, 8201, node.id.loc.start);
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
			else node.typeParameters = null;
			node.right = this.flowParseTypeInitialiser(29);
			this.semicolon();
			return this.finishNode(node, "TypeAlias");
		}
		flowParseOpaqueType(node, declare) {
			this.expectContextual(130);
			node.id = this.flowParseRestrictedIdentifier(true, true);
			this.scope.declareName(node.id.name, 8201, node.id.loc.start);
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
			else node.typeParameters = null;
			node.supertype = null;
			if (this.match(14)) node.supertype = this.flowParseTypeInitialiser(14);
			node.impltype = null;
			if (!declare) node.impltype = this.flowParseTypeInitialiser(29);
			this.semicolon();
			return this.finishNode(node, "OpaqueType");
		}
		flowParseTypeParameter(requireDefault = false) {
			const nodeStartLoc = this.state.startLoc;
			const node = this.startNode();
			const variance = this.flowParseVariance();
			const ident = this.flowParseTypeAnnotatableIdentifier();
			node.name = ident.name;
			node.variance = variance;
			node.bound = ident.typeAnnotation;
			if (this.match(29)) {
				this.eat(29);
				node.default = this.flowParseType();
			} else if (requireDefault) this.raise(FlowErrors.MissingTypeParamDefault, nodeStartLoc);
			return this.finishNode(node, "TypeParameter");
		}
		flowParseTypeParameterDeclaration() {
			const oldInType = this.state.inType;
			const node = this.startNode();
			node.params = [];
			this.state.inType = true;
			if (this.match(47) || this.match(143)) this.next();
			else this.unexpected();
			let defaultRequired = false;
			do {
				const typeParameter = this.flowParseTypeParameter(defaultRequired);
				node.params.push(typeParameter);
				if (typeParameter.default) defaultRequired = true;
				if (!this.match(48)) this.expect(12);
			} while (!this.match(48));
			this.expect(48);
			this.state.inType = oldInType;
			return this.finishNode(node, "TypeParameterDeclaration");
		}
		flowInTopLevelContext(cb) {
			if (this.curContext() !== types$1.brace) {
				const oldContext = this.state.context;
				this.state.context = [oldContext[0]];
				try {
					return cb();
				} finally {
					this.state.context = oldContext;
				}
			} else return cb();
		}
		flowParseTypeParameterInstantiationInExpression() {
			if (this.reScan_lt() !== 47) return;
			return this.flowParseTypeParameterInstantiation();
		}
		flowParseTypeParameterInstantiation() {
			const node = this.startNode();
			const oldInType = this.state.inType;
			this.state.inType = true;
			node.params = [];
			this.flowInTopLevelContext(() => {
				this.expect(47);
				const oldNoAnonFunctionType = this.state.noAnonFunctionType;
				this.state.noAnonFunctionType = false;
				while (!this.match(48)) {
					node.params.push(this.flowParseType());
					if (!this.match(48)) this.expect(12);
				}
				this.state.noAnonFunctionType = oldNoAnonFunctionType;
			});
			this.state.inType = oldInType;
			if (!this.state.inType && this.curContext() === types$1.brace) this.reScan_lt_gt();
			this.expect(48);
			return this.finishNode(node, "TypeParameterInstantiation");
		}
		flowParseTypeParameterInstantiationCallOrNew() {
			if (this.reScan_lt() !== 47) return;
			const node = this.startNode();
			const oldInType = this.state.inType;
			node.params = [];
			this.state.inType = true;
			this.expect(47);
			while (!this.match(48)) {
				node.params.push(this.flowParseTypeOrImplicitInstantiation());
				if (!this.match(48)) this.expect(12);
			}
			this.expect(48);
			this.state.inType = oldInType;
			return this.finishNode(node, "TypeParameterInstantiation");
		}
		flowParseInterfaceType() {
			const node = this.startNode();
			this.expectContextual(129);
			node.extends = [];
			if (this.eat(81)) do
				node.extends.push(this.flowParseInterfaceExtends());
			while (this.eat(12));
			node.body = this.flowParseObjectType({
				allowStatic: false,
				allowExact: false,
				allowSpread: false,
				allowProto: false,
				allowInexact: false
			});
			return this.finishNode(node, "InterfaceTypeAnnotation");
		}
		flowParseObjectPropertyKey() {
			return this.match(135) || this.match(134) ? super.parseExprAtom() : this.parseIdentifier(true);
		}
		flowParseObjectTypeIndexer(node, isStatic$1, variance) {
			node.static = isStatic$1;
			if (this.lookahead().type === 14) {
				node.id = this.flowParseObjectPropertyKey();
				node.key = this.flowParseTypeInitialiser();
			} else {
				node.id = null;
				node.key = this.flowParseType();
			}
			this.expect(3);
			node.value = this.flowParseTypeInitialiser();
			node.variance = variance;
			return this.finishNode(node, "ObjectTypeIndexer");
		}
		flowParseObjectTypeInternalSlot(node, isStatic$1) {
			node.static = isStatic$1;
			node.id = this.flowParseObjectPropertyKey();
			this.expect(3);
			this.expect(3);
			if (this.match(47) || this.match(10)) {
				node.method = true;
				node.optional = false;
				node.value = this.flowParseObjectTypeMethodish(this.startNodeAt(node.loc.start));
			} else {
				node.method = false;
				if (this.eat(17)) node.optional = true;
				node.value = this.flowParseTypeInitialiser();
			}
			return this.finishNode(node, "ObjectTypeInternalSlot");
		}
		flowParseObjectTypeMethodish(node) {
			node.params = [];
			node.rest = null;
			node.typeParameters = null;
			node.this = null;
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
			this.expect(10);
			if (this.match(78)) {
				node.this = this.flowParseFunctionTypeParam(true);
				node.this.name = null;
				if (!this.match(11)) this.expect(12);
			}
			while (!this.match(11) && !this.match(21)) {
				node.params.push(this.flowParseFunctionTypeParam(false));
				if (!this.match(11)) this.expect(12);
			}
			if (this.eat(21)) node.rest = this.flowParseFunctionTypeParam(false);
			this.expect(11);
			node.returnType = this.flowParseTypeInitialiser();
			return this.finishNode(node, "FunctionTypeAnnotation");
		}
		flowParseObjectTypeCallProperty(node, isStatic$1) {
			const valueNode = this.startNode();
			node.static = isStatic$1;
			node.value = this.flowParseObjectTypeMethodish(valueNode);
			return this.finishNode(node, "ObjectTypeCallProperty");
		}
		flowParseObjectType({ allowStatic, allowExact, allowSpread, allowProto, allowInexact }) {
			const oldInType = this.state.inType;
			this.state.inType = true;
			const nodeStart = this.startNode();
			nodeStart.callProperties = [];
			nodeStart.properties = [];
			nodeStart.indexers = [];
			nodeStart.internalSlots = [];
			let endDelim;
			let exact;
			let inexact = false;
			if (allowExact && this.match(6)) {
				this.expect(6);
				endDelim = 9;
				exact = true;
			} else {
				this.expect(5);
				endDelim = 8;
				exact = false;
			}
			nodeStart.exact = exact;
			while (!this.match(endDelim)) {
				let isStatic$1 = false;
				let protoStartLoc = null;
				let inexactStartLoc = null;
				const node = this.startNode();
				if (allowProto && this.isContextual(118)) {
					const lookahead = this.lookahead();
					if (lookahead.type !== 14 && lookahead.type !== 17) {
						this.next();
						protoStartLoc = this.state.startLoc;
						allowStatic = false;
					}
				}
				if (allowStatic && this.isContextual(106)) {
					const lookahead = this.lookahead();
					if (lookahead.type !== 14 && lookahead.type !== 17) {
						this.next();
						isStatic$1 = true;
					}
				}
				const variance = this.flowParseVariance();
				if (this.eat(0)) {
					if (protoStartLoc != null) this.unexpected(protoStartLoc);
					if (this.eat(0)) {
						if (variance) this.unexpected(variance.loc.start);
						nodeStart.internalSlots.push(this.flowParseObjectTypeInternalSlot(node, isStatic$1));
					} else nodeStart.indexers.push(this.flowParseObjectTypeIndexer(node, isStatic$1, variance));
				} else if (this.match(10) || this.match(47)) {
					if (protoStartLoc != null) this.unexpected(protoStartLoc);
					if (variance) this.unexpected(variance.loc.start);
					nodeStart.callProperties.push(this.flowParseObjectTypeCallProperty(node, isStatic$1));
				} else {
					let kind = "init";
					if (this.isContextual(99) || this.isContextual(104)) {
						const lookahead = this.lookahead();
						if (tokenIsLiteralPropertyName(lookahead.type)) {
							kind = this.state.value;
							this.next();
						}
					}
					const propOrInexact = this.flowParseObjectTypeProperty(node, isStatic$1, protoStartLoc, variance, kind, allowSpread, allowInexact != null ? allowInexact : !exact);
					if (propOrInexact === null) {
						inexact = true;
						inexactStartLoc = this.state.lastTokStartLoc;
					} else nodeStart.properties.push(propOrInexact);
				}
				this.flowObjectTypeSemicolon();
				if (inexactStartLoc && !this.match(8) && !this.match(9)) this.raise(FlowErrors.UnexpectedExplicitInexactInObject, inexactStartLoc);
			}
			this.expect(endDelim);
			if (allowSpread) nodeStart.inexact = inexact;
			const out = this.finishNode(nodeStart, "ObjectTypeAnnotation");
			this.state.inType = oldInType;
			return out;
		}
		flowParseObjectTypeProperty(node, isStatic$1, protoStartLoc, variance, kind, allowSpread, allowInexact) {
			if (this.eat(21)) {
				const isInexactToken = this.match(12) || this.match(13) || this.match(8) || this.match(9);
				if (isInexactToken) {
					if (!allowSpread) this.raise(FlowErrors.InexactInsideNonObject, this.state.lastTokStartLoc);
					else if (!allowInexact) this.raise(FlowErrors.InexactInsideExact, this.state.lastTokStartLoc);
					if (variance) this.raise(FlowErrors.InexactVariance, variance);
					return null;
				}
				if (!allowSpread) this.raise(FlowErrors.UnexpectedSpreadType, this.state.lastTokStartLoc);
				if (protoStartLoc != null) this.unexpected(protoStartLoc);
				if (variance) this.raise(FlowErrors.SpreadVariance, variance);
				node.argument = this.flowParseType();
				return this.finishNode(node, "ObjectTypeSpreadProperty");
			} else {
				node.key = this.flowParseObjectPropertyKey();
				node.static = isStatic$1;
				node.proto = protoStartLoc != null;
				node.kind = kind;
				let optional = false;
				if (this.match(47) || this.match(10)) {
					node.method = true;
					if (protoStartLoc != null) this.unexpected(protoStartLoc);
					if (variance) this.unexpected(variance.loc.start);
					node.value = this.flowParseObjectTypeMethodish(this.startNodeAt(node.loc.start));
					if (kind === "get" || kind === "set") this.flowCheckGetterSetterParams(node);
					if (!allowSpread && node.key.name === "constructor" && node.value.this) this.raise(FlowErrors.ThisParamBannedInConstructor, node.value.this);
				} else {
					if (kind !== "init") this.unexpected();
					node.method = false;
					if (this.eat(17)) optional = true;
					node.value = this.flowParseTypeInitialiser();
					node.variance = variance;
				}
				node.optional = optional;
				return this.finishNode(node, "ObjectTypeProperty");
			}
		}
		flowCheckGetterSetterParams(property) {
			const paramCount = property.kind === "get" ? 0 : 1;
			const length = property.value.params.length + (property.value.rest ? 1 : 0);
			if (property.value.this) this.raise(property.kind === "get" ? FlowErrors.GetterMayNotHaveThisParam : FlowErrors.SetterMayNotHaveThisParam, property.value.this);
			if (length !== paramCount) this.raise(property.kind === "get" ? Errors.BadGetterArity : Errors.BadSetterArity, property);
			if (property.kind === "set" && property.value.rest) this.raise(Errors.BadSetterRestParameter, property);
		}
		flowObjectTypeSemicolon() {
			if (!this.eat(13) && !this.eat(12) && !this.match(8) && !this.match(9)) this.unexpected();
		}
		flowParseQualifiedTypeIdentifier(startLoc, id) {
			startLoc != null || (startLoc = this.state.startLoc);
			let node = id || this.flowParseRestrictedIdentifier(true);
			while (this.eat(16)) {
				const node2 = this.startNodeAt(startLoc);
				node2.qualification = node;
				node2.id = this.flowParseRestrictedIdentifier(true);
				node = this.finishNode(node2, "QualifiedTypeIdentifier");
			}
			return node;
		}
		flowParseGenericType(startLoc, id) {
			const node = this.startNodeAt(startLoc);
			node.typeParameters = null;
			node.id = this.flowParseQualifiedTypeIdentifier(startLoc, id);
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterInstantiation();
			return this.finishNode(node, "GenericTypeAnnotation");
		}
		flowParseTypeofType() {
			const node = this.startNode();
			this.expect(87);
			node.argument = this.flowParsePrimaryType();
			return this.finishNode(node, "TypeofTypeAnnotation");
		}
		flowParseTupleType() {
			const node = this.startNode();
			node.types = [];
			this.expect(0);
			while (this.state.pos < this.length && !this.match(3)) {
				node.types.push(this.flowParseType());
				if (this.match(3)) break;
				this.expect(12);
			}
			this.expect(3);
			return this.finishNode(node, "TupleTypeAnnotation");
		}
		flowParseFunctionTypeParam(first) {
			let name = null;
			let optional = false;
			let typeAnnotation = null;
			const node = this.startNode();
			const lh = this.lookahead();
			const isThis = this.state.type === 78;
			if (lh.type === 14 || lh.type === 17) {
				if (isThis && !first) this.raise(FlowErrors.ThisParamMustBeFirst, node);
				name = this.parseIdentifier(isThis);
				if (this.eat(17)) {
					optional = true;
					if (isThis) this.raise(FlowErrors.ThisParamMayNotBeOptional, node);
				}
				typeAnnotation = this.flowParseTypeInitialiser();
			} else typeAnnotation = this.flowParseType();
			node.name = name;
			node.optional = optional;
			node.typeAnnotation = typeAnnotation;
			return this.finishNode(node, "FunctionTypeParam");
		}
		reinterpretTypeAsFunctionTypeParam(type) {
			const node = this.startNodeAt(type.loc.start);
			node.name = null;
			node.optional = false;
			node.typeAnnotation = type;
			return this.finishNode(node, "FunctionTypeParam");
		}
		flowParseFunctionTypeParams(params = []) {
			let rest = null;
			let _this = null;
			if (this.match(78)) {
				_this = this.flowParseFunctionTypeParam(true);
				_this.name = null;
				if (!this.match(11)) this.expect(12);
			}
			while (!this.match(11) && !this.match(21)) {
				params.push(this.flowParseFunctionTypeParam(false));
				if (!this.match(11)) this.expect(12);
			}
			if (this.eat(21)) rest = this.flowParseFunctionTypeParam(false);
			return {
				params,
				rest,
				_this
			};
		}
		flowIdentToTypeAnnotation(startLoc, node, id) {
			switch (id.name) {
				case "any": return this.finishNode(node, "AnyTypeAnnotation");
				case "bool":
				case "boolean": return this.finishNode(node, "BooleanTypeAnnotation");
				case "mixed": return this.finishNode(node, "MixedTypeAnnotation");
				case "empty": return this.finishNode(node, "EmptyTypeAnnotation");
				case "number": return this.finishNode(node, "NumberTypeAnnotation");
				case "string": return this.finishNode(node, "StringTypeAnnotation");
				case "symbol": return this.finishNode(node, "SymbolTypeAnnotation");
				default:
					this.checkNotUnderscore(id.name);
					return this.flowParseGenericType(startLoc, id);
			}
		}
		flowParsePrimaryType() {
			const startLoc = this.state.startLoc;
			const node = this.startNode();
			let tmp;
			let type;
			let isGroupedType = false;
			const oldNoAnonFunctionType = this.state.noAnonFunctionType;
			switch (this.state.type) {
				case 5: return this.flowParseObjectType({
					allowStatic: false,
					allowExact: false,
					allowSpread: true,
					allowProto: false,
					allowInexact: true
				});
				case 6: return this.flowParseObjectType({
					allowStatic: false,
					allowExact: true,
					allowSpread: true,
					allowProto: false,
					allowInexact: false
				});
				case 0:
					this.state.noAnonFunctionType = false;
					type = this.flowParseTupleType();
					this.state.noAnonFunctionType = oldNoAnonFunctionType;
					return type;
				case 47: {
					const node$1 = this.startNode();
					node$1.typeParameters = this.flowParseTypeParameterDeclaration();
					this.expect(10);
					tmp = this.flowParseFunctionTypeParams();
					node$1.params = tmp.params;
					node$1.rest = tmp.rest;
					node$1.this = tmp._this;
					this.expect(11);
					this.expect(19);
					node$1.returnType = this.flowParseType();
					return this.finishNode(node$1, "FunctionTypeAnnotation");
				}
				case 10: {
					const node$1 = this.startNode();
					this.next();
					if (!this.match(11) && !this.match(21)) if (tokenIsIdentifier(this.state.type) || this.match(78)) {
						const token = this.lookahead().type;
						isGroupedType = token !== 17 && token !== 14;
					} else isGroupedType = true;
					if (isGroupedType) {
						this.state.noAnonFunctionType = false;
						type = this.flowParseType();
						this.state.noAnonFunctionType = oldNoAnonFunctionType;
						if (this.state.noAnonFunctionType || !(this.match(12) || this.match(11) && this.lookahead().type === 19)) {
							this.expect(11);
							return type;
						} else this.eat(12);
					}
					if (type) tmp = this.flowParseFunctionTypeParams([this.reinterpretTypeAsFunctionTypeParam(type)]);
					else tmp = this.flowParseFunctionTypeParams();
					node$1.params = tmp.params;
					node$1.rest = tmp.rest;
					node$1.this = tmp._this;
					this.expect(11);
					this.expect(19);
					node$1.returnType = this.flowParseType();
					node$1.typeParameters = null;
					return this.finishNode(node$1, "FunctionTypeAnnotation");
				}
				case 134: return this.parseLiteral(this.state.value, "StringLiteralTypeAnnotation");
				case 85:
				case 86:
					node.value = this.match(85);
					this.next();
					return this.finishNode(node, "BooleanLiteralTypeAnnotation");
				case 53:
					if (this.state.value === "-") {
						this.next();
						if (this.match(135)) return this.parseLiteralAtNode(-this.state.value, "NumberLiteralTypeAnnotation", node);
						if (this.match(136)) return this.parseLiteralAtNode(-this.state.value, "BigIntLiteralTypeAnnotation", node);
						throw this.raise(FlowErrors.UnexpectedSubtractionOperand, this.state.startLoc);
					}
					this.unexpected();
					return;
				case 135: return this.parseLiteral(this.state.value, "NumberLiteralTypeAnnotation");
				case 136: return this.parseLiteral(this.state.value, "BigIntLiteralTypeAnnotation");
				case 88:
					this.next();
					return this.finishNode(node, "VoidTypeAnnotation");
				case 84:
					this.next();
					return this.finishNode(node, "NullLiteralTypeAnnotation");
				case 78:
					this.next();
					return this.finishNode(node, "ThisTypeAnnotation");
				case 55:
					this.next();
					return this.finishNode(node, "ExistsTypeAnnotation");
				case 87: return this.flowParseTypeofType();
				default: if (tokenIsKeyword(this.state.type)) {
					const label = tokenLabelName(this.state.type);
					this.next();
					return super.createIdentifier(node, label);
				} else if (tokenIsIdentifier(this.state.type)) {
					if (this.isContextual(129)) return this.flowParseInterfaceType();
					return this.flowIdentToTypeAnnotation(startLoc, node, this.parseIdentifier());
				}
			}
			this.unexpected();
		}
		flowParsePostfixType() {
			const startLoc = this.state.startLoc;
			let type = this.flowParsePrimaryType();
			let seenOptionalIndexedAccess = false;
			while ((this.match(0) || this.match(18)) && !this.canInsertSemicolon()) {
				const node = this.startNodeAt(startLoc);
				const optional = this.eat(18);
				seenOptionalIndexedAccess = seenOptionalIndexedAccess || optional;
				this.expect(0);
				if (!optional && this.match(3)) {
					node.elementType = type;
					this.next();
					type = this.finishNode(node, "ArrayTypeAnnotation");
				} else {
					node.objectType = type;
					node.indexType = this.flowParseType();
					this.expect(3);
					if (seenOptionalIndexedAccess) {
						node.optional = optional;
						type = this.finishNode(node, "OptionalIndexedAccessType");
					} else type = this.finishNode(node, "IndexedAccessType");
				}
			}
			return type;
		}
		flowParsePrefixType() {
			const node = this.startNode();
			if (this.eat(17)) {
				node.typeAnnotation = this.flowParsePrefixType();
				return this.finishNode(node, "NullableTypeAnnotation");
			} else return this.flowParsePostfixType();
		}
		flowParseAnonFunctionWithoutParens() {
			const param = this.flowParsePrefixType();
			if (!this.state.noAnonFunctionType && this.eat(19)) {
				const node = this.startNodeAt(param.loc.start);
				node.params = [this.reinterpretTypeAsFunctionTypeParam(param)];
				node.rest = null;
				node.this = null;
				node.returnType = this.flowParseType();
				node.typeParameters = null;
				return this.finishNode(node, "FunctionTypeAnnotation");
			}
			return param;
		}
		flowParseIntersectionType() {
			const node = this.startNode();
			this.eat(45);
			const type = this.flowParseAnonFunctionWithoutParens();
			node.types = [type];
			while (this.eat(45)) node.types.push(this.flowParseAnonFunctionWithoutParens());
			return node.types.length === 1 ? type : this.finishNode(node, "IntersectionTypeAnnotation");
		}
		flowParseUnionType() {
			const node = this.startNode();
			this.eat(43);
			const type = this.flowParseIntersectionType();
			node.types = [type];
			while (this.eat(43)) node.types.push(this.flowParseIntersectionType());
			return node.types.length === 1 ? type : this.finishNode(node, "UnionTypeAnnotation");
		}
		flowParseType() {
			const oldInType = this.state.inType;
			this.state.inType = true;
			const type = this.flowParseUnionType();
			this.state.inType = oldInType;
			return type;
		}
		flowParseTypeOrImplicitInstantiation() {
			if (this.state.type === 132 && this.state.value === "_") {
				const startLoc = this.state.startLoc;
				const node = this.parseIdentifier();
				return this.flowParseGenericType(startLoc, node);
			} else return this.flowParseType();
		}
		flowParseTypeAnnotation() {
			const node = this.startNode();
			node.typeAnnotation = this.flowParseTypeInitialiser();
			return this.finishNode(node, "TypeAnnotation");
		}
		flowParseTypeAnnotatableIdentifier(allowPrimitiveOverride) {
			const ident = allowPrimitiveOverride ? this.parseIdentifier() : this.flowParseRestrictedIdentifier();
			if (this.match(14)) {
				ident.typeAnnotation = this.flowParseTypeAnnotation();
				this.resetEndLocation(ident);
			}
			return ident;
		}
		typeCastToParameter(node) {
			node.expression.typeAnnotation = node.typeAnnotation;
			this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
			return node.expression;
		}
		flowParseVariance() {
			let variance = null;
			if (this.match(53)) {
				variance = this.startNode();
				if (this.state.value === "+") variance.kind = "plus";
				else variance.kind = "minus";
				this.next();
				return this.finishNode(variance, "Variance");
			}
			return variance;
		}
		parseFunctionBody(node, allowExpressionBody, isMethod = false) {
			if (allowExpressionBody) {
				this.forwardNoArrowParamsConversionAt(node, () => super.parseFunctionBody(node, true, isMethod));
				return;
			}
			super.parseFunctionBody(node, false, isMethod);
		}
		parseFunctionBodyAndFinish(node, type, isMethod = false) {
			if (this.match(14)) {
				const typeNode = this.startNode();
				[typeNode.typeAnnotation, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
				node.returnType = typeNode.typeAnnotation ? this.finishNode(typeNode, "TypeAnnotation") : null;
			}
			return super.parseFunctionBodyAndFinish(node, type, isMethod);
		}
		parseStatementLike(flags) {
			if (this.state.strict && this.isContextual(129)) {
				const lookahead = this.lookahead();
				if (tokenIsKeywordOrIdentifier(lookahead.type)) {
					const node = this.startNode();
					this.next();
					return this.flowParseInterface(node);
				}
			} else if (this.isContextual(126)) {
				const node = this.startNode();
				this.next();
				return this.flowParseEnumDeclaration(node);
			}
			const stmt = super.parseStatementLike(flags);
			if (this.flowPragma === void 0 && !this.isValidDirective(stmt)) this.flowPragma = null;
			return stmt;
		}
		parseExpressionStatement(node, expr, decorators) {
			if (expr.type === "Identifier") {
				if (expr.name === "declare") {
					if (this.match(80) || tokenIsIdentifier(this.state.type) || this.match(68) || this.match(74) || this.match(82)) return this.flowParseDeclare(node);
				} else if (tokenIsIdentifier(this.state.type)) {
					if (expr.name === "interface") return this.flowParseInterface(node);
					else if (expr.name === "type") return this.flowParseTypeAlias(node);
					else if (expr.name === "opaque") return this.flowParseOpaqueType(node, false);
				}
			}
			return super.parseExpressionStatement(node, expr, decorators);
		}
		shouldParseExportDeclaration() {
			const { type } = this.state;
			if (type === 126 || tokenIsFlowInterfaceOrTypeOrOpaque(type)) return !this.state.containsEsc;
			return super.shouldParseExportDeclaration();
		}
		isExportDefaultSpecifier() {
			const { type } = this.state;
			if (type === 126 || tokenIsFlowInterfaceOrTypeOrOpaque(type)) return this.state.containsEsc;
			return super.isExportDefaultSpecifier();
		}
		parseExportDefaultExpression() {
			if (this.isContextual(126)) {
				const node = this.startNode();
				this.next();
				return this.flowParseEnumDeclaration(node);
			}
			return super.parseExportDefaultExpression();
		}
		parseConditional(expr, startLoc, refExpressionErrors) {
			if (!this.match(17)) return expr;
			if (this.state.maybeInArrowParameters) {
				const nextCh = this.lookaheadCharCode();
				if (nextCh === 44 || nextCh === 61 || nextCh === 58 || nextCh === 41) {
					this.setOptionalParametersError(refExpressionErrors);
					return expr;
				}
			}
			this.expect(17);
			const state = this.state.clone();
			const originalNoArrowAt = this.state.noArrowAt;
			const node = this.startNodeAt(startLoc);
			let { consequent, failed } = this.tryParseConditionalConsequent();
			let [valid, invalid] = this.getArrowLikeExpressions(consequent);
			if (failed || invalid.length > 0) {
				const noArrowAt = [...originalNoArrowAt];
				if (invalid.length > 0) {
					this.state = state;
					this.state.noArrowAt = noArrowAt;
					for (let i = 0; i < invalid.length; i++) noArrowAt.push(invalid[i].start);
					({consequent, failed} = this.tryParseConditionalConsequent());
					[valid, invalid] = this.getArrowLikeExpressions(consequent);
				}
				if (failed && valid.length > 1) this.raise(FlowErrors.AmbiguousConditionalArrow, state.startLoc);
				if (failed && valid.length === 1) {
					this.state = state;
					noArrowAt.push(valid[0].start);
					this.state.noArrowAt = noArrowAt;
					({consequent, failed} = this.tryParseConditionalConsequent());
				}
			}
			this.getArrowLikeExpressions(consequent, true);
			this.state.noArrowAt = originalNoArrowAt;
			this.expect(14);
			node.test = expr;
			node.consequent = consequent;
			node.alternate = this.forwardNoArrowParamsConversionAt(node, () => this.parseMaybeAssign(void 0, void 0));
			return this.finishNode(node, "ConditionalExpression");
		}
		tryParseConditionalConsequent() {
			this.state.noArrowParamsConversionAt.push(this.state.start);
			const consequent = this.parseMaybeAssignAllowIn();
			const failed = !this.match(14);
			this.state.noArrowParamsConversionAt.pop();
			return {
				consequent,
				failed
			};
		}
		getArrowLikeExpressions(node, disallowInvalid) {
			const stack$1 = [node];
			const arrows = [];
			while (stack$1.length !== 0) {
				const node$1 = stack$1.pop();
				if (node$1.type === "ArrowFunctionExpression" && node$1.body.type !== "BlockStatement") {
					if (node$1.typeParameters || !node$1.returnType) this.finishArrowValidation(node$1);
					else arrows.push(node$1);
					stack$1.push(node$1.body);
				} else if (node$1.type === "ConditionalExpression") {
					stack$1.push(node$1.consequent);
					stack$1.push(node$1.alternate);
				}
			}
			if (disallowInvalid) {
				arrows.forEach((node$1) => this.finishArrowValidation(node$1));
				return [arrows, []];
			}
			return partition(arrows, (node$1) => node$1.params.every((param) => this.isAssignable(param, true)));
		}
		finishArrowValidation(node) {
			var _node$extra;
			this.toAssignableList(node.params, (_node$extra = node.extra) == null ? void 0 : _node$extra.trailingCommaLoc, false);
			this.scope.enter(518);
			super.checkParams(node, false, true);
			this.scope.exit();
		}
		forwardNoArrowParamsConversionAt(node, parse$4) {
			let result;
			if (this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) {
				this.state.noArrowParamsConversionAt.push(this.state.start);
				result = parse$4();
				this.state.noArrowParamsConversionAt.pop();
			} else result = parse$4();
			return result;
		}
		parseParenItem(node, startLoc) {
			const newNode = super.parseParenItem(node, startLoc);
			if (this.eat(17)) {
				newNode.optional = true;
				this.resetEndLocation(node);
			}
			if (this.match(14)) {
				const typeCastNode = this.startNodeAt(startLoc);
				typeCastNode.expression = newNode;
				typeCastNode.typeAnnotation = this.flowParseTypeAnnotation();
				return this.finishNode(typeCastNode, "TypeCastExpression");
			}
			return newNode;
		}
		assertModuleNodeAllowed(node) {
			if (node.type === "ImportDeclaration" && (node.importKind === "type" || node.importKind === "typeof") || node.type === "ExportNamedDeclaration" && node.exportKind === "type" || node.type === "ExportAllDeclaration" && node.exportKind === "type") return;
			super.assertModuleNodeAllowed(node);
		}
		parseExportDeclaration(node) {
			if (this.isContextual(130)) {
				node.exportKind = "type";
				const declarationNode = this.startNode();
				this.next();
				if (this.match(5)) {
					node.specifiers = this.parseExportSpecifiers(true);
					super.parseExportFrom(node);
					return null;
				} else return this.flowParseTypeAlias(declarationNode);
			} else if (this.isContextual(131)) {
				node.exportKind = "type";
				const declarationNode = this.startNode();
				this.next();
				return this.flowParseOpaqueType(declarationNode, false);
			} else if (this.isContextual(129)) {
				node.exportKind = "type";
				const declarationNode = this.startNode();
				this.next();
				return this.flowParseInterface(declarationNode);
			} else if (this.isContextual(126)) {
				node.exportKind = "value";
				const declarationNode = this.startNode();
				this.next();
				return this.flowParseEnumDeclaration(declarationNode);
			} else return super.parseExportDeclaration(node);
		}
		eatExportStar(node) {
			if (super.eatExportStar(node)) return true;
			if (this.isContextual(130) && this.lookahead().type === 55) {
				node.exportKind = "type";
				this.next();
				this.next();
				return true;
			}
			return false;
		}
		maybeParseExportNamespaceSpecifier(node) {
			const { startLoc } = this.state;
			const hasNamespace = super.maybeParseExportNamespaceSpecifier(node);
			if (hasNamespace && node.exportKind === "type") this.unexpected(startLoc);
			return hasNamespace;
		}
		parseClassId(node, isStatement, optionalId) {
			super.parseClassId(node, isStatement, optionalId);
			if (this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
		}
		parseClassMember(classBody, member, state) {
			const { startLoc } = this.state;
			if (this.isContextual(125)) {
				if (super.parseClassMemberFromModifier(classBody, member)) return;
				member.declare = true;
			}
			super.parseClassMember(classBody, member, state);
			if (member.declare) {
				if (member.type !== "ClassProperty" && member.type !== "ClassPrivateProperty" && member.type !== "PropertyDefinition") this.raise(FlowErrors.DeclareClassElement, startLoc);
				else if (member.value) this.raise(FlowErrors.DeclareClassFieldInitializer, member.value);
			}
		}
		isIterator(word) {
			return word === "iterator" || word === "asyncIterator";
		}
		readIterator() {
			const word = super.readWord1();
			const fullWord = "@@" + word;
			if (!this.isIterator(word) || !this.state.inType) this.raise(Errors.InvalidIdentifier, this.state.curPosition(), { identifierName: fullWord });
			this.finishToken(132, fullWord);
		}
		getTokenFromCode(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (code$1 === 123 && next$1 === 124) this.finishOp(6, 2);
			else if (this.state.inType && (code$1 === 62 || code$1 === 60)) this.finishOp(code$1 === 62 ? 48 : 47, 1);
			else if (this.state.inType && code$1 === 63) if (next$1 === 46) this.finishOp(18, 2);
			else this.finishOp(17, 1);
			else if (isIteratorStart(code$1, next$1, this.input.charCodeAt(this.state.pos + 2))) {
				this.state.pos += 2;
				this.readIterator();
			} else super.getTokenFromCode(code$1);
		}
		isAssignable(node, isBinding) {
			if (node.type === "TypeCastExpression") return this.isAssignable(node.expression, isBinding);
			else return super.isAssignable(node, isBinding);
		}
		toAssignable(node, isLHS = false) {
			if (!isLHS && node.type === "AssignmentExpression" && node.left.type === "TypeCastExpression") node.left = this.typeCastToParameter(node.left);
			super.toAssignable(node, isLHS);
		}
		toAssignableList(exprList, trailingCommaLoc, isLHS) {
			for (let i = 0; i < exprList.length; i++) {
				const expr = exprList[i];
				if ((expr == null ? void 0 : expr.type) === "TypeCastExpression") exprList[i] = this.typeCastToParameter(expr);
			}
			super.toAssignableList(exprList, trailingCommaLoc, isLHS);
		}
		toReferencedList(exprList, isParenthesizedExpr) {
			for (let i = 0; i < exprList.length; i++) {
				var _expr$extra;
				const expr = exprList[i];
				if (expr && expr.type === "TypeCastExpression" && !((_expr$extra = expr.extra) != null && _expr$extra.parenthesized) && (exprList.length > 1 || !isParenthesizedExpr)) this.raise(FlowErrors.TypeCastInPattern, expr.typeAnnotation);
			}
			return exprList;
		}
		parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
			const node = super.parseArrayLike(close, canBePattern, isTuple, refExpressionErrors);
			if (canBePattern && !this.state.maybeInArrowParameters) this.toReferencedList(node.elements);
			return node;
		}
		isValidLVal(type, isParenthesized, binding) {
			return type === "TypeCastExpression" || super.isValidLVal(type, isParenthesized, binding);
		}
		parseClassProperty(node) {
			if (this.match(14)) node.typeAnnotation = this.flowParseTypeAnnotation();
			return super.parseClassProperty(node);
		}
		parseClassPrivateProperty(node) {
			if (this.match(14)) node.typeAnnotation = this.flowParseTypeAnnotation();
			return super.parseClassPrivateProperty(node);
		}
		isClassMethod() {
			return this.match(47) || super.isClassMethod();
		}
		isClassProperty() {
			return this.match(14) || super.isClassProperty();
		}
		isNonstaticConstructor(method) {
			return !this.match(14) && super.isNonstaticConstructor(method);
		}
		pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
			if (method.variance) this.unexpected(method.variance.loc.start);
			delete method.variance;
			if (this.match(47)) method.typeParameters = this.flowParseTypeParameterDeclaration();
			super.pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper);
			if (method.params && isConstructor) {
				const params = method.params;
				if (params.length > 0 && this.isThisParam(params[0])) this.raise(FlowErrors.ThisParamBannedInConstructor, method);
			} else if (method.type === "MethodDefinition" && isConstructor && method.value.params) {
				const params = method.value.params;
				if (params.length > 0 && this.isThisParam(params[0])) this.raise(FlowErrors.ThisParamBannedInConstructor, method);
			}
		}
		pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
			if (method.variance) this.unexpected(method.variance.loc.start);
			delete method.variance;
			if (this.match(47)) method.typeParameters = this.flowParseTypeParameterDeclaration();
			super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
		}
		parseClassSuper(node) {
			super.parseClassSuper(node);
			if (node.superClass && (this.match(47) || this.match(51))) node.superTypeParameters = this.flowParseTypeParameterInstantiationInExpression();
			if (this.isContextual(113)) {
				this.next();
				const implemented = node.implements = [];
				do {
					const node$1 = this.startNode();
					node$1.id = this.flowParseRestrictedIdentifier(true);
					if (this.match(47)) node$1.typeParameters = this.flowParseTypeParameterInstantiation();
					else node$1.typeParameters = null;
					implemented.push(this.finishNode(node$1, "ClassImplements"));
				} while (this.eat(12));
			}
		}
		checkGetterSetterParams(method) {
			super.checkGetterSetterParams(method);
			const params = this.getObjectOrClassMethodParams(method);
			if (params.length > 0) {
				const param = params[0];
				if (this.isThisParam(param) && method.kind === "get") this.raise(FlowErrors.GetterMayNotHaveThisParam, param);
				else if (this.isThisParam(param)) this.raise(FlowErrors.SetterMayNotHaveThisParam, param);
			}
		}
		parsePropertyNamePrefixOperator(node) {
			node.variance = this.flowParseVariance();
		}
		parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
			if (prop.variance) this.unexpected(prop.variance.loc.start);
			delete prop.variance;
			let typeParameters;
			if (this.match(47) && !isAccessor) {
				typeParameters = this.flowParseTypeParameterDeclaration();
				if (!this.match(10)) this.unexpected();
			}
			const result = super.parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors);
			if (typeParameters) (result.value || result).typeParameters = typeParameters;
			return result;
		}
		parseFunctionParamType(param) {
			if (this.eat(17)) {
				if (param.type !== "Identifier") this.raise(FlowErrors.PatternIsOptional, param);
				if (this.isThisParam(param)) this.raise(FlowErrors.ThisParamMayNotBeOptional, param);
				param.optional = true;
			}
			if (this.match(14)) param.typeAnnotation = this.flowParseTypeAnnotation();
			else if (this.isThisParam(param)) this.raise(FlowErrors.ThisParamAnnotationRequired, param);
			if (this.match(29) && this.isThisParam(param)) this.raise(FlowErrors.ThisParamNoDefault, param);
			this.resetEndLocation(param);
			return param;
		}
		parseMaybeDefault(startLoc, left) {
			const node = super.parseMaybeDefault(startLoc, left);
			if (node.type === "AssignmentPattern" && node.typeAnnotation && node.right.start < node.typeAnnotation.start) this.raise(FlowErrors.TypeBeforeInitializer, node.typeAnnotation);
			return node;
		}
		checkImportReflection(node) {
			super.checkImportReflection(node);
			if (node.module && node.importKind !== "value") this.raise(FlowErrors.ImportReflectionHasImportType, node.specifiers[0].loc.start);
		}
		parseImportSpecifierLocal(node, specifier, type) {
			specifier.local = hasTypeImportKind(node) ? this.flowParseRestrictedIdentifier(true, true) : this.parseIdentifier();
			node.specifiers.push(this.finishImportSpecifier(specifier, type));
		}
		isPotentialImportPhase(isExport) {
			if (super.isPotentialImportPhase(isExport)) return true;
			if (this.isContextual(130)) {
				if (!isExport) return true;
				const ch = this.lookaheadCharCode();
				return ch === 123 || ch === 42;
			}
			return !isExport && this.isContextual(87);
		}
		applyImportPhase(node, isExport, phase, loc) {
			super.applyImportPhase(node, isExport, phase, loc);
			if (isExport) {
				if (!phase && this.match(65)) return;
				node.exportKind = phase === "type" ? phase : "value";
			} else {
				if (phase === "type" && this.match(55)) this.unexpected();
				node.importKind = phase === "type" || phase === "typeof" ? phase : "value";
			}
		}
		parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
			const firstIdent = specifier.imported;
			let specifierTypeKind = null;
			if (firstIdent.type === "Identifier") {
				if (firstIdent.name === "type") specifierTypeKind = "type";
				else if (firstIdent.name === "typeof") specifierTypeKind = "typeof";
			}
			let isBinding = false;
			if (this.isContextual(93) && !this.isLookaheadContextual("as")) {
				const as_ident = this.parseIdentifier(true);
				if (specifierTypeKind !== null && !tokenIsKeywordOrIdentifier(this.state.type)) {
					specifier.imported = as_ident;
					specifier.importKind = specifierTypeKind;
					specifier.local = this.cloneIdentifier(as_ident);
				} else {
					specifier.imported = firstIdent;
					specifier.importKind = null;
					specifier.local = this.parseIdentifier();
				}
			} else {
				if (specifierTypeKind !== null && tokenIsKeywordOrIdentifier(this.state.type)) {
					specifier.imported = this.parseIdentifier(true);
					specifier.importKind = specifierTypeKind;
				} else {
					if (importedIsString) throw this.raise(Errors.ImportBindingIsString, specifier, { importName: firstIdent.value });
					specifier.imported = firstIdent;
					specifier.importKind = null;
				}
				if (this.eatContextual(93)) specifier.local = this.parseIdentifier();
				else {
					isBinding = true;
					specifier.local = this.cloneIdentifier(specifier.imported);
				}
			}
			const specifierIsTypeImport = hasTypeImportKind(specifier);
			if (isInTypeOnlyImport && specifierIsTypeImport) this.raise(FlowErrors.ImportTypeShorthandOnlyInPureImport, specifier);
			if (isInTypeOnlyImport || specifierIsTypeImport) this.checkReservedType(specifier.local.name, specifier.local.loc.start, true);
			if (isBinding && !isInTypeOnlyImport && !specifierIsTypeImport) this.checkReservedWord(specifier.local.name, specifier.loc.start, true, true);
			return this.finishImportSpecifier(specifier, "ImportSpecifier");
		}
		parseBindingAtom() {
			switch (this.state.type) {
				case 78: return this.parseIdentifier(true);
				default: return super.parseBindingAtom();
			}
		}
		parseFunctionParams(node, isConstructor) {
			const kind = node.kind;
			if (kind !== "get" && kind !== "set" && this.match(47)) node.typeParameters = this.flowParseTypeParameterDeclaration();
			super.parseFunctionParams(node, isConstructor);
		}
		parseVarId(decl, kind) {
			super.parseVarId(decl, kind);
			if (this.match(14)) {
				decl.id.typeAnnotation = this.flowParseTypeAnnotation();
				this.resetEndLocation(decl.id);
			}
		}
		parseAsyncArrowFromCallExpression(node, call) {
			if (this.match(14)) {
				const oldNoAnonFunctionType = this.state.noAnonFunctionType;
				this.state.noAnonFunctionType = true;
				node.returnType = this.flowParseTypeAnnotation();
				this.state.noAnonFunctionType = oldNoAnonFunctionType;
			}
			return super.parseAsyncArrowFromCallExpression(node, call);
		}
		shouldParseAsyncArrow() {
			return this.match(14) || super.shouldParseAsyncArrow();
		}
		parseMaybeAssign(refExpressionErrors, afterLeftParse) {
			var _jsx;
			let state = null;
			let jsx$1;
			if (this.hasPlugin("jsx") && (this.match(143) || this.match(47))) {
				state = this.state.clone();
				jsx$1 = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
				if (!jsx$1.error) return jsx$1.node;
				const { context } = this.state;
				const currentContext = context[context.length - 1];
				if (currentContext === types$1.j_oTag || currentContext === types$1.j_expr) context.pop();
			}
			if ((_jsx = jsx$1) != null && _jsx.error || this.match(47)) {
				var _jsx2, _jsx3;
				state = state || this.state.clone();
				let typeParameters;
				const arrow = this.tryParse((abort) => {
					var _arrowExpression$extr;
					typeParameters = this.flowParseTypeParameterDeclaration();
					const arrowExpression$1 = this.forwardNoArrowParamsConversionAt(typeParameters, () => {
						const result = super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
						this.resetStartLocationFromNode(result, typeParameters);
						return result;
					});
					if ((_arrowExpression$extr = arrowExpression$1.extra) != null && _arrowExpression$extr.parenthesized) abort();
					const expr = this.maybeUnwrapTypeCastExpression(arrowExpression$1);
					if (expr.type !== "ArrowFunctionExpression") abort();
					expr.typeParameters = typeParameters;
					this.resetStartLocationFromNode(expr, typeParameters);
					return arrowExpression$1;
				}, state);
				let arrowExpression = null;
				if (arrow.node && this.maybeUnwrapTypeCastExpression(arrow.node).type === "ArrowFunctionExpression") {
					if (!arrow.error && !arrow.aborted) {
						if (arrow.node.async) this.raise(FlowErrors.UnexpectedTypeParameterBeforeAsyncArrowFunction, typeParameters);
						return arrow.node;
					}
					arrowExpression = arrow.node;
				}
				if ((_jsx2 = jsx$1) != null && _jsx2.node) {
					this.state = jsx$1.failState;
					return jsx$1.node;
				}
				if (arrowExpression) {
					this.state = arrow.failState;
					return arrowExpression;
				}
				if ((_jsx3 = jsx$1) != null && _jsx3.thrown) throw jsx$1.error;
				if (arrow.thrown) throw arrow.error;
				throw this.raise(FlowErrors.UnexpectedTokenAfterTypeParameter, typeParameters);
			}
			return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
		}
		parseArrow(node) {
			if (this.match(14)) {
				const result = this.tryParse(() => {
					const oldNoAnonFunctionType = this.state.noAnonFunctionType;
					this.state.noAnonFunctionType = true;
					const typeNode = this.startNode();
					[typeNode.typeAnnotation, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
					this.state.noAnonFunctionType = oldNoAnonFunctionType;
					if (this.canInsertSemicolon()) this.unexpected();
					if (!this.match(19)) this.unexpected();
					return typeNode;
				});
				if (result.thrown) return null;
				if (result.error) this.state = result.failState;
				node.returnType = result.node.typeAnnotation ? this.finishNode(result.node, "TypeAnnotation") : null;
			}
			return super.parseArrow(node);
		}
		shouldParseArrow(params) {
			return this.match(14) || super.shouldParseArrow(params);
		}
		setArrowFunctionParameters(node, params) {
			if (this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) node.params = params;
			else super.setArrowFunctionParameters(node, params);
		}
		checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged = true) {
			if (isArrowFunction && this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) return;
			for (let i = 0; i < node.params.length; i++) if (this.isThisParam(node.params[i]) && i > 0) this.raise(FlowErrors.ThisParamMustBeFirst, node.params[i]);
			super.checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged);
		}
		parseParenAndDistinguishExpression(canBeArrow) {
			return super.parseParenAndDistinguishExpression(canBeArrow && !this.state.noArrowAt.includes(this.sourceToOffsetPos(this.state.start)));
		}
		parseSubscripts(base, startLoc, noCalls) {
			if (base.type === "Identifier" && base.name === "async" && this.state.noArrowAt.includes(startLoc.index)) {
				this.next();
				const node = this.startNodeAt(startLoc);
				node.callee = base;
				node.arguments = super.parseCallExpressionArguments();
				base = this.finishNode(node, "CallExpression");
			} else if (base.type === "Identifier" && base.name === "async" && this.match(47)) {
				const state = this.state.clone();
				const arrow = this.tryParse((abort) => this.parseAsyncArrowWithTypeParameters(startLoc) || abort(), state);
				if (!arrow.error && !arrow.aborted) return arrow.node;
				const result = this.tryParse(() => super.parseSubscripts(base, startLoc, noCalls), state);
				if (result.node && !result.error) return result.node;
				if (arrow.node) {
					this.state = arrow.failState;
					return arrow.node;
				}
				if (result.node) {
					this.state = result.failState;
					return result.node;
				}
				throw arrow.error || result.error;
			}
			return super.parseSubscripts(base, startLoc, noCalls);
		}
		parseSubscript(base, startLoc, noCalls, subscriptState) {
			if (this.match(18) && this.isLookaheadToken_lt()) {
				subscriptState.optionalChainMember = true;
				if (noCalls) {
					subscriptState.stop = true;
					return base;
				}
				this.next();
				const node = this.startNodeAt(startLoc);
				node.callee = base;
				node.typeArguments = this.flowParseTypeParameterInstantiationInExpression();
				this.expect(10);
				node.arguments = this.parseCallExpressionArguments();
				node.optional = true;
				return this.finishCallExpression(node, true);
			} else if (!noCalls && this.shouldParseTypes() && (this.match(47) || this.match(51))) {
				const node = this.startNodeAt(startLoc);
				node.callee = base;
				const result = this.tryParse(() => {
					node.typeArguments = this.flowParseTypeParameterInstantiationCallOrNew();
					this.expect(10);
					node.arguments = super.parseCallExpressionArguments();
					if (subscriptState.optionalChainMember) node.optional = false;
					return this.finishCallExpression(node, subscriptState.optionalChainMember);
				});
				if (result.node) {
					if (result.error) this.state = result.failState;
					return result.node;
				}
			}
			return super.parseSubscript(base, startLoc, noCalls, subscriptState);
		}
		parseNewCallee(node) {
			super.parseNewCallee(node);
			let targs = null;
			if (this.shouldParseTypes() && this.match(47)) targs = this.tryParse(() => this.flowParseTypeParameterInstantiationCallOrNew()).node;
			node.typeArguments = targs;
		}
		parseAsyncArrowWithTypeParameters(startLoc) {
			const node = this.startNodeAt(startLoc);
			this.parseFunctionParams(node, false);
			if (!this.parseArrow(node)) return;
			return super.parseArrowExpression(node, void 0, true);
		}
		readToken_mult_modulo(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (code$1 === 42 && next$1 === 47 && this.state.hasFlowComment) {
				this.state.hasFlowComment = false;
				this.state.pos += 2;
				this.nextToken();
				return;
			}
			super.readToken_mult_modulo(code$1);
		}
		readToken_pipe_amp(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (code$1 === 124 && next$1 === 125) {
				this.finishOp(9, 2);
				return;
			}
			super.readToken_pipe_amp(code$1);
		}
		parseTopLevel(file, program) {
			const fileNode = super.parseTopLevel(file, program);
			if (this.state.hasFlowComment) this.raise(FlowErrors.UnterminatedFlowComment, this.state.curPosition());
			return fileNode;
		}
		skipBlockComment() {
			if (this.hasPlugin("flowComments") && this.skipFlowComment()) {
				if (this.state.hasFlowComment) throw this.raise(FlowErrors.NestedFlowComment, this.state.startLoc);
				this.hasFlowCommentCompletion();
				const commentSkip = this.skipFlowComment();
				if (commentSkip) {
					this.state.pos += commentSkip;
					this.state.hasFlowComment = true;
				}
				return;
			}
			return super.skipBlockComment(this.state.hasFlowComment ? "*-/" : "*/");
		}
		skipFlowComment() {
			const { pos } = this.state;
			let shiftToFirstNonWhiteSpace = 2;
			while ([32, 9].includes(this.input.charCodeAt(pos + shiftToFirstNonWhiteSpace))) shiftToFirstNonWhiteSpace++;
			const ch2 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos);
			const ch3 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos + 1);
			if (ch2 === 58 && ch3 === 58) return shiftToFirstNonWhiteSpace + 2;
			if (this.input.slice(shiftToFirstNonWhiteSpace + pos, shiftToFirstNonWhiteSpace + pos + 12) === "flow-include") return shiftToFirstNonWhiteSpace + 12;
			if (ch2 === 58 && ch3 !== 58) return shiftToFirstNonWhiteSpace;
			return false;
		}
		hasFlowCommentCompletion() {
			const end = this.input.indexOf("*/", this.state.pos);
			if (end === -1) throw this.raise(Errors.UnterminatedComment, this.state.curPosition());
		}
		flowEnumErrorBooleanMemberNotInitialized(loc, { enumName, memberName }) {
			this.raise(FlowErrors.EnumBooleanMemberNotInitialized, loc, {
				memberName,
				enumName
			});
		}
		flowEnumErrorInvalidMemberInitializer(loc, enumContext) {
			return this.raise(!enumContext.explicitType ? FlowErrors.EnumInvalidMemberInitializerUnknownType : enumContext.explicitType === "symbol" ? FlowErrors.EnumInvalidMemberInitializerSymbolType : FlowErrors.EnumInvalidMemberInitializerPrimaryType, loc, enumContext);
		}
		flowEnumErrorNumberMemberNotInitialized(loc, details) {
			this.raise(FlowErrors.EnumNumberMemberNotInitialized, loc, details);
		}
		flowEnumErrorStringMemberInconsistentlyInitialized(node, details) {
			this.raise(FlowErrors.EnumStringMemberInconsistentlyInitialized, node, details);
		}
		flowEnumMemberInit() {
			const startLoc = this.state.startLoc;
			const endOfInit = () => this.match(12) || this.match(8);
			switch (this.state.type) {
				case 135: {
					const literal = this.parseNumericLiteral(this.state.value);
					if (endOfInit()) return {
						type: "number",
						loc: literal.loc.start,
						value: literal
					};
					return {
						type: "invalid",
						loc: startLoc
					};
				}
				case 134: {
					const literal = this.parseStringLiteral(this.state.value);
					if (endOfInit()) return {
						type: "string",
						loc: literal.loc.start,
						value: literal
					};
					return {
						type: "invalid",
						loc: startLoc
					};
				}
				case 85:
				case 86: {
					const literal = this.parseBooleanLiteral(this.match(85));
					if (endOfInit()) return {
						type: "boolean",
						loc: literal.loc.start,
						value: literal
					};
					return {
						type: "invalid",
						loc: startLoc
					};
				}
				default: return {
					type: "invalid",
					loc: startLoc
				};
			}
		}
		flowEnumMemberRaw() {
			const loc = this.state.startLoc;
			const id = this.parseIdentifier(true);
			const init = this.eat(29) ? this.flowEnumMemberInit() : {
				type: "none",
				loc
			};
			return {
				id,
				init
			};
		}
		flowEnumCheckExplicitTypeMismatch(loc, context, expectedType) {
			const { explicitType } = context;
			if (explicitType === null) return;
			if (explicitType !== expectedType) this.flowEnumErrorInvalidMemberInitializer(loc, context);
		}
		flowEnumMembers({ enumName, explicitType }) {
			const seenNames = /* @__PURE__ */ new Set();
			const members = {
				booleanMembers: [],
				numberMembers: [],
				stringMembers: [],
				defaultedMembers: []
			};
			let hasUnknownMembers = false;
			while (!this.match(8)) {
				if (this.eat(21)) {
					hasUnknownMembers = true;
					break;
				}
				const memberNode = this.startNode();
				const { id, init } = this.flowEnumMemberRaw();
				const memberName = id.name;
				if (memberName === "") continue;
				if (/^[a-z]/.test(memberName)) this.raise(FlowErrors.EnumInvalidMemberName, id, {
					memberName,
					suggestion: memberName[0].toUpperCase() + memberName.slice(1),
					enumName
				});
				if (seenNames.has(memberName)) this.raise(FlowErrors.EnumDuplicateMemberName, id, {
					memberName,
					enumName
				});
				seenNames.add(memberName);
				const context = {
					enumName,
					explicitType,
					memberName
				};
				memberNode.id = id;
				switch (init.type) {
					case "boolean": {
						this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "boolean");
						memberNode.init = init.value;
						members.booleanMembers.push(this.finishNode(memberNode, "EnumBooleanMember"));
						break;
					}
					case "number": {
						this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "number");
						memberNode.init = init.value;
						members.numberMembers.push(this.finishNode(memberNode, "EnumNumberMember"));
						break;
					}
					case "string": {
						this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "string");
						memberNode.init = init.value;
						members.stringMembers.push(this.finishNode(memberNode, "EnumStringMember"));
						break;
					}
					case "invalid": throw this.flowEnumErrorInvalidMemberInitializer(init.loc, context);
					case "none": switch (explicitType) {
						case "boolean":
							this.flowEnumErrorBooleanMemberNotInitialized(init.loc, context);
							break;
						case "number":
							this.flowEnumErrorNumberMemberNotInitialized(init.loc, context);
							break;
						default: members.defaultedMembers.push(this.finishNode(memberNode, "EnumDefaultedMember"));
					}
				}
				if (!this.match(8)) this.expect(12);
			}
			return {
				members,
				hasUnknownMembers
			};
		}
		flowEnumStringMembers(initializedMembers, defaultedMembers, { enumName }) {
			if (initializedMembers.length === 0) return defaultedMembers;
			else if (defaultedMembers.length === 0) return initializedMembers;
			else if (defaultedMembers.length > initializedMembers.length) {
				for (const member of initializedMembers) this.flowEnumErrorStringMemberInconsistentlyInitialized(member, { enumName });
				return defaultedMembers;
			} else {
				for (const member of defaultedMembers) this.flowEnumErrorStringMemberInconsistentlyInitialized(member, { enumName });
				return initializedMembers;
			}
		}
		flowEnumParseExplicitType({ enumName }) {
			if (!this.eatContextual(102)) return null;
			if (!tokenIsIdentifier(this.state.type)) throw this.raise(FlowErrors.EnumInvalidExplicitTypeUnknownSupplied, this.state.startLoc, { enumName });
			const { value } = this.state;
			this.next();
			if (value !== "boolean" && value !== "number" && value !== "string" && value !== "symbol") this.raise(FlowErrors.EnumInvalidExplicitType, this.state.startLoc, {
				enumName,
				invalidEnumType: value
			});
			return value;
		}
		flowEnumBody(node, id) {
			const enumName = id.name;
			const nameLoc = id.loc.start;
			const explicitType = this.flowEnumParseExplicitType({ enumName });
			this.expect(5);
			const { members, hasUnknownMembers } = this.flowEnumMembers({
				enumName,
				explicitType
			});
			node.hasUnknownMembers = hasUnknownMembers;
			switch (explicitType) {
				case "boolean":
					node.explicitType = true;
					node.members = members.booleanMembers;
					this.expect(8);
					return this.finishNode(node, "EnumBooleanBody");
				case "number":
					node.explicitType = true;
					node.members = members.numberMembers;
					this.expect(8);
					return this.finishNode(node, "EnumNumberBody");
				case "string":
					node.explicitType = true;
					node.members = this.flowEnumStringMembers(members.stringMembers, members.defaultedMembers, { enumName });
					this.expect(8);
					return this.finishNode(node, "EnumStringBody");
				case "symbol":
					node.members = members.defaultedMembers;
					this.expect(8);
					return this.finishNode(node, "EnumSymbolBody");
				default: {
					const empty = () => {
						node.members = [];
						this.expect(8);
						return this.finishNode(node, "EnumStringBody");
					};
					node.explicitType = false;
					const boolsLen = members.booleanMembers.length;
					const numsLen = members.numberMembers.length;
					const strsLen = members.stringMembers.length;
					const defaultedLen = members.defaultedMembers.length;
					if (!boolsLen && !numsLen && !strsLen && !defaultedLen) return empty();
					else if (!boolsLen && !numsLen) {
						node.members = this.flowEnumStringMembers(members.stringMembers, members.defaultedMembers, { enumName });
						this.expect(8);
						return this.finishNode(node, "EnumStringBody");
					} else if (!numsLen && !strsLen && boolsLen >= defaultedLen) {
						for (const member of members.defaultedMembers) this.flowEnumErrorBooleanMemberNotInitialized(member.loc.start, {
							enumName,
							memberName: member.id.name
						});
						node.members = members.booleanMembers;
						this.expect(8);
						return this.finishNode(node, "EnumBooleanBody");
					} else if (!boolsLen && !strsLen && numsLen >= defaultedLen) {
						for (const member of members.defaultedMembers) this.flowEnumErrorNumberMemberNotInitialized(member.loc.start, {
							enumName,
							memberName: member.id.name
						});
						node.members = members.numberMembers;
						this.expect(8);
						return this.finishNode(node, "EnumNumberBody");
					} else {
						this.raise(FlowErrors.EnumInconsistentMemberValues, nameLoc, { enumName });
						return empty();
					}
				}
			}
		}
		flowParseEnumDeclaration(node) {
			const id = this.parseIdentifier();
			node.id = id;
			node.body = this.flowEnumBody(this.startNode(), id);
			return this.finishNode(node, "EnumDeclaration");
		}
		jsxParseOpeningElementAfterName(node) {
			if (this.shouldParseTypes()) {
				if (this.match(47) || this.match(51)) node.typeArguments = this.flowParseTypeParameterInstantiationInExpression();
			}
			return super.jsxParseOpeningElementAfterName(node);
		}
		isLookaheadToken_lt() {
			const next$1 = this.nextTokenStart();
			if (this.input.charCodeAt(next$1) === 60) {
				const afterNext = this.input.charCodeAt(next$1 + 1);
				return afterNext !== 60 && afterNext !== 61;
			}
			return false;
		}
		reScan_lt_gt() {
			const { type } = this.state;
			if (type === 47) {
				this.state.pos -= 1;
				this.readToken_lt();
			} else if (type === 48) {
				this.state.pos -= 1;
				this.readToken_gt();
			}
		}
		reScan_lt() {
			const { type } = this.state;
			if (type === 51) {
				this.state.pos -= 2;
				this.finishOp(47, 1);
				return 47;
			}
			return type;
		}
		maybeUnwrapTypeCastExpression(node) {
			return node.type === "TypeCastExpression" ? node.expression : node;
		}
	};
	const entities = {
		__proto__: null,
		quot: "\"",
		amp: "&",
		apos: "'",
		lt: "<",
		gt: ">",
		nbsp: "\xA0",
		iexcl: "¡",
		cent: "¢",
		pound: "£",
		curren: "¤",
		yen: "¥",
		brvbar: "¦",
		sect: "§",
		uml: "¨",
		copy: "©",
		ordf: "ª",
		laquo: "«",
		not: "¬",
		shy: "­",
		reg: "®",
		macr: "¯",
		deg: "°",
		plusmn: "±",
		sup2: "²",
		sup3: "³",
		acute: "´",
		micro: "µ",
		para: "¶",
		middot: "·",
		cedil: "¸",
		sup1: "¹",
		ordm: "º",
		raquo: "»",
		frac14: "¼",
		frac12: "½",
		frac34: "¾",
		iquest: "¿",
		Agrave: "À",
		Aacute: "Á",
		Acirc: "Â",
		Atilde: "Ã",
		Auml: "Ä",
		Aring: "Å",
		AElig: "Æ",
		Ccedil: "Ç",
		Egrave: "È",
		Eacute: "É",
		Ecirc: "Ê",
		Euml: "Ë",
		Igrave: "Ì",
		Iacute: "Í",
		Icirc: "Î",
		Iuml: "Ï",
		ETH: "Ð",
		Ntilde: "Ñ",
		Ograve: "Ò",
		Oacute: "Ó",
		Ocirc: "Ô",
		Otilde: "Õ",
		Ouml: "Ö",
		times: "×",
		Oslash: "Ø",
		Ugrave: "Ù",
		Uacute: "Ú",
		Ucirc: "Û",
		Uuml: "Ü",
		Yacute: "Ý",
		THORN: "Þ",
		szlig: "ß",
		agrave: "à",
		aacute: "á",
		acirc: "â",
		atilde: "ã",
		auml: "ä",
		aring: "å",
		aelig: "æ",
		ccedil: "ç",
		egrave: "è",
		eacute: "é",
		ecirc: "ê",
		euml: "ë",
		igrave: "ì",
		iacute: "í",
		icirc: "î",
		iuml: "ï",
		eth: "ð",
		ntilde: "ñ",
		ograve: "ò",
		oacute: "ó",
		ocirc: "ô",
		otilde: "õ",
		ouml: "ö",
		divide: "÷",
		oslash: "ø",
		ugrave: "ù",
		uacute: "ú",
		ucirc: "û",
		uuml: "ü",
		yacute: "ý",
		thorn: "þ",
		yuml: "ÿ",
		OElig: "Œ",
		oelig: "œ",
		Scaron: "Š",
		scaron: "š",
		Yuml: "Ÿ",
		fnof: "ƒ",
		circ: "ˆ",
		tilde: "˜",
		Alpha: "Α",
		Beta: "Β",
		Gamma: "Γ",
		Delta: "Δ",
		Epsilon: "Ε",
		Zeta: "Ζ",
		Eta: "Η",
		Theta: "Θ",
		Iota: "Ι",
		Kappa: "Κ",
		Lambda: "Λ",
		Mu: "Μ",
		Nu: "Ν",
		Xi: "Ξ",
		Omicron: "Ο",
		Pi: "Π",
		Rho: "Ρ",
		Sigma: "Σ",
		Tau: "Τ",
		Upsilon: "Υ",
		Phi: "Φ",
		Chi: "Χ",
		Psi: "Ψ",
		Omega: "Ω",
		alpha: "α",
		beta: "β",
		gamma: "γ",
		delta: "δ",
		epsilon: "ε",
		zeta: "ζ",
		eta: "η",
		theta: "θ",
		iota: "ι",
		kappa: "κ",
		lambda: "λ",
		mu: "μ",
		nu: "ν",
		xi: "ξ",
		omicron: "ο",
		pi: "π",
		rho: "ρ",
		sigmaf: "ς",
		sigma: "σ",
		tau: "τ",
		upsilon: "υ",
		phi: "φ",
		chi: "χ",
		psi: "ψ",
		omega: "ω",
		thetasym: "ϑ",
		upsih: "ϒ",
		piv: "ϖ",
		ensp: " ",
		emsp: " ",
		thinsp: " ",
		zwnj: "‌",
		zwj: "‍",
		lrm: "‎",
		rlm: "‏",
		ndash: "–",
		mdash: "—",
		lsquo: "‘",
		rsquo: "’",
		sbquo: "‚",
		ldquo: "“",
		rdquo: "”",
		bdquo: "„",
		dagger: "†",
		Dagger: "‡",
		bull: "•",
		hellip: "…",
		permil: "‰",
		prime: "′",
		Prime: "″",
		lsaquo: "‹",
		rsaquo: "›",
		oline: "‾",
		frasl: "⁄",
		euro: "€",
		image: "ℑ",
		weierp: "℘",
		real: "ℜ",
		trade: "™",
		alefsym: "ℵ",
		larr: "←",
		uarr: "↑",
		rarr: "→",
		darr: "↓",
		harr: "↔",
		crarr: "↵",
		lArr: "⇐",
		uArr: "⇑",
		rArr: "⇒",
		dArr: "⇓",
		hArr: "⇔",
		forall: "∀",
		part: "∂",
		exist: "∃",
		empty: "∅",
		nabla: "∇",
		isin: "∈",
		notin: "∉",
		ni: "∋",
		prod: "∏",
		sum: "∑",
		minus: "−",
		lowast: "∗",
		radic: "√",
		prop: "∝",
		infin: "∞",
		ang: "∠",
		and: "∧",
		or: "∨",
		cap: "∩",
		cup: "∪",
		int: "∫",
		there4: "∴",
		sim: "∼",
		cong: "≅",
		asymp: "≈",
		ne: "≠",
		equiv: "≡",
		le: "≤",
		ge: "≥",
		sub: "⊂",
		sup: "⊃",
		nsub: "⊄",
		sube: "⊆",
		supe: "⊇",
		oplus: "⊕",
		otimes: "⊗",
		perp: "⊥",
		sdot: "⋅",
		lceil: "⌈",
		rceil: "⌉",
		lfloor: "⌊",
		rfloor: "⌋",
		lang: "〈",
		rang: "〉",
		loz: "◊",
		spades: "♠",
		clubs: "♣",
		hearts: "♥",
		diams: "♦"
	};
	const lineBreak = /\r\n|[\r\n\u2028\u2029]/;
	const lineBreakG = new RegExp(lineBreak.source, "g");
	function isNewLine(code$1) {
		switch (code$1) {
			case 10:
			case 13:
			case 8232:
			case 8233: return true;
			default: return false;
		}
	}
	function hasNewLine(input, start, end) {
		for (let i = start; i < end; i++) if (isNewLine(input.charCodeAt(i))) return true;
		return false;
	}
	const skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
	const skipWhiteSpaceInLine = /(?:[^\S\n\r\u2028\u2029]|\/\/.*|\/\*.*?\*\/)*/g;
	function isWhitespace$2(code$1) {
		switch (code$1) {
			case 9:
			case 11:
			case 12:
			case 32:
			case 160:
			case 5760:
			case 8192:
			case 8193:
			case 8194:
			case 8195:
			case 8196:
			case 8197:
			case 8198:
			case 8199:
			case 8200:
			case 8201:
			case 8202:
			case 8239:
			case 8287:
			case 12288:
			case 65279: return true;
			default: return false;
		}
	}
	const JsxErrors = ParseErrorEnum`jsx`({
		AttributeIsEmpty: "JSX attributes must only be assigned a non-empty expression.",
		MissingClosingTagElement: ({ openingTagName }) => `Expected corresponding JSX closing tag for <${openingTagName}>.`,
		MissingClosingTagFragment: "Expected corresponding JSX closing tag for <>.",
		UnexpectedSequenceExpression: "Sequence expressions cannot be directly nested inside JSX. Did you mean to wrap it in parentheses (...)?",
		UnexpectedToken: ({ unexpected, HTMLEntity }) => `Unexpected token \`${unexpected}\`. Did you mean \`${HTMLEntity}\` or \`{'${unexpected}'}\`?`,
		UnsupportedJsxValue: "JSX value should be either an expression or a quoted JSX text.",
		UnterminatedJsxContent: "Unterminated JSX contents.",
		UnwrappedAdjacentJSXElements: "Adjacent JSX elements must be wrapped in an enclosing tag. Did you want a JSX fragment <>...</>?"
	});
	function isFragment$1(object) {
		return object ? object.type === "JSXOpeningFragment" || object.type === "JSXClosingFragment" : false;
	}
	function getQualifiedJSXName(object) {
		if (object.type === "JSXIdentifier") return object.name;
		if (object.type === "JSXNamespacedName") return object.namespace.name + ":" + object.name.name;
		if (object.type === "JSXMemberExpression") return getQualifiedJSXName(object.object) + "." + getQualifiedJSXName(object.property);
		throw new Error("Node had unexpected type: " + object.type);
	}
	var jsx = (superClass) => class JSXParserMixin extends superClass {
		jsxReadToken() {
			let out = "";
			let chunkStart = this.state.pos;
			for (;;) {
				if (this.state.pos >= this.length) throw this.raise(JsxErrors.UnterminatedJsxContent, this.state.startLoc);
				const ch = this.input.charCodeAt(this.state.pos);
				switch (ch) {
					case 60:
					case 123:
						if (this.state.pos === this.state.start) {
							if (ch === 60 && this.state.canStartJSXElement) {
								++this.state.pos;
								this.finishToken(143);
							} else super.getTokenFromCode(ch);
							return;
						}
						out += this.input.slice(chunkStart, this.state.pos);
						this.finishToken(142, out);
						return;
					case 38:
						out += this.input.slice(chunkStart, this.state.pos);
						out += this.jsxReadEntity();
						chunkStart = this.state.pos;
						break;
					case 62:
					case 125:
					default: if (isNewLine(ch)) {
						out += this.input.slice(chunkStart, this.state.pos);
						out += this.jsxReadNewLine(true);
						chunkStart = this.state.pos;
					} else ++this.state.pos;
				}
			}
		}
		jsxReadNewLine(normalizeCRLF) {
			const ch = this.input.charCodeAt(this.state.pos);
			let out;
			++this.state.pos;
			if (ch === 13 && this.input.charCodeAt(this.state.pos) === 10) {
				++this.state.pos;
				out = normalizeCRLF ? "\n" : "\r\n";
			} else out = String.fromCharCode(ch);
			++this.state.curLine;
			this.state.lineStart = this.state.pos;
			return out;
		}
		jsxReadString(quote) {
			let out = "";
			let chunkStart = ++this.state.pos;
			for (;;) {
				if (this.state.pos >= this.length) throw this.raise(Errors.UnterminatedString, this.state.startLoc);
				const ch = this.input.charCodeAt(this.state.pos);
				if (ch === quote) break;
				if (ch === 38) {
					out += this.input.slice(chunkStart, this.state.pos);
					out += this.jsxReadEntity();
					chunkStart = this.state.pos;
				} else if (isNewLine(ch)) {
					out += this.input.slice(chunkStart, this.state.pos);
					out += this.jsxReadNewLine(false);
					chunkStart = this.state.pos;
				} else ++this.state.pos;
			}
			out += this.input.slice(chunkStart, this.state.pos++);
			this.finishToken(134, out);
		}
		jsxReadEntity() {
			const startPos = ++this.state.pos;
			if (this.codePointAtPos(this.state.pos) === 35) {
				++this.state.pos;
				let radix = 10;
				if (this.codePointAtPos(this.state.pos) === 120) {
					radix = 16;
					++this.state.pos;
				}
				const codePoint = this.readInt(radix, void 0, false, "bail");
				if (codePoint !== null && this.codePointAtPos(this.state.pos) === 59) {
					++this.state.pos;
					return String.fromCodePoint(codePoint);
				}
			} else {
				let count$1 = 0;
				let semi = false;
				while (count$1++ < 10 && this.state.pos < this.length && !(semi = this.codePointAtPos(this.state.pos) === 59)) ++this.state.pos;
				if (semi) {
					const desc = this.input.slice(startPos, this.state.pos);
					const entity = entities[desc];
					++this.state.pos;
					if (entity) return entity;
				}
			}
			this.state.pos = startPos;
			return "&";
		}
		jsxReadWord() {
			let ch;
			const start = this.state.pos;
			do
				ch = this.input.charCodeAt(++this.state.pos);
			while (isIdentifierChar(ch) || ch === 45);
			this.finishToken(141, this.input.slice(start, this.state.pos));
		}
		jsxParseIdentifier() {
			const node = this.startNode();
			if (this.match(141)) node.name = this.state.value;
			else if (tokenIsKeyword(this.state.type)) node.name = tokenLabelName(this.state.type);
			else this.unexpected();
			this.next();
			return this.finishNode(node, "JSXIdentifier");
		}
		jsxParseNamespacedName() {
			const startLoc = this.state.startLoc;
			const name = this.jsxParseIdentifier();
			if (!this.eat(14)) return name;
			const node = this.startNodeAt(startLoc);
			node.namespace = name;
			node.name = this.jsxParseIdentifier();
			return this.finishNode(node, "JSXNamespacedName");
		}
		jsxParseElementName() {
			const startLoc = this.state.startLoc;
			let node = this.jsxParseNamespacedName();
			if (node.type === "JSXNamespacedName") return node;
			while (this.eat(16)) {
				const newNode = this.startNodeAt(startLoc);
				newNode.object = node;
				newNode.property = this.jsxParseIdentifier();
				node = this.finishNode(newNode, "JSXMemberExpression");
			}
			return node;
		}
		jsxParseAttributeValue() {
			let node;
			switch (this.state.type) {
				case 5:
					node = this.startNode();
					this.setContext(types$1.brace);
					this.next();
					node = this.jsxParseExpressionContainer(node, types$1.j_oTag);
					if (node.expression.type === "JSXEmptyExpression") this.raise(JsxErrors.AttributeIsEmpty, node);
					return node;
				case 143:
				case 134: return this.parseExprAtom();
				default: throw this.raise(JsxErrors.UnsupportedJsxValue, this.state.startLoc);
			}
		}
		jsxParseEmptyExpression() {
			const node = this.startNodeAt(this.state.lastTokEndLoc);
			return this.finishNodeAt(node, "JSXEmptyExpression", this.state.startLoc);
		}
		jsxParseSpreadChild(node) {
			this.next();
			node.expression = this.parseExpression();
			this.setContext(types$1.j_expr);
			this.state.canStartJSXElement = true;
			this.expect(8);
			return this.finishNode(node, "JSXSpreadChild");
		}
		jsxParseExpressionContainer(node, previousContext) {
			if (this.match(8)) node.expression = this.jsxParseEmptyExpression();
			else {
				const expression = this.parseExpression();
				node.expression = expression;
			}
			this.setContext(previousContext);
			this.state.canStartJSXElement = true;
			this.expect(8);
			return this.finishNode(node, "JSXExpressionContainer");
		}
		jsxParseAttribute() {
			const node = this.startNode();
			if (this.match(5)) {
				this.setContext(types$1.brace);
				this.next();
				this.expect(21);
				node.argument = this.parseMaybeAssignAllowIn();
				this.setContext(types$1.j_oTag);
				this.state.canStartJSXElement = true;
				this.expect(8);
				return this.finishNode(node, "JSXSpreadAttribute");
			}
			node.name = this.jsxParseNamespacedName();
			node.value = this.eat(29) ? this.jsxParseAttributeValue() : null;
			return this.finishNode(node, "JSXAttribute");
		}
		jsxParseOpeningElementAt(startLoc) {
			const node = this.startNodeAt(startLoc);
			if (this.eat(144)) return this.finishNode(node, "JSXOpeningFragment");
			node.name = this.jsxParseElementName();
			return this.jsxParseOpeningElementAfterName(node);
		}
		jsxParseOpeningElementAfterName(node) {
			const attributes = [];
			while (!this.match(56) && !this.match(144)) attributes.push(this.jsxParseAttribute());
			node.attributes = attributes;
			node.selfClosing = this.eat(56);
			this.expect(144);
			return this.finishNode(node, "JSXOpeningElement");
		}
		jsxParseClosingElementAt(startLoc) {
			const node = this.startNodeAt(startLoc);
			if (this.eat(144)) return this.finishNode(node, "JSXClosingFragment");
			node.name = this.jsxParseElementName();
			this.expect(144);
			return this.finishNode(node, "JSXClosingElement");
		}
		jsxParseElementAt(startLoc) {
			const node = this.startNodeAt(startLoc);
			const children = [];
			const openingElement = this.jsxParseOpeningElementAt(startLoc);
			let closingElement = null;
			if (!openingElement.selfClosing) {
				contents: for (;;) switch (this.state.type) {
					case 143:
						startLoc = this.state.startLoc;
						this.next();
						if (this.eat(56)) {
							closingElement = this.jsxParseClosingElementAt(startLoc);
							break contents;
						}
						children.push(this.jsxParseElementAt(startLoc));
						break;
					case 142:
						children.push(this.parseLiteral(this.state.value, "JSXText"));
						break;
					case 5: {
						const node$1 = this.startNode();
						this.setContext(types$1.brace);
						this.next();
						if (this.match(21)) children.push(this.jsxParseSpreadChild(node$1));
						else children.push(this.jsxParseExpressionContainer(node$1, types$1.j_expr));
						break;
					}
					default: this.unexpected();
				}
				if (isFragment$1(openingElement) && !isFragment$1(closingElement) && closingElement !== null) this.raise(JsxErrors.MissingClosingTagFragment, closingElement);
				else if (!isFragment$1(openingElement) && isFragment$1(closingElement)) this.raise(JsxErrors.MissingClosingTagElement, closingElement, { openingTagName: getQualifiedJSXName(openingElement.name) });
				else if (!isFragment$1(openingElement) && !isFragment$1(closingElement)) {
					if (getQualifiedJSXName(closingElement.name) !== getQualifiedJSXName(openingElement.name)) this.raise(JsxErrors.MissingClosingTagElement, closingElement, { openingTagName: getQualifiedJSXName(openingElement.name) });
				}
			}
			if (isFragment$1(openingElement)) {
				node.openingFragment = openingElement;
				node.closingFragment = closingElement;
			} else {
				node.openingElement = openingElement;
				node.closingElement = closingElement;
			}
			node.children = children;
			if (this.match(47)) throw this.raise(JsxErrors.UnwrappedAdjacentJSXElements, this.state.startLoc);
			return isFragment$1(openingElement) ? this.finishNode(node, "JSXFragment") : this.finishNode(node, "JSXElement");
		}
		jsxParseElement() {
			const startLoc = this.state.startLoc;
			this.next();
			return this.jsxParseElementAt(startLoc);
		}
		setContext(newContext) {
			const { context } = this.state;
			context[context.length - 1] = newContext;
		}
		parseExprAtom(refExpressionErrors) {
			if (this.match(143)) return this.jsxParseElement();
			else if (this.match(47) && this.input.charCodeAt(this.state.pos) !== 33) {
				this.replaceToken(143);
				return this.jsxParseElement();
			} else return super.parseExprAtom(refExpressionErrors);
		}
		skipSpace() {
			const curContext = this.curContext();
			if (!curContext.preserveSpace) super.skipSpace();
		}
		getTokenFromCode(code$1) {
			const context = this.curContext();
			if (context === types$1.j_expr) {
				this.jsxReadToken();
				return;
			}
			if (context === types$1.j_oTag || context === types$1.j_cTag) {
				if (isIdentifierStart(code$1)) {
					this.jsxReadWord();
					return;
				}
				if (code$1 === 62) {
					++this.state.pos;
					this.finishToken(144);
					return;
				}
				if ((code$1 === 34 || code$1 === 39) && context === types$1.j_oTag) {
					this.jsxReadString(code$1);
					return;
				}
			}
			if (code$1 === 60 && this.state.canStartJSXElement && this.input.charCodeAt(this.state.pos + 1) !== 33) {
				++this.state.pos;
				this.finishToken(143);
				return;
			}
			super.getTokenFromCode(code$1);
		}
		updateContext(prevType) {
			const { context, type } = this.state;
			if (type === 56 && prevType === 143) {
				context.splice(-2, 2, types$1.j_cTag);
				this.state.canStartJSXElement = false;
			} else if (type === 143) context.push(types$1.j_oTag);
			else if (type === 144) {
				const out = context[context.length - 1];
				if (out === types$1.j_oTag && prevType === 56 || out === types$1.j_cTag) {
					context.pop();
					this.state.canStartJSXElement = context[context.length - 1] === types$1.j_expr;
				} else {
					this.setContext(types$1.j_expr);
					this.state.canStartJSXElement = true;
				}
			} else this.state.canStartJSXElement = tokenComesBeforeExpression(type);
		}
	};
	var TypeScriptScope = class extends Scope {
		constructor(...args) {
			super(...args);
			this.tsNames = /* @__PURE__ */ new Map();
		}
	};
	var TypeScriptScopeHandler = class extends ScopeHandler {
		constructor(...args) {
			super(...args);
			this.importsStack = [];
		}
		createScope(flags) {
			this.importsStack.push(/* @__PURE__ */ new Set());
			return new TypeScriptScope(flags);
		}
		enter(flags) {
			if (flags === 1024) this.importsStack.push(/* @__PURE__ */ new Set());
			super.enter(flags);
		}
		exit() {
			const flags = super.exit();
			if (flags === 1024) this.importsStack.pop();
			return flags;
		}
		hasImport(name, allowShadow) {
			const len$1 = this.importsStack.length;
			if (this.importsStack[len$1 - 1].has(name)) return true;
			if (!allowShadow && len$1 > 1) {
				for (let i = 0; i < len$1 - 1; i++) if (this.importsStack[i].has(name)) return true;
			}
			return false;
		}
		declareName(name, bindingType, loc) {
			if (bindingType & 4096) {
				if (this.hasImport(name, true)) this.parser.raise(Errors.VarRedeclaration, loc, { identifierName: name });
				this.importsStack[this.importsStack.length - 1].add(name);
				return;
			}
			const scope = this.currentScope();
			let type = scope.tsNames.get(name) || 0;
			if (bindingType & 1024) {
				this.maybeExportDefined(scope, name);
				scope.tsNames.set(name, type | 16);
				return;
			}
			super.declareName(name, bindingType, loc);
			if (bindingType & 2) {
				if (!(bindingType & 1)) {
					this.checkRedeclarationInScope(scope, name, bindingType, loc);
					this.maybeExportDefined(scope, name);
				}
				type = type | 1;
			}
			if (bindingType & 256) type = type | 2;
			if (bindingType & 512) type = type | 4;
			if (bindingType & 128) type = type | 8;
			if (type) scope.tsNames.set(name, type);
		}
		isRedeclaredInScope(scope, name, bindingType) {
			const type = scope.tsNames.get(name);
			if ((type & 2) > 0) {
				if (bindingType & 256) {
					const isConst$1 = !!(bindingType & 512);
					const wasConst = (type & 4) > 0;
					return isConst$1 !== wasConst;
				}
				return true;
			}
			if (bindingType & 128 && (type & 8) > 0) if (scope.names.get(name) & 2) return !!(bindingType & 1);
			else return false;
			if (bindingType & 2 && (type & 1) > 0) return true;
			return super.isRedeclaredInScope(scope, name, bindingType);
		}
		checkLocalExport(id) {
			const { name } = id;
			if (this.hasImport(name)) return;
			const len$1 = this.scopeStack.length;
			for (let i = len$1 - 1; i >= 0; i--) {
				const scope = this.scopeStack[i];
				const type = scope.tsNames.get(name);
				if ((type & 1) > 0 || (type & 16) > 0) return;
			}
			super.checkLocalExport(id);
		}
	};
	var ProductionParameterHandler = class {
		constructor() {
			this.stacks = [];
		}
		enter(flags) {
			this.stacks.push(flags);
		}
		exit() {
			this.stacks.pop();
		}
		currentFlags() {
			return this.stacks[this.stacks.length - 1];
		}
		get hasAwait() {
			return (this.currentFlags() & 2) > 0;
		}
		get hasYield() {
			return (this.currentFlags() & 1) > 0;
		}
		get hasReturn() {
			return (this.currentFlags() & 4) > 0;
		}
		get hasIn() {
			return (this.currentFlags() & 8) > 0;
		}
	};
	function functionFlags(isAsync, isGenerator) {
		return (isAsync ? 2 : 0) | (isGenerator ? 1 : 0);
	}
	var BaseParser = class {
		constructor() {
			this.sawUnambiguousESM = false;
			this.ambiguousScriptDifferentAst = false;
		}
		sourceToOffsetPos(sourcePos) {
			return sourcePos + this.startIndex;
		}
		offsetToSourcePos(offsetPos) {
			return offsetPos - this.startIndex;
		}
		hasPlugin(pluginConfig) {
			if (typeof pluginConfig === "string") return this.plugins.has(pluginConfig);
			else {
				const [pluginName, pluginOptions] = pluginConfig;
				if (!this.hasPlugin(pluginName)) return false;
				const actualOptions = this.plugins.get(pluginName);
				for (const key of Object.keys(pluginOptions)) if ((actualOptions == null ? void 0 : actualOptions[key]) !== pluginOptions[key]) return false;
				return true;
			}
		}
		getPluginOption(plugin$13, name) {
			var _this$plugins$get;
			return (_this$plugins$get = this.plugins.get(plugin$13)) == null ? void 0 : _this$plugins$get[name];
		}
	};
	function setTrailingComments(node, comments) {
		if (node.trailingComments === void 0) node.trailingComments = comments;
		else node.trailingComments.unshift(...comments);
	}
	function setLeadingComments(node, comments) {
		if (node.leadingComments === void 0) node.leadingComments = comments;
		else node.leadingComments.unshift(...comments);
	}
	function setInnerComments(node, comments) {
		if (node.innerComments === void 0) node.innerComments = comments;
		else node.innerComments.unshift(...comments);
	}
	function adjustInnerComments(node, elements, commentWS) {
		let lastElement = null;
		let i = elements.length;
		while (lastElement === null && i > 0) lastElement = elements[--i];
		if (lastElement === null || lastElement.start > commentWS.start) setInnerComments(node, commentWS.comments);
		else setTrailingComments(lastElement, commentWS.comments);
	}
	var CommentsParser = class extends BaseParser {
		addComment(comment$1) {
			if (this.filename) comment$1.loc.filename = this.filename;
			const { commentsLen } = this.state;
			if (this.comments.length !== commentsLen) this.comments.length = commentsLen;
			this.comments.push(comment$1);
			this.state.commentsLen++;
		}
		processComment(node) {
			const { commentStack } = this.state;
			const commentStackLength = commentStack.length;
			if (commentStackLength === 0) return;
			let i = commentStackLength - 1;
			const lastCommentWS = commentStack[i];
			if (lastCommentWS.start === node.end) {
				lastCommentWS.leadingNode = node;
				i--;
			}
			const { start: nodeStart } = node;
			for (; i >= 0; i--) {
				const commentWS = commentStack[i];
				const commentEnd = commentWS.end;
				if (commentEnd > nodeStart) {
					commentWS.containingNode = node;
					this.finalizeComment(commentWS);
					commentStack.splice(i, 1);
				} else {
					if (commentEnd === nodeStart) commentWS.trailingNode = node;
					break;
				}
			}
		}
		finalizeComment(commentWS) {
			var _node$options;
			const { comments } = commentWS;
			if (commentWS.leadingNode !== null || commentWS.trailingNode !== null) {
				if (commentWS.leadingNode !== null) setTrailingComments(commentWS.leadingNode, comments);
				if (commentWS.trailingNode !== null) setLeadingComments(commentWS.trailingNode, comments);
			} else {
				const { containingNode: node, start: commentStart } = commentWS;
				if (this.input.charCodeAt(this.offsetToSourcePos(commentStart) - 1) === 44) switch (node.type) {
					case "ObjectExpression":
					case "ObjectPattern":
					case "RecordExpression":
						adjustInnerComments(node, node.properties, commentWS);
						break;
					case "CallExpression":
					case "OptionalCallExpression":
						adjustInnerComments(node, node.arguments, commentWS);
						break;
					case "ImportExpression":
						adjustInnerComments(node, [node.source, (_node$options = node.options) != null ? _node$options : null], commentWS);
						break;
					case "FunctionDeclaration":
					case "FunctionExpression":
					case "ArrowFunctionExpression":
					case "ObjectMethod":
					case "ClassMethod":
					case "ClassPrivateMethod":
						adjustInnerComments(node, node.params, commentWS);
						break;
					case "ArrayExpression":
					case "ArrayPattern":
					case "TupleExpression":
						adjustInnerComments(node, node.elements, commentWS);
						break;
					case "ExportNamedDeclaration":
					case "ImportDeclaration":
						adjustInnerComments(node, node.specifiers, commentWS);
						break;
					case "TSEnumDeclaration":
						adjustInnerComments(node, node.members, commentWS);
						break;
					case "TSEnumBody":
						adjustInnerComments(node, node.members, commentWS);
						break;
					default: setInnerComments(node, comments);
				}
				else setInnerComments(node, comments);
			}
		}
		finalizeRemainingComments() {
			const { commentStack } = this.state;
			for (let i = commentStack.length - 1; i >= 0; i--) this.finalizeComment(commentStack[i]);
			this.state.commentStack = [];
		}
		resetPreviousNodeTrailingComments(node) {
			const { commentStack } = this.state;
			const { length } = commentStack;
			if (length === 0) return;
			const commentWS = commentStack[length - 1];
			if (commentWS.leadingNode === node) commentWS.leadingNode = null;
		}
		takeSurroundingComments(node, start, end) {
			const { commentStack } = this.state;
			const commentStackLength = commentStack.length;
			if (commentStackLength === 0) return;
			let i = commentStackLength - 1;
			for (; i >= 0; i--) {
				const commentWS = commentStack[i];
				const commentEnd = commentWS.end;
				const commentStart = commentWS.start;
				if (commentStart === end) commentWS.leadingNode = node;
				else if (commentEnd === start) commentWS.trailingNode = node;
				else if (commentEnd < start) break;
			}
		}
	};
	var State = class State {
		constructor() {
			this.flags = 1024;
			this.startIndex = void 0;
			this.curLine = void 0;
			this.lineStart = void 0;
			this.startLoc = void 0;
			this.endLoc = void 0;
			this.errors = [];
			this.potentialArrowAt = -1;
			this.noArrowAt = [];
			this.noArrowParamsConversionAt = [];
			this.topicContext = {
				maxNumOfResolvableTopics: 0,
				maxTopicIndex: null
			};
			this.labels = [];
			this.commentsLen = 0;
			this.commentStack = [];
			this.pos = 0;
			this.type = 140;
			this.value = null;
			this.start = 0;
			this.end = 0;
			this.lastTokEndLoc = null;
			this.lastTokStartLoc = null;
			this.context = [types$1.brace];
			this.firstInvalidTemplateEscapePos = null;
			this.strictErrors = /* @__PURE__ */ new Map();
			this.tokensLength = 0;
		}
		get strict() {
			return (this.flags & 1) > 0;
		}
		set strict(v) {
			if (v) this.flags |= 1;
			else this.flags &= -2;
		}
		init({ strictMode, sourceType, startIndex, startLine, startColumn }) {
			this.strict = strictMode === false ? false : strictMode === true ? true : sourceType === "module";
			this.startIndex = startIndex;
			this.curLine = startLine;
			this.lineStart = -startColumn;
			this.startLoc = this.endLoc = new Position(startLine, startColumn, startIndex);
		}
		get maybeInArrowParameters() {
			return (this.flags & 2) > 0;
		}
		set maybeInArrowParameters(v) {
			if (v) this.flags |= 2;
			else this.flags &= -3;
		}
		get inType() {
			return (this.flags & 4) > 0;
		}
		set inType(v) {
			if (v) this.flags |= 4;
			else this.flags &= -5;
		}
		get noAnonFunctionType() {
			return (this.flags & 8) > 0;
		}
		set noAnonFunctionType(v) {
			if (v) this.flags |= 8;
			else this.flags &= -9;
		}
		get hasFlowComment() {
			return (this.flags & 16) > 0;
		}
		set hasFlowComment(v) {
			if (v) this.flags |= 16;
			else this.flags &= -17;
		}
		get isAmbientContext() {
			return (this.flags & 32) > 0;
		}
		set isAmbientContext(v) {
			if (v) this.flags |= 32;
			else this.flags &= -33;
		}
		get inAbstractClass() {
			return (this.flags & 64) > 0;
		}
		set inAbstractClass(v) {
			if (v) this.flags |= 64;
			else this.flags &= -65;
		}
		get inDisallowConditionalTypesContext() {
			return (this.flags & 128) > 0;
		}
		set inDisallowConditionalTypesContext(v) {
			if (v) this.flags |= 128;
			else this.flags &= -129;
		}
		get soloAwait() {
			return (this.flags & 256) > 0;
		}
		set soloAwait(v) {
			if (v) this.flags |= 256;
			else this.flags &= -257;
		}
		get inFSharpPipelineDirectBody() {
			return (this.flags & 512) > 0;
		}
		set inFSharpPipelineDirectBody(v) {
			if (v) this.flags |= 512;
			else this.flags &= -513;
		}
		get canStartJSXElement() {
			return (this.flags & 1024) > 0;
		}
		set canStartJSXElement(v) {
			if (v) this.flags |= 1024;
			else this.flags &= -1025;
		}
		get containsEsc() {
			return (this.flags & 2048) > 0;
		}
		set containsEsc(v) {
			if (v) this.flags |= 2048;
			else this.flags &= -2049;
		}
		get hasTopLevelAwait() {
			return (this.flags & 4096) > 0;
		}
		set hasTopLevelAwait(v) {
			if (v) this.flags |= 4096;
			else this.flags &= -4097;
		}
		curPosition() {
			return new Position(this.curLine, this.pos - this.lineStart, this.pos + this.startIndex);
		}
		clone() {
			const state = new State();
			state.flags = this.flags;
			state.startIndex = this.startIndex;
			state.curLine = this.curLine;
			state.lineStart = this.lineStart;
			state.startLoc = this.startLoc;
			state.endLoc = this.endLoc;
			state.errors = this.errors.slice();
			state.potentialArrowAt = this.potentialArrowAt;
			state.noArrowAt = this.noArrowAt.slice();
			state.noArrowParamsConversionAt = this.noArrowParamsConversionAt.slice();
			state.topicContext = this.topicContext;
			state.labels = this.labels.slice();
			state.commentsLen = this.commentsLen;
			state.commentStack = this.commentStack.slice();
			state.pos = this.pos;
			state.type = this.type;
			state.value = this.value;
			state.start = this.start;
			state.end = this.end;
			state.lastTokEndLoc = this.lastTokEndLoc;
			state.lastTokStartLoc = this.lastTokStartLoc;
			state.context = this.context.slice();
			state.firstInvalidTemplateEscapePos = this.firstInvalidTemplateEscapePos;
			state.strictErrors = this.strictErrors;
			state.tokensLength = this.tokensLength;
			return state;
		}
	};
	var _isDigit = function isDigit(code$1) {
		return code$1 >= 48 && code$1 <= 57;
	};
	const forbiddenNumericSeparatorSiblings = {
		decBinOct: new Set([
			46,
			66,
			69,
			79,
			95,
			98,
			101,
			111
		]),
		hex: new Set([
			46,
			88,
			95,
			120
		])
	};
	const isAllowedNumericSeparatorSibling = {
		bin: (ch) => ch === 48 || ch === 49,
		oct: (ch) => ch >= 48 && ch <= 55,
		dec: (ch) => ch >= 48 && ch <= 57,
		hex: (ch) => ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102
	};
	function readStringContents(type, input, pos, lineStart, curLine, errors) {
		const initialPos = pos;
		const initialLineStart = lineStart;
		const initialCurLine = curLine;
		let out = "";
		let firstInvalidLoc = null;
		let chunkStart = pos;
		const { length } = input;
		for (;;) {
			if (pos >= length) {
				errors.unterminated(initialPos, initialLineStart, initialCurLine);
				out += input.slice(chunkStart, pos);
				break;
			}
			const ch = input.charCodeAt(pos);
			if (isStringEnd(type, ch, input, pos)) {
				out += input.slice(chunkStart, pos);
				break;
			}
			if (ch === 92) {
				out += input.slice(chunkStart, pos);
				const res = readEscapedChar(input, pos, lineStart, curLine, type === "template", errors);
				if (res.ch === null && !firstInvalidLoc) firstInvalidLoc = {
					pos,
					lineStart,
					curLine
				};
				else out += res.ch;
				({pos, lineStart, curLine} = res);
				chunkStart = pos;
			} else if (ch === 8232 || ch === 8233) {
				++pos;
				++curLine;
				lineStart = pos;
			} else if (ch === 10 || ch === 13) if (type === "template") {
				out += input.slice(chunkStart, pos) + "\n";
				++pos;
				if (ch === 13 && input.charCodeAt(pos) === 10) ++pos;
				++curLine;
				chunkStart = lineStart = pos;
			} else errors.unterminated(initialPos, initialLineStart, initialCurLine);
			else ++pos;
		}
		return {
			pos,
			str: out,
			firstInvalidLoc,
			lineStart,
			curLine,
			containsInvalid: !!firstInvalidLoc
		};
	}
	function isStringEnd(type, ch, input, pos) {
		if (type === "template") return ch === 96 || ch === 36 && input.charCodeAt(pos + 1) === 123;
		return ch === (type === "double" ? 34 : 39);
	}
	function readEscapedChar(input, pos, lineStart, curLine, inTemplate, errors) {
		const throwOnInvalid = !inTemplate;
		pos++;
		const res = (ch$1) => ({
			pos,
			ch: ch$1,
			lineStart,
			curLine
		});
		const ch = input.charCodeAt(pos++);
		switch (ch) {
			case 110: return res("\n");
			case 114: return res("\r");
			case 120: {
				let code$1;
				({code: code$1, pos} = readHexChar(input, pos, lineStart, curLine, 2, false, throwOnInvalid, errors));
				return res(code$1 === null ? null : String.fromCharCode(code$1));
			}
			case 117: {
				let code$1;
				({code: code$1, pos} = readCodePoint(input, pos, lineStart, curLine, throwOnInvalid, errors));
				return res(code$1 === null ? null : String.fromCodePoint(code$1));
			}
			case 116: return res("	");
			case 98: return res("\b");
			case 118: return res("\v");
			case 102: return res("\f");
			case 13: if (input.charCodeAt(pos) === 10) ++pos;
			case 10:
				lineStart = pos;
				++curLine;
			case 8232:
			case 8233: return res("");
			case 56:
			case 57: if (inTemplate) return res(null);
			else errors.strictNumericEscape(pos - 1, lineStart, curLine);
			default:
				if (ch >= 48 && ch <= 55) {
					const startPos = pos - 1;
					const match$1 = /^[0-7]+/.exec(input.slice(startPos, pos + 2));
					let octalStr = match$1[0];
					let octal = parseInt(octalStr, 8);
					if (octal > 255) {
						octalStr = octalStr.slice(0, -1);
						octal = parseInt(octalStr, 8);
					}
					pos += octalStr.length - 1;
					const next$1 = input.charCodeAt(pos);
					if (octalStr !== "0" || next$1 === 56 || next$1 === 57) if (inTemplate) return res(null);
					else errors.strictNumericEscape(startPos, lineStart, curLine);
					return res(String.fromCharCode(octal));
				}
				return res(String.fromCharCode(ch));
		}
	}
	function readHexChar(input, pos, lineStart, curLine, len$1, forceLen, throwOnInvalid, errors) {
		const initialPos = pos;
		let n;
		({n, pos} = readInt(input, pos, lineStart, curLine, 16, len$1, forceLen, false, errors, !throwOnInvalid));
		if (n === null) if (throwOnInvalid) errors.invalidEscapeSequence(initialPos, lineStart, curLine);
		else pos = initialPos - 1;
		return {
			code: n,
			pos
		};
	}
	function readInt(input, pos, lineStart, curLine, radix, len$1, forceLen, allowNumSeparator, errors, bailOnError) {
		const start = pos;
		const forbiddenSiblings = radix === 16 ? forbiddenNumericSeparatorSiblings.hex : forbiddenNumericSeparatorSiblings.decBinOct;
		const isAllowedSibling = radix === 16 ? isAllowedNumericSeparatorSibling.hex : radix === 10 ? isAllowedNumericSeparatorSibling.dec : radix === 8 ? isAllowedNumericSeparatorSibling.oct : isAllowedNumericSeparatorSibling.bin;
		let invalid = false;
		let total = 0;
		for (let i = 0, e = len$1 == null ? Infinity : len$1; i < e; ++i) {
			const code$1 = input.charCodeAt(pos);
			let val;
			if (code$1 === 95 && allowNumSeparator !== "bail") {
				const prev = input.charCodeAt(pos - 1);
				const next$1 = input.charCodeAt(pos + 1);
				if (!allowNumSeparator) {
					if (bailOnError) return {
						n: null,
						pos
					};
					errors.numericSeparatorInEscapeSequence(pos, lineStart, curLine);
				} else if (Number.isNaN(next$1) || !isAllowedSibling(next$1) || forbiddenSiblings.has(prev) || forbiddenSiblings.has(next$1)) {
					if (bailOnError) return {
						n: null,
						pos
					};
					errors.unexpectedNumericSeparator(pos, lineStart, curLine);
				}
				++pos;
				continue;
			}
			if (code$1 >= 97) val = code$1 - 97 + 10;
			else if (code$1 >= 65) val = code$1 - 65 + 10;
			else if (_isDigit(code$1)) val = code$1 - 48;
			else val = Infinity;
			if (val >= radix) if (val <= 9 && bailOnError) return {
				n: null,
				pos
			};
			else if (val <= 9 && errors.invalidDigit(pos, lineStart, curLine, radix)) val = 0;
			else if (forceLen) {
				val = 0;
				invalid = true;
			} else break;
			++pos;
			total = total * radix + val;
		}
		if (pos === start || len$1 != null && pos - start !== len$1 || invalid) return {
			n: null,
			pos
		};
		return {
			n: total,
			pos
		};
	}
	function readCodePoint(input, pos, lineStart, curLine, throwOnInvalid, errors) {
		const ch = input.charCodeAt(pos);
		let code$1;
		if (ch === 123) {
			++pos;
			({code: code$1, pos} = readHexChar(input, pos, lineStart, curLine, input.indexOf("}", pos) - pos, true, throwOnInvalid, errors));
			++pos;
			if (code$1 !== null && code$1 > 1114111) if (throwOnInvalid) errors.invalidCodePoint(pos, lineStart, curLine);
			else return {
				code: null,
				pos
			};
		} else ({code: code$1, pos} = readHexChar(input, pos, lineStart, curLine, 4, false, throwOnInvalid, errors));
		return {
			code: code$1,
			pos
		};
	}
	function buildPosition(pos, lineStart, curLine) {
		return new Position(curLine, pos - lineStart, pos);
	}
	const VALID_REGEX_FLAGS = new Set([
		103,
		109,
		115,
		105,
		121,
		117,
		100,
		118
	]);
	var Token = class {
		constructor(state) {
			const startIndex = state.startIndex || 0;
			this.type = state.type;
			this.value = state.value;
			this.start = startIndex + state.start;
			this.end = startIndex + state.end;
			this.loc = new SourceLocation(state.startLoc, state.endLoc);
		}
	};
	var Tokenizer$1 = class extends CommentsParser {
		constructor(options, input) {
			super();
			this.isLookahead = void 0;
			this.tokens = [];
			this.errorHandlers_readInt = {
				invalidDigit: (pos, lineStart, curLine, radix) => {
					if (!(this.optionFlags & 2048)) return false;
					this.raise(Errors.InvalidDigit, buildPosition(pos, lineStart, curLine), { radix });
					return true;
				},
				numericSeparatorInEscapeSequence: this.errorBuilder(Errors.NumericSeparatorInEscapeSequence),
				unexpectedNumericSeparator: this.errorBuilder(Errors.UnexpectedNumericSeparator)
			};
			this.errorHandlers_readCodePoint = Object.assign({}, this.errorHandlers_readInt, {
				invalidEscapeSequence: this.errorBuilder(Errors.InvalidEscapeSequence),
				invalidCodePoint: this.errorBuilder(Errors.InvalidCodePoint)
			});
			this.errorHandlers_readStringContents_string = Object.assign({}, this.errorHandlers_readCodePoint, {
				strictNumericEscape: (pos, lineStart, curLine) => {
					this.recordStrictModeErrors(Errors.StrictNumericEscape, buildPosition(pos, lineStart, curLine));
				},
				unterminated: (pos, lineStart, curLine) => {
					throw this.raise(Errors.UnterminatedString, buildPosition(pos - 1, lineStart, curLine));
				}
			});
			this.errorHandlers_readStringContents_template = Object.assign({}, this.errorHandlers_readCodePoint, {
				strictNumericEscape: this.errorBuilder(Errors.StrictNumericEscape),
				unterminated: (pos, lineStart, curLine) => {
					throw this.raise(Errors.UnterminatedTemplate, buildPosition(pos, lineStart, curLine));
				}
			});
			this.state = new State();
			this.state.init(options);
			this.input = input;
			this.length = input.length;
			this.comments = [];
			this.isLookahead = false;
		}
		pushToken(token) {
			this.tokens.length = this.state.tokensLength;
			this.tokens.push(token);
			++this.state.tokensLength;
		}
		next() {
			this.checkKeywordEscapes();
			if (this.optionFlags & 256) this.pushToken(new Token(this.state));
			this.state.lastTokEndLoc = this.state.endLoc;
			this.state.lastTokStartLoc = this.state.startLoc;
			this.nextToken();
		}
		eat(type) {
			if (this.match(type)) {
				this.next();
				return true;
			} else return false;
		}
		match(type) {
			return this.state.type === type;
		}
		createLookaheadState(state) {
			return {
				pos: state.pos,
				value: null,
				type: state.type,
				start: state.start,
				end: state.end,
				context: [this.curContext()],
				inType: state.inType,
				startLoc: state.startLoc,
				lastTokEndLoc: state.lastTokEndLoc,
				curLine: state.curLine,
				lineStart: state.lineStart,
				curPosition: state.curPosition
			};
		}
		lookahead() {
			const old = this.state;
			this.state = this.createLookaheadState(old);
			this.isLookahead = true;
			this.nextToken();
			this.isLookahead = false;
			const curr = this.state;
			this.state = old;
			return curr;
		}
		nextTokenStart() {
			return this.nextTokenStartSince(this.state.pos);
		}
		nextTokenStartSince(pos) {
			skipWhiteSpace.lastIndex = pos;
			return skipWhiteSpace.test(this.input) ? skipWhiteSpace.lastIndex : pos;
		}
		lookaheadCharCode() {
			return this.lookaheadCharCodeSince(this.state.pos);
		}
		lookaheadCharCodeSince(pos) {
			return this.input.charCodeAt(this.nextTokenStartSince(pos));
		}
		nextTokenInLineStart() {
			return this.nextTokenInLineStartSince(this.state.pos);
		}
		nextTokenInLineStartSince(pos) {
			skipWhiteSpaceInLine.lastIndex = pos;
			return skipWhiteSpaceInLine.test(this.input) ? skipWhiteSpaceInLine.lastIndex : pos;
		}
		lookaheadInLineCharCode() {
			return this.input.charCodeAt(this.nextTokenInLineStart());
		}
		codePointAtPos(pos) {
			let cp = this.input.charCodeAt(pos);
			if ((cp & 64512) === 55296 && ++pos < this.input.length) {
				const trail = this.input.charCodeAt(pos);
				if ((trail & 64512) === 56320) cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
			}
			return cp;
		}
		setStrict(strict) {
			this.state.strict = strict;
			if (strict) {
				this.state.strictErrors.forEach(([toParseError, at]) => this.raise(toParseError, at));
				this.state.strictErrors.clear();
			}
		}
		curContext() {
			return this.state.context[this.state.context.length - 1];
		}
		nextToken() {
			this.skipSpace();
			this.state.start = this.state.pos;
			if (!this.isLookahead) this.state.startLoc = this.state.curPosition();
			if (this.state.pos >= this.length) {
				this.finishToken(140);
				return;
			}
			this.getTokenFromCode(this.codePointAtPos(this.state.pos));
		}
		skipBlockComment(commentEnd) {
			let startLoc;
			if (!this.isLookahead) startLoc = this.state.curPosition();
			const start = this.state.pos;
			const end = this.input.indexOf(commentEnd, start + 2);
			if (end === -1) throw this.raise(Errors.UnterminatedComment, this.state.curPosition());
			this.state.pos = end + commentEnd.length;
			lineBreakG.lastIndex = start + 2;
			while (lineBreakG.test(this.input) && lineBreakG.lastIndex <= end) {
				++this.state.curLine;
				this.state.lineStart = lineBreakG.lastIndex;
			}
			if (this.isLookahead) return;
			const comment$1 = {
				type: "CommentBlock",
				value: this.input.slice(start + 2, end),
				start: this.sourceToOffsetPos(start),
				end: this.sourceToOffsetPos(end + commentEnd.length),
				loc: new SourceLocation(startLoc, this.state.curPosition())
			};
			if (this.optionFlags & 256) this.pushToken(comment$1);
			return comment$1;
		}
		skipLineComment(startSkip) {
			const start = this.state.pos;
			let startLoc;
			if (!this.isLookahead) startLoc = this.state.curPosition();
			let ch = this.input.charCodeAt(this.state.pos += startSkip);
			if (this.state.pos < this.length) while (!isNewLine(ch) && ++this.state.pos < this.length) ch = this.input.charCodeAt(this.state.pos);
			if (this.isLookahead) return;
			const end = this.state.pos;
			const value = this.input.slice(start + startSkip, end);
			const comment$1 = {
				type: "CommentLine",
				value,
				start: this.sourceToOffsetPos(start),
				end: this.sourceToOffsetPos(end),
				loc: new SourceLocation(startLoc, this.state.curPosition())
			};
			if (this.optionFlags & 256) this.pushToken(comment$1);
			return comment$1;
		}
		skipSpace() {
			const spaceStart = this.state.pos;
			const comments = this.optionFlags & 4096 ? [] : null;
			loop: while (this.state.pos < this.length) {
				const ch = this.input.charCodeAt(this.state.pos);
				switch (ch) {
					case 32:
					case 160:
					case 9:
						++this.state.pos;
						break;
					case 13: if (this.input.charCodeAt(this.state.pos + 1) === 10) ++this.state.pos;
					case 10:
					case 8232:
					case 8233:
						++this.state.pos;
						++this.state.curLine;
						this.state.lineStart = this.state.pos;
						break;
					case 47:
						switch (this.input.charCodeAt(this.state.pos + 1)) {
							case 42: {
								const comment$1 = this.skipBlockComment("*/");
								if (comment$1 !== void 0) {
									this.addComment(comment$1);
									comments?.push(comment$1);
								}
								break;
							}
							case 47: {
								const comment$1 = this.skipLineComment(2);
								if (comment$1 !== void 0) {
									this.addComment(comment$1);
									comments?.push(comment$1);
								}
								break;
							}
							default: break loop;
						}
						break;
					default: if (isWhitespace$2(ch)) ++this.state.pos;
					else if (ch === 45 && !this.inModule && this.optionFlags & 8192) {
						const pos = this.state.pos;
						if (this.input.charCodeAt(pos + 1) === 45 && this.input.charCodeAt(pos + 2) === 62 && (spaceStart === 0 || this.state.lineStart > spaceStart)) {
							const comment$1 = this.skipLineComment(3);
							if (comment$1 !== void 0) {
								this.addComment(comment$1);
								comments?.push(comment$1);
							}
						} else break loop;
					} else if (ch === 60 && !this.inModule && this.optionFlags & 8192) {
						const pos = this.state.pos;
						if (this.input.charCodeAt(pos + 1) === 33 && this.input.charCodeAt(pos + 2) === 45 && this.input.charCodeAt(pos + 3) === 45) {
							const comment$1 = this.skipLineComment(4);
							if (comment$1 !== void 0) {
								this.addComment(comment$1);
								comments?.push(comment$1);
							}
						} else break loop;
					} else break loop;
				}
			}
			if ((comments == null ? void 0 : comments.length) > 0) {
				const end = this.state.pos;
				const commentWhitespace = {
					start: this.sourceToOffsetPos(spaceStart),
					end: this.sourceToOffsetPos(end),
					comments,
					leadingNode: null,
					trailingNode: null,
					containingNode: null
				};
				this.state.commentStack.push(commentWhitespace);
			}
		}
		finishToken(type, val) {
			this.state.end = this.state.pos;
			this.state.endLoc = this.state.curPosition();
			const prevType = this.state.type;
			this.state.type = type;
			this.state.value = val;
			if (!this.isLookahead) this.updateContext(prevType);
		}
		replaceToken(type) {
			this.state.type = type;
			this.updateContext();
		}
		readToken_numberSign() {
			if (this.state.pos === 0 && this.readToken_interpreter()) return;
			const nextPos = this.state.pos + 1;
			const next$1 = this.codePointAtPos(nextPos);
			if (next$1 >= 48 && next$1 <= 57) throw this.raise(Errors.UnexpectedDigitAfterHash, this.state.curPosition());
			if (next$1 === 123 || next$1 === 91 && this.hasPlugin("recordAndTuple")) {
				this.expectPlugin("recordAndTuple");
				if (this.getPluginOption("recordAndTuple", "syntaxType") === "bar") throw this.raise(next$1 === 123 ? Errors.RecordExpressionHashIncorrectStartSyntaxType : Errors.TupleExpressionHashIncorrectStartSyntaxType, this.state.curPosition());
				this.state.pos += 2;
				if (next$1 === 123) this.finishToken(7);
				else this.finishToken(1);
			} else if (isIdentifierStart(next$1)) {
				++this.state.pos;
				this.finishToken(139, this.readWord1(next$1));
			} else if (next$1 === 92) {
				++this.state.pos;
				this.finishToken(139, this.readWord1());
			} else this.finishOp(27, 1);
		}
		readToken_dot() {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 >= 48 && next$1 <= 57) {
				this.readNumber(true);
				return;
			}
			if (next$1 === 46 && this.input.charCodeAt(this.state.pos + 2) === 46) {
				this.state.pos += 3;
				this.finishToken(21);
			} else {
				++this.state.pos;
				this.finishToken(16);
			}
		}
		readToken_slash() {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === 61) this.finishOp(31, 2);
			else this.finishOp(56, 1);
		}
		readToken_interpreter() {
			if (this.state.pos !== 0 || this.length < 2) return false;
			let ch = this.input.charCodeAt(this.state.pos + 1);
			if (ch !== 33) return false;
			const start = this.state.pos;
			this.state.pos += 1;
			while (!isNewLine(ch) && ++this.state.pos < this.length) ch = this.input.charCodeAt(this.state.pos);
			const value = this.input.slice(start + 2, this.state.pos);
			this.finishToken(28, value);
			return true;
		}
		readToken_mult_modulo(code$1) {
			let type = code$1 === 42 ? 55 : 54;
			let width = 1;
			let next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (code$1 === 42 && next$1 === 42) {
				width++;
				next$1 = this.input.charCodeAt(this.state.pos + 2);
				type = 57;
			}
			if (next$1 === 61 && !this.state.inType) {
				width++;
				type = code$1 === 37 ? 33 : 30;
			}
			this.finishOp(type, width);
		}
		readToken_pipe_amp(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === code$1) {
				if (this.input.charCodeAt(this.state.pos + 2) === 61) this.finishOp(30, 3);
				else this.finishOp(code$1 === 124 ? 41 : 42, 2);
				return;
			}
			if (code$1 === 124) {
				if (next$1 === 62) {
					this.finishOp(39, 2);
					return;
				}
				if (this.hasPlugin("recordAndTuple") && next$1 === 125) {
					if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") throw this.raise(Errors.RecordExpressionBarIncorrectEndSyntaxType, this.state.curPosition());
					this.state.pos += 2;
					this.finishToken(9);
					return;
				}
				if (this.hasPlugin("recordAndTuple") && next$1 === 93) {
					if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") throw this.raise(Errors.TupleExpressionBarIncorrectEndSyntaxType, this.state.curPosition());
					this.state.pos += 2;
					this.finishToken(4);
					return;
				}
			}
			if (next$1 === 61) {
				this.finishOp(30, 2);
				return;
			}
			this.finishOp(code$1 === 124 ? 43 : 45, 1);
		}
		readToken_caret() {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === 61 && !this.state.inType) this.finishOp(32, 2);
			else if (next$1 === 94 && this.hasPlugin(["pipelineOperator", {
				proposal: "hack",
				topicToken: "^^"
			}])) {
				this.finishOp(37, 2);
				const lookaheadCh = this.input.codePointAt(this.state.pos);
				if (lookaheadCh === 94) this.unexpected();
			} else this.finishOp(44, 1);
		}
		readToken_atSign() {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === 64 && this.hasPlugin(["pipelineOperator", {
				proposal: "hack",
				topicToken: "@@"
			}])) this.finishOp(38, 2);
			else this.finishOp(26, 1);
		}
		readToken_plus_min(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === code$1) {
				this.finishOp(34, 2);
				return;
			}
			if (next$1 === 61) this.finishOp(30, 2);
			else this.finishOp(53, 1);
		}
		readToken_lt() {
			const { pos } = this.state;
			const next$1 = this.input.charCodeAt(pos + 1);
			if (next$1 === 60) {
				if (this.input.charCodeAt(pos + 2) === 61) {
					this.finishOp(30, 3);
					return;
				}
				this.finishOp(51, 2);
				return;
			}
			if (next$1 === 61) {
				this.finishOp(49, 2);
				return;
			}
			this.finishOp(47, 1);
		}
		readToken_gt() {
			const { pos } = this.state;
			const next$1 = this.input.charCodeAt(pos + 1);
			if (next$1 === 62) {
				const size = this.input.charCodeAt(pos + 2) === 62 ? 3 : 2;
				if (this.input.charCodeAt(pos + size) === 61) {
					this.finishOp(30, size + 1);
					return;
				}
				this.finishOp(52, size);
				return;
			}
			if (next$1 === 61) {
				this.finishOp(49, 2);
				return;
			}
			this.finishOp(48, 1);
		}
		readToken_eq_excl(code$1) {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			if (next$1 === 61) {
				this.finishOp(46, this.input.charCodeAt(this.state.pos + 2) === 61 ? 3 : 2);
				return;
			}
			if (code$1 === 61 && next$1 === 62) {
				this.state.pos += 2;
				this.finishToken(19);
				return;
			}
			this.finishOp(code$1 === 61 ? 29 : 35, 1);
		}
		readToken_question() {
			const next$1 = this.input.charCodeAt(this.state.pos + 1);
			const next2 = this.input.charCodeAt(this.state.pos + 2);
			if (next$1 === 63) if (next2 === 61) this.finishOp(30, 3);
			else this.finishOp(40, 2);
			else if (next$1 === 46 && !(next2 >= 48 && next2 <= 57)) {
				this.state.pos += 2;
				this.finishToken(18);
			} else {
				++this.state.pos;
				this.finishToken(17);
			}
		}
		getTokenFromCode(code$1) {
			switch (code$1) {
				case 46:
					this.readToken_dot();
					return;
				case 40:
					++this.state.pos;
					this.finishToken(10);
					return;
				case 41:
					++this.state.pos;
					this.finishToken(11);
					return;
				case 59:
					++this.state.pos;
					this.finishToken(13);
					return;
				case 44:
					++this.state.pos;
					this.finishToken(12);
					return;
				case 91:
					if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
						if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") throw this.raise(Errors.TupleExpressionBarIncorrectStartSyntaxType, this.state.curPosition());
						this.state.pos += 2;
						this.finishToken(2);
					} else {
						++this.state.pos;
						this.finishToken(0);
					}
					return;
				case 93:
					++this.state.pos;
					this.finishToken(3);
					return;
				case 123:
					if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
						if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") throw this.raise(Errors.RecordExpressionBarIncorrectStartSyntaxType, this.state.curPosition());
						this.state.pos += 2;
						this.finishToken(6);
					} else {
						++this.state.pos;
						this.finishToken(5);
					}
					return;
				case 125:
					++this.state.pos;
					this.finishToken(8);
					return;
				case 58:
					if (this.hasPlugin("functionBind") && this.input.charCodeAt(this.state.pos + 1) === 58) this.finishOp(15, 2);
					else {
						++this.state.pos;
						this.finishToken(14);
					}
					return;
				case 63:
					this.readToken_question();
					return;
				case 96:
					this.readTemplateToken();
					return;
				case 48: {
					const next$1 = this.input.charCodeAt(this.state.pos + 1);
					if (next$1 === 120 || next$1 === 88) {
						this.readRadixNumber(16);
						return;
					}
					if (next$1 === 111 || next$1 === 79) {
						this.readRadixNumber(8);
						return;
					}
					if (next$1 === 98 || next$1 === 66) {
						this.readRadixNumber(2);
						return;
					}
				}
				case 49:
				case 50:
				case 51:
				case 52:
				case 53:
				case 54:
				case 55:
				case 56:
				case 57:
					this.readNumber(false);
					return;
				case 34:
				case 39:
					this.readString(code$1);
					return;
				case 47:
					this.readToken_slash();
					return;
				case 37:
				case 42:
					this.readToken_mult_modulo(code$1);
					return;
				case 124:
				case 38:
					this.readToken_pipe_amp(code$1);
					return;
				case 94:
					this.readToken_caret();
					return;
				case 43:
				case 45:
					this.readToken_plus_min(code$1);
					return;
				case 60:
					this.readToken_lt();
					return;
				case 62:
					this.readToken_gt();
					return;
				case 61:
				case 33:
					this.readToken_eq_excl(code$1);
					return;
				case 126:
					this.finishOp(36, 1);
					return;
				case 64:
					this.readToken_atSign();
					return;
				case 35:
					this.readToken_numberSign();
					return;
				case 92:
					this.readWord();
					return;
				default: if (isIdentifierStart(code$1)) {
					this.readWord(code$1);
					return;
				}
			}
			throw this.raise(Errors.InvalidOrUnexpectedToken, this.state.curPosition(), { unexpected: String.fromCodePoint(code$1) });
		}
		finishOp(type, size) {
			const str$1 = this.input.slice(this.state.pos, this.state.pos + size);
			this.state.pos += size;
			this.finishToken(type, str$1);
		}
		readRegexp() {
			const startLoc = this.state.startLoc;
			const start = this.state.start + 1;
			let escaped, inClass;
			let { pos } = this.state;
			for (;; ++pos) {
				if (pos >= this.length) throw this.raise(Errors.UnterminatedRegExp, createPositionWithColumnOffset(startLoc, 1));
				const ch = this.input.charCodeAt(pos);
				if (isNewLine(ch)) throw this.raise(Errors.UnterminatedRegExp, createPositionWithColumnOffset(startLoc, 1));
				if (escaped) escaped = false;
				else {
					if (ch === 91) inClass = true;
					else if (ch === 93 && inClass) inClass = false;
					else if (ch === 47 && !inClass) break;
					escaped = ch === 92;
				}
			}
			const content = this.input.slice(start, pos);
			++pos;
			let mods = "";
			const nextPos = () => createPositionWithColumnOffset(startLoc, pos + 2 - start);
			while (pos < this.length) {
				const cp = this.codePointAtPos(pos);
				const char = String.fromCharCode(cp);
				if (VALID_REGEX_FLAGS.has(cp)) {
					if (cp === 118) {
						if (mods.includes("u")) this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
					} else if (cp === 117) {
						if (mods.includes("v")) this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
					}
					if (mods.includes(char)) this.raise(Errors.DuplicateRegExpFlags, nextPos());
				} else if (isIdentifierChar(cp) || cp === 92) this.raise(Errors.MalformedRegExpFlags, nextPos());
				else break;
				++pos;
				mods += char;
			}
			this.state.pos = pos;
			this.finishToken(138, {
				pattern: content,
				flags: mods
			});
		}
		readInt(radix, len$1, forceLen = false, allowNumSeparator = true) {
			const { n, pos } = readInt(this.input, this.state.pos, this.state.lineStart, this.state.curLine, radix, len$1, forceLen, allowNumSeparator, this.errorHandlers_readInt, false);
			this.state.pos = pos;
			return n;
		}
		readRadixNumber(radix) {
			const start = this.state.pos;
			const startLoc = this.state.curPosition();
			let isBigInt = false;
			this.state.pos += 2;
			const val = this.readInt(radix);
			if (val == null) this.raise(Errors.InvalidDigit, createPositionWithColumnOffset(startLoc, 2), { radix });
			const next$1 = this.input.charCodeAt(this.state.pos);
			if (next$1 === 110) {
				++this.state.pos;
				isBigInt = true;
			} else if (next$1 === 109) throw this.raise(Errors.InvalidDecimal, startLoc);
			if (isIdentifierStart(this.codePointAtPos(this.state.pos))) throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
			if (isBigInt) {
				const str$1 = this.input.slice(start, this.state.pos).replace(/[_n]/g, "");
				this.finishToken(136, str$1);
				return;
			}
			this.finishToken(135, val);
		}
		readNumber(startsWithDot) {
			const start = this.state.pos;
			const startLoc = this.state.curPosition();
			let isFloat = false;
			let isBigInt = false;
			let hasExponent = false;
			let isOctal = false;
			if (!startsWithDot && this.readInt(10) === null) this.raise(Errors.InvalidNumber, this.state.curPosition());
			const hasLeadingZero = this.state.pos - start >= 2 && this.input.charCodeAt(start) === 48;
			if (hasLeadingZero) {
				const integer = this.input.slice(start, this.state.pos);
				this.recordStrictModeErrors(Errors.StrictOctalLiteral, startLoc);
				if (!this.state.strict) {
					const underscorePos = integer.indexOf("_");
					if (underscorePos > 0) this.raise(Errors.ZeroDigitNumericSeparator, createPositionWithColumnOffset(startLoc, underscorePos));
				}
				isOctal = hasLeadingZero && !/[89]/.test(integer);
			}
			let next$1 = this.input.charCodeAt(this.state.pos);
			if (next$1 === 46 && !isOctal) {
				++this.state.pos;
				this.readInt(10);
				isFloat = true;
				next$1 = this.input.charCodeAt(this.state.pos);
			}
			if ((next$1 === 69 || next$1 === 101) && !isOctal) {
				next$1 = this.input.charCodeAt(++this.state.pos);
				if (next$1 === 43 || next$1 === 45) ++this.state.pos;
				if (this.readInt(10) === null) this.raise(Errors.InvalidOrMissingExponent, startLoc);
				isFloat = true;
				hasExponent = true;
				next$1 = this.input.charCodeAt(this.state.pos);
			}
			if (next$1 === 110) {
				if (isFloat || hasLeadingZero) this.raise(Errors.InvalidBigIntLiteral, startLoc);
				++this.state.pos;
				isBigInt = true;
			}
			if (next$1 === 109) {
				this.expectPlugin("decimal", this.state.curPosition());
				if (hasExponent || hasLeadingZero) this.raise(Errors.InvalidDecimal, startLoc);
				++this.state.pos;
				var isDecimal = true;
			}
			if (isIdentifierStart(this.codePointAtPos(this.state.pos))) throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
			const str$1 = this.input.slice(start, this.state.pos).replace(/[_mn]/g, "");
			if (isBigInt) {
				this.finishToken(136, str$1);
				return;
			}
			if (isDecimal) {
				this.finishToken(137, str$1);
				return;
			}
			const val = isOctal ? parseInt(str$1, 8) : parseFloat(str$1);
			this.finishToken(135, val);
		}
		readCodePoint(throwOnInvalid) {
			const { code: code$1, pos } = readCodePoint(this.input, this.state.pos, this.state.lineStart, this.state.curLine, throwOnInvalid, this.errorHandlers_readCodePoint);
			this.state.pos = pos;
			return code$1;
		}
		readString(quote) {
			const { str: str$1, pos, curLine, lineStart } = readStringContents(quote === 34 ? "double" : "single", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_string);
			this.state.pos = pos + 1;
			this.state.lineStart = lineStart;
			this.state.curLine = curLine;
			this.finishToken(134, str$1);
		}
		readTemplateContinuation() {
			if (!this.match(8)) this.unexpected(null, 8);
			this.state.pos--;
			this.readTemplateToken();
		}
		readTemplateToken() {
			const opening = this.input[this.state.pos];
			const { str: str$1, firstInvalidLoc, pos, curLine, lineStart } = readStringContents("template", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_template);
			this.state.pos = pos + 1;
			this.state.lineStart = lineStart;
			this.state.curLine = curLine;
			if (firstInvalidLoc) this.state.firstInvalidTemplateEscapePos = new Position(firstInvalidLoc.curLine, firstInvalidLoc.pos - firstInvalidLoc.lineStart, this.sourceToOffsetPos(firstInvalidLoc.pos));
			if (this.input.codePointAt(pos) === 96) this.finishToken(24, firstInvalidLoc ? null : opening + str$1 + "`");
			else {
				this.state.pos++;
				this.finishToken(25, firstInvalidLoc ? null : opening + str$1 + "${");
			}
		}
		recordStrictModeErrors(toParseError, at) {
			const index$1 = at.index;
			if (this.state.strict && !this.state.strictErrors.has(index$1)) this.raise(toParseError, at);
			else this.state.strictErrors.set(index$1, [toParseError, at]);
		}
		readWord1(firstCode) {
			this.state.containsEsc = false;
			let word = "";
			const start = this.state.pos;
			let chunkStart = this.state.pos;
			if (firstCode !== void 0) this.state.pos += firstCode <= 65535 ? 1 : 2;
			while (this.state.pos < this.length) {
				const ch = this.codePointAtPos(this.state.pos);
				if (isIdentifierChar(ch)) this.state.pos += ch <= 65535 ? 1 : 2;
				else if (ch === 92) {
					this.state.containsEsc = true;
					word += this.input.slice(chunkStart, this.state.pos);
					const escStart = this.state.curPosition();
					const identifierCheck = this.state.pos === start ? isIdentifierStart : isIdentifierChar;
					if (this.input.charCodeAt(++this.state.pos) !== 117) {
						this.raise(Errors.MissingUnicodeEscape, this.state.curPosition());
						chunkStart = this.state.pos - 1;
						continue;
					}
					++this.state.pos;
					const esc = this.readCodePoint(true);
					if (esc !== null) {
						if (!identifierCheck(esc)) this.raise(Errors.EscapedCharNotAnIdentifier, escStart);
						word += String.fromCodePoint(esc);
					}
					chunkStart = this.state.pos;
				} else break;
			}
			return word + this.input.slice(chunkStart, this.state.pos);
		}
		readWord(firstCode) {
			const word = this.readWord1(firstCode);
			const type = keywords$1.get(word);
			if (type !== void 0) this.finishToken(type, tokenLabelName(type));
			else this.finishToken(132, word);
		}
		checkKeywordEscapes() {
			const { type } = this.state;
			if (tokenIsKeyword(type) && this.state.containsEsc) this.raise(Errors.InvalidEscapedReservedWord, this.state.startLoc, { reservedWord: tokenLabelName(type) });
		}
		raise(toParseError, at, details = {}) {
			const loc = at instanceof Position ? at : at.loc.start;
			const error = toParseError(loc, details);
			if (!(this.optionFlags & 2048)) throw error;
			if (!this.isLookahead) this.state.errors.push(error);
			return error;
		}
		raiseOverwrite(toParseError, at, details = {}) {
			const loc = at instanceof Position ? at : at.loc.start;
			const pos = loc.index;
			const errors = this.state.errors;
			for (let i = errors.length - 1; i >= 0; i--) {
				const error = errors[i];
				if (error.loc.index === pos) return errors[i] = toParseError(loc, details);
				if (error.loc.index < pos) break;
			}
			return this.raise(toParseError, at, details);
		}
		updateContext(prevType) {}
		unexpected(loc, type) {
			throw this.raise(Errors.UnexpectedToken, loc != null ? loc : this.state.startLoc, { expected: type ? tokenLabelName(type) : null });
		}
		expectPlugin(pluginName, loc) {
			if (this.hasPlugin(pluginName)) return true;
			throw this.raise(Errors.MissingPlugin, loc != null ? loc : this.state.startLoc, { missingPlugin: [pluginName] });
		}
		expectOnePlugin(pluginNames) {
			if (!pluginNames.some((name) => this.hasPlugin(name))) throw this.raise(Errors.MissingOneOfPlugins, this.state.startLoc, { missingPlugin: pluginNames });
		}
		errorBuilder(error) {
			return (pos, lineStart, curLine) => {
				this.raise(error, buildPosition(pos, lineStart, curLine));
			};
		}
	};
	var ClassScope = class {
		constructor() {
			this.privateNames = /* @__PURE__ */ new Set();
			this.loneAccessors = /* @__PURE__ */ new Map();
			this.undefinedPrivateNames = /* @__PURE__ */ new Map();
		}
	};
	var ClassScopeHandler = class {
		constructor(parser$1) {
			this.parser = void 0;
			this.stack = [];
			this.undefinedPrivateNames = /* @__PURE__ */ new Map();
			this.parser = parser$1;
		}
		current() {
			return this.stack[this.stack.length - 1];
		}
		enter() {
			this.stack.push(new ClassScope());
		}
		exit() {
			const oldClassScope = this.stack.pop();
			const current = this.current();
			for (const [name, loc] of Array.from(oldClassScope.undefinedPrivateNames)) if (current) {
				if (!current.undefinedPrivateNames.has(name)) current.undefinedPrivateNames.set(name, loc);
			} else this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, { identifierName: name });
		}
		declarePrivateName(name, elementType, loc) {
			const { privateNames, loneAccessors, undefinedPrivateNames } = this.current();
			let redefined = privateNames.has(name);
			if (elementType & 3) {
				const accessor = redefined && loneAccessors.get(name);
				if (accessor) {
					const oldStatic = accessor & 4;
					const newStatic = elementType & 4;
					const oldKind = accessor & 3;
					const newKind = elementType & 3;
					redefined = oldKind === newKind || oldStatic !== newStatic;
					if (!redefined) loneAccessors.delete(name);
				} else if (!redefined) loneAccessors.set(name, elementType);
			}
			if (redefined) this.parser.raise(Errors.PrivateNameRedeclaration, loc, { identifierName: name });
			privateNames.add(name);
			undefinedPrivateNames.delete(name);
		}
		usePrivateName(name, loc) {
			let classScope;
			for (classScope of this.stack) if (classScope.privateNames.has(name)) return;
			if (classScope) classScope.undefinedPrivateNames.set(name, loc);
			else this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, { identifierName: name });
		}
	};
	var ExpressionScope = class {
		constructor(type = 0) {
			this.type = type;
		}
		canBeArrowParameterDeclaration() {
			return this.type === 2 || this.type === 1;
		}
		isCertainlyParameterDeclaration() {
			return this.type === 3;
		}
	};
	var ArrowHeadParsingScope = class extends ExpressionScope {
		constructor(type) {
			super(type);
			this.declarationErrors = /* @__PURE__ */ new Map();
		}
		recordDeclarationError(ParsingErrorClass, at) {
			const index$1 = at.index;
			this.declarationErrors.set(index$1, [ParsingErrorClass, at]);
		}
		clearDeclarationError(index$1) {
			this.declarationErrors.delete(index$1);
		}
		iterateErrors(iterator) {
			this.declarationErrors.forEach(iterator);
		}
	};
	var ExpressionScopeHandler = class {
		constructor(parser$1) {
			this.parser = void 0;
			this.stack = [new ExpressionScope()];
			this.parser = parser$1;
		}
		enter(scope) {
			this.stack.push(scope);
		}
		exit() {
			this.stack.pop();
		}
		recordParameterInitializerError(toParseError, node) {
			const origin = node.loc.start;
			const { stack: stack$1 } = this;
			let i = stack$1.length - 1;
			let scope = stack$1[i];
			while (!scope.isCertainlyParameterDeclaration()) {
				if (scope.canBeArrowParameterDeclaration()) scope.recordDeclarationError(toParseError, origin);
				else return;
				scope = stack$1[--i];
			}
			this.parser.raise(toParseError, origin);
		}
		recordArrowParameterBindingError(error, node) {
			const { stack: stack$1 } = this;
			const scope = stack$1[stack$1.length - 1];
			const origin = node.loc.start;
			if (scope.isCertainlyParameterDeclaration()) this.parser.raise(error, origin);
			else if (scope.canBeArrowParameterDeclaration()) scope.recordDeclarationError(error, origin);
			else return;
		}
		recordAsyncArrowParametersError(at) {
			const { stack: stack$1 } = this;
			let i = stack$1.length - 1;
			let scope = stack$1[i];
			while (scope.canBeArrowParameterDeclaration()) {
				if (scope.type === 2) scope.recordDeclarationError(Errors.AwaitBindingIdentifier, at);
				scope = stack$1[--i];
			}
		}
		validateAsPattern() {
			const { stack: stack$1 } = this;
			const currentScope = stack$1[stack$1.length - 1];
			if (!currentScope.canBeArrowParameterDeclaration()) return;
			currentScope.iterateErrors(([toParseError, loc]) => {
				this.parser.raise(toParseError, loc);
				let i = stack$1.length - 2;
				let scope = stack$1[i];
				while (scope.canBeArrowParameterDeclaration()) {
					scope.clearDeclarationError(loc.index);
					scope = stack$1[--i];
				}
			});
		}
	};
	function newParameterDeclarationScope() {
		return new ExpressionScope(3);
	}
	function newArrowHeadScope() {
		return new ArrowHeadParsingScope(1);
	}
	function newAsyncArrowScope() {
		return new ArrowHeadParsingScope(2);
	}
	function newExpressionScope() {
		return new ExpressionScope();
	}
	var UtilParser = class extends Tokenizer$1 {
		addExtra(node, key, value, enumerable = true) {
			if (!node) return;
			let { extra } = node;
			if (extra == null) {
				extra = {};
				node.extra = extra;
			}
			if (enumerable) extra[key] = value;
			else Object.defineProperty(extra, key, {
				enumerable,
				value
			});
		}
		isContextual(token) {
			return this.state.type === token && !this.state.containsEsc;
		}
		isUnparsedContextual(nameStart, name) {
			if (this.input.startsWith(name, nameStart)) {
				const nextCh = this.input.charCodeAt(nameStart + name.length);
				return !(isIdentifierChar(nextCh) || (nextCh & 64512) === 55296);
			}
			return false;
		}
		isLookaheadContextual(name) {
			const next$1 = this.nextTokenStart();
			return this.isUnparsedContextual(next$1, name);
		}
		eatContextual(token) {
			if (this.isContextual(token)) {
				this.next();
				return true;
			}
			return false;
		}
		expectContextual(token, toParseError) {
			if (!this.eatContextual(token)) {
				if (toParseError != null) throw this.raise(toParseError, this.state.startLoc);
				this.unexpected(null, token);
			}
		}
		canInsertSemicolon() {
			return this.match(140) || this.match(8) || this.hasPrecedingLineBreak();
		}
		hasPrecedingLineBreak() {
			return hasNewLine(this.input, this.offsetToSourcePos(this.state.lastTokEndLoc.index), this.state.start);
		}
		hasFollowingLineBreak() {
			return hasNewLine(this.input, this.state.end, this.nextTokenStart());
		}
		isLineTerminator() {
			return this.eat(13) || this.canInsertSemicolon();
		}
		semicolon(allowAsi = true) {
			if (allowAsi ? this.isLineTerminator() : this.eat(13)) return;
			this.raise(Errors.MissingSemicolon, this.state.lastTokEndLoc);
		}
		expect(type, loc) {
			if (!this.eat(type)) this.unexpected(loc, type);
		}
		tryParse(fn, oldState = this.state.clone()) {
			const abortSignal = { node: null };
			try {
				const node = fn((node$1 = null) => {
					abortSignal.node = node$1;
					throw abortSignal;
				});
				if (this.state.errors.length > oldState.errors.length) {
					const failState = this.state;
					this.state = oldState;
					this.state.tokensLength = failState.tokensLength;
					return {
						node,
						error: failState.errors[oldState.errors.length],
						thrown: false,
						aborted: false,
						failState
					};
				}
				return {
					node,
					error: null,
					thrown: false,
					aborted: false,
					failState: null
				};
			} catch (error) {
				const failState = this.state;
				this.state = oldState;
				if (error instanceof SyntaxError) return {
					node: null,
					error,
					thrown: true,
					aborted: false,
					failState
				};
				if (error === abortSignal) return {
					node: abortSignal.node,
					error: null,
					thrown: false,
					aborted: true,
					failState
				};
				throw error;
			}
		}
		checkExpressionErrors(refExpressionErrors, andThrow) {
			if (!refExpressionErrors) return false;
			const { shorthandAssignLoc, doubleProtoLoc, privateKeyLoc, optionalParametersLoc, voidPatternLoc } = refExpressionErrors;
			const hasErrors = !!shorthandAssignLoc || !!doubleProtoLoc || !!optionalParametersLoc || !!privateKeyLoc || !!voidPatternLoc;
			if (!andThrow) return hasErrors;
			if (shorthandAssignLoc != null) this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
			if (doubleProtoLoc != null) this.raise(Errors.DuplicateProto, doubleProtoLoc);
			if (privateKeyLoc != null) this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
			if (optionalParametersLoc != null) this.unexpected(optionalParametersLoc);
			if (voidPatternLoc != null) this.raise(Errors.InvalidCoverDiscardElement, voidPatternLoc);
		}
		isLiteralPropertyName() {
			return tokenIsLiteralPropertyName(this.state.type);
		}
		isPrivateName(node) {
			return node.type === "PrivateName";
		}
		getPrivateNameSV(node) {
			return node.id.name;
		}
		hasPropertyAsPrivateName(node) {
			return (node.type === "MemberExpression" || node.type === "OptionalMemberExpression") && this.isPrivateName(node.property);
		}
		isObjectProperty(node) {
			return node.type === "ObjectProperty";
		}
		isObjectMethod(node) {
			return node.type === "ObjectMethod";
		}
		initializeScopes(inModule = this.options.sourceType === "module") {
			const oldLabels = this.state.labels;
			this.state.labels = [];
			const oldExportedIdentifiers = this.exportedIdentifiers;
			this.exportedIdentifiers = /* @__PURE__ */ new Set();
			const oldInModule = this.inModule;
			this.inModule = inModule;
			const oldScope = this.scope;
			const ScopeHandler$1 = this.getScopeHandler();
			this.scope = new ScopeHandler$1(this, inModule);
			const oldProdParam = this.prodParam;
			this.prodParam = new ProductionParameterHandler();
			const oldClassScope = this.classScope;
			this.classScope = new ClassScopeHandler(this);
			const oldExpressionScope = this.expressionScope;
			this.expressionScope = new ExpressionScopeHandler(this);
			return () => {
				this.state.labels = oldLabels;
				this.exportedIdentifiers = oldExportedIdentifiers;
				this.inModule = oldInModule;
				this.scope = oldScope;
				this.prodParam = oldProdParam;
				this.classScope = oldClassScope;
				this.expressionScope = oldExpressionScope;
			};
		}
		enterInitialScopes() {
			let paramFlags = 0;
			if (this.inModule || this.optionFlags & 1) paramFlags |= 2;
			if (this.optionFlags & 32) paramFlags |= 1;
			const isCommonJS = !this.inModule && this.options.sourceType === "commonjs";
			if (isCommonJS || this.optionFlags & 2) paramFlags |= 4;
			this.prodParam.enter(paramFlags);
			let scopeFlags = isCommonJS ? 514 : 1;
			if (this.optionFlags & 4) scopeFlags |= 512;
			this.scope.enter(scopeFlags);
		}
		checkDestructuringPrivate(refExpressionErrors) {
			const { privateKeyLoc } = refExpressionErrors;
			if (privateKeyLoc !== null) this.expectPlugin("destructuringPrivate", privateKeyLoc);
		}
	};
	var ExpressionErrors = class {
		constructor() {
			this.shorthandAssignLoc = null;
			this.doubleProtoLoc = null;
			this.privateKeyLoc = null;
			this.optionalParametersLoc = null;
			this.voidPatternLoc = null;
		}
	};
	var Node = class {
		constructor(parser$1, pos, loc) {
			this.type = "";
			this.start = pos;
			this.end = 0;
			this.loc = new SourceLocation(loc);
			if ((parser$1 == null ? void 0 : parser$1.optionFlags) & 128) this.range = [pos, 0];
			if (parser$1 != null && parser$1.filename) this.loc.filename = parser$1.filename;
		}
	};
	const NodePrototype = Node.prototype;
	NodePrototype.__clone = function() {
		const newNode = new Node(void 0, this.start, this.loc.start);
		const keys = Object.keys(this);
		for (let i = 0, length = keys.length; i < length; i++) {
			const key = keys[i];
			if (key !== "leadingComments" && key !== "trailingComments" && key !== "innerComments") newNode[key] = this[key];
		}
		return newNode;
	};
	var NodeUtils = class extends UtilParser {
		startNode() {
			const loc = this.state.startLoc;
			return new Node(this, loc.index, loc);
		}
		startNodeAt(loc) {
			return new Node(this, loc.index, loc);
		}
		startNodeAtNode(type) {
			return this.startNodeAt(type.loc.start);
		}
		finishNode(node, type) {
			return this.finishNodeAt(node, type, this.state.lastTokEndLoc);
		}
		finishNodeAt(node, type, endLoc) {
			node.type = type;
			node.end = endLoc.index;
			node.loc.end = endLoc;
			if (this.optionFlags & 128) node.range[1] = endLoc.index;
			if (this.optionFlags & 4096) this.processComment(node);
			return node;
		}
		resetStartLocation(node, startLoc) {
			node.start = startLoc.index;
			node.loc.start = startLoc;
			if (this.optionFlags & 128) node.range[0] = startLoc.index;
		}
		resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
			node.end = endLoc.index;
			node.loc.end = endLoc;
			if (this.optionFlags & 128) node.range[1] = endLoc.index;
		}
		resetStartLocationFromNode(node, locationNode) {
			this.resetStartLocation(node, locationNode.loc.start);
		}
		castNodeTo(node, type) {
			node.type = type;
			return node;
		}
		cloneIdentifier(node) {
			const { type, start, end, loc, range: range$3, name } = node;
			const cloned = Object.create(NodePrototype);
			cloned.type = type;
			cloned.start = start;
			cloned.end = end;
			cloned.loc = loc;
			cloned.range = range$3;
			cloned.name = name;
			if (node.extra) cloned.extra = node.extra;
			return cloned;
		}
		cloneStringLiteral(node) {
			const { type, start, end, loc, range: range$3, extra } = node;
			const cloned = Object.create(NodePrototype);
			cloned.type = type;
			cloned.start = start;
			cloned.end = end;
			cloned.loc = loc;
			cloned.range = range$3;
			cloned.extra = extra;
			cloned.value = node.value;
			return cloned;
		}
	};
	const unwrapParenthesizedExpression = (node) => {
		return node.type === "ParenthesizedExpression" ? unwrapParenthesizedExpression(node.expression) : node;
	};
	var LValParser = class extends NodeUtils {
		toAssignable(node, isLHS = false) {
			var _node$extra, _node$extra3;
			let parenthesized = void 0;
			if (node.type === "ParenthesizedExpression" || (_node$extra = node.extra) != null && _node$extra.parenthesized) {
				parenthesized = unwrapParenthesizedExpression(node);
				if (isLHS) {
					if (parenthesized.type === "Identifier") this.expressionScope.recordArrowParameterBindingError(Errors.InvalidParenthesizedAssignment, node);
					else if (parenthesized.type !== "MemberExpression" && !this.isOptionalMemberExpression(parenthesized)) this.raise(Errors.InvalidParenthesizedAssignment, node);
				} else this.raise(Errors.InvalidParenthesizedAssignment, node);
			}
			switch (node.type) {
				case "Identifier":
				case "ObjectPattern":
				case "ArrayPattern":
				case "AssignmentPattern":
				case "RestElement":
				case "VoidPattern": break;
				case "ObjectExpression":
					this.castNodeTo(node, "ObjectPattern");
					for (let i = 0, length = node.properties.length, last = length - 1; i < length; i++) {
						var _node$extra2;
						const prop = node.properties[i];
						const isLast = i === last;
						this.toAssignableObjectExpressionProp(prop, isLast, isLHS);
						if (isLast && prop.type === "RestElement" && (_node$extra2 = node.extra) != null && _node$extra2.trailingCommaLoc) this.raise(Errors.RestTrailingComma, node.extra.trailingCommaLoc);
					}
					break;
				case "ObjectProperty": {
					const { key, value } = node;
					if (this.isPrivateName(key)) this.classScope.usePrivateName(this.getPrivateNameSV(key), key.loc.start);
					this.toAssignable(value, isLHS);
					break;
				}
				case "SpreadElement": throw new Error("Internal @babel/parser error (this is a bug, please report it). SpreadElement should be converted by .toAssignable's caller.");
				case "ArrayExpression":
					this.castNodeTo(node, "ArrayPattern");
					this.toAssignableList(node.elements, (_node$extra3 = node.extra) == null ? void 0 : _node$extra3.trailingCommaLoc, isLHS);
					break;
				case "AssignmentExpression":
					if (node.operator !== "=") this.raise(Errors.MissingEqInAssignment, node.left.loc.end);
					this.castNodeTo(node, "AssignmentPattern");
					delete node.operator;
					if (node.left.type === "VoidPattern") this.raise(Errors.VoidPatternInitializer, node.left);
					this.toAssignable(node.left, isLHS);
					break;
				case "ParenthesizedExpression":
					this.toAssignable(parenthesized, isLHS);
					break;
			}
		}
		toAssignableObjectExpressionProp(prop, isLast, isLHS) {
			if (prop.type === "ObjectMethod") this.raise(prop.kind === "get" || prop.kind === "set" ? Errors.PatternHasAccessor : Errors.PatternHasMethod, prop.key);
			else if (prop.type === "SpreadElement") {
				this.castNodeTo(prop, "RestElement");
				const arg = prop.argument;
				this.checkToRestConversion(arg, false);
				this.toAssignable(arg, isLHS);
				if (!isLast) this.raise(Errors.RestTrailingComma, prop);
			} else this.toAssignable(prop, isLHS);
		}
		toAssignableList(exprList, trailingCommaLoc, isLHS) {
			const end = exprList.length - 1;
			for (let i = 0; i <= end; i++) {
				const elt = exprList[i];
				if (!elt) continue;
				this.toAssignableListItem(exprList, i, isLHS);
				if (elt.type === "RestElement") {
					if (i < end) this.raise(Errors.RestTrailingComma, elt);
					else if (trailingCommaLoc) this.raise(Errors.RestTrailingComma, trailingCommaLoc);
				}
			}
		}
		toAssignableListItem(exprList, index$1, isLHS) {
			const node = exprList[index$1];
			if (node.type === "SpreadElement") {
				this.castNodeTo(node, "RestElement");
				const arg = node.argument;
				this.checkToRestConversion(arg, true);
				this.toAssignable(arg, isLHS);
			} else this.toAssignable(node, isLHS);
		}
		isAssignable(node, isBinding) {
			switch (node.type) {
				case "Identifier":
				case "ObjectPattern":
				case "ArrayPattern":
				case "AssignmentPattern":
				case "RestElement":
				case "VoidPattern": return true;
				case "ObjectExpression": {
					const last = node.properties.length - 1;
					return node.properties.every((prop, i) => {
						return prop.type !== "ObjectMethod" && (i === last || prop.type !== "SpreadElement") && this.isAssignable(prop);
					});
				}
				case "ObjectProperty": return this.isAssignable(node.value);
				case "SpreadElement": return this.isAssignable(node.argument);
				case "ArrayExpression": return node.elements.every((element) => element === null || this.isAssignable(element));
				case "AssignmentExpression": return node.operator === "=";
				case "ParenthesizedExpression": return this.isAssignable(node.expression);
				case "MemberExpression":
				case "OptionalMemberExpression": return !isBinding;
				default: return false;
			}
		}
		toReferencedList(exprList, isParenthesizedExpr) {
			return exprList;
		}
		toReferencedListDeep(exprList, isParenthesizedExpr) {
			this.toReferencedList(exprList, isParenthesizedExpr);
			for (const expr of exprList) if ((expr == null ? void 0 : expr.type) === "ArrayExpression") this.toReferencedListDeep(expr.elements);
		}
		parseSpread(refExpressionErrors) {
			const node = this.startNode();
			this.next();
			node.argument = this.parseMaybeAssignAllowIn(refExpressionErrors, void 0);
			return this.finishNode(node, "SpreadElement");
		}
		parseRestBinding() {
			const node = this.startNode();
			this.next();
			const argument = this.parseBindingAtom();
			if (argument.type === "VoidPattern") this.raise(Errors.UnexpectedVoidPattern, argument);
			node.argument = argument;
			return this.finishNode(node, "RestElement");
		}
		parseBindingAtom() {
			switch (this.state.type) {
				case 0: {
					const node = this.startNode();
					this.next();
					node.elements = this.parseBindingList(3, 93, 1);
					return this.finishNode(node, "ArrayPattern");
				}
				case 5: return this.parseObjectLike(8, true);
				case 88: return this.parseVoidPattern(null);
			}
			return this.parseIdentifier();
		}
		parseBindingList(close, closeCharCode, flags) {
			const allowEmpty = flags & 1;
			const elts = [];
			let first = true;
			while (!this.eat(close)) {
				if (first) first = false;
				else this.expect(12);
				if (allowEmpty && this.match(12)) elts.push(null);
				else if (this.eat(close)) break;
				else if (this.match(21)) {
					let rest = this.parseRestBinding();
					if (this.hasPlugin("flow") || flags & 2) rest = this.parseFunctionParamType(rest);
					elts.push(rest);
					if (!this.checkCommaAfterRest(closeCharCode)) {
						this.expect(close);
						break;
					}
				} else {
					const decorators = [];
					if (flags & 2) {
						if (this.match(26) && this.hasPlugin("decorators")) this.raise(Errors.UnsupportedParameterDecorator, this.state.startLoc);
						while (this.match(26)) decorators.push(this.parseDecorator());
					}
					elts.push(this.parseBindingElement(flags, decorators));
				}
			}
			return elts;
		}
		parseBindingRestProperty(prop) {
			this.next();
			if (this.hasPlugin("discardBinding") && this.match(88)) {
				prop.argument = this.parseVoidPattern(null);
				this.raise(Errors.UnexpectedVoidPattern, prop.argument);
			} else prop.argument = this.parseIdentifier();
			this.checkCommaAfterRest(125);
			return this.finishNode(prop, "RestElement");
		}
		parseBindingProperty() {
			const { type, startLoc } = this.state;
			if (type === 21) return this.parseBindingRestProperty(this.startNode());
			const prop = this.startNode();
			if (type === 139) {
				this.expectPlugin("destructuringPrivate", startLoc);
				this.classScope.usePrivateName(this.state.value, startLoc);
				prop.key = this.parsePrivateName();
			} else this.parsePropertyName(prop);
			prop.method = false;
			return this.parseObjPropValue(prop, startLoc, false, false, true, false);
		}
		parseBindingElement(flags, decorators) {
			const left = this.parseMaybeDefault();
			if (this.hasPlugin("flow") || flags & 2) this.parseFunctionParamType(left);
			if (decorators.length) {
				left.decorators = decorators;
				this.resetStartLocationFromNode(left, decorators[0]);
			}
			const elt = this.parseMaybeDefault(left.loc.start, left);
			return elt;
		}
		parseFunctionParamType(param) {
			return param;
		}
		parseMaybeDefault(startLoc, left) {
			startLoc != null || (startLoc = this.state.startLoc);
			left = left != null ? left : this.parseBindingAtom();
			if (!this.eat(29)) return left;
			const node = this.startNodeAt(startLoc);
			if (left.type === "VoidPattern") this.raise(Errors.VoidPatternInitializer, left);
			node.left = left;
			node.right = this.parseMaybeAssignAllowIn();
			return this.finishNode(node, "AssignmentPattern");
		}
		isValidLVal(type, isUnparenthesizedInAssign, binding) {
			switch (type) {
				case "AssignmentPattern": return "left";
				case "RestElement": return "argument";
				case "ObjectProperty": return "value";
				case "ParenthesizedExpression": return "expression";
				case "ArrayPattern": return "elements";
				case "ObjectPattern": return "properties";
				case "VoidPattern": return true;
			}
			return false;
		}
		isOptionalMemberExpression(expression) {
			return expression.type === "OptionalMemberExpression";
		}
		checkLVal(expression, ancestor, binding = 64, checkClashes = false, strictModeChanged = false, hasParenthesizedAncestor = false) {
			var _expression$extra;
			const type = expression.type;
			if (this.isObjectMethod(expression)) return;
			const isOptionalMemberExpression = this.isOptionalMemberExpression(expression);
			if (isOptionalMemberExpression || type === "MemberExpression") {
				if (isOptionalMemberExpression) {
					this.expectPlugin("optionalChainingAssign", expression.loc.start);
					if (ancestor.type !== "AssignmentExpression") this.raise(Errors.InvalidLhsOptionalChaining, expression, { ancestor });
				}
				if (binding !== 64) this.raise(Errors.InvalidPropertyBindingPattern, expression);
				return;
			}
			if (type === "Identifier") {
				this.checkIdentifier(expression, binding, strictModeChanged);
				const { name } = expression;
				if (checkClashes) if (checkClashes.has(name)) this.raise(Errors.ParamDupe, expression);
				else checkClashes.add(name);
				return;
			} else if (type === "VoidPattern" && ancestor.type === "CatchClause") this.raise(Errors.VoidPatternCatchClauseParam, expression);
			const validity = this.isValidLVal(type, !(hasParenthesizedAncestor || (_expression$extra = expression.extra) != null && _expression$extra.parenthesized) && ancestor.type === "AssignmentExpression", binding);
			if (validity === true) return;
			if (validity === false) {
				const ParseErrorClass = binding === 64 ? Errors.InvalidLhs : Errors.InvalidLhsBinding;
				this.raise(ParseErrorClass, expression, { ancestor });
				return;
			}
			let key, isParenthesizedExpression;
			if (typeof validity === "string") {
				key = validity;
				isParenthesizedExpression = type === "ParenthesizedExpression";
			} else [key, isParenthesizedExpression] = validity;
			const nextAncestor = type === "ArrayPattern" || type === "ObjectPattern" ? { type } : ancestor;
			const val = expression[key];
			if (Array.isArray(val)) {
				for (const child of val) if (child) this.checkLVal(child, nextAncestor, binding, checkClashes, strictModeChanged, isParenthesizedExpression);
			} else if (val) this.checkLVal(val, nextAncestor, binding, checkClashes, strictModeChanged, isParenthesizedExpression);
		}
		checkIdentifier(at, bindingType, strictModeChanged = false) {
			if (this.state.strict && (strictModeChanged ? isStrictBindReservedWord(at.name, this.inModule) : isStrictBindOnlyReservedWord(at.name))) if (bindingType === 64) this.raise(Errors.StrictEvalArguments, at, { referenceName: at.name });
			else this.raise(Errors.StrictEvalArgumentsBinding, at, { bindingName: at.name });
			if (bindingType & 8192 && at.name === "let") this.raise(Errors.LetInLexicalBinding, at);
			if (!(bindingType & 64)) this.declareNameFromIdentifier(at, bindingType);
		}
		declareNameFromIdentifier(identifier, binding) {
			this.scope.declareName(identifier.name, binding, identifier.loc.start);
		}
		checkToRestConversion(node, allowPattern) {
			switch (node.type) {
				case "ParenthesizedExpression":
					this.checkToRestConversion(node.expression, allowPattern);
					break;
				case "Identifier":
				case "MemberExpression": break;
				case "ArrayExpression":
				case "ObjectExpression": if (allowPattern) break;
				default: this.raise(Errors.InvalidRestAssignmentPattern, node);
			}
		}
		checkCommaAfterRest(close) {
			if (!this.match(12)) return false;
			this.raise(this.lookaheadCharCode() === close ? Errors.RestTrailingComma : Errors.ElementAfterRest, this.state.startLoc);
			return true;
		}
	};
	function nonNull(x) {
		if (x == null) throw new Error(`Unexpected ${x} value.`);
		return x;
	}
	function assert$1(x) {
		if (!x) throw new Error("Assert fail");
	}
	const TSErrors = ParseErrorEnum`typescript`({
		AbstractMethodHasImplementation: ({ methodName }) => `Method '${methodName}' cannot have an implementation because it is marked abstract.`,
		AbstractPropertyHasInitializer: ({ propertyName }) => `Property '${propertyName}' cannot have an initializer because it is marked abstract.`,
		AccessorCannotBeOptional: "An 'accessor' property cannot be declared optional.",
		AccessorCannotDeclareThisParameter: "'get' and 'set' accessors cannot declare 'this' parameters.",
		AccessorCannotHaveTypeParameters: "An accessor cannot have type parameters.",
		ClassMethodHasDeclare: "Class methods cannot have the 'declare' modifier.",
		ClassMethodHasReadonly: "Class methods cannot have the 'readonly' modifier.",
		ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference: "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference.",
		ConstructorHasTypeParameters: "Type parameters cannot appear on a constructor declaration.",
		DeclareAccessor: ({ kind }) => `'declare' is not allowed in ${kind}ters.`,
		DeclareClassFieldHasInitializer: "Initializers are not allowed in ambient contexts.",
		DeclareFunctionHasImplementation: "An implementation cannot be declared in ambient contexts.",
		DuplicateAccessibilityModifier: ({ modifier }) => `Accessibility modifier already seen: '${modifier}'.`,
		DuplicateModifier: ({ modifier }) => `Duplicate modifier: '${modifier}'.`,
		EmptyHeritageClauseType: ({ token }) => `'${token}' list cannot be empty.`,
		EmptyTypeArguments: "Type argument list cannot be empty.",
		EmptyTypeParameters: "Type parameter list cannot be empty.",
		ExpectedAmbientAfterExportDeclare: "'export declare' must be followed by an ambient declaration.",
		ImportAliasHasImportType: "An import alias can not use 'import type'.",
		ImportReflectionHasImportType: "An `import module` declaration can not use `type` modifier",
		IncompatibleModifiers: ({ modifiers }) => `'${modifiers[0]}' modifier cannot be used with '${modifiers[1]}' modifier.`,
		IndexSignatureHasAbstract: "Index signatures cannot have the 'abstract' modifier.",
		IndexSignatureHasAccessibility: ({ modifier }) => `Index signatures cannot have an accessibility modifier ('${modifier}').`,
		IndexSignatureHasDeclare: "Index signatures cannot have the 'declare' modifier.",
		IndexSignatureHasOverride: "'override' modifier cannot appear on an index signature.",
		IndexSignatureHasStatic: "Index signatures cannot have the 'static' modifier.",
		InitializerNotAllowedInAmbientContext: "Initializers are not allowed in ambient contexts.",
		InvalidHeritageClauseType: ({ token }) => `'${token}' list can only include identifiers or qualified-names with optional type arguments.`,
		InvalidModifierOnAwaitUsingDeclaration: (modifier) => `'${modifier}' modifier cannot appear on an await using declaration.`,
		InvalidModifierOnTypeMember: ({ modifier }) => `'${modifier}' modifier cannot appear on a type member.`,
		InvalidModifierOnTypeParameter: ({ modifier }) => `'${modifier}' modifier cannot appear on a type parameter.`,
		InvalidModifierOnTypeParameterPositions: ({ modifier }) => `'${modifier}' modifier can only appear on a type parameter of a class, interface or type alias.`,
		InvalidModifierOnUsingDeclaration: (modifier) => `'${modifier}' modifier cannot appear on a using declaration.`,
		InvalidModifiersOrder: ({ orderedModifiers }) => `'${orderedModifiers[0]}' modifier must precede '${orderedModifiers[1]}' modifier.`,
		InvalidPropertyAccessAfterInstantiationExpression: "Invalid property access after an instantiation expression. You can either wrap the instantiation expression in parentheses, or delete the type arguments.",
		InvalidTupleMemberLabel: "Tuple members must be labeled with a simple identifier.",
		MissingInterfaceName: "'interface' declarations must be followed by an identifier.",
		NonAbstractClassHasAbstractMethod: "Abstract methods can only appear within an abstract class.",
		NonClassMethodPropertyHasAbstractModifier: "'abstract' modifier can only appear on a class, method, or property declaration.",
		OptionalTypeBeforeRequired: "A required element cannot follow an optional element.",
		OverrideNotInSubClass: "This member cannot have an 'override' modifier because its containing class does not extend another class.",
		PatternIsOptional: "A binding pattern parameter cannot be optional in an implementation signature.",
		PrivateElementHasAbstract: "Private elements cannot have the 'abstract' modifier.",
		PrivateElementHasAccessibility: ({ modifier }) => `Private elements cannot have an accessibility modifier ('${modifier}').`,
		ReadonlyForMethodSignature: "'readonly' modifier can only appear on a property declaration or index signature.",
		ReservedArrowTypeParam: "This syntax is reserved in files with the .mts or .cts extension. Add a trailing comma, as in `<T,>() => ...`.",
		ReservedTypeAssertion: "This syntax is reserved in files with the .mts or .cts extension. Use an `as` expression instead.",
		SetAccessorCannotHaveOptionalParameter: "A 'set' accessor cannot have an optional parameter.",
		SetAccessorCannotHaveRestParameter: "A 'set' accessor cannot have rest parameter.",
		SetAccessorCannotHaveReturnType: "A 'set' accessor cannot have a return type annotation.",
		SingleTypeParameterWithoutTrailingComma: ({ typeParameterName }) => `Single type parameter ${typeParameterName} should have a trailing comma. Example usage: <${typeParameterName},>.`,
		StaticBlockCannotHaveModifier: "Static class blocks cannot have any modifier.",
		TupleOptionalAfterType: "A labeled tuple optional element must be declared using a question mark after the name and before the colon (`name?: type`), rather than after the type (`name: type?`).",
		TypeAnnotationAfterAssign: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
		TypeImportCannotSpecifyDefaultAndNamed: "A type-only import can specify a default import or named bindings, but not both.",
		TypeModifierIsUsedInTypeExports: "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement.",
		TypeModifierIsUsedInTypeImports: "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement.",
		UnexpectedParameterModifier: "A parameter property is only allowed in a constructor implementation.",
		UnexpectedReadonly: "'readonly' type modifier is only permitted on array and tuple literal types.",
		UnexpectedTypeAnnotation: "Did not expect a type annotation here.",
		UnexpectedTypeCastInParameter: "Unexpected type cast in parameter position.",
		UnsupportedImportTypeArgument: "Argument in a type import must be a string literal.",
		UnsupportedParameterPropertyKind: "A parameter property may not be declared using a binding pattern.",
		UnsupportedSignatureParameterKind: ({ type }) => `Name in a signature must be an Identifier, ObjectPattern or ArrayPattern, instead got ${type}.`,
		UsingDeclarationInAmbientContext: (kind) => `'${kind}' declarations are not allowed in ambient contexts.`
	});
	function keywordTypeFromName(value) {
		switch (value) {
			case "any": return "TSAnyKeyword";
			case "boolean": return "TSBooleanKeyword";
			case "bigint": return "TSBigIntKeyword";
			case "never": return "TSNeverKeyword";
			case "number": return "TSNumberKeyword";
			case "object": return "TSObjectKeyword";
			case "string": return "TSStringKeyword";
			case "symbol": return "TSSymbolKeyword";
			case "undefined": return "TSUndefinedKeyword";
			case "unknown": return "TSUnknownKeyword";
			default: return void 0;
		}
	}
	function tsIsAccessModifier(modifier) {
		return modifier === "private" || modifier === "public" || modifier === "protected";
	}
	function tsIsVarianceAnnotations(modifier) {
		return modifier === "in" || modifier === "out";
	}
	var typescript = (superClass) => class TypeScriptParserMixin extends superClass {
		constructor(...args) {
			super(...args);
			this.tsParseInOutModifiers = this.tsParseModifiers.bind(this, {
				allowedModifiers: ["in", "out"],
				disallowedModifiers: [
					"const",
					"public",
					"private",
					"protected",
					"readonly",
					"declare",
					"abstract",
					"override"
				],
				errorTemplate: TSErrors.InvalidModifierOnTypeParameter
			});
			this.tsParseConstModifier = this.tsParseModifiers.bind(this, {
				allowedModifiers: ["const"],
				disallowedModifiers: ["in", "out"],
				errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions
			});
			this.tsParseInOutConstModifiers = this.tsParseModifiers.bind(this, {
				allowedModifiers: [
					"in",
					"out",
					"const"
				],
				disallowedModifiers: [
					"public",
					"private",
					"protected",
					"readonly",
					"declare",
					"abstract",
					"override"
				],
				errorTemplate: TSErrors.InvalidModifierOnTypeParameter
			});
		}
		getScopeHandler() {
			return TypeScriptScopeHandler;
		}
		tsIsIdentifier() {
			return tokenIsIdentifier(this.state.type);
		}
		tsTokenCanFollowModifier() {
			return this.match(0) || this.match(5) || this.match(55) || this.match(21) || this.match(139) || this.isLiteralPropertyName();
		}
		tsNextTokenOnSameLineAndCanFollowModifier() {
			this.next();
			if (this.hasPrecedingLineBreak()) return false;
			return this.tsTokenCanFollowModifier();
		}
		tsNextTokenCanFollowModifier() {
			if (this.match(106)) {
				this.next();
				return this.tsTokenCanFollowModifier();
			}
			return this.tsNextTokenOnSameLineAndCanFollowModifier();
		}
		tsParseModifier(allowedModifiers, stopOnStartOfClassStaticBlock, hasSeenStaticModifier) {
			if (!tokenIsIdentifier(this.state.type) && this.state.type !== 58 && this.state.type !== 75) return void 0;
			const modifier = this.state.value;
			if (allowedModifiers.includes(modifier)) {
				if (hasSeenStaticModifier && this.match(106)) return void 0;
				if (stopOnStartOfClassStaticBlock && this.tsIsStartOfStaticBlocks()) return void 0;
				if (this.tsTryParse(this.tsNextTokenCanFollowModifier.bind(this))) return modifier;
			}
			return void 0;
		}
		tsParseModifiers({ allowedModifiers, disallowedModifiers, stopOnStartOfClassStaticBlock, errorTemplate = TSErrors.InvalidModifierOnTypeMember }, modified) {
			const enforceOrder = (loc, modifier, before, after) => {
				if (modifier === before && modified[after]) this.raise(TSErrors.InvalidModifiersOrder, loc, { orderedModifiers: [before, after] });
			};
			const incompatible = (loc, modifier, mod1, mod2) => {
				if (modified[mod1] && modifier === mod2 || modified[mod2] && modifier === mod1) this.raise(TSErrors.IncompatibleModifiers, loc, { modifiers: [mod1, mod2] });
			};
			for (;;) {
				const { startLoc } = this.state;
				const modifier = this.tsParseModifier(allowedModifiers.concat(disallowedModifiers != null ? disallowedModifiers : []), stopOnStartOfClassStaticBlock, modified.static);
				if (!modifier) break;
				if (tsIsAccessModifier(modifier)) if (modified.accessibility) this.raise(TSErrors.DuplicateAccessibilityModifier, startLoc, { modifier });
				else {
					enforceOrder(startLoc, modifier, modifier, "override");
					enforceOrder(startLoc, modifier, modifier, "static");
					enforceOrder(startLoc, modifier, modifier, "readonly");
					modified.accessibility = modifier;
				}
				else if (tsIsVarianceAnnotations(modifier)) {
					if (modified[modifier]) this.raise(TSErrors.DuplicateModifier, startLoc, { modifier });
					modified[modifier] = true;
					enforceOrder(startLoc, modifier, "in", "out");
				} else {
					if (hasOwnProperty.call(modified, modifier)) this.raise(TSErrors.DuplicateModifier, startLoc, { modifier });
					else {
						enforceOrder(startLoc, modifier, "static", "readonly");
						enforceOrder(startLoc, modifier, "static", "override");
						enforceOrder(startLoc, modifier, "override", "readonly");
						enforceOrder(startLoc, modifier, "abstract", "override");
						incompatible(startLoc, modifier, "declare", "override");
						incompatible(startLoc, modifier, "static", "abstract");
					}
					modified[modifier] = true;
				}
				if (disallowedModifiers != null && disallowedModifiers.includes(modifier)) this.raise(errorTemplate, startLoc, { modifier });
			}
		}
		tsIsListTerminator(kind) {
			switch (kind) {
				case "EnumMembers":
				case "TypeMembers": return this.match(8);
				case "HeritageClauseElement": return this.match(5);
				case "TupleElementTypes": return this.match(3);
				case "TypeParametersOrArguments": return this.match(48);
			}
		}
		tsParseList(kind, parseElement) {
			const result = [];
			while (!this.tsIsListTerminator(kind)) result.push(parseElement());
			return result;
		}
		tsParseDelimitedList(kind, parseElement, refTrailingCommaPos) {
			return nonNull(this.tsParseDelimitedListWorker(kind, parseElement, true, refTrailingCommaPos));
		}
		tsParseDelimitedListWorker(kind, parseElement, expectSuccess, refTrailingCommaPos) {
			const result = [];
			let trailingCommaPos = -1;
			for (;;) {
				if (this.tsIsListTerminator(kind)) break;
				trailingCommaPos = -1;
				const element = parseElement();
				if (element == null) return void 0;
				result.push(element);
				if (this.eat(12)) {
					trailingCommaPos = this.state.lastTokStartLoc.index;
					continue;
				}
				if (this.tsIsListTerminator(kind)) break;
				if (expectSuccess) this.expect(12);
				return void 0;
			}
			if (refTrailingCommaPos) refTrailingCommaPos.value = trailingCommaPos;
			return result;
		}
		tsParseBracketedList(kind, parseElement, bracket, skipFirstToken, refTrailingCommaPos) {
			if (!skipFirstToken) if (bracket) this.expect(0);
			else this.expect(47);
			const result = this.tsParseDelimitedList(kind, parseElement, refTrailingCommaPos);
			if (bracket) this.expect(3);
			else this.expect(48);
			return result;
		}
		tsParseImportType() {
			const node = this.startNode();
			this.expect(83);
			this.expect(10);
			if (!this.match(134)) {
				this.raise(TSErrors.UnsupportedImportTypeArgument, this.state.startLoc);
				node.argument = super.parseExprAtom();
			} else node.argument = this.parseStringLiteral(this.state.value);
			if (this.eat(12)) node.options = this.tsParseImportTypeOptions();
			else node.options = null;
			this.expect(11);
			if (this.eat(16)) node.qualifier = this.tsParseEntityName(3);
			if (this.match(47)) node.typeParameters = this.tsParseTypeArguments();
			return this.finishNode(node, "TSImportType");
		}
		tsParseImportTypeOptions() {
			const node = this.startNode();
			this.expect(5);
			const withProperty = this.startNode();
			if (this.isContextual(76)) {
				withProperty.method = false;
				withProperty.key = this.parseIdentifier(true);
				withProperty.computed = false;
				withProperty.shorthand = false;
			} else this.unexpected(null, 76);
			this.expect(14);
			withProperty.value = this.tsParseImportTypeWithPropertyValue();
			node.properties = [this.finishObjectProperty(withProperty)];
			this.expect(8);
			return this.finishNode(node, "ObjectExpression");
		}
		tsParseImportTypeWithPropertyValue() {
			const node = this.startNode();
			const properties = [];
			this.expect(5);
			while (!this.match(8)) {
				const type = this.state.type;
				if (tokenIsIdentifier(type) || type === 134) properties.push(super.parsePropertyDefinition(null));
				else this.unexpected();
				this.eat(12);
			}
			node.properties = properties;
			this.next();
			return this.finishNode(node, "ObjectExpression");
		}
		tsParseEntityName(flags) {
			let entity;
			if (flags & 1 && this.match(78)) if (flags & 2) entity = this.parseIdentifier(true);
			else {
				const node = this.startNode();
				this.next();
				entity = this.finishNode(node, "ThisExpression");
			}
			else entity = this.parseIdentifier(!!(flags & 1));
			while (this.eat(16)) {
				const node = this.startNodeAtNode(entity);
				node.left = entity;
				node.right = this.parseIdentifier(!!(flags & 1));
				entity = this.finishNode(node, "TSQualifiedName");
			}
			return entity;
		}
		tsParseTypeReference() {
			const node = this.startNode();
			node.typeName = this.tsParseEntityName(1);
			if (!this.hasPrecedingLineBreak() && this.match(47)) node.typeParameters = this.tsParseTypeArguments();
			return this.finishNode(node, "TSTypeReference");
		}
		tsParseThisTypePredicate(lhs) {
			this.next();
			const node = this.startNodeAtNode(lhs);
			node.parameterName = lhs;
			node.typeAnnotation = this.tsParseTypeAnnotation(false);
			node.asserts = false;
			return this.finishNode(node, "TSTypePredicate");
		}
		tsParseThisTypeNode() {
			const node = this.startNode();
			this.next();
			return this.finishNode(node, "TSThisType");
		}
		tsParseTypeQuery() {
			const node = this.startNode();
			this.expect(87);
			if (this.match(83)) node.exprName = this.tsParseImportType();
			else node.exprName = this.tsParseEntityName(3);
			if (!this.hasPrecedingLineBreak() && this.match(47)) node.typeParameters = this.tsParseTypeArguments();
			return this.finishNode(node, "TSTypeQuery");
		}
		tsParseTypeParameter(parseModifiers$1) {
			const node = this.startNode();
			parseModifiers$1(node);
			node.name = this.tsParseTypeParameterName();
			node.constraint = this.tsEatThenParseType(81);
			node.default = this.tsEatThenParseType(29);
			return this.finishNode(node, "TSTypeParameter");
		}
		tsTryParseTypeParameters(parseModifiers$1) {
			if (this.match(47)) return this.tsParseTypeParameters(parseModifiers$1);
		}
		tsParseTypeParameters(parseModifiers$1) {
			const node = this.startNode();
			if (this.match(47) || this.match(143)) this.next();
			else this.unexpected();
			const refTrailingCommaPos = { value: -1 };
			node.params = this.tsParseBracketedList("TypeParametersOrArguments", this.tsParseTypeParameter.bind(this, parseModifiers$1), false, true, refTrailingCommaPos);
			if (node.params.length === 0) this.raise(TSErrors.EmptyTypeParameters, node);
			if (refTrailingCommaPos.value !== -1) this.addExtra(node, "trailingComma", refTrailingCommaPos.value);
			return this.finishNode(node, "TSTypeParameterDeclaration");
		}
		tsFillSignature(returnToken, signature) {
			const returnTokenRequired = returnToken === 19;
			const paramsKey = "parameters";
			const returnTypeKey = "typeAnnotation";
			signature.typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
			this.expect(10);
			signature[paramsKey] = this.tsParseBindingListForSignature();
			if (returnTokenRequired) signature[returnTypeKey] = this.tsParseTypeOrTypePredicateAnnotation(returnToken);
			else if (this.match(returnToken)) signature[returnTypeKey] = this.tsParseTypeOrTypePredicateAnnotation(returnToken);
		}
		tsParseBindingListForSignature() {
			const list = super.parseBindingList(11, 41, 2);
			for (const pattern of list) {
				const { type } = pattern;
				if (type === "AssignmentPattern" || type === "TSParameterProperty") this.raise(TSErrors.UnsupportedSignatureParameterKind, pattern, { type });
			}
			return list;
		}
		tsParseTypeMemberSemicolon() {
			if (!this.eat(12) && !this.isLineTerminator()) this.expect(13);
		}
		tsParseSignatureMember(kind, node) {
			this.tsFillSignature(14, node);
			this.tsParseTypeMemberSemicolon();
			return this.finishNode(node, kind);
		}
		tsIsUnambiguouslyIndexSignature() {
			this.next();
			if (tokenIsIdentifier(this.state.type)) {
				this.next();
				return this.match(14);
			}
			return false;
		}
		tsTryParseIndexSignature(node) {
			if (!(this.match(0) && this.tsLookAhead(this.tsIsUnambiguouslyIndexSignature.bind(this)))) return;
			this.expect(0);
			const id = this.parseIdentifier();
			id.typeAnnotation = this.tsParseTypeAnnotation();
			this.resetEndLocation(id);
			this.expect(3);
			node.parameters = [id];
			const type = this.tsTryParseTypeAnnotation();
			if (type) node.typeAnnotation = type;
			this.tsParseTypeMemberSemicolon();
			return this.finishNode(node, "TSIndexSignature");
		}
		tsParsePropertyOrMethodSignature(node, readonly) {
			if (this.eat(17)) node.optional = true;
			if (this.match(10) || this.match(47)) {
				if (readonly) this.raise(TSErrors.ReadonlyForMethodSignature, node);
				const method = node;
				if (method.kind && this.match(47)) this.raise(TSErrors.AccessorCannotHaveTypeParameters, this.state.curPosition());
				this.tsFillSignature(14, method);
				this.tsParseTypeMemberSemicolon();
				const paramsKey = "parameters";
				const returnTypeKey = "typeAnnotation";
				if (method.kind === "get") {
					if (method[paramsKey].length > 0) {
						this.raise(Errors.BadGetterArity, this.state.curPosition());
						if (this.isThisParam(method[paramsKey][0])) this.raise(TSErrors.AccessorCannotDeclareThisParameter, this.state.curPosition());
					}
				} else if (method.kind === "set") {
					if (method[paramsKey].length !== 1) this.raise(Errors.BadSetterArity, this.state.curPosition());
					else {
						const firstParameter = method[paramsKey][0];
						if (this.isThisParam(firstParameter)) this.raise(TSErrors.AccessorCannotDeclareThisParameter, this.state.curPosition());
						if (firstParameter.type === "Identifier" && firstParameter.optional) this.raise(TSErrors.SetAccessorCannotHaveOptionalParameter, this.state.curPosition());
						if (firstParameter.type === "RestElement") this.raise(TSErrors.SetAccessorCannotHaveRestParameter, this.state.curPosition());
					}
					if (method[returnTypeKey]) this.raise(TSErrors.SetAccessorCannotHaveReturnType, method[returnTypeKey]);
				} else method.kind = "method";
				return this.finishNode(method, "TSMethodSignature");
			} else {
				const property = node;
				if (readonly) property.readonly = true;
				const type = this.tsTryParseTypeAnnotation();
				if (type) property.typeAnnotation = type;
				this.tsParseTypeMemberSemicolon();
				return this.finishNode(property, "TSPropertySignature");
			}
		}
		tsParseTypeMember() {
			const node = this.startNode();
			if (this.match(10) || this.match(47)) return this.tsParseSignatureMember("TSCallSignatureDeclaration", node);
			if (this.match(77)) {
				const id = this.startNode();
				this.next();
				if (this.match(10) || this.match(47)) return this.tsParseSignatureMember("TSConstructSignatureDeclaration", node);
				else {
					node.key = this.createIdentifier(id, "new");
					return this.tsParsePropertyOrMethodSignature(node, false);
				}
			}
			this.tsParseModifiers({
				allowedModifiers: ["readonly"],
				disallowedModifiers: [
					"declare",
					"abstract",
					"private",
					"protected",
					"public",
					"static",
					"override"
				]
			}, node);
			const idx = this.tsTryParseIndexSignature(node);
			if (idx) return idx;
			super.parsePropertyName(node);
			if (!node.computed && node.key.type === "Identifier" && (node.key.name === "get" || node.key.name === "set") && this.tsTokenCanFollowModifier()) {
				node.kind = node.key.name;
				super.parsePropertyName(node);
				if (!this.match(10) && !this.match(47)) this.unexpected(null, 10);
			}
			return this.tsParsePropertyOrMethodSignature(node, !!node.readonly);
		}
		tsParseTypeLiteral() {
			const node = this.startNode();
			node.members = this.tsParseObjectTypeMembers();
			return this.finishNode(node, "TSTypeLiteral");
		}
		tsParseObjectTypeMembers() {
			this.expect(5);
			const members = this.tsParseList("TypeMembers", this.tsParseTypeMember.bind(this));
			this.expect(8);
			return members;
		}
		tsIsStartOfMappedType() {
			this.next();
			if (this.eat(53)) return this.isContextual(122);
			if (this.isContextual(122)) this.next();
			if (!this.match(0)) return false;
			this.next();
			if (!this.tsIsIdentifier()) return false;
			this.next();
			return this.match(58);
		}
		tsParseMappedType() {
			const node = this.startNode();
			this.expect(5);
			if (this.match(53)) {
				node.readonly = this.state.value;
				this.next();
				this.expectContextual(122);
			} else if (this.eatContextual(122)) node.readonly = true;
			this.expect(0);
			{
				const typeParameter = this.startNode();
				typeParameter.name = this.tsParseTypeParameterName();
				typeParameter.constraint = this.tsExpectThenParseType(58);
				node.typeParameter = this.finishNode(typeParameter, "TSTypeParameter");
			}
			node.nameType = this.eatContextual(93) ? this.tsParseType() : null;
			this.expect(3);
			if (this.match(53)) {
				node.optional = this.state.value;
				this.next();
				this.expect(17);
			} else if (this.eat(17)) node.optional = true;
			node.typeAnnotation = this.tsTryParseType();
			this.semicolon();
			this.expect(8);
			return this.finishNode(node, "TSMappedType");
		}
		tsParseTupleType() {
			const node = this.startNode();
			node.elementTypes = this.tsParseBracketedList("TupleElementTypes", this.tsParseTupleElementType.bind(this), true, false);
			let seenOptionalElement = false;
			node.elementTypes.forEach((elementNode) => {
				const { type } = elementNode;
				if (seenOptionalElement && type !== "TSRestType" && type !== "TSOptionalType" && !(type === "TSNamedTupleMember" && elementNode.optional)) this.raise(TSErrors.OptionalTypeBeforeRequired, elementNode);
				seenOptionalElement || (seenOptionalElement = type === "TSNamedTupleMember" && elementNode.optional || type === "TSOptionalType");
			});
			return this.finishNode(node, "TSTupleType");
		}
		tsParseTupleElementType() {
			const restStartLoc = this.state.startLoc;
			const rest = this.eat(21);
			const { startLoc } = this.state;
			let labeled;
			let label;
			let optional;
			let type;
			const isWord = tokenIsKeywordOrIdentifier(this.state.type);
			const chAfterWord = isWord ? this.lookaheadCharCode() : null;
			if (chAfterWord === 58) {
				labeled = true;
				optional = false;
				label = this.parseIdentifier(true);
				this.expect(14);
				type = this.tsParseType();
			} else if (chAfterWord === 63) {
				optional = true;
				const wordName = this.state.value;
				const typeOrLabel = this.tsParseNonArrayType();
				if (this.lookaheadCharCode() === 58) {
					labeled = true;
					label = this.createIdentifier(this.startNodeAt(startLoc), wordName);
					this.expect(17);
					this.expect(14);
					type = this.tsParseType();
				} else {
					labeled = false;
					type = typeOrLabel;
					this.expect(17);
				}
			} else {
				type = this.tsParseType();
				optional = this.eat(17);
				labeled = this.eat(14);
			}
			if (labeled) {
				let labeledNode;
				if (label) {
					labeledNode = this.startNodeAt(startLoc);
					labeledNode.optional = optional;
					labeledNode.label = label;
					labeledNode.elementType = type;
					if (this.eat(17)) {
						labeledNode.optional = true;
						this.raise(TSErrors.TupleOptionalAfterType, this.state.lastTokStartLoc);
					}
				} else {
					labeledNode = this.startNodeAt(startLoc);
					labeledNode.optional = optional;
					this.raise(TSErrors.InvalidTupleMemberLabel, type);
					labeledNode.label = type;
					labeledNode.elementType = this.tsParseType();
				}
				type = this.finishNode(labeledNode, "TSNamedTupleMember");
			} else if (optional) {
				const optionalTypeNode = this.startNodeAt(startLoc);
				optionalTypeNode.typeAnnotation = type;
				type = this.finishNode(optionalTypeNode, "TSOptionalType");
			}
			if (rest) {
				const restNode = this.startNodeAt(restStartLoc);
				restNode.typeAnnotation = type;
				type = this.finishNode(restNode, "TSRestType");
			}
			return type;
		}
		tsParseParenthesizedType() {
			const node = this.startNode();
			this.expect(10);
			node.typeAnnotation = this.tsParseType();
			this.expect(11);
			return this.finishNode(node, "TSParenthesizedType");
		}
		tsParseFunctionOrConstructorType(type, abstract) {
			const node = this.startNode();
			if (type === "TSConstructorType") {
				node.abstract = !!abstract;
				if (abstract) this.next();
				this.next();
			}
			this.tsInAllowConditionalTypesContext(() => this.tsFillSignature(19, node));
			return this.finishNode(node, type);
		}
		tsParseLiteralTypeNode() {
			const node = this.startNode();
			switch (this.state.type) {
				case 135:
				case 136:
				case 134:
				case 85:
				case 86:
					node.literal = super.parseExprAtom();
					break;
				default: this.unexpected();
			}
			return this.finishNode(node, "TSLiteralType");
		}
		tsParseTemplateLiteralType() {
			{
				const node = this.startNode();
				node.literal = super.parseTemplate(false);
				return this.finishNode(node, "TSLiteralType");
			}
		}
		parseTemplateSubstitution() {
			if (this.state.inType) return this.tsParseType();
			return super.parseTemplateSubstitution();
		}
		tsParseThisTypeOrThisTypePredicate() {
			const thisKeyword = this.tsParseThisTypeNode();
			if (this.isContextual(116) && !this.hasPrecedingLineBreak()) return this.tsParseThisTypePredicate(thisKeyword);
			else return thisKeyword;
		}
		tsParseNonArrayType() {
			switch (this.state.type) {
				case 134:
				case 135:
				case 136:
				case 85:
				case 86: return this.tsParseLiteralTypeNode();
				case 53:
					if (this.state.value === "-") {
						const node = this.startNode();
						const nextToken = this.lookahead();
						if (nextToken.type !== 135 && nextToken.type !== 136) this.unexpected();
						node.literal = this.parseMaybeUnary();
						return this.finishNode(node, "TSLiteralType");
					}
					break;
				case 78: return this.tsParseThisTypeOrThisTypePredicate();
				case 87: return this.tsParseTypeQuery();
				case 83: return this.tsParseImportType();
				case 5: return this.tsLookAhead(this.tsIsStartOfMappedType.bind(this)) ? this.tsParseMappedType() : this.tsParseTypeLiteral();
				case 0: return this.tsParseTupleType();
				case 10: return this.tsParseParenthesizedType();
				case 25:
				case 24: return this.tsParseTemplateLiteralType();
				default: {
					const { type } = this.state;
					if (tokenIsIdentifier(type) || type === 88 || type === 84) {
						const nodeType = type === 88 ? "TSVoidKeyword" : type === 84 ? "TSNullKeyword" : keywordTypeFromName(this.state.value);
						if (nodeType !== void 0 && this.lookaheadCharCode() !== 46) {
							const node = this.startNode();
							this.next();
							return this.finishNode(node, nodeType);
						}
						return this.tsParseTypeReference();
					}
				}
			}
			this.unexpected();
		}
		tsParseArrayTypeOrHigher() {
			const { startLoc } = this.state;
			let type = this.tsParseNonArrayType();
			while (!this.hasPrecedingLineBreak() && this.eat(0)) if (this.match(3)) {
				const node = this.startNodeAt(startLoc);
				node.elementType = type;
				this.expect(3);
				type = this.finishNode(node, "TSArrayType");
			} else {
				const node = this.startNodeAt(startLoc);
				node.objectType = type;
				node.indexType = this.tsParseType();
				this.expect(3);
				type = this.finishNode(node, "TSIndexedAccessType");
			}
			return type;
		}
		tsParseTypeOperator() {
			const node = this.startNode();
			const operator = this.state.value;
			this.next();
			node.operator = operator;
			node.typeAnnotation = this.tsParseTypeOperatorOrHigher();
			if (operator === "readonly") this.tsCheckTypeAnnotationForReadOnly(node);
			return this.finishNode(node, "TSTypeOperator");
		}
		tsCheckTypeAnnotationForReadOnly(node) {
			switch (node.typeAnnotation.type) {
				case "TSTupleType":
				case "TSArrayType": return;
				default: this.raise(TSErrors.UnexpectedReadonly, node);
			}
		}
		tsParseInferType() {
			const node = this.startNode();
			this.expectContextual(115);
			const typeParameter = this.startNode();
			typeParameter.name = this.tsParseTypeParameterName();
			typeParameter.constraint = this.tsTryParse(() => this.tsParseConstraintForInferType());
			node.typeParameter = this.finishNode(typeParameter, "TSTypeParameter");
			return this.finishNode(node, "TSInferType");
		}
		tsParseConstraintForInferType() {
			if (this.eat(81)) {
				const constraint = this.tsInDisallowConditionalTypesContext(() => this.tsParseType());
				if (this.state.inDisallowConditionalTypesContext || !this.match(17)) return constraint;
			}
		}
		tsParseTypeOperatorOrHigher() {
			const isTypeOperator = tokenIsTSTypeOperator(this.state.type) && !this.state.containsEsc;
			return isTypeOperator ? this.tsParseTypeOperator() : this.isContextual(115) ? this.tsParseInferType() : this.tsInAllowConditionalTypesContext(() => this.tsParseArrayTypeOrHigher());
		}
		tsParseUnionOrIntersectionType(kind, parseConstituentType, operator) {
			const node = this.startNode();
			const hasLeadingOperator = this.eat(operator);
			const types$2 = [];
			do
				types$2.push(parseConstituentType());
			while (this.eat(operator));
			if (types$2.length === 1 && !hasLeadingOperator) return types$2[0];
			node.types = types$2;
			return this.finishNode(node, kind);
		}
		tsParseIntersectionTypeOrHigher() {
			return this.tsParseUnionOrIntersectionType("TSIntersectionType", this.tsParseTypeOperatorOrHigher.bind(this), 45);
		}
		tsParseUnionTypeOrHigher() {
			return this.tsParseUnionOrIntersectionType("TSUnionType", this.tsParseIntersectionTypeOrHigher.bind(this), 43);
		}
		tsIsStartOfFunctionType() {
			if (this.match(47)) return true;
			return this.match(10) && this.tsLookAhead(this.tsIsUnambiguouslyStartOfFunctionType.bind(this));
		}
		tsSkipParameterStart() {
			if (tokenIsIdentifier(this.state.type) || this.match(78)) {
				this.next();
				return true;
			}
			if (this.match(5)) {
				const { errors } = this.state;
				const previousErrorCount = errors.length;
				try {
					this.parseObjectLike(8, true);
					return errors.length === previousErrorCount;
				} catch (_unused) {
					return false;
				}
			}
			if (this.match(0)) {
				this.next();
				const { errors } = this.state;
				const previousErrorCount = errors.length;
				try {
					super.parseBindingList(3, 93, 1);
					return errors.length === previousErrorCount;
				} catch (_unused2) {
					return false;
				}
			}
			return false;
		}
		tsIsUnambiguouslyStartOfFunctionType() {
			this.next();
			if (this.match(11) || this.match(21)) return true;
			if (this.tsSkipParameterStart()) {
				if (this.match(14) || this.match(12) || this.match(17) || this.match(29)) return true;
				if (this.match(11)) {
					this.next();
					if (this.match(19)) return true;
				}
			}
			return false;
		}
		tsParseTypeOrTypePredicateAnnotation(returnToken) {
			return this.tsInType(() => {
				const t = this.startNode();
				this.expect(returnToken);
				const node = this.startNode();
				const asserts = !!this.tsTryParse(this.tsParseTypePredicateAsserts.bind(this));
				if (asserts && this.match(78)) {
					let thisTypePredicate = this.tsParseThisTypeOrThisTypePredicate();
					if (thisTypePredicate.type === "TSThisType") {
						node.parameterName = thisTypePredicate;
						node.asserts = true;
						node.typeAnnotation = null;
						thisTypePredicate = this.finishNode(node, "TSTypePredicate");
					} else {
						this.resetStartLocationFromNode(thisTypePredicate, node);
						thisTypePredicate.asserts = true;
					}
					t.typeAnnotation = thisTypePredicate;
					return this.finishNode(t, "TSTypeAnnotation");
				}
				const typePredicateVariable = this.tsIsIdentifier() && this.tsTryParse(this.tsParseTypePredicatePrefix.bind(this));
				if (!typePredicateVariable) {
					if (!asserts) return this.tsParseTypeAnnotation(false, t);
					node.parameterName = this.parseIdentifier();
					node.asserts = asserts;
					node.typeAnnotation = null;
					t.typeAnnotation = this.finishNode(node, "TSTypePredicate");
					return this.finishNode(t, "TSTypeAnnotation");
				}
				const type = this.tsParseTypeAnnotation(false);
				node.parameterName = typePredicateVariable;
				node.typeAnnotation = type;
				node.asserts = asserts;
				t.typeAnnotation = this.finishNode(node, "TSTypePredicate");
				return this.finishNode(t, "TSTypeAnnotation");
			});
		}
		tsTryParseTypeOrTypePredicateAnnotation() {
			if (this.match(14)) return this.tsParseTypeOrTypePredicateAnnotation(14);
		}
		tsTryParseTypeAnnotation() {
			if (this.match(14)) return this.tsParseTypeAnnotation();
		}
		tsTryParseType() {
			return this.tsEatThenParseType(14);
		}
		tsParseTypePredicatePrefix() {
			const id = this.parseIdentifier();
			if (this.isContextual(116) && !this.hasPrecedingLineBreak()) {
				this.next();
				return id;
			}
		}
		tsParseTypePredicateAsserts() {
			if (this.state.type !== 109) return false;
			const containsEsc = this.state.containsEsc;
			this.next();
			if (!tokenIsIdentifier(this.state.type) && !this.match(78)) return false;
			if (containsEsc) this.raise(Errors.InvalidEscapedReservedWord, this.state.lastTokStartLoc, { reservedWord: "asserts" });
			return true;
		}
		tsParseTypeAnnotation(eatColon = true, t = this.startNode()) {
			this.tsInType(() => {
				if (eatColon) this.expect(14);
				t.typeAnnotation = this.tsParseType();
			});
			return this.finishNode(t, "TSTypeAnnotation");
		}
		tsParseType() {
			assert$1(this.state.inType);
			const type = this.tsParseNonConditionalType();
			if (this.state.inDisallowConditionalTypesContext || this.hasPrecedingLineBreak() || !this.eat(81)) return type;
			const node = this.startNodeAtNode(type);
			node.checkType = type;
			node.extendsType = this.tsInDisallowConditionalTypesContext(() => this.tsParseNonConditionalType());
			this.expect(17);
			node.trueType = this.tsInAllowConditionalTypesContext(() => this.tsParseType());
			this.expect(14);
			node.falseType = this.tsInAllowConditionalTypesContext(() => this.tsParseType());
			return this.finishNode(node, "TSConditionalType");
		}
		isAbstractConstructorSignature() {
			return this.isContextual(124) && this.isLookaheadContextual("new");
		}
		tsParseNonConditionalType() {
			if (this.tsIsStartOfFunctionType()) return this.tsParseFunctionOrConstructorType("TSFunctionType");
			if (this.match(77)) return this.tsParseFunctionOrConstructorType("TSConstructorType");
			else if (this.isAbstractConstructorSignature()) return this.tsParseFunctionOrConstructorType("TSConstructorType", true);
			return this.tsParseUnionTypeOrHigher();
		}
		tsParseTypeAssertion() {
			if (this.getPluginOption("typescript", "disallowAmbiguousJSXLike")) this.raise(TSErrors.ReservedTypeAssertion, this.state.startLoc);
			const node = this.startNode();
			node.typeAnnotation = this.tsInType(() => {
				this.next();
				return this.match(75) ? this.tsParseTypeReference() : this.tsParseType();
			});
			this.expect(48);
			node.expression = this.parseMaybeUnary();
			return this.finishNode(node, "TSTypeAssertion");
		}
		tsParseHeritageClause(token) {
			const originalStartLoc = this.state.startLoc;
			const delimitedList = this.tsParseDelimitedList("HeritageClauseElement", () => {
				{
					const node = this.startNode();
					node.expression = this.tsParseEntityName(3);
					if (this.match(47)) node.typeParameters = this.tsParseTypeArguments();
					return this.finishNode(node, "TSExpressionWithTypeArguments");
				}
			});
			if (!delimitedList.length) this.raise(TSErrors.EmptyHeritageClauseType, originalStartLoc, { token });
			return delimitedList;
		}
		tsParseInterfaceDeclaration(node, properties = {}) {
			if (this.hasFollowingLineBreak()) return null;
			this.expectContextual(129);
			if (properties.declare) node.declare = true;
			if (tokenIsIdentifier(this.state.type)) {
				node.id = this.parseIdentifier();
				this.checkIdentifier(node.id, 130);
			} else {
				node.id = null;
				this.raise(TSErrors.MissingInterfaceName, this.state.startLoc);
			}
			node.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers);
			if (this.eat(81)) node.extends = this.tsParseHeritageClause("extends");
			const body = this.startNode();
			body.body = this.tsInType(this.tsParseObjectTypeMembers.bind(this));
			node.body = this.finishNode(body, "TSInterfaceBody");
			return this.finishNode(node, "TSInterfaceDeclaration");
		}
		tsParseTypeAliasDeclaration(node) {
			node.id = this.parseIdentifier();
			this.checkIdentifier(node.id, 2);
			node.typeAnnotation = this.tsInType(() => {
				node.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutModifiers);
				this.expect(29);
				if (this.isContextual(114) && this.lookaheadCharCode() !== 46) {
					const node$1 = this.startNode();
					this.next();
					return this.finishNode(node$1, "TSIntrinsicKeyword");
				}
				return this.tsParseType();
			});
			this.semicolon();
			return this.finishNode(node, "TSTypeAliasDeclaration");
		}
		tsInTopLevelContext(cb) {
			if (this.curContext() !== types$1.brace) {
				const oldContext = this.state.context;
				this.state.context = [oldContext[0]];
				try {
					return cb();
				} finally {
					this.state.context = oldContext;
				}
			} else return cb();
		}
		tsInType(cb) {
			const oldInType = this.state.inType;
			this.state.inType = true;
			try {
				return cb();
			} finally {
				this.state.inType = oldInType;
			}
		}
		tsInDisallowConditionalTypesContext(cb) {
			const oldInDisallowConditionalTypesContext = this.state.inDisallowConditionalTypesContext;
			this.state.inDisallowConditionalTypesContext = true;
			try {
				return cb();
			} finally {
				this.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
			}
		}
		tsInAllowConditionalTypesContext(cb) {
			const oldInDisallowConditionalTypesContext = this.state.inDisallowConditionalTypesContext;
			this.state.inDisallowConditionalTypesContext = false;
			try {
				return cb();
			} finally {
				this.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
			}
		}
		tsEatThenParseType(token) {
			if (this.match(token)) return this.tsNextThenParseType();
		}
		tsExpectThenParseType(token) {
			return this.tsInType(() => {
				this.expect(token);
				return this.tsParseType();
			});
		}
		tsNextThenParseType() {
			return this.tsInType(() => {
				this.next();
				return this.tsParseType();
			});
		}
		tsParseEnumMember() {
			const node = this.startNode();
			node.id = this.match(134) ? super.parseStringLiteral(this.state.value) : this.parseIdentifier(true);
			if (this.eat(29)) node.initializer = super.parseMaybeAssignAllowIn();
			return this.finishNode(node, "TSEnumMember");
		}
		tsParseEnumDeclaration(node, properties = {}) {
			if (properties.const) node.const = true;
			if (properties.declare) node.declare = true;
			this.expectContextual(126);
			node.id = this.parseIdentifier();
			this.checkIdentifier(node.id, node.const ? 8971 : 8459);
			{
				this.expect(5);
				node.members = this.tsParseDelimitedList("EnumMembers", this.tsParseEnumMember.bind(this));
				this.expect(8);
			}
			return this.finishNode(node, "TSEnumDeclaration");
		}
		tsParseEnumBody() {
			const node = this.startNode();
			this.expect(5);
			node.members = this.tsParseDelimitedList("EnumMembers", this.tsParseEnumMember.bind(this));
			this.expect(8);
			return this.finishNode(node, "TSEnumBody");
		}
		tsParseModuleBlock() {
			const node = this.startNode();
			this.scope.enter(0);
			this.expect(5);
			super.parseBlockOrModuleBlockBody(node.body = [], void 0, true, 8);
			this.scope.exit();
			return this.finishNode(node, "TSModuleBlock");
		}
		tsParseModuleOrNamespaceDeclaration(node, nested = false) {
			node.id = this.parseIdentifier();
			if (!nested) this.checkIdentifier(node.id, 1024);
			if (this.eat(16)) {
				const inner = this.startNode();
				this.tsParseModuleOrNamespaceDeclaration(inner, true);
				node.body = inner;
			} else {
				this.scope.enter(1024);
				this.prodParam.enter(0);
				node.body = this.tsParseModuleBlock();
				this.prodParam.exit();
				this.scope.exit();
			}
			return this.finishNode(node, "TSModuleDeclaration");
		}
		tsParseAmbientExternalModuleDeclaration(node) {
			if (this.isContextual(112)) {
				node.kind = "global";
				node.global = true;
				node.id = this.parseIdentifier();
			} else if (this.match(134)) {
				node.kind = "module";
				node.id = super.parseStringLiteral(this.state.value);
			} else this.unexpected();
			if (this.match(5)) {
				this.scope.enter(1024);
				this.prodParam.enter(0);
				node.body = this.tsParseModuleBlock();
				this.prodParam.exit();
				this.scope.exit();
			} else this.semicolon();
			return this.finishNode(node, "TSModuleDeclaration");
		}
		tsParseImportEqualsDeclaration(node, maybeDefaultIdentifier, isExport) {
			node.isExport = isExport || false;
			node.id = maybeDefaultIdentifier || this.parseIdentifier();
			this.checkIdentifier(node.id, 4096);
			this.expect(29);
			const moduleReference = this.tsParseModuleReference();
			if (node.importKind === "type" && moduleReference.type !== "TSExternalModuleReference") this.raise(TSErrors.ImportAliasHasImportType, moduleReference);
			node.moduleReference = moduleReference;
			this.semicolon();
			return this.finishNode(node, "TSImportEqualsDeclaration");
		}
		tsIsExternalModuleReference() {
			return this.isContextual(119) && this.lookaheadCharCode() === 40;
		}
		tsParseModuleReference() {
			return this.tsIsExternalModuleReference() ? this.tsParseExternalModuleReference() : this.tsParseEntityName(0);
		}
		tsParseExternalModuleReference() {
			const node = this.startNode();
			this.expectContextual(119);
			this.expect(10);
			if (!this.match(134)) this.unexpected();
			node.expression = super.parseExprAtom();
			this.expect(11);
			this.sawUnambiguousESM = true;
			return this.finishNode(node, "TSExternalModuleReference");
		}
		tsLookAhead(f) {
			const state = this.state.clone();
			const res = f();
			this.state = state;
			return res;
		}
		tsTryParseAndCatch(f) {
			const result = this.tryParse((abort) => f() || abort());
			if (result.aborted || !result.node) return;
			if (result.error) this.state = result.failState;
			return result.node;
		}
		tsTryParse(f) {
			const state = this.state.clone();
			const result = f();
			if (result !== void 0 && result !== false) return result;
			this.state = state;
		}
		tsTryParseDeclare(node) {
			if (this.isLineTerminator()) return;
			const startType = this.state.type;
			return this.tsInAmbientContext(() => {
				switch (startType) {
					case 68:
						node.declare = true;
						return super.parseFunctionStatement(node, false, false);
					case 80:
						node.declare = true;
						return this.parseClass(node, true, false);
					case 126: return this.tsParseEnumDeclaration(node, { declare: true });
					case 112: return this.tsParseAmbientExternalModuleDeclaration(node);
					case 100: if (this.state.containsEsc) return;
					case 75:
					case 74:
						if (!this.match(75) || !this.isLookaheadContextual("enum")) {
							node.declare = true;
							return this.parseVarStatement(node, this.state.value, true);
						}
						this.expect(75);
						return this.tsParseEnumDeclaration(node, {
							const: true,
							declare: true
						});
					case 107:
						if (this.isUsing()) {
							this.raise(TSErrors.InvalidModifierOnUsingDeclaration, this.state.startLoc, "declare");
							node.declare = true;
							return this.parseVarStatement(node, "using", true);
						}
						break;
					case 96:
						if (this.isAwaitUsing()) {
							this.raise(TSErrors.InvalidModifierOnAwaitUsingDeclaration, this.state.startLoc, "declare");
							node.declare = true;
							this.next();
							return this.parseVarStatement(node, "await using", true);
						}
						break;
					case 129: {
						const result = this.tsParseInterfaceDeclaration(node, { declare: true });
						if (result) return result;
					}
					default: if (tokenIsIdentifier(startType)) return this.tsParseDeclaration(node, this.state.value, true, null);
				}
			});
		}
		tsTryParseExportDeclaration() {
			return this.tsParseDeclaration(this.startNode(), this.state.value, true, null);
		}
		tsParseExpressionStatement(node, expr, decorators) {
			switch (expr.name) {
				case "declare": {
					const declaration = this.tsTryParseDeclare(node);
					if (declaration) declaration.declare = true;
					return declaration;
				}
				case "global":
					if (this.match(5)) {
						this.scope.enter(1024);
						this.prodParam.enter(0);
						const mod = node;
						mod.kind = "global";
						node.global = true;
						mod.id = expr;
						mod.body = this.tsParseModuleBlock();
						this.scope.exit();
						this.prodParam.exit();
						return this.finishNode(mod, "TSModuleDeclaration");
					}
					break;
				default: return this.tsParseDeclaration(node, expr.name, false, decorators);
			}
		}
		tsParseDeclaration(node, value, next$1, decorators) {
			switch (value) {
				case "abstract":
					if (this.tsCheckLineTerminator(next$1) && (this.match(80) || tokenIsIdentifier(this.state.type))) return this.tsParseAbstractDeclaration(node, decorators);
					break;
				case "module":
					if (this.tsCheckLineTerminator(next$1)) {
						if (this.match(134)) return this.tsParseAmbientExternalModuleDeclaration(node);
						else if (tokenIsIdentifier(this.state.type)) {
							node.kind = "module";
							return this.tsParseModuleOrNamespaceDeclaration(node);
						}
					}
					break;
				case "namespace":
					if (this.tsCheckLineTerminator(next$1) && tokenIsIdentifier(this.state.type)) {
						node.kind = "namespace";
						return this.tsParseModuleOrNamespaceDeclaration(node);
					}
					break;
				case "type":
					if (this.tsCheckLineTerminator(next$1) && tokenIsIdentifier(this.state.type)) return this.tsParseTypeAliasDeclaration(node);
					break;
			}
		}
		tsCheckLineTerminator(next$1) {
			if (next$1) {
				if (this.hasFollowingLineBreak()) return false;
				this.next();
				return true;
			}
			return !this.isLineTerminator();
		}
		tsTryParseGenericAsyncArrowFunction(startLoc) {
			if (!this.match(47)) return;
			const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
			this.state.maybeInArrowParameters = true;
			const res = this.tsTryParseAndCatch(() => {
				const node = this.startNodeAt(startLoc);
				node.typeParameters = this.tsParseTypeParameters(this.tsParseConstModifier);
				super.parseFunctionParams(node);
				node.returnType = this.tsTryParseTypeOrTypePredicateAnnotation();
				this.expect(19);
				return node;
			});
			this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
			if (!res) return;
			return super.parseArrowExpression(res, null, true);
		}
		tsParseTypeArgumentsInExpression() {
			if (this.reScan_lt() !== 47) return;
			return this.tsParseTypeArguments();
		}
		tsParseTypeArguments() {
			const node = this.startNode();
			node.params = this.tsInType(() => this.tsInTopLevelContext(() => {
				this.expect(47);
				return this.tsParseDelimitedList("TypeParametersOrArguments", this.tsParseType.bind(this));
			}));
			if (node.params.length === 0) this.raise(TSErrors.EmptyTypeArguments, node);
			else if (!this.state.inType && this.curContext() === types$1.brace) this.reScan_lt_gt();
			this.expect(48);
			return this.finishNode(node, "TSTypeParameterInstantiation");
		}
		tsIsDeclarationStart() {
			return tokenIsTSDeclarationStart(this.state.type);
		}
		isExportDefaultSpecifier() {
			if (this.tsIsDeclarationStart()) return false;
			return super.isExportDefaultSpecifier();
		}
		parseBindingElement(flags, decorators) {
			const startLoc = decorators.length ? decorators[0].loc.start : this.state.startLoc;
			const modified = {};
			this.tsParseModifiers({ allowedModifiers: [
				"public",
				"private",
				"protected",
				"override",
				"readonly"
			] }, modified);
			const accessibility = modified.accessibility;
			const override = modified.override;
			const readonly = modified.readonly;
			if (!(flags & 4) && (accessibility || readonly || override)) this.raise(TSErrors.UnexpectedParameterModifier, startLoc);
			const left = this.parseMaybeDefault();
			if (flags & 2) this.parseFunctionParamType(left);
			const elt = this.parseMaybeDefault(left.loc.start, left);
			if (accessibility || readonly || override) {
				const pp = this.startNodeAt(startLoc);
				if (decorators.length) pp.decorators = decorators;
				if (accessibility) pp.accessibility = accessibility;
				if (readonly) pp.readonly = readonly;
				if (override) pp.override = override;
				if (elt.type !== "Identifier" && elt.type !== "AssignmentPattern") this.raise(TSErrors.UnsupportedParameterPropertyKind, pp);
				pp.parameter = elt;
				return this.finishNode(pp, "TSParameterProperty");
			}
			if (decorators.length) left.decorators = decorators;
			return elt;
		}
		isSimpleParameter(node) {
			return node.type === "TSParameterProperty" && super.isSimpleParameter(node.parameter) || super.isSimpleParameter(node);
		}
		tsDisallowOptionalPattern(node) {
			for (const param of node.params) if (param.type !== "Identifier" && param.optional && !this.state.isAmbientContext) this.raise(TSErrors.PatternIsOptional, param);
		}
		setArrowFunctionParameters(node, params, trailingCommaLoc) {
			super.setArrowFunctionParameters(node, params, trailingCommaLoc);
			this.tsDisallowOptionalPattern(node);
		}
		parseFunctionBodyAndFinish(node, type, isMethod = false) {
			if (this.match(14)) node.returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
			const bodilessType = type === "FunctionDeclaration" ? "TSDeclareFunction" : type === "ClassMethod" || type === "ClassPrivateMethod" ? "TSDeclareMethod" : void 0;
			if (bodilessType && !this.match(5) && this.isLineTerminator()) return this.finishNode(node, bodilessType);
			if (bodilessType === "TSDeclareFunction" && this.state.isAmbientContext) {
				this.raise(TSErrors.DeclareFunctionHasImplementation, node);
				if (node.declare) return super.parseFunctionBodyAndFinish(node, bodilessType, isMethod);
			}
			this.tsDisallowOptionalPattern(node);
			return super.parseFunctionBodyAndFinish(node, type, isMethod);
		}
		registerFunctionStatementId(node) {
			if (!node.body && node.id) this.checkIdentifier(node.id, 1024);
			else super.registerFunctionStatementId(node);
		}
		tsCheckForInvalidTypeCasts(items) {
			items.forEach((node) => {
				if ((node == null ? void 0 : node.type) === "TSTypeCastExpression") this.raise(TSErrors.UnexpectedTypeAnnotation, node.typeAnnotation);
			});
		}
		toReferencedList(exprList, isInParens) {
			this.tsCheckForInvalidTypeCasts(exprList);
			return exprList;
		}
		parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
			const node = super.parseArrayLike(close, canBePattern, isTuple, refExpressionErrors);
			if (node.type === "ArrayExpression") this.tsCheckForInvalidTypeCasts(node.elements);
			return node;
		}
		parseSubscript(base, startLoc, noCalls, state) {
			if (!this.hasPrecedingLineBreak() && this.match(35)) {
				this.state.canStartJSXElement = false;
				this.next();
				const nonNullExpression = this.startNodeAt(startLoc);
				nonNullExpression.expression = base;
				return this.finishNode(nonNullExpression, "TSNonNullExpression");
			}
			let isOptionalCall = false;
			if (this.match(18) && this.lookaheadCharCode() === 60) {
				if (noCalls) {
					state.stop = true;
					return base;
				}
				state.optionalChainMember = isOptionalCall = true;
				this.next();
			}
			if (this.match(47) || this.match(51)) {
				let missingParenErrorLoc;
				const result = this.tsTryParseAndCatch(() => {
					if (!noCalls && this.atPossibleAsyncArrow(base)) {
						const asyncArrowFn = this.tsTryParseGenericAsyncArrowFunction(startLoc);
						if (asyncArrowFn) return asyncArrowFn;
					}
					const typeArguments = this.tsParseTypeArgumentsInExpression();
					if (!typeArguments) return;
					if (isOptionalCall && !this.match(10)) {
						missingParenErrorLoc = this.state.curPosition();
						return;
					}
					if (tokenIsTemplate(this.state.type)) {
						const result$1 = super.parseTaggedTemplateExpression(base, startLoc, state);
						result$1.typeParameters = typeArguments;
						return result$1;
					}
					if (!noCalls && this.eat(10)) {
						const node$1 = this.startNodeAt(startLoc);
						node$1.callee = base;
						node$1.arguments = this.parseCallExpressionArguments();
						this.tsCheckForInvalidTypeCasts(node$1.arguments);
						node$1.typeParameters = typeArguments;
						if (state.optionalChainMember) node$1.optional = isOptionalCall;
						return this.finishCallExpression(node$1, state.optionalChainMember);
					}
					const tokenType = this.state.type;
					if (tokenType === 48 || tokenType === 52 || tokenType !== 10 && tokenCanStartExpression(tokenType) && !this.hasPrecedingLineBreak()) return;
					const node = this.startNodeAt(startLoc);
					node.expression = base;
					node.typeParameters = typeArguments;
					return this.finishNode(node, "TSInstantiationExpression");
				});
				if (missingParenErrorLoc) this.unexpected(missingParenErrorLoc, 10);
				if (result) {
					if (result.type === "TSInstantiationExpression") {
						if (this.match(16) || this.match(18) && this.lookaheadCharCode() !== 40) this.raise(TSErrors.InvalidPropertyAccessAfterInstantiationExpression, this.state.startLoc);
						if (!this.match(16) && !this.match(18)) result.expression = super.stopParseSubscript(base, state);
					}
					return result;
				}
			}
			return super.parseSubscript(base, startLoc, noCalls, state);
		}
		parseNewCallee(node) {
			var _callee$extra;
			super.parseNewCallee(node);
			const { callee } = node;
			if (callee.type === "TSInstantiationExpression" && !((_callee$extra = callee.extra) != null && _callee$extra.parenthesized)) {
				node.typeParameters = callee.typeParameters;
				node.callee = callee.expression;
			}
		}
		parseExprOp(left, leftStartLoc, minPrec) {
			let isSatisfies;
			if (tokenOperatorPrecedence(58) > minPrec && !this.hasPrecedingLineBreak() && (this.isContextual(93) || (isSatisfies = this.isContextual(120)))) {
				const node = this.startNodeAt(leftStartLoc);
				node.expression = left;
				node.typeAnnotation = this.tsInType(() => {
					this.next();
					if (this.match(75)) {
						if (isSatisfies) this.raise(Errors.UnexpectedKeyword, this.state.startLoc, { keyword: "const" });
						return this.tsParseTypeReference();
					}
					return this.tsParseType();
				});
				this.finishNode(node, isSatisfies ? "TSSatisfiesExpression" : "TSAsExpression");
				this.reScan_lt_gt();
				return this.parseExprOp(node, leftStartLoc, minPrec);
			}
			return super.parseExprOp(left, leftStartLoc, minPrec);
		}
		checkReservedWord(word, startLoc, checkKeywords, isBinding) {
			if (!this.state.isAmbientContext) super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
		}
		checkImportReflection(node) {
			super.checkImportReflection(node);
			if (node.module && node.importKind !== "value") this.raise(TSErrors.ImportReflectionHasImportType, node.specifiers[0].loc.start);
		}
		checkDuplicateExports() {}
		isPotentialImportPhase(isExport) {
			if (super.isPotentialImportPhase(isExport)) return true;
			if (this.isContextual(130)) {
				const ch = this.lookaheadCharCode();
				return isExport ? ch === 123 || ch === 42 : ch !== 61;
			}
			return !isExport && this.isContextual(87);
		}
		applyImportPhase(node, isExport, phase, loc) {
			super.applyImportPhase(node, isExport, phase, loc);
			if (isExport) node.exportKind = phase === "type" ? "type" : "value";
			else node.importKind = phase === "type" || phase === "typeof" ? phase : "value";
		}
		parseImport(node) {
			if (this.match(134)) {
				node.importKind = "value";
				return super.parseImport(node);
			}
			let importNode;
			if (tokenIsIdentifier(this.state.type) && this.lookaheadCharCode() === 61) {
				node.importKind = "value";
				return this.tsParseImportEqualsDeclaration(node);
			} else if (this.isContextual(130)) {
				const maybeDefaultIdentifier = this.parseMaybeImportPhase(node, false);
				if (this.lookaheadCharCode() === 61) return this.tsParseImportEqualsDeclaration(node, maybeDefaultIdentifier);
				else importNode = super.parseImportSpecifiersAndAfter(node, maybeDefaultIdentifier);
			} else importNode = super.parseImport(node);
			if (importNode.importKind === "type" && importNode.specifiers.length > 1 && importNode.specifiers[0].type === "ImportDefaultSpecifier") this.raise(TSErrors.TypeImportCannotSpecifyDefaultAndNamed, importNode);
			return importNode;
		}
		parseExport(node, decorators) {
			if (this.match(83)) {
				const nodeImportEquals = node;
				this.next();
				let maybeDefaultIdentifier = null;
				if (this.isContextual(130) && this.isPotentialImportPhase(false)) maybeDefaultIdentifier = this.parseMaybeImportPhase(nodeImportEquals, false);
				else nodeImportEquals.importKind = "value";
				const declaration = this.tsParseImportEqualsDeclaration(nodeImportEquals, maybeDefaultIdentifier, true);
				return declaration;
			} else if (this.eat(29)) {
				const assign = node;
				assign.expression = super.parseExpression();
				this.semicolon();
				this.sawUnambiguousESM = true;
				return this.finishNode(assign, "TSExportAssignment");
			} else if (this.eatContextual(93)) {
				const decl = node;
				this.expectContextual(128);
				decl.id = this.parseIdentifier();
				this.semicolon();
				return this.finishNode(decl, "TSNamespaceExportDeclaration");
			} else return super.parseExport(node, decorators);
		}
		isAbstractClass() {
			return this.isContextual(124) && this.isLookaheadContextual("class");
		}
		parseExportDefaultExpression() {
			if (this.isAbstractClass()) {
				const cls = this.startNode();
				this.next();
				cls.abstract = true;
				return this.parseClass(cls, true, true);
			}
			if (this.match(129)) {
				const result = this.tsParseInterfaceDeclaration(this.startNode());
				if (result) return result;
			}
			return super.parseExportDefaultExpression();
		}
		parseVarStatement(node, kind, allowMissingInitializer = false) {
			const { isAmbientContext } = this.state;
			const declaration = super.parseVarStatement(node, kind, allowMissingInitializer || isAmbientContext);
			if (!isAmbientContext) return declaration;
			if (!node.declare && (kind === "using" || kind === "await using")) {
				this.raiseOverwrite(TSErrors.UsingDeclarationInAmbientContext, node, kind);
				return declaration;
			}
			for (const { id, init } of declaration.declarations) {
				if (!init) continue;
				if (kind === "var" || kind === "let" || !!id.typeAnnotation) this.raise(TSErrors.InitializerNotAllowedInAmbientContext, init);
				else if (!isValidAmbientConstInitializer(init, this.hasPlugin("estree"))) this.raise(TSErrors.ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference, init);
			}
			return declaration;
		}
		parseStatementContent(flags, decorators) {
			if (this.match(75) && this.isLookaheadContextual("enum")) {
				const node = this.startNode();
				this.expect(75);
				return this.tsParseEnumDeclaration(node, { const: true });
			}
			if (this.isContextual(126)) return this.tsParseEnumDeclaration(this.startNode());
			if (this.isContextual(129)) {
				const result = this.tsParseInterfaceDeclaration(this.startNode());
				if (result) return result;
			}
			return super.parseStatementContent(flags, decorators);
		}
		parseAccessModifier() {
			return this.tsParseModifier([
				"public",
				"protected",
				"private"
			]);
		}
		tsHasSomeModifiers(member, modifiers) {
			return modifiers.some((modifier) => {
				if (tsIsAccessModifier(modifier)) return member.accessibility === modifier;
				return !!member[modifier];
			});
		}
		tsIsStartOfStaticBlocks() {
			return this.isContextual(106) && this.lookaheadCharCode() === 123;
		}
		parseClassMember(classBody, member, state) {
			const modifiers = [
				"declare",
				"private",
				"public",
				"protected",
				"override",
				"abstract",
				"readonly",
				"static"
			];
			this.tsParseModifiers({
				allowedModifiers: modifiers,
				disallowedModifiers: ["in", "out"],
				stopOnStartOfClassStaticBlock: true,
				errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions
			}, member);
			const callParseClassMemberWithIsStatic = () => {
				if (this.tsIsStartOfStaticBlocks()) {
					this.next();
					this.next();
					if (this.tsHasSomeModifiers(member, modifiers)) this.raise(TSErrors.StaticBlockCannotHaveModifier, this.state.curPosition());
					super.parseClassStaticBlock(classBody, member);
				} else this.parseClassMemberWithIsStatic(classBody, member, state, !!member.static);
			};
			if (member.declare) this.tsInAmbientContext(callParseClassMemberWithIsStatic);
			else callParseClassMemberWithIsStatic();
		}
		parseClassMemberWithIsStatic(classBody, member, state, isStatic$1) {
			const idx = this.tsTryParseIndexSignature(member);
			if (idx) {
				classBody.body.push(idx);
				if (member.abstract) this.raise(TSErrors.IndexSignatureHasAbstract, member);
				if (member.accessibility) this.raise(TSErrors.IndexSignatureHasAccessibility, member, { modifier: member.accessibility });
				if (member.declare) this.raise(TSErrors.IndexSignatureHasDeclare, member);
				if (member.override) this.raise(TSErrors.IndexSignatureHasOverride, member);
				return;
			}
			if (!this.state.inAbstractClass && member.abstract) this.raise(TSErrors.NonAbstractClassHasAbstractMethod, member);
			if (member.override) {
				if (!state.hadSuperClass) this.raise(TSErrors.OverrideNotInSubClass, member);
			}
			super.parseClassMemberWithIsStatic(classBody, member, state, isStatic$1);
		}
		parsePostMemberNameModifiers(methodOrProp) {
			const optional = this.eat(17);
			if (optional) methodOrProp.optional = true;
			if (methodOrProp.readonly && this.match(10)) this.raise(TSErrors.ClassMethodHasReadonly, methodOrProp);
			if (methodOrProp.declare && this.match(10)) this.raise(TSErrors.ClassMethodHasDeclare, methodOrProp);
		}
		parseExpressionStatement(node, expr, decorators) {
			const decl = expr.type === "Identifier" ? this.tsParseExpressionStatement(node, expr, decorators) : void 0;
			return decl || super.parseExpressionStatement(node, expr, decorators);
		}
		shouldParseExportDeclaration() {
			if (this.tsIsDeclarationStart()) return true;
			return super.shouldParseExportDeclaration();
		}
		parseConditional(expr, startLoc, refExpressionErrors) {
			if (!this.match(17)) return expr;
			if (this.state.maybeInArrowParameters) {
				const nextCh = this.lookaheadCharCode();
				if (nextCh === 44 || nextCh === 61 || nextCh === 58 || nextCh === 41) {
					this.setOptionalParametersError(refExpressionErrors);
					return expr;
				}
			}
			return super.parseConditional(expr, startLoc, refExpressionErrors);
		}
		parseParenItem(node, startLoc) {
			const newNode = super.parseParenItem(node, startLoc);
			if (this.eat(17)) {
				newNode.optional = true;
				this.resetEndLocation(node);
			}
			if (this.match(14)) {
				const typeCastNode = this.startNodeAt(startLoc);
				typeCastNode.expression = node;
				typeCastNode.typeAnnotation = this.tsParseTypeAnnotation();
				return this.finishNode(typeCastNode, "TSTypeCastExpression");
			}
			return node;
		}
		parseExportDeclaration(node) {
			if (!this.state.isAmbientContext && this.isContextual(125)) return this.tsInAmbientContext(() => this.parseExportDeclaration(node));
			const startLoc = this.state.startLoc;
			const isDeclare = this.eatContextual(125);
			if (isDeclare && (this.isContextual(125) || !this.shouldParseExportDeclaration())) throw this.raise(TSErrors.ExpectedAmbientAfterExportDeclare, this.state.startLoc);
			const isIdentifier = tokenIsIdentifier(this.state.type);
			const declaration = isIdentifier && this.tsTryParseExportDeclaration() || super.parseExportDeclaration(node);
			if (!declaration) return null;
			if (declaration.type === "TSInterfaceDeclaration" || declaration.type === "TSTypeAliasDeclaration" || isDeclare) node.exportKind = "type";
			if (isDeclare && declaration.type !== "TSImportEqualsDeclaration") {
				this.resetStartLocation(declaration, startLoc);
				declaration.declare = true;
			}
			return declaration;
		}
		parseClassId(node, isStatement, optionalId, bindingType) {
			if ((!isStatement || optionalId) && this.isContextual(113)) return;
			super.parseClassId(node, isStatement, optionalId, node.declare ? 1024 : 8331);
			const typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers);
			if (typeParameters) node.typeParameters = typeParameters;
		}
		parseClassPropertyAnnotation(node) {
			if (!node.optional) {
				if (this.eat(35)) node.definite = true;
				else if (this.eat(17)) node.optional = true;
			}
			const type = this.tsTryParseTypeAnnotation();
			if (type) node.typeAnnotation = type;
		}
		parseClassProperty(node) {
			this.parseClassPropertyAnnotation(node);
			if (this.state.isAmbientContext && !(node.readonly && !node.typeAnnotation) && this.match(29)) this.raise(TSErrors.DeclareClassFieldHasInitializer, this.state.startLoc);
			if (node.abstract && this.match(29)) {
				const { key } = node;
				this.raise(TSErrors.AbstractPropertyHasInitializer, this.state.startLoc, { propertyName: key.type === "Identifier" && !node.computed ? key.name : `[${this.input.slice(this.offsetToSourcePos(key.start), this.offsetToSourcePos(key.end))}]` });
			}
			return super.parseClassProperty(node);
		}
		parseClassPrivateProperty(node) {
			if (node.abstract) this.raise(TSErrors.PrivateElementHasAbstract, node);
			if (node.accessibility) this.raise(TSErrors.PrivateElementHasAccessibility, node, { modifier: node.accessibility });
			this.parseClassPropertyAnnotation(node);
			return super.parseClassPrivateProperty(node);
		}
		parseClassAccessorProperty(node) {
			this.parseClassPropertyAnnotation(node);
			if (node.optional) this.raise(TSErrors.AccessorCannotBeOptional, node);
			return super.parseClassAccessorProperty(node);
		}
		pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
			const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
			if (typeParameters && isConstructor) this.raise(TSErrors.ConstructorHasTypeParameters, typeParameters);
			const { declare = false, kind } = method;
			if (declare && (kind === "get" || kind === "set")) this.raise(TSErrors.DeclareAccessor, method, { kind });
			if (typeParameters) method.typeParameters = typeParameters;
			super.pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper);
		}
		pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
			const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
			if (typeParameters) method.typeParameters = typeParameters;
			super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
		}
		declareClassPrivateMethodInScope(node, kind) {
			if (node.type === "TSDeclareMethod") return;
			if (node.type === "MethodDefinition" && node.value.body == null) return;
			super.declareClassPrivateMethodInScope(node, kind);
		}
		parseClassSuper(node) {
			super.parseClassSuper(node);
			if (node.superClass && (this.match(47) || this.match(51))) node.superTypeParameters = this.tsParseTypeArgumentsInExpression();
			if (this.eatContextual(113)) node.implements = this.tsParseHeritageClause("implements");
		}
		parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
			const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
			if (typeParameters) prop.typeParameters = typeParameters;
			return super.parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors);
		}
		parseFunctionParams(node, isConstructor) {
			const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
			if (typeParameters) node.typeParameters = typeParameters;
			super.parseFunctionParams(node, isConstructor);
		}
		parseVarId(decl, kind) {
			super.parseVarId(decl, kind);
			if (decl.id.type === "Identifier" && !this.hasPrecedingLineBreak() && this.eat(35)) decl.definite = true;
			const type = this.tsTryParseTypeAnnotation();
			if (type) {
				decl.id.typeAnnotation = type;
				this.resetEndLocation(decl.id);
			}
		}
		parseAsyncArrowFromCallExpression(node, call) {
			if (this.match(14)) node.returnType = this.tsParseTypeAnnotation();
			return super.parseAsyncArrowFromCallExpression(node, call);
		}
		parseMaybeAssign(refExpressionErrors, afterLeftParse) {
			var _jsx, _jsx2, _typeCast, _jsx3, _typeCast2;
			let state;
			let jsx$1;
			let typeCast;
			if (this.hasPlugin("jsx") && (this.match(143) || this.match(47))) {
				state = this.state.clone();
				jsx$1 = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
				if (!jsx$1.error) return jsx$1.node;
				const { context } = this.state;
				const currentContext = context[context.length - 1];
				if (currentContext === types$1.j_oTag || currentContext === types$1.j_expr) context.pop();
			}
			if (!((_jsx = jsx$1) != null && _jsx.error) && !this.match(47)) return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
			if (!state || state === this.state) state = this.state.clone();
			let typeParameters;
			const arrow = this.tryParse((abort) => {
				var _expr$extra, _typeParameters;
				typeParameters = this.tsParseTypeParameters(this.tsParseConstModifier);
				const expr = super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
				if (expr.type !== "ArrowFunctionExpression" || (_expr$extra = expr.extra) != null && _expr$extra.parenthesized) abort();
				if (((_typeParameters = typeParameters) == null ? void 0 : _typeParameters.params.length) !== 0) this.resetStartLocationFromNode(expr, typeParameters);
				expr.typeParameters = typeParameters;
				return expr;
			}, state);
			if (!arrow.error && !arrow.aborted) {
				if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
				return arrow.node;
			}
			if (!jsx$1) {
				assert$1(!this.hasPlugin("jsx"));
				typeCast = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
				if (!typeCast.error) return typeCast.node;
			}
			if ((_jsx2 = jsx$1) != null && _jsx2.node) {
				this.state = jsx$1.failState;
				return jsx$1.node;
			}
			if (arrow.node) {
				this.state = arrow.failState;
				if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
				return arrow.node;
			}
			if ((_typeCast = typeCast) != null && _typeCast.node) {
				this.state = typeCast.failState;
				return typeCast.node;
			}
			throw ((_jsx3 = jsx$1) == null ? void 0 : _jsx3.error) || arrow.error || ((_typeCast2 = typeCast) == null ? void 0 : _typeCast2.error);
		}
		reportReservedArrowTypeParam(node) {
			var _node$extra2;
			if (node.params.length === 1 && !node.params[0].constraint && !((_node$extra2 = node.extra) != null && _node$extra2.trailingComma) && this.getPluginOption("typescript", "disallowAmbiguousJSXLike")) this.raise(TSErrors.ReservedArrowTypeParam, node);
		}
		parseMaybeUnary(refExpressionErrors, sawUnary) {
			if (!this.hasPlugin("jsx") && this.match(47)) return this.tsParseTypeAssertion();
			return super.parseMaybeUnary(refExpressionErrors, sawUnary);
		}
		parseArrow(node) {
			if (this.match(14)) {
				const result = this.tryParse((abort) => {
					const returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
					if (this.canInsertSemicolon() || !this.match(19)) abort();
					return returnType;
				});
				if (result.aborted) return;
				if (!result.thrown) {
					if (result.error) this.state = result.failState;
					node.returnType = result.node;
				}
			}
			return super.parseArrow(node);
		}
		parseFunctionParamType(param) {
			if (this.eat(17)) param.optional = true;
			const type = this.tsTryParseTypeAnnotation();
			if (type) param.typeAnnotation = type;
			this.resetEndLocation(param);
			return param;
		}
		isAssignable(node, isBinding) {
			switch (node.type) {
				case "TSTypeCastExpression": return this.isAssignable(node.expression, isBinding);
				case "TSParameterProperty": return true;
				default: return super.isAssignable(node, isBinding);
			}
		}
		toAssignable(node, isLHS = false) {
			switch (node.type) {
				case "ParenthesizedExpression":
					this.toAssignableParenthesizedExpression(node, isLHS);
					break;
				case "TSAsExpression":
				case "TSSatisfiesExpression":
				case "TSNonNullExpression":
				case "TSTypeAssertion":
					if (isLHS) this.expressionScope.recordArrowParameterBindingError(TSErrors.UnexpectedTypeCastInParameter, node);
					else this.raise(TSErrors.UnexpectedTypeCastInParameter, node);
					this.toAssignable(node.expression, isLHS);
					break;
				case "AssignmentExpression": if (!isLHS && node.left.type === "TSTypeCastExpression") node.left = this.typeCastToParameter(node.left);
				default: super.toAssignable(node, isLHS);
			}
		}
		toAssignableParenthesizedExpression(node, isLHS) {
			switch (node.expression.type) {
				case "TSAsExpression":
				case "TSSatisfiesExpression":
				case "TSNonNullExpression":
				case "TSTypeAssertion":
				case "ParenthesizedExpression":
					this.toAssignable(node.expression, isLHS);
					break;
				default: super.toAssignable(node, isLHS);
			}
		}
		checkToRestConversion(node, allowPattern) {
			switch (node.type) {
				case "TSAsExpression":
				case "TSSatisfiesExpression":
				case "TSTypeAssertion":
				case "TSNonNullExpression":
					this.checkToRestConversion(node.expression, false);
					break;
				default: super.checkToRestConversion(node, allowPattern);
			}
		}
		isValidLVal(type, isUnparenthesizedInAssign, binding) {
			switch (type) {
				case "TSTypeCastExpression": return true;
				case "TSParameterProperty": return "parameter";
				case "TSNonNullExpression": return "expression";
				case "TSAsExpression":
				case "TSSatisfiesExpression":
				case "TSTypeAssertion": return (binding !== 64 || !isUnparenthesizedInAssign) && ["expression", true];
				default: return super.isValidLVal(type, isUnparenthesizedInAssign, binding);
			}
		}
		parseBindingAtom() {
			if (this.state.type === 78) return this.parseIdentifier(true);
			return super.parseBindingAtom();
		}
		parseMaybeDecoratorArguments(expr, startLoc) {
			if (this.match(47) || this.match(51)) {
				const typeArguments = this.tsParseTypeArgumentsInExpression();
				if (this.match(10)) {
					const call = super.parseMaybeDecoratorArguments(expr, startLoc);
					call.typeParameters = typeArguments;
					return call;
				}
				this.unexpected(null, 10);
			}
			return super.parseMaybeDecoratorArguments(expr, startLoc);
		}
		checkCommaAfterRest(close) {
			if (this.state.isAmbientContext && this.match(12) && this.lookaheadCharCode() === close) {
				this.next();
				return false;
			}
			return super.checkCommaAfterRest(close);
		}
		isClassMethod() {
			return this.match(47) || super.isClassMethod();
		}
		isClassProperty() {
			return this.match(35) || this.match(14) || super.isClassProperty();
		}
		parseMaybeDefault(startLoc, left) {
			const node = super.parseMaybeDefault(startLoc, left);
			if (node.type === "AssignmentPattern" && node.typeAnnotation && node.right.start < node.typeAnnotation.start) this.raise(TSErrors.TypeAnnotationAfterAssign, node.typeAnnotation);
			return node;
		}
		getTokenFromCode(code$1) {
			if (this.state.inType) {
				if (code$1 === 62) {
					this.finishOp(48, 1);
					return;
				}
				if (code$1 === 60) {
					this.finishOp(47, 1);
					return;
				}
			}
			super.getTokenFromCode(code$1);
		}
		reScan_lt_gt() {
			const { type } = this.state;
			if (type === 47) {
				this.state.pos -= 1;
				this.readToken_lt();
			} else if (type === 48) {
				this.state.pos -= 1;
				this.readToken_gt();
			}
		}
		reScan_lt() {
			const { type } = this.state;
			if (type === 51) {
				this.state.pos -= 2;
				this.finishOp(47, 1);
				return 47;
			}
			return type;
		}
		toAssignableListItem(exprList, index$1, isLHS) {
			const node = exprList[index$1];
			if (node.type === "TSTypeCastExpression") exprList[index$1] = this.typeCastToParameter(node);
			super.toAssignableListItem(exprList, index$1, isLHS);
		}
		typeCastToParameter(node) {
			node.expression.typeAnnotation = node.typeAnnotation;
			this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
			return node.expression;
		}
		shouldParseArrow(params) {
			if (this.match(14)) return params.every((expr) => this.isAssignable(expr, true));
			return super.shouldParseArrow(params);
		}
		shouldParseAsyncArrow() {
			return this.match(14) || super.shouldParseAsyncArrow();
		}
		canHaveLeadingDecorator() {
			return super.canHaveLeadingDecorator() || this.isAbstractClass();
		}
		jsxParseOpeningElementAfterName(node) {
			if (this.match(47) || this.match(51)) {
				const typeArguments = this.tsTryParseAndCatch(() => this.tsParseTypeArgumentsInExpression());
				if (typeArguments) node.typeParameters = typeArguments;
			}
			return super.jsxParseOpeningElementAfterName(node);
		}
		getGetterSetterExpectedParamCount(method) {
			const baseCount = super.getGetterSetterExpectedParamCount(method);
			const params = this.getObjectOrClassMethodParams(method);
			const firstParam = params[0];
			const hasContextParam = firstParam && this.isThisParam(firstParam);
			return hasContextParam ? baseCount + 1 : baseCount;
		}
		parseCatchClauseParam() {
			const param = super.parseCatchClauseParam();
			const type = this.tsTryParseTypeAnnotation();
			if (type) {
				param.typeAnnotation = type;
				this.resetEndLocation(param);
			}
			return param;
		}
		tsInAmbientContext(cb) {
			const { isAmbientContext: oldIsAmbientContext, strict: oldStrict } = this.state;
			this.state.isAmbientContext = true;
			this.state.strict = false;
			try {
				return cb();
			} finally {
				this.state.isAmbientContext = oldIsAmbientContext;
				this.state.strict = oldStrict;
			}
		}
		parseClass(node, isStatement, optionalId) {
			const oldInAbstractClass = this.state.inAbstractClass;
			this.state.inAbstractClass = !!node.abstract;
			try {
				return super.parseClass(node, isStatement, optionalId);
			} finally {
				this.state.inAbstractClass = oldInAbstractClass;
			}
		}
		tsParseAbstractDeclaration(node, decorators) {
			if (this.match(80)) {
				node.abstract = true;
				return this.maybeTakeDecorators(decorators, this.parseClass(node, true, false));
			} else if (this.isContextual(129)) {
				if (!this.hasFollowingLineBreak()) {
					node.abstract = true;
					this.raise(TSErrors.NonClassMethodPropertyHasAbstractModifier, node);
					return this.tsParseInterfaceDeclaration(node);
				}
			} else this.unexpected(null, 80);
		}
		parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope) {
			const method = super.parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope);
			if (method.abstract || method.type === "TSAbstractMethodDefinition") {
				const hasEstreePlugin = this.hasPlugin("estree");
				const methodFn = hasEstreePlugin ? method.value : method;
				if (methodFn.body) {
					const { key } = method;
					this.raise(TSErrors.AbstractMethodHasImplementation, method, { methodName: key.type === "Identifier" && !method.computed ? key.name : `[${this.input.slice(this.offsetToSourcePos(key.start), this.offsetToSourcePos(key.end))}]` });
				}
			}
			return method;
		}
		tsParseTypeParameterName() {
			const typeName = this.parseIdentifier();
			return typeName.name;
		}
		shouldParseAsAmbientContext() {
			return !!this.getPluginOption("typescript", "dts");
		}
		parse() {
			if (this.shouldParseAsAmbientContext()) this.state.isAmbientContext = true;
			return super.parse();
		}
		getExpression() {
			if (this.shouldParseAsAmbientContext()) this.state.isAmbientContext = true;
			return super.getExpression();
		}
		parseExportSpecifier(node, isString$1, isInTypeExport, isMaybeTypeOnly) {
			if (!isString$1 && isMaybeTypeOnly) {
				this.parseTypeOnlyImportExportSpecifier(node, false, isInTypeExport);
				return this.finishNode(node, "ExportSpecifier");
			}
			node.exportKind = "value";
			return super.parseExportSpecifier(node, isString$1, isInTypeExport, isMaybeTypeOnly);
		}
		parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
			if (!importedIsString && isMaybeTypeOnly) {
				this.parseTypeOnlyImportExportSpecifier(specifier, true, isInTypeOnlyImport);
				return this.finishNode(specifier, "ImportSpecifier");
			}
			specifier.importKind = "value";
			return super.parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, isInTypeOnlyImport ? 4098 : 4096);
		}
		parseTypeOnlyImportExportSpecifier(node, isImport, isInTypeOnlyImportExport) {
			const leftOfAsKey = isImport ? "imported" : "local";
			const rightOfAsKey = isImport ? "local" : "exported";
			let leftOfAs = node[leftOfAsKey];
			let rightOfAs;
			let hasTypeSpecifier = false;
			let canParseAsKeyword = true;
			const loc = leftOfAs.loc.start;
			if (this.isContextual(93)) {
				const firstAs = this.parseIdentifier();
				if (this.isContextual(93)) {
					const secondAs = this.parseIdentifier();
					if (tokenIsKeywordOrIdentifier(this.state.type)) {
						hasTypeSpecifier = true;
						leftOfAs = firstAs;
						rightOfAs = isImport ? this.parseIdentifier() : this.parseModuleExportName();
						canParseAsKeyword = false;
					} else {
						rightOfAs = secondAs;
						canParseAsKeyword = false;
					}
				} else if (tokenIsKeywordOrIdentifier(this.state.type)) {
					canParseAsKeyword = false;
					rightOfAs = isImport ? this.parseIdentifier() : this.parseModuleExportName();
				} else {
					hasTypeSpecifier = true;
					leftOfAs = firstAs;
				}
			} else if (tokenIsKeywordOrIdentifier(this.state.type)) {
				hasTypeSpecifier = true;
				if (isImport) {
					leftOfAs = this.parseIdentifier(true);
					if (!this.isContextual(93)) this.checkReservedWord(leftOfAs.name, leftOfAs.loc.start, true, true);
				} else leftOfAs = this.parseModuleExportName();
			}
			if (hasTypeSpecifier && isInTypeOnlyImportExport) this.raise(isImport ? TSErrors.TypeModifierIsUsedInTypeImports : TSErrors.TypeModifierIsUsedInTypeExports, loc);
			node[leftOfAsKey] = leftOfAs;
			node[rightOfAsKey] = rightOfAs;
			const kindKey = isImport ? "importKind" : "exportKind";
			node[kindKey] = hasTypeSpecifier ? "type" : "value";
			if (canParseAsKeyword && this.eatContextual(93)) node[rightOfAsKey] = isImport ? this.parseIdentifier() : this.parseModuleExportName();
			if (!node[rightOfAsKey]) node[rightOfAsKey] = this.cloneIdentifier(node[leftOfAsKey]);
			if (isImport) this.checkIdentifier(node[rightOfAsKey], hasTypeSpecifier ? 4098 : 4096);
		}
		fillOptionalPropertiesForTSESLint(node) {
			var _node$directive, _node$decorators, _node$optional, _node$typeAnnotation, _node$accessibility, _node$decorators2, _node$override, _node$readonly, _node$static, _node$declare, _node$returnType, _node$typeParameters, _node$optional2, _node$optional3, _node$accessibility2, _node$readonly2, _node$static2, _node$declare2, _node$definite, _node$readonly3, _node$typeAnnotation2, _node$accessibility3, _node$decorators3, _node$override2, _node$optional4, _node$id, _node$abstract, _node$declare3, _node$decorators4, _node$implements, _node$superTypeArgume, _node$typeParameters2, _node$declare4, _node$definite2, _node$const, _node$declare5, _node$computed, _node$qualifier, _node$options, _node$declare6, _node$extends, _node$declare7, _node$global, _node$const2, _node$in, _node$out;
			switch (node.type) {
				case "ExpressionStatement":
					(_node$directive = node.directive) != null || (node.directive = void 0);
					return;
				case "RestElement": node.value = void 0;
				case "Identifier":
				case "ArrayPattern":
				case "AssignmentPattern":
				case "ObjectPattern":
					(_node$decorators = node.decorators) != null || (node.decorators = []);
					(_node$optional = node.optional) != null || (node.optional = false);
					(_node$typeAnnotation = node.typeAnnotation) != null || (node.typeAnnotation = void 0);
					return;
				case "TSParameterProperty":
					(_node$accessibility = node.accessibility) != null || (node.accessibility = void 0);
					(_node$decorators2 = node.decorators) != null || (node.decorators = []);
					(_node$override = node.override) != null || (node.override = false);
					(_node$readonly = node.readonly) != null || (node.readonly = false);
					(_node$static = node.static) != null || (node.static = false);
					return;
				case "TSEmptyBodyFunctionExpression": node.body = null;
				case "TSDeclareFunction":
				case "FunctionDeclaration":
				case "FunctionExpression":
				case "ClassMethod":
				case "ClassPrivateMethod":
					(_node$declare = node.declare) != null || (node.declare = false);
					(_node$returnType = node.returnType) != null || (node.returnType = void 0);
					(_node$typeParameters = node.typeParameters) != null || (node.typeParameters = void 0);
					return;
				case "Property":
					(_node$optional2 = node.optional) != null || (node.optional = false);
					return;
				case "TSMethodSignature":
				case "TSPropertySignature": (_node$optional3 = node.optional) != null || (node.optional = false);
				case "TSIndexSignature":
					(_node$accessibility2 = node.accessibility) != null || (node.accessibility = void 0);
					(_node$readonly2 = node.readonly) != null || (node.readonly = false);
					(_node$static2 = node.static) != null || (node.static = false);
					return;
				case "TSAbstractPropertyDefinition":
				case "PropertyDefinition":
				case "TSAbstractAccessorProperty":
				case "AccessorProperty":
					(_node$declare2 = node.declare) != null || (node.declare = false);
					(_node$definite = node.definite) != null || (node.definite = false);
					(_node$readonly3 = node.readonly) != null || (node.readonly = false);
					(_node$typeAnnotation2 = node.typeAnnotation) != null || (node.typeAnnotation = void 0);
				case "TSAbstractMethodDefinition":
				case "MethodDefinition":
					(_node$accessibility3 = node.accessibility) != null || (node.accessibility = void 0);
					(_node$decorators3 = node.decorators) != null || (node.decorators = []);
					(_node$override2 = node.override) != null || (node.override = false);
					(_node$optional4 = node.optional) != null || (node.optional = false);
					return;
				case "ClassExpression": (_node$id = node.id) != null || (node.id = null);
				case "ClassDeclaration":
					(_node$abstract = node.abstract) != null || (node.abstract = false);
					(_node$declare3 = node.declare) != null || (node.declare = false);
					(_node$decorators4 = node.decorators) != null || (node.decorators = []);
					(_node$implements = node.implements) != null || (node.implements = []);
					(_node$superTypeArgume = node.superTypeArguments) != null || (node.superTypeArguments = void 0);
					(_node$typeParameters2 = node.typeParameters) != null || (node.typeParameters = void 0);
					return;
				case "TSTypeAliasDeclaration":
				case "VariableDeclaration":
					(_node$declare4 = node.declare) != null || (node.declare = false);
					return;
				case "VariableDeclarator":
					(_node$definite2 = node.definite) != null || (node.definite = false);
					return;
				case "TSEnumDeclaration":
					(_node$const = node.const) != null || (node.const = false);
					(_node$declare5 = node.declare) != null || (node.declare = false);
					return;
				case "TSEnumMember":
					(_node$computed = node.computed) != null || (node.computed = false);
					return;
				case "TSImportType":
					(_node$qualifier = node.qualifier) != null || (node.qualifier = null);
					(_node$options = node.options) != null || (node.options = null);
					return;
				case "TSInterfaceDeclaration":
					(_node$declare6 = node.declare) != null || (node.declare = false);
					(_node$extends = node.extends) != null || (node.extends = []);
					return;
				case "TSModuleDeclaration":
					(_node$declare7 = node.declare) != null || (node.declare = false);
					(_node$global = node.global) != null || (node.global = node.kind === "global");
					return;
				case "TSTypeParameter":
					(_node$const2 = node.const) != null || (node.const = false);
					(_node$in = node.in) != null || (node.in = false);
					(_node$out = node.out) != null || (node.out = false);
					return;
			}
		}
	};
	function isPossiblyLiteralEnum(expression) {
		if (expression.type !== "MemberExpression") return false;
		const { computed: computed$1, property } = expression;
		if (computed$1 && property.type !== "StringLiteral" && (property.type !== "TemplateLiteral" || property.expressions.length > 0)) return false;
		return isUncomputedMemberExpressionChain(expression.object);
	}
	function isValidAmbientConstInitializer(expression, estree$1) {
		var _expression$extra;
		const { type } = expression;
		if ((_expression$extra = expression.extra) != null && _expression$extra.parenthesized) return false;
		if (estree$1) {
			if (type === "Literal") {
				const { value } = expression;
				if (typeof value === "string" || typeof value === "boolean") return true;
			}
		} else if (type === "StringLiteral" || type === "BooleanLiteral") return true;
		if (isNumber(expression, estree$1) || isNegativeNumber(expression, estree$1)) return true;
		if (type === "TemplateLiteral" && expression.expressions.length === 0) return true;
		if (isPossiblyLiteralEnum(expression)) return true;
		return false;
	}
	function isNumber(expression, estree$1) {
		if (estree$1) return expression.type === "Literal" && (typeof expression.value === "number" || "bigint" in expression);
		return expression.type === "NumericLiteral" || expression.type === "BigIntLiteral";
	}
	function isNegativeNumber(expression, estree$1) {
		if (expression.type === "UnaryExpression") {
			const { operator, argument } = expression;
			if (operator === "-" && isNumber(argument, estree$1)) return true;
		}
		return false;
	}
	function isUncomputedMemberExpressionChain(expression) {
		if (expression.type === "Identifier") return true;
		if (expression.type !== "MemberExpression" || expression.computed) return false;
		return isUncomputedMemberExpressionChain(expression.object);
	}
	const PlaceholderErrors = ParseErrorEnum`placeholders`({
		ClassNameIsRequired: "A class name is required.",
		UnexpectedSpace: "Unexpected space in placeholder."
	});
	var placeholders = (superClass) => class PlaceholdersParserMixin extends superClass {
		parsePlaceholder(expectedNode) {
			if (this.match(133)) {
				const node = this.startNode();
				this.next();
				this.assertNoSpace();
				node.name = super.parseIdentifier(true);
				this.assertNoSpace();
				this.expect(133);
				return this.finishPlaceholder(node, expectedNode);
			}
		}
		finishPlaceholder(node, expectedNode) {
			let placeholder = node;
			if (!placeholder.expectedNode || !placeholder.type) placeholder = this.finishNode(placeholder, "Placeholder");
			placeholder.expectedNode = expectedNode;
			return placeholder;
		}
		getTokenFromCode(code$1) {
			if (code$1 === 37 && this.input.charCodeAt(this.state.pos + 1) === 37) this.finishOp(133, 2);
			else super.getTokenFromCode(code$1);
		}
		parseExprAtom(refExpressionErrors) {
			return this.parsePlaceholder("Expression") || super.parseExprAtom(refExpressionErrors);
		}
		parseIdentifier(liberal) {
			return this.parsePlaceholder("Identifier") || super.parseIdentifier(liberal);
		}
		checkReservedWord(word, startLoc, checkKeywords, isBinding) {
			if (word !== void 0) super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
		}
		cloneIdentifier(node) {
			const cloned = super.cloneIdentifier(node);
			if (cloned.type === "Placeholder") cloned.expectedNode = node.expectedNode;
			return cloned;
		}
		cloneStringLiteral(node) {
			if (node.type === "Placeholder") return this.cloneIdentifier(node);
			return super.cloneStringLiteral(node);
		}
		parseBindingAtom() {
			return this.parsePlaceholder("Pattern") || super.parseBindingAtom();
		}
		isValidLVal(type, isParenthesized, binding) {
			return type === "Placeholder" || super.isValidLVal(type, isParenthesized, binding);
		}
		toAssignable(node, isLHS) {
			if (node && node.type === "Placeholder" && node.expectedNode === "Expression") node.expectedNode = "Pattern";
			else super.toAssignable(node, isLHS);
		}
		chStartsBindingIdentifier(ch, pos) {
			if (super.chStartsBindingIdentifier(ch, pos)) return true;
			const next$1 = this.nextTokenStart();
			if (this.input.charCodeAt(next$1) === 37 && this.input.charCodeAt(next$1 + 1) === 37) return true;
			return false;
		}
		verifyBreakContinue(node, isBreak) {
			if (node.label && node.label.type === "Placeholder") return;
			super.verifyBreakContinue(node, isBreak);
		}
		parseExpressionStatement(node, expr) {
			var _expr$extra;
			if (expr.type !== "Placeholder" || (_expr$extra = expr.extra) != null && _expr$extra.parenthesized) return super.parseExpressionStatement(node, expr);
			if (this.match(14)) {
				const stmt = node;
				stmt.label = this.finishPlaceholder(expr, "Identifier");
				this.next();
				stmt.body = super.parseStatementOrSloppyAnnexBFunctionDeclaration();
				return this.finishNode(stmt, "LabeledStatement");
			}
			this.semicolon();
			const stmtPlaceholder = node;
			stmtPlaceholder.name = expr.name;
			return this.finishPlaceholder(stmtPlaceholder, "Statement");
		}
		parseBlock(allowDirectives, createNewLexicalScope, afterBlockParse) {
			return this.parsePlaceholder("BlockStatement") || super.parseBlock(allowDirectives, createNewLexicalScope, afterBlockParse);
		}
		parseFunctionId(requireId) {
			return this.parsePlaceholder("Identifier") || super.parseFunctionId(requireId);
		}
		parseClass(node, isStatement, optionalId) {
			const type = isStatement ? "ClassDeclaration" : "ClassExpression";
			this.next();
			const oldStrict = this.state.strict;
			const placeholder = this.parsePlaceholder("Identifier");
			if (placeholder) if (this.match(81) || this.match(133) || this.match(5)) node.id = placeholder;
			else if (optionalId || !isStatement) {
				node.id = null;
				node.body = this.finishPlaceholder(placeholder, "ClassBody");
				return this.finishNode(node, type);
			} else throw this.raise(PlaceholderErrors.ClassNameIsRequired, this.state.startLoc);
			else this.parseClassId(node, isStatement, optionalId);
			super.parseClassSuper(node);
			node.body = this.parsePlaceholder("ClassBody") || super.parseClassBody(!!node.superClass, oldStrict);
			return this.finishNode(node, type);
		}
		parseExport(node, decorators) {
			const placeholder = this.parsePlaceholder("Identifier");
			if (!placeholder) return super.parseExport(node, decorators);
			const node2 = node;
			if (!this.isContextual(98) && !this.match(12)) {
				node2.specifiers = [];
				node2.source = null;
				node2.declaration = this.finishPlaceholder(placeholder, "Declaration");
				return this.finishNode(node2, "ExportNamedDeclaration");
			}
			this.expectPlugin("exportDefaultFrom");
			const specifier = this.startNode();
			specifier.exported = placeholder;
			node2.specifiers = [this.finishNode(specifier, "ExportDefaultSpecifier")];
			return super.parseExport(node2, decorators);
		}
		isExportDefaultSpecifier() {
			if (this.match(65)) {
				const next$1 = this.nextTokenStart();
				if (this.isUnparsedContextual(next$1, "from")) {
					if (this.input.startsWith(tokenLabelName(133), this.nextTokenStartSince(next$1 + 4))) return true;
				}
			}
			return super.isExportDefaultSpecifier();
		}
		maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
			var _specifiers;
			if ((_specifiers = node.specifiers) != null && _specifiers.length) return true;
			return super.maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier);
		}
		checkExport(node) {
			const { specifiers } = node;
			if (specifiers != null && specifiers.length) node.specifiers = specifiers.filter((node$1) => node$1.exported.type === "Placeholder");
			super.checkExport(node);
			node.specifiers = specifiers;
		}
		parseImport(node) {
			const placeholder = this.parsePlaceholder("Identifier");
			if (!placeholder) return super.parseImport(node);
			node.specifiers = [];
			if (!this.isContextual(98) && !this.match(12)) {
				node.source = this.finishPlaceholder(placeholder, "StringLiteral");
				this.semicolon();
				return this.finishNode(node, "ImportDeclaration");
			}
			const specifier = this.startNodeAtNode(placeholder);
			specifier.local = placeholder;
			node.specifiers.push(this.finishNode(specifier, "ImportDefaultSpecifier"));
			if (this.eat(12)) {
				const hasStarImport = this.maybeParseStarImportSpecifier(node);
				if (!hasStarImport) this.parseNamedImportSpecifiers(node);
			}
			this.expectContextual(98);
			node.source = this.parseImportSource();
			this.semicolon();
			return this.finishNode(node, "ImportDeclaration");
		}
		parseImportSource() {
			return this.parsePlaceholder("StringLiteral") || super.parseImportSource();
		}
		assertNoSpace() {
			if (this.state.start > this.offsetToSourcePos(this.state.lastTokEndLoc.index)) this.raise(PlaceholderErrors.UnexpectedSpace, this.state.lastTokEndLoc);
		}
	};
	var v8intrinsic = (superClass) => class V8IntrinsicMixin extends superClass {
		parseV8Intrinsic() {
			if (this.match(54)) {
				const v8IntrinsicStartLoc = this.state.startLoc;
				const node = this.startNode();
				this.next();
				if (tokenIsIdentifier(this.state.type)) {
					const name = this.parseIdentifierName();
					const identifier = this.createIdentifier(node, name);
					this.castNodeTo(identifier, "V8IntrinsicIdentifier");
					if (this.match(10)) return identifier;
				}
				this.unexpected(v8IntrinsicStartLoc);
			}
		}
		parseExprAtom(refExpressionErrors) {
			return this.parseV8Intrinsic() || super.parseExprAtom(refExpressionErrors);
		}
	};
	const PIPELINE_PROPOSALS = [
		"minimal",
		"fsharp",
		"hack",
		"smart"
	];
	const TOPIC_TOKENS = [
		"^^",
		"@@",
		"^",
		"%",
		"#"
	];
	function validatePlugins(pluginsMap) {
		if (pluginsMap.has("decorators")) {
			if (pluginsMap.has("decorators-legacy")) throw new Error("Cannot use the decorators and decorators-legacy plugin together");
			const decoratorsBeforeExport = pluginsMap.get("decorators").decoratorsBeforeExport;
			if (decoratorsBeforeExport != null && typeof decoratorsBeforeExport !== "boolean") throw new Error("'decoratorsBeforeExport' must be a boolean, if specified.");
			const allowCallParenthesized = pluginsMap.get("decorators").allowCallParenthesized;
			if (allowCallParenthesized != null && typeof allowCallParenthesized !== "boolean") throw new Error("'allowCallParenthesized' must be a boolean.");
		}
		if (pluginsMap.has("flow") && pluginsMap.has("typescript")) throw new Error("Cannot combine flow and typescript plugins.");
		if (pluginsMap.has("placeholders") && pluginsMap.has("v8intrinsic")) throw new Error("Cannot combine placeholders and v8intrinsic plugins.");
		if (pluginsMap.has("pipelineOperator")) {
			var _pluginsMap$get2;
			const proposal = pluginsMap.get("pipelineOperator").proposal;
			if (!PIPELINE_PROPOSALS.includes(proposal)) {
				const proposalList = PIPELINE_PROPOSALS.map((p) => `"${p}"`).join(", ");
				throw new Error(`"pipelineOperator" requires "proposal" option whose value must be one of: ${proposalList}.`);
			}
			if (proposal === "hack") {
				if (pluginsMap.has("placeholders")) throw new Error("Cannot combine placeholders plugin and Hack-style pipes.");
				if (pluginsMap.has("v8intrinsic")) throw new Error("Cannot combine v8intrinsic plugin and Hack-style pipes.");
				const topicToken = pluginsMap.get("pipelineOperator").topicToken;
				if (!TOPIC_TOKENS.includes(topicToken)) {
					const tokenList = TOPIC_TOKENS.map((t) => `"${t}"`).join(", ");
					throw new Error(`"pipelineOperator" in "proposal": "hack" mode also requires a "topicToken" option whose value must be one of: ${tokenList}.`);
				}
				{
					var _pluginsMap$get;
					if (topicToken === "#" && ((_pluginsMap$get = pluginsMap.get("recordAndTuple")) == null ? void 0 : _pluginsMap$get.syntaxType) === "hash") throw new Error(`Plugin conflict between \`["pipelineOperator", { proposal: "hack", topicToken: "#" }]\` and \`${JSON.stringify(["recordAndTuple", pluginsMap.get("recordAndTuple")])}\`.`);
				}
			} else if (proposal === "smart" && ((_pluginsMap$get2 = pluginsMap.get("recordAndTuple")) == null ? void 0 : _pluginsMap$get2.syntaxType) === "hash") throw new Error(`Plugin conflict between \`["pipelineOperator", { proposal: "smart" }]\` and \`${JSON.stringify(["recordAndTuple", pluginsMap.get("recordAndTuple")])}\`.`);
		}
		if (pluginsMap.has("moduleAttributes")) {
			if (pluginsMap.has("deprecatedImportAssert") || pluginsMap.has("importAssertions")) throw new Error("Cannot combine importAssertions, deprecatedImportAssert and moduleAttributes plugins.");
			const moduleAttributesVersionPluginOption = pluginsMap.get("moduleAttributes").version;
			if (moduleAttributesVersionPluginOption !== "may-2020") throw new Error("The 'moduleAttributes' plugin requires a 'version' option, representing the last proposal update. Currently, the only supported value is 'may-2020'.");
		}
		if (pluginsMap.has("importAssertions")) {
			if (pluginsMap.has("deprecatedImportAssert")) throw new Error("Cannot combine importAssertions and deprecatedImportAssert plugins.");
		}
		if (!pluginsMap.has("deprecatedImportAssert") && pluginsMap.has("importAttributes") && pluginsMap.get("importAttributes").deprecatedAssertSyntax) pluginsMap.set("deprecatedImportAssert", {});
		if (pluginsMap.has("recordAndTuple")) {
			const syntaxType = pluginsMap.get("recordAndTuple").syntaxType;
			if (syntaxType != null) {
				const RECORD_AND_TUPLE_SYNTAX_TYPES = ["hash", "bar"];
				if (!RECORD_AND_TUPLE_SYNTAX_TYPES.includes(syntaxType)) throw new Error("The 'syntaxType' option of the 'recordAndTuple' plugin must be one of: " + RECORD_AND_TUPLE_SYNTAX_TYPES.map((p) => `'${p}'`).join(", "));
			}
		}
		if (pluginsMap.has("asyncDoExpressions") && !pluginsMap.has("doExpressions")) {
			const error = new Error("'asyncDoExpressions' requires 'doExpressions', please add 'doExpressions' to parser plugins.");
			error.missingPlugins = "doExpressions";
			throw error;
		}
		if (pluginsMap.has("optionalChainingAssign") && pluginsMap.get("optionalChainingAssign").version !== "2023-07") throw new Error("The 'optionalChainingAssign' plugin requires a 'version' option, representing the last proposal update. Currently, the only supported value is '2023-07'.");
		if (pluginsMap.has("discardBinding") && pluginsMap.get("discardBinding").syntaxType !== "void") throw new Error("The 'discardBinding' plugin requires a 'syntaxType' option. Currently the only supported value is 'void'.");
	}
	const mixinPlugins = {
		estree,
		jsx,
		flow,
		typescript,
		v8intrinsic,
		placeholders
	};
	const mixinPluginNames = Object.keys(mixinPlugins);
	var ExpressionParser = class extends LValParser {
		checkProto(prop, isRecord, sawProto, refExpressionErrors) {
			if (prop.type === "SpreadElement" || this.isObjectMethod(prop) || prop.computed || prop.shorthand) return sawProto;
			const key = prop.key;
			const name = key.type === "Identifier" ? key.name : key.value;
			if (name === "__proto__") {
				if (isRecord) {
					this.raise(Errors.RecordNoProto, key);
					return true;
				}
				if (sawProto) if (refExpressionErrors) {
					if (refExpressionErrors.doubleProtoLoc === null) refExpressionErrors.doubleProtoLoc = key.loc.start;
				} else this.raise(Errors.DuplicateProto, key);
				return true;
			}
			return sawProto;
		}
		shouldExitDescending(expr, potentialArrowAt) {
			return expr.type === "ArrowFunctionExpression" && this.offsetToSourcePos(expr.start) === potentialArrowAt;
		}
		getExpression() {
			this.enterInitialScopes();
			this.nextToken();
			if (this.match(140)) throw this.raise(Errors.ParseExpressionEmptyInput, this.state.startLoc);
			const expr = this.parseExpression();
			if (!this.match(140)) throw this.raise(Errors.ParseExpressionExpectsEOF, this.state.startLoc, { unexpected: this.input.codePointAt(this.state.start) });
			this.finalizeRemainingComments();
			expr.comments = this.comments;
			expr.errors = this.state.errors;
			if (this.optionFlags & 256) expr.tokens = this.tokens;
			return expr;
		}
		parseExpression(disallowIn, refExpressionErrors) {
			if (disallowIn) return this.disallowInAnd(() => this.parseExpressionBase(refExpressionErrors));
			return this.allowInAnd(() => this.parseExpressionBase(refExpressionErrors));
		}
		parseExpressionBase(refExpressionErrors) {
			const startLoc = this.state.startLoc;
			const expr = this.parseMaybeAssign(refExpressionErrors);
			if (this.match(12)) {
				const node = this.startNodeAt(startLoc);
				node.expressions = [expr];
				while (this.eat(12)) node.expressions.push(this.parseMaybeAssign(refExpressionErrors));
				this.toReferencedList(node.expressions);
				return this.finishNode(node, "SequenceExpression");
			}
			return expr;
		}
		parseMaybeAssignDisallowIn(refExpressionErrors, afterLeftParse) {
			return this.disallowInAnd(() => this.parseMaybeAssign(refExpressionErrors, afterLeftParse));
		}
		parseMaybeAssignAllowIn(refExpressionErrors, afterLeftParse) {
			return this.allowInAnd(() => this.parseMaybeAssign(refExpressionErrors, afterLeftParse));
		}
		setOptionalParametersError(refExpressionErrors) {
			refExpressionErrors.optionalParametersLoc = this.state.startLoc;
		}
		parseMaybeAssign(refExpressionErrors, afterLeftParse) {
			const startLoc = this.state.startLoc;
			const isYield = this.isContextual(108);
			if (isYield) {
				if (this.prodParam.hasYield) {
					this.next();
					let left$1 = this.parseYield(startLoc);
					if (afterLeftParse) left$1 = afterLeftParse.call(this, left$1, startLoc);
					return left$1;
				}
			}
			let ownExpressionErrors;
			if (refExpressionErrors) ownExpressionErrors = false;
			else {
				refExpressionErrors = new ExpressionErrors();
				ownExpressionErrors = true;
			}
			const { type } = this.state;
			if (type === 10 || tokenIsIdentifier(type)) this.state.potentialArrowAt = this.state.start;
			let left = this.parseMaybeConditional(refExpressionErrors);
			if (afterLeftParse) left = afterLeftParse.call(this, left, startLoc);
			if (tokenIsAssignment(this.state.type)) {
				const node = this.startNodeAt(startLoc);
				const operator = this.state.value;
				node.operator = operator;
				if (this.match(29)) {
					this.toAssignable(left, true);
					node.left = left;
					const startIndex = startLoc.index;
					if (refExpressionErrors.doubleProtoLoc != null && refExpressionErrors.doubleProtoLoc.index >= startIndex) refExpressionErrors.doubleProtoLoc = null;
					if (refExpressionErrors.shorthandAssignLoc != null && refExpressionErrors.shorthandAssignLoc.index >= startIndex) refExpressionErrors.shorthandAssignLoc = null;
					if (refExpressionErrors.privateKeyLoc != null && refExpressionErrors.privateKeyLoc.index >= startIndex) {
						this.checkDestructuringPrivate(refExpressionErrors);
						refExpressionErrors.privateKeyLoc = null;
					}
					if (refExpressionErrors.voidPatternLoc != null && refExpressionErrors.voidPatternLoc.index >= startIndex) refExpressionErrors.voidPatternLoc = null;
				} else node.left = left;
				this.next();
				node.right = this.parseMaybeAssign();
				this.checkLVal(left, this.finishNode(node, "AssignmentExpression"));
				return node;
			} else if (ownExpressionErrors) this.checkExpressionErrors(refExpressionErrors, true);
			if (isYield) {
				const { type: type$1 } = this.state;
				const startsExpr$1 = this.hasPlugin("v8intrinsic") ? tokenCanStartExpression(type$1) : tokenCanStartExpression(type$1) && !this.match(54);
				if (startsExpr$1 && !this.isAmbiguousPrefixOrIdentifier()) {
					this.raiseOverwrite(Errors.YieldNotInGeneratorFunction, startLoc);
					return this.parseYield(startLoc);
				}
			}
			return left;
		}
		parseMaybeConditional(refExpressionErrors) {
			const startLoc = this.state.startLoc;
			const potentialArrowAt = this.state.potentialArrowAt;
			const expr = this.parseExprOps(refExpressionErrors);
			if (this.shouldExitDescending(expr, potentialArrowAt)) return expr;
			return this.parseConditional(expr, startLoc, refExpressionErrors);
		}
		parseConditional(expr, startLoc, refExpressionErrors) {
			if (this.eat(17)) {
				const node = this.startNodeAt(startLoc);
				node.test = expr;
				node.consequent = this.parseMaybeAssignAllowIn();
				this.expect(14);
				node.alternate = this.parseMaybeAssign();
				return this.finishNode(node, "ConditionalExpression");
			}
			return expr;
		}
		parseMaybeUnaryOrPrivate(refExpressionErrors) {
			return this.match(139) ? this.parsePrivateName() : this.parseMaybeUnary(refExpressionErrors);
		}
		parseExprOps(refExpressionErrors) {
			const startLoc = this.state.startLoc;
			const potentialArrowAt = this.state.potentialArrowAt;
			const expr = this.parseMaybeUnaryOrPrivate(refExpressionErrors);
			if (this.shouldExitDescending(expr, potentialArrowAt)) return expr;
			return this.parseExprOp(expr, startLoc, -1);
		}
		parseExprOp(left, leftStartLoc, minPrec) {
			if (this.isPrivateName(left)) {
				const value = this.getPrivateNameSV(left);
				if (minPrec >= tokenOperatorPrecedence(58) || !this.prodParam.hasIn || !this.match(58)) this.raise(Errors.PrivateInExpectedIn, left, { identifierName: value });
				this.classScope.usePrivateName(value, left.loc.start);
			}
			const op = this.state.type;
			if (tokenIsOperator(op) && (this.prodParam.hasIn || !this.match(58))) {
				let prec = tokenOperatorPrecedence(op);
				if (prec > minPrec) {
					if (op === 39) {
						this.expectPlugin("pipelineOperator");
						if (this.state.inFSharpPipelineDirectBody) return left;
						this.checkPipelineAtInfixOperator(left, leftStartLoc);
					}
					const node = this.startNodeAt(leftStartLoc);
					node.left = left;
					node.operator = this.state.value;
					const logical = op === 41 || op === 42;
					const coalesce = op === 40;
					if (coalesce) prec = tokenOperatorPrecedence(42);
					this.next();
					if (op === 39 && this.hasPlugin(["pipelineOperator", { proposal: "minimal" }])) {
						if (this.state.type === 96 && this.prodParam.hasAwait) throw this.raise(Errors.UnexpectedAwaitAfterPipelineBody, this.state.startLoc);
					}
					node.right = this.parseExprOpRightExpr(op, prec);
					const finishedNode = this.finishNode(node, logical || coalesce ? "LogicalExpression" : "BinaryExpression");
					const nextOp = this.state.type;
					if (coalesce && (nextOp === 41 || nextOp === 42) || logical && nextOp === 40) throw this.raise(Errors.MixingCoalesceWithLogical, this.state.startLoc);
					return this.parseExprOp(finishedNode, leftStartLoc, minPrec);
				}
			}
			return left;
		}
		parseExprOpRightExpr(op, prec) {
			const startLoc = this.state.startLoc;
			switch (op) {
				case 39:
					switch (this.getPluginOption("pipelineOperator", "proposal")) {
						case "hack": return this.withTopicBindingContext(() => {
							return this.parseHackPipeBody();
						});
						case "fsharp": return this.withSoloAwaitPermittingContext(() => {
							return this.parseFSharpPipelineBody(prec);
						});
					}
					if (this.getPluginOption("pipelineOperator", "proposal") === "smart") return this.withTopicBindingContext(() => {
						if (this.prodParam.hasYield && this.isContextual(108)) throw this.raise(Errors.PipeBodyIsTighter, this.state.startLoc);
						return this.parseSmartPipelineBodyInStyle(this.parseExprOpBaseRightExpr(op, prec), startLoc);
					});
				default: return this.parseExprOpBaseRightExpr(op, prec);
			}
		}
		parseExprOpBaseRightExpr(op, prec) {
			const startLoc = this.state.startLoc;
			return this.parseExprOp(this.parseMaybeUnaryOrPrivate(), startLoc, tokenIsRightAssociative(op) ? prec - 1 : prec);
		}
		parseHackPipeBody() {
			var _body$extra;
			const { startLoc } = this.state;
			const body = this.parseMaybeAssign();
			const requiredParentheses = UnparenthesizedPipeBodyDescriptions.has(body.type);
			if (requiredParentheses && !((_body$extra = body.extra) != null && _body$extra.parenthesized)) this.raise(Errors.PipeUnparenthesizedBody, startLoc, { type: body.type });
			if (!this.topicReferenceWasUsedInCurrentContext()) this.raise(Errors.PipeTopicUnused, startLoc);
			return body;
		}
		checkExponentialAfterUnary(node) {
			if (this.match(57)) this.raise(Errors.UnexpectedTokenUnaryExponentiation, node.argument);
		}
		parseMaybeUnary(refExpressionErrors, sawUnary) {
			const startLoc = this.state.startLoc;
			const isAwait = this.isContextual(96);
			if (isAwait && this.recordAwaitIfAllowed()) {
				this.next();
				const expr$1 = this.parseAwait(startLoc);
				if (!sawUnary) this.checkExponentialAfterUnary(expr$1);
				return expr$1;
			}
			const update = this.match(34);
			const node = this.startNode();
			if (tokenIsPrefix(this.state.type)) {
				node.operator = this.state.value;
				node.prefix = true;
				if (this.match(72)) this.expectPlugin("throwExpressions");
				const isDelete = this.match(89);
				this.next();
				node.argument = this.parseMaybeUnary(null, true);
				this.checkExpressionErrors(refExpressionErrors, true);
				if (this.state.strict && isDelete) {
					const arg = node.argument;
					if (arg.type === "Identifier") this.raise(Errors.StrictDelete, node);
					else if (this.hasPropertyAsPrivateName(arg)) this.raise(Errors.DeletePrivateField, node);
				}
				if (!update) {
					if (!sawUnary) this.checkExponentialAfterUnary(node);
					return this.finishNode(node, "UnaryExpression");
				}
			}
			const expr = this.parseUpdate(node, update, refExpressionErrors);
			if (isAwait) {
				const { type } = this.state;
				const startsExpr$1 = this.hasPlugin("v8intrinsic") ? tokenCanStartExpression(type) : tokenCanStartExpression(type) && !this.match(54);
				if (startsExpr$1 && !this.isAmbiguousPrefixOrIdentifier()) {
					this.raiseOverwrite(Errors.AwaitNotInAsyncContext, startLoc);
					return this.parseAwait(startLoc);
				}
			}
			return expr;
		}
		parseUpdate(node, update, refExpressionErrors) {
			if (update) {
				const updateExpressionNode = node;
				this.checkLVal(updateExpressionNode.argument, this.finishNode(updateExpressionNode, "UpdateExpression"));
				return node;
			}
			const startLoc = this.state.startLoc;
			let expr = this.parseExprSubscripts(refExpressionErrors);
			if (this.checkExpressionErrors(refExpressionErrors, false)) return expr;
			while (tokenIsPostfix(this.state.type) && !this.canInsertSemicolon()) {
				const node$1 = this.startNodeAt(startLoc);
				node$1.operator = this.state.value;
				node$1.prefix = false;
				node$1.argument = expr;
				this.next();
				this.checkLVal(expr, expr = this.finishNode(node$1, "UpdateExpression"));
			}
			return expr;
		}
		parseExprSubscripts(refExpressionErrors) {
			const startLoc = this.state.startLoc;
			const potentialArrowAt = this.state.potentialArrowAt;
			const expr = this.parseExprAtom(refExpressionErrors);
			if (this.shouldExitDescending(expr, potentialArrowAt)) return expr;
			return this.parseSubscripts(expr, startLoc);
		}
		parseSubscripts(base, startLoc, noCalls) {
			const state = {
				optionalChainMember: false,
				maybeAsyncArrow: this.atPossibleAsyncArrow(base),
				stop: false
			};
			do {
				base = this.parseSubscript(base, startLoc, noCalls, state);
				state.maybeAsyncArrow = false;
			} while (!state.stop);
			return base;
		}
		parseSubscript(base, startLoc, noCalls, state) {
			const { type } = this.state;
			if (!noCalls && type === 15) return this.parseBind(base, startLoc, noCalls, state);
			else if (tokenIsTemplate(type)) return this.parseTaggedTemplateExpression(base, startLoc, state);
			let optional = false;
			if (type === 18) {
				if (noCalls) {
					this.raise(Errors.OptionalChainingNoNew, this.state.startLoc);
					if (this.lookaheadCharCode() === 40) return this.stopParseSubscript(base, state);
				}
				state.optionalChainMember = optional = true;
				this.next();
			}
			if (!noCalls && this.match(10)) return this.parseCoverCallAndAsyncArrowHead(base, startLoc, state, optional);
			else {
				const computed$1 = this.eat(0);
				if (computed$1 || optional || this.eat(16)) return this.parseMember(base, startLoc, state, computed$1, optional);
				else return this.stopParseSubscript(base, state);
			}
		}
		stopParseSubscript(base, state) {
			state.stop = true;
			return base;
		}
		parseMember(base, startLoc, state, computed$1, optional) {
			const node = this.startNodeAt(startLoc);
			node.object = base;
			node.computed = computed$1;
			if (computed$1) {
				node.property = this.parseExpression();
				this.expect(3);
			} else if (this.match(139)) {
				if (base.type === "Super") this.raise(Errors.SuperPrivateField, startLoc);
				this.classScope.usePrivateName(this.state.value, this.state.startLoc);
				node.property = this.parsePrivateName();
			} else node.property = this.parseIdentifier(true);
			if (state.optionalChainMember) {
				node.optional = optional;
				return this.finishNode(node, "OptionalMemberExpression");
			} else return this.finishNode(node, "MemberExpression");
		}
		parseBind(base, startLoc, noCalls, state) {
			const node = this.startNodeAt(startLoc);
			node.object = base;
			this.next();
			node.callee = this.parseNoCallExpr();
			state.stop = true;
			return this.parseSubscripts(this.finishNode(node, "BindExpression"), startLoc, noCalls);
		}
		parseCoverCallAndAsyncArrowHead(base, startLoc, state, optional) {
			const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
			let refExpressionErrors = null;
			this.state.maybeInArrowParameters = true;
			this.next();
			const node = this.startNodeAt(startLoc);
			node.callee = base;
			const { maybeAsyncArrow, optionalChainMember } = state;
			if (maybeAsyncArrow) {
				this.expressionScope.enter(newAsyncArrowScope());
				refExpressionErrors = new ExpressionErrors();
			}
			if (optionalChainMember) node.optional = optional;
			if (optional) node.arguments = this.parseCallExpressionArguments();
			else node.arguments = this.parseCallExpressionArguments(base.type !== "Super", node, refExpressionErrors);
			let finishedNode = this.finishCallExpression(node, optionalChainMember);
			if (maybeAsyncArrow && this.shouldParseAsyncArrow() && !optional) {
				state.stop = true;
				this.checkDestructuringPrivate(refExpressionErrors);
				this.expressionScope.validateAsPattern();
				this.expressionScope.exit();
				finishedNode = this.parseAsyncArrowFromCallExpression(this.startNodeAt(startLoc), finishedNode);
			} else {
				if (maybeAsyncArrow) {
					this.checkExpressionErrors(refExpressionErrors, true);
					this.expressionScope.exit();
				}
				this.toReferencedArguments(finishedNode);
			}
			this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
			return finishedNode;
		}
		toReferencedArguments(node, isParenthesizedExpr) {
			this.toReferencedListDeep(node.arguments, isParenthesizedExpr);
		}
		parseTaggedTemplateExpression(base, startLoc, state) {
			const node = this.startNodeAt(startLoc);
			node.tag = base;
			node.quasi = this.parseTemplate(true);
			if (state.optionalChainMember) this.raise(Errors.OptionalChainingNoTemplate, startLoc);
			return this.finishNode(node, "TaggedTemplateExpression");
		}
		atPossibleAsyncArrow(base) {
			return base.type === "Identifier" && base.name === "async" && this.state.lastTokEndLoc.index === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 && this.offsetToSourcePos(base.start) === this.state.potentialArrowAt;
		}
		finishCallExpression(node, optional) {
			if (node.callee.type === "Import") {
				if (node.arguments.length === 0 || node.arguments.length > 2) this.raise(Errors.ImportCallArity, node);
				else for (const arg of node.arguments) if (arg.type === "SpreadElement") this.raise(Errors.ImportCallSpreadArgument, arg);
			}
			return this.finishNode(node, optional ? "OptionalCallExpression" : "CallExpression");
		}
		parseCallExpressionArguments(allowPlaceholder, nodeForExtra, refExpressionErrors) {
			const elts = [];
			let first = true;
			const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
			this.state.inFSharpPipelineDirectBody = false;
			while (!this.eat(11)) {
				if (first) first = false;
				else {
					this.expect(12);
					if (this.match(11)) {
						if (nodeForExtra) this.addTrailingCommaExtraToNode(nodeForExtra);
						this.next();
						break;
					}
				}
				elts.push(this.parseExprListItem(11, false, refExpressionErrors, allowPlaceholder));
			}
			this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
			return elts;
		}
		shouldParseAsyncArrow() {
			return this.match(19) && !this.canInsertSemicolon();
		}
		parseAsyncArrowFromCallExpression(node, call) {
			var _call$extra;
			this.resetPreviousNodeTrailingComments(call);
			this.expect(19);
			this.parseArrowExpression(node, call.arguments, true, (_call$extra = call.extra) == null ? void 0 : _call$extra.trailingCommaLoc);
			if (call.innerComments) setInnerComments(node, call.innerComments);
			if (call.callee.trailingComments) setInnerComments(node, call.callee.trailingComments);
			return node;
		}
		parseNoCallExpr() {
			const startLoc = this.state.startLoc;
			return this.parseSubscripts(this.parseExprAtom(), startLoc, true);
		}
		parseExprAtom(refExpressionErrors) {
			let node;
			let decorators = null;
			const { type } = this.state;
			switch (type) {
				case 79: return this.parseSuper();
				case 83:
					node = this.startNode();
					this.next();
					if (this.match(16)) return this.parseImportMetaPropertyOrPhaseCall(node);
					if (this.match(10)) if (this.optionFlags & 512) return this.parseImportCall(node);
					else return this.finishNode(node, "Import");
					else {
						this.raise(Errors.UnsupportedImport, this.state.lastTokStartLoc);
						return this.finishNode(node, "Import");
					}
				case 78:
					node = this.startNode();
					this.next();
					return this.finishNode(node, "ThisExpression");
				case 90: return this.parseDo(this.startNode(), false);
				case 56:
				case 31: {
					this.readRegexp();
					return this.parseRegExpLiteral(this.state.value);
				}
				case 135: return this.parseNumericLiteral(this.state.value);
				case 136: return this.parseBigIntLiteral(this.state.value);
				case 134: return this.parseStringLiteral(this.state.value);
				case 84: return this.parseNullLiteral();
				case 85: return this.parseBooleanLiteral(true);
				case 86: return this.parseBooleanLiteral(false);
				case 10: {
					const canBeArrow = this.state.potentialArrowAt === this.state.start;
					return this.parseParenAndDistinguishExpression(canBeArrow);
				}
				case 0: return this.parseArrayLike(3, true, false, refExpressionErrors);
				case 5: return this.parseObjectLike(8, false, false, refExpressionErrors);
				case 68: return this.parseFunctionOrFunctionSent();
				case 26: decorators = this.parseDecorators();
				case 80: return this.parseClass(this.maybeTakeDecorators(decorators, this.startNode()), false);
				case 77: return this.parseNewOrNewTarget();
				case 25:
				case 24: return this.parseTemplate(false);
				case 15: {
					node = this.startNode();
					this.next();
					node.object = null;
					const callee = node.callee = this.parseNoCallExpr();
					if (callee.type === "MemberExpression") return this.finishNode(node, "BindExpression");
					else throw this.raise(Errors.UnsupportedBind, callee);
				}
				case 139: {
					this.raise(Errors.PrivateInExpectedIn, this.state.startLoc, { identifierName: this.state.value });
					return this.parsePrivateName();
				}
				case 33: return this.parseTopicReferenceThenEqualsSign(54, "%");
				case 32: return this.parseTopicReferenceThenEqualsSign(44, "^");
				case 37:
				case 38: return this.parseTopicReference("hack");
				case 44:
				case 54:
				case 27: {
					const pipeProposal = this.getPluginOption("pipelineOperator", "proposal");
					if (pipeProposal) return this.parseTopicReference(pipeProposal);
					this.unexpected();
					break;
				}
				case 47: {
					const lookaheadCh = this.input.codePointAt(this.nextTokenStart());
					if (isIdentifierStart(lookaheadCh) || lookaheadCh === 62) this.expectOnePlugin([
						"jsx",
						"flow",
						"typescript"
					]);
					else this.unexpected();
					break;
				}
				default:
					if (type === 137) return this.parseDecimalLiteral(this.state.value);
					else if (type === 2 || type === 1) return this.parseArrayLike(this.state.type === 2 ? 4 : 3, false, true);
					else if (type === 6 || type === 7) return this.parseObjectLike(this.state.type === 6 ? 9 : 8, false, true);
					if (tokenIsIdentifier(type)) {
						if (this.isContextual(127) && this.lookaheadInLineCharCode() === 123) return this.parseModuleExpression();
						const canBeArrow = this.state.potentialArrowAt === this.state.start;
						const containsEsc = this.state.containsEsc;
						const id = this.parseIdentifier();
						if (!containsEsc && id.name === "async" && !this.canInsertSemicolon()) {
							const { type: type$1 } = this.state;
							if (type$1 === 68) {
								this.resetPreviousNodeTrailingComments(id);
								this.next();
								return this.parseAsyncFunctionExpression(this.startNodeAtNode(id));
							} else if (tokenIsIdentifier(type$1)) if (this.lookaheadCharCode() === 61) return this.parseAsyncArrowUnaryFunction(this.startNodeAtNode(id));
							else return id;
							else if (type$1 === 90) {
								this.resetPreviousNodeTrailingComments(id);
								return this.parseDo(this.startNodeAtNode(id), true);
							}
						}
						if (canBeArrow && this.match(19) && !this.canInsertSemicolon()) {
							this.next();
							return this.parseArrowExpression(this.startNodeAtNode(id), [id], false);
						}
						return id;
					} else this.unexpected();
			}
		}
		parseTopicReferenceThenEqualsSign(topicTokenType, topicTokenValue) {
			const pipeProposal = this.getPluginOption("pipelineOperator", "proposal");
			if (pipeProposal) {
				this.state.type = topicTokenType;
				this.state.value = topicTokenValue;
				this.state.pos--;
				this.state.end--;
				this.state.endLoc = createPositionWithColumnOffset(this.state.endLoc, -1);
				return this.parseTopicReference(pipeProposal);
			} else this.unexpected();
		}
		parseTopicReference(pipeProposal) {
			const node = this.startNode();
			const startLoc = this.state.startLoc;
			const tokenType = this.state.type;
			this.next();
			return this.finishTopicReference(node, startLoc, pipeProposal, tokenType);
		}
		finishTopicReference(node, startLoc, pipeProposal, tokenType) {
			if (this.testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType)) if (pipeProposal === "hack") {
				if (!this.topicReferenceIsAllowedInCurrentContext()) this.raise(Errors.PipeTopicUnbound, startLoc);
				this.registerTopicReference();
				return this.finishNode(node, "TopicReference");
			} else {
				if (!this.topicReferenceIsAllowedInCurrentContext()) this.raise(Errors.PrimaryTopicNotAllowed, startLoc);
				this.registerTopicReference();
				return this.finishNode(node, "PipelinePrimaryTopicReference");
			}
			else throw this.raise(Errors.PipeTopicUnconfiguredToken, startLoc, { token: tokenLabelName(tokenType) });
		}
		testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType) {
			switch (pipeProposal) {
				case "hack": return this.hasPlugin(["pipelineOperator", { topicToken: tokenLabelName(tokenType) }]);
				case "smart": return tokenType === 27;
				default: throw this.raise(Errors.PipeTopicRequiresHackPipes, startLoc);
			}
		}
		parseAsyncArrowUnaryFunction(node) {
			this.prodParam.enter(functionFlags(true, this.prodParam.hasYield));
			const params = [this.parseIdentifier()];
			this.prodParam.exit();
			if (this.hasPrecedingLineBreak()) this.raise(Errors.LineTerminatorBeforeArrow, this.state.curPosition());
			this.expect(19);
			return this.parseArrowExpression(node, params, true);
		}
		parseDo(node, isAsync) {
			this.expectPlugin("doExpressions");
			if (isAsync) this.expectPlugin("asyncDoExpressions");
			node.async = isAsync;
			this.next();
			const oldLabels = this.state.labels;
			this.state.labels = [];
			if (isAsync) {
				this.prodParam.enter(2);
				node.body = this.parseBlock();
				this.prodParam.exit();
			} else node.body = this.parseBlock();
			this.state.labels = oldLabels;
			return this.finishNode(node, "DoExpression");
		}
		parseSuper() {
			const node = this.startNode();
			this.next();
			if (this.match(10) && !this.scope.allowDirectSuper && !(this.optionFlags & 16)) this.raise(Errors.SuperNotAllowed, node);
			else if (!this.scope.allowSuper && !(this.optionFlags & 16)) this.raise(Errors.UnexpectedSuper, node);
			if (!this.match(10) && !this.match(0) && !this.match(16)) this.raise(Errors.UnsupportedSuper, node);
			return this.finishNode(node, "Super");
		}
		parsePrivateName() {
			const node = this.startNode();
			const id = this.startNodeAt(createPositionWithColumnOffset(this.state.startLoc, 1));
			const name = this.state.value;
			this.next();
			node.id = this.createIdentifier(id, name);
			return this.finishNode(node, "PrivateName");
		}
		parseFunctionOrFunctionSent() {
			const node = this.startNode();
			this.next();
			if (this.prodParam.hasYield && this.match(16)) {
				const meta = this.createIdentifier(this.startNodeAtNode(node), "function");
				this.next();
				if (this.match(103)) this.expectPlugin("functionSent");
				else if (!this.hasPlugin("functionSent")) this.unexpected();
				return this.parseMetaProperty(node, meta, "sent");
			}
			return this.parseFunction(node);
		}
		parseMetaProperty(node, meta, propertyName) {
			node.meta = meta;
			const containsEsc = this.state.containsEsc;
			node.property = this.parseIdentifier(true);
			if (node.property.name !== propertyName || containsEsc) this.raise(Errors.UnsupportedMetaProperty, node.property, {
				target: meta.name,
				onlyValidPropertyName: propertyName
			});
			return this.finishNode(node, "MetaProperty");
		}
		parseImportMetaPropertyOrPhaseCall(node) {
			this.next();
			if (this.isContextual(105) || this.isContextual(97)) {
				const isSource = this.isContextual(105);
				this.expectPlugin(isSource ? "sourcePhaseImports" : "deferredImportEvaluation");
				this.next();
				node.phase = isSource ? "source" : "defer";
				return this.parseImportCall(node);
			} else {
				const id = this.createIdentifierAt(this.startNodeAtNode(node), "import", this.state.lastTokStartLoc);
				if (this.isContextual(101)) {
					if (!this.inModule) this.raise(Errors.ImportMetaOutsideModule, id);
					this.sawUnambiguousESM = true;
				}
				return this.parseMetaProperty(node, id, "meta");
			}
		}
		parseLiteralAtNode(value, type, node) {
			this.addExtra(node, "rawValue", value);
			this.addExtra(node, "raw", this.input.slice(this.offsetToSourcePos(node.start), this.state.end));
			node.value = value;
			this.next();
			return this.finishNode(node, type);
		}
		parseLiteral(value, type) {
			const node = this.startNode();
			return this.parseLiteralAtNode(value, type, node);
		}
		parseStringLiteral(value) {
			return this.parseLiteral(value, "StringLiteral");
		}
		parseNumericLiteral(value) {
			return this.parseLiteral(value, "NumericLiteral");
		}
		parseBigIntLiteral(value) {
			return this.parseLiteral(value, "BigIntLiteral");
		}
		parseDecimalLiteral(value) {
			return this.parseLiteral(value, "DecimalLiteral");
		}
		parseRegExpLiteral(value) {
			const node = this.startNode();
			this.addExtra(node, "raw", this.input.slice(this.offsetToSourcePos(node.start), this.state.end));
			node.pattern = value.pattern;
			node.flags = value.flags;
			this.next();
			return this.finishNode(node, "RegExpLiteral");
		}
		parseBooleanLiteral(value) {
			const node = this.startNode();
			node.value = value;
			this.next();
			return this.finishNode(node, "BooleanLiteral");
		}
		parseNullLiteral() {
			const node = this.startNode();
			this.next();
			return this.finishNode(node, "NullLiteral");
		}
		parseParenAndDistinguishExpression(canBeArrow) {
			const startLoc = this.state.startLoc;
			let val;
			this.next();
			this.expressionScope.enter(newArrowHeadScope());
			const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
			const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
			this.state.maybeInArrowParameters = true;
			this.state.inFSharpPipelineDirectBody = false;
			const innerStartLoc = this.state.startLoc;
			const exprList = [];
			const refExpressionErrors = new ExpressionErrors();
			let first = true;
			let spreadStartLoc;
			let optionalCommaStartLoc;
			while (!this.match(11)) {
				if (first) first = false;
				else {
					this.expect(12, refExpressionErrors.optionalParametersLoc === null ? null : refExpressionErrors.optionalParametersLoc);
					if (this.match(11)) {
						optionalCommaStartLoc = this.state.startLoc;
						break;
					}
				}
				if (this.match(21)) {
					const spreadNodeStartLoc = this.state.startLoc;
					spreadStartLoc = this.state.startLoc;
					exprList.push(this.parseParenItem(this.parseRestBinding(), spreadNodeStartLoc));
					if (!this.checkCommaAfterRest(41)) break;
				} else exprList.push(this.parseMaybeAssignAllowInOrVoidPattern(11, refExpressionErrors, this.parseParenItem));
			}
			const innerEndLoc = this.state.lastTokEndLoc;
			this.expect(11);
			this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
			this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
			let arrowNode = this.startNodeAt(startLoc);
			if (canBeArrow && this.shouldParseArrow(exprList) && (arrowNode = this.parseArrow(arrowNode))) {
				this.checkDestructuringPrivate(refExpressionErrors);
				this.expressionScope.validateAsPattern();
				this.expressionScope.exit();
				this.parseArrowExpression(arrowNode, exprList, false);
				return arrowNode;
			}
			this.expressionScope.exit();
			if (!exprList.length) this.unexpected(this.state.lastTokStartLoc);
			if (optionalCommaStartLoc) this.unexpected(optionalCommaStartLoc);
			if (spreadStartLoc) this.unexpected(spreadStartLoc);
			this.checkExpressionErrors(refExpressionErrors, true);
			this.toReferencedListDeep(exprList, true);
			if (exprList.length > 1) {
				val = this.startNodeAt(innerStartLoc);
				val.expressions = exprList;
				this.finishNode(val, "SequenceExpression");
				this.resetEndLocation(val, innerEndLoc);
			} else val = exprList[0];
			return this.wrapParenthesis(startLoc, val);
		}
		wrapParenthesis(startLoc, expression) {
			if (!(this.optionFlags & 1024)) {
				this.addExtra(expression, "parenthesized", true);
				this.addExtra(expression, "parenStart", startLoc.index);
				this.takeSurroundingComments(expression, startLoc.index, this.state.lastTokEndLoc.index);
				return expression;
			}
			const parenExpression = this.startNodeAt(startLoc);
			parenExpression.expression = expression;
			return this.finishNode(parenExpression, "ParenthesizedExpression");
		}
		shouldParseArrow(params) {
			return !this.canInsertSemicolon();
		}
		parseArrow(node) {
			if (this.eat(19)) return node;
		}
		parseParenItem(node, startLoc) {
			return node;
		}
		parseNewOrNewTarget() {
			const node = this.startNode();
			this.next();
			if (this.match(16)) {
				const meta = this.createIdentifier(this.startNodeAtNode(node), "new");
				this.next();
				const metaProp = this.parseMetaProperty(node, meta, "target");
				if (!this.scope.allowNewTarget) this.raise(Errors.UnexpectedNewTarget, metaProp);
				return metaProp;
			}
			return this.parseNew(node);
		}
		parseNew(node) {
			this.parseNewCallee(node);
			if (this.eat(10)) {
				const args = this.parseExprList(11);
				this.toReferencedList(args);
				node.arguments = args;
			} else node.arguments = [];
			return this.finishNode(node, "NewExpression");
		}
		parseNewCallee(node) {
			const isImport = this.match(83);
			const callee = this.parseNoCallExpr();
			node.callee = callee;
			if (isImport && (callee.type === "Import" || callee.type === "ImportExpression")) this.raise(Errors.ImportCallNotNewExpression, callee);
		}
		parseTemplateElement(isTagged) {
			const { start, startLoc, end, value } = this.state;
			const elemStart = start + 1;
			const elem = this.startNodeAt(createPositionWithColumnOffset(startLoc, 1));
			if (value === null) {
				if (!isTagged) this.raise(Errors.InvalidEscapeSequenceTemplate, createPositionWithColumnOffset(this.state.firstInvalidTemplateEscapePos, 1));
			}
			const isTail = this.match(24);
			const endOffset = isTail ? -1 : -2;
			const elemEnd = end + endOffset;
			elem.value = {
				raw: this.input.slice(elemStart, elemEnd).replace(/\r\n?/g, "\n"),
				cooked: value === null ? null : value.slice(1, endOffset)
			};
			elem.tail = isTail;
			this.next();
			const finishedNode = this.finishNode(elem, "TemplateElement");
			this.resetEndLocation(finishedNode, createPositionWithColumnOffset(this.state.lastTokEndLoc, endOffset));
			return finishedNode;
		}
		parseTemplate(isTagged) {
			const node = this.startNode();
			let curElt = this.parseTemplateElement(isTagged);
			const quasis = [curElt];
			const substitutions = [];
			while (!curElt.tail) {
				substitutions.push(this.parseTemplateSubstitution());
				this.readTemplateContinuation();
				quasis.push(curElt = this.parseTemplateElement(isTagged));
			}
			node.expressions = substitutions;
			node.quasis = quasis;
			return this.finishNode(node, "TemplateLiteral");
		}
		parseTemplateSubstitution() {
			return this.parseExpression();
		}
		parseObjectLike(close, isPattern, isRecord, refExpressionErrors) {
			if (isRecord) this.expectPlugin("recordAndTuple");
			const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
			this.state.inFSharpPipelineDirectBody = false;
			let sawProto = false;
			let first = true;
			const node = this.startNode();
			node.properties = [];
			this.next();
			while (!this.match(close)) {
				if (first) first = false;
				else {
					this.expect(12);
					if (this.match(close)) {
						this.addTrailingCommaExtraToNode(node);
						break;
					}
				}
				let prop;
				if (isPattern) prop = this.parseBindingProperty();
				else {
					prop = this.parsePropertyDefinition(refExpressionErrors);
					sawProto = this.checkProto(prop, isRecord, sawProto, refExpressionErrors);
				}
				if (isRecord && !this.isObjectProperty(prop) && prop.type !== "SpreadElement") this.raise(Errors.InvalidRecordProperty, prop);
				if (prop.shorthand) this.addExtra(prop, "shorthand", true);
				node.properties.push(prop);
			}
			this.next();
			this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
			let type = "ObjectExpression";
			if (isPattern) type = "ObjectPattern";
			else if (isRecord) type = "RecordExpression";
			return this.finishNode(node, type);
		}
		addTrailingCommaExtraToNode(node) {
			this.addExtra(node, "trailingComma", this.state.lastTokStartLoc.index);
			this.addExtra(node, "trailingCommaLoc", this.state.lastTokStartLoc, false);
		}
		maybeAsyncOrAccessorProp(prop) {
			return !prop.computed && prop.key.type === "Identifier" && (this.isLiteralPropertyName() || this.match(0) || this.match(55));
		}
		parsePropertyDefinition(refExpressionErrors) {
			let decorators = [];
			if (this.match(26)) {
				if (this.hasPlugin("decorators")) this.raise(Errors.UnsupportedPropertyDecorator, this.state.startLoc);
				while (this.match(26)) decorators.push(this.parseDecorator());
			}
			const prop = this.startNode();
			let isAsync = false;
			let isAccessor = false;
			let startLoc;
			if (this.match(21)) {
				if (decorators.length) this.unexpected();
				return this.parseSpread();
			}
			if (decorators.length) {
				prop.decorators = decorators;
				decorators = [];
			}
			prop.method = false;
			if (refExpressionErrors) startLoc = this.state.startLoc;
			let isGenerator = this.eat(55);
			this.parsePropertyNamePrefixOperator(prop);
			const containsEsc = this.state.containsEsc;
			this.parsePropertyName(prop, refExpressionErrors);
			if (!isGenerator && !containsEsc && this.maybeAsyncOrAccessorProp(prop)) {
				const { key } = prop;
				const keyName = key.name;
				if (keyName === "async" && !this.hasPrecedingLineBreak()) {
					isAsync = true;
					this.resetPreviousNodeTrailingComments(key);
					isGenerator = this.eat(55);
					this.parsePropertyName(prop);
				}
				if (keyName === "get" || keyName === "set") {
					isAccessor = true;
					this.resetPreviousNodeTrailingComments(key);
					prop.kind = keyName;
					if (this.match(55)) {
						isGenerator = true;
						this.raise(Errors.AccessorIsGenerator, this.state.curPosition(), { kind: keyName });
						this.next();
					}
					this.parsePropertyName(prop);
				}
			}
			return this.parseObjPropValue(prop, startLoc, isGenerator, isAsync, false, isAccessor, refExpressionErrors);
		}
		getGetterSetterExpectedParamCount(method) {
			return method.kind === "get" ? 0 : 1;
		}
		getObjectOrClassMethodParams(method) {
			return method.params;
		}
		checkGetterSetterParams(method) {
			var _params;
			const paramCount = this.getGetterSetterExpectedParamCount(method);
			const params = this.getObjectOrClassMethodParams(method);
			if (params.length !== paramCount) this.raise(method.kind === "get" ? Errors.BadGetterArity : Errors.BadSetterArity, method);
			if (method.kind === "set" && ((_params = params[params.length - 1]) == null ? void 0 : _params.type) === "RestElement") this.raise(Errors.BadSetterRestParameter, method);
		}
		parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
			if (isAccessor) {
				const finishedProp = this.parseMethod(prop, isGenerator, false, false, false, "ObjectMethod");
				this.checkGetterSetterParams(finishedProp);
				return finishedProp;
			}
			if (isAsync || isGenerator || this.match(10)) {
				if (isPattern) this.unexpected();
				prop.kind = "method";
				prop.method = true;
				return this.parseMethod(prop, isGenerator, isAsync, false, false, "ObjectMethod");
			}
		}
		parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
			prop.shorthand = false;
			if (this.eat(14)) {
				prop.value = isPattern ? this.parseMaybeDefault(this.state.startLoc) : this.parseMaybeAssignAllowInOrVoidPattern(8, refExpressionErrors);
				return this.finishObjectProperty(prop);
			}
			if (!prop.computed && prop.key.type === "Identifier") {
				this.checkReservedWord(prop.key.name, prop.key.loc.start, true, false);
				if (isPattern) prop.value = this.parseMaybeDefault(startLoc, this.cloneIdentifier(prop.key));
				else if (this.match(29)) {
					const shorthandAssignLoc = this.state.startLoc;
					if (refExpressionErrors != null) {
						if (refExpressionErrors.shorthandAssignLoc === null) refExpressionErrors.shorthandAssignLoc = shorthandAssignLoc;
					} else this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
					prop.value = this.parseMaybeDefault(startLoc, this.cloneIdentifier(prop.key));
				} else prop.value = this.cloneIdentifier(prop.key);
				prop.shorthand = true;
				return this.finishObjectProperty(prop);
			}
		}
		finishObjectProperty(node) {
			return this.finishNode(node, "ObjectProperty");
		}
		parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
			const node = this.parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) || this.parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors);
			if (!node) this.unexpected();
			return node;
		}
		parsePropertyName(prop, refExpressionErrors) {
			if (this.eat(0)) {
				prop.computed = true;
				prop.key = this.parseMaybeAssignAllowIn();
				this.expect(3);
			} else {
				const { type, value } = this.state;
				let key;
				if (tokenIsKeywordOrIdentifier(type)) key = this.parseIdentifier(true);
				else switch (type) {
					case 135:
						key = this.parseNumericLiteral(value);
						break;
					case 134:
						key = this.parseStringLiteral(value);
						break;
					case 136:
						key = this.parseBigIntLiteral(value);
						break;
					case 139: {
						const privateKeyLoc = this.state.startLoc;
						if (refExpressionErrors != null) {
							if (refExpressionErrors.privateKeyLoc === null) refExpressionErrors.privateKeyLoc = privateKeyLoc;
						} else this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
						key = this.parsePrivateName();
						break;
					}
					default:
						if (type === 137) {
							key = this.parseDecimalLiteral(value);
							break;
						}
						this.unexpected();
				}
				prop.key = key;
				if (type !== 139) prop.computed = false;
			}
		}
		initFunction(node, isAsync) {
			node.id = null;
			node.generator = false;
			node.async = isAsync;
		}
		parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope = false) {
			this.initFunction(node, isAsync);
			node.generator = isGenerator;
			this.scope.enter(530 | (inClassScope ? 576 : 0) | (allowDirectSuper ? 32 : 0));
			this.prodParam.enter(functionFlags(isAsync, node.generator));
			this.parseFunctionParams(node, isConstructor);
			const finishedNode = this.parseFunctionBodyAndFinish(node, type, true);
			this.prodParam.exit();
			this.scope.exit();
			return finishedNode;
		}
		parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
			if (isTuple) this.expectPlugin("recordAndTuple");
			const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
			this.state.inFSharpPipelineDirectBody = false;
			const node = this.startNode();
			this.next();
			node.elements = this.parseExprList(close, !isTuple, refExpressionErrors, node);
			this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
			return this.finishNode(node, isTuple ? "TupleExpression" : "ArrayExpression");
		}
		parseArrowExpression(node, params, isAsync, trailingCommaLoc) {
			this.scope.enter(518);
			let flags = functionFlags(isAsync, false);
			if (!this.match(5) && this.prodParam.hasIn) flags |= 8;
			this.prodParam.enter(flags);
			this.initFunction(node, isAsync);
			const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
			if (params) {
				this.state.maybeInArrowParameters = true;
				this.setArrowFunctionParameters(node, params, trailingCommaLoc);
			}
			this.state.maybeInArrowParameters = false;
			this.parseFunctionBody(node, true);
			this.prodParam.exit();
			this.scope.exit();
			this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
			return this.finishNode(node, "ArrowFunctionExpression");
		}
		setArrowFunctionParameters(node, params, trailingCommaLoc) {
			this.toAssignableList(params, trailingCommaLoc, false);
			node.params = params;
		}
		parseFunctionBodyAndFinish(node, type, isMethod = false) {
			this.parseFunctionBody(node, false, isMethod);
			return this.finishNode(node, type);
		}
		parseFunctionBody(node, allowExpression, isMethod = false) {
			const isExpression = allowExpression && !this.match(5);
			this.expressionScope.enter(newExpressionScope());
			if (isExpression) {
				node.body = this.parseMaybeAssign();
				this.checkParams(node, false, allowExpression, false);
			} else {
				const oldStrict = this.state.strict;
				const oldLabels = this.state.labels;
				this.state.labels = [];
				this.prodParam.enter(this.prodParam.currentFlags() | 4);
				node.body = this.parseBlock(true, false, (hasStrictModeDirective) => {
					const nonSimple = !this.isSimpleParamList(node.params);
					if (hasStrictModeDirective && nonSimple) this.raise(Errors.IllegalLanguageModeDirective, (node.kind === "method" || node.kind === "constructor") && !!node.key ? node.key.loc.end : node);
					const strictModeChanged = !oldStrict && this.state.strict;
					this.checkParams(node, !this.state.strict && !allowExpression && !isMethod && !nonSimple, allowExpression, strictModeChanged);
					if (this.state.strict && node.id) this.checkIdentifier(node.id, 65, strictModeChanged);
				});
				this.prodParam.exit();
				this.state.labels = oldLabels;
			}
			this.expressionScope.exit();
		}
		isSimpleParameter(node) {
			return node.type === "Identifier";
		}
		isSimpleParamList(params) {
			for (let i = 0, len$1 = params.length; i < len$1; i++) if (!this.isSimpleParameter(params[i])) return false;
			return true;
		}
		checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged = true) {
			const checkClashes = !allowDuplicates && /* @__PURE__ */ new Set();
			const formalParameters = { type: "FormalParameters" };
			for (const param of node.params) this.checkLVal(param, formalParameters, 5, checkClashes, strictModeChanged);
		}
		parseExprList(close, allowEmpty, refExpressionErrors, nodeForExtra) {
			const elts = [];
			let first = true;
			while (!this.eat(close)) {
				if (first) first = false;
				else {
					this.expect(12);
					if (this.match(close)) {
						if (nodeForExtra) this.addTrailingCommaExtraToNode(nodeForExtra);
						this.next();
						break;
					}
				}
				elts.push(this.parseExprListItem(close, allowEmpty, refExpressionErrors));
			}
			return elts;
		}
		parseExprListItem(close, allowEmpty, refExpressionErrors, allowPlaceholder) {
			let elt;
			if (this.match(12)) {
				if (!allowEmpty) this.raise(Errors.UnexpectedToken, this.state.curPosition(), { unexpected: "," });
				elt = null;
			} else if (this.match(21)) {
				const spreadNodeStartLoc = this.state.startLoc;
				elt = this.parseParenItem(this.parseSpread(refExpressionErrors), spreadNodeStartLoc);
			} else if (this.match(17)) {
				this.expectPlugin("partialApplication");
				if (!allowPlaceholder) this.raise(Errors.UnexpectedArgumentPlaceholder, this.state.startLoc);
				const node = this.startNode();
				this.next();
				elt = this.finishNode(node, "ArgumentPlaceholder");
			} else elt = this.parseMaybeAssignAllowInOrVoidPattern(close, refExpressionErrors, this.parseParenItem);
			return elt;
		}
		parseIdentifier(liberal) {
			const node = this.startNode();
			const name = this.parseIdentifierName(liberal);
			return this.createIdentifier(node, name);
		}
		createIdentifier(node, name) {
			node.name = name;
			node.loc.identifierName = name;
			return this.finishNode(node, "Identifier");
		}
		createIdentifierAt(node, name, endLoc) {
			node.name = name;
			node.loc.identifierName = name;
			return this.finishNodeAt(node, "Identifier", endLoc);
		}
		parseIdentifierName(liberal) {
			let name;
			const { startLoc, type } = this.state;
			if (tokenIsKeywordOrIdentifier(type)) name = this.state.value;
			else this.unexpected();
			const tokenIsKeyword$1 = tokenKeywordOrIdentifierIsKeyword(type);
			if (liberal) {
				if (tokenIsKeyword$1) this.replaceToken(132);
			} else this.checkReservedWord(name, startLoc, tokenIsKeyword$1, false);
			this.next();
			return name;
		}
		checkReservedWord(word, startLoc, checkKeywords, isBinding) {
			if (word.length > 10) return;
			if (!canBeReservedWord(word)) return;
			if (checkKeywords && isKeyword(word)) {
				this.raise(Errors.UnexpectedKeyword, startLoc, { keyword: word });
				return;
			}
			const reservedTest = !this.state.strict ? isReservedWord : isBinding ? isStrictBindReservedWord : isStrictReservedWord;
			if (reservedTest(word, this.inModule)) {
				this.raise(Errors.UnexpectedReservedWord, startLoc, { reservedWord: word });
				return;
			} else if (word === "yield") {
				if (this.prodParam.hasYield) {
					this.raise(Errors.YieldBindingIdentifier, startLoc);
					return;
				}
			} else if (word === "await") {
				if (this.prodParam.hasAwait) {
					this.raise(Errors.AwaitBindingIdentifier, startLoc);
					return;
				}
				if (this.scope.inStaticBlock) {
					this.raise(Errors.AwaitBindingIdentifierInStaticBlock, startLoc);
					return;
				}
				this.expressionScope.recordAsyncArrowParametersError(startLoc);
			} else if (word === "arguments") {
				if (this.scope.inClassAndNotInNonArrowFunction) {
					this.raise(Errors.ArgumentsInClass, startLoc);
					return;
				}
			}
		}
		recordAwaitIfAllowed() {
			const isAwaitAllowed = this.prodParam.hasAwait;
			if (isAwaitAllowed && !this.scope.inFunction) this.state.hasTopLevelAwait = true;
			return isAwaitAllowed;
		}
		parseAwait(startLoc) {
			const node = this.startNodeAt(startLoc);
			this.expressionScope.recordParameterInitializerError(Errors.AwaitExpressionFormalParameter, node);
			if (this.eat(55)) this.raise(Errors.ObsoleteAwaitStar, node);
			if (!this.scope.inFunction && !(this.optionFlags & 1)) if (this.isAmbiguousPrefixOrIdentifier()) this.ambiguousScriptDifferentAst = true;
			else this.sawUnambiguousESM = true;
			if (!this.state.soloAwait) node.argument = this.parseMaybeUnary(null, true);
			return this.finishNode(node, "AwaitExpression");
		}
		isAmbiguousPrefixOrIdentifier() {
			if (this.hasPrecedingLineBreak()) return true;
			const { type } = this.state;
			return type === 53 || type === 10 || type === 0 || tokenIsTemplate(type) || type === 102 && !this.state.containsEsc || type === 138 || type === 56 || this.hasPlugin("v8intrinsic") && type === 54;
		}
		parseYield(startLoc) {
			const node = this.startNodeAt(startLoc);
			this.expressionScope.recordParameterInitializerError(Errors.YieldInParameter, node);
			let delegating = false;
			let argument = null;
			if (!this.hasPrecedingLineBreak()) {
				delegating = this.eat(55);
				switch (this.state.type) {
					case 13:
					case 140:
					case 8:
					case 11:
					case 3:
					case 9:
					case 14:
					case 12: if (!delegating) break;
					default: argument = this.parseMaybeAssign();
				}
			}
			node.delegate = delegating;
			node.argument = argument;
			return this.finishNode(node, "YieldExpression");
		}
		parseImportCall(node) {
			this.next();
			node.source = this.parseMaybeAssignAllowIn();
			node.options = null;
			if (this.eat(12)) if (!this.match(11)) {
				node.options = this.parseMaybeAssignAllowIn();
				if (this.eat(12)) {
					this.addTrailingCommaExtraToNode(node.options);
					if (!this.match(11)) {
						do
							this.parseMaybeAssignAllowIn();
						while (this.eat(12) && !this.match(11));
						this.raise(Errors.ImportCallArity, node);
					}
				}
			} else this.addTrailingCommaExtraToNode(node.source);
			this.expect(11);
			return this.finishNode(node, "ImportExpression");
		}
		checkPipelineAtInfixOperator(left, leftStartLoc) {
			if (this.hasPlugin(["pipelineOperator", { proposal: "smart" }])) {
				if (left.type === "SequenceExpression") this.raise(Errors.PipelineHeadSequenceExpression, leftStartLoc);
			}
		}
		parseSmartPipelineBodyInStyle(childExpr, startLoc) {
			if (this.isSimpleReference(childExpr)) {
				const bodyNode = this.startNodeAt(startLoc);
				bodyNode.callee = childExpr;
				return this.finishNode(bodyNode, "PipelineBareFunction");
			} else {
				const bodyNode = this.startNodeAt(startLoc);
				this.checkSmartPipeTopicBodyEarlyErrors(startLoc);
				bodyNode.expression = childExpr;
				return this.finishNode(bodyNode, "PipelineTopicExpression");
			}
		}
		isSimpleReference(expression) {
			switch (expression.type) {
				case "MemberExpression": return !expression.computed && this.isSimpleReference(expression.object);
				case "Identifier": return true;
				default: return false;
			}
		}
		checkSmartPipeTopicBodyEarlyErrors(startLoc) {
			if (this.match(19)) throw this.raise(Errors.PipelineBodyNoArrow, this.state.startLoc);
			if (!this.topicReferenceWasUsedInCurrentContext()) this.raise(Errors.PipelineTopicUnused, startLoc);
		}
		withTopicBindingContext(callback) {
			const outerContextTopicState = this.state.topicContext;
			this.state.topicContext = {
				maxNumOfResolvableTopics: 1,
				maxTopicIndex: null
			};
			try {
				return callback();
			} finally {
				this.state.topicContext = outerContextTopicState;
			}
		}
		withSmartMixTopicForbiddingContext(callback) {
			if (this.hasPlugin(["pipelineOperator", { proposal: "smart" }])) {
				const outerContextTopicState = this.state.topicContext;
				this.state.topicContext = {
					maxNumOfResolvableTopics: 0,
					maxTopicIndex: null
				};
				try {
					return callback();
				} finally {
					this.state.topicContext = outerContextTopicState;
				}
			} else return callback();
		}
		withSoloAwaitPermittingContext(callback) {
			const outerContextSoloAwaitState = this.state.soloAwait;
			this.state.soloAwait = true;
			try {
				return callback();
			} finally {
				this.state.soloAwait = outerContextSoloAwaitState;
			}
		}
		allowInAnd(callback) {
			const flags = this.prodParam.currentFlags();
			const prodParamToSet = 8 & ~flags;
			if (prodParamToSet) {
				this.prodParam.enter(flags | 8);
				try {
					return callback();
				} finally {
					this.prodParam.exit();
				}
			}
			return callback();
		}
		disallowInAnd(callback) {
			const flags = this.prodParam.currentFlags();
			const prodParamToClear = 8 & flags;
			if (prodParamToClear) {
				this.prodParam.enter(flags & -9);
				try {
					return callback();
				} finally {
					this.prodParam.exit();
				}
			}
			return callback();
		}
		registerTopicReference() {
			this.state.topicContext.maxTopicIndex = 0;
		}
		topicReferenceIsAllowedInCurrentContext() {
			return this.state.topicContext.maxNumOfResolvableTopics >= 1;
		}
		topicReferenceWasUsedInCurrentContext() {
			return this.state.topicContext.maxTopicIndex != null && this.state.topicContext.maxTopicIndex >= 0;
		}
		parseFSharpPipelineBody(prec) {
			const startLoc = this.state.startLoc;
			this.state.potentialArrowAt = this.state.start;
			const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
			this.state.inFSharpPipelineDirectBody = true;
			const ret = this.parseExprOp(this.parseMaybeUnaryOrPrivate(), startLoc, prec);
			this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
			return ret;
		}
		parseModuleExpression() {
			this.expectPlugin("moduleBlocks");
			const node = this.startNode();
			this.next();
			if (!this.match(5)) this.unexpected(null, 5);
			const program = this.startNodeAt(this.state.endLoc);
			this.next();
			const revertScopes = this.initializeScopes(true);
			this.enterInitialScopes();
			try {
				node.body = this.parseProgram(program, 8, "module");
			} finally {
				revertScopes();
			}
			return this.finishNode(node, "ModuleExpression");
		}
		parseVoidPattern(refExpressionErrors) {
			this.expectPlugin("discardBinding");
			const node = this.startNode();
			if (refExpressionErrors != null) refExpressionErrors.voidPatternLoc = this.state.startLoc;
			this.next();
			return this.finishNode(node, "VoidPattern");
		}
		parseMaybeAssignAllowInOrVoidPattern(close, refExpressionErrors, afterLeftParse) {
			if (refExpressionErrors != null && this.match(88)) {
				const nextCode = this.lookaheadCharCode();
				if (nextCode === 44 || nextCode === (close === 3 ? 93 : close === 8 ? 125 : 41) || nextCode === 61) return this.parseMaybeDefault(this.state.startLoc, this.parseVoidPattern(refExpressionErrors));
			}
			return this.parseMaybeAssignAllowIn(refExpressionErrors, afterLeftParse);
		}
		parsePropertyNamePrefixOperator(prop) {}
	};
	const loopLabel = { kind: 1 }, switchLabel = { kind: 2 };
	const loneSurrogate = /[\uD800-\uDFFF]/u;
	const keywordRelationalOperator = /in(?:stanceof)?/y;
	function babel7CompatTokens(tokens, input, startIndex) {
		for (let i = 0; i < tokens.length; i++) {
			const token = tokens[i];
			const { type } = token;
			if (typeof type === "number") {
				{
					if (type === 139) {
						const { loc, start, value, end } = token;
						const hashEndPos = start + 1;
						const hashEndLoc = createPositionWithColumnOffset(loc.start, 1);
						tokens.splice(i, 1, new Token({
							type: getExportedToken(27),
							value: "#",
							start,
							end: hashEndPos,
							startLoc: loc.start,
							endLoc: hashEndLoc
						}), new Token({
							type: getExportedToken(132),
							value,
							start: hashEndPos,
							end,
							startLoc: hashEndLoc,
							endLoc: loc.end
						}));
						i++;
						continue;
					}
					if (tokenIsTemplate(type)) {
						const { loc, start, value, end } = token;
						const backquoteEnd = start + 1;
						const backquoteEndLoc = createPositionWithColumnOffset(loc.start, 1);
						let startToken;
						if (input.charCodeAt(start - startIndex) === 96) startToken = new Token({
							type: getExportedToken(22),
							value: "`",
							start,
							end: backquoteEnd,
							startLoc: loc.start,
							endLoc: backquoteEndLoc
						});
						else startToken = new Token({
							type: getExportedToken(8),
							value: "}",
							start,
							end: backquoteEnd,
							startLoc: loc.start,
							endLoc: backquoteEndLoc
						});
						let templateValue, templateElementEnd, templateElementEndLoc, endToken;
						if (type === 24) {
							templateElementEnd = end - 1;
							templateElementEndLoc = createPositionWithColumnOffset(loc.end, -1);
							templateValue = value === null ? null : value.slice(1, -1);
							endToken = new Token({
								type: getExportedToken(22),
								value: "`",
								start: templateElementEnd,
								end,
								startLoc: templateElementEndLoc,
								endLoc: loc.end
							});
						} else {
							templateElementEnd = end - 2;
							templateElementEndLoc = createPositionWithColumnOffset(loc.end, -2);
							templateValue = value === null ? null : value.slice(1, -2);
							endToken = new Token({
								type: getExportedToken(23),
								value: "${",
								start: templateElementEnd,
								end,
								startLoc: templateElementEndLoc,
								endLoc: loc.end
							});
						}
						tokens.splice(i, 1, startToken, new Token({
							type: getExportedToken(20),
							value: templateValue,
							start: backquoteEnd,
							end: templateElementEnd,
							startLoc: backquoteEndLoc,
							endLoc: templateElementEndLoc
						}), endToken);
						i += 2;
						continue;
					}
				}
				token.type = getExportedToken(type);
			}
		}
		return tokens;
	}
	var StatementParser = class extends ExpressionParser {
		parseTopLevel(file, program) {
			file.program = this.parseProgram(program, 140, this.options.sourceType === "module" ? "module" : "script");
			file.comments = this.comments;
			if (this.optionFlags & 256) file.tokens = babel7CompatTokens(this.tokens, this.input, this.startIndex);
			return this.finishNode(file, "File");
		}
		parseProgram(program, end, sourceType) {
			program.sourceType = sourceType;
			program.interpreter = this.parseInterpreterDirective();
			this.parseBlockBody(program, true, true, end);
			if (this.inModule) {
				if (!(this.optionFlags & 64) && this.scope.undefinedExports.size > 0) for (const [localName, at] of Array.from(this.scope.undefinedExports)) this.raise(Errors.ModuleExportUndefined, at, { localName });
				this.addExtra(program, "topLevelAwait", this.state.hasTopLevelAwait);
			}
			let finishedProgram;
			if (end === 140) finishedProgram = this.finishNode(program, "Program");
			else finishedProgram = this.finishNodeAt(program, "Program", createPositionWithColumnOffset(this.state.startLoc, -1));
			return finishedProgram;
		}
		stmtToDirective(stmt) {
			const directive = this.castNodeTo(stmt, "Directive");
			const directiveLiteral = this.castNodeTo(stmt.expression, "DirectiveLiteral");
			const expressionValue = directiveLiteral.value;
			const raw$1 = this.input.slice(this.offsetToSourcePos(directiveLiteral.start), this.offsetToSourcePos(directiveLiteral.end));
			const val = directiveLiteral.value = raw$1.slice(1, -1);
			this.addExtra(directiveLiteral, "raw", raw$1);
			this.addExtra(directiveLiteral, "rawValue", val);
			this.addExtra(directiveLiteral, "expressionValue", expressionValue);
			directive.value = directiveLiteral;
			delete stmt.expression;
			return directive;
		}
		parseInterpreterDirective() {
			if (!this.match(28)) return null;
			const node = this.startNode();
			node.value = this.state.value;
			this.next();
			return this.finishNode(node, "InterpreterDirective");
		}
		isLet() {
			if (!this.isContextual(100)) return false;
			return this.hasFollowingBindingAtom();
		}
		isUsing() {
			if (!this.isContextual(107)) return false;
			const next$1 = this.nextTokenInLineStart();
			const nextCh = this.codePointAtPos(next$1);
			return this.chStartsBindingIdentifier(nextCh, next$1);
		}
		isForUsing() {
			if (!this.isContextual(107)) return false;
			const next$1 = this.nextTokenInLineStart();
			const nextCh = this.codePointAtPos(next$1);
			if (this.isUnparsedContextual(next$1, "of")) {
				const nextCharAfterOf = this.lookaheadCharCodeSince(next$1 + 2);
				if (nextCharAfterOf !== 61 && nextCharAfterOf !== 58 && nextCharAfterOf !== 59) return false;
			}
			if (this.chStartsBindingIdentifier(nextCh, next$1) || this.isUnparsedContextual(next$1, "void")) return true;
			return false;
		}
		isAwaitUsing() {
			if (!this.isContextual(96)) return false;
			let next$1 = this.nextTokenInLineStart();
			if (this.isUnparsedContextual(next$1, "using")) {
				next$1 = this.nextTokenInLineStartSince(next$1 + 5);
				const nextCh = this.codePointAtPos(next$1);
				if (this.chStartsBindingIdentifier(nextCh, next$1)) return true;
			}
			return false;
		}
		chStartsBindingIdentifier(ch, pos) {
			if (isIdentifierStart(ch)) {
				keywordRelationalOperator.lastIndex = pos;
				if (keywordRelationalOperator.test(this.input)) {
					const endCh = this.codePointAtPos(keywordRelationalOperator.lastIndex);
					if (!isIdentifierChar(endCh) && endCh !== 92) return false;
				}
				return true;
			} else if (ch === 92) return true;
			else return false;
		}
		chStartsBindingPattern(ch) {
			return ch === 91 || ch === 123;
		}
		hasFollowingBindingAtom() {
			const next$1 = this.nextTokenStart();
			const nextCh = this.codePointAtPos(next$1);
			return this.chStartsBindingPattern(nextCh) || this.chStartsBindingIdentifier(nextCh, next$1);
		}
		hasInLineFollowingBindingIdentifierOrBrace() {
			const next$1 = this.nextTokenInLineStart();
			const nextCh = this.codePointAtPos(next$1);
			return nextCh === 123 || this.chStartsBindingIdentifier(nextCh, next$1);
		}
		allowsUsing() {
			return (this.scope.inModule || !this.scope.inTopLevel) && !this.scope.inBareCaseStatement;
		}
		parseModuleItem() {
			return this.parseStatementLike(15);
		}
		parseStatementListItem() {
			return this.parseStatementLike(6 | (!this.options.annexB || this.state.strict ? 0 : 8));
		}
		parseStatementOrSloppyAnnexBFunctionDeclaration(allowLabeledFunction = false) {
			let flags = 0;
			if (this.options.annexB && !this.state.strict) {
				flags |= 4;
				if (allowLabeledFunction) flags |= 8;
			}
			return this.parseStatementLike(flags);
		}
		parseStatement() {
			return this.parseStatementLike(0);
		}
		parseStatementLike(flags) {
			let decorators = null;
			if (this.match(26)) decorators = this.parseDecorators(true);
			return this.parseStatementContent(flags, decorators);
		}
		parseStatementContent(flags, decorators) {
			const startType = this.state.type;
			const node = this.startNode();
			const allowDeclaration = !!(flags & 2);
			const allowFunctionDeclaration = !!(flags & 4);
			const topLevel = flags & 1;
			switch (startType) {
				case 60: return this.parseBreakContinueStatement(node, true);
				case 63: return this.parseBreakContinueStatement(node, false);
				case 64: return this.parseDebuggerStatement(node);
				case 90: return this.parseDoWhileStatement(node);
				case 91: return this.parseForStatement(node);
				case 68:
					if (this.lookaheadCharCode() === 46) break;
					if (!allowFunctionDeclaration) this.raise(this.state.strict ? Errors.StrictFunction : this.options.annexB ? Errors.SloppyFunctionAnnexB : Errors.SloppyFunction, this.state.startLoc);
					return this.parseFunctionStatement(node, false, !allowDeclaration && allowFunctionDeclaration);
				case 80:
					if (!allowDeclaration) this.unexpected();
					return this.parseClass(this.maybeTakeDecorators(decorators, node), true);
				case 69: return this.parseIfStatement(node);
				case 70: return this.parseReturnStatement(node);
				case 71: return this.parseSwitchStatement(node);
				case 72: return this.parseThrowStatement(node);
				case 73: return this.parseTryStatement(node);
				case 96:
					if (this.isAwaitUsing()) {
						if (!this.allowsUsing()) this.raise(Errors.UnexpectedUsingDeclaration, node);
						else if (!allowDeclaration) this.raise(Errors.UnexpectedLexicalDeclaration, node);
						else if (!this.recordAwaitIfAllowed()) this.raise(Errors.AwaitUsingNotInAsyncContext, node);
						this.next();
						return this.parseVarStatement(node, "await using");
					}
					break;
				case 107:
					if (this.state.containsEsc || !this.hasInLineFollowingBindingIdentifierOrBrace()) break;
					if (!this.allowsUsing()) this.raise(Errors.UnexpectedUsingDeclaration, this.state.startLoc);
					else if (!allowDeclaration) this.raise(Errors.UnexpectedLexicalDeclaration, this.state.startLoc);
					return this.parseVarStatement(node, "using");
				case 100: {
					if (this.state.containsEsc) break;
					const next$1 = this.nextTokenStart();
					const nextCh = this.codePointAtPos(next$1);
					if (nextCh !== 91) {
						if (!allowDeclaration && this.hasFollowingLineBreak()) break;
						if (!this.chStartsBindingIdentifier(nextCh, next$1) && nextCh !== 123) break;
					}
				}
				case 75: if (!allowDeclaration) this.raise(Errors.UnexpectedLexicalDeclaration, this.state.startLoc);
				case 74: {
					const kind = this.state.value;
					return this.parseVarStatement(node, kind);
				}
				case 92: return this.parseWhileStatement(node);
				case 76: return this.parseWithStatement(node);
				case 5: return this.parseBlock();
				case 13: return this.parseEmptyStatement(node);
				case 83: {
					const nextTokenCharCode = this.lookaheadCharCode();
					if (nextTokenCharCode === 40 || nextTokenCharCode === 46) break;
				}
				case 82: {
					if (!(this.optionFlags & 8) && !topLevel) this.raise(Errors.UnexpectedImportExport, this.state.startLoc);
					this.next();
					let result;
					if (startType === 83) result = this.parseImport(node);
					else result = this.parseExport(node, decorators);
					this.assertModuleNodeAllowed(result);
					return result;
				}
				default: if (this.isAsyncFunction()) {
					if (!allowDeclaration) this.raise(Errors.AsyncFunctionInSingleStatementContext, this.state.startLoc);
					this.next();
					return this.parseFunctionStatement(node, true, !allowDeclaration && allowFunctionDeclaration);
				}
			}
			const maybeName = this.state.value;
			const expr = this.parseExpression();
			if (tokenIsIdentifier(startType) && expr.type === "Identifier" && this.eat(14)) return this.parseLabeledStatement(node, maybeName, expr, flags);
			else return this.parseExpressionStatement(node, expr, decorators);
		}
		assertModuleNodeAllowed(node) {
			if (!(this.optionFlags & 8) && !this.inModule) this.raise(Errors.ImportOutsideModule, node);
		}
		decoratorsEnabledBeforeExport() {
			if (this.hasPlugin("decorators-legacy")) return true;
			return this.hasPlugin("decorators") && this.getPluginOption("decorators", "decoratorsBeforeExport") !== false;
		}
		maybeTakeDecorators(maybeDecorators, classNode, exportNode) {
			if (maybeDecorators) {
				var _classNode$decorators;
				if ((_classNode$decorators = classNode.decorators) != null && _classNode$decorators.length) {
					if (typeof this.getPluginOption("decorators", "decoratorsBeforeExport") !== "boolean") this.raise(Errors.DecoratorsBeforeAfterExport, classNode.decorators[0]);
					classNode.decorators.unshift(...maybeDecorators);
				} else classNode.decorators = maybeDecorators;
				this.resetStartLocationFromNode(classNode, maybeDecorators[0]);
				if (exportNode) this.resetStartLocationFromNode(exportNode, classNode);
			}
			return classNode;
		}
		canHaveLeadingDecorator() {
			return this.match(80);
		}
		parseDecorators(allowExport) {
			const decorators = [];
			do
				decorators.push(this.parseDecorator());
			while (this.match(26));
			if (this.match(82)) {
				if (!allowExport) this.unexpected();
				if (!this.decoratorsEnabledBeforeExport()) this.raise(Errors.DecoratorExportClass, this.state.startLoc);
			} else if (!this.canHaveLeadingDecorator()) throw this.raise(Errors.UnexpectedLeadingDecorator, this.state.startLoc);
			return decorators;
		}
		parseDecorator() {
			this.expectOnePlugin(["decorators", "decorators-legacy"]);
			const node = this.startNode();
			this.next();
			if (this.hasPlugin("decorators")) {
				const startLoc = this.state.startLoc;
				let expr;
				if (this.match(10)) {
					const startLoc$1 = this.state.startLoc;
					this.next();
					expr = this.parseExpression();
					this.expect(11);
					expr = this.wrapParenthesis(startLoc$1, expr);
					const paramsStartLoc = this.state.startLoc;
					node.expression = this.parseMaybeDecoratorArguments(expr, startLoc$1);
					if (this.getPluginOption("decorators", "allowCallParenthesized") === false && node.expression !== expr) this.raise(Errors.DecoratorArgumentsOutsideParentheses, paramsStartLoc);
				} else {
					expr = this.parseIdentifier(false);
					while (this.eat(16)) {
						const node$1 = this.startNodeAt(startLoc);
						node$1.object = expr;
						if (this.match(139)) {
							this.classScope.usePrivateName(this.state.value, this.state.startLoc);
							node$1.property = this.parsePrivateName();
						} else node$1.property = this.parseIdentifier(true);
						node$1.computed = false;
						expr = this.finishNode(node$1, "MemberExpression");
					}
					node.expression = this.parseMaybeDecoratorArguments(expr, startLoc);
				}
			} else node.expression = this.parseExprSubscripts();
			return this.finishNode(node, "Decorator");
		}
		parseMaybeDecoratorArguments(expr, startLoc) {
			if (this.eat(10)) {
				const node = this.startNodeAt(startLoc);
				node.callee = expr;
				node.arguments = this.parseCallExpressionArguments();
				this.toReferencedList(node.arguments);
				return this.finishNode(node, "CallExpression");
			}
			return expr;
		}
		parseBreakContinueStatement(node, isBreak) {
			this.next();
			if (this.isLineTerminator()) node.label = null;
			else {
				node.label = this.parseIdentifier();
				this.semicolon();
			}
			this.verifyBreakContinue(node, isBreak);
			return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
		}
		verifyBreakContinue(node, isBreak) {
			let i;
			for (i = 0; i < this.state.labels.length; ++i) {
				const lab = this.state.labels[i];
				if (node.label == null || lab.name === node.label.name) {
					if (lab.kind != null && (isBreak || lab.kind === 1)) break;
					if (node.label && isBreak) break;
				}
			}
			if (i === this.state.labels.length) {
				const type = isBreak ? "BreakStatement" : "ContinueStatement";
				this.raise(Errors.IllegalBreakContinue, node, { type });
			}
		}
		parseDebuggerStatement(node) {
			this.next();
			this.semicolon();
			return this.finishNode(node, "DebuggerStatement");
		}
		parseHeaderExpression() {
			this.expect(10);
			const val = this.parseExpression();
			this.expect(11);
			return val;
		}
		parseDoWhileStatement(node) {
			this.next();
			this.state.labels.push(loopLabel);
			node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
			this.state.labels.pop();
			this.expect(92);
			node.test = this.parseHeaderExpression();
			this.eat(13);
			return this.finishNode(node, "DoWhileStatement");
		}
		parseForStatement(node) {
			this.next();
			this.state.labels.push(loopLabel);
			let awaitAt = null;
			if (this.isContextual(96) && this.recordAwaitIfAllowed()) {
				awaitAt = this.state.startLoc;
				this.next();
			}
			this.scope.enter(0);
			this.expect(10);
			if (this.match(13)) {
				if (awaitAt !== null) this.unexpected(awaitAt);
				return this.parseFor(node, null);
			}
			const startsWithLet = this.isContextual(100);
			{
				const startsWithAwaitUsing = this.isAwaitUsing();
				const starsWithUsingDeclaration = startsWithAwaitUsing || this.isForUsing();
				const isLetOrUsing = startsWithLet && this.hasFollowingBindingAtom() || starsWithUsingDeclaration;
				if (this.match(74) || this.match(75) || isLetOrUsing) {
					const initNode = this.startNode();
					let kind;
					if (startsWithAwaitUsing) {
						kind = "await using";
						if (!this.recordAwaitIfAllowed()) this.raise(Errors.AwaitUsingNotInAsyncContext, this.state.startLoc);
						this.next();
					} else kind = this.state.value;
					this.next();
					this.parseVar(initNode, true, kind);
					const init$1 = this.finishNode(initNode, "VariableDeclaration");
					const isForIn = this.match(58);
					if (isForIn && starsWithUsingDeclaration) this.raise(Errors.ForInUsing, init$1);
					if ((isForIn || this.isContextual(102)) && init$1.declarations.length === 1) return this.parseForIn(node, init$1, awaitAt);
					if (awaitAt !== null) this.unexpected(awaitAt);
					return this.parseFor(node, init$1);
				}
			}
			const startsWithAsync = this.isContextual(95);
			const refExpressionErrors = new ExpressionErrors();
			const init = this.parseExpression(true, refExpressionErrors);
			const isForOf = this.isContextual(102);
			if (isForOf) {
				if (startsWithLet) this.raise(Errors.ForOfLet, init);
				if (awaitAt === null && startsWithAsync && init.type === "Identifier") this.raise(Errors.ForOfAsync, init);
			}
			if (isForOf || this.match(58)) {
				this.checkDestructuringPrivate(refExpressionErrors);
				this.toAssignable(init, true);
				const type = isForOf ? "ForOfStatement" : "ForInStatement";
				this.checkLVal(init, { type });
				return this.parseForIn(node, init, awaitAt);
			} else this.checkExpressionErrors(refExpressionErrors, true);
			if (awaitAt !== null) this.unexpected(awaitAt);
			return this.parseFor(node, init);
		}
		parseFunctionStatement(node, isAsync, isHangingDeclaration) {
			this.next();
			return this.parseFunction(node, 1 | (isHangingDeclaration ? 2 : 0) | (isAsync ? 8 : 0));
		}
		parseIfStatement(node) {
			this.next();
			node.test = this.parseHeaderExpression();
			node.consequent = this.parseStatementOrSloppyAnnexBFunctionDeclaration();
			node.alternate = this.eat(66) ? this.parseStatementOrSloppyAnnexBFunctionDeclaration() : null;
			return this.finishNode(node, "IfStatement");
		}
		parseReturnStatement(node) {
			if (!this.prodParam.hasReturn) this.raise(Errors.IllegalReturn, this.state.startLoc);
			this.next();
			if (this.isLineTerminator()) node.argument = null;
			else {
				node.argument = this.parseExpression();
				this.semicolon();
			}
			return this.finishNode(node, "ReturnStatement");
		}
		parseSwitchStatement(node) {
			this.next();
			node.discriminant = this.parseHeaderExpression();
			const cases = node.cases = [];
			this.expect(5);
			this.state.labels.push(switchLabel);
			this.scope.enter(256);
			let cur;
			for (let sawDefault; !this.match(8);) if (this.match(61) || this.match(65)) {
				const isCase = this.match(61);
				if (cur) this.finishNode(cur, "SwitchCase");
				cases.push(cur = this.startNode());
				cur.consequent = [];
				this.next();
				if (isCase) cur.test = this.parseExpression();
				else {
					if (sawDefault) this.raise(Errors.MultipleDefaultsInSwitch, this.state.lastTokStartLoc);
					sawDefault = true;
					cur.test = null;
				}
				this.expect(14);
			} else if (cur) cur.consequent.push(this.parseStatementListItem());
			else this.unexpected();
			this.scope.exit();
			if (cur) this.finishNode(cur, "SwitchCase");
			this.next();
			this.state.labels.pop();
			return this.finishNode(node, "SwitchStatement");
		}
		parseThrowStatement(node) {
			this.next();
			if (this.hasPrecedingLineBreak()) this.raise(Errors.NewlineAfterThrow, this.state.lastTokEndLoc);
			node.argument = this.parseExpression();
			this.semicolon();
			return this.finishNode(node, "ThrowStatement");
		}
		parseCatchClauseParam() {
			const param = this.parseBindingAtom();
			this.scope.enter(this.options.annexB && param.type === "Identifier" ? 8 : 0);
			this.checkLVal(param, { type: "CatchClause" }, 9);
			return param;
		}
		parseTryStatement(node) {
			this.next();
			node.block = this.parseBlock();
			node.handler = null;
			if (this.match(62)) {
				const clause = this.startNode();
				this.next();
				if (this.match(10)) {
					this.expect(10);
					clause.param = this.parseCatchClauseParam();
					this.expect(11);
				} else {
					clause.param = null;
					this.scope.enter(0);
				}
				clause.body = this.withSmartMixTopicForbiddingContext(() => this.parseBlock(false, false));
				this.scope.exit();
				node.handler = this.finishNode(clause, "CatchClause");
			}
			node.finalizer = this.eat(67) ? this.parseBlock() : null;
			if (!node.handler && !node.finalizer) this.raise(Errors.NoCatchOrFinally, node);
			return this.finishNode(node, "TryStatement");
		}
		parseVarStatement(node, kind, allowMissingInitializer = false) {
			this.next();
			this.parseVar(node, false, kind, allowMissingInitializer);
			this.semicolon();
			return this.finishNode(node, "VariableDeclaration");
		}
		parseWhileStatement(node) {
			this.next();
			node.test = this.parseHeaderExpression();
			this.state.labels.push(loopLabel);
			node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
			this.state.labels.pop();
			return this.finishNode(node, "WhileStatement");
		}
		parseWithStatement(node) {
			if (this.state.strict) this.raise(Errors.StrictWith, this.state.startLoc);
			this.next();
			node.object = this.parseHeaderExpression();
			node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
			return this.finishNode(node, "WithStatement");
		}
		parseEmptyStatement(node) {
			this.next();
			return this.finishNode(node, "EmptyStatement");
		}
		parseLabeledStatement(node, maybeName, expr, flags) {
			for (const label of this.state.labels) if (label.name === maybeName) this.raise(Errors.LabelRedeclaration, expr, { labelName: maybeName });
			const kind = tokenIsLoop(this.state.type) ? 1 : this.match(71) ? 2 : null;
			for (let i = this.state.labels.length - 1; i >= 0; i--) {
				const label = this.state.labels[i];
				if (label.statementStart === node.start) {
					label.statementStart = this.sourceToOffsetPos(this.state.start);
					label.kind = kind;
				} else break;
			}
			this.state.labels.push({
				name: maybeName,
				kind,
				statementStart: this.sourceToOffsetPos(this.state.start)
			});
			node.body = flags & 8 ? this.parseStatementOrSloppyAnnexBFunctionDeclaration(true) : this.parseStatement();
			this.state.labels.pop();
			node.label = expr;
			return this.finishNode(node, "LabeledStatement");
		}
		parseExpressionStatement(node, expr, decorators) {
			node.expression = expr;
			this.semicolon();
			return this.finishNode(node, "ExpressionStatement");
		}
		parseBlock(allowDirectives = false, createNewLexicalScope = true, afterBlockParse) {
			const node = this.startNode();
			if (allowDirectives) this.state.strictErrors.clear();
			this.expect(5);
			if (createNewLexicalScope) this.scope.enter(0);
			this.parseBlockBody(node, allowDirectives, false, 8, afterBlockParse);
			if (createNewLexicalScope) this.scope.exit();
			return this.finishNode(node, "BlockStatement");
		}
		isValidDirective(stmt) {
			return stmt.type === "ExpressionStatement" && stmt.expression.type === "StringLiteral" && !stmt.expression.extra.parenthesized;
		}
		parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
			const body = node.body = [];
			const directives$1 = node.directives = [];
			this.parseBlockOrModuleBlockBody(body, allowDirectives ? directives$1 : void 0, topLevel, end, afterBlockParse);
		}
		parseBlockOrModuleBlockBody(body, directives$1, topLevel, end, afterBlockParse) {
			const oldStrict = this.state.strict;
			let hasStrictModeDirective = false;
			let parsedNonDirective = false;
			while (!this.match(end)) {
				const stmt = topLevel ? this.parseModuleItem() : this.parseStatementListItem();
				if (directives$1 && !parsedNonDirective) {
					if (this.isValidDirective(stmt)) {
						const directive = this.stmtToDirective(stmt);
						directives$1.push(directive);
						if (!hasStrictModeDirective && directive.value.value === "use strict") {
							hasStrictModeDirective = true;
							this.setStrict(true);
						}
						continue;
					}
					parsedNonDirective = true;
					this.state.strictErrors.clear();
				}
				body.push(stmt);
			}
			afterBlockParse?.call(this, hasStrictModeDirective);
			if (!oldStrict) this.setStrict(false);
			this.next();
		}
		parseFor(node, init) {
			node.init = init;
			this.semicolon(false);
			node.test = this.match(13) ? null : this.parseExpression();
			this.semicolon(false);
			node.update = this.match(11) ? null : this.parseExpression();
			this.expect(11);
			node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
			this.scope.exit();
			this.state.labels.pop();
			return this.finishNode(node, "ForStatement");
		}
		parseForIn(node, init, awaitAt) {
			const isForIn = this.match(58);
			this.next();
			if (isForIn) {
				if (awaitAt !== null) this.unexpected(awaitAt);
			} else node.await = awaitAt !== null;
			if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || !this.options.annexB || this.state.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) this.raise(Errors.ForInOfLoopInitializer, init, { type: isForIn ? "ForInStatement" : "ForOfStatement" });
			if (init.type === "AssignmentPattern") this.raise(Errors.InvalidLhs, init, { ancestor: { type: "ForStatement" } });
			node.left = init;
			node.right = isForIn ? this.parseExpression() : this.parseMaybeAssignAllowIn();
			this.expect(11);
			node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
			this.scope.exit();
			this.state.labels.pop();
			return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
		}
		parseVar(node, isFor, kind, allowMissingInitializer = false) {
			const declarations = node.declarations = [];
			node.kind = kind;
			for (;;) {
				const decl = this.startNode();
				this.parseVarId(decl, kind);
				decl.init = !this.eat(29) ? null : isFor ? this.parseMaybeAssignDisallowIn() : this.parseMaybeAssignAllowIn();
				if (decl.init === null && !allowMissingInitializer) {
					if (decl.id.type !== "Identifier" && !(isFor && (this.match(58) || this.isContextual(102)))) this.raise(Errors.DeclarationMissingInitializer, this.state.lastTokEndLoc, { kind: "destructuring" });
					else if ((kind === "const" || kind === "using" || kind === "await using") && !(this.match(58) || this.isContextual(102))) this.raise(Errors.DeclarationMissingInitializer, this.state.lastTokEndLoc, { kind });
				}
				declarations.push(this.finishNode(decl, "VariableDeclarator"));
				if (!this.eat(12)) break;
			}
			return node;
		}
		parseVarId(decl, kind) {
			const id = this.parseBindingAtom();
			if (kind === "using" || kind === "await using") {
				if (id.type === "ArrayPattern" || id.type === "ObjectPattern") this.raise(Errors.UsingDeclarationHasBindingPattern, id.loc.start);
			} else if (id.type === "VoidPattern") this.raise(Errors.UnexpectedVoidPattern, id.loc.start);
			this.checkLVal(id, { type: "VariableDeclarator" }, kind === "var" ? 5 : 8201);
			decl.id = id;
		}
		parseAsyncFunctionExpression(node) {
			return this.parseFunction(node, 8);
		}
		parseFunction(node, flags = 0) {
			const hangingDeclaration = flags & 2;
			const isDeclaration = !!(flags & 1);
			const requireId = isDeclaration && !(flags & 4);
			const isAsync = !!(flags & 8);
			this.initFunction(node, isAsync);
			if (this.match(55)) {
				if (hangingDeclaration) this.raise(Errors.GeneratorInSingleStatementContext, this.state.startLoc);
				this.next();
				node.generator = true;
			}
			if (isDeclaration) node.id = this.parseFunctionId(requireId);
			const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
			this.state.maybeInArrowParameters = false;
			this.scope.enter(514);
			this.prodParam.enter(functionFlags(isAsync, node.generator));
			if (!isDeclaration) node.id = this.parseFunctionId();
			this.parseFunctionParams(node, false);
			this.withSmartMixTopicForbiddingContext(() => {
				this.parseFunctionBodyAndFinish(node, isDeclaration ? "FunctionDeclaration" : "FunctionExpression");
			});
			this.prodParam.exit();
			this.scope.exit();
			if (isDeclaration && !hangingDeclaration) this.registerFunctionStatementId(node);
			this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
			return node;
		}
		parseFunctionId(requireId) {
			return requireId || tokenIsIdentifier(this.state.type) ? this.parseIdentifier() : null;
		}
		parseFunctionParams(node, isConstructor) {
			this.expect(10);
			this.expressionScope.enter(newParameterDeclarationScope());
			node.params = this.parseBindingList(11, 41, 2 | (isConstructor ? 4 : 0));
			this.expressionScope.exit();
		}
		registerFunctionStatementId(node) {
			if (!node.id) return;
			this.scope.declareName(node.id.name, !this.options.annexB || this.state.strict || node.generator || node.async ? this.scope.treatFunctionsAsVar ? 5 : 8201 : 17, node.id.loc.start);
		}
		parseClass(node, isStatement, optionalId) {
			this.next();
			const oldStrict = this.state.strict;
			this.state.strict = true;
			this.parseClassId(node, isStatement, optionalId);
			this.parseClassSuper(node);
			node.body = this.parseClassBody(!!node.superClass, oldStrict);
			return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression");
		}
		isClassProperty() {
			return this.match(29) || this.match(13) || this.match(8);
		}
		isClassMethod() {
			return this.match(10);
		}
		nameIsConstructor(key) {
			return key.type === "Identifier" && key.name === "constructor" || key.type === "StringLiteral" && key.value === "constructor";
		}
		isNonstaticConstructor(method) {
			return !method.computed && !method.static && this.nameIsConstructor(method.key);
		}
		parseClassBody(hadSuperClass, oldStrict) {
			this.classScope.enter();
			const state = {
				hadConstructor: false,
				hadSuperClass
			};
			let decorators = [];
			const classBody = this.startNode();
			classBody.body = [];
			this.expect(5);
			this.withSmartMixTopicForbiddingContext(() => {
				while (!this.match(8)) {
					if (this.eat(13)) {
						if (decorators.length > 0) throw this.raise(Errors.DecoratorSemicolon, this.state.lastTokEndLoc);
						continue;
					}
					if (this.match(26)) {
						decorators.push(this.parseDecorator());
						continue;
					}
					const member = this.startNode();
					if (decorators.length) {
						member.decorators = decorators;
						this.resetStartLocationFromNode(member, decorators[0]);
						decorators = [];
					}
					this.parseClassMember(classBody, member, state);
					if (member.kind === "constructor" && member.decorators && member.decorators.length > 0) this.raise(Errors.DecoratorConstructor, member);
				}
			});
			this.state.strict = oldStrict;
			this.next();
			if (decorators.length) throw this.raise(Errors.TrailingDecorator, this.state.startLoc);
			this.classScope.exit();
			return this.finishNode(classBody, "ClassBody");
		}
		parseClassMemberFromModifier(classBody, member) {
			const key = this.parseIdentifier(true);
			if (this.isClassMethod()) {
				const method = member;
				method.kind = "method";
				method.computed = false;
				method.key = key;
				method.static = false;
				this.pushClassMethod(classBody, method, false, false, false, false);
				return true;
			} else if (this.isClassProperty()) {
				const prop = member;
				prop.computed = false;
				prop.key = key;
				prop.static = false;
				classBody.body.push(this.parseClassProperty(prop));
				return true;
			}
			this.resetPreviousNodeTrailingComments(key);
			return false;
		}
		parseClassMember(classBody, member, state) {
			const isStatic$1 = this.isContextual(106);
			if (isStatic$1) {
				if (this.parseClassMemberFromModifier(classBody, member)) return;
				if (this.eat(5)) {
					this.parseClassStaticBlock(classBody, member);
					return;
				}
			}
			this.parseClassMemberWithIsStatic(classBody, member, state, isStatic$1);
		}
		parseClassMemberWithIsStatic(classBody, member, state, isStatic$1) {
			const publicMethod = member;
			const privateMethod = member;
			const publicProp = member;
			const privateProp = member;
			const accessorProp = member;
			const method = publicMethod;
			const publicMember = publicMethod;
			member.static = isStatic$1;
			this.parsePropertyNamePrefixOperator(member);
			if (this.eat(55)) {
				method.kind = "method";
				const isPrivateName = this.match(139);
				this.parseClassElementName(method);
				this.parsePostMemberNameModifiers(method);
				if (isPrivateName) {
					this.pushClassPrivateMethod(classBody, privateMethod, true, false);
					return;
				}
				if (this.isNonstaticConstructor(publicMethod)) this.raise(Errors.ConstructorIsGenerator, publicMethod.key);
				this.pushClassMethod(classBody, publicMethod, true, false, false, false);
				return;
			}
			const isContextual = !this.state.containsEsc && tokenIsIdentifier(this.state.type);
			const key = this.parseClassElementName(member);
			const maybeContextualKw = isContextual ? key.name : null;
			const isPrivate = this.isPrivateName(key);
			const maybeQuestionTokenStartLoc = this.state.startLoc;
			this.parsePostMemberNameModifiers(publicMember);
			if (this.isClassMethod()) {
				method.kind = "method";
				if (isPrivate) {
					this.pushClassPrivateMethod(classBody, privateMethod, false, false);
					return;
				}
				const isConstructor = this.isNonstaticConstructor(publicMethod);
				let allowsDirectSuper = false;
				if (isConstructor) {
					publicMethod.kind = "constructor";
					if (state.hadConstructor && !this.hasPlugin("typescript")) this.raise(Errors.DuplicateConstructor, key);
					if (isConstructor && this.hasPlugin("typescript") && member.override) this.raise(Errors.OverrideOnConstructor, key);
					state.hadConstructor = true;
					allowsDirectSuper = state.hadSuperClass;
				}
				this.pushClassMethod(classBody, publicMethod, false, false, isConstructor, allowsDirectSuper);
			} else if (this.isClassProperty()) if (isPrivate) this.pushClassPrivateProperty(classBody, privateProp);
			else this.pushClassProperty(classBody, publicProp);
			else if (maybeContextualKw === "async" && !this.isLineTerminator()) {
				this.resetPreviousNodeTrailingComments(key);
				const isGenerator = this.eat(55);
				if (publicMember.optional) this.unexpected(maybeQuestionTokenStartLoc);
				method.kind = "method";
				const isPrivate$1 = this.match(139);
				this.parseClassElementName(method);
				this.parsePostMemberNameModifiers(publicMember);
				if (isPrivate$1) this.pushClassPrivateMethod(classBody, privateMethod, isGenerator, true);
				else {
					if (this.isNonstaticConstructor(publicMethod)) this.raise(Errors.ConstructorIsAsync, publicMethod.key);
					this.pushClassMethod(classBody, publicMethod, isGenerator, true, false, false);
				}
			} else if ((maybeContextualKw === "get" || maybeContextualKw === "set") && !(this.match(55) && this.isLineTerminator())) {
				this.resetPreviousNodeTrailingComments(key);
				method.kind = maybeContextualKw;
				const isPrivate$1 = this.match(139);
				this.parseClassElementName(publicMethod);
				if (isPrivate$1) this.pushClassPrivateMethod(classBody, privateMethod, false, false);
				else {
					if (this.isNonstaticConstructor(publicMethod)) this.raise(Errors.ConstructorIsAccessor, publicMethod.key);
					this.pushClassMethod(classBody, publicMethod, false, false, false, false);
				}
				this.checkGetterSetterParams(publicMethod);
			} else if (maybeContextualKw === "accessor" && !this.isLineTerminator()) {
				this.expectPlugin("decoratorAutoAccessors");
				this.resetPreviousNodeTrailingComments(key);
				const isPrivate$1 = this.match(139);
				this.parseClassElementName(publicProp);
				this.pushClassAccessorProperty(classBody, accessorProp, isPrivate$1);
			} else if (this.isLineTerminator()) if (isPrivate) this.pushClassPrivateProperty(classBody, privateProp);
			else this.pushClassProperty(classBody, publicProp);
			else this.unexpected();
		}
		parseClassElementName(member) {
			const { type, value } = this.state;
			if ((type === 132 || type === 134) && member.static && value === "prototype") this.raise(Errors.StaticPrototype, this.state.startLoc);
			if (type === 139) {
				if (value === "constructor") this.raise(Errors.ConstructorClassPrivateField, this.state.startLoc);
				const key = this.parsePrivateName();
				member.key = key;
				return key;
			}
			this.parsePropertyName(member);
			return member.key;
		}
		parseClassStaticBlock(classBody, member) {
			var _member$decorators;
			this.scope.enter(720);
			const oldLabels = this.state.labels;
			this.state.labels = [];
			this.prodParam.enter(0);
			const body = member.body = [];
			this.parseBlockOrModuleBlockBody(body, void 0, false, 8);
			this.prodParam.exit();
			this.scope.exit();
			this.state.labels = oldLabels;
			classBody.body.push(this.finishNode(member, "StaticBlock"));
			if ((_member$decorators = member.decorators) != null && _member$decorators.length) this.raise(Errors.DecoratorStaticBlock, member);
		}
		pushClassProperty(classBody, prop) {
			if (!prop.computed && this.nameIsConstructor(prop.key)) this.raise(Errors.ConstructorClassField, prop.key);
			classBody.body.push(this.parseClassProperty(prop));
		}
		pushClassPrivateProperty(classBody, prop) {
			const node = this.parseClassPrivateProperty(prop);
			classBody.body.push(node);
			this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), 0, node.key.loc.start);
		}
		pushClassAccessorProperty(classBody, prop, isPrivate) {
			if (!isPrivate && !prop.computed && this.nameIsConstructor(prop.key)) this.raise(Errors.ConstructorClassField, prop.key);
			const node = this.parseClassAccessorProperty(prop);
			classBody.body.push(node);
			if (isPrivate) this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), 0, node.key.loc.start);
		}
		pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
			classBody.body.push(this.parseMethod(method, isGenerator, isAsync, isConstructor, allowsDirectSuper, "ClassMethod", true));
		}
		pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
			const node = this.parseMethod(method, isGenerator, isAsync, false, false, "ClassPrivateMethod", true);
			classBody.body.push(node);
			const kind = node.kind === "get" ? node.static ? 6 : 2 : node.kind === "set" ? node.static ? 5 : 1 : 0;
			this.declareClassPrivateMethodInScope(node, kind);
		}
		declareClassPrivateMethodInScope(node, kind) {
			this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), kind, node.key.loc.start);
		}
		parsePostMemberNameModifiers(methodOrProp) {}
		parseClassPrivateProperty(node) {
			this.parseInitializer(node);
			this.semicolon();
			return this.finishNode(node, "ClassPrivateProperty");
		}
		parseClassProperty(node) {
			this.parseInitializer(node);
			this.semicolon();
			return this.finishNode(node, "ClassProperty");
		}
		parseClassAccessorProperty(node) {
			this.parseInitializer(node);
			this.semicolon();
			return this.finishNode(node, "ClassAccessorProperty");
		}
		parseInitializer(node) {
			this.scope.enter(592);
			this.expressionScope.enter(newExpressionScope());
			this.prodParam.enter(0);
			node.value = this.eat(29) ? this.parseMaybeAssignAllowIn() : null;
			this.expressionScope.exit();
			this.prodParam.exit();
			this.scope.exit();
		}
		parseClassId(node, isStatement, optionalId, bindingType = 8331) {
			if (tokenIsIdentifier(this.state.type)) {
				node.id = this.parseIdentifier();
				if (isStatement) this.declareNameFromIdentifier(node.id, bindingType);
			} else if (optionalId || !isStatement) node.id = null;
			else throw this.raise(Errors.MissingClassName, this.state.startLoc);
		}
		parseClassSuper(node) {
			node.superClass = this.eat(81) ? this.parseExprSubscripts() : null;
		}
		parseExport(node, decorators) {
			const maybeDefaultIdentifier = this.parseMaybeImportPhase(node, true);
			const hasDefault = this.maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier);
			const parseAfterDefault = !hasDefault || this.eat(12);
			const hasStar = parseAfterDefault && this.eatExportStar(node);
			const hasNamespace = hasStar && this.maybeParseExportNamespaceSpecifier(node);
			const parseAfterNamespace = parseAfterDefault && (!hasNamespace || this.eat(12));
			const isFromRequired = hasDefault || hasStar;
			if (hasStar && !hasNamespace) {
				if (hasDefault) this.unexpected();
				if (decorators) throw this.raise(Errors.UnsupportedDecoratorExport, node);
				this.parseExportFrom(node, true);
				this.sawUnambiguousESM = true;
				return this.finishNode(node, "ExportAllDeclaration");
			}
			const hasSpecifiers = this.maybeParseExportNamedSpecifiers(node);
			if (hasDefault && parseAfterDefault && !hasStar && !hasSpecifiers) this.unexpected(null, 5);
			if (hasNamespace && parseAfterNamespace) this.unexpected(null, 98);
			let hasDeclaration;
			if (isFromRequired || hasSpecifiers) {
				hasDeclaration = false;
				if (decorators) throw this.raise(Errors.UnsupportedDecoratorExport, node);
				this.parseExportFrom(node, isFromRequired);
			} else hasDeclaration = this.maybeParseExportDeclaration(node);
			if (isFromRequired || hasSpecifiers || hasDeclaration) {
				var _node2$declaration;
				const node2 = node;
				this.checkExport(node2, true, false, !!node2.source);
				if (((_node2$declaration = node2.declaration) == null ? void 0 : _node2$declaration.type) === "ClassDeclaration") this.maybeTakeDecorators(decorators, node2.declaration, node2);
				else if (decorators) throw this.raise(Errors.UnsupportedDecoratorExport, node);
				this.sawUnambiguousESM = true;
				return this.finishNode(node2, "ExportNamedDeclaration");
			}
			if (this.eat(65)) {
				const node2 = node;
				const decl = this.parseExportDefaultExpression();
				node2.declaration = decl;
				if (decl.type === "ClassDeclaration") this.maybeTakeDecorators(decorators, decl, node2);
				else if (decorators) throw this.raise(Errors.UnsupportedDecoratorExport, node);
				this.checkExport(node2, true, true);
				this.sawUnambiguousESM = true;
				return this.finishNode(node2, "ExportDefaultDeclaration");
			}
			this.unexpected(null, 5);
		}
		eatExportStar(node) {
			return this.eat(55);
		}
		maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
			if (maybeDefaultIdentifier || this.isExportDefaultSpecifier()) {
				this.expectPlugin("exportDefaultFrom", maybeDefaultIdentifier == null ? void 0 : maybeDefaultIdentifier.loc.start);
				const id = maybeDefaultIdentifier || this.parseIdentifier(true);
				const specifier = this.startNodeAtNode(id);
				specifier.exported = id;
				node.specifiers = [this.finishNode(specifier, "ExportDefaultSpecifier")];
				return true;
			}
			return false;
		}
		maybeParseExportNamespaceSpecifier(node) {
			if (this.isContextual(93)) {
				var _ref, _ref$specifiers;
				(_ref$specifiers = (_ref = node).specifiers) != null || (_ref.specifiers = []);
				const specifier = this.startNodeAt(this.state.lastTokStartLoc);
				this.next();
				specifier.exported = this.parseModuleExportName();
				node.specifiers.push(this.finishNode(specifier, "ExportNamespaceSpecifier"));
				return true;
			}
			return false;
		}
		maybeParseExportNamedSpecifiers(node) {
			if (this.match(5)) {
				const node2 = node;
				if (!node2.specifiers) node2.specifiers = [];
				const isTypeExport = node2.exportKind === "type";
				node2.specifiers.push(...this.parseExportSpecifiers(isTypeExport));
				node2.source = null;
				if (this.hasPlugin("importAssertions")) node2.assertions = [];
				else node2.attributes = [];
				node2.declaration = null;
				return true;
			}
			return false;
		}
		maybeParseExportDeclaration(node) {
			if (this.shouldParseExportDeclaration()) {
				node.specifiers = [];
				node.source = null;
				if (this.hasPlugin("importAssertions")) node.assertions = [];
				else node.attributes = [];
				node.declaration = this.parseExportDeclaration(node);
				return true;
			}
			return false;
		}
		isAsyncFunction() {
			if (!this.isContextual(95)) return false;
			const next$1 = this.nextTokenInLineStart();
			return this.isUnparsedContextual(next$1, "function");
		}
		parseExportDefaultExpression() {
			const expr = this.startNode();
			if (this.match(68)) {
				this.next();
				return this.parseFunction(expr, 5);
			} else if (this.isAsyncFunction()) {
				this.next();
				this.next();
				return this.parseFunction(expr, 13);
			}
			if (this.match(80)) return this.parseClass(expr, true, true);
			if (this.match(26)) {
				if (this.hasPlugin("decorators") && this.getPluginOption("decorators", "decoratorsBeforeExport") === true) this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
				return this.parseClass(this.maybeTakeDecorators(this.parseDecorators(false), this.startNode()), true, true);
			}
			if (this.match(75) || this.match(74) || this.isLet() || this.isUsing() || this.isAwaitUsing()) throw this.raise(Errors.UnsupportedDefaultExport, this.state.startLoc);
			const res = this.parseMaybeAssignAllowIn();
			this.semicolon();
			return res;
		}
		parseExportDeclaration(node) {
			if (this.match(80)) {
				const node$1 = this.parseClass(this.startNode(), true, false);
				return node$1;
			}
			return this.parseStatementListItem();
		}
		isExportDefaultSpecifier() {
			const { type } = this.state;
			if (tokenIsIdentifier(type)) {
				if (type === 95 && !this.state.containsEsc || type === 100) return false;
				if ((type === 130 || type === 129) && !this.state.containsEsc) {
					const next$2 = this.nextTokenStart();
					const nextChar = this.input.charCodeAt(next$2);
					if (nextChar === 123 || this.chStartsBindingIdentifier(nextChar, next$2) && !this.input.startsWith("from", next$2)) {
						this.expectOnePlugin(["flow", "typescript"]);
						return false;
					}
				}
			} else if (!this.match(65)) return false;
			const next$1 = this.nextTokenStart();
			const hasFrom = this.isUnparsedContextual(next$1, "from");
			if (this.input.charCodeAt(next$1) === 44 || tokenIsIdentifier(this.state.type) && hasFrom) return true;
			if (this.match(65) && hasFrom) {
				const nextAfterFrom = this.input.charCodeAt(this.nextTokenStartSince(next$1 + 4));
				return nextAfterFrom === 34 || nextAfterFrom === 39;
			}
			return false;
		}
		parseExportFrom(node, expect) {
			if (this.eatContextual(98)) {
				node.source = this.parseImportSource();
				this.checkExport(node);
				this.maybeParseImportAttributes(node);
				this.checkJSONModuleImport(node);
			} else if (expect) this.unexpected();
			this.semicolon();
		}
		shouldParseExportDeclaration() {
			const { type } = this.state;
			if (type === 26) {
				this.expectOnePlugin(["decorators", "decorators-legacy"]);
				if (this.hasPlugin("decorators")) {
					if (this.getPluginOption("decorators", "decoratorsBeforeExport") === true) this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
					return true;
				}
			}
			if (this.isUsing()) {
				this.raise(Errors.UsingDeclarationExport, this.state.startLoc);
				return true;
			}
			if (this.isAwaitUsing()) {
				this.raise(Errors.UsingDeclarationExport, this.state.startLoc);
				return true;
			}
			return type === 74 || type === 75 || type === 68 || type === 80 || this.isLet() || this.isAsyncFunction();
		}
		checkExport(node, checkNames, isDefault, isFrom) {
			if (checkNames) {
				var _node$specifiers;
				if (isDefault) {
					this.checkDuplicateExports(node, "default");
					if (this.hasPlugin("exportDefaultFrom")) {
						var _declaration$extra;
						const declaration = node.declaration;
						if (declaration.type === "Identifier" && declaration.name === "from" && declaration.end - declaration.start === 4 && !((_declaration$extra = declaration.extra) != null && _declaration$extra.parenthesized)) this.raise(Errors.ExportDefaultFromAsIdentifier, declaration);
					}
				} else if ((_node$specifiers = node.specifiers) != null && _node$specifiers.length) for (const specifier of node.specifiers) {
					const { exported } = specifier;
					const exportName = exported.type === "Identifier" ? exported.name : exported.value;
					this.checkDuplicateExports(specifier, exportName);
					if (!isFrom && specifier.local) {
						const { local } = specifier;
						if (local.type !== "Identifier") this.raise(Errors.ExportBindingIsString, specifier, {
							localName: local.value,
							exportName
						});
						else {
							this.checkReservedWord(local.name, local.loc.start, true, false);
							this.scope.checkLocalExport(local);
						}
					}
				}
				else if (node.declaration) {
					const decl = node.declaration;
					if (decl.type === "FunctionDeclaration" || decl.type === "ClassDeclaration") {
						const { id } = decl;
						if (!id) throw new Error("Assertion failure");
						this.checkDuplicateExports(node, id.name);
					} else if (decl.type === "VariableDeclaration") for (const declaration of decl.declarations) this.checkDeclaration(declaration.id);
				}
			}
		}
		checkDeclaration(node) {
			if (node.type === "Identifier") this.checkDuplicateExports(node, node.name);
			else if (node.type === "ObjectPattern") for (const prop of node.properties) this.checkDeclaration(prop);
			else if (node.type === "ArrayPattern") {
				for (const elem of node.elements) if (elem) this.checkDeclaration(elem);
			} else if (node.type === "ObjectProperty") this.checkDeclaration(node.value);
			else if (node.type === "RestElement") this.checkDeclaration(node.argument);
			else if (node.type === "AssignmentPattern") this.checkDeclaration(node.left);
		}
		checkDuplicateExports(node, exportName) {
			if (this.exportedIdentifiers.has(exportName)) if (exportName === "default") this.raise(Errors.DuplicateDefaultExport, node);
			else this.raise(Errors.DuplicateExport, node, { exportName });
			this.exportedIdentifiers.add(exportName);
		}
		parseExportSpecifiers(isInTypeExport) {
			const nodes = [];
			let first = true;
			this.expect(5);
			while (!this.eat(8)) {
				if (first) first = false;
				else {
					this.expect(12);
					if (this.eat(8)) break;
				}
				const isMaybeTypeOnly = this.isContextual(130);
				const isString$1 = this.match(134);
				const node = this.startNode();
				node.local = this.parseModuleExportName();
				nodes.push(this.parseExportSpecifier(node, isString$1, isInTypeExport, isMaybeTypeOnly));
			}
			return nodes;
		}
		parseExportSpecifier(node, isString$1, isInTypeExport, isMaybeTypeOnly) {
			if (this.eatContextual(93)) node.exported = this.parseModuleExportName();
			else if (isString$1) node.exported = this.cloneStringLiteral(node.local);
			else if (!node.exported) node.exported = this.cloneIdentifier(node.local);
			return this.finishNode(node, "ExportSpecifier");
		}
		parseModuleExportName() {
			if (this.match(134)) {
				const result = this.parseStringLiteral(this.state.value);
				const surrogate = loneSurrogate.exec(result.value);
				if (surrogate) this.raise(Errors.ModuleExportNameHasLoneSurrogate, result, { surrogateCharCode: surrogate[0].charCodeAt(0) });
				return result;
			}
			return this.parseIdentifier(true);
		}
		isJSONModuleImport(node) {
			if (node.assertions != null) return node.assertions.some(({ key, value }) => {
				return value.value === "json" && (key.type === "Identifier" ? key.name === "type" : key.value === "type");
			});
			return false;
		}
		checkImportReflection(node) {
			const { specifiers } = node;
			const singleBindingType = specifiers.length === 1 ? specifiers[0].type : null;
			if (node.phase === "source") {
				if (singleBindingType !== "ImportDefaultSpecifier") this.raise(Errors.SourcePhaseImportRequiresDefault, specifiers[0].loc.start);
			} else if (node.phase === "defer") {
				if (singleBindingType !== "ImportNamespaceSpecifier") this.raise(Errors.DeferImportRequiresNamespace, specifiers[0].loc.start);
			} else if (node.module) {
				var _node$assertions;
				if (singleBindingType !== "ImportDefaultSpecifier") this.raise(Errors.ImportReflectionNotBinding, specifiers[0].loc.start);
				if (((_node$assertions = node.assertions) == null ? void 0 : _node$assertions.length) > 0) this.raise(Errors.ImportReflectionHasAssertion, specifiers[0].loc.start);
			}
		}
		checkJSONModuleImport(node) {
			if (this.isJSONModuleImport(node) && node.type !== "ExportAllDeclaration") {
				const { specifiers } = node;
				if (specifiers != null) {
					const nonDefaultNamedSpecifier = specifiers.find((specifier) => {
						let imported;
						if (specifier.type === "ExportSpecifier") imported = specifier.local;
						else if (specifier.type === "ImportSpecifier") imported = specifier.imported;
						if (imported !== void 0) return imported.type === "Identifier" ? imported.name !== "default" : imported.value !== "default";
					});
					if (nonDefaultNamedSpecifier !== void 0) this.raise(Errors.ImportJSONBindingNotDefault, nonDefaultNamedSpecifier.loc.start);
				}
			}
		}
		isPotentialImportPhase(isExport) {
			if (isExport) return false;
			return this.isContextual(105) || this.isContextual(97) || this.isContextual(127);
		}
		applyImportPhase(node, isExport, phase, loc) {
			if (isExport) return;
			if (phase === "module") {
				this.expectPlugin("importReflection", loc);
				node.module = true;
			} else if (this.hasPlugin("importReflection")) node.module = false;
			if (phase === "source") {
				this.expectPlugin("sourcePhaseImports", loc);
				node.phase = "source";
			} else if (phase === "defer") {
				this.expectPlugin("deferredImportEvaluation", loc);
				node.phase = "defer";
			} else if (this.hasPlugin("sourcePhaseImports")) node.phase = null;
		}
		parseMaybeImportPhase(node, isExport) {
			if (!this.isPotentialImportPhase(isExport)) {
				this.applyImportPhase(node, isExport, null);
				return null;
			}
			const phaseIdentifier = this.startNode();
			const phaseIdentifierName = this.parseIdentifierName(true);
			const { type } = this.state;
			const isImportPhase = tokenIsKeywordOrIdentifier(type) ? type !== 98 || this.lookaheadCharCode() === 102 : type !== 12;
			if (isImportPhase) {
				this.applyImportPhase(node, isExport, phaseIdentifierName, phaseIdentifier.loc.start);
				return null;
			} else {
				this.applyImportPhase(node, isExport, null);
				return this.createIdentifier(phaseIdentifier, phaseIdentifierName);
			}
		}
		isPrecedingIdImportPhase(phase) {
			const { type } = this.state;
			return tokenIsIdentifier(type) ? type !== 98 || this.lookaheadCharCode() === 102 : type !== 12;
		}
		parseImport(node) {
			if (this.match(134)) return this.parseImportSourceAndAttributes(node);
			return this.parseImportSpecifiersAndAfter(node, this.parseMaybeImportPhase(node, false));
		}
		parseImportSpecifiersAndAfter(node, maybeDefaultIdentifier) {
			node.specifiers = [];
			const hasDefault = this.maybeParseDefaultImportSpecifier(node, maybeDefaultIdentifier);
			const parseNext = !hasDefault || this.eat(12);
			const hasStar = parseNext && this.maybeParseStarImportSpecifier(node);
			if (parseNext && !hasStar) this.parseNamedImportSpecifiers(node);
			this.expectContextual(98);
			return this.parseImportSourceAndAttributes(node);
		}
		parseImportSourceAndAttributes(node) {
			var _node$specifiers2;
			(_node$specifiers2 = node.specifiers) != null || (node.specifiers = []);
			node.source = this.parseImportSource();
			this.maybeParseImportAttributes(node);
			this.checkImportReflection(node);
			this.checkJSONModuleImport(node);
			this.semicolon();
			this.sawUnambiguousESM = true;
			return this.finishNode(node, "ImportDeclaration");
		}
		parseImportSource() {
			if (!this.match(134)) this.unexpected();
			return this.parseExprAtom();
		}
		parseImportSpecifierLocal(node, specifier, type) {
			specifier.local = this.parseIdentifier();
			node.specifiers.push(this.finishImportSpecifier(specifier, type));
		}
		finishImportSpecifier(specifier, type, bindingType = 8201) {
			this.checkLVal(specifier.local, { type }, bindingType);
			return this.finishNode(specifier, type);
		}
		parseImportAttributes() {
			this.expect(5);
			const attrs = [];
			const attrNames = /* @__PURE__ */ new Set();
			do {
				if (this.match(8)) break;
				const node = this.startNode();
				const keyName = this.state.value;
				if (attrNames.has(keyName)) this.raise(Errors.ModuleAttributesWithDuplicateKeys, this.state.startLoc, { key: keyName });
				attrNames.add(keyName);
				if (this.match(134)) node.key = this.parseStringLiteral(keyName);
				else node.key = this.parseIdentifier(true);
				this.expect(14);
				if (!this.match(134)) throw this.raise(Errors.ModuleAttributeInvalidValue, this.state.startLoc);
				node.value = this.parseStringLiteral(this.state.value);
				attrs.push(this.finishNode(node, "ImportAttribute"));
			} while (this.eat(12));
			this.expect(8);
			return attrs;
		}
		parseModuleAttributes() {
			const attrs = [];
			const attributes = /* @__PURE__ */ new Set();
			do {
				const node = this.startNode();
				node.key = this.parseIdentifier(true);
				if (node.key.name !== "type") this.raise(Errors.ModuleAttributeDifferentFromType, node.key);
				if (attributes.has(node.key.name)) this.raise(Errors.ModuleAttributesWithDuplicateKeys, node.key, { key: node.key.name });
				attributes.add(node.key.name);
				this.expect(14);
				if (!this.match(134)) throw this.raise(Errors.ModuleAttributeInvalidValue, this.state.startLoc);
				node.value = this.parseStringLiteral(this.state.value);
				attrs.push(this.finishNode(node, "ImportAttribute"));
			} while (this.eat(12));
			return attrs;
		}
		maybeParseImportAttributes(node) {
			let attributes;
			var useWith = false;
			if (this.match(76)) {
				if (this.hasPrecedingLineBreak() && this.lookaheadCharCode() === 40) return;
				this.next();
				if (this.hasPlugin("moduleAttributes")) {
					attributes = this.parseModuleAttributes();
					this.addExtra(node, "deprecatedWithLegacySyntax", true);
				} else attributes = this.parseImportAttributes();
				useWith = true;
			} else if (this.isContextual(94) && !this.hasPrecedingLineBreak()) {
				if (!this.hasPlugin("deprecatedImportAssert") && !this.hasPlugin("importAssertions")) this.raise(Errors.ImportAttributesUseAssert, this.state.startLoc);
				if (!this.hasPlugin("importAssertions")) this.addExtra(node, "deprecatedAssertSyntax", true);
				this.next();
				attributes = this.parseImportAttributes();
			} else attributes = [];
			if (!useWith && this.hasPlugin("importAssertions")) node.assertions = attributes;
			else node.attributes = attributes;
		}
		maybeParseDefaultImportSpecifier(node, maybeDefaultIdentifier) {
			if (maybeDefaultIdentifier) {
				const specifier = this.startNodeAtNode(maybeDefaultIdentifier);
				specifier.local = maybeDefaultIdentifier;
				node.specifiers.push(this.finishImportSpecifier(specifier, "ImportDefaultSpecifier"));
				return true;
			} else if (tokenIsKeywordOrIdentifier(this.state.type)) {
				this.parseImportSpecifierLocal(node, this.startNode(), "ImportDefaultSpecifier");
				return true;
			}
			return false;
		}
		maybeParseStarImportSpecifier(node) {
			if (this.match(55)) {
				const specifier = this.startNode();
				this.next();
				this.expectContextual(93);
				this.parseImportSpecifierLocal(node, specifier, "ImportNamespaceSpecifier");
				return true;
			}
			return false;
		}
		parseNamedImportSpecifiers(node) {
			let first = true;
			this.expect(5);
			while (!this.eat(8)) {
				if (first) first = false;
				else {
					if (this.eat(14)) throw this.raise(Errors.DestructureNamedImport, this.state.startLoc);
					this.expect(12);
					if (this.eat(8)) break;
				}
				const specifier = this.startNode();
				const importedIsString = this.match(134);
				const isMaybeTypeOnly = this.isContextual(130);
				specifier.imported = this.parseModuleExportName();
				const importSpecifier = this.parseImportSpecifier(specifier, importedIsString, node.importKind === "type" || node.importKind === "typeof", isMaybeTypeOnly, void 0);
				node.specifiers.push(importSpecifier);
			}
		}
		parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
			if (this.eatContextual(93)) specifier.local = this.parseIdentifier();
			else {
				const { imported } = specifier;
				if (importedIsString) throw this.raise(Errors.ImportBindingIsString, specifier, { importName: imported.value });
				this.checkReservedWord(imported.name, specifier.loc.start, true, true);
				if (!specifier.local) specifier.local = this.cloneIdentifier(imported);
			}
			return this.finishImportSpecifier(specifier, "ImportSpecifier", bindingType);
		}
		isThisParam(param) {
			return param.type === "Identifier" && param.name === "this";
		}
	};
	var Parser = class extends StatementParser {
		constructor(options, input, pluginsMap) {
			options = getOptions(options);
			super(options, input);
			this.options = options;
			this.initializeScopes();
			this.plugins = pluginsMap;
			this.filename = options.sourceFilename;
			this.startIndex = options.startIndex;
			let optionFlags = 0;
			if (options.allowAwaitOutsideFunction) optionFlags |= 1;
			if (options.allowReturnOutsideFunction) optionFlags |= 2;
			if (options.allowImportExportEverywhere) optionFlags |= 8;
			if (options.allowSuperOutsideMethod) optionFlags |= 16;
			if (options.allowUndeclaredExports) optionFlags |= 64;
			if (options.allowNewTargetOutsideFunction) optionFlags |= 4;
			if (options.allowYieldOutsideFunction) optionFlags |= 32;
			if (options.ranges) optionFlags |= 128;
			if (options.tokens) optionFlags |= 256;
			if (options.createImportExpressions) optionFlags |= 512;
			if (options.createParenthesizedExpressions) optionFlags |= 1024;
			if (options.errorRecovery) optionFlags |= 2048;
			if (options.attachComment) optionFlags |= 4096;
			if (options.annexB) optionFlags |= 8192;
			this.optionFlags = optionFlags;
		}
		getScopeHandler() {
			return ScopeHandler;
		}
		parse() {
			this.enterInitialScopes();
			const file = this.startNode();
			const program = this.startNode();
			this.nextToken();
			file.errors = null;
			this.parseTopLevel(file, program);
			file.errors = this.state.errors;
			file.comments.length = this.state.commentsLen;
			return file;
		}
	};
	function parse$3(input, options) {
		var _options;
		if (((_options = options) == null ? void 0 : _options.sourceType) === "unambiguous") {
			options = Object.assign({}, options);
			try {
				options.sourceType = "module";
				const parser$1 = getParser(options, input);
				const ast = parser$1.parse();
				if (parser$1.sawUnambiguousESM) return ast;
				if (parser$1.ambiguousScriptDifferentAst) try {
					options.sourceType = "script";
					return getParser(options, input).parse();
				} catch (_unused) {}
				else ast.program.sourceType = "script";
				return ast;
			} catch (moduleError) {
				try {
					options.sourceType = "script";
					return getParser(options, input).parse();
				} catch (_unused2) {}
				throw moduleError;
			}
		} else return getParser(options, input).parse();
	}
	function parseExpression(input, options) {
		const parser$1 = getParser(options, input);
		if (parser$1.options.strictMode) parser$1.state.strict = true;
		return parser$1.getExpression();
	}
	function generateExportedTokenTypes(internalTokenTypes) {
		const tokenTypes$1 = {};
		for (const typeName of Object.keys(internalTokenTypes)) tokenTypes$1[typeName] = getExportedToken(internalTokenTypes[typeName]);
		return tokenTypes$1;
	}
	const tokTypes = generateExportedTokenTypes(tt);
	function getParser(options, input) {
		let cls = Parser;
		const pluginsMap = /* @__PURE__ */ new Map();
		if (options != null && options.plugins) {
			for (const plugin$13 of options.plugins) {
				let name, opts;
				if (typeof plugin$13 === "string") name = plugin$13;
				else [name, opts] = plugin$13;
				if (!pluginsMap.has(name)) pluginsMap.set(name, opts || {});
			}
			validatePlugins(pluginsMap);
			cls = getParserClass(pluginsMap);
		}
		return new cls(options, input, pluginsMap);
	}
	const parserClassCache = /* @__PURE__ */ new Map();
	function getParserClass(pluginsMap) {
		const pluginList = [];
		for (const name of mixinPluginNames) if (pluginsMap.has(name)) pluginList.push(name);
		const key = pluginList.join("|");
		let cls = parserClassCache.get(key);
		if (!cls) {
			cls = Parser;
			for (const plugin$13 of pluginList) cls = mixinPlugins[plugin$13](cls);
			parserClassCache.set(key, cls);
		}
		return cls;
	}
	exports.parse = parse$3;
	exports.parseExpression = parseExpression;
	exports.tokTypes = tokTypes;
} });

//#endregion
//#region node_modules/estree-walker/dist/umd/estree-walker.js
var require_estree_walker = __commonJS({ "node_modules/estree-walker/dist/umd/estree-walker.js"(exports, module) {
	(function(global$1, factory) {
		typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global$1 = global$1 || self, factory(global$1.estreeWalker = {}));
	})(void 0, function(exports$1) {
		"use strict";
		/** @typedef { import('estree').BaseNode} BaseNode */
		/** @typedef {{
		skip: () => void;
		remove: () => void;
		replace: (node: BaseNode) => void;
		}} WalkerContext */
		class WalkerBase {
			constructor() {
				/** @type {boolean} */
				this.should_skip = false;
				/** @type {boolean} */
				this.should_remove = false;
				/** @type {BaseNode | null} */
				this.replacement = null;
				/** @type {WalkerContext} */
				this.context = {
					skip: () => this.should_skip = true,
					remove: () => this.should_remove = true,
					replace: (node) => this.replacement = node
				};
			}
			/**
			*
			* @param {any} parent
			* @param {string} prop
			* @param {number} index
			* @param {BaseNode} node
			*/
			replace(parent, prop, index$1, node) {
				if (parent) if (index$1 !== null) parent[prop][index$1] = node;
				else parent[prop] = node;
			}
			/**
			*
			* @param {any} parent
			* @param {string} prop
			* @param {number} index
			*/
			remove(parent, prop, index$1) {
				if (parent) if (index$1 !== null) parent[prop].splice(index$1, 1);
				else delete parent[prop];
			}
		}
		/** @typedef { import('estree').BaseNode} BaseNode */
		/** @typedef { import('./walker.js').WalkerContext} WalkerContext */
		/** @typedef {(
		*    this: WalkerContext,
		*    node: BaseNode,
		*    parent: BaseNode,
		*    key: string,
		*    index: number
		* ) => void} SyncHandler */
		class SyncWalker extends WalkerBase {
			/**
			*
			* @param {SyncHandler} enter
			* @param {SyncHandler} leave
			*/
			constructor(enter, leave) {
				super();
				/** @type {SyncHandler} */
				this.enter = enter;
				/** @type {SyncHandler} */
				this.leave = leave;
			}
			/**
			*
			* @param {BaseNode} node
			* @param {BaseNode} parent
			* @param {string} [prop]
			* @param {number} [index]
			* @returns {BaseNode}
			*/
			visit(node, parent, prop, index$1) {
				if (node) {
					if (this.enter) {
						const _should_skip = this.should_skip;
						const _should_remove = this.should_remove;
						const _replacement = this.replacement;
						this.should_skip = false;
						this.should_remove = false;
						this.replacement = null;
						this.enter.call(this.context, node, parent, prop, index$1);
						if (this.replacement) {
							node = this.replacement;
							this.replace(parent, prop, index$1, node);
						}
						if (this.should_remove) this.remove(parent, prop, index$1);
						const skipped = this.should_skip;
						const removed = this.should_remove;
						this.should_skip = _should_skip;
						this.should_remove = _should_remove;
						this.replacement = _replacement;
						if (skipped) return node;
						if (removed) return null;
					}
					for (const key in node) {
						const value = node[key];
						if (typeof value !== "object") continue;
						else if (Array.isArray(value)) {
							for (let i = 0; i < value.length; i += 1) if (value[i] !== null && typeof value[i].type === "string") {
								if (!this.visit(value[i], node, key, i)) i--;
							}
						} else if (value !== null && typeof value.type === "string") this.visit(value, node, key, null);
					}
					if (this.leave) {
						const _replacement = this.replacement;
						const _should_remove = this.should_remove;
						this.replacement = null;
						this.should_remove = false;
						this.leave.call(this.context, node, parent, prop, index$1);
						if (this.replacement) {
							node = this.replacement;
							this.replace(parent, prop, index$1, node);
						}
						if (this.should_remove) this.remove(parent, prop, index$1);
						const removed = this.should_remove;
						this.replacement = _replacement;
						this.should_remove = _should_remove;
						if (removed) return null;
					}
				}
				return node;
			}
		}
		/** @typedef { import('estree').BaseNode} BaseNode */
		/** @typedef { import('./walker').WalkerContext} WalkerContext */
		/** @typedef {(
		*    this: WalkerContext,
		*    node: BaseNode,
		*    parent: BaseNode,
		*    key: string,
		*    index: number
		* ) => Promise<void>} AsyncHandler */
		class AsyncWalker extends WalkerBase {
			/**
			*
			* @param {AsyncHandler} enter
			* @param {AsyncHandler} leave
			*/
			constructor(enter, leave) {
				super();
				/** @type {AsyncHandler} */
				this.enter = enter;
				/** @type {AsyncHandler} */
				this.leave = leave;
			}
			/**
			*
			* @param {BaseNode} node
			* @param {BaseNode} parent
			* @param {string} [prop]
			* @param {number} [index]
			* @returns {Promise<BaseNode>}
			*/
			async visit(node, parent, prop, index$1) {
				if (node) {
					if (this.enter) {
						const _should_skip = this.should_skip;
						const _should_remove = this.should_remove;
						const _replacement = this.replacement;
						this.should_skip = false;
						this.should_remove = false;
						this.replacement = null;
						await this.enter.call(this.context, node, parent, prop, index$1);
						if (this.replacement) {
							node = this.replacement;
							this.replace(parent, prop, index$1, node);
						}
						if (this.should_remove) this.remove(parent, prop, index$1);
						const skipped = this.should_skip;
						const removed = this.should_remove;
						this.should_skip = _should_skip;
						this.should_remove = _should_remove;
						this.replacement = _replacement;
						if (skipped) return node;
						if (removed) return null;
					}
					for (const key in node) {
						const value = node[key];
						if (typeof value !== "object") continue;
						else if (Array.isArray(value)) {
							for (let i = 0; i < value.length; i += 1) if (value[i] !== null && typeof value[i].type === "string") {
								if (!await this.visit(value[i], node, key, i)) i--;
							}
						} else if (value !== null && typeof value.type === "string") await this.visit(value, node, key, null);
					}
					if (this.leave) {
						const _replacement = this.replacement;
						const _should_remove = this.should_remove;
						this.replacement = null;
						this.should_remove = false;
						await this.leave.call(this.context, node, parent, prop, index$1);
						if (this.replacement) {
							node = this.replacement;
							this.replace(parent, prop, index$1, node);
						}
						if (this.should_remove) this.remove(parent, prop, index$1);
						const removed = this.should_remove;
						this.replacement = _replacement;
						this.should_remove = _should_remove;
						if (removed) return null;
					}
				}
				return node;
			}
		}
		/** @typedef { import('estree').BaseNode} BaseNode */
		/** @typedef { import('./sync.js').SyncHandler} SyncHandler */
		/** @typedef { import('./async.js').AsyncHandler} AsyncHandler */
		/**
		*
		* @param {BaseNode} ast
		* @param {{
		*   enter?: SyncHandler
		*   leave?: SyncHandler
		* }} walker
		* @returns {BaseNode}
		*/
		function walk$2(ast, { enter, leave }) {
			const instance = new SyncWalker(enter, leave);
			return instance.visit(ast, null);
		}
		/**
		*
		* @param {BaseNode} ast
		* @param {{
		*   enter?: AsyncHandler
		*   leave?: AsyncHandler
		* }} walker
		* @returns {Promise<BaseNode>}
		*/
		async function asyncWalk(ast, { enter, leave }) {
			const instance = new AsyncWalker(enter, leave);
			return await instance.visit(ast, null);
		}
		exports$1.asyncWalk = asyncWalk;
		exports$1.walk = walk$2;
		Object.defineProperty(exports$1, "__esModule", { value: true });
	});
} });

//#endregion
//#region node_modules/source-map-js/lib/base64.js
var require_base64 = __commonJS({ "node_modules/source-map-js/lib/base64.js"(exports) {
	var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
	/**
	* Encode an integer in the range of 0 to 63 to a single base 64 digit.
	*/
	exports.encode = function(number) {
		if (0 <= number && number < intToCharMap.length) return intToCharMap[number];
		throw new TypeError("Must be between 0 and 63: " + number);
	};
	/**
	* Decode a single base 64 character code digit to an integer. Returns -1 on
	* failure.
	*/
	exports.decode = function(charCode) {
		var bigA = 65;
		var bigZ = 90;
		var littleA = 97;
		var littleZ = 122;
		var zero = 48;
		var nine = 57;
		var plus = 43;
		var slash = 47;
		var littleOffset = 26;
		var numberOffset = 52;
		if (bigA <= charCode && charCode <= bigZ) return charCode - bigA;
		if (littleA <= charCode && charCode <= littleZ) return charCode - littleA + littleOffset;
		if (zero <= charCode && charCode <= nine) return charCode - zero + numberOffset;
		if (charCode == plus) return 62;
		if (charCode == slash) return 63;
		return -1;
	};
} });

//#endregion
//#region node_modules/source-map-js/lib/base64-vlq.js
var require_base64_vlq = __commonJS({ "node_modules/source-map-js/lib/base64-vlq.js"(exports) {
	var base64 = require_base64();
	var VLQ_BASE_SHIFT = 5;
	var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
	var VLQ_BASE_MASK = VLQ_BASE - 1;
	var VLQ_CONTINUATION_BIT = VLQ_BASE;
	/**
	* Converts from a two-complement value to a value where the sign bit is
	* placed in the least significant bit.  For example, as decimals:
	*   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
	*   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
	*/
	function toVLQSigned(aValue) {
		return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
	}
	/**
	* Converts to a two-complement value from a value where the sign bit is
	* placed in the least significant bit.  For example, as decimals:
	*   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
	*   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
	*/
	function fromVLQSigned(aValue) {
		var isNegative = (aValue & 1) === 1;
		var shifted = aValue >> 1;
		return isNegative ? -shifted : shifted;
	}
	/**
	* Returns the base 64 VLQ encoded value.
	*/
	exports.encode = function base64VLQ_encode(aValue) {
		var encoded = "";
		var digit;
		var vlq = toVLQSigned(aValue);
		do {
			digit = vlq & VLQ_BASE_MASK;
			vlq >>>= VLQ_BASE_SHIFT;
			if (vlq > 0) digit |= VLQ_CONTINUATION_BIT;
			encoded += base64.encode(digit);
		} while (vlq > 0);
		return encoded;
	};
	/**
	* Decodes the next base 64 VLQ value from the given string and returns the
	* value and the rest of the string via the out parameter.
	*/
	exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
		var strLen = aStr.length;
		var result = 0;
		var shift = 0;
		var continuation, digit;
		do {
			if (aIndex >= strLen) throw new Error("Expected more digits in base 64 VLQ value.");
			digit = base64.decode(aStr.charCodeAt(aIndex++));
			if (digit === -1) throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
			continuation = !!(digit & VLQ_CONTINUATION_BIT);
			digit &= VLQ_BASE_MASK;
			result = result + (digit << shift);
			shift += VLQ_BASE_SHIFT;
		} while (continuation);
		aOutParam.value = fromVLQSigned(result);
		aOutParam.rest = aIndex;
	};
} });

//#endregion
//#region node_modules/source-map-js/lib/util.js
var require_util = __commonJS({ "node_modules/source-map-js/lib/util.js"(exports) {
	/**
	* This is a helper function for getting values from parameter/options
	* objects.
	*
	* @param args The object we are extracting values from
	* @param name The name of the property we are getting.
	* @param defaultValue An optional value to return if the property is missing
	* from the object. If this is not specified and the property is missing, an
	* error will be thrown.
	*/
	function getArg(aArgs, aName, aDefaultValue) {
		if (aName in aArgs) return aArgs[aName];
		else if (arguments.length === 3) return aDefaultValue;
		else throw new Error("\"" + aName + "\" is a required argument.");
	}
	exports.getArg = getArg;
	var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
	var dataUrlRegexp = /^data:.+\,.+$/;
	function urlParse(aUrl) {
		var match$1 = aUrl.match(urlRegexp);
		if (!match$1) return null;
		return {
			scheme: match$1[1],
			auth: match$1[2],
			host: match$1[3],
			port: match$1[4],
			path: match$1[5]
		};
	}
	exports.urlParse = urlParse;
	function urlGenerate(aParsedUrl) {
		var url = "";
		if (aParsedUrl.scheme) url += aParsedUrl.scheme + ":";
		url += "//";
		if (aParsedUrl.auth) url += aParsedUrl.auth + "@";
		if (aParsedUrl.host) url += aParsedUrl.host;
		if (aParsedUrl.port) url += ":" + aParsedUrl.port;
		if (aParsedUrl.path) url += aParsedUrl.path;
		return url;
	}
	exports.urlGenerate = urlGenerate;
	var MAX_CACHED_INPUTS = 32;
	/**
	* Takes some function `f(input) -> result` and returns a memoized version of
	* `f`.
	*
	* We keep at most `MAX_CACHED_INPUTS` memoized results of `f` alive. The
	* memoization is a dumb-simple, linear least-recently-used cache.
	*/
	function lruMemoize(f) {
		var cache = [];
		return function(input) {
			for (var i = 0; i < cache.length; i++) if (cache[i].input === input) {
				var temp = cache[0];
				cache[0] = cache[i];
				cache[i] = temp;
				return cache[0].result;
			}
			var result = f(input);
			cache.unshift({
				input,
				result
			});
			if (cache.length > MAX_CACHED_INPUTS) cache.pop();
			return result;
		};
	}
	/**
	* Normalizes a path, or the path portion of a URL:
	*
	* - Replaces consecutive slashes with one slash.
	* - Removes unnecessary '.' parts.
	* - Removes unnecessary '<dir>/..' parts.
	*
	* Based on code in the Node.js 'path' core module.
	*
	* @param aPath The path or url to normalize.
	*/
	var normalize = lruMemoize(function normalize$1(aPath) {
		var path$5 = aPath;
		var url = urlParse(aPath);
		if (url) {
			if (!url.path) return aPath;
			path$5 = url.path;
		}
		var isAbsolute = exports.isAbsolute(path$5);
		var parts = [];
		var start = 0;
		var i = 0;
		while (true) {
			start = i;
			i = path$5.indexOf("/", start);
			if (i === -1) {
				parts.push(path$5.slice(start));
				break;
			} else {
				parts.push(path$5.slice(start, i));
				while (i < path$5.length && path$5[i] === "/") i++;
			}
		}
		for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
			part = parts[i];
			if (part === ".") parts.splice(i, 1);
			else if (part === "..") up++;
			else if (up > 0) if (part === "") {
				parts.splice(i + 1, up);
				up = 0;
			} else {
				parts.splice(i, 2);
				up--;
			}
		}
		path$5 = parts.join("/");
		if (path$5 === "") path$5 = isAbsolute ? "/" : ".";
		if (url) {
			url.path = path$5;
			return urlGenerate(url);
		}
		return path$5;
	});
	exports.normalize = normalize;
	/**
	* Joins two paths/URLs.
	*
	* @param aRoot The root path or URL.
	* @param aPath The path or URL to be joined with the root.
	*
	* - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
	*   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
	*   first.
	* - Otherwise aPath is a path. If aRoot is a URL, then its path portion
	*   is updated with the result and aRoot is returned. Otherwise the result
	*   is returned.
	*   - If aPath is absolute, the result is aPath.
	*   - Otherwise the two paths are joined with a slash.
	* - Joining for example 'http://' and 'www.example.com' is also supported.
	*/
	function join(aRoot, aPath) {
		if (aRoot === "") aRoot = ".";
		if (aPath === "") aPath = ".";
		var aPathUrl = urlParse(aPath);
		var aRootUrl = urlParse(aRoot);
		if (aRootUrl) aRoot = aRootUrl.path || "/";
		if (aPathUrl && !aPathUrl.scheme) {
			if (aRootUrl) aPathUrl.scheme = aRootUrl.scheme;
			return urlGenerate(aPathUrl);
		}
		if (aPathUrl || aPath.match(dataUrlRegexp)) return aPath;
		if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
			aRootUrl.host = aPath;
			return urlGenerate(aRootUrl);
		}
		var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
		if (aRootUrl) {
			aRootUrl.path = joined;
			return urlGenerate(aRootUrl);
		}
		return joined;
	}
	exports.join = join;
	exports.isAbsolute = function(aPath) {
		return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
	};
	/**
	* Make a path relative to a URL or another path.
	*
	* @param aRoot The root path or URL.
	* @param aPath The path or URL to be made relative to aRoot.
	*/
	function relative(aRoot, aPath) {
		if (aRoot === "") aRoot = ".";
		aRoot = aRoot.replace(/\/$/, "");
		var level = 0;
		while (aPath.indexOf(aRoot + "/") !== 0) {
			var index$1 = aRoot.lastIndexOf("/");
			if (index$1 < 0) return aPath;
			aRoot = aRoot.slice(0, index$1);
			if (aRoot.match(/^([^\/]+:\/)?\/*$/)) return aPath;
			++level;
		}
		return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
	}
	exports.relative = relative;
	var supportsNullProto = function() {
		var obj = Object.create(null);
		return !("__proto__" in obj);
	}();
	function identity$1(s) {
		return s;
	}
	/**
	* Because behavior goes wacky when you set `__proto__` on objects, we
	* have to prefix all the strings in our set with an arbitrary character.
	*
	* See https://github.com/mozilla/source-map/pull/31 and
	* https://github.com/mozilla/source-map/issues/30
	*
	* @param String aStr
	*/
	function toSetString(aStr) {
		if (isProtoString(aStr)) return "$" + aStr;
		return aStr;
	}
	exports.toSetString = supportsNullProto ? identity$1 : toSetString;
	function fromSetString(aStr) {
		if (isProtoString(aStr)) return aStr.slice(1);
		return aStr;
	}
	exports.fromSetString = supportsNullProto ? identity$1 : fromSetString;
	function isProtoString(s) {
		if (!s) return false;
		var length = s.length;
		if (length < 9) return false;
		if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) return false;
		for (var i = length - 10; i >= 0; i--) if (s.charCodeAt(i) !== 36) return false;
		return true;
	}
	/**
	* Comparator between two mappings where the original positions are compared.
	*
	* Optionally pass in `true` as `onlyCompareGenerated` to consider two
	* mappings with the same original source/line/column, but different generated
	* line and column the same. Useful when searching for a mapping with a
	* stubbed out mapping.
	*/
	function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
		var cmp = strcmp(mappingA.source, mappingB.source);
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalLine - mappingB.originalLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalColumn - mappingB.originalColumn;
		if (cmp !== 0 || onlyCompareOriginal) return cmp;
		cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		if (cmp !== 0) return cmp;
		cmp = mappingA.generatedLine - mappingB.generatedLine;
		if (cmp !== 0) return cmp;
		return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByOriginalPositions = compareByOriginalPositions;
	function compareByOriginalPositionsNoSource(mappingA, mappingB, onlyCompareOriginal) {
		var cmp;
		cmp = mappingA.originalLine - mappingB.originalLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalColumn - mappingB.originalColumn;
		if (cmp !== 0 || onlyCompareOriginal) return cmp;
		cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		if (cmp !== 0) return cmp;
		cmp = mappingA.generatedLine - mappingB.generatedLine;
		if (cmp !== 0) return cmp;
		return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByOriginalPositionsNoSource = compareByOriginalPositionsNoSource;
	/**
	* Comparator between two mappings with deflated source and name indices where
	* the generated positions are compared.
	*
	* Optionally pass in `true` as `onlyCompareGenerated` to consider two
	* mappings with the same generated line and column, but different
	* source/name/original line and column the same. Useful when searching for a
	* mapping with a stubbed out mapping.
	*/
	function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
		var cmp = mappingA.generatedLine - mappingB.generatedLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		if (cmp !== 0 || onlyCompareGenerated) return cmp;
		cmp = strcmp(mappingA.source, mappingB.source);
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalLine - mappingB.originalLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalColumn - mappingB.originalColumn;
		if (cmp !== 0) return cmp;
		return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
	function compareByGeneratedPositionsDeflatedNoLine(mappingA, mappingB, onlyCompareGenerated) {
		var cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		if (cmp !== 0 || onlyCompareGenerated) return cmp;
		cmp = strcmp(mappingA.source, mappingB.source);
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalLine - mappingB.originalLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalColumn - mappingB.originalColumn;
		if (cmp !== 0) return cmp;
		return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByGeneratedPositionsDeflatedNoLine = compareByGeneratedPositionsDeflatedNoLine;
	function strcmp(aStr1, aStr2) {
		if (aStr1 === aStr2) return 0;
		if (aStr1 === null) return 1;
		if (aStr2 === null) return -1;
		if (aStr1 > aStr2) return 1;
		return -1;
	}
	/**
	* Comparator between two mappings with inflated source and name strings where
	* the generated positions are compared.
	*/
	function compareByGeneratedPositionsInflated(mappingA, mappingB) {
		var cmp = mappingA.generatedLine - mappingB.generatedLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		if (cmp !== 0) return cmp;
		cmp = strcmp(mappingA.source, mappingB.source);
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalLine - mappingB.originalLine;
		if (cmp !== 0) return cmp;
		cmp = mappingA.originalColumn - mappingB.originalColumn;
		if (cmp !== 0) return cmp;
		return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
	/**
	* Strip any JSON XSSI avoidance prefix from the string (as documented
	* in the source maps specification), and then parse the string as
	* JSON.
	*/
	function parseSourceMapInput(str$1) {
		return JSON.parse(str$1.replace(/^\)]}'[^\n]*\n/, ""));
	}
	exports.parseSourceMapInput = parseSourceMapInput;
	/**
	* Compute the URL of a source given the the source root, the source's
	* URL, and the source map's URL.
	*/
	function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
		sourceURL = sourceURL || "";
		if (sourceRoot) {
			if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") sourceRoot += "/";
			sourceURL = sourceRoot + sourceURL;
		}
		if (sourceMapURL) {
			var parsed = urlParse(sourceMapURL);
			if (!parsed) throw new Error("sourceMapURL could not be parsed");
			if (parsed.path) {
				var index$1 = parsed.path.lastIndexOf("/");
				if (index$1 >= 0) parsed.path = parsed.path.substring(0, index$1 + 1);
			}
			sourceURL = join(urlGenerate(parsed), sourceURL);
		}
		return normalize(sourceURL);
	}
	exports.computeSourceURL = computeSourceURL;
} });

//#endregion
//#region node_modules/source-map-js/lib/array-set.js
var require_array_set = __commonJS({ "node_modules/source-map-js/lib/array-set.js"(exports) {
	var util$4 = require_util();
	var has = Object.prototype.hasOwnProperty;
	var hasNativeMap = typeof Map !== "undefined";
	/**
	* A data structure which is a combination of an array and a set. Adding a new
	* member is O(1), testing for membership is O(1), and finding the index of an
	* element is O(1). Removing elements from the set is not supported. Only
	* strings are supported for membership.
	*/
	function ArraySet$2() {
		this._array = [];
		this._set = hasNativeMap ? /* @__PURE__ */ new Map() : Object.create(null);
	}
	/**
	* Static method for creating ArraySet instances from an existing array.
	*/
	ArraySet$2.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
		var set$1 = new ArraySet$2();
		for (var i = 0, len$1 = aArray.length; i < len$1; i++) set$1.add(aArray[i], aAllowDuplicates);
		return set$1;
	};
	/**
	* Return how many unique items are in this ArraySet. If duplicates have been
	* added, than those do not count towards the size.
	*
	* @returns Number
	*/
	ArraySet$2.prototype.size = function ArraySet_size() {
		return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
	};
	/**
	* Add the given string to this set.
	*
	* @param String aStr
	*/
	ArraySet$2.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
		var sStr = hasNativeMap ? aStr : util$4.toSetString(aStr);
		var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
		var idx = this._array.length;
		if (!isDuplicate || aAllowDuplicates) this._array.push(aStr);
		if (!isDuplicate) if (hasNativeMap) this._set.set(aStr, idx);
		else this._set[sStr] = idx;
	};
	/**
	* Is the given string a member of this set?
	*
	* @param String aStr
	*/
	ArraySet$2.prototype.has = function ArraySet_has(aStr) {
		if (hasNativeMap) return this._set.has(aStr);
		else {
			var sStr = util$4.toSetString(aStr);
			return has.call(this._set, sStr);
		}
	};
	/**
	* What is the index of the given string in the array?
	*
	* @param String aStr
	*/
	ArraySet$2.prototype.indexOf = function ArraySet_indexOf(aStr) {
		if (hasNativeMap) {
			var idx = this._set.get(aStr);
			if (idx >= 0) return idx;
		} else {
			var sStr = util$4.toSetString(aStr);
			if (has.call(this._set, sStr)) return this._set[sStr];
		}
		throw new Error("\"" + aStr + "\" is not in the set.");
	};
	/**
	* What is the element at the given index?
	*
	* @param Number aIdx
	*/
	ArraySet$2.prototype.at = function ArraySet_at(aIdx) {
		if (aIdx >= 0 && aIdx < this._array.length) return this._array[aIdx];
		throw new Error("No element indexed by " + aIdx);
	};
	/**
	* Returns the array representation of this set (which has the proper indices
	* indicated by indexOf). Note that this is a copy of the internal array used
	* for storing the members so that no one can mess with internal state.
	*/
	ArraySet$2.prototype.toArray = function ArraySet_toArray() {
		return this._array.slice();
	};
	exports.ArraySet = ArraySet$2;
} });

//#endregion
//#region node_modules/source-map-js/lib/mapping-list.js
var require_mapping_list = __commonJS({ "node_modules/source-map-js/lib/mapping-list.js"(exports) {
	var util$3 = require_util();
	/**
	* Determine whether mappingB is after mappingA with respect to generated
	* position.
	*/
	function generatedPositionAfter(mappingA, mappingB) {
		var lineA = mappingA.generatedLine;
		var lineB = mappingB.generatedLine;
		var columnA = mappingA.generatedColumn;
		var columnB = mappingB.generatedColumn;
		return lineB > lineA || lineB == lineA && columnB >= columnA || util$3.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
	}
	/**
	* A data structure to provide a sorted view of accumulated mappings in a
	* performance conscious manner. It trades a neglibable overhead in general
	* case for a large speedup in case of mappings being added in order.
	*/
	function MappingList$1() {
		this._array = [];
		this._sorted = true;
		this._last = {
			generatedLine: -1,
			generatedColumn: 0
		};
	}
	/**
	* Iterate through internal items. This method takes the same arguments that
	* `Array.prototype.forEach` takes.
	*
	* NOTE: The order of the mappings is NOT guaranteed.
	*/
	MappingList$1.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
		this._array.forEach(aCallback, aThisArg);
	};
	/**
	* Add the given source mapping.
	*
	* @param Object aMapping
	*/
	MappingList$1.prototype.add = function MappingList_add(aMapping) {
		if (generatedPositionAfter(this._last, aMapping)) {
			this._last = aMapping;
			this._array.push(aMapping);
		} else {
			this._sorted = false;
			this._array.push(aMapping);
		}
	};
	/**
	* Returns the flat, sorted array of mappings. The mappings are sorted by
	* generated position.
	*
	* WARNING: This method returns internal data without copying, for
	* performance. The return value must NOT be mutated, and should be treated as
	* an immutable borrow. If you want to take ownership, you must make your own
	* copy.
	*/
	MappingList$1.prototype.toArray = function MappingList_toArray() {
		if (!this._sorted) {
			this._array.sort(util$3.compareByGeneratedPositionsInflated);
			this._sorted = true;
		}
		return this._array;
	};
	exports.MappingList = MappingList$1;
} });

//#endregion
//#region node_modules/source-map-js/lib/source-map-generator.js
var require_source_map_generator = __commonJS({ "node_modules/source-map-js/lib/source-map-generator.js"(exports) {
	var base64VLQ$1 = require_base64_vlq();
	var util$2 = require_util();
	var ArraySet$1 = require_array_set().ArraySet;
	var MappingList = require_mapping_list().MappingList;
	/**
	* An instance of the SourceMapGenerator represents a source map which is
	* being built incrementally. You may pass an object with the following
	* properties:
	*
	*   - file: The filename of the generated source.
	*   - sourceRoot: A root for all relative URLs in this source map.
	*/
	function SourceMapGenerator$1(aArgs) {
		if (!aArgs) aArgs = {};
		this._file = util$2.getArg(aArgs, "file", null);
		this._sourceRoot = util$2.getArg(aArgs, "sourceRoot", null);
		this._skipValidation = util$2.getArg(aArgs, "skipValidation", false);
		this._ignoreInvalidMapping = util$2.getArg(aArgs, "ignoreInvalidMapping", false);
		this._sources = new ArraySet$1();
		this._names = new ArraySet$1();
		this._mappings = new MappingList();
		this._sourcesContents = null;
	}
	SourceMapGenerator$1.prototype._version = 3;
	/**
	* Creates a new SourceMapGenerator based on a SourceMapConsumer
	*
	* @param aSourceMapConsumer The SourceMap.
	*/
	SourceMapGenerator$1.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer, generatorOps) {
		var sourceRoot = aSourceMapConsumer.sourceRoot;
		var generator = new SourceMapGenerator$1(Object.assign(generatorOps || {}, {
			file: aSourceMapConsumer.file,
			sourceRoot
		}));
		aSourceMapConsumer.eachMapping(function(mapping) {
			var newMapping = { generated: {
				line: mapping.generatedLine,
				column: mapping.generatedColumn
			} };
			if (mapping.source != null) {
				newMapping.source = mapping.source;
				if (sourceRoot != null) newMapping.source = util$2.relative(sourceRoot, newMapping.source);
				newMapping.original = {
					line: mapping.originalLine,
					column: mapping.originalColumn
				};
				if (mapping.name != null) newMapping.name = mapping.name;
			}
			generator.addMapping(newMapping);
		});
		aSourceMapConsumer.sources.forEach(function(sourceFile) {
			var sourceRelative = sourceFile;
			if (sourceRoot !== null) sourceRelative = util$2.relative(sourceRoot, sourceFile);
			if (!generator._sources.has(sourceRelative)) generator._sources.add(sourceRelative);
			var content = aSourceMapConsumer.sourceContentFor(sourceFile);
			if (content != null) generator.setSourceContent(sourceFile, content);
		});
		return generator;
	};
	/**
	* Add a single mapping from original source line and column to the generated
	* source's line and column for this source map being created. The mapping
	* object should have the following properties:
	*
	*   - generated: An object with the generated line and column positions.
	*   - original: An object with the original line and column positions.
	*   - source: The original source file (relative to the sourceRoot).
	*   - name: An optional original token name for this mapping.
	*/
	SourceMapGenerator$1.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
		var generated = util$2.getArg(aArgs, "generated");
		var original = util$2.getArg(aArgs, "original", null);
		var source = util$2.getArg(aArgs, "source", null);
		var name = util$2.getArg(aArgs, "name", null);
		if (!this._skipValidation) {
			if (this._validateMapping(generated, original, source, name) === false) return;
		}
		if (source != null) {
			source = String(source);
			if (!this._sources.has(source)) this._sources.add(source);
		}
		if (name != null) {
			name = String(name);
			if (!this._names.has(name)) this._names.add(name);
		}
		this._mappings.add({
			generatedLine: generated.line,
			generatedColumn: generated.column,
			originalLine: original != null && original.line,
			originalColumn: original != null && original.column,
			source,
			name
		});
	};
	/**
	* Set the source content for a source file.
	*/
	SourceMapGenerator$1.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
		var source = aSourceFile;
		if (this._sourceRoot != null) source = util$2.relative(this._sourceRoot, source);
		if (aSourceContent != null) {
			if (!this._sourcesContents) this._sourcesContents = Object.create(null);
			this._sourcesContents[util$2.toSetString(source)] = aSourceContent;
		} else if (this._sourcesContents) {
			delete this._sourcesContents[util$2.toSetString(source)];
			if (Object.keys(this._sourcesContents).length === 0) this._sourcesContents = null;
		}
	};
	/**
	* Applies the mappings of a sub-source-map for a specific source file to the
	* source map being generated. Each mapping to the supplied source file is
	* rewritten using the supplied source map. Note: The resolution for the
	* resulting mappings is the minimium of this map and the supplied map.
	*
	* @param aSourceMapConsumer The source map to be applied.
	* @param aSourceFile Optional. The filename of the source file.
	*        If omitted, SourceMapConsumer's file property will be used.
	* @param aSourceMapPath Optional. The dirname of the path to the source map
	*        to be applied. If relative, it is relative to the SourceMapConsumer.
	*        This parameter is needed when the two source maps aren't in the same
	*        directory, and the source map to be applied contains relative source
	*        paths. If so, those relative source paths need to be rewritten
	*        relative to the SourceMapGenerator.
	*/
	SourceMapGenerator$1.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
		var sourceFile = aSourceFile;
		if (aSourceFile == null) {
			if (aSourceMapConsumer.file == null) throw new Error("SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's \"file\" property. Both were omitted.");
			sourceFile = aSourceMapConsumer.file;
		}
		var sourceRoot = this._sourceRoot;
		if (sourceRoot != null) sourceFile = util$2.relative(sourceRoot, sourceFile);
		var newSources = new ArraySet$1();
		var newNames = new ArraySet$1();
		this._mappings.unsortedForEach(function(mapping) {
			if (mapping.source === sourceFile && mapping.originalLine != null) {
				var original = aSourceMapConsumer.originalPositionFor({
					line: mapping.originalLine,
					column: mapping.originalColumn
				});
				if (original.source != null) {
					mapping.source = original.source;
					if (aSourceMapPath != null) mapping.source = util$2.join(aSourceMapPath, mapping.source);
					if (sourceRoot != null) mapping.source = util$2.relative(sourceRoot, mapping.source);
					mapping.originalLine = original.line;
					mapping.originalColumn = original.column;
					if (original.name != null) mapping.name = original.name;
				}
			}
			var source = mapping.source;
			if (source != null && !newSources.has(source)) newSources.add(source);
			var name = mapping.name;
			if (name != null && !newNames.has(name)) newNames.add(name);
		}, this);
		this._sources = newSources;
		this._names = newNames;
		aSourceMapConsumer.sources.forEach(function(sourceFile$1) {
			var content = aSourceMapConsumer.sourceContentFor(sourceFile$1);
			if (content != null) {
				if (aSourceMapPath != null) sourceFile$1 = util$2.join(aSourceMapPath, sourceFile$1);
				if (sourceRoot != null) sourceFile$1 = util$2.relative(sourceRoot, sourceFile$1);
				this.setSourceContent(sourceFile$1, content);
			}
		}, this);
	};
	/**
	* A mapping can have one of the three levels of data:
	*
	*   1. Just the generated position.
	*   2. The Generated position, original position, and original source.
	*   3. Generated and original position, original source, as well as a name
	*      token.
	*
	* To maintain consistency, we validate that any new mapping being added falls
	* in to one of these categories.
	*/
	SourceMapGenerator$1.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
		if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
			var message = "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.";
			if (this._ignoreInvalidMapping) {
				if (typeof console !== "undefined" && console.warn) console.warn(message);
				return false;
			} else throw new Error(message);
		}
		if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) return;
		else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) return;
		else {
			var message = "Invalid mapping: " + JSON.stringify({
				generated: aGenerated,
				source: aSource,
				original: aOriginal,
				name: aName
			});
			if (this._ignoreInvalidMapping) {
				if (typeof console !== "undefined" && console.warn) console.warn(message);
				return false;
			} else throw new Error(message);
		}
	};
	/**
	* Serialize the accumulated mappings in to the stream of base 64 VLQs
	* specified by the source map format.
	*/
	SourceMapGenerator$1.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
		var previousGeneratedColumn = 0;
		var previousGeneratedLine = 1;
		var previousOriginalColumn = 0;
		var previousOriginalLine = 0;
		var previousName = 0;
		var previousSource = 0;
		var result = "";
		var next$1;
		var mapping;
		var nameIdx;
		var sourceIdx;
		var mappings = this._mappings.toArray();
		for (var i = 0, len$1 = mappings.length; i < len$1; i++) {
			mapping = mappings[i];
			next$1 = "";
			if (mapping.generatedLine !== previousGeneratedLine) {
				previousGeneratedColumn = 0;
				while (mapping.generatedLine !== previousGeneratedLine) {
					next$1 += ";";
					previousGeneratedLine++;
				}
			} else if (i > 0) {
				if (!util$2.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) continue;
				next$1 += ",";
			}
			next$1 += base64VLQ$1.encode(mapping.generatedColumn - previousGeneratedColumn);
			previousGeneratedColumn = mapping.generatedColumn;
			if (mapping.source != null) {
				sourceIdx = this._sources.indexOf(mapping.source);
				next$1 += base64VLQ$1.encode(sourceIdx - previousSource);
				previousSource = sourceIdx;
				next$1 += base64VLQ$1.encode(mapping.originalLine - 1 - previousOriginalLine);
				previousOriginalLine = mapping.originalLine - 1;
				next$1 += base64VLQ$1.encode(mapping.originalColumn - previousOriginalColumn);
				previousOriginalColumn = mapping.originalColumn;
				if (mapping.name != null) {
					nameIdx = this._names.indexOf(mapping.name);
					next$1 += base64VLQ$1.encode(nameIdx - previousName);
					previousName = nameIdx;
				}
			}
			result += next$1;
		}
		return result;
	};
	SourceMapGenerator$1.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
		return aSources.map(function(source) {
			if (!this._sourcesContents) return null;
			if (aSourceRoot != null) source = util$2.relative(aSourceRoot, source);
			var key = util$2.toSetString(source);
			return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
		}, this);
	};
	/**
	* Externalize the source map.
	*/
	SourceMapGenerator$1.prototype.toJSON = function SourceMapGenerator_toJSON() {
		var map = {
			version: this._version,
			sources: this._sources.toArray(),
			names: this._names.toArray(),
			mappings: this._serializeMappings()
		};
		if (this._file != null) map.file = this._file;
		if (this._sourceRoot != null) map.sourceRoot = this._sourceRoot;
		if (this._sourcesContents) map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
		return map;
	};
	/**
	* Render the source map being generated to a string.
	*/
	SourceMapGenerator$1.prototype.toString = function SourceMapGenerator_toString() {
		return JSON.stringify(this.toJSON());
	};
	exports.SourceMapGenerator = SourceMapGenerator$1;
} });

//#endregion
//#region node_modules/source-map-js/lib/binary-search.js
var require_binary_search = __commonJS({ "node_modules/source-map-js/lib/binary-search.js"(exports) {
	exports.GREATEST_LOWER_BOUND = 1;
	exports.LEAST_UPPER_BOUND = 2;
	/**
	* Recursive implementation of binary search.
	*
	* @param aLow Indices here and lower do not contain the needle.
	* @param aHigh Indices here and higher do not contain the needle.
	* @param aNeedle The element being searched for.
	* @param aHaystack The non-empty array being searched.
	* @param aCompare Function which takes two elements and returns -1, 0, or 1.
	* @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
	*     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
	*     closest element that is smaller than or greater than the one we are
	*     searching for, respectively, if the exact element cannot be found.
	*/
	function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
		var mid = Math.floor((aHigh - aLow) / 2) + aLow;
		var cmp = aCompare(aNeedle, aHaystack[mid], true);
		if (cmp === 0) return mid;
		else if (cmp > 0) {
			if (aHigh - mid > 1) return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
			if (aBias == exports.LEAST_UPPER_BOUND) return aHigh < aHaystack.length ? aHigh : -1;
			else return mid;
		} else {
			if (mid - aLow > 1) return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
			if (aBias == exports.LEAST_UPPER_BOUND) return mid;
			else return aLow < 0 ? -1 : aLow;
		}
	}
	/**
	* This is an implementation of binary search which will always try and return
	* the index of the closest element if there is no exact hit. This is because
	* mappings between original and generated line/col pairs are single points,
	* and there is an implicit region between each of them, so a miss just means
	* that you aren't on the very start of a region.
	*
	* @param aNeedle The element you are looking for.
	* @param aHaystack The array that is being searched.
	* @param aCompare A function which takes the needle and an element in the
	*     array and returns -1, 0, or 1 depending on whether the needle is less
	*     than, equal to, or greater than the element, respectively.
	* @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
	*     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
	*     closest element that is smaller than or greater than the one we are
	*     searching for, respectively, if the exact element cannot be found.
	*     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
	*/
	exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
		if (aHaystack.length === 0) return -1;
		var index$1 = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare, aBias || exports.GREATEST_LOWER_BOUND);
		if (index$1 < 0) return -1;
		while (index$1 - 1 >= 0) {
			if (aCompare(aHaystack[index$1], aHaystack[index$1 - 1], true) !== 0) break;
			--index$1;
		}
		return index$1;
	};
} });

//#endregion
//#region node_modules/source-map-js/lib/quick-sort.js
var require_quick_sort = __commonJS({ "node_modules/source-map-js/lib/quick-sort.js"(exports) {
	function SortTemplate(comparator) {
		/**
		* Swap the elements indexed by `x` and `y` in the array `ary`.
		*
		* @param {Array} ary
		*        The array.
		* @param {Number} x
		*        The index of the first item.
		* @param {Number} y
		*        The index of the second item.
		*/
		function swap(ary, x, y) {
			var temp = ary[x];
			ary[x] = ary[y];
			ary[y] = temp;
		}
		/**
		* Returns a random integer within the range `low .. high` inclusive.
		*
		* @param {Number} low
		*        The lower bound on the range.
		* @param {Number} high
		*        The upper bound on the range.
		*/
		function randomIntInRange(low, high) {
			return Math.round(low + Math.random() * (high - low));
		}
		/**
		* The Quick Sort algorithm.
		*
		* @param {Array} ary
		*        An array to sort.
		* @param {function} comparator
		*        Function to use to compare two items.
		* @param {Number} p
		*        Start index of the array
		* @param {Number} r
		*        End index of the array
		*/
		function doQuickSort(ary, comparator$1, p, r) {
			if (p < r) {
				var pivotIndex = randomIntInRange(p, r);
				var i = p - 1;
				swap(ary, pivotIndex, r);
				var pivot = ary[r];
				for (var j = p; j < r; j++) if (comparator$1(ary[j], pivot, false) <= 0) {
					i += 1;
					swap(ary, i, j);
				}
				swap(ary, i + 1, j);
				var q = i + 1;
				doQuickSort(ary, comparator$1, p, q - 1);
				doQuickSort(ary, comparator$1, q + 1, r);
			}
		}
		return doQuickSort;
	}
	function cloneSort(comparator) {
		let template = SortTemplate.toString();
		let templateFn = new Function(`return ${template}`)();
		return templateFn(comparator);
	}
	/**
	* Sort the given array in-place with the given comparator function.
	*
	* @param {Array} ary
	*        An array to sort.
	* @param {function} comparator
	*        Function to use to compare two items.
	*/
	let sortCache = /* @__PURE__ */ new WeakMap();
	exports.quickSort = function(ary, comparator, start = 0) {
		let doQuickSort = sortCache.get(comparator);
		if (doQuickSort === void 0) {
			doQuickSort = cloneSort(comparator);
			sortCache.set(comparator, doQuickSort);
		}
		doQuickSort(ary, comparator, start, ary.length - 1);
	};
} });

//#endregion
//#region node_modules/source-map-js/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({ "node_modules/source-map-js/lib/source-map-consumer.js"(exports) {
	var util$1 = require_util();
	var binarySearch$1 = require_binary_search();
	var ArraySet = require_array_set().ArraySet;
	var base64VLQ = require_base64_vlq();
	var quickSort = require_quick_sort().quickSort;
	function SourceMapConsumer(aSourceMap, aSourceMapURL) {
		var sourceMap = aSourceMap;
		if (typeof aSourceMap === "string") sourceMap = util$1.parseSourceMapInput(aSourceMap);
		return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
	}
	SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
		return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
	};
	/**
	* The version of the source mapping spec that we are consuming.
	*/
	SourceMapConsumer.prototype._version = 3;
	SourceMapConsumer.prototype.__generatedMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
		configurable: true,
		enumerable: true,
		get: function() {
			if (!this.__generatedMappings) this._parseMappings(this._mappings, this.sourceRoot);
			return this.__generatedMappings;
		}
	});
	SourceMapConsumer.prototype.__originalMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
		configurable: true,
		enumerable: true,
		get: function() {
			if (!this.__originalMappings) this._parseMappings(this._mappings, this.sourceRoot);
			return this.__originalMappings;
		}
	});
	SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index$1) {
		var c = aStr.charAt(index$1);
		return c === ";" || c === ",";
	};
	/**
	* Parse the mappings in a string in to a data structure which we can easily
	* query (the ordered arrays in the `this.__generatedMappings` and
	* `this.__originalMappings` properties).
	*/
	SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		throw new Error("Subclasses must implement _parseMappings");
	};
	SourceMapConsumer.GENERATED_ORDER = 1;
	SourceMapConsumer.ORIGINAL_ORDER = 2;
	SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
	SourceMapConsumer.LEAST_UPPER_BOUND = 2;
	/**
	* Iterate over each mapping between an original source/line/column and a
	* generated line/column in this source map.
	*
	* @param Function aCallback
	*        The function that is called with each mapping.
	* @param Object aContext
	*        Optional. If specified, this object will be the value of `this` every
	*        time that `aCallback` is called.
	* @param aOrder
	*        Either `SourceMapConsumer.GENERATED_ORDER` or
	*        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
	*        iterate over the mappings sorted by the generated file's line/column
	*        order or the original's source/line/column order, respectively. Defaults to
	*        `SourceMapConsumer.GENERATED_ORDER`.
	*/
	SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
		var context = aContext || null;
		var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
		var mappings;
		switch (order) {
			case SourceMapConsumer.GENERATED_ORDER:
				mappings = this._generatedMappings;
				break;
			case SourceMapConsumer.ORIGINAL_ORDER:
				mappings = this._originalMappings;
				break;
			default: throw new Error("Unknown order of iteration.");
		}
		var sourceRoot = this.sourceRoot;
		var boundCallback = aCallback.bind(context);
		var names = this._names;
		var sources = this._sources;
		var sourceMapURL = this._sourceMapURL;
		for (var i = 0, n = mappings.length; i < n; i++) {
			var mapping = mappings[i];
			var source = mapping.source === null ? null : sources.at(mapping.source);
			if (source !== null) source = util$1.computeSourceURL(sourceRoot, source, sourceMapURL);
			boundCallback({
				source,
				generatedLine: mapping.generatedLine,
				generatedColumn: mapping.generatedColumn,
				originalLine: mapping.originalLine,
				originalColumn: mapping.originalColumn,
				name: mapping.name === null ? null : names.at(mapping.name)
			});
		}
	};
	/**
	* Returns all generated line and column information for the original source,
	* line, and column provided. If no column is provided, returns all mappings
	* corresponding to a either the line we are searching for or the next
	* closest line that has any mappings. Otherwise, returns all mappings
	* corresponding to the given line and either the column we are searching for
	* or the next closest column that has any offsets.
	*
	* The only argument is an object with the following properties:
	*
	*   - source: The filename of the original source.
	*   - line: The line number in the original source.  The line number is 1-based.
	*   - column: Optional. the column number in the original source.
	*    The column number is 0-based.
	*
	* and an array of objects is returned, each with the following properties:
	*
	*   - line: The line number in the generated source, or null.  The
	*    line number is 1-based.
	*   - column: The column number in the generated source, or null.
	*    The column number is 0-based.
	*/
	SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
		var line = util$1.getArg(aArgs, "line");
		var needle = {
			source: util$1.getArg(aArgs, "source"),
			originalLine: line,
			originalColumn: util$1.getArg(aArgs, "column", 0)
		};
		needle.source = this._findSourceIndex(needle.source);
		if (needle.source < 0) return [];
		var mappings = [];
		var index$1 = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util$1.compareByOriginalPositions, binarySearch$1.LEAST_UPPER_BOUND);
		if (index$1 >= 0) {
			var mapping = this._originalMappings[index$1];
			if (aArgs.column === void 0) {
				var originalLine = mapping.originalLine;
				while (mapping && mapping.originalLine === originalLine) {
					mappings.push({
						line: util$1.getArg(mapping, "generatedLine", null),
						column: util$1.getArg(mapping, "generatedColumn", null),
						lastColumn: util$1.getArg(mapping, "lastGeneratedColumn", null)
					});
					mapping = this._originalMappings[++index$1];
				}
			} else {
				var originalColumn = mapping.originalColumn;
				while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
					mappings.push({
						line: util$1.getArg(mapping, "generatedLine", null),
						column: util$1.getArg(mapping, "generatedColumn", null),
						lastColumn: util$1.getArg(mapping, "lastGeneratedColumn", null)
					});
					mapping = this._originalMappings[++index$1];
				}
			}
		}
		return mappings;
	};
	exports.SourceMapConsumer = SourceMapConsumer;
	/**
	* A BasicSourceMapConsumer instance represents a parsed source map which we can
	* query for information about the original file positions by giving it a file
	* position in the generated source.
	*
	* The first parameter is the raw source map (either as a JSON string, or
	* already parsed to an object). According to the spec, source maps have the
	* following attributes:
	*
	*   - version: Which version of the source map spec this map is following.
	*   - sources: An array of URLs to the original source files.
	*   - names: An array of identifiers which can be referrenced by individual mappings.
	*   - sourceRoot: Optional. The URL root from which all sources are relative.
	*   - sourcesContent: Optional. An array of contents of the original source files.
	*   - mappings: A string of base64 VLQs which contain the actual mappings.
	*   - file: Optional. The generated file this source map is associated with.
	*
	* Here is an example source map, taken from the source map spec[0]:
	*
	*     {
	*       version : 3,
	*       file: "out.js",
	*       sourceRoot : "",
	*       sources: ["foo.js", "bar.js"],
	*       names: ["src", "maps", "are", "fun"],
	*       mappings: "AA,AB;;ABCDE;"
	*     }
	*
	* The second parameter, if given, is a string whose value is the URL
	* at which the source map was found.  This URL is used to compute the
	* sources array.
	*
	* [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
	*/
	function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
		var sourceMap = aSourceMap;
		if (typeof aSourceMap === "string") sourceMap = util$1.parseSourceMapInput(aSourceMap);
		var version = util$1.getArg(sourceMap, "version");
		var sources = util$1.getArg(sourceMap, "sources");
		var names = util$1.getArg(sourceMap, "names", []);
		var sourceRoot = util$1.getArg(sourceMap, "sourceRoot", null);
		var sourcesContent = util$1.getArg(sourceMap, "sourcesContent", null);
		var mappings = util$1.getArg(sourceMap, "mappings");
		var file = util$1.getArg(sourceMap, "file", null);
		if (version != this._version) throw new Error("Unsupported version: " + version);
		if (sourceRoot) sourceRoot = util$1.normalize(sourceRoot);
		sources = sources.map(String).map(util$1.normalize).map(function(source) {
			return sourceRoot && util$1.isAbsolute(sourceRoot) && util$1.isAbsolute(source) ? util$1.relative(sourceRoot, source) : source;
		});
		this._names = ArraySet.fromArray(names.map(String), true);
		this._sources = ArraySet.fromArray(sources, true);
		this._absoluteSources = this._sources.toArray().map(function(s) {
			return util$1.computeSourceURL(sourceRoot, s, aSourceMapURL);
		});
		this.sourceRoot = sourceRoot;
		this.sourcesContent = sourcesContent;
		this._mappings = mappings;
		this._sourceMapURL = aSourceMapURL;
		this.file = file;
	}
	BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
	/**
	* Utility function to find the index of a source.  Returns -1 if not
	* found.
	*/
	BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
		var relativeSource = aSource;
		if (this.sourceRoot != null) relativeSource = util$1.relative(this.sourceRoot, relativeSource);
		if (this._sources.has(relativeSource)) return this._sources.indexOf(relativeSource);
		var i;
		for (i = 0; i < this._absoluteSources.length; ++i) if (this._absoluteSources[i] == aSource) return i;
		return -1;
	};
	/**
	* Create a BasicSourceMapConsumer from a SourceMapGenerator.
	*
	* @param SourceMapGenerator aSourceMap
	*        The source map that will be consumed.
	* @param String aSourceMapURL
	*        The URL at which the source map can be found (optional)
	* @returns BasicSourceMapConsumer
	*/
	BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
		var smc = Object.create(BasicSourceMapConsumer.prototype);
		var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
		var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
		smc.sourceRoot = aSourceMap._sourceRoot;
		smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
		smc.file = aSourceMap._file;
		smc._sourceMapURL = aSourceMapURL;
		smc._absoluteSources = smc._sources.toArray().map(function(s) {
			return util$1.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
		});
		var generatedMappings = aSourceMap._mappings.toArray().slice();
		var destGeneratedMappings = smc.__generatedMappings = [];
		var destOriginalMappings = smc.__originalMappings = [];
		for (var i = 0, length = generatedMappings.length; i < length; i++) {
			var srcMapping = generatedMappings[i];
			var destMapping = new Mapping();
			destMapping.generatedLine = srcMapping.generatedLine;
			destMapping.generatedColumn = srcMapping.generatedColumn;
			if (srcMapping.source) {
				destMapping.source = sources.indexOf(srcMapping.source);
				destMapping.originalLine = srcMapping.originalLine;
				destMapping.originalColumn = srcMapping.originalColumn;
				if (srcMapping.name) destMapping.name = names.indexOf(srcMapping.name);
				destOriginalMappings.push(destMapping);
			}
			destGeneratedMappings.push(destMapping);
		}
		quickSort(smc.__originalMappings, util$1.compareByOriginalPositions);
		return smc;
	};
	/**
	* The version of the source mapping spec that we are consuming.
	*/
	BasicSourceMapConsumer.prototype._version = 3;
	/**
	* The list of original sources.
	*/
	Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", { get: function() {
		return this._absoluteSources.slice();
	} });
	/**
	* Provide the JIT with a nice shape / hidden class.
	*/
	function Mapping() {
		this.generatedLine = 0;
		this.generatedColumn = 0;
		this.source = null;
		this.originalLine = null;
		this.originalColumn = null;
		this.name = null;
	}
	/**
	* Parse the mappings in a string in to a data structure which we can easily
	* query (the ordered arrays in the `this.__generatedMappings` and
	* `this.__originalMappings` properties).
	*/
	const compareGenerated = util$1.compareByGeneratedPositionsDeflatedNoLine;
	function sortGenerated(array, start) {
		let l = array.length;
		let n = array.length - start;
		if (n <= 1) return;
		else if (n == 2) {
			let a = array[start];
			let b = array[start + 1];
			if (compareGenerated(a, b) > 0) {
				array[start] = b;
				array[start + 1] = a;
			}
		} else if (n < 20) for (let i = start; i < l; i++) for (let j = i; j > start; j--) {
			let a = array[j - 1];
			let b = array[j];
			if (compareGenerated(a, b) <= 0) break;
			array[j - 1] = b;
			array[j] = a;
		}
		else quickSort(array, compareGenerated, start);
	}
	BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		var generatedLine = 1;
		var previousGeneratedColumn = 0;
		var previousOriginalLine = 0;
		var previousOriginalColumn = 0;
		var previousSource = 0;
		var previousName = 0;
		var length = aStr.length;
		var index$1 = 0;
		var cachedSegments = {};
		var temp = {};
		var originalMappings = [];
		var generatedMappings = [];
		var mapping, str$1, segment, end, value;
		let subarrayStart = 0;
		while (index$1 < length) if (aStr.charAt(index$1) === ";") {
			generatedLine++;
			index$1++;
			previousGeneratedColumn = 0;
			sortGenerated(generatedMappings, subarrayStart);
			subarrayStart = generatedMappings.length;
		} else if (aStr.charAt(index$1) === ",") index$1++;
		else {
			mapping = new Mapping();
			mapping.generatedLine = generatedLine;
			for (end = index$1; end < length; end++) if (this._charIsMappingSeparator(aStr, end)) break;
			str$1 = aStr.slice(index$1, end);
			segment = [];
			while (index$1 < end) {
				base64VLQ.decode(aStr, index$1, temp);
				value = temp.value;
				index$1 = temp.rest;
				segment.push(value);
			}
			if (segment.length === 2) throw new Error("Found a source, but no line and column");
			if (segment.length === 3) throw new Error("Found a source and line, but no column");
			mapping.generatedColumn = previousGeneratedColumn + segment[0];
			previousGeneratedColumn = mapping.generatedColumn;
			if (segment.length > 1) {
				mapping.source = previousSource + segment[1];
				previousSource += segment[1];
				mapping.originalLine = previousOriginalLine + segment[2];
				previousOriginalLine = mapping.originalLine;
				mapping.originalLine += 1;
				mapping.originalColumn = previousOriginalColumn + segment[3];
				previousOriginalColumn = mapping.originalColumn;
				if (segment.length > 4) {
					mapping.name = previousName + segment[4];
					previousName += segment[4];
				}
			}
			generatedMappings.push(mapping);
			if (typeof mapping.originalLine === "number") {
				let currentSource = mapping.source;
				while (originalMappings.length <= currentSource) originalMappings.push(null);
				if (originalMappings[currentSource] === null) originalMappings[currentSource] = [];
				originalMappings[currentSource].push(mapping);
			}
		}
		sortGenerated(generatedMappings, subarrayStart);
		this.__generatedMappings = generatedMappings;
		for (var i = 0; i < originalMappings.length; i++) if (originalMappings[i] != null) quickSort(originalMappings[i], util$1.compareByOriginalPositionsNoSource);
		this.__originalMappings = [].concat(...originalMappings);
	};
	/**
	* Find the mapping that best matches the hypothetical "needle" mapping that
	* we are searching for in the given "haystack" of mappings.
	*/
	BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
		if (aNeedle[aLineName] <= 0) throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
		if (aNeedle[aColumnName] < 0) throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
		return binarySearch$1.search(aNeedle, aMappings, aComparator, aBias);
	};
	/**
	* Compute the last column for each generated mapping. The last column is
	* inclusive.
	*/
	BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
		for (var index$1 = 0; index$1 < this._generatedMappings.length; ++index$1) {
			var mapping = this._generatedMappings[index$1];
			if (index$1 + 1 < this._generatedMappings.length) {
				var nextMapping = this._generatedMappings[index$1 + 1];
				if (mapping.generatedLine === nextMapping.generatedLine) {
					mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
					continue;
				}
			}
			mapping.lastGeneratedColumn = Infinity;
		}
	};
	/**
	* Returns the original source, line, and column information for the generated
	* source's line and column positions provided. The only argument is an object
	* with the following properties:
	*
	*   - line: The line number in the generated source.  The line number
	*     is 1-based.
	*   - column: The column number in the generated source.  The column
	*     number is 0-based.
	*   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	*     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	*     closest element that is smaller than or greater than the one we are
	*     searching for, respectively, if the exact element cannot be found.
	*     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	*
	* and an object is returned with the following properties:
	*
	*   - source: The original source file, or null.
	*   - line: The line number in the original source, or null.  The
	*     line number is 1-based.
	*   - column: The column number in the original source, or null.  The
	*     column number is 0-based.
	*   - name: The original identifier, or null.
	*/
	BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
		var needle = {
			generatedLine: util$1.getArg(aArgs, "line"),
			generatedColumn: util$1.getArg(aArgs, "column")
		};
		var index$1 = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util$1.compareByGeneratedPositionsDeflated, util$1.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND));
		if (index$1 >= 0) {
			var mapping = this._generatedMappings[index$1];
			if (mapping.generatedLine === needle.generatedLine) {
				var source = util$1.getArg(mapping, "source", null);
				if (source !== null) {
					source = this._sources.at(source);
					source = util$1.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
				}
				var name = util$1.getArg(mapping, "name", null);
				if (name !== null) name = this._names.at(name);
				return {
					source,
					line: util$1.getArg(mapping, "originalLine", null),
					column: util$1.getArg(mapping, "originalColumn", null),
					name
				};
			}
		}
		return {
			source: null,
			line: null,
			column: null,
			name: null
		};
	};
	/**
	* Return true if we have the source content for every source in the source
	* map, false otherwise.
	*/
	BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
		if (!this.sourcesContent) return false;
		return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
			return sc == null;
		});
	};
	/**
	* Returns the original source content. The only argument is the url of the
	* original source file. Returns null if no original source content is
	* available.
	*/
	BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
		if (!this.sourcesContent) return null;
		var index$1 = this._findSourceIndex(aSource);
		if (index$1 >= 0) return this.sourcesContent[index$1];
		var relativeSource = aSource;
		if (this.sourceRoot != null) relativeSource = util$1.relative(this.sourceRoot, relativeSource);
		var url;
		if (this.sourceRoot != null && (url = util$1.urlParse(this.sourceRoot))) {
			var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
			if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
			if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
		}
		if (nullOnMissing) return null;
		else throw new Error("\"" + relativeSource + "\" is not in the SourceMap.");
	};
	/**
	* Returns the generated line and column information for the original source,
	* line, and column positions provided. The only argument is an object with
	* the following properties:
	*
	*   - source: The filename of the original source.
	*   - line: The line number in the original source.  The line number
	*     is 1-based.
	*   - column: The column number in the original source.  The column
	*     number is 0-based.
	*   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	*     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	*     closest element that is smaller than or greater than the one we are
	*     searching for, respectively, if the exact element cannot be found.
	*     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	*
	* and an object is returned with the following properties:
	*
	*   - line: The line number in the generated source, or null.  The
	*     line number is 1-based.
	*   - column: The column number in the generated source, or null.
	*     The column number is 0-based.
	*/
	BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
		var source = util$1.getArg(aArgs, "source");
		source = this._findSourceIndex(source);
		if (source < 0) return {
			line: null,
			column: null,
			lastColumn: null
		};
		var needle = {
			source,
			originalLine: util$1.getArg(aArgs, "line"),
			originalColumn: util$1.getArg(aArgs, "column")
		};
		var index$1 = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util$1.compareByOriginalPositions, util$1.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND));
		if (index$1 >= 0) {
			var mapping = this._originalMappings[index$1];
			if (mapping.source === needle.source) return {
				line: util$1.getArg(mapping, "generatedLine", null),
				column: util$1.getArg(mapping, "generatedColumn", null),
				lastColumn: util$1.getArg(mapping, "lastGeneratedColumn", null)
			};
		}
		return {
			line: null,
			column: null,
			lastColumn: null
		};
	};
	exports.BasicSourceMapConsumer = BasicSourceMapConsumer;
	/**
	* An IndexedSourceMapConsumer instance represents a parsed source map which
	* we can query for information. It differs from BasicSourceMapConsumer in
	* that it takes "indexed" source maps (i.e. ones with a "sections" field) as
	* input.
	*
	* The first parameter is a raw source map (either as a JSON string, or already
	* parsed to an object). According to the spec for indexed source maps, they
	* have the following attributes:
	*
	*   - version: Which version of the source map spec this map is following.
	*   - file: Optional. The generated file this source map is associated with.
	*   - sections: A list of section definitions.
	*
	* Each value under the "sections" field has two fields:
	*   - offset: The offset into the original specified at which this section
	*       begins to apply, defined as an object with a "line" and "column"
	*       field.
	*   - map: A source map definition. This source map could also be indexed,
	*       but doesn't have to be.
	*
	* Instead of the "map" field, it's also possible to have a "url" field
	* specifying a URL to retrieve a source map from, but that's currently
	* unsupported.
	*
	* Here's an example source map, taken from the source map spec[0], but
	* modified to omit a section which uses the "url" field.
	*
	*  {
	*    version : 3,
	*    file: "app.js",
	*    sections: [{
	*      offset: {line:100, column:10},
	*      map: {
	*        version : 3,
	*        file: "section.js",
	*        sources: ["foo.js", "bar.js"],
	*        names: ["src", "maps", "are", "fun"],
	*        mappings: "AAAA,E;;ABCDE;"
	*      }
	*    }],
	*  }
	*
	* The second parameter, if given, is a string whose value is the URL
	* at which the source map was found.  This URL is used to compute the
	* sources array.
	*
	* [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
	*/
	function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
		var sourceMap = aSourceMap;
		if (typeof aSourceMap === "string") sourceMap = util$1.parseSourceMapInput(aSourceMap);
		var version = util$1.getArg(sourceMap, "version");
		var sections = util$1.getArg(sourceMap, "sections");
		if (version != this._version) throw new Error("Unsupported version: " + version);
		this._sources = new ArraySet();
		this._names = new ArraySet();
		var lastOffset = {
			line: -1,
			column: 0
		};
		this._sections = sections.map(function(s) {
			if (s.url) throw new Error("Support for url field in sections not implemented.");
			var offset = util$1.getArg(s, "offset");
			var offsetLine = util$1.getArg(offset, "line");
			var offsetColumn = util$1.getArg(offset, "column");
			if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) throw new Error("Section offsets must be ordered and non-overlapping.");
			lastOffset = offset;
			return {
				generatedOffset: {
					generatedLine: offsetLine + 1,
					generatedColumn: offsetColumn + 1
				},
				consumer: new SourceMapConsumer(util$1.getArg(s, "map"), aSourceMapURL)
			};
		});
	}
	IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
	/**
	* The version of the source mapping spec that we are consuming.
	*/
	IndexedSourceMapConsumer.prototype._version = 3;
	/**
	* The list of original sources.
	*/
	Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", { get: function() {
		var sources = [];
		for (var i = 0; i < this._sections.length; i++) for (var j = 0; j < this._sections[i].consumer.sources.length; j++) sources.push(this._sections[i].consumer.sources[j]);
		return sources;
	} });
	/**
	* Returns the original source, line, and column information for the generated
	* source's line and column positions provided. The only argument is an object
	* with the following properties:
	*
	*   - line: The line number in the generated source.  The line number
	*     is 1-based.
	*   - column: The column number in the generated source.  The column
	*     number is 0-based.
	*
	* and an object is returned with the following properties:
	*
	*   - source: The original source file, or null.
	*   - line: The line number in the original source, or null.  The
	*     line number is 1-based.
	*   - column: The column number in the original source, or null.  The
	*     column number is 0-based.
	*   - name: The original identifier, or null.
	*/
	IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
		var needle = {
			generatedLine: util$1.getArg(aArgs, "line"),
			generatedColumn: util$1.getArg(aArgs, "column")
		};
		var sectionIndex = binarySearch$1.search(needle, this._sections, function(needle$1, section$1) {
			var cmp = needle$1.generatedLine - section$1.generatedOffset.generatedLine;
			if (cmp) return cmp;
			return needle$1.generatedColumn - section$1.generatedOffset.generatedColumn;
		});
		var section = this._sections[sectionIndex];
		if (!section) return {
			source: null,
			line: null,
			column: null,
			name: null
		};
		return section.consumer.originalPositionFor({
			line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
			column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
			bias: aArgs.bias
		});
	};
	/**
	* Return true if we have the source content for every source in the source
	* map, false otherwise.
	*/
	IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
		return this._sections.every(function(s) {
			return s.consumer.hasContentsOfAllSources();
		});
	};
	/**
	* Returns the original source content. The only argument is the url of the
	* original source file. Returns null if no original source content is
	* available.
	*/
	IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
		for (var i = 0; i < this._sections.length; i++) {
			var section = this._sections[i];
			var content = section.consumer.sourceContentFor(aSource, true);
			if (content || content === "") return content;
		}
		if (nullOnMissing) return null;
		else throw new Error("\"" + aSource + "\" is not in the SourceMap.");
	};
	/**
	* Returns the generated line and column information for the original source,
	* line, and column positions provided. The only argument is an object with
	* the following properties:
	*
	*   - source: The filename of the original source.
	*   - line: The line number in the original source.  The line number
	*     is 1-based.
	*   - column: The column number in the original source.  The column
	*     number is 0-based.
	*
	* and an object is returned with the following properties:
	*
	*   - line: The line number in the generated source, or null.  The
	*     line number is 1-based. 
	*   - column: The column number in the generated source, or null.
	*     The column number is 0-based.
	*/
	IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
		for (var i = 0; i < this._sections.length; i++) {
			var section = this._sections[i];
			if (section.consumer._findSourceIndex(util$1.getArg(aArgs, "source")) === -1) continue;
			var generatedPosition = section.consumer.generatedPositionFor(aArgs);
			if (generatedPosition) {
				var ret = {
					line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
					column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
				};
				return ret;
			}
		}
		return {
			line: null,
			column: null
		};
	};
	/**
	* Parse the mappings in a string in to a data structure which we can easily
	* query (the ordered arrays in the `this.__generatedMappings` and
	* `this.__originalMappings` properties).
	*/
	IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		this.__generatedMappings = [];
		this.__originalMappings = [];
		for (var i = 0; i < this._sections.length; i++) {
			var section = this._sections[i];
			var sectionMappings = section.consumer._generatedMappings;
			for (var j = 0; j < sectionMappings.length; j++) {
				var mapping = sectionMappings[j];
				var source = section.consumer._sources.at(mapping.source);
				if (source !== null) source = util$1.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
				this._sources.add(source);
				source = this._sources.indexOf(source);
				var name = null;
				if (mapping.name) {
					name = section.consumer._names.at(mapping.name);
					this._names.add(name);
					name = this._names.indexOf(name);
				}
				var adjustedMapping = {
					source,
					generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
					generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
					originalLine: mapping.originalLine,
					originalColumn: mapping.originalColumn,
					name
				};
				this.__generatedMappings.push(adjustedMapping);
				if (typeof adjustedMapping.originalLine === "number") this.__originalMappings.push(adjustedMapping);
			}
		}
		quickSort(this.__generatedMappings, util$1.compareByGeneratedPositionsDeflated);
		quickSort(this.__originalMappings, util$1.compareByOriginalPositions);
	};
	exports.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
} });

//#endregion
//#region node_modules/source-map-js/lib/source-node.js
var require_source_node = __commonJS({ "node_modules/source-map-js/lib/source-node.js"(exports) {
	var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
	var util = require_util();
	var REGEX_NEWLINE = /(\r?\n)/;
	var NEWLINE_CODE = 10;
	var isSourceNode = "$$$isSourceNode$$$";
	/**
	* SourceNodes provide a way to abstract over interpolating/concatenating
	* snippets of generated JavaScript source code while maintaining the line and
	* column information associated with the original source code.
	*
	* @param aLine The original line number.
	* @param aColumn The original column number.
	* @param aSource The original source's filename.
	* @param aChunks Optional. An array of strings which are snippets of
	*        generated JS, or other SourceNodes.
	* @param aName The original identifier.
	*/
	function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
		this.children = [];
		this.sourceContents = {};
		this.line = aLine == null ? null : aLine;
		this.column = aColumn == null ? null : aColumn;
		this.source = aSource == null ? null : aSource;
		this.name = aName == null ? null : aName;
		this[isSourceNode] = true;
		if (aChunks != null) this.add(aChunks);
	}
	/**
	* Creates a SourceNode from generated code and a SourceMapConsumer.
	*
	* @param aGeneratedCode The generated code
	* @param aSourceMapConsumer The SourceMap for the generated code
	* @param aRelativePath Optional. The path that relative sources in the
	*        SourceMapConsumer should be relative to.
	*/
	SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
		var node = new SourceNode();
		var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
		var remainingLinesIndex = 0;
		var shiftNextLine = function() {
			var lineContents = getNextLine();
			var newLine = getNextLine() || "";
			return lineContents + newLine;
			function getNextLine() {
				return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
			}
		};
		var lastGeneratedLine = 1, lastGeneratedColumn = 0;
		var lastMapping = null;
		aSourceMapConsumer.eachMapping(function(mapping) {
			if (lastMapping !== null) if (lastGeneratedLine < mapping.generatedLine) {
				addMappingWithCode(lastMapping, shiftNextLine());
				lastGeneratedLine++;
				lastGeneratedColumn = 0;
			} else {
				var nextLine = remainingLines[remainingLinesIndex] || "";
				var code$1 = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
				remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
				lastGeneratedColumn = mapping.generatedColumn;
				addMappingWithCode(lastMapping, code$1);
				lastMapping = mapping;
				return;
			}
			while (lastGeneratedLine < mapping.generatedLine) {
				node.add(shiftNextLine());
				lastGeneratedLine++;
			}
			if (lastGeneratedColumn < mapping.generatedColumn) {
				var nextLine = remainingLines[remainingLinesIndex] || "";
				node.add(nextLine.substr(0, mapping.generatedColumn));
				remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
				lastGeneratedColumn = mapping.generatedColumn;
			}
			lastMapping = mapping;
		}, this);
		if (remainingLinesIndex < remainingLines.length) {
			if (lastMapping) addMappingWithCode(lastMapping, shiftNextLine());
			node.add(remainingLines.splice(remainingLinesIndex).join(""));
		}
		aSourceMapConsumer.sources.forEach(function(sourceFile) {
			var content = aSourceMapConsumer.sourceContentFor(sourceFile);
			if (content != null) {
				if (aRelativePath != null) sourceFile = util.join(aRelativePath, sourceFile);
				node.setSourceContent(sourceFile, content);
			}
		});
		return node;
		function addMappingWithCode(mapping, code$1) {
			if (mapping === null || mapping.source === void 0) node.add(code$1);
			else {
				var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
				node.add(new SourceNode(mapping.originalLine, mapping.originalColumn, source, code$1, mapping.name));
			}
		}
	};
	/**
	* Add a chunk of generated JS to this source node.
	*
	* @param aChunk A string snippet of generated JS code, another instance of
	*        SourceNode, or an array where each member is one of those things.
	*/
	SourceNode.prototype.add = function SourceNode_add(aChunk) {
		if (Array.isArray(aChunk)) aChunk.forEach(function(chunk) {
			this.add(chunk);
		}, this);
		else if (aChunk[isSourceNode] || typeof aChunk === "string") {
			if (aChunk) this.children.push(aChunk);
		} else throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
		return this;
	};
	/**
	* Add a chunk of generated JS to the beginning of this source node.
	*
	* @param aChunk A string snippet of generated JS code, another instance of
	*        SourceNode, or an array where each member is one of those things.
	*/
	SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
		if (Array.isArray(aChunk)) for (var i = aChunk.length - 1; i >= 0; i--) this.prepend(aChunk[i]);
		else if (aChunk[isSourceNode] || typeof aChunk === "string") this.children.unshift(aChunk);
		else throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
		return this;
	};
	/**
	* Walk over the tree of JS snippets in this node and its children. The
	* walking function is called once for each snippet of JS and is passed that
	* snippet and the its original associated source's line/column location.
	*
	* @param aFn The traversal function.
	*/
	SourceNode.prototype.walk = function SourceNode_walk(aFn) {
		var chunk;
		for (var i = 0, len$1 = this.children.length; i < len$1; i++) {
			chunk = this.children[i];
			if (chunk[isSourceNode]) chunk.walk(aFn);
			else if (chunk !== "") aFn(chunk, {
				source: this.source,
				line: this.line,
				column: this.column,
				name: this.name
			});
		}
	};
	/**
	* Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
	* each of `this.children`.
	*
	* @param aSep The separator.
	*/
	SourceNode.prototype.join = function SourceNode_join(aSep) {
		var newChildren;
		var i;
		var len$1 = this.children.length;
		if (len$1 > 0) {
			newChildren = [];
			for (i = 0; i < len$1 - 1; i++) {
				newChildren.push(this.children[i]);
				newChildren.push(aSep);
			}
			newChildren.push(this.children[i]);
			this.children = newChildren;
		}
		return this;
	};
	/**
	* Call String.prototype.replace on the very right-most source snippet. Useful
	* for trimming whitespace from the end of a source node, etc.
	*
	* @param aPattern The pattern to replace.
	* @param aReplacement The thing to replace the pattern with.
	*/
	SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
		var lastChild = this.children[this.children.length - 1];
		if (lastChild[isSourceNode]) lastChild.replaceRight(aPattern, aReplacement);
		else if (typeof lastChild === "string") this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
		else this.children.push("".replace(aPattern, aReplacement));
		return this;
	};
	/**
	* Set the source content for a source file. This will be added to the SourceMapGenerator
	* in the sourcesContent field.
	*
	* @param aSourceFile The filename of the source file
	* @param aSourceContent The content of the source file
	*/
	SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
		this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
	};
	/**
	* Walk over the tree of SourceNodes. The walking function is called for each
	* source file content and is passed the filename and source content.
	*
	* @param aFn The traversal function.
	*/
	SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
		for (var i = 0, len$1 = this.children.length; i < len$1; i++) if (this.children[i][isSourceNode]) this.children[i].walkSourceContents(aFn);
		var sources = Object.keys(this.sourceContents);
		for (var i = 0, len$1 = sources.length; i < len$1; i++) aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
	};
	/**
	* Return the string representation of this source node. Walks over the tree
	* and concatenates all the various snippets together to one string.
	*/
	SourceNode.prototype.toString = function SourceNode_toString() {
		var str$1 = "";
		this.walk(function(chunk) {
			str$1 += chunk;
		});
		return str$1;
	};
	/**
	* Returns the string representation of this source node along with a source
	* map.
	*/
	SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
		var generated = {
			code: "",
			line: 1,
			column: 0
		};
		var map = new SourceMapGenerator(aArgs);
		var sourceMappingActive = false;
		var lastOriginalSource = null;
		var lastOriginalLine = null;
		var lastOriginalColumn = null;
		var lastOriginalName = null;
		this.walk(function(chunk, original) {
			generated.code += chunk;
			if (original.source !== null && original.line !== null && original.column !== null) {
				if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) map.addMapping({
					source: original.source,
					original: {
						line: original.line,
						column: original.column
					},
					generated: {
						line: generated.line,
						column: generated.column
					},
					name: original.name
				});
				lastOriginalSource = original.source;
				lastOriginalLine = original.line;
				lastOriginalColumn = original.column;
				lastOriginalName = original.name;
				sourceMappingActive = true;
			} else if (sourceMappingActive) {
				map.addMapping({ generated: {
					line: generated.line,
					column: generated.column
				} });
				lastOriginalSource = null;
				sourceMappingActive = false;
			}
			for (var idx = 0, length = chunk.length; idx < length; idx++) if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
				generated.line++;
				generated.column = 0;
				if (idx + 1 === length) {
					lastOriginalSource = null;
					sourceMappingActive = false;
				} else if (sourceMappingActive) map.addMapping({
					source: original.source,
					original: {
						line: original.line,
						column: original.column
					},
					generated: {
						line: generated.line,
						column: generated.column
					},
					name: original.name
				});
			} else generated.column++;
		});
		this.walkSourceContents(function(sourceFile, sourceContent) {
			map.setSourceContent(sourceFile, sourceContent);
		});
		return {
			code: generated.code,
			map
		};
	};
	exports.SourceNode = SourceNode;
} });

//#endregion
//#region node_modules/source-map-js/source-map.js
var require_source_map = __commonJS({ "node_modules/source-map-js/source-map.js"(exports) {
	exports.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
	exports.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
	exports.SourceNode = require_source_node().SourceNode;
} });

//#endregion
//#region node_modules/@vue/compiler-core/dist/compiler-core.cjs.prod.js
var require_compiler_core_cjs_prod = __commonJS({ "node_modules/@vue/compiler-core/dist/compiler-core.cjs.prod.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	var shared$1 = require_shared$2();
	var decode_js = require_decode();
	var parser = require_lib();
	var estreeWalker = require_estree_walker();
	var sourceMapJs = require_source_map();
	const FRAGMENT = Symbol(``);
	const TELEPORT = Symbol(``);
	const SUSPENSE = Symbol(``);
	const KEEP_ALIVE = Symbol(``);
	const BASE_TRANSITION = Symbol(``);
	const OPEN_BLOCK = Symbol(``);
	const CREATE_BLOCK = Symbol(``);
	const CREATE_ELEMENT_BLOCK = Symbol(``);
	const CREATE_VNODE = Symbol(``);
	const CREATE_ELEMENT_VNODE = Symbol(``);
	const CREATE_COMMENT = Symbol(``);
	const CREATE_TEXT = Symbol(``);
	const CREATE_STATIC = Symbol(``);
	const RESOLVE_COMPONENT = Symbol(``);
	const RESOLVE_DYNAMIC_COMPONENT = Symbol(``);
	const RESOLVE_DIRECTIVE = Symbol(``);
	const RESOLVE_FILTER = Symbol(``);
	const WITH_DIRECTIVES = Symbol(``);
	const RENDER_LIST = Symbol(``);
	const RENDER_SLOT = Symbol(``);
	const CREATE_SLOTS = Symbol(``);
	const TO_DISPLAY_STRING = Symbol(``);
	const MERGE_PROPS = Symbol(``);
	const NORMALIZE_CLASS = Symbol(``);
	const NORMALIZE_STYLE = Symbol(``);
	const NORMALIZE_PROPS = Symbol(``);
	const GUARD_REACTIVE_PROPS = Symbol(``);
	const TO_HANDLERS = Symbol(``);
	const CAMELIZE = Symbol(``);
	const CAPITALIZE = Symbol(``);
	const TO_HANDLER_KEY = Symbol(``);
	const SET_BLOCK_TRACKING = Symbol(``);
	const PUSH_SCOPE_ID = Symbol(``);
	const POP_SCOPE_ID = Symbol(``);
	const WITH_CTX = Symbol(``);
	const UNREF = Symbol(``);
	const IS_REF = Symbol(``);
	const WITH_MEMO = Symbol(``);
	const IS_MEMO_SAME = Symbol(``);
	const helperNameMap = {
		[FRAGMENT]: `Fragment`,
		[TELEPORT]: `Teleport`,
		[SUSPENSE]: `Suspense`,
		[KEEP_ALIVE]: `KeepAlive`,
		[BASE_TRANSITION]: `BaseTransition`,
		[OPEN_BLOCK]: `openBlock`,
		[CREATE_BLOCK]: `createBlock`,
		[CREATE_ELEMENT_BLOCK]: `createElementBlock`,
		[CREATE_VNODE]: `createVNode`,
		[CREATE_ELEMENT_VNODE]: `createElementVNode`,
		[CREATE_COMMENT]: `createCommentVNode`,
		[CREATE_TEXT]: `createTextVNode`,
		[CREATE_STATIC]: `createStaticVNode`,
		[RESOLVE_COMPONENT]: `resolveComponent`,
		[RESOLVE_DYNAMIC_COMPONENT]: `resolveDynamicComponent`,
		[RESOLVE_DIRECTIVE]: `resolveDirective`,
		[RESOLVE_FILTER]: `resolveFilter`,
		[WITH_DIRECTIVES]: `withDirectives`,
		[RENDER_LIST]: `renderList`,
		[RENDER_SLOT]: `renderSlot`,
		[CREATE_SLOTS]: `createSlots`,
		[TO_DISPLAY_STRING]: `toDisplayString`,
		[MERGE_PROPS]: `mergeProps`,
		[NORMALIZE_CLASS]: `normalizeClass`,
		[NORMALIZE_STYLE]: `normalizeStyle`,
		[NORMALIZE_PROPS]: `normalizeProps`,
		[GUARD_REACTIVE_PROPS]: `guardReactiveProps`,
		[TO_HANDLERS]: `toHandlers`,
		[CAMELIZE]: `camelize`,
		[CAPITALIZE]: `capitalize`,
		[TO_HANDLER_KEY]: `toHandlerKey`,
		[SET_BLOCK_TRACKING]: `setBlockTracking`,
		[PUSH_SCOPE_ID]: `pushScopeId`,
		[POP_SCOPE_ID]: `popScopeId`,
		[WITH_CTX]: `withCtx`,
		[UNREF]: `unref`,
		[IS_REF]: `isRef`,
		[WITH_MEMO]: `withMemo`,
		[IS_MEMO_SAME]: `isMemoSame`
	};
	function registerRuntimeHelpers(helpers) {
		Object.getOwnPropertySymbols(helpers).forEach((s) => {
			helperNameMap[s] = helpers[s];
		});
	}
	const Namespaces = {
		"HTML": 0,
		"0": "HTML",
		"SVG": 1,
		"1": "SVG",
		"MATH_ML": 2,
		"2": "MATH_ML"
	};
	const NodeTypes = {
		"ROOT": 0,
		"0": "ROOT",
		"ELEMENT": 1,
		"1": "ELEMENT",
		"TEXT": 2,
		"2": "TEXT",
		"COMMENT": 3,
		"3": "COMMENT",
		"SIMPLE_EXPRESSION": 4,
		"4": "SIMPLE_EXPRESSION",
		"INTERPOLATION": 5,
		"5": "INTERPOLATION",
		"ATTRIBUTE": 6,
		"6": "ATTRIBUTE",
		"DIRECTIVE": 7,
		"7": "DIRECTIVE",
		"COMPOUND_EXPRESSION": 8,
		"8": "COMPOUND_EXPRESSION",
		"IF": 9,
		"9": "IF",
		"IF_BRANCH": 10,
		"10": "IF_BRANCH",
		"FOR": 11,
		"11": "FOR",
		"TEXT_CALL": 12,
		"12": "TEXT_CALL",
		"VNODE_CALL": 13,
		"13": "VNODE_CALL",
		"JS_CALL_EXPRESSION": 14,
		"14": "JS_CALL_EXPRESSION",
		"JS_OBJECT_EXPRESSION": 15,
		"15": "JS_OBJECT_EXPRESSION",
		"JS_PROPERTY": 16,
		"16": "JS_PROPERTY",
		"JS_ARRAY_EXPRESSION": 17,
		"17": "JS_ARRAY_EXPRESSION",
		"JS_FUNCTION_EXPRESSION": 18,
		"18": "JS_FUNCTION_EXPRESSION",
		"JS_CONDITIONAL_EXPRESSION": 19,
		"19": "JS_CONDITIONAL_EXPRESSION",
		"JS_CACHE_EXPRESSION": 20,
		"20": "JS_CACHE_EXPRESSION",
		"JS_BLOCK_STATEMENT": 21,
		"21": "JS_BLOCK_STATEMENT",
		"JS_TEMPLATE_LITERAL": 22,
		"22": "JS_TEMPLATE_LITERAL",
		"JS_IF_STATEMENT": 23,
		"23": "JS_IF_STATEMENT",
		"JS_ASSIGNMENT_EXPRESSION": 24,
		"24": "JS_ASSIGNMENT_EXPRESSION",
		"JS_SEQUENCE_EXPRESSION": 25,
		"25": "JS_SEQUENCE_EXPRESSION",
		"JS_RETURN_STATEMENT": 26,
		"26": "JS_RETURN_STATEMENT"
	};
	const ElementTypes = {
		"ELEMENT": 0,
		"0": "ELEMENT",
		"COMPONENT": 1,
		"1": "COMPONENT",
		"SLOT": 2,
		"2": "SLOT",
		"TEMPLATE": 3,
		"3": "TEMPLATE"
	};
	const ConstantTypes = {
		"NOT_CONSTANT": 0,
		"0": "NOT_CONSTANT",
		"CAN_SKIP_PATCH": 1,
		"1": "CAN_SKIP_PATCH",
		"CAN_CACHE": 2,
		"2": "CAN_CACHE",
		"CAN_STRINGIFY": 3,
		"3": "CAN_STRINGIFY"
	};
	const locStub = {
		start: {
			line: 1,
			column: 1,
			offset: 0
		},
		end: {
			line: 1,
			column: 1,
			offset: 0
		},
		source: ""
	};
	function createRoot(children, source = "") {
		return {
			type: 0,
			source,
			children,
			helpers: /* @__PURE__ */ new Set(),
			components: [],
			directives: [],
			hoists: [],
			imports: [],
			cached: [],
			temps: 0,
			codegenNode: void 0,
			loc: locStub
		};
	}
	function createVNodeCall(context, tag, props, children, patchFlag, dynamicProps, directives$1, isBlock = false, disableTracking = false, isComponent$1 = false, loc = locStub) {
		if (context) {
			if (isBlock) {
				context.helper(OPEN_BLOCK);
				context.helper(getVNodeBlockHelper(context.inSSR, isComponent$1));
			} else context.helper(getVNodeHelper(context.inSSR, isComponent$1));
			if (directives$1) context.helper(WITH_DIRECTIVES);
		}
		return {
			type: 13,
			tag,
			props,
			children,
			patchFlag,
			dynamicProps,
			directives: directives$1,
			isBlock,
			disableTracking,
			isComponent: isComponent$1,
			loc
		};
	}
	function createArrayExpression(elements, loc = locStub) {
		return {
			type: 17,
			loc,
			elements
		};
	}
	function createObjectExpression(properties, loc = locStub) {
		return {
			type: 15,
			loc,
			properties
		};
	}
	function createObjectProperty(key, value) {
		return {
			type: 16,
			loc: locStub,
			key: shared$1.isString(key) ? createSimpleExpression(key, true) : key,
			value
		};
	}
	function createSimpleExpression(content, isStatic$1 = false, loc = locStub, constType = 0) {
		return {
			type: 4,
			loc,
			content,
			isStatic: isStatic$1,
			constType: isStatic$1 ? 3 : constType
		};
	}
	function createInterpolation(content, loc) {
		return {
			type: 5,
			loc,
			content: shared$1.isString(content) ? createSimpleExpression(content, false, loc) : content
		};
	}
	function createCompoundExpression(children, loc = locStub) {
		return {
			type: 8,
			loc,
			children
		};
	}
	function createCallExpression(callee, args = [], loc = locStub) {
		return {
			type: 14,
			loc,
			callee,
			arguments: args
		};
	}
	function createFunctionExpression(params, returns = void 0, newline = false, isSlot = false, loc = locStub) {
		return {
			type: 18,
			params,
			returns,
			newline,
			isSlot,
			loc
		};
	}
	function createConditionalExpression(test, consequent, alternate, newline = true) {
		return {
			type: 19,
			test,
			consequent,
			alternate,
			newline,
			loc: locStub
		};
	}
	function createCacheExpression(index$1, value, needPauseTracking = false, inVOnce = false) {
		return {
			type: 20,
			index: index$1,
			value,
			needPauseTracking,
			inVOnce,
			needArraySpread: false,
			loc: locStub
		};
	}
	function createBlockStatement(body) {
		return {
			type: 21,
			body,
			loc: locStub
		};
	}
	function createTemplateLiteral(elements) {
		return {
			type: 22,
			elements,
			loc: locStub
		};
	}
	function createIfStatement(test, consequent, alternate) {
		return {
			type: 23,
			test,
			consequent,
			alternate,
			loc: locStub
		};
	}
	function createAssignmentExpression(left, right) {
		return {
			type: 24,
			left,
			right,
			loc: locStub
		};
	}
	function createSequenceExpression(expressions) {
		return {
			type: 25,
			expressions,
			loc: locStub
		};
	}
	function createReturnStatement(returns) {
		return {
			type: 26,
			returns,
			loc: locStub
		};
	}
	function getVNodeHelper(ssr, isComponent$1) {
		return ssr || isComponent$1 ? CREATE_VNODE : CREATE_ELEMENT_VNODE;
	}
	function getVNodeBlockHelper(ssr, isComponent$1) {
		return ssr || isComponent$1 ? CREATE_BLOCK : CREATE_ELEMENT_BLOCK;
	}
	function convertToBlock(node, { helper, removeHelper, inSSR }) {
		if (!node.isBlock) {
			node.isBlock = true;
			removeHelper(getVNodeHelper(inSSR, node.isComponent));
			helper(OPEN_BLOCK);
			helper(getVNodeBlockHelper(inSSR, node.isComponent));
		}
	}
	const defaultDelimitersOpen = new Uint8Array([123, 123]);
	const defaultDelimitersClose = new Uint8Array([125, 125]);
	function isTagStartChar(c) {
		return c >= 97 && c <= 122 || c >= 65 && c <= 90;
	}
	function isWhitespace$1(c) {
		return c === 32 || c === 10 || c === 9 || c === 12 || c === 13;
	}
	function isEndOfTagSection(c) {
		return c === 47 || c === 62 || isWhitespace$1(c);
	}
	function toCharCodes(str$1) {
		const ret = new Uint8Array(str$1.length);
		for (let i = 0; i < str$1.length; i++) ret[i] = str$1.charCodeAt(i);
		return ret;
	}
	const Sequences = {
		Cdata: new Uint8Array([
			67,
			68,
			65,
			84,
			65,
			91
		]),
		CdataEnd: new Uint8Array([
			93,
			93,
			62
		]),
		CommentEnd: new Uint8Array([
			45,
			45,
			62
		]),
		ScriptEnd: new Uint8Array([
			60,
			47,
			115,
			99,
			114,
			105,
			112,
			116
		]),
		StyleEnd: new Uint8Array([
			60,
			47,
			115,
			116,
			121,
			108,
			101
		]),
		TitleEnd: new Uint8Array([
			60,
			47,
			116,
			105,
			116,
			108,
			101
		]),
		TextareaEnd: new Uint8Array([
			60,
			47,
			116,
			101,
			120,
			116,
			97,
			114,
			101,
			97
		])
	};
	var Tokenizer = class {
		constructor(stack$1, cbs) {
			this.stack = stack$1;
			this.cbs = cbs;
			/** The current state the tokenizer is in. */
			this.state = 1;
			/** The read buffer. */
			this.buffer = "";
			/** The beginning of the section that is currently being read. */
			this.sectionStart = 0;
			/** The index within the buffer that we are currently looking at. */
			this.index = 0;
			/** The start of the last entity. */
			this.entityStart = 0;
			/** Some behavior, eg. when decoding entities, is done while we are in another state. This keeps track of the other state type. */
			this.baseState = 1;
			/** For special parsing behavior inside of script and style tags. */
			this.inRCDATA = false;
			/** For disabling RCDATA tags handling */
			this.inXML = false;
			/** For disabling interpolation parsing in v-pre */
			this.inVPre = false;
			/** Record newline positions for fast line / column calculation */
			this.newlines = [];
			this.mode = 0;
			this.delimiterOpen = defaultDelimitersOpen;
			this.delimiterClose = defaultDelimitersClose;
			this.delimiterIndex = -1;
			this.currentSequence = void 0;
			this.sequenceIndex = 0;
			this.entityDecoder = new decode_js.EntityDecoder(decode_js.htmlDecodeTree, (cp, consumed) => this.emitCodePoint(cp, consumed));
		}
		get inSFCRoot() {
			return this.mode === 2 && this.stack.length === 0;
		}
		reset() {
			this.state = 1;
			this.mode = 0;
			this.buffer = "";
			this.sectionStart = 0;
			this.index = 0;
			this.baseState = 1;
			this.inRCDATA = false;
			this.currentSequence = void 0;
			this.newlines.length = 0;
			this.delimiterOpen = defaultDelimitersOpen;
			this.delimiterClose = defaultDelimitersClose;
		}
		/**
		* Generate Position object with line / column information using recorded
		* newline positions. We know the index is always going to be an already
		* processed index, so all the newlines up to this index should have been
		* recorded.
		*/
		getPos(index$1) {
			let line = 1;
			let column = index$1 + 1;
			for (let i = this.newlines.length - 1; i >= 0; i--) {
				const newlineIndex = this.newlines[i];
				if (index$1 > newlineIndex) {
					line = i + 2;
					column = index$1 - newlineIndex;
					break;
				}
			}
			return {
				column,
				line,
				offset: index$1
			};
		}
		peek() {
			return this.buffer.charCodeAt(this.index + 1);
		}
		stateText(c) {
			if (c === 60) {
				if (this.index > this.sectionStart) this.cbs.ontext(this.sectionStart, this.index);
				this.state = 5;
				this.sectionStart = this.index;
			} else if (c === 38) this.startEntity();
			else if (!this.inVPre && c === this.delimiterOpen[0]) {
				this.state = 2;
				this.delimiterIndex = 0;
				this.stateInterpolationOpen(c);
			}
		}
		stateInterpolationOpen(c) {
			if (c === this.delimiterOpen[this.delimiterIndex]) if (this.delimiterIndex === this.delimiterOpen.length - 1) {
				const start = this.index + 1 - this.delimiterOpen.length;
				if (start > this.sectionStart) this.cbs.ontext(this.sectionStart, start);
				this.state = 3;
				this.sectionStart = start;
			} else this.delimiterIndex++;
			else if (this.inRCDATA) {
				this.state = 32;
				this.stateInRCDATA(c);
			} else {
				this.state = 1;
				this.stateText(c);
			}
		}
		stateInterpolation(c) {
			if (c === this.delimiterClose[0]) {
				this.state = 4;
				this.delimiterIndex = 0;
				this.stateInterpolationClose(c);
			}
		}
		stateInterpolationClose(c) {
			if (c === this.delimiterClose[this.delimiterIndex]) if (this.delimiterIndex === this.delimiterClose.length - 1) {
				this.cbs.oninterpolation(this.sectionStart, this.index + 1);
				if (this.inRCDATA) this.state = 32;
				else this.state = 1;
				this.sectionStart = this.index + 1;
			} else this.delimiterIndex++;
			else {
				this.state = 3;
				this.stateInterpolation(c);
			}
		}
		stateSpecialStartSequence(c) {
			const isEnd = this.sequenceIndex === this.currentSequence.length;
			const isMatch = isEnd ? isEndOfTagSection(c) : (c | 32) === this.currentSequence[this.sequenceIndex];
			if (!isMatch) this.inRCDATA = false;
			else if (!isEnd) {
				this.sequenceIndex++;
				return;
			}
			this.sequenceIndex = 0;
			this.state = 6;
			this.stateInTagName(c);
		}
		/** Look for an end tag. For <title> and <textarea>, also decode entities. */
		stateInRCDATA(c) {
			if (this.sequenceIndex === this.currentSequence.length) {
				if (c === 62 || isWhitespace$1(c)) {
					const endOfText = this.index - this.currentSequence.length;
					if (this.sectionStart < endOfText) {
						const actualIndex = this.index;
						this.index = endOfText;
						this.cbs.ontext(this.sectionStart, endOfText);
						this.index = actualIndex;
					}
					this.sectionStart = endOfText + 2;
					this.stateInClosingTagName(c);
					this.inRCDATA = false;
					return;
				}
				this.sequenceIndex = 0;
			}
			if ((c | 32) === this.currentSequence[this.sequenceIndex]) this.sequenceIndex += 1;
			else if (this.sequenceIndex === 0) {
				if (this.currentSequence === Sequences.TitleEnd || this.currentSequence === Sequences.TextareaEnd && !this.inSFCRoot) {
					if (c === 38) this.startEntity();
					else if (!this.inVPre && c === this.delimiterOpen[0]) {
						this.state = 2;
						this.delimiterIndex = 0;
						this.stateInterpolationOpen(c);
					}
				} else if (this.fastForwardTo(60)) this.sequenceIndex = 1;
			} else this.sequenceIndex = Number(c === 60);
		}
		stateCDATASequence(c) {
			if (c === Sequences.Cdata[this.sequenceIndex]) {
				if (++this.sequenceIndex === Sequences.Cdata.length) {
					this.state = 28;
					this.currentSequence = Sequences.CdataEnd;
					this.sequenceIndex = 0;
					this.sectionStart = this.index + 1;
				}
			} else {
				this.sequenceIndex = 0;
				this.state = 23;
				this.stateInDeclaration(c);
			}
		}
		/**
		* When we wait for one specific character, we can speed things up
		* by skipping through the buffer until we find it.
		*
		* @returns Whether the character was found.
		*/
		fastForwardTo(c) {
			while (++this.index < this.buffer.length) {
				const cc = this.buffer.charCodeAt(this.index);
				if (cc === 10) this.newlines.push(this.index);
				if (cc === c) return true;
			}
			this.index = this.buffer.length - 1;
			return false;
		}
		/**
		* Comments and CDATA end with `-->` and `]]>`.
		*
		* Their common qualities are:
		* - Their end sequences have a distinct character they start with.
		* - That character is then repeated, so we have to check multiple repeats.
		* - All characters but the start character of the sequence can be skipped.
		*/
		stateInCommentLike(c) {
			if (c === this.currentSequence[this.sequenceIndex]) {
				if (++this.sequenceIndex === this.currentSequence.length) {
					if (this.currentSequence === Sequences.CdataEnd) this.cbs.oncdata(this.sectionStart, this.index - 2);
					else this.cbs.oncomment(this.sectionStart, this.index - 2);
					this.sequenceIndex = 0;
					this.sectionStart = this.index + 1;
					this.state = 1;
				}
			} else if (this.sequenceIndex === 0) {
				if (this.fastForwardTo(this.currentSequence[0])) this.sequenceIndex = 1;
			} else if (c !== this.currentSequence[this.sequenceIndex - 1]) this.sequenceIndex = 0;
		}
		startSpecial(sequence, offset) {
			this.enterRCDATA(sequence, offset);
			this.state = 31;
		}
		enterRCDATA(sequence, offset) {
			this.inRCDATA = true;
			this.currentSequence = sequence;
			this.sequenceIndex = offset;
		}
		stateBeforeTagName(c) {
			if (c === 33) {
				this.state = 22;
				this.sectionStart = this.index + 1;
			} else if (c === 63) {
				this.state = 24;
				this.sectionStart = this.index + 1;
			} else if (isTagStartChar(c)) {
				this.sectionStart = this.index;
				if (this.mode === 0) this.state = 6;
				else if (this.inSFCRoot) this.state = 34;
				else if (!this.inXML) if (c === 116) this.state = 30;
				else this.state = c === 115 ? 29 : 6;
				else this.state = 6;
			} else if (c === 47) this.state = 8;
			else {
				this.state = 1;
				this.stateText(c);
			}
		}
		stateInTagName(c) {
			if (isEndOfTagSection(c)) this.handleTagName(c);
		}
		stateInSFCRootTagName(c) {
			if (isEndOfTagSection(c)) {
				const tag = this.buffer.slice(this.sectionStart, this.index);
				if (tag !== "template") this.enterRCDATA(toCharCodes(`</` + tag), 0);
				this.handleTagName(c);
			}
		}
		handleTagName(c) {
			this.cbs.onopentagname(this.sectionStart, this.index);
			this.sectionStart = -1;
			this.state = 11;
			this.stateBeforeAttrName(c);
		}
		stateBeforeClosingTagName(c) {
			if (isWhitespace$1(c));
			else if (c === 62) {
				this.cbs.onerr(14, this.index);
				this.state = 1;
				this.sectionStart = this.index + 1;
			} else {
				this.state = isTagStartChar(c) ? 9 : 27;
				this.sectionStart = this.index;
			}
		}
		stateInClosingTagName(c) {
			if (c === 62 || isWhitespace$1(c)) {
				this.cbs.onclosetag(this.sectionStart, this.index);
				this.sectionStart = -1;
				this.state = 10;
				this.stateAfterClosingTagName(c);
			}
		}
		stateAfterClosingTagName(c) {
			if (c === 62) {
				this.state = 1;
				this.sectionStart = this.index + 1;
			}
		}
		stateBeforeAttrName(c) {
			if (c === 62) {
				this.cbs.onopentagend(this.index);
				if (this.inRCDATA) this.state = 32;
				else this.state = 1;
				this.sectionStart = this.index + 1;
			} else if (c === 47) {
				this.state = 7;
				if (this.peek() !== 62) this.cbs.onerr(22, this.index);
			} else if (c === 60 && this.peek() === 47) {
				this.cbs.onopentagend(this.index);
				this.state = 5;
				this.sectionStart = this.index;
			} else if (!isWhitespace$1(c)) {
				if (c === 61) this.cbs.onerr(19, this.index);
				this.handleAttrStart(c);
			}
		}
		handleAttrStart(c) {
			if (c === 118 && this.peek() === 45) {
				this.state = 13;
				this.sectionStart = this.index;
			} else if (c === 46 || c === 58 || c === 64 || c === 35) {
				this.cbs.ondirname(this.index, this.index + 1);
				this.state = 14;
				this.sectionStart = this.index + 1;
			} else {
				this.state = 12;
				this.sectionStart = this.index;
			}
		}
		stateInSelfClosingTag(c) {
			if (c === 62) {
				this.cbs.onselfclosingtag(this.index);
				this.state = 1;
				this.sectionStart = this.index + 1;
				this.inRCDATA = false;
			} else if (!isWhitespace$1(c)) {
				this.state = 11;
				this.stateBeforeAttrName(c);
			}
		}
		stateInAttrName(c) {
			if (c === 61 || isEndOfTagSection(c)) {
				this.cbs.onattribname(this.sectionStart, this.index);
				this.handleAttrNameEnd(c);
			} else if (c === 34 || c === 39 || c === 60) this.cbs.onerr(17, this.index);
		}
		stateInDirName(c) {
			if (c === 61 || isEndOfTagSection(c)) {
				this.cbs.ondirname(this.sectionStart, this.index);
				this.handleAttrNameEnd(c);
			} else if (c === 58) {
				this.cbs.ondirname(this.sectionStart, this.index);
				this.state = 14;
				this.sectionStart = this.index + 1;
			} else if (c === 46) {
				this.cbs.ondirname(this.sectionStart, this.index);
				this.state = 16;
				this.sectionStart = this.index + 1;
			}
		}
		stateInDirArg(c) {
			if (c === 61 || isEndOfTagSection(c)) {
				this.cbs.ondirarg(this.sectionStart, this.index);
				this.handleAttrNameEnd(c);
			} else if (c === 91) this.state = 15;
			else if (c === 46) {
				this.cbs.ondirarg(this.sectionStart, this.index);
				this.state = 16;
				this.sectionStart = this.index + 1;
			}
		}
		stateInDynamicDirArg(c) {
			if (c === 93) this.state = 14;
			else if (c === 61 || isEndOfTagSection(c)) {
				this.cbs.ondirarg(this.sectionStart, this.index + 1);
				this.handleAttrNameEnd(c);
				this.cbs.onerr(27, this.index);
			}
		}
		stateInDirModifier(c) {
			if (c === 61 || isEndOfTagSection(c)) {
				this.cbs.ondirmodifier(this.sectionStart, this.index);
				this.handleAttrNameEnd(c);
			} else if (c === 46) {
				this.cbs.ondirmodifier(this.sectionStart, this.index);
				this.sectionStart = this.index + 1;
			}
		}
		handleAttrNameEnd(c) {
			this.sectionStart = this.index;
			this.state = 17;
			this.cbs.onattribnameend(this.index);
			this.stateAfterAttrName(c);
		}
		stateAfterAttrName(c) {
			if (c === 61) this.state = 18;
			else if (c === 47 || c === 62) {
				this.cbs.onattribend(0, this.sectionStart);
				this.sectionStart = -1;
				this.state = 11;
				this.stateBeforeAttrName(c);
			} else if (!isWhitespace$1(c)) {
				this.cbs.onattribend(0, this.sectionStart);
				this.handleAttrStart(c);
			}
		}
		stateBeforeAttrValue(c) {
			if (c === 34) {
				this.state = 19;
				this.sectionStart = this.index + 1;
			} else if (c === 39) {
				this.state = 20;
				this.sectionStart = this.index + 1;
			} else if (!isWhitespace$1(c)) {
				this.sectionStart = this.index;
				this.state = 21;
				this.stateInAttrValueNoQuotes(c);
			}
		}
		handleInAttrValue(c, quote) {
			if (c === quote || false) {
				this.cbs.onattribdata(this.sectionStart, this.index);
				this.sectionStart = -1;
				this.cbs.onattribend(quote === 34 ? 3 : 2, this.index + 1);
				this.state = 11;
			} else if (c === 38) this.startEntity();
		}
		stateInAttrValueDoubleQuotes(c) {
			this.handleInAttrValue(c, 34);
		}
		stateInAttrValueSingleQuotes(c) {
			this.handleInAttrValue(c, 39);
		}
		stateInAttrValueNoQuotes(c) {
			if (isWhitespace$1(c) || c === 62) {
				this.cbs.onattribdata(this.sectionStart, this.index);
				this.sectionStart = -1;
				this.cbs.onattribend(1, this.index);
				this.state = 11;
				this.stateBeforeAttrName(c);
			} else if (c === 34 || c === 39 || c === 60 || c === 61 || c === 96) this.cbs.onerr(18, this.index);
			else if (c === 38) this.startEntity();
		}
		stateBeforeDeclaration(c) {
			if (c === 91) {
				this.state = 26;
				this.sequenceIndex = 0;
			} else this.state = c === 45 ? 25 : 23;
		}
		stateInDeclaration(c) {
			if (c === 62 || this.fastForwardTo(62)) {
				this.state = 1;
				this.sectionStart = this.index + 1;
			}
		}
		stateInProcessingInstruction(c) {
			if (c === 62 || this.fastForwardTo(62)) {
				this.cbs.onprocessinginstruction(this.sectionStart, this.index);
				this.state = 1;
				this.sectionStart = this.index + 1;
			}
		}
		stateBeforeComment(c) {
			if (c === 45) {
				this.state = 28;
				this.currentSequence = Sequences.CommentEnd;
				this.sequenceIndex = 2;
				this.sectionStart = this.index + 1;
			} else this.state = 23;
		}
		stateInSpecialComment(c) {
			if (c === 62 || this.fastForwardTo(62)) {
				this.cbs.oncomment(this.sectionStart, this.index);
				this.state = 1;
				this.sectionStart = this.index + 1;
			}
		}
		stateBeforeSpecialS(c) {
			if (c === Sequences.ScriptEnd[3]) this.startSpecial(Sequences.ScriptEnd, 4);
			else if (c === Sequences.StyleEnd[3]) this.startSpecial(Sequences.StyleEnd, 4);
			else {
				this.state = 6;
				this.stateInTagName(c);
			}
		}
		stateBeforeSpecialT(c) {
			if (c === Sequences.TitleEnd[3]) this.startSpecial(Sequences.TitleEnd, 4);
			else if (c === Sequences.TextareaEnd[3]) this.startSpecial(Sequences.TextareaEnd, 4);
			else {
				this.state = 6;
				this.stateInTagName(c);
			}
		}
		startEntity() {
			{
				this.baseState = this.state;
				this.state = 33;
				this.entityStart = this.index;
				this.entityDecoder.startEntity(this.baseState === 1 || this.baseState === 32 ? decode_js.DecodingMode.Legacy : decode_js.DecodingMode.Attribute);
			}
		}
		stateInEntity() {
			{
				const length = this.entityDecoder.write(this.buffer, this.index);
				if (length >= 0) {
					this.state = this.baseState;
					if (length === 0) this.index = this.entityStart;
				} else this.index = this.buffer.length - 1;
			}
		}
		/**
		* Iterates through the buffer, calling the function corresponding to the current state.
		*
		* States that are more likely to be hit are higher up, as a performance improvement.
		*/
		parse(input) {
			this.buffer = input;
			while (this.index < this.buffer.length) {
				const c = this.buffer.charCodeAt(this.index);
				if (c === 10 && this.state !== 33) this.newlines.push(this.index);
				switch (this.state) {
					case 1: {
						this.stateText(c);
						break;
					}
					case 2: {
						this.stateInterpolationOpen(c);
						break;
					}
					case 3: {
						this.stateInterpolation(c);
						break;
					}
					case 4: {
						this.stateInterpolationClose(c);
						break;
					}
					case 31: {
						this.stateSpecialStartSequence(c);
						break;
					}
					case 32: {
						this.stateInRCDATA(c);
						break;
					}
					case 26: {
						this.stateCDATASequence(c);
						break;
					}
					case 19: {
						this.stateInAttrValueDoubleQuotes(c);
						break;
					}
					case 12: {
						this.stateInAttrName(c);
						break;
					}
					case 13: {
						this.stateInDirName(c);
						break;
					}
					case 14: {
						this.stateInDirArg(c);
						break;
					}
					case 15: {
						this.stateInDynamicDirArg(c);
						break;
					}
					case 16: {
						this.stateInDirModifier(c);
						break;
					}
					case 28: {
						this.stateInCommentLike(c);
						break;
					}
					case 27: {
						this.stateInSpecialComment(c);
						break;
					}
					case 11: {
						this.stateBeforeAttrName(c);
						break;
					}
					case 6: {
						this.stateInTagName(c);
						break;
					}
					case 34: {
						this.stateInSFCRootTagName(c);
						break;
					}
					case 9: {
						this.stateInClosingTagName(c);
						break;
					}
					case 5: {
						this.stateBeforeTagName(c);
						break;
					}
					case 17: {
						this.stateAfterAttrName(c);
						break;
					}
					case 20: {
						this.stateInAttrValueSingleQuotes(c);
						break;
					}
					case 18: {
						this.stateBeforeAttrValue(c);
						break;
					}
					case 8: {
						this.stateBeforeClosingTagName(c);
						break;
					}
					case 10: {
						this.stateAfterClosingTagName(c);
						break;
					}
					case 29: {
						this.stateBeforeSpecialS(c);
						break;
					}
					case 30: {
						this.stateBeforeSpecialT(c);
						break;
					}
					case 21: {
						this.stateInAttrValueNoQuotes(c);
						break;
					}
					case 7: {
						this.stateInSelfClosingTag(c);
						break;
					}
					case 23: {
						this.stateInDeclaration(c);
						break;
					}
					case 22: {
						this.stateBeforeDeclaration(c);
						break;
					}
					case 25: {
						this.stateBeforeComment(c);
						break;
					}
					case 24: {
						this.stateInProcessingInstruction(c);
						break;
					}
					case 33: {
						this.stateInEntity();
						break;
					}
				}
				this.index++;
			}
			this.cleanup();
			this.finish();
		}
		/**
		* Remove data that has already been consumed from the buffer.
		*/
		cleanup() {
			if (this.sectionStart !== this.index) {
				if (this.state === 1 || this.state === 32 && this.sequenceIndex === 0) {
					this.cbs.ontext(this.sectionStart, this.index);
					this.sectionStart = this.index;
				} else if (this.state === 19 || this.state === 20 || this.state === 21) {
					this.cbs.onattribdata(this.sectionStart, this.index);
					this.sectionStart = this.index;
				}
			}
		}
		finish() {
			if (this.state === 33) {
				this.entityDecoder.end();
				this.state = this.baseState;
			}
			this.handleTrailingData();
			this.cbs.onend();
		}
		/** Handle any trailing data. */
		handleTrailingData() {
			const endIndex = this.buffer.length;
			if (this.sectionStart >= endIndex) return;
			if (this.state === 28) if (this.currentSequence === Sequences.CdataEnd) this.cbs.oncdata(this.sectionStart, endIndex);
			else this.cbs.oncomment(this.sectionStart, endIndex);
			else if (this.state === 6 || this.state === 11 || this.state === 18 || this.state === 17 || this.state === 12 || this.state === 13 || this.state === 14 || this.state === 15 || this.state === 16 || this.state === 20 || this.state === 19 || this.state === 21 || this.state === 9);
			else this.cbs.ontext(this.sectionStart, endIndex);
		}
		emitCodePoint(cp, consumed) {
			if (this.baseState !== 1 && this.baseState !== 32) {
				if (this.sectionStart < this.entityStart) this.cbs.onattribdata(this.sectionStart, this.entityStart);
				this.sectionStart = this.entityStart + consumed;
				this.index = this.sectionStart - 1;
				this.cbs.onattribentity(decode_js.fromCodePoint(cp), this.entityStart, this.sectionStart);
			} else {
				if (this.sectionStart < this.entityStart) this.cbs.ontext(this.sectionStart, this.entityStart);
				this.sectionStart = this.entityStart + consumed;
				this.index = this.sectionStart - 1;
				this.cbs.ontextentity(decode_js.fromCodePoint(cp), this.entityStart, this.sectionStart);
			}
		}
	};
	const CompilerDeprecationTypes = {
		"COMPILER_IS_ON_ELEMENT": "COMPILER_IS_ON_ELEMENT",
		"COMPILER_V_BIND_SYNC": "COMPILER_V_BIND_SYNC",
		"COMPILER_V_BIND_OBJECT_ORDER": "COMPILER_V_BIND_OBJECT_ORDER",
		"COMPILER_V_ON_NATIVE": "COMPILER_V_ON_NATIVE",
		"COMPILER_V_IF_V_FOR_PRECEDENCE": "COMPILER_V_IF_V_FOR_PRECEDENCE",
		"COMPILER_NATIVE_TEMPLATE": "COMPILER_NATIVE_TEMPLATE",
		"COMPILER_INLINE_TEMPLATE": "COMPILER_INLINE_TEMPLATE",
		"COMPILER_FILTERS": "COMPILER_FILTERS"
	};
	const deprecationData = {
		["COMPILER_IS_ON_ELEMENT"]: {
			message: `Platform-native elements with "is" prop will no longer be treated as components in Vue 3 unless the "is" value is explicitly prefixed with "vue:".`,
			link: `https://v3-migration.vuejs.org/breaking-changes/custom-elements-interop.html`
		},
		["COMPILER_V_BIND_SYNC"]: {
			message: (key) => `.sync modifier for v-bind has been removed. Use v-model with argument instead. \`v-bind:${key}.sync\` should be changed to \`v-model:${key}\`.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/v-model.html`
		},
		["COMPILER_V_BIND_OBJECT_ORDER"]: {
			message: `v-bind="obj" usage is now order sensitive and behaves like JavaScript object spread: it will now overwrite an existing non-mergeable attribute that appears before v-bind in the case of conflict. To retain 2.x behavior, move v-bind to make it the first attribute. You can also suppress this warning if the usage is intended.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/v-bind.html`
		},
		["COMPILER_V_ON_NATIVE"]: {
			message: `.native modifier for v-on has been removed as is no longer necessary.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/v-on-native-modifier-removed.html`
		},
		["COMPILER_V_IF_V_FOR_PRECEDENCE"]: {
			message: `v-if / v-for precedence when used on the same element has changed in Vue 3: v-if now takes higher precedence and will no longer have access to v-for scope variables. It is best to avoid the ambiguity with <template> tags or use a computed property that filters v-for data source.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/v-if-v-for.html`
		},
		["COMPILER_NATIVE_TEMPLATE"]: { message: `<template> with no special directives will render as a native template element instead of its inner content in Vue 3.` },
		["COMPILER_INLINE_TEMPLATE"]: {
			message: `"inline-template" has been removed in Vue 3.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/inline-template-attribute.html`
		},
		["COMPILER_FILTERS"]: {
			message: `filters have been removed in Vue 3. The "|" symbol will be treated as native JavaScript bitwise OR operator. Use method calls or computed properties instead.`,
			link: `https://v3-migration.vuejs.org/breaking-changes/filters.html`
		}
	};
	function getCompatValue(key, { compatConfig }) {
		const value = compatConfig && compatConfig[key];
		if (key === "MODE") return value || 3;
		else return value;
	}
	function isCompatEnabled(key, context) {
		const mode = getCompatValue("MODE", context);
		const value = getCompatValue(key, context);
		return mode === 3 ? value === true : value !== false;
	}
	function checkCompatEnabled(key, context, loc, ...args) {
		const enabled = isCompatEnabled(key, context);
		return enabled;
	}
	function warnDeprecation(key, context, loc, ...args) {
		const val = getCompatValue(key, context);
		if (val === "suppress-warning") return;
		const { message, link: link$1 } = deprecationData[key];
		const msg = `(deprecation ${key}) ${typeof message === "function" ? message(...args) : message}${link$1 ? `
  Details: ${link$1}` : ``}`;
		const err = new SyntaxError(msg);
		err.code = key;
		if (loc) err.loc = loc;
		context.onWarn(err);
	}
	function defaultOnError(error) {
		throw error;
	}
	function defaultOnWarn(msg) {}
	function createCompilerError(code$1, loc, messages, additionalMessage) {
		const msg = (messages || errorMessages)[code$1] + (additionalMessage || ``);
		const error = new SyntaxError(String(msg));
		error.code = code$1;
		error.loc = loc;
		return error;
	}
	const ErrorCodes = {
		"ABRUPT_CLOSING_OF_EMPTY_COMMENT": 0,
		"0": "ABRUPT_CLOSING_OF_EMPTY_COMMENT",
		"CDATA_IN_HTML_CONTENT": 1,
		"1": "CDATA_IN_HTML_CONTENT",
		"DUPLICATE_ATTRIBUTE": 2,
		"2": "DUPLICATE_ATTRIBUTE",
		"END_TAG_WITH_ATTRIBUTES": 3,
		"3": "END_TAG_WITH_ATTRIBUTES",
		"END_TAG_WITH_TRAILING_SOLIDUS": 4,
		"4": "END_TAG_WITH_TRAILING_SOLIDUS",
		"EOF_BEFORE_TAG_NAME": 5,
		"5": "EOF_BEFORE_TAG_NAME",
		"EOF_IN_CDATA": 6,
		"6": "EOF_IN_CDATA",
		"EOF_IN_COMMENT": 7,
		"7": "EOF_IN_COMMENT",
		"EOF_IN_SCRIPT_HTML_COMMENT_LIKE_TEXT": 8,
		"8": "EOF_IN_SCRIPT_HTML_COMMENT_LIKE_TEXT",
		"EOF_IN_TAG": 9,
		"9": "EOF_IN_TAG",
		"INCORRECTLY_CLOSED_COMMENT": 10,
		"10": "INCORRECTLY_CLOSED_COMMENT",
		"INCORRECTLY_OPENED_COMMENT": 11,
		"11": "INCORRECTLY_OPENED_COMMENT",
		"INVALID_FIRST_CHARACTER_OF_TAG_NAME": 12,
		"12": "INVALID_FIRST_CHARACTER_OF_TAG_NAME",
		"MISSING_ATTRIBUTE_VALUE": 13,
		"13": "MISSING_ATTRIBUTE_VALUE",
		"MISSING_END_TAG_NAME": 14,
		"14": "MISSING_END_TAG_NAME",
		"MISSING_WHITESPACE_BETWEEN_ATTRIBUTES": 15,
		"15": "MISSING_WHITESPACE_BETWEEN_ATTRIBUTES",
		"NESTED_COMMENT": 16,
		"16": "NESTED_COMMENT",
		"UNEXPECTED_CHARACTER_IN_ATTRIBUTE_NAME": 17,
		"17": "UNEXPECTED_CHARACTER_IN_ATTRIBUTE_NAME",
		"UNEXPECTED_CHARACTER_IN_UNQUOTED_ATTRIBUTE_VALUE": 18,
		"18": "UNEXPECTED_CHARACTER_IN_UNQUOTED_ATTRIBUTE_VALUE",
		"UNEXPECTED_EQUALS_SIGN_BEFORE_ATTRIBUTE_NAME": 19,
		"19": "UNEXPECTED_EQUALS_SIGN_BEFORE_ATTRIBUTE_NAME",
		"UNEXPECTED_NULL_CHARACTER": 20,
		"20": "UNEXPECTED_NULL_CHARACTER",
		"UNEXPECTED_QUESTION_MARK_INSTEAD_OF_TAG_NAME": 21,
		"21": "UNEXPECTED_QUESTION_MARK_INSTEAD_OF_TAG_NAME",
		"UNEXPECTED_SOLIDUS_IN_TAG": 22,
		"22": "UNEXPECTED_SOLIDUS_IN_TAG",
		"X_INVALID_END_TAG": 23,
		"23": "X_INVALID_END_TAG",
		"X_MISSING_END_TAG": 24,
		"24": "X_MISSING_END_TAG",
		"X_MISSING_INTERPOLATION_END": 25,
		"25": "X_MISSING_INTERPOLATION_END",
		"X_MISSING_DIRECTIVE_NAME": 26,
		"26": "X_MISSING_DIRECTIVE_NAME",
		"X_MISSING_DYNAMIC_DIRECTIVE_ARGUMENT_END": 27,
		"27": "X_MISSING_DYNAMIC_DIRECTIVE_ARGUMENT_END",
		"X_V_IF_NO_EXPRESSION": 28,
		"28": "X_V_IF_NO_EXPRESSION",
		"X_V_IF_SAME_KEY": 29,
		"29": "X_V_IF_SAME_KEY",
		"X_V_ELSE_NO_ADJACENT_IF": 30,
		"30": "X_V_ELSE_NO_ADJACENT_IF",
		"X_V_FOR_NO_EXPRESSION": 31,
		"31": "X_V_FOR_NO_EXPRESSION",
		"X_V_FOR_MALFORMED_EXPRESSION": 32,
		"32": "X_V_FOR_MALFORMED_EXPRESSION",
		"X_V_FOR_TEMPLATE_KEY_PLACEMENT": 33,
		"33": "X_V_FOR_TEMPLATE_KEY_PLACEMENT",
		"X_V_BIND_NO_EXPRESSION": 34,
		"34": "X_V_BIND_NO_EXPRESSION",
		"X_V_ON_NO_EXPRESSION": 35,
		"35": "X_V_ON_NO_EXPRESSION",
		"X_V_SLOT_UNEXPECTED_DIRECTIVE_ON_SLOT_OUTLET": 36,
		"36": "X_V_SLOT_UNEXPECTED_DIRECTIVE_ON_SLOT_OUTLET",
		"X_V_SLOT_MIXED_SLOT_USAGE": 37,
		"37": "X_V_SLOT_MIXED_SLOT_USAGE",
		"X_V_SLOT_DUPLICATE_SLOT_NAMES": 38,
		"38": "X_V_SLOT_DUPLICATE_SLOT_NAMES",
		"X_V_SLOT_EXTRANEOUS_DEFAULT_SLOT_CHILDREN": 39,
		"39": "X_V_SLOT_EXTRANEOUS_DEFAULT_SLOT_CHILDREN",
		"X_V_SLOT_MISPLACED": 40,
		"40": "X_V_SLOT_MISPLACED",
		"X_V_MODEL_NO_EXPRESSION": 41,
		"41": "X_V_MODEL_NO_EXPRESSION",
		"X_V_MODEL_MALFORMED_EXPRESSION": 42,
		"42": "X_V_MODEL_MALFORMED_EXPRESSION",
		"X_V_MODEL_ON_SCOPE_VARIABLE": 43,
		"43": "X_V_MODEL_ON_SCOPE_VARIABLE",
		"X_V_MODEL_ON_PROPS": 44,
		"44": "X_V_MODEL_ON_PROPS",
		"X_INVALID_EXPRESSION": 45,
		"45": "X_INVALID_EXPRESSION",
		"X_KEEP_ALIVE_INVALID_CHILDREN": 46,
		"46": "X_KEEP_ALIVE_INVALID_CHILDREN",
		"X_PREFIX_ID_NOT_SUPPORTED": 47,
		"47": "X_PREFIX_ID_NOT_SUPPORTED",
		"X_MODULE_MODE_NOT_SUPPORTED": 48,
		"48": "X_MODULE_MODE_NOT_SUPPORTED",
		"X_CACHE_HANDLER_NOT_SUPPORTED": 49,
		"49": "X_CACHE_HANDLER_NOT_SUPPORTED",
		"X_SCOPE_ID_NOT_SUPPORTED": 50,
		"50": "X_SCOPE_ID_NOT_SUPPORTED",
		"X_VNODE_HOOKS": 51,
		"51": "X_VNODE_HOOKS",
		"X_V_BIND_INVALID_SAME_NAME_ARGUMENT": 52,
		"52": "X_V_BIND_INVALID_SAME_NAME_ARGUMENT",
		"__EXTEND_POINT__": 53,
		"53": "__EXTEND_POINT__"
	};
	const errorMessages = {
		[0]: "Illegal comment.",
		[1]: "CDATA section is allowed only in XML context.",
		[2]: "Duplicate attribute.",
		[3]: "End tag cannot have attributes.",
		[4]: "Illegal '/' in tags.",
		[5]: "Unexpected EOF in tag.",
		[6]: "Unexpected EOF in CDATA section.",
		[7]: "Unexpected EOF in comment.",
		[8]: "Unexpected EOF in script.",
		[9]: "Unexpected EOF in tag.",
		[10]: "Incorrectly closed comment.",
		[11]: "Incorrectly opened comment.",
		[12]: "Illegal tag name. Use '&lt;' to print '<'.",
		[13]: "Attribute value was expected.",
		[14]: "End tag name was expected.",
		[15]: "Whitespace was expected.",
		[16]: "Unexpected '<!--' in comment.",
		[17]: `Attribute name cannot contain U+0022 ("), U+0027 ('), and U+003C (<).`,
		[18]: "Unquoted attribute value cannot contain U+0022 (\"), U+0027 ('), U+003C (<), U+003D (=), and U+0060 (`).",
		[19]: "Attribute name cannot start with '='.",
		[21]: "'<?' is allowed only in XML context.",
		[20]: `Unexpected null character.`,
		[22]: "Illegal '/' in tags.",
		[23]: "Invalid end tag.",
		[24]: "Element is missing end tag.",
		[25]: "Interpolation end sign was not found.",
		[27]: "End bracket for dynamic directive argument was not found. Note that dynamic directive argument cannot contain spaces.",
		[26]: "Legal directive name was expected.",
		[28]: `v-if/v-else-if is missing expression.`,
		[29]: `v-if/else branches must use unique keys.`,
		[30]: `v-else/v-else-if has no adjacent v-if or v-else-if.`,
		[31]: `v-for is missing expression.`,
		[32]: `v-for has invalid expression.`,
		[33]: `<template v-for> key should be placed on the <template> tag.`,
		[34]: `v-bind is missing expression.`,
		[52]: `v-bind with same-name shorthand only allows static argument.`,
		[35]: `v-on is missing expression.`,
		[36]: `Unexpected custom directive on <slot> outlet.`,
		[37]: `Mixed v-slot usage on both the component and nested <template>. When there are multiple named slots, all slots should use <template> syntax to avoid scope ambiguity.`,
		[38]: `Duplicate slot names found. `,
		[39]: `Extraneous children found when component already has explicitly named default slot. These children will be ignored.`,
		[40]: `v-slot can only be used on components or <template> tags.`,
		[41]: `v-model is missing expression.`,
		[42]: `v-model value must be a valid JavaScript member expression.`,
		[43]: `v-model cannot be used on v-for or v-slot scope variables because they are not writable.`,
		[44]: `v-model cannot be used on a prop, because local prop bindings are not writable.
Use a v-bind binding combined with a v-on listener that emits update:x event instead.`,
		[45]: `Error parsing JavaScript expression: `,
		[46]: `<KeepAlive> expects exactly one child component.`,
		[51]: `@vnode-* hooks in templates are no longer supported. Use the vue: prefix instead. For example, @vnode-mounted should be changed to @vue:mounted. @vnode-* hooks support has been removed in 3.4.`,
		[47]: `"prefixIdentifiers" option is not supported in this build of compiler.`,
		[48]: `ES module mode is not supported in this build of compiler.`,
		[49]: `"cacheHandlers" option is only supported when the "prefixIdentifiers" option is enabled.`,
		[50]: `"scopeId" option is only supported in module mode.`,
		[53]: ``
	};
	function walkIdentifiers$1(root, onIdentifier, includeAll = false, parentStack = [], knownIds = /* @__PURE__ */ Object.create(null)) {
		const rootExp = root.type === "Program" ? root.body[0].type === "ExpressionStatement" && root.body[0].expression : root;
		estreeWalker.walk(root, {
			enter(node, parent) {
				parent && parentStack.push(parent);
				if (parent && parent.type.startsWith("TS") && !TS_NODE_TYPES.includes(parent.type)) return this.skip();
				if (node.type === "Identifier") {
					const isLocal = !!knownIds[node.name];
					const isRefed = isReferencedIdentifier(node, parent, parentStack);
					if (includeAll || isRefed && !isLocal) onIdentifier(node, parent, parentStack, isRefed, isLocal);
				} else if (node.type === "ObjectProperty" && (parent == null ? void 0 : parent.type) === "ObjectPattern") node.inPattern = true;
				else if (isFunctionType(node)) if (node.scopeIds) node.scopeIds.forEach((id) => markKnownIds(id, knownIds));
				else walkFunctionParams(node, (id) => markScopeIdentifier(node, id, knownIds));
				else if (node.type === "BlockStatement") if (node.scopeIds) node.scopeIds.forEach((id) => markKnownIds(id, knownIds));
				else walkBlockDeclarations(node, (id) => markScopeIdentifier(node, id, knownIds));
				else if (node.type === "CatchClause" && node.param) for (const id of extractIdentifiers(node.param)) markScopeIdentifier(node, id, knownIds);
				else if (isForStatement(node)) walkForStatement(node, false, (id) => markScopeIdentifier(node, id, knownIds));
			},
			leave(node, parent) {
				parent && parentStack.pop();
				if (node !== rootExp && node.scopeIds) for (const id of node.scopeIds) {
					knownIds[id]--;
					if (knownIds[id] === 0) delete knownIds[id];
				}
			}
		});
	}
	function isReferencedIdentifier(id, parent, parentStack) {
		if (!parent) return true;
		if (id.name === "arguments") return false;
		if (isReferenced(id, parent)) return true;
		switch (parent.type) {
			case "AssignmentExpression":
			case "AssignmentPattern": return true;
			case "ObjectPattern":
			case "ArrayPattern": return isInDestructureAssignment(parent, parentStack);
		}
		return false;
	}
	function isInDestructureAssignment(parent, parentStack) {
		if (parent && (parent.type === "ObjectProperty" || parent.type === "ArrayPattern")) {
			let i = parentStack.length;
			while (i--) {
				const p = parentStack[i];
				if (p.type === "AssignmentExpression") return true;
				else if (p.type !== "ObjectProperty" && !p.type.endsWith("Pattern")) break;
			}
		}
		return false;
	}
	function isInNewExpression(parentStack) {
		let i = parentStack.length;
		while (i--) {
			const p = parentStack[i];
			if (p.type === "NewExpression") return true;
			else if (p.type !== "MemberExpression") break;
		}
		return false;
	}
	function walkFunctionParams(node, onIdent) {
		for (const p of node.params) for (const id of extractIdentifiers(p)) onIdent(id);
	}
	function walkBlockDeclarations(block, onIdent) {
		for (const stmt of block.body) if (stmt.type === "VariableDeclaration") {
			if (stmt.declare) continue;
			for (const decl of stmt.declarations) for (const id of extractIdentifiers(decl.id)) onIdent(id);
		} else if (stmt.type === "FunctionDeclaration" || stmt.type === "ClassDeclaration") {
			if (stmt.declare || !stmt.id) continue;
			onIdent(stmt.id);
		} else if (isForStatement(stmt)) walkForStatement(stmt, true, onIdent);
	}
	function isForStatement(stmt) {
		return stmt.type === "ForOfStatement" || stmt.type === "ForInStatement" || stmt.type === "ForStatement";
	}
	function walkForStatement(stmt, isVar, onIdent) {
		const variable = stmt.type === "ForStatement" ? stmt.init : stmt.left;
		if (variable && variable.type === "VariableDeclaration" && (variable.kind === "var" ? isVar : !isVar)) for (const decl of variable.declarations) for (const id of extractIdentifiers(decl.id)) onIdent(id);
	}
	function extractIdentifiers(param, nodes = []) {
		switch (param.type) {
			case "Identifier":
				nodes.push(param);
				break;
			case "MemberExpression":
				let object = param;
				while (object.type === "MemberExpression") object = object.object;
				nodes.push(object);
				break;
			case "ObjectPattern":
				for (const prop of param.properties) if (prop.type === "RestElement") extractIdentifiers(prop.argument, nodes);
				else extractIdentifiers(prop.value, nodes);
				break;
			case "ArrayPattern":
				param.elements.forEach((element) => {
					if (element) extractIdentifiers(element, nodes);
				});
				break;
			case "RestElement":
				extractIdentifiers(param.argument, nodes);
				break;
			case "AssignmentPattern":
				extractIdentifiers(param.left, nodes);
				break;
		}
		return nodes;
	}
	function markKnownIds(name, knownIds) {
		if (name in knownIds) knownIds[name]++;
		else knownIds[name] = 1;
	}
	function markScopeIdentifier(node, child, knownIds) {
		const { name } = child;
		if (node.scopeIds && node.scopeIds.has(name)) return;
		markKnownIds(name, knownIds);
		(node.scopeIds || (node.scopeIds = /* @__PURE__ */ new Set())).add(name);
	}
	const isFunctionType = (node) => {
		return /Function(?:Expression|Declaration)$|Method$/.test(node.type);
	};
	const isStaticProperty = (node) => node && (node.type === "ObjectProperty" || node.type === "ObjectMethod") && !node.computed;
	const isStaticPropertyKey = (node, parent) => isStaticProperty(parent) && parent.key === node;
	function isReferenced(node, parent, grandparent) {
		switch (parent.type) {
			case "MemberExpression":
			case "OptionalMemberExpression":
				if (parent.property === node) return !!parent.computed;
				return parent.object === node;
			case "JSXMemberExpression": return parent.object === node;
			case "VariableDeclarator": return parent.init === node;
			case "ArrowFunctionExpression": return parent.body === node;
			case "PrivateName": return false;
			case "ClassMethod":
			case "ClassPrivateMethod":
			case "ObjectMethod":
				if (parent.key === node) return !!parent.computed;
				return false;
			case "ObjectProperty":
				if (parent.key === node) return !!parent.computed;
				return true;
			case "ClassProperty":
				if (parent.key === node) return !!parent.computed;
				return true;
			case "ClassPrivateProperty": return parent.key !== node;
			case "ClassDeclaration":
			case "ClassExpression": return parent.superClass === node;
			case "AssignmentExpression": return parent.right === node;
			case "AssignmentPattern": return parent.right === node;
			case "LabeledStatement": return false;
			case "CatchClause": return false;
			case "RestElement": return false;
			case "BreakStatement":
			case "ContinueStatement": return false;
			case "FunctionDeclaration":
			case "FunctionExpression": return false;
			case "ExportNamespaceSpecifier":
			case "ExportDefaultSpecifier": return false;
			case "ExportSpecifier": return parent.local === node;
			case "ImportDefaultSpecifier":
			case "ImportNamespaceSpecifier":
			case "ImportSpecifier": return false;
			case "ImportAttribute": return false;
			case "JSXAttribute": return false;
			case "ObjectPattern":
			case "ArrayPattern": return false;
			case "MetaProperty": return false;
			case "ObjectTypeProperty": return parent.key !== node;
			case "TSEnumMember": return parent.id !== node;
			case "TSPropertySignature":
				if (parent.key === node) return !!parent.computed;
				return true;
		}
		return true;
	}
	const TS_NODE_TYPES = [
		"TSAsExpression",
		"TSTypeAssertion",
		"TSNonNullExpression",
		"TSInstantiationExpression",
		"TSSatisfiesExpression"
	];
	function unwrapTSNode(node) {
		if (TS_NODE_TYPES.includes(node.type)) return unwrapTSNode(node.expression);
		else return node;
	}
	const isStaticExp = (p) => p.type === 4 && p.isStatic;
	function isCoreComponent(tag) {
		switch (tag) {
			case "Teleport":
			case "teleport": return TELEPORT;
			case "Suspense":
			case "suspense": return SUSPENSE;
			case "KeepAlive":
			case "keep-alive": return KEEP_ALIVE;
			case "BaseTransition":
			case "base-transition": return BASE_TRANSITION;
		}
	}
	const nonIdentifierRE = /^\d|[^\$\w\xA0-\uFFFF]/;
	const isSimpleIdentifier = (name) => !nonIdentifierRE.test(name);
	const validFirstIdentCharRE = /[A-Za-z_$\xA0-\uFFFF]/;
	const validIdentCharRE = /[\.\?\w$\xA0-\uFFFF]/;
	const whitespaceRE$1 = /\s+[.[]\s*|\s*[.[]\s+/g;
	const getExpSource = (exp) => exp.type === 4 ? exp.content : exp.loc.source;
	const isMemberExpressionBrowser = (exp) => {
		const path$5 = getExpSource(exp).trim().replace(whitespaceRE$1, (s) => s.trim());
		let state = 0;
		let stateStack = [];
		let currentOpenBracketCount = 0;
		let currentOpenParensCount = 0;
		let currentStringType = null;
		for (let i = 0; i < path$5.length; i++) {
			const char = path$5.charAt(i);
			switch (state) {
				case 0:
					if (char === "[") {
						stateStack.push(state);
						state = 1;
						currentOpenBracketCount++;
					} else if (char === "(") {
						stateStack.push(state);
						state = 2;
						currentOpenParensCount++;
					} else if (!(i === 0 ? validFirstIdentCharRE : validIdentCharRE).test(char)) return false;
					break;
				case 1:
					if (char === `'` || char === `"` || char === "`") {
						stateStack.push(state);
						state = 3;
						currentStringType = char;
					} else if (char === `[`) currentOpenBracketCount++;
					else if (char === `]`) {
						if (!--currentOpenBracketCount) state = stateStack.pop();
					}
					break;
				case 2:
					if (char === `'` || char === `"` || char === "`") {
						stateStack.push(state);
						state = 3;
						currentStringType = char;
					} else if (char === `(`) currentOpenParensCount++;
					else if (char === `)`) {
						if (i === path$5.length - 1) return false;
						if (!--currentOpenParensCount) state = stateStack.pop();
					}
					break;
				case 3:
					if (char === currentStringType) {
						state = stateStack.pop();
						currentStringType = null;
					}
					break;
			}
		}
		return !currentOpenBracketCount && !currentOpenParensCount;
	};
	const isMemberExpressionNode = (exp, context) => {
		try {
			let ret = exp.ast || parser.parseExpression(getExpSource(exp), { plugins: context.expressionPlugins ? [...context.expressionPlugins, "typescript"] : ["typescript"] });
			ret = unwrapTSNode(ret);
			return ret.type === "MemberExpression" || ret.type === "OptionalMemberExpression" || ret.type === "Identifier" && ret.name !== "undefined";
		} catch (e) {
			return false;
		}
	};
	const isMemberExpression = isMemberExpressionNode;
	const fnExpRE$1 = /^\s*(async\s*)?(\([^)]*?\)|[\w$_]+)\s*(:[^=]+)?=>|^\s*(async\s+)?function(?:\s+[\w$]+)?\s*\(/;
	const isFnExpressionBrowser = (exp) => fnExpRE$1.test(getExpSource(exp));
	const isFnExpressionNode = (exp, context) => {
		try {
			let ret = exp.ast || parser.parseExpression(getExpSource(exp), { plugins: context.expressionPlugins ? [...context.expressionPlugins, "typescript"] : ["typescript"] });
			if (ret.type === "Program") {
				ret = ret.body[0];
				if (ret.type === "ExpressionStatement") ret = ret.expression;
			}
			ret = unwrapTSNode(ret);
			return ret.type === "FunctionExpression" || ret.type === "ArrowFunctionExpression";
		} catch (e) {
			return false;
		}
	};
	const isFnExpression = isFnExpressionNode;
	function advancePositionWithClone(pos, source, numberOfCharacters = source.length) {
		return advancePositionWithMutation({
			offset: pos.offset,
			line: pos.line,
			column: pos.column
		}, source, numberOfCharacters);
	}
	function advancePositionWithMutation(pos, source, numberOfCharacters = source.length) {
		let linesCount = 0;
		let lastNewLinePos = -1;
		for (let i = 0; i < numberOfCharacters; i++) if (source.charCodeAt(i) === 10) {
			linesCount++;
			lastNewLinePos = i;
		}
		pos.offset += numberOfCharacters;
		pos.line += linesCount;
		pos.column = lastNewLinePos === -1 ? pos.column + numberOfCharacters : numberOfCharacters - lastNewLinePos;
		return pos;
	}
	function assert(condition, msg) {
		if (!condition) throw new Error(msg || `unexpected compiler condition`);
	}
	function findDir(node, name, allowEmpty = false) {
		for (let i = 0; i < node.props.length; i++) {
			const p = node.props[i];
			if (p.type === 7 && (allowEmpty || p.exp) && (shared$1.isString(name) ? p.name === name : name.test(p.name))) return p;
		}
	}
	function findProp(node, name, dynamicOnly = false, allowEmpty = false) {
		for (let i = 0; i < node.props.length; i++) {
			const p = node.props[i];
			if (p.type === 6) {
				if (dynamicOnly) continue;
				if (p.name === name && (p.value || allowEmpty)) return p;
			} else if (p.name === "bind" && (p.exp || allowEmpty) && isStaticArgOf(p.arg, name)) return p;
		}
	}
	function isStaticArgOf(arg, name) {
		return !!(arg && isStaticExp(arg) && arg.content === name);
	}
	function hasDynamicKeyVBind(node) {
		return node.props.some((p) => p.type === 7 && p.name === "bind" && (!p.arg || p.arg.type !== 4 || !p.arg.isStatic));
	}
	function isText$1(node) {
		return node.type === 5 || node.type === 2;
	}
	function isVSlot(p) {
		return p.type === 7 && p.name === "slot";
	}
	function isTemplateNode(node) {
		return node.type === 1 && node.tagType === 3;
	}
	function isSlotOutlet(node) {
		return node.type === 1 && node.tagType === 2;
	}
	const propsHelperSet = /* @__PURE__ */ new Set([NORMALIZE_PROPS, GUARD_REACTIVE_PROPS]);
	function getUnnormalizedProps(props, callPath = []) {
		if (props && !shared$1.isString(props) && props.type === 14) {
			const callee = props.callee;
			if (!shared$1.isString(callee) && propsHelperSet.has(callee)) return getUnnormalizedProps(props.arguments[0], callPath.concat(props));
		}
		return [props, callPath];
	}
	function injectProp(node, prop, context) {
		let propsWithInjection;
		let props = node.type === 13 ? node.props : node.arguments[2];
		let callPath = [];
		let parentCall;
		if (props && !shared$1.isString(props) && props.type === 14) {
			const ret = getUnnormalizedProps(props);
			props = ret[0];
			callPath = ret[1];
			parentCall = callPath[callPath.length - 1];
		}
		if (props == null || shared$1.isString(props)) propsWithInjection = createObjectExpression([prop]);
		else if (props.type === 14) {
			const first = props.arguments[0];
			if (!shared$1.isString(first) && first.type === 15) {
				if (!hasProp(prop, first)) first.properties.unshift(prop);
			} else if (props.callee === TO_HANDLERS) propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [createObjectExpression([prop]), props]);
			else props.arguments.unshift(createObjectExpression([prop]));
			!propsWithInjection && (propsWithInjection = props);
		} else if (props.type === 15) {
			if (!hasProp(prop, props)) props.properties.unshift(prop);
			propsWithInjection = props;
		} else {
			propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [createObjectExpression([prop]), props]);
			if (parentCall && parentCall.callee === GUARD_REACTIVE_PROPS) parentCall = callPath[callPath.length - 2];
		}
		if (node.type === 13) if (parentCall) parentCall.arguments[0] = propsWithInjection;
		else node.props = propsWithInjection;
		else if (parentCall) parentCall.arguments[0] = propsWithInjection;
		else node.arguments[2] = propsWithInjection;
	}
	function hasProp(prop, props) {
		let result = false;
		if (prop.key.type === 4) {
			const propKeyName = prop.key.content;
			result = props.properties.some((p) => p.key.type === 4 && p.key.content === propKeyName);
		}
		return result;
	}
	function toValidAssetId(name, type) {
		return `_${type}_${name.replace(/[^\w]/g, (searchValue, replaceValue) => {
			return searchValue === "-" ? "_" : name.charCodeAt(replaceValue).toString();
		})}`;
	}
	function hasScopeRef(node, ids) {
		if (!node || Object.keys(ids).length === 0) return false;
		switch (node.type) {
			case 1:
				for (let i = 0; i < node.props.length; i++) {
					const p = node.props[i];
					if (p.type === 7 && (hasScopeRef(p.arg, ids) || hasScopeRef(p.exp, ids))) return true;
				}
				return node.children.some((c) => hasScopeRef(c, ids));
			case 11:
				if (hasScopeRef(node.source, ids)) return true;
				return node.children.some((c) => hasScopeRef(c, ids));
			case 9: return node.branches.some((b) => hasScopeRef(b, ids));
			case 10:
				if (hasScopeRef(node.condition, ids)) return true;
				return node.children.some((c) => hasScopeRef(c, ids));
			case 4: return !node.isStatic && isSimpleIdentifier(node.content) && !!ids[node.content];
			case 8: return node.children.some((c) => shared$1.isObject(c) && hasScopeRef(c, ids));
			case 5:
			case 12: return hasScopeRef(node.content, ids);
			case 2:
			case 3:
			case 20: return false;
			default: return false;
		}
	}
	function getMemoedVNodeCall(node) {
		if (node.type === 14 && node.callee === WITH_MEMO) return node.arguments[1].returns;
		else return node;
	}
	const forAliasRE$1 = /([\s\S]*?)\s+(?:in|of)\s+(\S[\s\S]*)/;
	const defaultParserOptions = {
		parseMode: "base",
		ns: 0,
		delimiters: [`{{`, `}}`],
		getNamespace: () => 0,
		isVoidTag: shared$1.NO,
		isPreTag: shared$1.NO,
		isIgnoreNewlineTag: shared$1.NO,
		isCustomElement: shared$1.NO,
		onError: defaultOnError,
		onWarn: defaultOnWarn,
		comments: false,
		prefixIdentifiers: false
	};
	let currentOptions = defaultParserOptions;
	let currentRoot = null;
	let currentInput = "";
	let currentOpenTag = null;
	let currentProp = null;
	let currentAttrValue = "";
	let currentAttrStartIndex = -1;
	let currentAttrEndIndex = -1;
	let inPre = 0;
	let inVPre = false;
	let currentVPreBoundary = null;
	const stack = [];
	const tokenizer = new Tokenizer(stack, {
		onerr: emitError,
		ontext(start, end) {
			onText(getSlice(start, end), start, end);
		},
		ontextentity(char, start, end) {
			onText(char, start, end);
		},
		oninterpolation(start, end) {
			if (inVPre) return onText(getSlice(start, end), start, end);
			let innerStart = start + tokenizer.delimiterOpen.length;
			let innerEnd = end - tokenizer.delimiterClose.length;
			while (isWhitespace$1(currentInput.charCodeAt(innerStart))) innerStart++;
			while (isWhitespace$1(currentInput.charCodeAt(innerEnd - 1))) innerEnd--;
			let exp = getSlice(innerStart, innerEnd);
			if (exp.includes("&")) exp = decode_js.decodeHTML(exp);
			addNode({
				type: 5,
				content: createExp(exp, false, getLoc(innerStart, innerEnd)),
				loc: getLoc(start, end)
			});
		},
		onopentagname(start, end) {
			const name = getSlice(start, end);
			currentOpenTag = {
				type: 1,
				tag: name,
				ns: currentOptions.getNamespace(name, stack[0], currentOptions.ns),
				tagType: 0,
				props: [],
				children: [],
				loc: getLoc(start - 1, end),
				codegenNode: void 0
			};
		},
		onopentagend(end) {
			endOpenTag(end);
		},
		onclosetag(start, end) {
			const name = getSlice(start, end);
			if (!currentOptions.isVoidTag(name)) {
				let found = false;
				for (let i = 0; i < stack.length; i++) {
					const e = stack[i];
					if (e.tag.toLowerCase() === name.toLowerCase()) {
						found = true;
						if (i > 0) emitError(24, stack[0].loc.start.offset);
						for (let j = 0; j <= i; j++) {
							const el = stack.shift();
							onCloseTag(el, end, j < i);
						}
						break;
					}
				}
				if (!found) emitError(23, backTrack(start, 60));
			}
		},
		onselfclosingtag(end) {
			const name = currentOpenTag.tag;
			currentOpenTag.isSelfClosing = true;
			endOpenTag(end);
			if (stack[0] && stack[0].tag === name) onCloseTag(stack.shift(), end);
		},
		onattribname(start, end) {
			currentProp = {
				type: 6,
				name: getSlice(start, end),
				nameLoc: getLoc(start, end),
				value: void 0,
				loc: getLoc(start)
			};
		},
		ondirname(start, end) {
			const raw$1 = getSlice(start, end);
			const name = raw$1 === "." || raw$1 === ":" ? "bind" : raw$1 === "@" ? "on" : raw$1 === "#" ? "slot" : raw$1.slice(2);
			if (!inVPre && name === "") emitError(26, start);
			if (inVPre || name === "") currentProp = {
				type: 6,
				name: raw$1,
				nameLoc: getLoc(start, end),
				value: void 0,
				loc: getLoc(start)
			};
			else {
				currentProp = {
					type: 7,
					name,
					rawName: raw$1,
					exp: void 0,
					arg: void 0,
					modifiers: raw$1 === "." ? [createSimpleExpression("prop")] : [],
					loc: getLoc(start)
				};
				if (name === "pre") {
					inVPre = tokenizer.inVPre = true;
					currentVPreBoundary = currentOpenTag;
					const props = currentOpenTag.props;
					for (let i = 0; i < props.length; i++) if (props[i].type === 7) props[i] = dirToAttr(props[i]);
				}
			}
		},
		ondirarg(start, end) {
			if (start === end) return;
			const arg = getSlice(start, end);
			if (inVPre) {
				currentProp.name += arg;
				setLocEnd(currentProp.nameLoc, end);
			} else {
				const isStatic$1 = arg[0] !== `[`;
				currentProp.arg = createExp(isStatic$1 ? arg : arg.slice(1, -1), isStatic$1, getLoc(start, end), isStatic$1 ? 3 : 0);
			}
		},
		ondirmodifier(start, end) {
			const mod = getSlice(start, end);
			if (inVPre) {
				currentProp.name += "." + mod;
				setLocEnd(currentProp.nameLoc, end);
			} else if (currentProp.name === "slot") {
				const arg = currentProp.arg;
				if (arg) {
					arg.content += "." + mod;
					setLocEnd(arg.loc, end);
				}
			} else {
				const exp = createSimpleExpression(mod, true, getLoc(start, end));
				currentProp.modifiers.push(exp);
			}
		},
		onattribdata(start, end) {
			currentAttrValue += getSlice(start, end);
			if (currentAttrStartIndex < 0) currentAttrStartIndex = start;
			currentAttrEndIndex = end;
		},
		onattribentity(char, start, end) {
			currentAttrValue += char;
			if (currentAttrStartIndex < 0) currentAttrStartIndex = start;
			currentAttrEndIndex = end;
		},
		onattribnameend(end) {
			const start = currentProp.loc.start.offset;
			const name = getSlice(start, end);
			if (currentProp.type === 7) currentProp.rawName = name;
			if (currentOpenTag.props.some((p) => (p.type === 7 ? p.rawName : p.name) === name)) emitError(2, start);
		},
		onattribend(quote, end) {
			if (currentOpenTag && currentProp) {
				setLocEnd(currentProp.loc, end);
				if (quote !== 0) if (currentProp.type === 6) {
					if (currentProp.name === "class") currentAttrValue = condense(currentAttrValue).trim();
					if (quote === 1 && !currentAttrValue) emitError(13, end);
					currentProp.value = {
						type: 2,
						content: currentAttrValue,
						loc: quote === 1 ? getLoc(currentAttrStartIndex, currentAttrEndIndex) : getLoc(currentAttrStartIndex - 1, currentAttrEndIndex + 1)
					};
					if (tokenizer.inSFCRoot && currentOpenTag.tag === "template" && currentProp.name === "lang" && currentAttrValue && currentAttrValue !== "html") tokenizer.enterRCDATA(toCharCodes(`</template`), 0);
				} else {
					let expParseMode = 0;
					if (currentProp.name === "for") expParseMode = 3;
					else if (currentProp.name === "slot") expParseMode = 1;
					else if (currentProp.name === "on" && currentAttrValue.includes(";")) expParseMode = 2;
					currentProp.exp = createExp(currentAttrValue, false, getLoc(currentAttrStartIndex, currentAttrEndIndex), 0, expParseMode);
					if (currentProp.name === "for") currentProp.forParseResult = parseForExpression(currentProp.exp);
					let syncIndex = -1;
					if (currentProp.name === "bind" && (syncIndex = currentProp.modifiers.findIndex((mod) => mod.content === "sync")) > -1 && checkCompatEnabled("COMPILER_V_BIND_SYNC", currentOptions, currentProp.loc, currentProp.arg.loc.source)) {
						currentProp.name = "model";
						currentProp.modifiers.splice(syncIndex, 1);
					}
				}
				if (currentProp.type !== 7 || currentProp.name !== "pre") currentOpenTag.props.push(currentProp);
			}
			currentAttrValue = "";
			currentAttrStartIndex = currentAttrEndIndex = -1;
		},
		oncomment(start, end) {
			if (currentOptions.comments) addNode({
				type: 3,
				content: getSlice(start, end),
				loc: getLoc(start - 4, end + 3)
			});
		},
		onend() {
			const end = currentInput.length;
			if (tokenizer.state !== 1) switch (tokenizer.state) {
				case 5:
				case 8:
					emitError(5, end);
					break;
				case 3:
				case 4:
					emitError(25, tokenizer.sectionStart);
					break;
				case 28:
					if (tokenizer.currentSequence === Sequences.CdataEnd) emitError(6, end);
					else emitError(7, end);
					break;
				case 6:
				case 7:
				case 9:
				case 11:
				case 12:
				case 13:
				case 14:
				case 15:
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				case 21:
					emitError(9, end);
					break;
			}
			for (let index$1 = 0; index$1 < stack.length; index$1++) {
				onCloseTag(stack[index$1], end - 1);
				emitError(24, stack[index$1].loc.start.offset);
			}
		},
		oncdata(start, end) {
			if (stack[0].ns !== 0) onText(getSlice(start, end), start, end);
			else emitError(1, start - 9);
		},
		onprocessinginstruction(start) {
			if ((stack[0] ? stack[0].ns : currentOptions.ns) === 0) emitError(21, start - 1);
		}
	});
	const forIteratorRE$1 = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
	const stripParensRE$1 = /^\(|\)$/g;
	function parseForExpression(input) {
		const loc = input.loc;
		const exp = input.content;
		const inMatch = exp.match(forAliasRE$1);
		if (!inMatch) return;
		const [, LHS, RHS] = inMatch;
		const createAliasExpression = (content, offset, asParam = false) => {
			const start = loc.start.offset + offset;
			const end = start + content.length;
			return createExp(content, false, getLoc(start, end), 0, asParam ? 1 : 0);
		};
		const result = {
			source: createAliasExpression(RHS.trim(), exp.indexOf(RHS, LHS.length)),
			value: void 0,
			key: void 0,
			index: void 0,
			finalized: false
		};
		let valueContent = LHS.trim().replace(stripParensRE$1, "").trim();
		const trimmedOffset = LHS.indexOf(valueContent);
		const iteratorMatch = valueContent.match(forIteratorRE$1);
		if (iteratorMatch) {
			valueContent = valueContent.replace(forIteratorRE$1, "").trim();
			const keyContent = iteratorMatch[1].trim();
			let keyOffset;
			if (keyContent) {
				keyOffset = exp.indexOf(keyContent, trimmedOffset + valueContent.length);
				result.key = createAliasExpression(keyContent, keyOffset, true);
			}
			if (iteratorMatch[2]) {
				const indexContent = iteratorMatch[2].trim();
				if (indexContent) result.index = createAliasExpression(indexContent, exp.indexOf(indexContent, result.key ? keyOffset + keyContent.length : trimmedOffset + valueContent.length), true);
			}
		}
		if (valueContent) result.value = createAliasExpression(valueContent, trimmedOffset, true);
		return result;
	}
	function getSlice(start, end) {
		return currentInput.slice(start, end);
	}
	function endOpenTag(end) {
		if (tokenizer.inSFCRoot) currentOpenTag.innerLoc = getLoc(end + 1, end + 1);
		addNode(currentOpenTag);
		const { tag, ns } = currentOpenTag;
		if (ns === 0 && currentOptions.isPreTag(tag)) inPre++;
		if (currentOptions.isVoidTag(tag)) onCloseTag(currentOpenTag, end);
		else {
			stack.unshift(currentOpenTag);
			if (ns === 1 || ns === 2) tokenizer.inXML = true;
		}
		currentOpenTag = null;
	}
	function onText(content, start, end) {
		const parent = stack[0] || currentRoot;
		const lastNode = parent.children[parent.children.length - 1];
		if (lastNode && lastNode.type === 2) {
			lastNode.content += content;
			setLocEnd(lastNode.loc, end);
		} else parent.children.push({
			type: 2,
			content,
			loc: getLoc(start, end)
		});
	}
	function onCloseTag(el, end, isImplied = false) {
		if (isImplied) setLocEnd(el.loc, backTrack(end, 60));
		else setLocEnd(el.loc, lookAhead(end, 62) + 1);
		if (tokenizer.inSFCRoot) {
			if (el.children.length) el.innerLoc.end = shared$1.extend({}, el.children[el.children.length - 1].loc.end);
			else el.innerLoc.end = shared$1.extend({}, el.innerLoc.start);
			el.innerLoc.source = getSlice(el.innerLoc.start.offset, el.innerLoc.end.offset);
		}
		const { tag, ns, children } = el;
		if (!inVPre) {
			if (tag === "slot") el.tagType = 2;
			else if (isFragmentTemplate(el)) el.tagType = 3;
			else if (isComponent(el)) el.tagType = 1;
		}
		if (!tokenizer.inRCDATA) el.children = condenseWhitespace(children);
		if (ns === 0 && currentOptions.isIgnoreNewlineTag(tag)) {
			const first = children[0];
			if (first && first.type === 2) first.content = first.content.replace(/^\r?\n/, "");
		}
		if (ns === 0 && currentOptions.isPreTag(tag)) inPre--;
		if (currentVPreBoundary === el) {
			inVPre = tokenizer.inVPre = false;
			currentVPreBoundary = null;
		}
		if (tokenizer.inXML && (stack[0] ? stack[0].ns : currentOptions.ns) === 0) tokenizer.inXML = false;
		{
			const props = el.props;
			if (!tokenizer.inSFCRoot && isCompatEnabled("COMPILER_NATIVE_TEMPLATE", currentOptions) && el.tag === "template" && !isFragmentTemplate(el)) {
				const parent = stack[0] || currentRoot;
				const index$1 = parent.children.indexOf(el);
				parent.children.splice(index$1, 1, ...el.children);
			}
			const inlineTemplateProp = props.find((p) => p.type === 6 && p.name === "inline-template");
			if (inlineTemplateProp && checkCompatEnabled("COMPILER_INLINE_TEMPLATE", currentOptions, inlineTemplateProp.loc) && el.children.length) inlineTemplateProp.value = {
				type: 2,
				content: getSlice(el.children[0].loc.start.offset, el.children[el.children.length - 1].loc.end.offset),
				loc: inlineTemplateProp.loc
			};
		}
	}
	function lookAhead(index$1, c) {
		let i = index$1;
		while (currentInput.charCodeAt(i) !== c && i < currentInput.length - 1) i++;
		return i;
	}
	function backTrack(index$1, c) {
		let i = index$1;
		while (currentInput.charCodeAt(i) !== c && i >= 0) i--;
		return i;
	}
	const specialTemplateDir = /* @__PURE__ */ new Set([
		"if",
		"else",
		"else-if",
		"for",
		"slot"
	]);
	function isFragmentTemplate({ tag, props }) {
		if (tag === "template") {
			for (let i = 0; i < props.length; i++) if (props[i].type === 7 && specialTemplateDir.has(props[i].name)) return true;
		}
		return false;
	}
	function isComponent({ tag, props }) {
		if (currentOptions.isCustomElement(tag)) return false;
		if (tag === "component" || isUpperCase(tag.charCodeAt(0)) || isCoreComponent(tag) || currentOptions.isBuiltInComponent && currentOptions.isBuiltInComponent(tag) || currentOptions.isNativeTag && !currentOptions.isNativeTag(tag)) return true;
		for (let i = 0; i < props.length; i++) {
			const p = props[i];
			if (p.type === 6) {
				if (p.name === "is" && p.value) {
					if (p.value.content.startsWith("vue:")) return true;
					else if (checkCompatEnabled("COMPILER_IS_ON_ELEMENT", currentOptions, p.loc)) return true;
				}
			} else if (p.name === "bind" && isStaticArgOf(p.arg, "is") && checkCompatEnabled("COMPILER_IS_ON_ELEMENT", currentOptions, p.loc)) return true;
		}
		return false;
	}
	function isUpperCase(c) {
		return c > 64 && c < 91;
	}
	const windowsNewlineRE = /\r\n/g;
	function condenseWhitespace(nodes) {
		const shouldCondense = currentOptions.whitespace !== "preserve";
		let removedWhitespace = false;
		for (let i = 0; i < nodes.length; i++) {
			const node = nodes[i];
			if (node.type === 2) if (!inPre) {
				if (isAllWhitespace(node.content)) {
					const prev = nodes[i - 1] && nodes[i - 1].type;
					const next$1 = nodes[i + 1] && nodes[i + 1].type;
					if (!prev || !next$1 || shouldCondense && (prev === 3 && (next$1 === 3 || next$1 === 1) || prev === 1 && (next$1 === 3 || next$1 === 1 && hasNewlineChar(node.content)))) {
						removedWhitespace = true;
						nodes[i] = null;
					} else node.content = " ";
				} else if (shouldCondense) node.content = condense(node.content);
			} else node.content = node.content.replace(windowsNewlineRE, "\n");
		}
		return removedWhitespace ? nodes.filter(Boolean) : nodes;
	}
	function isAllWhitespace(str$1) {
		for (let i = 0; i < str$1.length; i++) if (!isWhitespace$1(str$1.charCodeAt(i))) return false;
		return true;
	}
	function hasNewlineChar(str$1) {
		for (let i = 0; i < str$1.length; i++) {
			const c = str$1.charCodeAt(i);
			if (c === 10 || c === 13) return true;
		}
		return false;
	}
	function condense(str$1) {
		let ret = "";
		let prevCharIsWhitespace = false;
		for (let i = 0; i < str$1.length; i++) if (isWhitespace$1(str$1.charCodeAt(i))) {
			if (!prevCharIsWhitespace) {
				ret += " ";
				prevCharIsWhitespace = true;
			}
		} else {
			ret += str$1[i];
			prevCharIsWhitespace = false;
		}
		return ret;
	}
	function addNode(node) {
		(stack[0] || currentRoot).children.push(node);
	}
	function getLoc(start, end) {
		return {
			start: tokenizer.getPos(start),
			end: end == null ? end : tokenizer.getPos(end),
			source: end == null ? end : getSlice(start, end)
		};
	}
	function cloneLoc(loc) {
		return getLoc(loc.start.offset, loc.end.offset);
	}
	function setLocEnd(loc, end) {
		loc.end = tokenizer.getPos(end);
		loc.source = getSlice(loc.start.offset, end);
	}
	function dirToAttr(dir) {
		const attr = {
			type: 6,
			name: dir.rawName,
			nameLoc: getLoc(dir.loc.start.offset, dir.loc.start.offset + dir.rawName.length),
			value: void 0,
			loc: dir.loc
		};
		if (dir.exp) {
			const loc = dir.exp.loc;
			if (loc.end.offset < dir.loc.end.offset) {
				loc.start.offset--;
				loc.start.column--;
				loc.end.offset++;
				loc.end.column++;
			}
			attr.value = {
				type: 2,
				content: dir.exp.content,
				loc
			};
		}
		return attr;
	}
	function createExp(content, isStatic$1 = false, loc, constType = 0, parseMode = 0) {
		const exp = createSimpleExpression(content, isStatic$1, loc, constType);
		if (!isStatic$1 && currentOptions.prefixIdentifiers && parseMode !== 3 && content.trim()) {
			if (isSimpleIdentifier(content)) {
				exp.ast = null;
				return exp;
			}
			try {
				const plugins = currentOptions.expressionPlugins;
				const options = { plugins: plugins ? [...plugins, "typescript"] : ["typescript"] };
				if (parseMode === 2) exp.ast = parser.parse(` ${content} `, options).program;
				else if (parseMode === 1) exp.ast = parser.parseExpression(`(${content})=>{}`, options);
				else exp.ast = parser.parseExpression(`(${content})`, options);
			} catch (e) {
				exp.ast = false;
				emitError(45, loc.start.offset, e.message);
			}
		}
		return exp;
	}
	function emitError(code$1, index$1, message) {
		currentOptions.onError(createCompilerError(code$1, getLoc(index$1, index$1), void 0, message));
	}
	function reset() {
		tokenizer.reset();
		currentOpenTag = null;
		currentProp = null;
		currentAttrValue = "";
		currentAttrStartIndex = -1;
		currentAttrEndIndex = -1;
		stack.length = 0;
	}
	function baseParse(input, options) {
		reset();
		currentInput = input;
		currentOptions = shared$1.extend({}, defaultParserOptions);
		if (options) {
			let key;
			for (key in options) if (options[key] != null) currentOptions[key] = options[key];
		}
		tokenizer.mode = currentOptions.parseMode === "html" ? 1 : currentOptions.parseMode === "sfc" ? 2 : 0;
		tokenizer.inXML = currentOptions.ns === 1 || currentOptions.ns === 2;
		const delimiters$1 = options && options.delimiters;
		if (delimiters$1) {
			tokenizer.delimiterOpen = toCharCodes(delimiters$1[0]);
			tokenizer.delimiterClose = toCharCodes(delimiters$1[1]);
		}
		const root = currentRoot = createRoot([], input);
		tokenizer.parse(currentInput);
		root.loc = getLoc(0, input.length);
		root.children = condenseWhitespace(root.children);
		currentRoot = null;
		return root;
	}
	function cacheStatic(root, context) {
		walk$1(root, void 0, context, !!getSingleElementRoot(root));
	}
	function getSingleElementRoot(root) {
		const children = root.children.filter((x) => x.type !== 3);
		return children.length === 1 && children[0].type === 1 && !isSlotOutlet(children[0]) ? children[0] : null;
	}
	function walk$1(node, parent, context, doNotHoistNode = false, inFor = false) {
		const { children } = node;
		const toCache = [];
		for (let i = 0; i < children.length; i++) {
			const child = children[i];
			if (child.type === 1 && child.tagType === 0) {
				const constantType = doNotHoistNode ? 0 : getConstantType(child, context);
				if (constantType > 0) {
					if (constantType >= 2) {
						child.codegenNode.patchFlag = -1;
						toCache.push(child);
						continue;
					}
				} else {
					const codegenNode = child.codegenNode;
					if (codegenNode.type === 13) {
						const flag = codegenNode.patchFlag;
						if ((flag === void 0 || flag === 512 || flag === 1) && getGeneratedPropsConstantType(child, context) >= 2) {
							const props = getNodeProps(child);
							if (props) codegenNode.props = context.hoist(props);
						}
						if (codegenNode.dynamicProps) codegenNode.dynamicProps = context.hoist(codegenNode.dynamicProps);
					}
				}
			} else if (child.type === 12) {
				const constantType = doNotHoistNode ? 0 : getConstantType(child, context);
				if (constantType >= 2) {
					toCache.push(child);
					continue;
				}
			}
			if (child.type === 1) {
				const isComponent$1 = child.tagType === 1;
				if (isComponent$1) context.scopes.vSlot++;
				walk$1(child, node, context, false, inFor);
				if (isComponent$1) context.scopes.vSlot--;
			} else if (child.type === 11) walk$1(child, node, context, child.children.length === 1, true);
			else if (child.type === 9) for (let i2 = 0; i2 < child.branches.length; i2++) walk$1(child.branches[i2], node, context, child.branches[i2].children.length === 1, inFor);
		}
		let cachedAsArray = false;
		const slotCacheKeys = [];
		if (toCache.length === children.length && node.type === 1) {
			if (node.tagType === 0 && node.codegenNode && node.codegenNode.type === 13 && shared$1.isArray(node.codegenNode.children)) {
				node.codegenNode.children = getCacheExpression(createArrayExpression(node.codegenNode.children));
				cachedAsArray = true;
			} else if (node.tagType === 1 && node.codegenNode && node.codegenNode.type === 13 && node.codegenNode.children && !shared$1.isArray(node.codegenNode.children) && node.codegenNode.children.type === 15) {
				const slot = getSlotNode(node.codegenNode, "default");
				if (slot) {
					slotCacheKeys.push(context.cached.length);
					slot.returns = getCacheExpression(createArrayExpression(slot.returns));
					cachedAsArray = true;
				}
			} else if (node.tagType === 3 && parent && parent.type === 1 && parent.tagType === 1 && parent.codegenNode && parent.codegenNode.type === 13 && parent.codegenNode.children && !shared$1.isArray(parent.codegenNode.children) && parent.codegenNode.children.type === 15) {
				const slotName = findDir(node, "slot", true);
				const slot = slotName && slotName.arg && getSlotNode(parent.codegenNode, slotName.arg);
				if (slot) {
					slotCacheKeys.push(context.cached.length);
					slot.returns = getCacheExpression(createArrayExpression(slot.returns));
					cachedAsArray = true;
				}
			}
		}
		if (!cachedAsArray) for (const child of toCache) {
			slotCacheKeys.push(context.cached.length);
			child.codegenNode = context.cache(child.codegenNode);
		}
		if (slotCacheKeys.length && node.type === 1 && node.tagType === 1 && node.codegenNode && node.codegenNode.type === 13 && node.codegenNode.children && !shared$1.isArray(node.codegenNode.children) && node.codegenNode.children.type === 15) node.codegenNode.children.properties.push(createObjectProperty(`__`, createSimpleExpression(JSON.stringify(slotCacheKeys), false)));
		function getCacheExpression(value) {
			const exp = context.cache(value);
			if (inFor && context.hmr) exp.needArraySpread = true;
			return exp;
		}
		function getSlotNode(node2, name) {
			if (node2.children && !shared$1.isArray(node2.children) && node2.children.type === 15) {
				const slot = node2.children.properties.find((p) => p.key === name || p.key.content === name);
				return slot && slot.value;
			}
		}
		if (toCache.length && context.transformHoist) context.transformHoist(children, context, node);
	}
	function getConstantType(node, context) {
		const { constantCache } = context;
		switch (node.type) {
			case 1:
				if (node.tagType !== 0) return 0;
				const cached$1 = constantCache.get(node);
				if (cached$1 !== void 0) return cached$1;
				const codegenNode = node.codegenNode;
				if (codegenNode.type !== 13) return 0;
				if (codegenNode.isBlock && node.tag !== "svg" && node.tag !== "foreignObject" && node.tag !== "math") return 0;
				if (codegenNode.patchFlag === void 0) {
					let returnType2 = 3;
					const generatedPropsType = getGeneratedPropsConstantType(node, context);
					if (generatedPropsType === 0) {
						constantCache.set(node, 0);
						return 0;
					}
					if (generatedPropsType < returnType2) returnType2 = generatedPropsType;
					for (let i = 0; i < node.children.length; i++) {
						const childType = getConstantType(node.children[i], context);
						if (childType === 0) {
							constantCache.set(node, 0);
							return 0;
						}
						if (childType < returnType2) returnType2 = childType;
					}
					if (returnType2 > 1) for (let i = 0; i < node.props.length; i++) {
						const p = node.props[i];
						if (p.type === 7 && p.name === "bind" && p.exp) {
							const expType = getConstantType(p.exp, context);
							if (expType === 0) {
								constantCache.set(node, 0);
								return 0;
							}
							if (expType < returnType2) returnType2 = expType;
						}
					}
					if (codegenNode.isBlock) {
						for (let i = 0; i < node.props.length; i++) {
							const p = node.props[i];
							if (p.type === 7) {
								constantCache.set(node, 0);
								return 0;
							}
						}
						context.removeHelper(OPEN_BLOCK);
						context.removeHelper(getVNodeBlockHelper(context.inSSR, codegenNode.isComponent));
						codegenNode.isBlock = false;
						context.helper(getVNodeHelper(context.inSSR, codegenNode.isComponent));
					}
					constantCache.set(node, returnType2);
					return returnType2;
				} else {
					constantCache.set(node, 0);
					return 0;
				}
			case 2:
			case 3: return 3;
			case 9:
			case 11:
			case 10: return 0;
			case 5:
			case 12: return getConstantType(node.content, context);
			case 4: return node.constType;
			case 8:
				let returnType = 3;
				for (let i = 0; i < node.children.length; i++) {
					const child = node.children[i];
					if (shared$1.isString(child) || shared$1.isSymbol(child)) continue;
					const childType = getConstantType(child, context);
					if (childType === 0) return 0;
					else if (childType < returnType) returnType = childType;
				}
				return returnType;
			case 20: return 2;
			default: return 0;
		}
	}
	const allowHoistedHelperSet = /* @__PURE__ */ new Set([
		NORMALIZE_CLASS,
		NORMALIZE_STYLE,
		NORMALIZE_PROPS,
		GUARD_REACTIVE_PROPS
	]);
	function getConstantTypeOfHelperCall(value, context) {
		if (value.type === 14 && !shared$1.isString(value.callee) && allowHoistedHelperSet.has(value.callee)) {
			const arg = value.arguments[0];
			if (arg.type === 4) return getConstantType(arg, context);
			else if (arg.type === 14) return getConstantTypeOfHelperCall(arg, context);
		}
		return 0;
	}
	function getGeneratedPropsConstantType(node, context) {
		let returnType = 3;
		const props = getNodeProps(node);
		if (props && props.type === 15) {
			const { properties } = props;
			for (let i = 0; i < properties.length; i++) {
				const { key, value } = properties[i];
				const keyType = getConstantType(key, context);
				if (keyType === 0) return keyType;
				if (keyType < returnType) returnType = keyType;
				let valueType;
				if (value.type === 4) valueType = getConstantType(value, context);
				else if (value.type === 14) valueType = getConstantTypeOfHelperCall(value, context);
				else valueType = 0;
				if (valueType === 0) return valueType;
				if (valueType < returnType) returnType = valueType;
			}
		}
		return returnType;
	}
	function getNodeProps(node) {
		const codegenNode = node.codegenNode;
		if (codegenNode.type === 13) return codegenNode.props;
	}
	function createTransformContext(root, { filename = "", prefixIdentifiers = false, hoistStatic = false, hmr = false, cacheHandlers = false, nodeTransforms = [], directiveTransforms = {}, transformHoist = null, isBuiltInComponent = shared$1.NOOP, isCustomElement = shared$1.NOOP, expressionPlugins = [], scopeId = null, slotted = true, ssr = false, inSSR = false, ssrCssVars = ``, bindingMetadata = shared$1.EMPTY_OBJ, inline = false, isTS = false, onError = defaultOnError, onWarn = defaultOnWarn, compatConfig }) {
		const nameMatch = filename.replace(/\?.*$/, "").match(/([^/\\]+)\.\w+$/);
		const context = {
			filename,
			selfName: nameMatch && shared$1.capitalize(shared$1.camelize(nameMatch[1])),
			prefixIdentifiers,
			hoistStatic,
			hmr,
			cacheHandlers,
			nodeTransforms,
			directiveTransforms,
			transformHoist,
			isBuiltInComponent,
			isCustomElement,
			expressionPlugins,
			scopeId,
			slotted,
			ssr,
			inSSR,
			ssrCssVars,
			bindingMetadata,
			inline,
			isTS,
			onError,
			onWarn,
			compatConfig,
			root,
			helpers: /* @__PURE__ */ new Map(),
			components: /* @__PURE__ */ new Set(),
			directives: /* @__PURE__ */ new Set(),
			hoists: [],
			imports: [],
			cached: [],
			constantCache: /* @__PURE__ */ new WeakMap(),
			temps: 0,
			identifiers: /* @__PURE__ */ Object.create(null),
			scopes: {
				vFor: 0,
				vSlot: 0,
				vPre: 0,
				vOnce: 0
			},
			parent: null,
			grandParent: null,
			currentNode: root,
			childIndex: 0,
			inVOnce: false,
			helper(name) {
				const count$1 = context.helpers.get(name) || 0;
				context.helpers.set(name, count$1 + 1);
				return name;
			},
			removeHelper(name) {
				const count$1 = context.helpers.get(name);
				if (count$1) {
					const currentCount = count$1 - 1;
					if (!currentCount) context.helpers.delete(name);
					else context.helpers.set(name, currentCount);
				}
			},
			helperString(name) {
				return `_${helperNameMap[context.helper(name)]}`;
			},
			replaceNode(node) {
				context.parent.children[context.childIndex] = context.currentNode = node;
			},
			removeNode(node) {
				const list = context.parent.children;
				const removalIndex = node ? list.indexOf(node) : context.currentNode ? context.childIndex : -1;
				if (!node || node === context.currentNode) {
					context.currentNode = null;
					context.onNodeRemoved();
				} else if (context.childIndex > removalIndex) {
					context.childIndex--;
					context.onNodeRemoved();
				}
				context.parent.children.splice(removalIndex, 1);
			},
			onNodeRemoved: shared$1.NOOP,
			addIdentifiers(exp) {
				if (shared$1.isString(exp)) addId(exp);
				else if (exp.identifiers) exp.identifiers.forEach(addId);
				else if (exp.type === 4) addId(exp.content);
			},
			removeIdentifiers(exp) {
				if (shared$1.isString(exp)) removeId(exp);
				else if (exp.identifiers) exp.identifiers.forEach(removeId);
				else if (exp.type === 4) removeId(exp.content);
			},
			hoist(exp) {
				if (shared$1.isString(exp)) exp = createSimpleExpression(exp);
				context.hoists.push(exp);
				const identifier = createSimpleExpression(`_hoisted_${context.hoists.length}`, false, exp.loc, 2);
				identifier.hoisted = exp;
				return identifier;
			},
			cache(exp, isVNode = false, inVOnce = false) {
				const cacheExp = createCacheExpression(context.cached.length, exp, isVNode, inVOnce);
				context.cached.push(cacheExp);
				return cacheExp;
			}
		};
		context.filters = /* @__PURE__ */ new Set();
		function addId(id) {
			const { identifiers } = context;
			if (identifiers[id] === void 0) identifiers[id] = 0;
			identifiers[id]++;
		}
		function removeId(id) {
			context.identifiers[id]--;
		}
		return context;
	}
	function transform(root, options) {
		const context = createTransformContext(root, options);
		traverseNode(root, context);
		if (options.hoistStatic) cacheStatic(root, context);
		if (!options.ssr) createRootCodegen(root, context);
		root.helpers = /* @__PURE__ */ new Set([...context.helpers.keys()]);
		root.components = [...context.components];
		root.directives = [...context.directives];
		root.imports = context.imports;
		root.hoists = context.hoists;
		root.temps = context.temps;
		root.cached = context.cached;
		root.transformed = true;
		root.filters = [...context.filters];
	}
	function createRootCodegen(root, context) {
		const { helper } = context;
		const { children } = root;
		if (children.length === 1) {
			const singleElementRootChild = getSingleElementRoot(root);
			if (singleElementRootChild && singleElementRootChild.codegenNode) {
				const codegenNode = singleElementRootChild.codegenNode;
				if (codegenNode.type === 13) convertToBlock(codegenNode, context);
				root.codegenNode = codegenNode;
			} else root.codegenNode = children[0];
		} else if (children.length > 1) {
			let patchFlag = 64;
			root.codegenNode = createVNodeCall(context, helper(FRAGMENT), void 0, root.children, patchFlag, void 0, void 0, true, void 0, false);
		}
	}
	function traverseChildren(parent, context) {
		let i = 0;
		const nodeRemoved = () => {
			i--;
		};
		for (; i < parent.children.length; i++) {
			const child = parent.children[i];
			if (shared$1.isString(child)) continue;
			context.grandParent = context.parent;
			context.parent = parent;
			context.childIndex = i;
			context.onNodeRemoved = nodeRemoved;
			traverseNode(child, context);
		}
	}
	function traverseNode(node, context) {
		context.currentNode = node;
		const { nodeTransforms } = context;
		const exitFns = [];
		for (let i2 = 0; i2 < nodeTransforms.length; i2++) {
			const onExit = nodeTransforms[i2](node, context);
			if (onExit) if (shared$1.isArray(onExit)) exitFns.push(...onExit);
			else exitFns.push(onExit);
			if (!context.currentNode) return;
			else node = context.currentNode;
		}
		switch (node.type) {
			case 3:
				if (!context.ssr) context.helper(CREATE_COMMENT);
				break;
			case 5:
				if (!context.ssr) context.helper(TO_DISPLAY_STRING);
				break;
			case 9:
				for (let i2 = 0; i2 < node.branches.length; i2++) traverseNode(node.branches[i2], context);
				break;
			case 10:
			case 11:
			case 1:
			case 0:
				traverseChildren(node, context);
				break;
		}
		context.currentNode = node;
		let i = exitFns.length;
		while (i--) exitFns[i]();
	}
	function createStructuralDirectiveTransform(name, fn) {
		const matches = shared$1.isString(name) ? (n) => n === name : (n) => name.test(n);
		return (node, context) => {
			if (node.type === 1) {
				const { props } = node;
				if (node.tagType === 3 && props.some(isVSlot)) return;
				const exitFns = [];
				for (let i = 0; i < props.length; i++) {
					const prop = props[i];
					if (prop.type === 7 && matches(prop.name)) {
						props.splice(i, 1);
						i--;
						const onExit = fn(node, prop, context);
						if (onExit) exitFns.push(onExit);
					}
				}
				return exitFns;
			}
		};
	}
	const PURE_ANNOTATION = `/*@__PURE__*/`;
	const aliasHelper = (s) => `${helperNameMap[s]}: _${helperNameMap[s]}`;
	function createCodegenContext(ast, { mode = "function", prefixIdentifiers = mode === "module", sourceMap = false, filename = `template.vue.html`, scopeId = null, optimizeImports = false, runtimeGlobalName = `Vue`, runtimeModuleName = `vue`, ssrRuntimeModuleName = "vue/server-renderer", ssr = false, isTS = false, inSSR = false }) {
		const context = {
			mode,
			prefixIdentifiers,
			sourceMap,
			filename,
			scopeId,
			optimizeImports,
			runtimeGlobalName,
			runtimeModuleName,
			ssrRuntimeModuleName,
			ssr,
			isTS,
			inSSR,
			source: ast.source,
			code: ``,
			column: 1,
			line: 1,
			offset: 0,
			indentLevel: 0,
			pure: false,
			map: void 0,
			helper(key) {
				return `_${helperNameMap[key]}`;
			},
			push(code$1, newlineIndex = -2, node) {
				context.code += code$1;
				if (context.map) {
					if (node) {
						let name;
						if (node.type === 4 && !node.isStatic) {
							const content = node.content.replace(/^_ctx\./, "");
							if (content !== node.content && isSimpleIdentifier(content)) name = content;
						}
						if (node.loc.source) addMapping(node.loc.start, name);
					}
					if (newlineIndex === -3) advancePositionWithMutation(context, code$1);
					else {
						context.offset += code$1.length;
						if (newlineIndex === -2) context.column += code$1.length;
						else {
							if (newlineIndex === -1) newlineIndex = code$1.length - 1;
							context.line++;
							context.column = code$1.length - newlineIndex;
						}
					}
					if (node && node.loc !== locStub && node.loc.source) addMapping(node.loc.end);
				}
			},
			indent() {
				newline(++context.indentLevel);
			},
			deindent(withoutNewLine = false) {
				if (withoutNewLine) --context.indentLevel;
				else newline(--context.indentLevel);
			},
			newline() {
				newline(context.indentLevel);
			}
		};
		function newline(n) {
			context.push("\n" + `  `.repeat(n), 0);
		}
		function addMapping(loc, name = null) {
			const { _names, _mappings } = context.map;
			if (name !== null && !_names.has(name)) _names.add(name);
			_mappings.add({
				originalLine: loc.line,
				originalColumn: loc.column - 1,
				generatedLine: context.line,
				generatedColumn: context.column - 1,
				source: filename,
				name
			});
		}
		if (sourceMap) {
			context.map = new sourceMapJs.SourceMapGenerator();
			context.map.setSourceContent(filename, context.source);
			context.map._sources.add(filename);
		}
		return context;
	}
	function generate$3(ast, options = {}) {
		const context = createCodegenContext(ast, options);
		if (options.onContextCreated) options.onContextCreated(context);
		const { mode, push, prefixIdentifiers, indent, deindent: deindent$1, newline, scopeId, ssr } = context;
		const helpers = Array.from(ast.helpers);
		const hasHelpers = helpers.length > 0;
		const useWithBlock = !prefixIdentifiers && mode !== "module";
		const genScopeId = scopeId != null && mode === "module";
		const isSetupInlined = !!options.inline;
		const preambleContext = isSetupInlined ? createCodegenContext(ast, options) : context;
		if (mode === "module") genModulePreamble(ast, preambleContext, genScopeId, isSetupInlined);
		else genFunctionPreamble(ast, preambleContext);
		const functionName = ssr ? `ssrRender` : `render`;
		const args = ssr ? [
			"_ctx",
			"_push",
			"_parent",
			"_attrs"
		] : ["_ctx", "_cache"];
		if (options.bindingMetadata && !options.inline) args.push("$props", "$setup", "$data", "$options");
		const signature = options.isTS ? args.map((arg) => `${arg}: any`).join(",") : args.join(", ");
		if (isSetupInlined) push(`(${signature}) => {`);
		else push(`function ${functionName}(${signature}) {`);
		indent();
		if (useWithBlock) {
			push(`with (_ctx) {`);
			indent();
			if (hasHelpers) {
				push(`const { ${helpers.map(aliasHelper).join(", ")} } = _Vue
`, -1);
				newline();
			}
		}
		if (ast.components.length) {
			genAssets(ast.components, "component", context);
			if (ast.directives.length || ast.temps > 0) newline();
		}
		if (ast.directives.length) {
			genAssets(ast.directives, "directive", context);
			if (ast.temps > 0) newline();
		}
		if (ast.filters && ast.filters.length) {
			newline();
			genAssets(ast.filters, "filter", context);
			newline();
		}
		if (ast.temps > 0) {
			push(`let `);
			for (let i = 0; i < ast.temps; i++) push(`${i > 0 ? `, ` : ``}_temp${i}`);
		}
		if (ast.components.length || ast.directives.length || ast.temps) {
			push(`
`, 0);
			newline();
		}
		if (!ssr) push(`return `);
		if (ast.codegenNode) genNode$1(ast.codegenNode, context);
		else push(`null`);
		if (useWithBlock) {
			deindent$1();
			push(`}`);
		}
		deindent$1();
		push(`}`);
		return {
			ast,
			code: context.code,
			preamble: isSetupInlined ? preambleContext.code : ``,
			map: context.map ? context.map.toJSON() : void 0
		};
	}
	function genFunctionPreamble(ast, context) {
		const { ssr, prefixIdentifiers, push, newline, runtimeModuleName, runtimeGlobalName, ssrRuntimeModuleName } = context;
		const VueBinding = ssr ? `require(${JSON.stringify(runtimeModuleName)})` : runtimeGlobalName;
		const helpers = Array.from(ast.helpers);
		if (helpers.length > 0) if (prefixIdentifiers) push(`const { ${helpers.map(aliasHelper).join(", ")} } = ${VueBinding}
`, -1);
		else {
			push(`const _Vue = ${VueBinding}
`, -1);
			if (ast.hoists.length) {
				const staticHelpers = [
					CREATE_VNODE,
					CREATE_ELEMENT_VNODE,
					CREATE_COMMENT,
					CREATE_TEXT,
					CREATE_STATIC
				].filter((helper) => helpers.includes(helper)).map(aliasHelper).join(", ");
				push(`const { ${staticHelpers} } = _Vue
`, -1);
			}
		}
		if (ast.ssrHelpers && ast.ssrHelpers.length) push(`const { ${ast.ssrHelpers.map(aliasHelper).join(", ")} } = require("${ssrRuntimeModuleName}")
`, -1);
		genHoists(ast.hoists, context);
		newline();
		push(`return `);
	}
	function genModulePreamble(ast, context, genScopeId, inline) {
		const { push, newline, optimizeImports, runtimeModuleName, ssrRuntimeModuleName } = context;
		if (ast.helpers.size) {
			const helpers = Array.from(ast.helpers);
			if (optimizeImports) {
				push(`import { ${helpers.map((s) => helperNameMap[s]).join(", ")} } from ${JSON.stringify(runtimeModuleName)}
`, -1);
				push(`
// Binding optimization for webpack code-split
const ${helpers.map((s) => `_${helperNameMap[s]} = ${helperNameMap[s]}`).join(", ")}
`, -1);
			} else push(`import { ${helpers.map((s) => `${helperNameMap[s]} as _${helperNameMap[s]}`).join(", ")} } from ${JSON.stringify(runtimeModuleName)}
`, -1);
		}
		if (ast.ssrHelpers && ast.ssrHelpers.length) push(`import { ${ast.ssrHelpers.map((s) => `${helperNameMap[s]} as _${helperNameMap[s]}`).join(", ")} } from "${ssrRuntimeModuleName}"
`, -1);
		if (ast.imports.length) {
			genImports(ast.imports, context);
			newline();
		}
		genHoists(ast.hoists, context);
		newline();
		if (!inline) push(`export `);
	}
	function genAssets(assets, type, { helper, push, newline, isTS }) {
		const resolver = helper(type === "filter" ? RESOLVE_FILTER : type === "component" ? RESOLVE_COMPONENT : RESOLVE_DIRECTIVE);
		for (let i = 0; i < assets.length; i++) {
			let id = assets[i];
			const maybeSelfReference = id.endsWith("__self");
			if (maybeSelfReference) id = id.slice(0, -6);
			push(`const ${toValidAssetId(id, type)} = ${resolver}(${JSON.stringify(id)}${maybeSelfReference ? `, true` : ``})${isTS ? `!` : ``}`);
			if (i < assets.length - 1) newline();
		}
	}
	function genHoists(hoists, context) {
		if (!hoists.length) return;
		context.pure = true;
		const { push, newline } = context;
		newline();
		for (let i = 0; i < hoists.length; i++) {
			const exp = hoists[i];
			if (exp) {
				push(`const _hoisted_${i + 1} = `);
				genNode$1(exp, context);
				newline();
			}
		}
		context.pure = false;
	}
	function genImports(importsOptions, context) {
		if (!importsOptions.length) return;
		importsOptions.forEach((imports) => {
			context.push(`import `);
			genNode$1(imports.exp, context);
			context.push(` from '${imports.path}'`);
			context.newline();
		});
	}
	function isText(n) {
		return shared$1.isString(n) || n.type === 4 || n.type === 2 || n.type === 5 || n.type === 8;
	}
	function genNodeListAsArray(nodes, context) {
		const multilines = nodes.length > 3 || nodes.some((n) => shared$1.isArray(n) || !isText(n));
		context.push(`[`);
		multilines && context.indent();
		genNodeList(nodes, context, multilines);
		multilines && context.deindent();
		context.push(`]`);
	}
	function genNodeList(nodes, context, multilines = false, comma = true) {
		const { push, newline } = context;
		for (let i = 0; i < nodes.length; i++) {
			const node = nodes[i];
			if (shared$1.isString(node)) push(node, -3);
			else if (shared$1.isArray(node)) genNodeListAsArray(node, context);
			else genNode$1(node, context);
			if (i < nodes.length - 1) if (multilines) {
				comma && push(",");
				newline();
			} else comma && push(", ");
		}
	}
	function genNode$1(node, context) {
		if (shared$1.isString(node)) {
			context.push(node, -3);
			return;
		}
		if (shared$1.isSymbol(node)) {
			context.push(context.helper(node));
			return;
		}
		switch (node.type) {
			case 1:
			case 9:
			case 11:
				genNode$1(node.codegenNode, context);
				break;
			case 2:
				genText$1(node, context);
				break;
			case 4:
				genExpression(node, context);
				break;
			case 5:
				genInterpolation(node, context);
				break;
			case 12:
				genNode$1(node.codegenNode, context);
				break;
			case 8:
				genCompoundExpression(node, context);
				break;
			case 3:
				genComment$1(node, context);
				break;
			case 13:
				genVNodeCall(node, context);
				break;
			case 14:
				genCallExpression(node, context);
				break;
			case 15:
				genObjectExpression(node, context);
				break;
			case 17:
				genArrayExpression(node, context);
				break;
			case 18:
				genFunctionExpression(node, context);
				break;
			case 19:
				genConditionalExpression(node, context);
				break;
			case 20:
				genCacheExpression(node, context);
				break;
			case 21:
				genNodeList(node.body, context, true, false);
				break;
			case 22:
				genTemplateLiteral(node, context);
				break;
			case 23:
				genIfStatement(node, context);
				break;
			case 24:
				genAssignmentExpression(node, context);
				break;
			case 25:
				genSequenceExpression(node, context);
				break;
			case 26:
				genReturnStatement(node, context);
				break;
		}
	}
	function genText$1(node, context) {
		context.push(JSON.stringify(node.content), -3, node);
	}
	function genExpression(node, context) {
		const { content, isStatic: isStatic$1 } = node;
		context.push(isStatic$1 ? JSON.stringify(content) : content, -3, node);
	}
	function genInterpolation(node, context) {
		const { push, helper, pure } = context;
		if (pure) push(PURE_ANNOTATION);
		push(`${helper(TO_DISPLAY_STRING)}(`);
		genNode$1(node.content, context);
		push(`)`);
	}
	function genCompoundExpression(node, context) {
		for (let i = 0; i < node.children.length; i++) {
			const child = node.children[i];
			if (shared$1.isString(child)) context.push(child, -3);
			else genNode$1(child, context);
		}
	}
	function genExpressionAsPropertyKey(node, context) {
		const { push } = context;
		if (node.type === 8) {
			push(`[`);
			genCompoundExpression(node, context);
			push(`]`);
		} else if (node.isStatic) {
			const text$1 = isSimpleIdentifier(node.content) ? node.content : JSON.stringify(node.content);
			push(text$1, -2, node);
		} else push(`[${node.content}]`, -3, node);
	}
	function genComment$1(node, context) {
		const { push, helper, pure } = context;
		if (pure) push(PURE_ANNOTATION);
		push(`${helper(CREATE_COMMENT)}(${JSON.stringify(node.content)})`, -3, node);
	}
	function genVNodeCall(node, context) {
		const { push, helper, pure } = context;
		const { tag, props, children, patchFlag, dynamicProps, directives: directives$1, isBlock, disableTracking, isComponent: isComponent$1 } = node;
		let patchFlagString;
		if (patchFlag) patchFlagString = String(patchFlag);
		if (directives$1) push(helper(WITH_DIRECTIVES) + `(`);
		if (isBlock) push(`(${helper(OPEN_BLOCK)}(${disableTracking ? `true` : ``}), `);
		if (pure) push(PURE_ANNOTATION);
		const callHelper = isBlock ? getVNodeBlockHelper(context.inSSR, isComponent$1) : getVNodeHelper(context.inSSR, isComponent$1);
		push(helper(callHelper) + `(`, -2, node);
		genNodeList(genNullableArgs([
			tag,
			props,
			children,
			patchFlagString,
			dynamicProps
		]), context);
		push(`)`);
		if (isBlock) push(`)`);
		if (directives$1) {
			push(`, `);
			genNode$1(directives$1, context);
			push(`)`);
		}
	}
	function genNullableArgs(args) {
		let i = args.length;
		while (i--) if (args[i] != null) break;
		return args.slice(0, i + 1).map((arg) => arg || `null`);
	}
	function genCallExpression(node, context) {
		const { push, helper, pure } = context;
		const callee = shared$1.isString(node.callee) ? node.callee : helper(node.callee);
		if (pure) push(PURE_ANNOTATION);
		push(callee + `(`, -2, node);
		genNodeList(node.arguments, context);
		push(`)`);
	}
	function genObjectExpression(node, context) {
		const { push, indent, deindent: deindent$1, newline } = context;
		const { properties } = node;
		if (!properties.length) {
			push(`{}`, -2, node);
			return;
		}
		const multilines = properties.length > 1 || properties.some((p) => p.value.type !== 4);
		push(multilines ? `{` : `{ `);
		multilines && indent();
		for (let i = 0; i < properties.length; i++) {
			const { key, value } = properties[i];
			genExpressionAsPropertyKey(key, context);
			push(`: `);
			genNode$1(value, context);
			if (i < properties.length - 1) {
				push(`,`);
				newline();
			}
		}
		multilines && deindent$1();
		push(multilines ? `}` : ` }`);
	}
	function genArrayExpression(node, context) {
		genNodeListAsArray(node.elements, context);
	}
	function genFunctionExpression(node, context) {
		const { push, indent, deindent: deindent$1 } = context;
		const { params, returns, body, newline, isSlot } = node;
		if (isSlot) push(`_${helperNameMap[WITH_CTX]}(`);
		push(`(`, -2, node);
		if (shared$1.isArray(params)) genNodeList(params, context);
		else if (params) genNode$1(params, context);
		push(`) => `);
		if (newline || body) {
			push(`{`);
			indent();
		}
		if (returns) {
			if (newline) push(`return `);
			if (shared$1.isArray(returns)) genNodeListAsArray(returns, context);
			else genNode$1(returns, context);
		} else if (body) genNode$1(body, context);
		if (newline || body) {
			deindent$1();
			push(`}`);
		}
		if (isSlot) {
			if (node.isNonScopedSlot) push(`, undefined, true`);
			push(`)`);
		}
	}
	function genConditionalExpression(node, context) {
		const { test, consequent, alternate, newline: needNewline } = node;
		const { push, indent, deindent: deindent$1, newline } = context;
		if (test.type === 4) {
			const needsParens = !isSimpleIdentifier(test.content);
			needsParens && push(`(`);
			genExpression(test, context);
			needsParens && push(`)`);
		} else {
			push(`(`);
			genNode$1(test, context);
			push(`)`);
		}
		needNewline && indent();
		context.indentLevel++;
		needNewline || push(` `);
		push(`? `);
		genNode$1(consequent, context);
		context.indentLevel--;
		needNewline && newline();
		needNewline || push(` `);
		push(`: `);
		const isNested = alternate.type === 19;
		if (!isNested) context.indentLevel++;
		genNode$1(alternate, context);
		if (!isNested) context.indentLevel--;
		needNewline && deindent$1(true);
	}
	function genCacheExpression(node, context) {
		const { push, helper, indent, deindent: deindent$1, newline } = context;
		const { needPauseTracking, needArraySpread } = node;
		if (needArraySpread) push(`[...(`);
		push(`_cache[${node.index}] || (`);
		if (needPauseTracking) {
			indent();
			push(`${helper(SET_BLOCK_TRACKING)}(-1`);
			if (node.inVOnce) push(`, true`);
			push(`),`);
			newline();
			push(`(`);
		}
		push(`_cache[${node.index}] = `);
		genNode$1(node.value, context);
		if (needPauseTracking) {
			push(`).cacheIndex = ${node.index},`);
			newline();
			push(`${helper(SET_BLOCK_TRACKING)}(1),`);
			newline();
			push(`_cache[${node.index}]`);
			deindent$1();
		}
		push(`)`);
		if (needArraySpread) push(`)]`);
	}
	function genTemplateLiteral(node, context) {
		const { push, indent, deindent: deindent$1 } = context;
		push("`");
		const l = node.elements.length;
		const multilines = l > 3;
		for (let i = 0; i < l; i++) {
			const e = node.elements[i];
			if (shared$1.isString(e)) push(e.replace(/(`|\$|\\)/g, "\\$1"), -3);
			else {
				push("${");
				if (multilines) indent();
				genNode$1(e, context);
				if (multilines) deindent$1();
				push("}");
			}
		}
		push("`");
	}
	function genIfStatement(node, context) {
		const { push, indent, deindent: deindent$1 } = context;
		const { test, consequent, alternate } = node;
		push(`if (`);
		genNode$1(test, context);
		push(`) {`);
		indent();
		genNode$1(consequent, context);
		deindent$1();
		push(`}`);
		if (alternate) {
			push(` else `);
			if (alternate.type === 23) genIfStatement(alternate, context);
			else {
				push(`{`);
				indent();
				genNode$1(alternate, context);
				deindent$1();
				push(`}`);
			}
		}
	}
	function genAssignmentExpression(node, context) {
		genNode$1(node.left, context);
		context.push(` = `);
		genNode$1(node.right, context);
	}
	function genSequenceExpression(node, context) {
		context.push(`(`);
		genNodeList(node.expressions, context);
		context.push(`)`);
	}
	function genReturnStatement({ returns }, context) {
		context.push(`return `);
		if (shared$1.isArray(returns)) genNodeListAsArray(returns, context);
		else genNode$1(returns, context);
	}
	const isLiteralWhitelisted$1 = /* @__PURE__ */ shared$1.makeMap("true,false,null,this");
	const transformExpression = (node, context) => {
		if (node.type === 5) node.content = processExpression(node.content, context);
		else if (node.type === 1) {
			const memo = findDir(node, "memo");
			for (let i = 0; i < node.props.length; i++) {
				const dir = node.props[i];
				if (dir.type === 7 && dir.name !== "for") {
					const exp = dir.exp;
					const arg = dir.arg;
					if (exp && exp.type === 4 && !(dir.name === "on" && arg) && !(memo && arg && arg.type === 4 && arg.content === "key")) dir.exp = processExpression(exp, context, dir.name === "slot");
					if (arg && arg.type === 4 && !arg.isStatic) dir.arg = processExpression(arg, context);
				}
			}
		}
	};
	function processExpression(node, context, asParams = false, asRawStatements = false, localVars = Object.create(context.identifiers)) {
		if (!context.prefixIdentifiers || !node.content.trim()) return node;
		const { inline, bindingMetadata } = context;
		const rewriteIdentifier = (raw$1, parent, id) => {
			const type = shared$1.hasOwn(bindingMetadata, raw$1) && bindingMetadata[raw$1];
			if (inline) {
				const isAssignmentLVal = parent && parent.type === "AssignmentExpression" && parent.left === id;
				const isUpdateArg = parent && parent.type === "UpdateExpression" && parent.argument === id;
				const isDestructureAssignment = parent && isInDestructureAssignment(parent, parentStack);
				const isNewExpression = parent && isInNewExpression(parentStack);
				const wrapWithUnref = (raw2) => {
					const wrapped = `${context.helperString(UNREF)}(${raw2})`;
					return isNewExpression ? `(${wrapped})` : wrapped;
				};
				if (isConst(type) || type === "setup-reactive-const" || localVars[raw$1]) return raw$1;
				else if (type === "setup-ref") return `${raw$1}.value`;
				else if (type === "setup-maybe-ref") return isAssignmentLVal || isUpdateArg || isDestructureAssignment ? `${raw$1}.value` : wrapWithUnref(raw$1);
				else if (type === "setup-let") if (isAssignmentLVal) {
					const { right: rVal, operator } = parent;
					const rExp = rawExp.slice(rVal.start - 1, rVal.end - 1);
					const rExpString = stringifyExpression(processExpression(createSimpleExpression(rExp, false), context, false, false, knownIds));
					return `${context.helperString(IS_REF)}(${raw$1})${context.isTS ? ` //@ts-ignore
` : ``} ? ${raw$1}.value ${operator} ${rExpString} : ${raw$1}`;
				} else if (isUpdateArg) {
					id.start = parent.start;
					id.end = parent.end;
					const { prefix: isPrefix, operator } = parent;
					const prefix$1 = isPrefix ? operator : ``;
					const postfix$1 = isPrefix ? `` : operator;
					return `${context.helperString(IS_REF)}(${raw$1})${context.isTS ? ` //@ts-ignore
` : ``} ? ${prefix$1}${raw$1}.value${postfix$1} : ${prefix$1}${raw$1}${postfix$1}`;
				} else if (isDestructureAssignment) return raw$1;
				else return wrapWithUnref(raw$1);
				else if (type === "props") return shared$1.genPropsAccessExp(raw$1);
				else if (type === "props-aliased") return shared$1.genPropsAccessExp(bindingMetadata.__propsAliases[raw$1]);
			} else if (type && type.startsWith("setup") || type === "literal-const") return `$setup.${raw$1}`;
			else if (type === "props-aliased") return `$props['${bindingMetadata.__propsAliases[raw$1]}']`;
			else if (type) return `$${type}.${raw$1}`;
			return `_ctx.${raw$1}`;
		};
		const rawExp = node.content;
		let ast = node.ast;
		if (ast === false) return node;
		if (ast === null || !ast && isSimpleIdentifier(rawExp)) {
			const isScopeVarReference = context.identifiers[rawExp];
			const isAllowedGlobal = shared$1.isGloballyAllowed(rawExp);
			const isLiteral = isLiteralWhitelisted$1(rawExp);
			if (!asParams && !isScopeVarReference && !isLiteral && (!isAllowedGlobal || bindingMetadata[rawExp])) {
				if (isConst(bindingMetadata[rawExp])) node.constType = 1;
				node.content = rewriteIdentifier(rawExp);
			} else if (!isScopeVarReference) if (isLiteral) node.constType = 3;
			else node.constType = 2;
			return node;
		}
		if (!ast) {
			const source = asRawStatements ? ` ${rawExp} ` : `(${rawExp})${asParams ? `=>{}` : ``}`;
			try {
				ast = parser.parseExpression(source, {
					sourceType: "module",
					plugins: context.expressionPlugins
				});
			} catch (e) {
				context.onError(createCompilerError(45, node.loc, void 0, e.message));
				return node;
			}
		}
		const ids = [];
		const parentStack = [];
		const knownIds = Object.create(context.identifiers);
		walkIdentifiers$1(ast, (node2, parent, _, isReferenced$1, isLocal) => {
			if (isStaticPropertyKey(node2, parent)) return;
			if (node2.name.startsWith("_filter_")) return;
			const needPrefix = isReferenced$1 && canPrefix(node2);
			if (needPrefix && !isLocal) {
				if (isStaticProperty(parent) && parent.shorthand) node2.prefix = `${node2.name}: `;
				node2.name = rewriteIdentifier(node2.name, parent, node2);
				ids.push(node2);
			} else {
				if (!(needPrefix && isLocal) && (!parent || parent.type !== "CallExpression" && parent.type !== "NewExpression" && parent.type !== "MemberExpression")) node2.isConstant = true;
				ids.push(node2);
			}
		}, true, parentStack, knownIds);
		const children = [];
		ids.sort((a, b) => a.start - b.start);
		ids.forEach((id, i) => {
			const start = id.start - 1;
			const end = id.end - 1;
			const last = ids[i - 1];
			const leadingText = rawExp.slice(last ? last.end - 1 : 0, start);
			if (leadingText.length || id.prefix) children.push(leadingText + (id.prefix || ``));
			const source = rawExp.slice(start, end);
			children.push(createSimpleExpression(id.name, false, {
				start: advancePositionWithClone(node.loc.start, source, start),
				end: advancePositionWithClone(node.loc.start, source, end),
				source
			}, id.isConstant ? 3 : 0));
			if (i === ids.length - 1 && end < rawExp.length) children.push(rawExp.slice(end));
		});
		let ret;
		if (children.length) {
			ret = createCompoundExpression(children, node.loc);
			ret.ast = ast;
		} else {
			ret = node;
			ret.constType = 3;
		}
		ret.identifiers = Object.keys(knownIds);
		return ret;
	}
	function canPrefix(id) {
		if (shared$1.isGloballyAllowed(id.name)) return false;
		if (id.name === "require") return false;
		return true;
	}
	function stringifyExpression(exp) {
		if (shared$1.isString(exp)) return exp;
		else if (exp.type === 4) return exp.content;
		else return exp.children.map(stringifyExpression).join("");
	}
	function isConst(type) {
		return type === "setup-const" || type === "literal-const";
	}
	const transformIf = createStructuralDirectiveTransform(/^(if|else|else-if)$/, (node, dir, context) => {
		return processIf$1(node, dir, context, (ifNode, branch, isRoot) => {
			const siblings = context.parent.children;
			let i = siblings.indexOf(ifNode);
			let key = 0;
			while (i-- >= 0) {
				const sibling = siblings[i];
				if (sibling && sibling.type === 9) key += sibling.branches.length;
			}
			return () => {
				if (isRoot) ifNode.codegenNode = createCodegenNodeForBranch(branch, key, context);
				else {
					const parentCondition = getParentCondition(ifNode.codegenNode);
					parentCondition.alternate = createCodegenNodeForBranch(branch, key + ifNode.branches.length - 1, context);
				}
			};
		});
	});
	function processIf$1(node, dir, context, processCodegen) {
		if (dir.name !== "else" && (!dir.exp || !dir.exp.content.trim())) {
			const loc = dir.exp ? dir.exp.loc : node.loc;
			context.onError(createCompilerError(28, dir.loc));
			dir.exp = createSimpleExpression(`true`, false, loc);
		}
		if (context.prefixIdentifiers && dir.exp) dir.exp = processExpression(dir.exp, context);
		if (dir.name === "if") {
			const branch = createIfBranch(node, dir);
			const ifNode = {
				type: 9,
				loc: cloneLoc(node.loc),
				branches: [branch]
			};
			context.replaceNode(ifNode);
			if (processCodegen) return processCodegen(ifNode, branch, true);
		} else {
			const siblings = context.parent.children;
			let i = siblings.indexOf(node);
			while (i-- >= -1) {
				const sibling = siblings[i];
				if (sibling && sibling.type === 3) {
					context.removeNode(sibling);
					continue;
				}
				if (sibling && sibling.type === 2 && !sibling.content.trim().length) {
					context.removeNode(sibling);
					continue;
				}
				if (sibling && sibling.type === 9) {
					if (dir.name === "else-if" && sibling.branches[sibling.branches.length - 1].condition === void 0) context.onError(createCompilerError(30, node.loc));
					context.removeNode();
					const branch = createIfBranch(node, dir);
					{
						const key = branch.userKey;
						if (key) sibling.branches.forEach(({ userKey }) => {
							if (isSameKey(userKey, key)) context.onError(createCompilerError(29, branch.userKey.loc));
						});
					}
					sibling.branches.push(branch);
					const onExit = processCodegen && processCodegen(sibling, branch, false);
					traverseNode(branch, context);
					if (onExit) onExit();
					context.currentNode = null;
				} else context.onError(createCompilerError(30, node.loc));
				break;
			}
		}
	}
	function createIfBranch(node, dir) {
		const isTemplateIf = node.tagType === 3;
		return {
			type: 10,
			loc: node.loc,
			condition: dir.name === "else" ? void 0 : dir.exp,
			children: isTemplateIf && !findDir(node, "for") ? node.children : [node],
			userKey: findProp(node, `key`),
			isTemplateIf
		};
	}
	function createCodegenNodeForBranch(branch, keyIndex, context) {
		if (branch.condition) return createConditionalExpression(branch.condition, createChildrenCodegenNode(branch, keyIndex, context), createCallExpression(context.helper(CREATE_COMMENT), ["\"\"", "true"]));
		else return createChildrenCodegenNode(branch, keyIndex, context);
	}
	function createChildrenCodegenNode(branch, keyIndex, context) {
		const { helper } = context;
		const keyProperty = createObjectProperty(`key`, createSimpleExpression(`${keyIndex}`, false, locStub, 2));
		const { children } = branch;
		const firstChild = children[0];
		const needFragmentWrapper = children.length !== 1 || firstChild.type !== 1;
		if (needFragmentWrapper) if (children.length === 1 && firstChild.type === 11) {
			const vnodeCall = firstChild.codegenNode;
			injectProp(vnodeCall, keyProperty, context);
			return vnodeCall;
		} else {
			let patchFlag = 64;
			return createVNodeCall(context, helper(FRAGMENT), createObjectExpression([keyProperty]), children, patchFlag, void 0, void 0, true, false, false, branch.loc);
		}
		else {
			const ret = firstChild.codegenNode;
			const vnodeCall = getMemoedVNodeCall(ret);
			if (vnodeCall.type === 13) convertToBlock(vnodeCall, context);
			injectProp(vnodeCall, keyProperty, context);
			return ret;
		}
	}
	function isSameKey(a, b) {
		if (!a || a.type !== b.type) return false;
		if (a.type === 6) {
			if (a.value.content !== b.value.content) return false;
		} else {
			const exp = a.exp;
			const branchExp = b.exp;
			if (exp.type !== branchExp.type) return false;
			if (exp.type !== 4 || exp.isStatic !== branchExp.isStatic || exp.content !== branchExp.content) return false;
		}
		return true;
	}
	function getParentCondition(node) {
		while (true) if (node.type === 19) if (node.alternate.type === 19) node = node.alternate;
		else return node;
		else if (node.type === 20) node = node.value;
	}
	const transformBind = (dir, _node, context) => {
		const { modifiers, loc } = dir;
		const arg = dir.arg;
		let { exp } = dir;
		if (exp && exp.type === 4 && !exp.content.trim()) {
			context.onError(createCompilerError(34, loc));
			return { props: [createObjectProperty(arg, createSimpleExpression("", true, loc))] };
		}
		if (!exp) {
			if (arg.type !== 4 || !arg.isStatic) {
				context.onError(createCompilerError(52, arg.loc));
				return { props: [createObjectProperty(arg, createSimpleExpression("", true, loc))] };
			}
			transformBindShorthand(dir, context);
			exp = dir.exp;
		}
		if (arg.type !== 4) {
			arg.children.unshift(`(`);
			arg.children.push(`) || ""`);
		} else if (!arg.isStatic) arg.content = `${arg.content} || ""`;
		if (modifiers.some((mod) => mod.content === "camel")) if (arg.type === 4) if (arg.isStatic) arg.content = shared$1.camelize(arg.content);
		else arg.content = `${context.helperString(CAMELIZE)}(${arg.content})`;
		else {
			arg.children.unshift(`${context.helperString(CAMELIZE)}(`);
			arg.children.push(`)`);
		}
		if (!context.inSSR) {
			if (modifiers.some((mod) => mod.content === "prop")) injectPrefix(arg, ".");
			if (modifiers.some((mod) => mod.content === "attr")) injectPrefix(arg, "^");
		}
		return { props: [createObjectProperty(arg, exp)] };
	};
	const transformBindShorthand = (dir, context) => {
		const arg = dir.arg;
		const propName = shared$1.camelize(arg.content);
		dir.exp = createSimpleExpression(propName, false, arg.loc);
		dir.exp = processExpression(dir.exp, context);
	};
	const injectPrefix = (arg, prefix$1) => {
		if (arg.type === 4) if (arg.isStatic) arg.content = prefix$1 + arg.content;
		else arg.content = `\`${prefix$1}\${${arg.content}}\``;
		else {
			arg.children.unshift(`'${prefix$1}' + (`);
			arg.children.push(`)`);
		}
	};
	const transformFor = createStructuralDirectiveTransform("for", (node, dir, context) => {
		const { helper, removeHelper } = context;
		return processFor$1(node, dir, context, (forNode) => {
			const renderExp = createCallExpression(helper(RENDER_LIST), [forNode.source]);
			const isTemplate = isTemplateNode(node);
			const memo = findDir(node, "memo");
			const keyProp = findProp(node, `key`, false, true);
			const isDirKey = keyProp && keyProp.type === 7;
			if (isDirKey && !keyProp.exp) transformBindShorthand(keyProp, context);
			let keyExp = keyProp && (keyProp.type === 6 ? keyProp.value ? createSimpleExpression(keyProp.value.content, true) : void 0 : keyProp.exp);
			if (memo && keyExp && isDirKey) keyProp.exp = keyExp = processExpression(keyExp, context);
			const keyProperty = keyProp && keyExp ? createObjectProperty(`key`, keyExp) : null;
			if (isTemplate) {
				if (memo) memo.exp = processExpression(memo.exp, context);
				if (keyProperty && keyProp.type !== 6) keyProperty.value = processExpression(keyProperty.value, context);
			}
			const isStableFragment = forNode.source.type === 4 && forNode.source.constType > 0;
			const fragmentFlag = isStableFragment ? 64 : keyProp ? 128 : 256;
			forNode.codegenNode = createVNodeCall(context, helper(FRAGMENT), void 0, renderExp, fragmentFlag, void 0, void 0, true, !isStableFragment, false, node.loc);
			return () => {
				let childBlock;
				const { children } = forNode;
				if (isTemplate) node.children.some((c) => {
					if (c.type === 1) {
						const key = findProp(c, "key");
						if (key) {
							context.onError(createCompilerError(33, key.loc));
							return true;
						}
					}
				});
				const needFragmentWrapper = children.length !== 1 || children[0].type !== 1;
				const slotOutlet = isSlotOutlet(node) ? node : isTemplate && node.children.length === 1 && isSlotOutlet(node.children[0]) ? node.children[0] : null;
				if (slotOutlet) {
					childBlock = slotOutlet.codegenNode;
					if (isTemplate && keyProperty) injectProp(childBlock, keyProperty, context);
				} else if (needFragmentWrapper) childBlock = createVNodeCall(context, helper(FRAGMENT), keyProperty ? createObjectExpression([keyProperty]) : void 0, node.children, 64, void 0, void 0, true, void 0, false);
				else {
					childBlock = children[0].codegenNode;
					if (isTemplate && keyProperty) injectProp(childBlock, keyProperty, context);
					if (childBlock.isBlock !== !isStableFragment) if (childBlock.isBlock) {
						removeHelper(OPEN_BLOCK);
						removeHelper(getVNodeBlockHelper(context.inSSR, childBlock.isComponent));
					} else removeHelper(getVNodeHelper(context.inSSR, childBlock.isComponent));
					childBlock.isBlock = !isStableFragment;
					if (childBlock.isBlock) {
						helper(OPEN_BLOCK);
						helper(getVNodeBlockHelper(context.inSSR, childBlock.isComponent));
					} else helper(getVNodeHelper(context.inSSR, childBlock.isComponent));
				}
				if (memo) {
					const loop = createFunctionExpression(createForLoopParams(forNode.parseResult, [createSimpleExpression(`_cached`)]));
					loop.body = createBlockStatement([
						createCompoundExpression([
							`const _memo = (`,
							memo.exp,
							`)`
						]),
						createCompoundExpression([
							`if (_cached`,
							...keyExp ? [` && _cached.key === `, keyExp] : [],
							` && ${context.helperString(IS_MEMO_SAME)}(_cached, _memo)) return _cached`
						]),
						createCompoundExpression([`const _item = `, childBlock]),
						createSimpleExpression(`_item.memo = _memo`),
						createSimpleExpression(`return _item`)
					]);
					renderExp.arguments.push(loop, createSimpleExpression(`_cache`), createSimpleExpression(String(context.cached.length)));
					context.cached.push(null);
				} else renderExp.arguments.push(createFunctionExpression(createForLoopParams(forNode.parseResult), childBlock, true));
			};
		});
	});
	function processFor$1(node, dir, context, processCodegen) {
		if (!dir.exp) {
			context.onError(createCompilerError(31, dir.loc));
			return;
		}
		const parseResult = dir.forParseResult;
		if (!parseResult) {
			context.onError(createCompilerError(32, dir.loc));
			return;
		}
		finalizeForParseResult(parseResult, context);
		const { addIdentifiers, removeIdentifiers, scopes } = context;
		const { source, value, key, index: index$1 } = parseResult;
		const forNode = {
			type: 11,
			loc: dir.loc,
			source,
			valueAlias: value,
			keyAlias: key,
			objectIndexAlias: index$1,
			parseResult,
			children: isTemplateNode(node) ? node.children : [node]
		};
		context.replaceNode(forNode);
		scopes.vFor++;
		if (context.prefixIdentifiers) {
			value && addIdentifiers(value);
			key && addIdentifiers(key);
			index$1 && addIdentifiers(index$1);
		}
		const onExit = processCodegen && processCodegen(forNode);
		return () => {
			scopes.vFor--;
			if (context.prefixIdentifiers) {
				value && removeIdentifiers(value);
				key && removeIdentifiers(key);
				index$1 && removeIdentifiers(index$1);
			}
			if (onExit) onExit();
		};
	}
	function finalizeForParseResult(result, context) {
		if (result.finalized) return;
		if (context.prefixIdentifiers) {
			result.source = processExpression(result.source, context);
			if (result.key) result.key = processExpression(result.key, context, true);
			if (result.index) result.index = processExpression(result.index, context, true);
			if (result.value) result.value = processExpression(result.value, context, true);
		}
		result.finalized = true;
	}
	function createForLoopParams({ value, key, index: index$1 }, memoArgs = []) {
		return createParamsList([
			value,
			key,
			index$1,
			...memoArgs
		]);
	}
	function createParamsList(args) {
		let i = args.length;
		while (i--) if (args[i]) break;
		return args.slice(0, i + 1).map((arg, i2) => arg || createSimpleExpression(`_`.repeat(i2 + 1), false));
	}
	const defaultFallback = createSimpleExpression(`undefined`, false);
	const trackSlotScopes = (node, context) => {
		if (node.type === 1 && (node.tagType === 1 || node.tagType === 3)) {
			const vSlot = findDir(node, "slot");
			if (vSlot) {
				const slotProps = vSlot.exp;
				if (context.prefixIdentifiers) slotProps && context.addIdentifiers(slotProps);
				context.scopes.vSlot++;
				return () => {
					if (context.prefixIdentifiers) slotProps && context.removeIdentifiers(slotProps);
					context.scopes.vSlot--;
				};
			}
		}
	};
	const trackVForSlotScopes = (node, context) => {
		let vFor;
		if (isTemplateNode(node) && node.props.some(isVSlot) && (vFor = findDir(node, "for"))) {
			const result = vFor.forParseResult;
			if (result) {
				finalizeForParseResult(result, context);
				const { value, key, index: index$1 } = result;
				const { addIdentifiers, removeIdentifiers } = context;
				value && addIdentifiers(value);
				key && addIdentifiers(key);
				index$1 && addIdentifiers(index$1);
				return () => {
					value && removeIdentifiers(value);
					key && removeIdentifiers(key);
					index$1 && removeIdentifiers(index$1);
				};
			}
		}
	};
	const buildClientSlotFn = (props, _vForExp, children, loc) => createFunctionExpression(props, children, false, true, children.length ? children[0].loc : loc);
	function buildSlots(node, context, buildSlotFn = buildClientSlotFn) {
		context.helper(WITH_CTX);
		const { children, loc } = node;
		const slotsProperties = [];
		const dynamicSlots = [];
		let hasDynamicSlots = context.scopes.vSlot > 0 || context.scopes.vFor > 0;
		if (!context.ssr && context.prefixIdentifiers) hasDynamicSlots = hasScopeRef(node, context.identifiers);
		const onComponentSlot = findDir(node, "slot", true);
		if (onComponentSlot) {
			const { arg, exp } = onComponentSlot;
			if (arg && !isStaticExp(arg)) hasDynamicSlots = true;
			slotsProperties.push(createObjectProperty(arg || createSimpleExpression("default", true), buildSlotFn(exp, void 0, children, loc)));
		}
		let hasTemplateSlots = false;
		let hasNamedDefaultSlot = false;
		const implicitDefaultChildren = [];
		const seenSlotNames = /* @__PURE__ */ new Set();
		let conditionalBranchIndex = 0;
		for (let i = 0; i < children.length; i++) {
			const slotElement = children[i];
			let slotDir;
			if (!isTemplateNode(slotElement) || !(slotDir = findDir(slotElement, "slot", true))) {
				if (slotElement.type !== 3) implicitDefaultChildren.push(slotElement);
				continue;
			}
			if (onComponentSlot) {
				context.onError(createCompilerError(37, slotDir.loc));
				break;
			}
			hasTemplateSlots = true;
			const { children: slotChildren, loc: slotLoc } = slotElement;
			const { arg: slotName = createSimpleExpression(`default`, true), exp: slotProps, loc: dirLoc } = slotDir;
			let staticSlotName;
			if (isStaticExp(slotName)) staticSlotName = slotName ? slotName.content : `default`;
			else hasDynamicSlots = true;
			const vFor = findDir(slotElement, "for");
			const slotFunction = buildSlotFn(slotProps, vFor, slotChildren, slotLoc);
			let vIf;
			let vElse;
			if (vIf = findDir(slotElement, "if")) {
				hasDynamicSlots = true;
				dynamicSlots.push(createConditionalExpression(vIf.exp, buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++), defaultFallback));
			} else if (vElse = findDir(slotElement, /^else(-if)?$/, true)) {
				let j = i;
				let prev;
				while (j--) {
					prev = children[j];
					if (prev.type !== 3 && isNonWhitespaceContent(prev)) break;
				}
				if (prev && isTemplateNode(prev) && findDir(prev, /^(else-)?if$/)) {
					let conditional = dynamicSlots[dynamicSlots.length - 1];
					while (conditional.alternate.type === 19) conditional = conditional.alternate;
					conditional.alternate = vElse.exp ? createConditionalExpression(vElse.exp, buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++), defaultFallback) : buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++);
				} else context.onError(createCompilerError(30, vElse.loc));
			} else if (vFor) {
				hasDynamicSlots = true;
				const parseResult = vFor.forParseResult;
				if (parseResult) {
					finalizeForParseResult(parseResult, context);
					dynamicSlots.push(createCallExpression(context.helper(RENDER_LIST), [parseResult.source, createFunctionExpression(createForLoopParams(parseResult), buildDynamicSlot(slotName, slotFunction), true)]));
				} else context.onError(createCompilerError(32, vFor.loc));
			} else {
				if (staticSlotName) {
					if (seenSlotNames.has(staticSlotName)) {
						context.onError(createCompilerError(38, dirLoc));
						continue;
					}
					seenSlotNames.add(staticSlotName);
					if (staticSlotName === "default") hasNamedDefaultSlot = true;
				}
				slotsProperties.push(createObjectProperty(slotName, slotFunction));
			}
		}
		if (!onComponentSlot) {
			const buildDefaultSlotProperty = (props, children2) => {
				const fn = buildSlotFn(props, void 0, children2, loc);
				if (context.compatConfig) fn.isNonScopedSlot = true;
				return createObjectProperty(`default`, fn);
			};
			if (!hasTemplateSlots) slotsProperties.push(buildDefaultSlotProperty(void 0, children));
			else if (implicitDefaultChildren.length && implicitDefaultChildren.some((node2) => isNonWhitespaceContent(node2))) if (hasNamedDefaultSlot) context.onError(createCompilerError(39, implicitDefaultChildren[0].loc));
			else slotsProperties.push(buildDefaultSlotProperty(void 0, implicitDefaultChildren));
		}
		const slotFlag = hasDynamicSlots ? 2 : hasForwardedSlots(node.children) ? 3 : 1;
		let slots = createObjectExpression(slotsProperties.concat(createObjectProperty(`_`, createSimpleExpression(slotFlag + ``, false))), loc);
		if (dynamicSlots.length) slots = createCallExpression(context.helper(CREATE_SLOTS), [slots, createArrayExpression(dynamicSlots)]);
		return {
			slots,
			hasDynamicSlots
		};
	}
	function buildDynamicSlot(name, fn, index$1) {
		const props = [createObjectProperty(`name`, name), createObjectProperty(`fn`, fn)];
		if (index$1 != null) props.push(createObjectProperty(`key`, createSimpleExpression(String(index$1), true)));
		return createObjectExpression(props);
	}
	function hasForwardedSlots(children) {
		for (let i = 0; i < children.length; i++) {
			const child = children[i];
			switch (child.type) {
				case 1:
					if (child.tagType === 2 || hasForwardedSlots(child.children)) return true;
					break;
				case 9:
					if (hasForwardedSlots(child.branches)) return true;
					break;
				case 10:
				case 11:
					if (hasForwardedSlots(child.children)) return true;
					break;
			}
		}
		return false;
	}
	function isNonWhitespaceContent(node) {
		if (node.type !== 2 && node.type !== 12) return true;
		return node.type === 2 ? !!node.content.trim() : isNonWhitespaceContent(node.content);
	}
	const directiveImportMap = /* @__PURE__ */ new WeakMap();
	const transformElement = (node, context) => {
		return function postTransformElement() {
			node = context.currentNode;
			if (!(node.type === 1 && (node.tagType === 0 || node.tagType === 1))) return;
			const { tag, props } = node;
			const isComponent$1 = node.tagType === 1;
			let vnodeTag = isComponent$1 ? resolveComponentType(node, context) : `"${tag}"`;
			const isDynamicComponent = shared$1.isObject(vnodeTag) && vnodeTag.callee === RESOLVE_DYNAMIC_COMPONENT;
			let vnodeProps;
			let vnodeChildren;
			let patchFlag = 0;
			let vnodeDynamicProps;
			let dynamicPropNames;
			let vnodeDirectives;
			let shouldUseBlock = isDynamicComponent || vnodeTag === TELEPORT || vnodeTag === SUSPENSE || !isComponent$1 && (tag === "svg" || tag === "foreignObject" || tag === "math");
			if (props.length > 0) {
				const propsBuildResult = buildProps(node, context, void 0, isComponent$1, isDynamicComponent);
				vnodeProps = propsBuildResult.props;
				patchFlag = propsBuildResult.patchFlag;
				dynamicPropNames = propsBuildResult.dynamicPropNames;
				const directives$1 = propsBuildResult.directives;
				vnodeDirectives = directives$1 && directives$1.length ? createArrayExpression(directives$1.map((dir) => buildDirectiveArgs(dir, context))) : void 0;
				if (propsBuildResult.shouldUseBlock) shouldUseBlock = true;
			}
			if (node.children.length > 0) {
				if (vnodeTag === KEEP_ALIVE) {
					shouldUseBlock = true;
					patchFlag |= 1024;
				}
				const shouldBuildAsSlots = isComponent$1 && vnodeTag !== TELEPORT && vnodeTag !== KEEP_ALIVE;
				if (shouldBuildAsSlots) {
					const { slots, hasDynamicSlots } = buildSlots(node, context);
					vnodeChildren = slots;
					if (hasDynamicSlots) patchFlag |= 1024;
				} else if (node.children.length === 1 && vnodeTag !== TELEPORT) {
					const child = node.children[0];
					const type = child.type;
					const hasDynamicTextChild = type === 5 || type === 8;
					if (hasDynamicTextChild && getConstantType(child, context) === 0) patchFlag |= 1;
					if (hasDynamicTextChild || type === 2) vnodeChildren = child;
					else vnodeChildren = node.children;
				} else vnodeChildren = node.children;
			}
			if (dynamicPropNames && dynamicPropNames.length) vnodeDynamicProps = stringifyDynamicPropNames(dynamicPropNames);
			node.codegenNode = createVNodeCall(context, vnodeTag, vnodeProps, vnodeChildren, patchFlag === 0 ? void 0 : patchFlag, vnodeDynamicProps, vnodeDirectives, !!shouldUseBlock, false, isComponent$1, node.loc);
		};
	};
	function resolveComponentType(node, context, ssr = false) {
		let { tag } = node;
		const isExplicitDynamic = isComponentTag(tag);
		const isProp = findProp(node, "is", false, true);
		if (isProp) {
			if (isExplicitDynamic || isCompatEnabled("COMPILER_IS_ON_ELEMENT", context)) {
				let exp;
				if (isProp.type === 6) exp = isProp.value && createSimpleExpression(isProp.value.content, true);
				else {
					exp = isProp.exp;
					if (!exp) {
						exp = createSimpleExpression(`is`, false, isProp.arg.loc);
						exp = isProp.exp = processExpression(exp, context);
					}
				}
				if (exp) return createCallExpression(context.helper(RESOLVE_DYNAMIC_COMPONENT), [exp]);
			} else if (isProp.type === 6 && isProp.value.content.startsWith("vue:")) tag = isProp.value.content.slice(4);
		}
		const builtIn = isCoreComponent(tag) || context.isBuiltInComponent(tag);
		if (builtIn) {
			if (!ssr) context.helper(builtIn);
			return builtIn;
		}
		{
			const fromSetup = resolveSetupReference(tag, context);
			if (fromSetup) return fromSetup;
			const dotIndex = tag.indexOf(".");
			if (dotIndex > 0) {
				const ns = resolveSetupReference(tag.slice(0, dotIndex), context);
				if (ns) return ns + tag.slice(dotIndex);
			}
		}
		if (context.selfName && shared$1.capitalize(shared$1.camelize(tag)) === context.selfName) {
			context.helper(RESOLVE_COMPONENT);
			context.components.add(tag + `__self`);
			return toValidAssetId(tag, `component`);
		}
		context.helper(RESOLVE_COMPONENT);
		context.components.add(tag);
		return toValidAssetId(tag, `component`);
	}
	function resolveSetupReference(name, context) {
		const bindings = context.bindingMetadata;
		if (!bindings || bindings.__isScriptSetup === false) return;
		const camelName = shared$1.camelize(name);
		const PascalName = shared$1.capitalize(camelName);
		const checkType = (type) => {
			if (bindings[name] === type) return name;
			if (bindings[camelName] === type) return camelName;
			if (bindings[PascalName] === type) return PascalName;
		};
		const fromConst = checkType("setup-const") || checkType("setup-reactive-const") || checkType("literal-const");
		if (fromConst) return context.inline ? fromConst : `$setup[${JSON.stringify(fromConst)}]`;
		const fromMaybeRef = checkType("setup-let") || checkType("setup-ref") || checkType("setup-maybe-ref");
		if (fromMaybeRef) return context.inline ? `${context.helperString(UNREF)}(${fromMaybeRef})` : `$setup[${JSON.stringify(fromMaybeRef)}]`;
		const fromProps = checkType("props");
		if (fromProps) return `${context.helperString(UNREF)}(${context.inline ? "__props" : "$props"}[${JSON.stringify(fromProps)}])`;
	}
	function buildProps(node, context, props = node.props, isComponent$1, isDynamicComponent, ssr = false) {
		const { tag, loc: elementLoc, children } = node;
		let properties = [];
		const mergeArgs = [];
		const runtimeDirectives = [];
		const hasChildren = children.length > 0;
		let shouldUseBlock = false;
		let patchFlag = 0;
		let hasRef = false;
		let hasClassBinding = false;
		let hasStyleBinding = false;
		let hasHydrationEventBinding = false;
		let hasDynamicKeys = false;
		let hasVnodeHook = false;
		const dynamicPropNames = [];
		const pushMergeArg = (arg) => {
			if (properties.length) {
				mergeArgs.push(createObjectExpression(dedupeProperties(properties), elementLoc));
				properties = [];
			}
			if (arg) mergeArgs.push(arg);
		};
		const pushRefVForMarker = () => {
			if (context.scopes.vFor > 0) properties.push(createObjectProperty(createSimpleExpression("ref_for", true), createSimpleExpression("true")));
		};
		const analyzePatchFlag = ({ key, value }) => {
			if (isStaticExp(key)) {
				const name = key.content;
				const isEventHandler = shared$1.isOn(name);
				if (isEventHandler && (!isComponent$1 || isDynamicComponent) && name.toLowerCase() !== "onclick" && name !== "onUpdate:modelValue" && !shared$1.isReservedProp(name)) hasHydrationEventBinding = true;
				if (isEventHandler && shared$1.isReservedProp(name)) hasVnodeHook = true;
				if (isEventHandler && value.type === 14) value = value.arguments[0];
				if (value.type === 20 || (value.type === 4 || value.type === 8) && getConstantType(value, context) > 0) return;
				if (name === "ref") hasRef = true;
				else if (name === "class") hasClassBinding = true;
				else if (name === "style") hasStyleBinding = true;
				else if (name !== "key" && !dynamicPropNames.includes(name)) dynamicPropNames.push(name);
				if (isComponent$1 && (name === "class" || name === "style") && !dynamicPropNames.includes(name)) dynamicPropNames.push(name);
			} else hasDynamicKeys = true;
		};
		for (let i = 0; i < props.length; i++) {
			const prop = props[i];
			if (prop.type === 6) {
				const { loc, name, nameLoc, value } = prop;
				let isStatic$1 = true;
				if (name === "ref") {
					hasRef = true;
					pushRefVForMarker();
					if (value && context.inline) {
						const binding = context.bindingMetadata[value.content];
						if (binding === "setup-let" || binding === "setup-ref" || binding === "setup-maybe-ref") {
							isStatic$1 = false;
							properties.push(createObjectProperty(createSimpleExpression("ref_key", true), createSimpleExpression(value.content, true, value.loc)));
						}
					}
				}
				if (name === "is" && (isComponentTag(tag) || value && value.content.startsWith("vue:") || isCompatEnabled("COMPILER_IS_ON_ELEMENT", context))) continue;
				properties.push(createObjectProperty(createSimpleExpression(name, true, nameLoc), createSimpleExpression(value ? value.content : "", isStatic$1, value ? value.loc : loc)));
			} else {
				const { name, arg, exp, loc, modifiers } = prop;
				const isVBind = name === "bind";
				const isVOn = name === "on";
				if (name === "slot") {
					if (!isComponent$1) context.onError(createCompilerError(40, loc));
					continue;
				}
				if (name === "once" || name === "memo") continue;
				if (name === "is" || isVBind && isStaticArgOf(arg, "is") && (isComponentTag(tag) || isCompatEnabled("COMPILER_IS_ON_ELEMENT", context))) continue;
				if (isVOn && ssr) continue;
				if (isVBind && isStaticArgOf(arg, "key") || isVOn && hasChildren && isStaticArgOf(arg, "vue:before-update")) shouldUseBlock = true;
				if (isVBind && isStaticArgOf(arg, "ref")) pushRefVForMarker();
				if (!arg && (isVBind || isVOn)) {
					hasDynamicKeys = true;
					if (exp) if (isVBind) {
						{
							pushMergeArg();
							if (isCompatEnabled("COMPILER_V_BIND_OBJECT_ORDER", context)) {
								mergeArgs.unshift(exp);
								continue;
							}
						}
						pushRefVForMarker();
						pushMergeArg();
						mergeArgs.push(exp);
					} else pushMergeArg({
						type: 14,
						loc,
						callee: context.helper(TO_HANDLERS),
						arguments: isComponent$1 ? [exp] : [exp, `true`]
					});
					else context.onError(createCompilerError(isVBind ? 34 : 35, loc));
					continue;
				}
				if (isVBind && modifiers.some((mod) => mod.content === "prop")) patchFlag |= 32;
				const directiveTransform = context.directiveTransforms[name];
				if (directiveTransform) {
					const { props: props2, needRuntime } = directiveTransform(prop, node, context);
					!ssr && props2.forEach(analyzePatchFlag);
					if (isVOn && arg && !isStaticExp(arg)) pushMergeArg(createObjectExpression(props2, elementLoc));
					else properties.push(...props2);
					if (needRuntime) {
						runtimeDirectives.push(prop);
						if (shared$1.isSymbol(needRuntime)) directiveImportMap.set(prop, needRuntime);
					}
				} else if (!shared$1.isBuiltInDirective(name)) {
					runtimeDirectives.push(prop);
					if (hasChildren) shouldUseBlock = true;
				}
			}
		}
		let propsExpression = void 0;
		if (mergeArgs.length) {
			pushMergeArg();
			if (mergeArgs.length > 1) propsExpression = createCallExpression(context.helper(MERGE_PROPS), mergeArgs, elementLoc);
			else propsExpression = mergeArgs[0];
		} else if (properties.length) propsExpression = createObjectExpression(dedupeProperties(properties), elementLoc);
		if (hasDynamicKeys) patchFlag |= 16;
		else {
			if (hasClassBinding && !isComponent$1) patchFlag |= 2;
			if (hasStyleBinding && !isComponent$1) patchFlag |= 4;
			if (dynamicPropNames.length) patchFlag |= 8;
			if (hasHydrationEventBinding) patchFlag |= 32;
		}
		if (!shouldUseBlock && (patchFlag === 0 || patchFlag === 32) && (hasRef || hasVnodeHook || runtimeDirectives.length > 0)) patchFlag |= 512;
		if (!context.inSSR && propsExpression) switch (propsExpression.type) {
			case 15:
				let classKeyIndex = -1;
				let styleKeyIndex = -1;
				let hasDynamicKey = false;
				for (let i = 0; i < propsExpression.properties.length; i++) {
					const key = propsExpression.properties[i].key;
					if (isStaticExp(key)) {
						if (key.content === "class") classKeyIndex = i;
						else if (key.content === "style") styleKeyIndex = i;
					} else if (!key.isHandlerKey) hasDynamicKey = true;
				}
				const classProp = propsExpression.properties[classKeyIndex];
				const styleProp = propsExpression.properties[styleKeyIndex];
				if (!hasDynamicKey) {
					if (classProp && !isStaticExp(classProp.value)) classProp.value = createCallExpression(context.helper(NORMALIZE_CLASS), [classProp.value]);
					if (styleProp && (hasStyleBinding || styleProp.value.type === 4 && styleProp.value.content.trim()[0] === `[` || styleProp.value.type === 17)) styleProp.value = createCallExpression(context.helper(NORMALIZE_STYLE), [styleProp.value]);
				} else propsExpression = createCallExpression(context.helper(NORMALIZE_PROPS), [propsExpression]);
				break;
			case 14: break;
			default:
				propsExpression = createCallExpression(context.helper(NORMALIZE_PROPS), [createCallExpression(context.helper(GUARD_REACTIVE_PROPS), [propsExpression])]);
				break;
		}
		return {
			props: propsExpression,
			directives: runtimeDirectives,
			patchFlag,
			dynamicPropNames,
			shouldUseBlock
		};
	}
	function dedupeProperties(properties) {
		const knownProps = /* @__PURE__ */ new Map();
		const deduped = [];
		for (let i = 0; i < properties.length; i++) {
			const prop = properties[i];
			if (prop.key.type === 8 || !prop.key.isStatic) {
				deduped.push(prop);
				continue;
			}
			const name = prop.key.content;
			const existing = knownProps.get(name);
			if (existing) {
				if (name === "style" || name === "class" || shared$1.isOn(name)) mergeAsArray(existing, prop);
			} else {
				knownProps.set(name, prop);
				deduped.push(prop);
			}
		}
		return deduped;
	}
	function mergeAsArray(existing, incoming) {
		if (existing.value.type === 17) existing.value.elements.push(incoming.value);
		else existing.value = createArrayExpression([existing.value, incoming.value], existing.loc);
	}
	function buildDirectiveArgs(dir, context) {
		const dirArgs = [];
		const runtime = directiveImportMap.get(dir);
		if (runtime) dirArgs.push(context.helperString(runtime));
		else {
			const fromSetup = resolveSetupReference("v-" + dir.name, context);
			if (fromSetup) dirArgs.push(fromSetup);
			else {
				context.helper(RESOLVE_DIRECTIVE);
				context.directives.add(dir.name);
				dirArgs.push(toValidAssetId(dir.name, `directive`));
			}
		}
		const { loc } = dir;
		if (dir.exp) dirArgs.push(dir.exp);
		if (dir.arg) {
			if (!dir.exp) dirArgs.push(`void 0`);
			dirArgs.push(dir.arg);
		}
		if (Object.keys(dir.modifiers).length) {
			if (!dir.arg) {
				if (!dir.exp) dirArgs.push(`void 0`);
				dirArgs.push(`void 0`);
			}
			const trueExpression = createSimpleExpression(`true`, false, loc);
			dirArgs.push(createObjectExpression(dir.modifiers.map((modifier) => createObjectProperty(modifier, trueExpression)), loc));
		}
		return createArrayExpression(dirArgs, dir.loc);
	}
	function stringifyDynamicPropNames(props) {
		let propsNamesString = `[`;
		for (let i = 0, l = props.length; i < l; i++) {
			propsNamesString += JSON.stringify(props[i]);
			if (i < l - 1) propsNamesString += ", ";
		}
		return propsNamesString + `]`;
	}
	function isComponentTag(tag) {
		return tag === "component" || tag === "Component";
	}
	const transformSlotOutlet = (node, context) => {
		if (isSlotOutlet(node)) {
			const { children, loc } = node;
			const { slotName, slotProps } = processSlotOutlet$1(node, context);
			const slotArgs = [
				context.prefixIdentifiers ? `_ctx.$slots` : `$slots`,
				slotName,
				"{}",
				"undefined",
				"true"
			];
			let expectedLen = 2;
			if (slotProps) {
				slotArgs[2] = slotProps;
				expectedLen = 3;
			}
			if (children.length) {
				slotArgs[3] = createFunctionExpression([], children, false, false, loc);
				expectedLen = 4;
			}
			if (context.scopeId && !context.slotted) expectedLen = 5;
			slotArgs.splice(expectedLen);
			node.codegenNode = createCallExpression(context.helper(RENDER_SLOT), slotArgs, loc);
		}
	};
	function processSlotOutlet$1(node, context) {
		let slotName = `"default"`;
		let slotProps = void 0;
		const nonNameProps = [];
		for (let i = 0; i < node.props.length; i++) {
			const p = node.props[i];
			if (p.type === 6) {
				if (p.value) if (p.name === "name") slotName = JSON.stringify(p.value.content);
				else {
					p.name = shared$1.camelize(p.name);
					nonNameProps.push(p);
				}
			} else if (p.name === "bind" && isStaticArgOf(p.arg, "name")) {
				if (p.exp) slotName = p.exp;
				else if (p.arg && p.arg.type === 4) {
					const name = shared$1.camelize(p.arg.content);
					slotName = p.exp = createSimpleExpression(name, false, p.arg.loc);
					slotName = p.exp = processExpression(p.exp, context);
				}
			} else {
				if (p.name === "bind" && p.arg && isStaticExp(p.arg)) p.arg.content = shared$1.camelize(p.arg.content);
				nonNameProps.push(p);
			}
		}
		if (nonNameProps.length > 0) {
			const { props, directives: directives$1 } = buildProps(node, context, nonNameProps, false, false);
			slotProps = props;
			if (directives$1.length) context.onError(createCompilerError(36, directives$1[0].loc));
		}
		return {
			slotName,
			slotProps
		};
	}
	const transformOn$1 = (dir, node, context, augmentor) => {
		const { loc, modifiers, arg } = dir;
		if (!dir.exp && !modifiers.length) context.onError(createCompilerError(35, loc));
		let eventName;
		if (arg.type === 4) if (arg.isStatic) {
			let rawName = arg.content;
			if (rawName.startsWith("vue:")) rawName = `vnode-${rawName.slice(4)}`;
			const eventString = node.tagType !== 0 || rawName.startsWith("vnode") || !/[A-Z]/.test(rawName) ? shared$1.toHandlerKey(shared$1.camelize(rawName)) : `on:${rawName}`;
			eventName = createSimpleExpression(eventString, true, arg.loc);
		} else eventName = createCompoundExpression([
			`${context.helperString(TO_HANDLER_KEY)}(`,
			arg,
			`)`
		]);
		else {
			eventName = arg;
			eventName.children.unshift(`${context.helperString(TO_HANDLER_KEY)}(`);
			eventName.children.push(`)`);
		}
		let exp = dir.exp;
		if (exp && !exp.content.trim()) exp = void 0;
		let shouldCache = context.cacheHandlers && !exp && !context.inVOnce;
		if (exp) {
			const isMemberExp = isMemberExpression(exp, context);
			const isInlineStatement = !(isMemberExp || isFnExpression(exp, context));
			const hasMultipleStatements = exp.content.includes(`;`);
			if (context.prefixIdentifiers) {
				isInlineStatement && context.addIdentifiers(`$event`);
				exp = dir.exp = processExpression(exp, context, false, hasMultipleStatements);
				isInlineStatement && context.removeIdentifiers(`$event`);
				shouldCache = context.cacheHandlers && !context.inVOnce && !(exp.type === 4 && exp.constType > 0) && !(isMemberExp && node.tagType === 1) && !hasScopeRef(exp, context.identifiers);
				if (shouldCache && isMemberExp) if (exp.type === 4) exp.content = `${exp.content} && ${exp.content}(...args)`;
				else exp.children = [
					...exp.children,
					` && `,
					...exp.children,
					`(...args)`
				];
			}
			if (isInlineStatement || shouldCache && isMemberExp) exp = createCompoundExpression([
				`${isInlineStatement ? context.isTS ? `($event: any)` : `$event` : `${context.isTS ? `
//@ts-ignore
` : ``}(...args)`} => ${hasMultipleStatements ? `{` : `(`}`,
				exp,
				hasMultipleStatements ? `}` : `)`
			]);
		}
		let ret = { props: [createObjectProperty(eventName, exp || createSimpleExpression(`() => {}`, false, loc))] };
		if (augmentor) ret = augmentor(ret);
		if (shouldCache) ret.props[0].value = context.cache(ret.props[0].value);
		ret.props.forEach((p) => p.key.isHandlerKey = true);
		return ret;
	};
	const transformText = (node, context) => {
		if (node.type === 0 || node.type === 1 || node.type === 11 || node.type === 10) return () => {
			const children = node.children;
			let currentContainer = void 0;
			let hasText = false;
			for (let i = 0; i < children.length; i++) {
				const child = children[i];
				if (isText$1(child)) {
					hasText = true;
					for (let j = i + 1; j < children.length; j++) {
						const next$1 = children[j];
						if (isText$1(next$1)) {
							if (!currentContainer) currentContainer = children[i] = createCompoundExpression([child], child.loc);
							currentContainer.children.push(` + `, next$1);
							children.splice(j, 1);
							j--;
						} else {
							currentContainer = void 0;
							break;
						}
					}
				}
			}
			if (!hasText || children.length === 1 && (node.type === 0 || node.type === 1 && node.tagType === 0 && !node.props.find((p) => p.type === 7 && !context.directiveTransforms[p.name]) && !(node.tag === "template"))) return;
			for (let i = 0; i < children.length; i++) {
				const child = children[i];
				if (isText$1(child) || child.type === 8) {
					const callArgs = [];
					if (child.type !== 2 || child.content !== " ") callArgs.push(child);
					if (!context.ssr && getConstantType(child, context) === 0) callArgs.push("1");
					children[i] = {
						type: 12,
						content: child,
						loc: child.loc,
						codegenNode: createCallExpression(context.helper(CREATE_TEXT), callArgs)
					};
				}
			}
		};
	};
	const seen$1 = /* @__PURE__ */ new WeakSet();
	const transformOnce = (node, context) => {
		if (node.type === 1 && findDir(node, "once", true)) {
			if (seen$1.has(node) || context.inVOnce || context.inSSR) return;
			seen$1.add(node);
			context.inVOnce = true;
			context.helper(SET_BLOCK_TRACKING);
			return () => {
				context.inVOnce = false;
				const cur = context.currentNode;
				if (cur.codegenNode) cur.codegenNode = context.cache(cur.codegenNode, true, true);
			};
		}
	};
	const transformModel$2 = (dir, node, context) => {
		const { exp, arg } = dir;
		if (!exp) {
			context.onError(createCompilerError(41, dir.loc));
			return createTransformProps();
		}
		const rawExp = exp.loc.source.trim();
		const expString = exp.type === 4 ? exp.content : rawExp;
		const bindingType = context.bindingMetadata[rawExp];
		if (bindingType === "props" || bindingType === "props-aliased") {
			context.onError(createCompilerError(44, exp.loc));
			return createTransformProps();
		}
		const maybeRef = context.inline && (bindingType === "setup-let" || bindingType === "setup-ref" || bindingType === "setup-maybe-ref");
		if (!expString.trim() || !isMemberExpression(exp, context) && !maybeRef) {
			context.onError(createCompilerError(42, exp.loc));
			return createTransformProps();
		}
		if (context.prefixIdentifiers && isSimpleIdentifier(expString) && context.identifiers[expString]) {
			context.onError(createCompilerError(43, exp.loc));
			return createTransformProps();
		}
		const propName = arg ? arg : createSimpleExpression("modelValue", true);
		const eventName = arg ? isStaticExp(arg) ? `onUpdate:${shared$1.camelize(arg.content)}` : createCompoundExpression(["\"onUpdate:\" + ", arg]) : `onUpdate:modelValue`;
		let assignmentExp;
		const eventArg = context.isTS ? `($event: any)` : `$event`;
		if (maybeRef) if (bindingType === "setup-ref") assignmentExp = createCompoundExpression([
			`${eventArg} => ((`,
			createSimpleExpression(rawExp, false, exp.loc),
			`).value = $event)`
		]);
		else {
			const altAssignment = bindingType === "setup-let" ? `${rawExp} = $event` : `null`;
			assignmentExp = createCompoundExpression([
				`${eventArg} => (${context.helperString(IS_REF)}(${rawExp}) ? (`,
				createSimpleExpression(rawExp, false, exp.loc),
				`).value = $event : ${altAssignment})`
			]);
		}
		else assignmentExp = createCompoundExpression([
			`${eventArg} => ((`,
			exp,
			`) = $event)`
		]);
		const props = [createObjectProperty(propName, dir.exp), createObjectProperty(eventName, assignmentExp)];
		if (context.prefixIdentifiers && !context.inVOnce && context.cacheHandlers && !hasScopeRef(exp, context.identifiers)) props[1].value = context.cache(props[1].value);
		if (dir.modifiers.length && node.tagType === 1) {
			const modifiers = dir.modifiers.map((m) => m.content).map((m) => (isSimpleIdentifier(m) ? m : JSON.stringify(m)) + `: true`).join(`, `);
			const modifiersKey = arg ? isStaticExp(arg) ? `${arg.content}Modifiers` : createCompoundExpression([arg, " + \"Modifiers\""]) : `modelModifiers`;
			props.push(createObjectProperty(modifiersKey, createSimpleExpression(`{ ${modifiers} }`, false, dir.loc, 2)));
		}
		return createTransformProps(props);
	};
	function createTransformProps(props = []) {
		return { props };
	}
	const validDivisionCharRE$1 = /[\w).+\-_$\]]/;
	const transformFilter = (node, context) => {
		if (!isCompatEnabled("COMPILER_FILTERS", context)) return;
		if (node.type === 5) rewriteFilter(node.content, context);
		else if (node.type === 1) node.props.forEach((prop) => {
			if (prop.type === 7 && prop.name !== "for" && prop.exp) rewriteFilter(prop.exp, context);
		});
	};
	function rewriteFilter(node, context) {
		if (node.type === 4) parseFilter(node, context);
		else for (let i = 0; i < node.children.length; i++) {
			const child = node.children[i];
			if (typeof child !== "object") continue;
			if (child.type === 4) parseFilter(child, context);
			else if (child.type === 8) rewriteFilter(node, context);
			else if (child.type === 5) rewriteFilter(child.content, context);
		}
	}
	function parseFilter(node, context) {
		const exp = node.content;
		let inSingle = false;
		let inDouble = false;
		let inTemplateString = false;
		let inRegex = false;
		let curly = 0;
		let square = 0;
		let paren = 0;
		let lastFilterIndex = 0;
		let c, prev, i, expression, filters = [];
		for (i = 0; i < exp.length; i++) {
			prev = c;
			c = exp.charCodeAt(i);
			if (inSingle) {
				if (c === 39 && prev !== 92) inSingle = false;
			} else if (inDouble) {
				if (c === 34 && prev !== 92) inDouble = false;
			} else if (inTemplateString) {
				if (c === 96 && prev !== 92) inTemplateString = false;
			} else if (inRegex) {
				if (c === 47 && prev !== 92) inRegex = false;
			} else if (c === 124 && exp.charCodeAt(i + 1) !== 124 && exp.charCodeAt(i - 1) !== 124 && !curly && !square && !paren) if (expression === void 0) {
				lastFilterIndex = i + 1;
				expression = exp.slice(0, i).trim();
			} else pushFilter();
			else {
				switch (c) {
					case 34:
						inDouble = true;
						break;
					case 39:
						inSingle = true;
						break;
					case 96:
						inTemplateString = true;
						break;
					case 40:
						paren++;
						break;
					case 41:
						paren--;
						break;
					case 91:
						square++;
						break;
					case 93:
						square--;
						break;
					case 123:
						curly++;
						break;
					case 125:
						curly--;
						break;
				}
				if (c === 47) {
					let j = i - 1;
					let p;
					for (; j >= 0; j--) {
						p = exp.charAt(j);
						if (p !== " ") break;
					}
					if (!p || !validDivisionCharRE$1.test(p)) inRegex = true;
				}
			}
		}
		if (expression === void 0) expression = exp.slice(0, i).trim();
		else if (lastFilterIndex !== 0) pushFilter();
		function pushFilter() {
			filters.push(exp.slice(lastFilterIndex, i).trim());
			lastFilterIndex = i + 1;
		}
		if (filters.length) {
			for (i = 0; i < filters.length; i++) expression = wrapFilter$1(expression, filters[i], context);
			node.content = expression;
			node.ast = void 0;
		}
	}
	function wrapFilter$1(exp, filter$1, context) {
		context.helper(RESOLVE_FILTER);
		const i = filter$1.indexOf("(");
		if (i < 0) {
			context.filters.add(filter$1);
			return `${toValidAssetId(filter$1, "filter")}(${exp})`;
		} else {
			const name = filter$1.slice(0, i);
			const args = filter$1.slice(i + 1);
			context.filters.add(name);
			return `${toValidAssetId(name, "filter")}(${exp}${args !== ")" ? "," + args : args}`;
		}
	}
	const seen = /* @__PURE__ */ new WeakSet();
	const transformMemo = (node, context) => {
		if (node.type === 1) {
			const dir = findDir(node, "memo");
			if (!dir || seen.has(node)) return;
			seen.add(node);
			return () => {
				const codegenNode = node.codegenNode || context.currentNode.codegenNode;
				if (codegenNode && codegenNode.type === 13) {
					if (node.tagType !== 1) convertToBlock(codegenNode, context);
					node.codegenNode = createCallExpression(context.helper(WITH_MEMO), [
						dir.exp,
						createFunctionExpression(void 0, codegenNode),
						`_cache`,
						String(context.cached.length)
					]);
					context.cached.push(null);
				}
			};
		}
	};
	function getBaseTransformPreset(prefixIdentifiers) {
		return [[
			transformOnce,
			transformIf,
			transformMemo,
			transformFor,
			...[transformFilter],
			...prefixIdentifiers ? [trackVForSlotScopes, transformExpression] : [],
			transformSlotOutlet,
			transformElement,
			trackSlotScopes,
			transformText
		], {
			on: transformOn$1,
			bind: transformBind,
			model: transformModel$2
		}];
	}
	function baseCompile$1(source, options = {}) {
		const onError = options.onError || defaultOnError;
		const isModuleMode = options.mode === "module";
		const prefixIdentifiers = options.prefixIdentifiers === true || isModuleMode;
		if (!prefixIdentifiers && options.cacheHandlers) onError(createCompilerError(49));
		if (options.scopeId && !isModuleMode) onError(createCompilerError(50));
		const resolvedOptions = shared$1.extend({}, options, { prefixIdentifiers });
		const ast = shared$1.isString(source) ? baseParse(source, resolvedOptions) : source;
		const [nodeTransforms, directiveTransforms] = getBaseTransformPreset(prefixIdentifiers);
		if (options.isTS) {
			const { expressionPlugins } = options;
			if (!expressionPlugins || !expressionPlugins.includes("typescript")) options.expressionPlugins = [...expressionPlugins || [], "typescript"];
		}
		transform(ast, shared$1.extend({}, resolvedOptions, {
			nodeTransforms: [...nodeTransforms, ...options.nodeTransforms || []],
			directiveTransforms: shared$1.extend({}, directiveTransforms, options.directiveTransforms || {})
		}));
		return generate$3(ast, resolvedOptions);
	}
	const BindingTypes = {
		"DATA": "data",
		"PROPS": "props",
		"PROPS_ALIASED": "props-aliased",
		"SETUP_LET": "setup-let",
		"SETUP_CONST": "setup-const",
		"SETUP_REACTIVE_CONST": "setup-reactive-const",
		"SETUP_MAYBE_REF": "setup-maybe-ref",
		"SETUP_REF": "setup-ref",
		"OPTIONS": "options",
		"LITERAL_CONST": "literal-const"
	};
	const noopDirectiveTransform = () => ({ props: [] });
	exports.generateCodeFrame = shared$1.generateCodeFrame;
	exports.BASE_TRANSITION = BASE_TRANSITION;
	exports.BindingTypes = BindingTypes;
	exports.CAMELIZE = CAMELIZE;
	exports.CAPITALIZE = CAPITALIZE;
	exports.CREATE_BLOCK = CREATE_BLOCK;
	exports.CREATE_COMMENT = CREATE_COMMENT;
	exports.CREATE_ELEMENT_BLOCK = CREATE_ELEMENT_BLOCK;
	exports.CREATE_ELEMENT_VNODE = CREATE_ELEMENT_VNODE;
	exports.CREATE_SLOTS = CREATE_SLOTS;
	exports.CREATE_STATIC = CREATE_STATIC;
	exports.CREATE_TEXT = CREATE_TEXT;
	exports.CREATE_VNODE = CREATE_VNODE;
	exports.CompilerDeprecationTypes = CompilerDeprecationTypes;
	exports.ConstantTypes = ConstantTypes;
	exports.ElementTypes = ElementTypes;
	exports.ErrorCodes = ErrorCodes;
	exports.FRAGMENT = FRAGMENT;
	exports.GUARD_REACTIVE_PROPS = GUARD_REACTIVE_PROPS;
	exports.IS_MEMO_SAME = IS_MEMO_SAME;
	exports.IS_REF = IS_REF;
	exports.KEEP_ALIVE = KEEP_ALIVE;
	exports.MERGE_PROPS = MERGE_PROPS;
	exports.NORMALIZE_CLASS = NORMALIZE_CLASS;
	exports.NORMALIZE_PROPS = NORMALIZE_PROPS;
	exports.NORMALIZE_STYLE = NORMALIZE_STYLE;
	exports.Namespaces = Namespaces;
	exports.NodeTypes = NodeTypes;
	exports.OPEN_BLOCK = OPEN_BLOCK;
	exports.POP_SCOPE_ID = POP_SCOPE_ID;
	exports.PUSH_SCOPE_ID = PUSH_SCOPE_ID;
	exports.RENDER_LIST = RENDER_LIST;
	exports.RENDER_SLOT = RENDER_SLOT;
	exports.RESOLVE_COMPONENT = RESOLVE_COMPONENT;
	exports.RESOLVE_DIRECTIVE = RESOLVE_DIRECTIVE;
	exports.RESOLVE_DYNAMIC_COMPONENT = RESOLVE_DYNAMIC_COMPONENT;
	exports.RESOLVE_FILTER = RESOLVE_FILTER;
	exports.SET_BLOCK_TRACKING = SET_BLOCK_TRACKING;
	exports.SUSPENSE = SUSPENSE;
	exports.TELEPORT = TELEPORT;
	exports.TO_DISPLAY_STRING = TO_DISPLAY_STRING;
	exports.TO_HANDLERS = TO_HANDLERS;
	exports.TO_HANDLER_KEY = TO_HANDLER_KEY;
	exports.TS_NODE_TYPES = TS_NODE_TYPES;
	exports.UNREF = UNREF;
	exports.WITH_CTX = WITH_CTX;
	exports.WITH_DIRECTIVES = WITH_DIRECTIVES;
	exports.WITH_MEMO = WITH_MEMO;
	exports.advancePositionWithClone = advancePositionWithClone;
	exports.advancePositionWithMutation = advancePositionWithMutation;
	exports.assert = assert;
	exports.baseCompile = baseCompile$1;
	exports.baseParse = baseParse;
	exports.buildDirectiveArgs = buildDirectiveArgs;
	exports.buildProps = buildProps;
	exports.buildSlots = buildSlots;
	exports.checkCompatEnabled = checkCompatEnabled;
	exports.convertToBlock = convertToBlock;
	exports.createArrayExpression = createArrayExpression;
	exports.createAssignmentExpression = createAssignmentExpression;
	exports.createBlockStatement = createBlockStatement;
	exports.createCacheExpression = createCacheExpression;
	exports.createCallExpression = createCallExpression;
	exports.createCompilerError = createCompilerError;
	exports.createCompoundExpression = createCompoundExpression;
	exports.createConditionalExpression = createConditionalExpression;
	exports.createForLoopParams = createForLoopParams;
	exports.createFunctionExpression = createFunctionExpression;
	exports.createIfStatement = createIfStatement;
	exports.createInterpolation = createInterpolation;
	exports.createObjectExpression = createObjectExpression;
	exports.createObjectProperty = createObjectProperty;
	exports.createReturnStatement = createReturnStatement;
	exports.createRoot = createRoot;
	exports.createSequenceExpression = createSequenceExpression;
	exports.createSimpleExpression = createSimpleExpression;
	exports.createStructuralDirectiveTransform = createStructuralDirectiveTransform;
	exports.createTemplateLiteral = createTemplateLiteral;
	exports.createTransformContext = createTransformContext;
	exports.createVNodeCall = createVNodeCall;
	exports.errorMessages = errorMessages;
	exports.extractIdentifiers = extractIdentifiers;
	exports.findDir = findDir;
	exports.findProp = findProp;
	exports.forAliasRE = forAliasRE$1;
	exports.generate = generate$3;
	exports.getBaseTransformPreset = getBaseTransformPreset;
	exports.getConstantType = getConstantType;
	exports.getMemoedVNodeCall = getMemoedVNodeCall;
	exports.getVNodeBlockHelper = getVNodeBlockHelper;
	exports.getVNodeHelper = getVNodeHelper;
	exports.hasDynamicKeyVBind = hasDynamicKeyVBind;
	exports.hasScopeRef = hasScopeRef;
	exports.helperNameMap = helperNameMap;
	exports.injectProp = injectProp;
	exports.isCoreComponent = isCoreComponent;
	exports.isFnExpression = isFnExpression;
	exports.isFnExpressionBrowser = isFnExpressionBrowser;
	exports.isFnExpressionNode = isFnExpressionNode;
	exports.isFunctionType = isFunctionType;
	exports.isInDestructureAssignment = isInDestructureAssignment;
	exports.isInNewExpression = isInNewExpression;
	exports.isMemberExpression = isMemberExpression;
	exports.isMemberExpressionBrowser = isMemberExpressionBrowser;
	exports.isMemberExpressionNode = isMemberExpressionNode;
	exports.isReferencedIdentifier = isReferencedIdentifier;
	exports.isSimpleIdentifier = isSimpleIdentifier;
	exports.isSlotOutlet = isSlotOutlet;
	exports.isStaticArgOf = isStaticArgOf;
	exports.isStaticExp = isStaticExp;
	exports.isStaticProperty = isStaticProperty;
	exports.isStaticPropertyKey = isStaticPropertyKey;
	exports.isTemplateNode = isTemplateNode;
	exports.isText = isText$1;
	exports.isVSlot = isVSlot;
	exports.locStub = locStub;
	exports.noopDirectiveTransform = noopDirectiveTransform;
	exports.processExpression = processExpression;
	exports.processFor = processFor$1;
	exports.processIf = processIf$1;
	exports.processSlotOutlet = processSlotOutlet$1;
	exports.registerRuntimeHelpers = registerRuntimeHelpers;
	exports.resolveComponentType = resolveComponentType;
	exports.stringifyExpression = stringifyExpression;
	exports.toValidAssetId = toValidAssetId;
	exports.trackSlotScopes = trackSlotScopes;
	exports.trackVForSlotScopes = trackVForSlotScopes;
	exports.transform = transform;
	exports.transformBind = transformBind;
	exports.transformElement = transformElement;
	exports.transformExpression = transformExpression;
	exports.transformModel = transformModel$2;
	exports.transformOn = transformOn$1;
	exports.traverseNode = traverseNode;
	exports.unwrapTSNode = unwrapTSNode;
	exports.walkBlockDeclarations = walkBlockDeclarations;
	exports.walkFunctionParams = walkFunctionParams;
	exports.walkIdentifiers = walkIdentifiers$1;
	exports.warnDeprecation = warnDeprecation;
} });

//#endregion
//#region node_modules/@vue/compiler-core/index.js
var require_compiler_core = __commonJS({ "node_modules/@vue/compiler-core/index.js"(exports, module) {
	module.exports = require_compiler_core_cjs_prod();
} });

//#endregion
//#region node_modules/@vue/compiler-dom/dist/compiler-dom.cjs.prod.js
var require_compiler_dom_cjs_prod = __commonJS({ "node_modules/@vue/compiler-dom/dist/compiler-dom.cjs.prod.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	var compilerCore = require_compiler_core();
	var shared = require_shared$2();
	const V_MODEL_RADIO = Symbol(``);
	const V_MODEL_CHECKBOX = Symbol(``);
	const V_MODEL_TEXT = Symbol(``);
	const V_MODEL_SELECT = Symbol(``);
	const V_MODEL_DYNAMIC = Symbol(``);
	const V_ON_WITH_MODIFIERS = Symbol(``);
	const V_ON_WITH_KEYS = Symbol(``);
	const V_SHOW = Symbol(``);
	const TRANSITION = Symbol(``);
	const TRANSITION_GROUP = Symbol(``);
	compilerCore.registerRuntimeHelpers({
		[V_MODEL_RADIO]: `vModelRadio`,
		[V_MODEL_CHECKBOX]: `vModelCheckbox`,
		[V_MODEL_TEXT]: `vModelText`,
		[V_MODEL_SELECT]: `vModelSelect`,
		[V_MODEL_DYNAMIC]: `vModelDynamic`,
		[V_ON_WITH_MODIFIERS]: `withModifiers`,
		[V_ON_WITH_KEYS]: `withKeys`,
		[V_SHOW]: `vShow`,
		[TRANSITION]: `Transition`,
		[TRANSITION_GROUP]: `TransitionGroup`
	});
	const parserOptions = {
		parseMode: "html",
		isVoidTag: shared.isVoidTag,
		isNativeTag: (tag) => shared.isHTMLTag(tag) || shared.isSVGTag(tag) || shared.isMathMLTag(tag),
		isPreTag: (tag) => tag === "pre",
		isIgnoreNewlineTag: (tag) => tag === "pre" || tag === "textarea",
		decodeEntities: void 0,
		isBuiltInComponent: (tag) => {
			if (tag === "Transition" || tag === "transition") return TRANSITION;
			else if (tag === "TransitionGroup" || tag === "transition-group") return TRANSITION_GROUP;
		},
		getNamespace(tag, parent, rootNamespace) {
			let ns = parent ? parent.ns : rootNamespace;
			if (parent && ns === 2) {
				if (parent.tag === "annotation-xml") {
					if (tag === "svg") return 1;
					if (parent.props.some((a) => a.type === 6 && a.name === "encoding" && a.value != null && (a.value.content === "text/html" || a.value.content === "application/xhtml+xml"))) ns = 0;
				} else if (/^m(?:[ions]|text)$/.test(parent.tag) && tag !== "mglyph" && tag !== "malignmark") ns = 0;
			} else if (parent && ns === 1) {
				if (parent.tag === "foreignObject" || parent.tag === "desc" || parent.tag === "title") ns = 0;
			}
			if (ns === 0) {
				if (tag === "svg") return 1;
				if (tag === "math") return 2;
			}
			return ns;
		}
	};
	const transformStyle = (node) => {
		if (node.type === 1) node.props.forEach((p, i) => {
			if (p.type === 6 && p.name === "style" && p.value) node.props[i] = {
				type: 7,
				name: `bind`,
				arg: compilerCore.createSimpleExpression(`style`, true, p.loc),
				exp: parseInlineCSS(p.value.content, p.loc),
				modifiers: [],
				loc: p.loc
			};
		});
	};
	const parseInlineCSS = (cssText, loc) => {
		const normalized = shared.parseStringStyle(cssText);
		return compilerCore.createSimpleExpression(JSON.stringify(normalized), false, loc, 3);
	};
	function createDOMCompilerError(code$1, loc) {
		return compilerCore.createCompilerError(code$1, loc, DOMErrorMessages);
	}
	const DOMErrorCodes = {
		"X_V_HTML_NO_EXPRESSION": 53,
		"53": "X_V_HTML_NO_EXPRESSION",
		"X_V_HTML_WITH_CHILDREN": 54,
		"54": "X_V_HTML_WITH_CHILDREN",
		"X_V_TEXT_NO_EXPRESSION": 55,
		"55": "X_V_TEXT_NO_EXPRESSION",
		"X_V_TEXT_WITH_CHILDREN": 56,
		"56": "X_V_TEXT_WITH_CHILDREN",
		"X_V_MODEL_ON_INVALID_ELEMENT": 57,
		"57": "X_V_MODEL_ON_INVALID_ELEMENT",
		"X_V_MODEL_ARG_ON_ELEMENT": 58,
		"58": "X_V_MODEL_ARG_ON_ELEMENT",
		"X_V_MODEL_ON_FILE_INPUT_ELEMENT": 59,
		"59": "X_V_MODEL_ON_FILE_INPUT_ELEMENT",
		"X_V_MODEL_UNNECESSARY_VALUE": 60,
		"60": "X_V_MODEL_UNNECESSARY_VALUE",
		"X_V_SHOW_NO_EXPRESSION": 61,
		"61": "X_V_SHOW_NO_EXPRESSION",
		"X_TRANSITION_INVALID_CHILDREN": 62,
		"62": "X_TRANSITION_INVALID_CHILDREN",
		"X_IGNORED_SIDE_EFFECT_TAG": 63,
		"63": "X_IGNORED_SIDE_EFFECT_TAG",
		"__EXTEND_POINT__": 64,
		"64": "__EXTEND_POINT__"
	};
	const DOMErrorMessages = {
		[53]: `v-html is missing expression.`,
		[54]: `v-html will override element children.`,
		[55]: `v-text is missing expression.`,
		[56]: `v-text will override element children.`,
		[57]: `v-model can only be used on <input>, <textarea> and <select> elements.`,
		[58]: `v-model argument is not supported on plain elements.`,
		[59]: `v-model cannot be used on file inputs since they are read-only. Use a v-on:change listener instead.`,
		[60]: `Unnecessary value binding used alongside v-model. It will interfere with v-model's behavior.`,
		[61]: `v-show is missing expression.`,
		[62]: `<Transition> expects exactly one child element or component.`,
		[63]: `Tags with side effect (<script> and <style>) are ignored in client component templates.`
	};
	const transformVHtml = (dir, node, context) => {
		const { exp, loc } = dir;
		if (!exp) context.onError(createDOMCompilerError(53, loc));
		if (node.children.length) {
			context.onError(createDOMCompilerError(54, loc));
			node.children.length = 0;
		}
		return { props: [compilerCore.createObjectProperty(compilerCore.createSimpleExpression(`innerHTML`, true, loc), exp || compilerCore.createSimpleExpression("", true))] };
	};
	const transformVText = (dir, node, context) => {
		const { exp, loc } = dir;
		if (!exp) context.onError(createDOMCompilerError(55, loc));
		if (node.children.length) {
			context.onError(createDOMCompilerError(56, loc));
			node.children.length = 0;
		}
		return { props: [compilerCore.createObjectProperty(compilerCore.createSimpleExpression(`textContent`, true), exp ? compilerCore.getConstantType(exp, context) > 0 ? exp : compilerCore.createCallExpression(context.helperString(compilerCore.TO_DISPLAY_STRING), [exp], loc) : compilerCore.createSimpleExpression("", true))] };
	};
	const transformModel$1 = (dir, node, context) => {
		const baseResult = compilerCore.transformModel(dir, node, context);
		if (!baseResult.props.length || node.tagType === 1) return baseResult;
		if (dir.arg) context.onError(createDOMCompilerError(58, dir.arg.loc));
		const { tag } = node;
		const isCustomElement = context.isCustomElement(tag);
		if (tag === "input" || tag === "textarea" || tag === "select" || isCustomElement) {
			let directiveToUse = V_MODEL_TEXT;
			let isInvalidType = false;
			if (tag === "input" || isCustomElement) {
				const type = compilerCore.findProp(node, `type`);
				if (type) {
					if (type.type === 7) directiveToUse = V_MODEL_DYNAMIC;
					else if (type.value) switch (type.value.content) {
						case "radio":
							directiveToUse = V_MODEL_RADIO;
							break;
						case "checkbox":
							directiveToUse = V_MODEL_CHECKBOX;
							break;
						case "file":
							isInvalidType = true;
							context.onError(createDOMCompilerError(59, dir.loc));
							break;
					}
				} else if (compilerCore.hasDynamicKeyVBind(node)) directiveToUse = V_MODEL_DYNAMIC;
			} else if (tag === "select") directiveToUse = V_MODEL_SELECT;
			if (!isInvalidType) baseResult.needRuntime = context.helper(directiveToUse);
		} else context.onError(createDOMCompilerError(57, dir.loc));
		baseResult.props = baseResult.props.filter((p) => !(p.key.type === 4 && p.key.content === "modelValue"));
		return baseResult;
	};
	const isEventOptionModifier = /* @__PURE__ */ shared.makeMap(`passive,once,capture`);
	const isNonKeyModifier = /* @__PURE__ */ shared.makeMap(`stop,prevent,self,ctrl,shift,alt,meta,exact,middle`);
	const maybeKeyModifier = /* @__PURE__ */ shared.makeMap("left,right");
	const isKeyboardEvent = /* @__PURE__ */ shared.makeMap(`onkeyup,onkeydown,onkeypress`);
	const resolveModifiers = (key, modifiers, context, loc) => {
		const keyModifiers = [];
		const nonKeyModifiers = [];
		const eventOptionModifiers = [];
		for (let i = 0; i < modifiers.length; i++) {
			const modifier = modifiers[i].content;
			if (modifier === "native" && compilerCore.checkCompatEnabled("COMPILER_V_ON_NATIVE", context, loc)) eventOptionModifiers.push(modifier);
			else if (isEventOptionModifier(modifier)) eventOptionModifiers.push(modifier);
			else if (maybeKeyModifier(modifier)) if (compilerCore.isStaticExp(key)) if (isKeyboardEvent(key.content.toLowerCase())) keyModifiers.push(modifier);
			else nonKeyModifiers.push(modifier);
			else {
				keyModifiers.push(modifier);
				nonKeyModifiers.push(modifier);
			}
			else if (isNonKeyModifier(modifier)) nonKeyModifiers.push(modifier);
			else keyModifiers.push(modifier);
		}
		return {
			keyModifiers,
			nonKeyModifiers,
			eventOptionModifiers
		};
	};
	const transformClick = (key, event) => {
		const isStaticClick = compilerCore.isStaticExp(key) && key.content.toLowerCase() === "onclick";
		return isStaticClick ? compilerCore.createSimpleExpression(event, true) : key.type !== 4 ? compilerCore.createCompoundExpression([
			`(`,
			key,
			`) === "onClick" ? "${event}" : (`,
			key,
			`)`
		]) : key;
	};
	const transformOn = (dir, node, context) => {
		return compilerCore.transformOn(dir, node, context, (baseResult) => {
			const { modifiers } = dir;
			if (!modifiers.length) return baseResult;
			let { key, value: handlerExp } = baseResult.props[0];
			const { keyModifiers, nonKeyModifiers, eventOptionModifiers } = resolveModifiers(key, modifiers, context, dir.loc);
			if (nonKeyModifiers.includes("right")) key = transformClick(key, `onContextmenu`);
			if (nonKeyModifiers.includes("middle")) key = transformClick(key, `onMouseup`);
			if (nonKeyModifiers.length) handlerExp = compilerCore.createCallExpression(context.helper(V_ON_WITH_MODIFIERS), [handlerExp, JSON.stringify(nonKeyModifiers)]);
			if (keyModifiers.length && (!compilerCore.isStaticExp(key) || isKeyboardEvent(key.content.toLowerCase()))) handlerExp = compilerCore.createCallExpression(context.helper(V_ON_WITH_KEYS), [handlerExp, JSON.stringify(keyModifiers)]);
			if (eventOptionModifiers.length) {
				const modifierPostfix = eventOptionModifiers.map(shared.capitalize).join("");
				key = compilerCore.isStaticExp(key) ? compilerCore.createSimpleExpression(`${key.content}${modifierPostfix}`, true) : compilerCore.createCompoundExpression([
					`(`,
					key,
					`) + "${modifierPostfix}"`
				]);
			}
			return { props: [compilerCore.createObjectProperty(key, handlerExp)] };
		});
	};
	const transformShow = (dir, node, context) => {
		const { exp, loc } = dir;
		if (!exp) context.onError(createDOMCompilerError(61, loc));
		return {
			props: [],
			needRuntime: context.helper(V_SHOW)
		};
	};
	const expReplaceRE = /__VUE_EXP_START__(.*?)__VUE_EXP_END__/g;
	const stringifyStatic = (children, context, parent) => {
		if (context.scopes.vSlot > 0) return;
		const isParentCached = parent.type === 1 && parent.codegenNode && parent.codegenNode.type === 13 && parent.codegenNode.children && !shared.isArray(parent.codegenNode.children) && parent.codegenNode.children.type === 20;
		let nc = 0;
		let ec = 0;
		const currentChunk = [];
		const stringifyCurrentChunk = (currentIndex) => {
			if (nc >= 20 || ec >= 5) {
				const staticCall = compilerCore.createCallExpression(context.helper(compilerCore.CREATE_STATIC), [JSON.stringify(currentChunk.map((node) => stringifyNode(node, context)).join("")).replace(expReplaceRE, `" + $1 + "`), String(currentChunk.length)]);
				const deleteCount = currentChunk.length - 1;
				if (isParentCached) children.splice(currentIndex - currentChunk.length, currentChunk.length, staticCall);
				else {
					currentChunk[0].codegenNode.value = staticCall;
					if (currentChunk.length > 1) {
						children.splice(currentIndex - currentChunk.length + 1, deleteCount);
						const cacheIndex = context.cached.indexOf(currentChunk[currentChunk.length - 1].codegenNode);
						if (cacheIndex > -1) {
							for (let i2 = cacheIndex; i2 < context.cached.length; i2++) {
								const c = context.cached[i2];
								if (c) c.index -= deleteCount;
							}
							context.cached.splice(cacheIndex - deleteCount + 1, deleteCount);
						}
					}
				}
				return deleteCount;
			}
			return 0;
		};
		let i = 0;
		for (; i < children.length; i++) {
			const child = children[i];
			const isCached = isParentCached || getCachedNode(child);
			if (isCached) {
				const result = analyzeNode(child);
				if (result) {
					nc += result[0];
					ec += result[1];
					currentChunk.push(child);
					continue;
				}
			}
			i -= stringifyCurrentChunk(i);
			nc = 0;
			ec = 0;
			currentChunk.length = 0;
		}
		stringifyCurrentChunk(i);
	};
	const getCachedNode = (node) => {
		if ((node.type === 1 && node.tagType === 0 || node.type === 12) && node.codegenNode && node.codegenNode.type === 20) return node.codegenNode;
	};
	const dataAriaRE = /^(data|aria)-/;
	const isStringifiableAttr = (name, ns) => {
		return (ns === 0 ? shared.isKnownHtmlAttr(name) : ns === 1 ? shared.isKnownSvgAttr(name) : ns === 2 ? shared.isKnownMathMLAttr(name) : false) || dataAriaRE.test(name);
	};
	const isNonStringifiable = /* @__PURE__ */ shared.makeMap(`caption,thead,tr,th,tbody,td,tfoot,colgroup,col`);
	function analyzeNode(node) {
		if (node.type === 1 && isNonStringifiable(node.tag)) return false;
		if (node.type === 12) return [1, 0];
		let nc = 1;
		let ec = node.props.length > 0 ? 1 : 0;
		let bailed = false;
		const bail = () => {
			bailed = true;
			return false;
		};
		function walk$2(node2) {
			const isOptionTag = node2.tag === "option" && node2.ns === 0;
			for (let i = 0; i < node2.props.length; i++) {
				const p = node2.props[i];
				if (p.type === 6 && !isStringifiableAttr(p.name, node2.ns)) return bail();
				if (p.type === 7 && p.name === "bind") {
					if (p.arg && (p.arg.type === 8 || p.arg.isStatic && !isStringifiableAttr(p.arg.content, node2.ns))) return bail();
					if (p.exp && (p.exp.type === 8 || p.exp.constType < 3)) return bail();
					if (isOptionTag && compilerCore.isStaticArgOf(p.arg, "value") && p.exp && !p.exp.isStatic) return bail();
				}
			}
			for (let i = 0; i < node2.children.length; i++) {
				nc++;
				const child = node2.children[i];
				if (child.type === 1) {
					if (child.props.length > 0) ec++;
					walk$2(child);
					if (bailed) return false;
				}
			}
			return true;
		}
		return walk$2(node) ? [nc, ec] : false;
	}
	function stringifyNode(node, context) {
		if (shared.isString(node)) return node;
		if (shared.isSymbol(node)) return ``;
		switch (node.type) {
			case 1: return stringifyElement(node, context);
			case 2: return shared.escapeHtml(node.content);
			case 3: return `<!--${shared.escapeHtml(node.content)}-->`;
			case 5: return shared.escapeHtml(shared.toDisplayString(evaluateConstant(node.content)));
			case 8: return shared.escapeHtml(evaluateConstant(node));
			case 12: return stringifyNode(node.content, context);
			default: return "";
		}
	}
	function stringifyElement(node, context) {
		let res = `<${node.tag}`;
		let innerHTML = "";
		for (let i = 0; i < node.props.length; i++) {
			const p = node.props[i];
			if (p.type === 6) {
				res += ` ${p.name}`;
				if (p.value) res += `="${shared.escapeHtml(p.value.content)}"`;
			} else if (p.type === 7) {
				if (p.name === "bind") {
					const exp = p.exp;
					if (exp.content[0] === "_") {
						res += ` ${p.arg.content}="__VUE_EXP_START__${exp.content}__VUE_EXP_END__"`;
						continue;
					}
					if (shared.isBooleanAttr(p.arg.content) && exp.content === "false") continue;
					let evaluated = evaluateConstant(exp);
					if (evaluated != null) {
						const arg = p.arg && p.arg.content;
						if (arg === "class") evaluated = shared.normalizeClass(evaluated);
						else if (arg === "style") evaluated = shared.stringifyStyle(shared.normalizeStyle(evaluated));
						res += ` ${p.arg.content}="${shared.escapeHtml(evaluated)}"`;
					}
				} else if (p.name === "html") innerHTML = evaluateConstant(p.exp);
				else if (p.name === "text") innerHTML = shared.escapeHtml(shared.toDisplayString(evaluateConstant(p.exp)));
			}
		}
		if (context.scopeId) res += ` ${context.scopeId}`;
		res += `>`;
		if (innerHTML) res += innerHTML;
		else for (let i = 0; i < node.children.length; i++) res += stringifyNode(node.children[i], context);
		if (!shared.isVoidTag(node.tag)) res += `</${node.tag}>`;
		return res;
	}
	function evaluateConstant(exp) {
		if (exp.type === 4) return new Function(`return (${exp.content})`)();
		else {
			let res = ``;
			exp.children.forEach((c) => {
				if (shared.isString(c) || shared.isSymbol(c)) return;
				if (c.type === 2) res += c.content;
				else if (c.type === 5) res += shared.toDisplayString(evaluateConstant(c.content));
				else res += evaluateConstant(c);
			});
			return res;
		}
	}
	const ignoreSideEffectTags = (node, context) => {
		if (node.type === 1 && node.tagType === 0 && (node.tag === "script" || node.tag === "style")) context.removeNode();
	};
	const DOMNodeTransforms = [transformStyle, ...[]];
	const DOMDirectiveTransforms = {
		cloak: compilerCore.noopDirectiveTransform,
		html: transformVHtml,
		text: transformVText,
		model: transformModel$1,
		on: transformOn,
		show: transformShow
	};
	function compile$3(src, options = {}) {
		return compilerCore.baseCompile(src, shared.extend({}, parserOptions, options, {
			nodeTransforms: [
				ignoreSideEffectTags,
				...DOMNodeTransforms,
				...options.nodeTransforms || []
			],
			directiveTransforms: shared.extend({}, DOMDirectiveTransforms, options.directiveTransforms || {}),
			transformHoist: stringifyStatic
		}));
	}
	function parse$2(template, options = {}) {
		return compilerCore.baseParse(template, shared.extend({}, parserOptions, options));
	}
	exports.DOMDirectiveTransforms = DOMDirectiveTransforms;
	exports.DOMErrorCodes = DOMErrorCodes;
	exports.DOMErrorMessages = DOMErrorMessages;
	exports.DOMNodeTransforms = DOMNodeTransforms;
	exports.TRANSITION = TRANSITION;
	exports.TRANSITION_GROUP = TRANSITION_GROUP;
	exports.V_MODEL_CHECKBOX = V_MODEL_CHECKBOX;
	exports.V_MODEL_DYNAMIC = V_MODEL_DYNAMIC;
	exports.V_MODEL_RADIO = V_MODEL_RADIO;
	exports.V_MODEL_SELECT = V_MODEL_SELECT;
	exports.V_MODEL_TEXT = V_MODEL_TEXT;
	exports.V_ON_WITH_KEYS = V_ON_WITH_KEYS;
	exports.V_ON_WITH_MODIFIERS = V_ON_WITH_MODIFIERS;
	exports.V_SHOW = V_SHOW;
	exports.compile = compile$3;
	exports.createDOMCompilerError = createDOMCompilerError;
	exports.parse = parse$2;
	exports.parserOptions = parserOptions;
	exports.transformStyle = transformStyle;
	Object.keys(compilerCore).forEach(function(k) {
		if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k)) exports[k] = compilerCore[k];
	});
} });

//#endregion
//#region node_modules/@vue/compiler-dom/index.js
var require_compiler_dom = __commonJS({ "node_modules/@vue/compiler-dom/index.js"(exports, module) {
	module.exports = require_compiler_dom_cjs_prod();
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/utils/index.js
var require_utils$1 = __commonJS({ "node_modules/@vue/language-core/lib/codegen/utils/index.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.identifierRegex = exports.combineLastMapping = exports.endOfLine = exports.newLine = void 0;
	exports.collectVars = collectVars;
	exports.collectIdentifiers = collectIdentifiers;
	exports.normalizeAttributeValue = normalizeAttributeValue;
	exports.createTsAst = createTsAst;
	exports.generateSfcBlockSection = generateSfcBlockSection;
	const shared_1$25 = require_shared$1();
	exports.newLine = `\n`;
	exports.endOfLine = `;${exports.newLine}`;
	exports.combineLastMapping = { __combineOffset: 1 };
	exports.identifierRegex = /^[a-zA-Z_$][0-9a-zA-Z_$]*$/;
	function collectVars(ts, node, ast, results = []) {
		const identifiers = collectIdentifiers(ts, node, []);
		for (const { id } of identifiers) results.push((0, shared_1$25.getNodeText)(ts, id, ast));
		return results;
	}
	function collectIdentifiers(ts, node, results = [], isRest = false, initializer = void 0) {
		if (ts.isIdentifier(node)) results.push({
			id: node,
			isRest,
			initializer
		});
		else if (ts.isObjectBindingPattern(node)) for (const el of node.elements) collectIdentifiers(ts, el.name, results, !!el.dotDotDotToken, el.initializer);
		else if (ts.isArrayBindingPattern(node)) {
			for (const el of node.elements) if (ts.isBindingElement(el)) collectIdentifiers(ts, el.name, results, !!el.dotDotDotToken);
		} else ts.forEachChild(node, (node$1) => collectIdentifiers(ts, node$1, results, false));
		return results;
	}
	function normalizeAttributeValue(node) {
		let offset = node.loc.start.offset;
		let content = node.loc.source;
		if (content.startsWith(`'`) && content.endsWith(`'`) || content.startsWith(`"`) && content.endsWith(`"`)) {
			offset++;
			content = content.slice(1, -1);
		}
		return [content, offset];
	}
	function createTsAst(ts, inlineTsAsts, text$1) {
		let ast = inlineTsAsts?.get(text$1);
		if (!ast) {
			ast = ts.createSourceFile("/a.ts", text$1, 99);
			inlineTsAsts?.set(text$1, ast);
		}
		ast.__volar_used = true;
		return ast;
	}
	function generateSfcBlockSection(block, start, end, features) {
		return [
			block.content.slice(start, end),
			block.name,
			start,
			features
		];
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/utils/wrapWith.js
var require_wrapWith = __commonJS({ "node_modules/@vue/language-core/lib/codegen/utils/wrapWith.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.wrapWith = wrapWith;
	function* wrapWith(startOffset, endOffset, ...args) {
		let source = "template";
		let features;
		let codes;
		if (typeof args[0] === "string") [source, features, ...codes] = args;
		else [features, ...codes] = args;
		yield [
			"",
			source,
			startOffset,
			features
		];
		let offset = 1;
		for (const code$1 of codes) {
			if (typeof code$1 !== "string") offset++;
			yield code$1;
		}
		yield [
			"",
			source,
			endOffset,
			{ __combineOffset: offset }
		];
	}
} });

//#endregion
//#region node_modules/alien-signals/cjs/system.cjs
var require_system = __commonJS({ "node_modules/alien-signals/cjs/system.cjs"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.ReactiveFlags = void 0;
	exports.createReactiveSystem = createReactiveSystem;
	var ReactiveFlags;
	(function(ReactiveFlags$1) {
		ReactiveFlags$1[ReactiveFlags$1["None"] = 0] = "None";
		ReactiveFlags$1[ReactiveFlags$1["Mutable"] = 1] = "Mutable";
		ReactiveFlags$1[ReactiveFlags$1["Watching"] = 2] = "Watching";
		ReactiveFlags$1[ReactiveFlags$1["RecursedCheck"] = 4] = "RecursedCheck";
		ReactiveFlags$1[ReactiveFlags$1["Recursed"] = 8] = "Recursed";
		ReactiveFlags$1[ReactiveFlags$1["Dirty"] = 16] = "Dirty";
		ReactiveFlags$1[ReactiveFlags$1["Pending"] = 32] = "Pending";
	})(ReactiveFlags || (exports.ReactiveFlags = ReactiveFlags = {}));
	function createReactiveSystem({ update, notify: notify$1, unwatched }) {
		return {
			link: link$1,
			unlink: unlink$1,
			propagate: propagate$1,
			checkDirty: checkDirty$1,
			endTracking: endTracking$1,
			startTracking: startTracking$1,
			shallowPropagate: shallowPropagate$1
		};
		function link$1(dep, sub) {
			const prevDep = sub.depsTail;
			if (prevDep !== void 0 && prevDep.dep === dep) return;
			let nextDep = void 0;
			const recursedCheck = sub.flags & 4;
			if (recursedCheck) {
				nextDep = prevDep !== void 0 ? prevDep.nextDep : sub.deps;
				if (nextDep !== void 0 && nextDep.dep === dep) {
					sub.depsTail = nextDep;
					return;
				}
			}
			const prevSub = dep.subsTail;
			if (prevSub !== void 0 && prevSub.sub === sub && (!recursedCheck || isValidLink(prevSub, sub))) return;
			const newLink = sub.depsTail = dep.subsTail = {
				dep,
				sub,
				prevDep,
				nextDep,
				prevSub,
				nextSub: void 0
			};
			if (nextDep !== void 0) nextDep.prevDep = newLink;
			if (prevDep !== void 0) prevDep.nextDep = newLink;
			else sub.deps = newLink;
			if (prevSub !== void 0) prevSub.nextSub = newLink;
			else dep.subs = newLink;
		}
		function unlink$1(link$2, sub = link$2.sub) {
			const dep = link$2.dep;
			const prevDep = link$2.prevDep;
			const nextDep = link$2.nextDep;
			const nextSub = link$2.nextSub;
			const prevSub = link$2.prevSub;
			if (nextDep !== void 0) nextDep.prevDep = prevDep;
			else sub.depsTail = prevDep;
			if (prevDep !== void 0) prevDep.nextDep = nextDep;
			else sub.deps = nextDep;
			if (nextSub !== void 0) nextSub.prevSub = prevSub;
			else dep.subsTail = prevSub;
			if (prevSub !== void 0) prevSub.nextSub = nextSub;
			else if ((dep.subs = nextSub) === void 0) unwatched(dep);
			return nextDep;
		}
		function propagate$1(link$2) {
			let next$1 = link$2.nextSub;
			let stack$1;
			top: do {
				const sub = link$2.sub;
				let flags = sub.flags;
				if (flags & 3) {
					if (!(flags & 60)) sub.flags = flags | 32;
					else if (!(flags & 12)) flags = 0;
					else if (!(flags & 4)) sub.flags = flags & -9 | 32;
					else if (!(flags & 48) && isValidLink(link$2, sub)) {
						sub.flags = flags | 40;
						flags &= 1;
					} else flags = 0;
					if (flags & 2) notify$1(sub);
					if (flags & 1) {
						const subSubs = sub.subs;
						if (subSubs !== void 0) {
							link$2 = subSubs;
							if (subSubs.nextSub !== void 0) {
								stack$1 = {
									value: next$1,
									prev: stack$1
								};
								next$1 = link$2.nextSub;
							}
							continue;
						}
					}
				}
				if ((link$2 = next$1) !== void 0) {
					next$1 = link$2.nextSub;
					continue;
				}
				while (stack$1 !== void 0) {
					link$2 = stack$1.value;
					stack$1 = stack$1.prev;
					if (link$2 !== void 0) {
						next$1 = link$2.nextSub;
						continue top;
					}
				}
				break;
			} while (true);
		}
		function startTracking$1(sub) {
			sub.depsTail = void 0;
			sub.flags = sub.flags & -57 | 4;
		}
		function endTracking$1(sub) {
			const depsTail = sub.depsTail;
			let toRemove = depsTail !== void 0 ? depsTail.nextDep : sub.deps;
			while (toRemove !== void 0) toRemove = unlink$1(toRemove, sub);
			sub.flags &= -5;
		}
		function checkDirty$1(link$2, sub) {
			let stack$1;
			let checkDepth = 0;
			top: do {
				const dep = link$2.dep;
				const depFlags = dep.flags;
				let dirty = false;
				if (sub.flags & 16) dirty = true;
				else if ((depFlags & 17) === 17) {
					if (update(dep)) {
						const subs = dep.subs;
						if (subs.nextSub !== void 0) shallowPropagate$1(subs);
						dirty = true;
					}
				} else if ((depFlags & 33) === 33) {
					if (link$2.nextSub !== void 0 || link$2.prevSub !== void 0) stack$1 = {
						value: link$2,
						prev: stack$1
					};
					link$2 = dep.deps;
					sub = dep;
					++checkDepth;
					continue;
				}
				if (!dirty && link$2.nextDep !== void 0) {
					link$2 = link$2.nextDep;
					continue;
				}
				while (checkDepth) {
					--checkDepth;
					const firstSub = sub.subs;
					const hasMultipleSubs = firstSub.nextSub !== void 0;
					if (hasMultipleSubs) {
						link$2 = stack$1.value;
						stack$1 = stack$1.prev;
					} else link$2 = firstSub;
					if (dirty) {
						if (update(sub)) {
							if (hasMultipleSubs) shallowPropagate$1(firstSub);
							sub = link$2.sub;
							continue;
						}
					} else sub.flags &= -33;
					sub = link$2.sub;
					if (link$2.nextDep !== void 0) {
						link$2 = link$2.nextDep;
						continue top;
					}
					dirty = false;
				}
				return dirty;
			} while (true);
		}
		function shallowPropagate$1(link$2) {
			do {
				const sub = link$2.sub;
				const nextSub = link$2.nextSub;
				const subFlags = sub.flags;
				if ((subFlags & 48) === 32) {
					sub.flags = subFlags | 16;
					if (subFlags & 2) notify$1(sub);
				}
				link$2 = nextSub;
			} while (link$2 !== void 0);
		}
		function isValidLink(checkLink, sub) {
			const depsTail = sub.depsTail;
			if (depsTail !== void 0) {
				let link$2 = sub.deps;
				do {
					if (link$2 === checkLink) return true;
					if (link$2 === depsTail) break;
					link$2 = link$2.nextDep;
				} while (link$2 !== void 0);
			}
			return false;
		}
	}
} });

//#endregion
//#region node_modules/alien-signals/cjs/index.cjs
var require_cjs = __commonJS({ "node_modules/alien-signals/cjs/index.cjs"(exports) {
	var __createBinding$3 = void 0 && (void 0).__createBinding || (Object.create ? function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		var desc = Object.getOwnPropertyDescriptor(m, k);
		if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) desc = {
			enumerable: true,
			get: function() {
				return m[k];
			}
		};
		Object.defineProperty(o, k2, desc);
	} : function(o, m, k, k2) {
		if (k2 === void 0) k2 = k;
		o[k2] = m[k];
	});
	var __exportStar$3 = void 0 && (void 0).__exportStar || function(m, exports$1) {
		for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, p)) __createBinding$3(exports$1, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.batchDepth = void 0;
	exports.getCurrentSub = getCurrentSub;
	exports.setCurrentSub = setCurrentSub;
	exports.getCurrentScope = getCurrentScope;
	exports.setCurrentScope = setCurrentScope;
	exports.startBatch = startBatch;
	exports.endBatch = endBatch;
	exports.pauseTracking = pauseTracking;
	exports.resumeTracking = resumeTracking;
	exports.signal = signal;
	exports.computed = computed;
	exports.effect = effect;
	exports.effectScope = effectScope;
	__exportStar$3(require_system(), exports);
	const system_js_1 = require_system();
	const pauseStack = [];
	const queuedEffects = [];
	const { link, unlink, propagate, checkDirty, endTracking, startTracking, shallowPropagate } = (0, system_js_1.createReactiveSystem)({
		update(signal$1) {
			if ("getter" in signal$1) return updateComputed(signal$1);
			else return updateSignal(signal$1, signal$1.value);
		},
		notify,
		unwatched(node) {
			if ("getter" in node) {
				let toRemove = node.deps;
				if (toRemove !== void 0) {
					node.flags = 17;
					do
						toRemove = unlink(toRemove, node);
					while (toRemove !== void 0);
				}
			} else if (!("previousValue" in node)) effectOper.call(node);
		}
	});
	exports.batchDepth = 0;
	let notifyIndex = 0;
	let queuedEffectsLength = 0;
	let activeSub;
	let activeScope;
	function getCurrentSub() {
		return activeSub;
	}
	function setCurrentSub(sub) {
		const prevSub = activeSub;
		activeSub = sub;
		return prevSub;
	}
	function getCurrentScope() {
		return activeScope;
	}
	function setCurrentScope(scope) {
		const prevScope = activeScope;
		activeScope = scope;
		return prevScope;
	}
	function startBatch() {
		++exports.batchDepth;
	}
	function endBatch() {
		if (!--exports.batchDepth) flush();
	}
	function pauseTracking() {
		pauseStack.push(setCurrentSub(void 0));
	}
	function resumeTracking() {
		setCurrentSub(pauseStack.pop());
	}
	function signal(initialValue) {
		return signalOper.bind({
			previousValue: initialValue,
			value: initialValue,
			subs: void 0,
			subsTail: void 0,
			flags: 1
		});
	}
	function computed(getter) {
		return computedOper.bind({
			value: void 0,
			subs: void 0,
			subsTail: void 0,
			deps: void 0,
			depsTail: void 0,
			flags: 17,
			getter
		});
	}
	function effect(fn) {
		const e = {
			fn,
			subs: void 0,
			subsTail: void 0,
			deps: void 0,
			depsTail: void 0,
			flags: 2
		};
		if (activeSub !== void 0) link(e, activeSub);
		else if (activeScope !== void 0) link(e, activeScope);
		const prev = setCurrentSub(e);
		try {
			e.fn();
		} finally {
			setCurrentSub(prev);
		}
		return effectOper.bind(e);
	}
	function effectScope(fn) {
		const e = {
			deps: void 0,
			depsTail: void 0,
			subs: void 0,
			subsTail: void 0,
			flags: 0
		};
		if (activeScope !== void 0) link(e, activeScope);
		const prevSub = setCurrentSub(void 0);
		const prevScope = setCurrentScope(e);
		try {
			fn();
		} finally {
			setCurrentScope(prevScope);
			setCurrentSub(prevSub);
		}
		return effectOper.bind(e);
	}
	function updateComputed(c) {
		const prevSub = setCurrentSub(c);
		startTracking(c);
		try {
			const oldValue = c.value;
			return oldValue !== (c.value = c.getter(oldValue));
		} finally {
			setCurrentSub(prevSub);
			endTracking(c);
		}
	}
	function updateSignal(s, value) {
		s.flags = 1;
		return s.previousValue !== (s.previousValue = value);
	}
	function notify(e) {
		const flags = e.flags;
		if (!(flags & 64)) {
			e.flags = flags | 64;
			const subs = e.subs;
			if (subs !== void 0) notify(subs.sub);
			else queuedEffects[queuedEffectsLength++] = e;
		}
	}
	function run(e, flags) {
		if (flags & 16 || flags & 32 && checkDirty(e.deps, e)) {
			const prev = setCurrentSub(e);
			startTracking(e);
			try {
				e.fn();
			} finally {
				setCurrentSub(prev);
				endTracking(e);
			}
			return;
		} else if (flags & 32) e.flags = flags & -33;
		let link$1 = e.deps;
		while (link$1 !== void 0) {
			const dep = link$1.dep;
			const depFlags = dep.flags;
			if (depFlags & 64) run(dep, dep.flags = depFlags & -65);
			link$1 = link$1.nextDep;
		}
	}
	function flush() {
		while (notifyIndex < queuedEffectsLength) {
			const effect$1 = queuedEffects[notifyIndex];
			queuedEffects[notifyIndex++] = void 0;
			run(effect$1, effect$1.flags &= -65);
		}
		notifyIndex = 0;
		queuedEffectsLength = 0;
	}
	function computedOper() {
		const flags = this.flags;
		if (flags & 16 || flags & 32 && checkDirty(this.deps, this)) {
			if (updateComputed(this)) {
				const subs = this.subs;
				if (subs !== void 0) shallowPropagate(subs);
			}
		} else if (flags & 32) this.flags = flags & -33;
		if (activeSub !== void 0) link(this, activeSub);
		else if (activeScope !== void 0) link(this, activeScope);
		return this.value;
	}
	function signalOper(...value) {
		if (value.length) {
			const newValue = value[0];
			if (this.value !== (this.value = newValue)) {
				this.flags = 17;
				const subs = this.subs;
				if (subs !== void 0) {
					propagate(subs);
					if (!exports.batchDepth) flush();
				}
			}
		} else {
			const value$1 = this.value;
			if (this.flags & 16) {
				if (updateSignal(this, value$1)) {
					const subs = this.subs;
					if (subs !== void 0) shallowPropagate(subs);
				}
			}
			if (activeSub !== void 0) link(this, activeSub);
			return value$1;
		}
	}
	function effectOper() {
		let dep = this.deps;
		while (dep !== void 0) dep = unlink(dep, this);
		const sub = this.subs;
		if (sub !== void 0) unlink(sub);
		this.flags = 0;
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/utils/parseCssVars.js
var require_parseCssVars = __commonJS({ "node_modules/@vue/language-core/lib/utils/parseCssVars.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.commentReg = void 0;
	exports.parseCssVars = parseCssVars;
	exports.fillBlank = fillBlank;
	const vBindCssVarReg = /\bv-bind\(\s*(?:'([^']+)'|"([^"]+)"|([a-z_]\w*))\s*\)/gi;
	exports.commentReg = /(?<=\/\*)[\s\S]*?(?=\*\/)|(?<=\/\/)[\s\S]*?(?=\n)/g;
	function* parseCssVars(css) {
		css = fillBlank(css, exports.commentReg);
		const matchs = css.matchAll(vBindCssVarReg);
		for (const match$1 of matchs) {
			const matchText = match$1.slice(1).find((t) => t);
			if (matchText) {
				const offset = match$1.index + css.slice(match$1.index).indexOf(matchText);
				yield {
					offset,
					text: matchText
				};
			}
		}
	}
	function fillBlank(css, ...regs) {
		for (const reg of regs) css = css.replace(reg, (match$1) => " ".repeat(match$1.length));
		return css;
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/utils/parseCssClassNames.js
var require_parseCssClassNames = __commonJS({ "node_modules/@vue/language-core/lib/utils/parseCssClassNames.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.parseCssClassNames = parseCssClassNames;
	const parseCssVars_1$1 = require_parseCssVars();
	const cssClassNameReg = /(?=(\.[a-z_][-\w]*)[\s.,+~>:#)[{])/gi;
	const fragmentReg = /(?<={)[^{]*(?=(?<!\\);)/g;
	function* parseCssClassNames(css) {
		css = (0, parseCssVars_1$1.fillBlank)(css, parseCssVars_1$1.commentReg, fragmentReg);
		const matches = css.matchAll(cssClassNameReg);
		for (const match$1 of matches) {
			const matchText = match$1[1];
			if (matchText) yield {
				offset: match$1.index,
				text: matchText
			};
		}
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/utils/parseCssImports.js
var require_parseCssImports = __commonJS({ "node_modules/@vue/language-core/lib/utils/parseCssImports.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.parseCssImports = parseCssImports;
	const cssImportReg = /(?<=@import\s+url\()(["']?).*?\1(?=\))|(?<=@import\b\s*)(["']).*?\2/g;
	function* parseCssImports(css) {
		const matches = css.matchAll(cssImportReg);
		for (const match$1 of matches) {
			let text$1 = match$1[0];
			let offset = match$1.index;
			if (text$1.startsWith("'") || text$1.startsWith("\"")) {
				text$1 = text$1.slice(1, -1);
				offset += 1;
			}
			if (text$1) yield {
				text: text$1,
				offset
			};
		}
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/utils/signals.js
var require_signals = __commonJS({ "node_modules/@vue/language-core/lib/utils/signals.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.computedArray = computedArray;
	exports.computedSet = computedSet;
	exports.computedItems = computedItems;
	const alien_signals_1$5 = require_cjs();
	function computedArray(arr, getGetter) {
		const length = (0, alien_signals_1$5.computed)(() => arr().length);
		const keys = (0, alien_signals_1$5.computed)(() => {
			const keys$1 = [];
			for (let i = 0; i < length(); i++) keys$1.push(String(i));
			return keys$1;
		});
		const items = (0, alien_signals_1$5.computed)((array) => {
			array ??= [];
			while (array.length < length()) {
				const index$1 = array.length;
				const item = (0, alien_signals_1$5.computed)(() => arr()[index$1]);
				array.push((0, alien_signals_1$5.computed)(getGetter(item, index$1)));
			}
			if (array.length > length()) array.length = length();
			return array;
		});
		return new Proxy({}, {
			get(_, p, receiver) {
				if (p === "length") return length();
				if (typeof p === "string" && !isNaN(Number(p))) return items()[Number(p)]?.();
				return Reflect.get(items(), p, receiver);
			},
			has(_, p) {
				return Reflect.has(items(), p);
			},
			ownKeys() {
				return keys();
			}
		});
	}
	function computedSet(source) {
		return (0, alien_signals_1$5.computed)((oldValue) => {
			const newValue = source();
			if (oldValue?.size === newValue.size && [...oldValue].every((c) => newValue.has(c))) return oldValue;
			return newValue;
		});
	}
	function computedItems(source, compareFn) {
		return (0, alien_signals_1$5.computed)((oldArr) => {
			oldArr ??= [];
			const newArr = source();
			if (oldArr.length === newArr.length && oldArr.every((item, index$1) => compareFn(item, newArr[index$1]))) return oldArr;
			return newArr;
		});
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/virtualFile/computedSfc.js
var require_computedSfc = __commonJS({ "node_modules/@vue/language-core/lib/virtualFile/computedSfc.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.templateInlineTsAsts = void 0;
	exports.computedSfc = computedSfc;
	const alien_signals_1$4 = require_cjs();
	const parseCssClassNames_1 = require_parseCssClassNames();
	const parseCssImports_1 = require_parseCssImports();
	const parseCssVars_1 = require_parseCssVars();
	const signals_1$1 = require_signals();
	exports.templateInlineTsAsts = /* @__PURE__ */ new WeakMap();
	function computedSfc(ts, plugins, fileName, getSnapshot, getParseResult) {
		const getUntrackedSnapshot = () => {
			const pausedSub = (0, alien_signals_1$4.setCurrentSub)(void 0);
			const res = getSnapshot();
			(0, alien_signals_1$4.setCurrentSub)(pausedSub);
			return res;
		};
		const getContent = (0, alien_signals_1$4.computed)(() => {
			return getSnapshot().getText(0, getSnapshot().getLength());
		});
		const getComments = (0, alien_signals_1$4.computed)((oldValue) => {
			const newValue = getParseResult()?.descriptor.comments ?? [];
			if (oldValue?.length === newValue.length && oldValue?.every((v, i) => v === newValue[i])) return oldValue;
			return newValue;
		});
		const getTemplate = computedNullableSfcBlock("template", "html", (0, alien_signals_1$4.computed)(() => getParseResult()?.descriptor.template ?? void 0), (_block, base) => {
			const compiledAst = computedTemplateAst(base);
			return mergeObject(base, {
				get ast() {
					return compiledAst()?.ast;
				},
				get errors() {
					return compiledAst()?.errors;
				},
				get warnings() {
					return compiledAst()?.warnings;
				}
			});
		});
		const getScript = computedNullableSfcBlock("script", "js", (0, alien_signals_1$4.computed)(() => getParseResult()?.descriptor.script ?? void 0), (block, base) => {
			const getSrc = computedAttrValue("__src", base, block);
			const getAst = (0, alien_signals_1$4.computed)(() => {
				for (const plugin$13 of plugins) {
					const ast = plugin$13.compileSFCScript?.(base.lang, base.content);
					if (ast) return ast;
				}
				return ts.createSourceFile(fileName + "." + base.lang, "", 99);
			});
			return mergeObject(base, {
				get src() {
					return getSrc();
				},
				get ast() {
					return getAst();
				}
			});
		});
		const getOriginalScriptSetup = computedNullableSfcBlock("scriptSetup", "js", (0, alien_signals_1$4.computed)(() => getParseResult()?.descriptor.scriptSetup ?? void 0), (block, base) => {
			const getGeneric = computedAttrValue("__generic", base, block);
			const getAst = (0, alien_signals_1$4.computed)(() => {
				for (const plugin$13 of plugins) {
					const ast = plugin$13.compileSFCScript?.(base.lang, base.content);
					if (ast) return ast;
				}
				return ts.createSourceFile(fileName + "." + base.lang, "", 99);
			});
			return mergeObject(base, {
				get generic() {
					return getGeneric();
				},
				get ast() {
					return getAst();
				}
			});
		});
		const hasScript = (0, alien_signals_1$4.computed)(() => !!getParseResult()?.descriptor.script);
		const hasScriptSetup = (0, alien_signals_1$4.computed)(() => !!getParseResult()?.descriptor.scriptSetup);
		const getScriptSetup = (0, alien_signals_1$4.computed)(() => {
			if (!hasScript() && !hasScriptSetup()) return {
				content: "",
				lang: "ts",
				name: "",
				start: 0,
				end: 0,
				startTagEnd: 0,
				endTagStart: 0,
				generic: void 0,
				genericOffset: 0,
				attrs: {},
				ast: ts.createSourceFile("", "", 99, false, ts.ScriptKind.TS)
			};
			return getOriginalScriptSetup();
		});
		const styles = (0, signals_1$1.computedArray)((0, alien_signals_1$4.computed)(() => getParseResult()?.descriptor.styles ?? []), (getBlock, i) => {
			const base = computedSfcBlock("style_" + i, "css", getBlock);
			const getSrc = computedAttrValue("__src", base, getBlock);
			const getModule = computedAttrValue("__module", base, getBlock);
			const getScoped = (0, alien_signals_1$4.computed)(() => !!getBlock().scoped);
			const getImports = (0, signals_1$1.computedItems)(() => [...(0, parseCssImports_1.parseCssImports)(base.content)], (oldItem, newItem) => oldItem.text === newItem.text && oldItem.offset === newItem.offset);
			const getCssVars = (0, signals_1$1.computedItems)(() => [...(0, parseCssVars_1.parseCssVars)(base.content)], (oldItem, newItem) => oldItem.text === newItem.text && oldItem.offset === newItem.offset);
			const getClassNames = (0, signals_1$1.computedItems)(() => [...(0, parseCssClassNames_1.parseCssClassNames)(base.content)], (oldItem, newItem) => oldItem.text === newItem.text && oldItem.offset === newItem.offset);
			return () => mergeObject(base, {
				get src() {
					return getSrc();
				},
				get module() {
					return getModule();
				},
				get scoped() {
					return getScoped();
				},
				get imports() {
					return getImports();
				},
				get cssVars() {
					return getCssVars();
				},
				get classNames() {
					return getClassNames();
				}
			});
		});
		const customBlocks = (0, signals_1$1.computedArray)((0, alien_signals_1$4.computed)(() => getParseResult()?.descriptor.customBlocks ?? []), (getBlock, i) => {
			const base = computedSfcBlock("custom_block_" + i, "txt", getBlock);
			const getType$1 = (0, alien_signals_1$4.computed)(() => getBlock().type);
			return () => mergeObject(base, { get type() {
				return getType$1();
			} });
		});
		return {
			get content() {
				return getContent();
			},
			get comments() {
				return getComments();
			},
			get template() {
				return getTemplate();
			},
			get script() {
				return getScript();
			},
			get scriptSetup() {
				return getScriptSetup();
			},
			get styles() {
				return styles;
			},
			get customBlocks() {
				return customBlocks;
			}
		};
		function computedTemplateAst(base) {
			let cache;
			let inlineTsAsts;
			function updateInlineTsAsts(newAst, oldAst) {
				let newTsAsts = exports.templateInlineTsAsts.get(newAst);
				if (!newTsAsts) exports.templateInlineTsAsts.set(newAst, newTsAsts = /* @__PURE__ */ new Map());
				const oldTsAsts = oldAst && exports.templateInlineTsAsts.get(oldAst) || inlineTsAsts;
				if (oldTsAsts) for (const [text$1, ast] of oldTsAsts) if (!ast.__volar_used) oldTsAsts.delete(text$1);
				else {
					newTsAsts.set(text$1, ast);
					ast.__volar_used = false;
				}
				inlineTsAsts = new Map(newTsAsts);
			}
			return (0, alien_signals_1$4.computed)(() => {
				if (cache?.template === base.content) return {
					errors: [],
					warnings: [],
					ast: cache.result.ast
				};
				if (cache?.plugin.updateSFCTemplate) {
					const change = getUntrackedSnapshot().getChangeRange(cache.snapshot);
					if (change) {
						const pausedSub = (0, alien_signals_1$4.setCurrentSub)(void 0);
						const templateOffset = base.startTagEnd;
						(0, alien_signals_1$4.setCurrentSub)(pausedSub);
						const newText = getUntrackedSnapshot().getText(change.span.start, change.span.start + change.newLength);
						const newResult = cache.plugin.updateSFCTemplate(cache.result, {
							start: change.span.start - templateOffset,
							end: change.span.start + change.span.length - templateOffset,
							newText
						});
						if (newResult) {
							updateInlineTsAsts(newResult.ast, cache.result.ast);
							cache.template = base.content;
							cache.snapshot = getUntrackedSnapshot();
							cache.result = newResult;
							return {
								errors: [],
								warnings: [],
								ast: newResult.ast
							};
						}
					}
				}
				const errors = [];
				const warnings = [];
				let options = {
					onError: (err) => errors.push(err),
					onWarn: (err) => warnings.push(err),
					expressionPlugins: ["typescript"]
				};
				for (const plugin$13 of plugins) if (plugin$13.resolveTemplateCompilerOptions) options = plugin$13.resolveTemplateCompilerOptions(options);
				for (const plugin$13 of plugins) {
					let result;
					try {
						result = plugin$13.compileSFCTemplate?.(base.lang, base.content, options);
						if (result) updateInlineTsAsts(result.ast, cache?.result.ast);
					} catch (e) {
						const err = e;
						errors.push(err);
					}
					if (result || errors.length) {
						if (result && !errors.length && !warnings.length) cache = {
							template: base.content,
							snapshot: getUntrackedSnapshot(),
							result,
							plugin: plugin$13
						};
						else cache = void 0;
						return {
							errors,
							warnings,
							ast: result?.ast
						};
					}
				}
				return {
					errors,
					warnings,
					ast: void 0
				};
			});
		}
		function computedNullableSfcBlock(name, defaultLang, getBlock, resolve) {
			const hasBlock = (0, alien_signals_1$4.computed)(() => !!getBlock());
			return (0, alien_signals_1$4.computed)(() => {
				if (!hasBlock()) return;
				const _block = (0, alien_signals_1$4.computed)(() => getBlock());
				return resolve(_block, computedSfcBlock(name, defaultLang, _block));
			});
		}
		function computedSfcBlock(name, defaultLang, getBlock) {
			const getLang = (0, alien_signals_1$4.computed)(() => getBlock().lang ?? defaultLang);
			const getAttrs = (0, alien_signals_1$4.computed)(() => getBlock().attrs);
			const getContent$1 = (0, alien_signals_1$4.computed)(() => getBlock().content);
			const getStartTagEnd = (0, alien_signals_1$4.computed)(() => getBlock().loc.start.offset);
			const getEndTagStart = (0, alien_signals_1$4.computed)(() => getBlock().loc.end.offset);
			const getStart = (0, alien_signals_1$4.computed)(() => getUntrackedSnapshot().getText(0, getStartTagEnd()).lastIndexOf("<" + getBlock().type));
			const getEnd = (0, alien_signals_1$4.computed)(() => getEndTagStart() + getUntrackedSnapshot().getText(getEndTagStart(), getUntrackedSnapshot().getLength()).indexOf(">") + 1);
			return {
				name,
				get lang() {
					return getLang();
				},
				get attrs() {
					return getAttrs();
				},
				get content() {
					return getContent$1();
				},
				get startTagEnd() {
					return getStartTagEnd();
				},
				get endTagStart() {
					return getEndTagStart();
				},
				get start() {
					return getStart();
				},
				get end() {
					return getEnd();
				}
			};
		}
		function computedAttrValue(key, base, getBlock) {
			return (0, alien_signals_1$4.computed)(() => {
				const val = getBlock()[key];
				if (typeof val === "object") return {
					...val,
					offset: base.start + val.offset
				};
				return val;
			});
		}
	}
	function mergeObject(a, b) {
		return Object.defineProperties(a, Object.getOwnPropertyDescriptors(b));
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/codeFeatures.js
var require_codeFeatures = __commonJS({ "node_modules/@vue/language-core/lib/codegen/codeFeatures.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.codeFeatures = void 0;
	const raw = {
		all: {
			verification: true,
			completion: true,
			semantic: true,
			navigation: true
		},
		verification: { verification: true },
		completion: { completion: true },
		additionalCompletion: { completion: { isAdditional: true } },
		withoutCompletion: {
			verification: true,
			semantic: true,
			navigation: true
		},
		navigation: { navigation: true },
		navigationWithoutRename: { navigation: { shouldRename: () => false } },
		navigationAndCompletion: {
			navigation: true,
			completion: true
		},
		navigationAndAdditionalCompletion: {
			navigation: true,
			completion: { isAdditional: true }
		},
		navigationAndVerification: {
			navigation: true,
			verification: true
		},
		withoutNavigation: {
			verification: true,
			completion: true,
			semantic: true
		},
		semanticWithoutHighlight: { semantic: { shouldHighlight: () => false } },
		withoutHighlight: {
			semantic: { shouldHighlight: () => false },
			verification: true,
			navigation: true,
			completion: true
		},
		withoutHighlightAndNavigation: {
			semantic: { shouldHighlight: () => false },
			verification: true,
			completion: true
		},
		withoutHighlightAndCompletion: {
			semantic: { shouldHighlight: () => false },
			verification: true,
			navigation: true
		},
		withoutHighlightAndCompletionAndNavigation: {
			semantic: { shouldHighlight: () => false },
			verification: true
		},
		withoutSemantic: {
			verification: true,
			navigation: true,
			completion: true
		}
	};
	exports.codeFeatures = raw;
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/template/context.js
var require_context$1 = __commonJS({ "node_modules/@vue/language-core/lib/codegen/template/context.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createTemplateCodegenContext = createTemplateCodegenContext;
	const CompilerDOM$16 = require_compiler_dom();
	const computedSfc_1$2 = require_computedSfc();
	const codeFeatures_1$11 = require_codeFeatures();
	const utils_1$33 = require_utils$1();
	const wrapWith_1$15 = require_wrapWith();
	const commentDirectiveRegex = /^<!--\s*@vue-(?<name>[-\w]+)\b(?<content>[\s\S]*)-->$/;
	/**
	* Creates and returns a Context object used for generating type-checkable TS code
	* from the template section of a .vue file.
	*
	* ## Implementation Notes for supporting `@vue-ignore`, `@vue-expect-error`, and `@vue-skip` directives.
	*
	* Vue language tooling supports a number of directives for suppressing diagnostics within
	* Vue templates (https://github.com/vuejs/language-tools/pull/3215)
	*
	* Here is an overview for how support for how @vue-expect-error is implemented within this file
	* (@vue-expect-error is the most complicated directive to support due to its behavior of raising
	* a diagnostic when it is annotating a piece of code that doesn't actually have any errors/warning/diagnostics).
	*
	* Given .vue code:
	*
	* ```vue
	*   <script setup lang="ts">
	*   defineProps<{
	*     knownProp1: string;
	*     knownProp2: string;
	*     knownProp3: string;
	*     knownProp4_will_trigger_unused_expect_error: string;
	*   }>();
	*   </script>
	*
	*   <template>
	*     {{ knownProp1 }}
	*     {{ error_unknownProp }} <!-- ERROR: Property 'error_unknownProp' does not exist on type [...] -->
	*     {{ knownProp2 }}
	*     <!-- @vue-expect-error This suppresses an Unknown Property Error -->
	*     {{ suppressed_error_unknownProp }}
	*     {{ knownProp3 }}
	*     <!-- @vue-expect-error This will trigger Unused '@ts-expect-error' directive.ts(2578) -->
	*     {{ knownProp4_will_trigger_unused_expect_error }}
	*   </template>
	* ```
	*
	* The above code should raise two diagnostics:
	*
	* 1. Property 'error_unknownProp' does not exist on type [...]
	* 2. Unused '@ts-expect-error' directive.ts(2578) -- this is the bottom `@vue-expect-error` directive
	*    that covers code that doesn't actually raise an error -- note that all `@vue-...` directives
	*    will ultimately translate into `@ts-...` diagnostics.
	*
	* The above code will produce the following type-checkable TS code (note: omitting asterisks
	* to prevent VSCode syntax double-greying out double-commented code).
	*
	* ```ts
	*   ( __VLS_ctx.knownProp1 );
	*   ( __VLS_ctx.error_unknownProp ); // ERROR: Property 'error_unknownProp' does not exist on type [...]
	*   ( __VLS_ctx.knownProp2 );
	*   // @vue-expect-error start
	*   ( __VLS_ctx.suppressed_error_unknownProp );
	*   // @ts-expect-error __VLS_TS_EXPECT_ERROR
	*   ;
	*   // @vue-expect-error end of INTERPOLATION
	*   ( __VLS_ctx.knownProp3 );
	*   // @vue-expect-error start
	*   ( __VLS_ctx.knownProp4_will_trigger_unused_expect_error );
	*   // @ts-expect-error __VLS_TS_EXPECT_ERROR
	*   ;
	*   // @vue-expect-error end of INTERPOLATION
	* ```
	*
	* In the generated code, there are actually 3 diagnostic errors that'll be raised in the first
	* pass on this generated code (but through cleverness described below, not all of them will be
	* propagated back to the original .vue file):
	*
	* 1. Property 'error_unknownProp' does not exist on type [...]
	* 2. Unused '@ts-expect-error' directive.ts(2578) from the 1st `@ts-expect-error __VLS_TS_EXPECT_ERROR`
	* 3. Unused '@ts-expect-error' directive.ts(2578) from the 2nd `@ts-expect-error __VLS_TS_EXPECT_ERROR`
	*
	* Be sure to pay careful attention to the mixture of `@vue-expect-error` and `@ts-expect-error`;
	* Within the TS file, the only "real" directives recognized by TS are going to be prefixed with `@ts-`;
	* any `@vue-` prefixed directives in the comments are only for debugging purposes.
	*
	* As mentioned above, there are 3 diagnostics errors that'll be generated for the above code, but
	* only 2 should be propagated back to the original .vue file.
	*
	* (The reason we structure things this way is somewhat complicated, but in short it allows us
	* to lean on TS as much as possible to generate actual `unused @ts-expect-error directive` errors
	* while covering a number of edge cases.)
	*
	* So, we need a way to dynamically decide whether each of the `@ts-expect-error __VLS_TS_EXPECT_ERROR`
	* directives should be reported as an unused directive or not.
	*
	* To do this, we'll make use of the `shouldReport` callback that'll optionally be provided to the
	* `verification` property of the `CodeInformation` object attached to the mapping between source .vue
	* and generated .ts code. The `verification` property determines whether "verification" (which includes
	* semantic diagnostics) should be performed on the generated .ts code, and `shouldReport`, if provided,
	* can be used to determine whether a given diagnostic should be reported back "upwards" to the original
	* .vue file or not.
	*
	* See the comments in the code below for how and where we use this hook to keep track of whether
	* an error/diagnostic was encountered for a region of code covered by a `@vue-expect-error` directive,
	* and additionally how we use that to determine whether to propagate diagnostics back upward.
	*/
	function createTemplateCodegenContext(options, templateAst) {
		let variableId = 0;
		function resolveCodeFeatures(features) {
			if (features.verification && stack$1.length) {
				const data = stack$1[stack$1.length - 1];
				if (data.ignoreError) return {
					...features,
					verification: false
				};
				if (data.expectError !== void 0) return {
					...features,
					verification: { shouldReport: () => {
						data.expectError.token++;
						return false;
					} }
				};
			}
			return features;
		}
		const hoistVars = /* @__PURE__ */ new Map();
		const localVars = /* @__PURE__ */ new Map();
		const dollarVars = /* @__PURE__ */ new Set();
		const accessExternalVariables = /* @__PURE__ */ new Map();
		const slots = [];
		const dynamicSlots = [];
		const blockConditions = [];
		const scopedClasses = [];
		const emptyClassOffsets = [];
		const inlayHints = [];
		const bindingAttrLocs = [];
		const inheritedAttrVars = /* @__PURE__ */ new Set();
		const templateRefs = /* @__PURE__ */ new Map();
		const stack$1 = [];
		const commentBuffer = [];
		return {
			get currentInfo() {
				return stack$1[stack$1.length - 1];
			},
			codeFeatures: new Proxy(codeFeatures_1$11.codeFeatures, { get(target$1, key) {
				const data = target$1[key];
				return resolveCodeFeatures(data);
			} }),
			resolveCodeFeatures,
			inlineTsAsts: templateAst && computedSfc_1$2.templateInlineTsAsts.get(templateAst),
			inVFor: false,
			slots,
			dynamicSlots,
			dollarVars,
			accessExternalVariables,
			blockConditions,
			scopedClasses,
			emptyClassOffsets,
			inlayHints,
			bindingAttrLocs,
			inheritedAttrVars,
			templateRefs,
			currentComponent: void 0,
			singleRootElTypes: [],
			singleRootNodes: /* @__PURE__ */ new Set(),
			addTemplateRef(name, typeExp, offset) {
				let refs = templateRefs.get(name);
				if (!refs) templateRefs.set(name, refs = []);
				refs.push({
					typeExp,
					offset
				});
			},
			accessExternalVariable(name, offset) {
				let arr = accessExternalVariables.get(name);
				if (!arr) accessExternalVariables.set(name, arr = /* @__PURE__ */ new Set());
				if (offset !== void 0) arr.add(offset);
			},
			hasLocalVariable(name) {
				return !!localVars.get(name);
			},
			addLocalVariable(name) {
				localVars.set(name, (localVars.get(name) ?? 0) + 1);
			},
			removeLocalVariable(name) {
				localVars.set(name, localVars.get(name) - 1);
			},
			getInternalVariable() {
				return `__VLS_${variableId++}`;
			},
			getHoistVariable(originalVar) {
				let name = hoistVars.get(originalVar);
				if (name === void 0) hoistVars.set(originalVar, name = `__VLS_${variableId++}`);
				return name;
			},
			*generateHoistVariables() {
				if (hoistVars.size) {
					yield `// @ts-ignore${utils_1$33.newLine}`;
					yield `var `;
					for (const [originalVar, hoistVar] of hoistVars) yield `${hoistVar} = ${originalVar}, `;
					yield utils_1$33.endOfLine;
				}
			},
			*generateConditionGuards() {
				for (const condition of blockConditions) yield `if (!${condition}) return${utils_1$33.endOfLine}`;
			},
			*generateAutoImportCompletion() {
				const all = [...accessExternalVariables.entries()];
				if (!all.some(([_, offsets]) => offsets.size)) return;
				yield `// @ts-ignore${utils_1$33.newLine}`;
				yield `[`;
				for (const [varName, offsets] of all) {
					for (const offset of offsets) {
						if (options.scriptSetupBindingNames.has(varName)) yield [
							varName,
							"template",
							offset,
							{
								...codeFeatures_1$11.codeFeatures.additionalCompletion,
								...codeFeatures_1$11.codeFeatures.semanticWithoutHighlight
							}
						];
						else yield [
							varName,
							"template",
							offset,
							codeFeatures_1$11.codeFeatures.additionalCompletion
						];
						yield `,`;
					}
					offsets.clear();
				}
				yield `]${utils_1$33.endOfLine}`;
			},
			enter(node) {
				if (node.type === CompilerDOM$16.NodeTypes.COMMENT) {
					commentBuffer.push(node);
					return false;
				}
				const data = {};
				const comments = [...commentBuffer];
				commentBuffer.length = 0;
				for (const comment$1 of comments) {
					const match$1 = comment$1.loc.source.match(commentDirectiveRegex);
					if (match$1) {
						const { name, content } = match$1.groups;
						switch (name) {
							case "skip": return false;
							case "ignore": {
								data.ignoreError = true;
								break;
							}
							case "expect-error": {
								data.expectError = {
									token: 0,
									node: comment$1
								};
								break;
							}
							case "generic": {
								const text$1 = content.trim();
								if (text$1.startsWith("{") && text$1.endsWith("}")) data.generic = {
									content: text$1.slice(1, -1),
									offset: comment$1.loc.start.offset + comment$1.loc.source.indexOf("{") + 1
								};
								break;
							}
						}
					}
				}
				stack$1.push(data);
				return true;
			},
			*exit() {
				const data = stack$1.pop();
				commentBuffer.length = 0;
				if (data.expectError !== void 0) {
					yield* (0, wrapWith_1$15.wrapWith)(data.expectError.node.loc.start.offset, data.expectError.node.loc.end.offset, { verification: { shouldReport: () => data.expectError.token === 0 } }, `// @ts-expect-error`);
					yield `${utils_1$33.newLine}${utils_1$33.endOfLine}`;
				}
			}
		};
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/utils/camelized.js
var require_camelized = __commonJS({ "node_modules/@vue/language-core/lib/codegen/utils/camelized.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateCamelized = generateCamelized;
	const shared_1$24 = require_shared$2();
	function* generateCamelized(code$1, source, offset, features) {
		const parts = code$1.split("-");
		const startCombineOffset = features.__combineOffset ?? 0;
		for (let i = 0; i < parts.length; i++) {
			const part = parts[i];
			if (part !== "") if (i === 0) yield [
				part,
				source,
				offset,
				features
			];
			else yield [
				(0, shared_1$24.capitalize)(part),
				source,
				offset,
				{ __combineOffset: startCombineOffset + i }
			];
			offset += part.length + 1;
		}
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/utils/stringLiteralKey.js
var require_stringLiteralKey = __commonJS({ "node_modules/@vue/language-core/lib/codegen/utils/stringLiteralKey.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateStringLiteralKey = generateStringLiteralKey;
	const index_1$1 = require_utils$1();
	const wrapWith_1$14 = require_wrapWith();
	function* generateStringLiteralKey(code$1, offset, info) {
		if (offset === void 0 || !info) yield `'${code$1}'`;
		else yield* (0, wrapWith_1$14.wrapWith)(offset, offset + code$1.length, info, `'`, [
			code$1,
			"template",
			offset,
			index_1$1.combineLastMapping
		], `'`);
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/template/interpolation.js
var require_interpolation = __commonJS({ "node_modules/@vue/language-core/lib/codegen/template/interpolation.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateInterpolation = generateInterpolation;
	const shared_1$23 = require_shared$2();
	const shared_2$3 = require_shared$1();
	const utils_1$32 = require_utils$1();
	const isLiteralWhitelisted = /* @__PURE__ */ (0, shared_1$23.makeMap)("true,false,null,this");
	function* generateInterpolation(options, ctx, source, data, code$1, start, prefix$1 = "", suffix = "") {
		const { ts, destructuredPropNames, templateRefNames } = options;
		for (let [section, offset, type] of forEachInterpolationSegment(ts, ctx.inlineTsAsts, destructuredPropNames, templateRefNames, ctx, code$1, start, prefix$1, suffix)) if (offset === void 0) yield section;
		else {
			offset -= prefix$1.length;
			let addSuffix = "";
			const overLength = offset + section.length - code$1.length;
			if (overLength > 0) {
				addSuffix = section.slice(section.length - overLength);
				section = section.slice(0, -overLength);
			}
			if (offset < 0) {
				yield section.slice(0, -offset);
				section = section.slice(-offset);
				offset = 0;
			}
			const shouldSkip = section.length === 0 && (type === "startText" || type === "endText");
			if (!shouldSkip) if (start !== void 0 && data) yield [
				section,
				source,
				start + offset,
				type === "errorMappingOnly" ? ctx.codeFeatures.verification : typeof data === "function" ? data(start + offset) : data
			];
			else yield section;
			yield addSuffix;
		}
	}
	function* forEachInterpolationSegment(ts, inlineTsAsts, destructuredPropNames, templateRefNames, ctx, originalCode, start, prefix$1, suffix) {
		const code$1 = prefix$1 + originalCode + suffix;
		const offset = start !== void 0 ? start - prefix$1.length : void 0;
		let ctxVars = [];
		if (utils_1$32.identifierRegex.test(originalCode) && !shouldIdentifierSkipped(ctx, originalCode, destructuredPropNames)) ctxVars.push({
			text: originalCode,
			offset: prefix$1.length
		});
		else {
			const ast = (0, utils_1$32.createTsAst)(ts, inlineTsAsts, code$1);
			const varCb = (id, isShorthand) => {
				const text$1 = (0, shared_2$3.getNodeText)(ts, id, ast);
				if (!shouldIdentifierSkipped(ctx, text$1, destructuredPropNames)) ctxVars.push({
					text: text$1,
					offset: (0, shared_2$3.getStartEnd)(ts, id, ast).start,
					isShorthand
				});
			};
			ts.forEachChild(ast, (node) => walkIdentifiers(ts, node, ast, varCb, ctx));
		}
		ctxVars = ctxVars.sort((a, b) => a.offset - b.offset);
		if (ctxVars.length) {
			for (let i = 0; i < ctxVars.length; i++) {
				const lastVar$1 = ctxVars[i - 1];
				const curVar = ctxVars[i];
				const lastVarEnd = lastVar$1 ? lastVar$1.offset + lastVar$1.text.length : 0;
				if (curVar.isShorthand) {
					yield [code$1.slice(lastVarEnd, curVar.offset + curVar.text.length), lastVarEnd];
					yield [": ", void 0];
				} else yield [
					code$1.slice(lastVarEnd, curVar.offset),
					lastVarEnd,
					i ? void 0 : "startText"
				];
				yield* generateVar(templateRefNames, ctx, code$1, offset, curVar);
			}
			const lastVar = ctxVars.at(-1);
			if (lastVar.offset + lastVar.text.length < code$1.length) yield [
				code$1.slice(lastVar.offset + lastVar.text.length),
				lastVar.offset + lastVar.text.length,
				"endText"
			];
		} else yield [code$1, 0];
	}
	function* generateVar(templateRefNames, ctx, code$1, offset, curVar) {
		yield [
			"",
			curVar.offset,
			"errorMappingOnly"
		];
		const isTemplateRef = templateRefNames?.has(curVar.text) ?? false;
		if (isTemplateRef) {
			yield [`__VLS_unref(`, void 0];
			yield [code$1.slice(curVar.offset, curVar.offset + curVar.text.length), curVar.offset];
			yield [`)`, void 0];
		} else {
			if (offset !== void 0) ctx.accessExternalVariable(curVar.text, offset + curVar.offset);
			else ctx.accessExternalVariable(curVar.text);
			if (ctx.dollarVars.has(curVar.text)) yield [`__VLS_dollars.`, void 0];
			else yield [`__VLS_ctx.`, void 0];
			yield [code$1.slice(curVar.offset, curVar.offset + curVar.text.length), curVar.offset];
		}
	}
	function walkIdentifiers(ts, node, ast, cb, ctx, blockVars = [], isRoot = true) {
		if (ts.isIdentifier(node)) cb(node, false);
		else if (ts.isShorthandPropertyAssignment(node)) cb(node.name, true);
		else if (ts.isPropertyAccessExpression(node)) walkIdentifiers(ts, node.expression, ast, cb, ctx, blockVars, false);
		else if (ts.isVariableDeclaration(node)) {
			(0, utils_1$32.collectVars)(ts, node.name, ast, blockVars);
			for (const varName of blockVars) ctx.addLocalVariable(varName);
			if (node.initializer) walkIdentifiers(ts, node.initializer, ast, cb, ctx, blockVars, false);
		} else if (ts.isArrowFunction(node) || ts.isFunctionExpression(node)) processFunction(ts, node, ast, cb, ctx);
		else if (ts.isObjectLiteralExpression(node)) {
			for (const prop of node.properties) if (ts.isPropertyAssignment(prop)) {
				if (ts.isComputedPropertyName(prop.name)) walkIdentifiers(ts, prop.name.expression, ast, cb, ctx, blockVars, false);
				walkIdentifiers(ts, prop.initializer, ast, cb, ctx, blockVars, false);
			} else if (ts.isShorthandPropertyAssignment(prop)) walkIdentifiers(ts, prop, ast, cb, ctx, blockVars, false);
			else if (ts.isSpreadAssignment(prop)) walkIdentifiers(ts, prop.expression, ast, cb, ctx, blockVars, false);
			else if (ts.isFunctionLike(prop) && prop.body) processFunction(ts, prop, ast, cb, ctx);
		} else if (ts.isTypeReferenceNode(node)) ts.forEachChild(node, (node$1) => walkIdentifiersInTypeReference(ts, node$1, cb));
		else {
			const _blockVars = blockVars;
			if (ts.isBlock(node)) blockVars = [];
			ts.forEachChild(node, (node$1) => walkIdentifiers(ts, node$1, ast, cb, ctx, blockVars, false));
			if (ts.isBlock(node)) for (const varName of blockVars) ctx.removeLocalVariable(varName);
			blockVars = _blockVars;
		}
		if (isRoot) for (const varName of blockVars) ctx.removeLocalVariable(varName);
	}
	function processFunction(ts, node, ast, cb, ctx) {
		const functionArgs = [];
		for (const param of node.parameters) {
			(0, utils_1$32.collectVars)(ts, param.name, ast, functionArgs);
			if (param.type) walkIdentifiers(ts, param.type, ast, cb, ctx);
		}
		for (const varName of functionArgs) ctx.addLocalVariable(varName);
		if (node.body) walkIdentifiers(ts, node.body, ast, cb, ctx);
		for (const varName of functionArgs) ctx.removeLocalVariable(varName);
	}
	function walkIdentifiersInTypeReference(ts, node, cb) {
		if (ts.isTypeQueryNode(node) && ts.isIdentifier(node.exprName)) cb(node.exprName, false);
		else ts.forEachChild(node, (node$1) => walkIdentifiersInTypeReference(ts, node$1, cb));
	}
	function shouldIdentifierSkipped(ctx, text$1, destructuredPropNames) {
		return ctx.hasLocalVariable(text$1) || (0, shared_1$23.isGloballyAllowed)(text$1) || isLiteralWhitelisted(text$1) || text$1 === "require" || text$1.startsWith("__VLS_") || destructuredPropNames?.has(text$1);
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/template/objectProperty.js
var require_objectProperty = __commonJS({ "node_modules/@vue/language-core/lib/codegen/template/objectProperty.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateObjectProperty = generateObjectProperty;
	const shared_1$22 = require_shared$2();
	const utils_1$31 = require_utils$1();
	const camelized_1$5 = require_camelized();
	const stringLiteralKey_1$2 = require_stringLiteralKey();
	const wrapWith_1$13 = require_wrapWith();
	const interpolation_1$10 = require_interpolation();
	function* generateObjectProperty(options, ctx, code$1, offset, features, shouldCamelize = false, shouldBeConstant = false) {
		if (code$1.startsWith("[") && code$1.endsWith("]")) if (shouldBeConstant) yield* (0, interpolation_1$10.generateInterpolation)(options, ctx, "template", features, code$1.slice(1, -1), offset + 1, `[__VLS_tryAsConstant(`, `)]`);
		else yield* (0, interpolation_1$10.generateInterpolation)(options, ctx, "template", features, code$1, offset);
		else if (shouldCamelize) if (utils_1$31.identifierRegex.test((0, shared_1$22.camelize)(code$1))) yield* (0, camelized_1$5.generateCamelized)(code$1, "template", offset, features);
		else yield* (0, wrapWith_1$13.wrapWith)(offset, offset + code$1.length, features, `'`, ...(0, camelized_1$5.generateCamelized)(code$1, "template", offset, utils_1$31.combineLastMapping), `'`);
		else if (utils_1$31.identifierRegex.test(code$1)) yield [
			code$1,
			"template",
			offset,
			features
		];
		else yield* (0, stringLiteralKey_1$2.generateStringLiteralKey)(code$1, offset, features);
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/utils/escaped.js
var require_escaped = __commonJS({ "node_modules/@vue/language-core/lib/codegen/utils/escaped.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateEscaped = generateEscaped;
	function* generateEscaped(text$1, source, offset, features, escapeTarget) {
		const parts = text$1.split(escapeTarget);
		const startCombineOffset = features.__combineOffset ?? 0;
		let isEscapeTarget = false;
		for (let i = 0; i < parts.length; i++) {
			const part = parts[i];
			if (isEscapeTarget) yield `\\`;
			yield [
				part,
				source,
				offset,
				i === 0 ? features : { __combineOffset: startCombineOffset + i }
			];
			offset += part.length;
			isEscapeTarget = !isEscapeTarget;
		}
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/template/styleScopedClasses.js
var require_styleScopedClasses = __commonJS({ "node_modules/@vue/language-core/lib/codegen/template/styleScopedClasses.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateStyleScopedClassReferences = generateStyleScopedClassReferences;
	exports.collectStyleScopedClassReferences = collectStyleScopedClassReferences;
	const CompilerDOM$15 = require_compiler_dom();
	const shared_1$21 = require_shared$1();
	const utils_1$30 = require_utils$1();
	const escaped_1 = require_escaped();
	const wrapWith_1$12 = require_wrapWith();
	const classNameEscapeRegex = /([\\'])/;
	function* generateStyleScopedClassReferences(ctx, withDot = false) {
		for (const offset of ctx.emptyClassOffsets) {
			yield `/** @type {__VLS_StyleScopedClasses['`;
			yield [
				"",
				"template",
				offset,
				ctx.codeFeatures.additionalCompletion
			];
			yield `']} */${utils_1$30.endOfLine}`;
		}
		for (const { source, className, offset } of ctx.scopedClasses) {
			yield `/** @type {__VLS_StyleScopedClasses[`;
			yield* (0, wrapWith_1$12.wrapWith)(offset - (withDot ? 1 : 0), offset + className.length, source, ctx.codeFeatures.navigation, `'`, ...(0, escaped_1.generateEscaped)(className, source, offset, ctx.codeFeatures.navigationAndAdditionalCompletion, classNameEscapeRegex), `'`);
			yield `]} */${utils_1$30.endOfLine}`;
		}
	}
	function collectStyleScopedClassReferences(options, ctx, node) {
		for (const prop of node.props) if (prop.type === CompilerDOM$15.NodeTypes.ATTRIBUTE && prop.name === "class" && prop.value) if (options.template.lang === "pug") {
			const getClassOffset = Reflect.get(prop.value.loc.start, "getClassOffset");
			const content = prop.value.loc.source.slice(1, -1);
			let startOffset = 1;
			for (const className of content.split(" ")) {
				if (className) ctx.scopedClasses.push({
					source: "template",
					className,
					offset: getClassOffset(startOffset)
				});
				startOffset += className.length + 1;
			}
		} else {
			let isWrapped = false;
			const [content, startOffset] = (0, utils_1$30.normalizeAttributeValue)(prop.value);
			if (content) {
				const classes = collectClasses(content, startOffset + (isWrapped ? 1 : 0));
				ctx.scopedClasses.push(...classes);
			} else ctx.emptyClassOffsets.push(startOffset);
		}
		else if (prop.type === CompilerDOM$15.NodeTypes.DIRECTIVE && prop.arg?.type === CompilerDOM$15.NodeTypes.SIMPLE_EXPRESSION && prop.exp?.type === CompilerDOM$15.NodeTypes.SIMPLE_EXPRESSION && prop.arg.content === "class") {
			const content = "`${" + prop.exp.content + "}`";
			const startOffset = prop.exp.loc.start.offset - 3;
			const { ts } = options;
			const ast = ts.createSourceFile("", content, 99);
			const literals = [];
			ts.forEachChild(ast, (node$1) => {
				if (!ts.isExpressionStatement(node$1) || !isTemplateExpression(node$1.expression)) return;
				const expression = node$1.expression.templateSpans[0].expression;
				if (ts.isStringLiteralLike(expression)) literals.push(expression);
				if (ts.isArrayLiteralExpression(expression)) walkArrayLiteral(expression);
				if (ts.isObjectLiteralExpression(expression)) walkObjectLiteral(expression);
			});
			for (const literal of literals) if (literal.text) {
				const classes = collectClasses(literal.text, literal.end - literal.text.length - 1 + startOffset);
				ctx.scopedClasses.push(...classes);
			} else ctx.emptyClassOffsets.push(literal.end - 1 + startOffset);
			function walkArrayLiteral(node$1) {
				const { elements } = node$1;
				for (const element of elements) if (ts.isStringLiteralLike(element)) literals.push(element);
				else if (ts.isObjectLiteralExpression(element)) walkObjectLiteral(element);
			}
			function walkObjectLiteral(node$1) {
				const { properties } = node$1;
				for (const property of properties) if (ts.isPropertyAssignment(property)) {
					const { name } = property;
					if (ts.isIdentifier(name)) walkIdentifier(name);
					else if (ts.isStringLiteral(name)) literals.push(name);
					else if (ts.isComputedPropertyName(name)) {
						const { expression } = name;
						if (ts.isStringLiteralLike(expression)) literals.push(expression);
					}
				} else if (ts.isShorthandPropertyAssignment(property)) walkIdentifier(property.name);
			}
			function walkIdentifier(node$1) {
				const text$1 = (0, shared_1$21.getNodeText)(ts, node$1, ast);
				ctx.scopedClasses.push({
					source: "template",
					className: text$1,
					offset: node$1.end - text$1.length + startOffset
				});
			}
		}
	}
	function collectClasses(content, startOffset = 0) {
		const classes = [];
		let currentClassName = "";
		let offset = 0;
		for (const char of content + " ") if (char.trim() === "") {
			if (currentClassName !== "") {
				classes.push({
					source: "template",
					className: currentClassName,
					offset: offset + startOffset
				});
				offset += currentClassName.length;
				currentClassName = "";
			}
			offset += char.length;
		} else currentClassName += char;
		return classes;
	}
	function isTemplateExpression(node) {
		return node.kind === 228;
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/inlayHints.js
var require_inlayHints = __commonJS({ "node_modules/@vue/language-core/lib/codegen/inlayHints.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createVBindShorthandInlayHintInfo = createVBindShorthandInlayHintInfo;
	function createVBindShorthandInlayHintInfo(loc, variableName) {
		return {
			blockName: "template",
			offset: loc.end.offset,
			setting: "vue.inlayHints.vBindShorthand",
			label: `="${variableName}"`,
			tooltip: [
				`This is a shorthand for \`${loc.source}="${variableName}"\`.`,
				"To hide this hint, set `vue.inlayHints.vBindShorthand` to `false` in IDE settings.",
				"[More info](https://github.com/vuejs/core/pull/9451)"
			].join("\n\n")
		};
	}
} });

//#endregion
//#region node_modules/@vue/language-core/lib/codegen/template/elementChildren.js
var require_elementChildren = __commonJS({ "node_modules/@vue/language-core/lib/codegen/template/elementChildren.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.generateElementChildren = generateElementChildren;
	const templateChild_1$2 = require_templateChild();
	function* generateElementChildren(options, ctx, children, enterNode = true) {
		yield* ctx.generateAutoImportCompletion();
		for (const childNode of children) yield* (0, templateChild_1$2.generateTemplateChild)(options, ctx, childNode, enterNode);
		yield* ctx.generateAutoImportCompletion();
	}
} });

//#endregion
//#region node_modules/@isaacs/balanced-match/dist/commonjs/index.js
var require_commonjs$2 = __commonJS({ "node_modules/@isaacs/balanced-match/dist/commonjs/index.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.range = exports.balanced = void 0;
	const balanced = (a, b, str$1) => {
		const ma = a instanceof RegExp ? maybeMatch(a, str$1) : a;
		const mb = b instanceof RegExp ? maybeMatch(b, str$1) : b;
		const r = ma !== null && mb != null && (0, exports.range)(ma, mb, str$1);
		return r && {
			start: r[0],
			end: r[1],
			pre: str$1.slice(0, r[0]),
			body: str$1.slice(r[0] + ma.length, r[1]),
			post: str$1.slice(r[1] + mb.length)
		};
	};
	exports.balanced = balanced;
	const maybeMatch = (reg, str$1) => {
		const m = str$1.match(reg);
		return m ? m[0] : null;
	};
	const range$1 = (a, b, str$1) => {
		let begs, beg, left, right = void 0, result;
		let ai = str$1.indexOf(a);
		let bi = str$1.indexOf(b, ai + 1);
		let i = ai;
		if (ai >= 0 && bi > 0) {
			if (a === b) return [ai, bi];
			begs = [];
			left = str$1.length;
			while (i >= 0 && !result) {
				if (i === ai) {
					begs.push(i);
					ai = str$1.indexOf(a, i + 1);
				} else if (begs.length === 1) {
					const r = begs.pop();
					if (r !== void 0) result = [r, bi];
				} else {
					beg = begs.pop();
					if (beg !== void 0 && beg < left) {
						left = beg;
						right = bi;
					}
					bi = str$1.indexOf(b, i + 1);
				}
				i = ai < bi && ai >= 0 ? ai : bi;
			}
			if (begs.length && right !== void 0) result = [left, right];
		}
		return result;
	};
	exports.range = range$1;
} });

//#endregion
//#region node_modules/@isaacs/brace-expansion/dist/commonjs/index.js
var require_commonjs$1 = __commonJS({ "node_modules/@isaacs/brace-expansion/dist/commonjs/index.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.expand = expand;
	const balanced_match_1 = require_commonjs$2();
	const escSlash = "\0SLASH" + Math.random() + "\0";
	const escOpen = "\0OPEN" + Math.random() + "\0";
	const escClose = "\0CLOSE" + Math.random() + "\0";
	const escComma = "\0COMMA" + Math.random() + "\0";
	const escPeriod = "\0PERIOD" + Math.random() + "\0";
	const escSlashPattern = new RegExp(escSlash, "g");
	const escOpenPattern = new RegExp(escOpen, "g");
	const escClosePattern = new RegExp(escClose, "g");
	const escCommaPattern = new RegExp(escComma, "g");
	const escPeriodPattern = new RegExp(escPeriod, "g");
	const slashPattern = /\\\\/g;
	const openPattern = /\\{/g;
	const closePattern = /\\}/g;
	const commaPattern = /\\,/g;
	const periodPattern = /\\./g;
	function numeric(str$1) {
		return !isNaN(str$1) ? parseInt(str$1, 10) : str$1.charCodeAt(0);
	}
	function escapeBraces(str$1) {
		return str$1.replace(slashPattern, escSlash).replace(openPattern, escOpen).replace(closePattern, escClose).replace(commaPattern, escComma).replace(periodPattern, escPeriod);
	}
	function unescapeBraces(str$1) {
		return str$1.replace(escSlashPattern, "\\").replace(escOpenPattern, "{").replace(escClosePattern, "}").replace(escCommaPattern, ",").replace(escPeriodPattern, ".");
	}
	/**
	* Basically just str.split(","), but handling cases
	* where we have nested braced sections, which should be
	* treated as individual members, like {a,{b,c},d}
	*/
	function parseCommaParts(str$1) {
		if (!str$1) return [""];
		const parts = [];
		const m = (0, balanced_match_1.balanced)("{", "}", str$1);
		if (!m) return str$1.split(",");
		const { pre, body, post } = m;
		const p = pre.split(",");
		p[p.length - 1] += "{" + body + "}";
		const postParts = parseCommaParts(post);
		if (post.length) {
			p[p.length - 1] += postParts.shift();
			p.push.apply(p, postParts);
		}
		parts.push.apply(parts, p);
		return parts;
	}
	function expand(str$1) {
		if (!str$1) return [];
		if (str$1.slice(0, 2) === "{}") str$1 = "\\{\\}" + str$1.slice(2);
		return expand_(escapeBraces(str$1), true).map(unescapeBraces);
	}
	function embrace(str$1) {
		return "{" + str$1 + "}";
	}
	function isPadded(el) {
		return /^-?0\d/.test(el);
	}
	function lte(i, y) {
		return i <= y;
	}
	function gte(i, y) {
		return i >= y;
	}
	function expand_(str$1, isTop) {
		/** @type {string[]} */
		const expansions = [];
		const m = (0, balanced_match_1.balanced)("{", "}", str$1);
		if (!m) return [str$1];
		const pre = m.pre;
		const post = m.post.length ? expand_(m.post, false) : [""];
		if (/\$$/.test(m.pre)) for (let k = 0; k < post.length; k++) {
			const expansion = pre + "{" + m.body + "}" + post[k];
			expansions.push(expansion);
		}
		else {
			const isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
			const isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
			const isSequence = isNumericSequence || isAlphaSequence;
			const isOptions = m.body.indexOf(",") >= 0;
			if (!isSequence && !isOptions) {
				if (m.post.match(/,(?!,).*\}/)) {
					str$1 = m.pre + "{" + m.body + escClose + m.post;
					return expand_(str$1);
				}
				return [str$1];
			}
			let n;
			if (isSequence) n = m.body.split(/\.\./);
			else {
				n = parseCommaParts(m.body);
				if (n.length === 1 && n[0] !== void 0) {
					n = expand_(n[0], false).map(embrace);
					/* c8 ignore start */
					if (n.length === 1) return post.map((p) => m.pre + n[0] + p);
				}
			}
			let N;
			if (isSequence && n[0] !== void 0 && n[1] !== void 0) {
				const x = numeric(n[0]);
				const y = numeric(n[1]);
				const width = Math.max(n[0].length, n[1].length);
				let incr = n.length === 3 && n[2] !== void 0 ? Math.abs(numeric(n[2])) : 1;
				let test = lte;
				const reverse = y < x;
				if (reverse) {
					incr *= -1;
					test = gte;
				}
				const pad = n.some(isPadded);
				N = [];
				for (let i = x; test(i, y); i += incr) {
					let c;
					if (isAlphaSequence) {
						c = String.fromCharCode(i);
						if (c === "\\") c = "";
					} else {
						c = String(i);
						if (pad) {
							const need = width - c.length;
							if (need > 0) {
								const z = new Array(need + 1).join("0");
								if (i < 0) c = "-" + z + c.slice(1);
								else c = z + c;
							}
						}
					}
					N.push(c);
				}
			} else {
				N = [];
				for (let j = 0; j < n.length; j++) N.push.apply(N, expand_(n[j], false));
			}
			for (let j = 0; j < N.length; j++) for (let k = 0; k < post.length; k++) {
				const expansion = pre + N[j] + post[k];
				if (!isTop || isSequence || expansion) expansions.push(expansion);
			}
		}
		return expansions;
	}
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/assert-valid-pattern.js
var require_assert_valid_pattern = __commonJS({ "node_modules/minimatch/dist/commonjs/assert-valid-pattern.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.assertValidPattern = void 0;
	const MAX_PATTERN_LENGTH = 1024 * 64;
	const assertValidPattern = (pattern) => {
		if (typeof pattern !== "string") throw new TypeError("invalid pattern");
		if (pattern.length > MAX_PATTERN_LENGTH) throw new TypeError("pattern is too long");
	};
	exports.assertValidPattern = assertValidPattern;
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/brace-expressions.js
var require_brace_expressions = __commonJS({ "node_modules/minimatch/dist/commonjs/brace-expressions.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.parseClass = void 0;
	const posixClasses = {
		"[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
		"[:alpha:]": ["\\p{L}\\p{Nl}", true],
		"[:ascii:]": ["\\x00-\\x7f", false],
		"[:blank:]": ["\\p{Zs}\\t", true],
		"[:cntrl:]": ["\\p{Cc}", true],
		"[:digit:]": ["\\p{Nd}", true],
		"[:graph:]": [
			"\\p{Z}\\p{C}",
			true,
			true
		],
		"[:lower:]": ["\\p{Ll}", true],
		"[:print:]": ["\\p{C}", true],
		"[:punct:]": ["\\p{P}", true],
		"[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
		"[:upper:]": ["\\p{Lu}", true],
		"[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
		"[:xdigit:]": ["A-Fa-f0-9", false]
	};
	const braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
	const regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
	const rangesToString = (ranges) => ranges.join("");
	const parseClass = (glob, position) => {
		const pos = position;
		/* c8 ignore start */
		if (glob.charAt(pos) !== "[") throw new Error("not in a brace expression");
		/* c8 ignore stop */
		const ranges = [];
		const negs = [];
		let i = pos + 1;
		let sawStart = false;
		let uflag = false;
		let escaping = false;
		let negate = false;
		let endPos = pos;
		let rangeStart = "";
		WHILE: while (i < glob.length) {
			const c = glob.charAt(i);
			if ((c === "!" || c === "^") && i === pos + 1) {
				negate = true;
				i++;
				continue;
			}
			if (c === "]" && sawStart && !escaping) {
				endPos = i + 1;
				break;
			}
			sawStart = true;
			if (c === "\\") {
				if (!escaping) {
					escaping = true;
					i++;
					continue;
				}
			}
			if (c === "[" && !escaping) {
				for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) if (glob.startsWith(cls, i)) {
					if (rangeStart) return [
						"$.",
						false,
						glob.length - pos,
						true
					];
					i += cls.length;
					if (neg) negs.push(unip);
					else ranges.push(unip);
					uflag = uflag || u;
					continue WHILE;
				}
			}
			escaping = false;
			if (rangeStart) {
				if (c > rangeStart) ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
				else if (c === rangeStart) ranges.push(braceEscape(c));
				rangeStart = "";
				i++;
				continue;
			}
			if (glob.startsWith("-]", i + 1)) {
				ranges.push(braceEscape(c + "-"));
				i += 2;
				continue;
			}
			if (glob.startsWith("-", i + 1)) {
				rangeStart = c;
				i += 2;
				continue;
			}
			ranges.push(braceEscape(c));
			i++;
		}
		if (endPos < i) return [
			"",
			false,
			0,
			false
		];
		if (!ranges.length && !negs.length) return [
			"$.",
			false,
			glob.length - pos,
			true
		];
		if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
			const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
			return [
				regexpEscape(r),
				false,
				endPos - pos,
				false
			];
		}
		const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
		const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
		const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
		return [
			comb,
			uflag,
			endPos - pos,
			true
		];
	};
	exports.parseClass = parseClass;
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/unescape.js
var require_unescape = __commonJS({ "node_modules/minimatch/dist/commonjs/unescape.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.unescape = void 0;
	/**
	* Un-escape a string that has been escaped with {@link escape}.
	*
	* If the {@link windowsPathsNoEscape} option is used, then square-brace
	* escapes are removed, but not backslash escapes.  For example, it will turn
	* the string `'[*]'` into `*`, but it will not turn `'\\*'` into `'*'`,
	* becuase `\` is a path separator in `windowsPathsNoEscape` mode.
	*
	* When `windowsPathsNoEscape` is not set, then both brace escapes and
	* backslash escapes are removed.
	*
	* Slashes (and backslashes in `windowsPathsNoEscape` mode) cannot be escaped
	* or unescaped.
	*/
	const unescape = (s, { windowsPathsNoEscape = false } = {}) => {
		return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
	};
	exports.unescape = unescape;
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/ast.js
var require_ast = __commonJS({ "node_modules/minimatch/dist/commonjs/ast.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.AST = void 0;
	const brace_expressions_js_1 = require_brace_expressions();
	const unescape_js_1$1 = require_unescape();
	const types = new Set([
		"!",
		"?",
		"+",
		"*",
		"@"
	]);
	const isExtglobType = (c) => types.has(c);
	const startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
	const startNoDot = "(?!\\.)";
	const addPatternStart = new Set(["[", "."]);
	const justDots = new Set(["..", "."]);
	const reSpecials = new Set("().*{}+?[]^$\\!");
	const regExpEscape$1 = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
	const qmark$1 = "[^/]";
	const star$1 = qmark$1 + "*?";
	const starNoEmpty = qmark$1 + "+?";
	var AST = class AST {
		type;
		#root;
		#hasMagic;
		#uflag = false;
		#parts = [];
		#parent;
		#parentIndex;
		#negs;
		#filledNegs = false;
		#options;
		#toString;
		#emptyExt = false;
		constructor(type, parent, options = {}) {
			this.type = type;
			if (type) this.#hasMagic = true;
			this.#parent = parent;
			this.#root = this.#parent ? this.#parent.#root : this;
			this.#options = this.#root === this ? options : this.#root.#options;
			this.#negs = this.#root === this ? [] : this.#root.#negs;
			if (type === "!" && !this.#root.#filledNegs) this.#negs.push(this);
			this.#parentIndex = this.#parent ? this.#parent.#parts.length : 0;
		}
		get hasMagic() {
			/* c8 ignore start */
			if (this.#hasMagic !== void 0) return this.#hasMagic;
			/* c8 ignore stop */
			for (const p of this.#parts) {
				if (typeof p === "string") continue;
				if (p.type || p.hasMagic) return this.#hasMagic = true;
			}
			return this.#hasMagic;
		}
		toString() {
			if (this.#toString !== void 0) return this.#toString;
			if (!this.type) return this.#toString = this.#parts.map((p) => String(p)).join("");
			else return this.#toString = this.type + "(" + this.#parts.map((p) => String(p)).join("|") + ")";
		}
		#fillNegs() {
			/* c8 ignore start */
			if (this !== this.#root) throw new Error("should only call on root");
			if (this.#filledNegs) return this;
			/* c8 ignore stop */
			this.toString();
			this.#filledNegs = true;
			let n;
			while (n = this.#negs.pop()) {
				if (n.type !== "!") continue;
				let p = n;
				let pp = p.#parent;
				while (pp) {
					for (let i = p.#parentIndex + 1; !pp.type && i < pp.#parts.length; i++) for (const part of n.#parts) {
						/* c8 ignore start */
						if (typeof part === "string") throw new Error("string part in extglob AST??");
						/* c8 ignore stop */
						part.copyIn(pp.#parts[i]);
					}
					p = pp;
					pp = p.#parent;
				}
			}
			return this;
		}
		push(...parts) {
			for (const p of parts) {
				if (p === "") continue;
				/* c8 ignore start */
				if (typeof p !== "string" && !(p instanceof AST && p.#parent === this)) throw new Error("invalid part: " + p);
				/* c8 ignore stop */
				this.#parts.push(p);
			}
		}
		toJSON() {
			const ret = this.type === null ? this.#parts.slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...this.#parts.map((p) => p.toJSON())];
			if (this.isStart() && !this.type) ret.unshift([]);
			if (this.isEnd() && (this === this.#root || this.#root.#filledNegs && this.#parent?.type === "!")) ret.push({});
			return ret;
		}
		isStart() {
			if (this.#root === this) return true;
			if (!this.#parent?.isStart()) return false;
			if (this.#parentIndex === 0) return true;
			const p = this.#parent;
			for (let i = 0; i < this.#parentIndex; i++) {
				const pp = p.#parts[i];
				if (!(pp instanceof AST && pp.type === "!")) return false;
			}
			return true;
		}
		isEnd() {
			if (this.#root === this) return true;
			if (this.#parent?.type === "!") return true;
			if (!this.#parent?.isEnd()) return false;
			if (!this.type) return this.#parent?.isEnd();
			/* c8 ignore start */
			const pl = this.#parent ? this.#parent.#parts.length : 0;
			/* c8 ignore stop */
			return this.#parentIndex === pl - 1;
		}
		copyIn(part) {
			if (typeof part === "string") this.push(part);
			else this.push(part.clone(this));
		}
		clone(parent) {
			const c = new AST(this.type, parent);
			for (const p of this.#parts) c.copyIn(p);
			return c;
		}
		static #parseAST(str$1, ast, pos, opt) {
			let escaping = false;
			let inBrace = false;
			let braceStart = -1;
			let braceNeg = false;
			if (ast.type === null) {
				let i$1 = pos;
				let acc$1 = "";
				while (i$1 < str$1.length) {
					const c = str$1.charAt(i$1++);
					if (escaping || c === "\\") {
						escaping = !escaping;
						acc$1 += c;
						continue;
					}
					if (inBrace) {
						if (i$1 === braceStart + 1) {
							if (c === "^" || c === "!") braceNeg = true;
						} else if (c === "]" && !(i$1 === braceStart + 2 && braceNeg)) inBrace = false;
						acc$1 += c;
						continue;
					} else if (c === "[") {
						inBrace = true;
						braceStart = i$1;
						braceNeg = false;
						acc$1 += c;
						continue;
					}
					if (!opt.noext && isExtglobType(c) && str$1.charAt(i$1) === "(") {
						ast.push(acc$1);
						acc$1 = "";
						const ext$1 = new AST(c, ast);
						i$1 = AST.#parseAST(str$1, ext$1, i$1, opt);
						ast.push(ext$1);
						continue;
					}
					acc$1 += c;
				}
				ast.push(acc$1);
				return i$1;
			}
			let i = pos + 1;
			let part = new AST(null, ast);
			const parts = [];
			let acc = "";
			while (i < str$1.length) {
				const c = str$1.charAt(i++);
				if (escaping || c === "\\") {
					escaping = !escaping;
					acc += c;
					continue;
				}
				if (inBrace) {
					if (i === braceStart + 1) {
						if (c === "^" || c === "!") braceNeg = true;
					} else if (c === "]" && !(i === braceStart + 2 && braceNeg)) inBrace = false;
					acc += c;
					continue;
				} else if (c === "[") {
					inBrace = true;
					braceStart = i;
					braceNeg = false;
					acc += c;
					continue;
				}
				if (isExtglobType(c) && str$1.charAt(i) === "(") {
					part.push(acc);
					acc = "";
					const ext$1 = new AST(c, part);
					part.push(ext$1);
					i = AST.#parseAST(str$1, ext$1, i, opt);
					continue;
				}
				if (c === "|") {
					part.push(acc);
					acc = "";
					parts.push(part);
					part = new AST(null, ast);
					continue;
				}
				if (c === ")") {
					if (acc === "" && ast.#parts.length === 0) ast.#emptyExt = true;
					part.push(acc);
					acc = "";
					ast.push(...parts, part);
					return i;
				}
				acc += c;
			}
			ast.type = null;
			ast.#hasMagic = void 0;
			ast.#parts = [str$1.substring(pos - 1)];
			return i;
		}
		static fromGlob(pattern, options = {}) {
			const ast = new AST(null, void 0, options);
			AST.#parseAST(pattern, ast, 0, options);
			return ast;
		}
		toMMPattern() {
			/* c8 ignore start */
			if (this !== this.#root) return this.#root.toMMPattern();
			/* c8 ignore stop */
			const glob = this.toString();
			const [re, body, hasMagic, uflag] = this.toRegExpSource();
			const anyMagic = hasMagic || this.#hasMagic || this.#options.nocase && !this.#options.nocaseMagicOnly && glob.toUpperCase() !== glob.toLowerCase();
			if (!anyMagic) return body;
			const flags = (this.#options.nocase ? "i" : "") + (uflag ? "u" : "");
			return Object.assign(new RegExp(`^${re}$`, flags), {
				_src: re,
				_glob: glob
			});
		}
		get options() {
			return this.#options;
		}
		toRegExpSource(allowDot) {
			const dot = allowDot ?? !!this.#options.dot;
			if (this.#root === this) this.#fillNegs();
			if (!this.type) {
				const noEmpty = this.isStart() && this.isEnd();
				const src = this.#parts.map((p) => {
					const [re, _, hasMagic, uflag] = typeof p === "string" ? AST.#parseGlob(p, this.#hasMagic, noEmpty) : p.toRegExpSource(allowDot);
					this.#hasMagic = this.#hasMagic || hasMagic;
					this.#uflag = this.#uflag || uflag;
					return re;
				}).join("");
				let start$1 = "";
				if (this.isStart()) {
					if (typeof this.#parts[0] === "string") {
						const dotTravAllowed = this.#parts.length === 1 && justDots.has(this.#parts[0]);
						if (!dotTravAllowed) {
							const aps = addPatternStart;
							const needNoTrav = dot && aps.has(src.charAt(0)) || src.startsWith("\\.") && aps.has(src.charAt(2)) || src.startsWith("\\.\\.") && aps.has(src.charAt(4));
							const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
							start$1 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
						}
					}
				}
				let end = "";
				if (this.isEnd() && this.#root.#filledNegs && this.#parent?.type === "!") end = "(?:$|\\/)";
				const final$1 = start$1 + src + end;
				return [
					final$1,
					(0, unescape_js_1$1.unescape)(src),
					this.#hasMagic = !!this.#hasMagic,
					this.#uflag
				];
			}
			const repeated = this.type === "*" || this.type === "+";
			const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
			let body = this.#partsToRegExp(dot);
			if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
				const s = this.toString();
				this.#parts = [s];
				this.type = null;
				this.#hasMagic = void 0;
				return [
					s,
					(0, unescape_js_1$1.unescape)(this.toString()),
					false,
					false
				];
			}
			let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : this.#partsToRegExp(true);
			if (bodyDotAllowed === body) bodyDotAllowed = "";
			if (bodyDotAllowed) body = `(?:${body})(?:${bodyDotAllowed})*?`;
			let final = "";
			if (this.type === "!" && this.#emptyExt) final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
			else {
				const close = this.type === "!" ? "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star$1 + ")" : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
				final = start + body + close;
			}
			return [
				final,
				(0, unescape_js_1$1.unescape)(body),
				this.#hasMagic = !!this.#hasMagic,
				this.#uflag
			];
		}
		#partsToRegExp(dot) {
			return this.#parts.map((p) => {
				/* c8 ignore start */
				if (typeof p === "string") throw new Error("string type in extglob ast??");
				/* c8 ignore stop */
				const [re, _, _hasMagic, uflag] = p.toRegExpSource(dot);
				this.#uflag = this.#uflag || uflag;
				return re;
			}).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
		}
		static #parseGlob(glob, hasMagic, noEmpty = false) {
			let escaping = false;
			let re = "";
			let uflag = false;
			for (let i = 0; i < glob.length; i++) {
				const c = glob.charAt(i);
				if (escaping) {
					escaping = false;
					re += (reSpecials.has(c) ? "\\" : "") + c;
					continue;
				}
				if (c === "\\") {
					if (i === glob.length - 1) re += "\\\\";
					else escaping = true;
					continue;
				}
				if (c === "[") {
					const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob, i);
					if (consumed) {
						re += src;
						uflag = uflag || needUflag;
						i += consumed - 1;
						hasMagic = hasMagic || magic;
						continue;
					}
				}
				if (c === "*") {
					if (noEmpty && glob === "*") re += starNoEmpty;
					else re += star$1;
					hasMagic = true;
					continue;
				}
				if (c === "?") {
					re += qmark$1;
					hasMagic = true;
					continue;
				}
				re += regExpEscape$1(c);
			}
			return [
				re,
				(0, unescape_js_1$1.unescape)(glob),
				!!hasMagic,
				uflag
			];
		}
	};
	exports.AST = AST;
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/escape.js
var require_escape = __commonJS({ "node_modules/minimatch/dist/commonjs/escape.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.escape = void 0;
	/**
	* Escape all magic characters in a glob pattern.
	*
	* If the {@link windowsPathsNoEscape | GlobOptions.windowsPathsNoEscape}
	* option is used, then characters are escaped by wrapping in `[]`, because
	* a magic character wrapped in a character class can only be satisfied by
	* that exact character.  In this mode, `\` is _not_ escaped, because it is
	* not interpreted as a magic character, but instead as a path separator.
	*/
	const escape$1 = (s, { windowsPathsNoEscape = false } = {}) => {
		return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
	};
	exports.escape = escape$1;
} });

//#endregion
//#region node_modules/minimatch/dist/commonjs/index.js
var require_commonjs = __commonJS({ "node_modules/minimatch/dist/commonjs/index.js"(exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.unescape = exports.escape = exports.AST = exports.Minimatch = exports.match = exports.makeRe = exports.braceExpand = exports.defaults = exports.filter = exports.GLOBSTAR = exports.sep = exports.minimatch = void 0;
	const brace_expansion_1 = require_commonjs$1();
	const assert_valid_pattern_js_1 = require_assert_valid_pattern();
	const ast_js_1 = require_ast();
	const escape_js_1 = require_escape();
	const unescape_js_1 = require_unescape();
	const minimatch = (p, pattern, options = {}) => {
		(0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
		if (!options.nocomment && pattern.charAt(0) === "#") return false;
		return new Minimatch(pattern, options).match(p);
	};
	exports.minimatch = minimatch;
	const starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
	const starDotExtTest = (ext$1) => (f) => !f.startsWith(".") && f.endsWith(ext$1);
	const starDotExtTestDot = (ext$1) => (f) => f.endsWith(ext$1);
	const starDotExtTestNocase = (ext$1) => {
		ext$1 = ext$1.toLowerCase();
		return (f) => !f.startsWith(".") && f.toLowerCase().endsWith(ext$1);
	};
	const starDotExtTestNocaseDot = (ext$1) => {
		ext$1 = ext$1.toLowerCase();
		return (f) => f.toLowerCase().endsWith(ext$1);
	};
	const starDotStarRE = /^\*+\.\*+$/;
	const starDotStarTest = (f) => !f.startsWith(".") && f.includes(".");
	const starDotStarTestDot = (f) => f !== "." && f !== ".." && f.includes(".");
	const dotStarRE = /^\.\*+$/;
	const dotStarTest = (f) => f !== "." && f !== ".." && f.startsWith(".");
	const starRE = /^\*+$/;
	const starTest = (f) => f.length !== 0 && !f.startsWith(".");
	const starTestDot = (f) => f.length !== 0 && f !== "." && f !== "..";
	const qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
	const qmarksTestNocase = ([$0, ext$1 = ""]) => {
		const noext = qmarksTestNoExt([$0]);
		if (!ext$1) return noext;
		ext$1 = ext$1.toLowerCase();
		return (f) => noext(f) && f.toLowerCase().endsWith(ext$1);
	};
	const qmarksTestNocaseDot = ([$0, ext$1 = ""]) => {
		const noext = qmarksTestNoExtDot([$0]);
		if (!ext$1) return noext;
		ext$1 = ext$1.toLowerCase();
		return (f) => noext(f) && f.toLowerCase().endsWith(ext$1);
	};
	const qmarksTestDot = ([$0, ext$1 = ""]) => {
		const noext = qmarksTestNoExtDot([$0]);
		return !ext$1 ? noext : (f) => noext(f) && f.endsWith(ext$1);
	};
	const qmarksTest = ([$0, ext$1 = ""]) => {
		const noext = qmarksTestNoExt([$0]);
		return !ext$1 ? noext : (f) => noext(f) && f.endsWith(ext$1);
	};
	const qmarksTestNoExt = ([$0]) => {
		const len$1 = $0.length;
		return (f) => f.length === len$1 && !f.startsWith(".");
	};
	const qmarksTestNoExtDot = ([$0]) => {
		const len$1 = $0.length;
		return (f) => f.length === len$1 && f !== "." && f !== "..";
	};
	/* c8 ignore start */
	const defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
	const path$4 = {
		win32: { sep: "\\" },
		posix: { sep: "/" }
	};
	/* c8 ignore stop */
	exports.sep = defaultPlatform === "win32" ? path$4.win32.sep : path$4.posix.sep;
	exports.minimatch.sep = exports.sep;
	exports.GLOBSTAR = Symbol("globstar **");
	exports.minimatch.GLOBSTAR = exports.GLOBSTAR;
	const qmark = "[^/]";
	const star = qmark + "*?";
	const twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
	const twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
	const filter = (pattern, options = {}) => (p) => (0, exports.minimatch)(p, pattern, options);
	exports.filter = filter;
	exports.minimatch.filter = exports.filter;
	const ext = (a, b = {}) => Object.assign({}, a, b);
	const defaults = (def$2) => {
		if (!def$2 || typeof def$2 !== "object" || !Object.keys(def$2).length) return exports.minimatch;
		const orig = exports.minimatch;
		const m = (p, pattern, options = {}) => orig(p, pattern, ext(def$2, options));
		return Object.assign(m, {
		