/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSImportsValues;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.config.JSModuleTarget;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfig
extends JSConfig {
    public static final String TS_CONFIG_JSON = "tsconfig.json";
    public static final String JS_CONFIG_JSON = "jsconfig.json";
    public static final String OUT_PROPERTY = "out";
    public static final String FILES_PROPERTY = "files";
    public static final String DECLARATION_DIR_PROPERTY = "declarationDir";
    public static final String EXCLUDES_PROPERTY = "exclude";
    public static final String INCLUDES_PROPERTY = "include";
    public static final String COMPILER_OPTIONS_PROPERTY = "compilerOptions";
    public static final String REFERENCES_PROPERTY = "references";
    public static final String REFERENCES_PATH = "path";
    public static final String COMPILE_ON_SAVE = "compileOnSave";
    public static final String INLINE_SOURCE_MAP = "inlineSourceMap";
    public static final String SOURCE_MAP = "sourceMap";
    public static final String ALLOW_SYNTHETIC_DEFAULT_IMPORTS = "allowSyntheticDefaultImports";
    public static final String ES_MODULE_INTEROP = "esModuleInterop";
    public static final String ISOLATE_MODULES = "isolatedModules";
    public static final String IMPORTS_NOT_USED_AS_VALUES = "importsNotUsedAsValues";
    public static final String NO_IMPLICIT_OVERRIDE = "noImplicitOverride";
    public static final String REACT_NAMESPACE = "reactNamespace";
    public static final String EXTENDS = "extends";
    public static final String TARGET_OPTION = "target";
    public static final String JSX_FACTORY = "jsxFactory";
    public static final String JSX_FRAGMENT_FACTORY = "jsxFragmentFactory";
    public static final String JSX_IMPORT_SOURCE = "jsxImportSource";
    public static final String JSX = "jsx";
    public static final String OUT_DIR = "outDir";
    public static final String OUT_FILE = "outFile";
    public static final String PATHS = "paths";
    public static final String ROOT_DIRS = "rootDirs";
    public static final String ROOT_DIR = "rootDir";
    public static final String ALLOW_JS = "allowJs";
    public static final String CHECK_JS = "checkJs";
    public static final String STRICT_NULL_CHECKS = "strictNullChecks";
    public static final String STRICT = "strict";
    public static final String STRICT_BIND_CALL_APPLY = "strictBindCallApply";
    public static final String NO_IMPLICIT_ANY = "noImplicitAny";
    public static final String NO_IMPLICIT_THIS = "noImplicitThis";
    public static final String KEYOF_STRINGS_ONLY = "keyofStringsOnly";
    public static final String EXPERIMENTAL_DECORATORS = "experimentalDecorators";
    public static final String COMPOSITE = "composite";
    public static final String BASE_URL = "baseUrl";
    public static final String MODULE_RESOLUTION = "moduleResolution";
    public static final String MODULE = "module";
    public static final String TYPES = "types";
    public static final String LIB = "lib";
    public static final String NO_LIB = "noLib";
    public static final String PRESERVE_SYMLINKS = "preserveSymlinks";
    public static final String TYPE_ROOTS = "typeRoots";
    public static final String SUPPRESS_EXCESS_PROPERTY_ERRORS = "suppressExcessPropertyErrors";
    public static final String RESOLVE_JSON_MODULE = "resolveJsonModule";
    public static final String MODULE_SUFFIXES = "moduleSuffixes";
    public static final String VERBATIM_MODULE_SYNTAX = "verbatimModuleSyntax";
    public static final String ALLOW_IMPORTING_TS_EXTENSIONS = "allowImportingTsExtensions";
    public static final String TYPES_MODULE = "@types";
    public static final String TYPES_MODULE_WITH_SEPARATOR = "@types/";
    public static final String DEFAULT_TYPES_DIRECTORY = "node_modules/@types";
    public static final String MODULE_RESOLUTION_NODE = "node";
    public static final String MODULE_RESOLUTION_BUNDLER = "bundler";
    public static final String MODULE_RESOLUTION_CLASSIC = "classic";
    public static final String PLUGINS = "plugins";
    public static final Collection<String> DEFAULT_EXCLUDE_VALUES = JSLibraryUtil.LIBRARY_ROOT_DIR_NAME_SET;
    public static final LanguageTarget DEFAULT_LANGUAGE_TARGET = LanguageTarget.ES5;
    public static final String INDEX_D_TS = "index.d.ts";

    public boolean isDirectoryBased();

    @NotNull
    public VirtualFile getConfigFile();

    @Nullable
    default public String getProjectName() {
        VirtualFile configFile = this.getConfigFile();
        return configFile.isInLocalFileSystem() ? FileUtil.toSystemDependentName((String)configFile.getPath()) : null;
    }

    @Override
    @NotNull
    public JSModulePathMappings<JSModulePathSubstitution> getPathMappings();

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs();

    @NotNull
    public LanguageTarget getLanguageTarget();

    @Override
    @Nullable
    public VirtualFile getBaseUrl();

    @Nullable
    public String getOutDirectory();

    @NotNull
    default public VirtualFile getEffectiveOutDirectory() {
        String outDirPath = this.getOutDirectory();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)(outDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(outDirPath)), (Object)this.getConfigDirectory());
        if (virtualFile == null) {
            TypeScriptConfig.$$$reportNull$$$0(0);
        }
        return virtualFile;
    }

    @Nullable
    default public String getDeclarationDir() {
        return null;
    }

    @NotNull
    default public VirtualFile getEffectiveDeclarationDirectory() {
        String declarationDirPath = this.getDeclarationDir();
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)(declarationDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(declarationDirPath)), (Object)this.getEffectiveOutDirectory());
        if (virtualFile == null) {
            TypeScriptConfig.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    public boolean hasErrors();

    public boolean isInlineSourceMap();

    public boolean isSourceMap();

    @NotNull
    public Collection<String> getLibNames();

    @NotNull
    public Collection<VirtualFile> getTypeRoots();

    @NotNull
    public JSModuleResolution getResolution();

    @NotNull
    public JSModuleResolution getEffectiveResolution();

    @NotNull
    public Collection<String> getTypes();

    @NotNull
    public JSModuleTarget getModule();

    public boolean isIncludedFile(@NotNull VirtualFile var1, boolean var2);

    public boolean isFromFileList(@NotNull VirtualFile var1);

    @Nullable
    public String getRawCompilerOption(@NotNull String var1);

    @NotNull
    default public Map<String, Object> getRawCompilerOptions() {
        Map<String, Object> map2 = Collections.emptyMap();
        if (map2 == null) {
            TypeScriptConfig.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public boolean hasExplicitCompileOnSave();

    default public boolean compileOnSave() {
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootDirsFiles();

    @NotNull
    default public Collection<String> getModuleSuffixes() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            TypeScriptConfig.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Collection<String> getIncludePatterns();

    @NotNull
    public Collection<String> getExcludePatterns();

    @NotNull
    public Collection<VirtualFile> getFileList();

    public boolean hasFilesList();

    public boolean hasIncludesList();

    default public boolean hasExcludeList() {
        return !this.getExcludePatterns().isEmpty();
    }

    default public boolean hasReferences() {
        return false;
    }

    @NotNull
    public Collection<VirtualFile> getDependencies();

    public boolean allowJs();

    public boolean suppressExcessPropertyChecks();

    public boolean checkJs();

    public boolean noImplicitAny();

    public boolean noImplicitThis();

    public boolean strictNullChecks();

    public boolean hasCompilerOption(@NotNull String var1);

    public boolean strictBindCallApply();

    public boolean allowSyntheticDefaultImports();

    default public boolean esModuleInterop() {
        return false;
    }

    public boolean noLib();

    @Nullable
    public VirtualFile getRootDirFile();

    @Nullable
    public String jsxFactory();

    @Nullable
    default public String jsxFragmentFactory() {
        return null;
    }

    @Nullable
    default public String jsx() {
        return null;
    }

    @Nullable
    default public String jsxImportSource() {
        return null;
    }

    @NotNull
    public List<String> getPlugins();

    public boolean keyofStringsOnly();

    default public boolean experimentalDecorators() {
        return false;
    }

    @NotNull
    default public JSImportsValues importsNotUsedAsValues() {
        JSImportsValues jSImportsValues = JSImportsValues.REMOVE;
        if (jSImportsValues == null) {
            TypeScriptConfig.$$$reportNull$$$0(4);
        }
        return jSImportsValues;
    }

    default public boolean verbatimModuleSyntax() {
        return false;
    }

    default public boolean allowImportingTsExtensions() {
        return false;
    }

    default public boolean isComposite() {
        return false;
    }

    @NotNull
    default public Collection<VirtualFile> getReferences() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            TypeScriptConfig.$$$reportNull$$$0(5);
        }
        return list;
    }

    default public boolean resolveJsonModule() {
        return false;
    }

    default public boolean isolatedModules() {
        return false;
    }

    default public boolean noImplicitOverride() {
        return false;
    }

    @Override
    default public boolean isNodeResolution() {
        return this.getEffectiveResolution() != JSModuleResolution.CLASSIC;
    }

    default public boolean isJSConfig() {
        return JS_CONFIG_JSON.equals(this.getConfigFile().getName());
    }

    default public boolean hasCustomOption(@NotNull Key<?> key) {
        if (key == null) {
            TypeScriptConfig.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Nullable
    default public <T> T getCustomOption(@NotNull Key<T> key) {
        if (key == null) {
            TypeScriptConfig.$$$reportNull$$$0(7);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfig";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveOutDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveDeclarationDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCompilerOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSuffixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = IMPORTS_NOT_USED_AS_VALUES;
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfig";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomOption";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static final class LanguageTarget {
        public static final int MAX_PRIORITY = Integer.MAX_VALUE;
        public static final int NON_STANDARD_PRIORITY = 3;
        public static final LanguageTarget ES3 = new LanguageTarget("lib.d.ts", "es3", 0);
        public static final LanguageTarget ES5 = new LanguageTarget("lib.d.ts", "es5", 1);
        public static final LanguageTarget ES6 = new LanguageTarget("es6", "es6", 2);
        public static final LanguageTarget NEXT = new LanguageTarget("esnext.full", "esnext", Integer.MAX_VALUE);
        @NotNull
        public final String libName;
        @NotNull
        public final String targetName;
        public final int priority;

        @ApiStatus.Internal
        public LanguageTarget(@NotNull String libName, @NotNull String targetName, int priority) {
            if (libName == null) {
                LanguageTarget.$$$reportNull$$$0(0);
            }
            if (targetName == null) {
                LanguageTarget.$$$reportNull$$$0(1);
            }
            this.libName = libName;
            this.targetName = targetName;
            this.priority = priority;
        }

        @NotNull
        public static LanguageTarget fromLanguageLevel(@NotNull JSLanguageLevel languageLevel) {
            if (languageLevel == null) {
                LanguageTarget.$$$reportNull$$$0(2);
            }
            LanguageTarget languageTarget = languageLevel.isES6Compatible() ? ES6 : ES5;
            if (languageTarget == null) {
                LanguageTarget.$$$reportNull$$$0(3);
            }
            return languageTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfig$LanguageTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfig$LanguageTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromLanguageLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fromLanguageLevel";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

