/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.javascript.formatter.ECMA4CodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.EventBinder;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BindablePropertiesForm
implements EventBinder {
    private static final String PROPERTY_PLACEHOLDER = "{property}";
    private static final String PROPERTY_UPPERCASE_PLACEHOLDER = "{PROPERTY}";
    private JPanel myMainPanel;
    private JCheckBox myBindEventCheckBox;
    private JCheckBox myEventConstantCheckBox;
    private JTextField myEventConstantTextField;
    private JTextField myEventTextField;
    private final JSCodeStyleSettings myCodeStyleSettings;

    public BindablePropertiesForm(final Project project, boolean suggestEventConstant) {
        this.$$$setupUI$$$();
        this.myEventConstantCheckBox.setVisible(suggestEventConstant);
        this.myEventConstantTextField.setVisible(suggestEventConstant);
        this.myCodeStyleSettings = (JSCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ECMA4CodeStyleSettings.class);
        this.myEventTextField.setText(BindablePropertiesForm.constructEventName(PROPERTY_PLACEHOLDER));
        this.myEventConstantTextField.setText(BindablePropertiesForm.constructEventConstantName(PROPERTY_UPPERCASE_PLACEHOLDER));
        this.myBindEventCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindablePropertiesForm.this.updateControls();
                if (BindablePropertiesForm.this.myEventTextField.isEnabled()) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)BindablePropertiesForm.this.myEventTextField, true);
                }
            }
        });
        this.myEventConstantCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindablePropertiesForm.this.updateControls();
                if (BindablePropertiesForm.this.myEventConstantTextField.isEnabled()) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)BindablePropertiesForm.this.myEventConstantTextField, true);
                }
            }
        });
        this.updateControls();
    }

    private void updateControls() {
        this.myEventTextField.setEnabled(this.myBindEventCheckBox.isSelected());
        this.myEventConstantCheckBox.setEnabled(this.myBindEventCheckBox.isSelected());
        this.myEventConstantTextField.setEnabled(this.myEventConstantCheckBox.isEnabled() && this.myEventConstantCheckBox.isSelected());
    }

    private static String constructEventName(String property) {
        return property + "Changed";
    }

    private static String constructEventConstantName(String property) {
        return property + "_CHANGED_EVENT";
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Override
    public boolean isBindEvent() {
        return this.myBindEventCheckBox.isSelected();
    }

    @Override
    public String getEventName(String parameterName) {
        return BindablePropertiesForm.replaceTokens(this.myEventTextField.getText().trim(), JSRefactoringUtil.transformVarNameToAccessorName(parameterName, this.myCodeStyleSettings));
    }

    @Override
    public boolean isCreateEventConstant() {
        return this.myEventConstantCheckBox.isSelected();
    }

    @Override
    public String getEventConstantName(String parameterName) {
        return BindablePropertiesForm.replaceTokens(this.myEventConstantTextField.getText().trim(), JSRefactoringUtil.transformVarNameToAccessorName(parameterName, this.myCodeStyleSettings));
    }

    private static String replaceTokens(String s, String parameterName) {
        return s.replace(PROPERTY_PLACEHOLDER, parameterName).replace(PROPERTY_UPPERCASE_PLACEHOLDER, StringUtil.toUpperCase((String)parameterName));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 0, 0, 0), 0, -1, false, false));
        this.myBindEventCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", BindablePropertiesForm.class).getString("generation.bindable.event"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEventTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEventConstantCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", BindablePropertiesForm.class).getString("generation.event.constant"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEventConstantTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

