/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLookupElementInsertHandler
extends JSInsertHandler {
    @Nullable
    private final Runnable myInsertHandlerAction;
    private boolean myForceQualify = false;

    public JSLookupElementInsertHandler(boolean insertAsIndexer, @Nullable Runnable insertHandlerAction) {
        super(insertAsIndexer);
        this.myInsertHandlerAction = insertHandlerAction;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        PsiElement object;
        if (context2 == null) {
            JSLookupElementInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            JSLookupElementInsertHandler.$$$reportNull$$$0(1);
        }
        if ((object = item.getPsiElement()) == null) {
            super.handleInsert(context2, item);
            return;
        }
        PsiFile file = context2.getFile();
        boolean doQualify = false;
        String packageName = null;
        if (this.myForceQualify) {
            String qName;
            PsiElement element2 = object;
            PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)element2, (PsiFile)file);
            if (originalElement != null) {
                element2 = originalElement;
            }
            String string = qName = element2 instanceof JSPsiElementBase ? ((JSPsiElementBase)element2).getQualifiedName() : null;
            if (qName != null) {
                packageName = StringUtil.getPackageName((String)qName);
                doQualify = !packageName.isEmpty();
            }
        }
        PsiDocumentManager.getInstance((Project)context2.getProject()).commitAllDocuments();
        super.handleInsert(context2, item);
        if (doQualify) {
            Editor editor = context2.getEditor();
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(editor.getDocument());
            PsiReference ref2 = file.findReferenceAt(editor.getCaretModel().getOffset() - 1);
            if (ref2 != null) {
                TextRange refRange = ref2.getRangeInElement();
                TextRange elementRange = ref2.getElement().getTextRange();
                editor.getDocument().insertString(elementRange.getStartOffset() + refRange.getStartOffset(), (CharSequence)(packageName + "."));
            }
        }
        if (this.myInsertHandlerAction != null) {
            this.myInsertHandlerAction.run();
        }
    }

    public void setForceQualify(boolean forceQualify) {
        this.myForceQualify = forceQualify;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSLookupElementInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

