/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class CssInvalidCharsetRuleInspection
extends CssBaseInspection {
    private static final LocalQuickFix REMOVE_MISPLACED_CHARSET = new LocalQuickFix(){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssCharset) {
                element.delete();
            }
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.inspections.remove.charset.fix", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    };
    private static final LocalQuickFix CHANGE_QUOTES_FIX = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.intentions.replace.quotes", new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String text;
            PsiElement element;
            if (project == null) {
                2.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                2.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssString && StringUtil.isQuotedString((String)(text = element.getText())) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                CssString newString = CssElementFactory.getInstance(project).createString('\"', StringUtil.unquoteString((String)text), CssPsiUtil.getStylesheetLanguage(element));
                element.replace((PsiElement)newString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    };
    private static final LocalQuickFix MOVE_CHARSET_AT_THE_BEGINNING_FIX = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.inspections.move.charset.fix", new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            CssStylesheet stylesheet;
            PsiElement element;
            if (project == null) {
                3.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                3.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssCharset && (stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class)) != null) {
                stylesheet.addBefore(element, stylesheet.getFirstChild());
                element.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidCharsetRuleInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssCharset(CssCharset charset) {
                PsiElement parent = charset.getParent();
                CssString valueElement = charset.getValueElement();
                if (valueElement != null && valueElement.getChildren().length > 1) {
                    return;
                }
                if (!(charset.getContainingFile() instanceof StylesheetFile)) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message("css.inspections.charset.wrong.file", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{REMOVE_MISPLACED_CHARSET});
                } else if (!(parent instanceof CssStylesheet) || parent.getPrevSibling() != null || charset.getPrevSibling() != null) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message("css.inspections.charset.wrong.position", new Object[0]), new LocalQuickFix[]{MOVE_CHARSET_AT_THE_BEGINNING_FIX, REMOVE_MISPLACED_CHARSET});
                }
                if (valueElement != null) {
                    String text = valueElement.getText();
                    if (StringUtil.isQuotedString((String)text) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message("css.inspections.charset.wrong.quotes", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{CHANGE_QUOTES_FIX});
                    }
                    if (!Charset.availableCharsets().containsKey(StringUtil.unquoteString((String)text))) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message("css.inspections.charset.unknown.value", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection", "buildVisitor"));
    }
}

