/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.IdleTimeoutHandler;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

final class HttpTrafficHandler
extends ChannelDuplexHandler
implements Runnable {
    static final String MULTIPART_PREFIX = "multipart";
    static final HttpVersion H2 = HttpVersion.valueOf((String)"HTTP/2.0");
    static final boolean LAST_FLUSH_WHEN_NO_READ = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.lastFlushWhenNoRead", "false"));
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final Duration idleTimeout;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final int maxKeepAliveRequests;
    final Duration readTimeout;
    final Duration requestTimeout;
    ChannelHandlerContext ctx;
    boolean nonInformationalResponse;
    boolean overflow;
    int pendingResponses;
    boolean persistentConnection = true;
    Queue<Object> pipelined;
    SocketAddress remoteAddress;
    Boolean secure;
    boolean read;
    boolean needsFlush;
    boolean finalizingResponse;

    HttpTrafficHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, @Nullable Duration idleTimeout, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable Duration readTimeout, @Nullable Duration requestTimeout) {
        this.listener = listener;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.compress = compress;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.idleTimeout = idleTimeout;
        this.mapHandle = mapHandle;
        this.maxKeepAliveRequests = maxKeepAliveRequests;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http connection, requesting read"));
        }
        ctx.read();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        IdleTimeoutHandler.addIdleTimeoutHandler(ctx.pipeline(), this.idleTimeout);
        ctx.fireChannelActive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.read = true;
        if (this.secure == null) {
            this.secure = ctx.channel().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel())).orElse(ctx.channel().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request;
            this.finalizingResponse = false;
            if (this.idleTimeout != null) {
                IdleTimeoutHandler.removeIdleTimeoutHandler(ctx.pipeline());
            }
            if (H2.equals((Object)(request = (HttpRequest)msg).protocolVersion())) {
                IllegalStateException e = new IllegalStateException("Unexpected request [" + request.method() + " " + request.uri() + " HTTP/2.0]");
                request.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                this.sendDecodingFailures(e, msg);
                return;
            }
            if (this.persistentConnection) {
                ++this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Increasing pending responses count: {}"), this.pendingResponses);
                }
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropping pipelined HTTP request, previous response requested connection close"));
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.persistentConnection = HttpUtil.isKeepAlive((HttpMessage)request);
            if (this.pendingResponses > 1) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP request, pending responses count: {}, queue: {}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
                }
                this.overflow = true;
                this.doPipeline(ctx, new HttpRequestHolder(request));
                return;
            }
            this.overflow = false;
            if (LAST_FLUSH_WHEN_NO_READ && (ops = ChannelOperations.get(ctx.channel())) instanceof HttpServerOperations) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Last HTTP packet was sent, terminating the channel"));
                }
                ((HttpServerOperations)ops).terminateInternal();
            }
            if (this.handleDecodingFailures(request.decoderResult(), msg)) {
                return;
            }
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            ConnectionInfo connectionInfo = null;
            try {
                connectionInfo = ConnectionInfo.from(ctx.channel(), request, this.secure, this.remoteAddress, this.forwardedHeaderHandler);
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, request, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, false, this.mapHandle, this.readTimeout, this.requestTimeout, this.secure, timestamp);
            }
            catch (RuntimeException e) {
                request.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                this.sendDecodingFailures(e, msg, timestamp, connectionInfo);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            ctx.fireChannelRead(msg);
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
                ctx.fireChannelRead(msg);
            } else if (msg.getClass() == DefaultLastHttpContent.class) {
                if (this.handleDecodingFailures(((DefaultLastHttpContent)msg).decoderResult(), msg)) {
                    return;
                }
                ctx.fireChannelRead(msg);
            } else if (msg instanceof LastHttpContent) {
                if (this.handleDecodingFailures(((LastHttpContent)msg).decoderResult(), msg)) {
                    return;
                }
                ctx.fireChannelRead(msg);
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
                }
                ReferenceCountUtil.release((Object)msg);
            }
            ctx.read();
            return;
        }
        if (this.overflow) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP content, pending responses count: {}, queue: {}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
            }
            this.doPipeline(ctx, msg);
            return;
        }
        if (msg instanceof DecoderResultProvider && this.handleDecodingFailures(((DecoderResultProvider)msg).decoderResult(), msg)) {
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.endReadAndFlush();
        ctx.fireChannelReadComplete();
    }

    void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (LAST_FLUSH_WHEN_NO_READ && this.needsFlush) {
                this.needsFlush = false;
                this.ctx.flush();
            }
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        if (LAST_FLUSH_WHEN_NO_READ && this.finalizingResponse) {
            if (this.needsFlush || !ctx.channel().isWritable()) {
                this.needsFlush = false;
                ctx.flush();
            } else {
                this.needsFlush = true;
            }
        } else {
            ctx.flush();
        }
    }

    boolean handleDecodingFailures(DecoderResult decoderResult, Object msg) {
        if (decoderResult.isFailure()) {
            this.sendDecodingFailures(decoderResult.cause(), msg);
            return true;
        }
        return false;
    }

    void sendDecodingFailures(Throwable t, Object msg) {
        this.sendDecodingFailures(t, msg, null, null);
    }

    void sendDecodingFailures(Throwable t, Object msg, @Nullable ZonedDateTime timestamp, @Nullable ConnectionInfo connectionInfo) {
        this.persistentConnection = false;
        HttpServerOperations.sendDecodingFailures(this.ctx, this.listener, this.secure, t, msg, this.httpMessageLogFactory, timestamp, connectionInfo, this.remoteAddress);
    }

    void doPipeline(ChannelHandlerContext ctx, Object msg) {
        if (this.pipelined == null) {
            this.pipelined = Queues.unbounded().get();
        }
        if (!this.pipelined.offer(msg)) {
            ctx.fireExceptionCaught((Throwable)Exceptions.failWithOverflow());
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Class<?> msgClass = msg.getClass();
        if (msgClass == DefaultHttpResponse.class) {
            this.handleDefaultHttpResponse((DefaultHttpResponse)msg, promise);
            return;
        }
        if (msgClass == DefaultFullHttpResponse.class) {
            if (this.handleDefaultFullHttpResponse((DefaultFullHttpResponse)msg, promise)) {
                return;
            }
            this.handleLastHttpContent(msg, promise);
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT || msgClass == DefaultLastHttpContent.class) {
            this.handleLastHttpContent(msg, promise);
            return;
        }
        if (msgClass == DefaultHttpContent.class) {
            this.handleDefaultHttContent((DefaultHttpContent)msg, promise);
            return;
        }
        if (msg instanceof HttpResponse) {
            boolean maxKeepAliveRequestsReached;
            HttpResponse response = (HttpResponse)msg;
            this.nonInformationalResponse = !HttpTrafficHandler.isInformational(response);
            boolean bl = maxKeepAliveRequestsReached = this.maxKeepAliveRequests != -1 && HttpServerOperations.requestsCounter(ctx.channel()) == (long)this.maxKeepAliveRequests;
            if (maxKeepAliveRequestsReached || !HttpUtil.isKeepAlive((HttpMessage)response) || !HttpTrafficHandler.isSelfDefinedMessageLength(response)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
            }
            if (response.status().code() == HttpResponseStatus.CONTINUE.code()) {
                ctx.write(msg, promise);
                return;
            }
        }
        if (msg instanceof LastHttpContent) {
            this.handleLastHttpContent(msg, promise);
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
            }
            ReferenceCountUtil.release((Object)msg);
            promise.setSuccess();
            return;
        }
        ctx.write(msg, promise);
    }

    boolean handleDefaultFullHttpResponse(DefaultFullHttpResponse response, ChannelPromise promise) {
        boolean maxKeepAliveRequestsReached;
        this.nonInformationalResponse = !HttpTrafficHandler.isInformational((HttpResponse)response);
        boolean bl = maxKeepAliveRequestsReached = this.maxKeepAliveRequests != -1 && HttpServerOperations.requestsCounter(this.ctx.channel()) == (long)this.maxKeepAliveRequests;
        if (maxKeepAliveRequestsReached || !HttpUtil.isKeepAlive((HttpMessage)response) || !HttpTrafficHandler.isSelfDefinedMessageLength((HttpResponse)response)) {
            this.pendingResponses = 0;
            this.persistentConnection = false;
        }
        if (!this.shouldKeepAlive()) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
        }
        if (response.status().code() == HttpResponseStatus.CONTINUE.code()) {
            this.ctx.write((Object)response, promise);
            return true;
        }
        return false;
    }

    void handleDefaultHttContent(DefaultHttpContent msg, ChannelPromise promise) {
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(this.ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)));
            }
            msg.release();
            promise.setSuccess();
            return;
        }
        this.ctx.write((Object)msg, promise);
    }

    void handleDefaultHttpResponse(DefaultHttpResponse response, ChannelPromise promise) {
        boolean maxKeepAliveRequestsReached;
        this.nonInformationalResponse = !HttpTrafficHandler.isInformational((HttpResponse)response);
        boolean bl = maxKeepAliveRequestsReached = this.maxKeepAliveRequests != -1 && HttpServerOperations.requestsCounter(this.ctx.channel()) == (long)this.maxKeepAliveRequests;
        if (maxKeepAliveRequestsReached || !HttpUtil.isKeepAlive((HttpMessage)response) || !HttpTrafficHandler.isSelfDefinedMessageLength((HttpResponse)response)) {
            this.pendingResponses = 0;
            this.persistentConnection = false;
        }
        if (!this.shouldKeepAlive()) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
        }
        this.ctx.write((Object)response, promise);
    }

    void handleLastHttpContent(Object msg, ChannelPromise promise) {
        this.finalizingResponse = true;
        if (LAST_FLUSH_WHEN_NO_READ) {
            boolean bl = this.needsFlush = !this.read;
        }
        if (!this.shouldKeepAlive()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(this.ctx.channel(), "Detected non persistent http connection, preparing to close. Pending responses count: {}"), this.pendingResponses);
            }
            this.ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        this.ctx.write(msg, promise);
        if (!this.persistentConnection) {
            return;
        }
        if (this.nonInformationalResponse) {
            this.nonInformationalResponse = false;
            --this.pendingResponses;
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(this.ctx.channel(), "Decreasing pending responses count: {}"), this.pendingResponses);
            }
        }
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(this.ctx.channel(), "Draining next pipelined HTTP request, pending responses count: {}, queued: {}"), this.pendingResponses, this.pipelined.size());
            }
            this.ctx.executor().execute((Runnable)this);
        } else {
            IdleTimeoutHandler.addIdleTimeoutHandler(this.ctx.pipeline(), this.idleTimeout);
            this.ctx.read();
        }
    }

    @Override
    public void run() {
        Object next;
        HttpRequest nextRequest = null;
        while ((next = this.pipelined.peek()) != null) {
            if (next instanceof HttpRequestHolder) {
                HttpServerOperations ops;
                DecoderResult decoderResult;
                ChannelOperations<?, ?> ops2;
                if (nextRequest != null) {
                    return;
                }
                if (!this.persistentConnection) {
                    this.discard();
                    return;
                }
                HttpRequestHolder holder = (HttpRequestHolder)next;
                nextRequest = holder.request;
                this.finalizingResponse = false;
                if (LAST_FLUSH_WHEN_NO_READ && (ops2 = ChannelOperations.get(this.ctx.channel())) instanceof HttpServerOperations) {
                    if (HttpServerOperations.log.isDebugEnabled()) {
                        HttpServerOperations.log.debug(ReactorNetty.format(this.ctx.channel(), "Last HTTP packet was sent, terminating the channel"));
                    }
                    ((HttpServerOperations)ops2).terminateInternal();
                }
                if ((decoderResult = nextRequest.decoderResult()).isFailure()) {
                    this.sendDecodingFailures(decoderResult.cause(), nextRequest, holder.timestamp, null);
                    this.discard();
                    return;
                }
                ConnectionInfo connectionInfo = null;
                try {
                    connectionInfo = ConnectionInfo.from(this.ctx.channel(), nextRequest, this.secure, this.remoteAddress, this.forwardedHeaderHandler);
                    ops = new HttpServerOperations(Connection.from(this.ctx.channel()), this.listener, nextRequest, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, false, this.mapHandle, this.readTimeout, this.requestTimeout, this.secure, holder.timestamp);
                }
                catch (RuntimeException e) {
                    holder.request.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                    this.sendDecodingFailures(e, holder.request, holder.timestamp, connectionInfo);
                    return;
                }
                ops.bind();
                this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
                this.pipelined.poll();
                this.ctx.fireChannelRead((Object)holder.request);
                continue;
            }
            this.ctx.fireChannelRead(this.pipelined.poll());
        }
        this.overflow = false;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.discard();
    }

    final void discard() {
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            Object o;
            while ((o = this.pipelined.poll()) != null) {
                ReferenceCountUtil.release((Object)o);
            }
        }
    }

    boolean shouldKeepAlive() {
        return this.pendingResponses != 0 && this.persistentConnection;
    }

    static boolean isSelfDefinedMessageLength(HttpResponse response) {
        return HttpUtil.isContentLengthSet((HttpMessage)response) || HttpUtil.isTransferEncodingChunked((HttpMessage)response) || HttpTrafficHandler.isMultipart(response) || HttpTrafficHandler.isInformational(response) || HttpTrafficHandler.isNotModified(response) || HttpTrafficHandler.isNoContent(response);
    }

    static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    static boolean isNoContent(HttpResponse response) {
        return HttpResponseStatus.NO_CONTENT.code() == response.status().code();
    }

    static boolean isNotModified(HttpResponse response) {
        return HttpResponseStatus.NOT_MODIFIED.code() == response.status().code();
    }

    static boolean isMultipart(HttpResponse response) {
        String contentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }

    static final class HttpRequestHolder {
        final HttpRequest request;
        final ZonedDateTime timestamp;

        HttpRequestHolder(HttpRequest request) {
            this.request = request;
            this.timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
        }
    }
}

