/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import reactor.netty.Connection;
import reactor.netty.ReactorNetty;
import reactor.util.context.Context;

@FunctionalInterface
public interface ConnectionObserver {
    public static ConnectionObserver emptyListener() {
        return ReactorNetty.NOOP_LISTENER;
    }

    default public Context currentContext() {
        return Context.empty();
    }

    default public void onUncaughtException(Connection connection, Throwable error) {
        this.onStateChange(connection, State.DISCONNECTING);
    }

    public void onStateChange(Connection var1, State var2);

    default public ConnectionObserver then(ConnectionObserver other) {
        return ReactorNetty.compositeConnectionObserver(this, other);
    }

    public static interface State {
        public static final State CONNECTED = ReactorNetty.CONNECTED;
        public static final State CONFIGURED = ReactorNetty.CONFIGURED;
        public static final State ACQUIRED = ReactorNetty.ACQUIRED;
        public static final State RELEASED = ReactorNetty.RELEASED;
        public static final State DISCONNECTING = ReactorNetty.DISCONNECTING;
    }
}

