/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeNodingBuilder;
import org.locationtech.jts.operation.overlayng.ElevationModel;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.IntersectionPointBuilder;
import org.locationtech.jts.operation.overlayng.LineBuilder;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;
import org.locationtech.jts.operation.overlayng.OverlayLabeller;
import org.locationtech.jts.operation.overlayng.OverlayMixedPoints;
import org.locationtech.jts.operation.overlayng.OverlayPoints;
import org.locationtech.jts.operation.overlayng.OverlayUtil;
import org.locationtech.jts.operation.overlayng.PolygonBuilder;

public class OverlayNG {
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;
    static final boolean STRICT_MODE_DEFAULT = false;
    private int opCode;
    private InputGeometry inputGeom;
    private GeometryFactory geomFact;
    private PrecisionModel pm;
    private Noder noder;
    private boolean isStrictMode = false;
    private boolean isOptimized = true;
    private boolean isAreaResultOnly = false;
    private boolean isOutputEdges = false;
    private boolean isOutputResultEdges = false;
    private boolean isOutputNodedEdges = false;

    static boolean isResultOfOpPoint(OverlayLabel label, int opCode) {
        int loc0 = label.getLocation(0);
        int loc1 = label.getLocation(1);
        return OverlayNG.isResultOfOp(opCode, loc0, loc1);
    }

    static boolean isResultOfOp(int overlayOpCode, int loc0, int loc1) {
        if (loc0 == 1) {
            loc0 = 0;
        }
        if (loc1 == 1) {
            loc1 = 0;
        }
        switch (overlayOpCode) {
            case 1: {
                return loc0 == 0 && loc1 == 0;
            }
            case 2: {
                return loc0 == 0 || loc1 == 0;
            }
            case 3: {
                return loc0 == 0 && loc1 != 0;
            }
            case 4: {
                return loc0 == 0 && loc1 != 0 || loc0 != 0 && loc1 == 0;
            }
        }
        return false;
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, PrecisionModel pm) {
        OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
        Geometry geomOv = ov.getResult();
        return geomOv;
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, PrecisionModel pm, Noder noder) {
        OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
        ov.setNoder(noder);
        Geometry geomOv = ov.getResult();
        return geomOv;
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode, Noder noder) {
        OverlayNG ov = new OverlayNG(geom0, geom1, null, opCode);
        ov.setNoder(noder);
        Geometry geomOv = ov.getResult();
        return geomOv;
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode) {
        OverlayNG ov = new OverlayNG(geom0, geom1, opCode);
        return ov.getResult();
    }

    static Geometry union(Geometry geom, PrecisionModel pm) {
        OverlayNG ov = new OverlayNG(geom, pm);
        Geometry geomOv = ov.getResult();
        return geomOv;
    }

    static Geometry union(Geometry geom, PrecisionModel pm, Noder noder) {
        OverlayNG ov = new OverlayNG(geom, pm);
        ov.setNoder(noder);
        ov.setStrictMode(true);
        Geometry geomOv = ov.getResult();
        return geomOv;
    }

    public OverlayNG(Geometry geom0, Geometry geom1, PrecisionModel pm, int opCode) {
        this.pm = pm;
        this.opCode = opCode;
        this.geomFact = geom0.getFactory();
        this.inputGeom = new InputGeometry(geom0, geom1);
    }

    public OverlayNG(Geometry geom0, Geometry geom1, int opCode) {
        this(geom0, geom1, geom0.getFactory().getPrecisionModel(), opCode);
    }

    OverlayNG(Geometry geom, PrecisionModel pm) {
        this(geom, null, pm, 2);
    }

    public void setStrictMode(boolean isStrictMode) {
        this.isStrictMode = isStrictMode;
    }

    public void setOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
    }

    void setAreaResultOnly(boolean isAreaResultOnly) {
        this.isAreaResultOnly = isAreaResultOnly;
    }

    public void setOutputEdges(boolean isOutputEdges) {
        this.isOutputEdges = isOutputEdges;
    }

    public void setOutputNodedEdges(boolean isOutputNodedEdges) {
        this.isOutputEdges = true;
        this.isOutputNodedEdges = isOutputNodedEdges;
    }

    public void setOutputResultEdges(boolean isOutputResultEdges) {
        this.isOutputResultEdges = isOutputResultEdges;
    }

    void setNoder(Noder noder) {
        this.noder = noder;
    }

    public Geometry getResult() {
        if (OverlayUtil.isEmptyResult(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm)) {
            return this.createEmptyResult();
        }
        ElevationModel elevModel = ElevationModel.create(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1));
        Geometry result2 = this.inputGeom.isAllPoints() ? OverlayPoints.overlay(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm) : (!this.inputGeom.isSingle() && this.inputGeom.hasPoints() ? OverlayMixedPoints.overlay(this.opCode, this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.pm) : this.computeEdgeOverlay());
        elevModel.populateZ(result2);
        return result2;
    }

    private Geometry computeEdgeOverlay() {
        boolean isAreaConsistent;
        List<Edge> edges = this.nodeEdges();
        OverlayGraph graph = this.buildGraph(edges);
        if (this.isOutputNodedEdges) {
            return OverlayUtil.toLines(graph, this.isOutputEdges, this.geomFact);
        }
        this.labelGraph(graph);
        if (this.isOutputEdges || this.isOutputResultEdges) {
            return OverlayUtil.toLines(graph, this.isOutputEdges, this.geomFact);
        }
        Geometry result2 = this.extractResult(this.opCode, graph);
        if (OverlayUtil.isFloating(this.pm) && !(isAreaConsistent = OverlayUtil.isResultAreaConsistent(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1), this.opCode, result2))) {
            throw new TopologyException("Result area inconsistent with overlay operation");
        }
        return result2;
    }

    private List<Edge> nodeEdges() {
        Envelope clipEnv;
        EdgeNodingBuilder nodingBuilder = new EdgeNodingBuilder(this.pm, this.noder);
        if (this.isOptimized && (clipEnv = OverlayUtil.clippingEnvelope(this.opCode, this.inputGeom, this.pm)) != null) {
            nodingBuilder.setClipEnvelope(clipEnv);
        }
        List<Edge> mergedEdges = nodingBuilder.build(this.inputGeom.getGeometry(0), this.inputGeom.getGeometry(1));
        this.inputGeom.setCollapsed(0, !nodingBuilder.hasEdgesFor(0));
        this.inputGeom.setCollapsed(1, !nodingBuilder.hasEdgesFor(1));
        return mergedEdges;
    }

    private OverlayGraph buildGraph(Collection<Edge> edges) {
        OverlayGraph graph = new OverlayGraph();
        for (Edge e : edges) {
            graph.addEdge(e.getCoordinates(), e.createLabel());
        }
        return graph;
    }

    private void labelGraph(OverlayGraph graph) {
        OverlayLabeller labeller = new OverlayLabeller(graph, this.inputGeom);
        labeller.computeLabelling();
        labeller.markResultAreaEdges(this.opCode);
        labeller.unmarkDuplicateEdgesFromResultArea();
    }

    private Geometry extractResult(int opCode, OverlayGraph graph) {
        boolean isAllowMixedIntResult = !this.isStrictMode;
        List<OverlayEdge> resultAreaEdges = graph.getResultAreaEdges();
        PolygonBuilder polyBuilder = new PolygonBuilder(resultAreaEdges, this.geomFact);
        List<Polygon> resultPolyList = polyBuilder.getPolygons();
        boolean hasResultAreaComponents = resultPolyList.size() > 0;
        List<LineString> resultLineList = null;
        List<Point> resultPointList = null;
        if (!this.isAreaResultOnly) {
            boolean allowResultPoints;
            boolean allowResultLines;
            boolean bl = allowResultLines = !hasResultAreaComponents || isAllowMixedIntResult || opCode == 4 || opCode == 2;
            if (allowResultLines) {
                LineBuilder lineBuilder = new LineBuilder(this.inputGeom, graph, hasResultAreaComponents, opCode, this.geomFact);
                lineBuilder.setStrictMode(this.isStrictMode);
                resultLineList = lineBuilder.getLines();
            }
            boolean hasResultComponents = hasResultAreaComponents || resultLineList.size() > 0;
            boolean bl2 = allowResultPoints = !hasResultComponents || isAllowMixedIntResult;
            if (opCode == 1 && allowResultPoints) {
                IntersectionPointBuilder pointBuilder = new IntersectionPointBuilder(graph, this.geomFact);
                pointBuilder.setStrictMode(this.isStrictMode);
                resultPointList = pointBuilder.getPoints();
            }
        }
        if (OverlayNG.isEmpty(resultPolyList) && OverlayNG.isEmpty(resultLineList) && OverlayNG.isEmpty(resultPointList)) {
            return this.createEmptyResult();
        }
        Geometry resultGeom = OverlayUtil.createResultGeometry(resultPolyList, resultLineList, resultPointList, this.geomFact);
        return resultGeom;
    }

    private static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    private Geometry createEmptyResult() {
        return OverlayUtil.createEmptyResult(OverlayUtil.resultDimension(this.opCode, this.inputGeom.getDimension(0), this.inputGeom.getDimension(1)), this.geomFact);
    }
}

