/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.lang.javascript.linter.JSLinterFixSingleErrorBaseAction;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LineSeparator;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class TsLintErrorFixAction
extends JSLinterFixSingleErrorBaseAction
implements DumbAware {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final TsLinterError myError;
    private static final Comparator<TsLintFixInfo.TsLintFixReplacements> REPLACEMENTS_COMPARATOR = Comparator.comparingInt(value -> value.innerStart + value.innerLength).thenComparingInt(value -> value.innerStart).reversed();

    public TsLintErrorFixAction(@NotNull PsiFile file, @NotNull TsLinterError error, long modificationStamp) {
        if (file == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(0);
        }
        if (error == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(1);
        }
        super(TsLintBundle.message("tslint.framework.title", new Object[0]), file, error.getCode(), modificationStamp);
        this.myError = error;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(2);
        }
        return super.isAvailable(project, editor, psiFile) && this.myError.getFixInfo() != null && !StringUtil.equals((CharSequence)this.myError.getCode(), (CharSequence)"linebreak-style");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(3);
        }
        if (!this.isAvailable(project, editor, psiFile)) {
            return;
        }
        TsLintFixInfo info = this.myError.getFixInfo();
        if (info == null) {
            return;
        }
        TsLintFixInfo.TsLintFixReplacements[] replacements = info.innerReplacements;
        if (replacements == null || replacements.length == 0) {
            return;
        }
        Arrays.sort(replacements, REPLACEMENTS_COMPARATOR);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            String separator;
            Document document = editor.getDocument();
            if (!TsLintErrorFixAction.applyReplacements(document, separator = FileDocumentManager.getInstance().getLineSeparator(psiFile.getViewProvider().getVirtualFile(), project), replacements)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
    }

    private static boolean applyReplacements(@NotNull Document document, @NotNull String separator, TsLintFixInfo.TsLintFixReplacements @NotNull [] replacements) {
        String lf;
        if (document == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(5);
        }
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(6);
        }
        if ((lf = LineSeparator.LF.getSeparatorString()).equals(separator)) {
            return TsLintErrorFixAction.applyFor(document.getTextLength(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> document.replaceString(replacement.innerStart, replacement.innerStart + replacement.innerLength, (CharSequence)StringUtil.notNullize((String)replacement.innerText))));
        }
        StringBuilder newContent = new StringBuilder(StringUtilRt.convertLineSeparators((String)document.getText(), (String)separator));
        if (TsLintErrorFixAction.applyFor(newContent.length(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> newContent.replace(replacement.innerStart, replacement.innerStart + replacement.innerLength, StringUtil.notNullize((String)replacement.innerText))))) {
            document.setText(StringUtilRt.convertLineSeparators((CharSequence)newContent, (String)lf));
            return true;
        }
        return false;
    }

    private static boolean applyFor(int documentLength, TsLintFixInfo.TsLintFixReplacements @NotNull [] replacements, @NotNull Consumer<TsLintFixInfo.TsLintFixReplacements> apply) {
        if (apply == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(7);
        }
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(8);
        }
        for (TsLintFixInfo.TsLintFixReplacements replacement : replacements) {
            int offset = replacement.innerStart;
            if (offset > documentLength || offset + replacement.innerLength > documentLength) {
                return false;
            }
            apply.consume((Object)replacement);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apply";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applyReplacements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

