/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.connection.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsClient;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsClient;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SendEventLogAction
extends AnAction {
    SendEventLogAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SendEventLogAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SendEventLogAction.$$$reportNull$$$0(1);
        }
        String recorderId = StringUtil.trim((String)Registry.stringValue((String)"usage.statistics.test.action.recorder.id"));
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && StatisticsRecorderUtil.isTestModeEnabled((String)recorderId));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SendEventLogAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, StatisticsBundle.message((String)"stats.send.feature.usage.event.log", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean succeed;
                StatisticsResult result;
                StatisticsResult.ResultCode code;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((code = (result = 1.send()).getCode()) == StatisticsResult.ResultCode.SENT_WITH_ERRORS || code == StatisticsResult.ResultCode.SEND) && (succeed = SendEventLogAction.tryToOpenInScratch(project, result.getDescription()))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMultilineInputDialog((Project)project, (String)("Result: " + String.valueOf(code)), (String)"Statistics Result", (String)StringUtil.replace((String)result.getDescription(), (String)";", (String)"\n"), null, null), ModalityState.nonModal(), project.getDisposed());
            }

            private static StatisticsResult send() {
                String recorderId = StringUtil.trim((String)Registry.stringValue((String)"usage.statistics.test.action.recorder.id"));
                return EventLogStatisticsService.send((EventLogSendConfig)EventLogInternalSendConfig.createByRecorder((String)recorderId, (boolean)true), (EventLogSettingsClient)new EventLogTestSettingsClient(recorderId), (EventLogResultDecorator)new EventLogTestResultDecorator());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/devkit/actions/SendEventLogAction$1", "run"));
            }
        });
    }

    private static boolean tryToOpenInScratch(@NotNull Project project, @NotNull String request) {
        if (project == null) {
            SendEventLogAction.$$$reportNull$$$0(3);
        }
        if (request == null) {
            SendEventLogAction.$$$reportNull$$$0(4);
        }
        String fileName = "fus-event-log.json";
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file = fileService.findFile(RootType.findById((String)"scratches"), "fus-event-log.json", ScratchFileService.Option.create_new_always);
                fileService.getScratchesMapping().setMapping(file, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            NavigatablePsiElement psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(StatisticsBundle.message((String)"stats.creating.json.for.event.log.upload.results", (Object[])new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
            if (psiElement != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).submit(() -> psiElement.navigate(true));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/devkit/actions/SendEventLogAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/devkit/actions/SendEventLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToOpenInScratch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class EventLogTestResultDecorator
    implements EventLogResultDecorator {
        private final List<LogEventRecordRequest> mySucceed = new ArrayList<LogEventRecordRequest>();
        private final List<LogEventRecordRequest> myFailed = new ArrayList<LogEventRecordRequest>();

        private EventLogTestResultDecorator() {
        }

        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            if (request == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(0);
            }
            if (content == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(1);
            }
            if (logPath == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(2);
            }
            this.mySucceed.add(request);
        }

        public void onFailed(@Nullable LogEventRecordRequest request, int error, @Nullable String content) {
            if (request != null) {
                this.myFailed.add(request);
            } else {
                this.myFailed.add(new LogEventRecordRequest("INVALID", "INVALID", "INVALID", ContainerUtil.emptyList(), true));
            }
        }

        @NotNull
        public StatisticsResult onFinished() {
            int total = this.mySucceed.size() + this.myFailed.size();
            if (this.mySucceed.isEmpty() && this.myFailed.isEmpty()) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (!this.myFailed.isEmpty()) {
                StringBuilder out = new StringBuilder("{\"total\":");
                out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
                out.append("\"failed\":[");
                EventLogTestResultDecorator.append(out, this.myFailed);
                out.append("],\"succeed\":[");
                EventLogTestResultDecorator.append(out, this.mySucceed);
                out.append("]}");
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, out.toString());
            }
            StringBuilder out = new StringBuilder("{\"total\":");
            out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
            out.append("\"succeed\":[");
            EventLogTestResultDecorator.append(out, this.mySucceed);
            out.append("]}");
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, out.toString());
        }

        private static void append(@NotNull StringBuilder out, @NotNull List<LogEventRecordRequest> requests) {
            if (out == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(3);
            }
            if (requests == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(4);
            }
            boolean isFirst = true;
            for (LogEventRecordRequest request : requests) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    out.append(",");
                }
                out.append(LogEventSerializer.INSTANCE.toString(request));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/devkit/actions/SendEventLogAction$EventLogTestResultDecorator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSucceed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class EventLogTestApplication
    extends EventLogInternalApplicationInfo {
        private EventLogTestApplication() {
            super(false, true);
        }

        public boolean isInternal() {
            return true;
        }
    }

    private static final class EventLogTestSettingsClient
    extends EventLogUploadSettingsClient {
        private EventLogTestSettingsClient(@NotNull String recorderId) {
            if (recorderId == null) {
                EventLogTestSettingsClient.$$$reportNull$$$0(0);
            }
            super(recorderId, (EventLogApplicationInfo)new EventLogTestApplication(), TimeUnit.MINUTES.toMillis(10L));
        }

        @NotNull
        public LogEventFilter provideEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
            LogEventFilter filter2;
            if (base == null) {
                EventLogTestSettingsClient.$$$reportNull$$$0(1);
            }
            if (type == null) {
                EventLogTestSettingsClient.$$$reportNull$$$0(2);
            }
            if ((filter2 = super.provideEventFilter(base, type)) instanceof LogEventCompositeFilter) {
                LogEventFilter[] withoutSnapshot = (LogEventFilter[])Arrays.stream(((LogEventCompositeFilter)filter2).getFilters()).filter(f -> f != LogEventSnapshotBuildFilter.INSTANCE).toArray(LogEventFilter[]::new);
                return new LogEventCompositeFilter(withoutSnapshot);
            }
            LogEventFilter logEventFilter = filter2;
            if (logEventFilter == null) {
                EventLogTestSettingsClient.$$$reportNull$$$0(3);
            }
            return logEventFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/devkit/actions/SendEventLogAction$EventLogTestSettingsClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/devkit/actions/SendEventLogAction$EventLogTestSettingsClient";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideEventFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "provideEventFilter";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

