/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.PluginVcsMappingListener;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectLevelVcsManager {
    @Topic.ProjectLevel
    public static final Topic<VcsMappingListener> VCS_CONFIGURATION_CHANGED = new Topic(VcsMappingListener.class, Topic.BroadcastDirection.NONE);
    @Topic.ProjectLevel
    public static final Topic<PluginVcsMappingListener> VCS_CONFIGURATION_CHANGED_IN_PLUGIN = new Topic(PluginVcsMappingListener.class, Topic.BroadcastDirection.NONE);

    public abstract void iterateVfUnderVcsRoot(VirtualFile var1, Processor<? super VirtualFile> var2);

    public static ProjectLevelVcsManager getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectLevelVcsManager.$$$reportNull$$$0(0);
        }
        return (ProjectLevelVcsManager)project.getService(ProjectLevelVcsManager.class);
    }

    public abstract VcsDescriptor[] getAllVcss();

    @Nullable
    public abstract AbstractVcs findVcsByName(@Nullable @NonNls String var1);

    @Nullable
    public abstract VcsDescriptor getDescriptor(@NonNls String var1);

    public abstract boolean checkAllFilesAreUnder(AbstractVcs var1, VirtualFile[] var2);

    @NotNull
    @NlsSafe
    public abstract String getShortNameForVcsRoot(@NotNull VirtualFile var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(@Nullable VirtualFile var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(@Nullable FilePath var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(@Nullable VirtualFile var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(@Nullable FilePath var1);

    @Nullable
    public abstract VcsRoot getVcsRootObjectFor(@Nullable VirtualFile var1);

    @Nullable
    public abstract VcsRoot getVcsRootObjectFor(@Nullable FilePath var1);

    public abstract boolean checkVcsIsActive(@NotNull AbstractVcs var1);

    public abstract boolean checkVcsIsActive(@NonNls String var1);

    public abstract AbstractVcs @NotNull [] getAllSupportedVcss();

    public abstract AbstractVcs @NotNull [] getAllActiveVcss();

    @Nullable
    public abstract AbstractVcs getSingleVCS();

    public abstract boolean hasActiveVcss();

    public abstract boolean hasAnyMappings();

    @Deprecated(forRemoval=true)
    public abstract void addMessageToConsoleWindow(@Nls String var1, TextAttributes var2);

    public abstract void addMessageToConsoleWindow(@Nls @Nullable String var1, @NotNull ConsoleViewContentType var2);

    public abstract void addMessageToConsoleWindow(@Nullable VcsConsoleLine var1);

    @NotNull
    public abstract VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption var1, @NotNull AbstractVcs var2);

    @NotNull
    public abstract VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation var1, AbstractVcs var2);

    @RequiresEdt
    public abstract void showProjectOperationInfo(UpdatedFiles var1, @Nls String var2);

    public abstract void startBackgroundVcsOperation();

    public abstract void stopBackgroundVcsOperation();

    public abstract boolean isBackgroundVcsOperationRunning();

    public abstract List<VirtualFile> getRootsUnderVcsWithoutFiltering(@NotNull AbstractVcs var1);

    public abstract VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs var1);

    public abstract VirtualFile[] getAllVersionedRoots();

    public abstract VcsRoot @NotNull [] getAllVcsRoots();

    @Nls
    public abstract String getConsolidatedVcsName();

    @Deprecated(forRemoval=true)
    public void updateActiveVcss() {
    }

    public abstract List<VcsDirectoryMapping> getDirectoryMappings();

    public abstract List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs var1);

    @Nullable
    public abstract VcsDirectoryMapping getDirectoryMappingFor(@Nullable FilePath var1);

    @Deprecated(forRemoval=true)
    public abstract void setDirectoryMapping(@NonNls String var1, @NonNls String var2);

    public abstract void setDirectoryMappings(List<VcsDirectoryMapping> var1);

    public abstract void iterateVcsRoot(VirtualFile var1, Processor<? super FilePath> var2);

    public abstract void iterateVcsRoot(VirtualFile var1, Processor<? super FilePath> var2, @Nullable VirtualFileFilter var3);

    @Nullable
    public abstract AbstractVcs findVersioningVcs(@NotNull VirtualFile var1);

    @NotNull
    public abstract VcsRootChecker getRootChecker(@NotNull AbstractVcs var1);

    public abstract CheckoutProvider.Listener getCompositeCheckoutListener();

    public abstract VcsHistoryCache getVcsHistoryCache();

    public abstract ContentRevisionCache getContentRevisionCache();

    public abstract boolean isFileInContent(VirtualFile var1);

    public abstract boolean isIgnored(@NotNull VirtualFile var1);

    public abstract boolean isIgnored(@NotNull FilePath var1);

    @NotNull
    public abstract VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener();

    @Deprecated
    @RequiresEdt
    public abstract void showConsole(@Nullable Runnable var1);

    @Deprecated
    @RequiresEdt
    public abstract void scrollConsoleToTheEnd();

    public abstract void runAfterInitialization(@NotNull Runnable var1);

    public boolean areVcsesActivated() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ProjectLevelVcsManager", "getInstance"));
    }
}

