/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.ruby;

import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtFunctionInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class RubyFunctionIndexer
implements DataIndexer<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo, FileContent> {
    private static final Pattern RUBY_ADD_FUNCTION_PATTERN = Pattern.compile("newfunction\\s*\\((?:\"|'|:)([^ ,)\"]+)(?:\"|')?(?:\\)|,)");

    RubyFunctionIndexer() {
    }

    @NotNull
    public Map<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            RubyFunctionIndexer.$$$reportNull$$$0(0);
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> result = new HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo>();
        Matcher matcher = RUBY_ADD_FUNCTION_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String functionName = matcher.group(1);
            if (!PuppetLibraryUtil.isFunctionsStubsFile(inputData.getFile()) && !inputData.getFileName().equals(functionName + ".rb")) continue;
            result.put(new PuppetRubyPluginsIndex.EntryKey(PuppetRubyPluginsIndex.SymbolType.FUNCTION, functionName), new PuppetExtFunctionInfo(matcher.start(1), Collections.emptyList()));
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> hashMap = result;
        if (hashMap == null) {
            RubyFunctionIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyFunctionIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyFunctionIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

