/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.pro.coverage.PyCoverageEnabledConfiguration;
import com.intellij.python.pro.coverage.PyCoverageTargetedCommandLineBuilder;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunner;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class PythonCoverageRunner
extends PythonRunner {
    public static final String PYTHON_COVERAGE_RUNNER = "PythonCover";

    protected @NotNull Promise<@Nullable RunContentDescriptor> execute(@NotNull ExecutionEnvironment env, @NotNull RunProfileState state) {
        if (env == null) {
            PythonCoverageRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PythonCoverageRunner.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            try {
                ExecutionResult executionResult;
                if (state instanceof PythonCommandLineState && ((PythonCommandLineState)state).getConfig() != null) {
                    AbstractPythonRunConfiguration configuration = ((PythonCommandLineState)state).getConfig();
                    PyCoverageEnabledConfiguration pyCoverageEnabledConfiguration = PyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration);
                    if (pyCoverageEnabledConfiguration == null) {
                        throw new IllegalStateException("Cannot get PyCoverageEnabledConfiguration from " + String.valueOf(configuration));
                    }
                    PyCoverageTargetedCommandLineBuilder builder = new PyCoverageTargetedCommandLineBuilder(configuration.getProject(), configuration.getModule(), configuration.getSdk(), PythonCoverageRunner.getInterpreterParameters(configuration.getInterpreterOptions()), pyCoverageEnabledConfiguration);
                    executionResult = ((PythonCommandLineState)state).execute(env.getExecutor(), (PythonScriptTargetedCommandLineBuilder)builder);
                } else {
                    executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
                }
                ApplicationManager.getApplication().invokeLater(() -> promise.setResult((Object)DefaultProgramRunnerKt.showRunContent((ExecutionResult)executionResult, (ExecutionEnvironment)env)), ModalityState.any());
            }
            catch (ExecutionException | RuntimeException err) {
                promise.setError(err);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            PythonCoverageRunner.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @NotNull
    private static List<String> getInterpreterParameters(@Nullable String interpreterOptionsString) {
        if (StringUtil.isEmptyOrSpaces((String)interpreterOptionsString)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PythonCoverageRunner.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ParametersListUtil.parse((String)interpreterOptionsString);
        if (list == null) {
            PythonCoverageRunner.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PythonCoverageRunner.$$$reportNull$$$0(5);
        }
        if (profile == null) {
            PythonCoverageRunner.$$$reportNull$$$0(6);
        }
        return executorId.equals("Coverage") && profile instanceof AbstractPythonRunConfiguration && ((AbstractPythonRunConfiguration)profile).canRunWithCoverage();
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            PythonCoverageRunner.$$$reportNull$$$0(7);
        }
        return new CoverageRunnerData();
    }

    @NotNull
    public String getRunnerId() {
        return PYTHON_COVERAGE_RUNNER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/coverage/PythonCoverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/coverage/PythonCoverageRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

