/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.compare.CompareViewerPane;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.DialogSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public final class ParticipantPagePane {
    private final ISynchronizeParticipant participant;
    private final ISynchronizePageConfiguration pageConfiguration;
    private Image titleImage;
    private Shell shell;
    private final boolean isModal;
    private CompareViewerPane fEditionPane;
    private IPageBookViewPage fPage;
    private DialogSynchronizePageSite site;

    public ParticipantPagePane(Shell shell, boolean isModal, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
        this.isModal = isModal;
        this.shell = shell;
        this.participant = participant;
        this.pageConfiguration = pageConfiguration;
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.fPage != null) {
            this.fPage.dispose();
        }
        if (this.site != null) {
            this.site.dispose();
        }
    }

    public Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = this.participant.getImageDescriptor().createImage();
        }
        return this.titleImage;
    }

    public String getTitle() {
        return Utils.shortenText(100, this.participant.getName());
    }

    public Control createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        top.setLayout((Layout)layout);
        this.shell = parent.getShell();
        this.fEditionPane = new CompareViewerPane(top, 0x800800);
        this.fEditionPane.setText(TeamUIMessages.ParticipantPageSaveablePart_0);
        this.fEditionPane.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.fPage = this.participant.createPage(this.pageConfiguration);
        this.site = new DialogSynchronizePageSite(this.shell, this.isModal);
        ((SynchronizePageConfiguration)this.pageConfiguration).setSite(this.site);
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.fEditionPane);
        this.site.createActionBars((IToolBarManager)tbm);
        try {
            ((ISynchronizePage)this.fPage).init(this.pageConfiguration.getSite());
        }
        catch (PartInitException e1) {
            TeamUIPlugin.log(4, TeamUIMessages.ParticipantPagePane_0, e1);
        }
        this.fPage.createControl((Composite)this.fEditionPane);
        this.fPage.setActionBars(this.site.getActionBars());
        this.fEditionPane.setContent(this.fPage.getControl());
        tbm.update(true);
        return top;
    }

    public ISynchronizePageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }
}

