// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/bigquery/datapolicies/v1beta1/datapolicy.proto

package datapoliciespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A list of supported data policy types.
type DataPolicy_DataPolicyType int32

const (
	// Default value for the data policy type. This should not be used.
	DataPolicy_DATA_POLICY_TYPE_UNSPECIFIED DataPolicy_DataPolicyType = 0
	// Used to create a data policy for column-level security, without data
	// masking.
	DataPolicy_COLUMN_LEVEL_SECURITY_POLICY DataPolicy_DataPolicyType = 3
	// Used to create a data policy for data masking.
	DataPolicy_DATA_MASKING_POLICY DataPolicy_DataPolicyType = 2
)

// Enum value maps for DataPolicy_DataPolicyType.
var (
	DataPolicy_DataPolicyType_name = map[int32]string{
		0: "DATA_POLICY_TYPE_UNSPECIFIED",
		3: "COLUMN_LEVEL_SECURITY_POLICY",
		2: "DATA_MASKING_POLICY",
	}
	DataPolicy_DataPolicyType_value = map[string]int32{
		"DATA_POLICY_TYPE_UNSPECIFIED": 0,
		"COLUMN_LEVEL_SECURITY_POLICY": 3,
		"DATA_MASKING_POLICY":          2,
	}
)

func (x DataPolicy_DataPolicyType) Enum() *DataPolicy_DataPolicyType {
	p := new(DataPolicy_DataPolicyType)
	*p = x
	return p
}

func (x DataPolicy_DataPolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataPolicy_DataPolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes[0].Descriptor()
}

func (DataPolicy_DataPolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes[0]
}

func (x DataPolicy_DataPolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataPolicy_DataPolicyType.Descriptor instead.
func (DataPolicy_DataPolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{6, 0}
}

// The available masking rules. Learn more here:
// https://cloud.google.com/bigquery/docs/column-data-masking-intro#masking_options.
type DataMaskingPolicy_PredefinedExpression int32

const (
	// Default, unspecified predefined expression. No masking will take place
	// since no expression is specified.
	DataMaskingPolicy_PREDEFINED_EXPRESSION_UNSPECIFIED DataMaskingPolicy_PredefinedExpression = 0
	// Masking expression to replace data with SHA-256 hash.
	DataMaskingPolicy_SHA256 DataMaskingPolicy_PredefinedExpression = 3
	// Masking expression to replace data with NULLs.
	DataMaskingPolicy_ALWAYS_NULL DataMaskingPolicy_PredefinedExpression = 5
	// Masking expression to replace data with their default masking values.
	// The default masking values for each type listed as below:
	//
	// * STRING: ""
	// * BYTES: b”
	// * INTEGER: 0
	// * FLOAT: 0.0
	// * NUMERIC: 0
	// * BOOLEAN: FALSE
	// * TIMESTAMP: 0001-01-01 00:00:00 UTC
	// * DATE: 0001-01-01
	// * TIME: 00:00:00
	// * DATETIME: 0001-01-01T00:00:00
	// * GEOGRAPHY: POINT(0 0)
	// * BIGNUMERIC: 0
	// * ARRAY: []
	// * STRUCT: NOT_APPLICABLE
	// * JSON: NULL
	DataMaskingPolicy_DEFAULT_MASKING_VALUE DataMaskingPolicy_PredefinedExpression = 7
)

// Enum value maps for DataMaskingPolicy_PredefinedExpression.
var (
	DataMaskingPolicy_PredefinedExpression_name = map[int32]string{
		0: "PREDEFINED_EXPRESSION_UNSPECIFIED",
		3: "SHA256",
		5: "ALWAYS_NULL",
		7: "DEFAULT_MASKING_VALUE",
	}
	DataMaskingPolicy_PredefinedExpression_value = map[string]int32{
		"PREDEFINED_EXPRESSION_UNSPECIFIED": 0,
		"SHA256":                            3,
		"ALWAYS_NULL":                       5,
		"DEFAULT_MASKING_VALUE":             7,
	}
)

func (x DataMaskingPolicy_PredefinedExpression) Enum() *DataMaskingPolicy_PredefinedExpression {
	p := new(DataMaskingPolicy_PredefinedExpression)
	*p = x
	return p
}

func (x DataMaskingPolicy_PredefinedExpression) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataMaskingPolicy_PredefinedExpression) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes[1].Descriptor()
}

func (DataMaskingPolicy_PredefinedExpression) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes[1]
}

func (x DataMaskingPolicy_PredefinedExpression) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataMaskingPolicy_PredefinedExpression.Descriptor instead.
func (DataMaskingPolicy_PredefinedExpression) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{7, 0}
}

// Request message for the CreateDataPolicy method.
type CreateDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project that the data policy will belong to. The
	// format is `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The data policy to create. The `name` field does not need to be
	// provided for the data policy creation.
	DataPolicy *DataPolicy `protobuf:"bytes,2,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
}

func (x *CreateDataPolicyRequest) Reset() {
	*x = CreateDataPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataPolicyRequest) ProtoMessage() {}

func (x *CreateDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDataPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataPolicyRequest) GetDataPolicy() *DataPolicy {
	if x != nil {
		return x.DataPolicy
	}
	return nil
}

// Response message for the UpdateDataPolicy method.
type UpdateDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Update the data policy's metadata.
	//
	// The target data policy is determined by the `name` field.
	// Other fields are updated to the specified values based on the field masks.
	DataPolicy *DataPolicy `protobuf:"bytes,1,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
	// The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If not set, defaults to all of the fields that are allowed to update.
	//
	// Updates to the `name` and `dataPolicyId` fields are not allowed.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataPolicyRequest) Reset() {
	*x = UpdateDataPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataPolicyRequest) ProtoMessage() {}

func (x *UpdateDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateDataPolicyRequest) GetDataPolicy() *DataPolicy {
	if x != nil {
		return x.DataPolicy
	}
	return nil
}

func (x *UpdateDataPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for the DeleteDataPolicy method.
type DeleteDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the data policy to delete. Format is
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataPolicyRequest) Reset() {
	*x = DeleteDataPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataPolicyRequest) ProtoMessage() {}

func (x *DeleteDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteDataPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the GetDataPolicy method.
type GetDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the requested data policy. Format is
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataPolicyRequest) Reset() {
	*x = GetDataPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataPolicyRequest) ProtoMessage() {}

func (x *GetDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{3}
}

func (x *GetDataPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListDataPolicies method.
type ListDataPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project for which to list data policies. Format is
	// `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of data policies to return. Must be a value between 1
	// and 1000.
	// If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous list request, if any. If
	// not set, defaults to an empty string.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataPoliciesRequest) Reset() {
	*x = ListDataPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataPoliciesRequest) ProtoMessage() {}

func (x *ListDataPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListDataPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{4}
}

func (x *ListDataPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListDataPolicies method.
type ListDataPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data policies that belong to the requested project.
	DataPolicies []*DataPolicy `protobuf:"bytes,1,rep,name=data_policies,json=dataPolicies,proto3" json:"data_policies,omitempty"`
	// Token used to retrieve the next page of results, or empty if there are no
	// more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataPoliciesResponse) Reset() {
	*x = ListDataPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataPoliciesResponse) ProtoMessage() {}

func (x *ListDataPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListDataPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{5}
}

func (x *ListDataPoliciesResponse) GetDataPolicies() []*DataPolicy {
	if x != nil {
		return x.DataPolicies
	}
	return nil
}

func (x *ListDataPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the label-policy binding.
type DataPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label that is bound to this data policy.
	//
	// Types that are assignable to MatchingLabel:
	//
	//	*DataPolicy_PolicyTag
	MatchingLabel isDataPolicy_MatchingLabel `protobuf_oneof:"matching_label"`
	// The policy that is bound to this data policy.
	//
	// Types that are assignable to Policy:
	//
	//	*DataPolicy_DataMaskingPolicy
	Policy isDataPolicy_Policy `protobuf_oneof:"policy"`
	// Output only. Resource name of this data policy, in the format of
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of data policy.
	DataPolicyType DataPolicy_DataPolicyType `protobuf:"varint,2,opt,name=data_policy_type,json=dataPolicyType,proto3,enum=google.cloud.bigquery.datapolicies.v1beta1.DataPolicy_DataPolicyType" json:"data_policy_type,omitempty"`
	// User-assigned (human readable) ID of the data policy that needs to be
	// unique within a project. Used as {data_policy_id} in part of the resource
	// name.
	DataPolicyId string `protobuf:"bytes,3,opt,name=data_policy_id,json=dataPolicyId,proto3" json:"data_policy_id,omitempty"`
}

func (x *DataPolicy) Reset() {
	*x = DataPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataPolicy) ProtoMessage() {}

func (x *DataPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataPolicy.ProtoReflect.Descriptor instead.
func (*DataPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{6}
}

func (m *DataPolicy) GetMatchingLabel() isDataPolicy_MatchingLabel {
	if m != nil {
		return m.MatchingLabel
	}
	return nil
}

func (x *DataPolicy) GetPolicyTag() string {
	if x, ok := x.GetMatchingLabel().(*DataPolicy_PolicyTag); ok {
		return x.PolicyTag
	}
	return ""
}

func (m *DataPolicy) GetPolicy() isDataPolicy_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *DataPolicy) GetDataMaskingPolicy() *DataMaskingPolicy {
	if x, ok := x.GetPolicy().(*DataPolicy_DataMaskingPolicy); ok {
		return x.DataMaskingPolicy
	}
	return nil
}

func (x *DataPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataPolicy) GetDataPolicyType() DataPolicy_DataPolicyType {
	if x != nil {
		return x.DataPolicyType
	}
	return DataPolicy_DATA_POLICY_TYPE_UNSPECIFIED
}

func (x *DataPolicy) GetDataPolicyId() string {
	if x != nil {
		return x.DataPolicyId
	}
	return ""
}

type isDataPolicy_MatchingLabel interface {
	isDataPolicy_MatchingLabel()
}

type DataPolicy_PolicyTag struct {
	// Policy tag resource name, in the format of
	// `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
	PolicyTag string `protobuf:"bytes,4,opt,name=policy_tag,json=policyTag,proto3,oneof"`
}

func (*DataPolicy_PolicyTag) isDataPolicy_MatchingLabel() {}

type isDataPolicy_Policy interface {
	isDataPolicy_Policy()
}

type DataPolicy_DataMaskingPolicy struct {
	// The data masking policy that specifies the data masking rule to use.
	DataMaskingPolicy *DataMaskingPolicy `protobuf:"bytes,5,opt,name=data_masking_policy,json=dataMaskingPolicy,proto3,oneof"`
}

func (*DataPolicy_DataMaskingPolicy) isDataPolicy_Policy() {}

// The data masking policy that is used to specify data masking rule.
type DataMaskingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A masking expression to bind to the data masking rule.
	//
	// Types that are assignable to MaskingExpression:
	//
	//	*DataMaskingPolicy_PredefinedExpression_
	MaskingExpression isDataMaskingPolicy_MaskingExpression `protobuf_oneof:"masking_expression"`
}

func (x *DataMaskingPolicy) Reset() {
	*x = DataMaskingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataMaskingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataMaskingPolicy) ProtoMessage() {}

func (x *DataMaskingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataMaskingPolicy.ProtoReflect.Descriptor instead.
func (*DataMaskingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP(), []int{7}
}

func (m *DataMaskingPolicy) GetMaskingExpression() isDataMaskingPolicy_MaskingExpression {
	if m != nil {
		return m.MaskingExpression
	}
	return nil
}

func (x *DataMaskingPolicy) GetPredefinedExpression() DataMaskingPolicy_PredefinedExpression {
	if x, ok := x.GetMaskingExpression().(*DataMaskingPolicy_PredefinedExpression_); ok {
		return x.PredefinedExpression
	}
	return DataMaskingPolicy_PREDEFINED_EXPRESSION_UNSPECIFIED
}

type isDataMaskingPolicy_MaskingExpression interface {
	isDataMaskingPolicy_MaskingExpression()
}

type DataMaskingPolicy_PredefinedExpression_ struct {
	// A predefined masking expression.
	PredefinedExpression DataMaskingPolicy_PredefinedExpression `protobuf:"varint,1,opt,name=predefined_expression,json=predefinedExpression,proto3,enum=google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy_PredefinedExpression,oneof"`
}

func (*DataMaskingPolicy_PredefinedExpression_) isDataMaskingPolicy_MaskingExpression() {}

var File_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5c, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0xb4, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x63, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x12, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5b, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x04, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x6f, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x6f, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x22, 0x6d, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x53, 0x45, 0x43, 0x55, 0x52,
	0x49, 0x54, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x10, 0x02, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x42, 0x10, 0x0a, 0x0e,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x08,
	0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xac, 0x02, 0x0a, 0x11, 0x44, 0x61, 0x74,
	0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x89,
	0x01, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x0a, 0x14, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x52, 0x45, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44,
	0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x5f,
	0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10,
	0x07, 0x42, 0x14, 0x0a, 0x12, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xff, 0x0d, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf0, 0x01,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x5f, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x81, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0x70, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb5, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5,
	0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12,
	0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x9c, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x9c, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0xc2, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x7e, 0xca, 0x41, 0x21, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa2, 0x02, 0x0a, 0x2e, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0f, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x70, 0x62, 0xaa, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31,
	0xca, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescData = file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDesc
)

func file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescData)
	})
	return file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDescData
}

var file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_goTypes = []interface{}{
	(DataPolicy_DataPolicyType)(0),              // 0: google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
	(DataMaskingPolicy_PredefinedExpression)(0), // 1: google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.PredefinedExpression
	(*CreateDataPolicyRequest)(nil),             // 2: google.cloud.bigquery.datapolicies.v1beta1.CreateDataPolicyRequest
	(*UpdateDataPolicyRequest)(nil),             // 3: google.cloud.bigquery.datapolicies.v1beta1.UpdateDataPolicyRequest
	(*DeleteDataPolicyRequest)(nil),             // 4: google.cloud.bigquery.datapolicies.v1beta1.DeleteDataPolicyRequest
	(*GetDataPolicyRequest)(nil),                // 5: google.cloud.bigquery.datapolicies.v1beta1.GetDataPolicyRequest
	(*ListDataPoliciesRequest)(nil),             // 6: google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesRequest
	(*ListDataPoliciesResponse)(nil),            // 7: google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesResponse
	(*DataPolicy)(nil),                          // 8: google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	(*DataMaskingPolicy)(nil),                   // 9: google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
	(*fieldmaskpb.FieldMask)(nil),               // 10: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),           // 11: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),           // 12: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),     // 13: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                       // 14: google.protobuf.Empty
	(*iampb.Policy)(nil),                        // 15: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil),    // 16: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_depIdxs = []int32{
	8,  // 0: google.cloud.bigquery.datapolicies.v1beta1.CreateDataPolicyRequest.data_policy:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	8,  // 1: google.cloud.bigquery.datapolicies.v1beta1.UpdateDataPolicyRequest.data_policy:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	10, // 2: google.cloud.bigquery.datapolicies.v1beta1.UpdateDataPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 3: google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesResponse.data_policies:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	9,  // 4: google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.data_masking_policy:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy
	0,  // 5: google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.data_policy_type:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy.DataPolicyType
	1,  // 6: google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.predefined_expression:type_name -> google.cloud.bigquery.datapolicies.v1beta1.DataMaskingPolicy.PredefinedExpression
	2,  // 7: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.CreateDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v1beta1.CreateDataPolicyRequest
	3,  // 8: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.UpdateDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v1beta1.UpdateDataPolicyRequest
	4,  // 9: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.DeleteDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v1beta1.DeleteDataPolicyRequest
	5,  // 10: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.GetDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v1beta1.GetDataPolicyRequest
	6,  // 11: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.ListDataPolicies:input_type -> google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesRequest
	11, // 12: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	12, // 13: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	13, // 14: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	8,  // 15: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.CreateDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	8,  // 16: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.UpdateDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	14, // 17: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.DeleteDataPolicy:output_type -> google.protobuf.Empty
	8,  // 18: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.GetDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v1beta1.DataPolicy
	7,  // 19: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.ListDataPolicies:output_type -> google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesResponse
	15, // 20: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.GetIamPolicy:output_type -> google.iam.v1.Policy
	15, // 21: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.SetIamPolicy:output_type -> google.iam.v1.Policy
	16, // 22: google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	15, // [15:23] is the sub-list for method output_type
	7,  // [7:15] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_init() }
func file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_init() {
	if File_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataMaskingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*DataPolicy_PolicyTag)(nil),
		(*DataPolicy_DataMaskingPolicy)(nil),
	}
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*DataMaskingPolicy_PredefinedExpression_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto = out.File
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_rawDesc = nil
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_goTypes = nil
	file_google_cloud_bigquery_datapolicies_v1beta1_datapolicy_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataPolicyServiceClient is the client API for DataPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataPolicyServiceClient interface {
	// Creates a new data policy under a project with the given `dataPolicyId`
	// (used as the display name), policy tag, and data policy type.
	CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type dataPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataPolicyServiceClient(cc grpc.ClientConnInterface) DataPolicyServiceClient {
	return &dataPolicyServiceClient{cc}
}

func (c *dataPolicyServiceClient) CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/CreateDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/UpdateDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/DeleteDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/GetDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error) {
	out := new(ListDataPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/ListDataPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataPolicyServiceServer is the server API for DataPolicyService service.
type DataPolicyServiceServer interface {
	// Creates a new data policy under a project with the given `dataPolicyId`
	// (used as the display name), policy tag, and data policy type.
	CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedDataPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataPolicyServiceServer struct {
}

func (*UnimplementedDataPolicyServiceServer) CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataPolicies not implemented")
}
func (*UnimplementedDataPolicyServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataPolicyServiceServer(s *grpc.Server, srv DataPolicyServiceServer) {
	s.RegisterService(&_DataPolicyService_serviceDesc, srv)
}

func _DataPolicyService_CreateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/CreateDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, req.(*CreateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_UpdateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/UpdateDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, req.(*UpdateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_DeleteDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/DeleteDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, req.(*DeleteDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/GetDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, req.(*GetDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_ListDataPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/ListDataPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, req.(*ListDataPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datapolicies.v1beta1.DataPolicyService",
	HandlerType: (*DataPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataPolicy",
			Handler:    _DataPolicyService_CreateDataPolicy_Handler,
		},
		{
			MethodName: "UpdateDataPolicy",
			Handler:    _DataPolicyService_UpdateDataPolicy_Handler,
		},
		{
			MethodName: "DeleteDataPolicy",
			Handler:    _DataPolicyService_DeleteDataPolicy_Handler,
		},
		{
			MethodName: "GetDataPolicy",
			Handler:    _DataPolicyService_GetDataPolicy_Handler,
		},
		{
			MethodName: "ListDataPolicies",
			Handler:    _DataPolicyService_ListDataPolicies_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataPolicyService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataPolicyService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataPolicyService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datapolicies/v1beta1/datapolicy.proto",
}
