// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/gkemulticloud/v1/azure_resources.proto

package gkemulticloudpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The lifecycle state of the cluster.
type AzureCluster_State int32

const (
	// Not set.
	AzureCluster_STATE_UNSPECIFIED AzureCluster_State = 0
	// The PROVISIONING state indicates the cluster is being created.
	AzureCluster_PROVISIONING AzureCluster_State = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	AzureCluster_RUNNING AzureCluster_State = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the control plane replicas.
	AzureCluster_RECONCILING AzureCluster_State = 3
	// The STOPPING state indicates the cluster is being deleted.
	AzureCluster_STOPPING AzureCluster_State = 4
	// The ERROR state indicates the cluster is in a broken unrecoverable
	// state.
	AzureCluster_ERROR AzureCluster_State = 5
	// The DEGRADED state indicates the cluster requires user action to
	// restore full functionality.
	AzureCluster_DEGRADED AzureCluster_State = 6
)

// Enum value maps for AzureCluster_State.
var (
	AzureCluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	AzureCluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           2,
		"RECONCILING":       3,
		"STOPPING":          4,
		"ERROR":             5,
		"DEGRADED":          6,
	}
)

func (x AzureCluster_State) Enum() *AzureCluster_State {
	p := new(AzureCluster_State)
	*p = x
	return p
}

func (x AzureCluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureCluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes[0].Descriptor()
}

func (AzureCluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes[0]
}

func (x AzureCluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureCluster_State.Descriptor instead.
func (AzureCluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The lifecycle state of the node pool.
type AzureNodePool_State int32

const (
	// Not set.
	AzureNodePool_STATE_UNSPECIFIED AzureNodePool_State = 0
	// The PROVISIONING state indicates the node pool is being created.
	AzureNodePool_PROVISIONING AzureNodePool_State = 1
	// The RUNNING state indicates the node pool has been created and is fully
	// usable.
	AzureNodePool_RUNNING AzureNodePool_State = 2
	// The RECONCILING state indicates that the node pool is being reconciled.
	AzureNodePool_RECONCILING AzureNodePool_State = 3
	// The STOPPING state indicates the node pool is being deleted.
	AzureNodePool_STOPPING AzureNodePool_State = 4
	// The ERROR state indicates the node pool is in a broken unrecoverable
	// state.
	AzureNodePool_ERROR AzureNodePool_State = 5
	// The DEGRADED state indicates the node pool requires user action to
	// restore full functionality.
	AzureNodePool_DEGRADED AzureNodePool_State = 6
)

// Enum value maps for AzureNodePool_State.
var (
	AzureNodePool_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	AzureNodePool_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           2,
		"RECONCILING":       3,
		"STOPPING":          4,
		"ERROR":             5,
		"DEGRADED":          6,
	}
)

func (x AzureNodePool_State) Enum() *AzureNodePool_State {
	p := new(AzureNodePool_State)
	*p = x
	return p
}

func (x AzureNodePool_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureNodePool_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes[1].Descriptor()
}

func (AzureNodePool_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes[1]
}

func (x AzureNodePool_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureNodePool_State.Descriptor instead.
func (AzureNodePool_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{13, 0}
}

// An Anthos cluster running on Azure.
type AzureCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// Cluster names are formatted as
	// `projects/<project-number>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human readable description of this cluster.
	// Cannot be longer than 255 UTF-8 encoded bytes.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The Azure region where the cluster runs.
	//
	// Each Google Cloud region supports a subset of nearby Azure regions.
	// You can call
	// [GetAzureServerConfig][google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig]
	// to list all supported Azure regions within a given Google Cloud region.
	AzureRegion string `protobuf:"bytes,3,opt,name=azure_region,json=azureRegion,proto3" json:"azure_region,omitempty"`
	// Required. The ARM ID of the resource group where the cluster resources are
	// deployed. For example:
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-name>`
	ResourceGroupId string `protobuf:"bytes,17,opt,name=resource_group_id,json=resourceGroupId,proto3" json:"resource_group_id,omitempty"`
	// Optional. Name of the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] that contains
	// authentication configuration for how the Anthos Multi-Cloud API connects to
	// Azure APIs.
	//
	// Either azure_client or azure_services_authentication should be provided.
	//
	// The `AzureClient` resource must reside on the same Google Cloud Platform
	// project and region as the `AzureCluster`.
	//
	// `AzureClient` names are formatted as
	// `projects/<project-number>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	AzureClient string `protobuf:"bytes,16,opt,name=azure_client,json=azureClient,proto3" json:"azure_client,omitempty"`
	// Required. Cluster-wide networking configuration.
	Networking *AzureClusterNetworking `protobuf:"bytes,4,opt,name=networking,proto3" json:"networking,omitempty"`
	// Required. Configuration related to the cluster control plane.
	ControlPlane *AzureControlPlane `protobuf:"bytes,5,opt,name=control_plane,json=controlPlane,proto3" json:"control_plane,omitempty"`
	// Required. Configuration related to the cluster RBAC settings.
	Authorization *AzureAuthorization `protobuf:"bytes,6,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Optional. Authentication configuration for management of Azure resources.
	//
	// Either azure_client or azure_services_authentication should be provided.
	AzureServicesAuthentication *AzureServicesAuthentication `protobuf:"bytes,22,opt,name=azure_services_authentication,json=azureServicesAuthentication,proto3" json:"azure_services_authentication,omitempty"`
	// Output only. The current state of the cluster.
	State AzureCluster_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.gkemulticloud.v1.AzureCluster_State" json:"state,omitempty"`
	// Output only. The endpoint of the cluster's API server.
	Endpoint string `protobuf:"bytes,8,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. A globally unique identifier for the cluster.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. If set, there are currently changes in flight to the cluster.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The time at which this cluster was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this cluster was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	//
	// Can be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,13,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Annotations on the cluster.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Keys can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,14,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Workload Identity settings.
	WorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,18,opt,name=workload_identity_config,json=workloadIdentityConfig,proto3" json:"workload_identity_config,omitempty"`
	// Output only. PEM encoded x509 certificate of the cluster root of trust.
	ClusterCaCertificate string `protobuf:"bytes,19,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// Required. Fleet configuration.
	Fleet *Fleet `protobuf:"bytes,20,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Output only. Managed Azure resources for this cluster.
	ManagedResources *AzureClusterResources `protobuf:"bytes,21,opt,name=managed_resources,json=managedResources,proto3" json:"managed_resources,omitempty"`
	// Optional. Logging configuration for this cluster.
	LoggingConfig *LoggingConfig `protobuf:"bytes,23,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Output only. A set of errors found in the cluster.
	Errors []*AzureClusterError `protobuf:"bytes,24,rep,name=errors,proto3" json:"errors,omitempty"`
	// Optional. Monitoring configuration for this cluster.
	MonitoringConfig *MonitoringConfig `protobuf:"bytes,25,opt,name=monitoring_config,json=monitoringConfig,proto3" json:"monitoring_config,omitempty"`
}

func (x *AzureCluster) Reset() {
	*x = AzureCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureCluster) ProtoMessage() {}

func (x *AzureCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureCluster.ProtoReflect.Descriptor instead.
func (*AzureCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{0}
}

func (x *AzureCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureCluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AzureCluster) GetAzureRegion() string {
	if x != nil {
		return x.AzureRegion
	}
	return ""
}

func (x *AzureCluster) GetResourceGroupId() string {
	if x != nil {
		return x.ResourceGroupId
	}
	return ""
}

func (x *AzureCluster) GetAzureClient() string {
	if x != nil {
		return x.AzureClient
	}
	return ""
}

func (x *AzureCluster) GetNetworking() *AzureClusterNetworking {
	if x != nil {
		return x.Networking
	}
	return nil
}

func (x *AzureCluster) GetControlPlane() *AzureControlPlane {
	if x != nil {
		return x.ControlPlane
	}
	return nil
}

func (x *AzureCluster) GetAuthorization() *AzureAuthorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *AzureCluster) GetAzureServicesAuthentication() *AzureServicesAuthentication {
	if x != nil {
		return x.AzureServicesAuthentication
	}
	return nil
}

func (x *AzureCluster) GetState() AzureCluster_State {
	if x != nil {
		return x.State
	}
	return AzureCluster_STATE_UNSPECIFIED
}

func (x *AzureCluster) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *AzureCluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AzureCluster) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AzureCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AzureCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AzureCluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AzureCluster) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AzureCluster) GetWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.WorkloadIdentityConfig
	}
	return nil
}

func (x *AzureCluster) GetClusterCaCertificate() string {
	if x != nil {
		return x.ClusterCaCertificate
	}
	return ""
}

func (x *AzureCluster) GetFleet() *Fleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *AzureCluster) GetManagedResources() *AzureClusterResources {
	if x != nil {
		return x.ManagedResources
	}
	return nil
}

func (x *AzureCluster) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *AzureCluster) GetErrors() []*AzureClusterError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *AzureCluster) GetMonitoringConfig() *MonitoringConfig {
	if x != nil {
		return x.MonitoringConfig
	}
	return nil
}

// ClusterNetworking contains cluster-wide networking configuration.
type AzureClusterNetworking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Azure Resource Manager (ARM) ID of the VNet associated with
	// your cluster.
	//
	// All components in the cluster (i.e. control plane and node pools) run on a
	// single VNet.
	//
	// Example:
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.Network/virtualNetworks/<vnet-id>`
	//
	// This field cannot be changed after creation.
	VirtualNetworkId string `protobuf:"bytes,1,opt,name=virtual_network_id,json=virtualNetworkId,proto3" json:"virtual_network_id,omitempty"`
	// Required. The IP address range of the pods in this cluster, in CIDR
	// notation (e.g. `10.96.0.0/14`).
	//
	// All pods in the cluster get assigned a unique IPv4 address from these
	// ranges. Only a single range is supported.
	//
	// This field cannot be changed after creation.
	PodAddressCidrBlocks []string `protobuf:"bytes,2,rep,name=pod_address_cidr_blocks,json=podAddressCidrBlocks,proto3" json:"pod_address_cidr_blocks,omitempty"`
	// Required. The IP address range for services in this cluster, in CIDR
	// notation (e.g. `10.96.0.0/14`).
	//
	// All services in the cluster get assigned a unique IPv4 address from these
	// ranges. Only a single range is supported.
	//
	// This field cannot be changed after creating a cluster.
	ServiceAddressCidrBlocks []string `protobuf:"bytes,3,rep,name=service_address_cidr_blocks,json=serviceAddressCidrBlocks,proto3" json:"service_address_cidr_blocks,omitempty"`
	// Optional. The ARM ID of the subnet where Kubernetes private service type
	// load balancers are deployed. When unspecified, it defaults to
	// AzureControlPlane.subnet_id.
	//
	// Example:
	// "/subscriptions/d00494d6-6f3c-4280-bbb2-899e163d1d30/resourceGroups/anthos_cluster_gkeust4/providers/Microsoft.Network/virtualNetworks/gke-vnet-gkeust4/subnets/subnetid456"
	ServiceLoadBalancerSubnetId string `protobuf:"bytes,5,opt,name=service_load_balancer_subnet_id,json=serviceLoadBalancerSubnetId,proto3" json:"service_load_balancer_subnet_id,omitempty"`
}

func (x *AzureClusterNetworking) Reset() {
	*x = AzureClusterNetworking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClusterNetworking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClusterNetworking) ProtoMessage() {}

func (x *AzureClusterNetworking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClusterNetworking.ProtoReflect.Descriptor instead.
func (*AzureClusterNetworking) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{1}
}

func (x *AzureClusterNetworking) GetVirtualNetworkId() string {
	if x != nil {
		return x.VirtualNetworkId
	}
	return ""
}

func (x *AzureClusterNetworking) GetPodAddressCidrBlocks() []string {
	if x != nil {
		return x.PodAddressCidrBlocks
	}
	return nil
}

func (x *AzureClusterNetworking) GetServiceAddressCidrBlocks() []string {
	if x != nil {
		return x.ServiceAddressCidrBlocks
	}
	return nil
}

func (x *AzureClusterNetworking) GetServiceLoadBalancerSubnetId() string {
	if x != nil {
		return x.ServiceLoadBalancerSubnetId
	}
	return ""
}

// AzureControlPlane represents the control plane configurations.
type AzureControlPlane struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Kubernetes version to run on control plane replicas
	// (e.g. `1.19.10-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAzureServerConfig][google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig].
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. The ARM ID of the default subnet for the control plane. The
	// control plane VMs are deployed in this subnet, unless
	// `AzureControlPlane.replica_placements` is specified. This subnet will also
	// be used as default for `AzureControlPlane.endpoint_subnet_id` if
	// `AzureControlPlane.endpoint_subnet_id` is not specified. Similarly it will
	// be used as default for
	// `AzureClusterNetworking.service_load_balancer_subnet_id`.
	//
	// Example:
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.Network/virtualNetworks/<vnet-id>/subnets/default`.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Optional. The Azure VM size name. Example: `Standard_DS2_v2`.
	//
	// For available VM sizes, see
	// https://docs.microsoft.com/en-us/azure/virtual-machines/vm-naming-conventions.
	//
	// When unspecified, it defaults to `Standard_DS2_v2`.
	VmSize string `protobuf:"bytes,3,opt,name=vm_size,json=vmSize,proto3" json:"vm_size,omitempty"`
	// Required. SSH configuration for how to access the underlying control plane
	// machines.
	SshConfig *AzureSshConfig `protobuf:"bytes,11,opt,name=ssh_config,json=sshConfig,proto3" json:"ssh_config,omitempty"`
	// Optional. Configuration related to the root volume provisioned for each
	// control plane replica.
	//
	// When unspecified, it defaults to 32-GiB Azure Disk.
	RootVolume *AzureDiskTemplate `protobuf:"bytes,4,opt,name=root_volume,json=rootVolume,proto3" json:"root_volume,omitempty"`
	// Optional. Configuration related to the main volume provisioned for each
	// control plane replica.
	// The main volume is in charge of storing all of the cluster's etcd state.
	//
	// When unspecified, it defaults to a 8-GiB Azure Disk.
	MainVolume *AzureDiskTemplate `protobuf:"bytes,5,opt,name=main_volume,json=mainVolume,proto3" json:"main_volume,omitempty"`
	// Optional. Configuration related to application-layer secrets encryption.
	DatabaseEncryption *AzureDatabaseEncryption `protobuf:"bytes,10,opt,name=database_encryption,json=databaseEncryption,proto3" json:"database_encryption,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AzureProxyConfig `protobuf:"bytes,12,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
	// Optional. Configuration related to vm config encryption.
	ConfigEncryption *AzureConfigEncryption `protobuf:"bytes,14,opt,name=config_encryption,json=configEncryption,proto3" json:"config_encryption,omitempty"`
	// Optional. A set of tags to apply to all underlying control plane Azure
	// resources.
	Tags map[string]string `protobuf:"bytes,7,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Configuration for where to place the control plane replicas.
	//
	// Up to three replica placement instances can be specified. If
	// replica_placements is set, the replica placement instances will be applied
	// to the three control plane replicas as evenly as possible.
	ReplicaPlacements []*ReplicaPlacement `protobuf:"bytes,13,rep,name=replica_placements,json=replicaPlacements,proto3" json:"replica_placements,omitempty"`
	// Optional. The ARM ID of the subnet where the control plane load balancer is
	// deployed. When unspecified, it defaults to AzureControlPlane.subnet_id.
	//
	// Example:
	// "/subscriptions/d00494d6-6f3c-4280-bbb2-899e163d1d30/resourceGroups/anthos_cluster_gkeust4/providers/Microsoft.Network/virtualNetworks/gke-vnet-gkeust4/subnets/subnetid123"
	EndpointSubnetId string `protobuf:"bytes,15,opt,name=endpoint_subnet_id,json=endpointSubnetId,proto3" json:"endpoint_subnet_id,omitempty"`
}

func (x *AzureControlPlane) Reset() {
	*x = AzureControlPlane{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureControlPlane) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureControlPlane) ProtoMessage() {}

func (x *AzureControlPlane) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureControlPlane.ProtoReflect.Descriptor instead.
func (*AzureControlPlane) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{2}
}

func (x *AzureControlPlane) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AzureControlPlane) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *AzureControlPlane) GetVmSize() string {
	if x != nil {
		return x.VmSize
	}
	return ""
}

func (x *AzureControlPlane) GetSshConfig() *AzureSshConfig {
	if x != nil {
		return x.SshConfig
	}
	return nil
}

func (x *AzureControlPlane) GetRootVolume() *AzureDiskTemplate {
	if x != nil {
		return x.RootVolume
	}
	return nil
}

func (x *AzureControlPlane) GetMainVolume() *AzureDiskTemplate {
	if x != nil {
		return x.MainVolume
	}
	return nil
}

func (x *AzureControlPlane) GetDatabaseEncryption() *AzureDatabaseEncryption {
	if x != nil {
		return x.DatabaseEncryption
	}
	return nil
}

func (x *AzureControlPlane) GetProxyConfig() *AzureProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

func (x *AzureControlPlane) GetConfigEncryption() *AzureConfigEncryption {
	if x != nil {
		return x.ConfigEncryption
	}
	return nil
}

func (x *AzureControlPlane) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AzureControlPlane) GetReplicaPlacements() []*ReplicaPlacement {
	if x != nil {
		return x.ReplicaPlacements
	}
	return nil
}

func (x *AzureControlPlane) GetEndpointSubnetId() string {
	if x != nil {
		return x.EndpointSubnetId
	}
	return ""
}

// Configuration for the placement of a control plane replica.
type ReplicaPlacement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. For a given replica, the ARM ID of the subnet where the control
	// plane VM is deployed. Make sure it's a subnet under the virtual network in
	// the cluster configuration.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Required. For a given replica, the Azure availability zone where to
	// provision the control plane VM and the ETCD disk.
	AzureAvailabilityZone string `protobuf:"bytes,2,opt,name=azure_availability_zone,json=azureAvailabilityZone,proto3" json:"azure_availability_zone,omitempty"`
}

func (x *ReplicaPlacement) Reset() {
	*x = ReplicaPlacement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicaPlacement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaPlacement) ProtoMessage() {}

func (x *ReplicaPlacement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaPlacement.ProtoReflect.Descriptor instead.
func (*ReplicaPlacement) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ReplicaPlacement) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *ReplicaPlacement) GetAzureAvailabilityZone() string {
	if x != nil {
		return x.AzureAvailabilityZone
	}
	return ""
}

// Details of a proxy config stored in Azure Key Vault.
type AzureProxyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ARM ID the of the resource group containing proxy keyvault.
	//
	// Resource group ids are formatted as
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-name>`.
	ResourceGroupId string `protobuf:"bytes,1,opt,name=resource_group_id,json=resourceGroupId,proto3" json:"resource_group_id,omitempty"`
	// The URL the of the proxy setting secret with its version.
	//
	// The secret must be a JSON encoded proxy configuration
	// as described in
	// https://cloud.google.com/anthos/clusters/docs/multi-cloud/azure/how-to/use-a-proxy#create_a_proxy_configuration_file
	//
	// Secret ids are formatted as
	// `https://<key-vault-name>.vault.azure.net/secrets/<secret-name>/<secret-version>`.
	SecretId string `protobuf:"bytes,2,opt,name=secret_id,json=secretId,proto3" json:"secret_id,omitempty"`
}

func (x *AzureProxyConfig) Reset() {
	*x = AzureProxyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureProxyConfig) ProtoMessage() {}

func (x *AzureProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureProxyConfig.ProtoReflect.Descriptor instead.
func (*AzureProxyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{4}
}

func (x *AzureProxyConfig) GetResourceGroupId() string {
	if x != nil {
		return x.ResourceGroupId
	}
	return ""
}

func (x *AzureProxyConfig) GetSecretId() string {
	if x != nil {
		return x.SecretId
	}
	return ""
}

// Configuration related to application-layer secrets encryption.
//
// Anthos clusters on Azure encrypts your Kubernetes data at rest
// in etcd using Azure Key Vault.
type AzureDatabaseEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ARM ID of the Azure Key Vault key to encrypt / decrypt data.
	//
	// For example:
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.KeyVault/vaults/<key-vault-id>/keys/<key-name>`
	// Encryption will always take the latest version of the key and hence
	// specific version is not supported.
	KeyId string `protobuf:"bytes,3,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *AzureDatabaseEncryption) Reset() {
	*x = AzureDatabaseEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureDatabaseEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureDatabaseEncryption) ProtoMessage() {}

func (x *AzureDatabaseEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureDatabaseEncryption.ProtoReflect.Descriptor instead.
func (*AzureDatabaseEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{5}
}

func (x *AzureDatabaseEncryption) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// Configuration related to config data encryption.
//
// Azure VM bootstrap secret is envelope encrypted with the provided key vault
// key.
type AzureConfigEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ARM ID of the Azure Key Vault key to encrypt / decrypt config
	// data.
	//
	// For example:
	// `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.KeyVault/vaults/<key-vault-id>/keys/<key-name>`
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Optional. RSA key of the Azure Key Vault public key to use for encrypting
	// the data.
	//
	// This key must be formatted as a PEM-encoded SubjectPublicKeyInfo (RFC 5280)
	// in ASN.1 DER form. The string must be comprised of a single PEM block of
	// type "PUBLIC KEY".
	PublicKey string `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
}

func (x *AzureConfigEncryption) Reset() {
	*x = AzureConfigEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureConfigEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureConfigEncryption) ProtoMessage() {}

func (x *AzureConfigEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureConfigEncryption.ProtoReflect.Descriptor instead.
func (*AzureConfigEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AzureConfigEncryption) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *AzureConfigEncryption) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

// Configuration for Azure Disks.
type AzureDiskTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The size of the disk, in GiBs.
	//
	// When unspecified, a default value is provided. See the specific reference
	// in the parent resource.
	SizeGib int32 `protobuf:"varint,1,opt,name=size_gib,json=sizeGib,proto3" json:"size_gib,omitempty"`
}

func (x *AzureDiskTemplate) Reset() {
	*x = AzureDiskTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureDiskTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureDiskTemplate) ProtoMessage() {}

func (x *AzureDiskTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureDiskTemplate.ProtoReflect.Descriptor instead.
func (*AzureDiskTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{7}
}

func (x *AzureDiskTemplate) GetSizeGib() int32 {
	if x != nil {
		return x.SizeGib
	}
	return 0
}

// `AzureClient` resources hold client authentication information needed by the
// Anthos Multi-Cloud API to manage Azure resources on your Azure subscription.
//
// When an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] is
// created, an `AzureClient` resource needs to be provided and all operations on
// Azure resources associated to that cluster will authenticate to Azure
// services using the given client.
//
// `AzureClient` resources are immutable and cannot be modified upon creation.
//
// Each `AzureClient` resource is bound to a single Azure Active Directory
// Application and tenant.
type AzureClient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// `AzureClient` resource names are formatted as
	// `projects/<project-number>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Azure Active Directory Tenant ID.
	TenantId string `protobuf:"bytes,2,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// Required. The Azure Active Directory Application ID.
	ApplicationId string `protobuf:"bytes,3,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Output only. If set, there are currently pending changes to the client.
	Reconciling bool `protobuf:"varint,9,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Optional. Annotations on the resource.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Keys can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The PEM encoded x509 certificate.
	PemCertificate string `protobuf:"bytes,7,opt,name=pem_certificate,json=pemCertificate,proto3" json:"pem_certificate,omitempty"`
	// Output only. A globally unique identifier for the client.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time at which this resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this client was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AzureClient) Reset() {
	*x = AzureClient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClient) ProtoMessage() {}

func (x *AzureClient) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClient.ProtoReflect.Descriptor instead.
func (*AzureClient) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{8}
}

func (x *AzureClient) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureClient) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *AzureClient) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *AzureClient) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AzureClient) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AzureClient) GetPemCertificate() string {
	if x != nil {
		return x.PemCertificate
	}
	return ""
}

func (x *AzureClient) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AzureClient) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AzureClient) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration related to the cluster RBAC settings.
type AzureAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Users that can perform operations as a cluster admin. A managed
	// ClusterRoleBinding will be created to grant the `cluster-admin` ClusterRole
	// to the users. Up to ten admin users can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminUsers []*AzureClusterUser `protobuf:"bytes,1,rep,name=admin_users,json=adminUsers,proto3" json:"admin_users,omitempty"`
	// Optional. Groups of users that can perform operations as a cluster admin. A
	// managed ClusterRoleBinding will be created to grant the `cluster-admin`
	// ClusterRole to the groups. Up to ten admin groups can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminGroups []*AzureClusterGroup `protobuf:"bytes,2,rep,name=admin_groups,json=adminGroups,proto3" json:"admin_groups,omitempty"`
}

func (x *AzureAuthorization) Reset() {
	*x = AzureAuthorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureAuthorization) ProtoMessage() {}

func (x *AzureAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureAuthorization.ProtoReflect.Descriptor instead.
func (*AzureAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{9}
}

func (x *AzureAuthorization) GetAdminUsers() []*AzureClusterUser {
	if x != nil {
		return x.AdminUsers
	}
	return nil
}

func (x *AzureAuthorization) GetAdminGroups() []*AzureClusterGroup {
	if x != nil {
		return x.AdminGroups
	}
	return nil
}

// Authentication configuration for the management of Azure resources.
type AzureServicesAuthentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Azure Active Directory Tenant ID.
	TenantId string `protobuf:"bytes,1,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// Required. The Azure Active Directory Application ID.
	ApplicationId string `protobuf:"bytes,2,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
}

func (x *AzureServicesAuthentication) Reset() {
	*x = AzureServicesAuthentication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureServicesAuthentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureServicesAuthentication) ProtoMessage() {}

func (x *AzureServicesAuthentication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureServicesAuthentication.ProtoReflect.Descriptor instead.
func (*AzureServicesAuthentication) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{10}
}

func (x *AzureServicesAuthentication) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *AzureServicesAuthentication) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

// Identities of a user-type subject for Azure clusters.
type AzureClusterUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the user, e.g. `my-gcp-id@gmail.com`.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *AzureClusterUser) Reset() {
	*x = AzureClusterUser{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClusterUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClusterUser) ProtoMessage() {}

func (x *AzureClusterUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClusterUser.ProtoReflect.Descriptor instead.
func (*AzureClusterUser) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{11}
}

func (x *AzureClusterUser) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Identities of a group-type subject for Azure clusters.
type AzureClusterGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the group, e.g. `my-group@domain.com`.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *AzureClusterGroup) Reset() {
	*x = AzureClusterGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClusterGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClusterGroup) ProtoMessage() {}

func (x *AzureClusterGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClusterGroup.ProtoReflect.Descriptor instead.
func (*AzureClusterGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{12}
}

func (x *AzureClusterGroup) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// An Anthos node pool running on Azure.
type AzureNodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// Node pool names are formatted as
	// `projects/<project-number>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// For more details on Google Cloud resource names,
	// see [Resource Names](https://cloud.google.com/apis/design/resource_names)
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this
	// node pool.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Required. The node configuration of the node pool.
	Config *AzureNodeConfig `protobuf:"bytes,22,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The ARM ID of the subnet where the node pool VMs run. Make sure
	// it's a subnet under the virtual network in the cluster configuration.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Required. Autoscaler configuration for this node pool.
	Autoscaling *AzureNodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// Output only. The current state of the node pool.
	State AzureNodePool_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.gkemulticloud.v1.AzureNodePool_State" json:"state,omitempty"`
	// Output only. A globally unique identifier for the node pool.
	Uid string `protobuf:"bytes,8,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. If set, there are currently pending changes to the node
	// pool.
	Reconciling bool `protobuf:"varint,9,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The time at which this node pool was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this node pool was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	//
	// Can be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Annotations on the node pool.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Keys can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,21,opt,name=max_pods_constraint,json=maxPodsConstraint,proto3" json:"max_pods_constraint,omitempty"`
	// Optional. The Azure availability zone of the nodes in this nodepool.
	//
	// When unspecified, it defaults to `1`.
	AzureAvailabilityZone string `protobuf:"bytes,23,opt,name=azure_availability_zone,json=azureAvailabilityZone,proto3" json:"azure_availability_zone,omitempty"`
	// Output only. A set of errors found in the node pool.
	Errors []*AzureNodePoolError `protobuf:"bytes,29,rep,name=errors,proto3" json:"errors,omitempty"`
	// Optional. The Management configuration for this node pool.
	Management *AzureNodeManagement `protobuf:"bytes,30,opt,name=management,proto3" json:"management,omitempty"`
}

func (x *AzureNodePool) Reset() {
	*x = AzureNodePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureNodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureNodePool) ProtoMessage() {}

func (x *AzureNodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureNodePool.ProtoReflect.Descriptor instead.
func (*AzureNodePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{13}
}

func (x *AzureNodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureNodePool) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AzureNodePool) GetConfig() *AzureNodeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AzureNodePool) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *AzureNodePool) GetAutoscaling() *AzureNodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *AzureNodePool) GetState() AzureNodePool_State {
	if x != nil {
		return x.State
	}
	return AzureNodePool_STATE_UNSPECIFIED
}

func (x *AzureNodePool) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AzureNodePool) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AzureNodePool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AzureNodePool) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AzureNodePool) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AzureNodePool) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AzureNodePool) GetMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.MaxPodsConstraint
	}
	return nil
}

func (x *AzureNodePool) GetAzureAvailabilityZone() string {
	if x != nil {
		return x.AzureAvailabilityZone
	}
	return ""
}

func (x *AzureNodePool) GetErrors() []*AzureNodePoolError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *AzureNodePool) GetManagement() *AzureNodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

// AzureNodeManagement defines the set of node management features turned on for
// an Azure node pool.
type AzureNodeManagement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether or not the nodes will be automatically repaired. When set
	// to true, the nodes in this node pool will be monitored and if they fail
	// health checks consistently over a period of time, an automatic repair
	// action will be triggered to replace them with new nodes.
	AutoRepair bool `protobuf:"varint,1,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
}

func (x *AzureNodeManagement) Reset() {
	*x = AzureNodeManagement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureNodeManagement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureNodeManagement) ProtoMessage() {}

func (x *AzureNodeManagement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureNodeManagement.ProtoReflect.Descriptor instead.
func (*AzureNodeManagement) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{14}
}

func (x *AzureNodeManagement) GetAutoRepair() bool {
	if x != nil {
		return x.AutoRepair
	}
	return false
}

// Parameters that describe the configuration of all node machines
// on a given node pool.
type AzureNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Azure VM size name. Example: `Standard_DS2_v2`.
	//
	// See [Supported VM
	// sizes](/anthos/clusters/docs/azure/reference/supported-vms) for options.
	//
	// When unspecified, it defaults to `Standard_DS2_v2`.
	VmSize string `protobuf:"bytes,1,opt,name=vm_size,json=vmSize,proto3" json:"vm_size,omitempty"`
	// Optional. Configuration related to the root volume provisioned for each
	// node pool machine.
	//
	// When unspecified, it defaults to a 32-GiB Azure Disk.
	RootVolume *AzureDiskTemplate `protobuf:"bytes,2,opt,name=root_volume,json=rootVolume,proto3" json:"root_volume,omitempty"`
	// Optional. A set of tags to apply to all underlying Azure resources for this
	// node pool. This currently only includes Virtual Machine Scale Sets.
	//
	// Specify at most 50 pairs containing alphanumerics, spaces, and symbols
	// (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to
	// 255 Unicode characters.
	Tags map[string]string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The OS image type to use on node pool instances.
	// Can be unspecified, or have a value of `ubuntu`.
	//
	// When unspecified, it defaults to `ubuntu`.
	ImageType string `protobuf:"bytes,8,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// Required. SSH configuration for how to access the node pool machines.
	SshConfig *AzureSshConfig `protobuf:"bytes,7,opt,name=ssh_config,json=sshConfig,proto3" json:"ssh_config,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AzureProxyConfig `protobuf:"bytes,9,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
	// Optional. Configuration related to vm config encryption.
	ConfigEncryption *AzureConfigEncryption `protobuf:"bytes,12,opt,name=config_encryption,json=configEncryption,proto3" json:"config_encryption,omitempty"`
	// Optional. The initial taints assigned to nodes of this node pool.
	Taints []*NodeTaint `protobuf:"bytes,10,rep,name=taints,proto3" json:"taints,omitempty"`
	// Optional. The initial labels assigned to nodes of this node pool. An object
	// containing a list of "key": value pairs. Example: { "name": "wrench",
	// "mass": "1.3kg", "count": "3" }.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AzureNodeConfig) Reset() {
	*x = AzureNodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureNodeConfig) ProtoMessage() {}

func (x *AzureNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureNodeConfig.ProtoReflect.Descriptor instead.
func (*AzureNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{15}
}

func (x *AzureNodeConfig) GetVmSize() string {
	if x != nil {
		return x.VmSize
	}
	return ""
}

func (x *AzureNodeConfig) GetRootVolume() *AzureDiskTemplate {
	if x != nil {
		return x.RootVolume
	}
	return nil
}

func (x *AzureNodeConfig) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AzureNodeConfig) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *AzureNodeConfig) GetSshConfig() *AzureSshConfig {
	if x != nil {
		return x.SshConfig
	}
	return nil
}

func (x *AzureNodeConfig) GetProxyConfig() *AzureProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

func (x *AzureNodeConfig) GetConfigEncryption() *AzureConfigEncryption {
	if x != nil {
		return x.ConfigEncryption
	}
	return nil
}

func (x *AzureNodeConfig) GetTaints() []*NodeTaint {
	if x != nil {
		return x.Taints
	}
	return nil
}

func (x *AzureNodeConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Configuration related to Kubernetes cluster autoscaler.
//
// The Kubernetes cluster autoscaler will automatically adjust the
// size of the node pool based on the cluster load.
type AzureNodePoolAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum number of nodes in the node pool. Must be greater than or
	// equal to 1 and less than or equal to max_node_count.
	MinNodeCount int32 `protobuf:"varint,1,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Required. Maximum number of nodes in the node pool. Must be greater than or
	// equal to min_node_count and less than or equal to 50.
	MaxNodeCount int32 `protobuf:"varint,2,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
}

func (x *AzureNodePoolAutoscaling) Reset() {
	*x = AzureNodePoolAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureNodePoolAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureNodePoolAutoscaling) ProtoMessage() {}

func (x *AzureNodePoolAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureNodePoolAutoscaling.ProtoReflect.Descriptor instead.
func (*AzureNodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{16}
}

func (x *AzureNodePoolAutoscaling) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *AzureNodePoolAutoscaling) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

// AzureOpenIdConfig is an OIDC discovery document for the cluster.
// See the OpenID Connect Discovery 1.0 specification for details.
type AzureOpenIdConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OIDC Issuer.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// JSON Web Key uri.
	JwksUri string `protobuf:"bytes,2,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// Supported response types.
	ResponseTypesSupported []string `protobuf:"bytes,3,rep,name=response_types_supported,json=responseTypesSupported,proto3" json:"response_types_supported,omitempty"`
	// Supported subject types.
	SubjectTypesSupported []string `protobuf:"bytes,4,rep,name=subject_types_supported,json=subjectTypesSupported,proto3" json:"subject_types_supported,omitempty"`
	// supported ID Token signing Algorithms.
	IdTokenSigningAlgValuesSupported []string `protobuf:"bytes,5,rep,name=id_token_signing_alg_values_supported,json=idTokenSigningAlgValuesSupported,proto3" json:"id_token_signing_alg_values_supported,omitempty"`
	// Supported claims.
	ClaimsSupported []string `protobuf:"bytes,6,rep,name=claims_supported,json=claimsSupported,proto3" json:"claims_supported,omitempty"`
	// Supported grant types.
	GrantTypes []string `protobuf:"bytes,7,rep,name=grant_types,json=grantTypes,proto3" json:"grant_types,omitempty"`
}

func (x *AzureOpenIdConfig) Reset() {
	*x = AzureOpenIdConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureOpenIdConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureOpenIdConfig) ProtoMessage() {}

func (x *AzureOpenIdConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureOpenIdConfig.ProtoReflect.Descriptor instead.
func (*AzureOpenIdConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{17}
}

func (x *AzureOpenIdConfig) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *AzureOpenIdConfig) GetJwksUri() string {
	if x != nil {
		return x.JwksUri
	}
	return ""
}

func (x *AzureOpenIdConfig) GetResponseTypesSupported() []string {
	if x != nil {
		return x.ResponseTypesSupported
	}
	return nil
}

func (x *AzureOpenIdConfig) GetSubjectTypesSupported() []string {
	if x != nil {
		return x.SubjectTypesSupported
	}
	return nil
}

func (x *AzureOpenIdConfig) GetIdTokenSigningAlgValuesSupported() []string {
	if x != nil {
		return x.IdTokenSigningAlgValuesSupported
	}
	return nil
}

func (x *AzureOpenIdConfig) GetClaimsSupported() []string {
	if x != nil {
		return x.ClaimsSupported
	}
	return nil
}

func (x *AzureOpenIdConfig) GetGrantTypes() []string {
	if x != nil {
		return x.GrantTypes
	}
	return nil
}

// AzureJsonWebKeys is a valid JSON Web Key Set as specififed in RFC 7517.
type AzureJsonWebKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public component of the keys used by the cluster to sign token
	// requests.
	Keys []*Jwk `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *AzureJsonWebKeys) Reset() {
	*x = AzureJsonWebKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureJsonWebKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureJsonWebKeys) ProtoMessage() {}

func (x *AzureJsonWebKeys) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureJsonWebKeys.ProtoReflect.Descriptor instead.
func (*AzureJsonWebKeys) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{18}
}

func (x *AzureJsonWebKeys) GetKeys() []*Jwk {
	if x != nil {
		return x.Keys
	}
	return nil
}

// AzureServerConfig contains information about a Google Cloud location, such as
// supported Azure regions and Kubernetes versions.
type AzureServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `AzureServerConfig` resource name.
	//
	// `AzureServerConfig` names are formatted as
	// `projects/<project-number>/locations/<region>/azureServerConfig`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// List of all released Kubernetes versions, including ones which are end of
	// life and can no longer be used.  Filter by the `enabled`
	// property to limit to currently available versions.
	// Valid versions supported for both create and update operations
	ValidVersions []*AzureK8SVersionInfo `protobuf:"bytes,2,rep,name=valid_versions,json=validVersions,proto3" json:"valid_versions,omitempty"`
	// The list of supported Azure regions.
	SupportedAzureRegions []string `protobuf:"bytes,3,rep,name=supported_azure_regions,json=supportedAzureRegions,proto3" json:"supported_azure_regions,omitempty"`
}

func (x *AzureServerConfig) Reset() {
	*x = AzureServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureServerConfig) ProtoMessage() {}

func (x *AzureServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureServerConfig.ProtoReflect.Descriptor instead.
func (*AzureServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{19}
}

func (x *AzureServerConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureServerConfig) GetValidVersions() []*AzureK8SVersionInfo {
	if x != nil {
		return x.ValidVersions
	}
	return nil
}

func (x *AzureServerConfig) GetSupportedAzureRegions() []string {
	if x != nil {
		return x.SupportedAzureRegions
	}
	return nil
}

// Kubernetes version information of GKE cluster on Azure.
type AzureK8SVersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes version name (for example, `1.19.10-gke.1000`)
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. True if the version is available for cluster creation. If a
	// version is enabled for creation, it can be used to create new clusters.
	// Otherwise, cluster creation will fail. However, cluster upgrade operations
	// may succeed, even if the version is not enabled.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. True if this cluster version belongs to a minor version that has
	// reached its end of life and is no longer in scope to receive security and
	// bug fixes.
	EndOfLife bool `protobuf:"varint,4,opt,name=end_of_life,json=endOfLife,proto3" json:"end_of_life,omitempty"`
	// Optional. The estimated date (in Pacific Time) when this cluster version
	// will reach its end of life. Or if this version is no longer supported (the
	// `end_of_life` field is true), this is the actual date (in Pacific time)
	// when the version reached its end of life.
	EndOfLifeDate *date.Date `protobuf:"bytes,5,opt,name=end_of_life_date,json=endOfLifeDate,proto3" json:"end_of_life_date,omitempty"`
	// Optional. The date (in Pacific Time) when the cluster version was released.
	ReleaseDate *date.Date `protobuf:"bytes,6,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
}

func (x *AzureK8SVersionInfo) Reset() {
	*x = AzureK8SVersionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureK8SVersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureK8SVersionInfo) ProtoMessage() {}

func (x *AzureK8SVersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureK8SVersionInfo.ProtoReflect.Descriptor instead.
func (*AzureK8SVersionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{20}
}

func (x *AzureK8SVersionInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AzureK8SVersionInfo) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AzureK8SVersionInfo) GetEndOfLife() bool {
	if x != nil {
		return x.EndOfLife
	}
	return false
}

func (x *AzureK8SVersionInfo) GetEndOfLifeDate() *date.Date {
	if x != nil {
		return x.EndOfLifeDate
	}
	return nil
}

func (x *AzureK8SVersionInfo) GetReleaseDate() *date.Date {
	if x != nil {
		return x.ReleaseDate
	}
	return nil
}

// SSH configuration for Azure resources.
type AzureSshConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SSH public key data for VMs managed by Anthos. This accepts
	// the authorized_keys file format used in OpenSSH according to the sshd(8)
	// manual page.
	AuthorizedKey string `protobuf:"bytes,1,opt,name=authorized_key,json=authorizedKey,proto3" json:"authorized_key,omitempty"`
}

func (x *AzureSshConfig) Reset() {
	*x = AzureSshConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureSshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSshConfig) ProtoMessage() {}

func (x *AzureSshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSshConfig.ProtoReflect.Descriptor instead.
func (*AzureSshConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{21}
}

func (x *AzureSshConfig) GetAuthorizedKey() string {
	if x != nil {
		return x.AuthorizedKey
	}
	return ""
}

// Managed Azure resources for the cluster.
//
// The values could change and be empty, depending on the state of the cluster.
type AzureClusterResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ARM ID of the cluster network security group.
	NetworkSecurityGroupId string `protobuf:"bytes,1,opt,name=network_security_group_id,json=networkSecurityGroupId,proto3" json:"network_security_group_id,omitempty"`
	// Output only. The ARM ID of the control plane application security group.
	ControlPlaneApplicationSecurityGroupId string `protobuf:"bytes,2,opt,name=control_plane_application_security_group_id,json=controlPlaneApplicationSecurityGroupId,proto3" json:"control_plane_application_security_group_id,omitempty"`
}

func (x *AzureClusterResources) Reset() {
	*x = AzureClusterResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClusterResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClusterResources) ProtoMessage() {}

func (x *AzureClusterResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClusterResources.ProtoReflect.Descriptor instead.
func (*AzureClusterResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{22}
}

func (x *AzureClusterResources) GetNetworkSecurityGroupId() string {
	if x != nil {
		return x.NetworkSecurityGroupId
	}
	return ""
}

func (x *AzureClusterResources) GetControlPlaneApplicationSecurityGroupId() string {
	if x != nil {
		return x.ControlPlaneApplicationSecurityGroupId
	}
	return ""
}

// AzureClusterError describes errors found on Azure clusters.
type AzureClusterError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-friendly description of the error.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AzureClusterError) Reset() {
	*x = AzureClusterError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureClusterError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureClusterError) ProtoMessage() {}

func (x *AzureClusterError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureClusterError.ProtoReflect.Descriptor instead.
func (*AzureClusterError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{23}
}

func (x *AzureClusterError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// AzureNodePoolError describes errors found on Azure node pools.
type AzureNodePoolError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-friendly description of the error.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AzureNodePoolError) Reset() {
	*x = AzureNodePoolError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureNodePoolError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureNodePoolError) ProtoMessage() {}

func (x *AzureNodePoolError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureNodePoolError.ProtoReflect.Descriptor instead.
func (*AzureNodePoolError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP(), []int{24}
}

func (x *AzureNodePoolError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_azure_resources_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xa4, 0x0f, 0x0a, 0x0c, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50,
	0x6c, 0x61, 0x6e, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x1d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25,
	0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x63, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x74, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x12, 0x66, 0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x0e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e,
	0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50,
	0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x3a,
	0x75, 0xea, 0x41, 0x72, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0x96, 0x02, 0x0a, 0x16, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x12, 0x31, 0x0a, 0x12, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x17, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x70, 0x6f, 0x64, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73,
	0x12, 0x42, 0x0a, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x12, 0x49, 0x0a, 0x1f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x22,
	0xca, 0x07, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x50, 0x6c, 0x61, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76, 0x6d,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x73,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x73,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12,
	0x56, 0x0a, 0x0b, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x69,
	0x6e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66,
	0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x63, 0x0a, 0x12, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x31, 0x0a, 0x12, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x49, 0x64, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x71, 0x0a, 0x10,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x49, 0x64, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x41,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5a, 0x6f, 0x6e, 0x65, 0x22,
	0x5b, 0x0a, 0x10, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x49, 0x64, 0x22, 0x35, 0x0a, 0x17,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6b, 0x65,
	0x79, 0x49, 0x64, 0x22, 0x57, 0x0a, 0x15, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x06,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0x33, 0x0a, 0x11,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x69,
	0x62, 0x22, 0xf7, 0x04, 0x0a, 0x0b, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x62, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c,
	0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x65,
	0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a, 0x28, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xc5, 0x01, 0x0a, 0x12,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x22, 0x6b, 0x0a, 0x1b, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x33, 0x0a, 0x10, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2e, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x19, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xbb, 0x0a, 0x0a, 0x0d, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x0b, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x64,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x6f, 0x64,
	0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x15, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x57, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x98, 0x01, 0xea, 0x41, 0x94, 0x01, 0x0a,
	0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x66, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x7d, 0x22, 0x3b, 0x0a, 0x13, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72,
	0x22, 0xa6, 0x06, 0x0a, 0x0f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76, 0x6d, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x72, 0x6f, 0x6f, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x22, 0x0a,
	0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x51, 0x0a, 0x0a, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a,
	0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x70, 0x0a, 0x18, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d,
	0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd5, 0x02, 0x0a, 0x11,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x77, 0x6b,
	0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x77, 0x6b,
	0x73, 0x55, 0x72, 0x69, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x36,
	0x0a, 0x17, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x15, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x25, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x22, 0x4a, 0x0a, 0x10, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4a, 0x73, 0x6f, 0x6e,
	0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x36, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x77, 0x6b, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22,
	0xaa, 0x02, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x6e, 0xea, 0x41,
	0x6b, 0x0a, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xef, 0x01, 0x0a,
	0x13, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x23, 0x0a,
	0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69,
	0x66, 0x65, 0x12, 0x3f, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69, 0x66, 0x65, 0x44,
	0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x44, 0x61, 0x74, 0x65, 0x22, 0x3c,
	0x0a, 0x0e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x22, 0xb9, 0x01, 0x0a,
	0x15, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x19, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x2b, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x26, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x22, 0x2d, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x2e, 0x0a, 0x12, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0xe6, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x1d,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47,
	0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescData = file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_cloud_gkemulticloud_v1_azure_resources_proto_goTypes = []interface{}{
	(AzureCluster_State)(0),             // 0: google.cloud.gkemulticloud.v1.AzureCluster.State
	(AzureNodePool_State)(0),            // 1: google.cloud.gkemulticloud.v1.AzureNodePool.State
	(*AzureCluster)(nil),                // 2: google.cloud.gkemulticloud.v1.AzureCluster
	(*AzureClusterNetworking)(nil),      // 3: google.cloud.gkemulticloud.v1.AzureClusterNetworking
	(*AzureControlPlane)(nil),           // 4: google.cloud.gkemulticloud.v1.AzureControlPlane
	(*ReplicaPlacement)(nil),            // 5: google.cloud.gkemulticloud.v1.ReplicaPlacement
	(*AzureProxyConfig)(nil),            // 6: google.cloud.gkemulticloud.v1.AzureProxyConfig
	(*AzureDatabaseEncryption)(nil),     // 7: google.cloud.gkemulticloud.v1.AzureDatabaseEncryption
	(*AzureConfigEncryption)(nil),       // 8: google.cloud.gkemulticloud.v1.AzureConfigEncryption
	(*AzureDiskTemplate)(nil),           // 9: google.cloud.gkemulticloud.v1.AzureDiskTemplate
	(*AzureClient)(nil),                 // 10: google.cloud.gkemulticloud.v1.AzureClient
	(*AzureAuthorization)(nil),          // 11: google.cloud.gkemulticloud.v1.AzureAuthorization
	(*AzureServicesAuthentication)(nil), // 12: google.cloud.gkemulticloud.v1.AzureServicesAuthentication
	(*AzureClusterUser)(nil),            // 13: google.cloud.gkemulticloud.v1.AzureClusterUser
	(*AzureClusterGroup)(nil),           // 14: google.cloud.gkemulticloud.v1.AzureClusterGroup
	(*AzureNodePool)(nil),               // 15: google.cloud.gkemulticloud.v1.AzureNodePool
	(*AzureNodeManagement)(nil),         // 16: google.cloud.gkemulticloud.v1.AzureNodeManagement
	(*AzureNodeConfig)(nil),             // 17: google.cloud.gkemulticloud.v1.AzureNodeConfig
	(*AzureNodePoolAutoscaling)(nil),    // 18: google.cloud.gkemulticloud.v1.AzureNodePoolAutoscaling
	(*AzureOpenIdConfig)(nil),           // 19: google.cloud.gkemulticloud.v1.AzureOpenIdConfig
	(*AzureJsonWebKeys)(nil),            // 20: google.cloud.gkemulticloud.v1.AzureJsonWebKeys
	(*AzureServerConfig)(nil),           // 21: google.cloud.gkemulticloud.v1.AzureServerConfig
	(*AzureK8SVersionInfo)(nil),         // 22: google.cloud.gkemulticloud.v1.AzureK8sVersionInfo
	(*AzureSshConfig)(nil),              // 23: google.cloud.gkemulticloud.v1.AzureSshConfig
	(*AzureClusterResources)(nil),       // 24: google.cloud.gkemulticloud.v1.AzureClusterResources
	(*AzureClusterError)(nil),           // 25: google.cloud.gkemulticloud.v1.AzureClusterError
	(*AzureNodePoolError)(nil),          // 26: google.cloud.gkemulticloud.v1.AzureNodePoolError
	nil,                                 // 27: google.cloud.gkemulticloud.v1.AzureCluster.AnnotationsEntry
	nil,                                 // 28: google.cloud.gkemulticloud.v1.AzureControlPlane.TagsEntry
	nil,                                 // 29: google.cloud.gkemulticloud.v1.AzureClient.AnnotationsEntry
	nil,                                 // 30: google.cloud.gkemulticloud.v1.AzureNodePool.AnnotationsEntry
	nil,                                 // 31: google.cloud.gkemulticloud.v1.AzureNodeConfig.TagsEntry
	nil,                                 // 32: google.cloud.gkemulticloud.v1.AzureNodeConfig.LabelsEntry
	(*timestamppb.Timestamp)(nil),       // 33: google.protobuf.Timestamp
	(*WorkloadIdentityConfig)(nil),      // 34: google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	(*Fleet)(nil),                       // 35: google.cloud.gkemulticloud.v1.Fleet
	(*LoggingConfig)(nil),               // 36: google.cloud.gkemulticloud.v1.LoggingConfig
	(*MonitoringConfig)(nil),            // 37: google.cloud.gkemulticloud.v1.MonitoringConfig
	(*MaxPodsConstraint)(nil),           // 38: google.cloud.gkemulticloud.v1.MaxPodsConstraint
	(*NodeTaint)(nil),                   // 39: google.cloud.gkemulticloud.v1.NodeTaint
	(*Jwk)(nil),                         // 40: google.cloud.gkemulticloud.v1.Jwk
	(*date.Date)(nil),                   // 41: google.type.Date
}
var file_google_cloud_gkemulticloud_v1_azure_resources_proto_depIdxs = []int32{
	3,  // 0: google.cloud.gkemulticloud.v1.AzureCluster.networking:type_name -> google.cloud.gkemulticloud.v1.AzureClusterNetworking
	4,  // 1: google.cloud.gkemulticloud.v1.AzureCluster.control_plane:type_name -> google.cloud.gkemulticloud.v1.AzureControlPlane
	11, // 2: google.cloud.gkemulticloud.v1.AzureCluster.authorization:type_name -> google.cloud.gkemulticloud.v1.AzureAuthorization
	12, // 3: google.cloud.gkemulticloud.v1.AzureCluster.azure_services_authentication:type_name -> google.cloud.gkemulticloud.v1.AzureServicesAuthentication
	0,  // 4: google.cloud.gkemulticloud.v1.AzureCluster.state:type_name -> google.cloud.gkemulticloud.v1.AzureCluster.State
	33, // 5: google.cloud.gkemulticloud.v1.AzureCluster.create_time:type_name -> google.protobuf.Timestamp
	33, // 6: google.cloud.gkemulticloud.v1.AzureCluster.update_time:type_name -> google.protobuf.Timestamp
	27, // 7: google.cloud.gkemulticloud.v1.AzureCluster.annotations:type_name -> google.cloud.gkemulticloud.v1.AzureCluster.AnnotationsEntry
	34, // 8: google.cloud.gkemulticloud.v1.AzureCluster.workload_identity_config:type_name -> google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	35, // 9: google.cloud.gkemulticloud.v1.AzureCluster.fleet:type_name -> google.cloud.gkemulticloud.v1.Fleet
	24, // 10: google.cloud.gkemulticloud.v1.AzureCluster.managed_resources:type_name -> google.cloud.gkemulticloud.v1.AzureClusterResources
	36, // 11: google.cloud.gkemulticloud.v1.AzureCluster.logging_config:type_name -> google.cloud.gkemulticloud.v1.LoggingConfig
	25, // 12: google.cloud.gkemulticloud.v1.AzureCluster.errors:type_name -> google.cloud.gkemulticloud.v1.AzureClusterError
	37, // 13: google.cloud.gkemulticloud.v1.AzureCluster.monitoring_config:type_name -> google.cloud.gkemulticloud.v1.MonitoringConfig
	23, // 14: google.cloud.gkemulticloud.v1.AzureControlPlane.ssh_config:type_name -> google.cloud.gkemulticloud.v1.AzureSshConfig
	9,  // 15: google.cloud.gkemulticloud.v1.AzureControlPlane.root_volume:type_name -> google.cloud.gkemulticloud.v1.AzureDiskTemplate
	9,  // 16: google.cloud.gkemulticloud.v1.AzureControlPlane.main_volume:type_name -> google.cloud.gkemulticloud.v1.AzureDiskTemplate
	7,  // 17: google.cloud.gkemulticloud.v1.AzureControlPlane.database_encryption:type_name -> google.cloud.gkemulticloud.v1.AzureDatabaseEncryption
	6,  // 18: google.cloud.gkemulticloud.v1.AzureControlPlane.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AzureProxyConfig
	8,  // 19: google.cloud.gkemulticloud.v1.AzureControlPlane.config_encryption:type_name -> google.cloud.gkemulticloud.v1.AzureConfigEncryption
	28, // 20: google.cloud.gkemulticloud.v1.AzureControlPlane.tags:type_name -> google.cloud.gkemulticloud.v1.AzureControlPlane.TagsEntry
	5,  // 21: google.cloud.gkemulticloud.v1.AzureControlPlane.replica_placements:type_name -> google.cloud.gkemulticloud.v1.ReplicaPlacement
	29, // 22: google.cloud.gkemulticloud.v1.AzureClient.annotations:type_name -> google.cloud.gkemulticloud.v1.AzureClient.AnnotationsEntry
	33, // 23: google.cloud.gkemulticloud.v1.AzureClient.create_time:type_name -> google.protobuf.Timestamp
	33, // 24: google.cloud.gkemulticloud.v1.AzureClient.update_time:type_name -> google.protobuf.Timestamp
	13, // 25: google.cloud.gkemulticloud.v1.AzureAuthorization.admin_users:type_name -> google.cloud.gkemulticloud.v1.AzureClusterUser
	14, // 26: google.cloud.gkemulticloud.v1.AzureAuthorization.admin_groups:type_name -> google.cloud.gkemulticloud.v1.AzureClusterGroup
	17, // 27: google.cloud.gkemulticloud.v1.AzureNodePool.config:type_name -> google.cloud.gkemulticloud.v1.AzureNodeConfig
	18, // 28: google.cloud.gkemulticloud.v1.AzureNodePool.autoscaling:type_name -> google.cloud.gkemulticloud.v1.AzureNodePoolAutoscaling
	1,  // 29: google.cloud.gkemulticloud.v1.AzureNodePool.state:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool.State
	33, // 30: google.cloud.gkemulticloud.v1.AzureNodePool.create_time:type_name -> google.protobuf.Timestamp
	33, // 31: google.cloud.gkemulticloud.v1.AzureNodePool.update_time:type_name -> google.protobuf.Timestamp
	30, // 32: google.cloud.gkemulticloud.v1.AzureNodePool.annotations:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool.AnnotationsEntry
	38, // 33: google.cloud.gkemulticloud.v1.AzureNodePool.max_pods_constraint:type_name -> google.cloud.gkemulticloud.v1.MaxPodsConstraint
	26, // 34: google.cloud.gkemulticloud.v1.AzureNodePool.errors:type_name -> google.cloud.gkemulticloud.v1.AzureNodePoolError
	16, // 35: google.cloud.gkemulticloud.v1.AzureNodePool.management:type_name -> google.cloud.gkemulticloud.v1.AzureNodeManagement
	9,  // 36: google.cloud.gkemulticloud.v1.AzureNodeConfig.root_volume:type_name -> google.cloud.gkemulticloud.v1.AzureDiskTemplate
	31, // 37: google.cloud.gkemulticloud.v1.AzureNodeConfig.tags:type_name -> google.cloud.gkemulticloud.v1.AzureNodeConfig.TagsEntry
	23, // 38: google.cloud.gkemulticloud.v1.AzureNodeConfig.ssh_config:type_name -> google.cloud.gkemulticloud.v1.AzureSshConfig
	6,  // 39: google.cloud.gkemulticloud.v1.AzureNodeConfig.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AzureProxyConfig
	8,  // 40: google.cloud.gkemulticloud.v1.AzureNodeConfig.config_encryption:type_name -> google.cloud.gkemulticloud.v1.AzureConfigEncryption
	39, // 41: google.cloud.gkemulticloud.v1.AzureNodeConfig.taints:type_name -> google.cloud.gkemulticloud.v1.NodeTaint
	32, // 42: google.cloud.gkemulticloud.v1.AzureNodeConfig.labels:type_name -> google.cloud.gkemulticloud.v1.AzureNodeConfig.LabelsEntry
	40, // 43: google.cloud.gkemulticloud.v1.AzureJsonWebKeys.keys:type_name -> google.cloud.gkemulticloud.v1.Jwk
	22, // 44: google.cloud.gkemulticloud.v1.AzureServerConfig.valid_versions:type_name -> google.cloud.gkemulticloud.v1.AzureK8sVersionInfo
	41, // 45: google.cloud.gkemulticloud.v1.AzureK8sVersionInfo.end_of_life_date:type_name -> google.type.Date
	41, // 46: google.cloud.gkemulticloud.v1.AzureK8sVersionInfo.release_date:type_name -> google.type.Date
	47, // [47:47] is the sub-list for method output_type
	47, // [47:47] is the sub-list for method input_type
	47, // [47:47] is the sub-list for extension type_name
	47, // [47:47] is the sub-list for extension extendee
	0,  // [0:47] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_azure_resources_proto_init() }
func file_google_cloud_gkemulticloud_v1_azure_resources_proto_init() {
	if File_google_cloud_gkemulticloud_v1_azure_resources_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClusterNetworking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureControlPlane); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicaPlacement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureProxyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureDatabaseEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureConfigEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureDiskTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureAuthorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureServicesAuthentication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClusterUser); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClusterGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureNodePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureNodeManagement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureNodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureNodePoolAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureOpenIdConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureJsonWebKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureK8SVersionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureSshConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClusterResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureClusterError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureNodePoolError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_azure_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_azure_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkemulticloud_v1_azure_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_azure_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_azure_resources_proto = out.File
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_depIdxs = nil
}
