/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.community;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonInfoRegistry;
import org.openhab.core.addon.AddonService;
import org.openhab.core.addon.AddonType;
import org.openhab.core.addon.marketplace.AbstractRemoteAddonService;
import org.openhab.core.addon.marketplace.BundleVersion;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.internal.community.model.DiscourseCategoryResponseDTO;
import org.openhab.core.addon.marketplace.internal.community.model.DiscourseTopicResponseDTO;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.storage.StorageService;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.marketplace"}, property={"service.pid=org.openhab.marketplace"}, service={AddonService.class})
@ConfigurableService(category="system", label="Community Marketplace", description_uri="system:marketplace")
@NonNullByDefault
public class CommunityMarketplaceAddonService
extends AbstractRemoteAddonService {
    public static final String CODE_CONTENT_SUFFIX = "_content";
    public static final String JSON_CONTENT_PROPERTY = "json_content";
    public static final String YAML_CONTENT_PROPERTY = "yaml_content";
    static final String SERVICE_NAME = "Community Marketplace";
    static final String SERVICE_PID = "org.openhab.marketplace";
    static final String CONFIG_URI = "system:marketplace";
    static final String CONFIG_API_KEY = "apiKey";
    static final String CONFIG_SHOW_UNPUBLISHED_ENTRIES_KEY = "showUnpublished";
    static final String CONFIG_ENABLED_KEY = "enable";
    private static final String COMMUNITY_BASE_URL = "https://community.openhab.org";
    private static final String COMMUNITY_MARKETPLACE_URL = "https://community.openhab.org/c/marketplace/69/l/latest";
    private static final String COMMUNITY_TOPIC_URL = "https://community.openhab.org/t/";
    private static final Pattern BUNDLE_NAME_PATTERN = Pattern.compile(".*/(.*?)-\\d+\\.\\d+\\.\\d+.*");
    private static final String SERVICE_ID = "marketplace";
    private static final String ADDON_ID_PREFIX = "marketplace:";
    private static final Pattern CODE_MARKUP_PATTERN = Pattern.compile("<pre(?: data-code-wrap=\"[a-z]+\")?><code class=\"lang-(?<lang>[a-z]+)\">(?<content>.*?)</code></pre>", 32);
    private static final Integer BUNDLES_CATEGORY = 73;
    private static final Integer RULETEMPLATES_CATEGORY = 74;
    private static final Integer UIWIDGETS_CATEGORY = 75;
    private static final Integer BLOCKLIBRARIES_CATEGORY = 76;
    private static final Integer TRANSFORMATIONS_CATEGORY = 80;
    private static final String PUBLISHED_TAG = "published";
    private final Logger logger = LoggerFactory.getLogger(CommunityMarketplaceAddonService.class);
    private @Nullable String apiKey = null;
    private boolean showUnpublished = false;
    private boolean enabled = true;

    @Activate
    public CommunityMarketplaceAddonService(@Reference EventPublisher eventPublisher, @Reference ConfigurationAdmin configurationAdmin, @Reference StorageService storageService, @Reference AddonInfoRegistry addonInfoRegistry, Map<String, Object> config) {
        super(eventPublisher, configurationAdmin, storageService, addonInfoRegistry, SERVICE_PID);
        this.modified(config);
    }

    @Modified
    public void modified(@Nullable Map<String, Object> config) {
        if (config != null) {
            this.apiKey = (String)config.get(CONFIG_API_KEY);
            this.showUnpublished = (Boolean)ConfigParser.valueAsOrElse((Object)config.get(CONFIG_SHOW_UNPUBLISHED_ENTRIES_KEY), Boolean.class, (Object)false);
            this.enabled = (Boolean)ConfigParser.valueAsOrElse((Object)config.get(CONFIG_ENABLED_KEY), Boolean.class, (Object)true);
            this.cachedRemoteAddons.invalidateValue();
            this.refreshSource();
        }
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void addAddonHandler(MarketplaceAddonHandler handler) {
        this.addonHandlers.add(handler);
    }

    @Override
    protected void removeAddonHandler(MarketplaceAddonHandler handler) {
        this.addonHandlers.remove(handler);
    }

    public String getId() {
        return SERVICE_ID;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    protected List<Addon> getRemoteAddons() {
        if (!this.enabled) {
            return List.of();
        }
        ArrayList<Addon> addons = new ArrayList<Addon>();
        try {
            ArrayList<DiscourseCategoryResponseDTO> pages = new ArrayList<DiscourseCategoryResponseDTO>();
            URL url = URI.create(COMMUNITY_MARKETPLACE_URL).toURL();
            int pageNb = 1;
            while (url != null) {
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("Accept", "application/json");
                if (this.apiKey != null) {
                    connection.addRequestProperty("Api-Key", this.apiKey);
                }
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                    DiscourseCategoryResponseDTO parsed = (DiscourseCategoryResponseDTO)this.gson.fromJson((Reader)reader, DiscourseCategoryResponseDTO.class);
                    if (parsed.topicList.topics.length != 0) {
                        pages.add(parsed);
                    }
                    if (parsed.topicList.moreTopicsUrl != null) {
                        url = URI.create("https://community.openhab.org/c/marketplace/69/l/latest?page=" + pageNb++).toURL();
                        continue;
                    }
                    url = null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            List users = pages.stream().flatMap(p -> Stream.of(p.users)).toList();
            pages.stream().flatMap(p -> Stream.of(p.topicList.topics)).filter(t -> this.showUnpublished || t.tags != null && Arrays.stream(t.tags).anyMatch(tag -> PUBLISHED_TAG.equals(tag.name))).map(t -> Optional.ofNullable(this.convertTopicItemToAddon((DiscourseCategoryResponseDTO.DiscourseTopicItem)t, users))).forEach(a -> a.ifPresent(addons::add));
        }
        catch (Exception e) {
            this.logger.warn("Unable to retrieve marketplace add-ons: {}", (Object)e.getMessage());
        }
        return addons;
    }

    public @Nullable Addon getAddon(String uid, @Nullable Locale locale) {
        Object queryId;
        Object object = queryId = uid.startsWith(ADDON_ID_PREFIX) ? uid : ADDON_ID_PREFIX + uid;
        if (this.installedAddonIds.contains(queryId)) {
            return this.cachedAddons.stream().filter(arg_0 -> CommunityMarketplaceAddonService.lambda$7((String)queryId, arg_0)).findAny().orElse(null);
        }
        if (!this.remoteEnabled()) {
            return null;
        }
        try {
            URL url = URI.create(COMMUNITY_TOPIC_URL + uid.replace(ADDON_ID_PREFIX, "")).toURL();
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("Accept", "application/json");
            if (this.apiKey != null) {
                connection.addRequestProperty("Api-Key", this.apiKey);
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                DiscourseTopicResponseDTO parsed = (DiscourseTopicResponseDTO)this.gson.fromJson((Reader)reader, DiscourseTopicResponseDTO.class);
                return this.convertTopicToAddon(parsed);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public @Nullable String getAddonId(URI addonURI) {
        if (addonURI.toString().startsWith(COMMUNITY_TOPIC_URL)) {
            return addonURI.toString().substring(0, addonURI.toString().indexOf("/", COMMUNITY_BASE_URL.length()));
        }
        return null;
    }

    private @Nullable AddonType getAddonType(@Nullable Integer category, List<String> tags) {
        if (TRANSFORMATIONS_CATEGORY.equals(category)) {
            return AddonType.TRANSFORMATION;
        }
        if (RULETEMPLATES_CATEGORY.equals(category)) {
            return AddonType.AUTOMATION;
        }
        if (UIWIDGETS_CATEGORY.equals(category)) {
            return AddonType.UI;
        }
        if (BLOCKLIBRARIES_CATEGORY.equals(category)) {
            return AddonType.AUTOMATION;
        }
        if (BUNDLES_CATEGORY.equals(category)) {
            return AddonType.DEFAULT_TYPES.stream().filter(type -> tags.contains(type.getId())).findFirst().orElse(null);
        }
        return null;
    }

    private String getContentType(@Nullable Integer category, List<String> tags) {
        if (TRANSFORMATIONS_CATEGORY.equals(category)) {
            return "application/vnd.openhab.transformation";
        }
        if (RULETEMPLATES_CATEGORY.equals(category)) {
            return "application/vnd.openhab.ruletemplate";
        }
        if (UIWIDGETS_CATEGORY.equals(category)) {
            return "application/vnd.openhab.uicomponent;type=widget";
        }
        if (BLOCKLIBRARIES_CATEGORY.equals(category)) {
            return "application/vnd.openhab.uicomponent;type=blocks";
        }
        if (BUNDLES_CATEGORY.equals(category)) {
            if (tags.contains("kar")) {
                return "application/vnd.openhab.feature;type=karfile";
            }
            return "application/vnd.openhab.bundle";
        }
        return "";
    }

    private @Nullable Addon convertTopicItemToAddon(DiscourseCategoryResponseDTO.DiscourseTopicItem topic, List<DiscourseCategoryResponseDTO.DiscourseUser> users) {
        AddonType addonType;
        String uid;
        List<String> tags;
        block10: {
            tags = topic.tags == null ? List.of() : Arrays.stream(topic.tags).map(t -> t.name).toList();
            uid = ADDON_ID_PREFIX + topic.id.toString();
            addonType = this.getAddonType(topic.categoryId, tags);
            if (addonType != null) break block10;
            this.logger.debug("Ignoring topic '{}' because no add-on type could be found", (Object)topic.id);
            return null;
        }
        try {
            String type = addonType.getId();
            String id = topic.id.toString();
            String contentType = this.getContentType(topic.categoryId, tags);
            String title = topic.title;
            boolean compatible = true;
            int compatibilityStart = topic.title.lastIndexOf("[");
            if (topic.title.lastIndexOf(" ") < compatibilityStart) {
                String potentialRange = topic.title.substring(compatibilityStart);
                Matcher matcher = BundleVersion.RANGE_PATTERN.matcher(potentialRange);
                if (matcher.matches()) {
                    try {
                        compatible = this.coreVersion.inRange(potentialRange);
                        title = topic.title.substring(0, compatibilityStart).trim();
                        this.logger.debug("{} is {}compatible with core version {}", new Object[]{topic.title, compatible ? "" : "NOT ", this.coreVersion});
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.debug("Failed to determine compatibility for addon {}: {}", (Object)topic.title, (Object)e.getMessage());
                        compatible = true;
                    }
                } else {
                    this.logger.debug("Range pattern does not match '{}'", (Object)potentialRange);
                }
            }
            String link = COMMUNITY_TOPIC_URL + topic.id.toString();
            int likeCount = topic.likeCount;
            int views = topic.views;
            int postsCount = topic.postsCount;
            Date createdDate = topic.createdAt;
            String author = "";
            DiscourseCategoryResponseDTO.DiscoursePosterInfo[] discoursePosterInfoArray = topic.posters;
            int n = topic.posters.length;
            int n2 = 0;
            while (n2 < n) {
                DiscourseCategoryResponseDTO.DiscoursePosterInfo posterInfo = discoursePosterInfoArray[n2];
                if (posterInfo.description.contains("Original Poster")) {
                    author = users.stream().filter((Predicate<DiscourseCategoryResponseDTO.DiscourseUser>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$10(org.openhab.core.addon.marketplace.internal.community.model.DiscourseCategoryResponseDTO$DiscoursePosterInfo org.openhab.core.addon.marketplace.internal.community.model.DiscourseCategoryResponseDTO$DiscourseUser ), (Lorg/openhab/core/addon/marketplace/internal/community/model/DiscourseCategoryResponseDTO$DiscourseUser;)Z)((DiscourseCategoryResponseDTO.DiscoursePosterInfo)posterInfo)).findFirst().get().name;
                }
                ++n2;
            }
            String maturity = tags.stream().filter(Addon.CODE_MATURITY_LEVELS::contains).findAny().orElse(null);
            Map<String, T[]> properties = Map.of("created_at", createdDate, "like_count", likeCount, "views", views, "posts_count", postsCount, "tags", tags.toArray(String[]::new));
            boolean installed = this.addonHandlers.stream().anyMatch(handler -> handler.supports(type, contentType) && handler.isInstalled(uid));
            return Addon.create((String)uid).withType(type).withId(id).withContentType(contentType).withImageLink(topic.imageUrl).withAuthor(author).withProperties(properties).withLabel(title).withInstalled(installed).withMaturity(maturity).withCompatible(compatible).withLink(link).build();
        }
        catch (RuntimeException e) {
            this.logger.debug("Ignoring marketplace add-on '{}' due: {}", (Object)topic.title, (Object)e.getMessage());
            return null;
        }
    }

    private String unescapeEntities(String content) {
        return content.replace("&quot;", "\"").replace("&amp;", "&").replace("&apos;", "'").replace("&lt;", "<").replace("&gt;", ">");
    }

    private Addon convertTopicToAddon(DiscourseTopicResponseDTO topic) {
        String potentialRange;
        Matcher matcher;
        Matcher codeMarkup;
        String uid = ADDON_ID_PREFIX + topic.id.toString();
        List<String> tags = topic.tags == null ? List.of() : Arrays.stream(topic.tags).map(t -> t.name).toList();
        AddonType addonType = this.getAddonType(topic.categoryId, tags);
        String type = addonType != null ? addonType.getId() : "";
        String contentType = this.getContentType(topic.categoryId, tags);
        int likeCount = topic.likeCount;
        int views = topic.views;
        int postsCount = topic.postsCount;
        Date createdDate = topic.postStream.posts[0].createdAt;
        Date updatedDate = topic.postStream.posts[0].updatedAt;
        Date lastPostedDate = topic.lastPosted;
        String maturity = tags.stream().filter(Addon.CODE_MATURITY_LEVELS::contains).findAny().orElse(null);
        HashMap<Object, Object> properties = new HashMap<Object, Object>(10);
        properties.put("created_at", createdDate);
        properties.put("updated_at", updatedDate);
        properties.put("last_posted", lastPostedDate);
        properties.put("like_count", likeCount);
        properties.put("views", views);
        properties.put("posts_count", postsCount);
        properties.put("tags", tags.toArray(String[]::new));
        String detailedDescription = topic.postStream.posts[0].cooked;
        String id = null;
        if (topic.postStream.posts[0].linkCounts != null) {
            DiscourseTopicResponseDTO.DiscoursePostLink[] discoursePostLinkArray = topic.postStream.posts[0].linkCounts;
            int n = topic.postStream.posts[0].linkCounts.length;
            int n2 = 0;
            while (n2 < n) {
                DiscourseTopicResponseDTO.DiscoursePostLink postLink = discoursePostLinkArray[n2];
                if (postLink.url.endsWith(".jar")) {
                    properties.put("jar_download_url", postLink.url);
                    id = this.determineIdFromUrl(postLink.url);
                }
                if (postLink.url.endsWith(".kar")) {
                    properties.put("kar_download_url", postLink.url);
                    id = this.determineIdFromUrl(postLink.url);
                }
                if (postLink.url.endsWith(".json")) {
                    properties.put("json_download_url", postLink.url);
                }
                if (postLink.url.endsWith(".yaml")) {
                    properties.put("yaml_download_url", postLink.url);
                }
                ++n2;
            }
        }
        if (id == null) {
            id = topic.id.toString();
        }
        if ((codeMarkup = CODE_MARKUP_PATTERN.matcher(detailedDescription)).find()) {
            properties.put(codeMarkup.group("lang") + CODE_CONTENT_SUFFIX, this.unescapeEntities(codeMarkup.group("content")));
        }
        boolean installed = this.addonHandlers.stream().anyMatch(handler -> handler.supports(type, contentType) && handler.isInstalled(uid));
        String title = topic.title;
        int compatibilityStart = topic.title.lastIndexOf("[");
        if (topic.title.lastIndexOf(" ") < compatibilityStart && (matcher = BundleVersion.RANGE_PATTERN.matcher(potentialRange = topic.title.substring(compatibilityStart))).matches()) {
            title = topic.title.substring(0, compatibilityStart).trim();
        }
        Addon.Builder builder = Addon.create((String)uid).withType(type).withId(id).withContentType(contentType).withLabel(title).withImageLink(topic.imageUrl).withLink(COMMUNITY_TOPIC_URL + topic.id.toString()).withAuthor(topic.postStream.posts[0].displayUsername).withMaturity(maturity).withDetailedDescription(detailedDescription).withInstalled(installed).withProperties(properties);
        return builder.build();
    }

    private @Nullable String determineIdFromUrl(String url) {
        Matcher matcher = BUNDLE_NAME_PATTERN.matcher(url);
        if (matcher.matches()) {
            String bundleName = matcher.group(1);
            return bundleName.substring(bundleName.lastIndexOf(".") + 1);
        }
        this.logger.warn("Could not determine bundle name from url: {}", (Object)url);
        return null;
    }

    private static /* synthetic */ boolean lambda$7(String string, Addon e) {
        return string.equals(e.getUid());
    }

    private static /* synthetic */ boolean lambda$10(DiscourseCategoryResponseDTO.DiscoursePosterInfo discoursePosterInfo, DiscourseCategoryResponseDTO.DiscourseUser u) {
        return u.id.equals(discoursePosterInfo.userId);
    }
}

