#[cfg(feature = "Win32_UI_Shell_Common")]
pub mod Common;
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub mod PropertiesSystem;
#[inline]
pub unsafe fn AssocCreate<T>(clsid: windows_core::GUID) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocCreate(clsid : windows_core::GUID, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    AssocCreate(core::mem::transmute(clsid), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocCreateForClasses<T>(rgclasses: &[ASSOCIATIONELEMENT]) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn AssocCreateForClasses(rgclasses : *const ASSOCIATIONELEMENT, cclasses : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    AssocCreateForClasses(core::mem::transmute(rgclasses.as_ptr()), rgclasses.len().try_into().unwrap(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn AssocGetDetailsOfPropKey<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut windows_core::VARIANT, pffoundpropkey: Option<*mut super::super::Foundation::BOOL>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn AssocGetDetailsOfPropKey(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, pkey : *const PropertiesSystem:: PROPERTYKEY, pv : *mut core::mem::MaybeUninit < windows_core::VARIANT >, pffoundpropkey : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    AssocGetDetailsOfPropKey(psf.param().abi(), pidl, pkey, core::mem::transmute(pv), core::mem::transmute(pffoundpropkey.unwrap_or(std::ptr::null_mut()))).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn AssocGetPerceivedType<P0>(pszext: P0, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocGetPerceivedType(pszext : windows_core::PCWSTR, ptype : *mut Common:: PERCEIVED, pflag : *mut u32, ppsztype : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    AssocGetPerceivedType(pszext.param().abi(), ptype, pflag, core::mem::transmute(ppsztype.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn AssocIsDangerous<P0>(pszassoc: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocIsDangerous(pszassoc : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    AssocIsDangerous(pszassoc.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyA<P0, P1>(flags: ASSOCF, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> windows_core::Result<super::super::System::Registry::HKEY>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryKeyA(flags : ASSOCF, key : ASSOCKEY, pszassoc : windows_core::PCSTR, pszextra : windows_core::PCSTR, phkeyout : *mut super::super::System::Registry:: HKEY) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    AssocQueryKeyA(flags, key, pszassoc.param().abi(), pszextra.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyW<P0, P1>(flags: ASSOCF, key: ASSOCKEY, pszassoc: P0, pszextra: P1) -> windows_core::Result<super::super::System::Registry::HKEY>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryKeyW(flags : ASSOCF, key : ASSOCKEY, pszassoc : windows_core::PCWSTR, pszextra : windows_core::PCWSTR, phkeyout : *mut super::super::System::Registry:: HKEY) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    AssocQueryKeyW(flags, key, pszassoc.param().abi(), pszextra.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn AssocQueryStringA<P0, P1>(flags: ASSOCF, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: windows_core::PSTR, pcchout: *mut u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryStringA(flags : ASSOCF, str : ASSOCSTR, pszassoc : windows_core::PCSTR, pszextra : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    AssocQueryStringA(flags, str, pszassoc.param().abi(), pszextra.param().abi(), core::mem::transmute(pszout), pcchout)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyA<P0, P1>(flags: ASSOCF, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: windows_core::PSTR, pcchout: *mut u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryStringByKeyA(flags : ASSOCF, str : ASSOCSTR, hkassoc : super::super::System::Registry:: HKEY, pszextra : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    AssocQueryStringByKeyA(flags, str, hkassoc.param().abi(), pszextra.param().abi(), core::mem::transmute(pszout), pcchout)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyW<P0, P1>(flags: ASSOCF, str: ASSOCSTR, hkassoc: P0, pszextra: P1, pszout: windows_core::PWSTR, pcchout: *mut u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryStringByKeyW(flags : ASSOCF, str : ASSOCSTR, hkassoc : super::super::System::Registry:: HKEY, pszextra : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    AssocQueryStringByKeyW(flags, str, hkassoc.param().abi(), pszextra.param().abi(), core::mem::transmute(pszout), pcchout)
}
#[inline]
pub unsafe fn AssocQueryStringW<P0, P1>(flags: ASSOCF, str: ASSOCSTR, pszassoc: P0, pszextra: P1, pszout: windows_core::PWSTR, pcchout: *mut u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn AssocQueryStringW(flags : ASSOCF, str : ASSOCSTR, pszassoc : windows_core::PCWSTR, pszextra : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    AssocQueryStringW(flags, str, pszassoc.param().abi(), pszextra.param().abi(), core::mem::transmute(pszout), pcchout)
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CDefFolderMenu_Create2<P0, P1>(pidlfolder: Option<*const Common::ITEMIDLIST>, hwnd: P0, apidl: Option<&[*const Common::ITEMIDLIST]>, psf: P1, pfn: LPFNDFMCALLBACK, ahkeys: Option<&[super::super::System::Registry::HKEY]>) -> windows_core::Result<IContextMenu>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn CDefFolderMenu_Create2(pidlfolder : *const Common:: ITEMIDLIST, hwnd : super::super::Foundation:: HWND, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, psf : * mut core::ffi::c_void, pfn : LPFNDFMCALLBACK, nkeys : u32, ahkeys : *const super::super::System::Registry:: HKEY, ppcm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    CDefFolderMenu_Create2(core::mem::transmute(pidlfolder.unwrap_or(std::ptr::null())), hwnd.param().abi(), apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psf.param().abi(), pfn, ahkeys.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ahkeys.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, apidl: Option<&[*const Common::ITEMIDLIST]>) -> windows_core::Result<super::super::System::Com::IDataObject> {
    windows_targets::link!("shell32.dll" "system" fn CIDLData_CreateFromIDArray(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, ppdtobj : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    CIDLData_CreateFromIDArray(pidlfolder, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn ChrCmpIA(w1 : u16, w2 : u16) -> super::super::Foundation:: BOOL);
    ChrCmpIA(w1, w2)
}
#[inline]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn ChrCmpIW(w1 : u16, w2 : u16) -> super::super::Foundation:: BOOL);
    ChrCmpIW(w1, w2)
}
#[inline]
pub unsafe fn ColorAdjustLuma<P0, P1>(clrrgb: P0, n: i32, fscale: P1) -> super::super::Foundation::COLORREF
where
    P0: windows_core::Param<super::super::Foundation::COLORREF>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn ColorAdjustLuma(clrrgb : super::super::Foundation:: COLORREF, n : i32, fscale : super::super::Foundation:: BOOL) -> super::super::Foundation:: COLORREF);
    ColorAdjustLuma(clrrgb.param().abi(), n, fscale.param().abi())
}
#[inline]
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> super::super::Foundation::COLORREF {
    windows_targets::link!("shlwapi.dll" "system" fn ColorHLSToRGB(whue : u16, wluminance : u16, wsaturation : u16) -> super::super::Foundation:: COLORREF);
    ColorHLSToRGB(whue, wluminance, wsaturation)
}
#[inline]
pub unsafe fn ColorRGBToHLS<P0>(clrrgb: P0, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16)
where
    P0: windows_core::Param<super::super::Foundation::COLORREF>,
{
    windows_targets::link!("shlwapi.dll" "system" fn ColorRGBToHLS(clrrgb : super::super::Foundation:: COLORREF, pwhue : *mut u16, pwluminance : *mut u16, pwsaturation : *mut u16));
    ColorRGBToHLS(clrrgb.param().abi(), pwhue, pwluminance, pwsaturation)
}
#[inline]
pub unsafe fn CommandLineToArgvW<P0>(lpcmdline: P0, pnumargs: *mut i32) -> *mut windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn CommandLineToArgvW(lpcmdline : windows_core::PCWSTR, pnumargs : *mut i32) -> *mut windows_core::PWSTR);
    CommandLineToArgvW(lpcmdline.param().abi(), pnumargs)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn ConnectToConnectionPoint<P0, P1, P2>(punk: P0, riidevent: *const windows_core::GUID, fconnect: P1, punktarget: P2, pdwcookie: *mut u32, ppcpout: Option<*mut Option<super::super::System::Com::IConnectionPoint>>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
    P2: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shlwapi.dll" "system" fn ConnectToConnectionPoint(punk : * mut core::ffi::c_void, riidevent : *const windows_core::GUID, fconnect : super::super::Foundation:: BOOL, punktarget : * mut core::ffi::c_void, pdwcookie : *mut u32, ppcpout : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    ConnectToConnectionPoint(punk.param().abi(), riidevent, fconnect.param().abi(), punktarget.param().abi(), pdwcookie, core::mem::transmute(ppcpout.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CreateProfile<P0, P1>(pszusersid: P0, pszusername: P1, pszprofilepath: &mut [u16]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("userenv.dll" "system" fn CreateProfile(pszusersid : windows_core::PCWSTR, pszusername : windows_core::PCWSTR, pszprofilepath : windows_core::PWSTR, cchprofilepath : u32) -> windows_core::HRESULT);
    CreateProfile(pszusersid.param().abi(), pszusername.param().abi(), core::mem::transmute(pszprofilepath.as_ptr()), pszprofilepath.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn DAD_AutoScroll<P0>(hwnd: P0, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn DAD_AutoScroll(hwnd : super::super::Foundation:: HWND, pad : *mut AUTO_SCROLL_DATA, pptnow : *const super::super::Foundation:: POINT) -> super::super::Foundation:: BOOL);
    DAD_AutoScroll(hwnd.param().abi(), pad, pptnow)
}
#[inline]
pub unsafe fn DAD_DragEnterEx<P0>(hwndtarget: P0, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn DAD_DragEnterEx(hwndtarget : super::super::Foundation:: HWND, ptstart : super::super::Foundation:: POINT) -> super::super::Foundation:: BOOL);
    DAD_DragEnterEx(hwndtarget.param().abi(), core::mem::transmute(ptstart))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn DAD_DragEnterEx2<P0, P1>(hwndtarget: P0, ptstart: super::super::Foundation::POINT, pdtobject: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_targets::link!("shell32.dll" "system" fn DAD_DragEnterEx2(hwndtarget : super::super::Foundation:: HWND, ptstart : super::super::Foundation:: POINT, pdtobject : * mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    DAD_DragEnterEx2(hwndtarget.param().abi(), core::mem::transmute(ptstart), pdtobject.param().abi())
}
#[inline]
pub unsafe fn DAD_DragLeave() -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn DAD_DragLeave() -> super::super::Foundation:: BOOL);
    DAD_DragLeave()
}
#[inline]
pub unsafe fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn DAD_DragMove(pt : super::super::Foundation:: POINT) -> super::super::Foundation:: BOOL);
    DAD_DragMove(core::mem::transmute(pt))
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn DAD_SetDragImage<P0>(him: P0, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::Controls::HIMAGELIST>,
{
    windows_targets::link!("shell32.dll" "system" fn DAD_SetDragImage(him : super::Controls:: HIMAGELIST, pptoffset : *mut super::super::Foundation:: POINT) -> super::super::Foundation:: BOOL);
    DAD_SetDragImage(him.param().abi(), pptoffset)
}
#[inline]
pub unsafe fn DAD_ShowDragImage<P0>(fshow: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn DAD_ShowDragImage(fshow : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    DAD_ShowDragImage(fshow.param().abi())
}
#[inline]
pub unsafe fn DefSubclassProc<P0, P1, P2>(hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::WPARAM>,
    P2: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("comctl32.dll" "system" fn DefSubclassProc(hwnd : super::super::Foundation:: HWND, umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    DefSubclassProc(hwnd.param().abi(), umsg, wparam.param().abi(), lparam.param().abi())
}
#[inline]
pub unsafe fn DeleteProfileA<P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("userenv.dll" "system" fn DeleteProfileA(lpsidstring : windows_core::PCSTR, lpprofilepath : windows_core::PCSTR, lpcomputername : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    DeleteProfileA(lpsidstring.param().abi(), lpprofilepath.param().abi(), lpcomputername.param().abi()).ok()
}
#[inline]
pub unsafe fn DeleteProfileW<P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("userenv.dll" "system" fn DeleteProfileW(lpsidstring : windows_core::PCWSTR, lpprofilepath : windows_core::PCWSTR, lpcomputername : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    DeleteProfileW(lpsidstring.param().abi(), lpprofilepath.param().abi(), lpcomputername.param().abi()).ok()
}
#[inline]
pub unsafe fn DoEnvironmentSubstA(pszsrc: &mut [u8]) -> u32 {
    windows_targets::link!("shell32.dll" "system" fn DoEnvironmentSubstA(pszsrc : windows_core::PSTR, cchsrc : u32) -> u32);
    DoEnvironmentSubstA(core::mem::transmute(pszsrc.as_ptr()), pszsrc.len().try_into().unwrap())
}
#[inline]
pub unsafe fn DoEnvironmentSubstW(pszsrc: &mut [u16]) -> u32 {
    windows_targets::link!("shell32.dll" "system" fn DoEnvironmentSubstW(pszsrc : windows_core::PWSTR, cchsrc : u32) -> u32);
    DoEnvironmentSubstW(core::mem::transmute(pszsrc.as_ptr()), pszsrc.len().try_into().unwrap())
}
#[inline]
pub unsafe fn DragAcceptFiles<P0, P1>(hwnd: P0, faccept: P1)
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn DragAcceptFiles(hwnd : super::super::Foundation:: HWND, faccept : super::super::Foundation:: BOOL));
    DragAcceptFiles(hwnd.param().abi(), faccept.param().abi())
}
#[inline]
pub unsafe fn DragFinish<P0>(hdrop: P0)
where
    P0: windows_core::Param<HDROP>,
{
    windows_targets::link!("shell32.dll" "system" fn DragFinish(hdrop : HDROP));
    DragFinish(hdrop.param().abi())
}
#[inline]
pub unsafe fn DragQueryFileA<P0>(hdrop: P0, ifile: u32, lpszfile: Option<&mut [u8]>) -> u32
where
    P0: windows_core::Param<HDROP>,
{
    windows_targets::link!("shell32.dll" "system" fn DragQueryFileA(hdrop : HDROP, ifile : u32, lpszfile : windows_core::PSTR, cch : u32) -> u32);
    DragQueryFileA(hdrop.param().abi(), ifile, core::mem::transmute(lpszfile.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn DragQueryFileW<P0>(hdrop: P0, ifile: u32, lpszfile: Option<&mut [u16]>) -> u32
where
    P0: windows_core::Param<HDROP>,
{
    windows_targets::link!("shell32.dll" "system" fn DragQueryFileW(hdrop : HDROP, ifile : u32, lpszfile : windows_core::PWSTR, cch : u32) -> u32);
    DragQueryFileW(hdrop.param().abi(), ifile, core::mem::transmute(lpszfile.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn DragQueryPoint<P0>(hdrop: P0, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HDROP>,
{
    windows_targets::link!("shell32.dll" "system" fn DragQueryPoint(hdrop : HDROP, ppt : *mut super::super::Foundation:: POINT) -> super::super::Foundation:: BOOL);
    DragQueryPoint(hdrop.param().abi(), ppt)
}
#[inline]
pub unsafe fn DriveType(idrive: i32) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn DriveType(idrive : i32) -> i32);
    DriveType(idrive)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn DuplicateIcon<P0, P1>(hinst: P0, hicon: P1) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    P1: windows_core::Param<super::WindowsAndMessaging::HICON>,
{
    windows_targets::link!("shell32.dll" "system" fn DuplicateIcon(hinst : super::super::Foundation:: HINSTANCE, hicon : super::WindowsAndMessaging:: HICON) -> super::WindowsAndMessaging:: HICON);
    DuplicateIcon(hinst.param().abi(), hicon.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconA<P0>(hinst: P0, psziconpath: &mut [u8; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractAssociatedIconA(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PSTR, piicon : *mut u16) -> super::WindowsAndMessaging:: HICON);
    ExtractAssociatedIconA(hinst.param().abi(), core::mem::transmute(psziconpath.as_ptr()), piicon)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconExA<P0>(hinst: P0, psziconpath: &mut [u8; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractAssociatedIconExA(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PSTR, piiconindex : *mut u16, piiconid : *mut u16) -> super::WindowsAndMessaging:: HICON);
    ExtractAssociatedIconExA(hinst.param().abi(), core::mem::transmute(psziconpath.as_ptr()), piiconindex, piiconid)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconExW<P0>(hinst: P0, psziconpath: &mut [u16; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractAssociatedIconExW(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PWSTR, piiconindex : *mut u16, piiconid : *mut u16) -> super::WindowsAndMessaging:: HICON);
    ExtractAssociatedIconExW(hinst.param().abi(), core::mem::transmute(psziconpath.as_ptr()), piiconindex, piiconid)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconW<P0>(hinst: P0, psziconpath: &mut [u16; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractAssociatedIconW(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PWSTR, piicon : *mut u16) -> super::WindowsAndMessaging:: HICON);
    ExtractAssociatedIconW(hinst.param().abi(), core::mem::transmute(psziconpath.as_ptr()), piicon)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconA<P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractIconA(hinst : super::super::Foundation:: HINSTANCE, pszexefilename : windows_core::PCSTR, niconindex : u32) -> super::WindowsAndMessaging:: HICON);
    ExtractIconA(hinst.param().abi(), pszexefilename.param().abi(), niconindex)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExA<P0>(lpszfile: P0, niconindex: i32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractIconExA(lpszfile : windows_core::PCSTR, niconindex : i32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, nicons : u32) -> u32);
    ExtractIconExA(lpszfile.param().abi(), niconindex, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), nicons)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExW<P0>(lpszfile: P0, niconindex: i32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractIconExW(lpszfile : windows_core::PCWSTR, niconindex : i32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, nicons : u32) -> u32);
    ExtractIconExW(lpszfile.param().abi(), niconindex, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), nicons)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconW<P0, P1>(hinst: P0, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ExtractIconW(hinst : super::super::Foundation:: HINSTANCE, pszexefilename : windows_core::PCWSTR, niconindex : u32) -> super::WindowsAndMessaging:: HICON);
    ExtractIconW(hinst.param().abi(), pszexefilename.param().abi(), niconindex)
}
#[inline]
pub unsafe fn FindExecutableA<P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u8; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn FindExecutableA(lpfile : windows_core::PCSTR, lpdirectory : windows_core::PCSTR, lpresult : windows_core::PSTR) -> super::super::Foundation:: HINSTANCE);
    FindExecutableA(lpfile.param().abi(), lpdirectory.param().abi(), core::mem::transmute(lpresult.as_ptr()))
}
#[inline]
pub unsafe fn FindExecutableW<P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u16; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn FindExecutableW(lpfile : windows_core::PCWSTR, lpdirectory : windows_core::PCWSTR, lpresult : windows_core::PWSTR) -> super::super::Foundation:: HINSTANCE);
    FindExecutableW(lpfile.param().abi(), lpdirectory.param().abi(), core::mem::transmute(lpresult.as_ptr()))
}
#[inline]
pub unsafe fn GetAcceptLanguagesA(pszlanguages: windows_core::PSTR, pcchlanguages: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn GetAcceptLanguagesA(pszlanguages : windows_core::PSTR, pcchlanguages : *mut u32) -> windows_core::HRESULT);
    GetAcceptLanguagesA(core::mem::transmute(pszlanguages), pcchlanguages).ok()
}
#[inline]
pub unsafe fn GetAcceptLanguagesW(pszlanguages: windows_core::PWSTR, pcchlanguages: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn GetAcceptLanguagesW(pszlanguages : windows_core::PWSTR, pcchlanguages : *mut u32) -> windows_core::HRESULT);
    GetAcceptLanguagesW(core::mem::transmute(pszlanguages), pcchlanguages).ok()
}
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryA(lpprofiledir: windows_core::PSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetAllUsersProfileDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetAllUsersProfileDirectoryA(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryW(lpprofiledir: windows_core::PWSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetAllUsersProfileDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetAllUsersProfileDirectoryW(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID() -> windows_core::Result<windows_core::PWSTR> {
    windows_targets::link!("shell32.dll" "system" fn GetCurrentProcessExplicitAppUserModelID(appid : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    GetCurrentProcessExplicitAppUserModelID(&mut result__).map(|| result__)
}
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryA(lpprofiledir: windows_core::PSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetDefaultUserProfileDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetDefaultUserProfileDirectoryA(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryW(lpprofiledir: windows_core::PWSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetDefaultUserProfileDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetDefaultUserProfileDirectoryW(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-2.dll" "system" fn GetDpiForShellUIComponent(param0 : SHELL_UI_COMPONENT) -> u32);
    GetDpiForShellUIComponent(param0)
}
#[inline]
pub unsafe fn GetFileNameFromBrowse<P0, P1, P2, P3, P4>(hwnd: P0, pszfilepath: &mut [u16], pszworkingdir: P1, pszdefext: P2, pszfilters: P3, psztitle: P4) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn GetFileNameFromBrowse(hwnd : super::super::Foundation:: HWND, pszfilepath : windows_core::PWSTR, cchfilepath : u32, pszworkingdir : windows_core::PCWSTR, pszdefext : windows_core::PCWSTR, pszfilters : windows_core::PCWSTR, psztitle : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    GetFileNameFromBrowse(hwnd.param().abi(), core::mem::transmute(pszfilepath.as_ptr()), pszfilepath.len().try_into().unwrap(), pszworkingdir.param().abi(), pszdefext.param().abi(), pszfilters.param().abi(), psztitle.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuContextHelpId<P0>(param0: P0) -> u32
where
    P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
{
    windows_targets::link!("user32.dll" "system" fn GetMenuContextHelpId(param0 : super::WindowsAndMessaging:: HMENU) -> u32);
    GetMenuContextHelpId(param0.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuPosFromID<P0>(hmenu: P0, id: u32) -> i32
where
    P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
{
    windows_targets::link!("shlwapi.dll" "system" fn GetMenuPosFromID(hmenu : super::WindowsAndMessaging:: HMENU, id : u32) -> i32);
    GetMenuPosFromID(hmenu.param().abi(), id)
}
#[inline]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetProfileType(dwflags : *mut u32) -> super::super::Foundation:: BOOL);
    GetProfileType(dwflags).ok()
}
#[inline]
pub unsafe fn GetProfilesDirectoryA(lpprofiledir: windows_core::PSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetProfilesDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetProfilesDirectoryA(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetProfilesDirectoryW(lpprofiledir: windows_core::PWSTR, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("userenv.dll" "system" fn GetProfilesDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetProfilesDirectoryW(core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR {
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn GetScaleFactorForDevice(devicetype : DISPLAY_DEVICE_TYPE) -> Common:: DEVICE_SCALE_FACTOR);
    GetScaleFactorForDevice(devicetype)
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn GetScaleFactorForMonitor<P0>(hmon: P0) -> windows_core::Result<Common::DEVICE_SCALE_FACTOR>
where
    P0: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
{
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn GetScaleFactorForMonitor(hmon : super::super::Graphics::Gdi:: HMONITOR, pscale : *mut Common:: DEVICE_SCALE_FACTOR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    GetScaleFactorForMonitor(hmon.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn GetUserProfileDirectoryA<P0>(htoken: P0, lpprofiledir: windows_core::PSTR, lpcchsize: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("userenv.dll" "system" fn GetUserProfileDirectoryA(htoken : super::super::Foundation:: HANDLE, lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetUserProfileDirectoryA(htoken.param().abi(), core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetUserProfileDirectoryW<P0>(htoken: P0, lpprofiledir: windows_core::PWSTR, lpcchsize: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("userenv.dll" "system" fn GetUserProfileDirectoryW(htoken : super::super::Foundation:: HANDLE, lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> super::super::Foundation:: BOOL);
    GetUserProfileDirectoryW(htoken.param().abi(), core::mem::transmute(lpprofiledir), lpcchsize).ok()
}
#[inline]
pub unsafe fn GetWindowContextHelpId<P0>(param0: P0) -> u32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("user32.dll" "system" fn GetWindowContextHelpId(param0 : super::super::Foundation:: HWND) -> u32);
    GetWindowContextHelpId(param0.param().abi())
}
#[inline]
pub unsafe fn GetWindowSubclass<P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, pdwrefdata: Option<*mut usize>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("comctl32.dll" "system" fn GetWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize, pdwrefdata : *mut usize) -> super::super::Foundation:: BOOL);
    GetWindowSubclass(hwnd.param().abi(), pfnsubclass, uidsubclass, core::mem::transmute(pdwrefdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserFree(param0 : *const u32, param1 : *const super::super::Graphics::Gdi:: HMONITOR));
    HMONITOR_UserFree(param0, param1)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserFree64(param0 : *const u32, param1 : *const super::super::Graphics::Gdi:: HMONITOR));
    HMONITOR_UserFree64(param0, param1)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserMarshal(param0 : *const u32, param1 : *mut u8, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    HMONITOR_UserMarshal(param0, param1, param2)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserMarshal64(param0 : *const u32, param1 : *mut u8, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    HMONITOR_UserMarshal64(param0, param1, param2)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserSize(param0 : *const u32, param1 : u32, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> u32);
    HMONITOR_UserSize(param0, param1, param2)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserSize64(param0 : *const u32, param1 : u32, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> u32);
    HMONITOR_UserSize64(param0, param1, param2)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserUnmarshal(param0 : *const u32, param1 : *const u8, param2 : *mut super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    HMONITOR_UserUnmarshal(param0, param1, param2)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_targets::link!("ole32.dll" "system" fn HMONITOR_UserUnmarshal64(param0 : *const u32, param1 : *const u8, param2 : *mut super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    HMONITOR_UserUnmarshal64(param0, param1, param2)
}
#[inline]
pub unsafe fn HashData(pbdata: &[u8], pbhash: &mut [u8]) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn HashData(pbdata : *const u8, cbdata : u32, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    HashData(core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn HlinkClone<P0, P1, T>(pihl: P0, pihlsiteforclone: P1, dwsitedata: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<IHlink>,
    P1: windows_core::Param<IHlinkSite>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkClone(pihl : * mut core::ffi::c_void, riid : *const windows_core::GUID, pihlsiteforclone : * mut core::ffi::c_void, dwsitedata : u32, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkClone(pihl.param().abi(), &T::IID, pihlsiteforclone.param().abi(), dwsitedata, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn HlinkCreateBrowseContext<P0, T>(piunkouter: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateBrowseContext(piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkCreateBrowseContext(piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn HlinkCreateExtensionServices<P0, P1, P2, P3, P4, T>(pwzadditionalheaders: P0, phwnd: P1, pszusername: P2, pszpassword: P3, piunkouter: P4) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateExtensionServices(pwzadditionalheaders : windows_core::PCWSTR, phwnd : super::super::Foundation:: HWND, pszusername : windows_core::PCWSTR, pszpassword : windows_core::PCWSTR, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkCreateExtensionServices(pwzadditionalheaders.param().abi(), phwnd.param().abi(), pszusername.param().abi(), pszpassword.param().abi(), piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromData<P0, P1, P2, T>(pidataobj: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    P1: windows_core::Param<IHlinkSite>,
    P2: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateFromData(pidataobj : * mut core::ffi::c_void, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkCreateFromData(pidataobj.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromMoniker<P0, P1, P2, P3, P4, T>(pimktrgt: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IMoniker>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IHlinkSite>,
    P4: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateFromMoniker(pimktrgt : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkCreateFromMoniker(pimktrgt.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn HlinkCreateFromString<P0, P1, P2, P3, P4, T>(pwztarget: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P4) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IHlinkSite>,
    P4: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateFromString(pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    HlinkCreateFromString(pwztarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn HlinkCreateShortcut<P0, P1, P2>(grfhlshortcutf: u32, pihl: P0, pwzdir: P1, pwzfilename: P2, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlink>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateShortcut(grfhlshortcutf : u32, pihl : * mut core::ffi::c_void, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    HlinkCreateShortcut(grfhlshortcutf, pihl.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile, dwreserved).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateShortcutFromMoniker<P0, P1, P2, P3>(grfhlshortcutf: u32, pimktarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IMoniker>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateShortcutFromMoniker(grfhlshortcutf : u32, pimktarget : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    HlinkCreateShortcutFromMoniker(grfhlshortcutf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile, dwreserved).ok()
}
#[inline]
pub unsafe fn HlinkCreateShortcutFromString<P0, P1, P2, P3>(grfhlshortcutf: u32, pwztarget: P0, pwzlocation: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkCreateShortcutFromString(grfhlshortcutf : u32, pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    HlinkCreateShortcutFromString(grfhlshortcutf, pwztarget.param().abi(), pwzlocation.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile, dwreserved).ok()
}
#[inline]
pub unsafe fn HlinkGetSpecialReference(ureference: u32) -> windows_core::Result<windows_core::PWSTR> {
    windows_targets::link!("hlink.dll" "system" fn HlinkGetSpecialReference(ureference : u32, ppwzreference : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    HlinkGetSpecialReference(ureference, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn HlinkGetValueFromParams<P0, P1>(pwzparams: P0, pwzname: P1) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkGetValueFromParams(pwzparams : windows_core::PCWSTR, pwzname : windows_core::PCWSTR, ppwzvalue : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    HlinkGetValueFromParams(pwzparams.param().abi(), pwzname.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn HlinkIsShortcut<P0>(pwzfilename: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkIsShortcut(pwzfilename : windows_core::PCWSTR) -> windows_core::HRESULT);
    HlinkIsShortcut(pwzfilename.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigate<P0, P1, P2, P3, P4>(pihl: P0, pihlframe: P1, grfhlnf: u32, pbc: P2, pibsc: P3, pihlbc: P4) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlink>,
    P1: windows_core::Param<IHlinkFrame>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    P3: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P4: windows_core::Param<IHlinkBrowseContext>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkNavigate(pihl : * mut core::ffi::c_void, pihlframe : * mut core::ffi::c_void, grfhlnf : u32, pbc : * mut core::ffi::c_void, pibsc : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkNavigate(pihl.param().abi(), pihlframe.param().abi(), grfhlnf, pbc.param().abi(), pibsc.param().abi(), pihlbc.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigateToStringReference<P0, P1, P2, P3, P4, P5, P6>(pwztarget: P0, pwzlocation: P1, pihlsite: P2, dwsitedata: u32, pihlframe: P3, grfhlnf: u32, pibc: P4, pibsc: P5, pihlbc: P6) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<IHlinkSite>,
    P3: windows_core::Param<IHlinkFrame>,
    P4: windows_core::Param<super::super::System::Com::IBindCtx>,
    P5: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P6: windows_core::Param<IHlinkBrowseContext>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkNavigateToStringReference(pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, pihlframe : * mut core::ffi::c_void, grfhlnf : u32, pibc : * mut core::ffi::c_void, pibsc : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkNavigateToStringReference(pwztarget.param().abi(), pwzlocation.param().abi(), pihlsite.param().abi(), dwsitedata, pihlframe.param().abi(), grfhlnf, pibc.param().abi(), pibsc.param().abi(), pihlbc.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnNavigate<P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, grfhlnf: u32, pimktarget: P2, pwzlocation: P3, pwzfriendlyname: P4, puhlid: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlinkFrame>,
    P1: windows_core::Param<IHlinkBrowseContext>,
    P2: windows_core::Param<super::super::System::Com::IMoniker>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkOnNavigate(pihlframe : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void, grfhlnf : u32, pimktarget : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, puhlid : *mut u32) -> windows_core::HRESULT);
    HlinkOnNavigate(pihlframe.param().abi(), pihlbc.param().abi(), grfhlnf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), puhlid).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnRenameDocument<P0, P1, P2>(dwreserved: u32, pihlbc: P0, pimkold: P1, pimknew: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlinkBrowseContext>,
    P1: windows_core::Param<super::super::System::Com::IMoniker>,
    P2: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkOnRenameDocument(dwreserved : u32, pihlbc : * mut core::ffi::c_void, pimkold : * mut core::ffi::c_void, pimknew : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkOnRenameDocument(dwreserved, pihlbc.param().abi(), pimkold.param().abi(), pimknew.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkParseDisplayName<P0, P1, P2>(pibc: P0, pwzdisplayname: P1, fnoforceabs: P2, pccheaten: *mut u32, ppimk: *mut Option<super::super::System::Com::IMoniker>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkParseDisplayName(pibc : * mut core::ffi::c_void, pwzdisplayname : windows_core::PCWSTR, fnoforceabs : super::super::Foundation:: BOOL, pccheaten : *mut u32, ppimk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkParseDisplayName(pibc.param().abi(), pwzdisplayname.param().abi(), fnoforceabs.param().abi(), pccheaten, core::mem::transmute(ppimk)).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkPreprocessMoniker<P0, P1>(pibc: P0, pimkin: P1) -> windows_core::Result<super::super::System::Com::IMoniker>
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    P1: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkPreprocessMoniker(pibc : * mut core::ffi::c_void, pimkin : * mut core::ffi::c_void, ppimkout : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    HlinkPreprocessMoniker(pibc.param().abi(), pimkin.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkQueryCreateFromData<P0>(pidataobj: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkQueryCreateFromData(pidataobj : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkQueryCreateFromData(pidataobj.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveMonikerForData<P0, P1, P2, P3>(pimkreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IMoniker>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    P2: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P3: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkResolveMonikerForData(pimkreference : * mut core::ffi::c_void, reserved : u32, pibc : * mut core::ffi::c_void, cfmtetc : u32, rgfmtetc : *mut super::super::System::Com:: FORMATETC, pibsc : * mut core::ffi::c_void, pimkbase : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkResolveMonikerForData(pimkreference.param().abi(), reserved, pibc.param().abi(), cfmtetc, rgfmtetc, pibsc.param().abi(), pimkbase.param().abi()).ok()
}
#[inline]
pub unsafe fn HlinkResolveShortcut<P0, P1, P2>(pwzshortcutfilename: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P2, riid: *const windows_core::GUID, ppvobj: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IHlinkSite>,
    P2: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkResolveShortcut(pwzshortcutfilename : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkResolveShortcut(pwzshortcutfilename.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), riid, ppvobj).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveShortcutToMoniker<P0>(pwzshortcutfilename: P0, ppimktarget: *mut Option<super::super::System::Com::IMoniker>, ppwzlocation: *mut windows_core::PWSTR) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkResolveShortcutToMoniker(pwzshortcutfilename : windows_core::PCWSTR, ppimktarget : *mut * mut core::ffi::c_void, ppwzlocation : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    HlinkResolveShortcutToMoniker(pwzshortcutfilename.param().abi(), core::mem::transmute(ppimktarget), ppwzlocation).ok()
}
#[inline]
pub unsafe fn HlinkResolveShortcutToString<P0>(pwzshortcutfilename: P0, ppwztarget: *mut windows_core::PWSTR, ppwzlocation: *mut windows_core::PWSTR) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkResolveShortcutToString(pwzshortcutfilename : windows_core::PCWSTR, ppwztarget : *mut windows_core::PWSTR, ppwzlocation : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    HlinkResolveShortcutToString(pwzshortcutfilename.param().abi(), ppwztarget, ppwzlocation).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveStringForData<P0, P1, P2, P3>(pwzreference: P0, reserved: u32, pibc: P1, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P2, pimkbase: P3) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    P2: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P3: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkResolveStringForData(pwzreference : windows_core::PCWSTR, reserved : u32, pibc : * mut core::ffi::c_void, cfmtetc : u32, rgfmtetc : *mut super::super::System::Com:: FORMATETC, pibsc : * mut core::ffi::c_void, pimkbase : * mut core::ffi::c_void) -> windows_core::HRESULT);
    HlinkResolveStringForData(pwzreference.param().abi(), reserved, pibc.param().abi(), cfmtetc, rgfmtetc, pibsc.param().abi(), pimkbase.param().abi()).ok()
}
#[inline]
pub unsafe fn HlinkSetSpecialReference<P0>(ureference: u32, pwzreference: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkSetSpecialReference(ureference : u32, pwzreference : windows_core::PCWSTR) -> windows_core::HRESULT);
    HlinkSetSpecialReference(ureference, pwzreference.param().abi()).ok()
}
#[inline]
pub unsafe fn HlinkTranslateURL<P0>(pwzurl: P0, grfflags: u32) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkTranslateURL(pwzurl : windows_core::PCWSTR, grfflags : u32, ppwztranslatedurl : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    HlinkTranslateURL(pwzurl.param().abi(), grfflags, &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkUpdateStackItem<P0, P1, P2, P3, P4>(pihlframe: P0, pihlbc: P1, uhlid: u32, pimktrgt: P2, pwzlocation: P3, pwzfriendlyname: P4) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlinkFrame>,
    P1: windows_core::Param<IHlinkBrowseContext>,
    P2: windows_core::Param<super::super::System::Com::IMoniker>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("hlink.dll" "system" fn HlinkUpdateStackItem(pihlframe : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void, uhlid : u32, pimktrgt : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR) -> windows_core::HRESULT);
    HlinkUpdateStackItem(pihlframe.param().abi(), pihlbc.param().abi(), uhlid, pimktrgt.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi()).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILAppendID<P0>(pidl: Option<*const Common::ITEMIDLIST>, pmkid: *const Common::SHITEMID, fappend: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn ILAppendID(pidl : *const Common:: ITEMIDLIST, pmkid : *const Common:: SHITEMID, fappend : super::super::Foundation:: BOOL) -> *mut Common:: ITEMIDLIST);
    ILAppendID(core::mem::transmute(pidl.unwrap_or(std::ptr::null())), pmkid, fappend.param().abi())
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILClone(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILClone(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILClone(pidl)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCloneFirst(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILCloneFirst(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILCloneFirst(pidl)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCombine(pidl1: Option<*const Common::ITEMIDLIST>, pidl2: Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILCombine(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILCombine(core::mem::transmute(pidl1.unwrap_or(std::ptr::null())), core::mem::transmute(pidl2.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathA<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ILCreateFromPathA(pszpath : windows_core::PCSTR) -> *mut Common:: ITEMIDLIST);
    ILCreateFromPathA(pszpath.param().abi())
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathW<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ILCreateFromPathW(pszpath : windows_core::PCWSTR) -> *mut Common:: ITEMIDLIST);
    ILCreateFromPathW(pszpath.param().abi())
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindChild(pidlparent: *const Common::ITEMIDLIST, pidlchild: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILFindChild(pidlparent : *const Common:: ITEMIDLIST, pidlchild : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILFindChild(pidlparent, pidlchild)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindLastID(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILFindLastID(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILFindLastID(pidl)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFree(pidl: Option<*const Common::ITEMIDLIST>) {
    windows_targets::link!("shell32.dll" "system" fn ILFree(pidl : *const Common:: ITEMIDLIST));
    ILFree(core::mem::transmute(pidl.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetNext(pidl: Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn ILGetNext(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    ILGetNext(core::mem::transmute(pidl.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetSize(pidl: Option<*const Common::ITEMIDLIST>) -> u32 {
    windows_targets::link!("shell32.dll" "system" fn ILGetSize(pidl : *const Common:: ITEMIDLIST) -> u32);
    ILGetSize(core::mem::transmute(pidl.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILIsEqual(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn ILIsEqual(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST) -> super::super::Foundation:: BOOL);
    ILIsEqual(pidl1, pidl2)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILIsParent<P0>(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST, fimmediate: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn ILIsParent(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST, fimmediate : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    ILIsParent(pidl1, pidl2, fimmediate.param().abi())
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILLoadFromStreamEx<P0>(pstm: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shell32.dll" "system" fn ILLoadFromStreamEx(pstm : * mut core::ffi::c_void, pidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    ILLoadFromStreamEx(pstm.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILRemoveLastID(pidl: Option<*mut Common::ITEMIDLIST>) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn ILRemoveLastID(pidl : *mut Common:: ITEMIDLIST) -> super::super::Foundation:: BOOL);
    ILRemoveLastID(core::mem::transmute(pidl.unwrap_or(std::ptr::null_mut())))
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILSaveToStream<P0>(pstm: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shell32.dll" "system" fn ILSaveToStream(pstm : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST) -> windows_core::HRESULT);
    ILSaveToStream(pstm.param().abi(), pidl).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Copy<P0, P1>(pstmfrom: P0, pstmto: P1, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
    P1: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_Copy(pstmfrom : * mut core::ffi::c_void, pstmto : * mut core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    IStream_Copy(pstmfrom.param().abi(), pstmto.param().abi(), cb).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Read<P0>(pstm: P0, pv: *mut core::ffi::c_void, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_Read(pstm : * mut core::ffi::c_void, pv : *mut core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    IStream_Read(pstm.param().abi(), pv, cb).ok()
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_ReadPidl<P0>(pstm: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_ReadPidl(pstm : * mut core::ffi::c_void, ppidlout : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    IStream_ReadPidl(pstm.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_ReadStr<P0>(pstm: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_ReadStr(pstm : * mut core::ffi::c_void, ppsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    IStream_ReadStr(pstm.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Reset<P0>(pstm: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_Reset(pstm : * mut core::ffi::c_void) -> windows_core::HRESULT);
    IStream_Reset(pstm.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Size<P0>(pstm: P0) -> windows_core::Result<u64>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_Size(pstm : * mut core::ffi::c_void, pui : *mut u64) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    IStream_Size(pstm.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Write<P0>(pstm: P0, pv: *const core::ffi::c_void, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_Write(pstm : * mut core::ffi::c_void, pv : *const core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    IStream_Write(pstm.param().abi(), pv, cb).ok()
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_WritePidl<P0>(pstm: P0, pidlwrite: *const Common::ITEMIDLIST) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_WritePidl(pstm : * mut core::ffi::c_void, pidlwrite : *const Common:: ITEMIDLIST) -> windows_core::HRESULT);
    IStream_WritePidl(pstm.param().abi(), pidlwrite).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_WriteStr<P0, P1>(pstm: P0, psz: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IStream_WriteStr(pstm : * mut core::ffi::c_void, psz : windows_core::PCWSTR) -> windows_core::HRESULT);
    IStream_WriteStr(pstm.param().abi(), psz.param().abi()).ok()
}
#[inline]
pub unsafe fn IUnknown_AtomicRelease(ppunk: Option<*mut *mut core::ffi::c_void>) {
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_AtomicRelease(ppunk : *mut *mut core::ffi::c_void));
    IUnknown_AtomicRelease(core::mem::transmute(ppunk.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn IUnknown_GetSite<P0, T>(punk: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_GetSite(punk : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    IUnknown_GetSite(punk.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn IUnknown_GetWindow<P0>(punk: P0) -> windows_core::Result<super::super::Foundation::HWND>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_GetWindow(punk : * mut core::ffi::c_void, phwnd : *mut super::super::Foundation:: HWND) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    IUnknown_GetWindow(punk.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn IUnknown_QueryService<P0, T>(punk: P0, guidservice: *const windows_core::GUID) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_QueryService(punk : * mut core::ffi::c_void, guidservice : *const windows_core::GUID, riid : *const windows_core::GUID, ppvout : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    IUnknown_QueryService(punk.param().abi(), guidservice, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn IUnknown_Set<P0>(ppunk: *mut Option<windows_core::IUnknown>, punk: P0)
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_Set(ppunk : *mut * mut core::ffi::c_void, punk : * mut core::ffi::c_void));
    IUnknown_Set(core::mem::transmute(ppunk), punk.param().abi())
}
#[inline]
pub unsafe fn IUnknown_SetSite<P0, P1>(punk: P0, punksite: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IUnknown_SetSite(punk : * mut core::ffi::c_void, punksite : * mut core::ffi::c_void) -> windows_core::HRESULT);
    IUnknown_SetSite(punk.param().abi(), punksite.param().abi()).ok()
}
#[inline]
pub unsafe fn ImportPrivacySettings<P0>(pszfilename: P0, pfparseprivacypreferences: *mut super::super::Foundation::BOOL, pfparsepersiterules: *mut super::super::Foundation::BOOL) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shdocvw.dll" "system" fn ImportPrivacySettings(pszfilename : windows_core::PCWSTR, pfparseprivacypreferences : *mut super::super::Foundation:: BOOL, pfparsepersiterules : *mut super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    ImportPrivacySettings(pszfilename.param().abi(), pfparseprivacypreferences, pfparsepersiterules)
}
#[inline]
pub unsafe fn InitNetworkAddressControl() -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn InitNetworkAddressControl() -> super::super::Foundation:: BOOL);
    InitNetworkAddressControl()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn InitPropVariantFromStrRet(pstrret: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppropvar: *mut windows_core::PROPVARIANT) -> windows_core::Result<()> {
    windows_targets::link!("propsys.dll" "system" fn InitPropVariantFromStrRet(pstrret : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppropvar : *mut core::mem::MaybeUninit < windows_core::PROPVARIANT >) -> windows_core::HRESULT);
    InitPropVariantFromStrRet(pstrret, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), core::mem::transmute(ppropvar)).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn InitVariantFromStrRet(pstrret: *const Common::STRRET, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<windows_core::VARIANT> {
    windows_targets::link!("propsys.dll" "system" fn InitVariantFromStrRet(pstrret : *const Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pvar : *mut core::mem::MaybeUninit < windows_core::VARIANT >) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    InitVariantFromStrRet(pstrret, pidl, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn IntlStrEqWorkerA<P0, P1, P2>(fcasesens: P0, lpstring1: P1, lpstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IntlStrEqWorkerA(fcasesens : super::super::Foundation:: BOOL, lpstring1 : windows_core::PCSTR, lpstring2 : windows_core::PCSTR, nchar : i32) -> super::super::Foundation:: BOOL);
    IntlStrEqWorkerA(fcasesens.param().abi(), lpstring1.param().abi(), lpstring2.param().abi(), nchar)
}
#[inline]
pub unsafe fn IntlStrEqWorkerW<P0, P1, P2>(fcasesens: P0, lpstring1: P1, lpstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn IntlStrEqWorkerW(fcasesens : super::super::Foundation:: BOOL, lpstring1 : windows_core::PCWSTR, lpstring2 : windows_core::PCWSTR, nchar : i32) -> super::super::Foundation:: BOOL);
    IntlStrEqWorkerW(fcasesens.param().abi(), lpstring1.param().abi(), lpstring2.param().abi(), nchar)
}
#[inline]
pub unsafe fn IsCharSpaceA(wch: i8) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn IsCharSpaceA(wch : i8) -> super::super::Foundation:: BOOL);
    IsCharSpaceA(wch)
}
#[inline]
pub unsafe fn IsCharSpaceW(wch: u16) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn IsCharSpaceW(wch : u16) -> super::super::Foundation:: BOOL);
    IsCharSpaceW(wch)
}
#[inline]
pub unsafe fn IsInternetESCEnabled() -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn IsInternetESCEnabled() -> super::super::Foundation:: BOOL);
    IsInternetESCEnabled()
}
#[inline]
pub unsafe fn IsLFNDriveA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn IsLFNDriveA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    IsLFNDriveA(pszpath.param().abi())
}
#[inline]
pub unsafe fn IsLFNDriveW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn IsLFNDriveW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    IsLFNDriveW(pszpath.param().abi())
}
#[inline]
pub unsafe fn IsNetDrive(idrive: i32) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn IsNetDrive(idrive : i32) -> i32);
    IsNetDrive(idrive)
}
#[inline]
pub unsafe fn IsOS(dwos: OS) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn IsOS(dwos : OS) -> super::super::Foundation:: BOOL);
    IsOS(dwos)
}
#[inline]
pub unsafe fn IsUserAnAdmin() -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn IsUserAnAdmin() -> super::super::Foundation:: BOOL);
    IsUserAnAdmin()
}
#[inline]
pub unsafe fn LoadUserProfileA<P0>(htoken: P0, lpprofileinfo: *mut PROFILEINFOA) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("userenv.dll" "system" fn LoadUserProfileA(htoken : super::super::Foundation:: HANDLE, lpprofileinfo : *mut PROFILEINFOA) -> super::super::Foundation:: BOOL);
    LoadUserProfileA(htoken.param().abi(), lpprofileinfo).ok()
}
#[inline]
pub unsafe fn LoadUserProfileW<P0>(htoken: P0, lpprofileinfo: *mut PROFILEINFOW) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("userenv.dll" "system" fn LoadUserProfileW(htoken : super::super::Foundation:: HANDLE, lpprofileinfo : *mut PROFILEINFOW) -> super::super::Foundation:: BOOL);
    LoadUserProfileW(htoken.param().abi(), lpprofileinfo).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn OleSaveToStreamEx<P0, P1, P2>(piunk: P0, pistm: P1, fcleardirty: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<super::super::System::Com::IStream>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("hlink.dll" "system" fn OleSaveToStreamEx(piunk : * mut core::ffi::c_void, pistm : * mut core::ffi::c_void, fcleardirty : super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    OleSaveToStreamEx(piunk.param().abi(), pistm.param().abi(), fcleardirty.param().abi()).ok()
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn OpenRegStream<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn OpenRegStream(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    OpenRegStream(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), grfmode)
}
#[inline]
pub unsafe fn ParseURLA<P0>(pcszurl: P0, ppu: *mut PARSEDURLA) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn ParseURLA(pcszurl : windows_core::PCSTR, ppu : *mut PARSEDURLA) -> windows_core::HRESULT);
    ParseURLA(pcszurl.param().abi(), ppu).ok()
}
#[inline]
pub unsafe fn ParseURLW<P0>(pcszurl: P0, ppu: *mut PARSEDURLW) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn ParseURLW(pcszurl : windows_core::PCWSTR, ppu : *mut PARSEDURLW) -> windows_core::HRESULT);
    ParseURLW(pcszurl.param().abi(), ppu).ok()
}
#[inline]
pub unsafe fn PathAddBackslashA(pszpath: &mut [u8; 260]) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathAddBackslashA(pszpath : windows_core::PSTR) -> windows_core::PSTR);
    PathAddBackslashA(core::mem::transmute(pszpath.as_ptr()))
}
#[inline]
pub unsafe fn PathAddBackslashW(pszpath: &mut [u16; 260]) -> windows_core::PWSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathAddBackslashW(pszpath : windows_core::PWSTR) -> windows_core::PWSTR);
    PathAddBackslashW(core::mem::transmute(pszpath.as_ptr()))
}
#[inline]
pub unsafe fn PathAddExtensionA<P0>(pszpath: &mut [u8; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathAddExtensionA(pszpath : windows_core::PSTR, pszext : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathAddExtensionA(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi())
}
#[inline]
pub unsafe fn PathAddExtensionW<P0>(pszpath: &mut [u16; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathAddExtensionW(pszpath : windows_core::PWSTR, pszext : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathAddExtensionW(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi())
}
#[inline]
pub unsafe fn PathAllocCanonicalize<P0>(pszpathin: P0, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathAllocCanonicalize(pszpathin : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS, ppszpathout : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    PathAllocCanonicalize(pszpathin.param().abi(), dwflags, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn PathAllocCombine<P0, P1>(pszpathin: P0, pszmore: P1, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathAllocCombine(pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS, ppszpathout : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    PathAllocCombine(pszpathin.param().abi(), pszmore.param().abi(), dwflags, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn PathAppendA<P0>(pszpath: &mut [u8; 260], pszmore: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathAppendA(pszpath : windows_core::PSTR, pszmore : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathAppendA(core::mem::transmute(pszpath.as_ptr()), pszmore.param().abi())
}
#[inline]
pub unsafe fn PathAppendW<P0>(pszpath: &mut [u16; 260], pszmore: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathAppendW(pszpath : windows_core::PWSTR, pszmore : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathAppendW(core::mem::transmute(pszpath.as_ptr()), pszmore.param().abi())
}
#[inline]
pub unsafe fn PathBuildRootA(pszroot: &mut [u8; 4], idrive: i32) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathBuildRootA(pszroot : windows_core::PSTR, idrive : i32) -> windows_core::PSTR);
    PathBuildRootA(core::mem::transmute(pszroot.as_ptr()), idrive)
}
#[inline]
pub unsafe fn PathBuildRootW(pszroot: &mut [u16; 4], idrive: i32) -> windows_core::PWSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathBuildRootW(pszroot : windows_core::PWSTR, idrive : i32) -> windows_core::PWSTR);
    PathBuildRootW(core::mem::transmute(pszroot.as_ptr()), idrive)
}
#[inline]
pub unsafe fn PathCanonicalizeA<P0>(pszbuf: &mut [u8; 260], pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCanonicalizeA(pszbuf : windows_core::PSTR, pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathCanonicalizeA(core::mem::transmute(pszbuf.as_ptr()), pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCanonicalizeW<P0>(pszbuf: &mut [u16; 260], pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCanonicalizeW(pszbuf : windows_core::PWSTR, pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathCanonicalizeW(core::mem::transmute(pszbuf.as_ptr()), pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchAddBackslash(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddBackslash(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchAddBackslash(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathCchAddBackslashEx(pszpath: &mut [u16], ppszend: Option<*mut windows_core::PWSTR>, pcchremaining: Option<*mut usize>) -> windows_core::HRESULT {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddBackslashEx(pszpath : windows_core::PWSTR, cchpath : usize, ppszend : *mut windows_core::PWSTR, pcchremaining : *mut usize) -> windows_core::HRESULT);
    PathCchAddBackslashEx(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), core::mem::transmute(ppszend.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchremaining.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn PathCchAddExtension<P0>(pszpath: &mut [u16], pszext: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddExtension(pszpath : windows_core::PWSTR, cchpath : usize, pszext : windows_core::PCWSTR) -> windows_core::HRESULT);
    PathCchAddExtension(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszext.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchAppend<P0>(pszpath: &mut [u16], pszmore: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAppend(pszpath : windows_core::PWSTR, cchpath : usize, pszmore : windows_core::PCWSTR) -> windows_core::HRESULT);
    PathCchAppend(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszmore.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchAppendEx<P0>(pszpath: &mut [u16], pszmore: P0, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAppendEx(pszpath : windows_core::PWSTR, cchpath : usize, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    PathCchAppendEx(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszmore.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PathCchCanonicalize<P0>(pszpathout: &mut [u16], pszpathin: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCanonicalize(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR) -> windows_core::HRESULT);
    PathCchCanonicalize(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchCanonicalizeEx<P0>(pszpathout: &mut [u16], pszpathin: P0, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCanonicalizeEx(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    PathCchCanonicalizeEx(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PathCchCombine<P0, P1>(pszpathout: &mut [u16], pszpathin: P0, pszmore: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCombine(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR) -> windows_core::HRESULT);
    PathCchCombine(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), pszmore.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchCombineEx<P0, P1>(pszpathout: &mut [u16], pszpathin: P0, pszmore: P1, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCombineEx(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    PathCchCombineEx(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), pszmore.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PathCchFindExtension<P0>(pszpath: P0, cchpath: usize) -> windows_core::Result<windows_core::PCWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchFindExtension(pszpath : windows_core::PCWSTR, cchpath : usize, ppszext : *mut windows_core::PCWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    PathCchFindExtension(pszpath.param().abi(), cchpath, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn PathCchIsRoot<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchIsRoot(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathCchIsRoot(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathCchRemoveBackslash(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveBackslash(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchRemoveBackslash(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathCchRemoveBackslashEx(pszpath: windows_core::PWSTR, cchpath: usize, ppszend: Option<*mut windows_core::PWSTR>, pcchremaining: Option<*mut usize>) -> windows_core::Result<()> {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveBackslashEx(pszpath : windows_core::PWSTR, cchpath : usize, ppszend : *mut windows_core::PWSTR, pcchremaining : *mut usize) -> windows_core::HRESULT);
    PathCchRemoveBackslashEx(core::mem::transmute(pszpath), cchpath, core::mem::transmute(ppszend.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchremaining.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn PathCchRemoveExtension(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::Result<()> {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveExtension(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchRemoveExtension(core::mem::transmute(pszpath), cchpath).ok()
}
#[inline]
pub unsafe fn PathCchRemoveFileSpec(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::Result<()> {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveFileSpec(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchRemoveFileSpec(core::mem::transmute(pszpath), cchpath).ok()
}
#[inline]
pub unsafe fn PathCchRenameExtension<P0>(pszpath: &mut [u16], pszext: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRenameExtension(pszpath : windows_core::PWSTR, cchpath : usize, pszext : windows_core::PCWSTR) -> windows_core::HRESULT);
    PathCchRenameExtension(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszext.param().abi()).ok()
}
#[inline]
pub unsafe fn PathCchSkipRoot<P0>(pszpath: P0) -> windows_core::Result<windows_core::PCWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchSkipRoot(pszpath : windows_core::PCWSTR, ppszrootend : *mut windows_core::PCWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    PathCchSkipRoot(pszpath.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn PathCchStripPrefix(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchStripPrefix(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchStripPrefix(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathCchStripToRoot(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::HRESULT {
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchStripToRoot(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    PathCchStripToRoot(core::mem::transmute(pszpath), cchpath)
}
#[inline]
pub unsafe fn PathCleanupSpec<P0>(pszdir: P0, pszspec: windows_core::PWSTR) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathCleanupSpec(pszdir : windows_core::PCWSTR, pszspec : windows_core::PWSTR) -> i32);
    PathCleanupSpec(pszdir.param().abi(), core::mem::transmute(pszspec))
}
#[inline]
pub unsafe fn PathCombineA<P0, P1>(pszdest: &mut [u8; 260], pszdir: P0, pszfile: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCombineA(pszdest : windows_core::PSTR, pszdir : windows_core::PCSTR, pszfile : windows_core::PCSTR) -> windows_core::PSTR);
    PathCombineA(core::mem::transmute(pszdest.as_ptr()), pszdir.param().abi(), pszfile.param().abi())
}
#[inline]
pub unsafe fn PathCombineW<P0, P1>(pszdest: &mut [u16; 260], pszdir: P0, pszfile: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCombineW(pszdest : windows_core::PWSTR, pszdir : windows_core::PCWSTR, pszfile : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathCombineW(core::mem::transmute(pszdest.as_ptr()), pszdir.param().abi(), pszfile.param().abi())
}
#[inline]
pub unsafe fn PathCommonPrefixA<P0, P1>(pszfile1: P0, pszfile2: P1, achpath: Option<&mut [u8; 260]>) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCommonPrefixA(pszfile1 : windows_core::PCSTR, pszfile2 : windows_core::PCSTR, achpath : windows_core::PSTR) -> i32);
    PathCommonPrefixA(pszfile1.param().abi(), pszfile2.param().abi(), core::mem::transmute(achpath.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())))
}
#[inline]
pub unsafe fn PathCommonPrefixW<P0, P1>(pszfile1: P0, pszfile2: P1, achpath: Option<&mut [u16; 260]>) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCommonPrefixW(pszfile1 : windows_core::PCWSTR, pszfile2 : windows_core::PCWSTR, achpath : windows_core::PWSTR) -> i32);
    PathCommonPrefixW(pszfile1.param().abi(), pszfile2.param().abi(), core::mem::transmute(achpath.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())))
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn PathCompactPathA<P0>(hdc: P0, pszpath: &mut [u8; 260], dx: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCompactPathA(hdc : super::super::Graphics::Gdi:: HDC, pszpath : windows_core::PSTR, dx : u32) -> super::super::Foundation:: BOOL);
    PathCompactPathA(hdc.param().abi(), core::mem::transmute(pszpath.as_ptr()), dx)
}
#[inline]
pub unsafe fn PathCompactPathExA<P0>(pszout: &mut [u8], pszsrc: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCompactPathExA(pszout : windows_core::PSTR, pszsrc : windows_core::PCSTR, cchmax : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    PathCompactPathExA(core::mem::transmute(pszout.as_ptr()), pszsrc.param().abi(), pszout.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn PathCompactPathExW<P0>(pszout: &mut [u16], pszsrc: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCompactPathExW(pszout : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchmax : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    PathCompactPathExW(core::mem::transmute(pszout.as_ptr()), pszsrc.param().abi(), pszout.len().try_into().unwrap(), dwflags)
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn PathCompactPathW<P0>(hdc: P0, pszpath: &mut [u16; 260], dx: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCompactPathW(hdc : super::super::Graphics::Gdi:: HDC, pszpath : windows_core::PWSTR, dx : u32) -> super::super::Foundation:: BOOL);
    PathCompactPathW(hdc.param().abi(), core::mem::transmute(pszpath.as_ptr()), dx)
}
#[inline]
pub unsafe fn PathCreateFromUrlA<P0>(pszurl: P0, pszpath: windows_core::PSTR, pcchpath: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCreateFromUrlA(pszurl : windows_core::PCSTR, pszpath : windows_core::PSTR, pcchpath : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    PathCreateFromUrlA(pszurl.param().abi(), core::mem::transmute(pszpath), pcchpath, dwflags).ok()
}
#[inline]
pub unsafe fn PathCreateFromUrlAlloc<P0>(pszin: P0, ppszout: *mut windows_core::PWSTR, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCreateFromUrlAlloc(pszin : windows_core::PCWSTR, ppszout : *mut windows_core::PWSTR, dwflags : u32) -> windows_core::HRESULT);
    PathCreateFromUrlAlloc(pszin.param().abi(), ppszout, dwflags).ok()
}
#[inline]
pub unsafe fn PathCreateFromUrlW<P0>(pszurl: P0, pszpath: windows_core::PWSTR, pcchpath: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathCreateFromUrlW(pszurl : windows_core::PCWSTR, pszpath : windows_core::PWSTR, pcchpath : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    PathCreateFromUrlW(pszurl.param().abi(), core::mem::transmute(pszpath), pcchpath, dwflags).ok()
}
#[inline]
pub unsafe fn PathFileExistsA<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFileExistsA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathFileExistsA(pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn PathFileExistsW<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFileExistsW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathFileExistsW(pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn PathFindExtensionA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindExtensionA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    PathFindExtensionA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindExtensionW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindExtensionW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathFindExtensionW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindFileNameA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindFileNameA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    PathFindFileNameA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindFileNameW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindFileNameW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathFindFileNameW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindNextComponentA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindNextComponentA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    PathFindNextComponentA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindNextComponentW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindNextComponentW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathFindNextComponentW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathFindOnPathA(pszpath: &mut [u8; 260], ppszotherdirs: Option<*const *const i8>) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathFindOnPathA(pszpath : windows_core::PSTR, ppszotherdirs : *const *const i8) -> super::super::Foundation:: BOOL);
    PathFindOnPathA(core::mem::transmute(pszpath.as_ptr()), core::mem::transmute(ppszotherdirs.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn PathFindOnPathW(pszpath: &mut [u16; 260], ppszotherdirs: Option<*const *const u16>) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathFindOnPathW(pszpath : windows_core::PWSTR, ppszotherdirs : *const *const u16) -> super::super::Foundation:: BOOL);
    PathFindOnPathW(core::mem::transmute(pszpath.as_ptr()), core::mem::transmute(ppszotherdirs.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn PathFindSuffixArrayA<P0>(pszpath: P0, apszsuffix: &[windows_core::PCSTR]) -> windows_core::PCSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindSuffixArrayA(pszpath : windows_core::PCSTR, apszsuffix : *const windows_core::PCSTR, iarraysize : i32) -> windows_core::PCSTR);
    PathFindSuffixArrayA(pszpath.param().abi(), core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathFindSuffixArrayW<P0>(pszpath: P0, apszsuffix: &[windows_core::PCWSTR]) -> windows_core::PCWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathFindSuffixArrayW(pszpath : windows_core::PCWSTR, apszsuffix : *const windows_core::PCWSTR, iarraysize : i32) -> windows_core::PCWSTR);
    PathFindSuffixArrayW(pszpath.param().abi(), core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathGetArgsA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathGetArgsA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    PathGetArgsA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathGetArgsW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathGetArgsW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathGetArgsW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathGetCharTypeA(ch: u8) -> u32 {
    windows_targets::link!("shlwapi.dll" "system" fn PathGetCharTypeA(ch : u8) -> u32);
    PathGetCharTypeA(ch)
}
#[inline]
pub unsafe fn PathGetCharTypeW(ch: u16) -> u32 {
    windows_targets::link!("shlwapi.dll" "system" fn PathGetCharTypeW(ch : u16) -> u32);
    PathGetCharTypeW(ch)
}
#[inline]
pub unsafe fn PathGetDriveNumberA<P0>(pszpath: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathGetDriveNumberA(pszpath : windows_core::PCSTR) -> i32);
    PathGetDriveNumberA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathGetDriveNumberW<P0>(pszpath: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathGetDriveNumberW(pszpath : windows_core::PCWSTR) -> i32);
    PathGetDriveNumberW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathGetShortPath(pszlongpath: &mut [u16; 260]) {
    windows_targets::link!("shell32.dll" "system" fn PathGetShortPath(pszlongpath : windows_core::PWSTR));
    PathGetShortPath(core::mem::transmute(pszlongpath.as_ptr()))
}
#[inline]
pub unsafe fn PathIsContentTypeA<P0, P1>(pszpath: P0, pszcontenttype: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsContentTypeA(pszpath : windows_core::PCSTR, pszcontenttype : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsContentTypeA(pszpath.param().abi(), pszcontenttype.param().abi())
}
#[inline]
pub unsafe fn PathIsContentTypeW<P0, P1>(pszpath: P0, pszcontenttype: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsContentTypeW(pszpath : windows_core::PCWSTR, pszcontenttype : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsContentTypeW(pszpath.param().abi(), pszcontenttype.param().abi())
}
#[inline]
pub unsafe fn PathIsDirectoryA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsDirectoryA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsDirectoryA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsDirectoryEmptyA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsDirectoryEmptyA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsDirectoryEmptyA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsDirectoryEmptyW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsDirectoryEmptyW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsDirectoryEmptyW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsDirectoryW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsDirectoryW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsDirectoryW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsExe<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathIsExe(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsExe(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsFileSpecA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsFileSpecA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsFileSpecA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsFileSpecW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsFileSpecW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsFileSpecW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsLFNFileSpecA<P0>(pszname: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsLFNFileSpecA(pszname : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsLFNFileSpecA(pszname.param().abi())
}
#[inline]
pub unsafe fn PathIsLFNFileSpecW<P0>(pszname: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsLFNFileSpecW(pszname : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsLFNFileSpecW(pszname.param().abi())
}
#[inline]
pub unsafe fn PathIsNetworkPathA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsNetworkPathA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsNetworkPathA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsNetworkPathW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsNetworkPathW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsNetworkPathW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsPrefixA<P0, P1>(pszprefix: P0, pszpath: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsPrefixA(pszprefix : windows_core::PCSTR, pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsPrefixA(pszprefix.param().abi(), pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsPrefixW<P0, P1>(pszprefix: P0, pszpath: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsPrefixW(pszprefix : windows_core::PCWSTR, pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsPrefixW(pszprefix.param().abi(), pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsRelativeA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsRelativeA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsRelativeA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsRelativeW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsRelativeW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsRelativeW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsRootA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsRootA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsRootA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsRootW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsRootW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsRootW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsSameRootA<P0, P1>(pszpath1: P0, pszpath2: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsSameRootA(pszpath1 : windows_core::PCSTR, pszpath2 : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsSameRootA(pszpath1.param().abi(), pszpath2.param().abi())
}
#[inline]
pub unsafe fn PathIsSameRootW<P0, P1>(pszpath1: P0, pszpath2: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsSameRootW(pszpath1 : windows_core::PCWSTR, pszpath2 : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsSameRootW(pszpath1.param().abi(), pszpath2.param().abi())
}
#[inline]
pub unsafe fn PathIsSlowA<P0>(pszfile: P0, dwattr: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathIsSlowA(pszfile : windows_core::PCSTR, dwattr : u32) -> super::super::Foundation:: BOOL);
    PathIsSlowA(pszfile.param().abi(), dwattr)
}
#[inline]
pub unsafe fn PathIsSlowW<P0>(pszfile: P0, dwattr: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathIsSlowW(pszfile : windows_core::PCWSTR, dwattr : u32) -> super::super::Foundation:: BOOL);
    PathIsSlowW(pszfile.param().abi(), dwattr)
}
#[inline]
pub unsafe fn PathIsSystemFolderA<P0>(pszpath: P0, dwattrb: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsSystemFolderA(pszpath : windows_core::PCSTR, dwattrb : u32) -> super::super::Foundation:: BOOL);
    PathIsSystemFolderA(pszpath.param().abi(), dwattrb)
}
#[inline]
pub unsafe fn PathIsSystemFolderW<P0>(pszpath: P0, dwattrb: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsSystemFolderW(pszpath : windows_core::PCWSTR, dwattrb : u32) -> super::super::Foundation:: BOOL);
    PathIsSystemFolderW(pszpath.param().abi(), dwattrb)
}
#[inline]
pub unsafe fn PathIsUNCA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsUNCEx<P0>(pszpath: P0, ppszserver: Option<*mut windows_core::PCWSTR>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathIsUNCEx(pszpath : windows_core::PCWSTR, ppszserver : *mut windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCEx(pszpath.param().abi(), core::mem::transmute(ppszserver.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn PathIsUNCServerA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCServerA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCServerA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsUNCServerShareA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCServerShareA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCServerShareA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsUNCServerShareW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCServerShareW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCServerShareW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsUNCServerW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCServerW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCServerW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsUNCW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsUNCW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsUNCW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsURLA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsURLA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathIsURLA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathIsURLW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathIsURLW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathIsURLW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathMakePrettyA(pszpath: windows_core::PSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathMakePrettyA(pszpath : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    PathMakePrettyA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathMakePrettyW(pszpath: windows_core::PWSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathMakePrettyW(pszpath : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    PathMakePrettyW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathMakeSystemFolderA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMakeSystemFolderA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathMakeSystemFolderA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathMakeSystemFolderW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMakeSystemFolderW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathMakeSystemFolderW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathMakeUniqueName<P0, P1, P2>(pszuniquename: &mut [u16], psztemplate: P0, pszlongplate: P1, pszdir: P2) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathMakeUniqueName(pszuniquename : windows_core::PWSTR, cchmax : u32, psztemplate : windows_core::PCWSTR, pszlongplate : windows_core::PCWSTR, pszdir : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathMakeUniqueName(core::mem::transmute(pszuniquename.as_ptr()), pszuniquename.len().try_into().unwrap(), psztemplate.param().abi(), pszlongplate.param().abi(), pszdir.param().abi())
}
#[inline]
pub unsafe fn PathMatchSpecA<P0, P1>(pszfile: P0, pszspec: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMatchSpecA(pszfile : windows_core::PCSTR, pszspec : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathMatchSpecA(pszfile.param().abi(), pszspec.param().abi())
}
#[inline]
pub unsafe fn PathMatchSpecExA<P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMatchSpecExA(pszfile : windows_core::PCSTR, pszspec : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    PathMatchSpecExA(pszfile.param().abi(), pszspec.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PathMatchSpecExW<P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMatchSpecExW(pszfile : windows_core::PCWSTR, pszspec : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    PathMatchSpecExW(pszfile.param().abi(), pszspec.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PathMatchSpecW<P0, P1>(pszfile: P0, pszspec: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathMatchSpecW(pszfile : windows_core::PCWSTR, pszspec : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathMatchSpecW(pszfile.param().abi(), pszspec.param().abi())
}
#[inline]
pub unsafe fn PathParseIconLocationA(psziconfile: windows_core::PSTR) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn PathParseIconLocationA(psziconfile : windows_core::PSTR) -> i32);
    PathParseIconLocationA(core::mem::transmute(psziconfile))
}
#[inline]
pub unsafe fn PathParseIconLocationW(psziconfile: windows_core::PWSTR) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn PathParseIconLocationW(psziconfile : windows_core::PWSTR) -> i32);
    PathParseIconLocationW(core::mem::transmute(psziconfile))
}
#[inline]
pub unsafe fn PathQualify(psz: windows_core::PWSTR) {
    windows_targets::link!("shell32.dll" "system" fn PathQualify(psz : windows_core::PWSTR));
    PathQualify(core::mem::transmute(psz))
}
#[inline]
pub unsafe fn PathQuoteSpacesA(lpsz: &mut [u8; 260]) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathQuoteSpacesA(lpsz : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    PathQuoteSpacesA(core::mem::transmute(lpsz.as_ptr()))
}
#[inline]
pub unsafe fn PathQuoteSpacesW(lpsz: &mut [u16; 260]) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathQuoteSpacesW(lpsz : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    PathQuoteSpacesW(core::mem::transmute(lpsz.as_ptr()))
}
#[inline]
pub unsafe fn PathRelativePathToA<P0, P1>(pszpath: &mut [u8; 260], pszfrom: P0, dwattrfrom: u32, pszto: P1, dwattrto: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathRelativePathToA(pszpath : windows_core::PSTR, pszfrom : windows_core::PCSTR, dwattrfrom : u32, pszto : windows_core::PCSTR, dwattrto : u32) -> super::super::Foundation:: BOOL);
    PathRelativePathToA(core::mem::transmute(pszpath.as_ptr()), pszfrom.param().abi(), dwattrfrom, pszto.param().abi(), dwattrto)
}
#[inline]
pub unsafe fn PathRelativePathToW<P0, P1>(pszpath: &mut [u16; 260], pszfrom: P0, dwattrfrom: u32, pszto: P1, dwattrto: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathRelativePathToW(pszpath : windows_core::PWSTR, pszfrom : windows_core::PCWSTR, dwattrfrom : u32, pszto : windows_core::PCWSTR, dwattrto : u32) -> super::super::Foundation:: BOOL);
    PathRelativePathToW(core::mem::transmute(pszpath.as_ptr()), pszfrom.param().abi(), dwattrfrom, pszto.param().abi(), dwattrto)
}
#[inline]
pub unsafe fn PathRemoveArgsA(pszpath: windows_core::PSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveArgsA(pszpath : windows_core::PSTR));
    PathRemoveArgsA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveArgsW(pszpath: windows_core::PWSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveArgsW(pszpath : windows_core::PWSTR));
    PathRemoveArgsW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveBackslashA(pszpath: windows_core::PSTR) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveBackslashA(pszpath : windows_core::PSTR) -> windows_core::PSTR);
    PathRemoveBackslashA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveBackslashW(pszpath: windows_core::PWSTR) -> windows_core::PWSTR {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveBackslashW(pszpath : windows_core::PWSTR) -> windows_core::PWSTR);
    PathRemoveBackslashW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveBlanksA(pszpath: windows_core::PSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveBlanksA(pszpath : windows_core::PSTR));
    PathRemoveBlanksA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveBlanksW(pszpath: windows_core::PWSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveBlanksW(pszpath : windows_core::PWSTR));
    PathRemoveBlanksW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveExtensionA(pszpath: windows_core::PSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveExtensionA(pszpath : windows_core::PSTR));
    PathRemoveExtensionA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveExtensionW(pszpath: windows_core::PWSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveExtensionW(pszpath : windows_core::PWSTR));
    PathRemoveExtensionW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveFileSpecA(pszpath: windows_core::PSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveFileSpecA(pszpath : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    PathRemoveFileSpecA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRemoveFileSpecW(pszpath: windows_core::PWSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathRemoveFileSpecW(pszpath : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    PathRemoveFileSpecW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathRenameExtensionA<P0>(pszpath: &mut [u8; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathRenameExtensionA(pszpath : windows_core::PSTR, pszext : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathRenameExtensionA(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi())
}
#[inline]
pub unsafe fn PathRenameExtensionW<P0>(pszpath: &mut [u16; 260], pszext: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathRenameExtensionW(pszpath : windows_core::PWSTR, pszext : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathRenameExtensionW(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi())
}
#[inline]
pub unsafe fn PathResolve(pszpath: &mut [u16; 260], dirs: Option<*const *const u16>, fflags: PRF_FLAGS) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn PathResolve(pszpath : windows_core::PWSTR, dirs : *const *const u16, fflags : u32) -> i32);
    PathResolve(core::mem::transmute(pszpath.as_ptr()), core::mem::transmute(dirs.unwrap_or(std::ptr::null())), fflags.0 as _)
}
#[inline]
pub unsafe fn PathSearchAndQualifyA<P0>(pszpath: P0, pszbuf: &mut [u8]) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSearchAndQualifyA(pszpath : windows_core::PCSTR, pszbuf : windows_core::PSTR, cchbuf : u32) -> super::super::Foundation:: BOOL);
    PathSearchAndQualifyA(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathSearchAndQualifyW<P0>(pszpath: P0, pszbuf: &mut [u16]) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSearchAndQualifyW(pszpath : windows_core::PCWSTR, pszbuf : windows_core::PWSTR, cchbuf : u32) -> super::super::Foundation:: BOOL);
    PathSearchAndQualifyW(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathSetDlgItemPathA<P0, P1>(hdlg: P0, id: i32, pszpath: P1)
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSetDlgItemPathA(hdlg : super::super::Foundation:: HWND, id : i32, pszpath : windows_core::PCSTR));
    PathSetDlgItemPathA(hdlg.param().abi(), id, pszpath.param().abi())
}
#[inline]
pub unsafe fn PathSetDlgItemPathW<P0, P1>(hdlg: P0, id: i32, pszpath: P1)
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSetDlgItemPathW(hdlg : super::super::Foundation:: HWND, id : i32, pszpath : windows_core::PCWSTR));
    PathSetDlgItemPathW(hdlg.param().abi(), id, pszpath.param().abi())
}
#[inline]
pub unsafe fn PathSkipRootA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSkipRootA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    PathSkipRootA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathSkipRootW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathSkipRootW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    PathSkipRootW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathStripPathA(pszpath: windows_core::PSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathStripPathA(pszpath : windows_core::PSTR));
    PathStripPathA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathStripPathW(pszpath: windows_core::PWSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathStripPathW(pszpath : windows_core::PWSTR));
    PathStripPathW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathStripToRootA(pszpath: windows_core::PSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathStripToRootA(pszpath : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    PathStripToRootA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathStripToRootW(pszpath: windows_core::PWSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathStripToRootW(pszpath : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    PathStripToRootW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathUnExpandEnvStringsA<P0>(pszpath: P0, pszbuf: &mut [u8]) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathUnExpandEnvStringsA(pszpath : windows_core::PCSTR, pszbuf : windows_core::PSTR, cchbuf : u32) -> super::super::Foundation:: BOOL);
    PathUnExpandEnvStringsA(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathUnExpandEnvStringsW<P0>(pszpath: P0, pszbuf: &mut [u16]) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathUnExpandEnvStringsW(pszpath : windows_core::PCWSTR, pszbuf : windows_core::PWSTR, cchbuf : u32) -> super::super::Foundation:: BOOL);
    PathUnExpandEnvStringsW(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn PathUndecorateA(pszpath: windows_core::PSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathUndecorateA(pszpath : windows_core::PSTR));
    PathUndecorateA(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathUndecorateW(pszpath: windows_core::PWSTR) {
    windows_targets::link!("shlwapi.dll" "system" fn PathUndecorateW(pszpath : windows_core::PWSTR));
    PathUndecorateW(core::mem::transmute(pszpath))
}
#[inline]
pub unsafe fn PathUnmakeSystemFolderA<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathUnmakeSystemFolderA(pszpath : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    PathUnmakeSystemFolderA(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathUnmakeSystemFolderW<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn PathUnmakeSystemFolderW(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathUnmakeSystemFolderW(pszpath.param().abi())
}
#[inline]
pub unsafe fn PathUnquoteSpacesA(lpsz: windows_core::PSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathUnquoteSpacesA(lpsz : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    PathUnquoteSpacesA(core::mem::transmute(lpsz))
}
#[inline]
pub unsafe fn PathUnquoteSpacesW(lpsz: windows_core::PWSTR) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn PathUnquoteSpacesW(lpsz : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    PathUnquoteSpacesW(core::mem::transmute(lpsz))
}
#[inline]
pub unsafe fn PathYetAnotherMakeUniqueName<P0, P1, P2>(pszuniquename: &mut [u16; 260], pszpath: P0, pszshort: P1, pszfilespec: P2) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn PathYetAnotherMakeUniqueName(pszuniquename : windows_core::PWSTR, pszpath : windows_core::PCWSTR, pszshort : windows_core::PCWSTR, pszfilespec : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    PathYetAnotherMakeUniqueName(core::mem::transmute(pszuniquename.as_ptr()), pszpath.param().abi(), pszshort.param().abi(), pszfilespec.param().abi())
}
#[inline]
pub unsafe fn PickIconDlg<P0>(hwnd: P0, psziconpath: &mut [u16], piiconindex: Option<*mut i32>) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn PickIconDlg(hwnd : super::super::Foundation:: HWND, psziconpath : windows_core::PWSTR, cchiconpath : u32, piiconindex : *mut i32) -> i32);
    PickIconDlg(hwnd.param().abi(), core::mem::transmute(psziconpath.as_ptr()), psziconpath.len().try_into().unwrap(), core::mem::transmute(piiconindex.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn PropVariantToStrRet(propvar: *const windows_core::PROPVARIANT, pstrret: *mut Common::STRRET) -> windows_core::Result<()> {
    windows_targets::link!("propsys.dll" "system" fn PropVariantToStrRet(propvar : *const core::mem::MaybeUninit < windows_core::PROPVARIANT >, pstrret : *mut Common:: STRRET) -> windows_core::HRESULT);
    PropVariantToStrRet(core::mem::transmute(propvar), pstrret).ok()
}
#[inline]
pub unsafe fn QISearch<T>(that: *mut core::ffi::c_void, pqit: *const QITAB) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shlwapi.dll" "system" fn QISearch(that : *mut core::ffi::c_void, pqit : *const QITAB, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    QISearch(that, pqit, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn ReadCabinetState(pcs: *mut CABINETSTATE, clength: i32) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn ReadCabinetState(pcs : *mut CABINETSTATE, clength : i32) -> super::super::Foundation:: BOOL);
    ReadCabinetState(pcs, clength)
}
#[inline]
pub unsafe fn RealDriveType<P0>(idrive: i32, foktohitnet: P0) -> i32
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn RealDriveType(idrive : i32, foktohitnet : super::super::Foundation:: BOOL) -> i32);
    RealDriveType(idrive, foktohitnet.param().abi())
}
#[inline]
pub unsafe fn RegisterAppConstrainedChangeNotification(routine: PAPPCONSTRAIN_CHANGE_ROUTINE, context: Option<*const core::ffi::c_void>, registration: *mut PAPPCONSTRAIN_REGISTRATION) -> u32 {
    windows_targets::link!("api-ms-win-core-psm-appnotify-l1-1-1.dll" "system" fn RegisterAppConstrainedChangeNotification(routine : PAPPCONSTRAIN_CHANGE_ROUTINE, context : *const core::ffi::c_void, registration : *mut PAPPCONSTRAIN_REGISTRATION) -> u32);
    RegisterAppConstrainedChangeNotification(routine, core::mem::transmute(context.unwrap_or(std::ptr::null())), registration)
}
#[inline]
pub unsafe fn RegisterAppStateChangeNotification(routine: PAPPSTATE_CHANGE_ROUTINE, context: Option<*const core::ffi::c_void>, registration: *mut PAPPSTATE_REGISTRATION) -> u32 {
    windows_targets::link!("api-ms-win-core-psm-appnotify-l1-1-0.dll" "system" fn RegisterAppStateChangeNotification(routine : PAPPSTATE_CHANGE_ROUTINE, context : *const core::ffi::c_void, registration : *mut PAPPSTATE_REGISTRATION) -> u32);
    RegisterAppStateChangeNotification(routine, core::mem::transmute(context.unwrap_or(std::ptr::null())), registration)
}
#[inline]
pub unsafe fn RegisterScaleChangeEvent<P0>(hevent: P0) -> windows_core::Result<usize>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn RegisterScaleChangeEvent(hevent : super::super::Foundation:: HANDLE, pdwcookie : *mut usize) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    RegisterScaleChangeEvent(hevent.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn RegisterScaleChangeNotifications<P0>(displaydevice: DISPLAY_DEVICE_TYPE, hwndnotify: P0, umsgnotify: u32) -> windows_core::Result<u32>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn RegisterScaleChangeNotifications(displaydevice : DISPLAY_DEVICE_TYPE, hwndnotify : super::super::Foundation:: HWND, umsgnotify : u32, pdwcookie : *mut u32) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    RegisterScaleChangeNotifications(displaydevice, hwndnotify.param().abi(), umsgnotify, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn RemoveWindowSubclass<P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("comctl32.dll" "system" fn RemoveWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize) -> super::super::Foundation:: BOOL);
    RemoveWindowSubclass(hwnd.param().abi(), pfnsubclass, uidsubclass)
}
#[inline]
pub unsafe fn RestartDialog<P0, P1>(hwnd: P0, pszprompt: P1, dwreturn: u32) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn RestartDialog(hwnd : super::super::Foundation:: HWND, pszprompt : windows_core::PCWSTR, dwreturn : u32) -> i32);
    RestartDialog(hwnd.param().abi(), pszprompt.param().abi(), dwreturn)
}
#[inline]
pub unsafe fn RestartDialogEx<P0, P1>(hwnd: P0, pszprompt: P1, dwreturn: u32, dwreasoncode: u32) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn RestartDialogEx(hwnd : super::super::Foundation:: HWND, pszprompt : windows_core::PCWSTR, dwreturn : u32, dwreasoncode : u32) -> i32);
    RestartDialogEx(hwnd.param().abi(), pszprompt.param().abi(), dwreturn, dwreasoncode)
}
#[inline]
pub unsafe fn RevokeScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, dwcookie: u32) -> windows_core::Result<()> {
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn RevokeScaleChangeNotifications(displaydevice : DISPLAY_DEVICE_TYPE, dwcookie : u32) -> windows_core::HRESULT);
    RevokeScaleChangeNotifications(displaydevice, dwcookie).ok()
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn SHAddFromPropSheetExtArray<P0, P1>(hpsxa: P0, lpfnaddpage: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: P1) -> u32
where
    P0: windows_core::Param<HPSXA>,
    P1: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("shell32.dll" "system" fn SHAddFromPropSheetExtArray(hpsxa : HPSXA, lpfnaddpage : super::Controls:: LPFNSVADDPROPSHEETPAGE, lparam : super::super::Foundation:: LPARAM) -> u32);
    SHAddFromPropSheetExtArray(hpsxa.param().abi(), lpfnaddpage, lparam.param().abi())
}
#[inline]
pub unsafe fn SHAddToRecentDocs(uflags: u32, pv: Option<*const core::ffi::c_void>) {
    windows_targets::link!("shell32.dll" "system" fn SHAddToRecentDocs(uflags : u32, pv : *const core::ffi::c_void));
    SHAddToRecentDocs(uflags, core::mem::transmute(pv.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn SHAlloc(cb: usize) -> *mut core::ffi::c_void {
    windows_targets::link!("shell32.dll" "system" fn SHAlloc(cb : usize) -> *mut core::ffi::c_void);
    SHAlloc(cb)
}
#[inline]
pub unsafe fn SHAllocShared(pvdata: Option<*const core::ffi::c_void>, dwsize: u32, dwprocessid: u32) -> super::super::Foundation::HANDLE {
    windows_targets::link!("shlwapi.dll" "system" fn SHAllocShared(pvdata : *const core::ffi::c_void, dwsize : u32, dwprocessid : u32) -> super::super::Foundation:: HANDLE);
    SHAllocShared(core::mem::transmute(pvdata.unwrap_or(std::ptr::null())), dwsize, dwprocessid)
}
#[inline]
pub unsafe fn SHAnsiToAnsi<P0>(pszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHAnsiToAnsi(pszsrc : windows_core::PCSTR, pszdst : windows_core::PSTR, cchbuf : i32) -> i32);
    SHAnsiToAnsi(pszsrc.param().abi(), core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHAnsiToUnicode<P0>(pszsrc: P0, pwszdst: &mut [u16]) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHAnsiToUnicode(pszsrc : windows_core::PCSTR, pwszdst : windows_core::PWSTR, cwchbuf : i32) -> i32);
    SHAnsiToUnicode(pszsrc.param().abi(), core::mem::transmute(pwszdst.as_ptr()), pwszdst.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHAppBarMessage(dwmessage: u32, pdata: *mut APPBARDATA) -> usize {
    windows_targets::link!("shell32.dll" "system" fn SHAppBarMessage(dwmessage : u32, pdata : *mut APPBARDATA) -> usize);
    SHAppBarMessage(dwmessage, pdata)
}
#[inline]
pub unsafe fn SHAssocEnumHandlers<P0>(pszextra: P0, affilter: ASSOC_FILTER) -> windows_core::Result<IEnumAssocHandlers>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHAssocEnumHandlers(pszextra : windows_core::PCWSTR, affilter : ASSOC_FILTER, ppenumhandler : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHAssocEnumHandlers(pszextra.param().abi(), affilter, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHAssocEnumHandlersForProtocolByApplication<P0, T>(protocol: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHAssocEnumHandlersForProtocolByApplication(protocol : windows_core::PCWSTR, riid : *const windows_core::GUID, enumhandlers : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHAssocEnumHandlersForProtocolByApplication(protocol.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHAutoComplete<P0>(hwndedit: P0, dwflags: SHELL_AUTOCOMPLETE_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHAutoComplete(hwndedit : super::super::Foundation:: HWND, dwflags : SHELL_AUTOCOMPLETE_FLAGS) -> windows_core::HRESULT);
    SHAutoComplete(hwndedit.param().abi(), dwflags).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToFolderIDListParent<P0, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHBindToFolderIDListParent(psfroot : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHBindToFolderIDListParent(psfroot.param().abi(), pidl, &T::IID, &mut result__, core::mem::transmute(ppidllast.unwrap_or(std::ptr::null_mut()))).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToFolderIDListParentEx<P0, P1, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppbc: P1, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHBindToFolderIDListParentEx(psfroot : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, ppbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHBindToFolderIDListParentEx(psfroot.param().abi(), pidl, ppbc.param().abi(), &T::IID, &mut result__, core::mem::transmute(ppidllast.unwrap_or(std::ptr::null_mut()))).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToObject<P0, P1, T>(psf: P0, pidl: *const Common::ITEMIDLIST, pbc: P1) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHBindToObject(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHBindToObject(psf.param().abi(), pidl, pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToParent<T>(pidl: *const Common::ITEMIDLIST, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHBindToParent(pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHBindToParent(pidl, &T::IID, &mut result__, core::mem::transmute(ppidllast.unwrap_or(std::ptr::null_mut()))).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBrowseForFolderA(lpbi: *const BROWSEINFOA) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn SHBrowseForFolderA(lpbi : *const BROWSEINFOA) -> *mut Common:: ITEMIDLIST);
    SHBrowseForFolderA(lpbi)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBrowseForFolderW(lpbi: *const BROWSEINFOW) -> *mut Common::ITEMIDLIST {
    windows_targets::link!("shell32.dll" "system" fn SHBrowseForFolderW(lpbi : *const BROWSEINFOW) -> *mut Common:: ITEMIDLIST);
    SHBrowseForFolderW(lpbi)
}
#[inline]
pub unsafe fn SHCLSIDFromString<P0>(psz: P0) -> windows_core::Result<windows_core::GUID>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCLSIDFromString(psz : windows_core::PCWSTR, pclsid : *mut windows_core::GUID) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCLSIDFromString(psz.param().abi(), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHChangeNotification_Lock<P0>(hchange: P0, dwprocid: u32, pppidl: Option<*mut *mut *mut Common::ITEMIDLIST>, plevent: Option<*mut i32>) -> super::super::Foundation::HANDLE
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotification_Lock(hchange : super::super::Foundation:: HANDLE, dwprocid : u32, pppidl : *mut *mut *mut Common:: ITEMIDLIST, plevent : *mut i32) -> super::super::Foundation:: HANDLE);
    SHChangeNotification_Lock(hchange.param().abi(), dwprocid, core::mem::transmute(pppidl.unwrap_or(std::ptr::null_mut())), core::mem::transmute(plevent.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHChangeNotification_Unlock<P0>(hlock: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotification_Unlock(hlock : super::super::Foundation:: HANDLE) -> super::super::Foundation:: BOOL);
    SHChangeNotification_Unlock(hlock.param().abi())
}
#[inline]
pub unsafe fn SHChangeNotify(weventid: SHCNE_ID, uflags: SHCNF_FLAGS, dwitem1: Option<*const core::ffi::c_void>, dwitem2: Option<*const core::ffi::c_void>) {
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotify(weventid : i32, uflags : SHCNF_FLAGS, dwitem1 : *const core::ffi::c_void, dwitem2 : *const core::ffi::c_void));
    SHChangeNotify(weventid.0 as _, uflags, core::mem::transmute(dwitem1.unwrap_or(std::ptr::null())), core::mem::transmute(dwitem2.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn SHChangeNotifyDeregister(ulid: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotifyDeregister(ulid : u32) -> super::super::Foundation:: BOOL);
    SHChangeNotifyDeregister(ulid)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHChangeNotifyRegister<P0>(hwnd: P0, fsources: SHCNRF_SOURCE, fevents: i32, wmsg: u32, centries: i32, pshcne: *const SHChangeNotifyEntry) -> u32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotifyRegister(hwnd : super::super::Foundation:: HWND, fsources : SHCNRF_SOURCE, fevents : i32, wmsg : u32, centries : i32, pshcne : *const SHChangeNotifyEntry) -> u32);
    SHChangeNotifyRegister(hwnd.param().abi(), fsources, fevents, wmsg, centries, pshcne)
}
#[inline]
pub unsafe fn SHChangeNotifyRegisterThread(status: SCNRT_STATUS) {
    windows_targets::link!("shell32.dll" "system" fn SHChangeNotifyRegisterThread(status : SCNRT_STATUS));
    SHChangeNotifyRegisterThread(status)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCloneSpecialIDList<P0, P1>(hwnd: P0, csidl: i32, fcreate: P1) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCloneSpecialIDList(hwnd : super::super::Foundation:: HWND, csidl : i32, fcreate : super::super::Foundation:: BOOL) -> *mut Common:: ITEMIDLIST);
    SHCloneSpecialIDList(hwnd.param().abi(), csidl, fcreate.param().abi())
}
#[inline]
pub unsafe fn SHCoCreateInstance<P0, P1, T>(pszclsid: P0, pclsid: Option<*const windows_core::GUID>, punkouter: P1) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCoCreateInstance(pszclsid : windows_core::PCWSTR, pclsid : *const windows_core::GUID, punkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCoCreateInstance(pszclsid.param().abi(), core::mem::transmute(pclsid.unwrap_or(std::ptr::null())), punkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCopyKeyA<P0, P1, P2>(hkeysrc: P0, pszsrcsubkey: P1, hkeydest: P2, freserved: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCopyKeyA(hkeysrc : super::super::System::Registry:: HKEY, pszsrcsubkey : windows_core::PCSTR, hkeydest : super::super::System::Registry:: HKEY, freserved : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHCopyKeyA(hkeysrc.param().abi(), pszsrcsubkey.param().abi(), hkeydest.param().abi(), freserved)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCopyKeyW<P0, P1, P2>(hkeysrc: P0, pszsrcsubkey: P1, hkeydest: P2, freserved: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCopyKeyW(hkeysrc : super::super::System::Registry:: HKEY, pszsrcsubkey : windows_core::PCWSTR, hkeydest : super::super::System::Registry:: HKEY, freserved : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHCopyKeyW(hkeysrc.param().abi(), pszsrcsubkey.param().abi(), hkeydest.param().abi(), freserved)
}
#[inline]
pub unsafe fn SHCreateAssociationRegistration<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateAssociationRegistration(riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateAssociationRegistration(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDataObject<P0, T>(pidlfolder: Option<*const Common::ITEMIDLIST>, apidl: Option<&[*const Common::ITEMIDLIST]>, pdtinner: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDataObject(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, pdtinner : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateDataObject(core::mem::transmute(pidlfolder.unwrap_or(std::ptr::null())), apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pdtinner.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDefaultContextMenu<T>(pdcm: *const DEFCONTEXTMENU) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDefaultContextMenu(pdcm : *const DEFCONTEXTMENU, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateDefaultContextMenu(pdcm, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHCreateDefaultExtractIcon<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDefaultExtractIcon(riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateDefaultExtractIcon(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHCreateDefaultPropertiesOp<P0>(psi: P0) -> windows_core::Result<IFileOperation>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDefaultPropertiesOp(psi : * mut core::ffi::c_void, ppfileop : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateDefaultPropertiesOp(psi.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHCreateDirectory<P0, P1>(hwnd: P0, pszpath: P1) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDirectory(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCWSTR) -> i32);
    SHCreateDirectory(hwnd.param().abi(), pszpath.param().abi())
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SHCreateDirectoryExA<P0, P1>(hwnd: P0, pszpath: P1, psa: Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDirectoryExA(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCSTR, psa : *const super::super::Security:: SECURITY_ATTRIBUTES) -> i32);
    SHCreateDirectoryExA(hwnd.param().abi(), pszpath.param().abi(), core::mem::transmute(psa.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SHCreateDirectoryExW<P0, P1>(hwnd: P0, pszpath: P1, psa: Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateDirectoryExW(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCWSTR, psa : *const super::super::Security:: SECURITY_ATTRIBUTES) -> i32);
    SHCreateDirectoryExW(hwnd.param().abi(), pszpath.param().abi(), core::mem::transmute(psa.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn SHCreateFileExtractIconW<P0, T>(pszfile: P0, dwfileattributes: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateFileExtractIconW(pszfile : windows_core::PCWSTR, dwfileattributes : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateFileExtractIconW(pszfile.param().abi(), dwfileattributes, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemFromIDList<T>(pidl: *const Common::ITEMIDLIST) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateItemFromIDList(pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateItemFromIDList(pidl, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromParsingName<P0, P1, T>(pszpath: P0, pbc: P1) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateItemFromParsingName(pszpath : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateItemFromParsingName(pszpath.param().abi(), pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromRelativeName<P0, P1, P2, T>(psiparent: P0, pszname: P1, pbc: P2) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellItem>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateItemFromRelativeName(psiparent : * mut core::ffi::c_void, pszname : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateItemFromRelativeName(psiparent.param().abi(), pszname.param().abi(), pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHCreateItemInKnownFolder<P0, T>(kfid: *const windows_core::GUID, dwkfflags: KNOWN_FOLDER_FLAG, pszitem: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateItemInKnownFolder(kfid : *const windows_core::GUID, dwkfflags : u32, pszitem : windows_core::PCWSTR, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateItemInKnownFolder(kfid, dwkfflags.0 as _, pszitem.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemWithParent<P0, T>(pidlparent: Option<*const Common::ITEMIDLIST>, psfparent: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateItemWithParent(pidlparent : *const Common:: ITEMIDLIST, psfparent : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppvitem : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateItemWithParent(core::mem::transmute(pidlparent.unwrap_or(std::ptr::null())), psfparent.param().abi(), pidl, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateMemStream(pinit: Option<&[u8]>) -> Option<super::super::System::Com::IStream> {
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateMemStream(pinit : *const u8, cbinit : u32) -> Option < super::super::System::Com:: IStream >);
    SHCreateMemStream(core::mem::transmute(pinit.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pinit.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[cfg(all(feature = "Win32_Security", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn SHCreateProcessAsUserW(pscpi: *mut SHCREATEPROCESSINFOW) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateProcessAsUserW(pscpi : *mut SHCREATEPROCESSINFOW) -> super::super::Foundation:: BOOL);
    SHCreateProcessAsUserW(pscpi).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCreatePropSheetExtArray<P0, P1>(hkey: P0, pszsubkey: P1, max_iface: u32) -> HPSXA
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreatePropSheetExtArray(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, max_iface : u32) -> HPSXA);
    SHCreatePropSheetExtArray(hkey.param().abi(), pszsubkey.param().abi(), max_iface)
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateQueryCancelAutoPlayMoniker() -> windows_core::Result<super::super::System::Com::IMoniker> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateQueryCancelAutoPlayMoniker(ppmoniker : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateQueryCancelAutoPlayMoniker(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Ole")]
#[inline]
pub unsafe fn SHCreateShellFolderView(pcsfv: *const SFV_CREATE) -> windows_core::Result<IShellView> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellFolderView(pcsfv : *const SFV_CREATE, ppsv : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateShellFolderView(pcsfv, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateShellFolderViewEx(pcsfv: *const CSFV) -> windows_core::Result<IShellView> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellFolderViewEx(pcsfv : *const CSFV, ppsv : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateShellFolderViewEx(pcsfv, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItem<P0>(pidlparent: Option<*const Common::ITEMIDLIST>, psfparent: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<IShellItem>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellItem(pidlparent : *const Common:: ITEMIDLIST, psfparent : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, ppsi : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateShellItem(core::mem::transmute(pidlparent.unwrap_or(std::ptr::null())), psfparent.param().abi(), pidl, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArray<P0>(pidlparent: Option<*const Common::ITEMIDLIST>, psf: P0, ppidl: Option<&[*const Common::ITEMIDLIST]>) -> windows_core::Result<IShellItemArray>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellItemArray(pidlparent : *const Common:: ITEMIDLIST, psf : * mut core::ffi::c_void, cidl : u32, ppidl : *const *const Common:: ITEMIDLIST, ppsiitemarray : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateShellItemArray(core::mem::transmute(pidlparent.unwrap_or(std::ptr::null())), psf.param().abi(), ppidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ppidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromDataObject<P0, T>(pdo: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromDataObject(pdo : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateShellItemArrayFromDataObject(pdo.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromIDLists(rgpidl: &[*const Common::ITEMIDLIST]) -> windows_core::Result<IShellItemArray> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromIDLists(cidl : u32, rgpidl : *const *const Common:: ITEMIDLIST, ppsiitemarray : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateShellItemArrayFromIDLists(rgpidl.len().try_into().unwrap(), core::mem::transmute(rgpidl.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHCreateShellItemArrayFromShellItem<P0, T>(psi: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellItem>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromShellItem(psi : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHCreateShellItemArrayFromShellItem(psi.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn SHCreateShellPalette<P0>(hdc: P0) -> super::super::Graphics::Gdi::HPALETTE
where
    P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateShellPalette(hdc : super::super::Graphics::Gdi:: HDC) -> super::super::Graphics::Gdi:: HPALETTE);
    SHCreateShellPalette(hdc.param().abi())
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStdEnumFmtEtc(afmt: &[super::super::System::Com::FORMATETC]) -> windows_core::Result<super::super::System::Com::IEnumFORMATETC> {
    windows_targets::link!("shell32.dll" "system" fn SHCreateStdEnumFmtEtc(cfmt : u32, afmt : *const super::super::System::Com:: FORMATETC, ppenumformatetc : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateStdEnumFmtEtc(afmt.len().try_into().unwrap(), core::mem::transmute(afmt.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileA<P0>(pszfile: P0, grfmode: u32) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileA(pszfile : windows_core::PCSTR, grfmode : u32, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateStreamOnFileA(pszfile.param().abi(), grfmode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileEx<P0, P1, P2>(pszfile: P0, grfmode: u32, dwattributes: u32, fcreate: P1, pstmtemplate: P2) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
    P2: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileEx(pszfile : windows_core::PCWSTR, grfmode : u32, dwattributes : u32, fcreate : super::super::Foundation:: BOOL, pstmtemplate : * mut core::ffi::c_void, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateStreamOnFileEx(pszfile.param().abi(), grfmode, dwattributes, fcreate.param().abi(), pstmtemplate.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileW<P0>(pszfile: P0, grfmode: u32) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileW(pszfile : windows_core::PCWSTR, grfmode : u32, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHCreateStreamOnFileW(pszfile.param().abi(), grfmode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn SHCreateThread(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: Option<*const core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateThread(pfnthreadproc : super::super::System::Threading:: LPTHREAD_START_ROUTINE, pdata : *const core::ffi::c_void, flags : u32, pfncallback : super::super::System::Threading:: LPTHREAD_START_ROUTINE) -> super::super::Foundation:: BOOL);
    SHCreateThread(pfnthreadproc, core::mem::transmute(pdata.unwrap_or(std::ptr::null())), flags, pfncallback).ok()
}
#[inline]
pub unsafe fn SHCreateThreadRef(pcref: *mut i32, ppunk: *mut Option<windows_core::IUnknown>) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateThreadRef(pcref : *mut i32, ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    SHCreateThreadRef(pcref, core::mem::transmute(ppunk)).ok()
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn SHCreateThreadWithHandle(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: Option<*const core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE, phandle: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHCreateThreadWithHandle(pfnthreadproc : super::super::System::Threading:: LPTHREAD_START_ROUTINE, pdata : *const core::ffi::c_void, flags : u32, pfncallback : super::super::System::Threading:: LPTHREAD_START_ROUTINE, phandle : *mut super::super::Foundation:: HANDLE) -> super::super::Foundation:: BOOL);
    SHCreateThreadWithHandle(pfnthreadproc, core::mem::transmute(pdata.unwrap_or(std::ptr::null())), flags, pfncallback, core::mem::transmute(phandle.unwrap_or(std::ptr::null_mut()))).ok()
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconA<P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHDefExtractIconA(psziconfile : windows_core::PCSTR, iindex : i32, uflags : u32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, niconsize : u32) -> windows_core::HRESULT);
    SHDefExtractIconA(psziconfile.param().abi(), iindex, uflags, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), niconsize)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconW<P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHDefExtractIconW(psziconfile : windows_core::PCWSTR, iindex : i32, uflags : u32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, niconsize : u32) -> windows_core::HRESULT);
    SHDefExtractIconW(psziconfile.param().abi(), iindex, uflags, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), niconsize)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteEmptyKeyA<P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteEmptyKeyA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteEmptyKeyA(hkey.param().abi(), pszsubkey.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteEmptyKeyW<P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteEmptyKeyW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteEmptyKeyW(hkey.param().abi(), pszsubkey.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteKeyA<P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteKeyA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteKeyA(hkey.param().abi(), pszsubkey.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteKeyW<P0, P1>(hkey: P0, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteKeyW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteKeyW(hkey.param().abi(), pszsubkey.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteValueA<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteValueA(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteValueW<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHDeleteValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    SHDeleteValueW(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi())
}
#[inline]
pub unsafe fn SHDestroyPropSheetExtArray<P0>(hpsxa: P0)
where
    P0: windows_core::Param<HPSXA>,
{
    windows_targets::link!("shell32.dll" "system" fn SHDestroyPropSheetExtArray(hpsxa : HPSXA));
    SHDestroyPropSheetExtArray(hpsxa.param().abi())
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
#[inline]
pub unsafe fn SHDoDragDrop<P0, P1, P2>(hwnd: P0, pdata: P1, pdsrc: P2, dweffect: super::super::System::Ole::DROPEFFECT) -> windows_core::Result<super::super::System::Ole::DROPEFFECT>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::System::Com::IDataObject>,
    P2: windows_core::Param<super::super::System::Ole::IDropSource>,
{
    windows_targets::link!("shell32.dll" "system" fn SHDoDragDrop(hwnd : super::super::Foundation:: HWND, pdata : * mut core::ffi::c_void, pdsrc : * mut core::ffi::c_void, dweffect : super::super::System::Ole:: DROPEFFECT, pdweffect : *mut super::super::System::Ole:: DROPEFFECT) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHDoDragDrop(hwnd.param().abi(), pdata.param().abi(), pdsrc.param().abi(), dweffect, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHEmptyRecycleBinA<P0, P1>(hwnd: P0, pszrootpath: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHEmptyRecycleBinA(hwnd : super::super::Foundation:: HWND, pszrootpath : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    SHEmptyRecycleBinA(hwnd.param().abi(), pszrootpath.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn SHEmptyRecycleBinW<P0, P1>(hwnd: P0, pszrootpath: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHEmptyRecycleBinW(hwnd : super::super::Foundation:: HWND, pszrootpath : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    SHEmptyRecycleBinW(hwnd.param().abi(), pszrootpath.param().abi(), dwflags).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumKeyExA<P0>(hkey: P0, dwindex: u32, pszname: windows_core::PSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHEnumKeyExA(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszname : windows_core::PSTR, pcchname : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHEnumKeyExA(hkey.param().abi(), dwindex, core::mem::transmute(pszname), pcchname)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumKeyExW<P0>(hkey: P0, dwindex: u32, pszname: windows_core::PWSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHEnumKeyExW(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszname : windows_core::PWSTR, pcchname : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHEnumKeyExW(hkey.param().abi(), dwindex, core::mem::transmute(pszname), pcchname)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumValueA<P0>(hkey: P0, dwindex: u32, pszvaluename: windows_core::PSTR, pcchvaluename: Option<*mut u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHEnumValueA(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszvaluename : windows_core::PSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHEnumValueA(hkey.param().abi(), dwindex, core::mem::transmute(pszvaluename), core::mem::transmute(pcchvaluename.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumValueW<P0>(hkey: P0, dwindex: u32, pszvaluename: windows_core::PWSTR, pcchvaluename: Option<*mut u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHEnumValueW(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszvaluename : windows_core::PWSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHEnumValueW(hkey.param().abi(), dwindex, core::mem::transmute(pszvaluename), core::mem::transmute(pcchvaluename.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumerateUnreadMailAccountsW<P0>(hkeyuser: P0, dwindex: u32, pszmailaddress: &mut [u16]) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shell32.dll" "system" fn SHEnumerateUnreadMailAccountsW(hkeyuser : super::super::System::Registry:: HKEY, dwindex : u32, pszmailaddress : windows_core::PWSTR, cchmailaddress : i32) -> windows_core::HRESULT);
    SHEnumerateUnreadMailAccountsW(hkeyuser.param().abi(), dwindex, core::mem::transmute(pszmailaddress.as_ptr()), pszmailaddress.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn SHEvaluateSystemCommandTemplate<P0>(pszcmdtemplate: P0, ppszapplication: *mut windows_core::PWSTR, ppszcommandline: Option<*mut windows_core::PWSTR>, ppszparameters: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHEvaluateSystemCommandTemplate(pszcmdtemplate : windows_core::PCWSTR, ppszapplication : *mut windows_core::PWSTR, ppszcommandline : *mut windows_core::PWSTR, ppszparameters : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    SHEvaluateSystemCommandTemplate(pszcmdtemplate.param().abi(), ppszapplication, core::mem::transmute(ppszcommandline.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppszparameters.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn SHFileOperationA(lpfileop: *mut SHFILEOPSTRUCTA) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn SHFileOperationA(lpfileop : *mut SHFILEOPSTRUCTA) -> i32);
    SHFileOperationA(lpfileop)
}
#[inline]
pub unsafe fn SHFileOperationW(lpfileop: *mut SHFILEOPSTRUCTW) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn SHFileOperationW(lpfileop : *mut SHFILEOPSTRUCTW) -> i32);
    SHFileOperationW(lpfileop)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHFindFiles(pidlfolder: Option<*const Common::ITEMIDLIST>, pidlsavefile: Option<*const Common::ITEMIDLIST>) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SHFindFiles(pidlfolder : *const Common:: ITEMIDLIST, pidlsavefile : *const Common:: ITEMIDLIST) -> super::super::Foundation:: BOOL);
    SHFindFiles(core::mem::transmute(pidlfolder.unwrap_or(std::ptr::null())), core::mem::transmute(pidlsavefile.unwrap_or(std::ptr::null())))
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHFind_InitMenuPopup<P0, P1>(hmenu: P0, hwndowner: P1, idcmdfirst: u32, idcmdlast: u32) -> Option<IContextMenu>
where
    P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHFind_InitMenuPopup(hmenu : super::WindowsAndMessaging:: HMENU, hwndowner : super::super::Foundation:: HWND, idcmdfirst : u32, idcmdlast : u32) -> Option < IContextMenu >);
    SHFind_InitMenuPopup(hmenu.param().abi(), hwndowner.param().abi(), idcmdfirst, idcmdlast)
}
#[inline]
pub unsafe fn SHFlushSFCache() {
    windows_targets::link!("shell32.dll" "system" fn SHFlushSFCache());
    SHFlushSFCache()
}
#[inline]
pub unsafe fn SHFormatDateTimeA(pft: *const super::super::Foundation::FILETIME, pdwflags: Option<*mut u32>, pszbuf: &mut [u8]) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn SHFormatDateTimeA(pft : *const super::super::Foundation:: FILETIME, pdwflags : *mut u32, pszbuf : windows_core::PSTR, cchbuf : u32) -> i32);
    SHFormatDateTimeA(pft, core::mem::transmute(pdwflags.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHFormatDateTimeW(pft: *const super::super::Foundation::FILETIME, pdwflags: Option<*mut u32>, pszbuf: &mut [u16]) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn SHFormatDateTimeW(pft : *const super::super::Foundation:: FILETIME, pdwflags : *mut u32, pszbuf : windows_core::PWSTR, cchbuf : u32) -> i32);
    SHFormatDateTimeW(pft, core::mem::transmute(pdwflags.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHFormatDrive<P0>(hwnd: P0, drive: u32, fmtid: SHFMT_ID, options: SHFMT_OPT) -> u32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHFormatDrive(hwnd : super::super::Foundation:: HWND, drive : u32, fmtid : SHFMT_ID, options : u32) -> u32);
    SHFormatDrive(hwnd.param().abi(), drive, fmtid, options.0 as _)
}
#[inline]
pub unsafe fn SHFree(pv: Option<*const core::ffi::c_void>) {
    windows_targets::link!("shell32.dll" "system" fn SHFree(pv : *const core::ffi::c_void));
    SHFree(core::mem::transmute(pv.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn SHFreeNameMappings<P0>(hnamemappings: P0)
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHFreeNameMappings(hnamemappings : super::super::Foundation:: HANDLE));
    SHFreeNameMappings(hnamemappings.param().abi())
}
#[inline]
pub unsafe fn SHFreeShared<P0>(hdata: P0, dwprocessid: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHFreeShared(hdata : super::super::Foundation:: HANDLE, dwprocessid : u32) -> super::super::Foundation:: BOOL);
    SHFreeShared(hdata.param().abi(), dwprocessid).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetAttributesFromDataObject<P0>(pdo: P0, dwattributemask: u32, pdwattributes: Option<*mut u32>, pcitems: Option<*mut u32>) -> windows_core::HRESULT
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetAttributesFromDataObject(pdo : * mut core::ffi::c_void, dwattributemask : u32, pdwattributes : *mut u32, pcitems : *mut u32) -> windows_core::HRESULT);
    SHGetAttributesFromDataObject(pdo.param().abi(), dwattributemask, core::mem::transmute(pdwattributes.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcitems.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListA<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut core::ffi::c_void, cb: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetDataFromIDListA(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, nformat : SHGDFIL_FORMAT, pv : *mut core::ffi::c_void, cb : i32) -> windows_core::HRESULT);
    SHGetDataFromIDListA(psf.param().abi(), pidl, nformat, pv, cb).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListW<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut core::ffi::c_void, cb: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetDataFromIDListW(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, nformat : SHGDFIL_FORMAT, pv : *mut core::ffi::c_void, cb : i32) -> windows_core::HRESULT);
    SHGetDataFromIDListW(psf.param().abi(), pidl, nformat, pv, cb).ok()
}
#[inline]
pub unsafe fn SHGetDesktopFolder() -> windows_core::Result<IShellFolder> {
    windows_targets::link!("shell32.dll" "system" fn SHGetDesktopFolder(ppshf : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetDesktopFolder(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExA<P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: Option<*mut u64>, pultotalnumberofbytes: Option<*mut u64>, pultotalnumberoffreebytes: Option<*mut u64>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetDiskFreeSpaceExA(pszdirectoryname : windows_core::PCSTR, pulfreebytesavailabletocaller : *mut u64, pultotalnumberofbytes : *mut u64, pultotalnumberoffreebytes : *mut u64) -> super::super::Foundation:: BOOL);
    SHGetDiskFreeSpaceExA(pszdirectoryname.param().abi(), core::mem::transmute(pulfreebytesavailabletocaller.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pultotalnumberofbytes.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pultotalnumberoffreebytes.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExW<P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: Option<*mut u64>, pultotalnumberofbytes: Option<*mut u64>, pultotalnumberoffreebytes: Option<*mut u64>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetDiskFreeSpaceExW(pszdirectoryname : windows_core::PCWSTR, pulfreebytesavailabletocaller : *mut u64, pultotalnumberofbytes : *mut u64, pultotalnumberoffreebytes : *mut u64) -> super::super::Foundation:: BOOL);
    SHGetDiskFreeSpaceExW(pszdirectoryname.param().abi(), core::mem::transmute(pulfreebytesavailabletocaller.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pultotalnumberofbytes.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pultotalnumberoffreebytes.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHGetDriveMedia<P0>(pszdrive: P0) -> windows_core::Result<u32>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetDriveMedia(pszdrive : windows_core::PCWSTR, pdwmediacontent : *mut u32) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetDriveMedia(pszdrive.param().abi(), &mut result__).map(|| result__)
}
#[cfg(all(feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoA<P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: Option<*mut SHFILEINFOA>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFileInfoA(pszpath : windows_core::PCSTR, dwfileattributes : super::super::Storage::FileSystem:: FILE_FLAGS_AND_ATTRIBUTES, psfi : *mut SHFILEINFOA, cbfileinfo : u32, uflags : SHGFI_FLAGS) -> usize);
    SHGetFileInfoA(pszpath.param().abi(), dwfileattributes, core::mem::transmute(psfi.unwrap_or(std::ptr::null_mut())), cbfileinfo, uflags)
}
#[cfg(all(feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoW<P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: Option<*mut SHFILEINFOW>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFileInfoW(pszpath : windows_core::PCWSTR, dwfileattributes : super::super::Storage::FileSystem:: FILE_FLAGS_AND_ATTRIBUTES, psfi : *mut SHFILEINFOW, cbfileinfo : u32, uflags : SHGFI_FLAGS) -> usize);
    SHGetFileInfoW(pszpath.param().abi(), dwfileattributes, core::mem::transmute(psfi.unwrap_or(std::ptr::null_mut())), cbfileinfo, uflags)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetFolderLocation<P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFolderLocation(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetFolderLocation(hwnd.param().abi(), csidl, htoken.param().abi(), dwflags, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetFolderPathA<P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszpath: &mut [u8; 260]) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFolderPathA(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PSTR) -> windows_core::HRESULT);
    SHGetFolderPathA(hwnd.param().abi(), csidl, htoken.param().abi(), dwflags, core::mem::transmute(pszpath.as_ptr())).ok()
}
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirA<P0, P1, P2>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszsubdir: P2, pszpath: &mut [u8; 260]) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFolderPathAndSubDirA(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszsubdir : windows_core::PCSTR, pszpath : windows_core::PSTR) -> windows_core::HRESULT);
    SHGetFolderPathAndSubDirA(hwnd.param().abi(), csidl, htoken.param().abi(), dwflags, pszsubdir.param().abi(), core::mem::transmute(pszpath.as_ptr())).ok()
}
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirW<P0, P1, P2>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszsubdir: P2, pszpath: &mut [u16; 260]) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFolderPathAndSubDirW(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszsubdir : windows_core::PCWSTR, pszpath : windows_core::PWSTR) -> windows_core::HRESULT);
    SHGetFolderPathAndSubDirW(hwnd.param().abi(), csidl, htoken.param().abi(), dwflags, pszsubdir.param().abi(), core::mem::transmute(pszpath.as_ptr())).ok()
}
#[inline]
pub unsafe fn SHGetFolderPathW<P0, P1>(hwnd: P0, csidl: i32, htoken: P1, dwflags: u32, pszpath: &mut [u16; 260]) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetFolderPathW(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PWSTR) -> windows_core::HRESULT);
    SHGetFolderPathW(hwnd.param().abi(), csidl, htoken.param().abi(), dwflags, core::mem::transmute(pszpath.as_ptr())).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetIDListFromObject<P0>(punk: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetIDListFromObject(punk : * mut core::ffi::c_void, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetIDListFromObject(punk.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetIconOverlayIndexA<P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetIconOverlayIndexA(psziconpath : windows_core::PCSTR, iiconindex : i32) -> i32);
    SHGetIconOverlayIndexA(psziconpath.param().abi(), iiconindex)
}
#[inline]
pub unsafe fn SHGetIconOverlayIndexW<P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetIconOverlayIndexW(psziconpath : windows_core::PCWSTR, iiconindex : i32) -> i32);
    SHGetIconOverlayIndexW(psziconpath.param().abi(), iiconindex)
}
#[inline]
pub unsafe fn SHGetImageList<T>(iimagelist: i32) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetImageList(iimagelist : i32, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHGetImageList(iimagelist, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetInstanceExplorer() -> windows_core::Result<windows_core::IUnknown> {
    windows_targets::link!("shell32.dll" "system" fn SHGetInstanceExplorer(ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetInstanceExplorer(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetInverseCMAP(pbmap: &mut [u8]) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHGetInverseCMAP(pbmap : *mut u8, cbmap : u32) -> windows_core::HRESULT);
    SHGetInverseCMAP(core::mem::transmute(pbmap.as_ptr()), pbmap.len().try_into().unwrap()).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetItemFromDataObject<P0, T>(pdtobj: P0, dwflags: DATAOBJ_GET_ITEM_FLAGS) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetItemFromDataObject(pdtobj : * mut core::ffi::c_void, dwflags : DATAOBJ_GET_ITEM_FLAGS, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHGetItemFromDataObject(pdtobj.param().abi(), dwflags, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetItemFromObject<P0, T>(punk: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetItemFromObject(punk : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHGetItemFromObject(punk.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetKnownFolderIDList<P0>(rfid: *const windows_core::GUID, dwflags: u32, htoken: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetKnownFolderIDList(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetKnownFolderIDList(rfid, dwflags, htoken.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetKnownFolderItem<P0, T>(rfid: *const windows_core::GUID, flags: KNOWN_FOLDER_FLAG, htoken: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetKnownFolderItem(rfid : *const windows_core::GUID, flags : KNOWN_FOLDER_FLAG, htoken : super::super::Foundation:: HANDLE, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHGetKnownFolderItem(rfid, flags, htoken.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetKnownFolderPath<P0>(rfid: *const windows_core::GUID, dwflags: KNOWN_FOLDER_FLAG, htoken: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetKnownFolderPath(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, ppszpath : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetKnownFolderPath(rfid, dwflags.0 as _, htoken.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetLocalizedName<P0>(pszpath: P0, pszresmodule: &mut [u16], pidsres: *mut i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetLocalizedName(pszpath : windows_core::PCWSTR, pszresmodule : windows_core::PWSTR, cch : u32, pidsres : *mut i32) -> windows_core::HRESULT);
    SHGetLocalizedName(pszpath.param().abi(), core::mem::transmute(pszresmodule.as_ptr()), pszresmodule.len().try_into().unwrap(), pidsres).ok()
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetMalloc() -> windows_core::Result<super::super::System::Com::IMalloc> {
    windows_targets::link!("shell32.dll" "system" fn SHGetMalloc(ppmalloc : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetMalloc(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetNameFromIDList(pidl: *const Common::ITEMIDLIST, sigdnname: SIGDN) -> windows_core::Result<windows_core::PWSTR> {
    windows_targets::link!("shell32.dll" "system" fn SHGetNameFromIDList(pidl : *const Common:: ITEMIDLIST, sigdnname : SIGDN, ppszname : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetNameFromIDList(pidl, sigdnname, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetNewLinkInfoA<P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u8; 260], pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetNewLinkInfoA(pszlinkto : windows_core::PCSTR, pszdir : windows_core::PCSTR, pszname : windows_core::PSTR, pfmustcopy : *mut super::super::Foundation:: BOOL, uflags : u32) -> super::super::Foundation:: BOOL);
    SHGetNewLinkInfoA(pszlinkto.param().abi(), pszdir.param().abi(), core::mem::transmute(pszname.as_ptr()), pfmustcopy, uflags)
}
#[inline]
pub unsafe fn SHGetNewLinkInfoW<P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u16; 260], pfmustcopy: *mut super::super::Foundation::BOOL, uflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetNewLinkInfoW(pszlinkto : windows_core::PCWSTR, pszdir : windows_core::PCWSTR, pszname : windows_core::PWSTR, pfmustcopy : *mut super::super::Foundation:: BOOL, uflags : u32) -> super::super::Foundation:: BOOL);
    SHGetNewLinkInfoW(pszlinkto.param().abi(), pszdir.param().abi(), core::mem::transmute(pszname.as_ptr()), pfmustcopy, uflags)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListA(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u8; 260]) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SHGetPathFromIDListA(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PSTR) -> super::super::Foundation:: BOOL);
    SHGetPathFromIDListA(pidl, core::mem::transmute(pszpath.as_ptr()))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListEx(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16], uopts: GPFIDL_FLAGS) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SHGetPathFromIDListEx(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PWSTR, cchpath : u32, uopts : GPFIDL_FLAGS) -> super::super::Foundation:: BOOL);
    SHGetPathFromIDListEx(pidl, core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), uopts)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListW(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16; 260]) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SHGetPathFromIDListW(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    SHGetPathFromIDListW(pidl, core::mem::transmute(pszpath.as_ptr()))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetRealIDL<P0>(psf: P0, pidlsimple: *const Common::ITEMIDLIST) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetRealIDL(psf : * mut core::ffi::c_void, pidlsimple : *const Common:: ITEMIDLIST, ppidlreal : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetRealIDL(psf.param().abi(), pidlsimple, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetSetFolderCustomSettings<P0>(pfcs: *mut SHFOLDERCUSTOMSETTINGS, pszpath: P0, dwreadwrite: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetSetFolderCustomSettings(pfcs : *mut SHFOLDERCUSTOMSETTINGS, pszpath : windows_core::PCWSTR, dwreadwrite : u32) -> windows_core::HRESULT);
    SHGetSetFolderCustomSettings(pfcs, pszpath.param().abi(), dwreadwrite).ok()
}
#[inline]
pub unsafe fn SHGetSetSettings<P0>(lpss: Option<*mut SHELLSTATEA>, dwmask: SSF_MASK, bset: P0)
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetSetSettings(lpss : *mut SHELLSTATEA, dwmask : SSF_MASK, bset : super::super::Foundation:: BOOL));
    SHGetSetSettings(core::mem::transmute(lpss.unwrap_or(std::ptr::null_mut())), dwmask, bset.param().abi())
}
#[inline]
pub unsafe fn SHGetSettings(psfs: *mut SHELLFLAGSTATE, dwmask: u32) {
    windows_targets::link!("shell32.dll" "system" fn SHGetSettings(psfs : *mut SHELLFLAGSTATE, dwmask : u32));
    SHGetSettings(psfs, dwmask)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetSpecialFolderLocation<P0>(hwnd: P0, csidl: i32) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetSpecialFolderLocation(hwnd : super::super::Foundation:: HWND, csidl : i32, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetSpecialFolderLocation(hwnd.param().abi(), csidl, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHGetSpecialFolderPathA<P0, P1>(hwnd: P0, pszpath: &mut [u8; 260], csidl: i32, fcreate: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetSpecialFolderPathA(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PSTR, csidl : i32, fcreate : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHGetSpecialFolderPathA(hwnd.param().abi(), core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.param().abi())
}
#[inline]
pub unsafe fn SHGetSpecialFolderPathW<P0, P1>(hwnd: P0, pszpath: &mut [u16; 260], csidl: i32, fcreate: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetSpecialFolderPathW(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PWSTR, csidl : i32, fcreate : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHGetSpecialFolderPathW(hwnd.param().abi(), core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHGetStockIconInfo(siid: SHSTOCKICONID, uflags: SHGSI_FLAGS, psii: *mut SHSTOCKICONINFO) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn SHGetStockIconInfo(siid : SHSTOCKICONID, uflags : SHGSI_FLAGS, psii : *mut SHSTOCKICONINFO) -> windows_core::HRESULT);
    SHGetStockIconInfo(siid, uflags, psii).ok()
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn SHGetTemporaryPropertyForItem<P0>(psi: P0, propkey: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<windows_core::PROPVARIANT>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetTemporaryPropertyForItem(psi : * mut core::ffi::c_void, propkey : *const PropertiesSystem:: PROPERTYKEY, ppropvar : *mut core::mem::MaybeUninit < windows_core::PROPVARIANT >) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetTemporaryPropertyForItem(psi.param().abi(), propkey, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGetThreadRef() -> windows_core::Result<windows_core::IUnknown> {
    windows_targets::link!("shlwapi.dll" "system" fn SHGetThreadRef(ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHGetThreadRef(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetUnreadMailCountW<P0, P1>(hkeyuser: P0, pszmailaddress: P1, pdwcount: Option<*mut u32>, pfiletime: Option<*mut super::super::Foundation::FILETIME>, pszshellexecutecommand: Option<&mut [u16]>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHGetUnreadMailCountW(hkeyuser : super::super::System::Registry:: HKEY, pszmailaddress : windows_core::PCWSTR, pdwcount : *mut u32, pfiletime : *mut super::super::Foundation:: FILETIME, pszshellexecutecommand : windows_core::PWSTR, cchshellexecutecommand : i32) -> windows_core::HRESULT);
    SHGetUnreadMailCountW(hkeyuser.param().abi(), pszmailaddress.param().abi(), core::mem::transmute(pdwcount.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pfiletime.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pszshellexecutecommand.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pszshellexecutecommand.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetValueA<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHGetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHGetValueA(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetValueW<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHGetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHGetValueW(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetViewStatePropertyBag<P0, T>(pidl: Option<*const Common::ITEMIDLIST>, pszbagname: P0, dwflags: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHGetViewStatePropertyBag(pidl : *const Common:: ITEMIDLIST, pszbagname : windows_core::PCWSTR, dwflags : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    SHGetViewStatePropertyBag(core::mem::transmute(pidl.unwrap_or(std::ptr::null())), pszbagname.param().abi(), dwflags, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn SHGlobalCounterDecrement(id: SHGLOBALCOUNTER) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn SHGlobalCounterDecrement(id : SHGLOBALCOUNTER) -> i32);
    SHGlobalCounterDecrement(id)
}
#[inline]
pub unsafe fn SHGlobalCounterGetValue(id: SHGLOBALCOUNTER) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn SHGlobalCounterGetValue(id : SHGLOBALCOUNTER) -> i32);
    SHGlobalCounterGetValue(id)
}
#[inline]
pub unsafe fn SHGlobalCounterIncrement(id: SHGLOBALCOUNTER) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn SHGlobalCounterIncrement(id : SHGLOBALCOUNTER) -> i32);
    SHGlobalCounterIncrement(id)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHHandleUpdateImage(pidlextra: *const Common::ITEMIDLIST) -> i32 {
    windows_targets::link!("shell32.dll" "system" fn SHHandleUpdateImage(pidlextra : *const Common:: ITEMIDLIST) -> i32);
    SHHandleUpdateImage(pidlextra)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHILCreateFromPath<P0>(pszpath: P0, ppidl: *mut *mut Common::ITEMIDLIST, rgfinout: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHILCreateFromPath(pszpath : windows_core::PCWSTR, ppidl : *mut *mut Common:: ITEMIDLIST, rgfinout : *mut u32) -> windows_core::HRESULT);
    SHILCreateFromPath(pszpath.param().abi(), ppidl, core::mem::transmute(rgfinout.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn SHInvokePrinterCommandA<P0, P1, P2, P3>(hwnd: P0, uaction: u32, lpbuf1: P1, lpbuf2: P2, fmodal: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHInvokePrinterCommandA(hwnd : super::super::Foundation:: HWND, uaction : u32, lpbuf1 : windows_core::PCSTR, lpbuf2 : windows_core::PCSTR, fmodal : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHInvokePrinterCommandA(hwnd.param().abi(), uaction, lpbuf1.param().abi(), lpbuf2.param().abi(), fmodal.param().abi())
}
#[inline]
pub unsafe fn SHInvokePrinterCommandW<P0, P1, P2, P3>(hwnd: P0, uaction: u32, lpbuf1: P1, lpbuf2: P2, fmodal: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shell32.dll" "system" fn SHInvokePrinterCommandW(hwnd : super::super::Foundation:: HWND, uaction : u32, lpbuf1 : windows_core::PCWSTR, lpbuf2 : windows_core::PCWSTR, fmodal : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHInvokePrinterCommandW(hwnd.param().abi(), uaction, lpbuf1.param().abi(), lpbuf2.param().abi(), fmodal.param().abi())
}
#[inline]
pub unsafe fn SHIsFileAvailableOffline<P0>(pwszpath: P0, pdwstatus: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHIsFileAvailableOffline(pwszpath : windows_core::PCWSTR, pdwstatus : *mut u32) -> windows_core::HRESULT);
    SHIsFileAvailableOffline(pwszpath.param().abi(), core::mem::transmute(pdwstatus.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn SHIsLowMemoryMachine(dwtype: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("shlwapi.dll" "system" fn SHIsLowMemoryMachine(dwtype : u32) -> super::super::Foundation:: BOOL);
    SHIsLowMemoryMachine(dwtype)
}
#[inline]
pub unsafe fn SHLimitInputEdit<P0, P1>(hwndedit: P0, psf: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHLimitInputEdit(hwndedit : super::super::Foundation:: HWND, psf : * mut core::ffi::c_void) -> windows_core::HRESULT);
    SHLimitInputEdit(hwndedit.param().abi(), psf.param().abi()).ok()
}
#[inline]
pub unsafe fn SHLoadInProc(rclsid: *const windows_core::GUID) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn SHLoadInProc(rclsid : *const windows_core::GUID) -> windows_core::HRESULT);
    SHLoadInProc(rclsid).ok()
}
#[inline]
pub unsafe fn SHLoadIndirectString<P0>(pszsource: P0, pszoutbuf: &mut [u16], ppvreserved: Option<*const *const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHLoadIndirectString(pszsource : windows_core::PCWSTR, pszoutbuf : windows_core::PWSTR, cchoutbuf : u32, ppvreserved : *const *const core::ffi::c_void) -> windows_core::HRESULT);
    SHLoadIndirectString(pszsource.param().abi(), core::mem::transmute(pszoutbuf.as_ptr()), pszoutbuf.len().try_into().unwrap(), core::mem::transmute(ppvreserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn SHLoadNonloadedIconOverlayIdentifiers() -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn SHLoadNonloadedIconOverlayIdentifiers() -> windows_core::HRESULT);
    SHLoadNonloadedIconOverlayIdentifiers().ok()
}
#[inline]
pub unsafe fn SHLockShared<P0>(hdata: P0, dwprocessid: u32) -> *mut core::ffi::c_void
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHLockShared(hdata : super::super::Foundation:: HANDLE, dwprocessid : u32) -> *mut core::ffi::c_void);
    SHLockShared(hdata.param().abi(), dwprocessid)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHMapPIDLToSystemImageListIndex<P0>(pshf: P0, pidl: *const Common::ITEMIDLIST, piindexsel: Option<*mut i32>) -> i32
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_targets::link!("shell32.dll" "system" fn SHMapPIDLToSystemImageListIndex(pshf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, piindexsel : *mut i32) -> i32);
    SHMapPIDLToSystemImageListIndex(pshf.param().abi(), pidl, core::mem::transmute(piindexsel.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHMessageBoxCheckA<P0, P1, P2, P3>(hwnd: P0, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P3) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHMessageBoxCheckA(hwnd : super::super::Foundation:: HWND, psztext : windows_core::PCSTR, pszcaption : windows_core::PCSTR, utype : u32, idefault : i32, pszregval : windows_core::PCSTR) -> i32);
    SHMessageBoxCheckA(hwnd.param().abi(), psztext.param().abi(), pszcaption.param().abi(), utype, idefault, pszregval.param().abi())
}
#[inline]
pub unsafe fn SHMessageBoxCheckW<P0, P1, P2, P3>(hwnd: P0, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P3) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHMessageBoxCheckW(hwnd : super::super::Foundation:: HWND, psztext : windows_core::PCWSTR, pszcaption : windows_core::PCWSTR, utype : u32, idefault : i32, pszregval : windows_core::PCWSTR) -> i32);
    SHMessageBoxCheckW(hwnd.param().abi(), psztext.param().abi(), pszcaption.param().abi(), utype, idefault, pszregval.param().abi())
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHMultiFileProperties<P0>(pdtobj: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_targets::link!("shell32.dll" "system" fn SHMultiFileProperties(pdtobj : * mut core::ffi::c_void, dwflags : u32) -> windows_core::HRESULT);
    SHMultiFileProperties(pdtobj.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn SHObjectProperties<P0, P1, P2>(hwnd: P0, shopobjecttype: SHOP_TYPE, pszobjectname: P1, pszpropertypage: P2) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHObjectProperties(hwnd : super::super::Foundation:: HWND, shopobjecttype : u32, pszobjectname : windows_core::PCWSTR, pszpropertypage : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    SHObjectProperties(hwnd.param().abi(), shopobjecttype.0 as _, pszobjectname.param().abi(), pszpropertypage.param().abi())
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHOpenFolderAndSelectItems(pidlfolder: *const Common::ITEMIDLIST, apidl: Option<&[*const Common::ITEMIDLIST]>, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn SHOpenFolderAndSelectItems(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, dwflags : u32) -> windows_core::HRESULT);
    SHOpenFolderAndSelectItems(pidlfolder, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), dwflags).ok()
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenPropSheetW<P0, P1, P2, P3>(pszcaption: P0, ahkeys: Option<&[super::super::System::Registry::HKEY]>, pclsiddefault: Option<*const windows_core::GUID>, pdtobj: P1, psb: P2, pstartpage: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IDataObject>,
    P2: windows_core::Param<IShellBrowser>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHOpenPropSheetW(pszcaption : windows_core::PCWSTR, ahkeys : *const super::super::System::Registry:: HKEY, ckeys : u32, pclsiddefault : *const windows_core::GUID, pdtobj : * mut core::ffi::c_void, psb : * mut core::ffi::c_void, pstartpage : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    SHOpenPropSheetW(pszcaption.param().abi(), core::mem::transmute(ahkeys.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ahkeys.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pclsiddefault.unwrap_or(std::ptr::null())), pdtobj.param().abi(), psb.param().abi(), pstartpage.param().abi())
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2A<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHOpenRegStream2A(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    SHOpenRegStream2A(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), grfmode)
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2W<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHOpenRegStream2W(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    SHOpenRegStream2W(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), grfmode)
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamA<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHOpenRegStreamA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    SHOpenRegStreamA(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), grfmode)
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamW<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHOpenRegStreamW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    SHOpenRegStreamW(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), grfmode)
}
#[inline]
pub unsafe fn SHOpenWithDialog<P0>(hwndparent: P0, poainfo: *const OPENASINFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHOpenWithDialog(hwndparent : super::super::Foundation:: HWND, poainfo : *const OPENASINFO) -> windows_core::HRESULT);
    SHOpenWithDialog(hwndparent.param().abi(), poainfo).ok()
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHParseDisplayName<P0, P1>(pszname: P0, pbc: P1, ppidl: *mut *mut Common::ITEMIDLIST, sfgaoin: u32, psfgaoout: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
{
    windows_targets::link!("shell32.dll" "system" fn SHParseDisplayName(pszname : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, ppidl : *mut *mut Common:: ITEMIDLIST, sfgaoin : u32, psfgaoout : *mut u32) -> windows_core::HRESULT);
    SHParseDisplayName(pszname.param().abi(), pbc.param().abi(), ppidl, sfgaoin, core::mem::transmute(psfgaoout.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn SHPathPrepareForWriteA<P0, P1, P2>(hwnd: P0, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::IUnknown>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHPathPrepareForWriteA(hwnd : super::super::Foundation:: HWND, punkenablemodless : * mut core::ffi::c_void, pszpath : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    SHPathPrepareForWriteA(hwnd.param().abi(), punkenablemodless.param().abi(), pszpath.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn SHPathPrepareForWriteW<P0, P1, P2>(hwnd: P0, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::IUnknown>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHPathPrepareForWriteW(hwnd : super::super::Foundation:: HWND, punkenablemodless : * mut core::ffi::c_void, pszpath : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    SHPathPrepareForWriteW(hwnd.param().abi(), punkenablemodless.param().abi(), pszpath.param().abi(), dwflags).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryInfoKeyA<P0>(hkey: P0, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHQueryInfoKeyA(hkey : super::super::System::Registry:: HKEY, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHQueryInfoKeyA(hkey.param().abi(), core::mem::transmute(pcsubkeys.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxsubkeylen.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcvalues.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryInfoKeyW<P0>(hkey: P0, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHQueryInfoKeyW(hkey : super::super::System::Registry:: HKEY, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHQueryInfoKeyW(hkey.param().abi(), core::mem::transmute(pcsubkeys.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxsubkeylen.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcvalues.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHQueryRecycleBinA<P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHQueryRecycleBinA(pszrootpath : windows_core::PCSTR, pshqueryrbinfo : *mut SHQUERYRBINFO) -> windows_core::HRESULT);
    SHQueryRecycleBinA(pszrootpath.param().abi(), pshqueryrbinfo).ok()
}
#[inline]
pub unsafe fn SHQueryRecycleBinW<P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHQueryRecycleBinW(pszrootpath : windows_core::PCWSTR, pshqueryrbinfo : *mut SHQUERYRBINFO) -> windows_core::HRESULT);
    SHQueryRecycleBinW(pszrootpath.param().abi(), pshqueryrbinfo).ok()
}
#[inline]
pub unsafe fn SHQueryUserNotificationState() -> windows_core::Result<QUERY_USER_NOTIFICATION_STATE> {
    windows_targets::link!("shell32.dll" "system" fn SHQueryUserNotificationState(pquns : *mut QUERY_USER_NOTIFICATION_STATE) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHQueryUserNotificationState(&mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryValueExA<P0, P1>(hkey: P0, pszvalue: P1, pdwreserved: Option<*const u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHQueryValueExA(hkey : super::super::System::Registry:: HKEY, pszvalue : windows_core::PCSTR, pdwreserved : *const u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHQueryValueExA(hkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryValueExW<P0, P1>(hkey: P0, pszvalue: P1, pdwreserved: Option<*const u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHQueryValueExW(hkey : super::super::System::Registry:: HKEY, pszvalue : windows_core::PCWSTR, pdwreserved : *const u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHQueryValueExW(hkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHRegCloseUSKey(huskey: isize) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegCloseUSKey(huskey : isize) -> super::super::Foundation:: WIN32_ERROR);
    SHRegCloseUSKey(huskey)
}
#[inline]
pub unsafe fn SHRegCreateUSKeyA<P0>(pszpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegCreateUSKeyA(pszpath : windows_core::PCSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegCreateUSKeyA(pszpath.param().abi(), samdesired, hrelativeuskey, phnewuskey, dwflags)
}
#[inline]
pub unsafe fn SHRegCreateUSKeyW<P0>(pwzpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegCreateUSKeyW(pwzpath : windows_core::PCWSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegCreateUSKeyW(pwzpath.param().abi(), samdesired, hrelativeuskey, phnewuskey, dwflags)
}
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyA<P0>(huskey: isize, pszsubkey: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegDeleteEmptyUSKeyA(huskey : isize, pszsubkey : windows_core::PCSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegDeleteEmptyUSKeyA(huskey, pszsubkey.param().abi(), delregflags)
}
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyW<P0>(huskey: isize, pwzsubkey: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegDeleteEmptyUSKeyW(huskey : isize, pwzsubkey : windows_core::PCWSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegDeleteEmptyUSKeyW(huskey, pwzsubkey.param().abi(), delregflags)
}
#[inline]
pub unsafe fn SHRegDeleteUSValueA<P0>(huskey: isize, pszvalue: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegDeleteUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegDeleteUSValueA(huskey, pszvalue.param().abi(), delregflags)
}
#[inline]
pub unsafe fn SHRegDeleteUSValueW<P0>(huskey: isize, pwzvalue: P0, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegDeleteUSValueW(huskey : isize, pwzvalue : windows_core::PCWSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegDeleteUSValueW(huskey, pwzvalue.param().abi(), delregflags)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegDuplicateHKey<P0>(hkey: P0) -> super::super::System::Registry::HKEY
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegDuplicateHKey(hkey : super::super::System::Registry:: HKEY) -> super::super::System::Registry:: HKEY);
    SHRegDuplicateHKey(hkey.param().abi())
}
#[inline]
pub unsafe fn SHRegEnumUSKeyA(huskey: isize, dwindex: u32, pszname: windows_core::PSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegEnumUSKeyA(huskey : isize, dwindex : u32, pszname : windows_core::PSTR, pcchname : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegEnumUSKeyA(huskey, dwindex, core::mem::transmute(pszname), pcchname, enumregflags)
}
#[inline]
pub unsafe fn SHRegEnumUSKeyW(huskey: isize, dwindex: u32, pwzname: windows_core::PWSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegEnumUSKeyW(huskey : isize, dwindex : u32, pwzname : windows_core::PWSTR, pcchname : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegEnumUSKeyW(huskey, dwindex, core::mem::transmute(pwzname), pcchname, enumregflags)
}
#[inline]
pub unsafe fn SHRegEnumUSValueA(huskey: isize, dwindex: u32, pszvaluename: windows_core::PSTR, pcchvaluename: *mut u32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegEnumUSValueA(huskey : isize, dwindex : u32, pszvaluename : windows_core::PSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegEnumUSValueA(huskey, dwindex, core::mem::transmute(pszvaluename), pcchvaluename, core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), enumregflags)
}
#[inline]
pub unsafe fn SHRegEnumUSValueW(huskey: isize, dwindex: u32, pszvaluename: windows_core::PWSTR, pcchvaluename: *mut u32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegEnumUSValueW(huskey : isize, dwindex : u32, pszvaluename : windows_core::PWSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegEnumUSValueW(huskey, dwindex, core::mem::transmute(pszvaluename), pcchvaluename, core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), enumregflags)
}
#[inline]
pub unsafe fn SHRegGetBoolUSValueA<P0, P1, P2, P3>(pszsubkey: P0, pszvalue: P1, fignorehkcu: P2, fdefault: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
    P3: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetBoolUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, fignorehkcu : super::super::Foundation:: BOOL, fdefault : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHRegGetBoolUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), fignorehkcu.param().abi(), fdefault.param().abi())
}
#[inline]
pub unsafe fn SHRegGetBoolUSValueW<P0, P1, P2, P3>(pszsubkey: P0, pszvalue: P1, fignorehkcu: P2, fdefault: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
    P3: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetBoolUSValueW(pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, fignorehkcu : super::super::Foundation:: BOOL, fdefault : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    SHRegGetBoolUSValueW(pszsubkey.param().abi(), pszvalue.param().abi(), fignorehkcu.param().abi(), fdefault.param().abi())
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetIntW<P0, P1>(hk: P0, pwzkey: P1, idefault: i32) -> i32
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetIntW(hk : super::super::System::Registry:: HKEY, pwzkey : windows_core::PCWSTR, idefault : i32) -> i32);
    SHRegGetIntW(hk.param().abi(), pwzkey.param().abi(), idefault)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetPathA<P0, P1, P2>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u8; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetPathA(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCSTR, pcszvalue : windows_core::PCSTR, pszpath : windows_core::PSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetPathA(hkey.param().abi(), pcszsubkey.param().abi(), pcszvalue.param().abi(), core::mem::transmute(pszpath.as_ptr()), dwflags)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetPathW<P0, P1, P2>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u16; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetPathW(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCWSTR, pcszvalue : windows_core::PCWSTR, pszpath : windows_core::PWSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetPathW(hkey.param().abi(), pcszsubkey.param().abi(), pcszvalue.param().abi(), core::mem::transmute(pszpath.as_ptr()), dwflags)
}
#[inline]
pub unsafe fn SHRegGetUSValueA<P0, P1, P2>(pszsubkey: P0, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: P2, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : super::super::Foundation:: BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), fignorehkcu.param().abi(), core::mem::transmute(pvdefaultdata.unwrap_or(std::ptr::null())), dwdefaultdatasize)
}
#[inline]
pub unsafe fn SHRegGetUSValueW<P0, P1, P2>(pszsubkey: P0, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: P2, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetUSValueW(pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : super::super::Foundation:: BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetUSValueW(pszsubkey.param().abi(), pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), fignorehkcu.param().abi(), core::mem::transmute(pvdefaultdata.unwrap_or(std::ptr::null())), dwdefaultdatasize)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetValueA<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetValueA(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), srrfflags, core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHRegGetValueFromHKCUHKLM<P0, P1>(pwszkey: P0, pwszvalue: P1, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetValueFromHKCUHKLM(pwszkey : windows_core::PCWSTR, pwszvalue : windows_core::PCWSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetValueFromHKCUHKLM(pwszkey.param().abi(), pwszvalue.param().abi(), srrfflags, core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetValueW<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegGetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegGetValueW(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), srrfflags, core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn SHRegOpenUSKeyA<P0, P1>(pszpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegOpenUSKeyA(pszpath : windows_core::PCSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, fignorehkcu : super::super::Foundation:: BOOL) -> super::super::Foundation:: WIN32_ERROR);
    SHRegOpenUSKeyA(pszpath.param().abi(), samdesired, hrelativeuskey, phnewuskey, fignorehkcu.param().abi())
}
#[inline]
pub unsafe fn SHRegOpenUSKeyW<P0, P1>(pwzpath: P0, samdesired: u32, hrelativeuskey: isize, phnewuskey: *mut isize, fignorehkcu: P1) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegOpenUSKeyW(pwzpath : windows_core::PCWSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, fignorehkcu : super::super::Foundation:: BOOL) -> super::super::Foundation:: WIN32_ERROR);
    SHRegOpenUSKeyW(pwzpath.param().abi(), samdesired, hrelativeuskey, phnewuskey, fignorehkcu.param().abi())
}
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyA(huskey: isize, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegQueryInfoUSKeyA(huskey : isize, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegQueryInfoUSKeyA(huskey, core::mem::transmute(pcsubkeys.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxsubkeylen.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcvalues.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(std::ptr::null_mut())), enumregflags)
}
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyW(huskey: isize, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_targets::link!("shlwapi.dll" "system" fn SHRegQueryInfoUSKeyW(huskey : isize, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    SHRegQueryInfoUSKeyW(huskey, core::mem::transmute(pcsubkeys.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxsubkeylen.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcvalues.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcchmaxvaluenamelen.unwrap_or(std::ptr::null_mut())), enumregflags)
}
#[inline]
pub unsafe fn SHRegQueryUSValueA<P0, P1>(huskey: isize, pszvalue: P0, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: P1, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegQueryUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : super::super::Foundation:: BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegQueryUSValueA(huskey, pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), fignorehkcu.param().abi(), core::mem::transmute(pvdefaultdata.unwrap_or(std::ptr::null())), dwdefaultdatasize)
}
#[inline]
pub unsafe fn SHRegQueryUSValueW<P0, P1>(huskey: isize, pszvalue: P0, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: P1, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegQueryUSValueW(huskey : isize, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : super::super::Foundation:: BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegQueryUSValueW(huskey, pszvalue.param().abi(), core::mem::transmute(pdwtype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdata.unwrap_or(std::ptr::null_mut())), fignorehkcu.param().abi(), core::mem::transmute(pvdefaultdata.unwrap_or(std::ptr::null())), dwdefaultdatasize)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegSetPathA<P0, P1, P2, P3>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegSetPathA(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCSTR, pcszvalue : windows_core::PCSTR, pcszpath : windows_core::PCSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegSetPathA(hkey.param().abi(), pcszsubkey.param().abi(), pcszvalue.param().abi(), pcszpath.param().abi(), dwflags)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegSetPathW<P0, P1, P2, P3>(hkey: P0, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegSetPathW(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCWSTR, pcszvalue : windows_core::PCWSTR, pcszpath : windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegSetPathW(hkey.param().abi(), pcszsubkey.param().abi(), pcszvalue.param().abi(), pcszpath.param().abi(), dwflags)
}
#[inline]
pub unsafe fn SHRegSetUSValueA<P0, P1>(pszsubkey: P0, pszvalue: P1, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegSetUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegSetUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, core::mem::transmute(pvdata.unwrap_or(std::ptr::null())), cbdata, dwflags)
}
#[inline]
pub unsafe fn SHRegSetUSValueW<P0, P1>(pwzsubkey: P0, pwzvalue: P1, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegSetUSValueW(pwzsubkey : windows_core::PCWSTR, pwzvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegSetUSValueW(pwzsubkey.param().abi(), pwzvalue.param().abi(), dwtype, core::mem::transmute(pvdata.unwrap_or(std::ptr::null())), cbdata, dwflags)
}
#[inline]
pub unsafe fn SHRegWriteUSValueA<P0>(huskey: isize, pszvalue: P0, dwtype: u32, pvdata: *const core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegWriteUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegWriteUSValueA(huskey, pszvalue.param().abi(), dwtype, pvdata, cbdata, dwflags)
}
#[inline]
pub unsafe fn SHRegWriteUSValueW<P0>(huskey: isize, pwzvalue: P0, dwtype: u32, pvdata: *const core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHRegWriteUSValueW(huskey : isize, pwzvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    SHRegWriteUSValueW(huskey, pwzvalue.param().abi(), dwtype, pvdata, cbdata, dwflags)
}
#[inline]
pub unsafe fn SHReleaseThreadRef() -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHReleaseThreadRef() -> windows_core::HRESULT);
    SHReleaseThreadRef().ok()
}
#[inline]
pub unsafe fn SHRemoveLocalizedName<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHRemoveLocalizedName(pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    SHRemoveLocalizedName(pszpath.param().abi()).ok()
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn SHReplaceFromPropSheetExtArray<P0, P1>(hpsxa: P0, upageid: u32, lpfnreplacewith: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: P1) -> u32
where
    P0: windows_core::Param<HPSXA>,
    P1: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("shell32.dll" "system" fn SHReplaceFromPropSheetExtArray(hpsxa : HPSXA, upageid : u32, lpfnreplacewith : super::Controls:: LPFNSVADDPROPSHEETPAGE, lparam : super::super::Foundation:: LPARAM) -> u32);
    SHReplaceFromPropSheetExtArray(hpsxa.param().abi(), upageid, lpfnreplacewith, lparam.param().abi())
}
#[inline]
pub unsafe fn SHResolveLibrary<P0>(psilibrary: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_targets::link!("shell32.dll" "system" fn SHResolveLibrary(psilibrary : * mut core::ffi::c_void) -> windows_core::HRESULT);
    SHResolveLibrary(psilibrary.param().abi()).ok()
}
#[inline]
pub unsafe fn SHRestricted(rest: RESTRICTIONS) -> u32 {
    windows_targets::link!("shell32.dll" "system" fn SHRestricted(rest : RESTRICTIONS) -> u32);
    SHRestricted(rest)
}
#[inline]
pub unsafe fn SHSendMessageBroadcastA<P0, P1>(umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: windows_core::Param<super::super::Foundation::WPARAM>,
    P1: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSendMessageBroadcastA(umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    SHSendMessageBroadcastA(umsg, wparam.param().abi(), lparam.param().abi())
}
#[inline]
pub unsafe fn SHSendMessageBroadcastW<P0, P1>(umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: windows_core::Param<super::super::Foundation::WPARAM>,
    P1: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSendMessageBroadcastW(umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    SHSendMessageBroadcastW(umsg, wparam.param().abi(), lparam.param().abi())
}
#[inline]
pub unsafe fn SHSetDefaultProperties<P0, P1, P2>(hwnd: P0, psi: P1, dwfileopflags: u32, pfops: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<IShellItem>,
    P2: windows_core::Param<IFileOperationProgressSink>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetDefaultProperties(hwnd : super::super::Foundation:: HWND, psi : * mut core::ffi::c_void, dwfileopflags : u32, pfops : * mut core::ffi::c_void) -> windows_core::HRESULT);
    SHSetDefaultProperties(hwnd.param().abi(), psi.param().abi(), dwfileopflags, pfops.param().abi()).ok()
}
#[inline]
pub unsafe fn SHSetFolderPathA<P0, P1>(csidl: i32, htoken: P0, dwflags: u32, pszpath: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetFolderPathA(csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PCSTR) -> windows_core::HRESULT);
    SHSetFolderPathA(csidl, htoken.param().abi(), dwflags, pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn SHSetFolderPathW<P0, P1>(csidl: i32, htoken: P0, dwflags: u32, pszpath: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetFolderPathW(csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    SHSetFolderPathW(csidl, htoken.param().abi(), dwflags, pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn SHSetInstanceExplorer<P0>(punk: P0)
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetInstanceExplorer(punk : * mut core::ffi::c_void));
    SHSetInstanceExplorer(punk.param().abi())
}
#[inline]
pub unsafe fn SHSetKnownFolderPath<P0, P1>(rfid: *const windows_core::GUID, dwflags: u32, htoken: P0, pszpath: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetKnownFolderPath(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    SHSetKnownFolderPath(rfid, dwflags, htoken.param().abi(), pszpath.param().abi()).ok()
}
#[inline]
pub unsafe fn SHSetLocalizedName<P0, P1>(pszpath: P0, pszresmodule: P1, idsres: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetLocalizedName(pszpath : windows_core::PCWSTR, pszresmodule : windows_core::PCWSTR, idsres : i32) -> windows_core::HRESULT);
    SHSetLocalizedName(pszpath.param().abi(), pszresmodule.param().abi(), idsres).ok()
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn SHSetTemporaryPropertyForItem<P0>(psi: P0, propkey: *const PropertiesSystem::PROPERTYKEY, propvar: *const windows_core::PROPVARIANT) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetTemporaryPropertyForItem(psi : * mut core::ffi::c_void, propkey : *const PropertiesSystem:: PROPERTYKEY, propvar : *const core::mem::MaybeUninit < windows_core::PROPVARIANT >) -> windows_core::HRESULT);
    SHSetTemporaryPropertyForItem(psi.param().abi(), propkey, core::mem::transmute(propvar)).ok()
}
#[inline]
pub unsafe fn SHSetThreadRef<P0>(punk: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSetThreadRef(punk : * mut core::ffi::c_void) -> windows_core::HRESULT);
    SHSetThreadRef(punk.param().abi()).ok()
}
#[inline]
pub unsafe fn SHSetUnreadMailCountW<P0, P1>(pszmailaddress: P0, dwcount: u32, pszshellexecutecommand: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSetUnreadMailCountW(pszmailaddress : windows_core::PCWSTR, dwcount : u32, pszshellexecutecommand : windows_core::PCWSTR) -> windows_core::HRESULT);
    SHSetUnreadMailCountW(pszmailaddress.param().abi(), dwcount, pszshellexecutecommand.param().abi()).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueA<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32) -> i32
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32) -> i32);
    SHSetValueA(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, core::mem::transmute(pvdata.unwrap_or(std::ptr::null())), cbdata)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueW<P0, P1, P2>(hkey: P0, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32) -> i32
where
    P0: windows_core::Param<super::super::System::Registry::HKEY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32) -> i32);
    SHSetValueW(hkey.param().abi(), pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, core::mem::transmute(pvdata.unwrap_or(std::ptr::null())), cbdata)
}
#[inline]
pub unsafe fn SHShellFolderView_Message<P0, P1>(hwndmain: P0, umsg: u32, lparam: P1) -> super::super::Foundation::LRESULT
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<super::super::Foundation::LPARAM>,
{
    windows_targets::link!("shell32.dll" "system" fn SHShellFolderView_Message(hwndmain : super::super::Foundation:: HWND, umsg : u32, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    SHShellFolderView_Message(hwndmain.param().abi(), umsg, lparam.param().abi())
}
#[inline]
pub unsafe fn SHShowManageLibraryUI<P0, P1, P2, P3>(psilibrary: P0, hwndowner: P1, psztitle: P2, pszinstruction: P3, lmdoptions: LIBRARYMANAGEDIALOGOPTIONS) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHShowManageLibraryUI(psilibrary : * mut core::ffi::c_void, hwndowner : super::super::Foundation:: HWND, psztitle : windows_core::PCWSTR, pszinstruction : windows_core::PCWSTR, lmdoptions : LIBRARYMANAGEDIALOGOPTIONS) -> windows_core::HRESULT);
    SHShowManageLibraryUI(psilibrary.param().abi(), hwndowner.param().abi(), psztitle.param().abi(), pszinstruction.param().abi(), lmdoptions).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHSimpleIDListFromPath<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHSimpleIDListFromPath(pszpath : windows_core::PCWSTR) -> *mut Common:: ITEMIDLIST);
    SHSimpleIDListFromPath(pszpath.param().abi())
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHSkipJunction<P0>(pbc: P0, pclsid: *const windows_core::GUID) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHSkipJunction(pbc : * mut core::ffi::c_void, pclsid : *const windows_core::GUID) -> super::super::Foundation:: BOOL);
    SHSkipJunction(pbc.param().abi(), pclsid)
}
#[inline]
pub unsafe fn SHStartNetConnectionDialogW<P0, P1>(hwnd: P0, pszremotename: P1, dwtype: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHStartNetConnectionDialogW(hwnd : super::super::Foundation:: HWND, pszremotename : windows_core::PCWSTR, dwtype : u32) -> windows_core::HRESULT);
    SHStartNetConnectionDialogW(hwnd.param().abi(), pszremotename.param().abi(), dwtype).ok()
}
#[inline]
pub unsafe fn SHStrDupA<P0>(psz: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHStrDupA(psz : windows_core::PCSTR, ppwsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHStrDupA(psz.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHStrDupW<P0>(psz: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHStrDupW(psz : windows_core::PCWSTR, ppwsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    SHStrDupW(psz.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SHStripMneumonicA(pszmenu: windows_core::PSTR) -> i8 {
    windows_targets::link!("shlwapi.dll" "system" fn SHStripMneumonicA(pszmenu : windows_core::PSTR) -> i8);
    SHStripMneumonicA(core::mem::transmute(pszmenu))
}
#[inline]
pub unsafe fn SHStripMneumonicW(pszmenu: windows_core::PWSTR) -> u16 {
    windows_targets::link!("shlwapi.dll" "system" fn SHStripMneumonicW(pszmenu : windows_core::PWSTR) -> u16);
    SHStripMneumonicW(core::mem::transmute(pszmenu))
}
#[inline]
pub unsafe fn SHTestTokenMembership<P0>(htoken: P0, ulrid: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("shell32.dll" "system" fn SHTestTokenMembership(htoken : super::super::Foundation:: HANDLE, ulrid : u32) -> super::super::Foundation:: BOOL);
    SHTestTokenMembership(htoken.param().abi(), ulrid)
}
#[inline]
pub unsafe fn SHUnicodeToAnsi<P0>(pwszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHUnicodeToAnsi(pwszsrc : windows_core::PCWSTR, pszdst : windows_core::PSTR, cchbuf : i32) -> i32);
    SHUnicodeToAnsi(pwszsrc.param().abi(), core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHUnicodeToUnicode<P0>(pwzsrc: P0, pwzdst: &mut [u16]) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn SHUnicodeToUnicode(pwzsrc : windows_core::PCWSTR, pwzdst : windows_core::PWSTR, cwchbuf : i32) -> i32);
    SHUnicodeToUnicode(pwzsrc.param().abi(), core::mem::transmute(pwzdst.as_ptr()), pwzdst.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SHUnlockShared(pvdata: *const core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn SHUnlockShared(pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    SHUnlockShared(pvdata).ok()
}
#[inline]
pub unsafe fn SHUpdateImageA<P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHUpdateImageA(pszhashitem : windows_core::PCSTR, iindex : i32, uflags : u32, iimageindex : i32));
    SHUpdateImageA(pszhashitem.param().abi(), iindex, uflags, iimageindex)
}
#[inline]
pub unsafe fn SHUpdateImageW<P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SHUpdateImageW(pszhashitem : windows_core::PCWSTR, iindex : i32, uflags : u32, iimageindex : i32));
    SHUpdateImageW(pszhashitem.param().abi(), iindex, uflags, iimageindex)
}
#[inline]
pub unsafe fn SHValidateUNC<P0>(hwndowner: P0, pszfile: windows_core::PWSTR, fconnect: VALIDATEUNC_OPTION) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("shell32.dll" "system" fn SHValidateUNC(hwndowner : super::super::Foundation:: HWND, pszfile : windows_core::PWSTR, fconnect : u32) -> super::super::Foundation:: BOOL);
    SHValidateUNC(hwndowner.param().abi(), core::mem::transmute(pszfile), fconnect.0 as _)
}
#[inline]
pub unsafe fn SetCurrentProcessExplicitAppUserModelID<P0>(appid: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn SetCurrentProcessExplicitAppUserModelID(appid : windows_core::PCWSTR) -> windows_core::HRESULT);
    SetCurrentProcessExplicitAppUserModelID(appid.param().abi()).ok()
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SetMenuContextHelpId<P0>(param0: P0, param1: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
{
    windows_targets::link!("user32.dll" "system" fn SetMenuContextHelpId(param0 : super::WindowsAndMessaging:: HMENU, param1 : u32) -> super::super::Foundation:: BOOL);
    SetMenuContextHelpId(param0.param().abi(), param1).ok()
}
#[inline]
pub unsafe fn SetWindowContextHelpId<P0>(param0: P0, param1: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("user32.dll" "system" fn SetWindowContextHelpId(param0 : super::super::Foundation:: HWND, param1 : u32) -> super::super::Foundation:: BOOL);
    SetWindowContextHelpId(param0.param().abi(), param1).ok()
}
#[inline]
pub unsafe fn SetWindowSubclass<P0>(hwnd: P0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, dwrefdata: usize) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("comctl32.dll" "system" fn SetWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize, dwrefdata : usize) -> super::super::Foundation:: BOOL);
    SetWindowSubclass(hwnd.param().abi(), pfnsubclass, uidsubclass, dwrefdata)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellAboutA<P0, P1, P2, P3>(hwnd: P0, szapp: P1, szotherstuff: P2, hicon: P3) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<super::WindowsAndMessaging::HICON>,
{
    windows_targets::link!("shell32.dll" "system" fn ShellAboutA(hwnd : super::super::Foundation:: HWND, szapp : windows_core::PCSTR, szotherstuff : windows_core::PCSTR, hicon : super::WindowsAndMessaging:: HICON) -> i32);
    ShellAboutA(hwnd.param().abi(), szapp.param().abi(), szotherstuff.param().abi(), hicon.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellAboutW<P0, P1, P2, P3>(hwnd: P0, szapp: P1, szotherstuff: P2, hicon: P3) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<super::WindowsAndMessaging::HICON>,
{
    windows_targets::link!("shell32.dll" "system" fn ShellAboutW(hwnd : super::super::Foundation:: HWND, szapp : windows_core::PCWSTR, szotherstuff : windows_core::PCWSTR, hicon : super::WindowsAndMessaging:: HICON) -> i32);
    ShellAboutW(hwnd.param().abi(), szapp.param().abi(), szotherstuff.param().abi(), hicon.param().abi())
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellExecuteA<P0, P1, P2, P3, P4>(hwnd: P0, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
    P4: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ShellExecuteA(hwnd : super::super::Foundation:: HWND, lpoperation : windows_core::PCSTR, lpfile : windows_core::PCSTR, lpparameters : windows_core::PCSTR, lpdirectory : windows_core::PCSTR, nshowcmd : super::WindowsAndMessaging:: SHOW_WINDOW_CMD) -> super::super::Foundation:: HINSTANCE);
    ShellExecuteA(hwnd.param().abi(), lpoperation.param().abi(), lpfile.param().abi(), lpparameters.param().abi(), lpdirectory.param().abi(), nshowcmd)
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ShellExecuteExA(pexecinfo: *mut SHELLEXECUTEINFOA) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn ShellExecuteExA(pexecinfo : *mut SHELLEXECUTEINFOA) -> super::super::Foundation:: BOOL);
    ShellExecuteExA(pexecinfo).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ShellExecuteExW(pexecinfo: *mut SHELLEXECUTEINFOW) -> windows_core::Result<()> {
    windows_targets::link!("shell32.dll" "system" fn ShellExecuteExW(pexecinfo : *mut SHELLEXECUTEINFOW) -> super::super::Foundation:: BOOL);
    ShellExecuteExW(pexecinfo).ok()
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellExecuteW<P0, P1, P2, P3, P4>(hwnd: P0, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn ShellExecuteW(hwnd : super::super::Foundation:: HWND, lpoperation : windows_core::PCWSTR, lpfile : windows_core::PCWSTR, lpparameters : windows_core::PCWSTR, lpdirectory : windows_core::PCWSTR, nshowcmd : super::WindowsAndMessaging:: SHOW_WINDOW_CMD) -> super::super::Foundation:: HINSTANCE);
    ShellExecuteW(hwnd.param().abi(), lpoperation.param().abi(), lpfile.param().abi(), lpparameters.param().abi(), lpdirectory.param().abi(), nshowcmd)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellMessageBoxA<P0, P1, P2, P3>(happinst: P0, hwnd: P1, lpctext: P2, lpctitle: P3, fustyle: super::WindowsAndMessaging::MESSAGEBOX_STYLE) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "cdecl" fn ShellMessageBoxA(happinst : super::super::Foundation:: HINSTANCE, hwnd : super::super::Foundation:: HWND, lpctext : windows_core::PCSTR, lpctitle : windows_core::PCSTR, fustyle : super::WindowsAndMessaging:: MESSAGEBOX_STYLE) -> i32);
    ShellMessageBoxA(happinst.param().abi(), hwnd.param().abi(), lpctext.param().abi(), lpctitle.param().abi(), fustyle)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellMessageBoxW<P0, P1, P2, P3>(happinst: P0, hwnd: P1, lpctext: P2, lpctitle: P3, fustyle: super::WindowsAndMessaging::MESSAGEBOX_STYLE) -> i32
where
    P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "cdecl" fn ShellMessageBoxW(happinst : super::super::Foundation:: HINSTANCE, hwnd : super::super::Foundation:: HWND, lpctext : windows_core::PCWSTR, lpctitle : windows_core::PCWSTR, fustyle : super::WindowsAndMessaging:: MESSAGEBOX_STYLE) -> i32);
    ShellMessageBoxW(happinst.param().abi(), hwnd.param().abi(), lpctext.param().abi(), lpctitle.param().abi(), fustyle)
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndex<P0>(pwsziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn Shell_GetCachedImageIndex(pwsziconpath : windows_core::PCWSTR, iiconindex : i32, uiconflags : u32) -> i32);
    Shell_GetCachedImageIndex(pwsziconpath.param().abi(), iiconindex, uiconflags)
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndexA<P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn Shell_GetCachedImageIndexA(psziconpath : windows_core::PCSTR, iiconindex : i32, uiconflags : u32) -> i32);
    Shell_GetCachedImageIndexA(psziconpath.param().abi(), iiconindex, uiconflags)
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndexW<P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn Shell_GetCachedImageIndexW(psziconpath : windows_core::PCWSTR, iiconindex : i32, uiconflags : u32) -> i32);
    Shell_GetCachedImageIndexW(psziconpath.param().abi(), iiconindex, uiconflags)
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn Shell_GetImageLists(phiml: Option<*mut super::Controls::HIMAGELIST>, phimlsmall: Option<*mut super::Controls::HIMAGELIST>) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn Shell_GetImageLists(phiml : *mut super::Controls:: HIMAGELIST, phimlsmall : *mut super::Controls:: HIMAGELIST) -> super::super::Foundation:: BOOL);
    Shell_GetImageLists(core::mem::transmute(phiml.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phimlsmall.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_MergeMenus<P0, P1>(hmdst: P0, hmsrc: P1, uinsert: u32, uidadjust: u32, uidadjustmax: u32, uflags: MM_FLAGS) -> u32
where
    P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
    P1: windows_core::Param<super::WindowsAndMessaging::HMENU>,
{
    windows_targets::link!("shell32.dll" "system" fn Shell_MergeMenus(hmdst : super::WindowsAndMessaging:: HMENU, hmsrc : super::WindowsAndMessaging:: HMENU, uinsert : u32, uidadjust : u32, uidadjustmax : u32, uflags : MM_FLAGS) -> u32);
    Shell_MergeMenus(hmdst.param().abi(), hmsrc.param().abi(), uinsert, uidadjust, uidadjustmax, uflags)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_NotifyIconA(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAA) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn Shell_NotifyIconA(dwmessage : NOTIFY_ICON_MESSAGE, lpdata : *const NOTIFYICONDATAA) -> super::super::Foundation:: BOOL);
    Shell_NotifyIconA(dwmessage, lpdata)
}
#[inline]
pub unsafe fn Shell_NotifyIconGetRect(identifier: *const NOTIFYICONIDENTIFIER) -> windows_core::Result<super::super::Foundation::RECT> {
    windows_targets::link!("shell32.dll" "system" fn Shell_NotifyIconGetRect(identifier : *const NOTIFYICONIDENTIFIER, iconlocation : *mut super::super::Foundation:: RECT) -> windows_core::HRESULT);
    let mut result__ = core::mem::zeroed();
    Shell_NotifyIconGetRect(identifier, &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_NotifyIconW(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAW) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn Shell_NotifyIconW(dwmessage : NOTIFY_ICON_MESSAGE, lpdata : *const NOTIFYICONDATAW) -> super::super::Foundation:: BOOL);
    Shell_NotifyIconW(dwmessage, lpdata)
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SignalFileOpen(pidl: *const Common::ITEMIDLIST) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn SignalFileOpen(pidl : *const Common:: ITEMIDLIST) -> super::super::Foundation:: BOOL);
    SignalFileOpen(pidl)
}
#[cfg(feature = "Win32_System_Com_Urlmon")]
#[inline]
pub unsafe fn SoftwareUpdateMessageBox<P0, P1>(hwnd: P0, pszdistunit: P1, dwflags: u32, psdi: Option<*mut super::super::System::Com::Urlmon::SOFTDISTINFO>) -> u32
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shdocvw.dll" "system" fn SoftwareUpdateMessageBox(hwnd : super::super::Foundation:: HWND, pszdistunit : windows_core::PCWSTR, dwflags : u32, psdi : *mut super::super::System::Com::Urlmon:: SOFTDISTINFO) -> u32);
    SoftwareUpdateMessageBox(hwnd.param().abi(), pszdistunit.param().abi(), dwflags, core::mem::transmute(psdi.unwrap_or(std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[inline]
pub unsafe fn StgMakeUniqueName<P0, P1, T>(pstgparent: P0, pszfilespec: P1, grfmode: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::StructuredStorage::IStorage>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_targets::link!("shell32.dll" "system" fn StgMakeUniqueName(pstgparent : * mut core::ffi::c_void, pszfilespec : windows_core::PCWSTR, grfmode : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    StgMakeUniqueName(pstgparent.param().abi(), pszfilespec.param().abi(), grfmode, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
}
#[inline]
pub unsafe fn StrCSpnA<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCSpnA(pszstr : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    StrCSpnA(pszstr.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrCSpnIA<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCSpnIA(pszstr : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    StrCSpnIA(pszstr.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrCSpnIW<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCSpnIW(pszstr : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    StrCSpnIW(pszstr.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrCSpnW<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCSpnW(pszstr : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    StrCSpnW(pszstr.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrCatBuffA<P0>(pszdest: &mut [u8], pszsrc: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCatBuffA(pszdest : windows_core::PSTR, pszsrc : windows_core::PCSTR, cchdestbuffsize : i32) -> windows_core::PSTR);
    StrCatBuffA(core::mem::transmute(pszdest.as_ptr()), pszsrc.param().abi(), pszdest.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrCatBuffW<P0>(pszdest: &mut [u16], pszsrc: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCatBuffW(pszdest : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchdestbuffsize : i32) -> windows_core::PWSTR);
    StrCatBuffW(core::mem::transmute(pszdest.as_ptr()), pszsrc.param().abi(), pszdest.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrCatChainW<P0>(pszdst: &mut [u16], ichat: u32, pszsrc: P0) -> u32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCatChainW(pszdst : windows_core::PWSTR, cchdst : u32, ichat : u32, pszsrc : windows_core::PCWSTR) -> u32);
    StrCatChainW(core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap(), ichat, pszsrc.param().abi())
}
#[inline]
pub unsafe fn StrCatW<P0>(psz1: windows_core::PWSTR, psz2: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCatW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrCatW(core::mem::transmute(psz1), psz2.param().abi())
}
#[inline]
pub unsafe fn StrChrA<P0>(pszstart: P0, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrA(pszstart : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    StrChrA(pszstart.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrChrIA<P0>(pszstart: P0, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrIA(pszstart : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    StrChrIA(pszstart.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrChrIW<P0>(pszstart: P0, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrIW(pszstart : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    StrChrIW(pszstart.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrChrNIW<P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrNIW(pszstart : windows_core::PCWSTR, wmatch : u16, cchmax : u32) -> windows_core::PWSTR);
    StrChrNIW(pszstart.param().abi(), wmatch, cchmax)
}
#[inline]
pub unsafe fn StrChrNW<P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrNW(pszstart : windows_core::PCWSTR, wmatch : u16, cchmax : u32) -> windows_core::PWSTR);
    StrChrNW(pszstart.param().abi(), wmatch, cchmax)
}
#[inline]
pub unsafe fn StrChrW<P0>(pszstart: P0, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrChrW(pszstart : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    StrChrW(pszstart.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrCmpCA<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpCA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR) -> i32);
    StrCmpCA(pszstr1.param().abi(), pszstr2.param().abi())
}
#[inline]
pub unsafe fn StrCmpCW<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpCW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR) -> i32);
    StrCmpCW(pszstr1.param().abi(), pszstr2.param().abi())
}
#[inline]
pub unsafe fn StrCmpICA<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpICA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR) -> i32);
    StrCmpICA(pszstr1.param().abi(), pszstr2.param().abi())
}
#[inline]
pub unsafe fn StrCmpICW<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpICW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR) -> i32);
    StrCmpICW(pszstr1.param().abi(), pszstr2.param().abi())
}
#[inline]
pub unsafe fn StrCmpIW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpIW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    StrCmpIW(psz1.param().abi(), psz2.param().abi())
}
#[inline]
pub unsafe fn StrCmpLogicalW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpLogicalW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    StrCmpLogicalW(psz1.param().abi(), psz2.param().abi())
}
#[inline]
pub unsafe fn StrCmpNA<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, nchar : i32) -> i32);
    StrCmpNA(psz1.param().abi(), psz2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNCA<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNCA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR, nchar : i32) -> i32);
    StrCmpNCA(pszstr1.param().abi(), pszstr2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNCW<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNCW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR, nchar : i32) -> i32);
    StrCmpNCW(pszstr1.param().abi(), pszstr2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNIA<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNIA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, nchar : i32) -> i32);
    StrCmpNIA(psz1.param().abi(), psz2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNICA<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNICA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR, nchar : i32) -> i32);
    StrCmpNICA(pszstr1.param().abi(), pszstr2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNICW<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNICW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR, nchar : i32) -> i32);
    StrCmpNICW(pszstr1.param().abi(), pszstr2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNIW<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNIW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, nchar : i32) -> i32);
    StrCmpNIW(psz1.param().abi(), psz2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpNW<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpNW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, nchar : i32) -> i32);
    StrCmpNW(psz1.param().abi(), psz2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrCmpW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCmpW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    StrCmpW(psz1.param().abi(), psz2.param().abi())
}
#[inline]
pub unsafe fn StrCpyNW<P0>(pszdst: &mut [u16], pszsrc: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCpyNW(pszdst : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchmax : i32) -> windows_core::PWSTR);
    StrCpyNW(core::mem::transmute(pszdst.as_ptr()), pszsrc.param().abi(), pszdst.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrCpyW<P0>(psz1: windows_core::PWSTR, psz2: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrCpyW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrCpyW(core::mem::transmute(psz1), psz2.param().abi())
}
#[inline]
pub unsafe fn StrDupA<P0>(pszsrch: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrDupA(pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    StrDupA(pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrDupW<P0>(pszsrch: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrDupW(pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrDupW(pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrFormatByteSize64A(qdw: i64, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatByteSize64A(qdw : i64, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    StrFormatByteSize64A(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrFormatByteSizeA(dw: u32, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatByteSizeA(dw : u32, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    StrFormatByteSizeA(dw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrFormatByteSizeEx(ull: u64, flags: SFBS_FLAGS, pszbuf: &mut [u16]) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatByteSizeEx(ull : u64, flags : SFBS_FLAGS, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::HRESULT);
    StrFormatByteSizeEx(ull, flags, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn StrFormatByteSizeW(qdw: i64, pszbuf: &mut [u16]) -> windows_core::PWSTR {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatByteSizeW(qdw : i64, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::PWSTR);
    StrFormatByteSizeW(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrFormatKBSizeA(qdw: i64, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatKBSizeA(qdw : i64, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    StrFormatKBSizeA(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrFormatKBSizeW(qdw: i64, pszbuf: &mut [u16]) -> windows_core::PWSTR {
    windows_targets::link!("shlwapi.dll" "system" fn StrFormatKBSizeW(qdw : i64, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::PWSTR);
    StrFormatKBSizeW(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrFromTimeIntervalA(pszout: &mut [u8], dwtimems: u32, digits: i32) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn StrFromTimeIntervalA(pszout : windows_core::PSTR, cchmax : u32, dwtimems : u32, digits : i32) -> i32);
    StrFromTimeIntervalA(core::mem::transmute(pszout.as_ptr()), pszout.len().try_into().unwrap(), dwtimems, digits)
}
#[inline]
pub unsafe fn StrFromTimeIntervalW(pszout: &mut [u16], dwtimems: u32, digits: i32) -> i32 {
    windows_targets::link!("shlwapi.dll" "system" fn StrFromTimeIntervalW(pszout : windows_core::PWSTR, cchmax : u32, dwtimems : u32, digits : i32) -> i32);
    StrFromTimeIntervalW(core::mem::transmute(pszout.as_ptr()), pszout.len().try_into().unwrap(), dwtimems, digits)
}
#[inline]
pub unsafe fn StrIsIntlEqualA<P0, P1, P2>(fcasesens: P0, pszstring1: P1, pszstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrIsIntlEqualA(fcasesens : super::super::Foundation:: BOOL, pszstring1 : windows_core::PCSTR, pszstring2 : windows_core::PCSTR, nchar : i32) -> super::super::Foundation:: BOOL);
    StrIsIntlEqualA(fcasesens.param().abi(), pszstring1.param().abi(), pszstring2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrIsIntlEqualW<P0, P1, P2>(fcasesens: P0, pszstring1: P1, pszstring2: P2, nchar: i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrIsIntlEqualW(fcasesens : super::super::Foundation:: BOOL, pszstring1 : windows_core::PCWSTR, pszstring2 : windows_core::PCWSTR, nchar : i32) -> super::super::Foundation:: BOOL);
    StrIsIntlEqualW(fcasesens.param().abi(), pszstring1.param().abi(), pszstring2.param().abi(), nchar)
}
#[inline]
pub unsafe fn StrNCatA<P0>(psz1: &mut [u8], psz2: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrNCatA(psz1 : windows_core::PSTR, psz2 : windows_core::PCSTR, cchmax : i32) -> windows_core::PSTR);
    StrNCatA(core::mem::transmute(psz1.as_ptr()), psz2.param().abi(), psz1.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrNCatW<P0>(psz1: &mut [u16], psz2: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrNCatW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR, cchmax : i32) -> windows_core::PWSTR);
    StrNCatW(core::mem::transmute(psz1.as_ptr()), psz2.param().abi(), psz1.len().try_into().unwrap())
}
#[inline]
pub unsafe fn StrPBrkA<P0, P1>(psz: P0, pszset: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrPBrkA(psz : windows_core::PCSTR, pszset : windows_core::PCSTR) -> windows_core::PSTR);
    StrPBrkA(psz.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrPBrkW<P0, P1>(psz: P0, pszset: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrPBrkW(psz : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrPBrkW(psz.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrRChrA<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRChrA(pszstart : windows_core::PCSTR, pszend : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    StrRChrA(pszstart.param().abi(), pszend.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrRChrIA<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRChrIA(pszstart : windows_core::PCSTR, pszend : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    StrRChrIA(pszstart.param().abi(), pszend.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrRChrIW<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRChrIW(pszstart : windows_core::PCWSTR, pszend : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    StrRChrIW(pszstart.param().abi(), pszend.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrRChrW<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRChrW(pszstart : windows_core::PCWSTR, pszend : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    StrRChrW(pszstart.param().abi(), pszend.param().abi(), wmatch)
}
#[inline]
pub unsafe fn StrRStrIA<P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRStrIA(pszsource : windows_core::PCSTR, pszlast : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    StrRStrIA(pszsource.param().abi(), pszlast.param().abi(), pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrRStrIW<P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrRStrIW(pszsource : windows_core::PCWSTR, pszlast : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrRStrIW(pszsource.param().abi(), pszlast.param().abi(), pszsrch.param().abi())
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBSTR(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pbstr: *mut windows_core::BSTR) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrRetToBSTR(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pbstr : *mut core::mem::MaybeUninit < windows_core::BSTR >) -> windows_core::HRESULT);
    StrRetToBSTR(pstr, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), core::mem::transmute(pbstr)).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufA(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u8]) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrRetToBufA(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::HRESULT);
    StrRetToBufA(pstr, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufW(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u16]) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrRetToBufW(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::HRESULT);
    StrRetToBufW(pstr, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrA(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppsz: *mut windows_core::PSTR) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrRetToStrA(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppsz : *mut windows_core::PSTR) -> windows_core::HRESULT);
    StrRetToStrA(pstr, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), ppsz).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrW(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppsz: *mut windows_core::PWSTR) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn StrRetToStrW(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    StrRetToStrW(pstr, core::mem::transmute(pidl.unwrap_or(std::ptr::null())), ppsz).ok()
}
#[inline]
pub unsafe fn StrSpnA<P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrSpnA(psz : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    StrSpnA(psz.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrSpnW<P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrSpnW(psz : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    StrSpnW(psz.param().abi(), pszset.param().abi())
}
#[inline]
pub unsafe fn StrStrA<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrA(pszfirst : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    StrStrA(pszfirst.param().abi(), pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrStrIA<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrIA(pszfirst : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    StrStrIA(pszfirst.param().abi(), pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrStrIW<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrIW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrStrIW(pszfirst.param().abi(), pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrStrNIW<P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrNIW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR, cchmax : u32) -> windows_core::PWSTR);
    StrStrNIW(pszfirst.param().abi(), pszsrch.param().abi(), cchmax)
}
#[inline]
pub unsafe fn StrStrNW<P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrNW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR, cchmax : u32) -> windows_core::PWSTR);
    StrStrNW(pszfirst.param().abi(), pszsrch.param().abi(), cchmax)
}
#[inline]
pub unsafe fn StrStrW<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrStrW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    StrStrW(pszfirst.param().abi(), pszsrch.param().abi())
}
#[inline]
pub unsafe fn StrToInt64ExA<P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToInt64ExA(pszstring : windows_core::PCSTR, dwflags : i32, pllret : *mut i64) -> super::super::Foundation:: BOOL);
    StrToInt64ExA(pszstring.param().abi(), dwflags, pllret)
}
#[inline]
pub unsafe fn StrToInt64ExW<P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToInt64ExW(pszstring : windows_core::PCWSTR, dwflags : i32, pllret : *mut i64) -> super::super::Foundation:: BOOL);
    StrToInt64ExW(pszstring.param().abi(), dwflags, pllret)
}
#[inline]
pub unsafe fn StrToIntA<P0>(pszsrc: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToIntA(pszsrc : windows_core::PCSTR) -> i32);
    StrToIntA(pszsrc.param().abi())
}
#[inline]
pub unsafe fn StrToIntExA<P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToIntExA(pszstring : windows_core::PCSTR, dwflags : i32, piret : *mut i32) -> super::super::Foundation:: BOOL);
    StrToIntExA(pszstring.param().abi(), dwflags, piret)
}
#[inline]
pub unsafe fn StrToIntExW<P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToIntExW(pszstring : windows_core::PCWSTR, dwflags : i32, piret : *mut i32) -> super::super::Foundation:: BOOL);
    StrToIntExW(pszstring.param().abi(), dwflags, piret)
}
#[inline]
pub unsafe fn StrToIntW<P0>(pszsrc: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrToIntW(pszsrc : windows_core::PCWSTR) -> i32);
    StrToIntW(pszsrc.param().abi())
}
#[inline]
pub unsafe fn StrTrimA<P0>(psz: windows_core::PSTR, psztrimchars: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrTrimA(psz : windows_core::PSTR, psztrimchars : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    StrTrimA(core::mem::transmute(psz), psztrimchars.param().abi())
}
#[inline]
pub unsafe fn StrTrimW<P0>(psz: windows_core::PWSTR, psztrimchars: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn StrTrimW(psz : windows_core::PWSTR, psztrimchars : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    StrTrimW(core::mem::transmute(psz), psztrimchars.param().abi())
}
#[inline]
pub unsafe fn UnloadUserProfile<P0, P1>(htoken: P0, hprofile: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
    P1: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("userenv.dll" "system" fn UnloadUserProfile(htoken : super::super::Foundation:: HANDLE, hprofile : super::super::Foundation:: HANDLE) -> super::super::Foundation:: BOOL);
    UnloadUserProfile(htoken.param().abi(), hprofile.param().abi()).ok()
}
#[inline]
pub unsafe fn UnregisterAppConstrainedChangeNotification<P0>(registration: P0)
where
    P0: windows_core::Param<PAPPCONSTRAIN_REGISTRATION>,
{
    windows_targets::link!("api-ms-win-core-psm-appnotify-l1-1-1.dll" "system" fn UnregisterAppConstrainedChangeNotification(registration : PAPPCONSTRAIN_REGISTRATION));
    UnregisterAppConstrainedChangeNotification(registration.param().abi())
}
#[inline]
pub unsafe fn UnregisterAppStateChangeNotification<P0>(registration: P0)
where
    P0: windows_core::Param<PAPPSTATE_REGISTRATION>,
{
    windows_targets::link!("api-ms-win-core-psm-appnotify-l1-1-0.dll" "system" fn UnregisterAppStateChangeNotification(registration : PAPPSTATE_REGISTRATION));
    UnregisterAppStateChangeNotification(registration.param().abi())
}
#[inline]
pub unsafe fn UnregisterScaleChangeEvent(dwcookie: usize) -> windows_core::Result<()> {
    windows_targets::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn UnregisterScaleChangeEvent(dwcookie : usize) -> windows_core::HRESULT);
    UnregisterScaleChangeEvent(dwcookie).ok()
}
#[inline]
pub unsafe fn UrlApplySchemeA<P0>(pszin: P0, pszout: windows_core::PSTR, pcchout: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlApplySchemeA(pszin : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlApplySchemeA(pszin.param().abi(), core::mem::transmute(pszout), pcchout, dwflags).ok()
}
#[inline]
pub unsafe fn UrlApplySchemeW<P0>(pszin: P0, pszout: windows_core::PWSTR, pcchout: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlApplySchemeW(pszin : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlApplySchemeW(pszin.param().abi(), core::mem::transmute(pszout), pcchout, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCanonicalizeA<P0>(pszurl: P0, pszcanonicalized: windows_core::PSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCanonicalizeA(pszurl : windows_core::PCSTR, pszcanonicalized : windows_core::PSTR, pcchcanonicalized : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCanonicalizeA(pszurl.param().abi(), core::mem::transmute(pszcanonicalized), pcchcanonicalized, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCanonicalizeW<P0>(pszurl: P0, pszcanonicalized: windows_core::PWSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCanonicalizeW(pszurl : windows_core::PCWSTR, pszcanonicalized : windows_core::PWSTR, pcchcanonicalized : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCanonicalizeW(pszurl.param().abi(), core::mem::transmute(pszcanonicalized), pcchcanonicalized, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCombineA<P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: windows_core::PSTR, pcchcombined: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCombineA(pszbase : windows_core::PCSTR, pszrelative : windows_core::PCSTR, pszcombined : windows_core::PSTR, pcchcombined : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCombineA(pszbase.param().abi(), pszrelative.param().abi(), core::mem::transmute(pszcombined), pcchcombined, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCombineW<P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: windows_core::PWSTR, pcchcombined: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCombineW(pszbase : windows_core::PCWSTR, pszrelative : windows_core::PCWSTR, pszcombined : windows_core::PWSTR, pcchcombined : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCombineW(pszbase.param().abi(), pszrelative.param().abi(), core::mem::transmute(pszcombined), pcchcombined, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCompareA<P0, P1, P2>(psz1: P0, psz2: P1, fignoreslash: P2) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCompareA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, fignoreslash : super::super::Foundation:: BOOL) -> i32);
    UrlCompareA(psz1.param().abi(), psz2.param().abi(), fignoreslash.param().abi())
}
#[inline]
pub unsafe fn UrlCompareW<P0, P1, P2>(psz1: P0, psz2: P1, fignoreslash: P2) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCompareW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, fignoreslash : super::super::Foundation:: BOOL) -> i32);
    UrlCompareW(psz1.param().abi(), psz2.param().abi(), fignoreslash.param().abi())
}
#[inline]
pub unsafe fn UrlCreateFromPathA<P0>(pszpath: P0, pszurl: windows_core::PSTR, pcchurl: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCreateFromPathA(pszpath : windows_core::PCSTR, pszurl : windows_core::PSTR, pcchurl : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCreateFromPathA(pszpath.param().abi(), core::mem::transmute(pszurl), pcchurl, dwflags).ok()
}
#[inline]
pub unsafe fn UrlCreateFromPathW<P0>(pszpath: P0, pszurl: windows_core::PWSTR, pcchurl: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlCreateFromPathW(pszpath : windows_core::PCWSTR, pszurl : windows_core::PWSTR, pcchurl : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlCreateFromPathW(pszpath.param().abi(), core::mem::transmute(pszurl), pcchurl, dwflags).ok()
}
#[inline]
pub unsafe fn UrlEscapeA<P0>(pszurl: P0, pszescaped: windows_core::PSTR, pcchescaped: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlEscapeA(pszurl : windows_core::PCSTR, pszescaped : windows_core::PSTR, pcchescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlEscapeA(pszurl.param().abi(), core::mem::transmute(pszescaped), pcchescaped, dwflags).ok()
}
#[inline]
pub unsafe fn UrlEscapeW<P0>(pszurl: P0, pszescaped: windows_core::PWSTR, pcchescaped: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlEscapeW(pszurl : windows_core::PCWSTR, pszescaped : windows_core::PWSTR, pcchescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlEscapeW(pszurl.param().abi(), core::mem::transmute(pszescaped), pcchescaped, dwflags).ok()
}
#[inline]
pub unsafe fn UrlFixupW<P0>(pcszurl: P0, psztranslatedurl: &mut [u16]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlFixupW(pcszurl : windows_core::PCWSTR, psztranslatedurl : windows_core::PWSTR, cchmax : u32) -> windows_core::HRESULT);
    UrlFixupW(pcszurl.param().abi(), core::mem::transmute(psztranslatedurl.as_ptr()), psztranslatedurl.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn UrlGetLocationA<P0>(pszurl: P0) -> windows_core::PCSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlGetLocationA(pszurl : windows_core::PCSTR) -> windows_core::PCSTR);
    UrlGetLocationA(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlGetLocationW<P0>(pszurl: P0) -> windows_core::PCWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlGetLocationW(pszurl : windows_core::PCWSTR) -> windows_core::PCWSTR);
    UrlGetLocationW(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlGetPartA<P0>(pszin: P0, pszout: windows_core::PSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlGetPartA(pszin : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32, dwpart : u32, dwflags : u32) -> windows_core::HRESULT);
    UrlGetPartA(pszin.param().abi(), core::mem::transmute(pszout), pcchout, dwpart, dwflags).ok()
}
#[inline]
pub unsafe fn UrlGetPartW<P0>(pszin: P0, pszout: windows_core::PWSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlGetPartW(pszin : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32, dwpart : u32, dwflags : u32) -> windows_core::HRESULT);
    UrlGetPartW(pszin.param().abi(), core::mem::transmute(pszout), pcchout, dwpart, dwflags).ok()
}
#[inline]
pub unsafe fn UrlHashA<P0>(pszurl: P0, pbhash: &mut [u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlHashA(pszurl : windows_core::PCSTR, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    UrlHashA(pszurl.param().abi(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn UrlHashW<P0>(pszurl: P0, pbhash: &mut [u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlHashW(pszurl : windows_core::PCWSTR, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    UrlHashW(pszurl.param().abi(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn UrlIsA<P0>(pszurl: P0, urlis: URLIS) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsA(pszurl : windows_core::PCSTR, urlis : URLIS) -> super::super::Foundation:: BOOL);
    UrlIsA(pszurl.param().abi(), urlis)
}
#[inline]
pub unsafe fn UrlIsNoHistoryA<P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsNoHistoryA(pszurl : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    UrlIsNoHistoryA(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlIsNoHistoryW<P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsNoHistoryW(pszurl : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    UrlIsNoHistoryW(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlIsOpaqueA<P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsOpaqueA(pszurl : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    UrlIsOpaqueA(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlIsOpaqueW<P0>(pszurl: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsOpaqueW(pszurl : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    UrlIsOpaqueW(pszurl.param().abi())
}
#[inline]
pub unsafe fn UrlIsW<P0>(pszurl: P0, urlis: URLIS) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn UrlIsW(pszurl : windows_core::PCWSTR, urlis : URLIS) -> super::super::Foundation:: BOOL);
    UrlIsW(pszurl.param().abi(), urlis)
}
#[inline]
pub unsafe fn UrlUnescapeA(pszurl: windows_core::PSTR, pszunescaped: windows_core::PSTR, pcchunescaped: Option<*mut u32>, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn UrlUnescapeA(pszurl : windows_core::PSTR, pszunescaped : windows_core::PSTR, pcchunescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlUnescapeA(core::mem::transmute(pszurl), core::mem::transmute(pszunescaped), core::mem::transmute(pcchunescaped.unwrap_or(std::ptr::null_mut())), dwflags).ok()
}
#[inline]
pub unsafe fn UrlUnescapeW(pszurl: windows_core::PWSTR, pszunescaped: windows_core::PWSTR, pcchunescaped: Option<*mut u32>, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("shlwapi.dll" "system" fn UrlUnescapeW(pszurl : windows_core::PWSTR, pszunescaped : windows_core::PWSTR, pcchunescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    UrlUnescapeW(core::mem::transmute(pszurl), core::mem::transmute(pszunescaped), core::mem::transmute(pcchunescaped.unwrap_or(std::ptr::null_mut())), dwflags).ok()
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn VariantToStrRet(varin: *const windows_core::VARIANT, pstrret: *mut Common::STRRET) -> windows_core::Result<()> {
    windows_targets::link!("propsys.dll" "system" fn VariantToStrRet(varin : *const core::mem::MaybeUninit < windows_core::VARIANT >, pstrret : *mut Common:: STRRET) -> windows_core::HRESULT);
    VariantToStrRet(core::mem::transmute(varin), pstrret).ok()
}
#[inline]
pub unsafe fn WhichPlatform() -> u32 {
    windows_targets::link!("shlwapi.dll" "system" fn WhichPlatform() -> u32);
    WhichPlatform()
}
#[inline]
pub unsafe fn Win32DeleteFile<P0>(pszpath: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shell32.dll" "system" fn Win32DeleteFile(pszpath : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    Win32DeleteFile(pszpath.param().abi())
}
#[inline]
pub unsafe fn WinHelpA<P0, P1>(hwndmain: P0, lpszhelp: P1, ucommand: u32, dwdata: usize) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("user32.dll" "system" fn WinHelpA(hwndmain : super::super::Foundation:: HWND, lpszhelp : windows_core::PCSTR, ucommand : u32, dwdata : usize) -> super::super::Foundation:: BOOL);
    WinHelpA(hwndmain.param().abi(), lpszhelp.param().abi(), ucommand, dwdata).ok()
}
#[inline]
pub unsafe fn WinHelpW<P0, P1>(hwndmain: P0, lpszhelp: P1, ucommand: u32, dwdata: usize) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("user32.dll" "system" fn WinHelpW(hwndmain : super::super::Foundation:: HWND, lpszhelp : windows_core::PCWSTR, ucommand : u32, dwdata : usize) -> super::super::Foundation:: BOOL);
    WinHelpW(hwndmain.param().abi(), lpszhelp.param().abi(), ucommand, dwdata).ok()
}
#[inline]
pub unsafe fn WriteCabinetState(pcs: *const CABINETSTATE) -> super::super::Foundation::BOOL {
    windows_targets::link!("shell32.dll" "system" fn WriteCabinetState(pcs : *const CABINETSTATE) -> super::super::Foundation:: BOOL);
    WriteCabinetState(pcs)
}
#[inline]
pub unsafe fn wnsprintfA<P0>(pszdest: &mut [u8], pszfmt: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "cdecl" fn wnsprintfA(pszdest : windows_core::PSTR, cchdest : i32, pszfmt : windows_core::PCSTR) -> i32);
    wnsprintfA(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi())
}
#[inline]
pub unsafe fn wnsprintfW<P0>(pszdest: &mut [u16], pszfmt: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "cdecl" fn wnsprintfW(pszdest : windows_core::PWSTR, cchdest : i32, pszfmt : windows_core::PCWSTR) -> i32);
    wnsprintfW(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi())
}
#[inline]
pub unsafe fn wvnsprintfA<P0>(pszdest: &mut [u8], pszfmt: P0, arglist: *const i8) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn wvnsprintfA(pszdest : windows_core::PSTR, cchdest : i32, pszfmt : windows_core::PCSTR, arglist : *const i8) -> i32);
    wvnsprintfA(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi(), arglist)
}
#[inline]
pub unsafe fn wvnsprintfW<P0>(pszdest: &mut [u16], pszfmt: P0, arglist: *const i8) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("shlwapi.dll" "system" fn wvnsprintfW(pszdest : windows_core::PWSTR, cchdest : i32, pszfmt : windows_core::PCWSTR, arglist : *const i8) -> i32);
    wvnsprintfW(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi(), arglist)
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(CIE4ConnectionPoint, CIE4ConnectionPoint_Vtbl, 0);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for CIE4ConnectionPoint {
    type Target = super::super::System::Com::IConnectionPoint;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(CIE4ConnectionPoint, windows_core::IUnknown, super::super::System::Com::IConnectionPoint);
#[cfg(feature = "Win32_System_Com")]
impl CIE4ConnectionPoint {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn DoInvokeIE4(&self, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DoInvokeIE4)(windows_core::Interface::as_raw(self), pf, ppv, dispid, pdispparams).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn DoInvokePIDLIE4<P0>(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).DoInvokePIDLIE4)(windows_core::Interface::as_raw(self), dispid, pidl, fcancancel.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct CIE4ConnectionPoint_Vtbl {
    pub base__: super::super::System::Com::IConnectionPoint_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub DoInvokeIE4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL, *mut *mut core::ffi::c_void, i32, *mut super::super::System::Com::DISPPARAMS) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    DoInvokeIE4: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub DoInvokePIDLIE4: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut Common::ITEMIDLIST, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    DoInvokePIDLIE4: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DFConstraint, DFConstraint_Vtbl, 0x4a3df050_23bd_11d2_939f_00a0c91eedba);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DFConstraint {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DFConstraint, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DFConstraint {
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Value(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Value)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DFConstraint_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Value: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellFolderViewEvents, DShellFolderViewEvents_Vtbl, 0x62112aa2_ebe4_11cf_a5fb_0020afe7292d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellFolderViewEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellFolderViewEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DShellFolderViewEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellNameSpaceEvents, DShellNameSpaceEvents_Vtbl, 0x55136806_b2de_11d1_b9f2_00a0c98bc547);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellNameSpaceEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellNameSpaceEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DShellNameSpaceEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellWindowsEvents, DShellWindowsEvents_Vtbl, 0xfe4106e0_399a_11d0_a48c_00a0c90a8f39);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellWindowsEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellWindowsEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DShellWindowsEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DWebBrowserEvents, DWebBrowserEvents_Vtbl, 0xeab22ac2_30c1_11cf_a7eb_0000c05bae0b);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DWebBrowserEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DWebBrowserEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DWebBrowserEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DWebBrowserEvents2, DWebBrowserEvents2_Vtbl, 0x34a715a0_6587_11d0_924a_0020afc7ac4d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DWebBrowserEvents2 {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DWebBrowserEvents2, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct DWebBrowserEvents2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder, Folder_Vtbl, 0xbbcbde60_c3ff_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl Folder {
    pub unsafe fn Title(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Title)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> windows_core::Result<Folder> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ParentFolder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> windows_core::Result<FolderItems> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Items)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseName<P0>(&self, bname: P0) -> windows_core::Result<FolderItem>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ParseName)(windows_core::Interface::as_raw(self), bname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn NewFolder<P0, P1>(&self, bname: P0, voptions: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).NewFolder)(windows_core::Interface::as_raw(self), bname.param().abi(), voptions.param().abi()).ok()
    }
    pub unsafe fn MoveHere<P0, P1>(&self, vitem: P0, voptions: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
        P1: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).MoveHere)(windows_core::Interface::as_raw(self), vitem.param().abi(), voptions.param().abi()).ok()
    }
    pub unsafe fn CopyHere<P0, P1>(&self, vitem: P0, voptions: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
        P1: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).CopyHere)(windows_core::Interface::as_raw(self), vitem.param().abi(), voptions.param().abi()).ok()
    }
    pub unsafe fn GetDetailsOf<P0>(&self, vitem: P0, icolumn: i32) -> windows_core::Result<windows_core::BSTR>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDetailsOf)(windows_core::Interface::as_raw(self), vitem.param().abi(), icolumn, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct Folder_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Title: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParentFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParentFolder: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Items: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Items: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseName: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::BSTR>, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseName: usize,
    pub NewFolder: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::BSTR>, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub MoveHere: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub CopyHere: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetDetailsOf: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, i32, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder2, Folder2_Vtbl, 0xf0d2d8ef_3890_11d2_bf8b_00c04fb93661);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder2 {
    type Target = Folder;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder2, windows_core::IUnknown, super::super::System::Com::IDispatch, Folder);
#[cfg(feature = "Win32_System_Com")]
impl Folder2 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> windows_core::Result<FolderItem> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Self_)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn OfflineStatus(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OfflineStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Synchronize(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Synchronize)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).HaveToShowWebViewBarricade)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DismissedWebViewBarricade)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct Folder2_Vtbl {
    pub base__: Folder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Self_: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Self_: usize,
    pub OfflineStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Synchronize: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub HaveToShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub DismissedWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder3, Folder3_Vtbl, 0xa7ae5f64_c4d7_4d7f_9307_4d24ee54b841);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder3 {
    type Target = Folder2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder3, windows_core::IUnknown, super::super::System::Com::IDispatch, Folder, Folder2);
#[cfg(feature = "Win32_System_Com")]
impl Folder3 {
    pub unsafe fn ShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ShowWebViewBarricade)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetShowWebViewBarricade<P0>(&self, bshowwebviewbarricade: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).SetShowWebViewBarricade)(windows_core::Interface::as_raw(self), bshowwebviewbarricade.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct Folder3_Vtbl {
    pub base__: Folder2_Vtbl,
    pub ShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItem, FolderItem_Vtbl, 0xfac32c80_cbe4_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItem {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItem, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetName<P0>(&self, bs: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetName)(windows_core::Interface::as_raw(self), bs.param().abi()).ok()
    }
    pub unsafe fn Path(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Path)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetLink)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn IsLink(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsLink)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsFolder(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsFolder)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsFileSystem(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsFileSystem)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsBrowsable(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsBrowsable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ModifyDate(&self) -> windows_core::Result<f64> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ModifyDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetModifyDate)(windows_core::Interface::as_raw(self), dt).ok()
    }
    pub unsafe fn Size(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Size)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Type(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Type)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> windows_core::Result<FolderItemVerbs> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Verbs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InvokeVerb<P0>(&self, vverb: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).InvokeVerb)(windows_core::Interface::as_raw(self), vverb.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItem_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub SetName: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Path: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetLink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetLink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFolder: usize,
    pub IsLink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsFileSystem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsBrowsable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub ModifyDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetModifyDate: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Size: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Type: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
    pub InvokeVerb: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItem2, FolderItem2_Vtbl, 0xedc817aa_92b8_11d1_b075_00c04fc33aa5);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItem2 {
    type Target = FolderItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItem2, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItem);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem2 {
    pub unsafe fn InvokeVerbEx<P0, P1>(&self, vverb: P0, vargs: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
        P1: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).InvokeVerbEx)(windows_core::Interface::as_raw(self), vverb.param().abi(), vargs.param().abi()).ok()
    }
    pub unsafe fn ExtendedProperty<P0>(&self, bstrpropname: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ExtendedProperty)(windows_core::Interface::as_raw(self), bstrpropname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItem2_Vtbl {
    pub base__: FolderItem_Vtbl,
    pub InvokeVerbEx: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub ExtendedProperty: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::BSTR>, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItemVerb, FolderItemVerb_Vtbl, 0x08ec3e00_50b0_11cf_960c_0080c7f4ee85);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItemVerb {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItemVerb, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerb {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn DoIt(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DoIt)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItemVerb_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub DoIt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItemVerbs, FolderItemVerbs_Vtbl, 0x1f8352c0_50b0_11cf_960c_0080c7f4ee85);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItemVerbs {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItemVerbs, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerbs {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Item<P0>(&self, index: P0) -> windows_core::Result<FolderItemVerb>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), index.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItemVerbs_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems, FolderItems_Vtbl, 0x744129e0_cbe5_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Item<P0>(&self, index: P0) -> windows_core::Result<FolderItem>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), index.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItems_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems2, FolderItems2_Vtbl, 0xc94f0ad0_f363_11d2_a327_00c04f8eec7f);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems2 {
    type Target = FolderItems;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems2, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItems);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems2 {
    pub unsafe fn InvokeVerbEx<P0, P1>(&self, vverb: P0, vargs: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
        P1: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).InvokeVerbEx)(windows_core::Interface::as_raw(self), vverb.param().abi(), vargs.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItems2_Vtbl {
    pub base__: FolderItems_Vtbl,
    pub InvokeVerbEx: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::VARIANT>, core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems3, FolderItems3_Vtbl, 0xeaa7c309_bbec_49d5_821d_64d966cb667f);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems3 {
    type Target = FolderItems2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems3, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItems, FolderItems2);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems3 {
    pub unsafe fn Filter<P0>(&self, grfflags: i32, bstrfilespec: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).Filter)(windows_core::Interface::as_raw(self), grfflags, bstrfilespec.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> windows_core::Result<FolderItemVerbs> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Verbs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct FolderItems3_Vtbl {
    pub base__: FolderItems2_Vtbl,
    pub Filter: unsafe extern "system" fn(*mut core::ffi::c_void, i32, core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
}
windows_core::imp::define_interface!(IACList, IACList_Vtbl, 0x77a130b0_94fd_11d0_a544_00c04fd7d062);
impl core::ops::Deref for IACList {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IACList, windows_core::IUnknown);
impl IACList {
    pub unsafe fn Expand<P0>(&self, pszexpand: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Expand)(windows_core::Interface::as_raw(self), pszexpand.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IACList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Expand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IACList2, IACList2_Vtbl, 0x470141a0_5186_11d2_bbb6_0060977b464c);
impl core::ops::Deref for IACList2 {
    type Target = IACList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IACList2, windows_core::IUnknown, IACList);
impl IACList2 {
    pub unsafe fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IACList2_Vtbl {
    pub base__: IACList_Vtbl,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAccessibilityDockingService, IAccessibilityDockingService_Vtbl, 0x8849dc22_cedf_4c95_998d_051419dd3f76);
impl core::ops::Deref for IAccessibilityDockingService {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAccessibilityDockingService, windows_core::IUnknown);
impl IAccessibilityDockingService {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableSize<P0>(&self, hmonitor: P0, pcxfixed: *mut u32, pcymax: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
    {
        (windows_core::Interface::vtable(self).GetAvailableSize)(windows_core::Interface::as_raw(self), hmonitor.param().abi(), pcxfixed, pcymax).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn DockWindow<P0, P1, P2>(&self, hwnd: P0, hmonitor: P1, cyrequested: u32, pcallback: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
        P2: windows_core::Param<IAccessibilityDockingServiceCallback>,
    {
        (windows_core::Interface::vtable(self).DockWindow)(windows_core::Interface::as_raw(self), hwnd.param().abi(), hmonitor.param().abi(), cyrequested, pcallback.param().abi()).ok()
    }
    pub unsafe fn UndockWindow<P0>(&self, hwnd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).UndockWindow)(windows_core::Interface::as_raw(self), hwnd.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAccessibilityDockingService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, *mut u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableSize: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub DockWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, super::super::Graphics::Gdi::HMONITOR, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    DockWindow: usize,
    pub UndockWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAccessibilityDockingServiceCallback, IAccessibilityDockingServiceCallback_Vtbl, 0x157733fd_a592_42e5_b594_248468c5a81b);
impl core::ops::Deref for IAccessibilityDockingServiceCallback {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAccessibilityDockingServiceCallback, windows_core::IUnknown);
impl IAccessibilityDockingServiceCallback {
    pub unsafe fn Undocked(&self, undockreason: UNDOCK_REASON) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Undocked)(windows_core::Interface::as_raw(self), undockreason).ok()
    }
}
#[repr(C)]
pub struct IAccessibilityDockingServiceCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Undocked: unsafe extern "system" fn(*mut core::ffi::c_void, UNDOCK_REASON) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAccessibleObject, IAccessibleObject_Vtbl, 0x95a391c5_9ed4_4c28_8401_ab9e06719e11);
impl core::ops::Deref for IAccessibleObject {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAccessibleObject, windows_core::IUnknown);
impl IAccessibleObject {
    pub unsafe fn SetAccessibleName<P0>(&self, pszname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAccessibleName)(windows_core::Interface::as_raw(self), pszname.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAccessibleObject_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAccessibleName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IActionProgress, IActionProgress_Vtbl, 0x49ff1173_eadc_446d_9285_156453a6431c);
impl core::ops::Deref for IActionProgress {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IActionProgress, windows_core::IUnknown);
impl IActionProgress {
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Begin)(windows_core::Interface::as_raw(self), action, flags).ok()
    }
    pub unsafe fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateProgress)(windows_core::Interface::as_raw(self), ulcompleted, ultotal).ok()
    }
    pub unsafe fn UpdateText<P0, P1>(&self, sptext: SPTEXT, psztext: P0, fmaycompact: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).UpdateText)(windows_core::Interface::as_raw(self), sptext, psztext.param().abi(), fmaycompact.param().abi()).ok()
    }
    pub unsafe fn QueryCancel(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryCancel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ResetCancel(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetCancel)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn End(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).End)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IActionProgress_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Begin: unsafe extern "system" fn(*mut core::ffi::c_void, SPACTION, u32) -> windows_core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64) -> windows_core::HRESULT,
    pub UpdateText: unsafe extern "system" fn(*mut core::ffi::c_void, SPTEXT, windows_core::PCWSTR, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub QueryCancel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub ResetCancel: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub End: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IActionProgressDialog, IActionProgressDialog_Vtbl, 0x49ff1172_eadc_446d_9285_156453a6431c);
impl core::ops::Deref for IActionProgressDialog {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IActionProgressDialog, windows_core::IUnknown);
impl IActionProgressDialog {
    pub unsafe fn Initialize<P0, P1>(&self, flags: u32, psztitle: P0, pszcancel: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), flags, psztitle.param().abi(), pszcancel.param().abi()).ok()
    }
    pub unsafe fn Stop(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Stop)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IActionProgressDialog_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAppActivationUIInfo, IAppActivationUIInfo_Vtbl, 0xabad189d_9fa3_4278_b3ca_8ca448a88dcb);
impl core::ops::Deref for IAppActivationUIInfo {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAppActivationUIInfo, windows_core::IUnknown);
impl IAppActivationUIInfo {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> windows_core::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMonitor)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetInvokePoint(&self) -> windows_core::Result<super::super::Foundation::POINT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetInvokePoint)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetShowCommand(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetShowCommand)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetShowUI(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetShowUI)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetKeyState(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetKeyState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAppActivationUIInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
    pub GetInvokePoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::POINT) -> windows_core::HRESULT,
    pub GetShowCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetShowUI: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetKeyState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAppPublisher, IAppPublisher_Vtbl, 0x07250a10_9cf9_11d1_9076_006008059382);
impl core::ops::Deref for IAppPublisher {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAppPublisher, windows_core::IUnknown);
impl IAppPublisher {
    pub unsafe fn GetNumberOfCategories(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOfCategories)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCategories(&self) -> windows_core::Result<APPCATEGORYINFOLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCategories)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOfApps(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNumberOfApps)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn EnumApps(&self, pappcategoryid: *const windows_core::GUID) -> windows_core::Result<IEnumPublishedApps> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumApps)(windows_core::Interface::as_raw(self), pappcategoryid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IAppPublisher_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetNumberOfCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut APPCATEGORYINFOLIST) -> windows_core::HRESULT,
    pub GetNumberOfApps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub EnumApps: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAppVisibility, IAppVisibility_Vtbl, 0x2246ea2d_caea_4444_a3c4_6de827e44313);
impl core::ops::Deref for IAppVisibility {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAppVisibility, windows_core::IUnknown);
impl IAppVisibility {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor<P0>(&self, hmonitor: P0) -> windows_core::Result<MONITOR_APP_VISIBILITY>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAppVisibilityOnMonitor)(windows_core::Interface::as_raw(self), hmonitor.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn IsLauncherVisible(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsLauncherVisible)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Advise<P0>(&self, pcallback: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IAppVisibilityEvents>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcallback.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
}
#[repr(C)]
pub struct IAppVisibility_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAppVisibilityOnMonitor: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, *mut MONITOR_APP_VISIBILITY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAppVisibilityOnMonitor: usize,
    pub IsLauncherVisible: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAppVisibilityEvents, IAppVisibilityEvents_Vtbl, 0x6584ce6b_7d82_49c2_89c9_c6bc02ba8c38);
impl core::ops::Deref for IAppVisibilityEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAppVisibilityEvents, windows_core::IUnknown);
impl IAppVisibilityEvents {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged<P0>(&self, hmonitor: P0, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
    {
        (windows_core::Interface::vtable(self).AppVisibilityOnMonitorChanged)(windows_core::Interface::as_raw(self), hmonitor.param().abi(), previousmode, currentmode).ok()
    }
    pub unsafe fn LauncherVisibilityChange<P0>(&self, currentvisiblestate: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).LauncherVisibilityChange)(windows_core::Interface::as_raw(self), currentvisiblestate.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAppVisibilityEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub AppVisibilityOnMonitorChanged: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, MONITOR_APP_VISIBILITY, MONITOR_APP_VISIBILITY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    AppVisibilityOnMonitorChanged: usize,
    pub LauncherVisibilityChange: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationActivationManager, IApplicationActivationManager_Vtbl, 0x2e941141_7f97_4756_ba1d_9decde894a3d);
impl core::ops::Deref for IApplicationActivationManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationActivationManager, windows_core::IUnknown);
impl IApplicationActivationManager {
    pub unsafe fn ActivateApplication<P0, P1>(&self, appusermodelid: P0, arguments: P1, options: ACTIVATEOPTIONS) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ActivateApplication)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), arguments.param().abi(), options, &mut result__).map(|| result__)
    }
    pub unsafe fn ActivateForFile<P0, P1, P2>(&self, appusermodelid: P0, itemarray: P1, verb: P2) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IShellItemArray>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ActivateForFile)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), itemarray.param().abi(), verb.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn ActivateForProtocol<P0, P1>(&self, appusermodelid: P0, itemarray: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IShellItemArray>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ActivateForProtocol)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), itemarray.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IApplicationActivationManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ActivateApplication: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, ACTIVATEOPTIONS, *mut u32) -> windows_core::HRESULT,
    pub ActivateForFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void, windows_core::PCWSTR, *mut u32) -> windows_core::HRESULT,
    pub ActivateForProtocol: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationAssociationRegistration, IApplicationAssociationRegistration_Vtbl, 0x4e530b0a_e611_4c77_a3ac_9031d022281b);
impl core::ops::Deref for IApplicationAssociationRegistration {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationAssociationRegistration, windows_core::IUnknown);
impl IApplicationAssociationRegistration {
    pub unsafe fn QueryCurrentDefault<P0>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryCurrentDefault)(windows_core::Interface::as_raw(self), pszquery.param().abi(), atquerytype, alquerylevel, &mut result__).map(|| result__)
    }
    pub unsafe fn QueryAppIsDefault<P0, P1>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P1) -> windows_core::Result<super::super::Foundation::BOOL>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryAppIsDefault)(windows_core::Interface::as_raw(self), pszquery.param().abi(), atquerytype, alquerylevel, pszappregistryname.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn QueryAppIsDefaultAll<P0>(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P0) -> windows_core::Result<super::super::Foundation::BOOL>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryAppIsDefaultAll)(windows_core::Interface::as_raw(self), alquerylevel, pszappregistryname.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAppAsDefault<P0, P1>(&self, pszappregistryname: P0, pszset: P1, atsettype: ASSOCIATIONTYPE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppAsDefault)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi(), pszset.param().abi(), atsettype).ok()
    }
    pub unsafe fn SetAppAsDefaultAll<P0>(&self, pszappregistryname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppAsDefaultAll)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi()).ok()
    }
    pub unsafe fn ClearUserAssociations(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ClearUserAssociations)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IApplicationAssociationRegistration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryCurrentDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, ASSOCIATIONTYPE, ASSOCIATIONLEVEL, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub QueryAppIsDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, ASSOCIATIONTYPE, ASSOCIATIONLEVEL, windows_core::PCWSTR, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub QueryAppIsDefaultAll: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCIATIONLEVEL, windows_core::PCWSTR, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetAppAsDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, ASSOCIATIONTYPE) -> windows_core::HRESULT,
    pub SetAppAsDefaultAll: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ClearUserAssociations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationAssociationRegistrationUI, IApplicationAssociationRegistrationUI_Vtbl, 0x1f76a169_f994_40ac_8fc8_0959e8874710);
impl core::ops::Deref for IApplicationAssociationRegistrationUI {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationAssociationRegistrationUI, windows_core::IUnknown);
impl IApplicationAssociationRegistrationUI {
    pub unsafe fn LaunchAdvancedAssociationUI<P0>(&self, pszappregistryname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).LaunchAdvancedAssociationUI)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IApplicationAssociationRegistrationUI_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub LaunchAdvancedAssociationUI: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationDesignModeSettings, IApplicationDesignModeSettings_Vtbl, 0x2a3dee9a_e31d_46d6_8508_bcc597db3557);
impl core::ops::Deref for IApplicationDesignModeSettings {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationDesignModeSettings, windows_core::IUnknown);
impl IApplicationDesignModeSettings {
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNativeDisplaySize)(windows_core::Interface::as_raw(self), core::mem::transmute(nativedisplaysizepixels)).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetScaleFactor)(windows_core::Interface::as_raw(self), scalefactor).ok()
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetApplicationViewState)(windows_core::Interface::as_raw(self), viewstate).ok()
    }
    pub unsafe fn ComputeApplicationSize(&self) -> windows_core::Result<super::super::Foundation::SIZE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ComputeApplicationSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsApplicationViewStateSupported)(windows_core::Interface::as_raw(self), viewstate, core::mem::transmute(nativedisplaysizepixels), scalefactor, &mut result__).map(|| result__)
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TriggerEdgeGesture)(windows_core::Interface::as_raw(self), edgegesturekind).ok()
    }
}
#[repr(C)]
pub struct IApplicationDesignModeSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetNativeDisplaySize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::SIZE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetScaleFactor: unsafe extern "system" fn(*mut core::ffi::c_void, Common::DEVICE_SCALE_FACTOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetScaleFactor: usize,
    pub SetApplicationViewState: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_STATE) -> windows_core::HRESULT,
    pub ComputeApplicationSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::SIZE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IsApplicationViewStateSupported: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_STATE, super::super::Foundation::SIZE, Common::DEVICE_SCALE_FACTOR, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IsApplicationViewStateSupported: usize,
    pub TriggerEdgeGesture: unsafe extern "system" fn(*mut core::ffi::c_void, EDGE_GESTURE_KIND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationDesignModeSettings2, IApplicationDesignModeSettings2_Vtbl, 0x490514e1_675a_4d6e_a58d_e54901b4ca2f);
impl core::ops::Deref for IApplicationDesignModeSettings2 {
    type Target = IApplicationDesignModeSettings;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationDesignModeSettings2, windows_core::IUnknown, IApplicationDesignModeSettings);
impl IApplicationDesignModeSettings2 {
    pub unsafe fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNativeDisplayOrientation)(windows_core::Interface::as_raw(self), nativedisplayorientation).ok()
    }
    pub unsafe fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetApplicationViewOrientation)(windows_core::Interface::as_raw(self), vieworientation).ok()
    }
    pub unsafe fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAdjacentDisplayEdges)(windows_core::Interface::as_raw(self), adjacentdisplayedges).ok()
    }
    pub unsafe fn SetIsOnLockScreen<P0>(&self, isonlockscreen: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetIsOnLockScreen)(windows_core::Interface::as_raw(self), isonlockscreen.param().abi()).ok()
    }
    pub unsafe fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetApplicationViewMinWidth)(windows_core::Interface::as_raw(self), viewminwidth).ok()
    }
    pub unsafe fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetApplicationSizeBounds)(windows_core::Interface::as_raw(self), minapplicationsizepixels, maxapplicationsizepixels).ok()
    }
    pub unsafe fn GetApplicationViewOrientation(&self, applicationsizepixels: super::super::Foundation::SIZE) -> windows_core::Result<APPLICATION_VIEW_ORIENTATION> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetApplicationViewOrientation)(windows_core::Interface::as_raw(self), core::mem::transmute(applicationsizepixels), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IApplicationDesignModeSettings2_Vtbl {
    pub base__: IApplicationDesignModeSettings_Vtbl,
    pub SetNativeDisplayOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, NATIVE_DISPLAY_ORIENTATION) -> windows_core::HRESULT,
    pub SetApplicationViewOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT,
    pub SetAdjacentDisplayEdges: unsafe extern "system" fn(*mut core::ffi::c_void, ADJACENT_DISPLAY_EDGES) -> windows_core::HRESULT,
    pub SetIsOnLockScreen: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetApplicationViewMinWidth: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_MIN_WIDTH) -> windows_core::HRESULT,
    pub GetApplicationSizeBounds: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::SIZE, *mut super::super::Foundation::SIZE) -> windows_core::HRESULT,
    pub GetApplicationViewOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::SIZE, *mut APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationDestinations, IApplicationDestinations_Vtbl, 0x12337d35_94c6_48a0_bce7_6a9c69d4d600);
impl core::ops::Deref for IApplicationDestinations {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationDestinations, windows_core::IUnknown);
impl IApplicationDestinations {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok()
    }
    pub unsafe fn RemoveDestination<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).RemoveDestination)(windows_core::Interface::as_raw(self), punk.param().abi()).ok()
    }
    pub unsafe fn RemoveAllDestinations(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAllDestinations)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IApplicationDestinations_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub RemoveDestination: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAllDestinations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IApplicationDocumentLists, IApplicationDocumentLists_Vtbl, 0x3c594f9f_9f30_47a1_979a_c9e83d3d0a06);
impl core::ops::Deref for IApplicationDocumentLists {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationDocumentLists, windows_core::IUnknown);
impl IApplicationDocumentLists {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok()
    }
    pub unsafe fn GetList<T>(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetList)(windows_core::Interface::as_raw(self), listtype, citemsdesired, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IApplicationDocumentLists_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetList: unsafe extern "system" fn(*mut core::ffi::c_void, APPDOCLISTTYPE, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAssocHandler, IAssocHandler_Vtbl, 0xf04061ac_1659_4a3f_a954_775aa57fc083);
impl core::ops::Deref for IAssocHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAssocHandler, windows_core::IUnknown);
impl IAssocHandler {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetUIName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetUIName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetIconLocation(&self, ppszpath: *mut windows_core::PWSTR, pindex: *mut i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIconLocation)(windows_core::Interface::as_raw(self), ppszpath, pindex).ok()
    }
    pub unsafe fn IsRecommended(&self) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).IsRecommended)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn MakeDefault<P0>(&self, pszdescription: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).MakeDefault)(windows_core::Interface::as_raw(self), pszdescription.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<P0>(&self, pdo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).Invoke)(windows_core::Interface::as_raw(self), pdo.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<P0>(&self, pdo: P0) -> windows_core::Result<IAssocHandlerInvoker>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateInvoker)(windows_core::Interface::as_raw(self), pdo.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IAssocHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetUIName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetIconLocation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR, *mut i32) -> windows_core::HRESULT,
    pub IsRecommended: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MakeDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateInvoker: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateInvoker: usize,
}
windows_core::imp::define_interface!(IAssocHandlerInvoker, IAssocHandlerInvoker_Vtbl, 0x92218cab_ecaa_4335_8133_807fd234c2ee);
impl core::ops::Deref for IAssocHandlerInvoker {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAssocHandlerInvoker, windows_core::IUnknown);
impl IAssocHandlerInvoker {
    pub unsafe fn SupportsSelection(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SupportsSelection)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Invoke(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Invoke)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAssocHandlerInvoker_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SupportsSelection: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Invoke: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAttachmentExecute, IAttachmentExecute_Vtbl, 0x73db1241_1e85_4581_8e4f_a81e1d0f8c57);
impl core::ops::Deref for IAttachmentExecute {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAttachmentExecute, windows_core::IUnknown);
impl IAttachmentExecute {
    pub unsafe fn SetClientTitle<P0>(&self, psztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetClientTitle)(windows_core::Interface::as_raw(self), psztitle.param().abi()).ok()
    }
    pub unsafe fn SetClientGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetClientGuid)(windows_core::Interface::as_raw(self), guid).ok()
    }
    pub unsafe fn SetLocalPath<P0>(&self, pszlocalpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetLocalPath)(windows_core::Interface::as_raw(self), pszlocalpath.param().abi()).ok()
    }
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFileName)(windows_core::Interface::as_raw(self), pszfilename.param().abi()).ok()
    }
    pub unsafe fn SetSource<P0>(&self, pszsource: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetSource)(windows_core::Interface::as_raw(self), pszsource.param().abi()).ok()
    }
    pub unsafe fn SetReferrer<P0>(&self, pszreferrer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetReferrer)(windows_core::Interface::as_raw(self), pszreferrer.param().abi()).ok()
    }
    pub unsafe fn CheckPolicy(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CheckPolicy)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Prompt<P0>(&self, hwnd: P0, prompt: ATTACHMENT_PROMPT) -> windows_core::Result<ATTACHMENT_ACTION>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Prompt)(windows_core::Interface::as_raw(self), hwnd.param().abi(), prompt, &mut result__).map(|| result__)
    }
    pub unsafe fn Save(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Save)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Execute<P0, P1>(&self, hwnd: P0, pszverb: P1, phprocess: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), hwnd.param().abi(), pszverb.param().abi(), core::mem::transmute(phprocess.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SaveWithUI<P0>(&self, hwnd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SaveWithUI)(windows_core::Interface::as_raw(self), hwnd.param().abi()).ok()
    }
    pub unsafe fn ClearClientState(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ClearClientState)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAttachmentExecute_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetClientTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetClientGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub SetLocalPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFileName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetReferrer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CheckPolicy: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Prompt: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, ATTACHMENT_PROMPT, *mut ATTACHMENT_ACTION) -> windows_core::HRESULT,
    pub Save: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::PCWSTR, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub SaveWithUI: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub ClearClientState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAutoComplete, IAutoComplete_Vtbl, 0x00bb2762_6a77_11d0_a535_00c04fd7d062);
impl core::ops::Deref for IAutoComplete {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAutoComplete, windows_core::IUnknown);
impl IAutoComplete {
    pub unsafe fn Init<P0, P1, P2, P3>(&self, hwndedit: P0, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::IUnknown>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Init)(windows_core::Interface::as_raw(self), hwndedit.param().abi(), punkacl.param().abi(), pwszregkeypath.param().abi(), pwszquickcomplete.param().abi()).ok()
    }
    pub unsafe fn Enable<P0>(&self, fenable: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self), fenable.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAutoComplete_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Init: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAutoComplete2, IAutoComplete2_Vtbl, 0xeac04bc0_3791_11d2_bb95_0060977b464c);
impl core::ops::Deref for IAutoComplete2 {
    type Target = IAutoComplete;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAutoComplete2, windows_core::IUnknown, IAutoComplete);
impl IAutoComplete2 {
    pub unsafe fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAutoComplete2_Vtbl {
    pub base__: IAutoComplete_Vtbl,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IAutoCompleteDropDown, IAutoCompleteDropDown_Vtbl, 0x3cd141f4_3c6a_11d2_bcaa_00c04fd929db);
impl core::ops::Deref for IAutoCompleteDropDown {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAutoCompleteDropDown, windows_core::IUnknown);
impl IAutoCompleteDropDown {
    pub unsafe fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDropDownStatus)(windows_core::Interface::as_raw(self), pdwflags, ppwszstring).ok()
    }
    pub unsafe fn ResetEnumerator(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetEnumerator)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAutoCompleteDropDown_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDropDownStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub ResetEnumerator: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBandHost, IBandHost_Vtbl, 0xb9075c7c_d48e_403f_ab99_d6c77a1084ac);
impl core::ops::Deref for IBandHost {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBandHost, windows_core::IUnknown);
impl IBandHost {
    pub unsafe fn CreateBand<P0, P1, T>(&self, rclsidband: *const windows_core::GUID, favailable: P0, fvisible: P1) -> windows_core::Result<T>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).CreateBand)(windows_core::Interface::as_raw(self), rclsidband, favailable.param().abi(), fvisible.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetBandAvailability<P0>(&self, rclsidband: *const windows_core::GUID, favailable: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetBandAvailability)(windows_core::Interface::as_raw(self), rclsidband, favailable.param().abi()).ok()
    }
    pub unsafe fn DestroyBand(&self, rclsidband: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DestroyBand)(windows_core::Interface::as_raw(self), rclsidband).ok()
    }
}
#[repr(C)]
pub struct IBandHost_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CreateBand: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, super::super::Foundation::BOOL, super::super::Foundation::BOOL, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBandAvailability: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub DestroyBand: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBandSite, IBandSite_Vtbl, 0x4cf504b0_de96_11d0_8b3f_00a0c911e8e5);
impl core::ops::Deref for IBandSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBandSite, windows_core::IUnknown);
impl IBandSite {
    pub unsafe fn AddBand<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).AddBand)(windows_core::Interface::as_raw(self), punk.param().abi()).ok()
    }
    pub unsafe fn EnumBands(&self, uband: u32) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumBands)(windows_core::Interface::as_raw(self), uband, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn QueryBand(&self, dwbandid: u32, ppstb: Option<*mut Option<IDeskBand>>, pdwstate: Option<*mut u32>, pszname: Option<&mut [u16]>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryBand)(windows_core::Interface::as_raw(self), dwbandid, core::mem::transmute(ppstb.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwstate.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pszname.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pszname.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok()
    }
    pub unsafe fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetBandState)(windows_core::Interface::as_raw(self), dwbandid, dwmask, dwstate).ok()
    }
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveBand)(windows_core::Interface::as_raw(self), dwbandid).ok()
    }
    pub unsafe fn GetBandObject<T>(&self, dwbandid: u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetBandObject)(windows_core::Interface::as_raw(self), dwbandid, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetBandSiteInfo)(windows_core::Interface::as_raw(self), pbsinfo).ok()
    }
    pub unsafe fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBandSiteInfo)(windows_core::Interface::as_raw(self), pbsinfo).ok()
    }
}
#[repr(C)]
pub struct IBandSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AddBand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumBands: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub QueryBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    QueryBand: usize,
    pub SetBandState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub RemoveBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetBandObject: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBandSiteInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const BANDSITEINFO) -> windows_core::HRESULT,
    pub GetBandSiteInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BANDSITEINFO) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBannerNotificationHandler, IBannerNotificationHandler_Vtbl, 0x8d7b2ba7_db05_46a8_823c_d2b6de08ee91);
impl core::ops::Deref for IBannerNotificationHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBannerNotificationHandler, windows_core::IUnknown);
impl IBannerNotificationHandler {
    pub unsafe fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnBannerEvent)(windows_core::Interface::as_raw(self), notification).ok()
    }
}
#[repr(C)]
pub struct IBannerNotificationHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnBannerEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const BANNER_NOTIFICATION) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBanneredBar, IBanneredBar_Vtbl, 0x596a9a94_013e_11d1_8d34_00a0c90f2719);
impl core::ops::Deref for IBanneredBar {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBanneredBar, windows_core::IUnknown);
impl IBanneredBar {
    pub unsafe fn SetIconSize(&self, iicon: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetIconSize)(windows_core::Interface::as_raw(self), iicon).ok()
    }
    pub unsafe fn GetIconSize(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIconSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap<P0>(&self, hbitmap: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HBITMAP>,
    {
        (windows_core::Interface::vtable(self).SetBitmap)(windows_core::Interface::as_raw(self), hbitmap.param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(&self) -> windows_core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBitmap)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBanneredBar_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmap: usize,
}
windows_core::imp::define_interface!(IBrowserFrameOptions, IBrowserFrameOptions_Vtbl, 0x10df43c8_1dbe_11d3_8b34_006097df5bd4);
impl core::ops::Deref for IBrowserFrameOptions {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserFrameOptions, windows_core::IUnknown);
impl IBrowserFrameOptions {
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFrameOptions)(windows_core::Interface::as_raw(self), dwmask, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBrowserFrameOptions_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFrameOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBrowserService, IBrowserService_Vtbl, 0x02ba3b52_0547_11d1_b833_00c04fc9b31f);
impl core::ops::Deref for IBrowserService {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService, windows_core::IUnknown);
impl IBrowserService {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> windows_core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetParentSite)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<P0, P1>(&self, psv: P0, pszname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), psv.param().abi(), pszname.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<P0>(&self, psv: P0, pszname: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).GetTitle)(windows_core::Interface::as_raw(self), psv.param().abi(), core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> windows_core::Result<super::super::System::Ole::IOleObject> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOleObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetTravelLog(&self) -> windows_core::Result<ITravelLog> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetTravelLog)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn ShowControlWindow<P0>(&self, id: u32, fshow: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).ShowControlWindow)(windows_core::Interface::as_raw(self), id, fshow.param().abi()).ok()
    }
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsControlWindowShown)(windows_core::Interface::as_raw(self), id, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: windows_core::PWSTR, uflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IEGetDisplayName)(windows_core::Interface::as_raw(self), pidl, core::mem::transmute(pwszname), uflags).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<P0>(&self, uicp: u32, pwszpath: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IEParseDisplayName)(windows_core::Interface::as_raw(self), uicp, pwszpath.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn DisplayParseError<P0>(&self, hres: windows_core::HRESULT, pwszpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).DisplayParseError)(windows_core::Interface::as_raw(self), hres, pwszpath.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).NavigateToPidl)(windows_core::Interface::as_raw(self), pidl, grfhlnf).ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetNavigateState)(windows_core::Interface::as_raw(self), bnstate).ok()
    }
    pub unsafe fn GetNavigateState(&self) -> windows_core::Result<BNSTATE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNavigateState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<super::super::Foundation::BOOL>
    where
        P0: windows_core::Param<IShellView>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).NotifyRedirect)(windows_core::Interface::as_raw(self), psv.param().abi(), pidl, &mut result__).map(|| result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateWindowList)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateBackForwardState)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), dwflags, dwflagmask).ok()
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CanNavigateNow)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPidl)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetReferrer)(windows_core::Interface::as_raw(self), pidl).ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        (windows_core::Interface::vtable(self).GetBrowserIndex)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBrowserByIndex)(windows_core::Interface::as_raw(self), dwid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut Option<super::super::System::Ole::IOleObject>, pstm: *mut Option<super::super::System::Com::IStream>, ppbc: *mut Option<super::super::System::Com::IBindCtx>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetHistoryObject)(windows_core::Interface::as_raw(self), core::mem::transmute(ppole), core::mem::transmute(pstm), core::mem::transmute(ppbc)).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetHistoryObject<P0, P1>(&self, pole: P0, fislocalanchor: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Ole::IOleObject>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetHistoryObject)(windows_core::Interface::as_raw(self), pole.param().abi(), fislocalanchor.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<P0>(&self, pole: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Ole::IOleObject>,
    {
        (windows_core::Interface::vtable(self).CacheOLEServer)(windows_core::Interface::as_raw(self), pole.param().abi()).ok()
    }
    pub unsafe fn GetSetCodePage(&self, pvarin: *const windows_core::VARIANT) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSetCodePage)(windows_core::Interface::as_raw(self), core::mem::transmute(pvarin), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnHttpEquiv<P0, P1>(&self, psv: P0, fdone: P1, pvarargin: *const windows_core::VARIANT) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<IShellView>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnHttpEquiv)(windows_core::Interface::as_raw(self), psv.param().abi(), fdone.param().abi(), core::mem::transmute(pvarargin), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> windows_core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPalette)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterWindow<P0>(&self, fforceregister: P0, swc: ShellWindowTypeConstants) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).RegisterWindow)(windows_core::Interface::as_raw(self), fforceregister.param().abi(), swc).ok()
    }
}
#[repr(C)]
pub struct IBrowserService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetParentSite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetParentSite: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetOleObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetOleObject: usize,
    pub GetTravelLog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ShowControlWindow: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub IsControlWindowShown: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEGetDisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEGetDisplayName: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayName: usize,
    pub DisplayParseError: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub NavigateToPidl: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    NavigateToPidl: usize,
    pub SetNavigateState: unsafe extern "system" fn(*mut core::ffi::c_void, BNSTATE) -> windows_core::HRESULT,
    pub GetNavigateState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BNSTATE) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub NotifyRedirect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    NotifyRedirect: usize,
    pub UpdateWindowList: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UpdateBackForwardState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub CanNavigateNow: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetPidl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetPidl: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetReferrer: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetReferrer: usize,
    pub GetBrowserIndex: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetBrowserByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetHistoryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetHistoryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub CacheOLEServer: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CacheOLEServer: usize,
    pub GetSetCodePage: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::mem::MaybeUninit<windows_core::VARIANT>, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnHttpEquiv: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, *const core::mem::MaybeUninit<windows_core::VARIANT>, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnHttpEquiv: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HPALETTE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    pub RegisterWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL, ShellWindowTypeConstants) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IBrowserService2, IBrowserService2_Vtbl, 0x68bd21cc_438b_11d2_a560_00a0c92dbfe8);
impl core::ops::Deref for IBrowserService2 {
    type Target = IBrowserService;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService2, windows_core::IUnknown, IBrowserService);
impl IBrowserService2 {
    pub unsafe fn WndProcBS<P0, P1, P2>(&self, hwnd: P0, umsg: u32, wparam: P1, lparam: P2) -> super::super::Foundation::LRESULT
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::Foundation::WPARAM>,
        P2: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).WndProcBS)(windows_core::Interface::as_raw(self), hwnd.param().abi(), umsg, wparam.param().abi(), lparam.param().abi())
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetAsDefFolderSettings)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetViewRect(&self) -> windows_core::Result<super::super::Foundation::RECT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetViewRect)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn OnSize<P0>(&self, wparam: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
    {
        (windows_core::Interface::vtable(self).OnSize)(windows_core::Interface::as_raw(self), wparam.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnCreate)(windows_core::Interface::as_raw(self), pcs).ok()
    }
    pub unsafe fn OnCommand<P0, P1>(&self, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
        P1: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).OnCommand)(windows_core::Interface::as_raw(self), wparam.param().abi(), lparam.param().abi())
    }
    pub unsafe fn OnDestroy(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnDestroy)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_Controls")]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        (windows_core::Interface::vtable(self).OnNotify)(windows_core::Interface::as_raw(self), pnm)
    }
    pub unsafe fn OnSetFocus(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnSetFocus)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OnFrameWindowActivateBS<P0>(&self, factive: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnFrameWindowActivateBS)(windows_core::Interface::as_raw(self), factive.param().abi()).ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReleaseShellView)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ActivatePendingView)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CreateViewWindow<P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> windows_core::Result<super::super::Foundation::HWND>
    where
        P0: windows_core::Param<IShellView>,
        P1: windows_core::Param<IShellView>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateViewWindow)(windows_core::Interface::as_raw(self), psvnew.param().abi(), psvold.param().abi(), prcview, &mut result__).map(|| result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CreateBrowserPropSheetExt)(windows_core::Interface::as_raw(self), riid, ppv).ok()
    }
    pub unsafe fn GetViewWindow(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetViewWindow)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> windows_core::Result<*mut BASEBROWSERDATALH> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBaseBrowserData)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        (windows_core::Interface::vtable(self).PutBaseBrowserData)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn InitializeTravelLog<P0>(&self, ptl: P0, dw: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ITravelLog>,
    {
        (windows_core::Interface::vtable(self).InitializeTravelLog)(windows_core::Interface::as_raw(self), ptl.param().abi(), dw).ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetTopBrowser)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Offline)(windows_core::Interface::as_raw(self), icmd).ok()
    }
    pub unsafe fn AllowViewResize<P0>(&self, f: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).AllowViewResize)(windows_core::Interface::as_raw(self), f.param().abi()).ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetActivateState)(windows_core::Interface::as_raw(self), u).ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateSecureLockIcon)(windows_core::Interface::as_raw(self), esecurelock).ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeDownloadManager)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeTransitionSite)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _Initialize<P0, P1>(&self, hwnd: P0, pauto: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self)._Initialize)(windows_core::Interface::as_raw(self), hwnd.param().abi(), pauto.param().abi()).ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._CancelPendingNavigationAsync)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._CancelPendingView)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._MaySaveChanges)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _PauseOrResumeView<P0>(&self, fpaused: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self)._PauseOrResumeView)(windows_core::Interface::as_raw(self), fpaused.param().abi()).ok()
    }
    pub unsafe fn _DisableModeless(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._DisableModeless)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._NavigateToPidl2)(windows_core::Interface::as_raw(self), pidl, grfhlnf, dwflags).ok()
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self)._TryShell2Rename)(windows_core::Interface::as_raw(self), psv.param().abi(), pidlnew).ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._SwitchActivationNow)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ExecChildren<P0, P1>(&self, punkbar: P0, fbroadcast: P1, pguidcmdgroup: Option<*const windows_core::GUID>, ncmdid: u32, ncmdexecopt: u32, pvarargin: Option<*const windows_core::VARIANT>, pvarargout: Option<*mut windows_core::VARIANT>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self)._ExecChildren)(windows_core::Interface::as_raw(self), punkbar.param().abi(), fbroadcast.param().abi(), core::mem::transmute(pguidcmdgroup.unwrap_or(std::ptr::null())), ncmdid, ncmdexecopt, core::mem::transmute(pvarargin.unwrap_or(std::ptr::null())), core::mem::transmute(pvarargout.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn _SendChildren<P0, P1, P2, P3>(&self, hwndbar: P0, fbroadcast: P1, umsg: u32, wparam: P2, lparam: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
        P2: windows_core::Param<super::super::Foundation::WPARAM>,
        P3: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self)._SendChildren)(windows_core::Interface::as_raw(self), hwndbar.param().abi(), fbroadcast.param().abi(), umsg, wparam.param().abi(), lparam.param().abi()).ok()
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolderSetData)(windows_core::Interface::as_raw(self), pfsd).ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._OnFocusChange)(windows_core::Interface::as_raw(self), itb).ok()
    }
    pub unsafe fn v_ShowHideChildWindows<P0>(&self, fchildonly: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).v_ShowHideChildWindows)(windows_core::Interface::as_raw(self), fchildonly.param().abi()).ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        (windows_core::Interface::vtable(self)._get_itbLastFocus)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._put_itbLastFocus)(windows_core::Interface::as_raw(self), itblastfocus).ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._UIActivateView)(windows_core::Interface::as_raw(self), ustate).ok()
    }
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._GetViewBorderRect)(windows_core::Interface::as_raw(self), prc).ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._UpdateViewRectSize)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._ResizeNextBorder)(windows_core::Interface::as_raw(self), itb).ok()
    }
    pub unsafe fn _ResizeView(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._ResizeView)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn _GetEffectiveClientArea<P0>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
    {
        (windows_core::Interface::vtable(self)._GetEffectiveClientArea)(windows_core::Interface::as_raw(self), lprectborder, hmon.param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<P0>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P0) -> Option<super::super::System::Com::IStream>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).v_GetViewStream)(windows_core::Interface::as_raw(self), pidl, grfmode, pwszname.param().abi())
    }
    pub unsafe fn ForwardViewMsg<P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> super::super::Foundation::LRESULT
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
        P1: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).ForwardViewMsg)(windows_core::Interface::as_raw(self), umsg, wparam.param().abi(), lparam.param().abi())
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<P0>(&self, hacc: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::WindowsAndMessaging::HACCEL>,
    {
        (windows_core::Interface::vtable(self).SetAcceleratorMenu)(windows_core::Interface::as_raw(self), hacc.param().abi()).ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        (windows_core::Interface::vtable(self)._GetToolbarCount)(windows_core::Interface::as_raw(self))
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        (windows_core::Interface::vtable(self)._GetToolbarItem)(windows_core::Interface::as_raw(self), itb)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<P0>(&self, pstm: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        (windows_core::Interface::vtable(self)._SaveToolbars)(windows_core::Interface::as_raw(self), pstm.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<P0>(&self, pstm: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        (windows_core::Interface::vtable(self)._LoadToolbars)(windows_core::Interface::as_raw(self), pstm.param().abi()).ok()
    }
    pub unsafe fn _CloseAndReleaseToolbars<P0>(&self, fclose: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self)._CloseAndReleaseToolbars)(windows_core::Interface::as_raw(self), fclose.param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).v_MayGetNextToolbarFocus)(windows_core::Interface::as_raw(self), lpmsg, itbnext, citb, pptbi, phwnd).ok()
    }
    pub unsafe fn _ResizeNextBorderHelper<P0>(&self, itb: u32, busehmonitor: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self)._ResizeNextBorderHelper)(windows_core::Interface::as_raw(self), itb, busehmonitor.param().abi()).ok()
    }
    pub unsafe fn _FindTBar<P0>(&self, punksrc: P0) -> u32
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self)._FindTBar)(windows_core::Interface::as_raw(self), punksrc.param().abi())
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<P0>(&self, ptbi: *const TOOLBARITEM, hwnd: P0, lpmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self)._SetFocus)(windows_core::Interface::as_raw(self), ptbi, hwnd.param().abi(), lpmsg).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).v_MayTranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
    pub unsafe fn _GetBorderDWHelper<P0, P1>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self)._GetBorderDWHelper)(windows_core::Interface::as_raw(self), punksrc.param().abi(), lprectborder, busehmonitor.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).v_CheckZoneCrossing)(windows_core::Interface::as_raw(self), pidl).ok()
    }
}
#[repr(C)]
pub struct IBrowserService2_Vtbl {
    pub base__: IBrowserService_Vtbl,
    pub WndProcBS: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    pub SetAsDefFolderSettings: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetViewRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub OnSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::WPARAM) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub OnCreate: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    OnCreate: usize,
    pub OnCommand: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    pub OnDestroy: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Controls")]
    pub OnNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_UI_Controls"))]
    OnNotify: usize,
    pub OnSetFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnFrameWindowActivateBS: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub ReleaseShellView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ActivatePendingView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub CreateViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Foundation::RECT, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CreateViewWindow: usize,
    pub CreateBrowserPropSheetExt: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub GetBaseBrowserData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut BASEBROWSERDATALH) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    GetBaseBrowserData: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub PutBaseBrowserData: unsafe extern "system" fn(*mut core::ffi::c_void) -> *mut BASEBROWSERDATALH,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    PutBaseBrowserData: usize,
    pub InitializeTravelLog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetTopBrowser: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Offline: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub AllowViewResize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetActivateState: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub UpdateSecureLockIcon: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub InitializeDownloadManager: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InitializeTransitionSite: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _CancelPendingNavigationAsync: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _CancelPendingView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _MaySaveChanges: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _PauseOrResumeView: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub _DisableModeless: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub _NavigateToPidl2: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    _NavigateToPidl2: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub _TryShell2Rename: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    _TryShell2Rename: usize,
    pub _SwitchActivationNow: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _ExecChildren: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, *const windows_core::GUID, u32, u32, *const core::mem::MaybeUninit<windows_core::VARIANT>, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub _SendChildren: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, super::super::Foundation::BOOL, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
    pub GetFolderSetData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERSETDATA) -> windows_core::HRESULT,
    pub _OnFocusChange: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub v_ShowHideChildWindows: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub _get_itbLastFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub _put_itbLastFocus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _UIActivateView: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _GetViewBorderRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub _UpdateViewRectSize: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _ResizeNextBorder: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _ResizeView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub _GetEffectiveClientArea: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT, super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    _GetEffectiveClientArea: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub v_GetViewStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut Common::ITEMIDLIST, u32, windows_core::PCWSTR) -> Option<super::super::System::Com::IStream>,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    v_GetViewStream: usize,
    pub ForwardViewMsg: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorMenu: unsafe extern "system" fn(*mut core::ffi::c_void, super::WindowsAndMessaging::HACCEL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorMenu: usize,
    pub _GetToolbarCount: unsafe extern "system" fn(*mut core::ffi::c_void) -> i32,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub _GetToolbarItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> *mut TOOLBARITEM,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole")))]
    _GetToolbarItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _SaveToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _SaveToolbars: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _LoadToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _LoadToolbars: usize,
    pub _CloseAndReleaseToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayGetNextToolbarFocus: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG, u32, i32, *mut *mut TOOLBARITEM, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayGetNextToolbarFocus: usize,
    pub _ResizeNextBorderHelper: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub _FindTBar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub _SetFocus: unsafe extern "system" fn(*mut core::ffi::c_void, *const TOOLBARITEM, super::super::Foundation::HWND, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    _SetFocus: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub v_MayTranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    v_MayTranslateAccelerator: usize,
    pub _GetBorderDWHelper: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::RECT, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub v_CheckZoneCrossing: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    v_CheckZoneCrossing: usize,
}
windows_core::imp::define_interface!(IBrowserService3, IBrowserService3_Vtbl, 0x27d7ce21_762d_48f3_86f3_40e2fd3749c4);
impl core::ops::Deref for IBrowserService3 {
    type Target = IBrowserService2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService3, windows_core::IUnknown, IBrowserService, IBrowserService2);
impl IBrowserService3 {
    pub unsafe fn _PositionViewWindow<P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self)._PositionViewWindow)(windows_core::Interface::as_raw(self), hwnd.param().abi(), prc).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<P0>(&self, uicp: u32, pwszpath: P0, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IEParseDisplayNameEx)(windows_core::Interface::as_raw(self), uicp, pwszpath.param().abi(), dwflags, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBrowserService3_Vtbl {
    pub base__: IBrowserService2_Vtbl,
    pub _PositionViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayNameEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayNameEx: usize,
}
windows_core::imp::define_interface!(IBrowserService4, IBrowserService4_Vtbl, 0x639f1bff_e135_4096_abd8_e0f504d649a4);
impl core::ops::Deref for IBrowserService4 {
    type Target = IBrowserService3;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService4, windows_core::IUnknown, IBrowserService, IBrowserService2, IBrowserService3);
impl IBrowserService4 {
    pub unsafe fn ActivateView<P0>(&self, fpendingview: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).ActivateView)(windows_core::Interface::as_raw(self), fpendingview.param().abi()).ok()
    }
    pub unsafe fn SaveViewState(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SaveViewState)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn _ResizeAllBorders(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self)._ResizeAllBorders)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBrowserService4_Vtbl {
    pub base__: IBrowserService3_Vtbl,
    pub ActivateView: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SaveViewState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _ResizeAllBorders: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICDBurn, ICDBurn_Vtbl, 0x3d73a659_e5d0_4d42_afc0_5121ba425c8d);
impl core::ops::Deref for ICDBurn {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICDBurn, windows_core::IUnknown);
impl ICDBurn {
    pub unsafe fn GetRecorderDriveLetter(&self, pszdrive: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetRecorderDriveLetter)(windows_core::Interface::as_raw(self), core::mem::transmute(pszdrive.as_ptr()), pszdrive.len().try_into().unwrap()).ok()
    }
    pub unsafe fn Burn<P0>(&self, hwnd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Burn)(windows_core::Interface::as_raw(self), hwnd.param().abi()).ok()
    }
    pub unsafe fn HasRecordableDrive(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).HasRecordableDrive)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICDBurn_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetRecorderDriveLetter: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub Burn: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub HasRecordableDrive: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICDBurnExt, ICDBurnExt_Vtbl, 0x2271dcca_74fc_4414_8fb7_c56b05ace2d7);
impl core::ops::Deref for ICDBurnExt {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICDBurnExt, windows_core::IUnknown);
impl ICDBurnExt {
    pub unsafe fn GetSupportedActionTypes(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSupportedActionTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICDBurnExt_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetSupportedActionTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICategorizer, ICategorizer_Vtbl, 0xa3b14589_9174_49a8_89a3_06a1ae2b9ba7);
impl core::ops::Deref for ICategorizer {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICategorizer, windows_core::IUnknown);
impl ICategorizer {
    pub unsafe fn GetDescription(&self, pszdesc: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDescription)(windows_core::Interface::as_raw(self), core::mem::transmute(pszdesc.as_ptr()), pszdesc.len().try_into().unwrap()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCategory)(windows_core::Interface::as_raw(self), cidl, apidl, rgcategoryids).ok()
    }
    pub unsafe fn GetCategoryInfo(&self, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCategoryInfo)(windows_core::Interface::as_raw(self), dwcategoryid, pci).ok()
    }
    pub unsafe fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CompareCategory)(windows_core::Interface::as_raw(self), csfflags, dwcategoryid1, dwcategoryid2).ok()
    }
}
#[repr(C)]
pub struct ICategorizer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDescription: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCategory: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const *const Common::ITEMIDLIST, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCategory: usize,
    pub GetCategoryInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut CATEGORY_INFO) -> windows_core::HRESULT,
    pub CompareCategory: unsafe extern "system" fn(*mut core::ffi::c_void, CATSORT_FLAGS, u32, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICategoryProvider, ICategoryProvider_Vtbl, 0x9af64809_5864_4c26_a720_c1f78c086ee3);
impl core::ops::Deref for ICategoryProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICategoryProvider, windows_core::IUnknown);
impl ICategoryProvider {
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn CanCategorizeOnSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CanCategorizeOnSCID)(windows_core::Interface::as_raw(self), pscid).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetDefaultCategory(&self, pguid: *mut windows_core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDefaultCategory)(windows_core::Interface::as_raw(self), pguid, pscid).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetCategoryForSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCategoryForSCID)(windows_core::Interface::as_raw(self), pscid, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(&self) -> windows_core::Result<super::super::System::Com::IEnumGUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumCategories)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetCategoryName(&self, pguid: *const windows_core::GUID, pszname: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCategoryName)(windows_core::Interface::as_raw(self), pguid, core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok()
    }
    pub unsafe fn CreateCategory<T>(&self, pguid: *const windows_core::GUID) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).CreateCategory)(windows_core::Interface::as_raw(self), pguid, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICategoryProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub CanCategorizeOnSCID: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    CanCategorizeOnSCID: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetDefaultCategory: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetDefaultCategory: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetCategoryForSCID: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetCategoryForSCID: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCategories: usize,
    pub GetCategoryName: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub CreateCategory: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IColumnManager, IColumnManager_Vtbl, 0xd8ec27bb_3f3b_4042_b10a_4acfd924d453);
impl core::ops::Deref for IColumnManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IColumnManager, windows_core::IUnknown);
impl IColumnManager {
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetColumnInfo)(windows_core::Interface::as_raw(self), propkey, pcmci).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetColumnInfo)(windows_core::Interface::as_raw(self), propkey, pcmci).ok()
    }
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetColumnCount)(windows_core::Interface::as_raw(self), dwflags, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: &mut [PropertiesSystem::PROPERTYKEY]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetColumns)(windows_core::Interface::as_raw(self), dwflags, core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len().try_into().unwrap()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumns(&self, rgkeyorder: &[PropertiesSystem::PROPERTYKEY]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetColumns)(windows_core::Interface::as_raw(self), core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len().try_into().unwrap()).ok()
    }
}
#[repr(C)]
pub struct IColumnManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *const CM_COLUMNINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumnInfo: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *mut CM_COLUMNINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    pub GetColumnCount: unsafe extern "system" fn(*mut core::ffi::c_void, CM_ENUM_FLAGS, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumns: unsafe extern "system" fn(*mut core::ffi::c_void, CM_ENUM_FLAGS, *mut PropertiesSystem::PROPERTYKEY, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumns: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumns: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumns: usize,
}
windows_core::imp::define_interface!(IColumnProvider, IColumnProvider_Vtbl, 0xe8025004_1c42_11d2_be2c_00a0c9a83da1);
impl core::ops::Deref for IColumnProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IColumnProvider, windows_core::IUnknown);
impl IColumnProvider {
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psci).ok()
    }
    #[cfg(all(feature = "Win32_System_Variant", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32, psci: *mut SHCOLUMNINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetColumnInfo)(windows_core::Interface::as_raw(self), dwindex, psci).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetItemData(&self, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetItemData)(windows_core::Interface::as_raw(self), pscid, pscd, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IColumnProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const SHCOLUMNINIT) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Variant", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut SHCOLUMNINFO) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Variant", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetColumnInfo: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetItemData: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *const SHCOLUMNDATA, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetItemData: usize,
}
windows_core::imp::define_interface!(ICommDlgBrowser, ICommDlgBrowser_Vtbl, 0x000214f1_0000_0000_c000_000000000046);
impl core::ops::Deref for ICommDlgBrowser {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICommDlgBrowser, windows_core::IUnknown);
impl ICommDlgBrowser {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<P0>(&self, ppshv: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).OnDefaultCommand)(windows_core::Interface::as_raw(self), ppshv.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<P0>(&self, ppshv: P0, uchange: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).OnStateChange)(windows_core::Interface::as_raw(self), ppshv.param().abi(), uchange).ok()
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).IncludeObject)(windows_core::Interface::as_raw(self), ppshv.param().abi(), pidl).ok()
    }
}
#[repr(C)]
pub struct ICommDlgBrowser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnDefaultCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnDefaultCommand: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnStateChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnStateChange: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub IncludeObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    IncludeObject: usize,
}
windows_core::imp::define_interface!(ICommDlgBrowser2, ICommDlgBrowser2_Vtbl, 0x10339516_2894_11d2_9039_00c04f8eeb3e);
impl core::ops::Deref for ICommDlgBrowser2 {
    type Target = ICommDlgBrowser;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICommDlgBrowser2, windows_core::IUnknown, ICommDlgBrowser);
impl ICommDlgBrowser2 {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<P0>(&self, ppshv: P0, dwnotifytype: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).Notify)(windows_core::Interface::as_raw(self), ppshv.param().abi(), dwnotifytype).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<P0>(&self, ppshv: P0, psztext: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).GetDefaultMenuText)(windows_core::Interface::as_raw(self), ppshv.param().abi(), core::mem::transmute(psztext.as_ptr()), psztext.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetViewFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetViewFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICommDlgBrowser2_Vtbl {
    pub base__: ICommDlgBrowser_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub Notify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    Notify: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetDefaultMenuText: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetDefaultMenuText: usize,
    pub GetViewFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICommDlgBrowser3, ICommDlgBrowser3_Vtbl, 0xc8ad25a1_3294_41ee_8165_71174bd01c57);
impl core::ops::Deref for ICommDlgBrowser3 {
    type Target = ICommDlgBrowser2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICommDlgBrowser3, windows_core::IUnknown, ICommDlgBrowser, ICommDlgBrowser2);
impl ICommDlgBrowser3 {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnColumnClicked<P0>(&self, ppshv: P0, icolumn: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).OnColumnClicked)(windows_core::Interface::as_raw(self), ppshv.param().abi(), icolumn).ok()
    }
    pub unsafe fn GetCurrentFilter(&self, pszfilespec: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCurrentFilter)(windows_core::Interface::as_raw(self), core::mem::transmute(pszfilespec.as_ptr()), pszfilespec.len().try_into().unwrap()).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnPreViewCreated<P0>(&self, ppshv: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).OnPreViewCreated)(windows_core::Interface::as_raw(self), ppshv.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICommDlgBrowser3_Vtbl {
    pub base__: ICommDlgBrowser2_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnColumnClicked: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnColumnClicked: usize,
    pub GetCurrentFilter: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnPreViewCreated: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnPreViewCreated: usize,
}
windows_core::imp::define_interface!(IComputerInfoChangeNotify, IComputerInfoChangeNotify_Vtbl, 0x0df60d92_6818_46d6_b358_d66170dde466);
impl core::ops::Deref for IComputerInfoChangeNotify {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IComputerInfoChangeNotify, windows_core::IUnknown);
impl IComputerInfoChangeNotify {
    pub unsafe fn ComputerInfoChanged(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ComputerInfoChanged)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IComputerInfoChangeNotify_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ComputerInfoChanged: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IConnectableCredentialProviderCredential, IConnectableCredentialProviderCredential_Vtbl, 0x9387928b_ac75_4bf9_8ab2_2b93c4a55290);
impl core::ops::Deref for IConnectableCredentialProviderCredential {
    type Target = ICredentialProviderCredential;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IConnectableCredentialProviderCredential, windows_core::IUnknown, ICredentialProviderCredential);
impl IConnectableCredentialProviderCredential {
    pub unsafe fn Connect<P0>(&self, pqcws: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IQueryContinueWithStatus>,
    {
        (windows_core::Interface::vtable(self).Connect)(windows_core::Interface::as_raw(self), pqcws.param().abi()).ok()
    }
    pub unsafe fn Disconnect(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Disconnect)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IConnectableCredentialProviderCredential_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub Connect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IContactManagerInterop, IContactManagerInterop_Vtbl, 0x99eacba7_e073_43b6_a896_55afe48a0833);
impl core::ops::Deref for IContactManagerInterop {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContactManagerInterop, windows_core::IUnknown);
impl IContactManagerInterop {
    pub unsafe fn ShowContactCardForWindow<P0, P1>(&self, appwindow: P0, contact: P1, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).ShowContactCardForWindow)(windows_core::Interface::as_raw(self), appwindow.param().abi(), contact.param().abi(), selection, preferredplacement).ok()
    }
}
#[repr(C)]
pub struct IContactManagerInterop_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ShowContactCardForWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *const super::super::Foundation::RECT, FLYOUT_PLACEMENT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IContextMenu, IContextMenu_Vtbl, 0x000214e4_0000_0000_c000_000000000046);
impl core::ops::Deref for IContextMenu {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenu, windows_core::IUnknown);
impl IContextMenu {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu<P0>(&self, hmenu: P0, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::WindowsAndMessaging::HMENU>,
    {
        (windows_core::Interface::vtable(self).QueryContextMenu)(windows_core::Interface::as_raw(self), hmenu.param().abi(), indexmenu, idcmdfirst, idcmdlast, uflags).ok()
    }
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InvokeCommand)(windows_core::Interface::as_raw(self), pici).ok()
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: Option<*const u32>, pszname: windows_core::PSTR, cchmax: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCommandString)(windows_core::Interface::as_raw(self), idcmd, utype, core::mem::transmute(preserved.unwrap_or(std::ptr::null())), core::mem::transmute(pszname), cchmax).ok()
    }
}
#[repr(C)]
pub struct IContextMenu_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub QueryContextMenu: unsafe extern "system" fn(*mut core::ffi::c_void, super::WindowsAndMessaging::HMENU, u32, u32, u32, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    QueryContextMenu: usize,
    pub InvokeCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *const CMINVOKECOMMANDINFO) -> windows_core::HRESULT,
    pub GetCommandString: unsafe extern "system" fn(*mut core::ffi::c_void, usize, u32, *const u32, windows_core::PSTR, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IContextMenu2, IContextMenu2_Vtbl, 0x000214f4_0000_0000_c000_000000000046);
impl core::ops::Deref for IContextMenu2 {
    type Target = IContextMenu;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenu2, windows_core::IUnknown, IContextMenu);
impl IContextMenu2 {
    pub unsafe fn HandleMenuMsg<P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
        P1: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).HandleMenuMsg)(windows_core::Interface::as_raw(self), umsg, wparam.param().abi(), lparam.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IContextMenu2_Vtbl {
    pub base__: IContextMenu_Vtbl,
    pub HandleMenuMsg: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IContextMenu3, IContextMenu3_Vtbl, 0xbcfce0a0_ec17_11d0_8d10_00a0c90f2719);
impl core::ops::Deref for IContextMenu3 {
    type Target = IContextMenu2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenu3, windows_core::IUnknown, IContextMenu, IContextMenu2);
impl IContextMenu3 {
    pub unsafe fn HandleMenuMsg2<P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1, plresult: Option<*mut super::super::Foundation::LRESULT>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
        P1: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).HandleMenuMsg2)(windows_core::Interface::as_raw(self), umsg, wparam.param().abi(), lparam.param().abi(), core::mem::transmute(plresult.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IContextMenu3_Vtbl {
    pub base__: IContextMenu2_Vtbl,
    pub HandleMenuMsg2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM, *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IContextMenuCB, IContextMenuCB_Vtbl, 0x3409e930_5a39_11d1_83fa_00a0c90dc849);
impl core::ops::Deref for IContextMenuCB {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenuCB, windows_core::IUnknown);
impl IContextMenuCB {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CallBack<P0, P1, P2, P3, P4>(&self, psf: P0, hwndowner: P1, pdtobj: P2, umsg: u32, wparam: P3, lparam: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
        P1: windows_core::Param<super::super::Foundation::HWND>,
        P2: windows_core::Param<super::super::System::Com::IDataObject>,
        P3: windows_core::Param<super::super::Foundation::WPARAM>,
        P4: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).CallBack)(windows_core::Interface::as_raw(self), psf.param().abi(), hwndowner.param().abi(), pdtobj.param().abi(), umsg, wparam.param().abi(), lparam.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IContextMenuCB_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CallBack: usize,
}
windows_core::imp::define_interface!(IContextMenuSite, IContextMenuSite_Vtbl, 0x0811aebe_0b87_4c54_9e72_548cf649016b);
impl core::ops::Deref for IContextMenuSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenuSite, windows_core::IUnknown);
impl IContextMenuSite {
    pub unsafe fn DoContextMenuPopup<P0>(&self, punkcontextmenu: P0, fflags: u32, pt: super::super::Foundation::POINT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).DoContextMenuPopup)(windows_core::Interface::as_raw(self), punkcontextmenu.param().abi(), fflags, core::mem::transmute(pt)).ok()
    }
}
#[repr(C)]
pub struct IContextMenuSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub DoContextMenuPopup: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, super::super::Foundation::POINT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICopyHookA, ICopyHookA_Vtbl, 0x000214ef_0000_0000_c000_000000000046);
impl core::ops::Deref for ICopyHookA {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICopyHookA, windows_core::IUnknown);
impl ICopyHookA {
    pub unsafe fn CopyCallback<P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCSTR>,
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).CopyCallback)(windows_core::Interface::as_raw(self), hwnd.param().abi(), wfunc, wflags, pszsrcfile.param().abi(), dwsrcattribs, pszdestfile.param().abi(), dwdestattribs)
    }
}
#[repr(C)]
pub struct ICopyHookA_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CopyCallback: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, u32, windows_core::PCSTR, u32, windows_core::PCSTR, u32) -> u32,
}
windows_core::imp::define_interface!(ICopyHookW, ICopyHookW_Vtbl, 0x000214fc_0000_0000_c000_000000000046);
impl core::ops::Deref for ICopyHookW {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICopyHookW, windows_core::IUnknown);
impl ICopyHookW {
    pub unsafe fn CopyCallback<P0, P1, P2>(&self, hwnd: P0, wfunc: u32, wflags: u32, pszsrcfile: P1, dwsrcattribs: u32, pszdestfile: P2, dwdestattribs: u32) -> u32
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).CopyCallback)(windows_core::Interface::as_raw(self), hwnd.param().abi(), wfunc, wflags, pszsrcfile.param().abi(), dwsrcattribs, pszdestfile.param().abi(), dwdestattribs)
    }
}
#[repr(C)]
pub struct ICopyHookW_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CopyCallback: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, u32, windows_core::PCWSTR, u32, windows_core::PCWSTR, u32) -> u32,
}
windows_core::imp::define_interface!(ICreateProcessInputs, ICreateProcessInputs_Vtbl, 0xf6ef6140_e26f_4d82_bac4_e9ba5fd239a8);
impl core::ops::Deref for ICreateProcessInputs {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICreateProcessInputs, windows_core::IUnknown);
impl ICreateProcessInputs {
    pub unsafe fn GetCreateFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCreateFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCreateFlags)(windows_core::Interface::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn AddCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddCreateFlags)(windows_core::Interface::as_raw(self), dwcreationflags).ok()
    }
    pub unsafe fn SetHotKey(&self, whotkey: u16) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetHotKey)(windows_core::Interface::as_raw(self), whotkey).ok()
    }
    pub unsafe fn AddStartupFlags(&self, dwstartupinfoflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddStartupFlags)(windows_core::Interface::as_raw(self), dwstartupinfoflags).ok()
    }
    pub unsafe fn SetTitle<P0>(&self, psztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), psztitle.param().abi()).ok()
    }
    pub unsafe fn SetEnvironmentVariable<P0, P1>(&self, pszname: P0, pszvalue: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEnvironmentVariable)(windows_core::Interface::as_raw(self), pszname.param().abi(), pszvalue.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICreateProcessInputs_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetHotKey: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub AddStartupFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEnvironmentVariable: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICreatingProcess, ICreatingProcess_Vtbl, 0xc2b937a9_3110_4398_8a56_f34c6342d244);
impl core::ops::Deref for ICreatingProcess {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICreatingProcess, windows_core::IUnknown);
impl ICreatingProcess {
    pub unsafe fn OnCreating<P0>(&self, pcpi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICreateProcessInputs>,
    {
        (windows_core::Interface::vtable(self).OnCreating)(windows_core::Interface::as_raw(self), pcpi.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICreatingProcess_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnCreating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProvider, ICredentialProvider_Vtbl, 0xd27c3481_5a1c_45b2_8aaa_c20ebbe8229e);
impl core::ops::Deref for ICredentialProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProvider, windows_core::IUnknown);
impl ICredentialProvider {
    pub unsafe fn SetUsageScenario(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetUsageScenario)(windows_core::Interface::as_raw(self), cpus, dwflags).ok()
    }
    pub unsafe fn SetSerialization(&self, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSerialization)(windows_core::Interface::as_raw(self), pcpcs).ok()
    }
    pub unsafe fn Advise<P0>(&self, pcpe: P0, upadvisecontext: usize) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderEvents>,
    {
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcpe.param().abi(), upadvisecontext).ok()
    }
    pub unsafe fn UnAdvise(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnAdvise)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldDescriptorCount(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFieldDescriptorCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetFieldDescriptorAt(&self, dwindex: u32) -> windows_core::Result<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFieldDescriptorAt)(windows_core::Interface::as_raw(self), dwindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetCredentialCount(&self, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCredentialCount)(windows_core::Interface::as_raw(self), pdwcount, pdwdefault, pbautologonwithdefault).ok()
    }
    pub unsafe fn GetCredentialAt(&self, dwindex: u32) -> windows_core::Result<ICredentialProviderCredential> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCredentialAt)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICredentialProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetUsageScenario: unsafe extern "system" fn(*mut core::ffi::c_void, CREDENTIAL_PROVIDER_USAGE_SCENARIO, u32) -> windows_core::HRESULT,
    pub SetSerialization: unsafe extern "system" fn(*mut core::ffi::c_void, *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, usize) -> windows_core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFieldDescriptorCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFieldDescriptorAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR) -> windows_core::HRESULT,
    pub GetCredentialCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetCredentialAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderCredential, ICredentialProviderCredential_Vtbl, 0x63913a93_40c1_481a_818d_4072ff8c70cc);
impl core::ops::Deref for ICredentialProviderCredential {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderCredential, windows_core::IUnknown);
impl ICredentialProviderCredential {
    pub unsafe fn Advise<P0>(&self, pcpce: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredentialEvents>,
    {
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcpce.param().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnAdvise)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetSelected(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).SetSelected)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDeselected(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetDeselected)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFieldState)(windows_core::Interface::as_raw(self), dwfieldid, pcpfs, pcpfis).ok()
    }
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetStringValue)(windows_core::Interface::as_raw(self), dwfieldid, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> windows_core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBitmapValue)(windows_core::Interface::as_raw(self), dwfieldid, &mut result__).map(|| result__)
    }
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCheckboxValue)(windows_core::Interface::as_raw(self), dwfieldid, pbchecked, ppszlabel).ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSubmitButtonValue)(windows_core::Interface::as_raw(self), dwfieldid, &mut result__).map(|| result__)
    }
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetComboBoxValueCount)(windows_core::Interface::as_raw(self), dwfieldid, pcitems, pdwselecteditem).ok()
    }
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetComboBoxValueAt)(windows_core::Interface::as_raw(self), dwfieldid, dwitem, &mut result__).map(|| result__)
    }
    pub unsafe fn SetStringValue<P0>(&self, dwfieldid: u32, psz: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetStringValue)(windows_core::Interface::as_raw(self), dwfieldid, psz.param().abi()).ok()
    }
    pub unsafe fn SetCheckboxValue<P0>(&self, dwfieldid: u32, bchecked: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCheckboxValue)(windows_core::Interface::as_raw(self), dwfieldid, bchecked.param().abi()).ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetComboBoxSelectedValue)(windows_core::Interface::as_raw(self), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CommandLinkClicked)(windows_core::Interface::as_raw(self), dwfieldid).ok()
    }
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut windows_core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSerialization)(windows_core::Interface::as_raw(self), pcpgsr, pcpcs, ppszoptionalstatustext, pcpsioptionalstatusicon).ok()
    }
    pub unsafe fn ReportResult<P0, P1>(&self, ntsstatus: P0, ntssubstatus: P1, ppszoptionalstatustext: *mut windows_core::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::NTSTATUS>,
        P1: windows_core::Param<super::super::Foundation::NTSTATUS>,
    {
        (windows_core::Interface::vtable(self).ReportResult)(windows_core::Interface::as_raw(self), ntsstatus.param().abi(), ntssubstatus.param().abi(), ppszoptionalstatustext, pcpsioptionalstatusicon).ok()
    }
}
#[repr(C)]
pub struct ICredentialProviderCredential_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSelected: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetDeselected: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFieldState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut CREDENTIAL_PROVIDER_FIELD_STATE, *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> windows_core::HRESULT,
    pub GetStringValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmapValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmapValue: usize,
    pub GetCheckboxValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Foundation::BOOL, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetSubmitButtonValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetComboBoxValueCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetComboBoxValueAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetStringValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetCheckboxValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetComboBoxSelectedValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub CommandLinkClicked: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSerialization: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, *mut windows_core::PWSTR, *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> windows_core::HRESULT,
    pub ReportResult: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::NTSTATUS, super::super::Foundation::NTSTATUS, *mut windows_core::PWSTR, *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderCredential2, ICredentialProviderCredential2_Vtbl, 0xfd672c54_40ea_4d6e_9b49_cfb1a7507bd7);
impl core::ops::Deref for ICredentialProviderCredential2 {
    type Target = ICredentialProviderCredential;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderCredential2, windows_core::IUnknown, ICredentialProviderCredential);
impl ICredentialProviderCredential2 {
    pub unsafe fn GetUserSid(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetUserSid)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICredentialProviderCredential2_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub GetUserSid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderCredentialEvents, ICredentialProviderCredentialEvents_Vtbl, 0xfa6fa76b_66b7_4b11_95f1_86171118e816);
impl core::ops::Deref for ICredentialProviderCredentialEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderCredentialEvents, windows_core::IUnknown);
impl ICredentialProviderCredentialEvents {
    pub unsafe fn SetFieldState<P0>(&self, pcpc: P0, dwfieldid: u32, cpfs: CREDENTIAL_PROVIDER_FIELD_STATE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).SetFieldState)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, cpfs).ok()
    }
    pub unsafe fn SetFieldInteractiveState<P0>(&self, pcpc: P0, dwfieldid: u32, cpfis: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).SetFieldInteractiveState)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, cpfis).ok()
    }
    pub unsafe fn SetFieldString<P0, P1>(&self, pcpc: P0, dwfieldid: u32, psz: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFieldString)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, psz.param().abi()).ok()
    }
    pub unsafe fn SetFieldCheckbox<P0, P1, P2>(&self, pcpc: P0, dwfieldid: u32, bchecked: P1, pszlabel: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFieldCheckbox)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, bchecked.param().abi(), pszlabel.param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFieldBitmap<P0, P1>(&self, pcpc: P0, dwfieldid: u32, hbmp: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
        P1: windows_core::Param<super::super::Graphics::Gdi::HBITMAP>,
    {
        (windows_core::Interface::vtable(self).SetFieldBitmap)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, hbmp.param().abi()).ok()
    }
    pub unsafe fn SetFieldComboBoxSelectedItem<P0>(&self, pcpc: P0, dwfieldid: u32, dwselecteditem: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).SetFieldComboBoxSelectedItem)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, dwselecteditem).ok()
    }
    pub unsafe fn DeleteFieldComboBoxItem<P0>(&self, pcpc: P0, dwfieldid: u32, dwitem: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).DeleteFieldComboBoxItem)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, dwitem).ok()
    }
    pub unsafe fn AppendFieldComboBoxItem<P0, P1>(&self, pcpc: P0, dwfieldid: u32, pszitem: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AppendFieldComboBoxItem)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, pszitem.param().abi()).ok()
    }
    pub unsafe fn SetFieldSubmitButton<P0>(&self, pcpc: P0, dwfieldid: u32, dwadjacentto: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).SetFieldSubmitButton)(windows_core::Interface::as_raw(self), pcpc.param().abi(), dwfieldid, dwadjacentto).ok()
    }
    pub unsafe fn OnCreatingWindow(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnCreatingWindow)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICredentialProviderCredentialEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetFieldState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, CREDENTIAL_PROVIDER_FIELD_STATE) -> windows_core::HRESULT,
    pub SetFieldInteractiveState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> windows_core::HRESULT,
    pub SetFieldString: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFieldCheckbox: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, super::super::Foundation::BOOL, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetFieldBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetFieldBitmap: usize,
    pub SetFieldComboBoxSelectedItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub DeleteFieldComboBoxItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub AppendFieldComboBoxItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFieldSubmitButton: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnCreatingWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderCredentialEvents2, ICredentialProviderCredentialEvents2_Vtbl, 0xb53c00b6_9922_4b78_b1f4_ddfe774dc39b);
impl core::ops::Deref for ICredentialProviderCredentialEvents2 {
    type Target = ICredentialProviderCredentialEvents;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderCredentialEvents2, windows_core::IUnknown, ICredentialProviderCredentialEvents);
impl ICredentialProviderCredentialEvents2 {
    pub unsafe fn BeginFieldUpdates(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).BeginFieldUpdates)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndFieldUpdates(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndFieldUpdates)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFieldOptions<P0>(&self, credential: P0, fieldid: u32, options: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredential>,
    {
        (windows_core::Interface::vtable(self).SetFieldOptions)(windows_core::Interface::as_raw(self), credential.param().abi(), fieldid, options).ok()
    }
}
#[repr(C)]
pub struct ICredentialProviderCredentialEvents2_Vtbl {
    pub base__: ICredentialProviderCredentialEvents_Vtbl,
    pub BeginFieldUpdates: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndFieldUpdates: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFieldOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderCredentialWithFieldOptions, ICredentialProviderCredentialWithFieldOptions_Vtbl, 0xdbc6fb30_c843_49e3_a645_573e6f39446a);
impl core::ops::Deref for ICredentialProviderCredentialWithFieldOptions {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderCredentialWithFieldOptions, windows_core::IUnknown);
impl ICredentialProviderCredentialWithFieldOptions {
    pub unsafe fn GetFieldOptions(&self, fieldid: u32) -> windows_core::Result<CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFieldOptions)(windows_core::Interface::as_raw(self), fieldid, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ICredentialProviderCredentialWithFieldOptions_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFieldOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderEvents, ICredentialProviderEvents_Vtbl, 0x34201e5a_a787_41a3_a5a4_bd6dcf2a854e);
impl core::ops::Deref for ICredentialProviderEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderEvents, windows_core::IUnknown);
impl ICredentialProviderEvents {
    pub unsafe fn CredentialsChanged(&self, upadvisecontext: usize) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CredentialsChanged)(windows_core::Interface::as_raw(self), upadvisecontext).ok()
    }
}
#[repr(C)]
pub struct ICredentialProviderEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CredentialsChanged: unsafe extern "system" fn(*mut core::ffi::c_void, usize) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderFilter, ICredentialProviderFilter_Vtbl, 0xa5da53f9_d475_4080_a120_910c4a739880);
impl core::ops::Deref for ICredentialProviderFilter {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderFilter, windows_core::IUnknown);
impl ICredentialProviderFilter {
    pub unsafe fn Filter(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32, rgclsidproviders: *const windows_core::GUID, rgballow: *mut super::super::Foundation::BOOL, cproviders: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Filter)(windows_core::Interface::as_raw(self), cpus, dwflags, rgclsidproviders, rgballow, cproviders).ok()
    }
    pub unsafe fn UpdateRemoteCredential(&self, pcpcsin: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, pcpcsout: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateRemoteCredential)(windows_core::Interface::as_raw(self), pcpcsin, pcpcsout).ok()
    }
}
#[repr(C)]
pub struct ICredentialProviderFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Filter: unsafe extern "system" fn(*mut core::ffi::c_void, CREDENTIAL_PROVIDER_USAGE_SCENARIO, u32, *const windows_core::GUID, *mut super::super::Foundation::BOOL, u32) -> windows_core::HRESULT,
    pub UpdateRemoteCredential: unsafe extern "system" fn(*mut core::ffi::c_void, *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderSetUserArray, ICredentialProviderSetUserArray_Vtbl, 0x095c1484_1c0c_4388_9c6d_500e61bf84bd);
impl core::ops::Deref for ICredentialProviderSetUserArray {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderSetUserArray, windows_core::IUnknown);
impl ICredentialProviderSetUserArray {
    pub unsafe fn SetUserArray<P0>(&self, users: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderUserArray>,
    {
        (windows_core::Interface::vtable(self).SetUserArray)(windows_core::Interface::as_raw(self), users.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICredentialProviderSetUserArray_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetUserArray: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICredentialProviderUser, ICredentialProviderUser_Vtbl, 0x13793285_3ea6_40fd_b420_15f47da41fbb);
impl core::ops::Deref for ICredentialProviderUser {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderUser, windows_core::IUnknown);
impl ICredentialProviderUser {
    pub unsafe fn GetSid(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSid)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetProviderID(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProviderID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetStringValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetStringValue)(windows_core::Interface::as_raw(self), key, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetValue(&self, key: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<windows_core::PROPVARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetValue)(windows_core::Interface::as_raw(self), key, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICredentialProviderUser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetSid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetProviderID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetStringValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetStringValue: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, *mut core::mem::MaybeUninit<windows_core::PROPVARIANT>) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetValue: usize,
}
windows_core::imp::define_interface!(ICredentialProviderUserArray, ICredentialProviderUserArray_Vtbl, 0x90c119ae_0f18_4520_a1f1_114366a40fe8);
impl core::ops::Deref for ICredentialProviderUserArray {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICredentialProviderUserArray, windows_core::IUnknown);
impl ICredentialProviderUserArray {
    pub unsafe fn SetProviderFilter(&self, guidprovidertofilterto: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProviderFilter)(windows_core::Interface::as_raw(self), guidprovidertofilterto).ok()
    }
    pub unsafe fn GetAccountOptions(&self) -> windows_core::Result<CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAccountOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCount(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAt(&self, userindex: u32) -> windows_core::Result<ICredentialProviderUser> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAt)(windows_core::Interface::as_raw(self), userindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICredentialProviderUserArray_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetProviderFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetAccountOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS) -> windows_core::HRESULT,
    pub GetCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICurrentItem, ICurrentItem_Vtbl, 0x240a7174_d653_4a1d_a6d3_d4943cfbfe3d);
impl core::ops::Deref for ICurrentItem {
    type Target = IRelatedItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICurrentItem, windows_core::IUnknown, IRelatedItem);
impl ICurrentItem {}
#[repr(C)]
pub struct ICurrentItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
windows_core::imp::define_interface!(ICurrentWorkingDirectory, ICurrentWorkingDirectory_Vtbl, 0x91956d21_9276_11d1_921a_006097df5bd4);
impl core::ops::Deref for ICurrentWorkingDirectory {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICurrentWorkingDirectory, windows_core::IUnknown);
impl ICurrentWorkingDirectory {
    pub unsafe fn GetDirectory(&self, pwzpath: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetDirectory)(windows_core::Interface::as_raw(self), core::mem::transmute(pwzpath.as_ptr()), pwzpath.len().try_into().unwrap()).ok()
    }
    pub unsafe fn SetDirectory<P0>(&self, pwzpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetDirectory)(windows_core::Interface::as_raw(self), pwzpath.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICurrentWorkingDirectory_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDirectory: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub SetDirectory: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ICustomDestinationList, ICustomDestinationList_Vtbl, 0x6332debf_87b5_4670_90c0_5e57b408a49e);
impl core::ops::Deref for ICustomDestinationList {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICustomDestinationList, windows_core::IUnknown);
impl ICustomDestinationList {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok()
    }
    pub unsafe fn BeginList<T>(&self, pcminslots: *mut u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).BeginList)(windows_core::Interface::as_raw(self), pcminslots, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AppendCategory<P0, P1>(&self, pszcategory: P0, poa: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<Common::IObjectArray>,
    {
        (windows_core::Interface::vtable(self).AppendCategory)(windows_core::Interface::as_raw(self), pszcategory.param().abi(), poa.param().abi()).ok()
    }
    pub unsafe fn AppendKnownCategory(&self, category: KNOWNDESTCATEGORY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AppendKnownCategory)(windows_core::Interface::as_raw(self), category).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn AddUserTasks<P0>(&self, poa: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<Common::IObjectArray>,
    {
        (windows_core::Interface::vtable(self).AddUserTasks)(windows_core::Interface::as_raw(self), poa.param().abi()).ok()
    }
    pub unsafe fn CommitList(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CommitList)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRemovedDestinations<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetRemovedDestinations)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn DeleteList<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).DeleteList)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok()
    }
    pub unsafe fn AbortList(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AbortList)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct ICustomDestinationList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub BeginList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AppendCategory: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AppendCategory: usize,
    pub AppendKnownCategory: unsafe extern "system" fn(*mut core::ffi::c_void, KNOWNDESTCATEGORY) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub AddUserTasks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    AddUserTasks: usize,
    pub CommitList: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRemovedDestinations: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DeleteList: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AbortList: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDataObjectAsyncCapability, IDataObjectAsyncCapability_Vtbl, 0x3d8b0590_f691_11d2_8ea9_006097df5bd4);
impl core::ops::Deref for IDataObjectAsyncCapability {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataObjectAsyncCapability, windows_core::IUnknown);
impl IDataObjectAsyncCapability {
    pub unsafe fn SetAsyncMode<P0>(&self, fdoopasync: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetAsyncMode)(windows_core::Interface::as_raw(self), fdoopasync.param().abi()).ok()
    }
    pub unsafe fn GetAsyncMode(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAsyncMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StartOperation<P0>(&self, pbcreserved: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    {
        (windows_core::Interface::vtable(self).StartOperation)(windows_core::Interface::as_raw(self), pbcreserved.param().abi()).ok()
    }
    pub unsafe fn InOperation(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).InOperation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EndOperation<P0>(&self, hresult: windows_core::HRESULT, pbcreserved: P0, dweffects: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    {
        (windows_core::Interface::vtable(self).EndOperation)(windows_core::Interface::as_raw(self), hresult, pbcreserved.param().abi(), dweffects).ok()
    }
}
#[repr(C)]
pub struct IDataObjectAsyncCapability_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAsyncMode: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetAsyncMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub StartOperation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StartOperation: usize,
    pub InOperation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub EndOperation: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EndOperation: usize,
}
windows_core::imp::define_interface!(IDataObjectProvider, IDataObjectProvider_Vtbl, 0x3d25f6d6_4b2a_433c_9184_7c33ad35d001);
impl core::ops::Deref for IDataObjectProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataObjectProvider, windows_core::IUnknown);
impl IDataObjectProvider {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDataObject(&self) -> windows_core::Result<super::super::System::Com::IDataObject> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDataObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetDataObject<P0>(&self, dataobject: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).SetDataObject)(windows_core::Interface::as_raw(self), dataobject.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDataObjectProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetDataObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetDataObject: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetDataObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetDataObject: usize,
}
windows_core::imp::define_interface!(IDataTransferManagerInterop, IDataTransferManagerInterop_Vtbl, 0x3a3dcd6c_3eab_43dc_bcde_45671ce800c8);
impl core::ops::Deref for IDataTransferManagerInterop {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataTransferManagerInterop, windows_core::IUnknown);
impl IDataTransferManagerInterop {
    pub unsafe fn GetForWindow<P0, T>(&self, appwindow: P0) -> windows_core::Result<T>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetForWindow)(windows_core::Interface::as_raw(self), appwindow.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn ShowShareUIForWindow<P0>(&self, appwindow: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).ShowShareUIForWindow)(windows_core::Interface::as_raw(self), appwindow.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDataTransferManagerInterop_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetForWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ShowShareUIForWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDefaultExtractIconInit, IDefaultExtractIconInit_Vtbl, 0x41ded17d_d6b3_4261_997d_88c60e4b1d58);
impl core::ops::Deref for IDefaultExtractIconInit {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDefaultExtractIconInit, windows_core::IUnknown);
impl IDefaultExtractIconInit {
    pub unsafe fn SetFlags(&self, uflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), uflags).ok()
    }
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn SetKey<P0>(&self, hkey: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Registry::HKEY>,
    {
        (windows_core::Interface::vtable(self).SetKey)(windows_core::Interface::as_raw(self), hkey.param().abi()).ok()
    }
    pub unsafe fn SetNormalIcon<P0>(&self, pszfile: P0, iicon: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetNormalIcon)(windows_core::Interface::as_raw(self), pszfile.param().abi(), iicon).ok()
    }
    pub unsafe fn SetOpenIcon<P0>(&self, pszfile: P0, iicon: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOpenIcon)(windows_core::Interface::as_raw(self), pszfile.param().abi(), iicon).ok()
    }
    pub unsafe fn SetShortcutIcon<P0>(&self, pszfile: P0, iicon: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetShortcutIcon)(windows_core::Interface::as_raw(self), pszfile.param().abi(), iicon).ok()
    }
    pub unsafe fn SetDefaultIcon<P0>(&self, pszfile: P0, iicon: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetDefaultIcon)(windows_core::Interface::as_raw(self), pszfile.param().abi(), iicon).ok()
    }
}
#[repr(C)]
pub struct IDefaultExtractIconInit_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Registry")]
    pub SetKey: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Registry::HKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    SetKey: usize,
    pub SetNormalIcon: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, i32) -> windows_core::HRESULT,
    pub SetOpenIcon: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, i32) -> windows_core::HRESULT,
    pub SetShortcutIcon: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, i32) -> windows_core::HRESULT,
    pub SetDefaultIcon: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDefaultFolderMenuInitialize, IDefaultFolderMenuInitialize_Vtbl, 0x7690aa79_f8fc_4615_a327_36f7d18f5d91);
impl core::ops::Deref for IDefaultFolderMenuInitialize {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDefaultFolderMenuInitialize, windows_core::IUnknown);
impl IDefaultFolderMenuInitialize {
    #[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn Initialize<P0, P1, P2, P3>(&self, hwnd: P0, pcmcb: P1, pidlfolder: Option<*const Common::ITEMIDLIST>, psf: P2, apidl: &[*const Common::ITEMIDLIST], punkassociation: P3, ckeys: u32, akeys: Option<*const super::super::System::Registry::HKEY>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<IContextMenuCB>,
        P2: windows_core::Param<IShellFolder>,
        P3: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), hwnd.param().abi(), pcmcb.param().abi(), core::mem::transmute(pidlfolder.unwrap_or(std::ptr::null())), psf.param().abi(), apidl.len().try_into().unwrap(), core::mem::transmute(apidl.as_ptr()), punkassociation.param().abi(), ckeys, core::mem::transmute(akeys.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn SetMenuRestrictions(&self, dfmrvalues: DEFAULT_FOLDER_MENU_RESTRICTIONS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMenuRestrictions)(windows_core::Interface::as_raw(self), dfmrvalues).ok()
    }
    pub unsafe fn GetMenuRestrictions(&self, dfmrmask: DEFAULT_FOLDER_MENU_RESTRICTIONS) -> windows_core::Result<DEFAULT_FOLDER_MENU_RESTRICTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMenuRestrictions)(windows_core::Interface::as_raw(self), dfmrmask, &mut result__).map(|| result__)
    }
    pub unsafe fn SetHandlerClsid(&self, rclsid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetHandlerClsid)(windows_core::Interface::as_raw(self), rclsid).ok()
    }
}
#[repr(C)]
pub struct IDefaultFolderMenuInitialize_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut core::ffi::c_void, u32, *const *const Common::ITEMIDLIST, *mut core::ffi::c_void, u32, *const super::super::System::Registry::HKEY) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common")))]
    Initialize: usize,
    pub SetMenuRestrictions: unsafe extern "system" fn(*mut core::ffi::c_void, DEFAULT_FOLDER_MENU_RESTRICTIONS) -> windows_core::HRESULT,
    pub GetMenuRestrictions: unsafe extern "system" fn(*mut core::ffi::c_void, DEFAULT_FOLDER_MENU_RESTRICTIONS, *mut DEFAULT_FOLDER_MENU_RESTRICTIONS) -> windows_core::HRESULT,
    pub SetHandlerClsid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDelegateFolder, IDelegateFolder_Vtbl, 0xadd8ba80_002b_11d0_8f0f_00c04fd7d062);
impl core::ops::Deref for IDelegateFolder {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDelegateFolder, windows_core::IUnknown);
impl IDelegateFolder {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetItemAlloc<P0>(&self, pmalloc: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMalloc>,
    {
        (windows_core::Interface::vtable(self).SetItemAlloc)(windows_core::Interface::as_raw(self), pmalloc.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDelegateFolder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SetItemAlloc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetItemAlloc: usize,
}
windows_core::imp::define_interface!(IDelegateItem, IDelegateItem_Vtbl, 0x3c5a1c94_c951_4cb7_bb6d_3b93f30cce93);
impl core::ops::Deref for IDelegateItem {
    type Target = IRelatedItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDelegateItem, windows_core::IUnknown, IRelatedItem);
impl IDelegateItem {}
#[repr(C)]
pub struct IDelegateItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDeskBand, IDeskBand_Vtbl, 0xeb0fe172_1a3a_11d0_89b3_00a0c90a90ac);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDeskBand {
    type Target = IDockingWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDeskBand, windows_core::IUnknown, super::super::System::Ole::IOleWindow, IDockingWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBand {
    pub unsafe fn GetBandInfo(&self, dwbandid: u32, dwviewmode: u32, pdbi: *mut DESKBANDINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBandInfo)(windows_core::Interface::as_raw(self), dwbandid, dwviewmode, pdbi).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDeskBand_Vtbl {
    pub base__: IDockingWindow_Vtbl,
    pub GetBandInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut DESKBANDINFO) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDeskBand2, IDeskBand2_Vtbl, 0x79d16de4_abee_4021_8d9d_9169b261d657);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDeskBand2 {
    type Target = IDeskBand;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDeskBand2, windows_core::IUnknown, super::super::System::Ole::IOleWindow, IDockingWindow, IDeskBand);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBand2 {
    pub unsafe fn CanRenderComposited(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).CanRenderComposited)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCompositionState<P0>(&self, fcompositionenabled: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCompositionState)(windows_core::Interface::as_raw(self), fcompositionenabled.param().abi()).ok()
    }
    pub unsafe fn GetCompositionState(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCompositionState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDeskBand2_Vtbl {
    pub base__: IDeskBand_Vtbl,
    pub CanRenderComposited: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetCompositionState: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetCompositionState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDeskBandInfo, IDeskBandInfo_Vtbl, 0x77e425fc_cbf9_4307_ba6a_bb5727745661);
impl core::ops::Deref for IDeskBandInfo {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDeskBandInfo, windows_core::IUnknown);
impl IDeskBandInfo {
    pub unsafe fn GetDefaultBandWidth(&self, dwbandid: u32, dwviewmode: u32) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDefaultBandWidth)(windows_core::Interface::as_raw(self), dwbandid, dwviewmode, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDeskBandInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDefaultBandWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut i32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDeskBar, IDeskBar_Vtbl, 0xeb0fe173_1a3a_11d0_89b3_00a0c90a90ac);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDeskBar {
    type Target = super::super::System::Ole::IOleWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDeskBar, windows_core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBar {
    pub unsafe fn SetClient<P0>(&self, punkclient: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).SetClient)(windows_core::Interface::as_raw(self), punkclient.param().abi()).ok()
    }
    pub unsafe fn GetClient(&self) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn OnPosRectChangeDB(&self, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnPosRectChangeDB)(windows_core::Interface::as_raw(self), prc).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDeskBar_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub SetClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnPosRectChangeDB: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDeskBarClient, IDeskBarClient_Vtbl, 0xeb0fe175_1a3a_11d0_89b3_00a0c90a90ac);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDeskBarClient {
    type Target = super::super::System::Ole::IOleWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDeskBarClient, windows_core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDeskBarClient {
    pub unsafe fn SetDeskBarSite<P0>(&self, punksite: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).SetDeskBarSite)(windows_core::Interface::as_raw(self), punksite.param().abi()).ok()
    }
    pub unsafe fn SetModeDBC(&self, dwmode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetModeDBC)(windows_core::Interface::as_raw(self), dwmode).ok()
    }
    pub unsafe fn UIActivateDBC(&self, dwstate: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UIActivateDBC)(windows_core::Interface::as_raw(self), dwstate).ok()
    }
    pub unsafe fn GetSize(&self, dwwhich: u32) -> windows_core::Result<super::super::Foundation::RECT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSize)(windows_core::Interface::as_raw(self), dwwhich, &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDeskBarClient_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub SetDeskBarSite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetModeDBC: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub UIActivateDBC: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDesktopGadget, IDesktopGadget_Vtbl, 0xc1646bc4_f298_4f91_a204_eb2dd1709d1a);
impl core::ops::Deref for IDesktopGadget {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDesktopGadget, windows_core::IUnknown);
impl IDesktopGadget {
    pub unsafe fn RunGadget<P0>(&self, gadgetpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).RunGadget)(windows_core::Interface::as_raw(self), gadgetpath.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDesktopGadget_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RunGadget: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDesktopWallpaper, IDesktopWallpaper_Vtbl, 0xb92b56a9_8b55_4e14_9a89_0199bbb6f93b);
impl core::ops::Deref for IDesktopWallpaper {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDesktopWallpaper, windows_core::IUnknown);
impl IDesktopWallpaper {
    pub unsafe fn SetWallpaper<P0, P1>(&self, monitorid: P0, wallpaper: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetWallpaper)(windows_core::Interface::as_raw(self), monitorid.param().abi(), wallpaper.param().abi()).ok()
    }
    pub unsafe fn GetWallpaper<P0>(&self, monitorid: P0) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetWallpaper)(windows_core::Interface::as_raw(self), monitorid.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMonitorDevicePathAt(&self, monitorindex: u32) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMonitorDevicePathAt)(windows_core::Interface::as_raw(self), monitorindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetMonitorDevicePathCount(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMonitorDevicePathCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMonitorRECT<P0>(&self, monitorid: P0) -> windows_core::Result<super::super::Foundation::RECT>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMonitorRECT)(windows_core::Interface::as_raw(self), monitorid.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBackgroundColor<P0>(&self, color: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::COLORREF>,
    {
        (windows_core::Interface::vtable(self).SetBackgroundColor)(windows_core::Interface::as_raw(self), color.param().abi()).ok()
    }
    pub unsafe fn GetBackgroundColor(&self) -> windows_core::Result<super::super::Foundation::COLORREF> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBackgroundColor)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPosition(&self, position: DESKTOP_WALLPAPER_POSITION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetPosition)(windows_core::Interface::as_raw(self), position).ok()
    }
    pub unsafe fn GetPosition(&self) -> windows_core::Result<DESKTOP_WALLPAPER_POSITION> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPosition)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSlideshow<P0>(&self, items: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).SetSlideshow)(windows_core::Interface::as_raw(self), items.param().abi()).ok()
    }
    pub unsafe fn GetSlideshow(&self) -> windows_core::Result<IShellItemArray> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSlideshow)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetSlideshowOptions(&self, options: DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSlideshowOptions)(windows_core::Interface::as_raw(self), options, slideshowtick).ok()
    }
    pub unsafe fn GetSlideshowOptions(&self, options: *mut DESKTOP_SLIDESHOW_OPTIONS, slideshowtick: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSlideshowOptions)(windows_core::Interface::as_raw(self), options, slideshowtick).ok()
    }
    pub unsafe fn AdvanceSlideshow<P0>(&self, monitorid: P0, direction: DESKTOP_SLIDESHOW_DIRECTION) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AdvanceSlideshow)(windows_core::Interface::as_raw(self), monitorid.param().abi(), direction).ok()
    }
    pub unsafe fn GetStatus(&self) -> windows_core::Result<DESKTOP_SLIDESHOW_STATE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Enable<P0>(&self, enable: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self), enable.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDesktopWallpaper_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetWallpaper: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetWallpaper: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetMonitorDevicePathAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetMonitorDevicePathCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMonitorRECT: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::COLORREF) -> windows_core::HRESULT,
    pub GetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::COLORREF) -> windows_core::HRESULT,
    pub SetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, DESKTOP_WALLPAPER_POSITION) -> windows_core::HRESULT,
    pub GetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DESKTOP_WALLPAPER_POSITION) -> windows_core::HRESULT,
    pub SetSlideshow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSlideshow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSlideshowOptions: unsafe extern "system" fn(*mut core::ffi::c_void, DESKTOP_SLIDESHOW_OPTIONS, u32) -> windows_core::HRESULT,
    pub GetSlideshowOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DESKTOP_SLIDESHOW_OPTIONS, *mut u32) -> windows_core::HRESULT,
    pub AdvanceSlideshow: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, DESKTOP_SLIDESHOW_DIRECTION) -> windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DESKTOP_SLIDESHOW_STATE) -> windows_core::HRESULT,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDestinationStreamFactory, IDestinationStreamFactory_Vtbl, 0x8a87781b_39a7_4a1f_aab3_a39b9c34a7d9);
impl core::ops::Deref for IDestinationStreamFactory {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDestinationStreamFactory, windows_core::IUnknown);
impl IDestinationStreamFactory {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDestinationStream(&self) -> windows_core::Result<super::super::System::Com::IStream> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDestinationStream)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDestinationStreamFactory_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetDestinationStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetDestinationStream: usize,
}
windows_core::imp::define_interface!(IDisplayItem, IDisplayItem_Vtbl, 0xc6fd5997_9f6b_4888_8703_94e80e8cde3f);
impl core::ops::Deref for IDisplayItem {
    type Target = IRelatedItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDisplayItem, windows_core::IUnknown, IRelatedItem);
impl IDisplayItem {}
#[repr(C)]
pub struct IDisplayItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
windows_core::imp::define_interface!(IDocViewSite, IDocViewSite_Vtbl, 0x87d605e0_c511_11cf_89a9_00a0c9054129);
impl core::ops::Deref for IDocViewSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDocViewSite, windows_core::IUnknown);
impl IDocViewSite {
    pub unsafe fn OnSetTitle(&self, pvtitle: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnSetTitle)(windows_core::Interface::as_raw(self), core::mem::transmute(pvtitle)).ok()
    }
}
#[repr(C)]
pub struct IDocViewSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnSetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDockingWindow, IDockingWindow_Vtbl, 0x012dd920_7b26_11d0_8ca9_00a0c92dbfe8);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDockingWindow {
    type Target = super::super::System::Ole::IOleWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDockingWindow, windows_core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDockingWindow {
    pub unsafe fn ShowDW<P0>(&self, fshow: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).ShowDW)(windows_core::Interface::as_raw(self), fshow.param().abi()).ok()
    }
    pub unsafe fn CloseDW(&self, dwreserved: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseDW)(windows_core::Interface::as_raw(self), dwreserved).ok()
    }
    pub unsafe fn ResizeBorderDW<P0, P1>(&self, prcborder: *const super::super::Foundation::RECT, punktoolbarsite: P0, freserved: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).ResizeBorderDW)(windows_core::Interface::as_raw(self), prcborder, punktoolbarsite.param().abi(), freserved.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDockingWindow_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub ShowDW: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CloseDW: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ResizeBorderDW: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::RECT, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDockingWindowFrame, IDockingWindowFrame_Vtbl, 0x47d2657a_7b27_11d0_8ca9_00a0c92dbfe8);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDockingWindowFrame {
    type Target = super::super::System::Ole::IOleWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDockingWindowFrame, windows_core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDockingWindowFrame {
    pub unsafe fn AddToolbar<P0, P1>(&self, punksrc: P0, pwszitem: P1, dwaddflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddToolbar)(windows_core::Interface::as_raw(self), punksrc.param().abi(), pwszitem.param().abi(), dwaddflags).ok()
    }
    pub unsafe fn RemoveToolbar<P0>(&self, punksrc: P0, dwremoveflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).RemoveToolbar)(windows_core::Interface::as_raw(self), punksrc.param().abi(), dwremoveflags).ok()
    }
    pub unsafe fn FindToolbar<P0>(&self, pwszitem: P0, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).FindToolbar)(windows_core::Interface::as_raw(self), pwszitem.param().abi(), riid, ppv).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDockingWindowFrame_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub AddToolbar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub RemoveToolbar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub FindToolbar: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IDockingWindowSite, IDockingWindowSite_Vtbl, 0x2a342fc2_7b26_11d0_8ca9_00a0c92dbfe8);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IDockingWindowSite {
    type Target = super::super::System::Ole::IOleWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IDockingWindowSite, windows_core::IUnknown, super::super::System::Ole::IOleWindow);
#[cfg(feature = "Win32_System_Ole")]
impl IDockingWindowSite {
    pub unsafe fn GetBorderDW<P0>(&self, punkobj: P0) -> windows_core::Result<super::super::Foundation::RECT>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBorderDW)(windows_core::Interface::as_raw(self), punkobj.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn RequestBorderSpaceDW<P0>(&self, punkobj: P0, pbw: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).RequestBorderSpaceDW)(windows_core::Interface::as_raw(self), punkobj.param().abi(), pbw).ok()
    }
    pub unsafe fn SetBorderSpaceDW<P0>(&self, punkobj: P0, pbw: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).SetBorderSpaceDW)(windows_core::Interface::as_raw(self), punkobj.param().abi(), pbw).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IDockingWindowSite_Vtbl {
    pub base__: super::super::System::Ole::IOleWindow_Vtbl,
    pub GetBorderDW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub RequestBorderSpaceDW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub SetBorderSpaceDW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDragSourceHelper, IDragSourceHelper_Vtbl, 0xde5bf786_477a_11d2_839d_00c04fd918d0);
impl core::ops::Deref for IDragSourceHelper {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDragSourceHelper, windows_core::IUnknown);
impl IDragSourceHelper {
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com"))]
    pub unsafe fn InitializeFromBitmap<P0>(&self, pshdi: *const SHDRAGIMAGE, pdataobject: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).InitializeFromBitmap)(windows_core::Interface::as_raw(self), pshdi, pdataobject.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeFromWindow<P0, P1>(&self, hwnd: P0, ppt: Option<*const super::super::Foundation::POINT>, pdataobject: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).InitializeFromWindow)(windows_core::Interface::as_raw(self), hwnd.param().abi(), core::mem::transmute(ppt.unwrap_or(std::ptr::null())), pdataobject.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDragSourceHelper_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com"))]
    pub InitializeFromBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, *const SHDRAGIMAGE, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com")))]
    InitializeFromBitmap: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub InitializeFromWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::POINT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InitializeFromWindow: usize,
}
windows_core::imp::define_interface!(IDragSourceHelper2, IDragSourceHelper2_Vtbl, 0x83e07d0d_0c5f_4163_bf1a_60b274051e40);
impl core::ops::Deref for IDragSourceHelper2 {
    type Target = IDragSourceHelper;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDragSourceHelper2, windows_core::IUnknown, IDragSourceHelper);
impl IDragSourceHelper2 {
    pub unsafe fn SetFlags(&self, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), dwflags).ok()
    }
}
#[repr(C)]
pub struct IDragSourceHelper2_Vtbl {
    pub base__: IDragSourceHelper_Vtbl,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDropTargetHelper, IDropTargetHelper_Vtbl, 0x4657278b_411b_11d2_839a_00c04fd918d0);
impl core::ops::Deref for IDropTargetHelper {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDropTargetHelper, windows_core::IUnknown);
impl IDropTargetHelper {
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DragEnter<P0, P1>(&self, hwndtarget: P0, pdataobject: P1, ppt: *const super::super::Foundation::POINT, dweffect: super::super::System::Ole::DROPEFFECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).DragEnter)(windows_core::Interface::as_raw(self), hwndtarget.param().abi(), pdataobject.param().abi(), ppt, dweffect).ok()
    }
    pub unsafe fn DragLeave(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DragLeave)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn DragOver(&self, ppt: *const super::super::Foundation::POINT, dweffect: super::super::System::Ole::DROPEFFECT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DragOver)(windows_core::Interface::as_raw(self), ppt, dweffect).ok()
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Drop<P0>(&self, pdataobject: P0, ppt: *const super::super::Foundation::POINT, dweffect: super::super::System::Ole::DROPEFFECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).Drop)(windows_core::Interface::as_raw(self), pdataobject.param().abi(), ppt, dweffect).ok()
    }
    pub unsafe fn Show<P0>(&self, fshow: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).Show)(windows_core::Interface::as_raw(self), fshow.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDropTargetHelper_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DragEnter: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *const super::super::Foundation::POINT, super::super::System::Ole::DROPEFFECT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DragEnter: usize,
    pub DragLeave: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub DragOver: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::POINT, super::super::System::Ole::DROPEFFECT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    DragOver: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Drop: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Foundation::POINT, super::super::System::Ole::DROPEFFECT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Drop: usize,
    pub Show: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IDynamicHWHandler, IDynamicHWHandler_Vtbl, 0xdc2601d7_059e_42fc_a09d_2afd21b6d5f7);
impl core::ops::Deref for IDynamicHWHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDynamicHWHandler, windows_core::IUnknown);
impl IDynamicHWHandler {
    pub unsafe fn GetDynamicInfo<P0>(&self, pszdeviceid: P0, dwcontenttype: u32) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDynamicInfo)(windows_core::Interface::as_raw(self), pszdeviceid.param().abi(), dwcontenttype, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDynamicHWHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDynamicInfo: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IEnumACString, IEnumACString_Vtbl, 0x8e74c210_cf9d_4eaf_a403_7356428f0a5a);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IEnumACString {
    type Target = super::super::System::Com::IEnumString;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IEnumACString, windows_core::IUnknown, super::super::System::Com::IEnumString);
#[cfg(feature = "Win32_System_Com")]
impl IEnumACString {
    pub unsafe fn NextItem(&self, pszurl: Option<&mut [u16]>, pulsortindex: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).NextItem)(windows_core::Interface::as_raw(self), core::mem::transmute(pszurl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pszurl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pulsortindex).ok()
    }
    pub unsafe fn SetEnumOptions(&self, dwoptions: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetEnumOptions)(windows_core::Interface::as_raw(self), dwoptions).ok()
    }
    pub unsafe fn GetEnumOptions(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEnumOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IEnumACString_Vtbl {
    pub base__: super::super::System::Com::IEnumString_Vtbl,
    pub NextItem: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetEnumOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetEnumOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumAssocHandlers, IEnumAssocHandlers_Vtbl, 0x973810ae_9599_4b88_9e4d_6ee98c9552da);
impl core::ops::Deref for IEnumAssocHandlers {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumAssocHandlers, windows_core::IUnknown);
impl IEnumAssocHandlers {
    pub unsafe fn Next(&self, rgelt: &mut [Option<IAssocHandler>], pceltfetched: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IEnumAssocHandlers_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumExplorerCommand, IEnumExplorerCommand_Vtbl, 0xa88826f8_186f_4987_aade_ea0cef8fbfe8);
impl core::ops::Deref for IEnumExplorerCommand {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumExplorerCommand, windows_core::IUnknown);
impl IEnumExplorerCommand {
    pub unsafe fn Next(&self, puicommand: &mut [Option<IExplorerCommand>], pceltfetched: Option<*mut u32>) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), puicommand.len().try_into().unwrap(), core::mem::transmute(puicommand.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumExplorerCommand> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumExplorerCommand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumExtraSearch, IEnumExtraSearch_Vtbl, 0x0e700be1_9db6_11d1_a1ce_00c04fd75d13);
impl core::ops::Deref for IEnumExtraSearch {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumExtraSearch, windows_core::IUnknown);
impl IEnumExtraSearch {
    pub unsafe fn Next(&self, rgelt: &mut [EXTRASEARCH], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumExtraSearch> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumExtraSearch_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut EXTRASEARCH, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumFullIDList, IEnumFullIDList_Vtbl, 0xd0191542_7954_4908_bc06_b2360bbe45ba);
impl core::ops::Deref for IEnumFullIDList {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumFullIDList, windows_core::IUnknown);
impl IEnumFullIDList {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn Next(&self, rgelt: &mut [*mut Common::ITEMIDLIST], pceltfetched: Option<*mut u32>) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumFullIDList> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumFullIDList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut Common::ITEMIDLIST, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumHLITEM, IEnumHLITEM_Vtbl, 0x79eac9c6_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IEnumHLITEM {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumHLITEM, windows_core::IUnknown);
impl IEnumHLITEM {
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut HLITEM, pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), celt, rgelt, pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumHLITEM> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumHLITEM_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut HLITEM, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumIDList, IEnumIDList_Vtbl, 0x000214f2_0000_0000_c000_000000000046);
impl core::ops::Deref for IEnumIDList {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumIDList, windows_core::IUnknown);
impl IEnumIDList {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn Next(&self, rgelt: &mut [*mut Common::ITEMIDLIST], pceltfetched: Option<*mut u32>) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt)
    }
    pub unsafe fn Reset(&self) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn Clone(&self, ppenum: *mut Option<IEnumIDList>) -> windows_core::HRESULT {
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), core::mem::transmute(ppenum))
    }
}
#[repr(C)]
pub struct IEnumIDList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut Common::ITEMIDLIST, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumObjects, IEnumObjects_Vtbl, 0x2c1c7e2e_2d0e_4059_831e_1e6f82335c2e);
impl core::ops::Deref for IEnumObjects {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumObjects, windows_core::IUnknown);
impl IEnumObjects {
    pub unsafe fn Next(&self, riid: *const windows_core::GUID, rgelt: &mut [*mut core::ffi::c_void], pceltfetched: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), riid, core::mem::transmute(rgelt.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumObjects> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumObjects_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumPublishedApps, IEnumPublishedApps_Vtbl, 0x0b124f8c_91f0_11d1_b8b5_006008059382);
impl core::ops::Deref for IEnumPublishedApps {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumPublishedApps, windows_core::IUnknown);
impl IEnumPublishedApps {
    pub unsafe fn Next(&self) -> windows_core::Result<IPublishedApp> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IEnumPublishedApps_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumReadyCallback, IEnumReadyCallback_Vtbl, 0x61e00d45_8fff_4e60_924e_6537b61612dd);
impl core::ops::Deref for IEnumReadyCallback {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumReadyCallback, windows_core::IUnknown);
impl IEnumReadyCallback {
    pub unsafe fn EnumReady(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EnumReady)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IEnumReadyCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EnumReady: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumResources, IEnumResources_Vtbl, 0x2dd81fe3_a83c_4da9_a330_47249d345ba1);
impl core::ops::Deref for IEnumResources {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumResources, windows_core::IUnknown);
impl IEnumResources {
    pub unsafe fn Next(&self, psir: &mut [SHELL_ITEM_RESOURCE], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), psir.len().try_into().unwrap(), core::mem::transmute(psir.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumResources> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumResources_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut SHELL_ITEM_RESOURCE, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumShellItems, IEnumShellItems_Vtbl, 0x70629033_e363_4a28_a567_0db78006e6d7);
impl core::ops::Deref for IEnumShellItems {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumShellItems, windows_core::IUnknown);
impl IEnumShellItems {
    pub unsafe fn Next(&self, rgelt: &mut [Option<IShellItem>], pceltfetched: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), core::mem::transmute(pceltfetched.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumShellItems> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumShellItems_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumSyncMgrConflict, IEnumSyncMgrConflict_Vtbl, 0x82705914_dda3_4893_ba99_49de6c8c8036);
impl core::ops::Deref for IEnumSyncMgrConflict {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumSyncMgrConflict, windows_core::IUnknown);
impl IEnumSyncMgrConflict {
    pub unsafe fn Next(&self, rgelt: &mut [Option<ISyncMgrConflict>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumSyncMgrConflict> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumSyncMgrConflict_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumSyncMgrEvents, IEnumSyncMgrEvents_Vtbl, 0xc81a1d4e_8cf7_4683_80e0_bcae88d677b6);
impl core::ops::Deref for IEnumSyncMgrEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumSyncMgrEvents, windows_core::IUnknown);
impl IEnumSyncMgrEvents {
    pub unsafe fn Next(&self, rgelt: &mut [Option<ISyncMgrEvent>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumSyncMgrEvents> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumSyncMgrEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumSyncMgrSyncItems, IEnumSyncMgrSyncItems_Vtbl, 0x54b3abf3_f085_4181_b546_e29c403c726b);
impl core::ops::Deref for IEnumSyncMgrSyncItems {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumSyncMgrSyncItems, windows_core::IUnknown);
impl IEnumSyncMgrSyncItems {
    pub unsafe fn Next(&self, rgelt: &mut [Option<ISyncMgrSyncItem>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumSyncMgrSyncItems> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumSyncMgrSyncItems_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumTravelLogEntry, IEnumTravelLogEntry_Vtbl, 0x7ebfdd85_ad18_11d3_a4c5_00c04f72d6b8);
impl core::ops::Deref for IEnumTravelLogEntry {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumTravelLogEntry, windows_core::IUnknown);
impl IEnumTravelLogEntry {
    pub unsafe fn Next(&self, rgelt: &mut [Option<ITravelLogEntry>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumTravelLogEntry> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumTravelLogEntry_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IEnumerableView, IEnumerableView_Vtbl, 0x8c8bf236_1aec_495f_9894_91d57c3c686f);
impl core::ops::Deref for IEnumerableView {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEnumerableView, windows_core::IUnknown);
impl IEnumerableView {
    pub unsafe fn SetEnumReadyCallback<P0>(&self, percb: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IEnumReadyCallback>,
    {
        (windows_core::Interface::vtable(self).SetEnumReadyCallback)(windows_core::Interface::as_raw(self), percb.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn CreateEnumIDListFromContents(&self, pidlfolder: *const Common::ITEMIDLIST, dwenumflags: u32) -> windows_core::Result<IEnumIDList> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).CreateEnumIDListFromContents)(windows_core::Interface::as_raw(self), pidlfolder, dwenumflags, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumerableView_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetEnumReadyCallback: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub CreateEnumIDListFromContents: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    CreateEnumIDListFromContents: usize,
}
windows_core::imp::define_interface!(IExecuteCommand, IExecuteCommand_Vtbl, 0x7f9185b0_cb92_43c5_80a9_92277a4f7b54);
impl core::ops::Deref for IExecuteCommand {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExecuteCommand, windows_core::IUnknown);
impl IExecuteCommand {
    pub unsafe fn SetKeyState(&self, grfkeystate: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetKeyState)(windows_core::Interface::as_raw(self), grfkeystate).ok()
    }
    pub unsafe fn SetParameters<P0>(&self, pszparameters: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetParameters)(windows_core::Interface::as_raw(self), pszparameters.param().abi()).ok()
    }
    pub unsafe fn SetPosition(&self, pt: super::super::Foundation::POINT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetPosition)(windows_core::Interface::as_raw(self), core::mem::transmute(pt)).ok()
    }
    pub unsafe fn SetShowWindow(&self, nshow: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetShowWindow)(windows_core::Interface::as_raw(self), nshow).ok()
    }
    pub unsafe fn SetNoShowUI<P0>(&self, fnoshowui: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetNoShowUI)(windows_core::Interface::as_raw(self), fnoshowui.param().abi()).ok()
    }
    pub unsafe fn SetDirectory<P0>(&self, pszdirectory: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetDirectory)(windows_core::Interface::as_raw(self), pszdirectory.param().abi()).ok()
    }
    pub unsafe fn Execute(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IExecuteCommand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetKeyState: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::POINT) -> windows_core::HRESULT,
    pub SetShowWindow: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SetNoShowUI: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetDirectory: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExecuteCommandApplicationHostEnvironment, IExecuteCommandApplicationHostEnvironment_Vtbl, 0x18b21aa9_e184_4ff0_9f5e_f882d03771b3);
impl core::ops::Deref for IExecuteCommandApplicationHostEnvironment {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExecuteCommandApplicationHostEnvironment, windows_core::IUnknown);
impl IExecuteCommandApplicationHostEnvironment {
    pub unsafe fn GetValue(&self) -> windows_core::Result<AHE_TYPE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetValue)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExecuteCommandApplicationHostEnvironment_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AHE_TYPE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExecuteCommandHost, IExecuteCommandHost_Vtbl, 0x4b6832a2_5f04_4c9d_b89d_727a15d103e7);
impl core::ops::Deref for IExecuteCommandHost {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExecuteCommandHost, windows_core::IUnknown);
impl IExecuteCommandHost {
    pub unsafe fn GetUIMode(&self) -> windows_core::Result<EC_HOST_UI_MODE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetUIMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExecuteCommandHost_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetUIMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut EC_HOST_UI_MODE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExpDispSupport, IExpDispSupport_Vtbl, 0x0d7d1d00_6fc0_11d0_a974_00c04fd705a2);
impl core::ops::Deref for IExpDispSupport {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExpDispSupport, windows_core::IUnknown);
impl IExpDispSupport {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindConnectionPoint(&self, riid: *const windows_core::GUID) -> windows_core::Result<super::super::System::Com::IConnectionPoint> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FindConnectionPoint)(windows_core::Interface::as_raw(self), riid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn OnTranslateAccelerator(&self, pmsg: *const super::WindowsAndMessaging::MSG, grfmodifiers: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnTranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg, grfmodifiers).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OnInvoke(&self, dispidmember: i32, iid: *const windows_core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut windows_core::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnInvoke)(windows_core::Interface::as_raw(self), dispidmember, iid, lcid, wflags, pdispparams, core::mem::transmute(pvarresult), pexcepinfo, puargerr).ok()
    }
}
#[repr(C)]
pub struct IExpDispSupport_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub FindConnectionPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindConnectionPoint: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub OnTranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    OnTranslateAccelerator: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OnInvoke: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *const windows_core::GUID, u32, u16, *const super::super::System::Com::DISPPARAMS, *mut core::mem::MaybeUninit<windows_core::VARIANT>, *mut super::super::System::Com::EXCEPINFO, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OnInvoke: usize,
}
windows_core::imp::define_interface!(IExpDispSupportXP, IExpDispSupportXP_Vtbl, 0x2f0dd58c_f789_4f14_99fb_9293b3c9c212);
impl core::ops::Deref for IExpDispSupportXP {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExpDispSupportXP, windows_core::IUnknown);
impl IExpDispSupportXP {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindCIE4ConnectionPoint(&self, riid: *const windows_core::GUID) -> windows_core::Result<CIE4ConnectionPoint> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FindCIE4ConnectionPoint)(windows_core::Interface::as_raw(self), riid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn OnTranslateAccelerator(&self, pmsg: *const super::WindowsAndMessaging::MSG, grfmodifiers: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnTranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg, grfmodifiers).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OnInvoke(&self, dispidmember: i32, iid: *const windows_core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut windows_core::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnInvoke)(windows_core::Interface::as_raw(self), dispidmember, iid, lcid, wflags, pdispparams, core::mem::transmute(pvarresult), pexcepinfo, puargerr).ok()
    }
}
#[repr(C)]
pub struct IExpDispSupportXP_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub FindCIE4ConnectionPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindCIE4ConnectionPoint: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub OnTranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    OnTranslateAccelerator: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OnInvoke: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *const windows_core::GUID, u32, u16, *const super::super::System::Com::DISPPARAMS, *mut core::mem::MaybeUninit<windows_core::VARIANT>, *mut super::super::System::Com::EXCEPINFO, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OnInvoke: usize,
}
windows_core::imp::define_interface!(IExplorerBrowser, IExplorerBrowser_Vtbl, 0xdfd3b6b5_c10c_4be9_85f6_a66969f402f6);
impl core::ops::Deref for IExplorerBrowser {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerBrowser, windows_core::IUnknown);
impl IExplorerBrowser {
    pub unsafe fn Initialize<P0>(&self, hwndparent: P0, prc: *const super::super::Foundation::RECT, pfs: Option<*const FOLDERSETTINGS>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), hwndparent.param().abi(), prc, core::mem::transmute(pfs.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn Destroy(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Destroy)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetRect(&self, phdwp: Option<*mut super::WindowsAndMessaging::HDWP>, rcbrowser: super::super::Foundation::RECT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRect)(windows_core::Interface::as_raw(self), core::mem::transmute(phdwp.unwrap_or(std::ptr::null_mut())), core::mem::transmute(rcbrowser)).ok()
    }
    pub unsafe fn SetPropertyBag<P0>(&self, pszpropertybag: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetPropertyBag)(windows_core::Interface::as_raw(self), pszpropertybag.param().abi()).ok()
    }
    pub unsafe fn SetEmptyText<P0>(&self, pszemptytext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEmptyText)(windows_core::Interface::as_raw(self), pszemptytext.param().abi()).ok()
    }
    pub unsafe fn SetFolderSettings(&self, pfs: *const FOLDERSETTINGS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFolderSettings)(windows_core::Interface::as_raw(self), pfs).ok()
    }
    pub unsafe fn Advise<P0>(&self, psbe: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IExplorerBrowserEvents>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), psbe.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: EXPLORER_BROWSER_OPTIONS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), dwflag).ok()
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<EXPLORER_BROWSER_OPTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn BrowseToIDList(&self, pidl: *const Common::ITEMIDLIST, uflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).BrowseToIDList)(windows_core::Interface::as_raw(self), pidl, uflags).ok()
    }
    pub unsafe fn BrowseToObject<P0>(&self, punk: P0, uflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).BrowseToObject)(windows_core::Interface::as_raw(self), punk.param().abi(), uflags).ok()
    }
    pub unsafe fn FillFromObject<P0>(&self, punk: P0, dwflags: EXPLORER_BROWSER_FILL_FLAGS) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).FillFromObject)(windows_core::Interface::as_raw(self), punk.param().abi(), dwflags).ok()
    }
    pub unsafe fn RemoveAll(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAll)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetCurrentView<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetCurrentView)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IExplorerBrowser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::RECT, *const FOLDERSETTINGS) -> windows_core::HRESULT,
    pub Destroy: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::WindowsAndMessaging::HDWP, super::super::Foundation::RECT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetRect: usize,
    pub SetPropertyBag: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEmptyText: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFolderSettings: unsafe extern "system" fn(*mut core::ffi::c_void, *const FOLDERSETTINGS) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, EXPLORER_BROWSER_OPTIONS) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut EXPLORER_BROWSER_OPTIONS) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub BrowseToIDList: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    BrowseToIDList: usize,
    pub BrowseToObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub FillFromObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, EXPLORER_BROWSER_FILL_FLAGS) -> windows_core::HRESULT,
    pub RemoveAll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCurrentView: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExplorerBrowserEvents, IExplorerBrowserEvents_Vtbl, 0x361bbdc7_e6ee_4e13_be58_58e2240c810f);
impl core::ops::Deref for IExplorerBrowserEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerBrowserEvents, windows_core::IUnknown);
impl IExplorerBrowserEvents {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn OnNavigationPending(&self, pidlfolder: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnNavigationPending)(windows_core::Interface::as_raw(self), pidlfolder).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnViewCreated<P0>(&self, psv: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        (windows_core::Interface::vtable(self).OnViewCreated)(windows_core::Interface::as_raw(self), psv.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn OnNavigationComplete(&self, pidlfolder: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnNavigationComplete)(windows_core::Interface::as_raw(self), pidlfolder).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn OnNavigationFailed(&self, pidlfolder: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnNavigationFailed)(windows_core::Interface::as_raw(self), pidlfolder).ok()
    }
}
#[repr(C)]
pub struct IExplorerBrowserEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub OnNavigationPending: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    OnNavigationPending: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnViewCreated: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnViewCreated: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub OnNavigationComplete: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    OnNavigationComplete: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub OnNavigationFailed: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    OnNavigationFailed: usize,
}
windows_core::imp::define_interface!(IExplorerCommand, IExplorerCommand_Vtbl, 0xa08ce4d0_fa25_44ab_b57c_c7b1c323e0b9);
impl core::ops::Deref for IExplorerCommand {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerCommand, windows_core::IUnknown);
impl IExplorerCommand {
    pub unsafe fn GetTitle<P0>(&self, psiitemarray: P0) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetTitle)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetIcon<P0>(&self, psiitemarray: P0) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIcon)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetToolTip<P0>(&self, psiitemarray: P0) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetToolTip)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCanonicalName(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCanonicalName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetState<P0, P1>(&self, psiitemarray: P0, foktobeslow: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IShellItemArray>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetState)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), foktobeslow.param().abi(), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<P0, P1>(&self, psiitemarray: P0, pbc: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemArray>,
        P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    {
        (windows_core::Interface::vtable(self).Invoke)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), pbc.param().abi()).ok()
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn EnumSubCommands(&self) -> windows_core::Result<IEnumExplorerCommand> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumSubCommands)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IExplorerCommand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetIcon: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetToolTip: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetCanonicalName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub EnumSubCommands: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExplorerCommandProvider, IExplorerCommandProvider_Vtbl, 0x64961751_0835_43c0_8ffe_d57686530e64);
impl core::ops::Deref for IExplorerCommandProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerCommandProvider, windows_core::IUnknown);
impl IExplorerCommandProvider {
    pub unsafe fn GetCommands<P0, T>(&self, punksite: P0) -> windows_core::Result<T>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetCommands)(windows_core::Interface::as_raw(self), punksite.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetCommand<T>(&self, rguidcommandid: *const windows_core::GUID) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), rguidcommandid, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IExplorerCommandProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCommands: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExplorerCommandState, IExplorerCommandState_Vtbl, 0xbddacb60_7657_47ae_8445_d23e1acf82ae);
impl core::ops::Deref for IExplorerCommandState {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerCommandState, windows_core::IUnknown);
impl IExplorerCommandState {
    pub unsafe fn GetState<P0, P1>(&self, psiitemarray: P0, foktobeslow: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IShellItemArray>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetState)(windows_core::Interface::as_raw(self), psiitemarray.param().abi(), foktobeslow.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExplorerCommandState_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExplorerPaneVisibility, IExplorerPaneVisibility_Vtbl, 0xe07010ec_bc17_44c0_97b0_46c7c95b9edc);
impl core::ops::Deref for IExplorerPaneVisibility {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExplorerPaneVisibility, windows_core::IUnknown);
impl IExplorerPaneVisibility {
    pub unsafe fn GetPaneState(&self, ep: *const windows_core::GUID) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPaneState)(windows_core::Interface::as_raw(self), ep, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExplorerPaneVisibility_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetPaneState: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExtensionServices, IExtensionServices_Vtbl, 0x79eac9cb_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IExtensionServices {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExtensionServices, windows_core::IUnknown);
impl IExtensionServices {
    pub unsafe fn SetAdditionalHeaders<P0>(&self, pwzadditionalheaders: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAdditionalHeaders)(windows_core::Interface::as_raw(self), pwzadditionalheaders.param().abi()).ok()
    }
    pub unsafe fn SetAuthenticateData<P0, P1, P2>(&self, phwnd: P0, pwzusername: P1, pwzpassword: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAuthenticateData)(windows_core::Interface::as_raw(self), phwnd.param().abi(), pwzusername.param().abi(), pwzpassword.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IExtensionServices_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAdditionalHeaders: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetAuthenticateData: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IExtractIconA, IExtractIconA_Vtbl, 0x000214eb_0000_0000_c000_000000000046);
impl core::ops::Deref for IExtractIconA {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExtractIconA, windows_core::IUnknown);
impl IExtractIconA {
    pub unsafe fn GetIconLocation(&self, uflags: u32, psziconfile: &mut [u8], piindex: *mut i32, pwflags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIconLocation)(windows_core::Interface::as_raw(self), uflags, core::mem::transmute(psziconfile.as_ptr()), psziconfile.len().try_into().unwrap(), piindex, pwflags).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn Extract<P0>(&self, pszfile: P0, niconindex: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).Extract)(windows_core::Interface::as_raw(self), pszfile.param().abi(), niconindex, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), niconsize).ok()
    }
}
#[repr(C)]
pub struct IExtractIconA_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetIconLocation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut i32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub Extract: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, *mut super::WindowsAndMessaging::HICON, *mut super::WindowsAndMessaging::HICON, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    Extract: usize,
}
windows_core::imp::define_interface!(IExtractIconW, IExtractIconW_Vtbl, 0x000214fa_0000_0000_c000_000000000046);
impl core::ops::Deref for IExtractIconW {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExtractIconW, windows_core::IUnknown);
impl IExtractIconW {
    pub unsafe fn GetIconLocation(&self, uflags: u32, psziconfile: &mut [u16], piindex: *mut i32, pwflags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIconLocation)(windows_core::Interface::as_raw(self), uflags, core::mem::transmute(psziconfile.as_ptr()), psziconfile.len().try_into().unwrap(), piindex, pwflags).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn Extract<P0>(&self, pszfile: P0, niconindex: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Extract)(windows_core::Interface::as_raw(self), pszfile.param().abi(), niconindex, core::mem::transmute(phiconlarge.unwrap_or(std::ptr::null_mut())), core::mem::transmute(phiconsmall.unwrap_or(std::ptr::null_mut())), niconsize).ok()
    }
}
#[repr(C)]
pub struct IExtractIconW_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetIconLocation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut i32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub Extract: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut super::WindowsAndMessaging::HICON, *mut super::WindowsAndMessaging::HICON, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    Extract: usize,
}
windows_core::imp::define_interface!(IExtractImage, IExtractImage_Vtbl, 0xbb2e617c_0920_11d1_9a0b_00c04fc2d6c1);
impl core::ops::Deref for IExtractImage {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExtractImage, windows_core::IUnknown);
impl IExtractImage {
    pub unsafe fn GetLocation(&self, pszpathbuffer: &mut [u16], pdwpriority: *mut u32, prgsize: *const super::super::Foundation::SIZE, dwrecclrdepth: u32, pdwflags: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetLocation)(windows_core::Interface::as_raw(self), core::mem::transmute(pszpathbuffer.as_ptr()), pszpathbuffer.len().try_into().unwrap(), pdwpriority, prgsize, dwrecclrdepth, pdwflags).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn Extract(&self) -> windows_core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Extract)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExtractImage_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetLocation: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32, *const super::super::Foundation::SIZE, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub Extract: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    Extract: usize,
}
windows_core::imp::define_interface!(IExtractImage2, IExtractImage2_Vtbl, 0x953bb1ee_93b4_11d1_98a3_00c04fb687da);
impl core::ops::Deref for IExtractImage2 {
    type Target = IExtractImage;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IExtractImage2, windows_core::IUnknown, IExtractImage);
impl IExtractImage2 {
    pub unsafe fn GetDateStamp(&self) -> windows_core::Result<super::super::Foundation::FILETIME> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDateStamp)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IExtractImage2_Vtbl {
    pub base__: IExtractImage_Vtbl,
    pub GetDateStamp: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::FILETIME) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileDialog, IFileDialog_Vtbl, 0x42f85136_db7e_439c_85f1_e4075d135fc8);
impl core::ops::Deref for IFileDialog {
    type Target = IModalWindow;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileDialog, windows_core::IUnknown, IModalWindow);
impl IFileDialog {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetFileTypes(&self, rgfilterspec: &[Common::COMDLG_FILTERSPEC]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFileTypes)(windows_core::Interface::as_raw(self), rgfilterspec.len().try_into().unwrap(), core::mem::transmute(rgfilterspec.as_ptr())).ok()
    }
    pub unsafe fn SetFileTypeIndex(&self, ifiletype: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFileTypeIndex)(windows_core::Interface::as_raw(self), ifiletype).ok()
    }
    pub unsafe fn GetFileTypeIndex(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFileTypeIndex)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Advise<P0>(&self, pfde: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IFileDialogEvents>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pfde.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn SetOptions(&self, fos: FILEOPENDIALOGOPTIONS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), fos).ok()
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<FILEOPENDIALOGOPTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDefaultFolder<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetDefaultFolder)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn SetFolder<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetFolder)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn GetFolder(&self) -> windows_core::Result<IShellItem> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetCurrentSelection(&self) -> windows_core::Result<IShellItem> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentSelection)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetFileName<P0>(&self, pszname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFileName)(windows_core::Interface::as_raw(self), pszname.param().abi()).ok()
    }
    pub unsafe fn GetFileName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFileName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTitle<P0>(&self, psztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), psztitle.param().abi()).ok()
    }
    pub unsafe fn SetOkButtonLabel<P0>(&self, psztext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetOkButtonLabel)(windows_core::Interface::as_raw(self), psztext.param().abi()).ok()
    }
    pub unsafe fn SetFileNameLabel<P0>(&self, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFileNameLabel)(windows_core::Interface::as_raw(self), pszlabel.param().abi()).ok()
    }
    pub unsafe fn GetResult(&self) -> windows_core::Result<IShellItem> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetResult)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddPlace<P0>(&self, psi: P0, fdap: FDAP) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).AddPlace)(windows_core::Interface::as_raw(self), psi.param().abi(), fdap).ok()
    }
    pub unsafe fn SetDefaultExtension<P0>(&self, pszdefaultextension: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetDefaultExtension)(windows_core::Interface::as_raw(self), pszdefaultextension.param().abi()).ok()
    }
    pub unsafe fn Close(&self, hr: windows_core::HRESULT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self), hr).ok()
    }
    pub unsafe fn SetClientGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetClientGuid)(windows_core::Interface::as_raw(self), guid).ok()
    }
    pub unsafe fn ClearClientData(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ClearClientData)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFilter<P0>(&self, pfilter: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemFilter>,
    {
        (windows_core::Interface::vtable(self).SetFilter)(windows_core::Interface::as_raw(self), pfilter.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFileDialog_Vtbl {
    pub base__: IModalWindow_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetFileTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const Common::COMDLG_FILTERSPEC) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetFileTypes: usize,
    pub SetFileTypeIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetFileTypeIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, FILEOPENDIALOGOPTIONS) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FILEOPENDIALOGOPTIONS) -> windows_core::HRESULT,
    pub SetDefaultFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCurrentSelection: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFileName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetFileName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetOkButtonLabel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFileNameLabel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetResult: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddPlace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, FDAP) -> windows_core::HRESULT,
    pub SetDefaultExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT) -> windows_core::HRESULT,
    pub SetClientGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub ClearClientData: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileDialog2, IFileDialog2_Vtbl, 0x61744fc7_85b5_4791_a9b0_272276309b13);
impl core::ops::Deref for IFileDialog2 {
    type Target = IFileDialog;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileDialog2, windows_core::IUnknown, IModalWindow, IFileDialog);
impl IFileDialog2 {
    pub unsafe fn SetCancelButtonLabel<P0>(&self, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetCancelButtonLabel)(windows_core::Interface::as_raw(self), pszlabel.param().abi()).ok()
    }
    pub unsafe fn SetNavigationRoot<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetNavigationRoot)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFileDialog2_Vtbl {
    pub base__: IFileDialog_Vtbl,
    pub SetCancelButtonLabel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetNavigationRoot: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileDialogControlEvents, IFileDialogControlEvents_Vtbl, 0x36116642_d713_4b97_9b83_7484a9d00433);
impl core::ops::Deref for IFileDialogControlEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileDialogControlEvents, windows_core::IUnknown);
impl IFileDialogControlEvents {
    pub unsafe fn OnItemSelected<P0>(&self, pfdc: P0, dwidctl: u32, dwiditem: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialogCustomize>,
    {
        (windows_core::Interface::vtable(self).OnItemSelected)(windows_core::Interface::as_raw(self), pfdc.param().abi(), dwidctl, dwiditem).ok()
    }
    pub unsafe fn OnButtonClicked<P0>(&self, pfdc: P0, dwidctl: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialogCustomize>,
    {
        (windows_core::Interface::vtable(self).OnButtonClicked)(windows_core::Interface::as_raw(self), pfdc.param().abi(), dwidctl).ok()
    }
    pub unsafe fn OnCheckButtonToggled<P0, P1>(&self, pfdc: P0, dwidctl: u32, bchecked: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialogCustomize>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnCheckButtonToggled)(windows_core::Interface::as_raw(self), pfdc.param().abi(), dwidctl, bchecked.param().abi()).ok()
    }
    pub unsafe fn OnControlActivating<P0>(&self, pfdc: P0, dwidctl: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialogCustomize>,
    {
        (windows_core::Interface::vtable(self).OnControlActivating)(windows_core::Interface::as_raw(self), pfdc.param().abi(), dwidctl).ok()
    }
}
#[repr(C)]
pub struct IFileDialogControlEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnItemSelected: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnButtonClicked: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OnCheckButtonToggled: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OnControlActivating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileDialogCustomize, IFileDialogCustomize_Vtbl, 0xe6fdd21a_163f_4975_9c8c_a69f1ba37034);
impl core::ops::Deref for IFileDialogCustomize {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileDialogCustomize, windows_core::IUnknown);
impl IFileDialogCustomize {
    pub unsafe fn EnableOpenDropDown(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EnableOpenDropDown)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn AddMenu<P0>(&self, dwidctl: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddMenu)(windows_core::Interface::as_raw(self), dwidctl, pszlabel.param().abi()).ok()
    }
    pub unsafe fn AddPushButton<P0>(&self, dwidctl: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddPushButton)(windows_core::Interface::as_raw(self), dwidctl, pszlabel.param().abi()).ok()
    }
    pub unsafe fn AddComboBox(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddComboBox)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn AddRadioButtonList(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddRadioButtonList)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn AddCheckButton<P0, P1>(&self, dwidctl: u32, pszlabel: P0, bchecked: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).AddCheckButton)(windows_core::Interface::as_raw(self), dwidctl, pszlabel.param().abi(), bchecked.param().abi()).ok()
    }
    pub unsafe fn AddEditBox<P0>(&self, dwidctl: u32, psztext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddEditBox)(windows_core::Interface::as_raw(self), dwidctl, psztext.param().abi()).ok()
    }
    pub unsafe fn AddSeparator(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AddSeparator)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn AddText<P0>(&self, dwidctl: u32, psztext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddText)(windows_core::Interface::as_raw(self), dwidctl, psztext.param().abi()).ok()
    }
    pub unsafe fn SetControlLabel<P0>(&self, dwidctl: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetControlLabel)(windows_core::Interface::as_raw(self), dwidctl, pszlabel.param().abi()).ok()
    }
    pub unsafe fn GetControlState(&self, dwidctl: u32) -> windows_core::Result<CDCONTROLSTATEF> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetControlState)(windows_core::Interface::as_raw(self), dwidctl, &mut result__).map(|| result__)
    }
    pub unsafe fn SetControlState(&self, dwidctl: u32, dwstate: CDCONTROLSTATEF) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetControlState)(windows_core::Interface::as_raw(self), dwidctl, dwstate).ok()
    }
    pub unsafe fn GetEditBoxText(&self, dwidctl: u32) -> windows_core::Result<*mut u16> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetEditBoxText)(windows_core::Interface::as_raw(self), dwidctl, &mut result__).map(|| result__)
    }
    pub unsafe fn SetEditBoxText<P0>(&self, dwidctl: u32, psztext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetEditBoxText)(windows_core::Interface::as_raw(self), dwidctl, psztext.param().abi()).ok()
    }
    pub unsafe fn GetCheckButtonState(&self, dwidctl: u32) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCheckButtonState)(windows_core::Interface::as_raw(self), dwidctl, &mut result__).map(|| result__)
    }
    pub unsafe fn SetCheckButtonState<P0>(&self, dwidctl: u32, bchecked: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCheckButtonState)(windows_core::Interface::as_raw(self), dwidctl, bchecked.param().abi()).ok()
    }
    pub unsafe fn AddControlItem<P0>(&self, dwidctl: u32, dwiditem: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AddControlItem)(windows_core::Interface::as_raw(self), dwidctl, dwiditem, pszlabel.param().abi()).ok()
    }
    pub unsafe fn RemoveControlItem(&self, dwidctl: u32, dwiditem: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveControlItem)(windows_core::Interface::as_raw(self), dwidctl, dwiditem).ok()
    }
    pub unsafe fn RemoveAllControlItems(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAllControlItems)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn GetControlItemState(&self, dwidctl: u32, dwiditem: u32) -> windows_core::Result<CDCONTROLSTATEF> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetControlItemState)(windows_core::Interface::as_raw(self), dwidctl, dwiditem, &mut result__).map(|| result__)
    }
    pub unsafe fn SetControlItemState(&self, dwidctl: u32, dwiditem: u32, dwstate: CDCONTROLSTATEF) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetControlItemState)(windows_core::Interface::as_raw(self), dwidctl, dwiditem, dwstate).ok()
    }
    pub unsafe fn GetSelectedControlItem(&self, dwidctl: u32) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectedControlItem)(windows_core::Interface::as_raw(self), dwidctl, &mut result__).map(|| result__)
    }
    pub unsafe fn SetSelectedControlItem(&self, dwidctl: u32, dwiditem: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSelectedControlItem)(windows_core::Interface::as_raw(self), dwidctl, dwiditem).ok()
    }
    pub unsafe fn StartVisualGroup<P0>(&self, dwidctl: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartVisualGroup)(windows_core::Interface::as_raw(self), dwidctl, pszlabel.param().abi()).ok()
    }
    pub unsafe fn EndVisualGroup(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EndVisualGroup)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn MakeProminent(&self, dwidctl: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).MakeProminent)(windows_core::Interface::as_raw(self), dwidctl).ok()
    }
    pub unsafe fn SetControlItemText<P0>(&self, dwidctl: u32, dwiditem: u32, pszlabel: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetControlItemText)(windows_core::Interface::as_raw(self), dwidctl, dwiditem, pszlabel.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFileDialogCustomize_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EnableOpenDropDown: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddMenu: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddPushButton: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddComboBox: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddRadioButtonList: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddCheckButton: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub AddEditBox: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddSeparator: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetControlLabel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetControlState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut CDCONTROLSTATEF) -> windows_core::HRESULT,
    pub SetControlState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, CDCONTROLSTATEF) -> windows_core::HRESULT,
    pub GetEditBoxText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut u16) -> windows_core::HRESULT,
    pub SetEditBoxText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetCheckButtonState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetCheckButtonState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub AddControlItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub RemoveControlItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub RemoveAllControlItems: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetControlItemState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut CDCONTROLSTATEF) -> windows_core::HRESULT,
    pub SetControlItemState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, CDCONTROLSTATEF) -> windows_core::HRESULT,
    pub GetSelectedControlItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SetSelectedControlItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartVisualGroup: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub EndVisualGroup: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MakeProminent: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetControlItemText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileDialogEvents, IFileDialogEvents_Vtbl, 0x973510db_7d7f_452b_8975_74a85828d354);
impl core::ops::Deref for IFileDialogEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileDialogEvents, windows_core::IUnknown);
impl IFileDialogEvents {
    pub unsafe fn OnFileOk<P0>(&self, pfd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialog>,
    {
        (windows_core::Interface::vtable(self).OnFileOk)(windows_core::Interface::as_raw(self), pfd.param().abi()).ok()
    }
    pub unsafe fn OnFolderChanging<P0, P1>(&self, pfd: P0, psifolder: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialog>,
        P1: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnFolderChanging)(windows_core::Interface::as_raw(self), pfd.param().abi(), psifolder.param().abi()).ok()
    }
    pub unsafe fn OnFolderChange<P0>(&self, pfd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialog>,
    {
        (windows_core::Interface::vtable(self).OnFolderChange)(windows_core::Interface::as_raw(self), pfd.param().abi()).ok()
    }
    pub unsafe fn OnSelectionChange<P0>(&self, pfd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialog>,
    {
        (windows_core::Interface::vtable(self).OnSelectionChange)(windows_core::Interface::as_raw(self), pfd.param().abi()).ok()
    }
    pub unsafe fn OnShareViolation<P0, P1>(&self, pfd: P0, psi: P1) -> windows_core::Result<FDE_SHAREVIOLATION_RESPONSE>
    where
        P0: windows_core::Param<IFileDialog>,
        P1: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnShareViolation)(windows_core::Interface::as_raw(self), pfd.param().abi(), psi.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn OnTypeChange<P0>(&self, pfd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileDialog>,
    {
        (windows_core::Interface::vtable(self).OnTypeChange)(windows_core::Interface::as_raw(self), pfd.param().abi()).ok()
    }
    pub unsafe fn OnOverwrite<P0, P1>(&self, pfd: P0, psi: P1) -> windows_core::Result<FDE_OVERWRITE_RESPONSE>
    where
        P0: windows_core::Param<IFileDialog>,
        P1: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnOverwrite)(windows_core::Interface::as_raw(self), pfd.param().abi(), psi.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFileDialogEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnFileOk: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnFolderChanging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnFolderChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnSelectionChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnShareViolation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut FDE_SHAREVIOLATION_RESPONSE) -> windows_core::HRESULT,
    pub OnTypeChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnOverwrite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut FDE_OVERWRITE_RESPONSE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileIsInUse, IFileIsInUse_Vtbl, 0x64a1cbf0_3a1a_4461_9158_376969693950);
impl core::ops::Deref for IFileIsInUse {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileIsInUse, windows_core::IUnknown);
impl IFileIsInUse {
    pub unsafe fn GetAppName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAppName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetUsage(&self) -> windows_core::Result<FILE_USAGE_TYPE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetUsage)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCapabilities(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCapabilities)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSwitchToHWND(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSwitchToHWND)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CloseFile(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CloseFile)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IFileIsInUse_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetAppName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetUsage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FILE_USAGE_TYPE) -> windows_core::HRESULT,
    pub GetCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSwitchToHWND: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub CloseFile: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileOpenDialog, IFileOpenDialog_Vtbl, 0xd57c7288_d4ad_4768_be02_9d969532d960);
impl core::ops::Deref for IFileOpenDialog {
    type Target = IFileDialog;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileOpenDialog, windows_core::IUnknown, IModalWindow, IFileDialog);
impl IFileOpenDialog {
    pub unsafe fn GetResults(&self) -> windows_core::Result<IShellItemArray> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetResults)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetSelectedItems(&self) -> windows_core::Result<IShellItemArray> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectedItems)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IFileOpenDialog_Vtbl {
    pub base__: IFileDialog_Vtbl,
    pub GetResults: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSelectedItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileOperation, IFileOperation_Vtbl, 0x947aab5f_0a5c_4c13_b4d6_4bf7836fc9f8);
impl core::ops::Deref for IFileOperation {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileOperation, windows_core::IUnknown);
impl IFileOperation {
    pub unsafe fn Advise<P0>(&self, pfops: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IFileOperationProgressSink>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pfops.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn SetOperationFlags(&self, dwoperationflags: FILEOPERATION_FLAGS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOperationFlags)(windows_core::Interface::as_raw(self), dwoperationflags).ok()
    }
    pub unsafe fn SetProgressMessage<P0>(&self, pszmessage: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetProgressMessage)(windows_core::Interface::as_raw(self), pszmessage.param().abi()).ok()
    }
    pub unsafe fn SetProgressDialog<P0>(&self, popd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IOperationsProgressDialog>,
    {
        (windows_core::Interface::vtable(self).SetProgressDialog)(windows_core::Interface::as_raw(self), popd.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetProperties<P0>(&self, pproparray: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<PropertiesSystem::IPropertyChangeArray>,
    {
        (windows_core::Interface::vtable(self).SetProperties)(windows_core::Interface::as_raw(self), pproparray.param().abi()).ok()
    }
    pub unsafe fn SetOwnerWindow<P0>(&self, hwndowner: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SetOwnerWindow)(windows_core::Interface::as_raw(self), hwndowner.param().abi()).ok()
    }
    pub unsafe fn ApplyPropertiesToItem<P0>(&self, psiitem: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).ApplyPropertiesToItem)(windows_core::Interface::as_raw(self), psiitem.param().abi()).ok()
    }
    pub unsafe fn ApplyPropertiesToItems<P0>(&self, punkitems: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).ApplyPropertiesToItems)(windows_core::Interface::as_raw(self), punkitems.param().abi()).ok()
    }
    pub unsafe fn RenameItem<P0, P1, P2>(&self, psiitem: P0, psznewname: P1, pfopsitem: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).RenameItem)(windows_core::Interface::as_raw(self), psiitem.param().abi(), psznewname.param().abi(), pfopsitem.param().abi()).ok()
    }
    pub unsafe fn RenameItems<P0, P1>(&self, punkitems: P0, psznewname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).RenameItems)(windows_core::Interface::as_raw(self), punkitems.param().abi(), psznewname.param().abi()).ok()
    }
    pub unsafe fn MoveItem<P0, P1, P2, P3>(&self, psiitem: P0, psidestinationfolder: P1, psznewname: P2, pfopsitem: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).MoveItem)(windows_core::Interface::as_raw(self), psiitem.param().abi(), psidestinationfolder.param().abi(), psznewname.param().abi(), pfopsitem.param().abi()).ok()
    }
    pub unsafe fn MoveItems<P0, P1>(&self, punkitems: P0, psidestinationfolder: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).MoveItems)(windows_core::Interface::as_raw(self), punkitems.param().abi(), psidestinationfolder.param().abi()).ok()
    }
    pub unsafe fn CopyItem<P0, P1, P2, P3>(&self, psiitem: P0, psidestinationfolder: P1, pszcopyname: P2, pfopsitem: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).CopyItem)(windows_core::Interface::as_raw(self), psiitem.param().abi(), psidestinationfolder.param().abi(), pszcopyname.param().abi(), pfopsitem.param().abi()).ok()
    }
    pub unsafe fn CopyItems<P0, P1>(&self, punkitems: P0, psidestinationfolder: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).CopyItems)(windows_core::Interface::as_raw(self), punkitems.param().abi(), psidestinationfolder.param().abi()).ok()
    }
    pub unsafe fn DeleteItem<P0, P1>(&self, psiitem: P0, pfopsitem: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).DeleteItem)(windows_core::Interface::as_raw(self), psiitem.param().abi(), pfopsitem.param().abi()).ok()
    }
    pub unsafe fn DeleteItems<P0>(&self, punkitems: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).DeleteItems)(windows_core::Interface::as_raw(self), punkitems.param().abi()).ok()
    }
    pub unsafe fn NewItem<P0, P1, P2, P3>(&self, psidestinationfolder: P0, dwfileattributes: u32, pszname: P1, psztemplatename: P2, pfopsitem: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).NewItem)(windows_core::Interface::as_raw(self), psidestinationfolder.param().abi(), dwfileattributes, pszname.param().abi(), psztemplatename.param().abi(), pfopsitem.param().abi()).ok()
    }
    pub unsafe fn PerformOperations(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PerformOperations)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetAnyOperationsAborted(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAnyOperationsAborted)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFileOperation_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetOperationFlags: unsafe extern "system" fn(*mut core::ffi::c_void, FILEOPERATION_FLAGS) -> windows_core::HRESULT,
    pub SetProgressMessage: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetProperties: usize,
    pub SetOwnerWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub ApplyPropertiesToItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ApplyPropertiesToItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RenameItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RenameItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub MoveItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MoveItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CopyItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CopyItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DeleteItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DeleteItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub NewItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PerformOperations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetAnyOperationsAborted: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileOperation2, IFileOperation2_Vtbl, 0xcd8f23c1_8f61_4916_909d_55bdd0918753);
impl core::ops::Deref for IFileOperation2 {
    type Target = IFileOperation;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileOperation2, windows_core::IUnknown, IFileOperation);
impl IFileOperation2 {
    pub unsafe fn SetOperationFlags2(&self, operationflags2: FILE_OPERATION_FLAGS2) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOperationFlags2)(windows_core::Interface::as_raw(self), operationflags2).ok()
    }
}
#[repr(C)]
pub struct IFileOperation2_Vtbl {
    pub base__: IFileOperation_Vtbl,
    pub SetOperationFlags2: unsafe extern "system" fn(*mut core::ffi::c_void, FILE_OPERATION_FLAGS2) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileOperationProgressSink, IFileOperationProgressSink_Vtbl, 0x04b0f1a7_9490_44bc_96e1_4296a31252e2);
impl core::ops::Deref for IFileOperationProgressSink {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileOperationProgressSink, windows_core::IUnknown);
impl IFileOperationProgressSink {
    pub unsafe fn StartOperations(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).StartOperations)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn FinishOperations(&self, hrresult: windows_core::HRESULT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).FinishOperations)(windows_core::Interface::as_raw(self), hrresult).ok()
    }
    pub unsafe fn PreRenameItem<P0, P1>(&self, dwflags: u32, psiitem: P0, psznewname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).PreRenameItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psznewname.param().abi()).ok()
    }
    pub unsafe fn PostRenameItem<P0, P1, P2>(&self, dwflags: u32, psiitem: P0, psznewname: P1, hrrename: windows_core::HRESULT, psinewlycreated: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PostRenameItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psznewname.param().abi(), hrrename, psinewlycreated.param().abi()).ok()
    }
    pub unsafe fn PreMoveItem<P0, P1, P2>(&self, dwflags: u32, psiitem: P0, psidestinationfolder: P1, psznewname: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).PreMoveItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psidestinationfolder.param().abi(), psznewname.param().abi()).ok()
    }
    pub unsafe fn PostMoveItem<P0, P1, P2, P3>(&self, dwflags: u32, psiitem: P0, psidestinationfolder: P1, psznewname: P2, hrmove: windows_core::HRESULT, psinewlycreated: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PostMoveItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psidestinationfolder.param().abi(), psznewname.param().abi(), hrmove, psinewlycreated.param().abi()).ok()
    }
    pub unsafe fn PreCopyItem<P0, P1, P2>(&self, dwflags: u32, psiitem: P0, psidestinationfolder: P1, psznewname: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).PreCopyItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psidestinationfolder.param().abi(), psznewname.param().abi()).ok()
    }
    pub unsafe fn PostCopyItem<P0, P1, P2, P3>(&self, dwflags: u32, psiitem: P0, psidestinationfolder: P1, psznewname: P2, hrcopy: windows_core::HRESULT, psinewlycreated: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PostCopyItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), psidestinationfolder.param().abi(), psznewname.param().abi(), hrcopy, psinewlycreated.param().abi()).ok()
    }
    pub unsafe fn PreDeleteItem<P0>(&self, dwflags: u32, psiitem: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PreDeleteItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi()).ok()
    }
    pub unsafe fn PostDeleteItem<P0, P1>(&self, dwflags: u32, psiitem: P0, hrdelete: windows_core::HRESULT, psinewlycreated: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PostDeleteItem)(windows_core::Interface::as_raw(self), dwflags, psiitem.param().abi(), hrdelete, psinewlycreated.param().abi()).ok()
    }
    pub unsafe fn PreNewItem<P0, P1>(&self, dwflags: u32, psidestinationfolder: P0, psznewname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).PreNewItem)(windows_core::Interface::as_raw(self), dwflags, psidestinationfolder.param().abi(), psznewname.param().abi()).ok()
    }
    pub unsafe fn PostNewItem<P0, P1, P2, P3>(&self, dwflags: u32, psidestinationfolder: P0, psznewname: P1, psztemplatename: P2, dwfileattributes: u32, hrnew: windows_core::HRESULT, psinewitem: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).PostNewItem)(windows_core::Interface::as_raw(self), dwflags, psidestinationfolder.param().abi(), psznewname.param().abi(), psztemplatename.param().abi(), dwfileattributes, hrnew, psinewitem.param().abi()).ok()
    }
    pub unsafe fn UpdateProgress(&self, iworktotal: u32, iworksofar: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateProgress)(windows_core::Interface::as_raw(self), iworktotal, iworksofar).ok()
    }
    pub unsafe fn ResetTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetTimer)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PauseTimer)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ResumeTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResumeTimer)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IFileOperationProgressSink_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub StartOperations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FinishOperations: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT) -> windows_core::HRESULT,
    pub PreRenameItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub PostRenameItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::HRESULT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreMoveItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub PostMoveItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::HRESULT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreCopyItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub PostCopyItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::HRESULT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreDeleteItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PostDeleteItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::HRESULT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreNewItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub PostNewItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, u32, windows_core::HRESULT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub ResetTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PauseTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ResumeTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileSaveDialog, IFileSaveDialog_Vtbl, 0x84bccd23_5fde_4cdb_aea4_af64b83d78ab);
impl core::ops::Deref for IFileSaveDialog {
    type Target = IFileDialog;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileSaveDialog, windows_core::IUnknown, IModalWindow, IFileDialog);
impl IFileSaveDialog {
    pub unsafe fn SetSaveAsItem<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetSaveAsItem)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetProperties<P0>(&self, pstore: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<PropertiesSystem::IPropertyStore>,
    {
        (windows_core::Interface::vtable(self).SetProperties)(windows_core::Interface::as_raw(self), pstore.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetCollectedProperties<P0, P1>(&self, plist: P0, fappenddefault: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<PropertiesSystem::IPropertyDescriptionList>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCollectedProperties)(windows_core::Interface::as_raw(self), plist.param().abi(), fappenddefault.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetProperties(&self) -> windows_core::Result<PropertiesSystem::IPropertyStore> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProperties)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn ApplyProperties<P0, P1, P2, P3>(&self, psi: P0, pstore: P1, hwnd: P2, psink: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<PropertiesSystem::IPropertyStore>,
        P2: windows_core::Param<super::super::Foundation::HWND>,
        P3: windows_core::Param<IFileOperationProgressSink>,
    {
        (windows_core::Interface::vtable(self).ApplyProperties)(windows_core::Interface::as_raw(self), psi.param().abi(), pstore.param().abi(), hwnd.param().abi(), psink.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFileSaveDialog_Vtbl {
    pub base__: IFileDialog_Vtbl,
    pub SetSaveAsItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetProperties: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetCollectedProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetCollectedProperties: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetProperties: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub ApplyProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    ApplyProperties: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IFileSearchBand, IFileSearchBand_Vtbl, 0x2d91eea1_9932_11d2_be86_00a0c9a83da1);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IFileSearchBand {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IFileSearchBand, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IFileSearchBand {
    pub unsafe fn SetFocus(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFocus)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetSearchParameters<P0>(&self, pbstrsearchid: *const windows_core::BSTR, bnavtoresults: P0, pvarscope: *const windows_core::VARIANT, pvarqueryfile: *const windows_core::VARIANT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).SetSearchParameters)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrsearchid), bnavtoresults.param().abi(), core::mem::transmute(pvarscope), core::mem::transmute(pvarqueryfile)).ok()
    }
    pub unsafe fn SearchID(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).SearchID)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Scope(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Scope)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn QueryFile(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryFile)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IFileSearchBand_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSearchParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::mem::MaybeUninit<windows_core::BSTR>, super::super::Foundation::VARIANT_BOOL, *const core::mem::MaybeUninit<windows_core::VARIANT>, *const core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SearchID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Scope: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub QueryFile: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFileSyncMergeHandler, IFileSyncMergeHandler_Vtbl, 0xd97b5aac_c792_433c_975d_35c4eadc7a9d);
impl core::ops::Deref for IFileSyncMergeHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileSyncMergeHandler, windows_core::IUnknown);
impl IFileSyncMergeHandler {
    pub unsafe fn Merge<P0, P1>(&self, localfilepath: P0, serverfilepath: P1) -> windows_core::Result<MERGE_UPDATE_STATUS>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Merge)(windows_core::Interface::as_raw(self), localfilepath.param().abi(), serverfilepath.param().abi(), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn ShowResolveConflictUIAsync<P0, P1>(&self, localfilepath: P0, monitortodisplayon: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Graphics::Gdi::HMONITOR>,
    {
        (windows_core::Interface::vtable(self).ShowResolveConflictUIAsync)(windows_core::Interface::as_raw(self), localfilepath.param().abi(), monitortodisplayon.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFileSyncMergeHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Merge: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *mut MERGE_UPDATE_STATUS) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub ShowResolveConflictUIAsync: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    ShowResolveConflictUIAsync: usize,
}
windows_core::imp::define_interface!(IFileSystemBindData, IFileSystemBindData_Vtbl, 0x01e18d10_4d8b_11d2_855d_006008059367);
impl core::ops::Deref for IFileSystemBindData {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileSystemBindData, windows_core::IUnknown);
impl IFileSystemBindData {
    #[cfg(feature = "Win32_Storage_FileSystem")]
    pub unsafe fn SetFindData(&self, pfd: *const super::super::Storage::FileSystem::WIN32_FIND_DATAW) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFindData)(windows_core::Interface::as_raw(self), pfd).ok()
    }
    #[cfg(feature = "Win32_Storage_FileSystem")]
    pub unsafe fn GetFindData(&self, pfd: *mut super::super::Storage::FileSystem::WIN32_FIND_DATAW) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFindData)(windows_core::Interface::as_raw(self), pfd).ok()
    }
}
#[repr(C)]
pub struct IFileSystemBindData_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_FileSystem")]
    pub SetFindData: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Storage::FileSystem::WIN32_FIND_DATAW) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_FileSystem"))]
    SetFindData: usize,
    #[cfg(feature = "Win32_Storage_FileSystem")]
    pub GetFindData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Storage::FileSystem::WIN32_FIND_DATAW) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_FileSystem"))]
    GetFindData: usize,
}
windows_core::imp::define_interface!(IFileSystemBindData2, IFileSystemBindData2_Vtbl, 0x3acf075f_71db_4afa_81f0_3fc4fdf2a5b8);
impl core::ops::Deref for IFileSystemBindData2 {
    type Target = IFileSystemBindData;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFileSystemBindData2, windows_core::IUnknown, IFileSystemBindData);
impl IFileSystemBindData2 {
    pub unsafe fn SetFileID(&self, lifileid: i64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFileID)(windows_core::Interface::as_raw(self), lifileid).ok()
    }
    pub unsafe fn GetFileID(&self) -> windows_core::Result<i64> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFileID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetJunctionCLSID(&self, clsid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetJunctionCLSID)(windows_core::Interface::as_raw(self), clsid).ok()
    }
    pub unsafe fn GetJunctionCLSID(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetJunctionCLSID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFileSystemBindData2_Vtbl {
    pub base__: IFileSystemBindData_Vtbl,
    pub SetFileID: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
    pub GetFileID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub SetJunctionCLSID: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetJunctionCLSID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFolderBandPriv, IFolderBandPriv_Vtbl, 0x47c01f95_e185_412c_b5c5_4f27df965aea);
impl core::ops::Deref for IFolderBandPriv {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderBandPriv, windows_core::IUnknown);
impl IFolderBandPriv {
    pub unsafe fn SetCascade<P0>(&self, fcascade: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCascade)(windows_core::Interface::as_raw(self), fcascade.param().abi()).ok()
    }
    pub unsafe fn SetAccelerators<P0>(&self, faccelerators: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetAccelerators)(windows_core::Interface::as_raw(self), faccelerators.param().abi()).ok()
    }
    pub unsafe fn SetNoIcons<P0>(&self, fnoicons: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetNoIcons)(windows_core::Interface::as_raw(self), fnoicons.param().abi()).ok()
    }
    pub unsafe fn SetNoText<P0>(&self, fnotext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetNoText)(windows_core::Interface::as_raw(self), fnotext.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFolderBandPriv_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetCascade: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetAccelerators: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetNoIcons: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetNoText: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFolderFilter, IFolderFilter_Vtbl, 0x9cc22886_dc8e_11d2_b1d0_00c04f8eeb3e);
impl core::ops::Deref for IFolderFilter {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderFilter, windows_core::IUnknown);
impl IFolderFilter {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn ShouldShow<P0>(&self, psf: P0, pidlfolder: *const Common::ITEMIDLIST, pidlitem: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).ShouldShow)(windows_core::Interface::as_raw(self), psf.param().abi(), pidlfolder, pidlitem).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetEnumFlags<P0>(&self, psf: P0, pidlfolder: *const Common::ITEMIDLIST, phwnd: *mut super::super::Foundation::HWND, pgrfflags: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).GetEnumFlags)(windows_core::Interface::as_raw(self), psf.param().abi(), pidlfolder, phwnd, pgrfflags).ok()
    }
}
#[repr(C)]
pub struct IFolderFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub ShouldShow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    ShouldShow: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetEnumFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut super::super::Foundation::HWND, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetEnumFlags: usize,
}
windows_core::imp::define_interface!(IFolderFilterSite, IFolderFilterSite_Vtbl, 0xc0a651f5_b48b_11d2_b5ed_006097c686f6);
impl core::ops::Deref for IFolderFilterSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderFilterSite, windows_core::IUnknown);
impl IFolderFilterSite {
    pub unsafe fn SetFilter<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).SetFilter)(windows_core::Interface::as_raw(self), punk.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFolderFilterSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFolderView, IFolderView_Vtbl, 0xcde725b0_ccc9_4519_917e_325d72fab4ce);
impl core::ops::Deref for IFolderView {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderView, windows_core::IUnknown);
impl IFolderView {
    pub unsafe fn GetCurrentViewMode(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentViewMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCurrentViewMode(&self, viewmode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCurrentViewMode)(windows_core::Interface::as_raw(self), viewmode).ok()
    }
    pub unsafe fn GetFolder<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn Item(&self, iitemindex: i32) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), iitemindex, &mut result__).map(|| result__)
    }
    pub unsafe fn ItemCount(&self, uflags: _SVGIO) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ItemCount)(windows_core::Interface::as_raw(self), uflags.0 as _, &mut result__).map(|| result__)
    }
    pub unsafe fn Items<T>(&self, uflags: _SVGIO) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).Items)(windows_core::Interface::as_raw(self), uflags.0 as _, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetSelectionMarkedItem(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectionMarkedItem)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetFocusedItem(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFocusedItem)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetItemPosition(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<super::super::Foundation::POINT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetItemPosition)(windows_core::Interface::as_raw(self), pidl, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSpacing(&self, ppt: *mut super::super::Foundation::POINT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSpacing)(windows_core::Interface::as_raw(self), ppt).ok()
    }
    pub unsafe fn GetDefaultSpacing(&self) -> windows_core::Result<super::super::Foundation::POINT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetDefaultSpacing)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAutoArrange(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetAutoArrange)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SelectItem(&self, iitem: i32, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SelectItem)(windows_core::Interface::as_raw(self), iitem, dwflags).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SelectAndPositionItems(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, apt: Option<*const super::super::Foundation::POINT>, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SelectAndPositionItems)(windows_core::Interface::as_raw(self), cidl, apidl, core::mem::transmute(apt.unwrap_or(std::ptr::null())), dwflags).ok()
    }
}
#[repr(C)]
pub struct IFolderView_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCurrentViewMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCurrentViewMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    Item: usize,
    pub ItemCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut i32) -> windows_core::HRESULT,
    pub Items: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSelectionMarkedItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetFocusedItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetItemPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut super::super::Foundation::POINT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetItemPosition: usize,
    pub GetSpacing: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::POINT) -> windows_core::HRESULT,
    pub GetDefaultSpacing: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::POINT) -> windows_core::HRESULT,
    pub GetAutoArrange: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SelectItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SelectAndPositionItems: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const *const Common::ITEMIDLIST, *const super::super::Foundation::POINT, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SelectAndPositionItems: usize,
}
windows_core::imp::define_interface!(IFolderView2, IFolderView2_Vtbl, 0x1af3a467_214f_4298_908e_06b03e0b39f9);
impl core::ops::Deref for IFolderView2 {
    type Target = IFolderView;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderView2, windows_core::IUnknown, IFolderView);
impl IFolderView2 {
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetGroupBy<P0>(&self, key: *const PropertiesSystem::PROPERTYKEY, fascending: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetGroupBy)(windows_core::Interface::as_raw(self), key, fascending.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetGroupBy(&self, pkey: *mut PropertiesSystem::PROPERTYKEY, pfascending: Option<*mut super::super::Foundation::BOOL>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetGroupBy)(windows_core::Interface::as_raw(self), pkey, core::mem::transmute(pfascending.unwrap_or(std::ptr::null_mut()))).ok()
    }
    #[cfg(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn SetViewProperty(&self, pidl: *const Common::ITEMIDLIST, propkey: *const PropertiesSystem::PROPERTYKEY, propvar: *const windows_core::PROPVARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetViewProperty)(windows_core::Interface::as_raw(self), pidl, propkey, core::mem::transmute(propvar)).ok()
    }
    #[cfg(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetViewProperty(&self, pidl: *const Common::ITEMIDLIST, propkey: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<windows_core::PROPVARIANT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetViewProperty)(windows_core::Interface::as_raw(self), pidl, propkey, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetTileViewProperties<P0>(&self, pidl: *const Common::ITEMIDLIST, pszproplist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTileViewProperties)(windows_core::Interface::as_raw(self), pidl, pszproplist.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetExtendedTileViewProperties<P0>(&self, pidl: *const Common::ITEMIDLIST, pszproplist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetExtendedTileViewProperties)(windows_core::Interface::as_raw(self), pidl, pszproplist.param().abi()).ok()
    }
    pub unsafe fn SetText<P0>(&self, itype: FVTEXTTYPE, pwsztext: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetText)(windows_core::Interface::as_raw(self), itype, pwsztext.param().abi()).ok()
    }
    pub unsafe fn SetCurrentFolderFlags(&self, dwmask: u32, dwflags: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCurrentFolderFlags)(windows_core::Interface::as_raw(self), dwmask, dwflags).ok()
    }
    pub unsafe fn GetCurrentFolderFlags(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentFolderFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSortColumnCount(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSortColumnCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetSortColumns(&self, rgsortcolumns: &[SORTCOLUMN]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetSortColumns)(windows_core::Interface::as_raw(self), core::mem::transmute(rgsortcolumns.as_ptr()), rgsortcolumns.len().try_into().unwrap()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetSortColumns(&self, rgsortcolumns: &mut [SORTCOLUMN]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSortColumns)(windows_core::Interface::as_raw(self), core::mem::transmute(rgsortcolumns.as_ptr()), rgsortcolumns.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetItem<T>(&self, iitem: i32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetItem)(windows_core::Interface::as_raw(self), iitem, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetVisibleItem<P0>(&self, istart: i32, fprevious: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetVisibleItem)(windows_core::Interface::as_raw(self), istart, fprevious.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSelectedItem(&self, istart: i32) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectedItem)(windows_core::Interface::as_raw(self), istart, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSelection<P0>(&self, fnoneimpliesfolder: P0) -> windows_core::Result<IShellItemArray>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelection)(windows_core::Interface::as_raw(self), fnoneimpliesfolder.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetSelectionState(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectionState)(windows_core::Interface::as_raw(self), pidl, &mut result__).map(|| result__)
    }
    pub unsafe fn InvokeVerbOnSelection<P0>(&self, pszverb: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).InvokeVerbOnSelection)(windows_core::Interface::as_raw(self), pszverb.param().abi()).ok()
    }
    pub unsafe fn SetViewModeAndIconSize(&self, uviewmode: FOLDERVIEWMODE, iimagesize: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetViewModeAndIconSize)(windows_core::Interface::as_raw(self), uviewmode, iimagesize).ok()
    }
    pub unsafe fn GetViewModeAndIconSize(&self, puviewmode: *mut FOLDERVIEWMODE, piimagesize: *mut i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetViewModeAndIconSize)(windows_core::Interface::as_raw(self), puviewmode, piimagesize).ok()
    }
    pub unsafe fn SetGroupSubsetCount(&self, cvisiblerows: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetGroupSubsetCount)(windows_core::Interface::as_raw(self), cvisiblerows).ok()
    }
    pub unsafe fn GetGroupSubsetCount(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetGroupSubsetCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRedraw<P0>(&self, fredrawon: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetRedraw)(windows_core::Interface::as_raw(self), fredrawon.param().abi()).ok()
    }
    pub unsafe fn IsMoveInSameFolder(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsMoveInSameFolder)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DoRename(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DoRename)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IFolderView2_Vtbl {
    pub base__: IFolderView_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetGroupBy: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetGroupBy: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetGroupBy: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PropertiesSystem::PROPERTYKEY, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetGroupBy: usize,
    #[cfg(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub SetViewProperty: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *const PropertiesSystem::PROPERTYKEY, *const core::mem::MaybeUninit<windows_core::PROPVARIANT>) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    SetViewProperty: usize,
    #[cfg(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetViewProperty: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *const PropertiesSystem::PROPERTYKEY, *mut core::mem::MaybeUninit<windows_core::PROPVARIANT>) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetViewProperty: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetTileViewProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetTileViewProperties: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetExtendedTileViewProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetExtendedTileViewProperties: usize,
    pub SetText: unsafe extern "system" fn(*mut core::ffi::c_void, FVTEXTTYPE, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetCurrentFolderFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetCurrentFolderFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSortColumnCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetSortColumns: unsafe extern "system" fn(*mut core::ffi::c_void, *const SORTCOLUMN, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetSortColumns: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetSortColumns: unsafe extern "system" fn(*mut core::ffi::c_void, *mut SORTCOLUMN, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetSortColumns: usize,
    pub GetItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVisibleItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32, super::super::Foundation::BOOL, *mut i32) -> windows_core::HRESULT,
    pub GetSelectedItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub GetSelection: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetSelectionState: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetSelectionState: usize,
    pub InvokeVerbOnSelection: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub SetViewModeAndIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, FOLDERVIEWMODE, i32) -> windows_core::HRESULT,
    pub GetViewModeAndIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERVIEWMODE, *mut i32) -> windows_core::HRESULT,
    pub SetGroupSubsetCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetGroupSubsetCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetRedraw: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub IsMoveInSameFolder: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DoRename: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFolderViewHost, IFolderViewHost_Vtbl, 0x1ea58f02_d55a_411d_b09e_9e65ac21605b);
impl core::ops::Deref for IFolderViewHost {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderViewHost, windows_core::IUnknown);
impl IFolderViewHost {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<P0, P1>(&self, hwndparent: P0, pdo: P1, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), hwndparent.param().abi(), pdo.param().abi(), prc).ok()
    }
}
#[repr(C)]
pub struct IFolderViewHost_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IFolderViewOC, IFolderViewOC_Vtbl, 0x9ba05970_f6a8_11cf_a442_00a0c90a8f39);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IFolderViewOC {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IFolderViewOC, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IFolderViewOC {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetFolderView<P0>(&self, pdisp: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDispatch>,
    {
        (windows_core::Interface::vtable(self).SetFolderView)(windows_core::Interface::as_raw(self), pdisp.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IFolderViewOC_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SetFolderView: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetFolderView: usize,
}
windows_core::imp::define_interface!(IFolderViewOptions, IFolderViewOptions_Vtbl, 0x3cc974d2_b302_4d36_ad3e_06d93f695d3f);
impl core::ops::Deref for IFolderViewOptions {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderViewOptions, windows_core::IUnknown);
impl IFolderViewOptions {
    pub unsafe fn SetFolderViewOptions(&self, fvomask: FOLDERVIEWOPTIONS, fvoflags: FOLDERVIEWOPTIONS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFolderViewOptions)(windows_core::Interface::as_raw(self), fvomask, fvoflags).ok()
    }
    pub unsafe fn GetFolderViewOptions(&self) -> windows_core::Result<FOLDERVIEWOPTIONS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolderViewOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFolderViewOptions_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetFolderViewOptions: unsafe extern "system" fn(*mut core::ffi::c_void, FOLDERVIEWOPTIONS, FOLDERVIEWOPTIONS) -> windows_core::HRESULT,
    pub GetFolderViewOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERVIEWOPTIONS) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFolderViewSettings, IFolderViewSettings_Vtbl, 0xae8c987d_8797_4ed3_be72_2a47dd938db0);
impl core::ops::Deref for IFolderViewSettings {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFolderViewSettings, windows_core::IUnknown);
impl IFolderViewSettings {
    pub unsafe fn GetColumnPropertyList<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetColumnPropertyList)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetGroupByProperty(&self, pkey: *mut PropertiesSystem::PROPERTYKEY, pfgroupascending: *mut super::super::Foundation::BOOL) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetGroupByProperty)(windows_core::Interface::as_raw(self), pkey, pfgroupascending).ok()
    }
    pub unsafe fn GetViewMode(&self) -> windows_core::Result<FOLDERLOGICALVIEWMODE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetViewMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetIconSize(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIconSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetFolderFlags(&self, pfoldermask: *mut FOLDERFLAGS, pfolderflags: *mut FOLDERFLAGS) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolderFlags)(windows_core::Interface::as_raw(self), pfoldermask, pfolderflags).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetSortColumns(&self, rgsortcolumns: &mut [SORTCOLUMN], pccolumnsout: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetSortColumns)(windows_core::Interface::as_raw(self), core::mem::transmute(rgsortcolumns.as_ptr()), rgsortcolumns.len().try_into().unwrap(), pccolumnsout).ok()
    }
    pub unsafe fn GetGroupSubsetCount(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetGroupSubsetCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFolderViewSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetColumnPropertyList: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetGroupByProperty: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PropertiesSystem::PROPERTYKEY, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetGroupByProperty: usize,
    pub GetViewMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERLOGICALVIEWMODE) -> windows_core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFolderFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERFLAGS, *mut FOLDERFLAGS) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetSortColumns: unsafe extern "system" fn(*mut core::ffi::c_void, *mut SORTCOLUMN, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetSortColumns: usize,
    pub GetGroupSubsetCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFrameworkInputPane, IFrameworkInputPane_Vtbl, 0x5752238b_24f0_495a_82f1_2fd593056796);
impl core::ops::Deref for IFrameworkInputPane {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFrameworkInputPane, windows_core::IUnknown);
impl IFrameworkInputPane {
    pub unsafe fn Advise<P0, P1>(&self, pwindow: P0, phandler: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<IFrameworkInputPaneHandler>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pwindow.param().abi(), phandler.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn AdviseWithHWND<P0, P1>(&self, hwnd: P0, phandler: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<IFrameworkInputPaneHandler>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).AdviseWithHWND)(windows_core::Interface::as_raw(self), hwnd.param().abi(), phandler.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn Location(&self) -> windows_core::Result<super::super::Foundation::RECT> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Location)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFrameworkInputPane_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AdviseWithHWND: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Location: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IFrameworkInputPaneHandler, IFrameworkInputPaneHandler_Vtbl, 0x226c537b_1e76_4d9e_a760_33db29922f18);
impl core::ops::Deref for IFrameworkInputPaneHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IFrameworkInputPaneHandler, windows_core::IUnknown);
impl IFrameworkInputPaneHandler {
    pub unsafe fn Showing<P0>(&self, prcinputpanescreenlocation: *const super::super::Foundation::RECT, fensurefocusedelementinview: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).Showing)(windows_core::Interface::as_raw(self), prcinputpanescreenlocation, fensurefocusedelementinview.param().abi()).ok()
    }
    pub unsafe fn Hiding<P0>(&self, fensurefocusedelementinview: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).Hiding)(windows_core::Interface::as_raw(self), fensurefocusedelementinview.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFrameworkInputPaneHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Showing: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::RECT, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub Hiding: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IGetServiceIds, IGetServiceIds_Vtbl, 0x4a073526_6103_4e21_b7bc_f519d1524e5d);
impl core::ops::Deref for IGetServiceIds {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IGetServiceIds, windows_core::IUnknown);
impl IGetServiceIds {
    pub unsafe fn GetServiceIds(&self, serviceidcount: *mut u32, serviceids: *mut *mut windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetServiceIds)(windows_core::Interface::as_raw(self), serviceidcount, serviceids).ok()
    }
}
#[repr(C)]
pub struct IGetServiceIds_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetServiceIds: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut windows_core::GUID) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHWEventHandler, IHWEventHandler_Vtbl, 0xc1fb73d0_ec3a_4ba2_b512_8cdb9187b6d1);
impl core::ops::Deref for IHWEventHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHWEventHandler, windows_core::IUnknown);
impl IHWEventHandler {
    pub unsafe fn Initialize<P0>(&self, pszparams: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pszparams.param().abi()).ok()
    }
    pub unsafe fn HandleEvent<P0, P1, P2>(&self, pszdeviceid: P0, pszaltdeviceid: P1, pszeventtype: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).HandleEvent)(windows_core::Interface::as_raw(self), pszdeviceid.param().abi(), pszaltdeviceid.param().abi(), pszeventtype.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn HandleEventWithContent<P0, P1, P2, P3, P4>(&self, pszdeviceid: P0, pszaltdeviceid: P1, pszeventtype: P2, pszcontenttypehandler: P3, pdataobject: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        (windows_core::Interface::vtable(self).HandleEventWithContent)(windows_core::Interface::as_raw(self), pszdeviceid.param().abi(), pszaltdeviceid.param().abi(), pszeventtype.param().abi(), pszcontenttypehandler.param().abi(), pdataobject.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IHWEventHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub HandleEvent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub HandleEventWithContent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    HandleEventWithContent: usize,
}
windows_core::imp::define_interface!(IHWEventHandler2, IHWEventHandler2_Vtbl, 0xcfcc809f_295d_42e8_9ffc_424b33c487e6);
impl core::ops::Deref for IHWEventHandler2 {
    type Target = IHWEventHandler;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHWEventHandler2, windows_core::IUnknown, IHWEventHandler);
impl IHWEventHandler2 {
    pub unsafe fn HandleEventWithHWND<P0, P1, P2, P3>(&self, pszdeviceid: P0, pszaltdeviceid: P1, pszeventtype: P2, hwndowner: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).HandleEventWithHWND)(windows_core::Interface::as_raw(self), pszdeviceid.param().abi(), pszaltdeviceid.param().abi(), pszeventtype.param().abi(), hwndowner.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IHWEventHandler2_Vtbl {
    pub base__: IHWEventHandler_Vtbl,
    pub HandleEventWithHWND: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHandlerActivationHost, IHandlerActivationHost_Vtbl, 0x35094a87_8bb1_4237_96c6_c417eebdb078);
impl core::ops::Deref for IHandlerActivationHost {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHandlerActivationHost, windows_core::IUnknown);
impl IHandlerActivationHost {
    pub unsafe fn BeforeCoCreateInstance<P0, P1>(&self, clsidhandler: *const windows_core::GUID, itemsbeingactivated: P0, handlerinfo: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemArray>,
        P1: windows_core::Param<IHandlerInfo>,
    {
        (windows_core::Interface::vtable(self).BeforeCoCreateInstance)(windows_core::Interface::as_raw(self), clsidhandler, itemsbeingactivated.param().abi(), handlerinfo.param().abi()).ok()
    }
    pub unsafe fn BeforeCreateProcess<P0, P1, P2>(&self, applicationpath: P0, commandline: P1, handlerinfo: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<IHandlerInfo>,
    {
        (windows_core::Interface::vtable(self).BeforeCreateProcess)(windows_core::Interface::as_raw(self), applicationpath.param().abi(), commandline.param().abi(), handlerinfo.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IHandlerActivationHost_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub BeforeCoCreateInstance: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub BeforeCreateProcess: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHandlerInfo, IHandlerInfo_Vtbl, 0x997706ef_f880_453b_8118_39e1a2d2655a);
impl core::ops::Deref for IHandlerInfo {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHandlerInfo, windows_core::IUnknown);
impl IHandlerInfo {
    pub unsafe fn GetApplicationDisplayName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetApplicationDisplayName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetApplicationPublisher(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetApplicationPublisher)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetApplicationIconReference(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetApplicationIconReference)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IHandlerInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetApplicationDisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetApplicationPublisher: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetApplicationIconReference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHandlerInfo2, IHandlerInfo2_Vtbl, 0x31cca04c_04d3_4ea9_90de_97b15e87a532);
impl core::ops::Deref for IHandlerInfo2 {
    type Target = IHandlerInfo;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHandlerInfo2, windows_core::IUnknown, IHandlerInfo);
impl IHandlerInfo2 {
    pub unsafe fn GetApplicationId(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetApplicationId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IHandlerInfo2_Vtbl {
    pub base__: IHandlerInfo_Vtbl,
    pub GetApplicationId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHlink, IHlink_Vtbl, 0x79eac9c3_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IHlink {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHlink, windows_core::IUnknown);
impl IHlink {
    pub unsafe fn SetHlinkSite<P0>(&self, pihlsite: P0, dwsitedata: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IHlinkSite>,
    {
        (windows_core::Interface::vtable(self).SetHlinkSite)(windows_core::Interface::as_raw(self), pihlsite.param().abi(), dwsitedata).ok()
    }
    pub unsafe fn GetHlinkSite(&self, ppihlsite: *mut Option<IHlinkSite>, pdwsitedata: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetHlinkSite)(windows_core::Interface::as_raw(self), core::mem::transmute(ppihlsite), pdwsitedata).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetMonikerReference<P0, P1>(&self, grfhlsetf: u32, pimktarget: P0, pwzlocation: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetMonikerReference)(windows_core::Interface::as_raw(self), grfhlsetf, pimktarget.param().abi(), pwzlocation.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMonikerReference(&self, dwwhichref: u32, ppimktarget: Option<*mut Option<super::super::System::Com::IMoniker>>, ppwzlocation: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetMonikerReference)(windows_core::Interface::as_raw(self), dwwhichref, core::mem::transmute(ppimktarget.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppwzlocation.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetStringReference<P0, P1>(&self, grfhlsetf: u32, pwztarget: P0, pwzlocation: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetStringReference)(windows_core::Interface::as_raw(self), grfhlsetf, pwztarget.param().abi(), pwzlocation.param().abi()).ok()
    }
    pub unsafe fn GetStringReference(&self, dwwhichref: u32, ppwztarget: Option<*mut windows_core::PWSTR>, ppwzlocation: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetStringReference)(windows_core::Interface::as_raw(self), dwwhichref, core::mem::transmute(ppwztarget.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppwzlocation.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetFriendlyName<P0>(&self, pwzfriendlyname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFriendlyName)(windows_core::Interface::as_raw(self), pwzfriendlyname.param().abi()).ok()
    }
    pub unsafe fn GetFriendlyName(&self, grfhlfnamef: u32) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFriendlyName)(windows_core::Interface::as_raw(self), grfhlfnamef, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTargetFrameName<P0>(&self, pwztargetframename: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTargetFrameName)(windows_core::Interface::as_raw(self), pwztargetframename.param().abi()).ok()
    }
    pub unsafe fn GetTargetFrameName(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetTargetFrameName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMiscStatus(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMiscStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Navigate<P0, P1, P2>(&self, grfhlnf: u32, pibc: P0, pibsc: P1, pihlbc: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
        P1: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
        P2: windows_core::Param<IHlinkBrowseContext>,
    {
        (windows_core::Interface::vtable(self).Navigate)(windows_core::Interface::as_raw(self), grfhlnf, pibc.param().abi(), pibsc.param().abi(), pihlbc.param().abi()).ok()
    }
    pub unsafe fn SetAdditionalParams<P0>(&self, pwzadditionalparams: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAdditionalParams)(windows_core::Interface::as_raw(self), pwzadditionalparams.param().abi()).ok()
    }
    pub unsafe fn GetAdditionalParams(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAdditionalParams)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IHlink_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetHlinkSite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetHlinkSite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetMonikerReference: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetMonikerReference: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetMonikerReference: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetMonikerReference: usize,
    pub SetStringReference: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetStringReference: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetFriendlyName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetFriendlyName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetTargetFrameName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetTargetFrameName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetMiscStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Navigate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Navigate: usize,
    pub SetAdditionalParams: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetAdditionalParams: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHlinkBrowseContext, IHlinkBrowseContext_Vtbl, 0x79eac9c7_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IHlinkBrowseContext {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHlinkBrowseContext, windows_core::IUnknown);
impl IHlinkBrowseContext {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Register<P0, P1>(&self, reserved: u32, piunk: P0, pimk: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::System::Com::IMoniker>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Register)(windows_core::Interface::as_raw(self), reserved, piunk.param().abi(), pimk.param().abi(), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetObject<P0, P1>(&self, pimk: P0, fbindifrootregistered: P1) -> windows_core::Result<windows_core::IUnknown>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetObject)(windows_core::Interface::as_raw(self), pimk.param().abi(), fbindifrootregistered.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Revoke(&self, dwregister: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Revoke)(windows_core::Interface::as_raw(self), dwregister).ok()
    }
    pub unsafe fn SetBrowseWindowInfo(&self, phlbwi: *const HLBWINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetBrowseWindowInfo)(windows_core::Interface::as_raw(self), phlbwi).ok()
    }
    pub unsafe fn GetBrowseWindowInfo(&self, phlbwi: *mut HLBWINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetBrowseWindowInfo)(windows_core::Interface::as_raw(self), phlbwi).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetInitialHlink<P0, P1, P2>(&self, pimktarget: P0, pwzlocation: P1, pwzfriendlyname: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetInitialHlink)(windows_core::Interface::as_raw(self), pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OnNavigateHlink<P0, P1, P2>(&self, grfhlnf: u32, pimktarget: P0, pwzlocation: P1, pwzfriendlyname: P2) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnNavigateHlink)(windows_core::Interface::as_raw(self), grfhlnf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn UpdateHlink<P0, P1, P2>(&self, uhlid: u32, pimktarget: P0, pwzlocation: P1, pwzfriendlyname: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).UpdateHlink)(windows_core::Interface::as_raw(self), uhlid, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi()).ok()
    }
    pub unsafe fn EnumNavigationStack(&self, dwreserved: u32, grfhlfnamef: u32) -> windows_core::Result<IEnumHLITEM> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).EnumNavigationStack)(windows_core::Interface::as_raw(self), dwreserved, grfhlfnamef, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn QueryHlink(&self, grfhlqf: u32, uhlid: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryHlink)(windows_core::Interface::as_raw(self), grfhlqf, uhlid).ok()
    }
    pub unsafe fn GetHlink(&self, uhlid: u32) -> windows_core::Result<IHlink> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetHlink)(windows_core::Interface::as_raw(self), uhlid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetCurrentHlink(&self, uhlid: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCurrentHlink)(windows_core::Interface::as_raw(self), uhlid).ok()
    }
    pub unsafe fn Clone<P0>(&self, piunkouter: P0, riid: *const windows_core::GUID) -> windows_core::Result<windows_core::IUnknown>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), piunkouter.param().abi(), riid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Close(&self, reserved: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self), reserved).ok()
    }
}
#[repr(C)]
pub struct IHlinkBrowseContext_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Register: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Register: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetObject: usize,
    pub Revoke: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetBrowseWindowInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const HLBWINFO) -> windows_core::HRESULT,
    pub GetBrowseWindowInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut HLBWINFO) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetInitialHlink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetInitialHlink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OnNavigateHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OnNavigateHlink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub UpdateHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    UpdateHlink: usize,
    pub EnumNavigationStack: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub QueryHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetCurrentHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHlinkFrame, IHlinkFrame_Vtbl, 0x79eac9c5_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IHlinkFrame {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHlinkFrame, windows_core::IUnknown);
impl IHlinkFrame {
    pub unsafe fn SetBrowseContext<P0>(&self, pihlbc: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IHlinkBrowseContext>,
    {
        (windows_core::Interface::vtable(self).SetBrowseContext)(windows_core::Interface::as_raw(self), pihlbc.param().abi()).ok()
    }
    pub unsafe fn GetBrowseContext(&self) -> windows_core::Result<IHlinkBrowseContext> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBrowseContext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Navigate<P0, P1, P2>(&self, grfhlnf: u32, pbc: P0, pibsc: P1, pihlnavigate: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
        P1: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
        P2: windows_core::Param<IHlink>,
    {
        (windows_core::Interface::vtable(self).Navigate)(windows_core::Interface::as_raw(self), grfhlnf, pbc.param().abi(), pibsc.param().abi(), pihlnavigate.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OnNavigate<P0, P1, P2>(&self, grfhlnf: u32, pimktarget: P0, pwzlocation: P1, pwzfriendlyname: P2, dwreserved: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OnNavigate)(windows_core::Interface::as_raw(self), grfhlnf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), dwreserved).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn UpdateHlink<P0, P1, P2>(&self, uhlid: u32, pimktarget: P0, pwzlocation: P1, pwzfriendlyname: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).UpdateHlink)(windows_core::Interface::as_raw(self), uhlid, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IHlinkFrame_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetBrowseContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBrowseContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Navigate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Navigate: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OnNavigate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OnNavigate: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub UpdateHlink: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    UpdateHlink: usize,
}
windows_core::imp::define_interface!(IHlinkSite, IHlinkSite_Vtbl, 0x79eac9c2_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IHlinkSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHlinkSite, windows_core::IUnknown);
impl IHlinkSite {
    pub unsafe fn QueryService(&self, dwsitedata: u32, guidservice: *const windows_core::GUID, riid: *const windows_core::GUID) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryService)(windows_core::Interface::as_raw(self), dwsitedata, guidservice, riid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMoniker(&self, dwsitedata: u32, dwassign: u32, dwwhich: u32) -> windows_core::Result<super::super::System::Com::IMoniker> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMoniker)(windows_core::Interface::as_raw(self), dwsitedata, dwassign, dwwhich, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn ReadyToNavigate(&self, dwsitedata: u32, dwreserved: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ReadyToNavigate)(windows_core::Interface::as_raw(self), dwsitedata, dwreserved).ok()
    }
    pub unsafe fn OnNavigationComplete<P0>(&self, dwsitedata: u32, dwreserved: u32, hrerror: windows_core::HRESULT, pwzerror: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OnNavigationComplete)(windows_core::Interface::as_raw(self), dwsitedata, dwreserved, hrerror, pwzerror.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IHlinkSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryService: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetMoniker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetMoniker: usize,
    pub ReadyToNavigate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnNavigationComplete: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::HRESULT, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHlinkTarget, IHlinkTarget_Vtbl, 0x79eac9c4_baf9_11ce_8c82_00aa004ba90b);
impl core::ops::Deref for IHlinkTarget {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHlinkTarget, windows_core::IUnknown);
impl IHlinkTarget {
    pub unsafe fn SetBrowseContext<P0>(&self, pihlbc: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IHlinkBrowseContext>,
    {
        (windows_core::Interface::vtable(self).SetBrowseContext)(windows_core::Interface::as_raw(self), pihlbc.param().abi()).ok()
    }
    pub unsafe fn GetBrowseContext(&self) -> windows_core::Result<IHlinkBrowseContext> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetBrowseContext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Navigate<P0>(&self, grfhlnf: u32, pwzjumplocation: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Navigate)(windows_core::Interface::as_raw(self), grfhlnf, pwzjumplocation.param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMoniker<P0>(&self, pwzlocation: P0, dwassign: u32) -> windows_core::Result<super::super::System::Com::IMoniker>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMoniker)(windows_core::Interface::as_raw(self), pwzlocation.param().abi(), dwassign, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetFriendlyName<P0>(&self, pwzlocation: P0) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFriendlyName)(windows_core::Interface::as_raw(self), pwzlocation.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IHlinkTarget_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetBrowseContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBrowseContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Navigate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetMoniker: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetMoniker: usize,
    pub GetFriendlyName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IHomeGroup, IHomeGroup_Vtbl, 0x7a3bd1d9_35a9_4fb3_a467_f48cac35e2d0);
impl core::ops::Deref for IHomeGroup {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IHomeGroup, windows_core::IUnknown);
impl IHomeGroup {
    pub unsafe fn IsMember(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IsMember)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ShowSharingWizard<P0>(&self, owner: P0) -> windows_core::Result<HOMEGROUPSHARINGCHOICES>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ShowSharingWizard)(windows_core::Interface::as_raw(self), owner.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IHomeGroup_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub IsMember: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub ShowSharingWizard: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut HOMEGROUPSHARINGCHOICES) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IIOCancelInformation, IIOCancelInformation_Vtbl, 0xf5b0bf81_8cb5_4b1b_9449_1a159e0c733c);
impl core::ops::Deref for IIOCancelInformation {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IIOCancelInformation, windows_core::IUnknown);
impl IIOCancelInformation {
    pub unsafe fn SetCancelInformation(&self, dwthreadid: u32, umsgcancel: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCancelInformation)(windows_core::Interface::as_raw(self), dwthreadid, umsgcancel).ok()
    }
    pub unsafe fn GetCancelInformation(&self, pdwthreadid: Option<*mut u32>, pumsgcancel: Option<*mut u32>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetCancelInformation)(windows_core::Interface::as_raw(self), core::mem::transmute(pdwthreadid.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pumsgcancel.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IIOCancelInformation_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetCancelInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetCancelInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IIdentityName, IIdentityName_Vtbl, 0x7d903fca_d6f9_4810_8332_946c0177e247);
impl core::ops::Deref for IIdentityName {
    type Target = IRelatedItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IIdentityName, windows_core::IUnknown, IRelatedItem);
impl IIdentityName {}
#[repr(C)]
pub struct IIdentityName_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
windows_core::imp::define_interface!(IImageRecompress, IImageRecompress_Vtbl, 0x505f1513_6b3e_4892_a272_59f8889a4d3e);
impl core::ops::Deref for IImageRecompress {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IImageRecompress, windows_core::IUnknown);
impl IImageRecompress {
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn RecompressImage<P0, P1>(&self, psi: P0, cx: i32, cy: i32, iquality: i32, pstg: P1) -> windows_core::Result<super::super::System::Com::IStream>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<super::super::System::Com::StructuredStorage::IStorage>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).RecompressImage)(windows_core::Interface::as_raw(self), psi.param().abi(), cx, cy, iquality, pstg.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IImageRecompress_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub RecompressImage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32, i32, i32, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com_StructuredStorage"))]
    RecompressImage: usize,
}
windows_core::imp::define_interface!(IInitializeCommand, IInitializeCommand_Vtbl, 0x85075acf_231f_40ea_9610_d26b7b58f638);
impl core::ops::Deref for IInitializeCommand {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeCommand, windows_core::IUnknown);
impl IInitializeCommand {
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Initialize<P0, P1>(&self, pszcommandname: P0, ppb: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::System::Com::StructuredStorage::IPropertyBag>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pszcommandname.param().abi(), ppb.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInitializeCommand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com_StructuredStorage"))]
    Initialize: usize,
}
windows_core::imp::define_interface!(IInitializeNetworkFolder, IInitializeNetworkFolder_Vtbl, 0x6e0f9881_42a8_4f2a_97f8_8af4e026d92d);
impl core::ops::Deref for IInitializeNetworkFolder {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeNetworkFolder, windows_core::IUnknown);
impl IInitializeNetworkFolder {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn Initialize<P0, P1>(&self, pidl: *const Common::ITEMIDLIST, pidltarget: *const Common::ITEMIDLIST, udisplaytype: u32, pszresname: P0, pszprovider: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pidl, pidltarget, udisplaytype, pszresname.param().abi(), pszprovider.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInitializeNetworkFolder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *const Common::ITEMIDLIST, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    Initialize: usize,
}
windows_core::imp::define_interface!(IInitializeObject, IInitializeObject_Vtbl, 0x4622ad16_ff23_11d0_8d34_00a0c90f2719);
impl core::ops::Deref for IInitializeObject {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeObject, windows_core::IUnknown);
impl IInitializeObject {
    pub unsafe fn Initialize(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IInitializeObject_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInitializeWithBindCtx, IInitializeWithBindCtx_Vtbl, 0x71c0d2bc_726d_45cc_a6c0_2e31c1db2159);
impl core::ops::Deref for IInitializeWithBindCtx {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeWithBindCtx, windows_core::IUnknown);
impl IInitializeWithBindCtx {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<P0>(&self, pbc: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pbc.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInitializeWithBindCtx_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
}
windows_core::imp::define_interface!(IInitializeWithItem, IInitializeWithItem_Vtbl, 0x7f73be3f_fb79_493c_a6c7_7ee14e245841);
impl core::ops::Deref for IInitializeWithItem {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeWithItem, windows_core::IUnknown);
impl IInitializeWithItem {
    pub unsafe fn Initialize<P0>(&self, psi: P0, grfmode: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psi.param().abi(), grfmode).ok()
    }
}
#[repr(C)]
pub struct IInitializeWithItem_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInitializeWithPropertyStore, IInitializeWithPropertyStore_Vtbl, 0xc3e12eb5_7d8d_44f8_b6dd_0e77b34d6de4);
impl core::ops::Deref for IInitializeWithPropertyStore {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeWithPropertyStore, windows_core::IUnknown);
impl IInitializeWithPropertyStore {
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn Initialize<P0>(&self, pps: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<PropertiesSystem::IPropertyStore>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pps.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInitializeWithPropertyStore_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    Initialize: usize,
}
windows_core::imp::define_interface!(IInitializeWithWindow, IInitializeWithWindow_Vtbl, 0x3e68d4bd_7135_4d10_8018_9fb6d9f33fa1);
impl core::ops::Deref for IInitializeWithWindow {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInitializeWithWindow, windows_core::IUnknown);
impl IInitializeWithWindow {
    pub unsafe fn Initialize<P0>(&self, hwnd: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), hwnd.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInitializeWithWindow_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInputObject, IInputObject_Vtbl, 0x68284faa_6a48_11d0_8c78_00c04fd918b4);
impl core::ops::Deref for IInputObject {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputObject, windows_core::IUnknown);
impl IInputObject {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn UIActivateIO<P0>(&self, factivate: P0, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).UIActivateIO)(windows_core::Interface::as_raw(self), factivate.param().abi(), pmsg).ok()
    }
    pub unsafe fn HasFocusIO(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).HasFocusIO)(windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn TranslateAcceleratorIO(&self, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TranslateAcceleratorIO)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
}
#[repr(C)]
pub struct IInputObject_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub UIActivateIO: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    UIActivateIO: usize,
    pub HasFocusIO: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub TranslateAcceleratorIO: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    TranslateAcceleratorIO: usize,
}
windows_core::imp::define_interface!(IInputObject2, IInputObject2_Vtbl, 0x6915c085_510b_44cd_94af_28dfa56cf92b);
impl core::ops::Deref for IInputObject2 {
    type Target = IInputObject;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputObject2, windows_core::IUnknown, IInputObject);
impl IInputObject2 {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn TranslateAcceleratorGlobal(&self, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TranslateAcceleratorGlobal)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
}
#[repr(C)]
pub struct IInputObject2_Vtbl {
    pub base__: IInputObject_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub TranslateAcceleratorGlobal: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    TranslateAcceleratorGlobal: usize,
}
windows_core::imp::define_interface!(IInputObjectSite, IInputObjectSite_Vtbl, 0xf1db8392_7331_11d0_8c99_00a0c92dbfe8);
impl core::ops::Deref for IInputObjectSite {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputObjectSite, windows_core::IUnknown);
impl IInputObjectSite {
    pub unsafe fn OnFocusChangeIS<P0, P1>(&self, punkobj: P0, fsetfocus: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnFocusChangeIS)(windows_core::Interface::as_raw(self), punkobj.param().abi(), fsetfocus.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInputObjectSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnFocusChangeIS: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInputPaneAnimationCoordinator, IInputPaneAnimationCoordinator_Vtbl, 0x2af16ba9_2de5_4b75_82d9_01372afbffb4);
impl core::ops::Deref for IInputPaneAnimationCoordinator {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputPaneAnimationCoordinator, windows_core::IUnknown);
impl IInputPaneAnimationCoordinator {
    #[cfg(feature = "Win32_Graphics_DirectComposition")]
    pub unsafe fn AddAnimation<P0, P1>(&self, device: P0, animation: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<super::super::Graphics::DirectComposition::IDCompositionAnimation>,
    {
        (windows_core::Interface::vtable(self).AddAnimation)(windows_core::Interface::as_raw(self), device.param().abi(), animation.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IInputPaneAnimationCoordinator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectComposition")]
    pub AddAnimation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectComposition"))]
    AddAnimation: usize,
}
windows_core::imp::define_interface!(IInputPanelConfiguration, IInputPanelConfiguration_Vtbl, 0x41c81592_514c_48bd_a22e_e6af638521a6);
impl core::ops::Deref for IInputPanelConfiguration {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputPanelConfiguration, windows_core::IUnknown);
impl IInputPanelConfiguration {
    pub unsafe fn EnableFocusTracking(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).EnableFocusTracking)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IInputPanelConfiguration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EnableFocusTracking: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInputPanelInvocationConfiguration, IInputPanelInvocationConfiguration_Vtbl, 0xa213f136_3b45_4362_a332_efb6547cd432);
impl core::ops::Deref for IInputPanelInvocationConfiguration {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInputPanelInvocationConfiguration, windows_core::IUnknown);
impl IInputPanelInvocationConfiguration {
    pub unsafe fn RequireTouchInEditControl(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RequireTouchInEditControl)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IInputPanelInvocationConfiguration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RequireTouchInEditControl: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IInsertItem, IInsertItem_Vtbl, 0xd2b57227_3d23_4b95_93c0_492bd454c356);
impl core::ops::Deref for IInsertItem {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IInsertItem, windows_core::IUnknown);
impl IInsertItem {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn InsertItem(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InsertItem)(windows_core::Interface::as_raw(self), pidl).ok()
    }
}
#[repr(C)]
pub struct IInsertItem_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub InsertItem: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    InsertItem: usize,
}
windows_core::imp::define_interface!(IItemNameLimits, IItemNameLimits_Vtbl, 0x1df0d7f1_b267_4d28_8b10_12e23202a5c4);
impl core::ops::Deref for IItemNameLimits {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IItemNameLimits, windows_core::IUnknown);
impl IItemNameLimits {
    pub unsafe fn GetValidCharacters(&self, ppwszvalidchars: *mut windows_core::PWSTR, ppwszinvalidchars: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetValidCharacters)(windows_core::Interface::as_raw(self), ppwszvalidchars, ppwszinvalidchars).ok()
    }
    pub unsafe fn GetMaxLength<P0>(&self, pszname: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMaxLength)(windows_core::Interface::as_raw(self), pszname.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IItemNameLimits_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetValidCharacters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetMaxLength: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IKnownFolder, IKnownFolder_Vtbl, 0x3aa7af7e_9b36_420c_a8e3_f77d4674a488);
impl core::ops::Deref for IKnownFolder {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IKnownFolder, windows_core::IUnknown);
impl IKnownFolder {
    pub unsafe fn GetId(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCategory(&self) -> windows_core::Result<KF_CATEGORY> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCategory)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetShellItem<T>(&self, dwflags: u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetShellItem)(windows_core::Interface::as_raw(self), dwflags, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetPath(&self, dwflags: u32) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPath)(windows_core::Interface::as_raw(self), dwflags, &mut result__).map(|| result__)
    }
    pub unsafe fn SetPath<P0>(&self, dwflags: u32, pszpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetPath)(windows_core::Interface::as_raw(self), dwflags, pszpath.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetIDList(&self, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIDList)(windows_core::Interface::as_raw(self), dwflags, &mut result__).map(|| result__)
    }
    pub unsafe fn GetFolderType(&self) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolderType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetRedirectionCapabilities(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRedirectionCapabilities)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetFolderDefinition(&self, pkfd: *mut KNOWNFOLDER_DEFINITION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolderDefinition)(windows_core::Interface::as_raw(self), pkfd).ok()
    }
}
#[repr(C)]
pub struct IKnownFolder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetCategory: unsafe extern "system" fn(*mut core::ffi::c_void, *mut KF_CATEGORY) -> windows_core::HRESULT,
    pub GetShellItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPath: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetPath: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetIDList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetIDList: usize,
    pub GetFolderType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetRedirectionCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFolderDefinition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut KNOWNFOLDER_DEFINITION) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IKnownFolderManager, IKnownFolderManager_Vtbl, 0x8be2d872_86aa_4d47_b776_32cca40c7018);
impl core::ops::Deref for IKnownFolderManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IKnownFolderManager, windows_core::IUnknown);
impl IKnownFolderManager {
    pub unsafe fn FolderIdFromCsidl(&self, ncsidl: i32) -> windows_core::Result<windows_core::GUID> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FolderIdFromCsidl)(windows_core::Interface::as_raw(self), ncsidl, &mut result__).map(|| result__)
    }
    pub unsafe fn FolderIdToCsidl(&self, rfid: *const windows_core::GUID) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FolderIdToCsidl)(windows_core::Interface::as_raw(self), rfid, &mut result__).map(|| result__)
    }
    pub unsafe fn GetFolderIds(&self, ppkfid: *mut *mut windows_core::GUID, pcount: *mut u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolderIds)(windows_core::Interface::as_raw(self), ppkfid, pcount).ok()
    }
    pub unsafe fn GetFolder(&self, rfid: *const windows_core::GUID) -> windows_core::Result<IKnownFolder> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), rfid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetFolderByName<P0>(&self, pszcanonicalname: P0) -> windows_core::Result<IKnownFolder>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolderByName)(windows_core::Interface::as_raw(self), pszcanonicalname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RegisterFolder(&self, rfid: *const windows_core::GUID, pkfd: *const KNOWNFOLDER_DEFINITION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RegisterFolder)(windows_core::Interface::as_raw(self), rfid, pkfd).ok()
    }
    pub unsafe fn UnregisterFolder(&self, rfid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnregisterFolder)(windows_core::Interface::as_raw(self), rfid).ok()
    }
    pub unsafe fn FindFolderFromPath<P0>(&self, pszpath: P0, mode: FFFP_MODE) -> windows_core::Result<IKnownFolder>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FindFolderFromPath)(windows_core::Interface::as_raw(self), pszpath.param().abi(), mode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn FindFolderFromIDList(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<IKnownFolder> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).FindFolderFromIDList)(windows_core::Interface::as_raw(self), pidl, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Redirect<P0, P1>(&self, rfid: *const windows_core::GUID, hwnd: P0, flags: u32, psztargetpath: P1, pexclusion: Option<&[windows_core::GUID]>, ppszerror: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Redirect)(windows_core::Interface::as_raw(self), rfid, hwnd.param().abi(), flags, psztargetpath.param().abi(), pexclusion.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pexclusion.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), core::mem::transmute(ppszerror.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IKnownFolderManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub FolderIdFromCsidl: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub FolderIdToCsidl: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut i32) -> windows_core::HRESULT,
    pub GetFolderIds: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFolderByName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const KNOWNFOLDER_DEFINITION) -> windows_core::HRESULT,
    pub UnregisterFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub FindFolderFromPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, FFFP_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub FindFolderFromIDList: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    FindFolderFromIDList: usize,
    pub Redirect: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, super::super::Foundation::HWND, u32, windows_core::PCWSTR, u32, *const windows_core::GUID, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ILaunchSourceAppUserModelId, ILaunchSourceAppUserModelId_Vtbl, 0x989191ac_28ff_4cf0_9584_e0d078bc2396);
impl core::ops::Deref for ILaunchSourceAppUserModelId {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchSourceAppUserModelId, windows_core::IUnknown);
impl ILaunchSourceAppUserModelId {
    pub unsafe fn GetAppUserModelId(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAppUserModelId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ILaunchSourceAppUserModelId_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetAppUserModelId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ILaunchSourceViewSizePreference, ILaunchSourceViewSizePreference_Vtbl, 0xe5aa01f7_1fb8_4830_8720_4e6734cbd5f3);
impl core::ops::Deref for ILaunchSourceViewSizePreference {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchSourceViewSizePreference, windows_core::IUnknown);
impl ILaunchSourceViewSizePreference {
    pub unsafe fn GetSourceViewToPosition(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSourceViewToPosition)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceViewSizePreference(&self) -> windows_core::Result<APPLICATION_VIEW_SIZE_PREFERENCE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSourceViewSizePreference)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ILaunchSourceViewSizePreference_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetSourceViewToPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub GetSourceViewSizePreference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut APPLICATION_VIEW_SIZE_PREFERENCE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ILaunchTargetMonitor, ILaunchTargetMonitor_Vtbl, 0x266fbc7e_490d_46ed_a96b_2274db252003);
impl core::ops::Deref for ILaunchTargetMonitor {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchTargetMonitor, windows_core::IUnknown);
impl ILaunchTargetMonitor {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> windows_core::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMonitor)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ILaunchTargetMonitor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
}
windows_core::imp::define_interface!(ILaunchTargetViewSizePreference, ILaunchTargetViewSizePreference_Vtbl, 0x2f0666c6_12f7_4360_b511_a394a0553725);
impl core::ops::Deref for ILaunchTargetViewSizePreference {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchTargetViewSizePreference, windows_core::IUnknown);
impl ILaunchTargetViewSizePreference {
    pub unsafe fn GetTargetViewSizePreference(&self) -> windows_core::Result<APPLICATION_VIEW_SIZE_PREFERENCE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetTargetViewSizePreference)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ILaunchTargetViewSizePreference_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTargetViewSizePreference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut APPLICATION_VIEW_SIZE_PREFERENCE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ILaunchUIContext, ILaunchUIContext_Vtbl, 0x1791e8f6_21c7_4340_882a_a6a93e3fd73b);
impl core::ops::Deref for ILaunchUIContext {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchUIContext, windows_core::IUnknown);
impl ILaunchUIContext {
    pub unsafe fn SetAssociatedWindow<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SetAssociatedWindow)(windows_core::Interface::as_raw(self), value.param().abi()).ok()
    }
    pub unsafe fn SetTabGroupingPreference(&self, value: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetTabGroupingPreference)(windows_core::Interface::as_raw(self), value).ok()
    }
}
#[repr(C)]
pub struct ILaunchUIContext_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAssociatedWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub SetTabGroupingPreference: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(ILaunchUIContextProvider, ILaunchUIContextProvider_Vtbl, 0x0d12c4c8_a3d9_4e24_94c1_0e20c5a956c4);
impl core::ops::Deref for ILaunchUIContextProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ILaunchUIContextProvider, windows_core::IUnknown);
impl ILaunchUIContextProvider {
    pub unsafe fn UpdateContext<P0>(&self, context: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ILaunchUIContext>,
    {
        (windows_core::Interface::vtable(self).UpdateContext)(windows_core::Interface::as_raw(self), context.param().abi()).ok()
    }
}
#[repr(C)]
pub struct ILaunchUIContextProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub UpdateContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IMenuBand, IMenuBand_Vtbl, 0x568804cd_cbd7_11d0_9816_00c04fd91972);
impl core::ops::Deref for IMenuBand {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IMenuBand, windows_core::IUnknown);
impl IMenuBand {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn IsMenuMessage(&self, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsMenuMessage)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn TranslateMenuMessage(&self, pmsg: *mut super::WindowsAndMessaging::MSG, plret: *mut super::super::Foundation::LRESULT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TranslateMenuMessage)(windows_core::Interface::as_raw(self), pmsg, plret).ok()
    }
}
#[repr(C)]
pub struct IMenuBand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub IsMenuMessage: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    IsMenuMessage: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub TranslateMenuMessage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::WindowsAndMessaging::MSG, *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    TranslateMenuMessage: usize,
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::define_interface!(IMenuPopup, IMenuPopup_Vtbl, 0xd1e7afeb_6a2e_11d0_8c78_00c04fd918b4);
#[cfg(feature = "Win32_System_Ole")]
impl core::ops::Deref for IMenuPopup {
    type Target = IDeskBar;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Ole")]
windows_core::imp::interface_hierarchy!(IMenuPopup, windows_core::IUnknown, super::super::System::Ole::IOleWindow, IDeskBar);
#[cfg(feature = "Win32_System_Ole")]
impl IMenuPopup {
    pub unsafe fn Popup(&self, ppt: *const super::super::Foundation::POINTL, prcexclude: Option<*const super::super::Foundation::RECTL>, dwflags: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Popup)(windows_core::Interface::as_raw(self), ppt, core::mem::transmute(prcexclude.unwrap_or(std::ptr::null())), dwflags).ok()
    }
    pub unsafe fn OnSelect(&self, dwselecttype: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).OnSelect)(windows_core::Interface::as_raw(self), dwselecttype).ok()
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetSubMenu<P0, P1>(&self, pmp: P0, fset: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMenuPopup>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetSubMenu)(windows_core::Interface::as_raw(self), pmp.param().abi(), fset.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[repr(C)]
pub struct IMenuPopup_Vtbl {
    pub base__: IDeskBar_Vtbl,
    pub Popup: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::POINTL, *const super::super::Foundation::RECTL, i32) -> windows_core::HRESULT,
    pub OnSelect: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetSubMenu: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetSubMenu: usize,
}
windows_core::imp::define_interface!(IModalWindow, IModalWindow_Vtbl, 0xb4db1657_70d7_485e_8e3e_6fcb5a5c1802);
impl core::ops::Deref for IModalWindow {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IModalWindow, windows_core::IUnknown);
impl IModalWindow {
    pub unsafe fn Show<P0>(&self, hwndowner: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Show)(windows_core::Interface::as_raw(self), hwndowner.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IModalWindow_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Show: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeAccessible, INameSpaceTreeAccessible_Vtbl, 0x71f312de_43ed_4190_8477_e9536b82350b);
impl core::ops::Deref for INameSpaceTreeAccessible {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeAccessible, windows_core::IUnknown);
impl INameSpaceTreeAccessible {
    pub unsafe fn OnGetDefaultAccessibilityAction<P0>(&self, psi: P0) -> windows_core::Result<windows_core::BSTR>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnGetDefaultAccessibilityAction)(windows_core::Interface::as_raw(self), psi.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn OnDoDefaultAccessibilityAction<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnDoDefaultAccessibilityAction)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnGetAccessibilityRole<P0>(&self, psi: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).OnGetAccessibilityRole)(windows_core::Interface::as_raw(self), psi.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct INameSpaceTreeAccessible_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnGetDefaultAccessibilityAction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub OnDoDefaultAccessibilityAction: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnGetAccessibilityRole: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeControl, INameSpaceTreeControl_Vtbl, 0x028212a3_b627_47e9_8856_c14265554e4f);
impl core::ops::Deref for INameSpaceTreeControl {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControl, windows_core::IUnknown);
impl INameSpaceTreeControl {
    pub unsafe fn Initialize<P0>(&self, hwndparent: P0, prc: *const super::super::Foundation::RECT, nsctsflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), hwndparent.param().abi(), prc, nsctsflags).ok()
    }
    pub unsafe fn TreeAdvise<P0>(&self, punk: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).TreeAdvise)(windows_core::Interface::as_raw(self), punk.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn TreeUnadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TreeUnadvise)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn AppendRoot<P0, P1>(&self, psiroot: P0, grfenumflags: u32, grfrootstyle: u32, pif: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemFilter>,
    {
        (windows_core::Interface::vtable(self).AppendRoot)(windows_core::Interface::as_raw(self), psiroot.param().abi(), grfenumflags, grfrootstyle, pif.param().abi()).ok()
    }
    pub unsafe fn InsertRoot<P0, P1>(&self, iindex: i32, psiroot: P0, grfenumflags: u32, grfrootstyle: u32, pif: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemFilter>,
    {
        (windows_core::Interface::vtable(self).InsertRoot)(windows_core::Interface::as_raw(self), iindex, psiroot.param().abi(), grfenumflags, grfrootstyle, pif.param().abi()).ok()
    }
    pub unsafe fn RemoveRoot<P0>(&self, psiroot: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).RemoveRoot)(windows_core::Interface::as_raw(self), psiroot.param().abi()).ok()
    }
    pub unsafe fn RemoveAllRoots(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveAllRoots)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRootItems(&self) -> windows_core::Result<IShellItemArray> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetRootItems)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetItemState<P0>(&self, psi: P0, nstcismask: u32, nstcisflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetItemState)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcismask, nstcisflags).ok()
    }
    pub unsafe fn GetItemState<P0>(&self, psi: P0, nstcismask: u32) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetItemState)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcismask, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSelectedItems(&self) -> windows_core::Result<IShellItemArray> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSelectedItems)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetItemCustomState<P0>(&self, psi: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetItemCustomState)(windows_core::Interface::as_raw(self), psi.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetItemCustomState<P0>(&self, psi: P0, istatenumber: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetItemCustomState)(windows_core::Interface::as_raw(self), psi.param().abi(), istatenumber).ok()
    }
    pub unsafe fn EnsureItemVisible<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).EnsureItemVisible)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn SetTheme<P0>(&self, psztheme: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTheme)(windows_core::Interface::as_raw(self), psztheme.param().abi()).ok()
    }
    pub unsafe fn GetNextItem<P0>(&self, psi: P0, nstcgi: NSTCGNI) -> windows_core::Result<IShellItem>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetNextItem)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcgi, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn HitTest(&self, ppt: *const super::super::Foundation::POINT) -> windows_core::Result<IShellItem> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).HitTest)(windows_core::Interface::as_raw(self), ppt, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetItemRect<P0>(&self, psi: P0) -> windows_core::Result<super::super::Foundation::RECT>
    where
        P0: windows_core::Param<IShellItem>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetItemRect)(windows_core::Interface::as_raw(self), psi.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn CollapseAll(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).CollapseAll)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct INameSpaceTreeControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::RECT, u32) -> windows_core::HRESULT,
    pub TreeAdvise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub TreeUnadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AppendRoot: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InsertRoot: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut core::ffi::c_void, u32, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveRoot: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAllRoots: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRootItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetItemState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetItemState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSelectedItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetItemCustomState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetItemCustomState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub EnsureItemVisible: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetTheme: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetNextItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, NSTCGNI, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub HitTest: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::POINT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetItemRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub CollapseAll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeControl2, INameSpaceTreeControl2_Vtbl, 0x7cc7aed8_290e_49bc_8945_c1401cc9306c);
impl core::ops::Deref for INameSpaceTreeControl2 {
    type Target = INameSpaceTreeControl;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControl2, windows_core::IUnknown, INameSpaceTreeControl);
impl INameSpaceTreeControl2 {
    pub unsafe fn SetControlStyle(&self, nstcsmask: u32, nstcsstyle: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetControlStyle)(windows_core::Interface::as_raw(self), nstcsmask, nstcsstyle).ok()
    }
    pub unsafe fn GetControlStyle(&self, nstcsmask: u32) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetControlStyle)(windows_core::Interface::as_raw(self), nstcsmask, &mut result__).map(|| result__)
    }
    pub unsafe fn SetControlStyle2(&self, nstcsmask: NSTCSTYLE2, nstcsstyle: NSTCSTYLE2) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetControlStyle2)(windows_core::Interface::as_raw(self), nstcsmask, nstcsstyle).ok()
    }
    pub unsafe fn GetControlStyle2(&self, nstcsmask: NSTCSTYLE2) -> windows_core::Result<NSTCSTYLE2> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetControlStyle2)(windows_core::Interface::as_raw(self), nstcsmask, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct INameSpaceTreeControl2_Vtbl {
    pub base__: INameSpaceTreeControl_Vtbl,
    pub SetControlStyle: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetControlStyle: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub SetControlStyle2: unsafe extern "system" fn(*mut core::ffi::c_void, NSTCSTYLE2, NSTCSTYLE2) -> windows_core::HRESULT,
    pub GetControlStyle2: unsafe extern "system" fn(*mut core::ffi::c_void, NSTCSTYLE2, *mut NSTCSTYLE2) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeControlCustomDraw, INameSpaceTreeControlCustomDraw_Vtbl, 0x2d3ba758_33ee_42d5_bb7b_5f3431d86c78);
impl core::ops::Deref for INameSpaceTreeControlCustomDraw {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControlCustomDraw, windows_core::IUnknown);
impl INameSpaceTreeControlCustomDraw {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn PrePaint<P0>(&self, hdc: P0, prc: *const super::super::Foundation::RECT) -> windows_core::Result<super::super::Foundation::LRESULT>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).PrePaint)(windows_core::Interface::as_raw(self), hdc.param().abi(), prc, &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn PostPaint<P0>(&self, hdc: P0, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
    {
        (windows_core::Interface::vtable(self).PostPaint)(windows_core::Interface::as_raw(self), hdc.param().abi(), prc).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls"))]
    pub unsafe fn ItemPrePaint<P0>(&self, hdc: P0, prc: *const super::super::Foundation::RECT, pnstccditem: *const NSTCCUSTOMDRAW, pclrtext: *mut super::super::Foundation::COLORREF, pclrtextbk: *mut super::super::Foundation::COLORREF, plres: *mut super::super::Foundation::LRESULT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
    {
        (windows_core::Interface::vtable(self).ItemPrePaint)(windows_core::Interface::as_raw(self), hdc.param().abi(), prc, pnstccditem, pclrtext, pclrtextbk, plres).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls"))]
    pub unsafe fn ItemPostPaint<P0>(&self, hdc: P0, prc: *const super::super::Foundation::RECT, pnstccditem: *const NSTCCUSTOMDRAW) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Gdi::HDC>,
    {
        (windows_core::Interface::vtable(self).ItemPostPaint)(windows_core::Interface::as_raw(self), hdc.param().abi(), prc, pnstccditem).ok()
    }
}
#[repr(C)]
pub struct INameSpaceTreeControlCustomDraw_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub PrePaint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT, *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    PrePaint: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub PostPaint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    PostPaint: usize,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls"))]
    pub ItemPrePaint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT, *const NSTCCUSTOMDRAW, *mut super::super::Foundation::COLORREF, *mut super::super::Foundation::COLORREF, *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls")))]
    ItemPrePaint: usize,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls"))]
    pub ItemPostPaint: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT, *const NSTCCUSTOMDRAW) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Controls")))]
    ItemPostPaint: usize,
}
windows_core::imp::define_interface!(INameSpaceTreeControlDropHandler, INameSpaceTreeControlDropHandler_Vtbl, 0xf9c665d6_c2f2_4c19_bf33_8322d7352f51);
impl core::ops::Deref for INameSpaceTreeControlDropHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControlDropHandler, windows_core::IUnknown);
impl INameSpaceTreeControlDropHandler {
    pub unsafe fn OnDragEnter<P0, P1, P2>(&self, psiover: P0, psiadata: P1, foutsidesource: P2, grfkeystate: u32, pdweffect: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemArray>,
        P2: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnDragEnter)(windows_core::Interface::as_raw(self), psiover.param().abi(), psiadata.param().abi(), foutsidesource.param().abi(), grfkeystate, pdweffect).ok()
    }
    pub unsafe fn OnDragOver<P0, P1>(&self, psiover: P0, psiadata: P1, grfkeystate: u32, pdweffect: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).OnDragOver)(windows_core::Interface::as_raw(self), psiover.param().abi(), psiadata.param().abi(), grfkeystate, pdweffect).ok()
    }
    pub unsafe fn OnDragPosition<P0, P1>(&self, psiover: P0, psiadata: P1, inewposition: i32, ioldposition: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).OnDragPosition)(windows_core::Interface::as_raw(self), psiover.param().abi(), psiadata.param().abi(), inewposition, ioldposition).ok()
    }
    pub unsafe fn OnDrop<P0, P1>(&self, psiover: P0, psiadata: P1, iposition: i32, grfkeystate: u32, pdweffect: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).OnDrop)(windows_core::Interface::as_raw(self), psiover.param().abi(), psiadata.param().abi(), iposition, grfkeystate, pdweffect).ok()
    }
    pub unsafe fn OnDropPosition<P0, P1>(&self, psiover: P0, psiadata: P1, inewposition: i32, ioldposition: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).OnDropPosition)(windows_core::Interface::as_raw(self), psiover.param().abi(), psiadata.param().abi(), inewposition, ioldposition).ok()
    }
    pub unsafe fn OnDragLeave<P0>(&self, psiover: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnDragLeave)(windows_core::Interface::as_raw(self), psiover.param().abi()).ok()
    }
}
#[repr(C)]
pub struct INameSpaceTreeControlDropHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnDragEnter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL, u32, *mut u32) -> windows_core::HRESULT,
    pub OnDragOver: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub OnDragPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub OnDrop: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, i32, u32, *mut u32) -> windows_core::HRESULT,
    pub OnDropPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub OnDragLeave: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeControlEvents, INameSpaceTreeControlEvents_Vtbl, 0x93d77985_b3d8_4484_8318_672cdda002ce);
impl core::ops::Deref for INameSpaceTreeControlEvents {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControlEvents, windows_core::IUnknown);
impl INameSpaceTreeControlEvents {
    pub unsafe fn OnItemClick<P0>(&self, psi: P0, nstcehittest: u32, nstceclicktype: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnItemClick)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcehittest, nstceclicktype).ok()
    }
    pub unsafe fn OnPropertyItemCommit<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnPropertyItemCommit)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnItemStateChanging<P0>(&self, psi: P0, nstcismask: u32, nstcisstate: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnItemStateChanging)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcismask, nstcisstate).ok()
    }
    pub unsafe fn OnItemStateChanged<P0>(&self, psi: P0, nstcismask: u32, nstcisstate: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnItemStateChanged)(windows_core::Interface::as_raw(self), psi.param().abi(), nstcismask, nstcisstate).ok()
    }
    pub unsafe fn OnSelectionChanged<P0>(&self, psiaselection: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).OnSelectionChanged)(windows_core::Interface::as_raw(self), psiaselection.param().abi()).ok()
    }
    pub unsafe fn OnKeyboardInput<P0, P1>(&self, umsg: u32, wparam: P0, lparam: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::WPARAM>,
        P1: windows_core::Param<super::super::Foundation::LPARAM>,
    {
        (windows_core::Interface::vtable(self).OnKeyboardInput)(windows_core::Interface::as_raw(self), umsg, wparam.param().abi(), lparam.param().abi()).ok()
    }
    pub unsafe fn OnBeforeExpand<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnBeforeExpand)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnAfterExpand<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnAfterExpand)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnBeginLabelEdit<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnBeginLabelEdit)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnEndLabelEdit<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnEndLabelEdit)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnGetToolTip<P0>(&self, psi: P0, psztip: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnGetToolTip)(windows_core::Interface::as_raw(self), psi.param().abi(), core::mem::transmute(psztip.as_ptr()), psztip.len().try_into().unwrap()).ok()
    }
    pub unsafe fn OnBeforeItemDelete<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnBeforeItemDelete)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnItemAdded<P0, P1>(&self, psi: P0, fisroot: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnItemAdded)(windows_core::Interface::as_raw(self), psi.param().abi(), fisroot.param().abi()).ok()
    }
    pub unsafe fn OnItemDeleted<P0, P1>(&self, psi: P0, fisroot: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).OnItemDeleted)(windows_core::Interface::as_raw(self), psi.param().abi(), fisroot.param().abi()).ok()
    }
    pub unsafe fn OnBeforeContextMenu<P0>(&self, psi: P0, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnBeforeContextMenu)(windows_core::Interface::as_raw(self), psi.param().abi(), riid, ppv).ok()
    }
    pub unsafe fn OnAfterContextMenu<P0, P1>(&self, psi: P0, pcmin: P1, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IContextMenu>,
    {
        (windows_core::Interface::vtable(self).OnAfterContextMenu)(windows_core::Interface::as_raw(self), psi.param().abi(), pcmin.param().abi(), riid, ppv).ok()
    }
    pub unsafe fn OnBeforeStateImageChange<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnBeforeStateImageChange)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn OnGetDefaultIconIndex<P0>(&self, psi: P0, pidefaulticon: *mut i32, piopenicon: *mut i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).OnGetDefaultIconIndex)(windows_core::Interface::as_raw(self), psi.param().abi(), pidefaulticon, piopenicon).ok()
    }
}
#[repr(C)]
pub struct INameSpaceTreeControlEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnItemClick: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnPropertyItemCommit: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnItemStateChanging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnItemStateChanged: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub OnSelectionChanged: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnKeyboardInput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
    pub OnBeforeExpand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnAfterExpand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnBeginLabelEdit: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnEndLabelEdit: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnGetToolTip: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    pub OnBeforeItemDelete: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnItemAdded: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OnItemDeleted: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub OnBeforeContextMenu: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnAfterContextMenu: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnBeforeStateImageChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnGetDefaultIconIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INameSpaceTreeControlFolderCapabilities, INameSpaceTreeControlFolderCapabilities_Vtbl, 0xe9701183_e6b3_4ff2_8568_813615fec7be);
impl core::ops::Deref for INameSpaceTreeControlFolderCapabilities {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INameSpaceTreeControlFolderCapabilities, windows_core::IUnknown);
impl INameSpaceTreeControlFolderCapabilities {
    pub unsafe fn GetFolderCapabilities(&self, nfcmask: NSTCFOLDERCAPABILITIES) -> windows_core::Result<NSTCFOLDERCAPABILITIES> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetFolderCapabilities)(windows_core::Interface::as_raw(self), nfcmask, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct INameSpaceTreeControlFolderCapabilities_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFolderCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, NSTCFOLDERCAPABILITIES, *mut NSTCFOLDERCAPABILITIES) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INamedPropertyBag, INamedPropertyBag_Vtbl, 0xfb700430_952c_11d1_946f_000000000000);
impl core::ops::Deref for INamedPropertyBag {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INamedPropertyBag, windows_core::IUnknown);
impl INamedPropertyBag {
    pub unsafe fn ReadPropertyNPB<P0, P1>(&self, pszbagname: P0, pszpropname: P1, pvar: *mut windows_core::PROPVARIANT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).ReadPropertyNPB)(windows_core::Interface::as_raw(self), pszbagname.param().abi(), pszpropname.param().abi(), core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn WritePropertyNPB<P0, P1>(&self, pszbagname: P0, pszpropname: P1, pvar: *const windows_core::PROPVARIANT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).WritePropertyNPB)(windows_core::Interface::as_raw(self), pszbagname.param().abi(), pszpropname.param().abi(), core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn RemovePropertyNPB<P0, P1>(&self, pszbagname: P0, pszpropname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).RemovePropertyNPB)(windows_core::Interface::as_raw(self), pszbagname.param().abi(), pszpropname.param().abi()).ok()
    }
}
#[repr(C)]
pub struct INamedPropertyBag_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReadPropertyNPB: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::mem::MaybeUninit<windows_core::PROPVARIANT>) -> windows_core::HRESULT,
    pub WritePropertyNPB: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *const core::mem::MaybeUninit<windows_core::PROPVARIANT>) -> windows_core::HRESULT,
    pub RemovePropertyNPB: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INamespaceWalk, INamespaceWalk_Vtbl, 0x57ced8a7_3f4a_432c_9350_30f24483f74f);
impl core::ops::Deref for INamespaceWalk {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INamespaceWalk, windows_core::IUnknown);
impl INamespaceWalk {
    pub unsafe fn Walk<P0, P1>(&self, punktowalk: P0, dwflags: u32, cdepth: i32, pnswcb: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P1: windows_core::Param<INamespaceWalkCB>,
    {
        (windows_core::Interface::vtable(self).Walk)(windows_core::Interface::as_raw(self), punktowalk.param().abi(), dwflags, cdepth, pnswcb.param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetIDArrayResult(&self, pcitems: *mut u32, prgpidl: *mut *mut *mut Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetIDArrayResult)(windows_core::Interface::as_raw(self), pcitems, prgpidl).ok()
    }
}
#[repr(C)]
pub struct INamespaceWalk_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Walk: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, i32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetIDArrayResult: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetIDArrayResult: usize,
}
windows_core::imp::define_interface!(INamespaceWalkCB, INamespaceWalkCB_Vtbl, 0xd92995f8_cf5e_4a76_bf59_ead39ea2b97e);
impl core::ops::Deref for INamespaceWalkCB {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INamespaceWalkCB, windows_core::IUnknown);
impl INamespaceWalkCB {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn FoundItem<P0>(&self, psf: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).FoundItem)(windows_core::Interface::as_raw(self), psf.param().abi(), pidl).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn EnterFolder<P0>(&self, psf: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).EnterFolder)(windows_core::Interface::as_raw(self), psf.param().abi(), pidl).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn LeaveFolder<P0>(&self, psf: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).LeaveFolder)(windows_core::Interface::as_raw(self), psf.param().abi(), pidl).ok()
    }
    pub unsafe fn InitializeProgressDialog(&self, ppsztitle: *mut windows_core::PWSTR, ppszcancel: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeProgressDialog)(windows_core::Interface::as_raw(self), ppsztitle, ppszcancel).ok()
    }
}
#[repr(C)]
pub struct INamespaceWalkCB_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub FoundItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    FoundItem: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub EnterFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    EnterFolder: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub LeaveFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    LeaveFolder: usize,
    pub InitializeProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INamespaceWalkCB2, INamespaceWalkCB2_Vtbl, 0x7ac7492b_c38e_438a_87db_68737844ff70);
impl core::ops::Deref for INamespaceWalkCB2 {
    type Target = INamespaceWalkCB;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INamespaceWalkCB2, windows_core::IUnknown, INamespaceWalkCB);
impl INamespaceWalkCB2 {
    pub unsafe fn WalkComplete(&self, hr: windows_core::HRESULT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).WalkComplete)(windows_core::Interface::as_raw(self), hr).ok()
    }
}
#[repr(C)]
pub struct INamespaceWalkCB2_Vtbl {
    pub base__: INamespaceWalkCB_Vtbl,
    pub WalkComplete: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INetworkFolderInternal, INetworkFolderInternal_Vtbl, 0xceb38218_c971_47bb_a703_f0bc99ccdb81);
impl core::ops::Deref for INetworkFolderInternal {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INetworkFolderInternal, windows_core::IUnknown);
impl INetworkFolderInternal {
    pub unsafe fn GetResourceDisplayType(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetResourceDisplayType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetIDList(&self) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIDList)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetProvider(&self, itemids: &[*const Common::ITEMIDLIST], provider: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetProvider)(windows_core::Interface::as_raw(self), itemids.len().try_into().unwrap(), core::mem::transmute(itemids.as_ptr()), provider.len().try_into().unwrap(), core::mem::transmute(provider.as_ptr())).ok()
    }
}
#[repr(C)]
pub struct INetworkFolderInternal_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetResourceDisplayType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetIDList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetIDList: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetProvider: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const *const Common::ITEMIDLIST, u32, windows_core::PWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetProvider: usize,
}
windows_core::imp::define_interface!(INewMenuClient, INewMenuClient_Vtbl, 0xdcb07fdc_3bb5_451c_90be_966644fed7b0);
impl core::ops::Deref for INewMenuClient {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INewMenuClient, windows_core::IUnknown);
impl INewMenuClient {
    pub unsafe fn IncludeItems(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).IncludeItems)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SelectAndEditItem(&self, pidlitem: *const Common::ITEMIDLIST, flags: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SelectAndEditItem)(windows_core::Interface::as_raw(self), pidlitem, flags).ok()
    }
}
#[repr(C)]
pub struct INewMenuClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub IncludeItems: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SelectAndEditItem: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SelectAndEditItem: usize,
}
windows_core::imp::define_interface!(INewShortcutHookA, INewShortcutHookA_Vtbl, 0x000214e1_0000_0000_c000_000000000046);
impl core::ops::Deref for INewShortcutHookA {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INewShortcutHookA, windows_core::IUnknown);
impl INewShortcutHookA {
    pub unsafe fn SetReferent<P0, P1>(&self, pcszreferent: P0, hwnd: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P1: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SetReferent)(windows_core::Interface::as_raw(self), pcszreferent.param().abi(), hwnd.param().abi()).ok()
    }
    pub unsafe fn GetReferent(&self, pszreferent: &mut [u8]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetReferent)(windows_core::Interface::as_raw(self), core::mem::transmute(pszreferent.as_ptr()), pszreferent.len().try_into().unwrap()).ok()
    }
    pub unsafe fn SetFolder<P0>(&self, pcszfolder: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        (windows_core::Interface::vtable(self).SetFolder)(windows_core::Interface::as_raw(self), pcszfolder.param().abi()).ok()
    }
    pub unsafe fn GetFolder(&self, pszfolder: &mut [u8]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), core::mem::transmute(pszfolder.as_ptr()), pszfolder.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetName(&self, pszname: &mut [u8]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetExtension(&self, pszextension: &mut [u8]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExtension)(windows_core::Interface::as_raw(self), core::mem::transmute(pszextension.as_ptr()), pszextension.len().try_into().unwrap()).ok()
    }
}
#[repr(C)]
pub struct INewShortcutHookA_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetReferent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub GetReferent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, i32) -> windows_core::HRESULT,
    pub SetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, i32) -> windows_core::HRESULT,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, i32) -> windows_core::HRESULT,
    pub GetExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, i32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INewShortcutHookW, INewShortcutHookW_Vtbl, 0x000214f7_0000_0000_c000_000000000046);
impl core::ops::Deref for INewShortcutHookW {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INewShortcutHookW, windows_core::IUnknown);
impl INewShortcutHookW {
    pub unsafe fn SetReferent<P0, P1>(&self, pcszreferent: P0, hwnd: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SetReferent)(windows_core::Interface::as_raw(self), pcszreferent.param().abi(), hwnd.param().abi()).ok()
    }
    pub unsafe fn GetReferent(&self, pszreferent: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetReferent)(windows_core::Interface::as_raw(self), core::mem::transmute(pszreferent.as_ptr()), pszreferent.len().try_into().unwrap()).ok()
    }
    pub unsafe fn SetFolder<P0>(&self, pcszfolder: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetFolder)(windows_core::Interface::as_raw(self), pcszfolder.param().abi()).ok()
    }
    pub unsafe fn GetFolder(&self, pszfolder: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), core::mem::transmute(pszfolder.as_ptr()), pszfolder.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetName(&self, pszname: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetExtension(&self, pszextension: &mut [u16]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetExtension)(windows_core::Interface::as_raw(self), core::mem::transmute(pszextension.as_ptr()), pszextension.len().try_into().unwrap()).ok()
    }
}
#[repr(C)]
pub struct INewShortcutHookW_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetReferent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub GetReferent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    pub SetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    pub GetExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(INewWDEvents, INewWDEvents_Vtbl, 0x0751c551_7568_41c9_8e5b_e22e38919236);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for INewWDEvents {
    type Target = IWebWizardHost;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(INewWDEvents, windows_core::IUnknown, super::super::System::Com::IDispatch, IWebWizardHost);
#[cfg(feature = "Win32_System_Com")]
impl INewWDEvents {
    pub unsafe fn PassportAuthenticate<P0>(&self, bstrsigninurl: P0) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).PassportAuthenticate)(windows_core::Interface::as_raw(self), bstrsigninurl.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct INewWDEvents_Vtbl {
    pub base__: IWebWizardHost_Vtbl,
    pub PassportAuthenticate: unsafe extern "system" fn(*mut core::ffi::c_void, core::mem::MaybeUninit<windows_core::BSTR>, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INewWindowManager, INewWindowManager_Vtbl, 0xd2bc4c84_3f72_4a52_a604_7bcbf3982cbb);
impl core::ops::Deref for INewWindowManager {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INewWindowManager, windows_core::IUnknown);
impl INewWindowManager {
    pub unsafe fn EvaluateNewWindow<P0, P1, P2, P3, P4>(&self, pszurl: P0, pszname: P1, pszurlcontext: P2, pszfeatures: P3, freplace: P4, dwflags: u32, dwuseractiontime: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).EvaluateNewWindow)(windows_core::Interface::as_raw(self), pszurl.param().abi(), pszname.param().abi(), pszurlcontext.param().abi(), pszfeatures.param().abi(), freplace.param().abi(), dwflags, dwuseractiontime).ok()
    }
}
#[repr(C)]
pub struct INewWindowManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EvaluateNewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, super::super::Foundation::BOOL, u32, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(INotifyReplica, INotifyReplica_Vtbl, 0x99180163_da16_101a_935c_444553540000);
impl core::ops::Deref for INotifyReplica {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(INotifyReplica, windows_core::IUnknown);
impl INotifyReplica {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn YouAreAReplica(&self, rgpmkotherreplicas: &mut [Option<super::super::System::Com::IMoniker>]) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).YouAreAReplica)(windows_core::Interface::as_raw(self), rgpmkotherreplicas.len().try_into().unwrap(), core::mem::transmute(rgpmkotherreplicas.as_ptr())).ok()
    }
}
#[repr(C)]
pub struct INotifyReplica_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub YouAreAReplica: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    YouAreAReplica: usize,
}
windows_core::imp::define_interface!(IObjMgr, IObjMgr_Vtbl, 0x00bb2761_6a77_11d0_a535_00c04fd7d062);
impl core::ops::Deref for IObjMgr {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjMgr, windows_core::IUnknown);
impl IObjMgr {
    pub unsafe fn Append<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).Append)(windows_core::Interface::as_raw(self), punk.param().abi()).ok()
    }
    pub unsafe fn Remove<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self), punk.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IObjMgr_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Append: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectProvider, IObjectProvider_Vtbl, 0xa6087428_3be3_4d73_b308_7c04a540bf1a);
impl core::ops::Deref for IObjectProvider {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectProvider, windows_core::IUnknown);
impl IObjectProvider {
    pub unsafe fn QueryObject<T>(&self, guidobject: *const windows_core::GUID) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).QueryObject)(windows_core::Interface::as_raw(self), guidobject, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IObjectProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithAppUserModelID, IObjectWithAppUserModelID_Vtbl, 0x36db0196_9665_46d1_9ba7_d3709eecf9ed);
impl core::ops::Deref for IObjectWithAppUserModelID {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithAppUserModelID, windows_core::IUnknown);
impl IObjectWithAppUserModelID {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok()
    }
    pub unsafe fn GetAppID(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetAppID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IObjectWithAppUserModelID_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithBackReferences, IObjectWithBackReferences_Vtbl, 0x321a6a6a_d61f_4bf3_97ae_14be2986bb36);
impl core::ops::Deref for IObjectWithBackReferences {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithBackReferences, windows_core::IUnknown);
impl IObjectWithBackReferences {
    pub unsafe fn RemoveBackReferences(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveBackReferences)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IObjectWithBackReferences_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RemoveBackReferences: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithCancelEvent, IObjectWithCancelEvent_Vtbl, 0xf279b885_0ae9_4b85_ac06_ddecf9408941);
impl core::ops::Deref for IObjectWithCancelEvent {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithCancelEvent, windows_core::IUnknown);
impl IObjectWithCancelEvent {
    pub unsafe fn GetCancelEvent(&self) -> windows_core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCancelEvent)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IObjectWithCancelEvent_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCancelEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithFolderEnumMode, IObjectWithFolderEnumMode_Vtbl, 0x6a9d9026_0e6e_464c_b000_42ecc07de673);
impl core::ops::Deref for IObjectWithFolderEnumMode {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithFolderEnumMode, windows_core::IUnknown);
impl IObjectWithFolderEnumMode {
    pub unsafe fn SetMode(&self, femode: FOLDER_ENUM_MODE) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), femode).ok()
    }
    pub unsafe fn GetMode(&self) -> windows_core::Result<FOLDER_ENUM_MODE> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IObjectWithFolderEnumMode_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, FOLDER_ENUM_MODE) -> windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDER_ENUM_MODE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithProgID, IObjectWithProgID_Vtbl, 0x71e806fb_8dee_46fc_bf8c_7748a8a1ae13);
impl core::ops::Deref for IObjectWithProgID {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithProgID, windows_core::IUnknown);
impl IObjectWithProgID {
    pub unsafe fn SetProgID<P0>(&self, pszprogid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetProgID)(windows_core::Interface::as_raw(self), pszprogid.param().abi()).ok()
    }
    pub unsafe fn GetProgID(&self) -> windows_core::Result<windows_core::PWSTR> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProgID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IObjectWithProgID_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetProgID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetProgID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IObjectWithSelection, IObjectWithSelection_Vtbl, 0x1c9cd5bb_98e9_4491_a60f_31aacc72b83c);
impl core::ops::Deref for IObjectWithSelection {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IObjectWithSelection, windows_core::IUnknown);
impl IObjectWithSelection {
    pub unsafe fn SetSelection<P0>(&self, psia: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItemArray>,
    {
        (windows_core::Interface::vtable(self).SetSelection)(windows_core::Interface::as_raw(self), psia.param().abi()).ok()
    }
    pub unsafe fn GetSelection<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetSelection)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IObjectWithSelection_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetSelection: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSelection: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IOpenControlPanel, IOpenControlPanel_Vtbl, 0xd11ad862_66de_4df4_bf6c_1f5621996af1);
impl core::ops::Deref for IOpenControlPanel {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IOpenControlPanel, windows_core::IUnknown);
impl IOpenControlPanel {
    pub unsafe fn Open<P0, P1, P2>(&self, pszname: P0, pszpage: P1, punksite: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).Open)(windows_core::Interface::as_raw(self), pszname.param().abi(), pszpage.param().abi(), punksite.param().abi()).ok()
    }
    pub unsafe fn GetPath<P0>(&self, pszname: P0, pszpath: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetPath)(windows_core::Interface::as_raw(self), pszname.param().abi(), core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetCurrentView(&self) -> windows_core::Result<CPVIEW> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurrentView)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IOpenControlPanel_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Open: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub GetCurrentView: unsafe extern "system" fn(*mut core::ffi::c_void, *mut CPVIEW) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IOpenSearchSource, IOpenSearchSource_Vtbl, 0xf0ee7333_e6fc_479b_9f25_a860c234a38e);
impl core::ops::Deref for IOpenSearchSource {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IOpenSearchSource, windows_core::IUnknown);
impl IOpenSearchSource {
    pub unsafe fn GetResults<P0, P1, T>(&self, hwnd: P0, pszquery: P1, dwstartindex: u32, dwcount: u32) -> windows_core::Result<T>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetResults)(windows_core::Interface::as_raw(self), hwnd.param().abi(), pszquery.param().abi(), dwstartindex, dwcount, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IOpenSearchSource_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetResults: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::PCWSTR, u32, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IOperationsProgressDialog, IOperationsProgressDialog_Vtbl, 0x0c9fb851_e5c9_43eb_a370_f0677b13874c);
impl core::ops::Deref for IOperationsProgressDialog {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IOperationsProgressDialog, windows_core::IUnknown);
impl IOperationsProgressDialog {
    pub unsafe fn StartProgressDialog<P0>(&self, hwndowner: P0, flags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).StartProgressDialog)(windows_core::Interface::as_raw(self), hwndowner.param().abi(), flags).ok()
    }
    pub unsafe fn StopProgressDialog(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).StopProgressDialog)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetOperation(&self, action: SPACTION) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetOperation)(windows_core::Interface::as_raw(self), action).ok()
    }
    pub unsafe fn SetMode(&self, mode: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn UpdateProgress(&self, ullpointscurrent: u64, ullpointstotal: u64, ullsizecurrent: u64, ullsizetotal: u64, ullitemscurrent: u64, ullitemstotal: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UpdateProgress)(windows_core::Interface::as_raw(self), ullpointscurrent, ullpointstotal, ullsizecurrent, ullsizetotal, ullitemscurrent, ullitemstotal).ok()
    }
    pub unsafe fn UpdateLocations<P0, P1, P2>(&self, psisource: P0, psitarget: P1, psiitem: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
        P1: windows_core::Param<IShellItem>,
        P2: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).UpdateLocations)(windows_core::Interface::as_raw(self), psisource.param().abi(), psitarget.param().abi(), psiitem.param().abi()).ok()
    }
    pub unsafe fn ResetTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResetTimer)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PauseTimer)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ResumeTimer(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ResumeTimer)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetMilliseconds(&self, pullelapsed: *mut u64, pullremaining: *mut u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetMilliseconds)(windows_core::Interface::as_raw(self), pullelapsed, pullremaining).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetOperationStatus(&self) -> windows_core::Result<PropertiesSystem::PDOPSTATUS> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetOperationStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IOperationsProgressDialog_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub StartProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32) -> windows_core::HRESULT,
    pub StopProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOperation: unsafe extern "system" fn(*mut core::ffi::c_void, SPACTION) -> windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64, u64, u64, u64, u64) -> windows_core::HRESULT,
    pub UpdateLocations: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ResetTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PauseTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ResumeTimer: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetMilliseconds: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64, *mut u64) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetOperationStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PropertiesSystem::PDOPSTATUS) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetOperationStatus: usize,
}
windows_core::imp::define_interface!(IPackageDebugSettings, IPackageDebugSettings_Vtbl, 0xf27c3930_8029_4ad1_94e3_3dba417810c1);
impl core::ops::Deref for IPackageDebugSettings {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPackageDebugSettings, windows_core::IUnknown);
impl IPackageDebugSettings {
    pub unsafe fn EnableDebugging<P0, P1, P2>(&self, packagefullname: P0, debuggercommandline: P1, environment: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EnableDebugging)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), debuggercommandline.param().abi(), environment.param().abi()).ok()
    }
    pub unsafe fn DisableDebugging<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).DisableDebugging)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn Suspend<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Suspend)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn Resume<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Resume)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn TerminateAllProcesses<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).TerminateAllProcesses)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn SetTargetSessionId(&self, sessionid: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetTargetSessionId)(windows_core::Interface::as_raw(self), sessionid).ok()
    }
    pub unsafe fn EnumerateBackgroundTasks<P0>(&self, packagefullname: P0, taskcount: *mut u32, taskids: *mut *mut windows_core::GUID, tasknames: *mut *mut windows_core::PCWSTR) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EnumerateBackgroundTasks)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), taskcount, taskids, tasknames).ok()
    }
    pub unsafe fn ActivateBackgroundTask(&self, taskid: *const windows_core::GUID) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).ActivateBackgroundTask)(windows_core::Interface::as_raw(self), taskid).ok()
    }
    pub unsafe fn StartServicing<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartServicing)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn StopServicing<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StopServicing)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn StartSessionRedirection<P0>(&self, packagefullname: P0, sessionid: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StartSessionRedirection)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), sessionid).ok()
    }
    pub unsafe fn StopSessionRedirection<P0>(&self, packagefullname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).StopSessionRedirection)(windows_core::Interface::as_raw(self), packagefullname.param().abi()).ok()
    }
    pub unsafe fn GetPackageExecutionState<P0>(&self, packagefullname: P0) -> windows_core::Result<PACKAGE_EXECUTION_STATE>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPackageExecutionState)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterForPackageStateChanges<P0, P1>(&self, packagefullname: P0, ppackageexecutionstatechangenotification: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IPackageExecutionStateChangeNotification>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).RegisterForPackageStateChanges)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), ppackageexecutionstatechangenotification.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn UnregisterForPackageStateChanges(&self, dwcookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnregisterForPackageStateChanges)(windows_core::Interface::as_raw(self), dwcookie).ok()
    }
}
#[repr(C)]
pub struct IPackageDebugSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EnableDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub DisableDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Suspend: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub TerminateAllProcesses: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetTargetSessionId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub EnumerateBackgroundTasks: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u32, *mut *mut windows_core::GUID, *mut *mut windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ActivateBackgroundTask: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub StartServicing: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StopServicing: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartSessionRedirection: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub StopSessionRedirection: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetPackageExecutionState: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut PACKAGE_EXECUTION_STATE) -> windows_core::HRESULT,
    pub RegisterForPackageStateChanges: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub UnregisterForPackageStateChanges: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPackageDebugSettings2, IPackageDebugSettings2_Vtbl, 0x6e3194bb_ab82_4d22_93f5_fabda40e7b16);
impl core::ops::Deref for IPackageDebugSettings2 {
    type Target = IPackageDebugSettings;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPackageDebugSettings2, windows_core::IUnknown, IPackageDebugSettings);
impl IPackageDebugSettings2 {
    pub unsafe fn EnumerateApps<P0>(&self, packagefullname: P0, appcount: *mut u32, appusermodelids: *mut *mut windows_core::PWSTR, appdisplaynames: *mut *mut windows_core::PWSTR) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).EnumerateApps)(windows_core::Interface::as_raw(self), packagefullname.param().abi(), appcount, appusermodelids, appdisplaynames).ok()
    }
}
#[repr(C)]
pub struct IPackageDebugSettings2_Vtbl {
    pub base__: IPackageDebugSettings_Vtbl,
    pub EnumerateApps: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u32, *mut *mut windows_core::PWSTR, *mut *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPackageExecutionStateChangeNotification, IPackageExecutionStateChangeNotification_Vtbl, 0x1bb12a62_2ad8_432b_8ccf_0c2c52afcd5b);
impl core::ops::Deref for IPackageExecutionStateChangeNotification {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPackageExecutionStateChangeNotification, windows_core::IUnknown);
impl IPackageExecutionStateChangeNotification {
    pub unsafe fn OnStateChanged<P0>(&self, pszpackagefullname: P0, pesnewstate: PACKAGE_EXECUTION_STATE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).OnStateChanged)(windows_core::Interface::as_raw(self), pszpackagefullname.param().abi(), pesnewstate).ok()
    }
}
#[repr(C)]
pub struct IPackageExecutionStateChangeNotification_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnStateChanged: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, PACKAGE_EXECUTION_STATE) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IParentAndItem, IParentAndItem_Vtbl, 0xb3a4b685_b685_4805_99d9_5dead2873236);
impl core::ops::Deref for IParentAndItem {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IParentAndItem, windows_core::IUnknown);
impl IParentAndItem {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetParentAndItem<P0>(&self, pidlparent: *const Common::ITEMIDLIST, psf: P0, pidlchild: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
    {
        (windows_core::Interface::vtable(self).SetParentAndItem)(windows_core::Interface::as_raw(self), pidlparent, psf.param().abi(), pidlchild).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetParentAndItem(&self, ppidlparent: Option<*mut *mut Common::ITEMIDLIST>, ppsf: Option<*mut Option<IShellFolder>>, ppidlchild: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetParentAndItem)(windows_core::Interface::as_raw(self), core::mem::transmute(ppidlparent.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppsf.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppidlchild.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IParentAndItem_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetParentAndItem: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetParentAndItem: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetParentAndItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST, *mut *mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetParentAndItem: usize,
}
windows_core::imp::define_interface!(IParseAndCreateItem, IParseAndCreateItem_Vtbl, 0x67efed0e_e827_4408_b493_78f3982b685c);
impl core::ops::Deref for IParseAndCreateItem {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IParseAndCreateItem, windows_core::IUnknown);
impl IParseAndCreateItem {
    pub unsafe fn SetItem<P0>(&self, psi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellItem>,
    {
        (windows_core::Interface::vtable(self).SetItem)(windows_core::Interface::as_raw(self), psi.param().abi()).ok()
    }
    pub unsafe fn GetItem<T>(&self) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        (windows_core::Interface::vtable(self).GetItem)(windows_core::Interface::as_raw(self), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IParseAndCreateItem_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetItem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetItem: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IPersistFolder, IPersistFolder_Vtbl, 0x000214ea_0000_0000_c000_000000000046);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IPersistFolder {
    type Target = super::super::System::Com::IPersist;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IPersistFolder, windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl IPersistFolder {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn Initialize(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pidl).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPersistFolder_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    Initialize: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IPersistFolder2, IPersistFolder2_Vtbl, 0x1ac3d9f0_175c_11d1_95be_00609797ea4f);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IPersistFolder2 {
    type Target = IPersistFolder;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IPersistFolder2, windows_core::IUnknown, super::super::System::Com::IPersist, IPersistFolder);
#[cfg(feature = "Win32_System_Com")]
impl IPersistFolder2 {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCurFolder(&self) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCurFolder)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPersistFolder2_Vtbl {
    pub base__: IPersistFolder_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCurFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCurFolder: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IPersistFolder3, IPersistFolder3_Vtbl, 0xcef04fdf_fe72_11d2_87a5_00c04f6837cf);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IPersistFolder3 {
    type Target = IPersistFolder2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IPersistFolder3, windows_core::IUnknown, super::super::System::Com::IPersist, IPersistFolder, IPersistFolder2);
#[cfg(feature = "Win32_System_Com")]
impl IPersistFolder3 {
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn InitializeEx<P0>(&self, pbc: P0, pidlroot: *const Common::ITEMIDLIST, ppfti: *const PERSIST_FOLDER_TARGET_INFO) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    {
        (windows_core::Interface::vtable(self).InitializeEx)(windows_core::Interface::as_raw(self), pbc.param().abi(), pidlroot, ppfti).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetFolderTargetInfo(&self, ppfti: *mut PERSIST_FOLDER_TARGET_INFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetFolderTargetInfo)(windows_core::Interface::as_raw(self), ppfti).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPersistFolder3_Vtbl {
    pub base__: IPersistFolder2_Vtbl,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub InitializeEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *const PERSIST_FOLDER_TARGET_INFO) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    InitializeEx: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetFolderTargetInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PERSIST_FOLDER_TARGET_INFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetFolderTargetInfo: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IPersistIDList, IPersistIDList_Vtbl, 0x1079acfc_29bd_11d3_8e0d_00c04f6837d5);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IPersistIDList {
    type Target = super::super::System::Com::IPersist;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IPersistIDList, windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl IPersistIDList {
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetIDList(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetIDList)(windows_core::Interface::as_raw(self), pidl).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetIDList(&self) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetIDList)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPersistIDList_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetIDList: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetIDList: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetIDList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetIDList: usize,
}
windows_core::imp::define_interface!(IPreviewHandler, IPreviewHandler_Vtbl, 0x8895b1c6_b41f_4c1c_a562_0d564250836f);
impl core::ops::Deref for IPreviewHandler {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPreviewHandler, windows_core::IUnknown);
impl IPreviewHandler {
    pub unsafe fn SetWindow<P0>(&self, hwnd: P0, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).SetWindow)(windows_core::Interface::as_raw(self), hwnd.param().abi(), prc).ok()
    }
    pub unsafe fn SetRect(&self, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetRect)(windows_core::Interface::as_raw(self), prc).ok()
    }
    pub unsafe fn DoPreview(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DoPreview)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Unload(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unload)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetFocus(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFocus)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn QueryFocus(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).QueryFocus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn TranslateAccelerator(&self, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
}
#[repr(C)]
pub struct IPreviewHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub SetRect: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub DoPreview: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Unload: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub QueryFocus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub TranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    TranslateAccelerator: usize,
}
windows_core::imp::define_interface!(IPreviewHandlerFrame, IPreviewHandlerFrame_Vtbl, 0xfec87aaf_35f9_447a_adb7_20234491401a);
impl core::ops::Deref for IPreviewHandlerFrame {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPreviewHandlerFrame, windows_core::IUnknown);
impl IPreviewHandlerFrame {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn GetWindowContext(&self) -> windows_core::Result<PREVIEWHANDLERFRAMEINFO> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetWindowContext)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn TranslateAccelerator(&self, pmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).TranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg).ok()
    }
}
#[repr(C)]
pub struct IPreviewHandlerFrame_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub GetWindowContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PREVIEWHANDLERFRAMEINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    GetWindowContext: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub TranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    TranslateAccelerator: usize,
}
windows_core::imp::define_interface!(IPreviewHandlerVisuals, IPreviewHandlerVisuals_Vtbl, 0x196bf9a5_b346_4ef0_aa1e_5dcdb76768b1);
impl core::ops::Deref for IPreviewHandlerVisuals {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPreviewHandlerVisuals, windows_core::IUnknown);
impl IPreviewHandlerVisuals {
    pub unsafe fn SetBackgroundColor<P0>(&self, color: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::COLORREF>,
    {
        (windows_core::Interface::vtable(self).SetBackgroundColor)(windows_core::Interface::as_raw(self), color.param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetFont(&self, plf: *const super::super::Graphics::Gdi::LOGFONTW) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetFont)(windows_core::Interface::as_raw(self), plf).ok()
    }
    pub unsafe fn SetTextColor<P0>(&self, color: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::COLORREF>,
    {
        (windows_core::Interface::vtable(self).SetTextColor)(windows_core::Interface::as_raw(self), color.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IPreviewHandlerVisuals_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::COLORREF) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetFont: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Graphics::Gdi::LOGFONTW) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetFont: usize,
    pub SetTextColor: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::COLORREF) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPreviewItem, IPreviewItem_Vtbl, 0x36149969_0a8f_49c8_8b00_4aecb20222fb);
impl core::ops::Deref for IPreviewItem {
    type Target = IRelatedItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPreviewItem, windows_core::IUnknown, IRelatedItem);
impl IPreviewItem {}
#[repr(C)]
pub struct IPreviewItem_Vtbl {
    pub base__: IRelatedItem_Vtbl,
}
windows_core::imp::define_interface!(IPreviousVersionsInfo, IPreviousVersionsInfo_Vtbl, 0x76e54780_ad74_48e3_a695_3ba9a0aff10d);
impl core::ops::Deref for IPreviousVersionsInfo {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPreviousVersionsInfo, windows_core::IUnknown);
impl IPreviousVersionsInfo {
    pub unsafe fn AreSnapshotsAvailable<P0, P1>(&self, pszpath: P0, foktobeslow: P1) -> windows_core::Result<super::super::Foundation::BOOL>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).AreSnapshotsAvailable)(windows_core::Interface::as_raw(self), pszpath.param().abi(), foktobeslow.param().abi(), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IPreviousVersionsInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AreSnapshotsAvailable: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, super::super::Foundation::BOOL, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IProfferService, IProfferService_Vtbl, 0xcb728b20_f786_11ce_92ad_00aa00a74cd0);
impl core::ops::Deref for IProfferService {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IProfferService, windows_core::IUnknown);
impl IProfferService {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ProfferService<P0>(&self, serviceid: *const windows_core::GUID, serviceprovider: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<super::super::System::Com::IServiceProvider>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).ProfferService)(windows_core::Interface::as_raw(self), serviceid, serviceprovider.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn RevokeService(&self, cookie: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RevokeService)(windows_core::Interface::as_raw(self), cookie).ok()
    }
}
#[repr(C)]
pub struct IProfferService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ProfferService: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ProfferService: usize,
    pub RevokeService: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IProgressDialog, IProgressDialog_Vtbl, 0xebbc7c04_315e_11d2_b62f_006097df5bd4);
impl core::ops::Deref for IProgressDialog {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IProgressDialog, windows_core::IUnknown);
impl IProgressDialog {
    pub unsafe fn StartProgressDialog<P0, P1>(&self, hwndparent: P0, punkenablemodless: P1, dwflags: u32, pvresevered: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        (windows_core::Interface::vtable(self).StartProgressDialog)(windows_core::Interface::as_raw(self), hwndparent.param().abi(), punkenablemodless.param().abi(), dwflags, core::mem::transmute(pvresevered.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn StopProgressDialog(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).StopProgressDialog)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetTitle<P0>(&self, pwztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), pwztitle.param().abi()).ok()
    }
    pub unsafe fn SetAnimation<P0>(&self, hinstanimation: P0, idanimation: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HINSTANCE>,
    {
        (windows_core::Interface::vtable(self).SetAnimation)(windows_core::Interface::as_raw(self), hinstanimation.param().abi(), idanimation).ok()
    }
    pub unsafe fn HasUserCancelled(&self) -> super::super::Foundation::BOOL {
        (windows_core::Interface::vtable(self).HasUserCancelled)(windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetProgress(&self, dwcompleted: u32, dwtotal: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProgress)(windows_core::Interface::as_raw(self), dwcompleted, dwtotal).ok()
    }
    pub unsafe fn SetProgress64(&self, ullcompleted: u64, ulltotal: u64) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProgress64)(windows_core::Interface::as_raw(self), ullcompleted, ulltotal).ok()
    }
    pub unsafe fn SetLine<P0, P1>(&self, dwlinenum: u32, pwzstring: P0, fcompactpath: P1, pvresevered: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::Foundation::BOOL>,
    {
        (windows_core::Interface::vtable(self).SetLine)(windows_core::Interface::as_raw(self), dwlinenum, pwzstring.param().abi(), fcompactpath.param().abi(), core::mem::transmute(pvresevered.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn SetCancelMsg<P0>(&self, pwzcancelmsg: P0, pvresevered: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).SetCancelMsg)(windows_core::Interface::as_raw(self), pwzcancelmsg.param().abi(), core::mem::transmute(pvresevered.unwrap_or(std::ptr::null()))).ok()
    }
    pub unsafe fn Timer(&self, dwtimeraction: u32, pvresevered: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Timer)(windows_core::Interface::as_raw(self), dwtimeraction, core::mem::transmute(pvresevered.unwrap_or(std::ptr::null()))).ok()
    }
}
#[repr(C)]
pub struct IProgressDialog_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub StartProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, u32, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub StopProgressDialog: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetAnimation: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HINSTANCE, u32) -> windows_core::HRESULT,
    pub HasUserCancelled: unsafe extern "system" fn(*mut core::ffi::c_void) -> super::super::Foundation::BOOL,
    pub SetProgress: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub SetProgress64: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64) -> windows_core::HRESULT,
    pub SetLine: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, super::super::Foundation::BOOL, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub SetCancelMsg: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub Timer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPropertyKeyStore, IPropertyKeyStore_Vtbl, 0x75bd59aa_f23b_4963_aba4_0b355752a91b);
impl core::ops::Deref for IPropertyKeyStore {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPropertyKeyStore, windows_core::IUnknown);
impl IPropertyKeyStore {
    pub unsafe fn GetKeyCount(&self) -> windows_core::Result<i32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetKeyCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetKeyAt(&self, index: i32, pkey: *mut PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetKeyAt)(windows_core::Interface::as_raw(self), index, pkey).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn AppendKey(&self, key: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).AppendKey)(windows_core::Interface::as_raw(self), key).ok()
    }
    pub unsafe fn DeleteKey(&self, index: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).DeleteKey)(windows_core::Interface::as_raw(self), index).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn IsKeyInStore(&self, key: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).IsKeyInStore)(windows_core::Interface::as_raw(self), key).ok()
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn RemoveKey(&self, key: *const PropertiesSystem::PROPERTYKEY) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).RemoveKey)(windows_core::Interface::as_raw(self), key).ok()
    }
}
#[repr(C)]
pub struct IPropertyKeyStore_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetKeyCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetKeyAt: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetKeyAt: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub AppendKey: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    AppendKey: usize,
    pub DeleteKey: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub IsKeyInStore: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    IsKeyInStore: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub RemoveKey: unsafe extern "system" fn(*mut core::ffi::c_void, *const PropertiesSystem::PROPERTYKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    RemoveKey: usize,
}
windows_core::imp::define_interface!(IPublishedApp, IPublishedApp_Vtbl, 0x1bc752e0_9046_11d1_b8b3_006008059382);
impl core::ops::Deref for IPublishedApp {
    type Target = IShellApp;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPublishedApp, windows_core::IUnknown, IShellApp);
impl IPublishedApp {
    pub unsafe fn Install(&self, pstinstall: *const super::super::Foundation::SYSTEMTIME) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Install)(windows_core::Interface::as_raw(self), pstinstall).ok()
    }
    pub unsafe fn GetPublishedAppInfo(&self, ppai: *mut PUBAPPINFO) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetPublishedAppInfo)(windows_core::Interface::as_raw(self), ppai).ok()
    }
    pub unsafe fn Unschedule(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Unschedule)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IPublishedApp_Vtbl {
    pub base__: IShellApp_Vtbl,
    pub Install: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::SYSTEMTIME) -> windows_core::HRESULT,
    pub GetPublishedAppInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut PUBAPPINFO) -> windows_core::HRESULT,
    pub Unschedule: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPublishedApp2, IPublishedApp2_Vtbl, 0x12b81347_1b3a_4a04_aa61_3f768b67fd7e);
impl core::ops::Deref for IPublishedApp2 {
    type Target = IPublishedApp;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPublishedApp2, windows_core::IUnknown, IShellApp, IPublishedApp);
impl IPublishedApp2 {
    pub unsafe fn Install2<P0>(&self, pstinstall: *const super::super::Foundation::SYSTEMTIME, hwndparent: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Install2)(windows_core::Interface::as_raw(self), pstinstall, hwndparent.param().abi()).ok()
    }
}
#[repr(C)]
pub struct IPublishedApp2_Vtbl {
    pub base__: IPublishedApp_Vtbl,
    pub Install2: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::SYSTEMTIME, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IPublishingWizard, IPublishingWizard_Vtbl, 0xaa9198bb_ccec_472d_beed_19a4f6733f7a);
impl core::ops::Deref for IPublishingWizard {
    type Target = IWizardExtension;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IPublishingWizard, windows_core::IUnknown, IWizardExtension);
impl IPublishingWizard {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Initialize<P0, P1>(&self, pdo: P0, dwoptions: u32, pszservicescope: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pdo.param().abi(), dwoptions, pszservicescope.param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_System_Com"))]
    pub unsafe fn GetTransferManifest(&self, phrfromtransfer: Option<*mut windows_core::HRESULT>, pdocmanifest: Option<*mut Option<super::super::Data::Xml::MsXml::IXMLDOMDocument>>) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).GetTransferManifest)(windows_core::Interface::as_raw(self), core::mem::transmute(phrfromtransfer.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdocmanifest.unwrap_or(std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IPublishingWizard_Vtbl {
    pub base__: IWizardExtension_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Initialize: usize,
    #[cfg(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_System_Com"))]
    pub GetTransferManifest: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::HRESULT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_System_Com")))]
    GetTransferManifest: usize,
}
windows_core::imp::define_interface!(IQueryAssociations, IQueryAssociations_Vtbl, 0xc46ca590_3c3f_11d2_bee6_0000f805ca57);
impl core::ops::Deref for IQueryAssociations {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IQueryAssociations, windows_core::IUnknown);
impl IQueryAssociations {
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn Init<P0, P1, P2>(&self, flags: ASSOCF, pszassoc: P0, hkprogid: P1, hwnd: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<super::super::System::Registry::HKEY>,
        P2: windows_core::Param<super::super::Foundation::HWND>,
    {
        (windows_core::Interface::vtable(self).Init)(windows_core::Interface::as_raw(self), flags, pszassoc.param().abi(), hkprogid.param().abi(), hwnd.param().abi()).ok()
    }
    pub unsafe fn GetString<P0>(&self, flags: ASSOCF, str: ASSOCSTR, pszextra: P0, pszout: windows_core::PWSTR, pcchout: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetString)(windows_core::Interface::as_raw(self), flags, str, pszextra.param().abi(), core::mem::transmute(pszout), pcchout).ok()
    }
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn GetKey<P0>(&self, flags: ASSOCF, key: ASSOCKEY, pszextra: P0) -> windows_core::Result<super::super::System::Registry::HKEY>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetKey)(windows_core::Interface::as_raw(self), flags, key, pszextra.param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetData<P0>(&self, flags: ASSOCF, data: ASSOCDATA, pszextra: P0, pvout: Option<*mut core::ffi::c_void>, pcbout: Option<*mut u32>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetData)(windows_core::Interface::as_raw(self), flags, data, pszextra.param().abi(), core::mem::transmute(pvout.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbout.unwrap_or(std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetEnum<P0>(&self, flags: ASSOCF, assocenum: ASSOCENUM, pszextra: P0, riid: *const windows_core::GUID, ppvout: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).GetEnum)(windows_core::Interface::as_raw(self), flags, assocenum, pszextra.param().abi(), riid, ppvout).ok()
    }
}
#[repr(C)]
pub struct IQueryAssociations_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Registry")]
    pub Init: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCF, windows_core::PCWSTR, super::super::System::Registry::HKEY, super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    Init: usize,
    pub GetString: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCF, ASSOCSTR, windows_core::PCWSTR, windows_core::PWSTR, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Registry")]
    pub GetKey: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCF, ASSOCKEY, windows_core::PCWSTR, *mut super::super::System::Registry::HKEY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    GetKey: usize,
    pub GetData: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCF, ASSOCDATA, windows_core::PCWSTR, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetEnum: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCF, ASSOCENUM, windows_core::PCWSTR, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IQueryCancelAutoPlay, IQueryCancelAutoPlay_Vtbl, 0xddefe873_6997_4e68_be26_39b633adbe12);
impl core::ops::Deref for IQueryCancelAutoPlay {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IQueryCancelAutoPlay, windows_core::IUnknown);
impl IQueryCancelAutoPlay {
    pub unsafe fn AllowAutoPlay<P0, P1>(&self, pszpath: P0, dwcontenttype: u32, pszlabel: P1, dwserialnumber: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        (windows_core::Interface::vtable(self).AllowAutoPlay)(windows_core::Interface::as_raw(self), pszpath.param().abi(), dwcontenttype, pszlabel.param().abi(), dwserialnumber).ok()
    }
}
#[repr(C)]
pub struct IQueryCancelAutoPlay_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AllowAutoPlay: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IQueryCodePage, IQueryCodePage_Vtbl, 0xc7b236ce_ee80_11d0_985f_006008059382);
impl core::ops::Deref for IQueryCodePage {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IQueryCodePage, windows_core::IUnknown);
impl IQueryCodePage {
    pub unsafe fn GetCodePage(&self) -> windows_core::Result<u32> {
        let mut result__ = core::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCodePage)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCodePage(&self, uicodepage: u32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCodePage)(windows_core::Interface::as_raw(self), uicodepage).ok()
    }
}
#[repr(C)]
pub struct IQueryCodePage_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCodePage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCodePage: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
windows_core::imp::define_interface!(IQueryContinue, IQueryContinue_Vtbl, 0x7307055c_b24a_486b_9f25_163e597a28a9);
impl core::ops::Deref for IQueryContinue {
    type Target = windows_core::IUnknown;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IQueryContinue, windows_core::IUnknown);
impl IQueryContinue {
    pub unsafe fn QueryContinue(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).QueryContinu