//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// Type of the callback function used by CFSets for retaining values.
///
/// Parameter `allocator`: The allocator of the CFSet.
///
/// Parameter `value`: The value to retain.
///
/// Returns: The value to store in the set, which is usually the value
/// parameter passed to this callback, but may be a different
/// value if a different value should be stored in the set.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetretaincallback?language=objc)
pub type CFSetRetainCallBack =
    Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void) -> *const c_void>;

/// Type of the callback function used by CFSets for releasing a retain on values.
///
/// Parameter `allocator`: The allocator of the CFSet.
///
/// Parameter `value`: The value to release.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetreleasecallback?language=objc)
pub type CFSetReleaseCallBack =
    Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void)>;

/// Type of the callback function used by CFSets for describing values.
///
/// Parameter `value`: The value to describe.
///
/// Returns: A description of the specified value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetcopydescriptioncallback?language=objc)
pub type CFSetCopyDescriptionCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>;

/// Type of the callback function used by CFSets for comparing values.
///
/// Parameter `value1`: The first value to compare.
///
/// Parameter `value2`: The second value to compare.
///
/// Returns: True if the values are equal, otherwise false.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetequalcallback?language=objc)
pub type CFSetEqualCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>;

/// Type of the callback function used by CFSets for hashing values.
///
/// Parameter `value`: The value to hash.
///
/// Returns: The hash of the value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsethashcallback?language=objc)
pub type CFSetHashCallBack = Option<unsafe extern "C-unwind" fn(*const c_void) -> CFHashCode>;

/// Structure containing the callbacks of a CFSet.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the CFSet creation functions. This
/// structure is version 0.
/// Field: retain The callback used to add a retain for the set on
/// values as they are put into the set. This callback returns
/// the value to store in the set, which is usually the value
/// parameter passed to this callback, but may be a different
/// value if a different value should be stored in the set.
/// The set's allocator is passed as the first argument.
/// Field: release The callback used to remove a retain previously added
/// for the set from values as they are removed from the
/// set. The set's allocator is passed as the first
/// argument.
/// Field: copyDescription The callback used to create a descriptive
/// string representation of each value in the set. This is
/// used by the CFCopyDescription() function.
/// Field: equal The callback used to compare values in the set for
/// equality for some operations.
/// Field: hash The callback used to compare values in the set for
/// uniqueness for some operations.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetcallbacks?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFSetCallBacks {
    pub version: CFIndex,
    pub retain: CFSetRetainCallBack,
    pub release: CFSetReleaseCallBack,
    pub copyDescription: CFSetCopyDescriptionCallBack,
    pub equal: CFSetEqualCallBack,
    pub hash: CFSetHashCallBack,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFSetCallBacks {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <CFSetRetainCallBack>::ENCODING,
            <CFSetReleaseCallBack>::ENCODING,
            <CFSetCopyDescriptionCallBack>::ENCODING,
            <CFSetEqualCallBack>::ENCODING,
            <CFSetHashCallBack>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFSetCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Predefined CFSetCallBacks structure containing a set of callbacks
    /// appropriate for use when the values in a CFSet are all CFTypes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcftypesetcallbacks?language=objc)
    pub static kCFTypeSetCallBacks: CFSetCallBacks;
}

extern "C" {
    /// Predefined CFSetCallBacks structure containing a set of callbacks
    /// appropriate for use when the values in a CFSet should be copies
    /// of a CFString.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfcopystringsetcallbacks?language=objc)
    pub static kCFCopyStringSetCallBacks: CFSetCallBacks;
}

/// Type of the callback function used by the apply functions of
/// CFSets.
///
/// Parameter `value`: The current value from the set.
///
/// Parameter `context`: The user-defined context parameter given to the apply
/// function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfsetapplierfunction?language=objc)
pub type CFSetApplierFunction = Option<unsafe extern "C-unwind" fn(*const c_void, *mut c_void)>;

/// This is the type of a reference to immutable CFSets.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfset?language=objc)
#[repr(C)]
pub struct CFSet<T: ?Sized = Opaque> {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
    _generics: PhantomData<(*mut T,)>,
}

cf_type!(
    unsafe impl<T: ?Sized> CFSet<T> {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl<T: ?Sized> RefEncode<"__CFSet"> for CFSet<T> {}
);

/// This is the type of a reference to mutable CFSets.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutableset?language=objc)
#[repr(C)]
pub struct CFMutableSet<T: ?Sized = Opaque> {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
    _generics: PhantomData<(*mut T,)>,
}

cf_type!(
    unsafe impl<T: ?Sized> CFMutableSet<T>: CFSet<T> {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl<T: ?Sized> RefEncode<"__CFSet"> for CFMutableSet<T> {}
);

unsafe impl ConcreteType for CFSet {
    /// Returns the type identifier of all CFSet instances.
    #[doc(alias = "CFSetGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFSetGetTypeID() -> CFTypeID;
        }
        unsafe { CFSetGetTypeID() }
    }
}

impl CFSet {
    /// Creates a new immutable set with the given values.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the set and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `values`: A C array of the pointer-sized values to be in the
    /// set.  This C array is not changed or freed by this function.
    /// If this parameter is not a valid pointer to a C array of at
    /// least numValues pointers, the behavior is undefined.
    ///
    /// Parameter `numValues`: The number of values to copy from the values C
    /// array into the CFSet. This number will be the count of the
    /// set.  If this parameter is zero, negative, or greater than
    /// the number of values actually in the values C array, the
    /// behavior is undefined.
    ///
    /// Parameter `callBacks`: A C pointer to a CFSetCallBacks structure
    /// initialized with the callbacks for the set to use on each
    /// value in the set. A copy of the contents of the
    /// callbacks structure is made, so that a pointer to a
    /// structure on the stack can be passed in, or can be reused
    /// for multiple set creations. If the version field of this
    /// callbacks structure is not one of the defined ones for
    /// CFSet, the behavior is undefined. The retain field may be
    /// NULL, in which case the CFSet will do nothing to add a
    /// retain to the contained values for the set. The release
    /// field may be NULL, in which case the CFSet will do nothing
    /// to remove the set's retain (if any) on the values when the
    /// set is destroyed. If the copyDescription field is NULL,
    /// the set will create a simple description for the value. If
    /// the equal field is NULL, the set will use pointer equality
    /// to test for equality of values. The hash field may be NULL,
    /// in which case the CFSet will determine uniqueness by pointer
    /// equality. This callbacks parameter
    /// itself may be NULL, which is treated as if a valid structure
    /// of version 0 with all fields NULL had been passed in.
    /// Otherwise, if any of the fields are not valid pointers to
    /// functions of the correct type, or this parameter is not a
    /// valid pointer to a  CFSetCallBacks callbacks structure,
    /// the behavior is undefined. If any of the values put into the
    /// set is not one understood by one of the callback functions
    /// the behavior when that callback function is used is
    /// undefined.
    ///
    /// Returns: A reference to the new immutable CFSet.
    #[doc(alias = "CFSetCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        values: *mut *const c_void,
        num_values: CFIndex,
        call_backs: *const CFSetCallBacks,
    ) -> Option<CFRetained<CFSet>> {
        extern "C-unwind" {
            fn CFSetCreate(
                allocator: Option<&CFAllocator>,
                values: *mut *const c_void,
                num_values: CFIndex,
                call_backs: *const CFSetCallBacks,
            ) -> Option<NonNull<CFSet>>;
        }
        let ret = unsafe { CFSetCreate(allocator, values, num_values, call_backs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new immutable set with the values from the given set.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the set and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `theSet`: The set which is to be copied. The values from the
    /// set are copied as pointers into the new set (that is,
    /// the values themselves are copied, not that which the values
    /// point to, if anything). However, the values are also
    /// retained by the new set. The count of the new set will
    /// be the same as the copied set. The new set uses the same
    /// callbacks as the set to be copied. If this parameter is
    /// not a valid CFSet, the behavior is undefined.
    ///
    /// Returns: A reference to the new immutable CFSet.
    #[doc(alias = "CFSetCreateCopy")]
    #[inline]
    pub fn new_copy(
        allocator: Option<&CFAllocator>,
        the_set: Option<&CFSet>,
    ) -> Option<CFRetained<CFSet>> {
        extern "C-unwind" {
            fn CFSetCreateCopy(
                allocator: Option<&CFAllocator>,
                the_set: Option<&CFSet>,
            ) -> Option<NonNull<CFSet>>;
        }
        let ret = unsafe { CFSetCreateCopy(allocator, the_set) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFMutableSet {
    /// Creates a new empty mutable set.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the set and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `capacity`: A hint about the number of values that will be held
    /// by the CFSet. Pass 0 for no hint. The implementation may
    /// ignore this hint, or may use it to optimize various
    /// operations. A set's actual capacity is only limited by
    /// address space and available memory constraints). If this
    /// parameter is negative, the behavior is undefined.
    ///
    /// Parameter `callBacks`: A C pointer to a CFSetCallBacks structure
    /// initialized with the callbacks for the set to use on each
    /// value in the set. A copy of the contents of the
    /// callbacks structure is made, so that a pointer to a
    /// structure on the stack can be passed in, or can be reused
    /// for multiple set creations. If the version field of this
    /// callbacks structure is not one of the defined ones for
    /// CFSet, the behavior is undefined. The retain field may be
    /// NULL, in which case the CFSet will do nothing to add a
    /// retain to the contained values for the set. The release
    /// field may be NULL, in which case the CFSet will do nothing
    /// to remove the set's retain (if any) on the values when the
    /// set is destroyed. If the copyDescription field is NULL,
    /// the set will create a simple description for the value. If
    /// the equal field is NULL, the set will use pointer equality
    /// to test for equality of values. The hash field may be NULL,
    /// in which case the CFSet will determine uniqueness by pointer
    /// equality. This callbacks parameter
    /// itself may be NULL, which is treated as if a valid structure
    /// of version 0 with all fields NULL had been passed in.
    /// Otherwise, if any of the fields are not valid pointers to
    /// functions of the correct type, or this parameter is not a
    /// valid pointer to a  CFSetCallBacks callbacks structure,
    /// the behavior is undefined. If any of the values put into the
    /// set is not one understood by one of the callback functions
    /// the behavior when that callback function is used is
    /// undefined.
    ///
    /// Returns: A reference to the new mutable CFSet.
    #[doc(alias = "CFSetCreateMutable")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        call_backs: *const CFSetCallBacks,
    ) -> Option<CFRetained<CFMutableSet>> {
        extern "C-unwind" {
            fn CFSetCreateMutable(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                call_backs: *const CFSetCallBacks,
            ) -> Option<NonNull<CFMutableSet>>;
        }
        let ret = unsafe { CFSetCreateMutable(allocator, capacity, call_backs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new immutable set with the values from the given set.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the set and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `capacity`: A hint about the number of values that will be held
    /// by the CFSet. Pass 0 for no hint. The implementation may
    /// ignore this hint, or may use it to optimize various
    /// operations. A set's actual capacity is only limited by
    /// address space and available memory constraints).
    /// This parameter must be greater than or equal
    /// to the count of the set which is to be copied, or the
    /// behavior is undefined. If this parameter is negative, the
    /// behavior is undefined.
    ///
    /// Parameter `theSet`: The set which is to be copied. The values from the
    /// set are copied as pointers into the new set (that is,
    /// the values themselves are copied, not that which the values
    /// point to, if anything). However, the values are also
    /// retained by the new set. The count of the new set will
    /// be the same as the copied set. The new set uses the same
    /// callbacks as the set to be copied. If this parameter is
    /// not a valid CFSet, the behavior is undefined.
    ///
    /// Returns: A reference to the new mutable CFSet.
    #[doc(alias = "CFSetCreateMutableCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        the_set: Option<&CFSet>,
    ) -> Option<CFRetained<CFMutableSet>> {
        extern "C-unwind" {
            fn CFSetCreateMutableCopy(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                the_set: Option<&CFSet>,
            ) -> Option<NonNull<CFMutableSet>>;
        }
        let ret = unsafe { CFSetCreateMutableCopy(allocator, capacity, the_set) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFSet {
    /// Returns the number of values currently in the set.
    ///
    /// Parameter `theSet`: The set to be queried. If this parameter is not a valid
    /// CFSet, the behavior is undefined.
    ///
    /// Returns: The number of values in the set.
    #[doc(alias = "CFSetGetCount")]
    #[inline]
    pub fn count(self: &CFSet) -> CFIndex {
        extern "C-unwind" {
            fn CFSetGetCount(the_set: &CFSet) -> CFIndex;
        }
        unsafe { CFSetGetCount(self) }
    }

    /// Counts the number of times the given value occurs in the set. Since
    /// sets by definition contain only one instance of a value, this function
    /// is synonymous to CFSetContainsValue.
    ///
    /// Parameter `theSet`: The set to be searched. If this parameter is not a
    /// valid CFSet, the behavior is undefined.
    ///
    /// Parameter `value`: The value for which to find matches in the set. The
    /// equal() callback provided when the set was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the set, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: The number of times the given value occurs in the set.
    #[doc(alias = "CFSetGetCountOfValue")]
    #[inline]
    pub unsafe fn count_of_value(self: &CFSet, value: *const c_void) -> CFIndex {
        extern "C-unwind" {
            fn CFSetGetCountOfValue(the_set: &CFSet, value: *const c_void) -> CFIndex;
        }
        unsafe { CFSetGetCountOfValue(self, value) }
    }

    /// Reports whether or not the value is in the set.
    ///
    /// Parameter `theSet`: The set to be searched. If this parameter is not a
    /// valid CFSet, the behavior is undefined.
    ///
    /// Parameter `value`: The value for which to find matches in the set. The
    /// equal() callback provided when the set was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the set, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: true, if the value is in the set, otherwise false.
    #[doc(alias = "CFSetContainsValue")]
    #[inline]
    pub unsafe fn contains_value(self: &CFSet, value: *const c_void) -> bool {
        extern "C-unwind" {
            fn CFSetContainsValue(the_set: &CFSet, value: *const c_void) -> Boolean;
        }
        let ret = unsafe { CFSetContainsValue(self, value) };
        ret != 0
    }

    /// Retrieves a value in the set which hashes the same as the specified value.
    ///
    /// Parameter `theSet`: The set to be queried. If this parameter is not a
    /// valid CFSet, the behavior is undefined.
    ///
    /// Parameter `value`: The value to retrieve. The equal() callback provided when
    /// the set was created is used to compare. If the equal() callback
    /// was NULL, pointer equality (in C, ==) is used. If a value, or
    /// any of the values in the set, are not understood by the equal()
    /// callback, the behavior is undefined.
    ///
    /// Returns: The value in the set with the given hash.
    #[doc(alias = "CFSetGetValue")]
    #[inline]
    pub unsafe fn value(self: &CFSet, value: *const c_void) -> *const c_void {
        extern "C-unwind" {
            fn CFSetGetValue(the_set: &CFSet, value: *const c_void) -> *const c_void;
        }
        unsafe { CFSetGetValue(self, value) }
    }

    /// Retrieves a value in the set which hashes the same as the specified value,
    /// if present.
    ///
    /// Parameter `theSet`: The set to be queried. If this parameter is not a
    /// valid CFSet, the behavior is undefined.
    ///
    /// Parameter `candidate`: This value is hashed and compared with values in the
    /// set to determine which value to retrieve. The equal() callback provided when
    /// the set was created is used to compare. If the equal() callback
    /// was NULL, pointer equality (in C, ==) is used. If a value, or
    /// any of the values in the set, are not understood by the equal()
    /// callback, the behavior is undefined.
    ///
    /// Parameter `value`: A pointer to memory which should be filled with the
    /// pointer-sized value if a matching value is found. If no
    /// match is found, the contents of the storage pointed to by
    /// this parameter are undefined. This parameter may be NULL,
    /// in which case the value from the dictionary is not returned
    /// (but the return value of this function still indicates
    /// whether or not the value was present).
    ///
    /// Returns: True if the value was present in the set, otherwise false.
    #[doc(alias = "CFSetGetValueIfPresent")]
    #[inline]
    pub unsafe fn value_if_present(
        self: &CFSet,
        candidate: *const c_void,
        value: *mut *const c_void,
    ) -> bool {
        extern "C-unwind" {
            fn CFSetGetValueIfPresent(
                the_set: &CFSet,
                candidate: *const c_void,
                value: *mut *const c_void,
            ) -> Boolean;
        }
        let ret = unsafe { CFSetGetValueIfPresent(self, candidate, value) };
        ret != 0
    }

    /// Fills the buffer with values from the set.
    ///
    /// Parameter `theSet`: The set to be queried. If this parameter is not a
    /// valid CFSet, the behavior is undefined.
    ///
    /// Parameter `values`: A C array of pointer-sized values to be filled with
    /// values from the set. The values in the C array are ordered
    /// in the same order in which they appear in the set. If this
    /// parameter is not a valid pointer to a C array of at least
    /// CFSetGetCount() pointers, the behavior is undefined.
    #[doc(alias = "CFSetGetValues")]
    #[inline]
    pub unsafe fn values(self: &CFSet, values: *mut *const c_void) {
        extern "C-unwind" {
            fn CFSetGetValues(the_set: &CFSet, values: *mut *const c_void);
        }
        unsafe { CFSetGetValues(self, values) }
    }

    /// Calls a function once for each value in the set.
    ///
    /// Parameter `theSet`: The set to be operated upon. If this parameter is not
    /// a valid CFSet, the behavior is undefined.
    ///
    /// Parameter `applier`: The callback function to call once for each value in
    /// the given set. If this parameter is not a
    /// pointer to a function of the correct prototype, the behavior
    /// is undefined. If there are values in the set which the
    /// applier function does not expect or cannot properly apply
    /// to, the behavior is undefined.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the second parameter to the applier function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the applier function, the behavior is
    /// undefined.
    #[doc(alias = "CFSetApplyFunction")]
    #[inline]
    pub unsafe fn apply_function(
        self: &CFSet,
        applier: CFSetApplierFunction,
        context: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFSetApplyFunction(
                the_set: &CFSet,
                applier: CFSetApplierFunction,
                context: *mut c_void,
            );
        }
        unsafe { CFSetApplyFunction(self, applier, context) }
    }
}

impl CFMutableSet {
    /// Adds the value to the set if it is not already present.
    ///
    /// Parameter `theSet`: The set to which the value is to be added. If this
    /// parameter is not a valid mutable CFSet, the behavior is
    /// undefined.
    ///
    /// Parameter `value`: The value to add to the set. The value is retained by
    /// the set using the retain callback provided when the set
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The count of the
    /// set is increased by one.
    #[doc(alias = "CFSetAddValue")]
    #[inline]
    pub unsafe fn add_value(the_set: Option<&CFMutableSet>, value: *const c_void) {
        extern "C-unwind" {
            fn CFSetAddValue(the_set: Option<&CFMutableSet>, value: *const c_void);
        }
        unsafe { CFSetAddValue(the_set, value) }
    }

    /// Replaces the value in the set if it is present.
    ///
    /// Parameter `theSet`: The set to which the value is to be replaced. If this
    /// parameter is not a valid mutable CFSet, the behavior is
    /// undefined.
    ///
    /// Parameter `value`: The value to replace in the set. The equal() callback provided when
    /// the set was created is used to compare. If the equal() callback
    /// was NULL, pointer equality (in C, ==) is used. If a value, or
    /// any of the values in the set, are not understood by the equal()
    /// callback, the behavior is undefined. The value is retained by
    /// the set using the retain callback provided when the set
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The count of the
    /// set is increased by one.
    #[doc(alias = "CFSetReplaceValue")]
    #[inline]
    pub unsafe fn replace_value(the_set: Option<&CFMutableSet>, value: *const c_void) {
        extern "C-unwind" {
            fn CFSetReplaceValue(the_set: Option<&CFMutableSet>, value: *const c_void);
        }
        unsafe { CFSetReplaceValue(the_set, value) }
    }

    /// Replaces the value in the set if it is present, or adds the value to
    /// the set if it is absent.
    ///
    /// Parameter `theSet`: The set to which the value is to be replaced. If this
    /// parameter is not a valid mutable CFSet, the behavior is
    /// undefined.
    ///
    /// Parameter `value`: The value to set in the CFSet. The equal() callback provided when
    /// the set was created is used to compare. If the equal() callback
    /// was NULL, pointer equality (in C, ==) is used. If a value, or
    /// any of the values in the set, are not understood by the equal()
    /// callback, the behavior is undefined. The value is retained by
    /// the set using the retain callback provided when the set
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The count of the
    /// set is increased by one.
    #[doc(alias = "CFSetSetValue")]
    #[inline]
    pub unsafe fn set_value(the_set: Option<&CFMutableSet>, value: *const c_void) {
        extern "C-unwind" {
            fn CFSetSetValue(the_set: Option<&CFMutableSet>, value: *const c_void);
        }
        unsafe { CFSetSetValue(the_set, value) }
    }

    /// Removes the specified value from the set.
    ///
    /// Parameter `theSet`: The set from which the value is to be removed.
    /// If this parameter is not a valid mutable CFSet,
    /// the behavior is undefined.
    ///
    /// Parameter `value`: The value to remove. The equal() callback provided when
    /// the set was created is used to compare. If the equal() callback
    /// was NULL, pointer equality (in C, ==) is used. If a value, or
    /// any of the values in the set, are not understood by the equal()
    /// callback, the behavior is undefined.
    #[doc(alias = "CFSetRemoveValue")]
    #[inline]
    pub unsafe fn remove_value(the_set: Option<&CFMutableSet>, value: *const c_void) {
        extern "C-unwind" {
            fn CFSetRemoveValue(the_set: Option<&CFMutableSet>, value: *const c_void);
        }
        unsafe { CFSetRemoveValue(the_set, value) }
    }

    /// Removes all the values from the set, making it empty.
    ///
    /// Parameter `theSet`: The set from which all of the values are to be
    /// removed. If this parameter is not a valid mutable CFSet,
    /// the behavior is undefined.
    #[doc(alias = "CFSetRemoveAllValues")]
    #[inline]
    pub fn remove_all_values(the_set: Option<&CFMutableSet>) {
        extern "C-unwind" {
            fn CFSetRemoveAllValues(the_set: Option<&CFMutableSet>);
        }
        unsafe { CFSetRemoveAllValues(the_set) }
    }
}

#[deprecated = "renamed to `CFSet::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSetCreate(
    allocator: Option<&CFAllocator>,
    values: *mut *const c_void,
    num_values: CFIndex,
    call_backs: *const CFSetCallBacks,
) -> Option<CFRetained<CFSet>> {
    extern "C-unwind" {
        fn CFSetCreate(
            allocator: Option<&CFAllocator>,
            values: *mut *const c_void,
            num_values: CFIndex,
            call_backs: *const CFSetCallBacks,
        ) -> Option<NonNull<CFSet>>;
    }
    let ret = unsafe { CFSetCreate(allocator, values, num_values, call_backs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFSet::new_copy`"]
#[inline]
pub extern "C-unwind" fn CFSetCreateCopy(
    allocator: Option<&CFAllocator>,
    the_set: Option<&CFSet>,
) -> Option<CFRetained<CFSet>> {
    extern "C-unwind" {
        fn CFSetCreateCopy(
            allocator: Option<&CFAllocator>,
            the_set: Option<&CFSet>,
        ) -> Option<NonNull<CFSet>>;
    }
    let ret = unsafe { CFSetCreateCopy(allocator, the_set) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableSet::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSetCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    call_backs: *const CFSetCallBacks,
) -> Option<CFRetained<CFMutableSet>> {
    extern "C-unwind" {
        fn CFSetCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            call_backs: *const CFSetCallBacks,
        ) -> Option<NonNull<CFMutableSet>>;
    }
    let ret = unsafe { CFSetCreateMutable(allocator, capacity, call_backs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableSet::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSetCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    the_set: Option<&CFSet>,
) -> Option<CFRetained<CFMutableSet>> {
    extern "C-unwind" {
        fn CFSetCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            the_set: Option<&CFSet>,
        ) -> Option<NonNull<CFMutableSet>>;
    }
    let ret = unsafe { CFSetCreateMutableCopy(allocator, capacity, the_set) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFSet::count`"]
#[inline]
pub extern "C-unwind" fn CFSetGetCount(the_set: &CFSet) -> CFIndex {
    extern "C-unwind" {
        fn CFSetGetCount(the_set: &CFSet) -> CFIndex;
    }
    unsafe { CFSetGetCount(the_set) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFSet::count_of_value`"]
    pub fn CFSetGetCountOfValue(the_set: &CFSet, value: *const c_void) -> CFIndex;
}

#[deprecated = "renamed to `CFSet::contains_value`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSetContainsValue(the_set: &CFSet, value: *const c_void) -> bool {
    extern "C-unwind" {
        fn CFSetContainsValue(the_set: &CFSet, value: *const c_void) -> Boolean;
    }
    let ret = unsafe { CFSetContainsValue(the_set, value) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFSet::value`"]
    pub fn CFSetGetValue(the_set: &CFSet, value: *const c_void) -> *const c_void;
}

#[deprecated = "renamed to `CFSet::value_if_present`"]
#[inline]
pub unsafe extern "C-unwind" fn CFSetGetValueIfPresent(
    the_set: &CFSet,
    candidate: *const c_void,
    value: *mut *const c_void,
) -> bool {
    extern "C-unwind" {
        fn CFSetGetValueIfPresent(
            the_set: &CFSet,
            candidate: *const c_void,
            value: *mut *const c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFSetGetValueIfPresent(the_set, candidate, value) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFSet::values`"]
    pub fn CFSetGetValues(the_set: &CFSet, values: *mut *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFSet::apply_function`"]
    pub fn CFSetApplyFunction(the_set: &CFSet, applier: CFSetApplierFunction, context: *mut c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableSet::add_value`"]
    pub fn CFSetAddValue(the_set: Option<&CFMutableSet>, value: *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableSet::replace_value`"]
    pub fn CFSetReplaceValue(the_set: Option<&CFMutableSet>, value: *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableSet::set_value`"]
    pub fn CFSetSetValue(the_set: Option<&CFMutableSet>, value: *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableSet::remove_value`"]
    pub fn CFSetRemoveValue(the_set: Option<&CFMutableSet>, value: *const c_void);
}

#[deprecated = "renamed to `CFMutableSet::remove_all_values`"]
#[inline]
pub extern "C-unwind" fn CFSetRemoveAllValues(the_set: Option<&CFMutableSet>) {
    extern "C-unwind" {
        fn CFSetRemoveAllValues(the_set: Option<&CFMutableSet>);
    }
    unsafe { CFSetRemoveAllValues(the_set) }
}
