// Code generated by command: go run gen.go -out ../asm_amd64.s -stubs ../asm_amd64.go -pkg=minlz. DO NOT EDIT.

//go:build !appengine && !noasm && gc && !purego

package minlz

func _dummy_()

// encodeBlockAsm encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 8388608 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm(dst []byte, src []byte, tmp *[131072]byte) int

// encodeBlockAsm2MB encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 2097152 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm2MB(dst []byte, src []byte, tmp *[131072]byte) int

// encodeBlockAsm512K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 524288 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm512K(dst []byte, src []byte, tmp *[65536]byte) int

// encodeBlockAsm64K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 65536 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm64K(dst []byte, src []byte, tmp *[16384]byte) int

// encodeBlockAsm16K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 16384 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm16K(dst []byte, src []byte, tmp *[8192]byte) int

// encodeBlockAsm4K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 4096 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm4K(dst []byte, src []byte, tmp *[2048]byte) int

// encodeBlockAsm1K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 1024 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBlockAsm1K(dst []byte, src []byte, tmp *[1024]byte) int

// encodeBetterBlockAsm encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 8388608 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm(dst []byte, src []byte, tmp *[589824]byte) int

// encodeBetterBlockAsm2MB encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 2097152 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm2MB(dst []byte, src []byte, tmp *[589824]byte) int

// encodeBetterBlockAsm512K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 524288 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm512K(dst []byte, src []byte, tmp *[294912]byte) int

// encodeBetterBlockAsm64K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 65536 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm64K(dst []byte, src []byte, tmp *[73728]byte) int

// encodeBetterBlockAsm16K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 16384 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm16K(dst []byte, src []byte, tmp *[36864]byte) int

// encodeBetterBlockAsm4K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 4096 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm4K(dst []byte, src []byte, tmp *[10240]byte) int

// encodeBetterBlockAsm1K encodes a non-empty src to a guaranteed-large-enough dst.
// Maximum input 1024 bytes.
// It assumes that the varint-encoded length of the decompressed bytes has already been written.
//
//go:noescape
func encodeBetterBlockAsm1K(dst []byte, src []byte, tmp *[4608]byte) int

// emitLiteral writes a literal chunk and returns the number of bytes written.
//
// It assumes that:
//
//	dst is long enough to hold the encoded bytes with margin of 8 bytes
//	0 <= len(lit) && len(lit) <= math.MaxUint32
//
//go:noescape
func emitLiteral(dst []byte, lit []byte) int

// emitRepeat writes a repeat chunk and returns the number of bytes written.
// Length must be at least 4 and < 1<<32
//
//go:noescape
func emitRepeat(dst []byte, length int) int

// emitCopy writes a copy chunk and returns the number of bytes written.
//
// It assumes that:
//
//	dst is long enough to hold the encoded bytes
//	1 <= offset && offset <= math.MaxUint32
//	4 <= length && length <= 1 << 24
//
//go:noescape
func emitCopy(dst []byte, offset int, length int) int

// emitCopyLits2 writes a copy chunk and returns the number of bytes written.
//
// It assumes that:
//
//	dst is long enough to hold the encoded bytes
//	1 <= offset && offset <= 65536
//	4 <= length && length <= MaxBlockSize
//
//go:noescape
func emitCopyLits2(dst []byte, lits []byte, offset int, length int) int

// emitCopyLits3 writes a copy chunk and returns the number of bytes written.
//
// It assumes that:
//
//	dst is long enough to hold the encoded bytes
//	1 <= offset && offset <= (1<<21)
//	4 <= length && length <= MaxBlockSize
//
//go:noescape
func emitCopyLits3(dst []byte, lits []byte, offset int, length int) int

// matchLen returns how many bytes match in a and b
//
// It assumes that:
//
//	len(a) <= len(b)
//
//go:noescape
func matchLen(a []byte, b []byte) int

// cvtLZ4Block converts an LZ4 block to MinLZ
//
//go:noescape
func cvtLZ4BlockAsm(dst []byte, src []byte) (uncompressed int, dstUsed int)

// decodeBlockAsm encodes a non-empty src to a guaranteed-large-enough dst.
// It assumes that the varint-encoded length of the decompressed bytes has already been read.
//
//go:noescape
func decodeBlockAsm(dst []byte, src []byte) int
