/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_scn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_018 = "Àfrica di sciroccu";
        final String metaValue_ar = "àrabbu";
        final String metaValue_hy = "armenu";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_ka = "giurgianu";
        final String metaValue_el = "grecu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebbràicu";
        final String metaValue_ja = "giappunisi";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "curianu";
        final String metaValue_la = "latinu";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mòngulu";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "orìa";
        final String metaValue_si = "singalisi";
        final String metaValue_su = "sunnanisi";
        final String metaValue_syr = "sirìacu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailannisi";
        final Object[][] data = new Object[][] {
            { "001", "Munnu" },
            { "002", "Àfrica" },
            { "003", "Mèrica di tramuntana cuntinintali" },
            { "005", "Mèrica di sciroccu" },
            { "009", "Uciània" },
            { "011", "Àfrica punintina" },
            { "013", "Mèrica cintrali" },
            { "014", "Àfrica livantina" },
            { "015", "Àfrica di tramuntana" },
            { "017", "Àfrica di menzu" },
            { "018", metaValue_018 },
            { "019", "Mèrichi" },
            { "021", "Mèrica di tramuntana" },
            { "029", "Caràibbi" },
            { "030", "Asia livantina" },
            { "034", "Asia di sciroccu" },
            { "035", "Asia di sciroccu-livantina" },
            { "039", "Europa di sciroccu" },
            { "053", "Australasia" },
            { "054", "Milanesia" },
            { "057", "Riggiuni dâ Micrunesia" },
            { "061", "Pulinesia" },
            { "142", "Asia" },
            { "143", "Asia cintrali" },
            { "145", "Asia punintina" },
            { "150", "Europa" },
            { "151", "Europa livantina" },
            { "154", "Europa di tramuntana" },
            { "155", "Europa punintina" },
            { "202", "Àfrica sutta-sahariana" },
            { "419", "Mèrica latina" },
            { "AC", "Ìsula d’Ascinziuni" },
            { "AD", "Annorra" },
            { "AE", "Emirati Àrabbi Junciuti" },
            { "AF", "Afghànistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Arbanìa" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antàrtidi" },
            { "AR", "Argintina" },
            { "AS", "Samoa Miricani" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Ìsuli Åland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia e Herzegòvina" },
            { "BB", "Barbados" },
            { "BD", "Bàngladesh" },
            { "BE", "Bergiu" },
            { "BF", "Burkina Fasu" },
            { "BG", "Burgarìa" },
            { "BH", "Bahrain" },
            { "BI", "Burunni" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Birmuda" },
            { "BN", "Brunei" },
            { "BO", "Bulivia" },
            { "BQ", "Caràibbi ulannisi" },
            { "BR", "Brasili" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Ìsula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bilurussia" },
            { "BZ", "Bilisi" },
            { "CA", "Cànada" },
            { "CC", "Ìsuli Cocos (Keeling)" },
            { "CD", "Congu - Kinshasa" },
            { "CF", "Ripùbblica Centrafricana" },
            { "CG", "Congu - Brazzaville" },
            { "CH", "Sbìzzira" },
            { "CI", "Custa d’Avoriu" },
            { "CK", "Ìsuli Cook" },
            { "CL", "Cili" },
            { "CM", "Càmerun" },
            { "CN", "Cina" },
            { "CO", "Culommia" },
            { "CP", "Ìsula di Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Custa Rica" },
            { "CU", "Cubba" },
            { "CV", "Capu Virdi" },
            { "CW", "Curaçao" },
            { "CX", "Ìsula di Natali" },
            { "CY", "Cipru" },
            { "CZ", "Cechia" },
            { "DE", "Girmania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibbuti" },
            { "DK", "Danimarca" },
            { "DM", "Dumìnica" },
            { "DO", "Ripùbblica Duminicana" },
            { "DZ", "Algirìa" },
            { "EA", "Ceuta e Miliḍḍa" },
            { "EC", "Ècuador" },
            { "EE", "Estonia" },
            { "EG", "Eggittu" },
            { "EH", "Sahara punintinu" },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Unioni Eurupea" },
            { "EZ", "Zuna Euru" },
            { "FI", "Fillannia" },
            { "FJ", "Figi" },
            { "FK", "Ìsuli Falkland" },
            { "FM", "Micrunisia" },
            { "FO", "Ìsuli Faroe" },
            { "FR", "Franza" },
            { "GA", "Gabòn" },
            { "GB", "Regnu Junciutu" },
            { "GD", "Grenada" },
            { "GE", "Giorgia" },
            { "GF", "Guiana Francisi" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibbirterra" },
            { "GL", "Gruillannia" },
            { "GM", "Gammia" },
            { "GN", "Guinìa" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinìa Equaturiali" },
            { "GR", "Grecia" },
            { "GS", "Giorgia di sciroccu e Ìsuli Sandwich australi" },
            { "GT", "Guatimala" },
            { "GU", "Guam" },
            { "GW", "Guinìa-Bissau" },
            { "GY", "Guiana" },
            { "HK", "Hong Kong RAS dâ Cina" },
            { "HM", "Ìsuli Heard e McDonald" },
            { "HN", "Hunnuras" },
            { "HR", "Cruazzia" },
            { "HT", "Haiti" },
            { "HU", "Ungarìa" },
            { "IC", "Ìsuli Canari" },
            { "ID", "Innunesia" },
            { "IE", "Irlanna" },
            { "IL", "Isdraeli" },
            { "IM", "Ìsula di Man" },
            { "IN", "Innia" },
            { "IO", "Tirritoriu Uciànicu di l’Innia Britànnica" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islanna" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Giamàica" },
            { "JO", "Giurdania" },
            { "JP", "Giappuni" },
            { "KE", "Kenya" },
            { "KG", "Kirghìzzistan" },
            { "KH", "Camboggia" },
            { "KI", "Kiribati" },
            { "KM", "Còmoros" },
            { "KN", "S. Kitts e Nevis" },
            { "KP", "Curìa di Tramuntana" },
            { "KR", "Curìa di Sciroccu" },
            { "KW", "Kuwait" },
            { "KY", "Ìsuli Cayman" },
            { "KZ", "Kazzàkistan" },
            { "LA", "Laos" },
            { "LB", "Lìbbanu" },
            { "LC", "Santa Lucìa" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libberia" },
            { "LS", "Lisothu" },
            { "LT", "Lituania" },
            { "LU", "Lussimmurgu" },
            { "LV", "Littonia" },
            { "LY", "Libbia" },
            { "MA", "Maroccu" },
            { "MC", "Mònacu" },
            { "MD", "Murdova" },
            { "ME", "Muntinegru" },
            { "MF", "San Martinu" },
            { "MG", "Madagascàr" },
            { "MH", "Ìsuli Marshall" },
            { "MK", "Macidonia di tramuntana" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mungolia" },
            { "MO", "Macau RAS dâ Cina" },
            { "MP", "Ìsuli Marianna di Tramuntana" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Munzirratu" },
            { "MT", "Mauta" },
            { "MU", "Maurizzius" },
            { "MV", "Mardivi" },
            { "MW", "Malawi" },
            { "MX", "Mèssicu" },
            { "MY", "Malesia" },
            { "MZ", "Muzzammicu" },
            { "NA", "Namibbia" },
            { "NC", "Nova Calidonia" },
            { "NE", "Niger" },
            { "NF", "Ìsula Norfolk" },
            { "NG", "Niggeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pajisi Basci" },
            { "NO", "Nurbeggia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zilannia" },
            { "OM", "Oman" },
            { "PA", "Pànama" },
            { "PE", "Pirù" },
            { "PF", "Pulinisia Francisi" },
            { "PG", "Papua Nova Guinìa" },
            { "PH", "Filippini" },
            { "PK", "Pàkistan" },
            { "PL", "Pulonia" },
            { "PM", "S. Pierre e Miquelon" },
            { "PN", "Ìsuli Pitcairn" },
            { "PR", "Portu Ricu" },
            { "PS", "Tirritori Palistinesi" },
            { "PT", "Purtugallu" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Uciània di fora" },
            { "RE", "Riunion" },
            { "RO", "Rumanìa" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanna" },
            { "SA", "Arabbia Saudita" },
            { "SB", "Ìsuli Salumuni" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sbezzia" },
            { "SG", "Singapuri" },
            { "SH", "Sant’Èlina" },
            { "SI", "Sluvenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Sluvacchia" },
            { "SL", "Sierra Liuni" },
            { "SM", "San Marinu" },
            { "SN", "Sènigal" },
            { "SO", "Sumalia" },
            { "SR", "Surinami" },
            { "SS", "Sudan di sciroccu" },
            { "ST", "São Tomé e Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Ìsuli Turks e Càicos" },
            { "TD", "Chad" },
            { "TF", "Tirritori Francisi di Sciroccu" },
            { "TG", "Togu" },
            { "TH", "Tailannia" },
            { "TJ", "Tajìkistan" },
            { "TK", "Tukilau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmènistan" },
            { "TN", "Tunisìa" },
            { "TO", "Tonga" },
            { "TR", "Turchìa" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganna" },
            { "UM", "Ìsuli Miricani di Fora" },
            { "UN", "Nazzioni Junciuti" },
            { "US", "Stati Junciuti" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbèkistan" },
            { "VA", "Città dû Vaticanu" },
            { "VC", "S. Vincent e Grenadine" },
            { "VE", "Vinizzuela" },
            { "VG", "Ìsuli Vìrgini Britànnichi" },
            { "VI", "Ìsuli Vìrgini Miricani" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Accenti fausi" },
            { "XB", "Bidirizziunali fausu" },
            { "XK", "Kòssuvu" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", metaValue_018 },
            { "ZM", "Zammia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Riggiuni scanusciuta" },
            { "aa", "afar" },
            { "ab", "abkhasu" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amàricu" },
            { "an", "aragunisi" },
            { "ar", metaValue_ar },
            { "as", "assamisi" },
            { "az", "azzeru" },
            { "ba", "bashkir" },
            { "be", "belurrussu" },
            { "bg", "bùrgaru" },
            { "bm", "bambara" },
            { "bn", "bangladisi" },
            { "br", "brètuni" },
            { "bs", "busnìacu" },
            { "ca", "catalanu" },
            { "ce", "cicenu" },
            { "co", "corsu" },
            { "cs", "cecu" },
            { "cu", "slavu dâ cresia" },
            { "cv", "ciuvasciu" },
            { "cy", "gallisi" },
            { "da", "danisi" },
            { "de", "tidiscu" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ngrisi" },
            { "eo", "spirantu" },
            { "es", "spagnolu" },
            { "et", "èstuni" },
            { "eu", "bascu" },
            { "fa", "pirsianu" },
            { "ff", "fula" },
            { "fi", "fillannisi" },
            { "fo", "faruisi" },
            { "fr", "francisi" },
            { "fy", "frìsuni uccidintali" },
            { "ga", "irlannisi" },
            { "gd", "gaèlicu scuzzisi" },
            { "gl", "galizzianu" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "mannisi" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "innianu" },
            { "hr", "cruatu" },
            { "ht", "criolu d’Haiti" },
            { "hu", "unghirisi" },
            { "hy", metaValue_hy },
            { "ia", "ntirlingua" },
            { "id", "innunisianu" },
            { "ie", "ntirlingui" },
            { "ig", "igbo" },
            { "io", "idu" },
            { "is", "islannisi" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "giavanisi" },
            { "ka", metaValue_ka },
            { "ki", "kikuyu" },
            { "kk", "kazzaku" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ks", "kashmiri" },
            { "ku", "kurmanji" },
            { "kw", "còrnicu" },
            { "ky", "kirghizzu" },
            { "la", metaValue_la },
            { "lb", "lussimmurghisi" },
            { "lg", "ganda" },
            { "ln", "lingala" },
            { "lo", "lau" },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "lèttuni" },
            { "mg", "margasciu" },
            { "mi", "māori" },
            { "mk", "macèduni" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malisi" },
            { "mt", "mautisi" },
            { "my", "burmisi" },
            { "nb", "nurviggisi Bokmål" },
            { "ne", "nipalisi" },
            { "nl", "ulannisi" },
            { "nn", "nurbiggisi Nynorsk" },
            { "no", "nurbiggisi" },
            { "nv", "navajo" },
            { "oc", "uccitanu" },
            { "or", metaValue_or },
            { "pa", "punjabi" },
            { "pl", "pulaccu" },
            { "ps", "pashto" },
            { "pt", "purtughisi" },
            { "qu", "quechua" },
            { "rm", "rumanciu" },
            { "ro", "rumenu" },
            { "ru", "russu" },
            { "rw", "kinyarwanda" },
            { "sa", "sàscritu" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "si", metaValue_si },
            { "sk", "sluvaccu" },
            { "sl", "sluvenu" },
            { "so", "sòmalu" },
            { "sq", "arbanisi" },
            { "sr", "serbu" },
            { "su", metaValue_su },
            { "sv", "svidisi" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tajik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turkmenu" },
            { "to", "tunganu" },
            { "tr", "turcu" },
            { "tt", "tàtaru" },
            { "ug", "uyghur" },
            { "uk", "ucrainu" },
            { "ur", "urdu" },
            { "uz", "uzbeku" },
            { "vi", "vietnamisi" },
            { "vo", "volapük" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "cinisi" },
            { "zu", "zulu" },
            { "agq", "aghem" },
            { "apc", "àrabbu livantinu di tramuntana" },
            { "arn", "mapuche" },
            { "asa", "asu" },
            { "ast", "asturianu" },
            { "bal", "baluchi" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bho", "bhojipuri" },
            { "blo", "anii" },
            { "brx", "bodu" },
            { "bss", "akoose" },
            { "byn", "blin" },
            { "cad", "caddu" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebbuanu" },
            { "cgg", "chiga" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "cic", "chickasaw" },
            { "ckb", "curdu cintrali" },
            { "csw", "swampy cree" },
            { "doi", "dogri" },
            { "dsb", "sòrabbu suttanu" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "ebu", "embu" },
            { "ewo", "ewondo" },
            { "fil", "filippinu" },
            { "frc", "francisi Cajun" },
            { "fur", "friulanu" },
            { "gaa", "ga" },
            { "gez", "geez" },
            { "gsw", "tidiscu sbìzziru" },
            { "guz", "gusii" },
            { "haw", "hawaiianu" },
            { "hnj", "hmong njua" },
            { "hsb", "sòrabbu supranu" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabyle" },
            { "kaj", "jiu" },
            { "kam", "kamba" },
            { "kde", "makonde" },
            { "kea", "capuvirdianu" },
            { "ken", "kenyang" },
            { "kgp", "kaingang" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "ksf", "bafia" },
            { "ksh", "culunisi" },
            { "kxv", "kuvi" },
            { "lag", "langi" },
            { "lij", "lìguri" },
            { "lkt", "lakota" },
            { "lld", "ild" },
            { "lmo", "lummardu" },
            { "lou", "criolu dâ Louisiana" },
            { "ltg", "latgallisi" },
            { "luy", "luyia" },
            { "mai", "maithili" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mer", "meru" },
            { "mfe", "murisianu" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "metaʼ" },
            { "mhn", "muchenu" },
            { "mic", "mi'kmaw" },
            { "mni", "manipuri" },
            { "moh", "mohawk" },
            { "mua", "mundang" },
            { "mul", "assai lingui" },
            { "mus", "muscogee" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "naq", "nama" },
            { "nds", "tidiscu suttanu" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nqo", metaValue_nqo },
            { "nso", "sothu di tramuntana" },
            { "pcm", "pidgin niggirianu" },
            { "prg", "prussianu" },
            { "quc", "kʼicheʼ" },
            { "raj", "rajasthani" },
            { "sah", "yakut" },
            { "sat", "santali" },
            { "scn", "sicilianu" },
            { "ses", "koyraboro senni" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "syr", metaValue_syr },
            { "szl", "silisianu" },
            { "tzm", "tamazight di l’Atlanti Cintrali" },
            { "und", "lingua scanusciuta" },
            { "vec", "vènitu" },
            { "vmw", "makhuwa" },
            { "xnr", "kangri" },
            { "yrl", "nheengatu" },
            { "yue", "cantunisi" },
            { "zxx", "nuḍḍu cuntinutu linguìsticu" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Bali", "balinisi" },
            { "Beng", "bangla" },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sillabbazzioni nurmalizzata di l’abburìggini canadisi" },
            { "Cher", metaValue_chr },
            { "Cyrl", "cirìllicu" },
            { "Deva", "devanagari" },
            { "Ethi", "etìupi" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "Han cu bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "simprificatu" },
            { "Hant", "tradizziunali" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "sillabbari giappunisi" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "lao" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birmanu" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ol chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "tibbitanu" },
            { "Vaii", "vai" },
            { "Yiii", "yi" },
            { "Zmth", "nutazzioni matimàtica" },
            { "Zsye", "emoji" },
            { "Zsym", "sìmmuli" },
            { "Zxxx", "nun scrittu" },
            { "Zyyy", "cumuni" },
            { "Zzzz", "scrittura scanusciuta" },
            { "de_AT", "tidiscu austrìacu" },
            { "de_CH", "tidiscu autu sbìzziru" },
            { "en_AU", "ngrisi australianu" },
            { "en_CA", "ngrisi canadisi" },
            { "en_GB", "ngrisi britànnicu" },
            { "en_US", "ngrisi miricanu" },
            { "es_ES", "spagnolu eurupeu" },
            { "es_MX", "spagnolu missicanu" },
            { "fr_CA", "francisi canadisi" },
            { "fr_CH", "francisi sbìzziru" },
            { "nl_BE", "ciammingu" },
            { "pt_BR", "purtughisi brasilianu" },
            { "pt_PT", "purtughisi eurupeu" },
            { "ro_MD", "murdavu" },
            { "ar_001", "àrabbu nadaru mudernu" },
            { "es_419", "spagnolu dâ mèrica latina" },
            { "key.ca", "Calannariu" },
            { "key.ms", "Sistema di misura" },
            { "key.nu", "Nùmmari" },
            { "nds_NL", "sàssuni suttanu" },
            { "zh_Hans", "cinisi simprificatu" },
            { "zh_Hant", "cinisi tradizziunali" },
            { "type.ca.roc", "Calannariu minguo" },
            { "type.nu.latn", "Nùmmari di Punenti" },
            { "type.ca.dangi", "Calannariu dangi" },
            { "type.ca.coptic", "Calannariu coptu" },
            { "type.ca.hebrew", "Calannariu ebbràicu" },
            { "type.ms.metric", "Sistema mètricu" },
            { "type.ca.chinese", "Calannariu cinisi" },
            { "type.ca.islamic", "Calannariu slàmicu" },
            { "type.ca.iso8601", "Calannariu grigurianu (prima l’annu)" },
            { "type.ca.persian", "Calannariu pirsianu" },
            { "type.ca.buddhist", "Calannariu buddista" },
            { "type.ca.ethiopic", "Calannariu etìupi" },
            { "type.ca.japanese", "Calannariu giappunisi" },
            { "type.co.standard", "Arringu pridifinutu" },
            { "type.ms.uksystem", "Sistema mpiriali" },
            { "type.ms.ussystem", "Sistema miricanu" },
            { "type.ca.gregorian", "Calannariu grigurianu" },
            { "type.ca.islamic-civil", "Calannariu slàmicu civili" },
            { "type.ca.islamic-umalqura", "Calannariu slàmicu Umm Al-Qura" },
            { "type.ca.ethiopic-amete-alem", "Calannariu etìupi Amete-Alem" },
        };
        return data;
    }
}
