/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import java.util.List;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CatalogPage
extends WizardPage
implements IShellProvider {
    protected static final int MINIMUM_HEIGHT = 480;
    private final Catalog catalog;
    private boolean updated;
    private CatalogViewer viewer;

    public CatalogPage(Catalog catalog) {
        super(CatalogPage.class.getSimpleName());
        this.catalog = catalog;
        this.setPageComplete(false);
        this.setTitle(Messages.ConnectorDiscoveryWizardMainPage_connectorDiscovery);
        this.setDescription(Messages.ConnectorDiscoveryWizardMainPage_pageDescription);
    }

    public void createControl(Composite parent) {
        this.viewer = this.doCreateViewer(parent);
        this.viewer.addSelectionChangedListener(event -> this.setPageComplete(!this.viewer.getCheckedItems().isEmpty()));
        this.setControl(this.viewer.getControl());
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        CatalogViewer result = new CatalogViewer(this.getCatalog(), this, (IRunnableContext)this.getContainer(), this.getWizard().getConfiguration());
        result.setMinimumHeight(480);
        result.createControl(parent);
        return result;
    }

    protected CatalogViewer getViewer() {
        return this.viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(() -> {
                if (!this.getControl().isDisposed() && this.isCurrentPage()) {
                    this.viewer.updateCatalog();
                }
            });
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public List<CatalogItem> getInstallableConnectors() {
        return this.viewer.getCheckedItems();
    }

    public DiscoveryWizard getWizard() {
        return (DiscoveryWizard)super.getWizard();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doUpdateCatalog();
        }
    }
}

