/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.e4;

import java.lang.reflect.Field;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.CTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public final class DBeaverCTabFolderRenderer
extends CTabRendering
implements ICTabRendering {
    private static final Log log = Log.getLog(DBeaverCTabFolderRenderer.class);
    private static final Rectangle EMPTY_CLOSE_RECT = new Rectangle(0, 0, 0, 0);
    private static final String PART_SKIP_KEY = DBeaverCTabFolderRenderer.class.getName() + ".skipPart";
    private static final FieldReflection<CTabRendering, Color> selectedTabHighlightColorField = FieldReflection.of(CTabRendering.class, "selectedTabHighlightColor");
    private static final FieldReflection<CTabRendering, Color[]> selectedTabFillColorsField = FieldReflection.of(CTabRendering.class, "selectedTabFillColors");
    private static final FieldReflection<CTabRendering, Color> hotUnselectedTabsColorBackgroundField = FieldReflection.of(CTabRendering.class, "hotUnselectedTabsColorBackground");
    private static final FieldReflection<CTabItem, Integer> closeImageStateField = FieldReflection.of(CTabItem.class, "closeImageState");
    private static final FieldReflection<CTabItem, Rectangle> closeRectField = FieldReflection.of(CTabItem.class, "closeRect");
    private static final FieldReflection<CTabFolderRenderer, Integer> curveWidth = FieldReflection.of(CTabFolderRenderer.class, "curveWidth");
    private static final FieldReflection<CTabFolderRenderer, Integer> curveIndent = FieldReflection.of(CTabFolderRenderer.class, "curveIndent");
    private static volatile boolean isInColor;

    public DBeaverCTabFolderRenderer(@NotNull CTabFolder parent) {
        super(parent);
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        CTabItem item;
        Color color;
        if (part >= 0 && part < this.parent.getItemCount() && (color = DBeaverCTabFolderRenderer.getConnectionColor(item = this.parent.getItem(part))) != null) {
            Color oldHotUnselectedTabsColorBackground = hotUnselectedTabsColorBackgroundField.get(this);
            Color oldSelectedTabHighlightColor = selectedTabHighlightColorField.get(this);
            Color[] oldSelectedTabFillColors = selectedTabFillColorsField.get(this);
            Rectangle oldCloseRect = closeRectField.get(item);
            Integer oldCloseImageState = closeImageStateField.get(item);
            if (oldCloseImageState != null && oldCloseImageState == 8) {
                closeRectField.set(item, EMPTY_CLOSE_RECT);
            }
            boolean paintingHotTab = (state & 0x20) != 0;
            boolean isDarkTheme = UIStyles.isDarkTheme();
            Color fillColor = oldSelectedTabFillColors != null && oldSelectedTabFillColors.length == 1 ? oldSelectedTabFillColors[0] : this.parent.getSelectionBackground();
            Color selectedColor = UIStyles.mix((Color)(isDarkTheme ? UIStyles.lighten((Color)color, (float)0.2f) : color), (Color)fillColor, (float)0.2f);
            hotUnselectedTabsColorBackgroundField.set(this, paintingHotTab ? UIStyles.lighten((Color)color, (float)0.1f) : color);
            selectedTabFillColorsField.set(this, new Color[]{selectedColor});
            selectedTabHighlightColorField.set(this, selectedColor);
            super.draw(part, state | 0x20, bounds, gc);
            closeRectField.set(item, oldCloseRect);
            selectedTabHighlightColorField.set(this, oldSelectedTabHighlightColor);
            selectedTabFillColorsField.set(this, oldSelectedTabFillColors);
            hotUnselectedTabsColorBackgroundField.set(this, oldHotUnselectedTabsColorBackground);
            return;
        }
        super.draw(part, state, bounds, gc);
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        try {
            Rectangle rectangle = super.computeTrim(part, state, x, y, width, height);
            return rectangle;
        }
        finally {
            this.resetCurves();
        }
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        try {
            Point point = super.computeSize(part, state, gc, wHint, hHint);
            return point;
        }
        finally {
            this.resetCurves();
        }
    }

    private void resetCurves() {
        if (RuntimeUtils.isLinux()) {
            curveWidth.set((CTabFolderRenderer)this, 0);
            curveIndent.set((CTabFolderRenderer)this, 0);
        }
    }

    @Nullable
    private static Color getConnectionColor(@NotNull CTabItem item) {
        Object object = item.getData("modelElement");
        if (object instanceof MPart) {
            MPart part = (MPart)object;
            return DBeaverCTabFolderRenderer.getConnectionColor(part);
        }
        CTabFolder control = item.getParent();
        while (control != null) {
            Object object2 = control.getData("modelElement");
            if (object2 instanceof MPart) {
                MPart part = (MPart)object2;
                return DBeaverCTabFolderRenderer.getConnectionColor(part);
            }
            control = control.getParent();
        }
        return null;
    }

    @Nullable
    private static Color getConnectionColor(@NotNull MPart part) {
        if (part.getTransientData().containsKey(PART_SKIP_KEY)) {
            return null;
        }
        if (isInColor) {
            return null;
        }
        isInColor = true;
        try {
            Object object = part.getObject();
            if (object instanceof CompatibilityEditor) {
                CompatibilityEditor editor = (CompatibilityEditor)object;
                Color color = DBeaverCTabFolderRenderer.getConnectionColor(editor.getEditor());
                return color;
            }
            Object v = part.getTransientData().get(IWorkbenchPartReference.class.getName());
            if (v instanceof IEditorReference) {
                IEditorReference ref = (IEditorReference)v;
                IEditorPart editor = ref.getEditor(false);
                if (editor != null) {
                    Color color = DBeaverCTabFolderRenderer.getConnectionColor(editor);
                    return color;
                }
                Color color = DBeaverCTabFolderRenderer.getConnectionColor(ref.getEditorInput());
                return color;
            }
            return null;
        }
        finally {
            isInColor = false;
        }
    }

    @Nullable
    private static Color getConnectionColor(@NotNull IEditorPart editorPart) {
        DBPDataSourceContainerProvider provider;
        DBPDataSourceContainer container;
        if (editorPart instanceof DBPDataSourceContainerProvider && (container = (provider = (DBPDataSourceContainerProvider)editorPart).getDataSourceContainer()) != null) {
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
        }
        return DBeaverCTabFolderRenderer.getConnectionColor(editorPart.getEditorInput());
    }

    @Nullable
    private static Color getConnectionColor(@NotNull IEditorInput editorInput) {
        DBPDataSourceContainer container = EditorUtils.getInputDataSource((IEditorInput)editorInput, (boolean)false);
        if (container != null) {
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
        }
        return null;
    }

    private record FieldReflection<T_CLASS, T_FIELD>(@Nullable Field field) {
        static <T, R> FieldReflection<T, R> of(@NotNull Class<T> declaringClass, @NotNull String fieldName) {
            Field field = null;
            try {
                field = declaringClass.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("Cannot get field '" + fieldName + "' from class " + declaringClass.getName()), (Throwable)e);
            }
            return new FieldReflection(field);
        }

        @Nullable
        T_FIELD get(@NotNull T_CLASS object) {
            if (this.field == null) {
                return null;
            }
            try {
                return (T_FIELD)this.field.get(object);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("Cannot get value of field '" + this.field.getName() + "' from object " + String.valueOf(object)), (Throwable)e);
                return null;
            }
        }

        void set(@NotNull T_CLASS object, @Nullable T_FIELD value) {
            if (this.field == null) {
                return;
            }
            try {
                this.field.set(object, value);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("Cannot set value of field '" + this.field.getName() + "' from object " + String.valueOf(object)), (Throwable)e);
            }
        }
    }
}

