/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.ui.editors.text.handlers.AbstractTextHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TrimTextSpacesHandler
extends AbstractTextHandler {
    private static final Log log = Log.getLog(TrimTextSpacesHandler.class);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        BaseTextEditor textEditor = BaseTextEditor.getTextEditor(HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent));
        if (textEditor != null) {
            ISelection selection;
            ISelectionProvider provider = textEditor.getSelectionProvider();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (provider != null && document != null && (selection = provider.getSelection()) instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                try {
                    if (textSelection.getLength() > 0) {
                        int endLine;
                        int startLine = textSelection.getStartLine();
                        if (startLine != (endLine = textSelection.getEndLine())) {
                            StringBuilder allStrings = new StringBuilder();
                            String lineSeparator = GeneralUtils.getDefaultLineSeparator();
                            int i = startLine;
                            while (i <= endLine) {
                                IRegion lineInformation = document.getLineInformation(i);
                                String untrimmedString = document.get(lineInformation.getOffset(), lineInformation.getLength());
                                allStrings.append(untrimmedString.trim());
                                if (i != endLine) {
                                    allStrings.append(lineSeparator);
                                }
                                ++i;
                            }
                            document.replace(offset, textSelection.getLength(), allStrings.toString());
                        } else {
                            String trimmedSelection = textSelection.getText().trim();
                            if (!CommonUtils.isEmpty((String)trimmedSelection)) {
                                document.replace(offset, textSelection.getLength(), trimmedSelection);
                            }
                        }
                    } else {
                        IRegion information = document.getLineInformationOfOffset(offset);
                        int startLine = information.getOffset();
                        int length = offset - startLine;
                        String untrimmedString = document.get(startLine, length);
                        String trimmedString = untrimmedString.trim();
                        if (!CommonUtils.isEmpty((String)untrimmedString)) {
                            document.replace(startLine, length, trimmedString);
                        }
                    }
                }
                catch (BadLocationException e) {
                    log.error((Object)"Error reading or replacing text when trimming", (Throwable)e);
                }
            }
        }
        return null;
    }
}

