/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class BlockedJobsDialog
extends IconAndMessageDialog {
    protected static BlockedJobsDialog singleton;
    private DetailedProgressViewer viewer;
    private Button cancelSelected;
    private IProgressMonitor blockingMonitor;
    private static final WorkbenchJob dialogJob;

    static {
        dialogJob = new WorkbenchJob(WorkbenchMessages.EventLoopProgressMonitor_OpenDialogJobName){
            {
                this.setSystem(true);
            }

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (singleton == null) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressManagerUtil.rescheduleIfModalShellOpen(this)) {
                    return Status.CANCEL_STATUS;
                }
                singleton.open();
                return Status.OK_STATUS;
            }
        };
    }

    public static BlockedJobsDialog createBlockedDialog(Shell parentShell, IProgressMonitor blockedMonitor, IStatus reason) {
        if (singleton != null) {
            return singleton;
        }
        singleton = new BlockedJobsDialog(parentShell, blockedMonitor, reason);
        if (parentShell == null) {
            dialogJob.schedule(PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        } else {
            singleton.open();
        }
        return singleton;
    }

    public static void clear(IProgressMonitor monitor) {
        if (singleton != null) {
            singleton.close(monitor);
        }
    }

    private BlockedJobsDialog(Shell parentShell, IProgressMonitor blocking, IStatus blockingStatus) {
        super(parentShell == null ? ProgressManagerUtil.getDefaultParent() : parentShell);
        this.blockingMonitor = blocking;
        this.setShellStyle(0x10C30 | BlockedJobsDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
        this.setMessage(blockingStatus.getMessage());
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.message);
        this.createMessageArea(parent);
        this.showJobDetails(parent);
        return parent;
    }

    void showJobDetails(Composite parent) {
        int heightHint;
        this.viewer = new DetailedProgressViewer(parent, 2818);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        ProgressViewerContentProvider provider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = heightHint = this.convertHeightInCharsToPixels(10);
        this.viewer.getControl().setLayoutData((Object)data);
    }

    private ProgressViewerContentProvider getContentProvider() {
        return new ProgressViewerContentProvider(this.viewer, true, false);
    }

    private void clearCursors() {
        this.clearCursor((Control)this.cancelSelected);
        this.clearCursor((Control)this.getShell());
    }

    private void clearCursor(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setCursor(null);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ProgressMessages.BlockedJobsDialog_BlockedTitle);
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.blockingMonitor;
    }

    public boolean close(IProgressMonitor monitor) {
        if (this.blockingMonitor != monitor) {
            return false;
        }
        return this.close();
    }

    public boolean close() {
        singleton = null;
        this.clearCursors();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, ProgressMessages.BlockedJobsDialog_CancelButtonText, false);
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.blockingMonitor.clearBlocked();
        this.blockingMonitor.setCanceled(true);
    }
}

