MACRO(AS_NEEDED name)
  IF(CMAKE_COMPILER_IS_GNUCC AND NOT APPLE)
    TARGET_LINK_LIBRARIES( ${name} PRIVATE "-Wl,--as-needed")
  ENDIF()
ENDMACRO()

MACRO(ADM_ADD_SHARED_LIBRARY name)
  ADD_LIBRARY(${name} SHARED ${ARGN})
  AS_NEEDED(${name})

  IF(UNIX AND NOT APPLE)
    if(NOT ASAN)
      TARGET_LINK_LIBRARIES( ${name} PRIVATE "-Wl,-z,defs")
    ENDIF()
    TARGET_LINK_LIBRARIES( ${name} PRIVATE "stdc++") # for clang
  ENDIF()
ENDMACRO()

MACRO(ADM_TARGET_NO_EXCEPTION  name)
  IF(CMAKE_COMPILER_IS_GNUCC)
    ADD_TARGET_CFLAGS(${name} "-fno-exceptions -fno-rtti")
  ENDIF()
ENDMACRO()
