/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.util.Arrays;
import sun.nio.fs.BsdNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class BsdFileStore
extends UnixFileStore {
    BsdFileStore(UnixPath unixPath) throws IOException {
        super(unixPath);
    }

    BsdFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        super(unixFileSystem, unixMountEntry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        byte[] byArray;
        UnixFileSystem unixFileSystem = this.file().getFileSystem();
        UnixPath unixPath = null;
        try {
            byArray = UnixNativeDispatcher.realpath(this.file());
            unixPath = new UnixPath(unixFileSystem, byArray);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file());
        }
        byArray = null;
        try {
            byArray = BsdNativeDispatcher.getmntonname(unixPath);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
        for (UnixMountEntry unixMountEntry : unixFileSystem.getMountEntries()) {
            if (!Arrays.equals(byArray, unixMountEntry.dir())) continue;
            return unixMountEntry;
        }
        throw new IOException("Mount point not found in fstab");
    }
}

