%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM1": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2": ["0xFDFEFDFEFDFEFDFE", "0xFCFDFCFDFCFDFCFD", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x0202020202020202", "0x0303030303030303", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0xFDFEFDFE00000000", "0x03030303FCFD0000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6": ["0xFDFEFDFEFDFEFDFE", "0xFCFDFCFDFCFDFCFD", "0xFDFEFDFEFDFEFDFE", "0xFCFDFCFDFCFDFCFD"],
    "XMM7": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM8": ["0xFDFEFDFE00000000", "0x03030303FCFD0000", "0xFDFEFDFE00000000", "0x03030303FCFD0000"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx + 32 * 4]

; Test with full zero
vpsignw xmm1, xmm0, [rdx + 32 * 0]
vpsignw ymm5, ymm0, [rdx + 32 * 0]

; Test with full negative
vpsignw xmm2, xmm0, [rdx + 32 * 1]
vpsignw ymm6, ymm0, [rdx + 32 * 1]

; Test with full positive
vpsignw xmm3, xmm0, [rdx + 32 * 2]
vpsignw ymm7, ymm0, [rdx + 32 * 2]

; Test a mix
vpsignw xmm4, xmm0, [rdx + 32 * 3]
vpsignw ymm8, ymm0, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000

dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

dq 0x0001000100010001
dq 0x0001000100010001
dq 0x0001000100010001
dq 0x0001000100010001

dq 0xFFFFFFFF00000000
dq 0x00010001FFFF0000
dq 0xFFFFFFFF00000000
dq 0x00010001FFFF0000

dq 0x0202020202020202
dq 0x0303030303030303
dq 0x0202020202020202
dq 0x0303030303030303
