/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ru extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bax = "бамум";
        final String metaValue_zbl = "блиссимволика";
        final String metaValue_chr = "чероки";
        final String metaValue_gu = "гуджарати";
        final String metaValue_kn = "каннада";
        final String metaValue_kpe = "кпелле";
        final String metaValue_men = "менде";
        final String metaValue_ml = "малаялам";
        final String metaValue_nqo = "нко";
        final String metaValue_or = "ория";
        final String metaValue_te = "телугу";
        final String metaValue_tl = "тагалог";
        final String metaValue_Zsye = "эмодзи";
        final Object[][] data = new Object[][] {
            { "001", "весь мир" },
            { "002", "Африка" },
            { "003", "Северная Америка" },
            { "005", "Южная Америка" },
            { "009", "Океания" },
            { "011", "Западная Африка" },
            { "013", "Центральная Америка" },
            { "014", "Восточная Африка" },
            { "015", "Северная Африка" },
            { "017", "Центральная Африка" },
            { "018", "Южная Африка" },
            { "019", "Америка" },
            { "021", "Североамериканский регион" },
            { "029", "Карибы" },
            { "030", "Восточная Азия" },
            { "034", "Южная Азия" },
            { "035", "Юго-Восточная Азия" },
            { "039", "Южная Европа" },
            { "053", "Австралазия" },
            { "054", "Меланезия" },
            { "057", "Микронезия" },
            { "061", "Полинезия" },
            { "142", "Азия" },
            { "143", "Центральная Азия" },
            { "145", "Западная Азия" },
            { "150", "Европа" },
            { "151", "Восточная Европа" },
            { "154", "Северная Европа" },
            { "155", "Западная Европа" },
            { "202", "Тропическая Африка" },
            { "419", "Латинская Америка" },
            { "AC", "о-в Вознесения" },
            { "AD", "Андорра" },
            { "AE", "ОАЭ" },
            { "AF", "Афганистан" },
            { "AG", "Антигуа и Барбуда" },
            { "AI", "Ангилья" },
            { "AL", "Албания" },
            { "AM", "Армения" },
            { "AO", "Ангола" },
            { "AQ", "Антарктида" },
            { "AR", "Аргентина" },
            { "AS", "Американское Самоа" },
            { "AT", "Австрия" },
            { "AU", "Австралия" },
            { "AW", "Аруба" },
            { "AX", "Аландские о-ва" },
            { "AZ", "Азербайджан" },
            { "BA", "Босния и Герцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельгия" },
            { "BF", "Буркина-Фасо" },
            { "BG", "Болгария" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сен-Бартелеми" },
            { "BM", "Бермудские о-ва" },
            { "BN", "Бруней" },
            { "BO", "Боливия" },
            { "BQ", "Бонэйр, Синт-Эстатиус и Саба" },
            { "BR", "Бразилия" },
            { "BS", "Багамы" },
            { "BT", "Бутан" },
            { "BV", "о-в Буве" },
            { "BW", "Ботсвана" },
            { "BY", "Беларусь" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокосовые о-ва" },
            { "CD", "Конго - Киншаса" },
            { "CF", "Центрально-Африканская Республика" },
            { "CG", "Конго - Браззавиль" },
            { "CH", "Швейцария" },
            { "CI", "Кот-д’Ивуар" },
            { "CK", "о-ва Кука" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Китай" },
            { "CO", "Колумбия" },
            { "CP", "о-в Клиппертон" },
            { "CQ", "Сарк" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "о-в Рождества" },
            { "CY", "Кипр" },
            { "CZ", "Чехия" },
            { "DE", "Германия" },
            { "DG", "Диего-Гарсия" },
            { "DJ", "Джибути" },
            { "DK", "Дания" },
            { "DM", "Доминика" },
            { "DO", "Доминиканская Республика" },
            { "DZ", "Алжир" },
            { "EA", "Сеута и Мелилья" },
            { "EC", "Эквадор" },
            { "EE", "Эстония" },
            { "EG", "Египет" },
            { "EH", "Западная Сахара" },
            { "ER", "Эритрея" },
            { "ES", "Испания" },
            { "ET", "Эфиопия" },
            { "EU", "Европейский союз" },
            { "EZ", "еврозона" },
            { "FI", "Финляндия" },
            { "FJ", "Фиджи" },
            { "FK", "Фолклендские о-ва" },
            { "FM", "Федеративные Штаты Микронезии" },
            { "FO", "Фарерские о-ва" },
            { "FR", "Франция" },
            { "GA", "Габон" },
            { "GB", "Великобритания" },
            { "GD", "Гренада" },
            { "GE", "Грузия" },
            { "GF", "Французская Гвиана" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренландия" },
            { "GM", "Гамбия" },
            { "GN", "Гвинея" },
            { "GP", "Гваделупа" },
            { "GQ", "Экваториальная Гвинея" },
            { "GR", "Греция" },
            { "GS", "Южная Георгия и Южные Сандвичевы о-ва" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинея-Бисау" },
            { "GY", "Гайана" },
            { "HK", "Гонконг (САР)" },
            { "HM", "о-ва Херд и Макдональд" },
            { "HN", "Гондурас" },
            { "HR", "Хорватия" },
            { "HT", "Гаити" },
            { "HU", "Венгрия" },
            { "IC", "Канарские о-ва" },
            { "ID", "Индонезия" },
            { "IE", "Ирландия" },
            { "IL", "Израиль" },
            { "IM", "о-в Мэн" },
            { "IN", "Индия" },
            { "IO", "Британская территория в Индийском океане" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исландия" },
            { "IT", "Италия" },
            { "JE", "Джерси" },
            { "JM", "Ямайка" },
            { "JO", "Иордания" },
            { "JP", "Япония" },
            { "KE", "Кения" },
            { "KG", "Киргизия" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Коморы" },
            { "KN", "Сент-Китс и Невис" },
            { "KP", "КНДР" },
            { "KR", "Республика Корея" },
            { "KW", "Кувейт" },
            { "KY", "о-ва Кайман" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент-Люсия" },
            { "LI", "Лихтенштейн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либерия" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвия" },
            { "LY", "Ливия" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Черногория" },
            { "MF", "Сен-Мартен" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалловы о-ва" },
            { "MK", "Северная Македония" },
            { "ML", "Мали" },
            { "MM", "Мьянма (Бирма)" },
            { "MN", "Монголия" },
            { "MO", "Макао (САР)" },
            { "MP", "Северные Марианские о-ва" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритания" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикий" },
            { "MV", "Мальдивы" },
            { "MW", "Малави" },
            { "MX", "Мексика" },
            { "MY", "Малайзия" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибия" },
            { "NC", "Новая Каледония" },
            { "NE", "Нигер" },
            { "NF", "о-в Норфолк" },
            { "NG", "Нигерия" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерланды" },
            { "NO", "Норвегия" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Новая Зеландия" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Французская Полинезия" },
            { "PG", "Папуа — Новая Гвинея" },
            { "PH", "Филиппины" },
            { "PK", "Пакистан" },
            { "PL", "Польша" },
            { "PM", "Сен-Пьер и Микелон" },
            { "PN", "о-ва Питкэрн" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "Палестинские территории" },
            { "PT", "Португалия" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Внешняя Океания" },
            { "RE", "Реюньон" },
            { "RO", "Румыния" },
            { "RS", "Сербия" },
            { "RU", "Россия" },
            { "RW", "Руанда" },
            { "SA", "Саудовская Аравия" },
            { "SB", "Соломоновы о-ва" },
            { "SC", "Сейшельские о-ва" },
            { "SD", "Судан" },
            { "SE", "Швеция" },
            { "SG", "Сингапур" },
            { "SH", "о-в Св. Елены" },
            { "SI", "Словения" },
            { "SJ", "Шпицберген и Ян-Майен" },
            { "SK", "Словакия" },
            { "SL", "Сьерра-Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Южный Судан" },
            { "ST", "Сан-Томе и Принсипи" },
            { "SV", "Сальвадор" },
            { "SX", "Синт-Мартен" },
            { "SY", "Сирия" },
            { "SZ", "Эсватини" },
            { "TA", "Тристан-да-Кунья" },
            { "TC", "Тёркс и Кайкос" },
            { "TD", "Чад" },
            { "TF", "Французские Южные территории" },
            { "TG", "Того" },
            { "TH", "Таиланд" },
            { "TJ", "Таджикистан" },
            { "TK", "Токелау" },
            { "TL", "Восточный Тимор" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турция" },
            { "TT", "Тринидад и Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзания" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "Внешние малые о-ва (США)" },
            { "UN", "Организация Объединенных Наций" },
            { "US", "Соединенные Штаты" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Винсент и Гренадины" },
            { "VE", "Венесуэла" },
            { "VG", "Виргинские о-ва (Великобритания)" },
            { "VI", "Виргинские о-ва (США)" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис и Футуна" },
            { "WS", "Самоа" },
            { "XA", "псевдоакценты" },
            { "XB", "псевдо-Bidi" },
            { "XK", "Косово" },
            { "YE", "Йемен" },
            { "YT", "Майотта" },
            { "ZA", "Южно-Африканская Республика" },
            { "ZM", "Замбия" },
            { "ZW", "Зимбабве" },
            { "ZZ", "неизвестный регион" },
            { "aa", "афарский" },
            { "ab", "абхазский" },
            { "ae", "авестийский" },
            { "af", "африкаанс" },
            { "ak", "акан" },
            { "am", "амхарский" },
            { "an", "арагонский" },
            { "ar", "арабский" },
            { "as", "ассамский" },
            { "av", "аварский" },
            { "ay", "аймара" },
            { "az", "азербайджанский" },
            { "ba", "башкирский" },
            { "be", "белорусский" },
            { "bg", "болгарский" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгальский" },
            { "bo", "тибетский" },
            { "br", "бретонский" },
            { "bs", "боснийский" },
            { "ca", "каталанский" },
            { "ce", "чеченский" },
            { "ch", "чаморро" },
            { "co", "корсиканский" },
            { "cr", "кри" },
            { "cs", "чешский" },
            { "cu", "церковнославянский" },
            { "cv", "чувашский" },
            { "cy", "валлийский" },
            { "da", "датский" },
            { "de", "немецкий" },
            { "dv", "мальдивский" },
            { "dz", "дзонг-кэ" },
            { "ee", "эве" },
            { "el", "греческий" },
            { "en", "английский" },
            { "eo", "эсперанто" },
            { "es", "испанский" },
            { "et", "эстонский" },
            { "eu", "баскский" },
            { "fa", "персидский" },
            { "ff", "фулах" },
            { "fi", "финский" },
            { "fj", "фиджи" },
            { "fo", "фарерский" },
            { "fr", "французский" },
            { "fy", "западнофризский" },
            { "ga", "ирландский" },
            { "gd", "гэльский" },
            { "gl", "галисийский" },
            { "gn", "гуарани" },
            { "gu", metaValue_gu },
            { "gv", "мэнский" },
            { "ha", "хауса" },
            { "he", "иврит" },
            { "hi", "хинди" },
            { "ho", "хиримоту" },
            { "hr", "хорватский" },
            { "ht", "гаитянский" },
            { "hu", "венгерский" },
            { "hy", "армянский" },
            { "hz", "гереро" },
            { "ia", "интерлингва" },
            { "id", "индонезийский" },
            { "ie", "интерлингве" },
            { "ig", "игбо" },
            { "ii", "носу" },
            { "ik", "инупиак" },
            { "io", "идо" },
            { "is", "исландский" },
            { "it", "итальянский" },
            { "iu", "инуктитут" },
            { "ja", "японский" },
            { "jv", "яванский" },
            { "ka", "грузинский" },
            { "kg", "конго" },
            { "ki", "кикуйю" },
            { "kj", "кунама" },
            { "kk", "казахский" },
            { "kl", "гренландский" },
            { "km", "кхмерский" },
            { "kn", metaValue_kn },
            { "ko", "корейский" },
            { "kr", "канури" },
            { "ks", "кашмири" },
            { "ku", "курманджи" },
            { "kv", "коми" },
            { "kw", "корнский" },
            { "ky", "киргизский" },
            { "la", "латинский" },
            { "lb", "люксембургский" },
            { "lg", "ганда" },
            { "li", "лимбургский" },
            { "ln", "лингала" },
            { "lo", "лаосский" },
            { "lt", "литовский" },
            { "lu", "луба-катанга" },
            { "lv", "латышский" },
            { "mg", "малагасийский" },
            { "mh", "маршалльский" },
            { "mi", "маори" },
            { "mk", "македонский" },
            { "ml", metaValue_ml },
            { "mn", "монгольский" },
            { "mr", "маратхи" },
            { "ms", "малайский" },
            { "mt", "мальтийский" },
            { "my", "бирманский" },
            { "na", "науру" },
            { "nb", "норвежский букмол" },
            { "nd", "северный ндебеле" },
            { "ne", "непальский" },
            { "ng", "ндонга" },
            { "nl", "нидерландский" },
            { "nn", "нюнорск" },
            { "no", "норвежский" },
            { "nr", "южный ндебеле" },
            { "nv", "навахо" },
            { "ny", "ньянджа" },
            { "oc", "окситанский" },
            { "oj", "оджибва" },
            { "om", "оромо" },
            { "or", metaValue_or },
            { "os", "осетинский" },
            { "pa", "панджаби" },
            { "pi", "пали" },
            { "pl", "польский" },
            { "ps", "пушту" },
            { "pt", "португальский" },
            { "qu", "кечуа" },
            { "rm", "романшский" },
            { "rn", "рунди" },
            { "ro", "румынский" },
            { "ru", "русский" },
            { "rw", "киньяруанда" },
            { "sa", "санскрит" },
            { "sc", "сардинский" },
            { "sd", "синдхи" },
            { "se", "северносаамский" },
            { "sg", "санго" },
            { "sh", "сербскохорватский" },
            { "si", "сингальский" },
            { "sk", "словацкий" },
            { "sl", "словенский" },
            { "sm", "самоанский" },
            { "sn", "шона" },
            { "so", "сомали" },
            { "sq", "албанский" },
            { "sr", "сербский" },
            { "ss", "свази" },
            { "st", "южный сото" },
            { "su", "сунданский" },
            { "sv", "шведский" },
            { "sw", "суахили" },
            { "ta", "тамильский" },
            { "te", metaValue_te },
            { "tg", "таджикский" },
            { "th", "тайский" },
            { "ti", "тигринья" },
            { "tk", "туркменский" },
            { "tl", metaValue_tl },
            { "tn", "тсвана" },
            { "to", "тонганский" },
            { "tr", "турецкий" },
            { "ts", "тсонга" },
            { "tt", "татарский" },
            { "tw", "тви" },
            { "ty", "таитянский" },
            { "ug", "уйгурский" },
            { "uk", "украинский" },
            { "ur", "урду" },
            { "uz", "узбекский" },
            { "ve", "венда" },
            { "vi", "вьетнамский" },
            { "vo", "волапюк" },
            { "wa", "валлонский" },
            { "wo", "волоф" },
            { "xh", "коса" },
            { "yi", "идиш" },
            { "yo", "йоруба" },
            { "za", "чжуань" },
            { "zh", "китайский" },
            { "zu", "зулу" },
            { "ace", "ачехский" },
            { "ach", "ачоли" },
            { "ada", "адангме" },
            { "ady", "адыгейский" },
            { "afh", "африхили" },
            { "agq", "агем" },
            { "ain", "айнский" },
            { "akk", "аккадский" },
            { "ale", "алеутский" },
            { "alt", "южноалтайский" },
            { "ang", "староанглийский" },
            { "ann", "оболо" },
            { "anp", "ангика" },
            { "arc", "арамейский" },
            { "arn", "мапуче" },
            { "arp", "арапахо" },
            { "ars", "недждийский арабский" },
            { "arw", "аравакский" },
            { "asa", "асу" },
            { "ast", "астурийский" },
            { "atj", "атикамек" },
            { "awa", "авадхи" },
            { "bal", "белуджский" },
            { "ban", "балийский" },
            { "bas", "баса" },
            { "bax", metaValue_bax },
            { "bbj", "гомала" },
            { "bej", "беджа" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bfd", "бафут" },
            { "bgc", "харианви" },
            { "bgn", "западный белуджский" },
            { "bho", "бходжпури" },
            { "bik", "бикольский" },
            { "bin", "бини" },
            { "bkm", "ком" },
            { "bla", "сиксика" },
            { "blo", "ании" },
            { "bra", "брауи" },
            { "brx", "бодо" },
            { "bss", "акоосе" },
            { "bua", "бурятский" },
            { "bug", "бугийский" },
            { "bum", "булу" },
            { "byn", "билин" },
            { "byv", "медумба" },
            { "cad", "каддо" },
            { "car", "кариб" },
            { "cay", "кайюга" },
            { "cch", "атсам" },
            { "ccp", "чакма" },
            { "ceb", "себуано" },
            { "cgg", "кига" },
            { "chb", "чибча" },
            { "chg", "чагатайский" },
            { "chk", "чукотский" },
            { "chm", "марийский" },
            { "chn", "чинук жаргон" },
            { "cho", "чоктавский" },
            { "chp", "чипевьян" },
            { "chr", metaValue_chr },
            { "chy", "шайенский" },
            { "ckb", "центральнокурдский" },
            { "clc", "чилкотин" },
            { "cop", "коптский" },
            { "crg", "мичиф" },
            { "crh", "крымско-татарский" },
            { "crj", "юго-восточный кри" },
            { "crk", "равнинный кри" },
            { "crl", "северо-восточный кри" },
            { "crm", "мусский кри" },
            { "crr", "каролинский алгонкинский" },
            { "crs", "сейшельский креольский" },
            { "csb", "кашубский" },
            { "csw", "болотный кри" },
            { "dak", "дакота" },
            { "dar", "даргинский" },
            { "dav", "таита" },
            { "del", "делаварский" },
            { "den", "слейви" },
            { "dgr", "догриб" },
            { "din", "динка" },
            { "dje", "джерма" },
            { "doi", "догри" },
            { "dsb", "нижнелужицкий" },
            { "dua", "дуала" },
            { "dum", "средненидерландский" },
            { "dyo", "диола-фоньи" },
            { "dyu", "диула" },
            { "dzg", "даза" },
            { "ebu", "эмбу" },
            { "efi", "эфик" },
            { "egy", "древнеегипетский" },
            { "eka", "экаджук" },
            { "elx", "эламский" },
            { "enm", "среднеанглийский" },
            { "ewo", "эвондо" },
            { "fan", "фанг" },
            { "fat", "фанти" },
            { "fil", "филиппинский" },
            { "fon", "фон" },
            { "frc", "каджунский французский" },
            { "frm", "среднефранцузский" },
            { "fro", "старофранцузский" },
            { "frr", "северный фризский" },
            { "frs", "восточный фризский" },
            { "fur", "фриульский" },
            { "gaa", "га" },
            { "gag", "гагаузский" },
            { "gan", "гань" },
            { "gay", "гайо" },
            { "gba", "гбая" },
            { "gez", "геэз" },
            { "gil", "гилбертский" },
            { "gmh", "средневерхненемецкий" },
            { "goh", "древневерхненемецкий" },
            { "gon", "гонди" },
            { "gor", "горонтало" },
            { "got", "готский" },
            { "grb", "гребо" },
            { "grc", "древнегреческий" },
            { "gsw", "швейцарский немецкий" },
            { "guz", "гусии" },
            { "gwi", "гвичин" },
            { "hai", "хайда" },
            { "hak", "хакка" },
            { "haw", "гавайский" },
            { "hax", "южный хайда" },
            { "hil", "хилигайнон" },
            { "hit", "хеттский" },
            { "hmn", "хмонг" },
            { "hsb", "верхнелужицкий" },
            { "hsn", "сян" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибанский" },
            { "ibb", "ибибио" },
            { "ikt", "восточноканадский инуктитут" },
            { "ilo", "илоко" },
            { "inh", "ингушский" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "еврейско-персидский" },
            { "jrb", "еврейско-арабский" },
            { "kaa", "каракалпакский" },
            { "kab", "кабильский" },
            { "kac", "качинский" },
            { "kaj", "каджи" },
            { "kam", "камба" },
            { "kaw", "кави" },
            { "kbd", "кабардинский" },
            { "kbl", "канембу" },
            { "kcg", "тьяп" },
            { "kde", "маконде" },
            { "kea", "кабувердьяну" },
            { "kfo", "коро" },
            { "kgp", "каинганг" },
            { "kha", "кхаси" },
            { "kho", "хотанский" },
            { "khq", "койра чиини" },
            { "kkj", "како" },
            { "kln", "календжин" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермяцкий" },
            { "kok", "конкани" },
            { "kos", "косраенский" },
            { "kpe", metaValue_kpe },
            { "krc", "карачаево-балкарский" },
            { "krl", "карельский" },
            { "kru", "курух" },
            { "ksb", "шамбала" },
            { "ksf", "бафия" },
            { "ksh", "кёльнский" },
            { "kum", "кумыкский" },
            { "kut", "кутенаи" },
            { "kwk", "квакиутль" },
            { "kxv", "куви" },
            { "lad", "ладино" },
            { "lag", "ланго" },
            { "lah", "лахнда" },
            { "lam", "ламба" },
            { "lez", "лезгинский" },
            { "lij", "лигурский" },
            { "lil", "лиллуэт" },
            { "lkt", "лакота" },
            { "lmo", "ломбардский" },
            { "lol", "монго" },
            { "lou", "луизианский креольский" },
            { "loz", "лози" },
            { "lrc", "севернолурский" },
            { "lsm", "саамиа" },
            { "lua", "луба-лулуа" },
            { "lui", "луисеньо" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мизо" },
            { "luy", "лухья" },
            { "mad", "мадурский" },
            { "maf", "мафа" },
            { "mag", "магахи" },
            { "mai", "майтхили" },
            { "mak", "макассарский" },
            { "man", "мандинго" },
            { "mas", "масаи" },
            { "mde", "маба" },
            { "mdf", "мокшанский" },
            { "mdr", "мандарский" },
            { "men", metaValue_men },
            { "mer", "меру" },
            { "mfe", "маврикийский креольский" },
            { "mga", "среднеирландский" },
            { "mgh", "макуа-меетто" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mnc", "маньчжурский" },
            { "mni", "манипурский" },
            { "moe", "инну-аймун" },
            { "moh", "мохаук" },
            { "mos", "моси" },
            { "mua", "мунданг" },
            { "mul", "языки разных семей" },
            { "mus", "крик" },
            { "mwl", "мирандский" },
            { "mwr", "марвари" },
            { "mye", "миене" },
            { "myv", "эрзянский" },
            { "mzn", "мазандеранский" },
            { "nan", "миньнань" },
            { "nap", "неаполитанский" },
            { "naq", "нама" },
            { "nds", "нижненемецкий" },
            { "new", "неварский" },
            { "nia", "ниас" },
            { "niu", "ниуэ" },
            { "nmg", "квасио" },
            { "nnh", "нгиембунд" },
            { "nog", "ногайский" },
            { "non", "старонорвежский" },
            { "nqo", metaValue_nqo },
            { "nso", "северный сото" },
            { "nus", "нуэр" },
            { "nwc", "классический невари" },
            { "nym", "ньямвези" },
            { "nyn", "ньянколе" },
            { "nyo", "ньоро" },
            { "nzi", "нзима" },
            { "ojb", "северо-западный оджибве" },
            { "ojc", "центральный оджибве" },
            { "ojs", "оджи-кри" },
            { "ojw", "западный оджибве" },
            { "oka", "оканаган" },
            { "osa", "оседжи" },
            { "ota", "старотурецкий" },
            { "pag", "пангасинан" },
            { "pal", "пехлевийский" },
            { "pam", "пампанга" },
            { "pap", "папьяменто" },
            { "pau", "палау" },
            { "pcm", "нигерийско-креольский" },
            { "peo", "староперсидский" },
            { "phn", "финикийский" },
            { "pis", "соломонский пиджин" },
            { "pon", "понапе" },
            { "pqm", "малесит-пассамакводди" },
            { "prg", "прусский" },
            { "pro", "старопровансальский" },
            { "quc", "киче" },
            { "raj", "раджастхани" },
            { "rap", "рапануйский" },
            { "rar", "раротонга" },
            { "rhg", "рохинджа" },
            { "rof", "ромбо" },
            { "rom", "цыганский" },
            { "rup", "арумынский" },
            { "rwk", "руанда" },
            { "sad", "сандаве" },
            { "sah", "саха" },
            { "sam", "самаритянский арамейский" },
            { "saq", "самбуру" },
            { "sas", "сасакский" },
            { "sat", "сантали" },
            { "sba", "нгамбайский" },
            { "sbp", "сангу" },
            { "scn", "сицилийский" },
            { "sco", "шотландский" },
            { "sdh", "южнокурдский" },
            { "see", "сенека" },
            { "seh", "сена" },
            { "sel", "селькупский" },
            { "ses", "койраборо сенни" },
            { "sga", "староирландский" },
            { "shi", "ташельхит" },
            { "shn", "шанский" },
            { "shu", "чадский арабский" },
            { "sid", "сидама" },
            { "slh", "южный лушуцид" },
            { "sma", "южносаамский" },
            { "smj", "луле-саамский" },
            { "smn", "инари-саамский" },
            { "sms", "колтта-саамский" },
            { "snk", "сонинке" },
            { "sog", "согдийский" },
            { "srn", "сранан-тонго" },
            { "srr", "серер" },
            { "ssy", "сахо" },
            { "str", "стрейтс салиш" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "шумерский" },
            { "swb", "коморский" },
            { "syc", "классический сирийский" },
            { "syr", "сирийский" },
            { "szl", "силезский" },
            { "tce", "южный тутчоне" },
            { "tem", "темне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагиш" },
            { "tht", "талтан" },
            { "tig", "тигре" },
            { "tiv", "тиви" },
            { "tkl", "токелайский" },
            { "tlh", "клингонский" },
            { "tli", "тлингит" },
            { "tmh", "тамашек" },
            { "tog", "тонга" },
            { "tok", "токипона" },
            { "tpi", "ток-писин" },
            { "tru", "туройо" },
            { "trv", "седекский" },
            { "tsi", "цимшиан" },
            { "ttm", "северный тутчоне" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тувинский" },
            { "tzm", "среднеатласский тамазигхтский" },
            { "udm", "удмуртский" },
            { "uga", "угаритский" },
            { "umb", "умбунду" },
            { "und", "неизвестный язык" },
            { "vai", "ваи" },
            { "vec", "венецианский" },
            { "vmw", "макуа" },
            { "vot", "водский" },
            { "vun", "вунджо" },
            { "wae", "валлисский" },
            { "wal", "воламо" },
            { "war", "варай" },
            { "was", "вашо" },
            { "wbp", "вальбири" },
            { "wuu", "у" },
            { "xal", "калмыцкий" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yao", "яо" },
            { "yap", "яп" },
            { "yav", "янгбен" },
            { "ybb", "йемба" },
            { "yrl", "ньенгату" },
            { "yue", "кантонский" },
            { "zap", "сапотекский" },
            { "zbl", metaValue_zbl },
            { "zen", "зенагский" },
            { "zgh", "тамазигхтский" },
            { "zun", "зуньи" },
            { "zxx", "нет языкового материала" },
            { "zza", "заза" },
            { "Adlm", "адлам" },
            { "Afak", "афака" },
            { "Arab", "арабица" },
            { "Aran", "насталик" },
            { "Armi", "арамейская" },
            { "Armn", "армянская" },
            { "Avst", "авестийская" },
            { "Bali", "балийская" },
            { "Bamu", metaValue_bax },
            { "Bass", "басса (вах)" },
            { "Batk", "батакская" },
            { "Beng", "бенгальская" },
            { "Blis", metaValue_zbl },
            { "Bopo", "бопомофо" },
            { "Brah", "брахми" },
            { "Brai", "шрифт Брайля" },
            { "Bugi", "бугинизийская" },
            { "Buhd", "бухид" },
            { "Cakm", "чакмийская" },
            { "Cans", "канадское слоговое письмо" },
            { "Cari", "карийская" },
            { "Cham", "чамская" },
            { "Cher", metaValue_chr },
            { "Cirt", "кирт" },
            { "Copt", "коптская" },
            { "Cprt", "кипрская" },
            { "Cyrl", "кириллица" },
            { "Cyrs", "старославянская" },
            { "Deva", "деванагари" },
            { "Dsrt", "дезерет" },
            { "Dupl", "дуплоянская скоропись" },
            { "Egyd", "египетская демотическая" },
            { "Egyh", "египетская иератическая" },
            { "Egyp", "египетская иероглифическая" },
            { "Ethi", "эфиопская" },
            { "Geok", "грузинская хуцури" },
            { "Geor", "грузинская" },
            { "Glag", "глаголица" },
            { "Goth", "готская" },
            { "Gran", "грантха" },
            { "Grek", "греческая" },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмукхи" },
            { "Hanb", "ханьб" },
            { "Hang", "хангыль" },
            { "Hani", "китайская" },
            { "Hano", "хануну" },
            { "Hans", "упрощенная" },
            { "Hant", "традиционная" },
            { "Hebr", "еврейская" },
            { "Hira", "хирагана" },
            { "Hluw", "лувийские иероглифы" },
            { "Hmng", "пахау хмонг" },
            { "Hrkt", "катакана и хирагана" },
            { "Hung", "старовенгерская" },
            { "Inds", "хараппская (письменность долины Инда)" },
            { "Ital", "староитальянская" },
            { "Jamo", "джамо" },
            { "Java", "яванская" },
            { "Jpan", "японская" },
            { "Jurc", "чжурчжэньская" },
            { "Kali", "кайа" },
            { "Kana", "катакана" },
            { "Khar", "кхароштхи" },
            { "Khmr", "кхмерская" },
            { "Khoj", "ходжики" },
            { "Knda", metaValue_kn },
            { "Kore", "корейская" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "кайтхи" },
            { "Lana", "ланна" },
            { "Laoo", "лаосская" },
            { "Latf", "латинская фрактура" },
            { "Latg", "гэльская латинская" },
            { "Latn", "латиница" },
            { "Lepc", "лепха" },
            { "Limb", "лимбу" },
            { "Lina", "линейное письмо А" },
            { "Linb", "линейное письмо Б" },
            { "Lisu", "лису" },
            { "Loma", "лома" },
            { "Lyci", "лициан" },
            { "Lydi", "лидийская" },
            { "Mand", "мандейская" },
            { "Mani", "манихейская" },
            { "Maya", "майя" },
            { "Mend", metaValue_men },
            { "Merc", "мероитская курсивная" },
            { "Mero", "мероитская" },
            { "Mlym", metaValue_ml },
            { "Mong", "монгольская" },
            { "Moon", "азбука муна" },
            { "Mroo", "мро" },
            { "Mtei", "манипури" },
            { "Mymr", "мьянманская" },
            { "Narb", "северноаравийское" },
            { "Nbat", "набатейская" },
            { "Nkgb", "наси геба" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "нюй-шу" },
            { "Ogam", "огамическая" },
            { "Olck", "ол чики" },
            { "Orkh", "орхоно-енисейская" },
            { "Orya", metaValue_or },
            { "Osma", "османская" },
            { "Palm", "пальмиры" },
            { "Perm", "древнепермская" },
            { "Phag", "пагспа" },
            { "Phli", "пехлевийская" },
            { "Phlp", "пахлави псалтирная" },
            { "Phlv", "пахлави книжная" },
            { "Phnx", "финикийская" },
            { "Plrd", "поллардовская фонетика" },
            { "Prti", "парфянская" },
            { "Qaag", "зоджи" },
            { "Rjng", "реджангская" },
            { "Rohg", "ханифи" },
            { "Roro", "ронго-ронго" },
            { "Runr", "руническая" },
            { "Samr", "самаритянская" },
            { "Sara", "сарати" },
            { "Sarb", "староюжноарабская" },
            { "Saur", "саураштра" },
            { "Sgnw", "язык знаков" },
            { "Shaw", "алфавит Шоу" },
            { "Shrd", "шарада" },
            { "Sind", "кхудавади" },
            { "Sinh", "сингальская" },
            { "Sora", "сора-сонпенг" },
            { "Sund", "сунданская" },
            { "Sylo", "силоти нагри" },
            { "Syrc", "сирийская" },
            { "Syre", "сирийская эстрангело" },
            { "Syrj", "западносирийская" },
            { "Syrn", "восточно-сирийская" },
            { "Tagb", "тагбанва" },
            { "Takr", "такри" },
            { "Tale", "тайский ле" },
            { "Talu", "новый тайский ле" },
            { "Taml", "тамильская" },
            { "Tang", "тангутское меня" },
            { "Tavt", "тай-вьет" },
            { "Telu", metaValue_te },
            { "Teng", "тенгварская" },
            { "Tfng", "древнеливийская" },
            { "Tglg", metaValue_tl },
            { "Thaa", "тана" },
            { "Thai", "тайская" },
            { "Tibt", "тибетская" },
            { "Tirh", "тирхута" },
            { "Ugar", "угаритская" },
            { "Vaii", "вайская" },
            { "Visp", "видимая речь" },
            { "Wara", "варанг-кшити" },
            { "Wole", "волеаи" },
            { "Xpeo", "староперсидская" },
            { "Xsux", "шумеро-аккадская клинопись" },
            { "Yiii", "и" },
            { "Zinh", "унаследованная" },
            { "Zmth", "математические обозначения" },
            { "Zsye", metaValue_Zsye },
            { "Zsym", "символы" },
            { "Zxxx", "нет письменности" },
            { "Zyyy", "общепринятая" },
            { "Zzzz", "неизвестная письменность" },
            { "de_AT", "австрийский немецкий" },
            { "de_CH", "литературный швейцарский немецкий" },
            { "en_AU", "австралийский английский" },
            { "en_CA", "канадский английский" },
            { "en_GB", "британский английский" },
            { "en_US", "американский английский" },
            { "es_ES", "европейский испанский" },
            { "es_MX", "мексиканский испанский" },
            { "fa_AF", "дари" },
            { "fr_CA", "канадский французский" },
            { "fr_CH", "швейцарский французский" },
            { "nl_BE", "фламандский" },
            { "pt_BR", "бразильский португальский" },
            { "pt_PT", "европейский португальский" },
            { "ro_MD", "молдавский" },
            { "sw_CD", "конголезский суахили" },
            { "%%1901", "Традиционная немецкая орфография" },
            { "%%1994", "Стандартизированная резьянская орфография" },
            { "%%1996", "Правила немецкой орфографии установленные с 1996 года" },
            { "ar_001", "арабский литературный" },
            { "es_419", "латиноамериканский испанский" },
            { "key.ca", "календарь" },
            { "key.cf", "формат валюты" },
            { "key.co", "порядок сортировки" },
            { "key.cu", "валюта" },
            { "key.em", "представление эмодзи" },
            { "key.hc", "формат времени (12- или 24-часовой)" },
            { "key.lb", "стиль перевода строки" },
            { "key.lw", "стиль переноса слов" },
            { "key.ms", "система мер" },
            { "key.nu", "цифры" },
            { "key.ss", "разрыв предложения после сокращения" },
            { "key.tz", "часовой пояс" },
            { "key.va", "вариант региональных настроек" },
            { "nds_NL", "нижнесаксонский" },
            { "%%KKCOR", "Общая орфография" },
            { "%%POSIX", "Компьютерный" },
            { "%%ROZAJ", "Резьянский" },
            { "%%SAAHO", "Сахо" },
            { "zh_Hans", "китайский, упрощенное письмо" },
            { "zh_Hant", "китайский, традиционное письмо" },
            { "%%FONIPA", "Международный фонетический алфавит" },
            { "%%PINYIN", "Пиньинь" },
            { "%%TARASK", "Тарашкевица" },
            { "%%AREVELA", "Восточно-армянский" },
            { "%%AREVMDA", "Западно-армянский" },
            { "%%MONOTON", "Монотонный" },
            { "%%POLYTON", "Многотональный" },
            { "%%1606NICT", "Поздне-средневековый французский до 1606 г." },
            { "%%BAKU1926", "Унифицированный тюрско-латинский алфавит" },
            { "%%SCOTLAND", "Англо-шотландский" },
            { "%%VALENCIA", "Валенсийский" },
            { "%%WADEGILE", "Система Уэйда – Джайлза" },
            { "type.ca.roc", "календарь Миньго" },
            { "type.co.eor", "европейские правила сортировки" },
            { "type.hc.h11", "12-часовой формат времени (0–11)" },
            { "type.hc.h12", "12-часовой формат времени (1–12)" },
            { "type.hc.h23", "24-часовой формат времени (0–23)" },
            { "type.hc.h24", "24-часовой формат времени (1–24)" },
            { "type.m0.bgn", "система транслитерации BGN" },
            { "type.nu.arab", "арабско-индийские цифры" },
            { "type.nu.armn", "армянские цифры" },
            { "type.nu.bali", "балийские цифры" },
            { "type.nu.beng", "бенгальские цифры" },
            { "type.nu.brah", "цифры брахми" },
            { "type.nu.cakm", "цифры чакма" },
            { "type.nu.cham", "чамские цифры" },
            { "type.nu.deva", "цифры деванагари" },
            { "type.nu.ethi", "эфиопские цифры" },
            { "type.nu.geor", "грузинские цифры" },
            { "type.nu.grek", "греческие цифры" },
            { "type.nu.gujr", "цифры гуджарати" },
            { "type.nu.guru", "цифры гурмукхи" },
            { "type.nu.hans", "китайские упрощенные цифры" },
            { "type.nu.hant", "китайские традиционные цифры" },
            { "type.nu.hebr", "цифры на иврите" },
            { "type.nu.java", "яванские цифры" },
            { "type.nu.jpan", "японские цифры" },
            { "type.nu.kali", "цифры кайя ли" },
            { "type.nu.khmr", "кхмерские цифры" },
            { "type.nu.knda", "цифры каннада" },
            { "type.nu.lana", "цифры тай там хора" },
            { "type.nu.laoo", "лаосские цифры" },
            { "type.nu.latn", "современные арабские цифры" },
            { "type.nu.lepc", "цифры лепча" },
            { "type.nu.limb", "цифры лимбу" },
            { "type.nu.mlym", "цифры малаялам" },
            { "type.nu.mong", "Монгольские цифры" },
            { "type.nu.mtei", "цифры манипури" },
            { "type.nu.mymr", "бирманские цифры" },
            { "type.nu.nkoo", "цифры нко" },
            { "type.nu.olck", "цифры ол-чики" },
            { "type.nu.orya", "цифры ория" },
            { "type.nu.osma", "цифры османья" },
            { "type.nu.saur", "цифры саураштра" },
            { "type.nu.shrd", "цифры шарада" },
            { "type.nu.sora", "цифры сора-сомпенг" },
            { "type.nu.sund", "суданские цифры" },
            { "type.nu.takr", "цифры такри" },
            { "type.nu.talu", "цифры новой тай-лю" },
            { "type.nu.taml", "тамильские традиционные цифры" },
            { "type.nu.telu", "цифры телугу" },
            { "type.nu.thai", "тайские цифры" },
            { "type.nu.tibt", "тибетские цифры" },
            { "type.nu.vaii", "цифры ваи" },
            { "type.ca.dangi", "календарь данги" },
            { "type.co.ducet", "cтандартная сортировка Unicode" },
            { "type.co.emoji", metaValue_Zsye },
            { "type.lb.loose", "мягкий перевод строки" },
            { "type.nu.roman", "римские цифры" },
            { "type.ca.coptic", "коптский календарь" },
            { "type.ca.hebrew", "еврейский календарь" },
            { "type.ca.indian", "Национальный календарь Индии" },
            { "type.co.compat", "совместимый порядок сортировки" },
            { "type.co.pinyin", "пиньинь" },
            { "type.co.search", "поиск" },
            { "type.co.stroke", "по чертам" },
            { "type.co.unihan", "сортировка по ключам, затем по чертам" },
            { "type.co.zhuyin", "чжуинь" },
            { "type.d0.fwidth", "полноширинные символы" },
            { "type.d0.hwidth", "полуширинные символы" },
            { "type.lb.normal", "обычный перевод строки" },
            { "type.lb.strict", "жесткий перевод строки" },
            { "type.m0.ungegn", "система транслитерации ООН" },
            { "type.ms.metric", "метрическая система" },
            { "type.nu.native", "цифры коренных народов" },
            { "type.ca.chinese", "китайский календарь" },
            { "type.ca.islamic", "календарь хиджры" },
            { "type.ca.iso8601", "григорианский (сначала год)" },
            { "type.ca.persian", "персидский календарь" },
            { "type.cf.account", "финансовый формат" },
            { "type.d0.npinyin", "Числовая" },
            { "type.nu.arabext", "расширенная система арабско-индийских цифр" },
            { "type.nu.armnlow", "армянские цифры в нижнем регистре" },
            { "type.nu.finance", "Символы обозначения финансовых показателей" },
            { "type.nu.greklow", "греческие цифры в нижнем регистре" },
            { "type.nu.hanidec", "китайские десятичные цифры" },
            { "type.nu.hansfin", "китайские упрощенные цифры (финансы)" },
            { "type.nu.hantfin", "китайские традиционные цифры (финансы)" },
            { "type.nu.jpanfin", "японские цифры (финансы)" },
            { "type.nu.tamldec", "тамильские цифры" },
            { "type.ca.buddhist", "буддийский календарь" },
            { "type.ca.ethiopic", "эфиопский календарь" },
            { "type.ca.japanese", "японский календарь" },
            { "type.cf.standard", "стандартный формат" },
            { "type.co.phonetic", "фонетический порядок сортировки" },
            { "type.co.searchjl", "Поиск по первой согласной хангыль" },
            { "type.co.standard", "стандартная сортировка" },
            { "type.ms.uksystem", "британская система мер" },
            { "type.ms.ussystem", "американская система мер" },
            { "type.nu.fullwide", "полноширинные цифры" },
            { "type.nu.lanatham", "цифры тай там там" },
            { "type.nu.mymrshan", "бирманские шанские цифры" },
            { "type.nu.romanlow", "римские цифры в нижнем регистре" },
            { "type.ca.gregorian", "григорианский календарь" },
            { "type.co.phonebook", "порядок телефонной книги" },
            { "type.co.dictionary", "словарный порядок сортировки" },
            { "type.co.traditional", "традиционный порядок" },
            { "type.nu.traditional", "Традиционная система нумерации" },
            { "type.ca.islamic-rgsa", "исламский календарь (Саудовская Аравия)" },
            { "type.ca.islamic-tbla", "исламский календарь (табличный, астрономическая эпоха)" },
            { "type.ca.islamic-civil", "гражданский календарь хиджры (табличный)" },
            { "type.ca.islamic-umalqura", "календарь хиджры (Умм аль-Кура)" },
            { "type.ca.ethiopic-amete-alem", "эфиопский календарь амете-алем" },
        };
        return data;
    }
}
