// WARNING: this file was generated by ../scripts/gen-tag-table.py

use crate::Tag;

pub struct LangTag {
    pub language: &'static str,
    pub tag: Tag,
}

pub const OPEN_TYPE_LANGUAGES: &[LangTag] = &[
    LangTag { language: "aa", 	tag: Tag::from_bytes(b"AFR ") }, // Afar
    LangTag { language: "aae", 	tag: Tag::from_bytes(b"SQI ") }, // Arbëreshë Albanian -> Albanian
    LangTag { language: "aao", 	tag: Tag::from_bytes(b"ARA ") }, // Algerian Saharan Arabic -> Arabic
    LangTag { language: "aat", 	tag: Tag::from_bytes(b"SQI ") }, // Arvanitika Albanian -> Albanian
    LangTag { language: "ab", 	tag: Tag::from_bytes(b"ABK ") }, // Abkhazian
    LangTag { language: "abh", 	tag: Tag::from_bytes(b"ARA ") }, // Tajiki Arabic -> Arabic
    LangTag { language: "abq", 	tag: Tag::from_bytes(b"ABA ") }, // Abaza
    LangTag { language: "abv", 	tag: Tag::from_bytes(b"ARA ") }, // Baharna Arabic -> Arabic
    LangTag { language: "acf", 	tag: Tag::from_bytes(b"FAN ") }, // Saint Lucian Creole French -> French Antillean
//  LangTag { language: "ach", 	tag: Tag::from_bytes(b"ACH ") }, // Acoli -> Acholi
    LangTag { language: "acm", 	tag: Tag::from_bytes(b"ARA ") }, // Mesopotamian Arabic -> Arabic
    LangTag { language: "acq", 	tag: Tag::from_bytes(b"ARA ") }, // Ta'izzi-Adeni Arabic -> Arabic
//  LangTag { language: "acr", 	tag: Tag::from_bytes(b"ACR ") }, // Achi
    LangTag { language: "acw", 	tag: Tag::from_bytes(b"ARA ") }, // Hijazi Arabic -> Arabic
    LangTag { language: "acx", 	tag: Tag::from_bytes(b"ARA ") }, // Omani Arabic -> Arabic
    LangTag { language: "acy", 	tag: Tag::from_bytes(b"ARA ") }, // Cypriot Arabic -> Arabic
    LangTag { language: "ada", 	tag: Tag::from_bytes(b"DNG ") }, // Adangme -> Dangme
    LangTag { language: "adf", 	tag: Tag::from_bytes(b"ARA ") }, // Dhofari Arabic -> Arabic
    LangTag { language: "adp", 	tag: Tag::from_bytes(b"DZN ") }, // Adap(retired code) -> Dzongkha
//  LangTag { language: "ady", 	tag: Tag::from_bytes(b"ADY ") }, // Adyghe
    LangTag { language: "aeb", 	tag: Tag::from_bytes(b"ARA ") }, // Tunisian Arabic -> Arabic
    LangTag { language: "aec", 	tag: Tag::from_bytes(b"ARA ") }, // Saidi Arabic -> Arabic
    LangTag { language: "af", 	tag: Tag::from_bytes(b"AFK ") }, // Afrikaans
    LangTag { language: "afb", 	tag: Tag::from_bytes(b"ARA ") }, // Gulf Arabic -> Arabic
    LangTag { language: "ahg", 	tag: Tag::from_bytes(b"AGW ") }, // Qimant -> Agaw
    LangTag { language: "aht", 	tag: Tag::from_bytes(b"ATH ") }, // Ahtena -> Athapaskan
    LangTag { language: "aii", 	tag: Tag::from_bytes(b"SWA ") }, // Assyrian Neo-Aramaic -> Swadaya Aramaic
    LangTag { language: "aii", 	tag: Tag::from_bytes(b"SYR ") }, // Assyrian Neo-Aramaic -> Syriac
//  LangTag { language: "aio", 	tag: Tag::from_bytes(b"AIO ") }, // Aiton
    LangTag { language: "aiw", 	tag: Tag::from_bytes(b"ARI ") }, // Aari
    LangTag { language: "ajp", 	tag: Tag::from_bytes(b"ARA ") }, // South Levantine Arabic -> Arabic
    LangTag { language: "ak", 	tag: Tag::from_bytes(b"AKA ") }, // Akan [macrolanguage]
    LangTag { language: "ak", 	tag: Tag::from_bytes(b"TWI ") }, // Akan [macrolanguage] -> Twi
    LangTag { language: "aln", 	tag: Tag::from_bytes(b"SQI ") }, // Gheg Albanian -> Albanian
    LangTag { language: "als", 	tag: Tag::from_bytes(b"SQI ") }, // Tosk Albanian -> Albanian
//  LangTag { language: "alt", 	tag: Tag::from_bytes(b"ALT ") }, // Southern Altai -> Altai
    LangTag { language: "am", 	tag: Tag::from_bytes(b"AMH ") }, // Amharic
    LangTag { language: "amf", 	tag: Tag::from_bytes(b"HBN ") }, // Hamer-Banna -> Hammer-Banna
    LangTag { language: "amw", 	tag: Tag::from_bytes(b"SYR ") }, // Western Neo-Aramaic -> Syriac
    LangTag { language: "an", 	tag: Tag::from_bytes(b"ARG ") }, // Aragonese
//  LangTag { language: "ang", 	tag: Tag::from_bytes(b"ANG ") }, // Old English (ca. 450-1100) -> Anglo-Saxon
    LangTag { language: "apc", 	tag: Tag::from_bytes(b"ARA ") }, // North Levantine Arabic -> Arabic
    LangTag { language: "apd", 	tag: Tag::from_bytes(b"ARA ") }, // Sudanese Arabic -> Arabic
    LangTag { language: "apj", 	tag: Tag::from_bytes(b"ATH ") }, // Jicarilla Apache -> Athapaskan
    LangTag { language: "apk", 	tag: Tag::from_bytes(b"ATH ") }, // Kiowa Apache -> Athapaskan
    LangTag { language: "apl", 	tag: Tag::from_bytes(b"ATH ") }, // Lipan Apache -> Athapaskan
    LangTag { language: "apm", 	tag: Tag::from_bytes(b"ATH ") }, // Mescalero-Chiricahua Apache -> Athapaskan
    LangTag { language: "apw", 	tag: Tag::from_bytes(b"ATH ") }, // Western Apache -> Athapaskan
    LangTag { language: "ar", 	tag: Tag::from_bytes(b"ARA ") }, // Arabic [macrolanguage]
    LangTag { language: "arb", 	tag: Tag::from_bytes(b"ARA ") }, // Standard Arabic -> Arabic
    LangTag { language: "arn", 	tag: Tag::from_bytes(b"MAP ") }, // Mapudungun
    LangTag { language: "arq", 	tag: Tag::from_bytes(b"ARA ") }, // Algerian Arabic -> Arabic
    LangTag { language: "ars", 	tag: Tag::from_bytes(b"ARA ") }, // Najdi Arabic -> Arabic
    LangTag { language: "ary", 	tag: Tag::from_bytes(b"MOR ") }, // Moroccan Arabic -> Moroccan
    LangTag { language: "arz", 	tag: Tag::from_bytes(b"ARA ") }, // Egyptian Arabic -> Arabic
    LangTag { language: "as", 	tag: Tag::from_bytes(b"ASM ") }, // Assamese
//  LangTag { language: "ast", 	tag: Tag::from_bytes(b"AST ") }, // Asturian
//  LangTag { language: "ath", 	tag: Tag::from_bytes(b"ATH ") }, // Athapascan  [family] -> Athapaskan
    LangTag { language: "atj", 	tag: Tag::from_bytes(b"RCR ") }, // Atikamekw -> R-Cree
    LangTag { language: "atv", 	tag: Tag::from_bytes(b"ALT ") }, // Northern Altai -> Altai
    LangTag { language: "auz", 	tag: Tag::from_bytes(b"ARA ") }, // Uzbeki Arabic -> Arabic
    LangTag { language: "av", 	tag: Tag::from_bytes(b"AVR ") }, // Avaric -> Avar
    LangTag { language: "avl", 	tag: Tag::from_bytes(b"ARA ") }, // Eastern Egyptian Bedawi Arabic -> Arabic
//  LangTag { language: "awa", 	tag: Tag::from_bytes(b"AWA ") }, // Awadhi
    LangTag { language: "ay", 	tag: Tag::from_bytes(b"AYM ") }, // Aymara [macrolanguage]
    LangTag { language: "ayc", 	tag: Tag::from_bytes(b"AYM ") }, // Southern Aymara -> Aymara
    LangTag { language: "ayh", 	tag: Tag::from_bytes(b"ARA ") }, // Hadrami Arabic -> Arabic
    LangTag { language: "ayl", 	tag: Tag::from_bytes(b"ARA ") }, // Libyan Arabic -> Arabic
    LangTag { language: "ayn", 	tag: Tag::from_bytes(b"ARA ") }, // Sanaani Arabic -> Arabic
    LangTag { language: "ayp", 	tag: Tag::from_bytes(b"ARA ") }, // North Mesopotamian Arabic -> Arabic
    LangTag { language: "ayr", 	tag: Tag::from_bytes(b"AYM ") }, // Central Aymara -> Aymara
    LangTag { language: "az", 	tag: Tag::from_bytes(b"AZE ") }, // Azerbaijani [macrolanguage]
//  LangTag { language: "azb", 	tag: Tag::from_bytes(b"AZB ") }, // South Azerbaijani -> Torki
    LangTag { language: "azj", 	tag: Tag::from_bytes(b"AZE ") }, // North Azerbaijani -> Azerbaijani
    LangTag { language: "ba", 	tag: Tag::from_bytes(b"BSH ") }, // Bashkir
    LangTag { language: "bad", 	tag: Tag::from_bytes(b"BAD0") }, // Banda  [family]
    LangTag { language: "bai", 	tag: Tag::from_bytes(b"BML ") }, // Bamileke  [family]
    LangTag { language: "bal", 	tag: Tag::from_bytes(b"BLI ") }, // Baluchi [macrolanguage]
//  LangTag { language: "ban", 	tag: Tag::from_bytes(b"BAN ") }, // Balinese
//  LangTag { language: "bar", 	tag: Tag::from_bytes(b"BAR ") }, // Bavarian
//  LangTag { language: "bbc", 	tag: Tag::from_bytes(b"BBC ") }, // Batak Toba
    LangTag { language: "bbz", 	tag: Tag::from_bytes(b"ARA ") }, // Babalia Creole Arabic -> Arabic
    LangTag { language: "bcc", 	tag: Tag::from_bytes(b"BLI ") }, // Southern Balochi -> Baluchi
    LangTag { language: "bci", 	tag: Tag::from_bytes(b"BAU ") }, // Baoulé -> Baulé
    LangTag { language: "bcl", 	tag: Tag::from_bytes(b"BIK ") }, // Central Bikol -> Bikol
    LangTag { language: "bcq", 	tag: Tag::from_bytes(b"BCH ") }, // Bench
    LangTag { language: "bcr", 	tag: Tag::from_bytes(b"ATH ") }, // Babine -> Athapaskan
//  LangTag { language: "bdy", 	tag: Tag::from_bytes(b"BDY ") }, // Bandjalang
    LangTag { language: "be", 	tag: Tag::from_bytes(b"BEL ") }, // Belarusian -> Belarussian
    LangTag { language: "bea", 	tag: Tag::from_bytes(b"ATH ") }, // Beaver -> Athapaskan
    LangTag { language: "beb", 	tag: Tag::from_bytes(b"BTI ") }, // Bebele -> Beti
//  LangTag { language: "bem", 	tag: Tag::from_bytes(b"BEM ") }, // Bemba (Zambia)
    LangTag { language: "ber", 	tag: Tag::from_bytes(b"BBR ") }, // Berber  [family]
    LangTag { language: "bfq", 	tag: Tag::from_bytes(b"BAD ") }, // Badaga
    LangTag { language: "bft", 	tag: Tag::from_bytes(b"BLT ") }, // Balti
    LangTag { language: "bfu", 	tag: Tag::from_bytes(b"LAH ") }, // Gahri -> Lahuli
    LangTag { language: "bfy", 	tag: Tag::from_bytes(b"BAG ") }, // Bagheli -> Baghelkhandi
    LangTag { language: "bg", 	tag: Tag::from_bytes(b"BGR ") }, // Bulgarian
//  LangTag { language: "bgc", 	tag: Tag::from_bytes(b"BGC ") }, // Haryanvi
    LangTag { language: "bgn", 	tag: Tag::from_bytes(b"BLI ") }, // Western Balochi -> Baluchi
    LangTag { language: "bgp", 	tag: Tag::from_bytes(b"BLI ") }, // Eastern Balochi -> Baluchi
//  LangTag { language: "bgq", 	tag: Tag::from_bytes(b"BGQ ") }, // Bagri
    LangTag { language: "bgr", 	tag: Tag::from_bytes(b"QIN ") }, // Bawm Chin -> Chin
    LangTag { language: "bhb", 	tag: Tag::from_bytes(b"BHI ") }, // Bhili
//  LangTag { language: "bhi", 	tag: Tag::from_bytes(b"BHI ") }, // Bhilali -> Bhili
    LangTag { language: "bhk", 	tag: Tag::from_bytes(b"BIK ") }, // Albay Bicolano(retired code) -> Bikol
//  LangTag { language: "bho", 	tag: Tag::from_bytes(b"BHO ") }, // Bhojpuri
    LangTag { language: "bhr", 	tag: Tag::from_bytes(b"MLG ") }, // Bara Malagasy -> Malagasy
    LangTag { language: "bi", 	tag: Tag::from_bytes(b"BIS ") }, // Bislama
//  LangTag { language: "bik", 	tag: Tag::from_bytes(b"BIK ") }, // Bikol [macrolanguage]
    LangTag { language: "bin", 	tag: Tag::from_bytes(b"EDO ") }, // Edo
//  LangTag { language: "bjj", 	tag: Tag::from_bytes(b"BJJ ") }, // Kanauji
    LangTag { language: "bjn", 	tag: Tag::from_bytes(b"MLY ") }, // Banjar -> Malay
    LangTag { language: "bjq", 	tag: Tag::from_bytes(b"MLG ") }, // Southern Betsimisaraka Malagasy(retired code) -> Malagasy
    LangTag { language: "bjt", 	tag: Tag::from_bytes(b"BLN ") }, // Balanta-Ganja -> Balante
    LangTag { language: "bla", 	tag: Tag::from_bytes(b"BKF ") }, // Siksika -> Blackfoot
    LangTag { language: "ble", 	tag: Tag::from_bytes(b"BLN ") }, // Balanta-Kentohe -> Balante
//  LangTag { language: "blk", 	tag: Tag::from_bytes(b"BLK ") }, // Pa’o Karen
    LangTag { language: "bln", 	tag: Tag::from_bytes(b"BIK ") }, // Southern Catanduanes Bikol -> Bikol
    LangTag { language: "bm", 	tag: Tag::from_bytes(b"BMB ") }, // Bambara (Bamanankan)
    LangTag { language: "bmm", 	tag: Tag::from_bytes(b"MLG ") }, // Northern Betsimisaraka Malagasy -> Malagasy
    LangTag { language: "bn", 	tag: Tag::from_bytes(b"BEN ") }, // Bengali
    LangTag { language: "bo", 	tag: Tag::from_bytes(b"TIB ") }, // Tibetan
//  LangTag { language: "bpy", 	tag: Tag::from_bytes(b"BPY ") }, // Bishnupriya -> Bishnupriya Manipuri
    LangTag { language: "bqi", 	tag: Tag::from_bytes(b"LRC ") }, // Bakhtiari -> Luri
    LangTag { language: "br", 	tag: Tag::from_bytes(b"BRE ") }, // Breton
    LangTag { language: "bra", 	tag: Tag::from_bytes(b"BRI ") }, // Braj -> Braj Bhasha
//  LangTag { language: "brh", 	tag: Tag::from_bytes(b"BRH ") }, // Brahui
//  LangTag { language: "brx", 	tag: Tag::from_bytes(b"BRX ") }, // Bodo (India)
    LangTag { language: "bs", 	tag: Tag::from_bytes(b"BOS ") }, // Bosnian
//  LangTag { language: "bsk", 	tag: Tag::from_bytes(b"BSK ") }, // Burushaski
    LangTag { language: "btb", 	tag: Tag::from_bytes(b"BTI ") }, // Beti (Cameroon)(retired code)
    LangTag { language: "btj", 	tag: Tag::from_bytes(b"MLY ") }, // Bacanese Malay -> Malay
    LangTag { language: "bto", 	tag: Tag::from_bytes(b"BIK ") }, // Rinconada Bikol -> Bikol
//  LangTag { language: "bts", 	tag: Tag::from_bytes(b"BTS ") }, // Batak Simalungun
//  LangTag { language: "bug", 	tag: Tag::from_bytes(b"BUG ") }, // Buginese -> Bugis
    LangTag { language: "bum", 	tag: Tag::from_bytes(b"BTI ") }, // Bulu (Cameroon) -> Beti
    LangTag { language: "bve", 	tag: Tag::from_bytes(b"MLY ") }, // Berau Malay -> Malay
    LangTag { language: "bvu", 	tag: Tag::from_bytes(b"MLY ") }, // Bukit Malay -> Malay
    LangTag { language: "bxk", 	tag: Tag::from_bytes(b"LUH ") }, // Bukusu -> Luyia
    LangTag { language: "bxp", 	tag: Tag::from_bytes(b"BTI ") }, // Bebil -> Beti
    LangTag { language: "bxr", 	tag: Tag::from_bytes(b"RBU ") }, // Russia Buriat -> Russian Buriat
    LangTag { language: "byn", 	tag: Tag::from_bytes(b"BIL ") }, // Bilin -> Bilen
//  LangTag { language: "byv", 	tag: Tag::from_bytes(b"BYV ") }, // Medumba
    LangTag { language: "bzc", 	tag: Tag::from_bytes(b"MLG ") }, // Southern Betsimisaraka Malagasy -> Malagasy
    LangTag { language: "ca", 	tag: Tag::from_bytes(b"CAT ") }, // Catalan
    LangTag { language: "caf", 	tag: Tag::from_bytes(b"CRR ") }, // Southern Carrier -> Carrier
    LangTag { language: "caf", 	tag: Tag::from_bytes(b"ATH ") }, // Southern Carrier -> Athapaskan
//  LangTag { language: "cak", 	tag: Tag::from_bytes(b"CAK ") }, // Kaqchikel
//  LangTag { language: "cbk", 	tag: Tag::from_bytes(b"CBK ") }, // Chavacano -> Zamboanga Chavacano
    LangTag { language: "cbl", 	tag: Tag::from_bytes(b"QIN ") }, // Bualkhaw Chin -> Chin
    LangTag { language: "cco", 	tag: Tag::from_bytes(b"CCHN") }, // Comaltepec Chinantec -> Chinantec
    LangTag { language: "ccq", 	tag: Tag::from_bytes(b"ARK ") }, // Chaungtha(retired code) -> Rakhine
    LangTag { language: "cdo", 	tag: Tag::from_bytes(b"ZHS ") }, // Min Dong Chinese -> Chinese Simplified
    LangTag { language: "ce", 	tag: Tag::from_bytes(b"CHE ") }, // Chechen
//  LangTag { language: "ceb", 	tag: Tag::from_bytes(b"CEB ") }, // Cebuano
    LangTag { language: "cfm", 	tag: Tag::from_bytes(b"HAL ") }, // Halam (Falam Chin)
//  LangTag { language: "cgg", 	tag: Tag::from_bytes(b"CGG ") }, // Chiga
    LangTag { language: "ch", 	tag: Tag::from_bytes(b"CHA ") }, // Chamorro
    LangTag { language: "chj", 	tag: Tag::from_bytes(b"CCHN") }, // Ojitlán Chinantec -> Chinantec
    LangTag { language: "chk", 	tag: Tag::from_bytes(b"CHK0") }, // Chuukese
//  LangTag { language: "cho", 	tag: Tag::from_bytes(b"CHO ") }, // Choctaw
    LangTag { language: "chp", 	tag: Tag::from_bytes(b"CHP ") }, // Chipewyan
    LangTag { language: "chp", 	tag: Tag::from_bytes(b"SAY ") }, // Chipewyan -> Sayisi
    LangTag { language: "chp", 	tag: Tag::from_bytes(b"ATH ") }, // Chipewyan -> Athapaskan
    LangTag { language: "chq", 	tag: Tag::from_bytes(b"CCHN") }, // Quiotepec Chinantec -> Chinantec
//  LangTag { language: "chr", 	tag: Tag::from_bytes(b"CHR ") }, // Cherokee
//  LangTag { language: "chy", 	tag: Tag::from_bytes(b"CHY ") }, // Cheyenne
    LangTag { language: "chz", 	tag: Tag::from_bytes(b"CCHN") }, // Ozumacín Chinantec -> Chinantec
    LangTag { language: "ciw", 	tag: Tag::from_bytes(b"OJB ") }, // Chippewa -> Ojibway
//  LangTag { language: "cja", 	tag: Tag::from_bytes(b"CJA ") }, // Western Cham
//  LangTag { language: "cjm", 	tag: Tag::from_bytes(b"CJM ") }, // Eastern Cham
    LangTag { language: "cjy", 	tag: Tag::from_bytes(b"ZHS ") }, // Jinyu Chinese -> Chinese Simplified
    LangTag { language: "cka", 	tag: Tag::from_bytes(b"QIN ") }, // Khumi Awa Chin(retired code) -> Chin
    LangTag { language: "ckb", 	tag: Tag::from_bytes(b"KUR ") }, // Central Kurdish -> Kurdish
    LangTag { language: "ckt", 	tag: Tag::from_bytes(b"CHK ") }, // Chukot -> Chukchi
    LangTag { language: "clc", 	tag: Tag::from_bytes(b"ATH ") }, // Chilcotin -> Athapaskan
    LangTag { language: "cld", 	tag: Tag::from_bytes(b"SYR ") }, // Chaldean Neo-Aramaic -> Syriac
    LangTag { language: "cle", 	tag: Tag::from_bytes(b"CCHN") }, // Lealao Chinantec -> Chinantec
    LangTag { language: "cmn", 	tag: Tag::from_bytes(b"ZHS ") }, // Mandarin Chinese -> Chinese Simplified
    LangTag { language: "cmr", 	tag: Tag::from_bytes(b"QIN ") }, // Mro-Khimi Chin -> Chin
    LangTag { language: "cnb", 	tag: Tag::from_bytes(b"QIN ") }, // Chinbon Chin -> Chin
    LangTag { language: "cnh", 	tag: Tag::from_bytes(b"QIN ") }, // Hakha Chin -> Chin
    LangTag { language: "cnk", 	tag: Tag::from_bytes(b"QIN ") }, // Khumi Chin -> Chin
    LangTag { language: "cnl", 	tag: Tag::from_bytes(b"CCHN") }, // Lalana Chinantec -> Chinantec
    LangTag { language: "cnt", 	tag: Tag::from_bytes(b"CCHN") }, // Tepetotutla Chinantec -> Chinantec
    LangTag { language: "cnw", 	tag: Tag::from_bytes(b"QIN ") }, // Ngawn Chin -> Chin
    LangTag { language: "co", 	tag: Tag::from_bytes(b"COS ") }, // Corsican
    LangTag { language: "coa", 	tag: Tag::from_bytes(b"MLY ") }, // Cocos Islands Malay -> Malay
//  LangTag { language: "cop", 	tag: Tag::from_bytes(b"COP ") }, // Coptic
    LangTag { language: "coq", 	tag: Tag::from_bytes(b"ATH ") }, // Coquille -> Athapaskan
    LangTag { language: "cpa", 	tag: Tag::from_bytes(b"CCHN") }, // Palantla Chinantec -> Chinantec
    LangTag { language: "cpe", 	tag: Tag::from_bytes(b"CPP ") }, // English-based creoles and pidgins [family] -> Creoles
    LangTag { language: "cpf", 	tag: Tag::from_bytes(b"CPP ") }, // French-based creoles and pidgins [family] -> Creoles
//  LangTag { language: "cpp", 	tag: Tag::from_bytes(b"CPP ") }, // Portuguese-based creoles and pidgins [family] -> Creoles
    LangTag { language: "cpx", 	tag: Tag::from_bytes(b"ZHS ") }, // Pu-Xian Chinese -> Chinese Simplified
    LangTag { language: "cqd", 	tag: Tag::from_bytes(b"HMN ") }, // Chuanqiandian Cluster Miao -> Hmong
    LangTag { language: "cqu", 	tag: Tag::from_bytes(b"QUH ") }, // Chilean Quechua(retired code) -> Quechua (Bolivia)
    LangTag { language: "cr", 	tag: Tag::from_bytes(b"CRE ") }, // Cree [macrolanguage]
    LangTag { language: "cr", 	tag: Tag::from_bytes(b"YCR ") }, // Cree [macrolanguage] -> Y-Cree
    LangTag { language: "crh", 	tag: Tag::from_bytes(b"CRT ") }, // Crimean Tatar
    LangTag { language: "crj", 	tag: Tag::from_bytes(b"ECR ") }, // Southern East Cree -> Eastern Cree
    LangTag { language: "crk", 	tag: Tag::from_bytes(b"WCR ") }, // Plains Cree -> West-Cree
    LangTag { language: "crl", 	tag: Tag::from_bytes(b"ECR ") }, // Northern East Cree -> Eastern Cree
    LangTag { language: "crm", 	tag: Tag::from_bytes(b"MCR ") }, // Moose Cree
    LangTag { language: "crm", 	tag: Tag::from_bytes(b"LCR ") }, // Moose Cree -> L-Cree
    LangTag { language: "crp", 	tag: Tag::from_bytes(b"CPP ") }, // Creoles and pidgins [family] -> Creoles
    LangTag { language: "crx", 	tag: Tag::from_bytes(b"CRR ") }, // Carrier
    LangTag { language: "crx", 	tag: Tag::from_bytes(b"ATH ") }, // Carrier -> Athapaskan
    LangTag { language: "cs", 	tag: Tag::from_bytes(b"CSY ") }, // Czech
    LangTag { language: "csa", 	tag: Tag::from_bytes(b"CCHN") }, // Chiltepec Chinantec -> Chinantec
//  LangTag { language: "csb", 	tag: Tag::from_bytes(b"CSB ") }, // Kashubian
    LangTag { language: "csh", 	tag: Tag::from_bytes(b"QIN ") }, // Asho Chin -> Chin
    LangTag { language: "cso", 	tag: Tag::from_bytes(b"CCHN") }, // Sochiapam Chinantec -> Chinantec
    LangTag { language: "csw", 	tag: Tag::from_bytes(b"NCR ") }, // Swampy Cree -> N-Cree
    LangTag { language: "csw", 	tag: Tag::from_bytes(b"NHC ") }, // Swampy Cree -> Norway House Cree
    LangTag { language: "csy", 	tag: Tag::from_bytes(b"QIN ") }, // Siyin Chin -> Chin
    LangTag { language: "ctc", 	tag: Tag::from_bytes(b"ATH ") }, // Chetco -> Athapaskan
    LangTag { language: "ctd", 	tag: Tag::from_bytes(b"QIN ") }, // Tedim Chin -> Chin
    LangTag { language: "cte", 	tag: Tag::from_bytes(b"CCHN") }, // Tepinapa Chinantec -> Chinantec
//  LangTag { language: "ctg", 	tag: Tag::from_bytes(b"CTG ") }, // Chittagonian
    LangTag { language: "ctl", 	tag: Tag::from_bytes(b"CCHN") }, // Tlacoatzintepec Chinantec -> Chinantec
    LangTag { language: "cts", 	tag: Tag::from_bytes(b"BIK ") }, // Northern Catanduanes Bikol -> Bikol
    LangTag { language: "cu", 	tag: Tag::from_bytes(b"CSL ") }, // Church Slavonic
    LangTag { language: "cuc", 	tag: Tag::from_bytes(b"CCHN") }, // Usila Chinantec -> Chinantec
//  LangTag { language: "cuk", 	tag: Tag::from_bytes(b"CUK ") }, // San Blas Kuna
    LangTag { language: "cv", 	tag: Tag::from_bytes(b"CHU ") }, // Chuvash
    LangTag { language: "cvn", 	tag: Tag::from_bytes(b"CCHN") }, // Valle Nacional Chinantec -> Chinantec
    LangTag { language: "cwd", 	tag: Tag::from_bytes(b"DCR ") }, // Woods Cree
    LangTag { language: "cwd", 	tag: Tag::from_bytes(b"TCR ") }, // Woods Cree -> TH-Cree
    LangTag { language: "cy", 	tag: Tag::from_bytes(b"WEL ") }, // Welsh
    LangTag { language: "czh", 	tag: Tag::from_bytes(b"ZHS ") }, // Huizhou Chinese -> Chinese Simplified
    LangTag { language: "czo", 	tag: Tag::from_bytes(b"ZHS ") }, // Min Zhong Chinese -> Chinese Simplified
    LangTag { language: "czt", 	tag: Tag::from_bytes(b"QIN ") }, // Zotung Chin -> Chin
    LangTag { language: "da", 	tag: Tag::from_bytes(b"DAN ") }, // Danish
    LangTag { language: "dao", 	tag: Tag::from_bytes(b"QIN ") }, // Daai Chin -> Chin
    LangTag { language: "dap", 	tag: Tag::from_bytes(b"NIS ") }, // Nisi (India)(retired code)
//  LangTag { language: "dar", 	tag: Tag::from_bytes(b"DAR ") }, // Dargwa
//  LangTag { language: "dax", 	tag: Tag::from_bytes(b"DAX ") }, // Dayi
    LangTag { language: "de", 	tag: Tag::from_bytes(b"DEU ") }, // German
    LangTag { language: "den", 	tag: Tag::from_bytes(b"SLA ") }, // Slave (Athapascan) [macrolanguage] -> Slavey
    LangTag { language: "den", 	tag: Tag::from_bytes(b"ATH ") }, // Slave (Athapascan) [macrolanguage] -> Athapaskan
//  LangTag { language: "dgo", 	tag: Tag::from_bytes(b"DGO ") }, // Dogri
    LangTag { language: "dgr", 	tag: Tag::from_bytes(b"ATH ") }, // Dogrib -> Athapaskan
    LangTag { language: "dhd", 	tag: Tag::from_bytes(b"MAW ") }, // Dhundari -> Marwari
//  LangTag { language: "dhg", 	tag: Tag::from_bytes(b"DHG ") }, // Dhangu
    LangTag { language: "dib", 	tag: Tag::from_bytes(b"DNK ") }, // South Central Dinka -> Dinka
    LangTag { language: "dik", 	tag: Tag::from_bytes(b"DNK ") }, // Southwestern Dinka -> Dinka
    LangTag { language: "din", 	tag: Tag::from_bytes(b"DNK ") }, // Dinka [macrolanguage]
    LangTag { language: "dip", 	tag: Tag::from_bytes(b"DNK ") }, // Northeastern Dinka -> Dinka
//  LangTag { language: "diq", 	tag: Tag::from_bytes(b"DIQ ") }, // Dimli
    LangTag { language: "diw", 	tag: Tag::from_bytes(b"DNK ") }, // Northwestern Dinka -> Dinka
    LangTag { language: "dje", 	tag: Tag::from_bytes(b"DJR ") }, // Zarma
    LangTag { language: "djr", 	tag: Tag::from_bytes(b"DJR0") }, // Djambarrpuyngu
    LangTag { language: "dks", 	tag: Tag::from_bytes(b"DNK ") }, // Southeastern Dinka -> Dinka
    LangTag { language: "dng", 	tag: Tag::from_bytes(b"DUN ") }, // Dungan
//  LangTag { language: "dnj", 	tag: Tag::from_bytes(b"DNJ ") }, // Dan
    LangTag { language: "doi", 	tag: Tag::from_bytes(b"DGR ") }, // Dogri  [macrolanguage]
    LangTag { language: "drh", 	tag: Tag::from_bytes(b"MNG ") }, // Darkhat(retired code) -> Mongolian
    LangTag { language: "drw", 	tag: Tag::from_bytes(b"DRI ") }, // Darwazi(retired code) -> Dari
    LangTag { language: "dsb", 	tag: Tag::from_bytes(b"LSB ") }, // Lower Sorbian
    LangTag { language: "dty", 	tag: Tag::from_bytes(b"NEP ") }, // Dotyali -> Nepali
//  LangTag { language: "duj", 	tag: Tag::from_bytes(b"DUJ ") }, // Dhuwal(retired code)
    LangTag { language: "dup", 	tag: Tag::from_bytes(b"MLY ") }, // Duano -> Malay
    LangTag { language: "dv", 	tag: Tag::from_bytes(b"DIV ") }, // Divehi (Dhivehi, Maldivian)
    LangTag { language: "dv", 	tag: Tag::from_bytes(b"DHV ") }, // Divehi (Dhivehi, Maldivian)(deprecated)
    LangTag { language: "dwu", 	tag: Tag::from_bytes(b"DUJ ") }, // Dhuwal
    LangTag { language: "dwy", 	tag: Tag::from_bytes(b"DUJ ") }, // Dhuwaya -> Dhuwal
    LangTag { language: "dyu", 	tag: Tag::from_bytes(b"JUL ") }, // Dyula -> Jula
    LangTag { language: "dz", 	tag: Tag::from_bytes(b"DZN ") }, // Dzongkha
    LangTag { language: "ee", 	tag: Tag::from_bytes(b"EWE ") }, // Ewe
//  LangTag { language: "efi", 	tag: Tag::from_bytes(b"EFI ") }, // Efik
    LangTag { language: "ekk", 	tag: Tag::from_bytes(b"ETI ") }, // Standard Estonian -> Estonian
    LangTag { language: "el", 	tag: Tag::from_bytes(b"ELL ") }, // Modern Greek (1453-) -> Greek
    LangTag { language: "emk", 	tag: Tag::from_bytes(b"EMK ") }, // Eastern Maninkakan
    LangTag { language: "emk", 	tag: Tag::from_bytes(b"MNK ") }, // Eastern Maninkakan -> Maninka
    LangTag { language: "en", 	tag: Tag::from_bytes(b"ENG ") }, // English
    LangTag { language: "enb", 	tag: Tag::from_bytes(b"KAL ") }, // Markweeta -> Kalenjin
    LangTag { language: "enf", 	tag: Tag::from_bytes(b"FNE ") }, // Forest Enets -> Forest Nenets
    LangTag { language: "enh", 	tag: Tag::from_bytes(b"TNE ") }, // Tundra Enets -> Tundra Nenets
    LangTag { language: "eo", 	tag: Tag::from_bytes(b"NTO ") }, // Esperanto
    LangTag { language: "es", 	tag: Tag::from_bytes(b"ESP ") }, // Spanish
    LangTag { language: "esg", 	tag: Tag::from_bytes(b"GON ") }, // Aheri Gondi -> Gondi
    LangTag { language: "esi", 	tag: Tag::from_bytes(b"IPK ") }, // North Alaskan Inupiatun -> Inupiat
    LangTag { language: "esk", 	tag: Tag::from_bytes(b"IPK ") }, // Northwest Alaska Inupiatun -> Inupiat
//  LangTag { language: "esu", 	tag: Tag::from_bytes(b"ESU ") }, // Central Yupik
    LangTag { language: "et", 	tag: Tag::from_bytes(b"ETI ") }, // Estonian [macrolanguage]
    LangTag { language: "eto", 	tag: Tag::from_bytes(b"BTI ") }, // Eton (Cameroon) -> Beti
    LangTag { language: "eu", 	tag: Tag::from_bytes(b"EUQ ") }, // Basque
    LangTag { language: "eve", 	tag: Tag::from_bytes(b"EVN ") }, // Even
    LangTag { language: "evn", 	tag: Tag::from_bytes(b"EVK ") }, // Evenki
    LangTag { language: "ewo", 	tag: Tag::from_bytes(b"BTI ") }, // Ewondo -> Beti
    LangTag { language: "eyo", 	tag: Tag::from_bytes(b"KAL ") }, // Keiyo -> Kalenjin
    LangTag { language: "fa", 	tag: Tag::from_bytes(b"FAR ") }, // Persian [macrolanguage]
    LangTag { language: "fan", 	tag: Tag::from_bytes(b"FAN0") }, // Fang (Equatorial Guinea)
//  LangTag { language: "fat", 	tag: Tag::from_bytes(b"FAT ") }, // Fanti
    LangTag { language: "fbl", 	tag: Tag::from_bytes(b"BIK ") }, // West Albay Bikol -> Bikol
    LangTag { language: "ff", 	tag: Tag::from_bytes(b"FUL ") }, // Fulah [macrolanguage]
    LangTag { language: "ffm", 	tag: Tag::from_bytes(b"FUL ") }, // Maasina Fulfulde -> Fulah
    LangTag { language: "fi", 	tag: Tag::from_bytes(b"FIN ") }, // Finnish
    LangTag { language: "fil", 	tag: Tag::from_bytes(b"PIL ") }, // Filipino
    LangTag { language: "fj", 	tag: Tag::from_bytes(b"FJI ") }, // Fijian
    LangTag { language: "flm", 	tag: Tag::from_bytes(b"HAL ") }, // Halam (Falam Chin)(retired code)
    LangTag { language: "flm", 	tag: Tag::from_bytes(b"QIN ") }, // Falam Chin(retired code) -> Chin
//  LangTag { language: "fmp", 	tag: Tag::from_bytes(b"FMP ") }, // Fe’fe’
    LangTag { language: "fo", 	tag: Tag::from_bytes(b"FOS ") }, // Faroese
//  LangTag { language: "fon", 	tag: Tag::from_bytes(b"FON ") }, // Fon
    LangTag { language: "fr", 	tag: Tag::from_bytes(b"FRA ") }, // French
//  LangTag { language: "frc", 	tag: Tag::from_bytes(b"FRC ") }, // Cajun French
//  LangTag { language: "frp", 	tag: Tag::from_bytes(b"FRP ") }, // Arpitan
    LangTag { language: "fub", 	tag: Tag::from_bytes(b"FUL ") }, // Adamawa Fulfulde -> Fulah
    LangTag { language: "fuc", 	tag: Tag::from_bytes(b"FUL ") }, // Pulaar -> Fulah
    LangTag { language: "fue", 	tag: Tag::from_bytes(b"FUL ") }, // Borgu Fulfulde -> Fulah
    LangTag { language: "fuf", 	tag: Tag::from_bytes(b"FTA ") }, // Pular -> Futa
    LangTag { language: "fuh", 	tag: Tag::from_bytes(b"FUL ") }, // Western Niger Fulfulde -> Fulah
    LangTag { language: "fui", 	tag: Tag::from_bytes(b"FUL ") }, // Bagirmi Fulfulde -> Fulah
    LangTag { language: "fuq", 	tag: Tag::from_bytes(b"FUL ") }, // Central-Eastern Niger Fulfulde -> Fulah
    LangTag { language: "fur", 	tag: Tag::from_bytes(b"FRL ") }, // Friulian
//  LangTag { language: "fuv", 	tag: Tag::from_bytes(b"FUV ") }, // Nigerian Fulfulde
    LangTag { language: "fy", 	tag: Tag::from_bytes(b"FRI ") }, // Western Frisian -> Frisian
    LangTag { language: "ga", 	tag: Tag::from_bytes(b"IRI ") }, // Irish
    LangTag { language: "gaa", 	tag: Tag::from_bytes(b"GAD ") }, // Ga
//  LangTag { language: "gag", 	tag: Tag::from_bytes(b"GAG ") }, // Gagauz
    LangTag { language: "gan", 	tag: Tag::from_bytes(b"ZHS ") }, // Gan Chinese -> Chinese Simplified
    LangTag { language: "gax", 	tag: Tag::from_bytes(b"ORO ") }, // Borana-Arsi-Guji Oromo -> Oromo
    LangTag { language: "gaz", 	tag: Tag::from_bytes(b"ORO ") }, // West Central Oromo -> Oromo
    LangTag { language: "gbm", 	tag: Tag::from_bytes(b"GAW ") }, // Garhwali
    LangTag { language: "gce", 	tag: Tag::from_bytes(b"ATH ") }, // Galice -> Athapaskan
    LangTag { language: "gd", 	tag: Tag::from_bytes(b"GAE ") }, // Scottish Gaelic (Gaelic)
    LangTag { language: "gda", 	tag: Tag::from_bytes(b"RAJ ") }, // Gade Lohar -> Rajasthani
//  LangTag { language: "gez", 	tag: Tag::from_bytes(b"GEZ ") }, // Geez
    LangTag { language: "ggo", 	tag: Tag::from_bytes(b"GON ") }, // Southern Gondi(retired code) -> Gondi
//  LangTag { language: "gih", 	tag: Tag::from_bytes(b"GIH ") }, // Githabul
    LangTag { language: "gil", 	tag: Tag::from_bytes(b"GIL0") }, // Kiribati (Gilbertese)
    LangTag { language: "gju", 	tag: Tag::from_bytes(b"RAJ ") }, // Gujari -> Rajasthani
//  LangTag { language: "gkp", 	tag: Tag::from_bytes(b"GKP ") }, // Guinea Kpelle -> Kpelle (Guinea)
    LangTag { language: "gl", 	tag: Tag::from_bytes(b"GAL ") }, // Galician
    LangTag { language: "gld", 	tag: Tag::from_bytes(b"NAN ") }, // Nanai
//  LangTag { language: "glk", 	tag: Tag::from_bytes(b"GLK ") }, // Gilaki
    LangTag { language: "gn", 	tag: Tag::from_bytes(b"GUA ") }, // Guarani [macrolanguage]
//  LangTag { language: "gnn", 	tag: Tag::from_bytes(b"GNN ") }, // Gumatj
    LangTag { language: "gno", 	tag: Tag::from_bytes(b"GON ") }, // Northern Gondi -> Gondi
    LangTag { language: "gnw", 	tag: Tag::from_bytes(b"GUA ") }, // Western Bolivian Guaraní -> Guarani
//  LangTag { language: "gog", 	tag: Tag::from_bytes(b"GOG ") }, // Gogo
    LangTag { language: "gom", 	tag: Tag::from_bytes(b"KOK ") }, // Goan Konkani -> Konkani
//  LangTag { language: "gon", 	tag: Tag::from_bytes(b"GON ") }, // Gondi [macrolanguage]
    LangTag { language: "grt", 	tag: Tag::from_bytes(b"GRO ") }, // Garo
    LangTag { language: "gru", 	tag: Tag::from_bytes(b"SOG ") }, // Kistane -> Sodo Gurage
    LangTag { language: "gsw", 	tag: Tag::from_bytes(b"ALS ") }, // Alsatian
    LangTag { language: "gu", 	tag: Tag::from_bytes(b"GUJ ") }, // Gujarati
//  LangTag { language: "guc", 	tag: Tag::from_bytes(b"GUC ") }, // Wayuu
//  LangTag { language: "guf", 	tag: Tag::from_bytes(b"GUF ") }, // Gupapuyngu
    LangTag { language: "gug", 	tag: Tag::from_bytes(b"GUA ") }, // Paraguayan Guaraní -> Guarani
    LangTag { language: "gui", 	tag: Tag::from_bytes(b"GUA ") }, // Eastern Bolivian Guaraní -> Guarani
    LangTag { language: "guk", 	tag: Tag::from_bytes(b"GMZ ") }, // Gumuz
    LangTag { language: "guk", 	tag: Tag::from_bytes(b"GUK ") }, // Gumuz(SIL fonts)
    LangTag { language: "gun", 	tag: Tag::from_bytes(b"GUA ") }, // Mbyá Guaraní -> Guarani
//  LangTag { language: "guz", 	tag: Tag::from_bytes(b"GUZ ") }, // Gusii
    LangTag { language: "gv", 	tag: Tag::from_bytes(b"MNX ") }, // Manx
    LangTag { language: "gwi", 	tag: Tag::from_bytes(b"ATH ") }, // Gwichʼin -> Athapaskan
    LangTag { language: "ha", 	tag: Tag::from_bytes(b"HAU ") }, // Hausa
    LangTag { language: "haa", 	tag: Tag::from_bytes(b"ATH ") }, // Han -> Athapaskan
    LangTag { language: "hae", 	tag: Tag::from_bytes(b"ORO ") }, // Eastern Oromo -> Oromo
    LangTag { language: "hak", 	tag: Tag::from_bytes(b"ZHS ") }, // Hakka Chinese -> Chinese Simplified
    LangTag { language: "har", 	tag: Tag::from_bytes(b"HRI ") }, // Harari
//  LangTag { language: "haw", 	tag: Tag::from_bytes(b"HAW ") }, // Hawaiian
//  LangTag { language: "hay", 	tag: Tag::from_bytes(b"HAY ") }, // Haya
//  LangTag { language: "haz", 	tag: Tag::from_bytes(b"HAZ ") }, // Hazaragi
    LangTag { language: "he", 	tag: Tag::from_bytes(b"IWR ") }, // Hebrew
    LangTag { language: "hea", 	tag: Tag::from_bytes(b"HMN ") }, // Northern Qiandong Miao -> Hmong
    LangTag { language: "hi", 	tag: Tag::from_bytes(b"HIN ") }, // Hindi
//  LangTag { language: "hil", 	tag: Tag::from_bytes(b"HIL ") }, // Hiligaynon
    LangTag { language: "hji", 	tag: Tag::from_bytes(b"MLY ") }, // Haji -> Malay
    LangTag { language: "hlt", 	tag: Tag::from_bytes(b"QIN ") }, // Matu Chin -> Chin
    LangTag { language: "hma", 	tag: Tag::from_bytes(b"HMN ") }, // Southern Mashan Hmong -> Hmong
    LangTag { language: "hmc", 	tag: Tag::from_bytes(b"HMN ") }, // Central Huishui Hmong -> Hmong
    LangTag { language: "hmd", 	tag: Tag::from_bytes(b"HMN ") }, // Large Flowery Miao -> Hmong
    LangTag { language: "hme", 	tag: Tag::from_bytes(b"HMN ") }, // Eastern Huishui Hmong -> Hmong
    LangTag { language: "hmg", 	tag: Tag::from_bytes(b"HMN ") }, // Southwestern Guiyang Hmong -> Hmong
    LangTag { language: "hmh", 	tag: Tag::from_bytes(b"HMN ") }, // Southwestern Huishui Hmong -> Hmong
    LangTag { language: "hmi", 	tag: Tag::from_bytes(b"HMN ") }, // Northern Huishui Hmong -> Hmong
    LangTag { language: "hmj", 	tag: Tag::from_bytes(b"HMN ") }, // Ge -> Hmong
    LangTag { language: "hml", 	tag: Tag::from_bytes(b"HMN ") }, // Luopohe Hmong -> Hmong
    LangTag { language: "hmm", 	tag: Tag::from_bytes(b"HMN ") }, // Central Mashan Hmong -> Hmong
//  LangTag { language: "hmn", 	tag: Tag::from_bytes(b"HMN ") }, // Hmong [macrolanguage]
    LangTag { language: "hmp", 	tag: Tag::from_bytes(b"HMN ") }, // Northern Mashan Hmong -> Hmong
    LangTag { language: "hmq", 	tag: Tag::from_bytes(b"HMN ") }, // Eastern Qiandong Miao -> Hmong
    LangTag { language: "hms", 	tag: Tag::from_bytes(b"HMN ") }, // Southern Qiandong Miao -> Hmong
    LangTag { language: "hmw", 	tag: Tag::from_bytes(b"HMN ") }, // Western Mashan Hmong -> Hmong
    LangTag { language: "hmy", 	tag: Tag::from_bytes(b"HMN ") }, // Southern Guiyang Hmong -> Hmong
    LangTag { language: "hmz", 	tag: Tag::from_bytes(b"HMN ") }, // Hmong Shua -> Hmong
//  LangTag { language: "hnd", 	tag: Tag::from_bytes(b"HND ") }, // Southern Hindko -> Hindko
    LangTag { language: "hne", 	tag: Tag::from_bytes(b"CHH ") }, // Chhattisgarhi -> Chattisgarhi
    LangTag { language: "hnj", 	tag: Tag::from_bytes(b"HMN ") }, // Hmong Njua -> Hmong
    LangTag { language: "hno", 	tag: Tag::from_bytes(b"HND ") }, // Northern Hindko -> Hindko
    LangTag { language: "ho", 	tag: Tag::from_bytes(b"HMO ") }, // Hiri Motu
    LangTag { language: "hoc", 	tag: Tag::from_bytes(b"HO  ") }, // Ho
    LangTag { language: "hoi", 	tag: Tag::from_bytes(b"ATH ") }, // Holikachuk -> Athapaskan
    LangTag { language: "hoj", 	tag: Tag::from_bytes(b"HAR ") }, // Hadothi -> Harauti
    LangTag { language: "hr", 	tag: Tag::from_bytes(b"HRV ") }, // Croatian
    LangTag { language: "hrm", 	tag: Tag::from_bytes(b"HMN ") }, // Horned Miao -> Hmong
    LangTag { language: "hsb", 	tag: Tag::from_bytes(b"USB ") }, // Upper Sorbian
    LangTag { language: "hsn", 	tag: Tag::from_bytes(b"ZHS ") }, // Xiang Chinese -> Chinese Simplified
    LangTag { language: "ht", 	tag: Tag::from_bytes(b"HAI ") }, // Haitian (Haitian Creole)
    LangTag { language: "hu", 	tag: Tag::from_bytes(b"HUN ") }, // Hungarian
    LangTag { language: "huj", 	tag: Tag::from_bytes(b"HMN ") }, // Northern Guiyang Hmong -> Hmong
    LangTag { language: "hup", 	tag: Tag::from_bytes(b"ATH ") }, // Hupa -> Athapaskan
    LangTag { language: "hy", 	tag: Tag::from_bytes(b"HYE0") }, // Armenian -> Armenian East
    LangTag { language: "hy", 	tag: Tag::from_bytes(b"HYE ") }, // Armenian
    LangTag { language: "hyw", 	tag: Tag::from_bytes(b"HYE ") }, // Western Armenian -> Armenian
    LangTag { language: "hz", 	tag: Tag::from_bytes(b"HER ") }, // Herero
    LangTag { language: "ia", 	tag: Tag::from_bytes(b"INA ") }, // Interlingua (International Auxiliary Language Association)
//  LangTag { language: "iba", 	tag: Tag::from_bytes(b"IBA ") }, // Iban
//  LangTag { language: "ibb", 	tag: Tag::from_bytes(b"IBB ") }, // Ibibio
    LangTag { language: "id", 	tag: Tag::from_bytes(b"IND ") }, // Indonesian
    LangTag { language: "ida", 	tag: Tag::from_bytes(b"LUH ") }, // Idakho-Isukha-Tiriki -> Luyia
    LangTag { language: "ie", 	tag: Tag::from_bytes(b"ILE ") }, // Interlingue
    LangTag { language: "ig", 	tag: Tag::from_bytes(b"IBO ") }, // Igbo
    LangTag { language: "igb", 	tag: Tag::from_bytes(b"EBI ") }, // Ebira
    LangTag { language: "ii", 	tag: Tag::from_bytes(b"YIM ") }, // Sichuan Yi -> Yi Modern
    LangTag { language: "ijc", 	tag: Tag::from_bytes(b"IJO ") }, // Izon -> Ijo
//  LangTag { language: "ijo", 	tag: Tag::from_bytes(b"IJO ") }, // Ijo  [family]
    LangTag { language: "ik", 	tag: Tag::from_bytes(b"IPK ") }, // Inupiaq [macrolanguage] -> Inupiat
    LangTag { language: "ike", 	tag: Tag::from_bytes(b"INU ") }, // Eastern Canadian Inuktitut -> Inuktitut
    LangTag { language: "ikt", 	tag: Tag::from_bytes(b"INU ") }, // Inuinnaqtun -> Inuktitut
//  LangTag { language: "ilo", 	tag: Tag::from_bytes(b"ILO ") }, // Iloko -> Ilokano
    LangTag { language: "in", 	tag: Tag::from_bytes(b"IND ") }, // Indonesian(retired code)
    LangTag { language: "ing", 	tag: Tag::from_bytes(b"ATH ") }, // Degexit'an -> Athapaskan
    LangTag { language: "inh", 	tag: Tag::from_bytes(b"ING ") }, // Ingush
    LangTag { language: "io", 	tag: Tag::from_bytes(b"IDO ") }, // Ido
    LangTag { language: "is", 	tag: Tag::from_bytes(b"ISL ") }, // Icelandic
    LangTag { language: "it", 	tag: Tag::from_bytes(b"ITA ") }, // Italian
    LangTag { language: "iu", 	tag: Tag::from_bytes(b"INU ") }, // Inuktitut [macrolanguage]
    LangTag { language: "iw", 	tag: Tag::from_bytes(b"IWR ") }, // Hebrew(retired code)
    LangTag { language: "ja", 	tag: Tag::from_bytes(b"JAN ") }, // Japanese
    LangTag { language: "jak", 	tag: Tag::from_bytes(b"MLY ") }, // Jakun -> Malay
//  LangTag { language: "jam", 	tag: Tag::from_bytes(b"JAM ") }, // Jamaican Creole English -> Jamaican Creole
    LangTag { language: "jax", 	tag: Tag::from_bytes(b"MLY ") }, // Jambi Malay -> Malay
//  LangTag { language: "jbo", 	tag: Tag::from_bytes(b"JBO ") }, // Lojban
//  LangTag { language: "jct", 	tag: Tag::from_bytes(b"JCT ") }, // Krymchak
    LangTag { language: "ji", 	tag: Tag::from_bytes(b"JII ") }, // Yiddish(retired code)
    LangTag { language: "jv", 	tag: Tag::from_bytes(b"JAV ") }, // Javanese
    LangTag { language: "jw", 	tag: Tag::from_bytes(b"JAV ") }, // Javanese(retired code)
    LangTag { language: "ka", 	tag: Tag::from_bytes(b"KAT ") }, // Georgian
    LangTag { language: "kaa", 	tag: Tag::from_bytes(b"KRK ") }, // Kara-Kalpak -> Karakalpak
    LangTag { language: "kab", 	tag: Tag::from_bytes(b"KAB0") }, // Kabyle
    LangTag { language: "kam", 	tag: Tag::from_bytes(b"KMB ") }, // Kamba (Kenya)
    LangTag { language: "kar", 	tag: Tag::from_bytes(b"KRN ") }, // Karen  [family]
    LangTag { language: "kbd", 	tag: Tag::from_bytes(b"KAB ") }, // Kabardian
    LangTag { language: "kby", 	tag: Tag::from_bytes(b"KNR ") }, // Manga Kanuri -> Kanuri
    LangTag { language: "kca", 	tag: Tag::from_bytes(b"KHK ") }, // Khanty -> Khanty-Kazim
    LangTag { language: "kca", 	tag: Tag::from_bytes(b"KHS ") }, // Khanty -> Khanty-Shurishkar
    LangTag { language: "kca", 	tag: Tag::from_bytes(b"KHV ") }, // Khanty -> Khanty-Vakhi
//  LangTag { language: "kde", 	tag: Tag::from_bytes(b"KDE ") }, // Makonde
    LangTag { language: "kdr", 	tag: Tag::from_bytes(b"KRM ") }, // Karaim
    LangTag { language: "kdt", 	tag: Tag::from_bytes(b"KUY ") }, // Kuy
//  LangTag { language: "kea", 	tag: Tag::from_bytes(b"KEA ") }, // Kabuverdianu (Crioulo)
//  LangTag { language: "kek", 	tag: Tag::from_bytes(b"KEK ") }, // Kekchi
    LangTag { language: "kex", 	tag: Tag::from_bytes(b"KKN ") }, // Kukna -> Kokni
    LangTag { language: "kfa", 	tag: Tag::from_bytes(b"KOD ") }, // Kodava -> Kodagu
    LangTag { language: "kfr", 	tag: Tag::from_bytes(b"KAC ") }, // Kachhi -> Kachchi
    LangTag { language: "kfx", 	tag: Tag::from_bytes(b"KUL ") }, // Kullu Pahari -> Kulvi
    LangTag { language: "kfy", 	tag: Tag::from_bytes(b"KMN ") }, // Kumaoni
    LangTag { language: "kg", 	tag: Tag::from_bytes(b"KON0") }, // Kongo [macrolanguage]
    LangTag { language: "kha", 	tag: Tag::from_bytes(b"KSI ") }, // Khasi
    LangTag { language: "khb", 	tag: Tag::from_bytes(b"XBD ") }, // Lü
    LangTag { language: "khk", 	tag: Tag::from_bytes(b"MNG ") }, // Halh Mongolian -> Mongolian
    LangTag { language: "kht", 	tag: Tag::from_bytes(b"KHN ") }, // Khamti -> Khamti Shan(Microsoft fonts)
    LangTag { language: "kht", 	tag: Tag::from_bytes(b"KHT ") }, // Khamti -> Khamti Shan(OpenType spec and SIL fonts)
//  LangTag { language: "khw", 	tag: Tag::from_bytes(b"KHW ") }, // Khowar
    LangTag { language: "ki", 	tag: Tag::from_bytes(b"KIK ") }, // Kikuyu (Gikuyu)
//  LangTag { language: "kiu", 	tag: Tag::from_bytes(b"KIU ") }, // Kirmanjki
    LangTag { language: "kj", 	tag: Tag::from_bytes(b"KUA ") }, // Kuanyama
//  LangTag { language: "kjd", 	tag: Tag::from_bytes(b"KJD ") }, // Southern Kiwai
    LangTag { language: "kjh", 	tag: Tag::from_bytes(b"KHA ") }, // Khakas -> Khakass
//  LangTag { language: "kjp", 	tag: Tag::from_bytes(b"KJP ") }, // Pwo Eastern Karen -> Eastern Pwo Karen
//  LangTag { language: "kjz", 	tag: Tag::from_bytes(b"KJZ ") }, // Bumthangkha
    LangTag { language: "kk", 	tag: Tag::from_bytes(b"KAZ ") }, // Kazakh
    LangTag { language: "kkz", 	tag: Tag::from_bytes(b"ATH ") }, // Kaska -> Athapaskan
    LangTag { language: "kl", 	tag: Tag::from_bytes(b"GRN ") }, // Greenlandic
    LangTag { language: "kln", 	tag: Tag::from_bytes(b"KAL ") }, // Kalenjin [macrolanguage]
    LangTag { language: "km", 	tag: Tag::from_bytes(b"KHM ") }, // Khmer
    LangTag { language: "kmb", 	tag: Tag::from_bytes(b"MBN ") }, // Kimbundu -> Mbundu
    LangTag { language: "kmr", 	tag: Tag::from_bytes(b"KUR ") }, // Northern Kurdish -> Kurdish
    LangTag { language: "kmw", 	tag: Tag::from_bytes(b"KMO ") }, // Komo (Democratic Republic of Congo)
//  LangTag { language: "kmz", 	tag: Tag::from_bytes(b"KMZ ") }, // Khorasani Turkish -> Khorasani Turkic
    LangTag { language: "kn", 	tag: Tag::from_bytes(b"KAN ") }, // Kannada
    LangTag { language: "knc", 	tag: Tag::from_bytes(b"KNR ") }, // Central Kanuri -> Kanuri
    LangTag { language: "kng", 	tag: Tag::from_bytes(b"KON0") }, // Koongo -> Kongo
    LangTag { language: "knn", 	tag: Tag::from_bytes(b"KOK ") }, // Konkani
    LangTag { language: "ko", 	tag: Tag::from_bytes(b"KOR ") }, // Korean
    LangTag { language: "koi", 	tag: Tag::from_bytes(b"KOP ") }, // Komi-Permyak
//  LangTag { language: "kok", 	tag: Tag::from_bytes(b"KOK ") }, // Konkani  [macrolanguage]
//  LangTag { language: "kos", 	tag: Tag::from_bytes(b"KOS ") }, // Kosraean
    LangTag { language: "koy", 	tag: Tag::from_bytes(b"ATH ") }, // Koyukon -> Athapaskan
    LangTag { language: "kpe", 	tag: Tag::from_bytes(b"KPL ") }, // Kpelle [macrolanguage]
    LangTag { language: "kpv", 	tag: Tag::from_bytes(b"KOZ ") }, // Komi-Zyrian
    LangTag { language: "kpy", 	tag: Tag::from_bytes(b"KYK ") }, // Koryak
    LangTag { language: "kqs", 	tag: Tag::from_bytes(b"KIS ") }, // Northern Kissi -> Kisii
    LangTag { language: "kqy", 	tag: Tag::from_bytes(b"KRT ") }, // Koorete
    LangTag { language: "kr", 	tag: Tag::from_bytes(b"KNR ") }, // Kanuri [macrolanguage]
    LangTag { language: "krc", 	tag: Tag::from_bytes(b"KAR ") }, // Karachay-Balkar -> Karachay
    LangTag { language: "krc", 	tag: Tag::from_bytes(b"BAL ") }, // Karachay-Balkar -> Balkar
//  LangTag { language: "kri", 	tag: Tag::from_bytes(b"KRI ") }, // Krio
//  LangTag { language: "krl", 	tag: Tag::from_bytes(b"KRL ") }, // Karelian
    LangTag { language: "krt", 	tag: Tag::from_bytes(b"KNR ") }, // Tumari Kanuri -> Kanuri
    LangTag { language: "kru", 	tag: Tag::from_bytes(b"KUU ") }, // Kurukh
    LangTag { language: "ks", 	tag: Tag::from_bytes(b"KSH ") }, // Kashmiri
    LangTag { language: "ksh", 	tag: Tag::from_bytes(b"KSH0") }, // Kölsch -> Ripuarian
    LangTag { language: "kss", 	tag: Tag::from_bytes(b"KIS ") }, // Southern Kisi -> Kisii
//  LangTag { language: "ksw", 	tag: Tag::from_bytes(b"KSW ") }, // S’gaw Karen
    LangTag { language: "ktb", 	tag: Tag::from_bytes(b"KEB ") }, // Kambaata -> Kebena
    LangTag { language: "ktu", 	tag: Tag::from_bytes(b"KON ") }, // Kituba (Democratic Republic of Congo) -> Kikongo
    LangTag { language: "ktw", 	tag: Tag::from_bytes(b"ATH ") }, // Kato -> Athapaskan
    LangTag { language: "ku", 	tag: Tag::from_bytes(b"KUR ") }, // Kurdish [macrolanguage]
//  LangTag { language: "kum", 	tag: Tag::from_bytes(b"KUM ") }, // Kumyk
    LangTag { language: "kuu", 	tag: Tag::from_bytes(b"ATH ") }, // Upper Kuskokwim -> Athapaskan
    LangTag { language: "kv", 	tag: Tag::from_bytes(b"KOM ") }, // Komi [macrolanguage]
    LangTag { language: "kvb", 	tag: Tag::from_bytes(b"MLY ") }, // Kubu -> Malay
    LangTag { language: "kvr", 	tag: Tag::from_bytes(b"MLY ") }, // Kerinci -> Malay
    LangTag { language: "kw", 	tag: Tag::from_bytes(b"COR ") }, // Cornish
    LangTag { language: "kwy", 	tag: Tag::from_bytes(b"KON0") }, // San Salvador Kongo -> Kongo
    LangTag { language: "kxc", 	tag: Tag::from_bytes(b"KMS ") }, // Konso -> Komso
    LangTag { language: "kxd", 	tag: Tag::from_bytes(b"MLY ") }, // Brunei -> Malay
    LangTag { language: "kxu", 	tag: Tag::from_bytes(b"KUI ") }, // Kui (India)
    LangTag { language: "ky", 	tag: Tag::from_bytes(b"KIR ") }, // Kirghiz (Kyrgyz)
//  LangTag { language: "kyu", 	tag: Tag::from_bytes(b"KYU ") }, // Western Kayah
    LangTag { language: "la", 	tag: Tag::from_bytes(b"LAT ") }, // Latin
    LangTag { language: "lad", 	tag: Tag::from_bytes(b"JUD ") }, // Ladino
    LangTag { language: "lb", 	tag: Tag::from_bytes(b"LTZ ") }, // Luxembourgish
    LangTag { language: "lbe", 	tag: Tag::from_bytes(b"LAK ") }, // Lak
    LangTag { language: "lbj", 	tag: Tag::from_bytes(b"LDK ") }, // Ladakhi
    LangTag { language: "lbl", 	tag: Tag::from_bytes(b"BIK ") }, // Libon Bikol -> Bikol
    LangTag { language: "lce", 	tag: Tag::from_bytes(b"MLY ") }, // Loncong -> Malay
    LangTag { language: "lcf", 	tag: Tag::from_bytes(b"MLY ") }, // Lubu -> Malay
    LangTag { language: "ldi", 	tag: Tag::from_bytes(b"KON0") }, // Laari -> Kongo
//  LangTag { language: "lez", 	tag: Tag::from_bytes(b"LEZ ") }, // Lezghian -> Lezgi
    LangTag { language: "lg", 	tag: Tag::from_bytes(b"LUG ") }, // Ganda
    LangTag { language: "li", 	tag: Tag::from_bytes(b"LIM ") }, // Limburgish
    LangTag { language: "lif", 	tag: Tag::from_bytes(b"LMB ") }, // Limbu
//  LangTag { language: "lij", 	tag: Tag::from_bytes(b"LIJ ") }, // Ligurian
//  LangTag { language: "lis", 	tag: Tag::from_bytes(b"LIS ") }, // Lisu
    LangTag { language: "liw", 	tag: Tag::from_bytes(b"MLY ") }, // Col -> Malay
//  LangTag { language: "ljp", 	tag: Tag::from_bytes(b"LJP ") }, // Lampung Api -> Lampung
    LangTag { language: "lkb", 	tag: Tag::from_bytes(b"LUH ") }, // Kabras -> Luyia
//  LangTag { language: "lki", 	tag: Tag::from_bytes(b"LKI ") }, // Laki
    LangTag { language: "lko", 	tag: Tag::from_bytes(b"LUH ") }, // Khayo -> Luyia
    LangTag { language: "lks", 	tag: Tag::from_bytes(b"LUH ") }, // Kisa -> Luyia
    LangTag { language: "lld", 	tag: Tag::from_bytes(b"LAD ") }, // Ladin
    LangTag { language: "lmn", 	tag: Tag::from_bytes(b"LAM ") }, // Lambadi -> Lambani
//  LangTag { language: "lmo", 	tag: Tag::from_bytes(b"LMO ") }, // Lombard
    LangTag { language: "ln", 	tag: Tag::from_bytes(b"LIN ") }, // Lingala
    LangTag { language: "lo", 	tag: Tag::from_bytes(b"LAO ") }, // Lao
//  LangTag { language: "lom", 	tag: Tag::from_bytes(b"LOM ") }, // Loma (Liberia)
//  LangTag { language: "lrc", 	tag: Tag::from_bytes(b"LRC ") }, // Northern Luri -> Luri
    LangTag { language: "lri", 	tag: Tag::from_bytes(b"LUH ") }, // Marachi -> Luyia
    LangTag { language: "lrm", 	tag: Tag::from_bytes(b"LUH ") }, // Marama -> Luyia
    LangTag { language: "lsm", 	tag: Tag::from_bytes(b"LUH ") }, // Saamia -> Luyia
    LangTag { language: "lt", 	tag: Tag::from_bytes(b"LTH ") }, // Lithuanian
    LangTag { language: "ltg", 	tag: Tag::from_bytes(b"LVI ") }, // Latgalian -> Latvian
    LangTag { language: "lto", 	tag: Tag::from_bytes(b"LUH ") }, // Tsotso -> Luyia
    LangTag { language: "lts", 	tag: Tag::from_bytes(b"LUH ") }, // Tachoni -> Luyia
    LangTag { language: "lu", 	tag: Tag::from_bytes(b"LUB ") }, // Luba-Katanga
//  LangTag { language: "lua", 	tag: Tag::from_bytes(b"LUA ") }, // Luba-Lulua
//  LangTag { language: "luo", 	tag: Tag::from_bytes(b"LUO ") }, // Luo (Kenya and Tanzania)
    LangTag { language: "lus", 	tag: Tag::from_bytes(b"MIZ ") }, // Lushai -> Mizo
    LangTag { language: "luy", 	tag: Tag::from_bytes(b"LUH ") }, // Luyia [macrolanguage]
    LangTag { language: "luz", 	tag: Tag::from_bytes(b"LRC ") }, // Southern Luri -> Luri
    LangTag { language: "lv", 	tag: Tag::from_bytes(b"LVI ") }, // Latvian [macrolanguage]
    LangTag { language: "lvs", 	tag: Tag::from_bytes(b"LVI ") }, // Standard Latvian -> Latvian
    LangTag { language: "lwg", 	tag: Tag::from_bytes(b"LUH ") }, // Wanga -> Luyia
    LangTag { language: "lzh", 	tag: Tag::from_bytes(b"ZHT ") }, // Literary Chinese -> Chinese Traditional
    LangTag { language: "lzz", 	tag: Tag::from_bytes(b"LAZ ") }, // Laz
//  LangTag { language: "mad", 	tag: Tag::from_bytes(b"MAD ") }, // Madurese -> Madura
//  LangTag { language: "mag", 	tag: Tag::from_bytes(b"MAG ") }, // Magahi
    LangTag { language: "mai", 	tag: Tag::from_bytes(b"MTH ") }, // Maithili
    LangTag { language: "mak", 	tag: Tag::from_bytes(b"MKR ") }, // Makasar
//  LangTag { language: "mam", 	tag: Tag::from_bytes(b"MAM ") }, // Mam
    LangTag { language: "man", 	tag: Tag::from_bytes(b"MNK ") }, // Mandingo [macrolanguage] -> Maninka
    LangTag { language: "max", 	tag: Tag::from_bytes(b"MLY ") }, // North Moluccan Malay -> Malay
//  LangTag { language: "mbo", 	tag: Tag::from_bytes(b"MBO ") }, // Mbo (Cameroon)
    LangTag { language: "mct", 	tag: Tag::from_bytes(b"BTI ") }, // Mengisa -> Beti
    LangTag { language: "mdf", 	tag: Tag::from_bytes(b"MOK ") }, // Moksha
//  LangTag { language: "mdr", 	tag: Tag::from_bytes(b"MDR ") }, // Mandar
    LangTag { language: "mdy", 	tag: Tag::from_bytes(b"MLE ") }, // Male (Ethiopia)
    LangTag { language: "men", 	tag: Tag::from_bytes(b"MDE ") }, // Mende (Sierra Leone)
    LangTag { language: "meo", 	tag: Tag::from_bytes(b"MLY ") }, // Kedah Malay -> Malay
//  LangTag { language: "mer", 	tag: Tag::from_bytes(b"MER ") }, // Meru
//  LangTag { language: "mfa", 	tag: Tag::from_bytes(b"MFA ") }, // Pattani Malay
    LangTag { language: "mfb", 	tag: Tag::from_bytes(b"MLY ") }, // Bangka -> Malay
//  LangTag { language: "mfe", 	tag: Tag::from_bytes(b"MFE ") }, // Morisyen
    LangTag { language: "mg", 	tag: Tag::from_bytes(b"MLG ") }, // Malagasy [macrolanguage]
    LangTag { language: "mh", 	tag: Tag::from_bytes(b"MAH ") }, // Marshallese
    LangTag { language: "mhr", 	tag: Tag::from_bytes(b"LMA ") }, // Eastern Mari -> Low Mari
    LangTag { language: "mhv", 	tag: Tag::from_bytes(b"ARK ") }, // Arakanese(retired code) -> Rakhine
    LangTag { language: "mi", 	tag: Tag::from_bytes(b"MRI ") }, // Maori
//  LangTag { language: "min", 	tag: Tag::from_bytes(b"MIN ") }, // Minangkabau
    LangTag { language: "mk", 	tag: Tag::from_bytes(b"MKD ") }, // Macedonian
    LangTag { language: "mku", 	tag: Tag::from_bytes(b"MNK ") }, // Konyanka Maninka -> Maninka
//  LangTag { language: "mkw", 	tag: Tag::from_bytes(b"MKW ") }, // Kituba (Congo)
    LangTag { language: "ml", 	tag: Tag::from_bytes(b"MAL ") }, // Malayalam -> Malayalam Traditional
    LangTag { language: "ml", 	tag: Tag::from_bytes(b"MLR ") }, // Malayalam -> Malayalam Reformed
    LangTag { language: "mlq", 	tag: Tag::from_bytes(b"MLN ") }, // Western Maninkakan -> Malinke
    LangTag { language: "mlq", 	tag: Tag::from_bytes(b"MNK ") }, // Western Maninkakan -> Maninka
    LangTag { language: "mmr", 	tag: Tag::from_bytes(b"HMN ") }, // Western Xiangxi Miao -> Hmong
    LangTag { language: "mn", 	tag: Tag::from_bytes(b"MNG ") }, // Mongolian [macrolanguage]
    LangTag { language: "mnc", 	tag: Tag::from_bytes(b"MCH ") }, // Manchu
//  LangTag { language: "mni", 	tag: Tag::from_bytes(b"MNI ") }, // Manipuri
    LangTag { language: "mnk", 	tag: Tag::from_bytes(b"MND ") }, // Mandinka
    LangTag { language: "mnk", 	tag: Tag::from_bytes(b"MNK ") }, // Mandinka -> Maninka
    LangTag { language: "mnp", 	tag: Tag::from_bytes(b"ZHS ") }, // Min Bei Chinese -> Chinese Simplified
    LangTag { language: "mns", 	tag: Tag::from_bytes(b"MAN ") }, // Mansi
    LangTag { language: "mnw", 	tag: Tag::from_bytes(b"MON ") }, // Mon
    LangTag { language: "mo", 	tag: Tag::from_bytes(b"MOL ") }, // Moldavian(retired code)
//  LangTag { language: "moh", 	tag: Tag::from_bytes(b"MOH ") }, // Mohawk
//  LangTag { language: "mos", 	tag: Tag::from_bytes(b"MOS ") }, // Mossi
    LangTag { language: "mpe", 	tag: Tag::from_bytes(b"MAJ ") }, // Majang
    LangTag { language: "mqg", 	tag: Tag::from_bytes(b"MLY ") }, // Kota Bangun Kutai Malay -> Malay
    LangTag { language: "mr", 	tag: Tag::from_bytes(b"MAR ") }, // Marathi
    LangTag { language: "mrh", 	tag: Tag::from_bytes(b"QIN ") }, // Mara Chin -> Chin
    LangTag { language: "mrj", 	tag: Tag::from_bytes(b"HMA ") }, // Western Mari -> High Mari
    LangTag { language: "ms", 	tag: Tag::from_bytes(b"MLY ") }, // Malay  [macrolanguage]
    LangTag { language: "msc", 	tag: Tag::from_bytes(b"MNK ") }, // Sankaran Maninka -> Maninka
    LangTag { language: "msh", 	tag: Tag::from_bytes(b"MLG ") }, // Masikoro Malagasy -> Malagasy
    LangTag { language: "msi", 	tag: Tag::from_bytes(b"MLY ") }, // Sabah Malay -> Malay
    LangTag { language: "mt", 	tag: Tag::from_bytes(b"MTS ") }, // Maltese
    LangTag { language: "mtr", 	tag: Tag::from_bytes(b"MAW ") }, // Mewari -> Marwari
    LangTag { language: "mui", 	tag: Tag::from_bytes(b"MLY ") }, // Musi -> Malay
    LangTag { language: "mup", 	tag: Tag::from_bytes(b"RAJ ") }, // Malvi -> Rajasthani
    LangTag { language: "muq", 	tag: Tag::from_bytes(b"HMN ") }, // Eastern Xiangxi Miao -> Hmong
//  LangTag { language: "mus", 	tag: Tag::from_bytes(b"MUS ") }, // Creek -> Muscogee
    LangTag { language: "mvb", 	tag: Tag::from_bytes(b"ATH ") }, // Mattole -> Athapaskan
    LangTag { language: "mve", 	tag: Tag::from_bytes(b"MAW ") }, // Marwari (Pakistan)
    LangTag { language: "mvf", 	tag: Tag::from_bytes(b"MNG ") }, // Peripheral Mongolian -> Mongolian
    LangTag { language: "mwk", 	tag: Tag::from_bytes(b"MNK ") }, // Kita Maninkakan -> Maninka
//  LangTag { language: "mwl", 	tag: Tag::from_bytes(b"MWL ") }, // Mirandese
    LangTag { language: "mwr", 	tag: Tag::from_bytes(b"MAW ") }, // Marwari [macrolanguage]
//  LangTag { language: "mww", 	tag: Tag::from_bytes(b"MWW ") }, // Hmong Daw
    LangTag { language: "my", 	tag: Tag::from_bytes(b"BRM ") }, // Burmese
    LangTag { language: "mym", 	tag: Tag::from_bytes(b"MEN ") }, // Me’en
//  LangTag { language: "myn", 	tag: Tag::from_bytes(b"MYN ") }, // Mayan  [family]
    LangTag { language: "myq", 	tag: Tag::from_bytes(b"MNK ") }, // Forest Maninka(retired code) -> Maninka
    LangTag { language: "myv", 	tag: Tag::from_bytes(b"ERZ ") }, // Erzya
//  LangTag { language: "mzn", 	tag: Tag::from_bytes(b"MZN ") }, // Mazanderani
    LangTag { language: "na", 	tag: Tag::from_bytes(b"NAU ") }, // Nauru -> Nauruan
//  LangTag { language: "nag", 	tag: Tag::from_bytes(b"NAG ") }, // Naga Pidgin -> Naga-Assamese
//  LangTag { language: "nah", 	tag: Tag::from_bytes(b"NAH ") }, // Nahuatl  [family]
    LangTag { language: "nan", 	tag: Tag::from_bytes(b"ZHS ") }, // Min Nan Chinese -> Chinese Simplified
//  LangTag { language: "nap", 	tag: Tag::from_bytes(b"NAP ") }, // Neapolitan
    LangTag { language: "nb", 	tag: Tag::from_bytes(b"NOR ") }, // Norwegian Bokmål -> Norwegian
    LangTag { language: "nd", 	tag: Tag::from_bytes(b"NDB ") }, // North Ndebele -> Ndebele
//  LangTag { language: "ndc", 	tag: Tag::from_bytes(b"NDC ") }, // Ndau
//  LangTag { language: "nds", 	tag: Tag::from_bytes(b"NDS ") }, // Low Saxon
    LangTag { language: "ne", 	tag: Tag::from_bytes(b"NEP ") }, // Nepali  [macrolanguage]
//  LangTag { language: "new", 	tag: Tag::from_bytes(b"NEW ") }, // Newari
    LangTag { language: "ng", 	tag: Tag::from_bytes(b"NDG ") }, // Ndonga
//  LangTag { language: "nga", 	tag: Tag::from_bytes(b"NGA ") }, // Ngbaka
    LangTag { language: "ngl", 	tag: Tag::from_bytes(b"LMW ") }, // Lomwe
    LangTag { language: "ngo", 	tag: Tag::from_bytes(b"SXT ") }, // Ngoni -> Sutu
    LangTag { language: "nhd", 	tag: Tag::from_bytes(b"GUA ") }, // Chiripá -> Guarani
    LangTag { language: "niq", 	tag: Tag::from_bytes(b"KAL ") }, // Nandi -> Kalenjin
//  LangTag { language: "niu", 	tag: Tag::from_bytes(b"NIU ") }, // Niuean
    LangTag { language: "niv", 	tag: Tag::from_bytes(b"GIL ") }, // Gilyak
    LangTag { language: "njz", 	tag: Tag::from_bytes(b"NIS ") }, // Nyishi -> Nisi
    LangTag { language: "nl", 	tag: Tag::from_bytes(b"NLD ") }, // Dutch
    LangTag { language: "nle", 	tag: Tag::from_bytes(b"LUH ") }, // East Nyala -> Luyia
    LangTag { language: "nn", 	tag: Tag::from_bytes(b"NYN ") }, // Norwegian Nynorsk (Nynorsk, Norwegian)
    LangTag { language: "no", 	tag: Tag::from_bytes(b"NOR ") }, // Norwegian [macrolanguage]
    LangTag { language: "nod", 	tag: Tag::from_bytes(b"NTA ") }, // Northern Thai -> Northern Tai
//  LangTag { language: "noe", 	tag: Tag::from_bytes(b"NOE ") }, // Nimadi
//  LangTag { language: "nog", 	tag: Tag::from_bytes(b"NOG ") }, // Nogai
//  LangTag { language: "nov", 	tag: Tag::from_bytes(b"NOV ") }, // Novial
    LangTag { language: "npi", 	tag: Tag::from_bytes(b"NEP ") }, // Nepali
    LangTag { language: "nqo", 	tag: Tag::from_bytes(b"NKO ") }, // N’Ko
    LangTag { language: "nr", 	tag: Tag::from_bytes(b"NDB ") }, // South Ndebele -> Ndebele
    LangTag { language: "nsk", 	tag: Tag::from_bytes(b"NAS ") }, // Naskapi
//  LangTag { language: "nso", 	tag: Tag::from_bytes(b"NSO ") }, // Pedi -> Sotho, Northern
    LangTag { language: "nv", 	tag: Tag::from_bytes(b"NAV ") }, // Navajo
    LangTag { language: "nv", 	tag: Tag::from_bytes(b"ATH ") }, // Navajo -> Athapaskan
    LangTag { language: "ny", 	tag: Tag::from_bytes(b"CHI ") }, // Chichewa (Chewa, Nyanja)
    LangTag { language: "nyd", 	tag: Tag::from_bytes(b"LUH ") }, // Nyore -> Luyia
//  LangTag { language: "nym", 	tag: Tag::from_bytes(b"NYM ") }, // Nyamwezi
    LangTag { language: "nyn", 	tag: Tag::from_bytes(b"NKL ") }, // Nyankole
//  LangTag { language: "nza", 	tag: Tag::from_bytes(b"NZA ") }, // Tigon Mbembe -> Mbembe Tigon
    LangTag { language: "oc", 	tag: Tag::from_bytes(b"OCI ") }, // Occitan (post 1500)
    LangTag { language: "oj", 	tag: Tag::from_bytes(b"OJB ") }, // Ojibwa [macrolanguage] -> Ojibway
//  LangTag { language: "ojb", 	tag: Tag::from_bytes(b"OJB ") }, // Northwestern Ojibwa -> Ojibway
    LangTag { language: "ojc", 	tag: Tag::from_bytes(b"OJB ") }, // Central Ojibwa -> Ojibway
    LangTag { language: "ojg", 	tag: Tag::from_bytes(b"OJB ") }, // Eastern Ojibwa -> Ojibway
    LangTag { language: "ojs", 	tag: Tag::from_bytes(b"OCR ") }, // Severn Ojibwa -> Oji-Cree
    LangTag { language: "ojw", 	tag: Tag::from_bytes(b"OJB ") }, // Western Ojibwa -> Ojibway
    LangTag { language: "oki", 	tag: Tag::from_bytes(b"KAL ") }, // Okiek -> Kalenjin
    LangTag { language: "okm", 	tag: Tag::from_bytes(b"KOH ") }, // Middle Korean (10th-16th cent.) -> Korean Old Hangul
    LangTag { language: "om", 	tag: Tag::from_bytes(b"ORO ") }, // Oromo [macrolanguage]
    LangTag { language: "or", 	tag: Tag::from_bytes(b"ORI ") }, // Odia (formerly Oriya) [macrolanguage]
    LangTag { language: "orc", 	tag: Tag::from_bytes(b"ORO ") }, // Orma -> Oromo
    LangTag { language: "orn", 	tag: Tag::from_bytes(b"MLY ") }, // Orang Kanaq -> Malay
    LangTag { language: "ors", 	tag: Tag::from_bytes(b"MLY ") }, // Orang Seletar -> Malay
    LangTag { language: "ory", 	tag: Tag::from_bytes(b"ORI ") }, // Odia (formerly Oriya)
    LangTag { language: "os", 	tag: Tag::from_bytes(b"OSS ") }, // Ossetian
    LangTag { language: "otw", 	tag: Tag::from_bytes(b"OJB ") }, // Ottawa -> Ojibway
    LangTag { language: "pa", 	tag: Tag::from_bytes(b"PAN ") }, // Punjabi
//  LangTag { language: "pag", 	tag: Tag::from_bytes(b"PAG ") }, // Pangasinan
//  LangTag { language: "pam", 	tag: Tag::from_bytes(b"PAM ") }, // Pampanga -> Pampangan
    LangTag { language: "pap", 	tag: Tag::from_bytes(b"PAP0") }, // Papiamento -> Papiamentu
//  LangTag { language: "pau", 	tag: Tag::from_bytes(b"PAU ") }, // Palauan
    LangTag { language: "pbt", 	tag: Tag::from_bytes(b"PAS ") }, // Southern Pashto -> Pashto
    LangTag { language: "pbu", 	tag: Tag::from_bytes(b"PAS ") }, // Northern Pashto -> Pashto
//  LangTag { language: "pcc", 	tag: Tag::from_bytes(b"PCC ") }, // Bouyei
//  LangTag { language: "pcd", 	tag: Tag::from_bytes(b"PCD ") }, // Picard
    LangTag { language: "pce", 	tag: Tag::from_bytes(b"PLG ") }, // Ruching Palaung -> Palaung
    LangTag { language: "pck", 	tag: Tag::from_bytes(b"QIN ") }, // Paite Chin -> Chin
//  LangTag { language: "pdc", 	tag: Tag::from_bytes(b"PDC ") }, // Pennsylvania German
    LangTag { language: "pel", 	tag: Tag::from_bytes(b"MLY ") }, // Pekal -> Malay
    LangTag { language: "pes", 	tag: Tag::from_bytes(b"FAR ") }, // Iranian Persian -> Persian
    LangTag { language: "pga", 	tag: Tag::from_bytes(b"ARA ") }, // Sudanese Creole Arabic -> Arabic
//  LangTag { language: "phk", 	tag: Tag::from_bytes(b"PHK ") }, // Phake
    LangTag { language: "pi", 	tag: Tag::from_bytes(b"PAL ") }, // Pali
//  LangTag { language: "pih", 	tag: Tag::from_bytes(b"PIH ") }, // Pitcairn-Norfolk -> Norfolk
    LangTag { language: "pko", 	tag: Tag::from_bytes(b"KAL ") }, // Pökoot -> Kalenjin
    LangTag { language: "pl", 	tag: Tag::from_bytes(b"PLK ") }, // Polish
    LangTag { language: "pll", 	tag: Tag::from_bytes(b"PLG ") }, // Shwe Palaung -> Palaung
    LangTag { language: "plp", 	tag: Tag::from_bytes(b"PAP ") }, // Palpa
    LangTag { language: "plt", 	tag: Tag::from_bytes(b"MLG ") }, // Plateau Malagasy -> Malagasy
//  LangTag { language: "pms", 	tag: Tag::from_bytes(b"PMS ") }, // Piemontese
//  LangTag { language: "pnb", 	tag: Tag::from_bytes(b"PNB ") }, // Western Panjabi
//  LangTag { language: "poh", 	tag: Tag::from_bytes(b"POH ") }, // Poqomchi' -> Pocomchi
//  LangTag { language: "pon", 	tag: Tag::from_bytes(b"PON ") }, // Pohnpeian
    LangTag { language: "ppa", 	tag: Tag::from_bytes(b"BAG ") }, // Pao(retired code) -> Baghelkhandi
//  LangTag { language: "pro", 	tag: Tag::from_bytes(b"PRO ") }, // Old Provençal (to 1500) -> Provençal / Old Provençal
    LangTag { language: "prs", 	tag: Tag::from_bytes(b"DRI ") }, // Dari
    LangTag { language: "ps", 	tag: Tag::from_bytes(b"PAS ") }, // Pashto [macrolanguage]
    LangTag { language: "pse", 	tag: Tag::from_bytes(b"MLY ") }, // Central Malay -> Malay
    LangTag { language: "pst", 	tag: Tag::from_bytes(b"PAS ") }, // Central Pashto -> Pashto
    LangTag { language: "pt", 	tag: Tag::from_bytes(b"PTG ") }, // Portuguese
//  LangTag { language: "pwo", 	tag: Tag::from_bytes(b"PWO ") }, // Pwo Western Karen -> Western Pwo Karen
    LangTag { language: "qu", 	tag: Tag::from_bytes(b"QUZ ") }, // Quechua [macrolanguage]
    LangTag { language: "qub", 	tag: Tag::from_bytes(b"QWH ") }, // Huallaga Huánuco Quechua -> Quechua (Peru)
//  LangTag { language: "quc", 	tag: Tag::from_bytes(b"QUC ") }, // K’iche’
    LangTag { language: "qud", 	tag: Tag::from_bytes(b"QVI ") }, // Calderón Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "quf", 	tag: Tag::from_bytes(b"QUZ ") }, // Lambayeque Quechua -> Quechua
    LangTag { language: "qug", 	tag: Tag::from_bytes(b"QVI ") }, // Chimborazo Highland Quichua -> Quechua (Ecuador)
//  LangTag { language: "quh", 	tag: Tag::from_bytes(b"QUH ") }, // South Bolivian Quechua -> Quechua (Bolivia)
    LangTag { language: "quk", 	tag: Tag::from_bytes(b"QUZ ") }, // Chachapoyas Quechua -> Quechua
    LangTag { language: "qul", 	tag: Tag::from_bytes(b"QUZ ") }, // North Bolivian Quechua -> Quechua
    LangTag { language: "qup", 	tag: Tag::from_bytes(b"QVI ") }, // Southern Pastaza Quechua -> Quechua (Ecuador)
    LangTag { language: "qur", 	tag: Tag::from_bytes(b"QWH ") }, // Yanahuanca Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qus", 	tag: Tag::from_bytes(b"QUH ") }, // Santiago del Estero Quichua -> Quechua (Bolivia)
    LangTag { language: "quw", 	tag: Tag::from_bytes(b"QVI ") }, // Tena Lowland Quichua -> Quechua (Ecuador)
    LangTag { language: "qux", 	tag: Tag::from_bytes(b"QWH ") }, // Yauyos Quechua -> Quechua (Peru)
    LangTag { language: "quy", 	tag: Tag::from_bytes(b"QUZ ") }, // Ayacucho Quechua -> Quechua
//  LangTag { language: "quz", 	tag: Tag::from_bytes(b"QUZ ") }, // Cusco Quechua -> Quechua
    LangTag { language: "qva", 	tag: Tag::from_bytes(b"QWH ") }, // Ambo-Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qvc", 	tag: Tag::from_bytes(b"QUZ ") }, // Cajamarca Quechua -> Quechua
    LangTag { language: "qve", 	tag: Tag::from_bytes(b"QUZ ") }, // Eastern Apurímac Quechua -> Quechua
    LangTag { language: "qvh", 	tag: Tag::from_bytes(b"QWH ") }, // Huamalíes-Dos de Mayo Huánuco Quechua -> Quechua (Peru)
//  LangTag { language: "qvi", 	tag: Tag::from_bytes(b"QVI ") }, // Imbabura Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qvj", 	tag: Tag::from_bytes(b"QVI ") }, // Loja Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qvl", 	tag: Tag::from_bytes(b"QWH ") }, // Cajatambo North Lima Quechua -> Quechua (Peru)
    LangTag { language: "qvm", 	tag: Tag::from_bytes(b"QWH ") }, // Margos-Yarowilca-Lauricocha Quechua -> Quechua (Peru)
    LangTag { language: "qvn", 	tag: Tag::from_bytes(b"QWH ") }, // North Junín Quechua -> Quechua (Peru)
    LangTag { language: "qvo", 	tag: Tag::from_bytes(b"QVI ") }, // Napo Lowland Quechua -> Quechua (Ecuador)
    LangTag { language: "qvp", 	tag: Tag::from_bytes(b"QWH ") }, // Pacaraos Quechua -> Quechua (Peru)
    LangTag { language: "qvs", 	tag: Tag::from_bytes(b"QUZ ") }, // San Martín Quechua -> Quechua
    LangTag { language: "qvw", 	tag: Tag::from_bytes(b"QWH ") }, // Huaylla Wanca Quechua -> Quechua (Peru)
    LangTag { language: "qvz", 	tag: Tag::from_bytes(b"QVI ") }, // Northern Pastaza Quichua -> Quechua (Ecuador)
    LangTag { language: "qwa", 	tag: Tag::from_bytes(b"QWH ") }, // Corongo Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qwc", 	tag: Tag::from_bytes(b"QUZ ") }, // Classical Quechua -> Quechua
//  LangTag { language: "qwh", 	tag: Tag::from_bytes(b"QWH ") }, // Huaylas Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qws", 	tag: Tag::from_bytes(b"QWH ") }, // Sihuas Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxa", 	tag: Tag::from_bytes(b"QWH ") }, // Chiquián Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxc", 	tag: Tag::from_bytes(b"QWH ") }, // Chincha Quechua -> Quechua (Peru)
    LangTag { language: "qxh", 	tag: Tag::from_bytes(b"QWH ") }, // Panao Huánuco Quechua -> Quechua (Peru)
    LangTag { language: "qxl", 	tag: Tag::from_bytes(b"QVI ") }, // Salasaca Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qxn", 	tag: Tag::from_bytes(b"QWH ") }, // Northern Conchucos Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxo", 	tag: Tag::from_bytes(b"QWH ") }, // Southern Conchucos Ancash Quechua -> Quechua (Peru)
    LangTag { language: "qxp", 	tag: Tag::from_bytes(b"QUZ ") }, // Puno Quechua -> Quechua
    LangTag { language: "qxr", 	tag: Tag::from_bytes(b"QVI ") }, // Cañar Highland Quichua -> Quechua (Ecuador)
    LangTag { language: "qxt", 	tag: Tag::from_bytes(b"QWH ") }, // Santa Ana de Tusi Pasco Quechua -> Quechua (Peru)
    LangTag { language: "qxu", 	tag: Tag::from_bytes(b"QUZ ") }, // Arequipa-La Unión Quechua -> Quechua
    LangTag { language: "qxw", 	tag: Tag::from_bytes(b"QWH ") }, // Jauja Wanca Quechua -> Quechua (Peru)
    LangTag { language: "rag", 	tag: Tag::from_bytes(b"LUH ") }, // Logooli -> Luyia
//  LangTag { language: "raj", 	tag: Tag::from_bytes(b"RAJ ") }, // Rajasthani [macrolanguage]
//  LangTag { language: "rar", 	tag: Tag::from_bytes(b"RAR ") }, // Rarotongan
    LangTag { language: "rbb", 	tag: Tag::from_bytes(b"PLG ") }, // Rumai Palaung -> Palaung
    LangTag { language: "rbl", 	tag: Tag::from_bytes(b"BIK ") }, // Miraya Bikol -> Bikol
//  LangTag { language: "rej", 	tag: Tag::from_bytes(b"REJ ") }, // Rejang
//  LangTag { language: "ria", 	tag: Tag::from_bytes(b"RIA ") }, // Riang (India)
//  LangTag { language: "rif", 	tag: Tag::from_bytes(b"RIF ") }, // Tarifit
//  LangTag { language: "rit", 	tag: Tag::from_bytes(b"RIT ") }, // Ritharrngu -> Ritarungo
    LangTag { language: "rki", 	tag: Tag::from_bytes(b"ARK ") }, // Rakhine
//  LangTag { language: "rkw", 	tag: Tag::from_bytes(b"RKW ") }, // Arakwal
    LangTag { language: "rm", 	tag: Tag::from_bytes(b"RMS ") }, // Romansh
    LangTag { language: "rmc", 	tag: Tag::from_bytes(b"ROY ") }, // Carpathian Romani -> Romany
    LangTag { language: "rmf", 	tag: Tag::from_bytes(b"ROY ") }, // Kalo Finnish Romani -> Romany
    LangTag { language: "rml", 	tag: Tag::from_bytes(b"ROY ") }, // Baltic Romani -> Romany
    LangTag { language: "rmn", 	tag: Tag::from_bytes(b"ROY ") }, // Balkan Romani -> Romany
    LangTag { language: "rmo", 	tag: Tag::from_bytes(b"ROY ") }, // Sinte Romani -> Romany
    LangTag { language: "rmw", 	tag: Tag::from_bytes(b"ROY ") }, // Welsh Romani -> Romany
//  LangTag { language: "rmy", 	tag: Tag::from_bytes(b"RMY ") }, // Vlax Romani
    LangTag { language: "rmz", 	tag: Tag::from_bytes(b"ARK ") }, // Marma -> Rakhine
    LangTag { language: "rn", 	tag: Tag::from_bytes(b"RUN ") }, // Rundi
    LangTag { language: "rnl", 	tag: Tag::from_bytes(b"HAL ") }, // Ranglong -> Halam (Falam Chin)
    LangTag { language: "ro", 	tag: Tag::from_bytes(b"ROM ") }, // Romanian
    LangTag { language: "rom", 	tag: Tag::from_bytes(b"ROY ") }, // Romany [macrolanguage]
//  LangTag { language: "rtm", 	tag: Tag::from_bytes(b"RTM ") }, // Rotuman
    LangTag { language: "ru", 	tag: Tag::from_bytes(b"RUS ") }, // Russian
    LangTag { language: "rue", 	tag: Tag::from_bytes(b"RSY ") }, // Rusyn
//  LangTag { language: "rup", 	tag: Tag::from_bytes(b"RUP ") }, // Aromanian
    LangTag { language: "rw", 	tag: Tag::from_bytes(b"RUA ") }, // Kinyarwanda
    LangTag { language: "rwr", 	tag: Tag::from_bytes(b"MAW ") }, // Marwari (India)
    LangTag { language: "sa", 	tag: Tag::from_bytes(b"SAN ") }, // Sanskrit
    LangTag { language: "sah", 	tag: Tag::from_bytes(b"YAK ") }, // Yakut -> Sakha
    LangTag { language: "sam", 	tag: Tag::from_bytes(b"PAA ") }, // Samaritan Aramaic -> Palestinian Aramaic
//  LangTag { language: "sas", 	tag: Tag::from_bytes(b"SAS ") }, // Sasak
//  LangTag { language: "sat", 	tag: Tag::from_bytes(b"SAT ") }, // Santali
    LangTag { language: "sc", 	tag: Tag::from_bytes(b"SRD ") }, // Sardinian [macrolanguage]
    LangTag { language: "sck", 	tag: Tag::from_bytes(b"SAD ") }, // Sadri
//  LangTag { language: "scn", 	tag: Tag::from_bytes(b"SCN ") }, // Sicilian
//  LangTag { language: "sco", 	tag: Tag::from_bytes(b"SCO ") }, // Scots
    LangTag { language: "scs", 	tag: Tag::from_bytes(b"SCS ") }, // North Slavey
    LangTag { language: "scs", 	tag: Tag::from_bytes(b"SLA ") }, // North Slavey -> Slavey
    LangTag { language: "scs", 	tag: Tag::from_bytes(b"ATH ") }, // North Slavey -> Athapaskan
    LangTag { language: "sd", 	tag: Tag::from_bytes(b"SND ") }, // Sindhi
    LangTag { language: "sdc", 	tag: Tag::from_bytes(b"SRD ") }, // Sassarese Sardinian -> Sardinian
    LangTag { language: "sdh", 	tag: Tag::from_bytes(b"KUR ") }, // Southern Kurdish -> Kurdish
    LangTag { language: "sdn", 	tag: Tag::from_bytes(b"SRD ") }, // Gallurese Sardinian -> Sardinian
    LangTag { language: "se", 	tag: Tag::from_bytes(b"NSM ") }, // Northern Sami
    LangTag { language: "seh", 	tag: Tag::from_bytes(b"SNA ") }, // Sena
    LangTag { language: "sek", 	tag: Tag::from_bytes(b"ATH ") }, // Sekani -> Athapaskan
//  LangTag { language: "sel", 	tag: Tag::from_bytes(b"SEL ") }, // Selkup
    LangTag { language: "sez", 	tag: Tag::from_bytes(b"QIN ") }, // Senthang Chin -> Chin
    LangTag { language: "sfm", 	tag: Tag::from_bytes(b"HMN ") }, // Small Flowery Miao -> Hmong
    LangTag { language: "sg", 	tag: Tag::from_bytes(b"SGO ") }, // Sango
//  LangTag { language: "sga", 	tag: Tag::from_bytes(b"SGA ") }, // Old Irish (to 900)
    LangTag { language: "sgc", 	tag: Tag::from_bytes(b"KAL ") }, // Kipsigis -> Kalenjin
//  LangTag { language: "sgs", 	tag: Tag::from_bytes(b"SGS ") }, // Samogitian
    LangTag { language: "sgw", 	tag: Tag::from_bytes(b"CHG ") }, // Sebat Bet Gurage -> Chaha Gurage
    LangTag { language: "sgw", 	tag: Tag::from_bytes(b"SGW ") }, // Sebat Bet Gurage -> Chaha Gurage(SIL fonts)
//  LangTag { language: "shi", 	tag: Tag::from_bytes(b"SHI ") }, // Tachelhit
//  LangTag { language: "shn", 	tag: Tag::from_bytes(b"SHN ") }, // Shan
    LangTag { language: "shu", 	tag: Tag::from_bytes(b"ARA ") }, // Chadian Arabic -> Arabic
    LangTag { language: "si", 	tag: Tag::from_bytes(b"SNH ") }, // Sinhala (Sinhalese)
//  LangTag { language: "sid", 	tag: Tag::from_bytes(b"SID ") }, // Sidamo
    LangTag { language: "sjd", 	tag: Tag::from_bytes(b"KSM ") }, // Kildin Sami
    LangTag { language: "sjo", 	tag: Tag::from_bytes(b"SIB ") }, // Xibe -> Sibe
    LangTag { language: "sk", 	tag: Tag::from_bytes(b"SKY ") }, // Slovak
    LangTag { language: "skg", 	tag: Tag::from_bytes(b"MLG ") }, // Sakalava Malagasy -> Malagasy
    LangTag { language: "skr", 	tag: Tag::from_bytes(b"SRK ") }, // Saraiki
    LangTag { language: "sl", 	tag: Tag::from_bytes(b"SLV ") }, // Slovenian
    LangTag { language: "sm", 	tag: Tag::from_bytes(b"SMO ") }, // Samoan
    LangTag { language: "sma", 	tag: Tag::from_bytes(b"SSM ") }, // Southern Sami
    LangTag { language: "smj", 	tag: Tag::from_bytes(b"LSM ") }, // Lule Sami
    LangTag { language: "smn", 	tag: Tag::from_bytes(b"ISM ") }, // Inari Sami
    LangTag { language: "sms", 	tag: Tag::from_bytes(b"SKS ") }, // Skolt Sami
    LangTag { language: "sn", 	tag: Tag::from_bytes(b"SNA0") }, // Shona
//  LangTag { language: "snk", 	tag: Tag::from_bytes(b"SNK ") }, // Soninke
    LangTag { language: "so", 	tag: Tag::from_bytes(b"SML ") }, // Somali
//  LangTag { language: "sop", 	tag: Tag::from_bytes(b"SOP ") }, // Songe
    LangTag { language: "spv", 	tag: Tag::from_bytes(b"ORI ") }, // Sambalpuri -> Odia (formerly Oriya)
    LangTag { language: "spy", 	tag: Tag::from_bytes(b"KAL ") }, // Sabaot -> Kalenjin
    LangTag { language: "sq", 	tag: Tag::from_bytes(b"SQI ") }, // Albanian [macrolanguage]
    LangTag { language: "sr", 	tag: Tag::from_bytes(b"SRB ") }, // Serbian
    LangTag { language: "src", 	tag: Tag::from_bytes(b"SRD ") }, // Logudorese Sardinian -> Sardinian
    LangTag { language: "sro", 	tag: Tag::from_bytes(b"SRD ") }, // Campidanese Sardinian -> Sardinian
//  LangTag { language: "srr", 	tag: Tag::from_bytes(b"SRR ") }, // Serer
    LangTag { language: "srs", 	tag: Tag::from_bytes(b"ATH ") }, // Sarsi -> Athapaskan
    LangTag { language: "ss", 	tag: Tag::from_bytes(b"SWZ ") }, // Swati
    LangTag { language: "ssh", 	tag: Tag::from_bytes(b"ARA ") }, // Shihhi Arabic -> Arabic
    LangTag { language: "st", 	tag: Tag::from_bytes(b"SOT ") }, // Southern Sotho -> Sotho, Southern
//  LangTag { language: "stq", 	tag: Tag::from_bytes(b"STQ ") }, // Saterfriesisch -> Saterland Frisian
    LangTag { language: "stv", 	tag: Tag::from_bytes(b"SIG ") }, // Silt'e -> Silte Gurage
    LangTag { language: "su", 	tag: Tag::from_bytes(b"SUN ") }, // Sundanese
//  LangTag { language: "suk", 	tag: Tag::from_bytes(b"SUK ") }, // Sukuma
    LangTag { language: "suq", 	tag: Tag::from_bytes(b"SUR ") }, // Suri
    LangTag { language: "sv", 	tag: Tag::from_bytes(b"SVE ") }, // Swedish
//  LangTag { language: "sva", 	tag: Tag::from_bytes(b"SVA ") }, // Svan
    LangTag { language: "sw", 	tag: Tag::from_bytes(b"SWK ") }, // Swahili  [macrolanguage]
    LangTag { language: "swb", 	tag: Tag::from_bytes(b"CMR ") }, // Maore Comorian -> Comorian
    LangTag { language: "swc", 	tag: Tag::from_bytes(b"SWK ") }, // Congo Swahili -> Swahili
    LangTag { language: "swh", 	tag: Tag::from_bytes(b"SWK ") }, // Swahili
    LangTag { language: "swv", 	tag: Tag::from_bytes(b"MAW ") }, // Shekhawati -> Marwari
//  LangTag { language: "sxu", 	tag: Tag::from_bytes(b"SXU ") }, // Upper Saxon
    LangTag { language: "syc", 	tag: Tag::from_bytes(b"SYR ") }, // Classical Syriac -> Syriac
//  LangTag { language: "syl", 	tag: Tag::from_bytes(b"SYL ") }, // Sylheti
//  LangTag { language: "syr", 	tag: Tag::from_bytes(b"SYR ") }, // Syriac [macrolanguage]
//  LangTag { language: "szl", 	tag: Tag::from_bytes(b"SZL ") }, // Silesian
    LangTag { language: "ta", 	tag: Tag::from_bytes(b"TAM ") }, // Tamil
    LangTag { language: "taa", 	tag: Tag::from_bytes(b"ATH ") }, // Lower Tanana -> Athapaskan
//  LangTag { language: "tab", 	tag: Tag::from_bytes(b"TAB ") }, // Tabassaran -> Tabasaran
    LangTag { language: "taq", 	tag: Tag::from_bytes(b"TMH ") }, // Tamasheq -> Tamashek
    LangTag { language: "tau", 	tag: Tag::from_bytes(b"ATH ") }, // Upper Tanana -> Athapaskan
    LangTag { language: "tcb", 	tag: Tag::from_bytes(b"ATH ") }, // Tanacross -> Athapaskan
    LangTag { language: "tce", 	tag: Tag::from_bytes(b"ATH ") }, // Southern Tutchone -> Athapaskan
    LangTag { language: "tcp", 	tag: Tag::from_bytes(b"QIN ") }, // Tawr Chin -> Chin
    LangTag { language: "tcy", 	tag: Tag::from_bytes(b"TUL ") }, // Tulu -> Tumbuka
    LangTag { language: "tcz", 	tag: Tag::from_bytes(b"QIN ") }, // Thado Chin -> Chin
//  LangTag { language: "tdd", 	tag: Tag::from_bytes(b"TDD ") }, // Tai Nüa -> Dehong Dai
    LangTag { language: "tdx", 	tag: Tag::from_bytes(b"MLG ") }, // Tandroy-Mahafaly Malagasy -> Malagasy
    LangTag { language: "te", 	tag: Tag::from_bytes(b"TEL ") }, // Telugu
    LangTag { language: "tec", 	tag: Tag::from_bytes(b"KAL ") }, // Terik -> Kalenjin
    LangTag { language: "tem", 	tag: Tag::from_bytes(b"TMN ") }, // Timne -> Temne
//  LangTag { language: "tet", 	tag: Tag::from_bytes(b"TET ") }, // Tetum
    LangTag { language: "tfn", 	tag: Tag::from_bytes(b"ATH ") }, // Tanaina -> Athapaskan
    LangTag { language: "tg", 	tag: Tag::from_bytes(b"TAJ ") }, // Tajik -> Tajiki
    LangTag { language: "tgj", 	tag: Tag::from_bytes(b"NIS ") }, // Tagin -> Nisi
    LangTag { language: "tgx", 	tag: Tag::from_bytes(b"ATH ") }, // Tagish -> Athapaskan
    LangTag { language: "th", 	tag: Tag::from_bytes(b"THA ") }, // Thai
    LangTag { language: "tht", 	tag: Tag::from_bytes(b"ATH ") }, // Tahltan -> Athapaskan
    LangTag { language: "thv", 	tag: Tag::from_bytes(b"TMH ") }, // Tahaggart Tamahaq -> Tamashek
    LangTag { language: "thz", 	tag: Tag::from_bytes(b"TMH ") }, // Tayart Tamajeq -> Tamashek
    LangTag { language: "ti", 	tag: Tag::from_bytes(b"TGY ") }, // Tigrinya
    LangTag { language: "tig", 	tag: Tag::from_bytes(b"TGR ") }, // Tigre
//  LangTag { language: "tiv", 	tag: Tag::from_bytes(b"TIV ") }, // Tiv
    LangTag { language: "tk", 	tag: Tag::from_bytes(b"TKM ") }, // Turkmen
    LangTag { language: "tkg", 	tag: Tag::from_bytes(b"MLG ") }, // Tesaka Malagasy -> Malagasy
    LangTag { language: "tl", 	tag: Tag::from_bytes(b"TGL ") }, // Tagalog
//  LangTag { language: "tmh", 	tag: Tag::from_bytes(b"TMH ") }, // Tamashek [macrolanguage]
    LangTag { language: "tmw", 	tag: Tag::from_bytes(b"MLY ") }, // Temuan -> Malay
    LangTag { language: "tn", 	tag: Tag::from_bytes(b"TNA ") }, // Tswana
    LangTag { language: "tnf", 	tag: Tag::from_bytes(b"DRI ") }, // Tangshewi(retired code) -> Dari
    LangTag { language: "to", 	tag: Tag::from_bytes(b"TGN ") }, // Tonga (Tonga Islands) -> Tongan
    LangTag { language: "tod", 	tag: Tag::from_bytes(b"TOD0") }, // Toma
    LangTag { language: "toi", 	tag: Tag::from_bytes(b"TNG ") }, // Tonga (Zambia)
    LangTag { language: "tol", 	tag: Tag::from_bytes(b"ATH ") }, // Tolowa -> Athapaskan
//  LangTag { language: "tpi", 	tag: Tag::from_bytes(b"TPI ") }, // Tok Pisin
    LangTag { language: "tr", 	tag: Tag::from_bytes(b"TRK ") }, // Turkish
    LangTag { language: "tru", 	tag: Tag::from_bytes(b"TUA ") }, // Turoyo -> Turoyo Aramaic
    LangTag { language: "tru", 	tag: Tag::from_bytes(b"SYR ") }, // Turoyo -> Syriac
    LangTag { language: "ts", 	tag: Tag::from_bytes(b"TSG ") }, // Tsonga
//  LangTag { language: "tsj", 	tag: Tag::from_bytes(b"TSJ ") }, // Tshangla
    LangTag { language: "tt", 	tag: Tag::from_bytes(b"TAT ") }, // Tatar
    LangTag { language: "ttm", 	tag: Tag::from_bytes(b"ATH ") }, // Northern Tutchone -> Athapaskan
    LangTag { language: "ttq", 	tag: Tag::from_bytes(b"TMH ") }, // Tawallammat Tamajaq -> Tamashek
//  LangTag { language: "tum", 	tag: Tag::from_bytes(b"TUM ") }, // Tumbuka -> Tulu
    LangTag { language: "tuu", 	tag: Tag::from_bytes(b"ATH ") }, // Tututni -> Athapaskan
    LangTag { language: "tuy", 	tag: Tag::from_bytes(b"KAL ") }, // Tugen -> Kalenjin
//  LangTag { language: "tvl", 	tag: Tag::from_bytes(b"TVL ") }, // Tuvalu
    LangTag { language: "tw", 	tag: Tag::from_bytes(b"TWI ") }, // Twi
    LangTag { language: "tw", 	tag: Tag::from_bytes(b"AKA ") }, // Twi -> Akan
    LangTag { language: "txc", 	tag: Tag::from_bytes(b"ATH ") }, // Tsetsaut -> Athapaskan
    LangTag { language: "txy", 	tag: Tag::from_bytes(b"MLG ") }, // Tanosy Malagasy -> Malagasy
    LangTag { language: "ty", 	tag: Tag::from_bytes(b"THT ") }, // Tahitian
    LangTag { language: "tyv", 	tag: Tag::from_bytes(b"TUV ") }, // Tuvinian -> Tuvin
//  LangTag { language: "tyz", 	tag: Tag::from_bytes(b"TYZ ") }, // Tày
//  LangTag { language: "tzm", 	tag: Tag::from_bytes(b"TZM ") }, // Central Atlas Tamazight -> Tamazight
//  LangTag { language: "tzo", 	tag: Tag::from_bytes(b"TZO ") }, // Tzotzil
    LangTag { language: "ubl", 	tag: Tag::from_bytes(b"BIK ") }, // Buhi'non Bikol -> Bikol
//  LangTag { language: "udm", 	tag: Tag::from_bytes(b"UDM ") }, // Udmurt
    LangTag { language: "ug", 	tag: Tag::from_bytes(b"UYG ") }, // Uyghur
    LangTag { language: "uk", 	tag: Tag::from_bytes(b"UKR ") }, // Ukrainian
//  LangTag { language: "umb", 	tag: Tag::from_bytes(b"UMB ") }, // Umbundu
    LangTag { language: "unr", 	tag: Tag::from_bytes(b"MUN ") }, // Mundari
    LangTag { language: "ur", 	tag: Tag::from_bytes(b"URD ") }, // Urdu
    LangTag { language: "urk", 	tag: Tag::from_bytes(b"MLY ") }, // Urak Lawoi' -> Malay
    LangTag { language: "uz", 	tag: Tag::from_bytes(b"UZB ") }, // Uzbek [macrolanguage]
    LangTag { language: "uzn", 	tag: Tag::from_bytes(b"UZB ") }, // Northern Uzbek -> Uzbek
    LangTag { language: "uzs", 	tag: Tag::from_bytes(b"UZB ") }, // Southern Uzbek -> Uzbek
    LangTag { language: "ve", 	tag: Tag::from_bytes(b"VEN ") }, // Venda
//  LangTag { language: "vec", 	tag: Tag::from_bytes(b"VEC ") }, // Venetian
    LangTag { language: "vi", 	tag: Tag::from_bytes(b"VIT ") }, // Vietnamese
    LangTag { language: "vkk", 	tag: Tag::from_bytes(b"MLY ") }, // Kaur -> Malay
    LangTag { language: "vkt", 	tag: Tag::from_bytes(b"MLY ") }, // Tenggarong Kutai Malay -> Malay
    LangTag { language: "vls", 	tag: Tag::from_bytes(b"FLE ") }, // Vlaams -> Dutch (Flemish)
    LangTag { language: "vmw", 	tag: Tag::from_bytes(b"MAK ") }, // Makhuwa
    LangTag { language: "vo", 	tag: Tag::from_bytes(b"VOL ") }, // Volapük
//  LangTag { language: "vro", 	tag: Tag::from_bytes(b"VRO ") }, // Võro
    LangTag { language: "wa", 	tag: Tag::from_bytes(b"WLN ") }, // Walloon
//  LangTag { language: "war", 	tag: Tag::from_bytes(b"WAR ") }, // Waray (Philippines) -> Waray-Waray
    LangTag { language: "wbm", 	tag: Tag::from_bytes(b"WA  ") }, // Wa
    LangTag { language: "wbr", 	tag: Tag::from_bytes(b"WAG ") }, // Wagdi
    LangTag { language: "wlc", 	tag: Tag::from_bytes(b"CMR ") }, // Mwali Comorian -> Comorian
    LangTag { language: "wle", 	tag: Tag::from_bytes(b"SIG ") }, // Wolane -> Silte Gurage
    LangTag { language: "wlk", 	tag: Tag::from_bytes(b"ATH ") }, // Wailaki -> Athapaskan
    LangTag { language: "wni", 	tag: Tag::from_bytes(b"CMR ") }, // Ndzwani Comorian -> Comorian
    LangTag { language: "wo", 	tag: Tag::from_bytes(b"WLF ") }, // Wolof
    LangTag { language: "wry", 	tag: Tag::from_bytes(b"MAW ") }, // Merwari -> Marwari
    LangTag { language: "wsg", 	tag: Tag::from_bytes(b"GON ") }, // Adilabad Gondi -> Gondi
//  LangTag { language: "wtm", 	tag: Tag::from_bytes(b"WTM ") }, // Mewati
    LangTag { language: "wuu", 	tag: Tag::from_bytes(b"ZHS ") }, // Wu Chinese -> Chinese Simplified
    LangTag { language: "xal", 	tag: Tag::from_bytes(b"KLM ") }, // Kalmyk
    LangTag { language: "xal", 	tag: Tag::from_bytes(b"TOD ") }, // Kalmyk -> Todo
    LangTag { language: "xan", 	tag: Tag::from_bytes(b"SEK ") }, // Xamtanga -> Sekota
    LangTag { language: "xh", 	tag: Tag::from_bytes(b"XHS ") }, // Xhosa
//  LangTag { language: "xjb", 	tag: Tag::from_bytes(b"XJB ") }, // Minjungbal -> Minjangbal
//  LangTag { language: "xkf", 	tag: Tag::from_bytes(b"XKF ") }, // Khengkha
    LangTag { language: "xmm", 	tag: Tag::from_bytes(b"MLY ") }, // Manado Malay -> Malay
    LangTag { language: "xmv", 	tag: Tag::from_bytes(b"MLG ") }, // Antankarana Malagasy -> Malagasy
    LangTag { language: "xmw", 	tag: Tag::from_bytes(b"MLG ") }, // Tsimihety Malagasy -> Malagasy
    LangTag { language: "xnr", 	tag: Tag::from_bytes(b"DGR ") }, // Kangri -> Dogri
//  LangTag { language: "xog", 	tag: Tag::from_bytes(b"XOG ") }, // Soga
//  LangTag { language: "xpe", 	tag: Tag::from_bytes(b"XPE ") }, // Liberia Kpelle -> Kpelle (Liberia)
    LangTag { language: "xsl", 	tag: Tag::from_bytes(b"SSL ") }, // South Slavey
    LangTag { language: "xsl", 	tag: Tag::from_bytes(b"SLA ") }, // South Slavey -> Slavey
    LangTag { language: "xsl", 	tag: Tag::from_bytes(b"ATH ") }, // South Slavey -> Athapaskan
    LangTag { language: "xst", 	tag: Tag::from_bytes(b"SIG ") }, // Silt'e(retired code) -> Silte Gurage
    LangTag { language: "xwo", 	tag: Tag::from_bytes(b"TOD ") }, // Written Oirat -> Todo
//  LangTag { language: "yao", 	tag: Tag::from_bytes(b"YAO ") }, // Yao
//  LangTag { language: "yap", 	tag: Tag::from_bytes(b"YAP ") }, // Yapese
    LangTag { language: "ybd", 	tag: Tag::from_bytes(b"ARK ") }, // Yangbye(retired code) -> Rakhine
    LangTag { language: "ydd", 	tag: Tag::from_bytes(b"JII ") }, // Eastern Yiddish -> Yiddish
    LangTag { language: "yi", 	tag: Tag::from_bytes(b"JII ") }, // Yiddish [macrolanguage]
    LangTag { language: "yih", 	tag: Tag::from_bytes(b"JII ") }, // Western Yiddish -> Yiddish
    LangTag { language: "yo", 	tag: Tag::from_bytes(b"YBA ") }, // Yoruba
    LangTag { language: "yos", 	tag: Tag::from_bytes(b"QIN ") }, // Yos(retired code) -> Chin
    LangTag { language: "yrk", 	tag: Tag::from_bytes(b"TNE ") }, // Nenets -> Tundra Nenets
    LangTag { language: "yrk", 	tag: Tag::from_bytes(b"FNE ") }, // Nenets -> Forest Nenets
    LangTag { language: "yue", 	tag: Tag::from_bytes(b"ZHH ") }, // Yue Chinese -> Chinese, Hong Kong SAR
    LangTag { language: "za", 	tag: Tag::from_bytes(b"ZHA ") }, // Zhuang [macrolanguage]
    LangTag { language: "zch", 	tag: Tag::from_bytes(b"ZHA ") }, // Central Hongshuihe Zhuang -> Zhuang
    LangTag { language: "zdj", 	tag: Tag::from_bytes(b"CMR ") }, // Ngazidja Comorian -> Comorian
//  LangTag { language: "zea", 	tag: Tag::from_bytes(b"ZEA ") }, // Zeeuws -> Zealandic
    LangTag { language: "zeh", 	tag: Tag::from_bytes(b"ZHA ") }, // Eastern Hongshuihe Zhuang -> Zhuang
    LangTag { language: "zgb", 	tag: Tag::from_bytes(b"ZHA ") }, // Guibei Zhuang -> Zhuang
//  LangTag { language: "zgh", 	tag: Tag::from_bytes(b"ZGH ") }, // Standard Moroccan Tamazight
    LangTag { language: "zgm", 	tag: Tag::from_bytes(b"ZHA ") }, // Minz Zhuang -> Zhuang
    LangTag { language: "zgn", 	tag: Tag::from_bytes(b"ZHA ") }, // Guibian Zhuang -> Zhuang
    LangTag { language: "zh", 	tag: Tag::from_bytes(b"ZHS ") }, // Chinese [macrolanguage] -> Chinese Simplified
    LangTag { language: "zhd", 	tag: Tag::from_bytes(b"ZHA ") }, // Dai Zhuang -> Zhuang
    LangTag { language: "zhn", 	tag: Tag::from_bytes(b"ZHA ") }, // Nong Zhuang -> Zhuang
    LangTag { language: "zlj", 	tag: Tag::from_bytes(b"ZHA ") }, // Liujiang Zhuang -> Zhuang
    LangTag { language: "zlm", 	tag: Tag::from_bytes(b"MLY ") }, // Malay
    LangTag { language: "zln", 	tag: Tag::from_bytes(b"ZHA ") }, // Lianshan Zhuang -> Zhuang
    LangTag { language: "zlq", 	tag: Tag::from_bytes(b"ZHA ") }, // Liuqian Zhuang -> Zhuang
    LangTag { language: "zmi", 	tag: Tag::from_bytes(b"MLY ") }, // Negeri Sembilan Malay -> Malay
    LangTag { language: "zne", 	tag: Tag::from_bytes(b"ZND ") }, // Zande
    LangTag { language: "zom", 	tag: Tag::from_bytes(b"QIN ") }, // Zou -> Chin
    LangTag { language: "zqe", 	tag: Tag::from_bytes(b"ZHA ") }, // Qiubei Zhuang -> Zhuang
    LangTag { language: "zsm", 	tag: Tag::from_bytes(b"MLY ") }, // Standard Malay -> Malay
    LangTag { language: "zu", 	tag: Tag::from_bytes(b"ZUL ") }, // Zulu
    LangTag { language: "zum", 	tag: Tag::from_bytes(b"LRC ") }, // Kumzari -> Luri
    LangTag { language: "zyb", 	tag: Tag::from_bytes(b"ZHA ") }, // Yongbei Zhuang -> Zhuang
    LangTag { language: "zyg", 	tag: Tag::from_bytes(b"ZHA ") }, // Yang Zhuang -> Zhuang
    LangTag { language: "zyj", 	tag: Tag::from_bytes(b"ZHA ") }, // Youjiang Zhuang -> Zhuang
    LangTag { language: "zyn", 	tag: Tag::from_bytes(b"ZHA ") }, // Yongnan Zhuang -> Zhuang
//  LangTag { language: "zza", 	tag: Tag::from_bytes(b"ZZA ") }, // Zazaki [macrolanguage]
    LangTag { language: "zzj", 	tag: Tag::from_bytes(b"ZHA ") }, // Zuojiang Zhuang -> Zhuang
];

fn subtag_matches(language: &str, subtag: &str) -> bool {
    for(i, _) in language.match_indices(subtag) {
        if let Some(c) = language.as_bytes().get(i + subtag.len()) {
            if !c.is_ascii_alphanumeric() {
                return true;
            }
        } else {
            return true;
        }
    }

    false
}

fn lang_matches(language: &str, spec: &str) -> bool {
    if language.starts_with(spec) {
        return language.len() == spec.len() || language.as_bytes().get(spec.len()) == Some(&b'-');
    }

    false
}

fn strncmp(s1: &str, s2: &str, n: usize) -> bool {
    let n1 = core::cmp::min(n, s1.len());
    let n2 = core::cmp::min(n, s2.len());
    s1[..n1] == s2[..n2]
}

/// Converts a multi-subtag BCP 47 language tag to language tags.
pub fn tags_from_complex_language(
    language: &str,
    tags: &mut smallvec::SmallVec<[Tag; 3]>,
) -> bool {
    if subtag_matches(language, "-fonnapa")  {
        // Undetermined; North American Phonetic Alphabet
        tags.push(Tag::from_bytes(b"APPH")); // Phonetic transcription—Americanist conventions
        return true;
    }
    if subtag_matches(language, "-polyton")  {
        // Modern Greek (1453-); Polytonic Greek
        tags.push(Tag::from_bytes(b"PGR ")); // Polytonic Greek
        return true;
    }
    if subtag_matches(language, "-provenc")  {
        // Occitan (post 1500); Provençal
        tags.push(Tag::from_bytes(b"PRO ")); // Provençal / Old Provençal
        return true;
    }
    if subtag_matches(language, "-fonipa")  {
        // Undetermined; International Phonetic Alphabet
        tags.push(Tag::from_bytes(b"IPPH")); // Phonetic transcription—IPA conventions
        return true;
    }
    if subtag_matches(language, "-geok")  {
        // Undetermined; Khutsuri (Asomtavruli and Nuskhuri)
        tags.push(Tag::from_bytes(b"KGE ")); // Khutsuri Georgian
        return true;
    }
    if subtag_matches(language, "-syre")  {
        // Undetermined; Syriac (Estrangelo variant)
        tags.push(Tag::from_bytes(b"SYRE")); // Syriac, Estrangela script-variant (equivalent to ISO 15924 'Syre')
        return true;
    }
    if subtag_matches(language, "-syrj")  {
        // Undetermined; Syriac (Western variant)
        tags.push(Tag::from_bytes(b"SYRJ")); // Syriac, Western script-variant (equivalent to ISO 15924 'Syrj')
        return true;
    }
    if subtag_matches(language, "-syrn")  {
        // Undetermined; Syriac (Eastern variant)
        tags.push(Tag::from_bytes(b"SYRN")); // Syriac, Eastern script-variant (equivalent to ISO 15924 'Syrn')
        return true;
    }
    match language.as_bytes()[0] {
        b'a' => {
            if &language[1..] == "rt-lojban" {
                // Lojban
                tags.push(Tag::from_bytes(b"JBO ")); // Lojban
                return true;
            }
        }
        b'c' => {
            if lang_matches(&language[1..], "do-hant-hk"){
                // Min Dong Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "do-hant-mo"){
                // Min Dong Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "jy-hant-hk"){
                // Jinyu Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "jy-hant-mo"){
                // Jinyu Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "mn-hant-hk"){
                // Mandarin Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "mn-hant-mo"){
                // Mandarin Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "px-hant-hk"){
                // Pu-Xian Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "px-hant-mo"){
                // Pu-Xian Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zh-hant-hk"){
                // Huizhou Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zh-hant-mo"){
                // Huizhou Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zo-hant-hk"){
                // Min Zhong Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "zo-hant-mo"){
                // Min Zhong Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "do-hans"){
                // Min Dong Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "do-hant"){
                // Min Dong Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "jy-hans"){
                // Jinyu Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "jy-hant"){
                // Jinyu Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "mn-hans"){
                // Mandarin Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "mn-hant"){
                // Mandarin Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "px-hans"){
                // Pu-Xian Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "px-hant"){
                // Pu-Xian Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "zh-hans"){
                // Huizhou Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "zh-hant"){
                // Huizhou Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "zo-hans"){
                // Min Zhong Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "zo-hant"){
                // Min Zhong Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-hk") {
                // Min Dong Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-mo") {
                // Min Dong Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "do-", 3) && subtag_matches(language, "-tw") {
                // Min Dong Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-hk") {
                // Jinyu Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-mo") {
                // Jinyu Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "jy-", 3) && subtag_matches(language, "-tw") {
                // Jinyu Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-hk") {
                // Mandarin Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-mo") {
                // Mandarin Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "mn-", 3) && subtag_matches(language, "-tw") {
                // Mandarin Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-hk") {
                // Pu-Xian Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-mo") {
                // Pu-Xian Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "px-", 3) && subtag_matches(language, "-tw") {
                // Pu-Xian Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-hk") {
                // Huizhou Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-mo") {
                // Huizhou Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zh-", 3) && subtag_matches(language, "-tw") {
                // Huizhou Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-hk") {
                // Min Zhong Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-mo") {
                // Min Zhong Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "zo-", 3) && subtag_matches(language, "-tw") {
                // Min Zhong Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        b'g' => {
            if lang_matches(&language[1..], "an-hant-hk"){
                // Gan Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hant-mo"){
                // Gan Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hans"){
                // Gan Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "an-hant"){
                // Gan Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "a-latg"){
                // Irish
                tags.push(Tag::from_bytes(b"IRT ")); // Irish Traditional
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-hk") {
                // Gan Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-mo") {
                // Gan Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-tw") {
                // Gan Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        b'h' => {
            if lang_matches(&language[1..], "ak-hant-hk"){
                // Hakka Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "ak-hant-mo"){
                // Hakka Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "sn-hant-hk"){
                // Xiang Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "sn-hant-mo"){
                // Xiang Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "ak-hans"){
                // Hakka Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "ak-hant"){
                // Hakka Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if lang_matches(&language[1..], "sn-hans"){
                // Xiang Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "sn-hant"){
                // Xiang Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-hk") {
                // Hakka Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-mo") {
                // Hakka Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "ak-", 3) && subtag_matches(language, "-tw") {
                // Hakka Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-hk") {
                // Xiang Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-mo") {
                // Xiang Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "sn-", 3) && subtag_matches(language, "-tw") {
                // Xiang Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        b'i' => {
            if &language[1..] == "-navajo" {
                // Navajo
                let possible_tags = &[
                    Tag::from_bytes(b"NAV "), // Navajo
                    Tag::from_bytes(b"ATH "), // Athapaskan
                ];
                tags.extend_from_slice(possible_tags);
                return true;
            }
            if &language[1..] == "-hak" {
                // Hakka
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if &language[1..] == "-lux" {
                // Luxembourgish
                tags.push(Tag::from_bytes(b"LTZ ")); // Luxembourgish
                return true;
            }
        }
        b'l' => {
            if lang_matches(&language[1..], "zh-hans"){
                // Literary Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
        }
        b'm' => {
            if lang_matches(&language[1..], "np-hant-hk"){
                // Min Bei Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "np-hant-mo"){
                // Min Bei Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "np-hans"){
                // Min Bei Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "np-hant"){
                // Min Bei Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-hk") {
                // Min Bei Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-mo") {
                // Min Bei Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "np-", 3) && subtag_matches(language, "-tw") {
                // Min Bei Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        b'n' => {
            if lang_matches(&language[1..], "an-hant-hk"){
                // Min Nan Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hant-mo"){
                // Min Nan Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "an-hans"){
                // Min Nan Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "an-hant"){
                // Min Nan Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-hk") {
                // Min Nan Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-mo") {
                // Min Nan Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "an-", 3) && subtag_matches(language, "-tw") {
                // Min Nan Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if &language[1..] == "o-bok" {
                // Norwegian Bokmal
                tags.push(Tag::from_bytes(b"NOR ")); // Norwegian
                return true;
            }
            if &language[1..] == "o-nyn" {
                // Norwegian Nynorsk
                tags.push(Tag::from_bytes(b"NYN ")); // Norwegian Nynorsk (Nynorsk, Norwegian)
                return true;
            }
        }
        b'r' => {
            if strncmp(&language[1..], "o-", 2) && subtag_matches(language, "-md") {
                // Romanian; Moldova
                tags.push(Tag::from_bytes(b"MOL ")); // Moldavian
                return true;
            }
        }
        b'w' => {
            if lang_matches(&language[1..], "uu-hant-hk"){
                // Wu Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "uu-hant-mo"){
                // Wu Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "uu-hans"){
                // Wu Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "uu-hant"){
                // Wu Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-hk") {
                // Wu Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-mo") {
                // Wu Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "uu-", 3) && subtag_matches(language, "-tw") {
                // Wu Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        b'y' => {
            if lang_matches(&language[1..], "ue-hans"){
                // Yue Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
        }
        b'z' => {
            if lang_matches(&language[1..], "h-hant-hk"){
                // Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if lang_matches(&language[1..], "h-hant-mo"){
                // Chinese
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if &language[1..] == "h-min-nan" {
                // Minnan, Hokkien, Amoy, Taiwanese, Southern Min, Southern Fujian, Hoklo, Southern Fukien, Ho-lo
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "h-hans"){
                // Chinese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if lang_matches(&language[1..], "h-hant"){
                // Chinese
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
            if &language[1..] == "h-min" {
                // Min, Fuzhou, Hokkien, Amoy, or Taiwanese
                tags.push(Tag::from_bytes(b"ZHS ")); // Chinese Simplified
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-hk") {
                // Chinese; Hong Kong
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-mo") {
                // Chinese; Macao
                tags.push(Tag::from_bytes(b"ZHH ")); // Chinese, Hong Kong SAR
                return true;
            }
            if strncmp(&language[1..], "h-", 2) && subtag_matches(language, "-tw") {
                // Chinese; Taiwan, Province of China
                tags.push(Tag::from_bytes(b"ZHT ")); // Chinese Traditional
                return true;
            }
        }
        _ => {}
    }
    false
}
