// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief D_s+ -> pi+ pi+ pi- pi0 pi0
  class BESIII_2025_I2866208 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2025_I2866208);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==431);
      declare(ufs, "UFS");
      DecayedParticles DS(ufs);
      DS.addStable(PID::PI0);
      DS.addStable(PID::K0S);
      declare(DS,"DS");
      // histos
      for(unsigned int ix=0;ix<8;++ix)
        book(_h[ix],1,1,1+ix);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      static const map<PdgId,unsigned int> & mode   = { { 211,2}, {-211,1}, { 111,2}};
      static const map<PdgId,unsigned int> & modeCC = { {-211,2}, { 211,1}, { 111,2}};
      DecayedParticles DS = apply<DecayedParticles>(event, "DS");
      // loop over particles
      for(unsigned int ix=0;ix<DS.decaying().size();++ix) {
	int sign = 1;
	if (DS.decaying()[ix].pid()>0 && DS.modeMatches(ix,5,mode)) {
	  sign=1;
	}
	else if  (DS.decaying()[ix].pid()<0 && DS.modeMatches(ix,5,modeCC)) {
	  sign=-1;
	}
	else
	  continue;
	const Particles & pi0 = DS.decayProducts()[ix].at(      111);
	const Particles & pip = DS.decayProducts()[ix].at( sign*211);
	const Particle  & pim = DS.decayProducts()[ix].at(-sign*211)[0];
	double m0   = (pi0[0].momentum() +pi0[1].momentum()).mass();
	// K_S0 veto
	if(m0>0.487 && m0<0.511) continue;
        if(pip[0].parents()[0].pid()==PID::K0S ||
           pip[1].parents()[0].pid()==PID::K0S ||
           pim   .parents()[0].pid()==PID::K0S) continue;
        // eta veto
        double mpm0[4];
        bool passCut=true;
        for(unsigned int ix=0;ix<2;++ix) {
          for(unsigned int iy=0;iy<2;++iy) {
            mpm0[2*ix+iy+1] = (pi0[ix].momentum()+pip[iy].momentum()+pim.momentum()).mass();
            if(mpm0[2*ix+iy+1]>.49 && mpm0[2*ix+iy+1]<.58) passCut=false;
          }
        }
        if( ! passCut) continue;
        _h[0]->fill(m0);
        for(unsigned int ix=0;ix<4;++ix) _h[4]->fill(mpm0[ix]);
        _h[5]->fill((pi0[0].momentum()+pi0[1].momentum()+pim.momentum()).mass());
        for(unsigned int ix=0;ix<2;++ix) {
          _h[2]->fill((pip[ix].momentum()+pim.momentum()).mass());
          _h[3]->fill((pi0[ix].momentum()+pim.momentum()).mass());
          _h[6]->fill((pip[0].momentum()+pip[1].momentum()+pi0[ix].momentum()+pim.momentum()).mass());
          _h[7]->fill((pi0[0].momentum()+pi0[1].momentum()+pip[ix].momentum()+pim.momentum()).mass());
          for(unsigned int iy=0;iy<2;++iy)
            _h[1]->fill((pip[ix].momentum()+pi0[iy].momentum()).mass());
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      normalize(_h);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[8];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2025_I2866208);

}
