/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.ide.ui.UISettings;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.editor.markdown.JsonFontSettingsIncrement;
import com.intellij.jupyter.core.jupyter.editor.markdown.OS;
import com.intellij.jupyter.core.jupyter.editor.markdown.Record;
import com.intellij.openapi.util.SystemInfo;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"incrementSizeJsonFile", "", "fontIncrementSettingsLazy", "Lkotlin/Lazy;", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/JsonFontSettingsIncrement;", "readIncrementFromFile", "", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/OS;", "fontIncrementSettings", "getFontIncrementSettings", "()Lcom/intellij/jupyter/core/jupyter/editor/markdown/JsonFontSettingsIncrement;", "baseFontSize", "", "Lcom/intellij/ide/ui/UISettings;", "getBaseFontSize", "(Lcom/intellij/ide/ui/UISettings;)I", "intellij.jupyter.core"})
public final class JsonFontSizeIncrementKt {
    @NotNull
    public static final String incrementSizeJsonFile = "increments.json";
    @NotNull
    private static final Lazy<JsonFontSettingsIncrement> fontIncrementSettingsLazy = LazyKt.lazy(JsonFontSizeIncrementKt::fontIncrementSettingsLazy$lambda$0);

    @NotNull
    public static final Map<OS, JsonFontSettingsIncrement> readIncrementFromFile() {
        byte[] byArray;
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path userSettings = path.resolve(incrementSizeJsonFile);
        Intrinsics.checkNotNull((Object)userSettings);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(userSettings, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            byte[] byArray2 = Files.readAllBytes(userSettings);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
        } else {
            URL uRL = Record.class.getClassLoader().getResource(incrementSizeJsonFile);
            Intrinsics.checkNotNull((Object)uRL);
            byArray = TextStreamsKt.readBytes((URL)uRL);
        }
        byte[] data = byArray;
        Object object = JupyterJsonKt.getJackson().readValue(data, (TypeReference)new TypeReference<Map<OS, ? extends JsonFontSettingsIncrement>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Map)object;
    }

    @NotNull
    public static final JsonFontSettingsIncrement getFontIncrementSettings() {
        return (JsonFontSettingsIncrement)fontIncrementSettingsLazy.getValue();
    }

    public static final int getBaseFontSize(@NotNull UISettings $this$baseFontSize) {
        Intrinsics.checkNotNullParameter((Object)$this$baseFontSize, (String)"<this>");
        return (int)(($this$baseFontSize.getOverrideLafFonts() ? $this$baseFontSize.getFontSize2D() : UISettings.Companion.getDefFontSize()) + (float)4);
    }

    private static final JsonFontSettingsIncrement fontIncrementSettingsLazy$lambda$0() {
        OS os = SystemInfo.isWindows ? OS.Windows : (SystemInfo.isLinux ? OS.Linux : (SystemInfo.isMac ? OS.Mac : OS.Linux));
        JsonFontSettingsIncrement jsonFontSettingsIncrement = JsonFontSizeIncrementKt.readIncrementFromFile().get((Object)os);
        Intrinsics.checkNotNull((Object)jsonFontSettingsIncrement);
        return jsonFontSettingsIncrement;
    }
}

