/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import org.assertj.swing.core.FrameDisposer;
import org.assertj.swing.core.MainThreadIdentifier;
import org.assertj.swing.core.SimpleFallbackExceptionHandler;
import org.assertj.swing.core.ThreadsSource;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.AWTExceptionHandlerInstaller;

class TestTerminator {
    private final ThreadsSource threadsSource;
    private final FrameDisposer frameDisposer;
    private final MainThreadIdentifier mainThreadIdentifier;

    TestTerminator() {
        this(new ThreadsSource(), new FrameDisposer(), new MainThreadIdentifier());
    }

    TestTerminator(@Nonnull ThreadsSource threadsSource, @Nonnull FrameDisposer frameDisposer, @Nonnull MainThreadIdentifier mainThreadIdentifier) {
        this.threadsSource = threadsSource;
        this.frameDisposer = frameDisposer;
        this.mainThreadIdentifier = mainThreadIdentifier;
    }

    void terminateTests() {
        this.pokeMainThread();
        this.frameDisposer.disposeFrames();
        throw new RuntimeException("User aborted FEST-Swing tests");
    }

    private void pokeMainThread() {
        Thread mainThread = this.mainThreadIdentifier.mainThreadIn(this.threadsSource.allThreads());
        if (mainThread != null) {
            mainThread.interrupt();
        }
    }

    static {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(SimpleFallbackExceptionHandler.class);
    }
}

