package monitorlegacy

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// GreaterThan ...
	GreaterThan ConditionOperator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// LessThan ...
	LessThan ConditionOperator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns an array of possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual}
}

// DataStatus enumerates the values for data status.
type DataStatus string

const (
	// NotPresent ...
	NotPresent DataStatus = "notPresent"
	// Present ...
	Present DataStatus = "present"
)

// PossibleDataStatusValues returns an array of possible values for the DataStatus const type.
func PossibleDataStatusValues() []DataStatus {
	return []DataStatus{NotPresent, Present}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
	// OdataTypeRuleDataSource ...
	OdataTypeRuleDataSource OdataType = "RuleDataSource"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource, OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource, OdataTypeRuleDataSource}
}

// OdataTypeBasicRuleAction enumerates the values for odata type basic rule action.
type OdataTypeBasicRuleAction string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
	// OdataTypeRuleAction ...
	OdataTypeRuleAction OdataTypeBasicRuleAction = "RuleAction"
)

// PossibleOdataTypeBasicRuleActionValues returns an array of possible values for the OdataTypeBasicRuleAction const type.
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return []OdataTypeBasicRuleAction{OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction, OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction, OdataTypeRuleAction}
}

// OdataTypeBasicRuleCondition enumerates the values for odata type basic rule condition.
type OdataTypeBasicRuleCondition string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
	// OdataTypeRuleCondition ...
	OdataTypeRuleCondition OdataTypeBasicRuleCondition = "RuleCondition"
)

// PossibleOdataTypeBasicRuleConditionValues returns an array of possible values for the OdataTypeBasicRuleCondition const type.
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return []OdataTypeBasicRuleCondition{OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition, OdataTypeRuleCondition}
}

// OnboardingStatus enumerates the values for onboarding status.
type OnboardingStatus string

const (
	// NotOnboarded ...
	NotOnboarded OnboardingStatus = "notOnboarded"
	// Onboarded ...
	Onboarded OnboardingStatus = "onboarded"
	// Unknown ...
	Unknown OnboardingStatus = "unknown"
)

// PossibleOnboardingStatusValues returns an array of possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{NotOnboarded, Onboarded, Unknown}
}

// TimeAggregationOperator enumerates the values for time aggregation operator.
type TimeAggregationOperator string

const (
	// Average ...
	Average TimeAggregationOperator = "Average"
	// Last ...
	Last TimeAggregationOperator = "Last"
	// Maximum ...
	Maximum TimeAggregationOperator = "Maximum"
	// Minimum ...
	Minimum TimeAggregationOperator = "Minimum"
	// Total ...
	Total TimeAggregationOperator = "Total"
)

// PossibleTimeAggregationOperatorValues returns an array of possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{Average, Last, Maximum, Minimum, Total}
}
