//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/9/25.
//

#ifndef UOS_RECOVERY_IMMUTABLE_TASK_H
#define UOS_RECOVERY_IMMUTABLE_TASK_H

#include "AsyncTask.h"
#include "global.h"
#include <QTimer>
#include <QTime>

class ImmutableTask : public AsyncTask
{
    Q_OBJECT
public:
    ImmutableTask();
    explicit ImmutableTask(OperateType opType);
    virtual ~ImmutableTask();

    virtual void readStandardOutput() override;
    virtual void readAllStandardError() override;
    virtual bool buildArgumentsForBackup() override;
    virtual bool buildArgumentsForRestore(const QString &) override;
    virtual void doResult() override;

    void init();
    void startTimer();
    void stopTimer();
    void setSnapshotID(const QString &id);
    void setSnapshotName(const QString &name);
    void setSnapshotDesc(const QString &desc);
    void setUiOperateUserName(const QString &userName);

Q_SIGNALS:
    void progressChanged(const QJsonObject &progress);
    void error(const QJsonObject &errJson);
    void success(const QJsonObject &errJson);

private Q_SLOTS:
    void onTimeOut();

private:
    void reportProgress(int progress, int remainSecond);
    void estimateRemainTime();
    bool creatSnapshot(const QString &name, const QString &des);
    bool rollbackSnapshot(const QString &id);

protected:
    QTimer m_timer;
    QTime m_startTime;
    int m_progress = 0;
    int m_remainSecond = 0;
    OperateType m_opType = OperateType::Invalid;
    QString m_immutableCtlCmd = "deepin-immutable-ctl";
    QString m_snapshotID;
    QString m_snapshotName;
    QString m_snapshotDes;
    QString m_uiOperateUserName; // 用户名
};

#endif //UOS_RECOVERY_IMMUTABLE_TASK_H
