//
// Created by uos on 2022/2/24.
//

#ifndef UOS_RECOVERY_ASYNCTASK_H
#define UOS_RECOVERY_ASYNCTASK_H

#include "Process.h"
#include <QThread>
#include <QProcess>


class AsyncTask : public QThread
{
    Q_OBJECT
public:
    explicit AsyncTask();
    virtual ~AsyncTask();
    virtual bool buildArgumentsForBackup() = 0;
    virtual bool buildArgumentsForRestore(const QString &fromDir) = 0;
    virtual void doResult() = 0;
    void run() override;
    void kill();
    void setTryNum(int num);

signals:
    void error(const QJsonObject &errJson);
    void success(const QJsonObject &errJson);
public slots:
    virtual void readStandardOutput();
    virtual void readAllStandardError();

protected:
    QString m_cmd;
    QStringList m_args;
    QProcess *m_process = nullptr;
    int m_tryNum = 0;
};


#endif //UOS_RECOVERY_ASYNCTASK_H
