#include "HelpDialog.h"
#include "utils/Utils.h"
#include <QPainter>
#include <QVBoxLayout>

HelpDialog::HelpDialog(QWidget *parent):
    DBlurEffectWidget (parent)
{
    setWindowFlags(windowFlags() | Qt::X11BypassWindowManagerHint);
    setBlendMode(DBlurEffectWidget::BehindWindowBlend);
    m_mainLayout = new QVBoxLayout;
}

void HelpDialog::setContentText(const QList<HelpInfoItem> &texts)
{
    deleteLayout(m_mainLayout);
    m_mainLayout->setContentsMargins(10,10,10,10);
    m_mainLayout->setSpacing(10);
    m_mainLayout->addStretch();

    for (int i = 0; i < texts.size(); i++) {
        QWidget *infoWidget = new QWidget();
        QVBoxLayout *infoLayout = new QVBoxLayout();
        infoWidget->setLayout(infoLayout);
        infoLayout->setContentsMargins(0,0,0,0);
        infoLayout->setSpacing(3);
        DLabel *titleLabel = new DLabel;
        titleLabel->setText(QString("· %1").arg(texts.at(i).title));
        QFont titleFont = titleLabel->font();
        titleFont.setWeight(QFont::ExtraBold);
        titleLabel->setFont(titleFont);
        DLabel *subTitleLabel = new DLabel;
        subTitleLabel->setText(texts.at(i).subTitle);
        subTitleLabel->setWordWrap(true);
        infoLayout->addWidget(titleLabel);
        infoLayout->addWidget(subTitleLabel);
        m_mainLayout->addWidget(infoWidget);
    }

    m_mainLayout->addStretch();
    setLayout(m_mainLayout);
    lower();
}

void HelpDialog::deleteLayout(QLayout* layout)
{
    if (layout == nullptr) {
        return;
    }

    while (QLayoutItem* item = layout->takeAt(0))
    {
        if (QWidget* widget = item->widget()) {
            widget->deleteLater();
        }

        if (QLayout* childLayout = item->layout()) {
            deleteLayout(childLayout);
        }

        if (QSpacerItem* spacerItem = item->spacerItem()) {
            layout->removeItem(spacerItem);
        }

        delete item;
    }
}

void HelpDialog::tipsPairList2HelpInfoItemList(const QList<QPair<QString, QString>> &tipsPairList,
                                               QList<HelpInfoItem> &itemList)
{
    itemList.clear();
    for (auto iter = tipsPairList.begin(); iter != tipsPairList.end(); ++iter) {
        HelpInfoItem item;
        item.title = iter->first;
        item.subTitle = iter->second;
        itemList.append(item);
    }
}

QPixmap HelpDialog::getPixMapByThemeType(Dtk::Gui::DGuiApplicationHelper::ColorType themeType)
{
    static QPixmap lightHelpPixMap = Utils::hidpiPixmap(":/resources/icons/help_32px.svg", QSize(20, 20));
    if (Dtk::Gui::DGuiApplicationHelper::ColorType::LightType == themeType) {
        return lightHelpPixMap;
    }

    if (Dtk::Gui::DGuiApplicationHelper::ColorType::DarkType == themeType) {
        QPixmap darkHelpPixMap = lightHelpPixMap;
        QPainter p(&darkHelpPixMap);
        p.setCompositionMode(QPainter::CompositionMode_SourceIn);
        p.fillRect(darkHelpPixMap.rect(), QColor(255, 255, 255, 70));
        p.end();

        return darkHelpPixMap;
    }

    return QPixmap();
}
