//
// Created by uos on 2022/3/17.
//

#ifndef UOS_RECOVERY_ADVANCEDMODULE_H
#define UOS_RECOVERY_ADVANCEDMODULE_H

#include "interface/ModuleInterface.h"
#include <QString>
#include <QObject>

class FrameProxyInterface;
class QString;
class AdvancedWidget;
class AdvancedGhostWidget;
class ProgressWidget;
class ResultWidget;
class SelectPartitionDialog;

class AdvancedModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit AdvancedModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                            QObject *parent = nullptr);
    ~AdvancedModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;
    void setSelinuxEnable(bool enable);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);

private slots:
    void onBack();
    bool onCheckSpace(const QString &selectDir);
    void onBackHome();
    void onStartMake(const QString &selectDir);
    void onShowGhostWidget();
    void updateProgress(const QString &progress);
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onSuccess(const QString &msg);

private:
    AdvancedWidget *m_advancedWidget = nullptr;
    AdvancedGhostWidget *m_advancedGhostWidget = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    ResultWidget *m_resultWidget = nullptr;
    qint64 m_backupSizeBytes = 0;
    QString m_curOperateID;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
};


#endif //UOS_RECOVERY_ADVANCEDMODULE_H
