/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * This file is dual-licensed.
 * In addition to the GPLv3 license mentioned above, this code is also
 * licensed under LGPL 2.1. See LICENSES/COPYING.LGPL file for the
 * full text of the license.
 *
 */

/* Detection tables for Adibou / Addy Junior series. */
/* This Game uses the DEV6 Engine, more Information can be found here: https://wiki.scummvm.org/index.php?title=DEV6_Information */
/* These games are part of the Adibou series. For more information, refer to our wiki: https://wiki.scummvm.org/index.php?title=Adibou_Games */

#ifndef GOB_DETECTION_TABLES_ADIBOU2_H
#define GOB_DETECTION_TABLES_ADIBOU2_H

// -- French: Adibou --

{
	{
		"adibou2",
		"ADIBOU 2",
		AD_ENTRY1s("intro.stk", "94ae7004348dc8bf99c23a9a6ef81827", 956162),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"Le Jardin Magique d'Adibou",
		AD_ENTRY1s("intro.stk", "a8ff86f3cc40dfe5898e0a741217ef27", 956328),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU Version Decouverte 2.11",
		AD_ENTRY1s("intro.stk", "558c14327b79ed39214b49d567a75e33", 8737856),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.10 Environnement",
		AD_ENTRY2s("intro.stk", "f2b797819aeedee557e904b0b5ccd82e", 8736454,
				   "BECBF210.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND | GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.11 Environnement",
		AD_ENTRY2s("intro.stk", "7b1f1f6f6477f54401e95d913f75e333", 8736904,
				   "BECBF211.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND | GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.12 Environnement",
		AD_ENTRY3s("intro.stk", "1e49c39a4a3ce6032a84b712539c2d63", 8738134,
				   "BECBF212.CD1", "bc828c320908a5eaa349956d396bd8e1", 8,
				   "intro.itk", "610b4ade4912442f42f342594c654226", 13592576),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND | GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.12 Environnement",
		AD_ENTRY3s("intro.stk", "1e49c39a4a3ce6032a84b712539c2d63", 8738134,
				   "BECBF212.CD1", "bc828c320908a5eaa349956d396bd8e1", 8,
				   "intro.itk", "269fc5814db277b5a18d748e7ed55e90", 15079424),
		FR_FRA, // Canadian French
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND | GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU 2.13s Environnement",
		AD_ENTRY2s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958,
				   "BECBF213.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		FR_FRA,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FREE_BANANAS_WORKAROUND | GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOO 2.14 Environnement",
		AD_ENTRY1s("intro.stk", "ff63637e3cb7f0a457edf79457b1c6b3", 9333874),
		FR_FRA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOU Environnement",
		AD_ENTRY1s("intro.stk", "5606ff29ef33ef423519eb24e8096afc", 8737284),
		FR_CAN,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- German: Addy Junior --

{
	{
		"adibou2",
		"ADDY JR 2.20 Basisprogramm",
		AD_ENTRY2s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958,
				   "BECBD220.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		DE_DEU,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{ // Supplied by felsqualle
		"adibou2",
		"ADI Junior 2",
		AD_ENTRY1s("intro.stk", "80588ad3b5510bb44d3f40d6b07b81e7", 956328),
		DE_DEU,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{ // Supplied by BJNFNE
		"adibou2",
		"ADI Jr.",
		AD_ENTRY2s("intro.stk", "718a51862406136c28639489a9ba950a", 956350,
				   "intro.inf", "d8710732c9bfe3ca52d3ce5aefc06089", 48),
		DE_DEU,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{ // Supplied by BJNFNE
		"adibou2",
		"ADDY JR 2.13 Basisprogramm",
		AD_ENTRY2s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958,
				   "BECBD213.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		DE_DEU,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Italian: Adibù --
{
	{
		"adibou2",
		"ADIBÙ 2.13 Ambiente",
		AD_ENTRY2s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958,
				   "BECBI213.CD1",	"bc828c320908a5eaa349956d396bd8e1", 8),
		IT_ITA,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Spanish: Adibù --
{
	{ // Supplied by eientei95
		"adibou2",
		"ADIBÙ 2",
		AD_ENTRY1s("intro.stk", "0b996fcd8929245fecddc4d9169843d0", 956682),
		ES_ESP,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- English: Adiboo --
{
	{ // Supplied by sdelamarre
		"adibou2",
		"ADIBOO 2",
		AD_ENTRY2s("intro.stk", "718a51862406136c28639489a9ba950a", 956350,
				   "intro.inf", "9369aa62939f5f7c11b1e02a45038050", 44),
		EN_GRB,
		kPlatformWindows,
		GF_ENABLE_ADIBOU2_FLOWERS_INFINITE_LOOP_WORKAROUND,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOO 2.13 Environment",
		AD_ENTRY1s("intro.stk", "ff63637e3cb7f0a457edf79457b1c6b3", 9333874),
		EN_GRB,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"ADIBOO 2.13 Environment",
		AD_ENTRY2s("intro.stk", "092707829555f27706920e4cacf1fada", 8737958,
				   "BECBA213.CD1", "bc828c320908a5eaa349956d396bd8e1", 8),
		EN_GRB,
		kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Add-ons : Read/Count 4-5 years --
{
	{
		"adibou2readcount45",
		"", // "Lecture/Calcul 4-5 ans"
		AD_ENTRY2s("intro_ap.stk", "7ff46d8c804186d3a11bf6b921fac2c0", 40835594,
				   "appli_01.vmd", "11635be4aeaac46d199e7e37cf905240", 54402),
		FR_FRA,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount45",
		"", // "Lecture/Calcul 4-5 ans"
		AD_ENTRY2s("intro_ap.stk", "8f9dcb2fe953b1e031563307eae19a77", 40835810,
				   "appli_01.vmd", "d5f26306952d2ffbbadbb2b7d6cb3299", 41806),
		FR_CAN,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount45",
		"", // "Lesen/Rechnen 4-5 Jahre"
		AD_ENTRY2s("intro_ap.stk", "66a4ac911433c85b13811e874b5ceebd", 40946386,
				   "appli_01.vmd",  "f4ec39fd93d405f7aea84bd31de48f67", 63226),
		DE_DEU,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount45",
		"", // "Leggere/Contare 4-5 anni"
		AD_ENTRY2s("intro_ap.stk", "8540e44b24fef8dac2bbcd1aff6e0d8f", 44815582,
				   "appli_01.vmd", "2eb5ed83c2b3408d2d7ff54f5bfdaf3a", 49228),
		IT_ITA,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount45",
		"", // "I can read/I can count 4-5 years"
		AD_ENTRY2s("intro_ap.stk", "5ac48f29e989fae9a3c600978e52f5cf", 41662238,
				   "appli_01.vmd", "3a596569b76c0180a7e1643c1c76d383", 56432),
		EN_GRB,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Add-ons : Read/Count 6-7 years --
{
	{
		"adibou2readcount67",
		"", // "Lecture/Calcul 6-7 ans"
		AD_ENTRY2s("intro_ap.stk", "0e91d0d693d5731353ad4738f4aa065c", 36540132,
				   "appli_03.vmd", "6bf95a48f366bdf8af3a198c7b723c77", 58858),
		FR_FRA,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount67",
		"", // "Lecture/Calcul 6-7 ans"
		AD_ENTRY2s("intro_ap.stk", "82ec211d2f0cb3430d8f1eb80c949f41", 36540108,
				   "appli_03.vmd", "2ec3177c0f1b4ef326cc663834003eb4", 38062),
		FR_CAN,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount67",
		"", // "Lesen/Rechnen 6-7 Jahre"
		AD_ENTRY2s("intro_ap.stk", "5b83051c6d123fe0c506fd1ee17a73da", 36132776,
				   "appli_03.vmd", "462cd55c0759c1bd097b379995342b24", 65454),
		DE_DEU,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2readcount67",
		"", // Yo leo/Yo calculo 2° primaria
		AD_ENTRY2s("intro_ap.stk", "8ccaddbb40a3142db80d4e84fb4df447", 36332224,
				   "appli_03.vmd", "a14a48e9f3cfba245857fc74e249befd", 65542),
		ES_ESP,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Add-ons : "Nature & Sciences" --
{
	{
		"adibou2sciences",
		"", // "Je découvre la nature et les sciences"
		AD_ENTRY3s("intro_ap.stk", "bff25481fc05bc5c6a3aaa8c17e89e5b", 3446050,
				   "FICHES.ITK", "1670cc3373df162aed3219368665a1ca", 51025920,
				   "APPBOFR1.ITK", "b5354d97e1115ad337de55410dae82f7", 129994752),
		FR_FRA,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2sciences",
		"", // "Je découvre la nature et les sciences"
		AD_ENTRY3s("intro_ap.stk", "bff25481fc05bc5c6a3aaa8c17e89e5b", 3446050,
				   "FICHES.ITK", "1670cc3373df162aed3219368665a1ca", 51025920,
				   "APPBOFR1.ITK", "8bd95ce195278a29f0375ca2e2f3475d", 139196416),
		FR_CAN,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

{
	{
		"adibou2sciences",
		"", // "Discover Nature, Animals & Planets"
		AD_ENTRY2s("intro_ap.stk", "b630020cb8b6bc6f4b98876647ad418d", 3460620,
				   "FICHES.ITK", "2a704840f883b908f444f5215ab05e72", 52092928),
		EN_GRB,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2sciences",
		"", // "Natur & Technik"
		AD_ENTRY2s("intro_ap.stk", "404731e0108a43197ad408bda216a76e", 3162292,
				   "FICHES.ITK", "c301766d759d9ac8d7362558cc7a20c8", 51316736),
		DE_DEU,
		kPlatformWindows,
		ADGF_ADDON,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Add-ons : "Anglais" (English for non-native speakers) --
{
	{
		"adibou2anglais",
		"",
		AD_ENTRY2s("intro_ap.stk", "1c83832cfeeace2a4b1b9ca448fc5322", 1967132,
				   "LIPSYNC.ITK", "90ea1687c8d40989b5ff52c7ecaaf8b3", 107792384),
		FR_FRA,
		kPlatformWindows,
		ADGF_ADDON | ADGF_UNSTABLE,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Add-ons : Music --
{
	{
		"adibou2music",
		"",
		AD_ENTRY2s("intro_ap.stk", "2147748e04ac11bd7155779e1456be07", 1631068,
				   "MUZIKO.ITK", "101cd1690f13bf458e3988822a46e942", 54806528),
		FR_FRA,
		kPlatformWindows,
		ADGF_ADDON | ADGF_UNSTABLE,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2music",
		"",
		AD_ENTRY2s("intro_ap.stk", "0f3a372bb2e7d49ee430208a868f8605", 1629000,
				   "MUZIKO.ITK", "48e4576339b796f657a41d548abd97e1", 52834304),
		DE_DEU,
		kPlatformWindows,
		ADGF_ADDON | ADGF_UNSTABLE,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

// -- Demos --

{
	{
		"adibou2",
		"ADIBOU 2 Demo",
		AD_ENTRY1s("intro.stk", "0f197c6b8f1cef3fb4aa37438a52e031", 954276),
		FR_FRA,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},
{
	// Titlescreen says "ADIBOO: Limited version!", Sierra setup says "Adiboo 2 Demo"
	// Supplied by eientei95
	{
		"adibou2",
		"ADIBOO 2 Demo",
		AD_ENTRY1s("intro.stk", "ea6c2d25f33135db763c1175979d904a", 528108),
		EN_GRB,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demogb.scn", "9291455a908ac0e6aaaca686e532609b", 105,
				   "demogb.vmd", "bc9c1db97db7bec8f566332444fa0090", 14320840),
		EN_GRB,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 9
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demoall.scn", "c8fd308c037b829800006332b2c32674", 106,
				   "demoall.vmd", "4672b2deacc6fca97484840424b1921b", 14263433),
		DE_DEU,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 10
},
{
	{
		"adibou2",
		"Non-Interactive Demo",
		AD_ENTRY2s("demofra.scn", "d1b2b1618af384ea1120def8b986c02b", 106,
				   "demofra.vmd", "b494cdec1aac7e54c3f2480512d2880e", 14297100),
		FR_FRA,
		kPlatformWindows,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 11
},
{ // Shipped as an Demo / Preview for Nature et Sciences on Adibou presente Dessin CD
  // Supplied by BJNFNE
	{
		"adibou2",
		"Nature et Sciences Preview",
		AD_ENTRY1s("intro.stk", "22b997d97eef71c867b49092bd89c2b8", 38128),
		FR_FRA,
		kPlatformWindows,
		ADGF_UNSTABLE | ADGF_DEMO,
		GUIO0()
	},
	kFeatures640x480,
	0, 0, 0
},

#endif // GOB_DETECTION_TABLES_ADIBOU2_H
