# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddOrUpdateTextBlocklistItemsOptions(_model_base.Model):
    """The request to add blocklistItems to a text blocklist.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_items: Array of blocklistItems to add. Required.
    :vartype blocklist_items: list[~azure.ai.contentsafety.models.TextBlocklistItem]
    """

    blocklist_items: List["_models.TextBlocklistItem"] = rest_field(name="blocklistItems")
    """Array of blocklistItems to add. Required."""

    @overload
    def __init__(
        self,
        *,
        blocklist_items: List["_models.TextBlocklistItem"],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AddOrUpdateTextBlocklistItemsResult(_model_base.Model):
    """The response of adding blocklistItems to the text blocklist.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_items: Array of blocklistItems have been added. Required.
    :vartype blocklist_items: list[~azure.ai.contentsafety.models.TextBlocklistItem]
    """

    blocklist_items: List["_models.TextBlocklistItem"] = rest_field(name="blocklistItems")
    """Array of blocklistItems have been added. Required."""

    @overload
    def __init__(
        self,
        *,
        blocklist_items: List["_models.TextBlocklistItem"],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AnalyzeImageOptions(_model_base.Model):
    """The image analysis request.

    All required parameters must be populated in order to send to server.

    :ivar image: The image needs to be analyzed. Required.
    :vartype image: ~azure.ai.contentsafety.models.ImageData
    :ivar categories: The categories will be analyzed. If they are not assigned, a default set of
     analysis results for the categories will be returned.
    :vartype categories: list[str or ~azure.ai.contentsafety.models.ImageCategory]
    :ivar output_type: This refers to the type of image analysis output. If no value is assigned,
     the default value will be "FourSeverityLevels". "FourSeverityLevels"
    :vartype output_type: str or ~azure.ai.contentsafety.models.AnalyzeImageOutputType
    """

    image: "_models.ImageData" = rest_field()
    """The image needs to be analyzed. Required."""
    categories: Optional[List[Union[str, "_models.ImageCategory"]]] = rest_field()
    """The categories will be analyzed. If they are not assigned, a default set of analysis results
     for the categories will be returned."""
    output_type: Optional[Union[str, "_models.AnalyzeImageOutputType"]] = rest_field(name="outputType")
    """This refers to the type of image analysis output. If no value is assigned, the default value
     will be \"FourSeverityLevels\". \"FourSeverityLevels\""""

    @overload
    def __init__(
        self,
        *,
        image: "_models.ImageData",
        categories: Optional[List[Union[str, "_models.ImageCategory"]]] = None,
        output_type: Optional[Union[str, "_models.AnalyzeImageOutputType"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AnalyzeImageResult(_model_base.Model):
    """The image analysis response.

    All required parameters must be populated in order to send to server.

    :ivar categories_analysis: Analysis result for categories. Required.
    :vartype categories_analysis: list[~azure.ai.contentsafety.models.ImageCategoriesAnalysis]
    """

    categories_analysis: List["_models.ImageCategoriesAnalysis"] = rest_field(name="categoriesAnalysis")
    """Analysis result for categories. Required."""

    @overload
    def __init__(
        self,
        *,
        categories_analysis: List["_models.ImageCategoriesAnalysis"],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AnalyzeTextOptions(_model_base.Model):
    """The text analysis request.

    All required parameters must be populated in order to send to server.

    :ivar text: The text needs to be analyzed. We support a maximum of 10k Unicode characters
     (Unicode code points) in the text of one request. Required.
    :vartype text: str
    :ivar categories: The categories will be analyzed. If they are not assigned, a default set of
     analysis results for the categories will be returned.
    :vartype categories: list[str or ~azure.ai.contentsafety.models.TextCategory]
    :ivar blocklist_names: The names of blocklists.
    :vartype blocklist_names: list[str]
    :ivar halt_on_blocklist_hit: When set to true, further analyses of harmful content will not be
     performed in cases where blocklists are hit. When set to false, all analyses of harmful content
     will be performed, whether or not blocklists are hit.
    :vartype halt_on_blocklist_hit: bool
    :ivar output_type: This refers to the type of text analysis output. If no value is assigned,
     the default value will be "FourSeverityLevels". Known values are: "FourSeverityLevels" and
     "EightSeverityLevels".
    :vartype output_type: str or ~azure.ai.contentsafety.models.AnalyzeTextOutputType
    """

    text: str = rest_field()
    """The text needs to be analyzed. We support a maximum of 10k Unicode characters (Unicode code
     points) in the text of one request. Required."""
    categories: Optional[List[Union[str, "_models.TextCategory"]]] = rest_field()
    """The categories will be analyzed. If they are not assigned, a default set of analysis results
     for the categories will be returned."""
    blocklist_names: Optional[List[str]] = rest_field(name="blocklistNames")
    """The names of blocklists."""
    halt_on_blocklist_hit: Optional[bool] = rest_field(name="haltOnBlocklistHit")
    """When set to true, further analyses of harmful content will not be performed in cases where
     blocklists are hit. When set to false, all analyses of harmful content will be performed,
     whether or not blocklists are hit."""
    output_type: Optional[Union[str, "_models.AnalyzeTextOutputType"]] = rest_field(name="outputType")
    """This refers to the type of text analysis output. If no value is assigned, the default value
     will be \"FourSeverityLevels\". Known values are: \"FourSeverityLevels\" and
     \"EightSeverityLevels\"."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        categories: Optional[List[Union[str, "_models.TextCategory"]]] = None,
        blocklist_names: Optional[List[str]] = None,
        halt_on_blocklist_hit: Optional[bool] = None,
        output_type: Optional[Union[str, "_models.AnalyzeTextOutputType"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AnalyzeTextResult(_model_base.Model):
    """The text analysis response.

    All required parameters must be populated in order to send to server.

    :ivar blocklists_match: The blocklist match details.
    :vartype blocklists_match: list[~azure.ai.contentsafety.models.TextBlocklistMatch]
    :ivar categories_analysis: Analysis result for categories. Required.
    :vartype categories_analysis: list[~azure.ai.contentsafety.models.TextCategoriesAnalysis]
    """

    blocklists_match: Optional[List["_models.TextBlocklistMatch"]] = rest_field(name="blocklistsMatch")
    """The blocklist match details."""
    categories_analysis: List["_models.TextCategoriesAnalysis"] = rest_field(name="categoriesAnalysis")
    """Analysis result for categories. Required."""

    @overload
    def __init__(
        self,
        *,
        categories_analysis: List["_models.TextCategoriesAnalysis"],
        blocklists_match: Optional[List["_models.TextBlocklistMatch"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImageCategoriesAnalysis(_model_base.Model):
    """Image analysis result.

    All required parameters must be populated in order to send to server.

    :ivar category: The image analysis category. Required. Known values are: "Hate", "SelfHarm",
     "Sexual", and "Violence".
    :vartype category: str or ~azure.ai.contentsafety.models.ImageCategory
    :ivar severity: The value increases with the severity of the input content. The value of this
     field is determined by the output type specified in the request. The output type could be
     ‘FourSeverityLevels’, and the output value can be 0, 2, 4, 6.
    :vartype severity: int
    """

    category: Union[str, "_models.ImageCategory"] = rest_field()
    """The image analysis category. Required. Known values are: \"Hate\", \"SelfHarm\", \"Sexual\",
     and \"Violence\"."""
    severity: Optional[int] = rest_field()
    """The value increases with the severity of the input content. The value of this field is
     determined by the output type specified in the request. The output type could be
     ‘FourSeverityLevels’, and the output value can be 0, 2, 4, 6."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.ImageCategory"],
        severity: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImageData(_model_base.Model):
    """The image can be either base64 encoded bytes or a blob URL. You can choose only one of these
    options. If both are provided, the request will be refused. The maximum image size is 2048 x
    2048 pixels and should not exceed 4 MB, while the minimum image size is 50 x 50 pixels.

    :ivar content: The Base64 encoding of the image.
    :vartype content: bytes
    :ivar blob_url: The blob url of the image.
    :vartype blob_url: str
    """

    content: Optional[bytes] = rest_field(format="base64")
    """The Base64 encoding of the image."""
    blob_url: Optional[str] = rest_field(name="blobUrl")
    """The blob url of the image."""

    @overload
    def __init__(
        self,
        *,
        content: Optional[bytes] = None,
        blob_url: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RemoveTextBlocklistItemsOptions(_model_base.Model):
    """The request to remove blocklistItems from a text blocklist.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_item_ids: Array of blocklistItemIds to remove. Required.
    :vartype blocklist_item_ids: list[str]
    """

    blocklist_item_ids: List[str] = rest_field(name="blocklistItemIds")
    """Array of blocklistItemIds to remove. Required."""

    @overload
    def __init__(
        self,
        *,
        blocklist_item_ids: List[str],
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TextBlocklist(_model_base.Model):
    """Text Blocklist.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_name: Text blocklist name. Required.
    :vartype blocklist_name: str
    :ivar description: Text blocklist description.
    :vartype description: str
    """

    blocklist_name: str = rest_field(name="blocklistName", visibility=["read", "create", "query"])
    """Text blocklist name. Required."""
    description: Optional[str] = rest_field()
    """Text blocklist description."""

    @overload
    def __init__(
        self,
        *,
        blocklist_name: str,
        description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TextBlocklistItem(_model_base.Model):
    """Item in a TextBlocklist.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_item_id: The service will generate a BlocklistItemId, which will be a UUID.
     Required.
    :vartype blocklist_item_id: str
    :ivar description: BlocklistItem description.
    :vartype description: str
    :ivar text: BlocklistItem content. Required.
    :vartype text: str
    """

    blocklist_item_id: str = rest_field(name="blocklistItemId", visibility=["read"])
    """The service will generate a BlocklistItemId, which will be a UUID. Required."""
    description: Optional[str] = rest_field()
    """BlocklistItem description."""
    text: str = rest_field()
    """BlocklistItem content. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TextBlocklistMatch(_model_base.Model):
    """The result of blocklist match.

    All required parameters must be populated in order to send to server.

    :ivar blocklist_name: The name of the matched blocklist. Required.
    :vartype blocklist_name: str
    :ivar blocklist_item_id: The ID of the matched item. Required.
    :vartype blocklist_item_id: str
    :ivar blocklist_item_text: The content of the matched item. Required.
    :vartype blocklist_item_text: str
    """

    blocklist_name: str = rest_field(name="blocklistName")
    """The name of the matched blocklist. Required."""
    blocklist_item_id: str = rest_field(name="blocklistItemId")
    """The ID of the matched item. Required."""
    blocklist_item_text: str = rest_field(name="blocklistItemText")
    """The content of the matched item. Required."""

    @overload
    def __init__(
        self,
        *,
        blocklist_name: str,
        blocklist_item_id: str,
        blocklist_item_text: str,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TextCategoriesAnalysis(_model_base.Model):
    """Text analysis result.

    All required parameters must be populated in order to send to server.

    :ivar category: The text analysis category. Required. Known values are: "Hate", "SelfHarm",
     "Sexual", and "Violence".
    :vartype category: str or ~azure.ai.contentsafety.models.TextCategory
    :ivar severity: The value increases with the severity of the input content. The value of this
     field is determined by the output type specified in the request. The output type could be
     ‘FourSeverityLevels’ or ‘EightSeverity Levels’, and the output value can be 0, 2, 4, 6 or 0, 1,
     2, 3, 4, 5, 6, or 7.
    :vartype severity: int
    """

    category: Union[str, "_models.TextCategory"] = rest_field()
    """The text analysis category. Required. Known values are: \"Hate\", \"SelfHarm\", \"Sexual\", and
     \"Violence\"."""
    severity: Optional[int] = rest_field()
    """The value increases with the severity of the input content. The value of this field is
     determined by the output type specified in the request. The output type could be
     ‘FourSeverityLevels’ or ‘EightSeverity Levels’, and the output value can be 0, 2, 4, 6 or 0, 1,
     2, 3, 4, 5, 6, or 7."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.TextCategory"],
        severity: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
