# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class HealthStateCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StandbyPool health state."""

    HEALTHY = "HealthState/healthy"
    """StandbyPool is in healthy state."""
    DEGRADED = "HealthState/degraded"
    """StandbyPool is in degraded state."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PoolContainerGroupState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the pooled container groups."""

    RUNNING = "Running"
    """The container group is up and running."""
    CREATING = "Creating"
    """The container group is creating."""
    DELETING = "Deleting"
    """The container group is deleting."""


class PoolVirtualMachineState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the pooled virtual machines."""

    RUNNING = "Running"
    """The virtual machine is up and running."""
    CREATING = "Creating"
    """The virtual machine is creating."""
    STARTING = "Starting"
    """The virtual machine is starting."""
    DELETING = "Deleting"
    """The virtual machine is deleting."""
    DEALLOCATED = "Deallocated"
    """The virtual machine has released the lease on the underlying hardware and is powered off."""
    DEALLOCATING = "Deallocating"
    """The virtual machine is releasing the lease on the underlying hardware and is powered off."""
    HIBERNATED = "Hibernated"
    """The virtual machine has released the lease on the underlying hardware and is powered off.
    Memory contents of the VM are stored in the OS disk. When started again, applications and
    processes that were previously running in your VM resume from the state prior to hibernation."""
    HIBERNATING = "Hibernating"
    """The virtual machine is hibernating."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    DELETING = "Deleting"
    """Resource is being deleted."""


class RefillPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refill policy of standby pool."""

    ALWAYS = "always"
    """A refill policy that standby pool is automatically refilled to maintain maxReadyCapacity."""


class VirtualMachineState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of standby virtual machines."""

    RUNNING = "Running"
    """The virtual machine is up and running."""
    DEALLOCATED = "Deallocated"
    """The virtual machine has released the lease on the underlying hardware and is powered off."""
    HIBERNATED = "Hibernated"
    """The virtual machine has released the lease on the underlying hardware and is powered off.
    Memory contents of the VM are stored in the OS disk.  When started again, applications and
    processes that were previously running in your VM resume from the state prior to hibernation."""
