/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QApplication>
#include <QSplashScreen>
#include <QtQml>


/////////////////////// pappsomspp includes
#include <pappsomspp/core/processing/combiners/mzintegrationparams.h>

/////////////////////// Local includes


namespace MsXpS
{

namespace MineXpert
{

class ProgramWindow;

class Application: public QApplication
{
  Q_OBJECT

  ////////////////////////////// public //////////////////////////// /
  ////////////////////////////// public //////////////////////////////

  public:
  Application(int &argc, char **argv, const QString &moduleName);
  ~Application();

  Q_PROPERTY(
    QString m_description READ description WRITE setDescription USER true)
  QString m_description = QString(
    "MineXpert3: a program to view and analyze mass spectrometric data");

  void setProgramWindow(ProgramWindow *program_window_p);

  public slots:
  void setDescription(QString &desc);
  QString description();

  void destroySplash();

  QString getUserConfigSettingsDirPath();
  QString getUserConfigSettingsFilePath();

  // These settings are crucial throughout the whole program as they allow
  // storing the way bins are created when combining spectra. These config bits
  // are pretty stable because they depend on the mass spectrometer used to
  // acquire the data and, often, one works on lots of data from the same
  // instrument, so these config bits do not change. Store them to allow
  // for defaults.
  void saveMzIntegrationParamsToSettings(
    const pappso::MzIntegrationParams &mz_integration_params);
  void eraseMzIntegrationParamsFromSettings();
  pappso::MzIntegrationParams::InitializationResult
  getMzIntegrationParamsFromSavedSettings(
    pappso::MzIntegrationParams &mz_integration_params);

  // FIXME Should centralize here all the functions that read and set these
  // MzIntegrationParams.


  ////////////////////////////// Scripting HUB /////////////////////////////
  ////////////////////////////// Scripting HUB /////////////////////////////
  bool publishQObject(
    QObject *object,
    QObject *parent,
    QJSValue &js_value,
    const QString &name,
    const QString &alias                 = QString(),
    const QString &comment               = QString(),
    const QString &help                  = QString(),
    const QString &tool_tip              = QString(),
    const QColor &color                  = Qt::black,
    QJSEngine::ObjectOwnership ownership = QJSEngine::CppOwnership);


  ////////////////////////////// private //////////////////////////// /
  ////////////////////////////// private //////////////////////////////

  private:
  QString m_applicationName       = "Minexpert3";
  ProgramWindow *mp_programWindow = nullptr;

  // The splash screen, that we'll remove automatically after
  // 2 seconds.
  QSplashScreen *mpa_splash;
  QString m_userConfigSettingsDirPath;
  QString m_userConfigSettingsFilePath;
};

} // namespace MineXpert

} // namespace MsXpS
