//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azcertificates

// CertificatePolicyAction - The type of the action.
type CertificatePolicyAction string

const (
	CertificatePolicyActionAutoRenew     CertificatePolicyAction = "AutoRenew"
	CertificatePolicyActionEmailContacts CertificatePolicyAction = "EmailContacts"
)

// PossibleCertificatePolicyActionValues returns the possible values for the CertificatePolicyAction const type.
func PossibleCertificatePolicyActionValues() []CertificatePolicyAction {
	return []CertificatePolicyAction{
		CertificatePolicyActionAutoRenew,
		CertificatePolicyActionEmailContacts,
	}
}

// CurveName - Elliptic curve name.
type CurveName string

const (
	CurveNameP256  CurveName = "P-256"
	CurveNameP256K CurveName = "P-256K"
	CurveNameP384  CurveName = "P-384"
	CurveNameP521  CurveName = "P-521"
)

// PossibleCurveNameValues returns the possible values for the CurveName const type.
func PossibleCurveNameValues() []CurveName {
	return []CurveName{
		CurveNameP256,
		CurveNameP256K,
		CurveNameP384,
		CurveNameP521,
	}
}

// KeyType - The type of key pair to be used for the certificate.
type KeyType string

const (
	KeyTypeEC     KeyType = "EC"
	KeyTypeECHSM  KeyType = "EC-HSM"
	KeyTypeOct    KeyType = "oct"
	KeyTypeOctHSM KeyType = "oct-HSM"
	KeyTypeRSA    KeyType = "RSA"
	KeyTypeRSAHSM KeyType = "RSA-HSM"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypeEC,
		KeyTypeECHSM,
		KeyTypeOct,
		KeyTypeOctHSM,
		KeyTypeRSA,
		KeyTypeRSAHSM,
	}
}

// KeyUsageType - Defines how the certificate's key may be used.
type KeyUsageType string

const (
	KeyUsageTypeCRLSign          KeyUsageType = "cRLSign"
	KeyUsageTypeDataEncipherment KeyUsageType = "dataEncipherment"
	KeyUsageTypeDecipherOnly     KeyUsageType = "decipherOnly"
	KeyUsageTypeDigitalSignature KeyUsageType = "digitalSignature"
	KeyUsageTypeEncipherOnly     KeyUsageType = "encipherOnly"
	KeyUsageTypeKeyAgreement     KeyUsageType = "keyAgreement"
	KeyUsageTypeKeyCertSign      KeyUsageType = "keyCertSign"
	KeyUsageTypeKeyEncipherment  KeyUsageType = "keyEncipherment"
	KeyUsageTypeNonRepudiation   KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns the possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{
		KeyUsageTypeCRLSign,
		KeyUsageTypeDataEncipherment,
		KeyUsageTypeDecipherOnly,
		KeyUsageTypeDigitalSignature,
		KeyUsageTypeEncipherOnly,
		KeyUsageTypeKeyAgreement,
		KeyUsageTypeKeyCertSign,
		KeyUsageTypeKeyEncipherment,
		KeyUsageTypeNonRepudiation,
	}
}
