//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// APICollectionOnboardingServer is a fake server for instances of the armsecurity.APICollectionOnboardingClient type.
type APICollectionOnboardingServer struct {
	// Create is the fake for method APICollectionOnboardingClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, serviceName string, apiCollectionID string, options *armsecurity.APICollectionOnboardingClientCreateOptions) (resp azfake.Responder[armsecurity.APICollectionOnboardingClientCreateResponse], errResp azfake.ErrorResponder)
}

// NewAPICollectionOnboardingServerTransport creates a new instance of APICollectionOnboardingServerTransport with the provided implementation.
// The returned APICollectionOnboardingServerTransport instance is connected to an instance of armsecurity.APICollectionOnboardingClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAPICollectionOnboardingServerTransport(srv *APICollectionOnboardingServer) *APICollectionOnboardingServerTransport {
	return &APICollectionOnboardingServerTransport{srv: srv}
}

// APICollectionOnboardingServerTransport connects instances of armsecurity.APICollectionOnboardingClient to instances of APICollectionOnboardingServer.
// Don't use this type directly, use NewAPICollectionOnboardingServerTransport instead.
type APICollectionOnboardingServerTransport struct {
	srv *APICollectionOnboardingServer
}

// Do implements the policy.Transporter interface for APICollectionOnboardingServerTransport.
func (a *APICollectionOnboardingServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "APICollectionOnboardingClient.Create":
		resp, err = a.dispatchCreate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *APICollectionOnboardingServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if a.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/apiCollections/(?P<apiCollectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	apiCollectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("apiCollectionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Create(req.Context(), resourceGroupNameParam, serviceNameParam, apiCollectionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APICollectionResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
