//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armreservations

import "encoding/json"

// AzureReservationAPIClientGetAppliedReservationListResponse contains the response from method AzureReservationAPIClient.GetAppliedReservationList.
type AzureReservationAPIClientGetAppliedReservationListResponse struct {
	// The response for applied reservations api
	AppliedReservations
}

// AzureReservationAPIClientGetCatalogResponse contains the response from method AzureReservationAPIClient.NewGetCatalogPager.
type AzureReservationAPIClientGetCatalogResponse struct {
	// The list of catalogs and pagination information.
	CatalogsResult
}

// CalculateExchangeClientPostResponse contains the response from method CalculateExchangeClient.BeginPost.
type CalculateExchangeClientPostResponse struct {
	// CalculateExchange operation result
	CalculateExchangeOperationResultResponse
}

// CalculateRefundClientPostResponse contains the response from method CalculateRefundClient.Post.
type CalculateRefundClientPostResponse struct {
	// The response of calculate refund containing refund information of reservation
	CalculateRefundResponse
}

// ExchangeClientPostResponse contains the response from method ExchangeClient.BeginPost.
type ExchangeClientPostResponse struct {
	// Exchange operation result
	ExchangeOperationResultResponse
}

// OperationClientListResponse contains the response from method OperationClient.NewListPager.
type OperationClientListResponse struct {
	// Paginated list of operations
	OperationList
}

// QuotaClientCreateOrUpdateResponse contains the response from method QuotaClient.BeginCreateOrUpdate.
type QuotaClientCreateOrUpdateResponse struct {
	// Quota properties.
	CurrentQuotaLimitBase
}

// QuotaClientGetResponse contains the response from method QuotaClient.Get.
type QuotaClientGetResponse struct {
	// Quota properties.
	CurrentQuotaLimitBase

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// QuotaClientListResponse contains the response from method QuotaClient.NewListPager.
type QuotaClientListResponse struct {
	// Quota limits.
	QuotaLimits

	// ETag contains the information returned from the ETag header response.
	ETag *string
}

// QuotaClientUpdateResponse contains the response from method QuotaClient.BeginUpdate.
type QuotaClientUpdateResponse struct {
	// Quota properties.
	CurrentQuotaLimitBase
}

// QuotaRequestStatusClientGetResponse contains the response from method QuotaRequestStatusClient.Get.
type QuotaRequestStatusClientGetResponse struct {
	// Quota request details.
	QuotaRequestDetails
}

// QuotaRequestStatusClientListResponse contains the response from method QuotaRequestStatusClient.NewListPager.
type QuotaRequestStatusClientListResponse struct {
	// Quota request details.
	QuotaRequestDetailsList
}

// ReservationClientArchiveResponse contains the response from method ReservationClient.Archive.
type ReservationClientArchiveResponse struct {
	// placeholder for future response values
}

// ReservationClientAvailableScopesResponse contains the response from method ReservationClient.BeginAvailableScopes.
type ReservationClientAvailableScopesResponse struct {
	// The response of available scope api containing scopes and their eligibilities.
	AvailableScopeProperties
}

// ReservationClientGetResponse contains the response from method ReservationClient.Get.
type ReservationClientGetResponse struct {
	// The definition of the reservation.
	ReservationResponse
}

// ReservationClientListAllResponse contains the response from method ReservationClient.NewListAllPager.
type ReservationClientListAllResponse struct {
	// The list of reservations and summary of roll out count of reservations in each state.
	ListResult
}

// ReservationClientListResponse contains the response from method ReservationClient.NewListPager.
type ReservationClientListResponse struct {
	// List of `Reservation`s
	ReservationList
}

// ReservationClientListRevisionsResponse contains the response from method ReservationClient.NewListRevisionsPager.
type ReservationClientListRevisionsResponse struct {
	// List of `Reservation`s
	ReservationList
}

// ReservationClientMergeResponse contains the response from method ReservationClient.BeginMerge.
type ReservationClientMergeResponse struct {
	// Array of ReservationResponse
	ReservationResponseArray []*ReservationResponse
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationClientMergeResponse.
func (r *ReservationClientMergeResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &r.ReservationResponseArray)
}

// ReservationClientSplitResponse contains the response from method ReservationClient.BeginSplit.
type ReservationClientSplitResponse struct {
	// Array of ReservationResponse
	ReservationResponseArray []*ReservationResponse
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationClientSplitResponse.
func (r *ReservationClientSplitResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &r.ReservationResponseArray)
}

// ReservationClientUnarchiveResponse contains the response from method ReservationClient.Unarchive.
type ReservationClientUnarchiveResponse struct {
	// placeholder for future response values
}

// ReservationClientUpdateResponse contains the response from method ReservationClient.BeginUpdate.
type ReservationClientUpdateResponse struct {
	// The definition of the reservation.
	ReservationResponse
}

// ReservationOrderClientCalculateResponse contains the response from method ReservationOrderClient.Calculate.
type ReservationOrderClientCalculateResponse struct {
	// The response of calculate price for reservation.
	CalculatePriceResponse
}

// ReservationOrderClientChangeDirectoryResponse contains the response from method ReservationOrderClient.ChangeDirectory.
type ReservationOrderClientChangeDirectoryResponse struct {
	// Change directory response
	ChangeDirectoryResponse
}

// ReservationOrderClientGetResponse contains the response from method ReservationOrderClient.Get.
type ReservationOrderClientGetResponse struct {
	// Details of a reservation order being returned.
	ReservationOrderResponse
}

// ReservationOrderClientListResponse contains the response from method ReservationOrderClient.NewListPager.
type ReservationOrderClientListResponse struct {
	// List of `ReservationOrder`s
	ReservationOrderList
}

// ReservationOrderClientPurchaseResponse contains the response from method ReservationOrderClient.BeginPurchase.
type ReservationOrderClientPurchaseResponse struct {
	// Details of a reservation order being returned.
	ReservationOrderResponse
}

// ReturnClientPostResponse contains the response from method ReturnClient.BeginPost.
type ReturnClientPostResponse struct {
	// Details of a reservation order being returned.
	ReservationOrderResponse
}
